// This is brl/bseg/sdet/tests/test_region_proc.cxx
#include <vcl_vector.h>
#include <vcl_string.h>
#include <vcl_iostream.h>
#include <vil1/vil1_image.h>
#include <vil1/vil1_load.h>
#include <vtol/vtol_intensity_face.h>
#include <sdet/sdet_region_proc_params.h>
#include <sdet/sdet_region_proc.h>
#include <sdet/sdet_detector_params.h>
#include <sdet/sdet_detector.h>
#include <testlib/testlib_test.h>

static void test_region_proc(int argc, char * argv[])
{
  vcl_string image_path = (argc < 2) ? "jar-closeup.tif" : argv[1];
  vcl_cout << "Loading Image " << image_path << '\n';
  vil1_image image = vil1_load(image_path.c_str());
  if (image)
  {
    static sdet_detector_params dp;
    dp.noise_multiplier=1.0f;
    dp.aggressive_junction_closure=1;
    sdet_region_proc_params rpp(dp);
    sdet_region_proc rp(rpp);
    rp.set_image(image);
    rp.extract_regions();
    vcl_vector<vtol_intensity_face_sptr>& regions = rp.get_regions();
    int n = regions.size();
    TEST_NEAR("nregions", n, 190, 5);
    if (n>0)
    {
      vtol_intensity_face_sptr f = regions[0];
      TEST_NEAR("size of first region", f->Npix(), 41100, 50);
    }
  }
}

TESTMAIN_ARGS(test_region_proc);
