/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.util;

import java.io.PrintStream;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SAXErrorHandler
implements ErrorHandler {
    private PrintStream output;

    public SAXErrorHandler() {
        this.output = System.out;
    }

    public SAXErrorHandler(PrintStream printStream) {
        this.output = printStream == null ? System.out : printStream;
    }

    private String getParseExceptionInfo(SAXParseException sAXParseException) {
        String string = sAXParseException.getSystemId();
        if (string == null) {
            string = "null";
        }
        String string2 = "URI=" + string + " Line=" + sAXParseException.getLineNumber() + ": " + sAXParseException.getMessage();
        return string2;
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        System.out.println("Warning: " + this.getParseExceptionInfo(sAXParseException));
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        String string = "Error: " + this.getParseExceptionInfo(sAXParseException);
        throw new SAXException(string);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        String string = "Fatal Error: " + this.getParseExceptionInfo(sAXParseException);
        throw new SAXException(string);
    }
}

