/***************************************************************************
                 dcguiutils.h  -  Valknut Utility Functions
                             -------------------
    begin                : Thu Jul 3 2008
    copyright            : (C) 2008 by Edward Sheldrake
    email                : ejs1920@yahoo.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCGUIUTILS_H
#define DCGUIUTILS_H

/**
 * @author Edward Sheldrake
 *
 * This just cleans up a little copied and pasted code, and
 * wraps dclib's CUtils::GetSizeString because we usually want
 * the result as a QString and always use the unit from the config
 * settings.
 */

#include <qnamespace.h>
#include <QString>
#include <QList>

// for ulonglong
#include <dclib/dcos.h>

class QComboBox;
class Q3ListView;
class Q3ListViewItem;
class QTreeView;

class DCGuiUtils {

public:
	/** constructor - does nothing */
	DCGuiUtils();
	/** destructor - does nothing */
	~DCGuiUtils();
	
	/** Gets the size with units B to TiB from config settings */
	static QString GetSizeString( const ulonglong size );
	/** Adds the list of encodings to the combo box */
	static void AddEncodings( QComboBox * combobox );
	/** Returns "Ascending" or "Descending" as a string */
	static QString SortOrderName( const Qt::SortOrder order );
	/**
	 * Returns Qt::DescendingOrder for "Descending" and Qt::AscendingOrder
	 * for anything else.
	 */
	static Qt::SortOrder SortOrderFromName( const QString name );
	/**
	 * This resizes all the columns in the list view preserving the
	 * current ratio of column widths.
	 */
	static void AdjustColumnWidths( Q3ListView * view, int oldsize );
	/**
	 * This resizes all the columns in the tree view preserving the
	 * current ratio of column widths.
	 */
	static void AdjustColumnWidths( QTreeView * view, int oldsize );
	/**
	 * Adds all selected items to the list.
	 * Returns the number of items in the list.
	 */
	static int SelectedItems( Q3ListView * view, QList<Q3ListViewItem*> & list );
	/**
	 * Detects the style factory key for the current style of the QApplication.
	 * Involves creating QStyle objects until a match is found.
	 */
	static QString DetectAppStyleKey();
};

#endif // DCGUIUTILS_H
