#ifndef INCLUDED_TEXTS_H
#define INCLUDED_TEXTS_H
/* vim: set ts=8 sts=4 sw=4 tw=80 noet: */
/*======================================================================
Copyright (C) 2004,2005,2009,2013 Walter Doekes <walter+tthsum@wjd.nu>
This file is part of tthsum.

tthsum is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

tthsum is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with tthsum.  If not, see <http://www.gnu.org/licenses/>.
======================================================================*/

/**
 * Help and error texts for the tthsum application and the units that
 * tthsum consists of. Using texts is entirely optional: unless you
 * define USE_TEXTS, no tthsum unit will try to call any of these
 * functions.
 */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/**
 * The texts by id. If messages are to be translated, only the texts unit will
 * have to be modified.
 */
enum text_id {
    ERROR_FROM_OS = -1,
    ERROR_FIRST = 0,
    BASE32_INVALID_CHARACTER,
    ESCAPE_INVALID_ESCAPE,
    TEXTS_UNKNOWN_ERROR,
    THEX_INVALID_BLOCK_SIZE,
    TTHSUM_FILENAME_TOO_LARGE,
    TTHSUM_LINE_CORRUPT,
    TTHSUM_MISMATCHED_TTH,
    UTF8_INVALID_UNICODE,
    UTF8_INVALID_UTF8,
    UTF8_OVERLONG_UTF8,
    ERROR_LAST
};

/**
 * Set the last error: context is a short string specifying which function
 * caused the error, error defines what the error was. Specify the error by
 * text_id or ERROR_FROM_OS if you want to get the native OS-error message
 * (from a library call).
 */
void set_error(const char* context, int error);

/**
 * Get the set error as a descriptive message including the context.
 */
const char* get_error();

/**
 * Get a specific text.
 */
const char* get_text(enum text_id id);

#ifdef __cplusplus
} /* extern "C" */
#endif /* __cplusplus */

#endif /* INCLUDED_TEXTS_H */
