package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteSiteMonitors invokes the cms.DeleteSiteMonitors API synchronously
func (client *Client) DeleteSiteMonitors(request *DeleteSiteMonitorsRequest) (response *DeleteSiteMonitorsResponse, err error) {
	response = CreateDeleteSiteMonitorsResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteSiteMonitorsWithChan invokes the cms.DeleteSiteMonitors API asynchronously
func (client *Client) DeleteSiteMonitorsWithChan(request *DeleteSiteMonitorsRequest) (<-chan *DeleteSiteMonitorsResponse, <-chan error) {
	responseChan := make(chan *DeleteSiteMonitorsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteSiteMonitors(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteSiteMonitorsWithCallback invokes the cms.DeleteSiteMonitors API asynchronously
func (client *Client) DeleteSiteMonitorsWithCallback(request *DeleteSiteMonitorsRequest, callback func(response *DeleteSiteMonitorsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteSiteMonitorsResponse
		var err error
		defer close(result)
		response, err = client.DeleteSiteMonitors(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteSiteMonitorsRequest is the request struct for api DeleteSiteMonitors
type DeleteSiteMonitorsRequest struct {
	*requests.RpcRequest
	IsDeleteAlarms requests.Boolean `position:"Query" name:"IsDeleteAlarms"`
	TaskIds        string           `position:"Query" name:"TaskIds"`
}

// DeleteSiteMonitorsResponse is the response struct for api DeleteSiteMonitors
type DeleteSiteMonitorsResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   string `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDeleteSiteMonitorsRequest creates a request to invoke DeleteSiteMonitors API
func CreateDeleteSiteMonitorsRequest() (request *DeleteSiteMonitorsRequest) {
	request = &DeleteSiteMonitorsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "DeleteSiteMonitors", "Cms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteSiteMonitorsResponse creates a response to parse from DeleteSiteMonitors response
func CreateDeleteSiteMonitorsResponse() (response *DeleteSiteMonitorsResponse) {
	response = &DeleteSiteMonitorsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
