'\"
'\" Copyright (c) 2025 Jan Nijtmans.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
.TH build-info n 9.0 Tcl "Tcl Built-In Commands"
.so man.macros
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
buildinfo \- Build info
.SH SYNOPSIS
\fB::tcl::build-info\fR ?\fIfield\fR?
.BE
.SH DESCRIPTION
.PP
This command provides a way to retrieve information about how Tcl was built.
Without any options, the command returns the Tcl patchlevel, followed
by the '+'-sign, followed by the fossil commit-id followed by a list of
dot-separated tags. If a \fIfield\fR is given, this command extracts that
field as described below. Any other \fIfield\fR value not mentioned
below will always return "0". For official Tcl releases, the \fIfield\fRs are:
.\" METHOD: clang
.TP
\fB::tcl::build-info clang\fR
.
Returns the clang version number (as 4 digits) if Tcl is compiled with clang, 0 otherwise.
.\" METHOD: commit
.TP
\fB::tcl::build-info commit\fR
.
Returns the fossil commit-id where Tcl was built from.
.\" METHOD: compiledebug
.TP
\fB::tcl::build-info compiledebug\fR
.
Returns 1 if Tcl is compiled with \fB\-DTCL_COMPILE_DEBUG\fR, 0 otherwise.
.\" METHOD: compiler
.TP
\fB::tcl::build-info compiler\fR
.
Returns the compiler name (either clang, gcc, icc or msvc), followed by a dash and a (4-digit) version number.
.\" METHOD: compilestats
.TP
\fB::tcl::build-info compilestats\fR
.
Returns 1 if Tcl is compiled with \fB\-DTCL_COMPILE_STATS\fR, 0 otherwise.
.\" METHOD: cplusplus
.TP
\fB::tcl::build-info cplusplus\fR
.
Returns 1 if Tcl is compiled with a C++ compiler, 0 otherwise.
.\" METHOD: debug
.TP
\fB::tcl::build-info debug\fR
.
Returns 1 if Tcl is not compiled with \fB\-DNDEBUG\fR, 0 otherwise.
.\" METHOD: gcc
.TP
\fB::tcl::build-info gcc\fR
.
Returns the gcc version number (as 4 digits) if Tcl is compiled with gcc, 0 otherwise.
.\" METHOD: icc
.TP
\fB::tcl::build-info icc\fR
.
Returns the icc version number (as 4 digits) if Tcl is compiled with icc, 0 otherwise.
.\" METHOD: ilp32
.TP
\fB::tcl::build-info ilp32\fR
.
Returns 1 if Tcl is compiled such that integers, longs and pointers are all 32-bit, 0 otherwise.
.\" METHOD: memdebug
.TP
\fB::tcl::build-info memdebug\fR
.
Returns 1 if Tcl is compiled with \fB\-DTCL_MEM_DEBUG\fR, 0 otherwise.
.\" METHOD: msvc
.TP
\fB::tcl::build-info msvc\fR
.
Returns the msvc version number (as 4 digits) if Tcl is compiled with msvc, 0 otherwise.
.\" METHOD: nmake
.TP
\fB::tcl::build-info nmake\fR
.
Returns 1 if Tcl is built using nmake, 0 otherwise.
.\" METHOD: no-deprecate
.TP
\fB::tcl::build-info no-deprecate\fR
.
Returns 1 if Tcl is compiled with \fB\-DTCL_NO_DEPRECATED\fR, 0 otherwise.
.\" METHOD: no-thread
.TP
\fB::tcl::build-info no-thread\fR
.
Returns 1 if Tcl is compiled with \fB\-DTCL_THREADS=0\fR, 0 otherwise.
.\" METHOD: no-optimize
.TP
\fB::tcl::build-info no-optimize\fR
.
Returns 1 if Tcl is not compiled with \fB\-DTCL_CFG_OPTIMIZED\fR, 0 otherwise.
.\" METHOD: objective-c
.TP
\fB::tcl::build-info objective-c\fR
.
Returns 1 if Tcl is compiled with an objective-c compiler, 0 otherwise.
.\" METHOD: objective-cplusplus
.TP
\fB::tcl::build-info objective-cplusplus\fR
.
Returns 1 if Tcl is compiled with an objective-c++ compiler, 0 otherwise.
.\" METHOD: patchlevel
.TP
\fB::tcl::build-info patchlevel\fR
.
Returns the Tcl patchlevel, same as \fBinfo patchlevel\fR.
.\" METHOD: profile
.TP
\fB::tcl::build-info profile\fR
.
Returns 1 if Tcl is compiled with \fB\-DTCL_CFG_PROFILED\fR, 0 otherwise.
.\" METHOD: purify
.TP
\fB::tcl::build-info purify\fR
.
Returns 1 if Tcl is compiled with \fB\-DPURIFY\fR, 0 otherwise.
.\" METHOD: static
.TP
\fB::tcl::build-info static\fR
.
Returns 1 if Tcl is compiled as a static library, 0 otherwise.
.\" METHOD: tommath
.TP
\fB::tcl::build-info tommath\fR
.
Returns the libtommath version number (as 4 digits) if libtommath is built into Tcl, 0 otherwise.
.\" METHOD: version
.TP
\fB::tcl::build-info version\fR
.
Returns the Tcl version, same as \fBinfo tclversion\fR.
.\" METHOD: zlib
.TP
\fB::tcl::build-info zlib\fR
.
Returns the zlib version number (as 4 digits) if zlib is built into Tcl, 0 otherwise.
.SH "EXAMPLES"
.PP
These show the use of \fB::tcl::build-info\fR.
.PP
.CS
\fB::tcl::build-info\fR
     \fI\(-> 9.0.2+af16c07b81655fabde8028374161ad54b84ef9956843c63f49976b4ef601b611.gcc-1204\fR
\fB::tcl::build-info commit\fR
     \fI\(-> af16c07b81655fabde8028374161ad54b84ef9956843c63f49976b4ef601b611\fR
\fB::tcl::build-info compiler\fR
     \fI\(-> gcc-1204\fR
\fB::tcl::build-info gcc\fR
     \fI\(-> 1204\fR
\fB::tcl::build-info version\fR
     \fI\(-> 9.0\fR
\fB::tcl::build-info patchlevel\fR
     \fI\(-> 9.0.2\fR
.CE
.SH "SEE ALSO"
info(n)
.SH "KEYWORDS"
build-info
'\" Local Variables:
'\" mode: nroff
'\" End:
