/* ====================================================================
 * Copyright (c) 2003-2008  Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_SCMODEL_H
#define _SC_SCMODEL_H

// sc
#include "settings/ProjectSettings.h"
#include "settings/CommitLogHistory.h"
#include "sublib/DebugSettings.h"
#include "util/String.h"
class ConfigManager;
class FontSettings;
class LayoutSettings;
class CmdProgressCallback;
class ScCmd;
class ListCache;
class WcStatusCache;


namespace svn
{
  class Client;
}

// apr
struct apr_pool_t;


/**
 * Root model. The root model provides access to configuration info and
 * command execution.
 */
class ScModel
{
public:
  /** Create a root model with @a conf as @c ConfigMananger. */
  ScModel( ConfigManager* conf );
  ~ScModel();

  /// @name Projects
  // @{
  Project* createProject();
  void addProject( Project* project );
  void removeProject( Project* project );
  const Projects& getProjects();
  void reorderProjects( Project* src, Project* dst );
  void saveProject( Project* project );
  void saveProjects();
  // @}

  /// @name Commands
  // @
  void runThreaded( ScCmd* cmd );
  void runBlocked( ScCmd* cmd );

  /** Set the progress callback to @a cb. The model takes ownership of
   *  @a cb. */
  void setProgressCallback( CmdProgressCallback* cb );
  // @}

  /// @name Subversion
  // @{
  bool isWorkingCopy( const sc::String& path );
  // @}

  /// @name Command options
  // @{
  bool getOptionCommandRecurse();         // obsolete
  bool getOptionCommandForce();           // obsolete
  void setOptionCommandRecurse( bool b ); // obsolete
  void setOptionCommandForce( bool b );   // obsolete
  // @}

  /// @name Settings
  // @{
  void saveSettings();
  FontSettings* getFontSettings();
  LayoutSettings* getLayoutSettings();
  CommitLogHistory* getCommitLogHistory();
  // @}

  /// @name Caches
  // @{
  ListCache* getListCache();
  WcStatusCache* getStatusCache();
  // @}

protected:
  virtual void runAsync( ScCmd* cmd, CmdProgressCallback* pcb );
  virtual void runSync( ScCmd* cmd, CmdProgressCallback* pcb );

private:
  svn::Client* createSvnClient( unsigned long id ) const;
  svn::Client* createSvnClient( unsigned long id, CmdProgressCallback*
    cb ) const;

private:
  apr_pool_t*          _pool;

  ConfigManager*       _conf;        ///< configuration manager.
  Projects             _projects;    ///< the projects.

  CmdProgressCallback* _progress;

  ListCache*           _listCache;
  WcStatusCache*       _statusCache;
};

#endif // _SC_SCMODEL_H
