10.1 Usando atajos

# Usando atajos

Sonic Pi es tanto un instrumento como un ambiente de código. Los atajos
te hacen tocar Sonic Pi de una manera mucho más *eficiente y natural*.
Especialmente si tocas en frente de una audiencia en vivo.

Mucho de Sonic Pi puede ser controlado a través del teclado. Mientras
te familiarizas trabajando con Sonic Pi, probablemente usarás más y más
atajos. *personalmente soy del tipo toca-teclea* (lo que recomiendo aprender)
y me frustra el tener que ir al ratón, ya que me ralentiza. Por ello es que
utilizo estos atajos regularmente.

Por tanto, si te aprendes los atajos, utilizarás tu teclado de manera eficiente
y codificarás como un profesional en poco tiempo.

Sin embargo *no intentes aprender todo al mismo tiempo*, sólo intenta recordar
los que más utilizas y continua añadiendo otros a tú práctica.

## Consistencia a través de las plataformas

Imagina que estás aprendiendo el clarinete. Esperarás que todos los clarinetes
de cada constructor tenga controles y digitalizaciones similares. Si no fuese 
así, sería complicado cambiar de clarinetes y tendrías que usar sólo uno.

Desafortunadamente los tres principales sistemas operativos (Linux, Mac OS X y
Windows) vienen con acciones como cortar y pegar determinadas. Sonic Pi intentará
honrar estos estándares. Sin embargo *priorizaremos consistencia a través de las
plataformas* dentro de Sonic Pi. Esto significa que te sentirás cómodo y en casa
ya sea que toques con la Raspberry Pi, Mac o PC.

## Control y Meta

Parte de la noción de consistencia es el nombramiento de los atajos. En Sonic Pi
usamos los nombre *Control* y *Meta* para referirnos a las dos principales 
combinaciones de teclas. En todas las plataformas *Control* es igual.
Sin embargo, en Linux y Windows, *Meta* es la tecla *Alt*, mientras que en Mac
es la tecla *Command*. Por consistencia, utilizaremos el término *Meta* - sólo 
recuerda mapear la tecla apropiada a tu OS.

## Abreviaciones

Para mantener las cosas simples y legibles, utilizaremos la abreviación *C-*
para *Control* más otra tecla y *M-* por *Meta* más otra tecla. Por ejemplo,
si un atajo te requiere que mantengas apretadas ambas *Meta* y *r*, escribiremos
elso, así `M-r`. El *-* significa que es al mismo tiempo.

Los siguientes son los atajos que encuentro más útiles.

## Para y comenzar

En vez de comenzar tu código conel ratón, puedes simplemente presionar `M-r`.
Similarmente puedes pararlo con `M-s`.

## Navegación

Sin los atajos de navegación estaría perdido. Así que recomiendo que los
aprendas. Estos atajos funcional fenomenalmente cuando hayas aprendido a
tocar y teclear, ya que usan letras estándar, en vez de requerir que vayas
al ratón o las flechas del teclado.

Puedes moverte al inicio de una línea con `C-a`, al final de la línea con
`C-e`, una línea arriba con `C-p`, abajo con `C-n`, un carácter adelante
con `C-f`, y atrás un carácter con `C-b`. puedes borrar todos los caracteres
desde el cursor hasta el final de la línea con `C-k`.

## Código legibles

Para auto-alinear el código, simplemete presiona `M-m`.

## Sistema de ayuda

Para aparecer el sistema de ayuda, presiona `M-i`. Sin embargo, un atajo mucho
más útil es `C-i` que buscará la palabra debajo del cursor y mostrará los 
documentos si encuentra algo. ayuda instantánea.

Para una lista completa, mira la sección 10.2 Tabla de Atajos.
