import os, errno

class SymLink:
	def __init__(self, target, source):
		self.target = target
		self.source = source

def symlink_action(target, source, env):
	if os.path.lexists(str(target[0])):
		os.remove(str(target[0]))
	old_wd = os.path.curdir
	abs_target = os.path.abspath(str(target[0]))
	abs_source = os.path.abspath(str(source[0]))
	prefix = os.path.dirname(os.path.commonprefix([abs_target, abs_source]))
	link_source = abs_source[len(prefix)+1:]
	os.symlink(link_source, str(target[0]))	

def symlink_string(target, source, env):
	return "Creating symbolic link %s to %s" % (str(target[0]), str(source[0]))

def InstallSymlinks1(env, targetdir, target):
	targets = []
	for tgt in target:
		linksource = os.path.join(dir, os.path.basename(str(tgt.source)))
		targets += env.SymbolicLink(os.path.join(dir, os.path.basename(str(tgt.target))), linksource)
		
	return targets

def InstallSymlinks(env, dir, target, source):
	linksource = os.path.join(dir, os.path.basename(str(source)))
	targets = []
	for tgt in target:
		targets += env.SymbolicLink(os.path.join(dir, os.path.basename(str(tgt))), linksource)
	return targets

def generate(env, **kw):
	action = env.Action(symlink_action, symlink_string)
	env['BUILDERS']['SymbolicLink'] = env.Builder(action=action, single_source=True)
	env.AddMethod(InstallSymlinks, 'InstallSymlinks')

def exists(env):
	return 1
