#! /usr/bin/env python

'''
Python Interface to SAGA Tools Library
----------
- Category : Import/Export
- Name     : Web Services
- ID       : io_webservices

Description
----------
Web Services
'''

from PySAGA.helper import Tool_Wrapper

def Geocoding(
    ADDRESSES=None,
    LOCATIONS=None,
    FIELD=None,
    ADDRESS=None,
    PROVIDER=None,
    API_KEY=None,
    METADATA=None, Verbose=2):
    '''
    Geocoding
    ----------
    [io_webservices.0]\n
    Geocoding of addresses using geocoding services.\n
    Arguments
    ----------
    - ADDRESSES [`optional input table`] : Address List
    - LOCATIONS [`output shapes`] : Locations
    - FIELD [`table field`] : Address Field
    - ADDRESS [`text`] : Single Address. Default: Bundesstrasse 55, Hamburg, Germany
    - PROVIDER [`choice`] : Service Provider. Available Choices: [0] Nominatim (OpenStreetMap) [1] The Data Science Toolkit [2] Google [3] Bing [4] MapQuest Default: 0
    - API_KEY [`text`] : API Key
    - METADATA [`boolean`] : Store Metadata. Default: 0

    - Verbose [`integer number`] : Verbosity level, 0=silent, 1=tool name and success notification, 2=complete tool output.\n
    Returns
    ----------
    `boolean` : `True` on success, `False` on failure.
    '''
    Tool = Tool_Wrapper('io_webservices', '0', 'Geocoding')
    if Tool.is_Okay():
        Tool.Set_Input ('ADDRESSES', ADDRESSES)
        Tool.Set_Output('LOCATIONS', LOCATIONS)
        Tool.Set_Option('FIELD', FIELD)
        Tool.Set_Option('ADDRESS', ADDRESS)
        Tool.Set_Option('PROVIDER', PROVIDER)
        Tool.Set_Option('API_KEY', API_KEY)
        Tool.Set_Option('METADATA', METADATA)
        return Tool.Execute(Verbose)
    return False

def run_tool_io_webservices_0(
    ADDRESSES=None,
    LOCATIONS=None,
    FIELD=None,
    ADDRESS=None,
    PROVIDER=None,
    API_KEY=None,
    METADATA=None, Verbose=2):
    '''
    Geocoding
    ----------
    [io_webservices.0]\n
    Geocoding of addresses using geocoding services.\n
    Arguments
    ----------
    - ADDRESSES [`optional input table`] : Address List
    - LOCATIONS [`output shapes`] : Locations
    - FIELD [`table field`] : Address Field
    - ADDRESS [`text`] : Single Address. Default: Bundesstrasse 55, Hamburg, Germany
    - PROVIDER [`choice`] : Service Provider. Available Choices: [0] Nominatim (OpenStreetMap) [1] The Data Science Toolkit [2] Google [3] Bing [4] MapQuest Default: 0
    - API_KEY [`text`] : API Key
    - METADATA [`boolean`] : Store Metadata. Default: 0

    - Verbose [`integer number`] : Verbosity level, 0=silent, 1=tool name and success notification, 2=complete tool output.\n
    Returns
    ----------
    `boolean` : `True` on success, `False` on failure.
    '''
    Tool = Tool_Wrapper('io_webservices', '0', 'Geocoding')
    if Tool.is_Okay():
        Tool.Set_Input ('ADDRESSES', ADDRESSES)
        Tool.Set_Output('LOCATIONS', LOCATIONS)
        Tool.Set_Option('FIELD', FIELD)
        Tool.Set_Option('ADDRESS', ADDRESS)
        Tool.Set_Option('PROVIDER', PROVIDER)
        Tool.Set_Option('API_KEY', API_KEY)
        Tool.Set_Option('METADATA', METADATA)
        return Tool.Execute(Verbose)
    return False

def SRTM_CGIAR_CSI(
    GRID=None,
    SHAPES=None,
    RESULT=None,
    TILES=None,
    DELARCHIVE=None,
    EXTENT=None,
    GRID_SYSTEM=None,
    XMIN=None,
    XMAX=None,
    YMIN=None,
    YMAX=None,
    NX=None,
    NY=None,
    BUFFER=None,
    CELLSIZE=None,
    CRS_STRING=None, Verbose=2):
    '''
    SRTM (CGIAR CSI)
    ----------
    [io_webservices.1]\n
    This tool provides easy-to-use access to the 'NASA Shuttle Radar Topography Mission Global 3 arc second' elevation data (about 90 meter resolution) as provided by the CGIAR CSI server. It uses a local database in the chosen directory which provides the original tiles. If the tiles covering the requested area are not found in this directory the tool tries to download these from the CGIAR CSI server.\n
    Arguments
    ----------
    - GRID [`input grid`] : Grid
    - SHAPES [`input shapes`] : Shapes
    - RESULT [`output data object`] : Grid
    - TILES [`file path`] : Local Tiles Directory. Download location for tiles. If requested tile is already present download will be skipped.
    - DELARCHIVE [`boolean`] : Delete Archive Files. Default: 1 Do not keep archive files after download
    - EXTENT [`choice`] : Extent. Available Choices: [0] user defined [1] shapes extent [2] grid system extent [3] grid system Default: 0
    - GRID_SYSTEM [`grid system`] : Grid System
    - XMIN [`floating point number`] : West. Default: 270360.000000
    - XMAX [`floating point number`] : East. Default: 931320.000000
    - YMIN [`floating point number`] : South. Default: 5225850.000000
    - YMAX [`floating point number`] : North. Default: 6111540.000000
    - NX [`integer number`] : Columns. Minimum: 1 Default: 7345
    - NY [`integer number`] : Rows. Minimum: 1 Default: 9842
    - BUFFER [`floating point number`] : Buffer. Minimum: 0.000000 Default: 0.000000 add buffer (map units) to extent
    - CELLSIZE [`floating point number`] : Cellsize. Minimum: 0.000100 Default: 90.000000
    - CRS_STRING [`text`] : Coordinate System Definition. Supported formats comprise PROJ and WKT strings, object codes (e.g. "EPSG:4326").

    - Verbose [`integer number`] : Verbosity level, 0=silent, 1=tool name and success notification, 2=complete tool output.\n
    Returns
    ----------
    `boolean` : `True` on success, `False` on failure.
    '''
    Tool = Tool_Wrapper('io_webservices', '1', 'SRTM (CGIAR CSI)')
    if Tool.is_Okay():
        Tool.Set_Input ('GRID', GRID)
        Tool.Set_Input ('SHAPES', SHAPES)
        Tool.Set_Output('RESULT', RESULT)
        Tool.Set_Option('TILES', TILES)
        Tool.Set_Option('DELARCHIVE', DELARCHIVE)
        Tool.Set_Option('EXTENT', EXTENT)
        Tool.Set_Option('GRID_SYSTEM', GRID_SYSTEM)
        Tool.Set_Option('XMIN', XMIN)
        Tool.Set_Option('XMAX', XMAX)
        Tool.Set_Option('YMIN', YMIN)
        Tool.Set_Option('YMAX', YMAX)
        Tool.Set_Option('NX', NX)
        Tool.Set_Option('NY', NY)
        Tool.Set_Option('BUFFER', BUFFER)
        Tool.Set_Option('CELLSIZE', CELLSIZE)
        Tool.Set_Option('CRS_STRING', CRS_STRING)
        return Tool.Execute(Verbose)
    return False

def run_tool_io_webservices_1(
    GRID=None,
    SHAPES=None,
    RESULT=None,
    TILES=None,
    DELARCHIVE=None,
    EXTENT=None,
    GRID_SYSTEM=None,
    XMIN=None,
    XMAX=None,
    YMIN=None,
    YMAX=None,
    NX=None,
    NY=None,
    BUFFER=None,
    CELLSIZE=None,
    CRS_STRING=None, Verbose=2):
    '''
    SRTM (CGIAR CSI)
    ----------
    [io_webservices.1]\n
    This tool provides easy-to-use access to the 'NASA Shuttle Radar Topography Mission Global 3 arc second' elevation data (about 90 meter resolution) as provided by the CGIAR CSI server. It uses a local database in the chosen directory which provides the original tiles. If the tiles covering the requested area are not found in this directory the tool tries to download these from the CGIAR CSI server.\n
    Arguments
    ----------
    - GRID [`input grid`] : Grid
    - SHAPES [`input shapes`] : Shapes
    - RESULT [`output data object`] : Grid
    - TILES [`file path`] : Local Tiles Directory. Download location for tiles. If requested tile is already present download will be skipped.
    - DELARCHIVE [`boolean`] : Delete Archive Files. Default: 1 Do not keep archive files after download
    - EXTENT [`choice`] : Extent. Available Choices: [0] user defined [1] shapes extent [2] grid system extent [3] grid system Default: 0
    - GRID_SYSTEM [`grid system`] : Grid System
    - XMIN [`floating point number`] : West. Default: 270360.000000
    - XMAX [`floating point number`] : East. Default: 931320.000000
    - YMIN [`floating point number`] : South. Default: 5225850.000000
    - YMAX [`floating point number`] : North. Default: 6111540.000000
    - NX [`integer number`] : Columns. Minimum: 1 Default: 7345
    - NY [`integer number`] : Rows. Minimum: 1 Default: 9842
    - BUFFER [`floating point number`] : Buffer. Minimum: 0.000000 Default: 0.000000 add buffer (map units) to extent
    - CELLSIZE [`floating point number`] : Cellsize. Minimum: 0.000100 Default: 90.000000
    - CRS_STRING [`text`] : Coordinate System Definition. Supported formats comprise PROJ and WKT strings, object codes (e.g. "EPSG:4326").

    - Verbose [`integer number`] : Verbosity level, 0=silent, 1=tool name and success notification, 2=complete tool output.\n
    Returns
    ----------
    `boolean` : `True` on success, `False` on failure.
    '''
    Tool = Tool_Wrapper('io_webservices', '1', 'SRTM (CGIAR CSI)')
    if Tool.is_Okay():
        Tool.Set_Input ('GRID', GRID)
        Tool.Set_Input ('SHAPES', SHAPES)
        Tool.Set_Output('RESULT', RESULT)
        Tool.Set_Option('TILES', TILES)
        Tool.Set_Option('DELARCHIVE', DELARCHIVE)
        Tool.Set_Option('EXTENT', EXTENT)
        Tool.Set_Option('GRID_SYSTEM', GRID_SYSTEM)
        Tool.Set_Option('XMIN', XMIN)
        Tool.Set_Option('XMAX', XMAX)
        Tool.Set_Option('YMIN', YMIN)
        Tool.Set_Option('YMAX', YMAX)
        Tool.Set_Option('NX', NX)
        Tool.Set_Option('NY', NY)
        Tool.Set_Option('BUFFER', BUFFER)
        Tool.Set_Option('CELLSIZE', CELLSIZE)
        Tool.Set_Option('CRS_STRING', CRS_STRING)
        return Tool.Execute(Verbose)
    return False

def Global_OpenTopography(
    GRID=None,
    SHAPES=None,
    RESULT=None,
    DEMTYPE=None,
    API_KEY=None,
    EXTENT=None,
    GRID_SYSTEM=None,
    XMIN=None,
    XMAX=None,
    YMIN=None,
    YMAX=None,
    NX=None,
    NY=None,
    BUFFER=None,
    CELLSIZEDEF=None,
    CELLSIZE=None,
    CRS_STRING=None, Verbose=2):
    '''
    Global OpenTopography
    ----------
    [io_webservices.4]\n
    Download and optionally project global digital elevation model (DEM) data for the area of your interest provided by the OpenTopography project. The download needs a personal [API key] which can be obtained easily after login at the OpenTopography Data Portal.\n
    Available DEM products are:\n
    (-) SRTM GL3 90m\n
    (-) SRTM GL1 30m\n
    (-) SRTM GL1 Ellipsoidal 30m\n
    (-) ALOS World 3D 30m\n
    (-) ALOS World 3D Ellipsoidal, 30m\n
    (-) Global Bathymetry SRTM15+ V2.1 500m\n
    (-) NASADEM Global DEM\n
    (-) Copernicus Global DSM 30m\n
    (-) Copernicus Global DSM 90m\n
    (-) EU DTM 30m\n
    (-) GEDI_L3 DTM 1000m\n
    (-) Global Ice Bathymetry 500m\n
    (-) Global Sub-Ice Bathymetry 500m\n
    Arguments
    ----------
    - GRID [`input grid`] : Grid
    - SHAPES [`input shapes`] : Shapes
    - RESULT [`output data object`] : Grid
    - DEMTYPE [`choice`] : DEM Type. Available Choices: [0] SRTM GL3 90m [1] SRTM GL1 30m [2] SRTM GL1 Ellipsoidal 30m [3] ALOS World 3D 30m [4] ALOS World 3D Ellipsoidal, 30m [5] Global Bathymetry SRTM15+ V2.1 500m [6] NASADEM Global DEM [7] Copernicus Global DSM 30m [8] Copernicus Global DSM 90m [9] EU DTM 30m [10] GEDI_L3 DTM 1000m [11] Global Ice Bathymetry 500m [12] Global Sub-Ice Bathymetry 500m Default: 3
    - API_KEY [`text`] : API Key
    - EXTENT [`choice`] : Extent. Available Choices: [0] user defined [1] shapes extent [2] grid system extent [3] grid system Default: 0
    - GRID_SYSTEM [`grid system`] : Grid System
    - XMIN [`floating point number`] : West. Default: 538350.000000
    - XMAX [`floating point number`] : East. Default: 598020.000000
    - YMIN [`floating point number`] : South. Default: 5906910.000000
    - YMAX [`floating point number`] : North. Default: 5965170.000000
    - NX [`integer number`] : Columns. Minimum: 1 Default: 1990
    - NY [`integer number`] : Rows. Minimum: 1 Default: 1943
    - BUFFER [`floating point number`] : Buffer. Minimum: 0.000000 Default: 0.000000 add buffer (map units) to extent
    - CELLSIZEDEF [`choice`] : Take Cellsize. Available Choices: [0] data type resolution [1] user defined Default: 0
    - CELLSIZE [`floating point number`] : Cellsize. Minimum: 0.000100 Default: 90.000000
    - CRS_STRING [`text`] : Coordinate System Definition. Supported formats comprise PROJ and WKT strings, object codes (e.g. "EPSG:4326").

    - Verbose [`integer number`] : Verbosity level, 0=silent, 1=tool name and success notification, 2=complete tool output.\n
    Returns
    ----------
    `boolean` : `True` on success, `False` on failure.
    '''
    Tool = Tool_Wrapper('io_webservices', '4', 'Global OpenTopography')
    if Tool.is_Okay():
        Tool.Set_Input ('GRID', GRID)
        Tool.Set_Input ('SHAPES', SHAPES)
        Tool.Set_Output('RESULT', RESULT)
        Tool.Set_Option('DEMTYPE', DEMTYPE)
        Tool.Set_Option('API_KEY', API_KEY)
        Tool.Set_Option('EXTENT', EXTENT)
        Tool.Set_Option('GRID_SYSTEM', GRID_SYSTEM)
        Tool.Set_Option('XMIN', XMIN)
        Tool.Set_Option('XMAX', XMAX)
        Tool.Set_Option('YMIN', YMIN)
        Tool.Set_Option('YMAX', YMAX)
        Tool.Set_Option('NX', NX)
        Tool.Set_Option('NY', NY)
        Tool.Set_Option('BUFFER', BUFFER)
        Tool.Set_Option('CELLSIZEDEF', CELLSIZEDEF)
        Tool.Set_Option('CELLSIZE', CELLSIZE)
        Tool.Set_Option('CRS_STRING', CRS_STRING)
        return Tool.Execute(Verbose)
    return False

def run_tool_io_webservices_4(
    GRID=None,
    SHAPES=None,
    RESULT=None,
    DEMTYPE=None,
    API_KEY=None,
    EXTENT=None,
    GRID_SYSTEM=None,
    XMIN=None,
    XMAX=None,
    YMIN=None,
    YMAX=None,
    NX=None,
    NY=None,
    BUFFER=None,
    CELLSIZEDEF=None,
    CELLSIZE=None,
    CRS_STRING=None, Verbose=2):
    '''
    Global OpenTopography
    ----------
    [io_webservices.4]\n
    Download and optionally project global digital elevation model (DEM) data for the area of your interest provided by the OpenTopography project. The download needs a personal [API key] which can be obtained easily after login at the OpenTopography Data Portal.\n
    Available DEM products are:\n
    (-) SRTM GL3 90m\n
    (-) SRTM GL1 30m\n
    (-) SRTM GL1 Ellipsoidal 30m\n
    (-) ALOS World 3D 30m\n
    (-) ALOS World 3D Ellipsoidal, 30m\n
    (-) Global Bathymetry SRTM15+ V2.1 500m\n
    (-) NASADEM Global DEM\n
    (-) Copernicus Global DSM 30m\n
    (-) Copernicus Global DSM 90m\n
    (-) EU DTM 30m\n
    (-) GEDI_L3 DTM 1000m\n
    (-) Global Ice Bathymetry 500m\n
    (-) Global Sub-Ice Bathymetry 500m\n
    Arguments
    ----------
    - GRID [`input grid`] : Grid
    - SHAPES [`input shapes`] : Shapes
    - RESULT [`output data object`] : Grid
    - DEMTYPE [`choice`] : DEM Type. Available Choices: [0] SRTM GL3 90m [1] SRTM GL1 30m [2] SRTM GL1 Ellipsoidal 30m [3] ALOS World 3D 30m [4] ALOS World 3D Ellipsoidal, 30m [5] Global Bathymetry SRTM15+ V2.1 500m [6] NASADEM Global DEM [7] Copernicus Global DSM 30m [8] Copernicus Global DSM 90m [9] EU DTM 30m [10] GEDI_L3 DTM 1000m [11] Global Ice Bathymetry 500m [12] Global Sub-Ice Bathymetry 500m Default: 3
    - API_KEY [`text`] : API Key
    - EXTENT [`choice`] : Extent. Available Choices: [0] user defined [1] shapes extent [2] grid system extent [3] grid system Default: 0
    - GRID_SYSTEM [`grid system`] : Grid System
    - XMIN [`floating point number`] : West. Default: 538350.000000
    - XMAX [`floating point number`] : East. Default: 598020.000000
    - YMIN [`floating point number`] : South. Default: 5906910.000000
    - YMAX [`floating point number`] : North. Default: 5965170.000000
    - NX [`integer number`] : Columns. Minimum: 1 Default: 1990
    - NY [`integer number`] : Rows. Minimum: 1 Default: 1943
    - BUFFER [`floating point number`] : Buffer. Minimum: 0.000000 Default: 0.000000 add buffer (map units) to extent
    - CELLSIZEDEF [`choice`] : Take Cellsize. Available Choices: [0] data type resolution [1] user defined Default: 0
    - CELLSIZE [`floating point number`] : Cellsize. Minimum: 0.000100 Default: 90.000000
    - CRS_STRING [`text`] : Coordinate System Definition. Supported formats comprise PROJ and WKT strings, object codes (e.g. "EPSG:4326").

    - Verbose [`integer number`] : Verbosity level, 0=silent, 1=tool name and success notification, 2=complete tool output.\n
    Returns
    ----------
    `boolean` : `True` on success, `False` on failure.
    '''
    Tool = Tool_Wrapper('io_webservices', '4', 'Global OpenTopography')
    if Tool.is_Okay():
        Tool.Set_Input ('GRID', GRID)
        Tool.Set_Input ('SHAPES', SHAPES)
        Tool.Set_Output('RESULT', RESULT)
        Tool.Set_Option('DEMTYPE', DEMTYPE)
        Tool.Set_Option('API_KEY', API_KEY)
        Tool.Set_Option('EXTENT', EXTENT)
        Tool.Set_Option('GRID_SYSTEM', GRID_SYSTEM)
        Tool.Set_Option('XMIN', XMIN)
        Tool.Set_Option('XMAX', XMAX)
        Tool.Set_Option('YMIN', YMIN)
        Tool.Set_Option('YMAX', YMAX)
        Tool.Set_Option('NX', NX)
        Tool.Set_Option('NY', NY)
        Tool.Set_Option('BUFFER', BUFFER)
        Tool.Set_Option('CELLSIZEDEF', CELLSIZEDEF)
        Tool.Set_Option('CELLSIZE', CELLSIZE)
        Tool.Set_Option('CRS_STRING', CRS_STRING)
        return Tool.Execute(Verbose)
    return False

def USGS_Earthquake_Catalog(
    SHAPES=None,
    GRID=None,
    EARTHQUAKES=None,
    DATE_START=None,
    DATE_END=None,
    MAGNITUDE=None,
    EXTENT=None,
    GRID_SYSTEM=None,
    XMIN=None,
    XMAX=None,
    YMIN=None,
    YMAX=None,
    BUFFER=None,
    CRS_STRING=None, Verbose=2):
    '''
    USGS Earthquake Catalog
    ----------
    [io_webservices.5]\n
    Request earthquake data from the USGS Earthquake Catalog.\n
    Arguments
    ----------
    - SHAPES [`input shapes`] : Shapes
    - GRID [`optional input grid`] : Grid
    - EARTHQUAKES [`output shapes`] : Earthquakes
    - DATE_START [`date`] : Start. Default: 2025-03-25
    - DATE_END [`date`] : End. Default: 2025-04-01
    - MAGNITUDE [`value range`] : Magnitude
    - EXTENT [`choice`] : Extent. Available Choices: [0] user defined [1] shapes extent [2] grid system extent Default: 0
    - GRID_SYSTEM [`grid system`] : Grid System
    - XMIN [`floating point number`] : West. Default: -180.000000
    - XMAX [`floating point number`] : East. Default: 180.000000
    - YMIN [`floating point number`] : South. Default: -90.000000
    - YMAX [`floating point number`] : North. Default: 90.000000
    - BUFFER [`floating point number`] : Buffer. Minimum: 0.000000 Default: 0.000000 add buffer (map units) to extent
    - CRS_STRING [`text`] : Coordinate System Definition. Supported formats comprise PROJ and WKT strings, object codes (e.g. "EPSG:4326").

    - Verbose [`integer number`] : Verbosity level, 0=silent, 1=tool name and success notification, 2=complete tool output.\n
    Returns
    ----------
    `boolean` : `True` on success, `False` on failure.
    '''
    Tool = Tool_Wrapper('io_webservices', '5', 'USGS Earthquake Catalog')
    if Tool.is_Okay():
        Tool.Set_Input ('SHAPES', SHAPES)
        Tool.Set_Input ('GRID', GRID)
        Tool.Set_Output('EARTHQUAKES', EARTHQUAKES)
        Tool.Set_Option('DATE_START', DATE_START)
        Tool.Set_Option('DATE_END', DATE_END)
        Tool.Set_Option('MAGNITUDE', MAGNITUDE)
        Tool.Set_Option('EXTENT', EXTENT)
        Tool.Set_Option('GRID_SYSTEM', GRID_SYSTEM)
        Tool.Set_Option('XMIN', XMIN)
        Tool.Set_Option('XMAX', XMAX)
        Tool.Set_Option('YMIN', YMIN)
        Tool.Set_Option('YMAX', YMAX)
        Tool.Set_Option('BUFFER', BUFFER)
        Tool.Set_Option('CRS_STRING', CRS_STRING)
        return Tool.Execute(Verbose)
    return False

def run_tool_io_webservices_5(
    SHAPES=None,
    GRID=None,
    EARTHQUAKES=None,
    DATE_START=None,
    DATE_END=None,
    MAGNITUDE=None,
    EXTENT=None,
    GRID_SYSTEM=None,
    XMIN=None,
    XMAX=None,
    YMIN=None,
    YMAX=None,
    BUFFER=None,
    CRS_STRING=None, Verbose=2):
    '''
    USGS Earthquake Catalog
    ----------
    [io_webservices.5]\n
    Request earthquake data from the USGS Earthquake Catalog.\n
    Arguments
    ----------
    - SHAPES [`input shapes`] : Shapes
    - GRID [`optional input grid`] : Grid
    - EARTHQUAKES [`output shapes`] : Earthquakes
    - DATE_START [`date`] : Start. Default: 2025-03-25
    - DATE_END [`date`] : End. Default: 2025-04-01
    - MAGNITUDE [`value range`] : Magnitude
    - EXTENT [`choice`] : Extent. Available Choices: [0] user defined [1] shapes extent [2] grid system extent Default: 0
    - GRID_SYSTEM [`grid system`] : Grid System
    - XMIN [`floating point number`] : West. Default: -180.000000
    - XMAX [`floating point number`] : East. Default: 180.000000
    - YMIN [`floating point number`] : South. Default: -90.000000
    - YMAX [`floating point number`] : North. Default: 90.000000
    - BUFFER [`floating point number`] : Buffer. Minimum: 0.000000 Default: 0.000000 add buffer (map units) to extent
    - CRS_STRING [`text`] : Coordinate System Definition. Supported formats comprise PROJ and WKT strings, object codes (e.g. "EPSG:4326").

    - Verbose [`integer number`] : Verbosity level, 0=silent, 1=tool name and success notification, 2=complete tool output.\n
    Returns
    ----------
    `boolean` : `True` on success, `False` on failure.
    '''
    Tool = Tool_Wrapper('io_webservices', '5', 'USGS Earthquake Catalog')
    if Tool.is_Okay():
        Tool.Set_Input ('SHAPES', SHAPES)
        Tool.Set_Input ('GRID', GRID)
        Tool.Set_Output('EARTHQUAKES', EARTHQUAKES)
        Tool.Set_Option('DATE_START', DATE_START)
        Tool.Set_Option('DATE_END', DATE_END)
        Tool.Set_Option('MAGNITUDE', MAGNITUDE)
        Tool.Set_Option('EXTENT', EXTENT)
        Tool.Set_Option('GRID_SYSTEM', GRID_SYSTEM)
        Tool.Set_Option('XMIN', XMIN)
        Tool.Set_Option('XMAX', XMAX)
        Tool.Set_Option('YMIN', YMIN)
        Tool.Set_Option('YMAX', YMAX)
        Tool.Set_Option('BUFFER', BUFFER)
        Tool.Set_Option('CRS_STRING', CRS_STRING)
        return Tool.Execute(Verbose)
    return False

