// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::{ffi, VectorSprite};
use glib::{prelude::*, translate::*};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "ShumateVectorSpriteSheet")]
    pub struct VectorSpriteSheet(Object<ffi::ShumateVectorSpriteSheet, ffi::ShumateVectorSpriteSheetClass>);

    match fn {
        type_ => || ffi::shumate_vector_sprite_sheet_get_type(),
    }
}

impl VectorSpriteSheet {
    #[doc(alias = "shumate_vector_sprite_sheet_new")]
    pub fn new() -> VectorSpriteSheet {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::shumate_vector_sprite_sheet_new()) }
    }

    #[doc(alias = "shumate_vector_sprite_sheet_add_page")]
    pub fn add_page(
        &self,
        texture: &impl IsA<gdk::Texture>,
        json: &str,
        default_scale: f64,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let is_ok = ffi::shumate_vector_sprite_sheet_add_page(
                self.to_glib_none().0,
                texture.as_ref().to_glib_none().0,
                json.to_glib_none().0,
                default_scale,
                &mut error,
            );
            debug_assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "shumate_vector_sprite_sheet_add_sprite")]
    pub fn add_sprite(&self, name: &str, sprite: &VectorSprite) {
        unsafe {
            ffi::shumate_vector_sprite_sheet_add_sprite(
                self.to_glib_none().0,
                name.to_glib_none().0,
                sprite.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "shumate_vector_sprite_sheet_get_sprite")]
    #[doc(alias = "get_sprite")]
    pub fn sprite(&self, name: &str, scale: f64) -> Option<VectorSprite> {
        unsafe {
            from_glib_full(ffi::shumate_vector_sprite_sheet_get_sprite(
                self.to_glib_none().0,
                name.to_glib_none().0,
                scale,
            ))
        }
    }

    #[doc(alias = "shumate_vector_sprite_sheet_set_fallback")]
    pub fn set_fallback(
        &self,
        fallback: Option<
            Box_<dyn Fn(&VectorSpriteSheet, &str, f64) -> Option<VectorSprite> + 'static>,
        >,
    ) {
        let fallback_data: Box_<
            Option<Box_<dyn Fn(&VectorSpriteSheet, &str, f64) -> Option<VectorSprite> + 'static>>,
        > = Box_::new(fallback);
        unsafe extern "C" fn fallback_func(
            sprite_sheet: *mut ffi::ShumateVectorSpriteSheet,
            name: *const libc::c_char,
            scale: libc::c_double,
            user_data: glib::ffi::gpointer,
        ) -> *mut ffi::ShumateVectorSprite {
            let sprite_sheet = from_glib_borrow(sprite_sheet);
            let name: Borrowed<glib::GString> = from_glib_borrow(name);
            let callback = &*(user_data
                as *mut Option<
                    Box_<dyn Fn(&VectorSpriteSheet, &str, f64) -> Option<VectorSprite> + 'static>,
                >);
            if let Some(ref callback) = *callback {
                callback(&sprite_sheet, name.as_str(), scale)
            } else {
                panic!("cannot get closure...")
            }
            .to_glib_full()
        }
        let fallback = if fallback_data.is_some() {
            Some(fallback_func as _)
        } else {
            None
        };
        unsafe extern "C" fn notify_func(data: glib::ffi::gpointer) {
            let _callback = Box_::from_raw(
                data as *mut Option<
                    Box_<dyn Fn(&VectorSpriteSheet, &str, f64) -> Option<VectorSprite> + 'static>,
                >,
            );
        }
        let destroy_call3 = Some(notify_func as _);
        let super_callback0: Box_<
            Option<Box_<dyn Fn(&VectorSpriteSheet, &str, f64) -> Option<VectorSprite> + 'static>>,
        > = fallback_data;
        unsafe {
            ffi::shumate_vector_sprite_sheet_set_fallback(
                self.to_glib_none().0,
                fallback,
                Box_::into_raw(super_callback0) as *mut _,
                destroy_call3,
            );
        }
    }
}

#[cfg(feature = "v1_1")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_1")))]
impl Default for VectorSpriteSheet {
    fn default() -> Self {
        Self::new()
    }
}
