#!/bin/bash
#
# RC sample administration - secure apache web server with CGIs
#
#
DOCTYPE=`rc_get_item list_unused_fd_type_nr | head -n 1`
APACHEROLE=`rc_get_item list_unused_role_nr | head -n 1`
CGIROLE=`rc_get_item list_unused_role_nr | head -n 2 | tail -n 1`
#
GENERALTYPE=0
GENERALUSERROLE=0
ROLEADMINROLE=1
SYSADMINROLE=2
USEDROLES="`rc_get_item list_used_role_nr`"
USEDTYPES="`rc_get_item list_used_fd_type_nr`"
APACHEBIN=/usr/sbin/httpd
DOCROOT=/usr/local/httpd
CGIDIR=/usr/local/httpd/cgi-bin
APACHEUSER=wwwrun
#
# Redo security check
if test "`attr_get_file_dir DIR $DOCROOT rc_type_fd`" != "65"
then echo "$DOCROOT already has a rc_type_fd set, exiting!" ; exit
fi
#
echo ""
echo Create new type $DOCTYPE \"WWW Docs\"
rc_set_item TYPE $DOCTYPE type_fd_name "WWW Docs" || exit
#
echo ""
echo Give \"Role Admin\" read and attribute rights to DOCTYPE $DOCTYPE
rc_set_item ROLE $ROLEADMINROLE type_comp_fd $DOCTYPE R 1 || exit
rc_set_item ROLE $ROLEADMINROLE type_comp_fd $DOCTYPE SE 1 || exit
#
echo ""
echo Create new roles $APACHEROLE \"Apache Role\" and $CGIROLE \"CGI Role\"
rc_set_item ROLE $APACHEROLE name "Apache Role" || exit
rc_set_item ROLE $CGIROLE name "CGI Role" || exit
#
echo ""
echo Disallow file creation for $CGIROLE \"CGI Role\"
rc_set_item ROLE $CGIROLE def_fd_create_type 66 || exit
#
echo ""
echo Give \"Apache Role\" and \"CGI Role\" read rights to DOCTYPE $DOCTYPE
rc_set_item ROLE $APACHEROLE type_comp_fd $DOCTYPE R 1 || exit
rc_set_item ROLE $CGIROLE type_comp_fd $DOCTYPE R 1 || exit
#
echo ""
echo Give \"Apache Role\" CREATE and DELETE right to IPC type GENERALTYPE $GENERALTYPE
for i in CREATE DELETE
  do rc_set_item ROLE $APACHEROLE type_comp_ipc $GENERALTYPE $i 1 || exit
done
#
echo ""
echo Give \"Apache Role\" and \"CGI Role\" SEARCH right to
echo GENERALTYPE $GENERALTYPE to go down to own files
for i in SEARCH
  do rc_set_item ROLE $APACHEROLE type_comp_fd $GENERALTYPE $i 1 || exit
     rc_set_item ROLE $CGIROLE type_comp_fd $GENERALTYPE $i 1 || exit
done
#
echo ""
echo Give \"System Admin\" read-write rights to DOCTYPE $DOCTYPE
rc_set_item ROLE $SYSADMINROLE type_comp_fd $DOCTYPE RW 1 || exit
#
echo ""
echo Set type $DOCTYPE \"WWW Docs\" for $DOCROOT and $CGIDIR
attr_set_file_dir DIR $DOCROOT rc_type_fd $DOCTYPE || exit
attr_set_file_dir DIR $CGIDIR rc_type_fd $DOCTYPE || exit
#
echo ""
echo Give all CGIs in $CGIDIR rc_force_role \"CGI Role\"
for i in ${CGIDIR}/*
do \
  attr_set_file_dir FILE $i rc_force_role $CGIROLE || exit
done
#
echo ""
echo Set role $APACHEROLE \"Apache Role\" for $APACHEUSER
attr_set_user $APACHEUSER rc_def_role $APACHEROLE || exit
#
echo ""
echo "Ready. Please check your new configuration."
echo ""
echo "Don't forget to set an AUTH capability for $APACHEBIN,"
echo "user $APACHEUSER, if AUTH is active:"
echo auth_set_cap FILE add $APACHEBIN $APACHEUSER
echo ""
echo Also you might have to set perl's Registry.pm file to rc_type_fd $DOCTYPE
echo to run perl CGI scripts.
