/*
 * Copyright (c) 2014, 2015
 * NDE Netzdesign und -entwicklung AG, Hamburg, Germany
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program (see the file LICENSE.txt for more
 * details); if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
 */

package org.acplt.oncrpc.maven.plugin;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

/**
 * This class defines the goal <em>client</em> within the lifecycle
 * phase <em>generate-sources</em>.
 * 
 * <p>The client stub(s) to the RPC program(s) specified in the x-file
 * to be processed is(are) generated alongside the XDR datatype classes.
 * 
 * <p>Possible parameters are described in the base class
 * {@link JrpcgenGeneratorBase}.
 * 
 * <p>Sample configuration:
 * <pre>
	{@literal <}plugin{@literal >}
		{@literal <}groupId{@literal >}org.acplt.remotetea{@literal <}/groupId{@literal >}
		{@literal <}artifactId{@literal >}remotetea-maven-plugin{@literal <}/artifactId{@literal >}
		{@literal <}version{@literal >}1.1.6{@literal <}/version{@literal >}
		{@literal <}executions{@literal >}
			{@literal <}execution{@literal >}
				{@literal <}id{@literal >}jrpcgen{@literal <}/id{@literal >}
				{@literal <}goals{@literal >}
					{@literal <}goal{@literal >}clientandserver{@literal <}/goal{@literal >}
				{@literal <}/goals{@literal >}
				{@literal <}configuration{@literal >}
					{@literal <}xFile{@literal >}src/main/resources/bellamso_tracelog.x{@literal <}/xFile{@literal >}
					{@literal <}destDir{@literal >}${project.build.directory}/generated-sources{@literal <}/destDir{@literal >}
					{@literal <}packageName{@literal >}com.bellamso.tracelog.rpc{@literal <}/packageName{@literal >}
					{@literal <}!-- Force the creation of the destination directory
					     if it does not already exist at generation time. --{@literal >} 
					{@literal <}createDir{@literal >}true{@literal <}/createDir{@literal >}
				{@literal <}/configuration{@literal >}
			{@literal <}/execution{@literal >}
		{@literal <}/executions{@literal >}
	{@literal <}/plugin{@literal >}
 * </pre>
 * 
 * @author Harald Wirths {@literal <hwirths@nde.ag>}
 *
 */
@Mojo( name="client", defaultPhase=LifecyclePhase.GENERATE_SOURCES )
public class JRpcClientGenerator extends JRpcGeneratorBase
{

    public void execute()
            throws MojoExecutionException
        {
            options.noServer = true;
            this.generateSources();
        }
    
}
