// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2020 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from Emd.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.emdmodel {
  public class Emd_1_3_1 : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("emdmodel.Emd:1.3.1", null);

    public Emd_1_3_1(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public Emd_1_3_1(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new Emd_1_3_1 StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new Emd_1_3_1(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public const int ERR_INVALID_PARAMS = 1;

    public enum Events {
      EVT_KEY_SETTINGS_CHANGED,
    }

    public class MetaData : ICloneable {
      public object Clone() {
        MetaData copy = new MetaData();
        copy.nameplate = this.nameplate;
        copy.ctrlBoardSerial = this.ctrlBoardSerial;
        copy.hwRevision = this.hwRevision;
        copy.fwRevision = this.fwRevision;
        copy.macAddress = this.macAddress;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["nameplate"] = this.nameplate.Encode();
        json["ctrlBoardSerial"] = this.ctrlBoardSerial;
        json["hwRevision"] = this.hwRevision;
        json["fwRevision"] = this.fwRevision;
        json["macAddress"] = this.macAddress;
        return json;
      }

      public static MetaData Decode(LightJson.JsonObject json, Agent agent) {
        MetaData inst = new MetaData();
        inst.nameplate = Com.Raritan.Idl.pdumodel.Nameplate.Decode(json["nameplate"], agent);
        inst.ctrlBoardSerial = (string)json["ctrlBoardSerial"];
        inst.hwRevision = (string)json["hwRevision"];
        inst.fwRevision = (string)json["fwRevision"];
        inst.macAddress = (string)json["macAddress"];
        return inst;
      }

      public Com.Raritan.Idl.pdumodel.Nameplate nameplate = new Com.Raritan.Idl.pdumodel.Nameplate();
      public string ctrlBoardSerial = "";
      public string hwRevision = "";
      public string fwRevision = "";
      public string macAddress = "";
    }

    public class Settings : ICloneable {
      public object Clone() {
        Settings copy = new Settings();
        copy.name = this.name;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["name"] = this.name;
        return json;
      }

      public static Settings Decode(LightJson.JsonObject json, Agent agent) {
        Settings inst = new Settings();
        inst.name = (string)json["name"];
        return inst;
      }

      public string name = "";
    }

    public class GetMetaDataResult {
      public Com.Raritan.Idl.emdmodel.Emd_1_3_1.MetaData _ret_;
    }

    public GetMetaDataResult getMetaData() {
      JsonObject _parameters = null;
      var _result = RpcCall("getMetaData", _parameters);
      var _ret = new GetMetaDataResult();
      _ret._ret_ = Com.Raritan.Idl.emdmodel.Emd_1_3_1.MetaData.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getMetaData(AsyncRpcResponse<GetMetaDataResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getMetaData(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getMetaData(AsyncRpcResponse<GetMetaDataResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getMetaData", _parameters,
        _result => {
          try {
            var _ret = new GetMetaDataResult();
            _ret._ret_ = Com.Raritan.Idl.emdmodel.Emd_1_3_1.MetaData.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetExternalSensorManagerResult {
      public Com.Raritan.Idl.sensors.ExternalSensorManager_3_0_0 _ret_;
    }

    public GetExternalSensorManagerResult getExternalSensorManager() {
      JsonObject _parameters = null;
      var _result = RpcCall("getExternalSensorManager", _parameters);
      var _ret = new GetExternalSensorManagerResult();
      _ret._ret_ = Com.Raritan.Idl.sensors.ExternalSensorManager_3_0_0.StaticCast(ObjectProxy.Decode(_result["_ret_"], agent));
      return _ret;
    }

    public AsyncRequest getExternalSensorManager(AsyncRpcResponse<GetExternalSensorManagerResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getExternalSensorManager(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getExternalSensorManager(AsyncRpcResponse<GetExternalSensorManagerResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getExternalSensorManager", _parameters,
        _result => {
          try {
            var _ret = new GetExternalSensorManagerResult();
            _ret._ret_ = Com.Raritan.Idl.sensors.ExternalSensorManager_3_0_0.StaticCast(ObjectProxy.Decode(_result["_ret_"], agent));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetSettingsResult {
      public Com.Raritan.Idl.emdmodel.Emd_1_3_1.Settings _ret_;
    }

    public GetSettingsResult getSettings() {
      JsonObject _parameters = null;
      var _result = RpcCall("getSettings", _parameters);
      var _ret = new GetSettingsResult();
      _ret._ret_ = Com.Raritan.Idl.emdmodel.Emd_1_3_1.Settings.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getSettings(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getSettings", _parameters,
        _result => {
          try {
            var _ret = new GetSettingsResult();
            _ret._ret_ = Com.Raritan.Idl.emdmodel.Emd_1_3_1.Settings.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetSettingsResult {
      public int _ret_;
    }

    public SetSettingsResult setSettings(Com.Raritan.Idl.emdmodel.Emd_1_3_1.Settings settings) {
      var _parameters = new LightJson.JsonObject();
      _parameters["settings"] = settings.Encode();

      var _result = RpcCall("setSettings", _parameters);
      var _ret = new SetSettingsResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setSettings(Com.Raritan.Idl.emdmodel.Emd_1_3_1.Settings settings, AsyncRpcResponse<SetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setSettings(settings, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setSettings(Com.Raritan.Idl.emdmodel.Emd_1_3_1.Settings settings, AsyncRpcResponse<SetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["settings"] = settings.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setSettings", _parameters,
        _result => {
          try {
            var _ret = new SetSettingsResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetFeaturePortsResult {
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.portsmodel.Port_2_0_0> _ret_;
    }

    public GetFeaturePortsResult getFeaturePorts() {
      JsonObject _parameters = null;
      var _result = RpcCall("getFeaturePorts", _parameters);
      var _ret = new GetFeaturePortsResult();
      _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.portsmodel.Port_2_0_0>(_result["_ret_"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.portsmodel.Port_2_0_0.StaticCast(ObjectProxy.Decode(_value, agent))));
      return _ret;
    }

    public AsyncRequest getFeaturePorts(AsyncRpcResponse<GetFeaturePortsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getFeaturePorts(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getFeaturePorts(AsyncRpcResponse<GetFeaturePortsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getFeaturePorts", _parameters,
        _result => {
          try {
            var _ret = new GetFeaturePortsResult();
            _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.portsmodel.Port_2_0_0>(_result["_ret_"].AsJsonArray.Select(
              _value => Com.Raritan.Idl.portsmodel.Port_2_0_0.StaticCast(ObjectProxy.Decode(_value, agent))));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetAuxiliaryPortsResult {
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.portsmodel.Port_2_0_0> _ret_;
    }

    public GetAuxiliaryPortsResult getAuxiliaryPorts() {
      JsonObject _parameters = null;
      var _result = RpcCall("getAuxiliaryPorts", _parameters);
      var _ret = new GetAuxiliaryPortsResult();
      _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.portsmodel.Port_2_0_0>(_result["_ret_"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.portsmodel.Port_2_0_0.StaticCast(ObjectProxy.Decode(_value, agent))));
      return _ret;
    }

    public AsyncRequest getAuxiliaryPorts(AsyncRpcResponse<GetAuxiliaryPortsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getAuxiliaryPorts(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getAuxiliaryPorts(AsyncRpcResponse<GetAuxiliaryPortsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getAuxiliaryPorts", _parameters,
        _result => {
          try {
            var _ret = new GetAuxiliaryPortsResult();
            _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.portsmodel.Port_2_0_0>(_result["_ret_"].AsJsonArray.Select(
              _value => Com.Raritan.Idl.portsmodel.Port_2_0_0.StaticCast(ObjectProxy.Decode(_value, agent))));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetSensorLoggerResult {
      public Com.Raritan.Idl.pdumodel.SensorLogger_2_0_0 _ret_;
    }

    public GetSensorLoggerResult getSensorLogger() {
      JsonObject _parameters = null;
      var _result = RpcCall("getSensorLogger", _parameters);
      var _ret = new GetSensorLoggerResult();
      _ret._ret_ = Com.Raritan.Idl.pdumodel.SensorLogger_2_0_0.StaticCast(ObjectProxy.Decode(_result["_ret_"], agent));
      return _ret;
    }

    public AsyncRequest getSensorLogger(AsyncRpcResponse<GetSensorLoggerResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getSensorLogger(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getSensorLogger(AsyncRpcResponse<GetSensorLoggerResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getSensorLogger", _parameters,
        _result => {
          try {
            var _ret = new GetSensorLoggerResult();
            _ret._ret_ = Com.Raritan.Idl.pdumodel.SensorLogger_2_0_0.StaticCast(ObjectProxy.Decode(_result["_ret_"], agent));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
