% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shinywrappers.R
\name{renderText}
\alias{renderText}
\title{Text Output}
\usage{
renderText(expr, env = parent.frame(), quoted = FALSE,
  outputArgs = list())
}
\arguments{
\item{expr}{An expression that returns an R object that can be used as an
argument to \code{cat}.}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This
is useful if you want to save an expression in a variable.}

\item{outputArgs}{A list of arguments to be passed through to the implicit
call to \code{\link{textOutput}} when \code{renderText} is used in an
interactive R Markdown document.}
}
\description{
Makes a reactive version of the given function that also uses
\code{\link[base]{cat}} to turn its result into a single-element character
vector.
}
\details{
The corresponding HTML output tag can be anything (though \code{pre} is
recommended if you need a monospace font and whitespace preserved) and should
have the CSS class name \code{shiny-text-output}.

The result of executing \code{func} will passed to \code{cat}, inside a
\code{\link[utils]{capture.output}} call.
}
\examples{
isolate({

# renderPrint captures any print output, converts it to a string, and
# returns it
visFun <- renderPrint({ "foo" })
visFun()
# '[1] "foo"'

invisFun <- renderPrint({ invisible("foo") })
invisFun()
# ''

multiprintFun <- renderPrint({
  print("foo");
  "bar"
})
multiprintFun()
# '[1] "foo"\\n[1] "bar"'

nullFun <- renderPrint({ NULL })
nullFun()
# 'NULL'

invisNullFun <- renderPrint({ invisible(NULL) })
invisNullFun()
# ''

vecFun <- renderPrint({ 1:5 })
vecFun()
# '[1] 1 2 3 4 5'


# Contrast with renderText, which takes the value returned from the function
# and uses cat() to convert it to a string
visFun <- renderText({ "foo" })
visFun()
# 'foo'

invisFun <- renderText({ invisible("foo") })
invisFun()
# 'foo'

multiprintFun <- renderText({
  print("foo");
  "bar"
})
multiprintFun()
# 'bar'

nullFun <- renderText({ NULL })
nullFun()
# ''

invisNullFun <- renderText({ invisible(NULL) })
invisNullFun()
# ''

vecFun <- renderText({ 1:5 })
vecFun()
# '1 2 3 4 5'

})
}
\seealso{
\code{\link{renderPrint}} for capturing the print output of a
  function, rather than the returned text value.
}
