% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selections.R
\name{has_role}
\alias{has_role}
\alias{all_predictors}
\alias{all_numeric_predictors}
\alias{all_nominal_predictors}
\alias{all_outcomes}
\alias{has_type}
\alias{all_numeric}
\alias{all_nominal}
\alias{current_info}
\title{Role Selection}
\usage{
has_role(match = "predictor")

all_predictors()

all_numeric_predictors()

all_nominal_predictors()

all_outcomes()

has_type(match = "numeric")

all_numeric()

all_nominal()

current_info()
}
\arguments{
\item{match}{A single character string for the query. Exact
matching is used (i.e. regular expressions won't work).}
}
\value{
Selector functions return an integer vector.

\code{current_info()} returns an environment with objects \code{vars} and \code{data}.
}
\description{
\code{has_role()}, \code{all_predictors()}, and \code{all_outcomes()} can be used to
select variables in a formula that have certain roles.

Similarly, \code{has_type()}, \code{all_numeric()}, and \code{all_nominal()} are used to
select columns based on their data type. Nominal variables include both
character and factor.

\strong{In most cases}, the selectors \code{all_numeric_predictors()} and
\code{all_nominal_predictors()}, which select on role and type, will be the right
approach for users.

See \link{selections} for more details.

\code{current_info()} is an internal function.

All of these functions have have limited utility outside of column selection
in step functions.
}
\examples{
library(modeldata)
data(biomass)

rec <- recipe(biomass) \%>\%
  update_role(
    carbon, hydrogen, oxygen, nitrogen, sulfur,
    new_role = "predictor"
  ) \%>\%
  update_role(HHV, new_role = "outcome") \%>\%
  update_role(sample, new_role = "id variable") \%>\%
  update_role(dataset, new_role = "splitting indicator")

recipe_info <- summary(rec)
recipe_info

# Centering on all predictors except carbon
rec \%>\%
  step_center(all_predictors(), -carbon) \%>\%
  prep(training = biomass) \%>\%
  bake(new_data = NULL)

}
