% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stash.R
\name{stash}
\alias{stash}
\title{Stash}
\usage{
stash(repo = ".", message = as.character(Sys.time()), index = FALSE,
  untracked = FALSE, ignored = FALSE, stasher = NULL)
}
\arguments{
\item{repo}{a path to a repository or a \code{git_repository}
object. Default is '.'}

\item{message}{Optional description. Defaults to current time.}

\item{index}{All changes already added to the index are left
intact in the working directory. Default is FALSE}

\item{untracked}{All untracked files are also stashed and then
cleaned up from the working directory. Default is FALSE}

\item{ignored}{All ignored files are also stashed and then cleaned
up from the working directory. Default is FALSE}

\item{stasher}{Signature with stasher and time of stash}
}
\value{
invisible \code{git_stash} object if anything to stash
    else NULL
}
\description{
Stash
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

# Configure a user
config(repo, user.name="Alice", user.email="alice@example.org")

# Create a file, add and commit
writeLines("Hello world!", file.path(path, "test.txt"))
add(repo, 'test.txt')
commit(repo, "Commit message")

# Change file
writeLines(c("Hello world!", "HELLO WORLD!"), file.path(path, "test.txt"))

# Check status of repository
status(repo)

# Create stash in repository
stash(repo)

# Check status of repository
status(repo)

# View stash
stash_list(repo)
}
}
