% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comps.R
\name{comps}
\alias{comps}
\alias{components}
\alias{comps.dist}
\alias{comps.kNN}
\alias{comps.sNN}
\alias{comps.frNN}
\title{Find Connected Components in a Nearest-neighbor Graph}
\usage{
comps(x, ...)

\method{comps}{dist}(x, eps, ...)

\method{comps}{kNN}(x, mutual = FALSE, ...)

\method{comps}{sNN}(x, ...)

\method{comps}{frNN}(x, ...)
}
\arguments{
\item{x}{the \link{NN} object representing the graph or a \link{dist} object}

\item{...}{further arguments are currently unused.}

\item{eps}{threshold on the distance}

\item{mutual}{for a pair of points, do both have to be in each other's neighborhood?}
}
\value{
an integer vector with component assignments.
}
\description{
Generic function and methods to find connected components in nearest neighbor graphs.
}
\details{
Note that for kNN graphs, one point may be in the kNN of the other but nor vice versa.
\code{mutual = TRUE} requires that both points are in each other's kNN.
}
\examples{
set.seed(665544)
n <- 100
x <- cbind(
  x=runif(10, 0, 5) + rnorm(n, sd = 0.4),
  y=runif(10, 0, 5) + rnorm(n, sd = 0.4)
  )
plot(x, pch = 16)

# Connected components on a graph where each pair of points
# with a distance less or equal to eps are connected
d <- dist(x)
components <- comps(d, eps = .8)
plot(x, col = components, pch = 16)

# Connected components in a fixed radius nearest neighbor graph
# Gives the same result as the threshold on the distances above
frnn <- frNN(x, eps = .8)
components <- comps(frnn)
plot(frnn, data = x, col = components)

# Connected components on a k nearest neighbors graph
knn <- kNN(x, 3)
components <- comps(knn, mutual = FALSE)
plot(knn, data = x, col = components)

components <- comps(knn, mutual = TRUE)
plot(knn, data = x, col = components)

# Connected components in a shared nearest neighbor graph
snn <- sNN(x, k = 10, kt = 5)
components <- comps(snn)
plot(snn, data = x, col = components)
}
\seealso{
Other NN functions: 
\code{\link{NN}},
\code{\link{frNN}()},
\code{\link{kNN}()},
\code{\link{kNNdist}()},
\code{\link{sNN}()}
}
\author{
Michael Hahsler
}
\concept{NN functions}
\keyword{model}
