% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-failure-modes.R
\name{separate_failure_modes}
\alias{separate_failure_modes}
\title{Separate multiple failure modes into multiple rows}
\usage{
separate_failure_modes(data, failure_mode, sep = "[/, ]+")
}
\arguments{
\item{data}{a \code{data.frame}}

\item{failure_mode}{the column in \code{data} containing the failure modes}

\item{sep}{a regular expression with the character(s) separating individual
failure modes. Default \code{"[/, ]+"}.}
}
\description{
For a \code{data.frame} containing a column with (some) multiple failure modes,
this function expands the \code{data.frame} by repeating each row with multiple
failure modes so that each row contains only a single failure mode.
}
\details{
When multiple failure modes are reported, they are commonly reported in
the format "LGM/GIT" or "LGM,GIT". This function will separate these multiple
failure modes into multiple rows.

This can be useful when counting the number of coupons exhibited each
failure mode.
}
\examples{
library(dplyr)
data.frame(strength = c(101, 102), fm = c("LGM/GIT", "LGM")) \%>\%
  separate_failure_modes(fm)
##
## # A tibble: 3 × 2
##   strength fm
##      <dbl> <chr>
## 1      101 LGM
## 2      101 GIT
## 3      102 LGM

}
