% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/navbar_options.R
\name{navbar_options}
\alias{navbar_options}
\title{Create a set of navbar options}
\usage{
navbar_options(
  ...,
  position = c("static-top", "fixed-top", "fixed-bottom"),
  bg = NULL,
  theme = c("auto", "light", "dark"),
  collapsible = TRUE,
  underline = TRUE
)
}
\arguments{
\item{...}{Additional attributes that will be passed directly to the navbar
container element.}

\item{position}{Determines whether the navbar should be displayed at the top
of the page with normal scrolling behavior (\code{"static-top"}), pinned at
the top (\code{"fixed-top"}), or pinned at the bottom
(\code{"fixed-bottom"}). Note that using \code{"fixed-top"} or
\code{"fixed-bottom"} will cause the navbar to overlay your body content,
unless you add padding, e.g.: \code{tags$style(type="text/css", "body
  {padding-top: 70px;}")}}

\item{bg}{a CSS color to use for the navbar's background color.}

\item{theme}{Either \code{"dark"} for a light text color (on a \strong{dark}
background) or \code{"light"} for a dark text color (on a \strong{light} background).
If \code{"auto"} (the default) and \code{bg} is provided, the best contrast to \code{bg}
is chosen.}

\item{collapsible}{\code{TRUE} to automatically collapse the navigation
elements into an expandable menu on mobile devices or narrow window widths.}

\item{underline}{Whether or not to add underline styling to page or navbar
links when active or focused.}
}
\value{
Returns a list of navbar options.
}
\description{
A \code{navbar_options()} object captures options specific to the appearance and
behavior of the navbar, independent from the content displayed on the page.
This helper should be used to create the list of options expected by
\code{navbar_options} in \code{\link[=page_navbar]{page_navbar()}} and \code{\link[=navset_bar]{navset_bar()}}.
}
\details{
\subsection{Navbar style with Bootstrap 5 and Bootswatch themes}{

In \pkg{bslib} v0.9.0, the default navbar colors for Bootswatch themes with
Bootstrap 5 changed. Prior to v0.9.0, bslib pre-selected navbar background
colors in light and dark mode; after v0.9.0 the default navbar colors are
less opinionated by default and follow light or dark mode (see
\code{\link[=input_dark_mode]{input_dark_mode()}}).

You can use \code{navbar_options()} to adjust the colors of the navbar when using
a Bootswatch preset theme with Bootstrap 5. For example, the \href{https://bootswatch.com/flatly/}{Bootswatch documentation for the Flatly theme} shows
4 navbar variations. Inspecting the source code for the first example reveals
the following markup:

\if{html}{\out{<div class="sourceCode html">}}\preformatted{<nav class="navbar navbar-expand-lg bg-primary" data-bs-theme="dark">
  <!-- all of the navbar html -->
</nav>
}\if{html}{\out{</div>}}

Note that this navbar uses the \code{bg-primary} class for a dark navy background.
The navbar's white text is controlled by the \code{data-bs-theme="dark"}
attribute, which is used by Bootstrap for light text on a \emph{dark} background.
In \pkg{bslib}, you can achieve this look with:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{ui <- page_navbar(
  theme = bs_theme(5, "flatly"),
  navbar_options = navbar_options(class = "bg-primary", theme = "dark")
)
}\if{html}{\out{</div>}}

This particular combination of \code{class = "bg-primary"} and \code{theme = "dark"}
works well for most Bootswatch presets.

Another variation from the Flatly documentation features a navar with dark
text on a light background:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{ui <- page_navbar(
  theme = bs_theme(5, "flatly"),
  navbar_options = navbar_options(class = "bg-light", theme = "light")
)
}\if{html}{\out{</div>}}

The above options set navbar foreground and background colors that are always
the same in both light and dark modes. To customize the navbar colors used in
light or dark mode, you can use the \verb{$navbar-light-bg} and \verb{$navbar-dark-bg}
Sass variables. When provided, bslib will automatically choose to use
light or dark text as the foreground color.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{ui <- page_navbar(
  theme = bs_theme(
    5,
    preset = "flatly",
    navbar_light_bg = "#18BC9C", # flatly's success color (teal)
    navbar_dark_bg = "#2C3E50"   # flatly's primary color (navy)
  )
)
}\if{html}{\out{</div>}}

Finally, you can also use the \verb{$navbar-bg} Sass variable to set the navbar
background color for both light and dark modes:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{ui <- page_navbar(
  theme = bs_theme(
    5,
    preset = "flatly",
    navbar_bg = "#E74C3C" # flatly's danger color (red)
  )
)
}\if{html}{\out{</div>}}
}
}
\section{Changelog}{


This function was introduced in \pkg{bslib} v0.9.0, replacing the \code{position},
\code{bg}, \code{inverse}, \code{collapsible} and \code{underline} arguments of \code{\link[=page_navbar]{page_navbar()}}
and \code{\link[=navset_bar]{navset_bar()}}. Those arguments are deprecated with a warning and will be
removed in a future version of \pkg{bslib}. Note that the deprecated
\code{inverse} argument of \code{\link[=page_navbar]{page_navbar()}} and \code{\link[=navset_bar]{navset_bar()}} was replaced with
the \code{theme} argument of \code{navbar_options()}.
}

\examples{
navbar_options(position = "static-top", bg = "#2e9f7d", underline = FALSE)

}
