% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmnet_tidiers.R
\name{glmnet_tidiers}
\alias{glmnet_tidiers}
\alias{tidy.glmnet}
\alias{glance.glmnet}
\title{Tidiers for LASSO or elasticnet regularized fits}
\usage{
\method{tidy}{glmnet}(x, ...)

\method{glance}{glmnet}(x, ...)
}
\arguments{
\item{x}{a "glmnet" object}

\item{...}{extra arguments (not used)}
}
\value{
All tidying methods return a data.frame without rownames, whose
structure depends on the method chosen.

\code{tidy} produces a data.frame with one row per combination of
coefficient (including the intercept) and value of lambda for which the estimate
is nonzero, with the columns:
  \item{term}{coefficient name (V1...VN by default, along with
  "(Intercept)")}
  \item{step}{which step of lambda choices was used}
  \item{estimate}{estimate of coefficient}
  \item{lambda}{value of penalty parameter lambda}
  \item{dev.ratio}{fraction of null deviance explained at each
  value of lambda}

\code{glance} returns a one-row data.frame with the values
  \item{nulldev}{null deviance}
  \item{npasses}{total passes over the data across all lambda values}
}
\description{
Tidying methods for regularized fits produced by \code{glmnet}, summarizing
the estimates across values of the penalty parameter lambda.
}
\details{
Note that while this representation of GLMs is much easier
to plot and combine than the default structure, it is also much
more memory-intensive. Do not use for extremely large, sparse matrices.

No \code{augment} method is yet provided even though the model produces
predictions, because the input data is not tidy (it is a matrix that
may be very wide) and therefore combining predictions with it is not
logical. Furthermore, predictions make sense only with a specific
choice of lambda.
}
\examples{

if (require("glmnet", quietly = TRUE)) {
    set.seed(2014)
    x <- matrix(rnorm(100*20),100,20)
    y <- rnorm(100)
    fit1 <- glmnet(x,y)
    
    head(tidy(fit1))
    glance(fit1)
    
    library(dplyr)
    library(ggplot2)
    
    tidied <- tidy(fit1) \%>\% filter(term != "(Intercept)")
    
    ggplot(tidied, aes(step, estimate, group = term)) + geom_line()
    ggplot(tidied, aes(lambda, estimate, group = term)) +
        geom_line() + scale_x_log10()
 
    ggplot(tidied, aes(lambda, dev.ratio)) + geom_line()
    
    # works for other types of regressions as well, such as logistic
    g2 <- sample(1:2, 100, replace=TRUE)
    fit2 <- glmnet(x, g2, family="binomial")
    head(tidy(fit2))
}

}
