% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-dataset-converters.R
\name{convert_f_defaults}
\alias{convert_f_defaults}
\title{Rename columns and add defaults values if column not present}
\usage{
convert_f_defaults(.data, ..., .def_col_val = c(), .use_dots = TRUE)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g. a tibble), or a
lazy data frame (e.g. from dbplyr or dtplyr). See \emph{Methods}, below, for
more details.}

\item{...}{For \code{rename()}: <\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Use
\code{new_name = old_name} to rename selected variables.

For \code{rename_with()}: additional arguments passed onto \code{.fn}.}

\item{.def_col_val}{Named vector with columns with default values
if none exist after rename.}

\item{.use_dots}{Should a dot prefix be added to renamed variables?
This will allow swapping of columns.}
}
\value{
An object of the same type as .data. The output has the following properties:
\itemize{
\item Rows are not affected.
\item Column names are changed.
\item Column order is the same as that of the function call.
}
}
\description{
\code{convert_f_defaults()} combine the \code{\link[dplyr:rename]{dplyr::rename()}} way of
working and with the \code{\link[tibble:add_column]{tibble::add_column()}} to add columns
with default values in case they don't exist after renaming data.
}
\details{
The objective of using .use_dots is to be able to swap columns which,
by default, is not allowed by the \code{\link[dplyr:rename]{dplyr::rename()}} function.
The same behavior can be replicated by simply using the \code{\link[dplyr:select]{dplyr::select()}},
however, the select evaluation allows much more flexibility so that
unexpected results could be obtained. Despite this, a future implementation
will consider this form of execution to allow renaming the same
column to multiple ones (i.e. extend dataframe extension).
}
\examples{

df <- tibble::tibble(x = 1, y = 2, z = 3)

# Rename columns
df <- tibble::tibble(x = 1, y = 2)
convert_f_defaults(
    .data = df,
    new_x = x,
    new_y = y,
    new_z = NULL,
    .def_col_val = c(new_z = 3)
)
}
