/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#ifndef TREEMODEL_H
#define TREEMODEL_H

#include <QAbstractItemModel>

class TreeItem;
class MsgsHistory;

/**
	@author Anistratov Oleg <ower86@gmail.com>
*/
class TreeModel : public QAbstractItemModel
{
  Q_OBJECT
  private:
    TreeItem* m_rootItem;

  public:
    TreeModel(QObject *parent = 0);
    ~TreeModel();

    Qt::ItemFlags flags    (const QModelIndex &index) const;
    QVariant    data       (const QModelIndex &index, int role) const;
    QVariant    headerData (int section, Qt::Orientation orientation, int role = Qt::DisplayRole) const;
    QModelIndex index      (int row, int column, const QModelIndex &parent = QModelIndex()) const;
    QModelIndex parent     (const QModelIndex &index) const;
    int         rowCount   (const QModelIndex &parent = QModelIndex()) const;
    int         columnCount(const QModelIndex &parent = QModelIndex()) const;

    TreeItem* rootItem() const {return m_rootItem;}
    void setRootItem(TreeItem* item){m_rootItem = item;}

    void appendToRoot(TreeItem*);

    void clear();

  protected:
    virtual TreeItem* createRootItem() = 0;
};

#endif
