"""
This is a automatically generated file from the 2014 NIST fundamental constants.
Title: NIST-CODATA Internationally Recommended 2014 Values of the Fundamental Physical Constants - SRD 121
Date: 2014-01-01
DOI: 10.18434/T4WW24
URL: http://www.nist.gov/srd/srd_data/srd121_allascii_2014.json
Access Date: 2018-09-26 22:11:02.928442 UTC

File Authors: QCElemental Authors
"""

nist_2014_codata = {
    'title':
    'NIST-CODATA Internationally Recommended 2014 Values of the Fundamental Physical Constants - SRD 121',
    'date':
    '2014-01-01',
    'doi':
    '10.18434/T4WW24',
    'url':
    'http://www.nist.gov/srd/srd_data/srd121_allascii_2014.json',
    'access_data':
    '2018-09-26 22:11:02.928442',
    'constants': {
        '{220} lattice spacing of silicon': {
            'quantity': '{220} lattice spacing of silicon',
            'unit': 'm',
            'value': '192.0155714e-12',
            'uncertainty': '0.000 0032 e-12'
        },
        'alpha particle-electron mass ratio': {
            'quantity': 'alpha particle-electron mass ratio',
            'unit': '',
            'value': '7294.29954136',
            'uncertainty': '0.000 000 24'
        },
        'alpha particle mass': {
            'quantity': 'alpha particle mass',
            'unit': 'kg',
            'value': '6.644657230e-27',
            'uncertainty': '0.000 000 082 e-27'
        },
        'alpha particle mass energy equivalent': {
            'quantity': 'alpha particle mass energy equivalent',
            'unit': 'J',
            'value': '5.971920097e-10',
            'uncertainty': '0.000 000 073 e-10'
        },
        'alpha particle mass energy equivalent in mev': {
            'quantity': 'alpha particle mass energy equivalent in MeV',
            'unit': 'MeV',
            'value': '3727.379378',
            'uncertainty': '0.000 023'
        },
        'alpha particle mass in u': {
            'quantity': 'alpha particle mass in u',
            'unit': 'u',
            'value': '4.001506179127',
            'uncertainty': '0.000 000 000 063'
        },
        'alpha particle molar mass': {
            'quantity': 'alpha particle molar mass',
            'unit': 'kg mol^{-1}',
            'value': '4.001506179127e-3',
            'uncertainty': '0.000 000 000 063 e-3'
        },
        'alpha particle-proton mass ratio': {
            'quantity': 'alpha particle-proton mass ratio',
            'unit': '',
            'value': '3.97259968907',
            'uncertainty': '0.000 000 000 36'
        },
        'angstrom star': {
            'quantity': 'Angstrom star',
            'unit': 'm',
            'value': '1.00001495e-10',
            'uncertainty': '0.000 000 90 e-10'
        },
        'atomic mass constant': {
            'quantity': 'atomic mass constant',
            'unit': 'kg',
            'value': '1.660539040e-27',
            'uncertainty': '0.000 000 020 e-27'
        },
        'atomic mass constant energy equivalent': {
            'quantity': 'atomic mass constant energy equivalent',
            'unit': 'J',
            'value': '1.492418062e-10',
            'uncertainty': '0.000 000 018 e-10'
        },
        'atomic mass constant energy equivalent in mev': {
            'quantity': 'atomic mass constant energy equivalent in MeV',
            'unit': 'MeV',
            'value': '931.4940954',
            'uncertainty': '0.000 0057'
        },
        'atomic mass unit-electron volt relationship': {
            'quantity': 'atomic mass unit-electron volt relationship',
            'unit': 'eV',
            'value': '931.4940954e6',
            'uncertainty': '0.000 0057 e6'
        },
        'atomic mass unit-hartree relationship': {
            'quantity': 'atomic mass unit-hartree relationship',
            'unit': 'E_h',
            'value': '3.4231776902e7',
            'uncertainty': '0.000 000 0016 e7'
        },
        'atomic mass unit-hertz relationship': {
            'quantity': 'atomic mass unit-hertz relationship',
            'unit': 'Hz',
            'value': '2.2523427206e23',
            'uncertainty': '0.000 000 0010 e23'
        },
        'atomic mass unit-inverse meter relationship': {
            'quantity': 'atomic mass unit-inverse meter relationship',
            'unit': 'm^{-1}',
            'value': '7.5130066166e14',
            'uncertainty': '0.000 000 0034 e14'
        },
        'atomic mass unit-joule relationship': {
            'quantity': 'atomic mass unit-joule relationship',
            'unit': 'J',
            'value': '1.492418062e-10',
            'uncertainty': '0.000 000 018 e-10'
        },
        'atomic mass unit-kelvin relationship': {
            'quantity': 'atomic mass unit-kelvin relationship',
            'unit': 'K',
            'value': '1.08095438e13',
            'uncertainty': '0.000 000 62 e13'
        },
        'atomic mass unit-kilogram relationship': {
            'quantity': 'atomic mass unit-kilogram relationship',
            'unit': 'kg',
            'value': '1.660539040e-27',
            'uncertainty': '0.000 000 020 e-27'
        },
        'atomic unit of 1st hyperpolarizability': {
            'quantity': 'atomic unit of 1st hyperpolarizability',
            'unit': 'C^3 m^3 J^{-2}',
            'value': '3.206361329e-53',
            'uncertainty': '0.000 000 020 e-53'
        },
        'atomic unit of 2nd hyperpolarizability': {
            'quantity': 'atomic unit of 2nd hyperpolarizability',
            'unit': 'C^4 m^4 J^{-3}',
            'value': '6.235380085e-65',
            'uncertainty': '0.000 000 077 e-65'
        },
        'atomic unit of action': {
            'quantity': 'atomic unit of action',
            'unit': 'J s',
            'value': '1.054571800e-34',
            'uncertainty': '0.000 000 013 e-34'
        },
        'atomic unit of charge': {
            'quantity': 'atomic unit of charge',
            'unit': 'C',
            'value': '1.6021766208e-19',
            'uncertainty': '0.000 000 0098 e-19'
        },
        'atomic unit of charge density': {
            'quantity': 'atomic unit of charge density',
            'unit': 'C m^{-3}',
            'value': '1.0812023770e12',
            'uncertainty': '0.000 000 0067 e12'
        },
        'atomic unit of current': {
            'quantity': 'atomic unit of current',
            'unit': 'A',
            'value': '6.623618183e-3',
            'uncertainty': '0.000 000 041 e-3'
        },
        'atomic unit of electric dipole mom.': {
            'quantity': 'atomic unit of electric dipole mom.',
            'unit': 'C m',
            'value': '8.478353552e-30',
            'uncertainty': '0.000 000 052 e-30'
        },
        'atomic unit of electric field': {
            'quantity': 'atomic unit of electric field',
            'unit': 'V m^{-1}',
            'value': '5.142206707e11',
            'uncertainty': '0.000 000 032 e11'
        },
        'atomic unit of electric field gradient': {
            'quantity': 'atomic unit of electric field gradient',
            'unit': 'V m^{-2}',
            'value': '9.717362356e21',
            'uncertainty': '0.000 000 060 e21'
        },
        'atomic unit of electric polarizability': {
            'quantity': 'atomic unit of electric polarizability',
            'unit': 'C^2 m^2 J^{-1}',
            'value': '1.6487772731e-41',
            'uncertainty': '0.000 000 0011 e-41'
        },
        'atomic unit of electric potential': {
            'quantity': 'atomic unit of electric potential',
            'unit': 'V',
            'value': '27.21138602',
            'uncertainty': '0.000 000 17'
        },
        'atomic unit of electric quadrupole mom.': {
            'quantity': 'atomic unit of electric quadrupole mom.',
            'unit': 'C m^2',
            'value': '4.486551484e-40',
            'uncertainty': '0.000 000 028 e-40'
        },
        'atomic unit of energy': {
            'quantity': 'atomic unit of energy',
            'unit': 'J',
            'value': '4.359744650e-18',
            'uncertainty': '0.000 000 054 e-18'
        },
        'atomic unit of force': {
            'quantity': 'atomic unit of force',
            'unit': 'N',
            'value': '8.23872336e-8',
            'uncertainty': '0.000 000 10 e-8'
        },
        'atomic unit of length': {
            'quantity': 'atomic unit of length',
            'unit': 'm',
            'value': '0.52917721067e-10',
            'uncertainty': '0.000 000 000 12 e-10'
        },
        'atomic unit of mag. dipole mom.': {
            'quantity': 'atomic unit of mag. dipole mom.',
            'unit': 'J T^{-1}',
            'value': '1.854801999e-23',
            'uncertainty': '0.000 000 011 e-23'
        },
        'atomic unit of mag. flux density': {
            'quantity': 'atomic unit of mag. flux density',
            'unit': 'T',
            'value': '2.350517550e5',
            'uncertainty': '0.000 000 014 e5'
        },
        'atomic unit of magnetizability': {
            'quantity': 'atomic unit of magnetizability',
            'unit': 'J T^{-2}',
            'value': '7.8910365886e-29',
            'uncertainty': '0.000 000 0090 e-29'
        },
        'atomic unit of mass': {
            'quantity': 'atomic unit of mass',
            'unit': 'kg',
            'value': '9.10938356e-31',
            'uncertainty': '0.000 000 11 e-31'
        },
        'atomic unit of mom.um': {
            'quantity': 'atomic unit of mom.um',
            'unit': 'kg m s^{-1}',
            'value': '1.992851882e-24',
            'uncertainty': '0.000 000 024 e-24'
        },
        'atomic unit of permittivity': {
            'quantity': 'atomic unit of permittivity',
            'unit': 'F m^{-1}',
            'value': '1.112650056e-10',
            'uncertainty': '(exact)'
        },
        'atomic unit of time': {
            'quantity': 'atomic unit of time',
            'unit': 's',
            'value': '2.418884326509e-17',
            'uncertainty': '0.000 000 000 014 e-17'
        },
        'atomic unit of velocity': {
            'quantity': 'atomic unit of velocity',
            'unit': 'm s^{-1}',
            'value': '2.18769126277e6',
            'uncertainty': '0.000 000 000 50 e6'
        },
        'avogadro constant': {
            'quantity': 'Avogadro constant',
            'unit': 'mol^{-1}',
            'value': '6.022140857e23',
            'uncertainty': '0.000 000 074 e23'
        },
        'bohr magneton': {
            'quantity': 'Bohr magneton',
            'unit': 'J T^{-1}',
            'value': '927.4009994e-26',
            'uncertainty': '0.000 0057 e-26'
        },
        'bohr magneton in ev/t': {
            'quantity': 'Bohr magneton in eV/T',
            'unit': 'eV T^{-1}',
            'value': '5.7883818012e-5',
            'uncertainty': '0.000 000 0026 e-5'
        },
        'bohr magneton in hz/t': {
            'quantity': 'Bohr magneton in Hz/T',
            'unit': 'Hz T^{-1}',
            'value': '13.996245042e9',
            'uncertainty': '0.000 000 086 e9'
        },
        'bohr magneton in inverse meters per tesla': {
            'quantity': 'Bohr magneton in inverse meters per tesla',
            'unit': 'm^{-1} T^{-1}',
            'value': '46.68644814',
            'uncertainty': '0.000 000 29'
        },
        'bohr magneton in k/t': {
            'quantity': 'Bohr magneton in K/T',
            'unit': 'K T^{-1}',
            'value': '0.67171405',
            'uncertainty': '0.000 000 39'
        },
        'bohr radius': {
            'quantity': 'Bohr radius',
            'unit': 'm',
            'value': '0.52917721067e-10',
            'uncertainty': '0.000 000 000 12 e-10'
        },
        'boltzmann constant': {
            'quantity': 'Boltzmann constant',
            'unit': 'J K^{-1}',
            'value': '1.38064852e-23',
            'uncertainty': '0.000 000 79 e-23'
        },
        'boltzmann constant in ev/k': {
            'quantity': 'Boltzmann constant in eV/K',
            'unit': 'eV K^{-1}',
            'value': '8.6173303e-5',
            'uncertainty': '0.000 0050 e-5'
        },
        'boltzmann constant in hz/k': {
            'quantity': 'Boltzmann constant in Hz/K',
            'unit': 'Hz K^{-1}',
            'value': '2.0836612e10',
            'uncertainty': '0.000 0012 e10'
        },
        'boltzmann constant in inverse meters per kelvin': {
            'quantity': 'Boltzmann constant in inverse meters per kelvin',
            'unit': 'm^{-1} K^{-1}',
            'value': '69.503457',
            'uncertainty': '0.000 040'
        },
        'characteristic impedance of vacuum': {
            'quantity': 'characteristic impedance of vacuum',
            'unit': 'ohm',
            'value': '376.730313461',
            'uncertainty': '(exact)'
        },
        'classical electron radius': {
            'quantity': 'classical electron radius',
            'unit': 'm',
            'value': '2.8179403227e-15',
            'uncertainty': '0.000 000 0019 e-15'
        },
        'compton wavelength': {
            'quantity': 'Compton wavelength',
            'unit': 'm',
            'value': '2.4263102367e-12',
            'uncertainty': '0.000 000 0011 e-12'
        },
        'compton wavelength over 2 pi': {
            'quantity': 'Compton wavelength over 2 pi',
            'unit': 'm',
            'value': '386.15926764e-15',
            'uncertainty': '0.000 000 18 e-15'
        },
        'conductance quantum': {
            'quantity': 'conductance quantum',
            'unit': 'S',
            'value': '7.7480917310e-5',
            'uncertainty': '0.000 000 0018 e-5'
        },
        'conventional value of josephson constant': {
            'quantity': 'conventional value of Josephson constant',
            'unit': 'Hz V^{-1}',
            'value': '483597.9e9',
            'uncertainty': '(exact)'
        },
        'conventional value of von klitzing constant': {
            'quantity': 'conventional value of von Klitzing constant',
            'unit': 'ohm',
            'value': '25812.807',
            'uncertainty': '(exact)'
        },
        'cu x unit': {
            'quantity': 'Cu x unit',
            'unit': 'm',
            'value': '1.00207697e-13',
            'uncertainty': '0.000 000 28 e-13'
        },
        'deuteron-electron mag. mom. ratio': {
            'quantity': 'deuteron-electron mag. mom. ratio',
            'unit': '',
            'value': '-4.664345535e-4',
            'uncertainty': '0.000 000 026 e-4'
        },
        'deuteron-electron mass ratio': {
            'quantity': 'deuteron-electron mass ratio',
            'unit': '',
            'value': '3670.48296785',
            'uncertainty': '0.000 000 13'
        },
        'deuteron g factor': {
            'quantity': 'deuteron g factor',
            'unit': '',
            'value': '0.8574382311',
            'uncertainty': '0.000 000 0048'
        },
        'deuteron mag. mom.': {
            'quantity': 'deuteron mag. mom.',
            'unit': 'J T^{-1}',
            'value': '0.4330735040e-26',
            'uncertainty': '0.000 000 0036 e-26'
        },
        'deuteron mag. mom. to bohr magneton ratio': {
            'quantity': 'deuteron mag. mom. to Bohr magneton ratio',
            'unit': '',
            'value': '0.4669754554e-3',
            'uncertainty': '0.000 000 0026 e-3'
        },
        'deuteron mag. mom. to nuclear magneton ratio': {
            'quantity': 'deuteron mag. mom. to nuclear magneton ratio',
            'unit': '',
            'value': '0.8574382311',
            'uncertainty': '0.000 000 0048'
        },
        'deuteron mass': {
            'quantity': 'deuteron mass',
            'unit': 'kg',
            'value': '3.343583719e-27',
            'uncertainty': '0.000 000 041 e-27'
        },
        'deuteron mass energy equivalent': {
            'quantity': 'deuteron mass energy equivalent',
            'unit': 'J',
            'value': '3.005063183e-10',
            'uncertainty': '0.000 000 037 e-10'
        },
        'deuteron mass energy equivalent in mev': {
            'quantity': 'deuteron mass energy equivalent in MeV',
            'unit': 'MeV',
            'value': '1875.612928',
            'uncertainty': '0.000 012'
        },
        'deuteron mass in u': {
            'quantity': 'deuteron mass in u',
            'unit': 'u',
            'value': '2.013553212745',
            'uncertainty': '0.000 000 000 040'
        },
        'deuteron molar mass': {
            'quantity': 'deuteron molar mass',
            'unit': 'kg mol^{-1}',
            'value': '2.013553212745e-3',
            'uncertainty': '0.000 000 000 040 e-3'
        },
        'deuteron-neutron mag. mom. ratio': {
            'quantity': 'deuteron-neutron mag. mom. ratio',
            'unit': '',
            'value': '-0.44820652',
            'uncertainty': '0.000 000 11'
        },
        'deuteron-proton mag. mom. ratio': {
            'quantity': 'deuteron-proton mag. mom. ratio',
            'unit': '',
            'value': '0.3070122077',
            'uncertainty': '0.000 000 0015'
        },
        'deuteron-proton mass ratio': {
            'quantity': 'deuteron-proton mass ratio',
            'unit': '',
            'value': '1.99900750087',
            'uncertainty': '0.000 000 000 19'
        },
        'deuteron rms charge radius': {
            'quantity': 'deuteron rms charge radius',
            'unit': 'm',
            'value': '2.1413e-15',
            'uncertainty': '0.0025 e-15'
        },
        'electric constant': {
            'quantity': 'electric constant',
            'unit': 'F m^{-1}',
            'value': '8.854187817e-12',
            'uncertainty': '(exact)'
        },
        'electron charge to mass quotient': {
            'quantity': 'electron charge to mass quotient',
            'unit': 'C kg^{-1}',
            'value': '-1.758820024e11',
            'uncertainty': '0.000 000 011 e11'
        },
        'electron-deuteron mag. mom. ratio': {
            'quantity': 'electron-deuteron mag. mom. ratio',
            'unit': '',
            'value': '-2143.923499',
            'uncertainty': '0.000 012'
        },
        'electron-deuteron mass ratio': {
            'quantity': 'electron-deuteron mass ratio',
            'unit': '',
            'value': '2.724437107484e-4',
            'uncertainty': '0.000 000 000 096 e-4'
        },
        'electron g factor': {
            'quantity': 'electron g factor',
            'unit': '',
            'value': '-2.00231930436182',
            'uncertainty': '0.000 000 000 000 52'
        },
        'electron gyromag. ratio': {
            'quantity': 'electron gyromag. ratio',
            'unit': 's^{-1} T^{-1}',
            'value': '1.760859644e11',
            'uncertainty': '0.000 000 011 e11'
        },
        'electron gyromag. ratio over 2 pi': {
            'quantity': 'electron gyromag. ratio over 2 pi',
            'unit': 'MHz T^{-1}',
            'value': '28024.95164',
            'uncertainty': '0.000 17'
        },
        'electron-helion mass ratio': {
            'quantity': 'electron-helion mass ratio',
            'unit': '',
            'value': '1.819543074854e-4',
            'uncertainty': '0.000 000 000 088 e-4'
        },
        'electron mag. mom.': {
            'quantity': 'electron mag. mom.',
            'unit': 'J T^{-1}',
            'value': '-928.4764620e-26',
            'uncertainty': '0.000 0057 e-26'
        },
        'electron mag. mom. anomaly': {
            'quantity': 'electron mag. mom. anomaly',
            'unit': '',
            'value': '1.15965218091e-3',
            'uncertainty': '0.000 000 000 26 e-3'
        },
        'electron mag. mom. to bohr magneton ratio': {
            'quantity': 'electron mag. mom. to Bohr magneton ratio',
            'unit': '',
            'value': '-1.00115965218091',
            'uncertainty': '0.000 000 000 000 26'
        },
        'electron mag. mom. to nuclear magneton ratio': {
            'quantity': 'electron mag. mom. to nuclear magneton ratio',
            'unit': '',
            'value': '-1838.28197234',
            'uncertainty': '0.000 000 17'
        },
        'electron mass': {
            'quantity': 'electron mass',
            'unit': 'kg',
            'value': '9.10938356e-31',
            'uncertainty': '0.000 000 11 e-31'
        },
        'electron mass energy equivalent': {
            'quantity': 'electron mass energy equivalent',
            'unit': 'J',
            'value': '8.18710565e-14',
            'uncertainty': '0.000 000 10 e-14'
        },
        'electron mass energy equivalent in mev': {
            'quantity': 'electron mass energy equivalent in MeV',
            'unit': 'MeV',
            'value': '0.5109989461',
            'uncertainty': '0.000 000 0031'
        },
        'electron mass in u': {
            'quantity': 'electron mass in u',
            'unit': 'u',
            'value': '5.48579909070e-4',
            'uncertainty': '0.000 000 000 16 e-4'
        },
        'electron molar mass': {
            'quantity': 'electron molar mass',
            'unit': 'kg mol^{-1}',
            'value': '5.48579909070e-7',
            'uncertainty': '0.000 000 000 16 e-7'
        },
        'electron-muon mag. mom. ratio': {
            'quantity': 'electron-muon mag. mom. ratio',
            'unit': '',
            'value': '206.7669880',
            'uncertainty': '0.000 0046'
        },
        'electron-muon mass ratio': {
            'quantity': 'electron-muon mass ratio',
            'unit': '',
            'value': '4.83633170e-3',
            'uncertainty': '0.000 000 11 e-3'
        },
        'electron-neutron mag. mom. ratio': {
            'quantity': 'electron-neutron mag. mom. ratio',
            'unit': '',
            'value': '960.92050',
            'uncertainty': '0.000 23'
        },
        'electron-neutron mass ratio': {
            'quantity': 'electron-neutron mass ratio',
            'unit': '',
            'value': '5.4386734428e-4',
            'uncertainty': '0.000 000 0027 e-4'
        },
        'electron-proton mag. mom. ratio': {
            'quantity': 'electron-proton mag. mom. ratio',
            'unit': '',
            'value': '-658.2106866',
            'uncertainty': '0.000 0020'
        },
        'electron-proton mass ratio': {
            'quantity': 'electron-proton mass ratio',
            'unit': '',
            'value': '5.44617021352e-4',
            'uncertainty': '0.000 000 000 52 e-4'
        },
        'electron-tau mass ratio': {
            'quantity': 'electron-tau mass ratio',
            'unit': '',
            'value': '2.87592e-4',
            'uncertainty': '0.000 26 e-4'
        },
        'electron to alpha particle mass ratio': {
            'quantity': 'electron to alpha particle mass ratio',
            'unit': '',
            'value': '1.370933554798e-4',
            'uncertainty': '0.000 000 000 045 e-4'
        },
        'electron to shielded helion mag. mom. ratio': {
            'quantity': 'electron to shielded helion mag. mom. ratio',
            'unit': '',
            'value': '864.058257',
            'uncertainty': '0.000 010'
        },
        'electron to shielded proton mag. mom. ratio': {
            'quantity': 'electron to shielded proton mag. mom. ratio',
            'unit': '',
            'value': '-658.2275971',
            'uncertainty': '0.000 0072'
        },
        'electron-triton mass ratio': {
            'quantity': 'electron-triton mass ratio',
            'unit': '',
            'value': '1.819200062203e-4',
            'uncertainty': '0.000 000 000 084 e-4'
        },
        'electron volt': {
            'quantity': 'electron volt',
            'unit': 'J',
            'value': '1.6021766208e-19',
            'uncertainty': '0.000 000 0098 e-19'
        },
        'electron volt-atomic mass unit relationship': {
            'quantity': 'electron volt-atomic mass unit relationship',
            'unit': 'u',
            'value': '1.0735441105e-9',
            'uncertainty': '0.000 000 0066 e-9'
        },
        'electron volt-hartree relationship': {
            'quantity': 'electron volt-hartree relationship',
            'unit': 'E_h',
            'value': '3.674932248e-2',
            'uncertainty': '0.000 000 023 e-2'
        },
        'electron volt-hertz relationship': {
            'quantity': 'electron volt-hertz relationship',
            'unit': 'Hz',
            'value': '2.417989262e14',
            'uncertainty': '0.000 000 015 e14'
        },
        'electron volt-inverse meter relationship': {
            'quantity': 'electron volt-inverse meter relationship',
            'unit': 'm^{-1}',
            'value': '8.065544005e5',
            'uncertainty': '0.000 000 050 e5'
        },
        'electron volt-joule relationship': {
            'quantity': 'electron volt-joule relationship',
            'unit': 'J',
            'value': '1.6021766208e-19',
            'uncertainty': '0.000 000 0098 e-19'
        },
        'electron volt-kelvin relationship': {
            'quantity': 'electron volt-kelvin relationship',
            'unit': 'K',
            'value': '1.16045221e4',
            'uncertainty': '0.000 000 67 e4'
        },
        'electron volt-kilogram relationship': {
            'quantity': 'electron volt-kilogram relationship',
            'unit': 'kg',
            'value': '1.782661907e-36',
            'uncertainty': '0.000 000 011 e-36'
        },
        'elementary charge': {
            'quantity': 'elementary charge',
            'unit': 'C',
            'value': '1.6021766208e-19',
            'uncertainty': '0.000 000 0098 e-19'
        },
        'elementary charge over h': {
            'quantity': 'elementary charge over h',
            'unit': 'A J^{-1}',
            'value': '2.417989262e14',
            'uncertainty': '0.000 000 015 e14'
        },
        'faraday constant': {
            'quantity': 'Faraday constant',
            'unit': 'C mol^{-1}',
            'value': '96485.33289',
            'uncertainty': '0.000 59'
        },
        'faraday constant for conventional electric current': {
            'quantity': 'Faraday constant for conventional electric current',
            'unit': 'C_{90} mol^{-1}',
            'value': '96485.3251',
            'uncertainty': '0.0012'
        },
        'fermi coupling constant': {
            'quantity': 'Fermi coupling constant',
            'unit': 'GeV^{-2}',
            'value': '1.1663787e-5',
            'uncertainty': '0.000 0006 e-5'
        },
        'fine-structure constant': {
            'quantity': 'fine-structure constant',
            'unit': '',
            'value': '7.2973525664e-3',
            'uncertainty': '0.000 000 0017 e-3'
        },
        'first radiation constant': {
            'quantity': 'first radiation constant',
            'unit': 'W m^2',
            'value': '3.741771790e-16',
            'uncertainty': '0.000 000 046 e-16'
        },
        'first radiation constant for spectral radiance': {
            'quantity': 'first radiation constant for spectral radiance',
            'unit': 'W m^2 sr^{-1}',
            'value': '1.191042953e-16',
            'uncertainty': '0.000 000 015 e-16'
        },
        'hartree-atomic mass unit relationship': {
            'quantity': 'hartree-atomic mass unit relationship',
            'unit': 'u',
            'value': '2.9212623197e-8',
            'uncertainty': '0.000 000 0013 e-8'
        },
        'hartree-electron volt relationship': {
            'quantity': 'hartree-electron volt relationship',
            'unit': 'eV',
            'value': '27.21138602',
            'uncertainty': '0.000 000 17'
        },
        'hartree energy': {
            'quantity': 'Hartree energy',
            'unit': 'J',
            'value': '4.359744650e-18',
            'uncertainty': '0.000 000 054 e-18'
        },
        'hartree energy in ev': {
            'quantity': 'Hartree energy in eV',
            'unit': 'eV',
            'value': '27.21138602',
            'uncertainty': '0.000 000 17'
        },
        'hartree-hertz relationship': {
            'quantity': 'hartree-hertz relationship',
            'unit': 'Hz',
            'value': '6.579683920711e15',
            'uncertainty': '0.000 000 000 039 e15'
        },
        'hartree-inverse meter relationship': {
            'quantity': 'hartree-inverse meter relationship',
            'unit': 'm^{-1}',
            'value': '2.194746313702e7',
            'uncertainty': '0.000 000 000 013 e7'
        },
        'hartree-joule relationship': {
            'quantity': 'hartree-joule relationship',
            'unit': 'J',
            'value': '4.359744650e-18',
            'uncertainty': '0.000 000 054 e-18'
        },
        'hartree-kelvin relationship': {
            'quantity': 'hartree-kelvin relationship',
            'unit': 'K',
            'value': '3.1577513e5',
            'uncertainty': '0.000 0018 e5'
        },
        'hartree-kilogram relationship': {
            'quantity': 'hartree-kilogram relationship',
            'unit': 'kg',
            'value': '4.850870129e-35',
            'uncertainty': '0.000 000 060 e-35'
        },
        'helion-electron mass ratio': {
            'quantity': 'helion-electron mass ratio',
            'unit': '',
            'value': '5495.88527922',
            'uncertainty': '0.000 000 27'
        },
        'helion g factor': {
            'quantity': 'helion g factor',
            'unit': '',
            'value': '-4.255250616',
            'uncertainty': '0.000 000 050'
        },
        'helion mag. mom.': {
            'quantity': 'helion mag. mom.',
            'unit': 'J T^{-1}',
            'value': '-1.074617522e-26',
            'uncertainty': '0.000 000 014 e-26'
        },
        'helion mag. mom. to bohr magneton ratio': {
            'quantity': 'helion mag. mom. to Bohr magneton ratio',
            'unit': '',
            'value': '-1.158740958e-3',
            'uncertainty': '0.000 000 014 e-3'
        },
        'helion mag. mom. to nuclear magneton ratio': {
            'quantity': 'helion mag. mom. to nuclear magneton ratio',
            'unit': '',
            'value': '-2.127625308',
            'uncertainty': '0.000 000 025'
        },
        'helion mass': {
            'quantity': 'helion mass',
            'unit': 'kg',
            'value': '5.006412700e-27',
            'uncertainty': '0.000 000 062 e-27'
        },
        'helion mass energy equivalent': {
            'quantity': 'helion mass energy equivalent',
            'unit': 'J',
            'value': '4.499539341e-10',
            'uncertainty': '0.000 000 055 e-10'
        },
        'helion mass energy equivalent in mev': {
            'quantity': 'helion mass energy equivalent in MeV',
            'unit': 'MeV',
            'value': '2808.391586',
            'uncertainty': '0.000 017'
        },
        'helion mass in u': {
            'quantity': 'helion mass in u',
            'unit': 'u',
            'value': '3.01493224673',
            'uncertainty': '0.000 000 000 12'
        },
        'helion molar mass': {
            'quantity': 'helion molar mass',
            'unit': 'kg mol^{-1}',
            'value': '3.01493224673e-3',
            'uncertainty': '0.000 000 000 12 e-3'
        },
        'helion-proton mass ratio': {
            'quantity': 'helion-proton mass ratio',
            'unit': '',
            'value': '2.99315267046',
            'uncertainty': '0.000 000 000 29'
        },
        'hertz-atomic mass unit relationship': {
            'quantity': 'hertz-atomic mass unit relationship',
            'unit': 'u',
            'value': '4.4398216616e-24',
            'uncertainty': '0.000 000 0020 e-24'
        },
        'hertz-electron volt relationship': {
            'quantity': 'hertz-electron volt relationship',
            'unit': 'eV',
            'value': '4.135667662e-15',
            'uncertainty': '0.000 000 025 e-15'
        },
        'hertz-hartree relationship': {
            'quantity': 'hertz-hartree relationship',
            'unit': 'E_h',
            'value': '1.5198298460088e-16',
            'uncertainty': '0.000 000 000 0090 e-16'
        },
        'hertz-inverse meter relationship': {
            'quantity': 'hertz-inverse meter relationship',
            'unit': 'm^{-1}',
            'value': '3.335640951e-9',
            'uncertainty': '(exact)'
        },
        'hertz-joule relationship': {
            'quantity': 'hertz-joule relationship',
            'unit': 'J',
            'value': '6.626070040e-34',
            'uncertainty': '0.000 000 081 e-34'
        },
        'hertz-kelvin relationship': {
            'quantity': 'hertz-kelvin relationship',
            'unit': 'K',
            'value': '4.7992447e-11',
            'uncertainty': '0.000 0028 e-11'
        },
        'hertz-kilogram relationship': {
            'quantity': 'hertz-kilogram relationship',
            'unit': 'kg',
            'value': '7.372497201e-51',
            'uncertainty': '0.000 000 091 e-51'
        },
        'inverse fine-structure constant': {
            'quantity': 'inverse fine-structure constant',
            'unit': '',
            'value': '137.035999139',
            'uncertainty': '0.000 000 031'
        },
        'inverse meter-atomic mass unit relationship': {
            'quantity': 'inverse meter-atomic mass unit relationship',
            'unit': 'u',
            'value': '1.33102504900e-15',
            'uncertainty': '0.000 000 000 61 e-15'
        },
        'inverse meter-electron volt relationship': {
            'quantity': 'inverse meter-electron volt relationship',
            'unit': 'eV',
            'value': '1.2398419739e-6',
            'uncertainty': '0.000 000 0076 e-6'
        },
        'inverse meter-hartree relationship': {
            'quantity': 'inverse meter-hartree relationship',
            'unit': 'E_h',
            'value': '4.556335252767e-8',
            'uncertainty': '0.000 000 000 027 e-8'
        },
        'inverse meter-hertz relationship': {
            'quantity': 'inverse meter-hertz relationship',
            'unit': 'Hz',
            'value': '299792458',
            'uncertainty': '(exact)'
        },
        'inverse meter-joule relationship': {
            'quantity': 'inverse meter-joule relationship',
            'unit': 'J',
            'value': '1.986445824e-25',
            'uncertainty': '0.000 000 024 e-25'
        },
        'inverse meter-kelvin relationship': {
            'quantity': 'inverse meter-kelvin relationship',
            'unit': 'K',
            'value': '1.43877736e-2',
            'uncertainty': '0.000 000 83 e-2'
        },
        'inverse meter-kilogram relationship': {
            'quantity': 'inverse meter-kilogram relationship',
            'unit': 'kg',
            'value': '2.210219057e-42',
            'uncertainty': '0.000 000 027 e-42'
        },
        'inverse of conductance quantum': {
            'quantity': 'inverse of conductance quantum',
            'unit': 'ohm',
            'value': '12906.4037278',
            'uncertainty': '0.000 0029'
        },
        'josephson constant': {
            'quantity': 'Josephson constant',
            'unit': 'Hz V^{-1}',
            'value': '483597.8525e9',
            'uncertainty': '0.0030 e9'
        },
        'joule-atomic mass unit relationship': {
            'quantity': 'joule-atomic mass unit relationship',
            'unit': 'u',
            'value': '6.700535363e9',
            'uncertainty': '0.000 000 082 e9'
        },
        'joule-electron volt relationship': {
            'quantity': 'joule-electron volt relationship',
            'unit': 'eV',
            'value': '6.241509126e18',
            'uncertainty': '0.000 000 038 e18'
        },
        'joule-hartree relationship': {
            'quantity': 'joule-hartree relationship',
            'unit': 'E_h',
            'value': '2.293712317e17',
            'uncertainty': '0.000 000 028 e17'
        },
        'joule-hertz relationship': {
            'quantity': 'joule-hertz relationship',
            'unit': 'Hz',
            'value': '1.509190205e33',
            'uncertainty': '0.000 000 019 e33'
        },
        'joule-inverse meter relationship': {
            'quantity': 'joule-inverse meter relationship',
            'unit': 'm^{-1}',
            'value': '5.034116651e24',
            'uncertainty': '0.000 000 062 e24'
        },
        'joule-kelvin relationship': {
            'quantity': 'joule-kelvin relationship',
            'unit': 'K',
            'value': '7.2429731e22',
            'uncertainty': '0.000 0042 e22'
        },
        'joule-kilogram relationship': {
            'quantity': 'joule-kilogram relationship',
            'unit': 'kg',
            'value': '1.112650056e-17',
            'uncertainty': '(exact)'
        },
        'kelvin-atomic mass unit relationship': {
            'quantity': 'kelvin-atomic mass unit relationship',
            'unit': 'u',
            'value': '9.2510842e-14',
            'uncertainty': '0.000 0053 e-14'
        },
        'kelvin-electron volt relationship': {
            'quantity': 'kelvin-electron volt relationship',
            'unit': 'eV',
            'value': '8.6173303e-5',
            'uncertainty': '0.000 0050 e-5'
        },
        'kelvin-hartree relationship': {
            'quantity': 'kelvin-hartree relationship',
            'unit': 'E_h',
            'value': '3.1668105e-6',
            'uncertainty': '0.000 0018 e-6'
        },
        'kelvin-hertz relationship': {
            'quantity': 'kelvin-hertz relationship',
            'unit': 'Hz',
            'value': '2.0836612e10',
            'uncertainty': '0.000 0012 e10'
        },
        'kelvin-inverse meter relationship': {
            'quantity': 'kelvin-inverse meter relationship',
            'unit': 'm^{-1}',
            'value': '69.503457',
            'uncertainty': '0.000 040'
        },
        'kelvin-joule relationship': {
            'quantity': 'kelvin-joule relationship',
            'unit': 'J',
            'value': '1.38064852e-23',
            'uncertainty': '0.000 000 79 e-23'
        },
        'kelvin-kilogram relationship': {
            'quantity': 'kelvin-kilogram relationship',
            'unit': 'kg',
            'value': '1.53617865e-40',
            'uncertainty': '0.000 000 88 e-40'
        },
        'kilogram-atomic mass unit relationship': {
            'quantity': 'kilogram-atomic mass unit relationship',
            'unit': 'u',
            'value': '6.022140857e26',
            'uncertainty': '0.000 000 074 e26'
        },
        'kilogram-electron volt relationship': {
            'quantity': 'kilogram-electron volt relationship',
            'unit': 'eV',
            'value': '5.609588650e35',
            'uncertainty': '0.000 000 034 e35'
        },
        'kilogram-hartree relationship': {
            'quantity': 'kilogram-hartree relationship',
            'unit': 'E_h',
            'value': '2.061485823e34',
            'uncertainty': '0.000 000 025 e34'
        },
        'kilogram-hertz relationship': {
            'quantity': 'kilogram-hertz relationship',
            'unit': 'Hz',
            'value': '1.356392512e50',
            'uncertainty': '0.000 000 017 e50'
        },
        'kilogram-inverse meter relationship': {
            'quantity': 'kilogram-inverse meter relationship',
            'unit': 'm^{-1}',
            'value': '4.524438411e41',
            'uncertainty': '0.000 000 056 e41'
        },
        'kilogram-joule relationship': {
            'quantity': 'kilogram-joule relationship',
            'unit': 'J',
            'value': '8.987551787e16',
            'uncertainty': '(exact)'
        },
        'kilogram-kelvin relationship': {
            'quantity': 'kilogram-kelvin relationship',
            'unit': 'K',
            'value': '6.5096595e39',
            'uncertainty': '0.000 0037 e39'
        },
        'lattice parameter of silicon': {
            'quantity': 'lattice parameter of silicon',
            'unit': 'm',
            'value': '543.1020504e-12',
            'uncertainty': '0.000 0089 e-12'
        },
        'loschmidt constant (273.15 k, 100 kpa)': {
            'quantity': 'Loschmidt constant (273.15 K, 100 kPa)',
            'unit': 'm^{-3}',
            'value': '2.6516467e25',
            'uncertainty': '0.000 0015 e25'
        },
        'loschmidt constant (273.15 k, 101.325 kpa)': {
            'quantity': 'Loschmidt constant (273.15 K, 101.325 kPa)',
            'unit': 'm^{-3}',
            'value': '2.6867811e25',
            'uncertainty': '0.000 0015 e25'
        },
        'mag. constant': {
            'quantity': 'mag. constant',
            'unit': 'N A^{-2}',
            'value': '12.566370614e-7',
            'uncertainty': '(exact)'
        },
        'mag. flux quantum': {
            'quantity': 'mag. flux quantum',
            'unit': 'Wb',
            'value': '2.067833831e-15',
            'uncertainty': '0.000 000 013 e-15'
        },
        'molar gas constant': {
            'quantity': 'molar gas constant',
            'unit': 'J mol^{-1} K^{-1}',
            'value': '8.3144598',
            'uncertainty': '0.000 0048'
        },
        'molar mass constant': {
            'quantity': 'molar mass constant',
            'unit': 'kg mol^{-1}',
            'value': '1e-3',
            'uncertainty': '(exact)'
        },
        'molar mass of carbon-12': {
            'quantity': 'molar mass of carbon-12',
            'unit': 'kg mol^{-1}',
            'value': '12e-3',
            'uncertainty': '(exact)'
        },
        'molar planck constant': {
            'quantity': 'molar Planck constant',
            'unit': 'J s mol^{-1}',
            'value': '3.9903127110e-10',
            'uncertainty': '0.000 000 0018 e-10'
        },
        'molar planck constant times c': {
            'quantity': 'molar Planck constant times c',
            'unit': 'J m mol^{-1}',
            'value': '0.119626565582',
            'uncertainty': '0.000 000 000 054'
        },
        'molar volume of ideal gas (273.15 k, 100 kpa)': {
            'quantity': 'molar volume of ideal gas (273.15 K, 100 kPa)',
            'unit': 'm^3 mol^{-1}',
            'value': '22.710947e-3',
            'uncertainty': '0.000 013 e-3'
        },
        'molar volume of ideal gas (273.15 k, 101.325 kpa)': {
            'quantity': 'molar volume of ideal gas (273.15 K, 101.325 kPa)',
            'unit': 'm^3 mol^{-1}',
            'value': '22.413962e-3',
            'uncertainty': '0.000 013 e-3'
        },
        'molar volume of silicon': {
            'quantity': 'molar volume of silicon',
            'unit': 'm^3 mol^{-1}',
            'value': '12.05883214e-6',
            'uncertainty': '0.000 000 61 e-6'
        },
        'mo x unit': {
            'quantity': 'Mo x unit',
            'unit': 'm',
            'value': '1.00209952e-13',
            'uncertainty': '0.000 000 53 e-13'
        },
        'muon compton wavelength': {
            'quantity': 'muon Compton wavelength',
            'unit': 'm',
            'value': '11.73444111e-15',
            'uncertainty': '0.000 000 26 e-15'
        },
        'muon compton wavelength over 2 pi': {
            'quantity': 'muon Compton wavelength over 2 pi',
            'unit': 'm',
            'value': '1.867594308e-15',
            'uncertainty': '0.000 000 042 e-15'
        },
        'muon-electron mass ratio': {
            'quantity': 'muon-electron mass ratio',
            'unit': '',
            'value': '206.7682826',
            'uncertainty': '0.000 0046'
        },
        'muon g factor': {
            'quantity': 'muon g factor',
            'unit': '',
            'value': '-2.0023318418',
            'uncertainty': '0.000 000 0013'
        },
        'muon mag. mom.': {
            'quantity': 'muon mag. mom.',
            'unit': 'J T^{-1}',
            'value': '-4.49044826e-26',
            'uncertainty': '0.000 000 10 e-26'
        },
        'muon mag. mom. anomaly': {
            'quantity': 'muon mag. mom. anomaly',
            'unit': '',
            'value': '1.16592089e-3',
            'uncertainty': '0.000 000 63 e-3'
        },
        'muon mag. mom. to bohr magneton ratio': {
            'quantity': 'muon mag. mom. to Bohr magneton ratio',
            'unit': '',
            'value': '-4.84197048e-3',
            'uncertainty': '0.000 000 11 e-3'
        },
        'muon mag. mom. to nuclear magneton ratio': {
            'quantity': 'muon mag. mom. to nuclear magneton ratio',
            'unit': '',
            'value': '-8.89059705',
            'uncertainty': '0.000 000 20'
        },
        'muon mass': {
            'quantity': 'muon mass',
            'unit': 'kg',
            'value': '1.883531594e-28',
            'uncertainty': '0.000 000 048 e-28'
        },
        'muon mass energy equivalent': {
            'quantity': 'muon mass energy equivalent',
            'unit': 'J',
            'value': '1.692833774e-11',
            'uncertainty': '0.000 000 043 e-11'
        },
        'muon mass energy equivalent in mev': {
            'quantity': 'muon mass energy equivalent in MeV',
            'unit': 'MeV',
            'value': '105.6583745',
            'uncertainty': '0.000 0024'
        },
        'muon mass in u': {
            'quantity': 'muon mass in u',
            'unit': 'u',
            'value': '0.1134289257',
            'uncertainty': '0.000 000 0025'
        },
        'muon molar mass': {
            'quantity': 'muon molar mass',
            'unit': 'kg mol^{-1}',
            'value': '0.1134289257e-3',
            'uncertainty': '0.000 000 0025 e-3'
        },
        'muon-neutron mass ratio': {
            'quantity': 'muon-neutron mass ratio',
            'unit': '',
            'value': '0.1124545167',
            'uncertainty': '0.000 000 0025'
        },
        'muon-proton mag. mom. ratio': {
            'quantity': 'muon-proton mag. mom. ratio',
            'unit': '',
            'value': '-3.183345142',
            'uncertainty': '0.000 000 071'
        },
        'muon-proton mass ratio': {
            'quantity': 'muon-proton mass ratio',
            'unit': '',
            'value': '0.1126095262',
            'uncertainty': '0.000 000 0025'
        },
        'muon-tau mass ratio': {
            'quantity': 'muon-tau mass ratio',
            'unit': '',
            'value': '5.94649e-2',
            'uncertainty': '0.000 54 e-2'
        },
        'natural unit of action': {
            'quantity': 'natural unit of action',
            'unit': 'J s',
            'value': '1.054571800e-34',
            'uncertainty': '0.000 000 013 e-34'
        },
        'natural unit of action in ev s': {
            'quantity': 'natural unit of action in eV s',
            'unit': 'eV s',
            'value': '6.582119514e-16',
            'uncertainty': '0.000 000 040 e-16'
        },
        'natural unit of energy': {
            'quantity': 'natural unit of energy',
            'unit': 'J',
            'value': '8.18710565e-14',
            'uncertainty': '0.000 000 10 e-14'
        },
        'natural unit of energy in mev': {
            'quantity': 'natural unit of energy in MeV',
            'unit': 'MeV',
            'value': '0.5109989461',
            'uncertainty': '0.000 000 0031'
        },
        'natural unit of length': {
            'quantity': 'natural unit of length',
            'unit': 'm',
            'value': '386.15926764e-15',
            'uncertainty': '0.000 000 18 e-15'
        },
        'natural unit of mass': {
            'quantity': 'natural unit of mass',
            'unit': 'kg',
            'value': '9.10938356e-31',
            'uncertainty': '0.000 000 11 e-31'
        },
        'natural unit of mom.um': {
            'quantity': 'natural unit of mom.um',
            'unit': 'kg m s^{-1}',
            'value': '2.730924488e-22',
            'uncertainty': '0.000 000 034 e-22'
        },
        'natural unit of mom.um in mev/c': {
            'quantity': 'natural unit of mom.um in MeV/c',
            'unit': 'MeV/c',
            'value': '0.5109989461',
            'uncertainty': '0.000 000 0031'
        },
        'natural unit of time': {
            'quantity': 'natural unit of time',
            'unit': 's',
            'value': '1.28808866712e-21',
            'uncertainty': '0.000 000 000 58 e-21'
        },
        'natural unit of velocity': {
            'quantity': 'natural unit of velocity',
            'unit': 'm s^{-1}',
            'value': '299792458',
            'uncertainty': '(exact)'
        },
        'neutron compton wavelength': {
            'quantity': 'neutron Compton wavelength',
            'unit': 'm',
            'value': '1.31959090481e-15',
            'uncertainty': '0.000 000 000 88 e-15'
        },
        'neutron compton wavelength over 2 pi': {
            'quantity': 'neutron Compton wavelength over 2 pi',
            'unit': 'm',
            'value': '0.21001941536e-15',
            'uncertainty': '0.000 000 000 14 e-15'
        },
        'neutron-electron mag. mom. ratio': {
            'quantity': 'neutron-electron mag. mom. ratio',
            'unit': '',
            'value': '1.04066882e-3',
            'uncertainty': '0.000 000 25 e-3'
        },
        'neutron-electron mass ratio': {
            'quantity': 'neutron-electron mass ratio',
            'unit': '',
            'value': '1838.68366158',
            'uncertainty': '0.000 000 90'
        },
        'neutron g factor': {
            'quantity': 'neutron g factor',
            'unit': '',
            'value': '-3.82608545',
            'uncertainty': '0.000 000 90'
        },
        'neutron gyromag. ratio': {
            'quantity': 'neutron gyromag. ratio',
            'unit': 's^{-1} T^{-1}',
            'value': '1.83247172e8',
            'uncertainty': '0.000 000 43 e8'
        },
        'neutron gyromag. ratio over 2 pi': {
            'quantity': 'neutron gyromag. ratio over 2 pi',
            'unit': 'MHz T^{-1}',
            'value': '29.1646933',
            'uncertainty': '0.000 0069'
        },
        'neutron mag. mom.': {
            'quantity': 'neutron mag. mom.',
            'unit': 'J T^{-1}',
            'value': '-0.96623650e-26',
            'uncertainty': '0.000 000 23 e-26'
        },
        'neutron mag. mom. to bohr magneton ratio': {
            'quantity': 'neutron mag. mom. to Bohr magneton ratio',
            'unit': '',
            'value': '-1.04187563e-3',
            'uncertainty': '0.000 000 25 e-3'
        },
        'neutron mag. mom. to nuclear magneton ratio': {
            'quantity': 'neutron mag. mom. to nuclear magneton ratio',
            'unit': '',
            'value': '-1.91304273',
            'uncertainty': '0.000 000 45'
        },
        'neutron mass': {
            'quantity': 'neutron mass',
            'unit': 'kg',
            'value': '1.674927471e-27',
            'uncertainty': '0.000 000 021 e-27'
        },
        'neutron mass energy equivalent': {
            'quantity': 'neutron mass energy equivalent',
            'unit': 'J',
            'value': '1.505349739e-10',
            'uncertainty': '0.000 000 019 e-10'
        },
        'neutron mass energy equivalent in mev': {
            'quantity': 'neutron mass energy equivalent in MeV',
            'unit': 'MeV',
            'value': '939.5654133',
            'uncertainty': '0.000 0058'
        },
        'neutron mass in u': {
            'quantity': 'neutron mass in u',
            'unit': 'u',
            'value': '1.00866491588',
            'uncertainty': '0.000 000 000 49'
        },
        'neutron molar mass': {
            'quantity': 'neutron molar mass',
            'unit': 'kg mol^{-1}',
            'value': '1.00866491588e-3',
            'uncertainty': '0.000 000 000 49 e-3'
        },
        'neutron-muon mass ratio': {
            'quantity': 'neutron-muon mass ratio',
            'unit': '',
            'value': '8.89248408',
            'uncertainty': '0.000 000 20'
        },
        'neutron-proton mag. mom. ratio': {
            'quantity': 'neutron-proton mag. mom. ratio',
            'unit': '',
            'value': '-0.68497934',
            'uncertainty': '0.000 000 16'
        },
        'neutron-proton mass difference': {
            'quantity': 'neutron-proton mass difference',
            'unit': '',
            'value': '2.30557377e-30',
            'uncertainty': '0.000 000 85 e-30'
        },
        'neutron-proton mass difference energy equivalent': {
            'quantity': 'neutron-proton mass difference energy equivalent',
            'unit': '',
            'value': '2.07214637e-13',
            'uncertainty': '0.000 000 76 e-13'
        },
        'neutron-proton mass difference energy equivalent in mev': {
            'quantity':
            'neutron-proton mass difference energy equivalent in MeV',
            'unit': '',
            'value': '1.29333205',
            'uncertainty': '0.000 000 48'
        },
        'neutron-proton mass difference in u': {
            'quantity': 'neutron-proton mass difference in u',
            'unit': '',
            'value': '0.00138844900',
            'uncertainty': '0.000 000 000 51'
        },
        'neutron-proton mass ratio': {
            'quantity': 'neutron-proton mass ratio',
            'unit': '',
            'value': '1.00137841898',
            'uncertainty': '0.000 000 000 51'
        },
        'neutron-tau mass ratio': {
            'quantity': 'neutron-tau mass ratio',
            'unit': '',
            'value': '0.528790',
            'uncertainty': '0.000 048'
        },
        'neutron to shielded proton mag. mom. ratio': {
            'quantity': 'neutron to shielded proton mag. mom. ratio',
            'unit': '',
            'value': '-0.68499694',
            'uncertainty': '0.000 000 16'
        },
        'newtonian constant of gravitation': {
            'quantity': 'Newtonian constant of gravitation',
            'unit': 'm^3 kg^{-1} s^{-2}',
            'value': '6.67408e-11',
            'uncertainty': '0.000 31 e-11'
        },
        'newtonian constant of gravitation over h-bar c': {
            'quantity': 'Newtonian constant of gravitation over h-bar c',
            'unit': '(GeV/c^2)^-2',
            'value': '6.70861e-39',
            'uncertainty': '0.000 31 e-39'
        },
        'nuclear magneton': {
            'quantity': 'nuclear magneton',
            'unit': 'J T^{-1}',
            'value': '5.050783699e-27',
            'uncertainty': '0.000 000 031 e-27'
        },
        'nuclear magneton in ev/t': {
            'quantity': 'nuclear magneton in eV/T',
            'unit': 'eV T^{-1}',
            'value': '3.1524512550e-8',
            'uncertainty': '0.000 000 0015 e-8'
        },
        'nuclear magneton in inverse meters per tesla': {
            'quantity': 'nuclear magneton in inverse meters per tesla',
            'unit': 'm^{-1} T^{-1}',
            'value': '2.542623432e-2',
            'uncertainty': '0.000 000 016 e-2'
        },
        'nuclear magneton in k/t': {
            'quantity': 'nuclear magneton in K/T',
            'unit': 'K T^{-1}',
            'value': '3.6582690e-4',
            'uncertainty': '0.000 0021 e-4'
        },
        'nuclear magneton in mhz/t': {
            'quantity': 'nuclear magneton in MHz/T',
            'unit': 'MHz T^{-1}',
            'value': '7.622593285',
            'uncertainty': '0.000 000 047'
        },
        'planck constant': {
            'quantity': 'Planck constant',
            'unit': 'J s',
            'value': '6.626070040e-34',
            'uncertainty': '0.000 000 081 e-34'
        },
        'planck constant in ev s': {
            'quantity': 'Planck constant in eV s',
            'unit': 'eV s',
            'value': '4.135667662e-15',
            'uncertainty': '0.000 000 025 e-15'
        },
        'planck constant over 2 pi': {
            'quantity': 'Planck constant over 2 pi',
            'unit': 'J s',
            'value': '1.054571800e-34',
            'uncertainty': '0.000 000 013 e-34'
        },
        'planck constant over 2 pi in ev s': {
            'quantity': 'Planck constant over 2 pi in eV s',
            'unit': 'eV s',
            'value': '6.582119514e-16',
            'uncertainty': '0.000 000 040 e-16'
        },
        'planck constant over 2 pi times c in mev fm': {
            'quantity': 'Planck constant over 2 pi times c in MeV fm',
            'unit': 'MeV fm',
            'value': '197.3269788',
            'uncertainty': '0.000 0012'
        },
        'planck length': {
            'quantity': 'Planck length',
            'unit': 'm',
            'value': '1.616229e-35',
            'uncertainty': '0.000 038 e-35'
        },
        'planck mass': {
            'quantity': 'Planck mass',
            'unit': 'kg',
            'value': '2.176470e-8',
            'uncertainty': '0.000 051 e-8'
        },
        'planck mass energy equivalent in gev': {
            'quantity': 'Planck mass energy equivalent in GeV',
            'unit': 'GeV',
            'value': '1.220910e19',
            'uncertainty': '0.000 029 e19'
        },
        'planck temperature': {
            'quantity': 'Planck temperature',
            'unit': 'K',
            'value': '1.416808e32',
            'uncertainty': '0.000 033 e32'
        },
        'planck time': {
            'quantity': 'Planck time',
            'unit': 's',
            'value': '5.39116e-44',
            'uncertainty': '0.000 13 e-44'
        },
        'proton charge to mass quotient': {
            'quantity': 'proton charge to mass quotient',
            'unit': 'C kg^{-1}',
            'value': '9.578833226e7',
            'uncertainty': '0.000 000 059 e7'
        },
        'proton compton wavelength': {
            'quantity': 'proton Compton wavelength',
            'unit': 'm',
            'value': '1.32140985396e-15',
            'uncertainty': '0.000 000 000 61 e-15'
        },
        'proton compton wavelength over 2 pi': {
            'quantity': 'proton Compton wavelength over 2 pi',
            'unit': 'm',
            'value': '0.210308910109e-15',
            'uncertainty': '0.000 000 000 097 e-15'
        },
        'proton-electron mass ratio': {
            'quantity': 'proton-electron mass ratio',
            'unit': '',
            'value': '1836.15267389',
            'uncertainty': '0.000 000 17'
        },
        'proton g factor': {
            'quantity': 'proton g factor',
            'unit': '',
            'value': '5.585694702',
            'uncertainty': '0.000 000 017'
        },
        'proton gyromag. ratio': {
            'quantity': 'proton gyromag. ratio',
            'unit': 's^{-1} T^{-1}',
            'value': '2.675221900e8',
            'uncertainty': '0.000 000 018 e8'
        },
        'proton gyromag. ratio over 2 pi': {
            'quantity': 'proton gyromag. ratio over 2 pi',
            'unit': 'MHz T^{-1}',
            'value': '42.57747892',
            'uncertainty': '0.000 000 29'
        },
        'proton mag. mom.': {
            'quantity': 'proton mag. mom.',
            'unit': 'J T^{-1}',
            'value': '1.4106067873e-26',
            'uncertainty': '0.000 000 0097 e-26'
        },
        'proton mag. mom. to bohr magneton ratio': {
            'quantity': 'proton mag. mom. to Bohr magneton ratio',
            'unit': '',
            'value': '1.5210322053e-3',
            'uncertainty': '0.000 000 0046 e-3'
        },
        'proton mag. mom. to nuclear magneton ratio': {
            'quantity': 'proton mag. mom. to nuclear magneton ratio',
            'unit': '',
            'value': '2.7928473508',
            'uncertainty': '0.000 000 0085'
        },
        'proton mag. shielding correction': {
            'quantity': 'proton mag. shielding correction',
            'unit': '',
            'value': '25.691e-6',
            'uncertainty': '0.011 e-6'
        },
        'proton mass': {
            'quantity': 'proton mass',
            'unit': 'kg',
            'value': '1.672621898e-27',
            'uncertainty': '0.000 000 021 e-27'
        },
        'proton mass energy equivalent': {
            'quantity': 'proton mass energy equivalent',
            'unit': 'J',
            'value': '1.503277593e-10',
            'uncertainty': '0.000 000 018 e-10'
        },
        'proton mass energy equivalent in mev': {
            'quantity': 'proton mass energy equivalent in MeV',
            'unit': 'MeV',
            'value': '938.2720813',
            'uncertainty': '0.000 0058'
        },
        'proton mass in u': {
            'quantity': 'proton mass in u',
            'unit': 'u',
            'value': '1.007276466879',
            'uncertainty': '0.000 000 000 091'
        },
        'proton molar mass': {
            'quantity': 'proton molar mass',
            'unit': 'kg mol^{-1}',
            'value': '1.007276466879e-3',
            'uncertainty': '0.000 000 000 091 e-3'
        },
        'proton-muon mass ratio': {
            'quantity': 'proton-muon mass ratio',
            'unit': '',
            'value': '8.88024338',
            'uncertainty': '0.000 000 20'
        },
        'proton-neutron mag. mom. ratio': {
            'quantity': 'proton-neutron mag. mom. ratio',
            'unit': '',
            'value': '-1.45989805',
            'uncertainty': '0.000 000 34'
        },
        'proton-neutron mass ratio': {
            'quantity': 'proton-neutron mass ratio',
            'unit': '',
            'value': '0.99862347844',
            'uncertainty': '0.000 000 000 51'
        },
        'proton rms charge radius': {
            'quantity': 'proton rms charge radius',
            'unit': 'm',
            'value': '0.8751e-15',
            'uncertainty': '0.0061 e-15'
        },
        'proton-tau mass ratio': {
            'quantity': 'proton-tau mass ratio',
            'unit': '',
            'value': '0.528063',
            'uncertainty': '0.000 048'
        },
        'quantum of circulation': {
            'quantity': 'quantum of circulation',
            'unit': 'm^2 s^{-1}',
            'value': '3.6369475486e-4',
            'uncertainty': '0.000 000 0017 e-4'
        },
        'quantum of circulation times 2': {
            'quantity': 'quantum of circulation times 2',
            'unit': 'm^2 s^{-1}',
            'value': '7.2738950972e-4',
            'uncertainty': '0.000 000 0033 e-4'
        },
        'rydberg constant': {
            'quantity': 'Rydberg constant',
            'unit': 'm^{-1}',
            'value': '10973731.568508',
            'uncertainty': '0.000 065'
        },
        'rydberg constant times c in hz': {
            'quantity': 'Rydberg constant times c in Hz',
            'unit': 'Hz',
            'value': '3.289841960355e15',
            'uncertainty': '0.000 000 000 019 e15'
        },
        'rydberg constant times hc in ev': {
            'quantity': 'Rydberg constant times hc in eV',
            'unit': 'eV',
            'value': '13.605693009',
            'uncertainty': '0.000 000 084'
        },
        'rydberg constant times hc in j': {
            'quantity': 'Rydberg constant times hc in J',
            'unit': 'J',
            'value': '2.179872325e-18',
            'uncertainty': '0.000 000 027 e-18'
        },
        'sackur-tetrode constant (1 k, 100 kpa)': {
            'quantity': 'Sackur-Tetrode constant (1 K, 100 kPa)',
            'unit': '',
            'value': '-1.1517084',
            'uncertainty': '0.000 0014'
        },
        'sackur-tetrode constant (1 k, 101.325 kpa)': {
            'quantity': 'Sackur-Tetrode constant (1 K, 101.325 kPa)',
            'unit': '',
            'value': '-1.1648714',
            'uncertainty': '0.000 0014'
        },
        'second radiation constant': {
            'quantity': 'second radiation constant',
            'unit': 'm K',
            'value': '1.43877736e-2',
            'uncertainty': '0.000 000 83 e-2'
        },
        'shielded helion gyromag. ratio': {
            'quantity': 'shielded helion gyromag. ratio',
            'unit': 's^{-1} T^{-1}',
            'value': '2.037894585e8',
            'uncertainty': '0.000 000 027 e8'
        },
        'shielded helion gyromag. ratio over 2 pi': {
            'quantity': 'shielded helion gyromag. ratio over 2 pi',
            'unit': 'MHz T^{-1}',
            'value': '32.43409966',
            'uncertainty': '0.000 000 43'
        },
        'shielded helion mag. mom.': {
            'quantity': 'shielded helion mag. mom.',
            'unit': 'J T^{-1}',
            'value': '-1.074553080e-26',
            'uncertainty': '0.000 000 014 e-26'
        },
        'shielded helion mag. mom. to bohr magneton ratio': {
            'quantity': 'shielded helion mag. mom. to Bohr magneton ratio',
            'unit': '',
            'value': '-1.158671471e-3',
            'uncertainty': '0.000 000 014 e-3'
        },
        'shielded helion mag. mom. to nuclear magneton ratio': {
            'quantity': 'shielded helion mag. mom. to nuclear magneton ratio',
            'unit': '',
            'value': '-2.127497720',
            'uncertainty': '0.000 000 025'
        },
        'shielded helion to proton mag. mom. ratio': {
            'quantity': 'shielded helion to proton mag. mom. ratio',
            'unit': '',
            'value': '-0.7617665603',
            'uncertainty': '0.000 000 0092'
        },
        'shielded helion to shielded proton mag. mom. ratio': {
            'quantity': 'shielded helion to shielded proton mag. mom. ratio',
            'unit': '',
            'value': '-0.7617861313',
            'uncertainty': '0.000 000 0033'
        },
        'shielded proton gyromag. ratio': {
            'quantity': 'shielded proton gyromag. ratio',
            'unit': 's^{-1} T^{-1}',
            'value': '2.675153171e8',
            'uncertainty': '0.000 000 033 e8'
        },
        'shielded proton gyromag. ratio over 2 pi': {
            'quantity': 'shielded proton gyromag. ratio over 2 pi',
            'unit': 'MHz T^{-1}',
            'value': '42.57638507',
            'uncertainty': '0.000 000 53'
        },
        'shielded proton mag. mom.': {
            'quantity': 'shielded proton mag. mom.',
            'unit': 'J T^{-1}',
            'value': '1.410570547e-26',
            'uncertainty': '0.000 000 018 e-26'
        },
        'shielded proton mag. mom. to bohr magneton ratio': {
            'quantity': 'shielded proton mag. mom. to Bohr magneton ratio',
            'unit': '',
            'value': '1.520993128e-3',
            'uncertainty': '0.000 000 017 e-3'
        },
        'shielded proton mag. mom. to nuclear magneton ratio': {
            'quantity': 'shielded proton mag. mom. to nuclear magneton ratio',
            'unit': '',
            'value': '2.792775600',
            'uncertainty': '0.000 000 030'
        },
        'speed of light in vacuum': {
            'quantity': 'speed of light in vacuum',
            'unit': 'm s^{-1}',
            'value': '299792458',
            'uncertainty': '(exact)'
        },
        'standard acceleration of gravity': {
            'quantity': 'standard acceleration of gravity',
            'unit': 'm s^{-2}',
            'value': '9.80665',
            'uncertainty': '(exact)'
        },
        'standard atmosphere': {
            'quantity': 'standard atmosphere',
            'unit': 'Pa',
            'value': '101325',
            'uncertainty': '(exact)'
        },
        'standard-state pressure': {
            'quantity': 'standard-state pressure',
            'unit': 'Pa',
            'value': '100000',
            'uncertainty': '(exact)'
        },
        'stefan-boltzmann constant': {
            'quantity': 'Stefan-Boltzmann constant',
            'unit': 'W m^{-2} K^{-4}',
            'value': '5.670367e-8',
            'uncertainty': '0.000 013 e-8'
        },
        'tau compton wavelength': {
            'quantity': 'tau Compton wavelength',
            'unit': 'm',
            'value': '0.697787e-15',
            'uncertainty': '0.000 063 e-15'
        },
        'tau compton wavelength over 2 pi': {
            'quantity': 'tau Compton wavelength over 2 pi',
            'unit': 'm',
            'value': '0.111056e-15',
            'uncertainty': '0.000 010 e-15'
        },
        'tau-electron mass ratio': {
            'quantity': 'tau-electron mass ratio',
            'unit': '',
            'value': '3477.15',
            'uncertainty': '0.31'
        },
        'tau mass': {
            'quantity': 'tau mass',
            'unit': 'kg',
            'value': '3.16747e-27',
            'uncertainty': '0.000 29 e-27'
        },
        'tau mass energy equivalent': {
            'quantity': 'tau mass energy equivalent',
            'unit': 'J',
            'value': '2.84678e-10',
            'uncertainty': '0.000 26 e-10'
        },
        'tau mass energy equivalent in mev': {
            'quantity': 'tau mass energy equivalent in MeV',
            'unit': 'MeV',
            'value': '1776.82',
            'uncertainty': '0.16'
        },
        'tau mass in u': {
            'quantity': 'tau mass in u',
            'unit': 'u',
            'value': '1.90749',
            'uncertainty': '0.000 17'
        },
        'tau molar mass': {
            'quantity': 'tau molar mass',
            'unit': 'kg mol^{-1}',
            'value': '1.90749e-3',
            'uncertainty': '0.000 17 e-3'
        },
        'tau-muon mass ratio': {
            'quantity': 'tau-muon mass ratio',
            'unit': '',
            'value': '16.8167',
            'uncertainty': '0.0015'
        },
        'tau-neutron mass ratio': {
            'quantity': 'tau-neutron mass ratio',
            'unit': '',
            'value': '1.89111',
            'uncertainty': '0.000 17'
        },
        'tau-proton mass ratio': {
            'quantity': 'tau-proton mass ratio',
            'unit': '',
            'value': '1.89372',
            'uncertainty': '0.000 17'
        },
        'thomson cross section': {
            'quantity': 'Thomson cross section',
            'unit': 'm^2',
            'value': '0.66524587158e-28',
            'uncertainty': '0.000 000 000 91 e-28'
        },
        'triton-electron mass ratio': {
            'quantity': 'triton-electron mass ratio',
            'unit': '',
            'value': '5496.92153588',
            'uncertainty': '0.000 000 26'
        },
        'triton g factor': {
            'quantity': 'triton g factor',
            'unit': '',
            'value': '5.957924920',
            'uncertainty': '0.000 000 028'
        },
        'triton mag. mom.': {
            'quantity': 'triton mag. mom.',
            'unit': 'J T^{-1}',
            'value': '1.504609503e-26',
            'uncertainty': '0.000 000 012 e-26'
        },
        'triton mag. mom. to bohr magneton ratio': {
            'quantity': 'triton mag. mom. to Bohr magneton ratio',
            'unit': '',
            'value': '1.6223936616e-3',
            'uncertainty': '0.000 000 0076 e-3'
        },
        'triton mag. mom. to nuclear magneton ratio': {
            'quantity': 'triton mag. mom. to nuclear magneton ratio',
            'unit': '',
            'value': '2.978962460',
            'uncertainty': '0.000 000 014'
        },
        'triton mass': {
            'quantity': 'triton mass',
            'unit': 'kg',
            'value': '5.007356665e-27',
            'uncertainty': '0.000 000 062 e-27'
        },
        'triton mass energy equivalent': {
            'quantity': 'triton mass energy equivalent',
            'unit': 'J',
            'value': '4.500387735e-10',
            'uncertainty': '0.000 000 055 e-10'
        },
        'triton mass energy equivalent in mev': {
            'quantity': 'triton mass energy equivalent in MeV',
            'unit': 'MeV',
            'value': '2808.921112',
            'uncertainty': '0.000 017'
        },
        'triton mass in u': {
            'quantity': 'triton mass in u',
            'unit': 'u',
            'value': '3.01550071632',
            'uncertainty': '0.000 000 000 11'
        },
        'triton molar mass': {
            'quantity': 'triton molar mass',
            'unit': 'kg mol^{-1}',
            'value': '3.01550071632e-3',
            'uncertainty': '0.000 000 000 11 e-3'
        },
        'triton-proton mass ratio': {
            'quantity': 'triton-proton mass ratio',
            'unit': '',
            'value': '2.99371703348',
            'uncertainty': '0.000 000 000 22'
        },
        'unified atomic mass unit': {
            'quantity': 'unified atomic mass unit',
            'unit': 'kg',
            'value': '1.660539040e-27',
            'uncertainty': '0.000 000 020 e-27'
        },
        'von klitzing constant': {
            'quantity': 'von Klitzing constant',
            'unit': 'ohm',
            'value': '25812.8074555',
            'uncertainty': '0.000 0059'
        },
        'weak mixing angle': {
            'quantity': 'weak mixing angle',
            'unit': '',
            'value': '0.2223',
            'uncertainty': '0.0021'
        },
        'wien frequency displacement law constant': {
            'quantity': 'Wien frequency displacement law constant',
            'unit': 'Hz K^{-1}',
            'value': '5.8789238e10',
            'uncertainty': '0.000 0034 e10'
        },
        'wien wavelength displacement law constant': {
            'quantity': 'Wien wavelength displacement law constant',
            'unit': 'm K',
            'value': '2.8977729e-3',
            'uncertainty': '0.000 0017 e-3'
        }
    }
}  # yapf: disable
