# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.impactreporting.aio import ImpactReportingMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestImpactReportingMgmtInsightsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ImpactReportingMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_insights_get(self, resource_group):
        response = await self.client.insights.get(
            workload_impact_name="str",
            insight_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_insights_list_by_subscription(self, resource_group):
        response = self.client.insights.list_by_subscription(
            workload_impact_name="str",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_insights_create(self, resource_group):
        response = await self.client.insights.create(
            workload_impact_name="str",
            insight_name="str",
            resource={
                "id": "str",
                "name": "str",
                "properties": {
                    "category": "str",
                    "content": {"description": "str", "title": "str"},
                    "impact": {
                        "impactId": "str",
                        "impactedResourceId": "str",
                        "startTime": "2020-02-20 00:00:00",
                        "endTime": "2020-02-20 00:00:00",
                    },
                    "insightUniqueId": "str",
                    "additionalDetails": {},
                    "eventId": "str",
                    "eventTime": "2020-02-20 00:00:00",
                    "groupId": "str",
                    "provisioningState": "str",
                    "status": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_insights_delete(self, resource_group):
        response = await self.client.insights.delete(
            workload_impact_name="str",
            insight_name="str",
        )

        # please add some check logic here by yourself
        # ...
