# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import datetime
from io import IOBase
import sys
from typing import Any, Callable, Dict, IO, Optional, TypeVar, Union, cast, overload

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ...operations._operations import (
    build_metadata_get_request,
    build_metadata_post_request,
    build_query_batch_request,
    build_query_execute_request,
    build_query_get_request,
    build_query_resource_execute_request,
    build_query_resource_execute_xms_request,
    build_query_resource_get_request,
    build_query_resource_get_xms_request,
)

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class QueryOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~monitor_query_client.aio.MonitorQueryClient`'s
        :attr:`query` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def get(
        self, workspace_id: str, *, query: str, timespan: Optional[datetime.timedelta] = None, **kwargs: Any
    ) -> JSON:
        """Execute an Analytics query.

        Executes an Analytics query for data.

        :param workspace_id: Primary Workspace ID of the query. This is the Workspace ID from the
         Properties blade in the Azure portal. Required.
        :type workspace_id: str
        :keyword query: The Analytics query. Learn more about the `Analytics query syntax
         <https://azure.microsoft.com/documentation/articles/app-insights-analytics-reference/>`_.
         Required.
        :paramtype query: str
        :keyword timespan: Optional. The timespan over which to query data. This is an ISO8601 time
         period value.  This timespan is applied in addition to any that are specified in the query
         expression. Default value is None.
        :paramtype timespan: ~datetime.timedelta
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "tables": [
                        {
                            "columns": [
                                {
                                    "name": "str",
                                    "type": "str"
                                }
                            ],
                            "name": "str",
                            "rows": [
                                [
                                    {}
                                ]
                            ]
                        }
                    ],
                    "error": {
                        "code": "str",
                        "message": "str",
                        "details": [
                            {
                                "code": "str",
                                "message": "str",
                                "resources": [
                                    "str"
                                ],
                                "target": "str",
                                "value": "str"
                            }
                        ],
                        "innererror": ...
                    },
                    "render": {},
                    "statistics": {}
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_query_get_request(
            workspace_id=workspace_id,
            query=query,
            timespan=timespan,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @overload
    async def execute(
        self,
        workspace_id: str,
        body: JSON,
        *,
        prefer: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> JSON:
        """Execute an Analytics query.

        Executes an Analytics query for data. `Here
        <https://learn.microsoft.com/azure/azure-monitor/logs/api/request-format>`_ is an example for
        using POST with an Analytics query.

        :param workspace_id: Primary Workspace ID of the query. This is the Workspace ID from the
         Properties blade in the Azure portal. Required.
        :type workspace_id: str
        :param body: The Analytics query. Learn more about the `Analytics query syntax
         <https://azure.microsoft.com/documentation/articles/app-insights-analytics-reference/>`_.
         Required.
        :type body: JSON
        :keyword prefer: Optional. The prefer header to set server timeout, query statistics and
         visualization information. Default value is None.
        :paramtype prefer: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "query": "str",
                    "timespan": "str",
                    "workspaces": [
                        "str"
                    ]
                }

                # response body for status code(s): 200
                response == {
                    "tables": [
                        {
                            "columns": [
                                {
                                    "name": "str",
                                    "type": "str"
                                }
                            ],
                            "name": "str",
                            "rows": [
                                [
                                    {}
                                ]
                            ]
                        }
                    ],
                    "error": {
                        "code": "str",
                        "message": "str",
                        "details": [
                            {
                                "code": "str",
                                "message": "str",
                                "resources": [
                                    "str"
                                ],
                                "target": "str",
                                "value": "str"
                            }
                        ],
                        "innererror": ...
                    },
                    "render": {},
                    "statistics": {}
                }
        """

    @overload
    async def execute(
        self,
        workspace_id: str,
        body: IO[bytes],
        *,
        prefer: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> JSON:
        """Execute an Analytics query.

        Executes an Analytics query for data. `Here
        <https://learn.microsoft.com/azure/azure-monitor/logs/api/request-format>`_ is an example for
        using POST with an Analytics query.

        :param workspace_id: Primary Workspace ID of the query. This is the Workspace ID from the
         Properties blade in the Azure portal. Required.
        :type workspace_id: str
        :param body: The Analytics query. Learn more about the `Analytics query syntax
         <https://azure.microsoft.com/documentation/articles/app-insights-analytics-reference/>`_.
         Required.
        :type body: IO[bytes]
        :keyword prefer: Optional. The prefer header to set server timeout, query statistics and
         visualization information. Default value is None.
        :paramtype prefer: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "tables": [
                        {
                            "columns": [
                                {
                                    "name": "str",
                                    "type": "str"
                                }
                            ],
                            "name": "str",
                            "rows": [
                                [
                                    {}
                                ]
                            ]
                        }
                    ],
                    "error": {
                        "code": "str",
                        "message": "str",
                        "details": [
                            {
                                "code": "str",
                                "message": "str",
                                "resources": [
                                    "str"
                                ],
                                "target": "str",
                                "value": "str"
                            }
                        ],
                        "innererror": ...
                    },
                    "render": {},
                    "statistics": {}
                }
        """

    @distributed_trace_async
    async def execute(
        self, workspace_id: str, body: Union[JSON, IO[bytes]], *, prefer: Optional[str] = None, **kwargs: Any
    ) -> JSON:
        """Execute an Analytics query.

        Executes an Analytics query for data. `Here
        <https://learn.microsoft.com/azure/azure-monitor/logs/api/request-format>`_ is an example for
        using POST with an Analytics query.

        :param workspace_id: Primary Workspace ID of the query. This is the Workspace ID from the
         Properties blade in the Azure portal. Required.
        :type workspace_id: str
        :param body: The Analytics query. Learn more about the `Analytics query syntax
         <https://azure.microsoft.com/documentation/articles/app-insights-analytics-reference/>`_. Is
         either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword prefer: Optional. The prefer header to set server timeout, query statistics and
         visualization information. Default value is None.
        :paramtype prefer: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "query": "str",
                    "timespan": "str",
                    "workspaces": [
                        "str"
                    ]
                }

                # response body for status code(s): 200
                response == {
                    "tables": [
                        {
                            "columns": [
                                {
                                    "name": "str",
                                    "type": "str"
                                }
                            ],
                            "name": "str",
                            "rows": [
                                [
                                    {}
                                ]
                            ]
                        }
                    ],
                    "error": {
                        "code": "str",
                        "message": "str",
                        "details": [
                            {
                                "code": "str",
                                "message": "str",
                                "resources": [
                                    "str"
                                ],
                                "target": "str",
                                "value": "str"
                            }
                        ],
                        "innererror": ...
                    },
                    "render": {},
                    "statistics": {}
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_query_execute_request(
            workspace_id=workspace_id,
            prefer=prefer,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def resource_get(
        self, resource_id: str, *, query: str, timespan: Optional[datetime.timedelta] = None, **kwargs: Any
    ) -> JSON:
        """Execute an Analytics query using resource URI.

        Executes an Analytics query for data in the context of a resource. `Here
        <https://learn.microsoft.com/azure/azure-monitor/logs/api/azure-resource-queries>`_ is an
        example for using POST with an Analytics query.

        :param resource_id: The identifier of the resource. Required.
        :type resource_id: str
        :keyword query: The Analytics query. Learn more about the `Analytics query syntax
         <https://azure.microsoft.com/documentation/articles/app-insights-analytics-reference/>`_.
         Required.
        :paramtype query: str
        :keyword timespan: Optional. The timespan over which to query data. This is an ISO8601 time
         period value.  This timespan is applied in addition to any that are specified in the query
         expression. Default value is None.
        :paramtype timespan: ~datetime.timedelta
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "tables": [
                        {
                            "columns": [
                                {
                                    "name": "str",
                                    "type": "str"
                                }
                            ],
                            "name": "str",
                            "rows": [
                                [
                                    {}
                                ]
                            ]
                        }
                    ],
                    "error": {
                        "code": "str",
                        "message": "str",
                        "details": [
                            {
                                "code": "str",
                                "message": "str",
                                "resources": [
                                    "str"
                                ],
                                "target": "str",
                                "value": "str"
                            }
                        ],
                        "innererror": ...
                    },
                    "render": {},
                    "statistics": {}
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_query_resource_get_request(
            resource_id=resource_id,
            query=query,
            timespan=timespan,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @overload
    async def resource_execute(
        self,
        resource_id: str,
        body: JSON,
        *,
        prefer: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> JSON:
        """Execute an Analytics query using resource ID.

        Executes an Analytics query for data in the context of a resource. `Here
        <https://learn.microsoft.com/azure/azure-monitor/logs/api/azure-resource-queries>`_ is an
        example for using POST with an Analytics query.

        :param resource_id: The identifier of the resource. Required.
        :type resource_id: str
        :param body: The Analytics query. Learn more about the `Analytics query syntax
         <https://azure.microsoft.com/documentation/articles/app-insights-analytics-reference/>`_.
         Required.
        :type body: JSON
        :keyword prefer: Optional. The prefer header to set server timeout, query statistics and
         visualization information. Default value is None.
        :paramtype prefer: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "query": "str",
                    "timespan": "str",
                    "workspaces": [
                        "str"
                    ]
                }

                # response body for status code(s): 200
                response == {
                    "tables": [
                        {
                            "columns": [
                                {
                                    "name": "str",
                                    "type": "str"
                                }
                            ],
                            "name": "str",
                            "rows": [
                                [
                                    {}
                                ]
                            ]
                        }
                    ],
                    "error": {
                        "code": "str",
                        "message": "str",
                        "details": [
                            {
                                "code": "str",
                                "message": "str",
                                "resources": [
                                    "str"
                                ],
                                "target": "str",
                                "value": "str"
                            }
                        ],
                        "innererror": ...
                    },
                    "render": {},
                    "statistics": {}
                }
        """

    @overload
    async def resource_execute(
        self,
        resource_id: str,
        body: IO[bytes],
        *,
        prefer: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> JSON:
        """Execute an Analytics query using resource ID.

        Executes an Analytics query for data in the context of a resource. `Here
        <https://learn.microsoft.com/azure/azure-monitor/logs/api/azure-resource-queries>`_ is an
        example for using POST with an Analytics query.

        :param resource_id: The identifier of the resource. Required.
        :type resource_id: str
        :param body: The Analytics query. Learn more about the `Analytics query syntax
         <https://azure.microsoft.com/documentation/articles/app-insights-analytics-reference/>`_.
         Required.
        :type body: IO[bytes]
        :keyword prefer: Optional. The prefer header to set server timeout, query statistics and
         visualization information. Default value is None.
        :paramtype prefer: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "tables": [
                        {
                            "columns": [
                                {
                                    "name": "str",
                                    "type": "str"
                                }
                            ],
                            "name": "str",
                            "rows": [
                                [
                                    {}
                                ]
                            ]
                        }
                    ],
                    "error": {
                        "code": "str",
                        "message": "str",
                        "details": [
                            {
                                "code": "str",
                                "message": "str",
                                "resources": [
                                    "str"
                                ],
                                "target": "str",
                                "value": "str"
                            }
                        ],
                        "innererror": ...
                    },
                    "render": {},
                    "statistics": {}
                }
        """

    @distributed_trace_async
    async def resource_execute(
        self, resource_id: str, body: Union[JSON, IO[bytes]], *, prefer: Optional[str] = None, **kwargs: Any
    ) -> JSON:
        """Execute an Analytics query using resource ID.

        Executes an Analytics query for data in the context of a resource. `Here
        <https://learn.microsoft.com/azure/azure-monitor/logs/api/azure-resource-queries>`_ is an
        example for using POST with an Analytics query.

        :param resource_id: The identifier of the resource. Required.
        :type resource_id: str
        :param body: The Analytics query. Learn more about the `Analytics query syntax
         <https://azure.microsoft.com/documentation/articles/app-insights-analytics-reference/>`_. Is
         either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword prefer: Optional. The prefer header to set server timeout, query statistics and
         visualization information. Default value is None.
        :paramtype prefer: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "query": "str",
                    "timespan": "str",
                    "workspaces": [
                        "str"
                    ]
                }

                # response body for status code(s): 200
                response == {
                    "tables": [
                        {
                            "columns": [
                                {
                                    "name": "str",
                                    "type": "str"
                                }
                            ],
                            "name": "str",
                            "rows": [
                                [
                                    {}
                                ]
                            ]
                        }
                    ],
                    "error": {
                        "code": "str",
                        "message": "str",
                        "details": [
                            {
                                "code": "str",
                                "message": "str",
                                "resources": [
                                    "str"
                                ],
                                "target": "str",
                                "value": "str"
                            }
                        ],
                        "innererror": ...
                    },
                    "render": {},
                    "statistics": {}
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_query_resource_execute_request(
            resource_id=resource_id,
            prefer=prefer,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @overload
    async def batch(self, body: JSON, *, content_type: str = "application/json", **kwargs: Any) -> JSON:
        """Execute a batch of Analytics queries.

        Executes a batch of Analytics queries for data. `Here
        <https://learn.microsoft.com/azure/azure-monitor/logs/api/batch-queries>`_ is an example for
        using POST with an Analytics query.

        :param body: The batch request body. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "requests": [
                        {
                            "body": {
                                "query": "str",
                                "timespan": "str",
                                "workspaces": [
                                    "str"
                                ]
                            },
                            "id": "str",
                            "workspace": "str",
                            "headers": {
                                "str": "str"
                            },
                            "method": "POST",
                            "path": "/query"
                        }
                    ]
                }

                # response body for status code(s): 200
                response == {
                    "responses": [
                        {
                            "body": {
                                "error": {
                                    "code": "str",
                                    "message": "str",
                                    "details": [
                                        {
                                            "code": "str",
                                            "message": "str",
                                            "resources": [
                                                "str"
                                            ],
                                            "target": "str",
                                            "value": "str"
                                        }
                                    ],
                                    "innererror": ...
                                },
                                "render": {},
                                "statistics": {},
                                "tables": [
                                    {
                                        "columns": [
                                            {
                                                "name": "str",
                                                "type": "str"
                                            }
                                        ],
                                        "name": "str",
                                        "rows": [
                                            [
                                                {}
                                            ]
                                        ]
                                    }
                                ]
                            },
                            "headers": {
                                "str": "str"
                            },
                            "id": "str",
                            "status": 0
                        }
                    ]
                }
        """

    @overload
    async def batch(self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any) -> JSON:
        """Execute a batch of Analytics queries.

        Executes a batch of Analytics queries for data. `Here
        <https://learn.microsoft.com/azure/azure-monitor/logs/api/batch-queries>`_ is an example for
        using POST with an Analytics query.

        :param body: The batch request body. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "responses": [
                        {
                            "body": {
                                "error": {
                                    "code": "str",
                                    "message": "str",
                                    "details": [
                                        {
                                            "code": "str",
                                            "message": "str",
                                            "resources": [
                                                "str"
                                            ],
                                            "target": "str",
                                            "value": "str"
                                        }
                                    ],
                                    "innererror": ...
                                },
                                "render": {},
                                "statistics": {},
                                "tables": [
                                    {
                                        "columns": [
                                            {
                                                "name": "str",
                                                "type": "str"
                                            }
                                        ],
                                        "name": "str",
                                        "rows": [
                                            [
                                                {}
                                            ]
                                        ]
                                    }
                                ]
                            },
                            "headers": {
                                "str": "str"
                            },
                            "id": "str",
                            "status": 0
                        }
                    ]
                }
        """

    @distributed_trace_async
    async def batch(self, body: Union[JSON, IO[bytes]], **kwargs: Any) -> JSON:
        """Execute a batch of Analytics queries.

        Executes a batch of Analytics queries for data. `Here
        <https://learn.microsoft.com/azure/azure-monitor/logs/api/batch-queries>`_ is an example for
        using POST with an Analytics query.

        :param body: The batch request body. Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "requests": [
                        {
                            "body": {
                                "query": "str",
                                "timespan": "str",
                                "workspaces": [
                                    "str"
                                ]
                            },
                            "id": "str",
                            "workspace": "str",
                            "headers": {
                                "str": "str"
                            },
                            "method": "POST",
                            "path": "/query"
                        }
                    ]
                }

                # response body for status code(s): 200
                response == {
                    "responses": [
                        {
                            "body": {
                                "error": {
                                    "code": "str",
                                    "message": "str",
                                    "details": [
                                        {
                                            "code": "str",
                                            "message": "str",
                                            "resources": [
                                                "str"
                                            ],
                                            "target": "str",
                                            "value": "str"
                                        }
                                    ],
                                    "innererror": ...
                                },
                                "render": {},
                                "statistics": {},
                                "tables": [
                                    {
                                        "columns": [
                                            {
                                                "name": "str",
                                                "type": "str"
                                            }
                                        ],
                                        "name": "str",
                                        "rows": [
                                            [
                                                {}
                                            ]
                                        ]
                                    }
                                ]
                            },
                            "headers": {
                                "str": "str"
                            },
                            "id": "str",
                            "status": 0
                        }
                    ]
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_query_batch_request(
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def resource_get_xms(
        self, resource_id: str, *, query: str, timespan: Optional[datetime.timedelta] = None, **kwargs: Any
    ) -> JSON:
        """Execute an Analytics query using resource URI.

        Executes an Analytics query for data in the context of a resource. `Here
        <https://learn.microsoft.com/azure/azure-monitor/logs/api/azure-resource-queries>`_ is an
        example for using POST with an Analytics query.

        :param resource_id: The identifier of the resource. Required.
        :type resource_id: str
        :keyword query: The Analytics query. Learn more about the `Analytics query syntax
         <https://azure.microsoft.com/documentation/articles/app-insights-analytics-reference/>`_.
         Required.
        :paramtype query: str
        :keyword timespan: Optional. The timespan over which to query data. This is an ISO8601 time
         period value.  This timespan is applied in addition to any that are specified in the query
         expression. Default value is None.
        :paramtype timespan: ~datetime.timedelta
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "tables": [
                        {
                            "columns": [
                                {
                                    "name": "str",
                                    "type": "str"
                                }
                            ],
                            "name": "str",
                            "rows": [
                                [
                                    {}
                                ]
                            ]
                        }
                    ],
                    "error": {
                        "code": "str",
                        "message": "str",
                        "details": [
                            {
                                "code": "str",
                                "message": "str",
                                "resources": [
                                    "str"
                                ],
                                "target": "str",
                                "value": "str"
                            }
                        ],
                        "innererror": ...
                    },
                    "render": {},
                    "statistics": {}
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_query_resource_get_xms_request(
            resource_id=resource_id,
            query=query,
            timespan=timespan,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @overload
    async def resource_execute_xms(
        self,
        resource_id: str,
        body: JSON,
        *,
        prefer: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> JSON:
        """Execute an Analytics query using resource ID.

        Executes an Analytics query for data in the context of a resource. `Here
        <https://learn.microsoft.com/azure/azure-monitor/logs/api/azure-resource-queries>`_ is an
        example for using POST with an Analytics query.

        :param resource_id: The identifier of the resource. Required.
        :type resource_id: str
        :param body: The Analytics query. Learn more about the `Analytics query syntax
         <https://azure.microsoft.com/documentation/articles/app-insights-analytics-reference/>`_.
         Required.
        :type body: JSON
        :keyword prefer: Optional. The prefer header to set server timeout, query statistics and
         visualization information. Default value is None.
        :paramtype prefer: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "query": "str",
                    "timespan": "str",
                    "workspaces": [
                        "str"
                    ]
                }

                # response body for status code(s): 200
                response == {
                    "tables": [
                        {
                            "columns": [
                                {
                                    "name": "str",
                                    "type": "str"
                                }
                            ],
                            "name": "str",
                            "rows": [
                                [
                                    {}
                                ]
                            ]
                        }
                    ],
                    "error": {
                        "code": "str",
                        "message": "str",
                        "details": [
                            {
                                "code": "str",
                                "message": "str",
                                "resources": [
                                    "str"
                                ],
                                "target": "str",
                                "value": "str"
                            }
                        ],
                        "innererror": ...
                    },
                    "render": {},
                    "statistics": {}
                }
        """

    @overload
    async def resource_execute_xms(
        self,
        resource_id: str,
        body: IO[bytes],
        *,
        prefer: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> JSON:
        """Execute an Analytics query using resource ID.

        Executes an Analytics query for data in the context of a resource. `Here
        <https://learn.microsoft.com/azure/azure-monitor/logs/api/azure-resource-queries>`_ is an
        example for using POST with an Analytics query.

        :param resource_id: The identifier of the resource. Required.
        :type resource_id: str
        :param body: The Analytics query. Learn more about the `Analytics query syntax
         <https://azure.microsoft.com/documentation/articles/app-insights-analytics-reference/>`_.
         Required.
        :type body: IO[bytes]
        :keyword prefer: Optional. The prefer header to set server timeout, query statistics and
         visualization information. Default value is None.
        :paramtype prefer: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "tables": [
                        {
                            "columns": [
                                {
                                    "name": "str",
                                    "type": "str"
                                }
                            ],
                            "name": "str",
                            "rows": [
                                [
                                    {}
                                ]
                            ]
                        }
                    ],
                    "error": {
                        "code": "str",
                        "message": "str",
                        "details": [
                            {
                                "code": "str",
                                "message": "str",
                                "resources": [
                                    "str"
                                ],
                                "target": "str",
                                "value": "str"
                            }
                        ],
                        "innererror": ...
                    },
                    "render": {},
                    "statistics": {}
                }
        """

    @distributed_trace_async
    async def resource_execute_xms(
        self, resource_id: str, body: Union[JSON, IO[bytes]], *, prefer: Optional[str] = None, **kwargs: Any
    ) -> JSON:
        """Execute an Analytics query using resource ID.

        Executes an Analytics query for data in the context of a resource. `Here
        <https://learn.microsoft.com/azure/azure-monitor/logs/api/azure-resource-queries>`_ is an
        example for using POST with an Analytics query.

        :param resource_id: The identifier of the resource. Required.
        :type resource_id: str
        :param body: The Analytics query. Learn more about the `Analytics query syntax
         <https://azure.microsoft.com/documentation/articles/app-insights-analytics-reference/>`_. Is
         either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword prefer: Optional. The prefer header to set server timeout, query statistics and
         visualization information. Default value is None.
        :paramtype prefer: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "query": "str",
                    "timespan": "str",
                    "workspaces": [
                        "str"
                    ]
                }

                # response body for status code(s): 200
                response == {
                    "tables": [
                        {
                            "columns": [
                                {
                                    "name": "str",
                                    "type": "str"
                                }
                            ],
                            "name": "str",
                            "rows": [
                                [
                                    {}
                                ]
                            ]
                        }
                    ],
                    "error": {
                        "code": "str",
                        "message": "str",
                        "details": [
                            {
                                "code": "str",
                                "message": "str",
                                "resources": [
                                    "str"
                                ],
                                "target": "str",
                                "value": "str"
                            }
                        ],
                        "innererror": ...
                    },
                    "render": {},
                    "statistics": {}
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = body

        _request = build_query_resource_execute_xms_request(
            resource_id=resource_id,
            prefer=prefer,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore


class MetadataOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~monitor_query_client.aio.MonitorQueryClient`'s
        :attr:`metadata` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def get(self, workspace_id: str, **kwargs: Any) -> JSON:
        """Gets metadata information.

        Retrieve the metadata information for the workspace, including its schema, functions, workspace
        info, categories etc.

        :param workspace_id: Primary Workspace ID of the query. This is the Workspace ID from the
         Properties blade in the Azure portal. Required.
        :type workspace_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "applications": [
                        {
                            "id": "str",
                            "name": "str",
                            "region": "str",
                            "resourceId": "str",
                            "related": {
                                "functions": [
                                    "str"
                                ],
                                "tables": [
                                    "str"
                                ]
                            }
                        }
                    ],
                    "categories": [
                        {
                            "displayName": "str",
                            "id": "str",
                            "description": "str",
                            "related": {
                                "functions": [
                                    "str"
                                ],
                                "queries": [
                                    "str"
                                ],
                                "resourceTypes": [
                                    "str"
                                ],
                                "solutions": [
                                    "str"
                                ],
                                "tables": [
                                    "str"
                                ]
                            }
                        }
                    ],
                    "functions": [
                        {
                            "body": "str",
                            "id": "str",
                            "name": "str",
                            "description": "str",
                            "displayName": "str",
                            "parameters": "str",
                            "properties": {},
                            "related": {
                                "categories": [
                                    "str"
                                ],
                                "resourceTypes": [
                                    "str"
                                ],
                                "solutions": [
                                    "str"
                                ],
                                "tables": [
                                    "str"
                                ],
                                "workspaces": [
                                    "str"
                                ]
                            },
                            "tags": {}
                        }
                    ],
                    "permissions": [
                        {
                            "workspaces": [
                                {
                                    "resourceId": "str",
                                    "denyTables": [
                                        "str"
                                    ]
                                }
                            ],
                            "applications": [
                                {
                                    "resourceId": "str"
                                }
                            ],
                            "resources": [
                                {
                                    "resourceId": "str",
                                    "denyTables": [
                                        "str"
                                    ]
                                }
                            ]
                        }
                    ],
                    "queries": [
                        {
                            "body": "str",
                            "id": "str",
                            "description": "str",
                            "displayName": "str",
                            "labels": [
                                "str"
                            ],
                            "properties": {},
                            "related": {
                                "categories": [
                                    "str"
                                ],
                                "resourceTypes": [
                                    "str"
                                ],
                                "solutions": [
                                    "str"
                                ],
                                "tables": [
                                    "str"
                                ]
                            },
                            "tags": {}
                        }
                    ],
                    "resourceTypes": [
                        {
                            "id": "str",
                            "type": "str",
                            "description": "str",
                            "displayName": "str",
                            "labels": [
                                "str"
                            ],
                            "properties": {},
                            "related": {
                                "categories": [
                                    "str"
                                ],
                                "functions": [
                                    "str"
                                ],
                                "queries": [
                                    "str"
                                ],
                                "resources": [
                                    "str"
                                ],
                                "tables": [
                                    "str"
                                ],
                                "workspaces": [
                                    "str"
                                ]
                            },
                            "tags": {}
                        }
                    ],
                    "resources": [
                        {}
                    ],
                    "solutions": [
                        {
                            "id": "str",
                            "name": "str",
                            "related": {
                                "tables": [
                                    "str"
                                ],
                                "categories": [
                                    "str"
                                ],
                                "functions": [
                                    "str"
                                ],
                                "queries": [
                                    "str"
                                ],
                                "workspaces": [
                                    "str"
                                ]
                            },
                            "description": "str",
                            "displayName": "str",
                            "properties": {},
                            "tags": {}
                        }
                    ],
                    "tables": [
                        {
                            "id": "str",
                            "name": "str",
                            "columns": [
                                {
                                    "name": "str",
                                    "type": "str",
                                    "description": "str",
                                    "isPreferredFacet": bool,
                                    "source": {}
                                }
                            ],
                            "description": "str",
                            "labels": [
                                "str"
                            ],
                            "properties": {},
                            "related": {
                                "categories": [
                                    "str"
                                ],
                                "functions": [
                                    "str"
                                ],
                                "queries": [
                                    "str"
                                ],
                                "resourceTypes": [
                                    "str"
                                ],
                                "solutions": [
                                    "str"
                                ],
                                "workspaces": [
                                    "str"
                                ]
                            },
                            "tags": {},
                            "timespanColumn": "str"
                        }
                    ],
                    "workspaces": [
                        {
                            "id": "str",
                            "name": "str",
                            "region": "str",
                            "resourceId": "str",
                            "related": {
                                "functions": [
                                    "str"
                                ],
                                "resourceTypes": [
                                    "str"
                                ],
                                "resources": [
                                    "str"
                                ],
                                "solutions": [
                                    "str"
                                ],
                                "tables": [
                                    "str"
                                ]
                            }
                        }
                    ]
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_metadata_get_request(
            workspace_id=workspace_id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def post(self, workspace_id: str, **kwargs: Any) -> JSON:
        """Gets metadata information.

        Retrieve the metadata information for the workspace, including its schema, functions, workspace
        info, categories etc.

        :param workspace_id: Primary Workspace ID of the query. This is the Workspace ID from the
         Properties blade in the Azure portal. Required.
        :type workspace_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "applications": [
                        {
                            "id": "str",
                            "name": "str",
                            "region": "str",
                            "resourceId": "str",
                            "related": {
                                "functions": [
                                    "str"
                                ],
                                "tables": [
                                    "str"
                                ]
                            }
                        }
                    ],
                    "categories": [
                        {
                            "displayName": "str",
                            "id": "str",
                            "description": "str",
                            "related": {
                                "functions": [
                                    "str"
                                ],
                                "queries": [
                                    "str"
                                ],
                                "resourceTypes": [
                                    "str"
                                ],
                                "solutions": [
                                    "str"
                                ],
                                "tables": [
                                    "str"
                                ]
                            }
                        }
                    ],
                    "functions": [
                        {
                            "body": "str",
                            "id": "str",
                            "name": "str",
                            "description": "str",
                            "displayName": "str",
                            "parameters": "str",
                            "properties": {},
                            "related": {
                                "categories": [
                                    "str"
                                ],
                                "resourceTypes": [
                                    "str"
                                ],
                                "solutions": [
                                    "str"
                                ],
                                "tables": [
                                    "str"
                                ],
                                "workspaces": [
                                    "str"
                                ]
                            },
                            "tags": {}
                        }
                    ],
                    "permissions": [
                        {
                            "workspaces": [
                                {
                                    "resourceId": "str",
                                    "denyTables": [
                                        "str"
                                    ]
                                }
                            ],
                            "applications": [
                                {
                                    "resourceId": "str"
                                }
                            ],
                            "resources": [
                                {
                                    "resourceId": "str",
                                    "denyTables": [
                                        "str"
                                    ]
                                }
                            ]
                        }
                    ],
                    "queries": [
                        {
                            "body": "str",
                            "id": "str",
                            "description": "str",
                            "displayName": "str",
                            "labels": [
                                "str"
                            ],
                            "properties": {},
                            "related": {
                                "categories": [
                                    "str"
                                ],
                                "resourceTypes": [
                                    "str"
                                ],
                                "solutions": [
                                    "str"
                                ],
                                "tables": [
                                    "str"
                                ]
                            },
                            "tags": {}
                        }
                    ],
                    "resourceTypes": [
                        {
                            "id": "str",
                            "type": "str",
                            "description": "str",
                            "displayName": "str",
                            "labels": [
                                "str"
                            ],
                            "properties": {},
                            "related": {
                                "categories": [
                                    "str"
                                ],
                                "functions": [
                                    "str"
                                ],
                                "queries": [
                                    "str"
                                ],
                                "resources": [
                                    "str"
                                ],
                                "tables": [
                                    "str"
                                ],
                                "workspaces": [
                                    "str"
                                ]
                            },
                            "tags": {}
                        }
                    ],
                    "resources": [
                        {}
                    ],
                    "solutions": [
                        {
                            "id": "str",
                            "name": "str",
                            "related": {
                                "tables": [
                                    "str"
                                ],
                                "categories": [
                                    "str"
                                ],
                                "functions": [
                                    "str"
                                ],
                                "queries": [
                                    "str"
                                ],
                                "workspaces": [
                                    "str"
                                ]
                            },
                            "description": "str",
                            "displayName": "str",
                            "properties": {},
                            "tags": {}
                        }
                    ],
                    "tables": [
                        {
                            "id": "str",
                            "name": "str",
                            "columns": [
                                {
                                    "name": "str",
                                    "type": "str",
                                    "description": "str",
                                    "isPreferredFacet": bool,
                                    "source": {}
                                }
                            ],
                            "description": "str",
                            "labels": [
                                "str"
                            ],
                            "properties": {},
                            "related": {
                                "categories": [
                                    "str"
                                ],
                                "functions": [
                                    "str"
                                ],
                                "queries": [
                                    "str"
                                ],
                                "resourceTypes": [
                                    "str"
                                ],
                                "solutions": [
                                    "str"
                                ],
                                "workspaces": [
                                    "str"
                                ]
                            },
                            "tags": {},
                            "timespanColumn": "str"
                        }
                    ],
                    "workspaces": [
                        {
                            "id": "str",
                            "name": "str",
                            "region": "str",
                            "resourceId": "str",
                            "related": {
                                "functions": [
                                    "str"
                                ],
                                "resourceTypes": [
                                    "str"
                                ],
                                "resources": [
                                    "str"
                                ],
                                "solutions": [
                                    "str"
                                ],
                                "tables": [
                                    "str"
                                ]
                            }
                        }
                    ]
                }
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_metadata_post_request(
            workspace_id=workspace_id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore
