# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, TYPE_CHECKING
from typing_extensions import Self

from azure.core.pipeline import policies
from azure.core.rest import HttpRequest, HttpResponse
from azure.mgmt.core import ARMPipelineClient
from azure.mgmt.core.policies import ARMAutoResourceProviderRegistrationPolicy

from . import models as _models
from ._configuration import CognitiveServicesManagementClientConfiguration
from ._serialization import Deserializer, Serializer
from .operations import (
    AccountsOperations,
    CognitiveServicesManagementClientOperationsMixin,
    CommitmentPlansOperations,
    CommitmentTiersOperations,
    DefenderForAISettingsOperations,
    DeletedAccountsOperations,
    DeploymentsOperations,
    EncryptionScopesOperations,
    LocationBasedModelCapacitiesOperations,
    ModelCapacitiesOperations,
    ModelsOperations,
    NetworkSecurityPerimeterConfigurationsOperations,
    Operations,
    PrivateEndpointConnectionsOperations,
    PrivateLinkResourcesOperations,
    RaiBlocklistItemsOperations,
    RaiBlocklistsOperations,
    RaiContentFiltersOperations,
    RaiPoliciesOperations,
    ResourceSkusOperations,
    UsagesOperations,
)

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials import TokenCredential


class CognitiveServicesManagementClient(
    CognitiveServicesManagementClientOperationsMixin
):  # pylint: disable=client-accepts-api-version-keyword,too-many-instance-attributes
    """Cognitive Services Management Client.

    :ivar accounts: AccountsOperations operations
    :vartype accounts: azure.mgmt.cognitiveservices.operations.AccountsOperations
    :ivar deleted_accounts: DeletedAccountsOperations operations
    :vartype deleted_accounts: azure.mgmt.cognitiveservices.operations.DeletedAccountsOperations
    :ivar resource_skus: ResourceSkusOperations operations
    :vartype resource_skus: azure.mgmt.cognitiveservices.operations.ResourceSkusOperations
    :ivar usages: UsagesOperations operations
    :vartype usages: azure.mgmt.cognitiveservices.operations.UsagesOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.cognitiveservices.operations.Operations
    :ivar commitment_tiers: CommitmentTiersOperations operations
    :vartype commitment_tiers: azure.mgmt.cognitiveservices.operations.CommitmentTiersOperations
    :ivar models: ModelsOperations operations
    :vartype models: azure.mgmt.cognitiveservices.operations.ModelsOperations
    :ivar location_based_model_capacities: LocationBasedModelCapacitiesOperations operations
    :vartype location_based_model_capacities:
     azure.mgmt.cognitiveservices.operations.LocationBasedModelCapacitiesOperations
    :ivar model_capacities: ModelCapacitiesOperations operations
    :vartype model_capacities: azure.mgmt.cognitiveservices.operations.ModelCapacitiesOperations
    :ivar private_endpoint_connections: PrivateEndpointConnectionsOperations operations
    :vartype private_endpoint_connections:
     azure.mgmt.cognitiveservices.operations.PrivateEndpointConnectionsOperations
    :ivar private_link_resources: PrivateLinkResourcesOperations operations
    :vartype private_link_resources:
     azure.mgmt.cognitiveservices.operations.PrivateLinkResourcesOperations
    :ivar deployments: DeploymentsOperations operations
    :vartype deployments: azure.mgmt.cognitiveservices.operations.DeploymentsOperations
    :ivar commitment_plans: CommitmentPlansOperations operations
    :vartype commitment_plans: azure.mgmt.cognitiveservices.operations.CommitmentPlansOperations
    :ivar encryption_scopes: EncryptionScopesOperations operations
    :vartype encryption_scopes: azure.mgmt.cognitiveservices.operations.EncryptionScopesOperations
    :ivar rai_policies: RaiPoliciesOperations operations
    :vartype rai_policies: azure.mgmt.cognitiveservices.operations.RaiPoliciesOperations
    :ivar rai_blocklists: RaiBlocklistsOperations operations
    :vartype rai_blocklists: azure.mgmt.cognitiveservices.operations.RaiBlocklistsOperations
    :ivar rai_blocklist_items: RaiBlocklistItemsOperations operations
    :vartype rai_blocklist_items:
     azure.mgmt.cognitiveservices.operations.RaiBlocklistItemsOperations
    :ivar rai_content_filters: RaiContentFiltersOperations operations
    :vartype rai_content_filters:
     azure.mgmt.cognitiveservices.operations.RaiContentFiltersOperations
    :ivar network_security_perimeter_configurations:
     NetworkSecurityPerimeterConfigurationsOperations operations
    :vartype network_security_perimeter_configurations:
     azure.mgmt.cognitiveservices.operations.NetworkSecurityPerimeterConfigurationsOperations
    :ivar defender_for_ai_settings: DefenderForAISettingsOperations operations
    :vartype defender_for_ai_settings:
     azure.mgmt.cognitiveservices.operations.DefenderForAISettingsOperations
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials.TokenCredential
    :param subscription_id: The ID of the target subscription. Required.
    :type subscription_id: str
    :param base_url: Service URL. Default value is "https://management.azure.com".
    :type base_url: str
    :keyword api_version: Api Version. Default value is "2024-10-01". Note that overriding this
     default value may result in unsupported behavior.
    :paramtype api_version: str
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(
        self,
        credential: "TokenCredential",
        subscription_id: str,
        base_url: str = "https://management.azure.com",
        **kwargs: Any
    ) -> None:
        self._config = CognitiveServicesManagementClientConfiguration(
            credential=credential, subscription_id=subscription_id, **kwargs
        )
        _policies = kwargs.pop("policies", None)
        if _policies is None:
            _policies = [
                policies.RequestIdPolicy(**kwargs),
                self._config.headers_policy,
                self._config.user_agent_policy,
                self._config.proxy_policy,
                policies.ContentDecodePolicy(**kwargs),
                ARMAutoResourceProviderRegistrationPolicy(),
                self._config.redirect_policy,
                self._config.retry_policy,
                self._config.authentication_policy,
                self._config.custom_hook_policy,
                self._config.logging_policy,
                policies.DistributedTracingPolicy(**kwargs),
                policies.SensitiveHeaderCleanupPolicy(**kwargs) if self._config.redirect_policy else None,
                self._config.http_logging_policy,
            ]
        self._client: ARMPipelineClient = ARMPipelineClient(base_url=base_url, policies=_policies, **kwargs)

        client_models = {k: v for k, v in _models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.accounts = AccountsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.deleted_accounts = DeletedAccountsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.resource_skus = ResourceSkusOperations(self._client, self._config, self._serialize, self._deserialize)
        self.usages = UsagesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.operations = Operations(self._client, self._config, self._serialize, self._deserialize)
        self.commitment_tiers = CommitmentTiersOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.models = ModelsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.location_based_model_capacities = LocationBasedModelCapacitiesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.model_capacities = ModelCapacitiesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.private_endpoint_connections = PrivateEndpointConnectionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.private_link_resources = PrivateLinkResourcesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.deployments = DeploymentsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.commitment_plans = CommitmentPlansOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.encryption_scopes = EncryptionScopesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.rai_policies = RaiPoliciesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.rai_blocklists = RaiBlocklistsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.rai_blocklist_items = RaiBlocklistItemsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.rai_content_filters = RaiContentFiltersOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.network_security_perimeter_configurations = NetworkSecurityPerimeterConfigurationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.defender_for_ai_settings = DefenderForAISettingsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )

    def _send_request(self, request: HttpRequest, *, stream: bool = False, **kwargs: Any) -> HttpResponse:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = client._send_request(request)
        <HttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.HttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, stream=stream, **kwargs)  # type: ignore

    def close(self) -> None:
        self._client.close()

    def __enter__(self) -> Self:
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details: Any) -> None:
        self._client.__exit__(*exc_details)
