/*
 * Decompiled with CFR 0.152.
 */
package weka.associations;

import java.util.Enumeration;
import java.util.Vector;
import weka.associations.Apriori;
import weka.associations.SingleAssociatorEnhancer;
import weka.core.Capabilities;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.MultiFilter;
import weka.filters.supervised.attribute.Discretize;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public class FilteredAssociator
extends SingleAssociatorEnhancer {
    static final long serialVersionUID = -4523450618538717400L;
    protected Filter m_Filter;
    protected Instances m_FilteredInstances;
    protected int m_ClassIndex;

    public FilteredAssociator() {
        this.m_Associator = new Apriori();
        this.m_Filter = new MultiFilter();
        ((MultiFilter)this.m_Filter).setFilters(new Filter[]{new ReplaceMissingValues()});
        this.m_ClassIndex = -1;
    }

    public String globalInfo() {
        return "Class for running an arbitrary associator on data that has been passed through an arbitrary filter. Like the associator, the structure of the filter is based exclusively on the training data and test instances will be processed by the filter without changing their structure.";
    }

    protected String defaultAssociatorString() {
        return Apriori.class.getName();
    }

    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tFull class name of filter to use, followed\n\tby filter options.\n\teg: \"weka.filters.unsupervised.attribute.Remove -V -R 1,2\"\n\t(default: weka.filters.MultiFilter with\n\tweka.filters.unsupervised.attribute.ReplaceMissingValues)", "F", 1, "-F <filter specification>"));
        result.addElement(new Option("\tThe class index.\n\t(default: -1, i.e. unset)", "c", 1, "-c <the class index>"));
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.addElement((Option)enm.nextElement());
        }
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('F', options);
        if (tmpStr.length() > 0) {
            String[] filterSpec = Utils.splitOptions(tmpStr);
            if (filterSpec.length == 0) {
                throw new IllegalArgumentException("Invalid filter specification string");
            }
            String filterName = filterSpec[0];
            filterSpec[0] = "";
            this.setFilter((Filter)Utils.forName(Filter.class, filterName, filterSpec));
        } else {
            this.setFilter(new Discretize());
        }
        tmpStr = Utils.getOption('c', options);
        if (tmpStr.length() > 0) {
            if (tmpStr.equalsIgnoreCase("last")) {
                this.setClassIndex(0);
            } else if (tmpStr.equalsIgnoreCase("first")) {
                this.setClassIndex(1);
            } else {
                this.setClassIndex(Integer.parseInt(tmpStr));
            }
        } else {
            this.setClassIndex(-1);
        }
        super.setOptions(options);
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-F");
        result.add("" + this.getFilterSpec());
        result.add("-c");
        result.add("" + this.getClassIndex());
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        return result.toArray(new String[result.size()]);
    }

    public String filterTipText() {
        return "The filter to be used.";
    }

    public void setFilter(Filter value) {
        this.m_Filter = value;
    }

    public Filter getFilter() {
        return this.m_Filter;
    }

    public String classIndexTipText() {
        return "Index of the class attribute. If set to -1, the last attribute is taken as class attribute.";
    }

    public void setClassIndex(int value) {
        this.m_ClassIndex = value;
    }

    public int getClassIndex() {
        return this.m_ClassIndex;
    }

    protected String getFilterSpec() {
        Filter c = this.getFilter();
        if (c instanceof OptionHandler) {
            return c.getClass().getName() + " " + Utils.joinOptions(((OptionHandler)((Object)c)).getOptions());
        }
        return c.getClass().getName();
    }

    public Capabilities getCapabilities() {
        Capabilities result = this.getFilter() == null ? super.getCapabilities() : this.getFilter().getCapabilities();
        result.enable(Capabilities.Capability.NO_CLASS);
        for (Capabilities.Capability cap : Capabilities.Capability.values()) {
            result.enableDependency(cap);
        }
        return result;
    }

    public void buildAssociations(Instances data) throws Exception {
        if (this.m_Associator == null) {
            throw new Exception("No base associator has been set!");
        }
        data = new Instances(data);
        if (this.getClassIndex() == 0) {
            data.setClassIndex(data.numAttributes() - 1);
        } else {
            data.setClassIndex(this.getClassIndex() - 1);
        }
        if (this.getClassIndex() != -1) {
            data.deleteWithMissingClass();
        }
        this.m_Filter.setInputFormat(data);
        data = Filter.useFilter(data, this.m_Filter);
        this.getAssociator().getCapabilities().testWithFail(data);
        this.m_FilteredInstances = data.stringFreeStructure();
        this.m_Associator.buildAssociations(data);
    }

    public String toString() {
        String result = this.m_FilteredInstances == null ? "FilteredAssociator: No model built yet." : "FilteredAssociator using " + this.getAssociatorSpec() + " on data filtered through " + this.getFilterSpec() + "\n\nFiltered Header\n" + this.m_FilteredInstances.toString() + "\n\nAssociator Model\n" + this.m_Associator.toString();
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5504 $");
    }

    public static void main(String[] args) {
        FilteredAssociator.runAssociator(new FilteredAssociator(), args);
    }
}

