# Bitflow lib and include path
# These variables are set:
#
#   BITFLOW_FOUND
#   BITFLOW_INCLUDE_DIR
#   BITFLOW_LIBRARIES
#
# Only works on Windows

if (BITFLOW_INCLUDE_DIR)
  # Already in cache, be silent
  set (Bitflow_FIND_QUIETLY TRUE)
endif ()

FIND_PATH (BITFLOW_SDK_DIR "include/BFApi.h" "C:/BitFlow SDK 4.00"
  DOC "Path to Bitflow SDK")

FIND_PATH (BITFLOW_INCLUDE_DIR "BFApi.h" 
  "${BITFLOW_SDK_DIR}/include"
  "C:/BitFlow SDK 4.00/include"
  DOC "Path to Bitflow include files")
FIND_PATH (BITFLOW_LIBRARY_PATH "BFD.lib"
  "${BITFLOW_SDK_DIR}/lib"
  "C:/BitFlow SDK 4.00/lib"
  DOC "Path to Bitflow libraries.")

FIND_LIBRARY (BITFLOW_BFD_LIB BFD ${BITFLOW_LIBRARY_PATH})
FIND_LIBRARY (BITFLOW_R2D_LIB R2d ${BITFLOW_LIBRARY_PATH})
FIND_LIBRARY (BITFLOW_DISPSURF_LIB DispSurf ${BITFLOW_LIBRARY_PATH})

if (BITFLOW_BFD_LIB AND BITFLOW_R2D_LIB AND BITFLOW_DISPSURF_LIB)
  set (BITFLOW_LIBRARIES 
    ${BITFLOW_BFD_LIB} ${BITFLOW_R2D_LIB} ${BITFLOW_DISPSURF_LIB})
else ()
  set (BITFLOW_LIBRARIES)
endif ()

INCLUDE (FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS (Bitflow DEFAULT_MSG 
  BITFLOW_LIBRARIES BITFLOW_INCLUDE_DIR)

MARK_AS_ADVANCED (
  BITFLOW_INCLUDE_DIR
  BITFLOW_LIBRARY_PATH
  BITFLOW_BFD_LIB
  BITFLOW_R2D_LIB
  BITFLOW_DISPSURF_LIB)
