/*
 *  PlanFacile (Easy plan, in french) is a small tool to help people to
 *  write a document on a particular subject.
 *  Copyright (C) 2005  Julien BRUGUIER
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __COMMANDEHEAD__
#define __COMMANDEHEAD__

#include <src/global/global.h>

typedef struct commandehead CONTENEUR(CommandeHead);

#include <src/donnees/flux/flux.h>
#include <src/donnees/flux/actionflux.h>
#include <src/donnees/commandes/localisationfichier.h>

struct commandehead
{
	STOCKAGE(LocalisationFichier) localisation;
	//Localisation de la commande d'entte dans le source.
	STOCKAGE(Flux) entete;
	//Texte de l'entte du document.
	//Ce flux est de type FLUX_DOCUMENT.
};
/* Commande dsigne pour recevoir l'entte du document  gnrer.
 */

Resultat commandehead_initialisation(TRAVAIL(CommandeHead) commandehead);
/* Cre une commande d'entte de document vide.
 * Renvoie RESULTAT_ERREUR_MEMOIRE si une allocation choue.
 */

Resultat commandehead_definition_localisationfichier(TRAVAIL(CommandeHead) commandehead , TRAVAIL(LocalisationFichier) localisationfichier);
/* Indique la position d'une commande head.
 * Renvoie RESULTAT_ERREUR si commandehead est NULL.
 * Renvoie RESULTAT_ERREUR_MEMOIRE si une allocation choue.
 */

Resultat commandehead_definition_entete(TRAVAIL(CommandeHead) commandehead , TRAVAIL(Flux) entete);
/* Assigne une entte  une commande head.
 * Renvoie RESULTAT_ERREUR si commandehead est NULL.
 * Renvoie RESULTAT_ERREUR_MEMOIRE si une allocation choue.
 */

Resultat commandehead_lecture_localisationfichier(TRAVAIL(CommandeHead) commandehead , REFERENCE(LocalisationFichier) localisationfichier);
/* Indique la position d'une commande head.
 * Renvoie RESULTAT_ERREUR si commandehead est NULL.
 */

Resultat commandehead_lecture_entete(TRAVAIL(CommandeHead) commandehead , REFERENCE(Flux) entete);
/* Lit une entte  une commande head.
 * Renvoie RESULTAT_ERREUR si commandehead est NULL.
 */

Resultat commandehead_parcours(TRAVAIL(CommandeHead) commandehead , TRAVAIL(ActionFlux) action , TRAVAIL(General) general);
/* Ralise un parcours des flux inclus dans la commande spcifie.
 * Renvoie les mmes erreurs que flux_parcours,
 * ainsi que RESULTAT_ERREUR si commande est NULL,
 * rien ne se passe si action est NULL.
 */

Resultat commandehead_copie(TRAVAIL(CommandeHead) commandehead , TRAVAIL(CommandeHead) copie);
/* Cre une copie de la commande head.
 * Renvoie RESULTAT_ERREUR si commandehead est NULL, et
 * RESULTAT_ERREUR_MEMOIRE si une allocation choue.
 * Si la copie est non vide, elle est au pralable supprime.
 */

Resultat commandehead_destruction(TRAVAIL(CommandeHead) commandehead);
/* Dtruit une commande d'entte de document.
 */

#endif
