#!/usr/bin/perl -w

use strict;
use warnings;

use Date::Calc;
use CGI;
use PDF::API2;

require 'Classes/Statistic.pm';

package main;

require 'Functions/config.pl';
require 'Functions/db.pl';
require 'Functions/parser.pl';
require 'Functions/console.pl';
require 'Functions/ps.pl';
require 'Functions/pdf_report.pl';

my $ReportName = shift;	# PDF report name
my $Type = shift;		# Day (YYYY-MM-DD), Week, Month (YYYY-MM), Year (YYYY)
my $From = shift;		# Start boundary
my $To = shift;			# End boundary

  # Check for missing values :
if ( ! $ReportName or ! $Type or ! $From or ! $To )
{
	die( "usage : perl ./crontab/report.pl \"2003-10 Monthly report\" \"YYYY-MM-DD\" \"2003-10-01\" \"2003-10-31\"\n" );
}

  # Check time values for format error :
my $regex = $Type;
$regex =~ s/[YMDHS]/\\d/g;

if ( ( $From !~ m/$regex/ ) or ( $To !~ m/$regex/ ) )
{
	die( "Start and/or end period do not respect the time format\n" );
}

  # Create the PDF object :
my $pdf = PDF::API2->new;

  # Set document preferences :
$pdf->preferences(
	-singlepage => 1,
	-fitwindow => 1,
	-centerwindow => 1,
	-displaytitle =>1
);

  # Set document information :
$pdf->info(
	'Author'       => "Stéphane LOEUILLET",
#	'CreationDate' => "D:20020911000000+01'00'",
#	'ModDate'      => "D:YYYYMMDDhhmmssOHH'mm'",
	'Creator'      => "PIWI - Prelude IDS Perl Web Front-End",
	'Producer'     => "PDF::API2",
	'Title'        => "$ReportName from $From to $To",
	'Subject'      => "$ReportName from $From to $To",
	'Keywords'     => "all good things are PDF"
);

#################################################################
#################################################################

  # Set default parameters for all pages :
my $Parameters = {};

  # Set generated image properties :
$Parameters->{'Graph_Width'} = 800;
$Parameters->{'Graph_Height'} = 600;
  # Set if we want a pie chart or a bar histogram :
$Parameters->{'Graph_Type'} = 'bars';

  # Set max element number in 'Top' Stat-Type :
$Parameters->{'Top_Limit'} = 20;

my $pages = [];
my $new_page = {
	'page_type' => 1,
	'section_id' => 0
};

#################################################################
#################################################################

our %conf;      # configuration directives
LoadConfig();

#$conf{'debug'} = 1;

  # Open the DB connection :
our $dbh = DB_Open();

our $cgi = CGI->new();
$cgi->param( 'backend', 'PS' );

#################################################################
#################################################################

local *FilterDir;
opendir( FilterDir, 'generated/Filters/' );
foreach my $DirEntry ( sort readdir( FilterDir ) )
{
	if ( $DirEntry =~ m/^(.*)\.flt$/ )
	{
		my $Label = $1;
		my $FilterFile = "generated/Filters/$Label.flt";
		print "Processing $FilterFile\n";

		  # Load the Filter object from a filter file :
		my $Filter = Filter->new();
		$Filter->load( $FilterFile );

		generate_report_statistic_page(
		{
			'Statistic_Stat_Type' => 'Time',
			'Statistic_Time_Type' => $Type,
			'Statistic_Time_From' => $From,
			'Statistic_Time_To' => $To,
			'Statistic_Filter' => $Filter,
			'Statistic_Parameters' => $Parameters,

			'PDF' => $pdf,
			'PDF_Pages' => $pages,
			'PDF_Page_Template' => $new_page,
			'PDF_Page_Title' => $Label
		}
		);

	}
}
closedir( FilterDir );

#################################################################
#################################################################

  # Get total page number in the PDF :
my $pagenumber = $pdf->pages;
print "This PDF contains $pagenumber page(s)\n";

  # Save the PDF to disk :
$pdf->saveas( "generated/Reports/$ReportName.pdf" );

  # Destroy the PDF object :
$pdf->end;

  # Delete the graphs :
delete_tmp_images( 'generated/Images/' );

#################################################################
#################################################################

exit;

__END__
