/*
 * Picviz - Parallel coordinates ploter
 * Copyright (C) 2008 Sebastien Tricaud <toady@gscore.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $Id: debug.c 369 2008-12-22 00:24:39Z toady $
 */

#include <stdio.h>
#include <stdarg.h>
#include <time.h>
#include <string.h>

#include <picviz.h>

void picviz_debug(int level, int area, const char *format, ...)
{
	char *timestr;
	va_list ap;
	time_t tm;
	FILE *fd = stderr;

	if (engine.debug) {

		if (level == PICVIZ_DEBUG_NOTICE) {
			fd = stdout;
		}

		va_start(ap, format);

		tm = time(NULL);
		timestr = ctime(&tm);
		timestr[strlen(timestr)-1] = '\0';
		fprintf(fd, "%s <%1d.%1d> ", timestr, level, area);
		vfprintf(fd, format, ap);
		va_end(ap);
		fprintf(fd, "\n");

		fflush(fd);
	}
}

void picviz_debug_print_axisplot(PicvizAxisPlot *axisplot)
{
	fprintf(stderr, "axisplot->strval=%s\n", axisplot->strval);
	fprintf(stderr, "axisplot->y=%lld\n", axisplot->y);
	fprintf(stderr, "axisplot->axis_id=%llu\n", axisplot->axis_id);
	fprintf(stderr, "axisplot->props->color=%s\n", picviz_properties_get(axisplot->props, "color"));
}

