---
title: PICOTOOL-INFO
section: 1
header: User Commands
---
# NAME

picotool\-info \- Display information from the target device\(s\) or file\. Without any arguments, this will display basic information for all connected RP\-series devices in BOOTSEL mode

# SYNOPSIS

picotool info \[\-b\] \[\-m\] \[\-p\] \[\-d\] \[\-\-debug\] \[\-l\] \[\-a\] \[device\-selection\]

picotool info \[\-b\] \[\-m\] \[\-p\] \[\-d\] \[\-\-debug\] \[\-l\] \[\-a\] \<filename\> \[\-t \<type\>\]


# OPTIONS

Information to display

**\-b**, **\-\-basic**
: Include basic information\. This is the default

**\-m**, **\-\-metadata**
: Include all metadata blocks

**\-p**, **\-\-pins**
: Include pin information

**\-d**, **\-\-device**
: Include device information

**\-\-debug**
: Include device debug information

**\-l**, **\-\-build**
: Include build attributes

**\-a**, **\-\-all**
: Include all information

# TARGET SELECTION

To target one or more connected RP\-series device\(s\) in BOOTSEL mode \(the default\)

**\-\-bus** \<*bus*\>
: Filter devices by USB bus number

**\-\-address** \<*addr*\>
: Filter devices by USB device address

**\-\-vid** \<*vid*\>
: Filter by vendor id

**\-\-pid** \<*pid*\>
: Filter by product id

**\-\-ser** \<*ser*\>
: Filter by serial number

**\-f**, **\-\-force**
: Force a device not in BOOTSEL mode but running compatible code toreset so the command can be executed\. After executing the command\(unless the command itself is a 'reboot'\) the device will berebooted back to application mode

**\-F**, **\-\-force\-no\-reboot**
: Force a device not in BOOTSEL mode but running compatible code toreset so the command can be executed\. After executing the command\(unless the command itself is a 'reboot'\) the device will be leftconnected and accessible to picotool, but without the USB drivemounted

To target a file

\<*filename*\>
: The file name

**\-t** \<*type*\>
: Specify file type \(uf2 \| elf \| bin\) explicitly, ignoring fileextension

