//                                               -*- C++ -*-
/**
 *  @brief Exact cdf of empirical Spearman correlation coefficient
 *
 *  Copyright 2005-2019 Airbus-EDF-IMACS-Phimeca
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
const Scalar rhoSpearman[20500] = { \
                                    -1.0000000000000000e+00,  1.0000000000000000e+00, -1.0000000000000000e+00, \
                                    -5.0000000000000000e-01,  0.0000000000000000e+00,  5.0000000000000000e-01, \
                                    1.0000000000000000e+00, -1.0000000000000000e+00, -8.0000000000000004e-01, \
                                    -5.9999999999999998e-01, -4.0000000000000002e-01, -2.0000000000000001e-01, \
                                    0.0000000000000000e+00,  2.0000000000000001e-01,  4.0000000000000002e-01, \
                                    5.9999999999999998e-01,  8.0000000000000004e-01,  1.0000000000000000e+00, \
                                    -1.0000000000000000e+00, -9.0000000000000002e-01, -8.0000000000000004e-01, \
                                    -6.9999999999999996e-01, -5.9999999999999998e-01, -5.0000000000000000e-01, \
                                    -4.0000000000000002e-01, -2.9999999999999999e-01, -2.0000000000000001e-01, \
                                    -1.0000000000000001e-01,  0.0000000000000000e+00,  1.0000000000000001e-01, \
                                    2.0000000000000001e-01,  2.9999999999999999e-01,  4.0000000000000002e-01, \
                                    5.0000000000000000e-01,  5.9999999999999998e-01,  6.9999999999999996e-01, \
                                    8.0000000000000004e-01,  9.0000000000000002e-01,  1.0000000000000000e+00, \
                                    -1.0000000000000000e+00, -9.4285714285699995e-01, -8.8571428571400002e-01, \
                                    -8.2857142857099997e-01, -7.7142857142900001e-01, -7.1428571428599996e-01, \
                                    -6.5714285714300003e-01, -5.9999999999999998e-01, -5.4285714285700004e-01, \
                                    -4.8571428571399999e-01, -4.2857142857100000e-01, -3.7142857142899999e-01, \
                                    -3.1428571428600000e-01, -2.5714285714300000e-01, -2.0000000000000001e-01, \
                                    -1.4285714285699999e-01, -8.5714285713999999e-02, -2.8571428571000000e-02, \
                                    2.8571428571000000e-02,  8.5714285713999999e-02,  1.4285714285699999e-01, \
                                    2.0000000000000001e-01,  2.5714285714300000e-01,  3.1428571428600000e-01, \
                                    3.7142857142899999e-01,  4.2857142857100000e-01,  4.8571428571399999e-01, \
                                    5.4285714285700004e-01,  5.9999999999999998e-01,  6.5714285714300003e-01, \
                                    7.1428571428599996e-01,  7.7142857142900001e-01,  8.2857142857099997e-01, \
                                    8.8571428571400002e-01,  9.4285714285699995e-01,  1.0000000000000000e+00, \
                                    -1.0000000000000000e+00, -9.6428571428599996e-01, -9.2857142857099995e-01, \
                                    -8.9285714285700002e-01, -8.5714285714299998e-01, -8.2142857142900005e-01, \
                                    -7.8571428571400004e-01, -7.5000000000000000e-01, -7.1428571428599996e-01, \
                                    -6.7857142857099995e-01, -6.4285714285700002e-01, -6.0714285714299998e-01, \
                                    -5.7142857142900005e-01, -5.3571428571400004e-01, -5.0000000000000000e-01, \
                                    -4.6428571428600002e-01, -4.2857142857100000e-01, -3.9285714285700002e-01, \
                                    -3.5714285714299998e-01, -3.2142857142900000e-01, -2.8571428571399998e-01, \
                                    -2.5000000000000000e-01, -2.1428571428599999e-01, -1.7857142857100000e-01, \
                                    -1.4285714285699999e-01, -1.0714285714299999e-01, -7.1428571428999998e-02, \
                                    -3.5714285714000003e-02,  0.0000000000000000e+00,  3.5714285714000003e-02, \
                                    7.1428571428999998e-02,  1.0714285714299999e-01,  1.4285714285699999e-01, \
                                    1.7857142857100000e-01,  2.1428571428599999e-01,  2.5000000000000000e-01, \
                                    2.8571428571399998e-01,  3.2142857142900000e-01,  3.5714285714299998e-01, \
                                    3.9285714285700002e-01,  4.2857142857100000e-01,  4.6428571428600002e-01, \
                                    5.0000000000000000e-01,  5.3571428571400004e-01,  5.7142857142900005e-01, \
                                    6.0714285714299998e-01,  6.4285714285700002e-01,  6.7857142857099995e-01, \
                                    7.1428571428599996e-01,  7.5000000000000000e-01,  7.8571428571400004e-01, \
                                    8.2142857142900005e-01,  8.5714285714299998e-01,  8.9285714285700002e-01, \
                                    9.2857142857099995e-01,  9.6428571428599996e-01,  1.0000000000000000e+00, \
                                    -1.0000000000000000e+00, -9.7619047618999999e-01, -9.5238095238099996e-01, \
                                    -9.2857142857099995e-01, -9.0476190476200002e-01, -8.8095238095200001e-01, \
                                    -8.5714285714299998e-01, -8.3333333333299997e-01, -8.0952380952400005e-01, \
                                    -7.8571428571400004e-01, -7.6190476190500001e-01, -7.3809523809499999e-01, \
                                    -7.1428571428599996e-01, -6.9047619047599995e-01, -6.6666666666700003e-01, \
                                    -6.4285714285700002e-01, -6.1904761904799999e-01, -5.9523809523799998e-01, \
                                    -5.7142857142900005e-01, -5.4761904761900004e-01, -5.2380952381000001e-01, \
                                    -5.0000000000000000e-01, -4.7619047618999999e-01, -4.5238095238100001e-01, \
                                    -4.2857142857100000e-01, -4.0476190476200002e-01, -3.8095238095200001e-01, \
                                    -3.5714285714299998e-01, -3.3333333333300003e-01, -3.0952380952399999e-01, \
                                    -2.8571428571399998e-01, -2.6190476190500001e-01, -2.3809523809499999e-01, \
                                    -2.1428571428599999e-01, -1.9047619047600001e-01, -1.6666666666700000e-01, \
                                    -1.4285714285699999e-01, -1.1904761904800000e-01, -9.5238095238000003e-02, \
                                    -7.1428571428999998e-02, -4.7619047619000002e-02, -2.3809523810000000e-02, \
                                    0.0000000000000000e+00,  2.3809523810000000e-02,  4.7619047619000002e-02, \
                                    7.1428571428999998e-02,  9.5238095238000003e-02,  1.1904761904800000e-01, \
                                    1.4285714285699999e-01,  1.6666666666700000e-01,  1.9047619047600001e-01, \
                                    2.1428571428599999e-01,  2.3809523809499999e-01,  2.6190476190500001e-01, \
                                    2.8571428571399998e-01,  3.0952380952399999e-01,  3.3333333333300003e-01, \
                                    3.5714285714299998e-01,  3.8095238095200001e-01,  4.0476190476200002e-01, \
                                    4.2857142857100000e-01,  4.5238095238100001e-01,  4.7619047618999999e-01, \
                                    5.0000000000000000e-01,  5.2380952381000001e-01,  5.4761904761900004e-01, \
                                    5.7142857142900005e-01,  5.9523809523799998e-01,  6.1904761904799999e-01, \
                                    6.4285714285700002e-01,  6.6666666666700003e-01,  6.9047619047599995e-01, \
                                    7.1428571428599996e-01,  7.3809523809499999e-01,  7.6190476190500001e-01, \
                                    7.8571428571400004e-01,  8.0952380952400005e-01,  8.3333333333299997e-01, \
                                    8.5714285714299998e-01,  8.8095238095200001e-01,  9.0476190476200002e-01, \
                                    9.2857142857099995e-01,  9.5238095238099996e-01,  9.7619047618999999e-01, \
                                    1.0000000000000000e+00, -1.0000000000000000e+00, -9.8333333333299999e-01, \
                                    -9.6666666666699996e-01, -9.4999999999999996e-01, -9.3333333333299995e-01, \
                                    -9.1666666666700003e-01, -9.0000000000000002e-01, -8.8333333333300001e-01, \
                                    -8.6666666666699999e-01, -8.4999999999999998e-01, -8.3333333333299997e-01, \
                                    -8.1666666666700005e-01, -8.0000000000000004e-01, -7.8333333333300004e-01, \
                                    -7.6666666666700001e-01, -7.5000000000000000e-01, -7.3333333333299999e-01, \
                                    -7.1666666666699996e-01, -6.9999999999999996e-01, -6.8333333333299995e-01, \
                                    -6.6666666666700003e-01, -6.5000000000000002e-01, -6.3333333333300001e-01, \
                                    -6.1666666666699999e-01, -5.9999999999999998e-01, -5.8333333333299997e-01, \
                                    -5.6666666666700005e-01, -5.5000000000000004e-01, -5.3333333333300004e-01, \
                                    -5.1666666666700001e-01, -5.0000000000000000e-01, -4.8333333333299999e-01, \
                                    -4.6666666666700002e-01, -4.5000000000000001e-01, -4.3333333333300000e-01, \
                                    -4.1666666666699997e-01, -4.0000000000000002e-01, -3.8333333333300001e-01, \
                                    -3.6666666666699999e-01, -3.4999999999999998e-01, -3.3333333333300003e-01, \
                                    -3.1666666666700000e-01, -2.9999999999999999e-01, -2.8333333333299998e-01, \
                                    -2.6666666666700001e-01, -2.5000000000000000e-01, -2.3333333333299999e-01, \
                                    -2.1666666666699999e-01, -2.0000000000000001e-01, -1.8333333333300000e-01, \
                                    -1.6666666666700000e-01, -1.4999999999999999e-01, -1.3333333333299999e-01, \
                                    -1.1666666666700000e-01, -1.0000000000000001e-01, -8.3333333332999998e-02, \
                                    -6.6666666666999996e-02, -5.0000000000000003e-02, -3.3333333333000002e-02, \
                                    -1.6666666667000000e-02,  0.0000000000000000e+00,  1.6666666667000000e-02, \
                                    3.3333333333000002e-02,  5.0000000000000003e-02,  6.6666666666999996e-02, \
                                    8.3333333332999998e-02,  1.0000000000000001e-01,  1.1666666666700000e-01, \
                                    1.3333333333299999e-01,  1.4999999999999999e-01,  1.6666666666700000e-01, \
                                    1.8333333333300000e-01,  2.0000000000000001e-01,  2.1666666666699999e-01, \
                                    2.3333333333299999e-01,  2.5000000000000000e-01,  2.6666666666700001e-01, \
                                    2.8333333333299998e-01,  2.9999999999999999e-01,  3.1666666666700000e-01, \
                                    3.3333333333300003e-01,  3.4999999999999998e-01,  3.6666666666699999e-01, \
                                    3.8333333333300001e-01,  4.0000000000000002e-01,  4.1666666666699997e-01, \
                                    4.3333333333300000e-01,  4.5000000000000001e-01,  4.6666666666700002e-01, \
                                    4.8333333333299999e-01,  5.0000000000000000e-01,  5.1666666666700001e-01, \
                                    5.3333333333300004e-01,  5.5000000000000004e-01,  5.6666666666700005e-01, \
                                    5.8333333333299997e-01,  5.9999999999999998e-01,  6.1666666666699999e-01, \
                                    6.3333333333300001e-01,  6.5000000000000002e-01,  6.6666666666700003e-01, \
                                    6.8333333333299995e-01,  6.9999999999999996e-01,  7.1666666666699996e-01, \
                                    7.3333333333299999e-01,  7.5000000000000000e-01,  7.6666666666700001e-01, \
                                    7.8333333333300004e-01,  8.0000000000000004e-01,  8.1666666666700005e-01, \
                                    8.3333333333299997e-01,  8.4999999999999998e-01,  8.6666666666699999e-01, \
                                    8.8333333333300001e-01,  9.0000000000000002e-01,  9.1666666666700003e-01, \
                                    9.3333333333299995e-01,  9.4999999999999996e-01,  9.6666666666699996e-01, \
                                    9.8333333333299999e-01,  1.0000000000000000e+00, -1.0000000000000000e+00, \
                                    -9.8787878787899996e-01, -9.7575757575800004e-01, -9.6363636363600003e-01, \
                                    -9.5151515151499999e-01, -9.3939393939399995e-01, -9.2727272727300003e-01, \
                                    -9.1515151515199999e-01, -9.0303030302999998e-01, -8.9090909090899995e-01, \
                                    -8.7878787878800002e-01, -8.6666666666699999e-01, -8.5454545454499997e-01, \
                                    -8.4242424242400005e-01, -8.3030303030300001e-01, -8.1818181818199998e-01, \
                                    -8.0606060606100005e-01, -7.9393939393900004e-01, -7.8181818181800000e-01, \
                                    -7.6969696969699997e-01, -7.5757575757600004e-01, -7.4545454545500001e-01, \
                                    -7.3333333333299999e-01, -7.2121212121199996e-01, -7.0909090909100003e-01, \
                                    -6.9696969697000000e-01, -6.8484848484799998e-01, -6.7272727272699995e-01, \
                                    -6.6060606060600002e-01, -6.4848484848499999e-01, -6.3636363636399995e-01, \
                                    -6.2424242424200005e-01, -6.1212121212100001e-01, -5.9999999999999998e-01, \
                                    -5.8787878787900005e-01, -5.7575757575800002e-01, -5.6363636363600000e-01, \
                                    -5.5151515151499997e-01, -5.3939393939400004e-01, -5.2727272727300001e-01, \
                                    -5.1515151515199997e-01, -5.0303030302999996e-01, -4.9090909090899998e-01, \
                                    -4.7878787878800000e-01, -4.6666666666700002e-01, -4.5454545454500001e-01, \
                                    -4.4242424242400002e-01, -4.3030303030299999e-01, -4.1818181818200001e-01, \
                                    -4.0606060606099997e-01, -3.9393939393900002e-01, -3.8181818181799998e-01, \
                                    -3.6969696969700000e-01, -3.5757575757600002e-01, -3.4545454545499998e-01, \
                                    -3.3333333333300003e-01, -3.2121212121199999e-01, -3.0909090909100001e-01, \
                                    -2.9696969696999997e-01, -2.8484848484800002e-01, -2.7272727272699998e-01, \
                                    -2.6060606060600000e-01, -2.4848484848499999e-01, -2.3636363636400001e-01, \
                                    -2.2424242424200000e-01, -2.1212121212099999e-01, -2.0000000000000001e-01, \
                                    -1.8787878787900000e-01, -1.7575757575800000e-01, -1.6363636363600001e-01, \
                                    -1.5151515151500000e-01, -1.3939393939399999e-01, -1.2727272727300001e-01, \
                                    -1.1515151515200001e-01, -1.0303030303000001e-01, -9.0909090908999998e-02, \
                                    -7.8787878788000004e-02, -6.6666666666999996e-02, -5.4545454544999997e-02, \
                                    -4.2424242424000003e-02, -3.0303030303000002e-02, -1.8181818182000001e-02, \
                                    -6.0606060609999998e-03,  6.0606060609999998e-03,  1.8181818182000001e-02, \
                                    3.0303030303000002e-02,  4.2424242424000003e-02,  5.4545454544999997e-02, \
                                    6.6666666666999996e-02,  7.8787878788000004e-02,  9.0909090908999998e-02, \
                                    1.0303030303000001e-01,  1.1515151515200001e-01,  1.2727272727300001e-01, \
                                    1.3939393939399999e-01,  1.5151515151500000e-01,  1.6363636363600001e-01, \
                                    1.7575757575800000e-01,  1.8787878787900000e-01,  2.0000000000000001e-01, \
                                    2.1212121212099999e-01,  2.2424242424200000e-01,  2.3636363636400001e-01, \
                                    2.4848484848499999e-01,  2.6060606060600000e-01,  2.7272727272699998e-01, \
                                    2.8484848484800002e-01,  2.9696969696999997e-01,  3.0909090909100001e-01, \
                                    3.2121212121199999e-01,  3.3333333333300003e-01,  3.4545454545499998e-01, \
                                    3.5757575757600002e-01,  3.6969696969700000e-01,  3.8181818181799998e-01, \
                                    3.9393939393900002e-01,  4.0606060606099997e-01,  4.1818181818200001e-01, \
                                    4.3030303030299999e-01,  4.4242424242400002e-01,  4.5454545454500001e-01, \
                                    4.6666666666700002e-01,  4.7878787878800000e-01,  4.9090909090899998e-01, \
                                    5.0303030302999996e-01,  5.1515151515199997e-01,  5.2727272727300001e-01, \
                                    5.3939393939400004e-01,  5.5151515151499997e-01,  5.6363636363600000e-01, \
                                    5.7575757575800002e-01,  5.8787878787900005e-01,  5.9999999999999998e-01, \
                                    6.1212121212100001e-01,  6.2424242424200005e-01,  6.3636363636399995e-01, \
                                    6.4848484848499999e-01,  6.6060606060600002e-01,  6.7272727272699995e-01, \
                                    6.8484848484799998e-01,  6.9696969697000000e-01,  7.0909090909100003e-01, \
                                    7.2121212121199996e-01,  7.3333333333299999e-01,  7.4545454545500001e-01, \
                                    7.5757575757600004e-01,  7.6969696969699997e-01,  7.8181818181800000e-01, \
                                    7.9393939393900004e-01,  8.0606060606100005e-01,  8.1818181818199998e-01, \
                                    8.3030303030300001e-01,  8.4242424242400005e-01,  8.5454545454499997e-01, \
                                    8.6666666666699999e-01,  8.7878787878800002e-01,  8.9090909090899995e-01, \
                                    9.0303030302999998e-01,  9.1515151515199999e-01,  9.2727272727300003e-01, \
                                    9.3939393939399995e-01,  9.5151515151499999e-01,  9.6363636363600003e-01, \
                                    9.7575757575800004e-01,  9.8787878787899996e-01,  1.0000000000000000e+00, \
                                    -1.0000000000000000e+00, -9.9090909090900003e-01, -9.8181818181799996e-01, \
                                    -9.7272727272699999e-01, -9.6363636363600003e-01, -9.5454545454499995e-01, \
                                    -9.4545454545499996e-01, -9.3636363636400000e-01, -9.2727272727300003e-01, \
                                    -9.1818181818199995e-01, -9.0909090909099999e-01, -9.0000000000000002e-01, \
                                    -8.9090909090899995e-01, -8.8181818181799998e-01, -8.7272727272700001e-01, \
                                    -8.6363636363600005e-01, -8.5454545454499997e-01, -8.4545454545499998e-01, \
                                    -8.3636363636400002e-01, -8.2727272727300005e-01, -8.1818181818199998e-01, \
                                    -8.0909090909100001e-01, -8.0000000000000004e-01, -7.9090909090899997e-01, \
                                    -7.8181818181800000e-01, -7.7272727272700004e-01, -7.6363636363599996e-01, \
                                    -7.5454545454499999e-01, -7.4545454545500001e-01, -7.3636363636400004e-01, \
                                    -7.2727272727299996e-01, -7.1818181818200000e-01, -7.0909090909100003e-01, \
                                    -6.9999999999999996e-01, -6.9090909090899999e-01, -6.8181818181800002e-01, \
                                    -6.7272727272699995e-01, -6.6363636363599998e-01, -6.5454545454500002e-01, \
                                    -6.4545454545500003e-01, -6.3636363636399995e-01, -6.2727272727299999e-01, \
                                    -6.1818181818200002e-01, -6.0909090909100005e-01, -5.9999999999999998e-01, \
                                    -5.9090909090900001e-01, -5.8181818181800005e-01, -5.7272727272699997e-01, \
                                    -5.6363636363600000e-01, -5.5454545454500004e-01, -5.4545454545500005e-01, \
                                    -5.3636363636399997e-01, -5.2727272727300001e-01, -5.1818181818200004e-01, \
                                    -5.0909090909099997e-01, -5.0000000000000000e-01, -4.9090909090899998e-01, \
                                    -4.8181818181800001e-01, -4.7272727272699999e-01, -4.6363636363600003e-01, \
                                    -4.5454545454500001e-01, -4.4545454545500002e-01, -4.3636363636400000e-01, \
                                    -4.2727272727299997e-01, -4.1818181818200001e-01, -4.0909090909099999e-01, \
                                    -4.0000000000000002e-01, -3.9090909090900000e-01, -3.8181818181799998e-01, \
                                    -3.7272727272700001e-01, -3.6363636363599999e-01, -3.5454545454500003e-01, \
                                    -3.4545454545499998e-01, -3.3636363636400002e-01, -3.2727272727300000e-01, \
                                    -3.1818181818199998e-01, -3.0909090909100001e-01, -2.9999999999999999e-01, \
                                    -2.9090909090900002e-01, -2.8181818181800000e-01, -2.7272727272699998e-01, \
                                    -2.6363636363600002e-01, -2.5454545454499999e-01, -2.4545454545500001e-01, \
                                    -2.3636363636400001e-01, -2.2727272727299999e-01, -2.1818181818200000e-01, \
                                    -2.0909090909100000e-01, -2.0000000000000001e-01, -1.9090909090899999e-01, \
                                    -1.8181818181800000e-01, -1.7272727272700000e-01, -1.6363636363600001e-01, \
                                    -1.5454545454499999e-01, -1.4545454545500000e-01, -1.3636363636400001e-01, \
                                    -1.2727272727300001e-01, -1.1818181818200001e-01, -1.0909090909100000e-01, \
                                    -1.0000000000000001e-01, -9.0909090908999998e-02, -8.1818181818000005e-02, \
                                    -7.2727272726999997e-02, -6.3636363636000004e-02, -5.4545454544999997e-02, \
                                    -4.5454545455000002e-02, -3.6363636364000002e-02, -2.7272727273000001e-02, \
                                    -1.8181818182000001e-02, -9.0909090910000004e-03,  0.0000000000000000e+00, \
                                    9.0909090910000004e-03,  1.8181818182000001e-02,  2.7272727273000001e-02, \
                                    3.6363636364000002e-02,  4.5454545455000002e-02,  5.4545454544999997e-02, \
                                    6.3636363636000004e-02,  7.2727272726999997e-02,  8.1818181818000005e-02, \
                                    9.0909090908999998e-02,  1.0000000000000001e-01,  1.0909090909100000e-01, \
                                    1.1818181818200001e-01,  1.2727272727300001e-01,  1.3636363636400001e-01, \
                                    1.4545454545500000e-01,  1.5454545454499999e-01,  1.6363636363600001e-01, \
                                    1.7272727272700000e-01,  1.8181818181800000e-01,  1.9090909090899999e-01, \
                                    2.0000000000000001e-01,  2.0909090909100000e-01,  2.1818181818200000e-01, \
                                    2.2727272727299999e-01,  2.3636363636400001e-01,  2.4545454545500001e-01, \
                                    2.5454545454499999e-01,  2.6363636363600002e-01,  2.7272727272699998e-01, \
                                    2.8181818181800000e-01,  2.9090909090900002e-01,  2.9999999999999999e-01, \
                                    3.0909090909100001e-01,  3.1818181818199998e-01,  3.2727272727300000e-01, \
                                    3.3636363636400002e-01,  3.4545454545499998e-01,  3.5454545454500003e-01, \
                                    3.6363636363599999e-01,  3.7272727272700001e-01,  3.8181818181799998e-01, \
                                    3.9090909090900000e-01,  4.0000000000000002e-01,  4.0909090909099999e-01, \
                                    4.1818181818200001e-01,  4.2727272727299997e-01,  4.3636363636400000e-01, \
                                    4.4545454545500002e-01,  4.5454545454500001e-01,  4.6363636363600003e-01, \
                                    4.7272727272699999e-01,  4.8181818181800001e-01,  4.9090909090899998e-01, \
                                    5.0000000000000000e-01,  5.0909090909099997e-01,  5.1818181818200004e-01, \
                                    5.2727272727300001e-01,  5.3636363636399997e-01,  5.4545454545500005e-01, \
                                    5.5454545454500004e-01,  5.6363636363600000e-01,  5.7272727272699997e-01, \
                                    5.8181818181800005e-01,  5.9090909090900001e-01,  5.9999999999999998e-01, \
                                    6.0909090909100005e-01,  6.1818181818200002e-01,  6.2727272727299999e-01, \
                                    6.3636363636399995e-01,  6.4545454545500003e-01,  6.5454545454500002e-01, \
                                    6.6363636363599998e-01,  6.7272727272699995e-01,  6.8181818181800002e-01, \
                                    6.9090909090899999e-01,  6.9999999999999996e-01,  7.0909090909100003e-01, \
                                    7.1818181818200000e-01,  7.2727272727299996e-01,  7.3636363636400004e-01, \
                                    7.4545454545500001e-01,  7.5454545454499999e-01,  7.6363636363599996e-01, \
                                    7.7272727272700004e-01,  7.8181818181800000e-01,  7.9090909090899997e-01, \
                                    8.0000000000000004e-01,  8.0909090909100001e-01,  8.1818181818199998e-01, \
                                    8.2727272727300005e-01,  8.3636363636400002e-01,  8.4545454545499998e-01, \
                                    8.5454545454499997e-01,  8.6363636363600005e-01,  8.7272727272700001e-01, \
                                    8.8181818181799998e-01,  8.9090909090899995e-01,  9.0000000000000002e-01, \
                                    9.0909090909099999e-01,  9.1818181818199995e-01,  9.2727272727300003e-01, \
                                    9.3636363636400000e-01,  9.4545454545499996e-01,  9.5454545454499995e-01, \
                                    9.6363636363600003e-01,  9.7272727272699999e-01,  9.8181818181799996e-01, \
                                    9.9090909090900003e-01,  1.0000000000000000e+00, -1.0000000000000000e+00, \
                                    -9.9300699300700002e-01, -9.8601398601400003e-01, -9.7902097902100005e-01, \
                                    -9.7202797202799995e-01, -9.6503496503499997e-01, -9.5804195804199999e-01, \
                                    -9.5104895104900000e-01, -9.4405594405600002e-01, -9.3706293706300003e-01, \
                                    -9.3006993007000005e-01, -9.2307692307699996e-01, -9.1608391608399997e-01, \
                                    -9.0909090909099999e-01, -9.0209790209800000e-01, -8.9510489510500002e-01, \
                                    -8.8811188811200004e-01, -8.8111888111900005e-01, -8.7412587412599996e-01, \
                                    -8.6713286713299997e-01, -8.6013986013999999e-01, -8.5314685314700001e-01, \
                                    -8.4615384615400002e-01, -8.3916083916100004e-01, -8.3216783216800005e-01, \
                                    -8.2517482517499996e-01, -8.1818181818199998e-01, -8.1118881118899999e-01, \
                                    -8.0419580419600001e-01, -7.9720279720300002e-01, -7.9020979021000004e-01, \
                                    -7.8321678321699995e-01, -7.7622377622399996e-01, -7.6923076923099998e-01, \
                                    -7.6223776223799999e-01, -7.5524475524500001e-01, -7.4825174825200003e-01, \
                                    -7.4125874125900004e-01, -7.3426573426599995e-01, -7.2727272727299996e-01, \
                                    -7.2027972027999998e-01, -7.1328671328700000e-01, -7.0629370629400001e-01, \
                                    -6.9930069930100003e-01, -6.9230769230800004e-01, -6.8531468531499995e-01, \
                                    -6.7832167832199997e-01, -6.7132867132899998e-01, -6.6433566433600000e-01, \
                                    -6.5734265734300001e-01, -6.5034965035000003e-01, -6.4335664335700005e-01, \
                                    -6.3636363636399995e-01, -6.2937062937099997e-01, -6.2237762237799998e-01, \
                                    -6.1538461538500000e-01, -6.0839160839200002e-01, -6.0139860139900003e-01, \
                                    -5.9440559440600005e-01, -5.8741258741299995e-01, -5.8041958041999997e-01, \
                                    -5.7342657342699999e-01, -5.6643356643400000e-01, -5.5944055944100002e-01, \
                                    -5.5244755244800003e-01, -5.4545454545500005e-01, -5.3846153846199996e-01, \
                                    -5.3146853146899997e-01, -5.2447552447599999e-01, -5.1748251748300000e-01, \
                                    -5.1048951049000002e-01, -5.0349650349700004e-01, -4.9650349650300002e-01, \
                                    -4.8951048950999998e-01, -4.8251748251700000e-01, -4.7552447552400001e-01, \
                                    -4.6853146853099997e-01, -4.6153846153799999e-01, -4.5454545454500001e-01, \
                                    -4.4755244755200002e-01, -4.4055944055899998e-01, -4.3356643356600000e-01, \
                                    -4.2657342657300001e-01, -4.1958041957999997e-01, -4.1258741258699999e-01, \
                                    -4.0559440559400001e-01, -3.9860139860100002e-01, -3.9160839160799998e-01, \
                                    -3.8461538461500000e-01, -3.7762237762200002e-01, -3.7062937062899998e-01, \
                                    -3.6363636363599999e-01, -3.5664335664300001e-01, -3.4965034965000003e-01, \
                                    -3.4265734265699999e-01, -3.3566433566400000e-01, -3.2867132867100002e-01, \
                                    -3.2167832167799998e-01, -3.1468531468499999e-01, -3.0769230769200001e-01, \
                                    -3.0069930069900003e-01, -2.9370629370599999e-01, -2.8671328671300000e-01, \
                                    -2.7972027972000002e-01, -2.7272727272699998e-01, -2.6573426573400000e-01, \
                                    -2.5874125874100001e-01, -2.5174825174799997e-01, -2.4475524475499999e-01, \
                                    -2.3776223776200001e-01, -2.3076923076899999e-01, -2.2377622377600001e-01, \
                                    -2.1678321678300000e-01, -2.0979020978999999e-01, -2.0279720279700000e-01, \
                                    -1.9580419580399999e-01, -1.8881118881100001e-01, -1.8181818181800000e-01, \
                                    -1.7482517482500001e-01, -1.6783216783200000e-01, -1.6083916083899999e-01, \
                                    -1.5384615384600001e-01, -1.4685314685299999e-01, -1.3986013986000001e-01, \
                                    -1.3286713286700000e-01, -1.2587412587399999e-01, -1.1888111888100000e-01, \
                                    -1.1188811188800001e-01, -1.0489510489499999e-01, -9.7902097901999996e-02, \
                                    -9.0909090908999998e-02, -8.3916083916000000e-02, -7.6923076923000003e-02, \
                                    -6.9930069930000005e-02, -6.2937062936999993e-02, -5.5944055944000003e-02, \
                                    -4.8951048950999998e-02, -4.1958041958000000e-02, -3.4965034965000003e-02, \
                                    -2.7972027972000001e-02, -2.0979020979000000e-02, -1.3986013986000001e-02, \
                                    -6.9930069930000003e-03,  0.0000000000000000e+00,  6.9930069930000003e-03, \
                                    1.3986013986000001e-02,  2.0979020979000000e-02,  2.7972027972000001e-02, \
                                    3.4965034965000003e-02,  4.1958041958000000e-02,  4.8951048950999998e-02, \
                                    5.5944055944000003e-02,  6.2937062936999993e-02,  6.9930069930000005e-02, \
                                    7.6923076923000003e-02,  8.3916083916000000e-02,  9.0909090908999998e-02, \
                                    9.7902097901999996e-02,  1.0489510489499999e-01,  1.1188811188800001e-01, \
                                    1.1888111888100000e-01,  1.2587412587399999e-01,  1.3286713286700000e-01, \
                                    1.3986013986000001e-01,  1.4685314685299999e-01,  1.5384615384600001e-01, \
                                    1.6083916083899999e-01,  1.6783216783200000e-01,  1.7482517482500001e-01, \
                                    1.8181818181800000e-01,  1.8881118881100001e-01,  1.9580419580399999e-01, \
                                    2.0279720279700000e-01,  2.0979020978999999e-01,  2.1678321678300000e-01, \
                                    2.2377622377600001e-01,  2.3076923076899999e-01,  2.3776223776200001e-01, \
                                    2.4475524475499999e-01,  2.5174825174799997e-01,  2.5874125874100001e-01, \
                                    2.6573426573400000e-01,  2.7272727272699998e-01,  2.7972027972000002e-01, \
                                    2.8671328671300000e-01,  2.9370629370599999e-01,  3.0069930069900003e-01, \
                                    3.0769230769200001e-01,  3.1468531468499999e-01,  3.2167832167799998e-01, \
                                    3.2867132867100002e-01,  3.3566433566400000e-01,  3.4265734265699999e-01, \
                                    3.4965034965000003e-01,  3.5664335664300001e-01,  3.6363636363599999e-01, \
                                    3.7062937062899998e-01,  3.7762237762200002e-01,  3.8461538461500000e-01, \
                                    3.9160839160799998e-01,  3.9860139860100002e-01,  4.0559440559400001e-01, \
                                    4.1258741258699999e-01,  4.1958041957999997e-01,  4.2657342657300001e-01, \
                                    4.3356643356600000e-01,  4.4055944055899998e-01,  4.4755244755200002e-01, \
                                    4.5454545454500001e-01,  4.6153846153799999e-01,  4.6853146853099997e-01, \
                                    4.7552447552400001e-01,  4.8251748251700000e-01,  4.8951048950999998e-01, \
                                    4.9650349650300002e-01,  5.0349650349700004e-01,  5.1048951049000002e-01, \
                                    5.1748251748300000e-01,  5.2447552447599999e-01,  5.3146853146899997e-01, \
                                    5.3846153846199996e-01,  5.4545454545500005e-01,  5.5244755244800003e-01, \
                                    5.5944055944100002e-01,  5.6643356643400000e-01,  5.7342657342699999e-01, \
                                    5.8041958041999997e-01,  5.8741258741299995e-01,  5.9440559440600005e-01, \
                                    6.0139860139900003e-01,  6.0839160839200002e-01,  6.1538461538500000e-01, \
                                    6.2237762237799998e-01,  6.2937062937099997e-01,  6.3636363636399995e-01, \
                                    6.4335664335700005e-01,  6.5034965035000003e-01,  6.5734265734300001e-01, \
                                    6.6433566433600000e-01,  6.7132867132899998e-01,  6.7832167832199997e-01, \
                                    6.8531468531499995e-01,  6.9230769230800004e-01,  6.9930069930100003e-01, \
                                    7.0629370629400001e-01,  7.1328671328700000e-01,  7.2027972027999998e-01, \
                                    7.2727272727299996e-01,  7.3426573426599995e-01,  7.4125874125900004e-01, \
                                    7.4825174825200003e-01,  7.5524475524500001e-01,  7.6223776223799999e-01, \
                                    7.6923076923099998e-01,  7.7622377622399996e-01,  7.8321678321699995e-01, \
                                    7.9020979021000004e-01,  7.9720279720300002e-01,  8.0419580419600001e-01, \
                                    8.1118881118899999e-01,  8.1818181818199998e-01,  8.2517482517499996e-01, \
                                    8.3216783216800005e-01,  8.3916083916100004e-01,  8.4615384615400002e-01, \
                                    8.5314685314700001e-01,  8.6013986013999999e-01,  8.6713286713299997e-01, \
                                    8.7412587412599996e-01,  8.8111888111900005e-01,  8.8811188811200004e-01, \
                                    8.9510489510500002e-01,  9.0209790209800000e-01,  9.0909090909099999e-01, \
                                    9.1608391608399997e-01,  9.2307692307699996e-01,  9.3006993007000005e-01, \
                                    9.3706293706300003e-01,  9.4405594405600002e-01,  9.5104895104900000e-01, \
                                    9.5804195804199999e-01,  9.6503496503499997e-01,  9.7202797202799995e-01, \
                                    9.7902097902100005e-01,  9.8601398601400003e-01,  9.9300699300700002e-01, \
                                    1.0000000000000000e+00, -1.0000000000000000e+00, -9.9450549450500003e-01, \
                                    -9.8901098901100004e-01, -9.8351648351599996e-01, -9.7802197802199997e-01, \
                                    -9.7252747252700000e-01, -9.6703296703300001e-01, -9.6153846153800004e-01, \
                                    -9.5604395604400005e-01, -9.5054945054899997e-01, -9.4505494505499998e-01, \
                                    -9.3956043956000002e-01, -9.3406593406600003e-01, -9.2857142857099995e-01, \
                                    -9.2307692307699996e-01, -9.1758241758199999e-01, -9.1208791208800000e-01, \
                                    -9.0659340659300003e-01, -9.0109890109900004e-01, -8.9560439560399996e-01, \
                                    -8.9010989010999997e-01, -8.8461538461500000e-01, -8.7912087912100001e-01, \
                                    -8.7362637362600004e-01, -8.6813186813200005e-01, -8.6263736263699997e-01, \
                                    -8.5714285714299998e-01, -8.5164835164800001e-01, -8.4615384615400002e-01, \
                                    -8.4065934065900005e-01, -8.3516483516499995e-01, -8.2967032966999998e-01, \
                                    -8.2417582417599999e-01, -8.1868131868100003e-01, -8.1318681318700003e-01, \
                                    -8.0769230769199996e-01, -8.0219780219799997e-01, -7.9670329670300000e-01, \
                                    -7.9120879120900001e-01, -7.8571428571400004e-01, -7.8021978022000005e-01, \
                                    -7.7472527472499997e-01, -7.6923076923099998e-01, -7.6373626373600001e-01, \
                                    -7.5824175824200002e-01, -7.5274725274700005e-01, -7.4725274725299995e-01, \
                                    -7.4175824175799998e-01, -7.3626373626399999e-01, -7.3076923076900002e-01, \
                                    -7.2527472527500003e-01, -7.1978021977999995e-01, -7.1428571428599996e-01, \
                                    -7.0879120879099999e-01, -7.0329670329700000e-01, -6.9780219780200003e-01, \
                                    -6.9230769230800004e-01, -6.8681318681299997e-01, -6.8131868131899997e-01, \
                                    -6.7582417582400001e-01, -6.7032967033000002e-01, -6.6483516483500005e-01, \
                                    -6.5934065934099995e-01, -6.5384615384599998e-01, -6.4835164835199999e-01, \
                                    -6.4285714285700002e-01, -6.3736263736300003e-01, -6.3186813186799995e-01, \
                                    -6.2637362637399996e-01, -6.2087912087899999e-01, -6.1538461538500000e-01, \
                                    -6.0989010989000003e-01, -6.0439560439600004e-01, -5.9890109890099996e-01, \
                                    -5.9340659340699997e-01, -5.8791208791200000e-01, -5.8241758241800001e-01, \
                                    -5.7692307692300004e-01, -5.7142857142900005e-01, -5.6593406593399997e-01, \
                                    -5.6043956043999998e-01, -5.5494505494500002e-01, -5.4945054945100003e-01, \
                                    -5.4395604395599995e-01, -5.3846153846199996e-01, -5.3296703296699999e-01, \
                                    -5.2747252747300000e-01, -5.2197802197800003e-01, -5.1648351648400004e-01, \
                                    -5.1098901098899996e-01, -5.0549450549499997e-01, -5.0000000000000000e-01, \
                                    -4.9450549450499998e-01, -4.8901098901099999e-01, -4.8351648351600002e-01, \
                                    -4.7802197802200003e-01, -4.7252747252700000e-01, -4.6703296703300001e-01, \
                                    -4.6153846153799999e-01, -4.5604395604400000e-01, -4.5054945054899997e-01, \
                                    -4.4505494505499998e-01, -4.3956043956000002e-01, -4.3406593406600003e-01, \
                                    -4.2857142857100000e-01, -4.2307692307700001e-01, -4.1758241758199999e-01, \
                                    -4.1208791208800000e-01, -4.0659340659299997e-01, -4.0109890109899998e-01, \
                                    -3.9560439560400001e-01, -3.9010989011000002e-01, -3.8461538461500000e-01, \
                                    -3.7912087912100001e-01, -3.7362637362599999e-01, -3.6813186813200000e-01, \
                                    -3.6263736263700003e-01, -3.5714285714299998e-01, -3.5164835164800001e-01, \
                                    -3.4615384615400002e-01, -3.4065934065900000e-01, -3.3516483516500001e-01, \
                                    -3.2967032966999998e-01, -3.2417582417599999e-01, -3.1868131868100003e-01, \
                                    -3.1318681318699998e-01, -3.0769230769200001e-01, -3.0219780219800002e-01, \
                                    -2.9670329670300000e-01, -2.9120879120900001e-01, -2.8571428571399998e-01, \
                                    -2.8021978021999999e-01, -2.7472527472500002e-01, -2.6923076923099998e-01, \
                                    -2.6373626373600001e-01, -2.5824175824200002e-01, -2.5274725274700000e-01, \
                                    -2.4725274725300000e-01, -2.4175824175800001e-01, -2.3626373626399999e-01, \
                                    -2.3076923076899999e-01, -2.2527472527500000e-01, -2.1978021978000001e-01, \
                                    -2.1428571428599999e-01, -2.0879120879099999e-01, -2.0329670329700000e-01, \
                                    -1.9780219780200001e-01, -1.9230769230799999e-01, -1.8681318681299999e-01, \
                                    -1.8131868131900000e-01, -1.7582417582400001e-01, -1.7032967032999999e-01, \
                                    -1.6483516483499999e-01, -1.5934065934100000e-01, -1.5384615384600001e-01, \
                                    -1.4835164835199999e-01, -1.4285714285699999e-01, -1.3736263736300000e-01, \
                                    -1.3186813186800000e-01, -1.2637362637399999e-01, -1.2087912087900000e-01, \
                                    -1.1538461538500000e-01, -1.0989010989000000e-01, -1.0439560439600000e-01, \
                                    -9.8901098901000004e-02, -9.3406593406999999e-02, -8.7912087912000003e-02, \
                                    -8.2417582417999999e-02, -7.6923076923000003e-02, -7.1428571428999998e-02, \
                                    -6.5934065934000002e-02, -6.0439560439999998e-02, -5.4945054945000002e-02, \
                                    -4.9450549450999998e-02, -4.3956043956000002e-02, -3.8461538461999997e-02, \
                                    -3.2967032967000001e-02, -2.7472527473000000e-02, -2.1978021978000001e-02, \
                                    -1.6483516484000000e-02, -1.0989010989000000e-02, -5.4945054950000004e-03, \
                                    0.0000000000000000e+00,  5.4945054950000004e-03,  1.0989010989000000e-02, \
                                    1.6483516484000000e-02,  2.1978021978000001e-02,  2.7472527473000000e-02, \
                                    3.2967032967000001e-02,  3.8461538461999997e-02,  4.3956043956000002e-02, \
                                    4.9450549450999998e-02,  5.4945054945000002e-02,  6.0439560439999998e-02, \
                                    6.5934065934000002e-02,  7.1428571428999998e-02,  7.6923076923000003e-02, \
                                    8.2417582417999999e-02,  8.7912087912000003e-02,  9.3406593406999999e-02, \
                                    9.8901098901000004e-02,  1.0439560439600000e-01,  1.0989010989000000e-01, \
                                    1.1538461538500000e-01,  1.2087912087900000e-01,  1.2637362637399999e-01, \
                                    1.3186813186800000e-01,  1.3736263736300000e-01,  1.4285714285699999e-01, \
                                    1.4835164835199999e-01,  1.5384615384600001e-01,  1.5934065934100000e-01, \
                                    1.6483516483499999e-01,  1.7032967032999999e-01,  1.7582417582400001e-01, \
                                    1.8131868131900000e-01,  1.8681318681299999e-01,  1.9230769230799999e-01, \
                                    1.9780219780200001e-01,  2.0329670329700000e-01,  2.0879120879099999e-01, \
                                    2.1428571428599999e-01,  2.1978021978000001e-01,  2.2527472527500000e-01, \
                                    2.3076923076899999e-01,  2.3626373626399999e-01,  2.4175824175800001e-01, \
                                    2.4725274725300000e-01,  2.5274725274700000e-01,  2.5824175824200002e-01, \
                                    2.6373626373600001e-01,  2.6923076923099998e-01,  2.7472527472500002e-01, \
                                    2.8021978021999999e-01,  2.8571428571399998e-01,  2.9120879120900001e-01, \
                                    2.9670329670300000e-01,  3.0219780219800002e-01,  3.0769230769200001e-01, \
                                    3.1318681318699998e-01,  3.1868131868100003e-01,  3.2417582417599999e-01, \
                                    3.2967032966999998e-01,  3.3516483516500001e-01,  3.4065934065900000e-01, \
                                    3.4615384615400002e-01,  3.5164835164800001e-01,  3.5714285714299998e-01, \
                                    3.6263736263700003e-01,  3.6813186813200000e-01,  3.7362637362599999e-01, \
                                    3.7912087912100001e-01,  3.8461538461500000e-01,  3.9010989011000002e-01, \
                                    3.9560439560400001e-01,  4.0109890109899998e-01,  4.0659340659299997e-01, \
                                    4.1208791208800000e-01,  4.1758241758199999e-01,  4.2307692307700001e-01, \
                                    4.2857142857100000e-01,  4.3406593406600003e-01,  4.3956043956000002e-01, \
                                    4.4505494505499998e-01,  4.5054945054899997e-01,  4.5604395604400000e-01, \
                                    4.6153846153799999e-01,  4.6703296703300001e-01,  4.7252747252700000e-01, \
                                    4.7802197802200003e-01,  4.8351648351600002e-01,  4.8901098901099999e-01, \
                                    4.9450549450499998e-01,  5.0000000000000000e-01,  5.0549450549499997e-01, \
                                    5.1098901098899996e-01,  5.1648351648400004e-01,  5.2197802197800003e-01, \
                                    5.2747252747300000e-01,  5.3296703296699999e-01,  5.3846153846199996e-01, \
                                    5.4395604395599995e-01,  5.4945054945100003e-01,  5.5494505494500002e-01, \
                                    5.6043956043999998e-01,  5.6593406593399997e-01,  5.7142857142900005e-01, \
                                    5.7692307692300004e-01,  5.8241758241800001e-01,  5.8791208791200000e-01, \
                                    5.9340659340699997e-01,  5.9890109890099996e-01,  6.0439560439600004e-01, \
                                    6.0989010989000003e-01,  6.1538461538500000e-01,  6.2087912087899999e-01, \
                                    6.2637362637399996e-01,  6.3186813186799995e-01,  6.3736263736300003e-01, \
                                    6.4285714285700002e-01,  6.4835164835199999e-01,  6.5384615384599998e-01, \
                                    6.5934065934099995e-01,  6.6483516483500005e-01,  6.7032967033000002e-01, \
                                    6.7582417582400001e-01,  6.8131868131899997e-01,  6.8681318681299997e-01, \
                                    6.9230769230800004e-01,  6.9780219780200003e-01,  7.0329670329700000e-01, \
                                    7.0879120879099999e-01,  7.1428571428599996e-01,  7.1978021977999995e-01, \
                                    7.2527472527500003e-01,  7.3076923076900002e-01,  7.3626373626399999e-01, \
                                    7.4175824175799998e-01,  7.4725274725299995e-01,  7.5274725274700005e-01, \
                                    7.5824175824200002e-01,  7.6373626373600001e-01,  7.6923076923099998e-01, \
                                    7.7472527472499997e-01,  7.8021978022000005e-01,  7.8571428571400004e-01, \
                                    7.9120879120900001e-01,  7.9670329670300000e-01,  8.0219780219799997e-01, \
                                    8.0769230769199996e-01,  8.1318681318700003e-01,  8.1868131868100003e-01, \
                                    8.2417582417599999e-01,  8.2967032966999998e-01,  8.3516483516499995e-01, \
                                    8.4065934065900005e-01,  8.4615384615400002e-01,  8.5164835164800001e-01, \
                                    8.5714285714299998e-01,  8.6263736263699997e-01,  8.6813186813200005e-01, \
                                    8.7362637362600004e-01,  8.7912087912100001e-01,  8.8461538461500000e-01, \
                                    8.9010989010999997e-01,  8.9560439560399996e-01,  9.0109890109900004e-01, \
                                    9.0659340659300003e-01,  9.1208791208800000e-01,  9.1758241758199999e-01, \
                                    9.2307692307699996e-01,  9.2857142857099995e-01,  9.3406593406600003e-01, \
                                    9.3956043956000002e-01,  9.4505494505499998e-01,  9.5054945054899997e-01, \
                                    9.5604395604400005e-01,  9.6153846153800004e-01,  9.6703296703300001e-01, \
                                    9.7252747252700000e-01,  9.7802197802199997e-01,  9.8351648351599996e-01, \
                                    9.8901098901100004e-01,  9.9450549450500003e-01,  1.0000000000000000e+00, \
                                    -1.0000000000000000e+00, -9.9560439560400005e-01, -9.9120879120899996e-01, \
                                    -9.8681318681300001e-01, -9.8241758241800003e-01, -9.7802197802199997e-01, \
                                    -9.7362637362600002e-01, -9.6923076923100004e-01, -9.6483516483499998e-01, \
                                    -9.6043956044000001e-01, -9.5604395604400005e-01, -9.5164835164799999e-01, \
                                    -9.4725274725300002e-01, -9.4285714285699995e-01, -9.3846153846199998e-01, \
                                    -9.3406593406600003e-01, -9.2967032966999996e-01, -9.2527472527499999e-01, \
                                    -9.2087912087900003e-01, -9.1648351648399995e-01, -9.1208791208800000e-01, \
                                    -9.0769230769200004e-01, -9.0329670329699996e-01, -8.9890109890100001e-01, \
                                    -8.9450549450500005e-01, -8.9010989010999997e-01, -8.8571428571400002e-01, \
                                    -8.8131868131900004e-01, -8.7692307692299998e-01, -8.7252747252700003e-01, \
                                    -8.6813186813200005e-01, -8.6373626373599999e-01, -8.5934065934100001e-01, \
                                    -8.5494505494499995e-01, -8.5054945054900000e-01, -8.4615384615400002e-01, \
                                    -8.4175824175799996e-01, -8.3736263736299998e-01, -8.3296703296700003e-01, \
                                    -8.2857142857099997e-01, -8.2417582417599999e-01, -8.1978021978000004e-01, \
                                    -8.1538461538499996e-01, -8.1098901098900000e-01, -8.0659340659300005e-01, \
                                    -8.0219780219799997e-01, -7.9780219780200001e-01, -7.9340659340700004e-01, \
                                    -7.8901098901099997e-01, -7.8461538461500002e-01, -7.8021978022000005e-01, \
                                    -7.7582417582399998e-01, -7.7142857142900001e-01, -7.6703296703299995e-01, \
                                    -7.6263736263699999e-01, -7.5824175824200002e-01, -7.5384615384599996e-01, \
                                    -7.4945054945099998e-01, -7.4505494505500003e-01, -7.4065934065899997e-01, \
                                    -7.3626373626399999e-01, -7.3186813186800004e-01, -7.2747252747299995e-01, \
                                    -7.2307692307700000e-01, -7.1868131868100005e-01, -7.1428571428599996e-01, \
                                    -7.0989010989000001e-01, -7.0549450549500003e-01, -7.0109890109899997e-01, \
                                    -6.9670329670300002e-01, -6.9230769230800004e-01, -6.8791208791199998e-01, \
                                    -6.8351648351600003e-01, -6.7912087912100005e-01, -6.7472527472499999e-01, \
                                    -6.7032967033000002e-01, -6.6593406593399995e-01, -6.6153846153800000e-01, \
                                    -6.5714285714300003e-01, -6.5274725274699996e-01, -6.4835164835199999e-01, \
                                    -6.4395604395600003e-01, -6.3956043955999997e-01, -6.3516483516500000e-01, \
                                    -6.3076923076900004e-01, -6.2637362637399996e-01, -6.2197802197800001e-01, \
                                    -6.1758241758200005e-01, -6.1318681318699997e-01, -6.0879120879100002e-01, \
                                    -6.0439560439600004e-01, -5.9999999999999998e-01, -5.9560439560400003e-01, \
                                    -5.9120879120900005e-01, -5.8681318681299999e-01, -5.8241758241800001e-01, \
                                    -5.7802197802199995e-01, -5.7362637362600000e-01, -5.6923076923100002e-01, \
                                    -5.6483516483499996e-01, -5.6043956043999998e-01, -5.5604395604400003e-01, \
                                    -5.5164835164799997e-01, -5.4725274725299999e-01, -5.4285714285700004e-01, \
                                    -5.3846153846199996e-01, -5.3406593406600000e-01, -5.2967032967000005e-01, \
                                    -5.2527472527499997e-01, -5.2087912087900001e-01, -5.1648351648400004e-01, \
                                    -5.1208791208799997e-01, -5.0769230769200002e-01, -5.0329670329700005e-01, \
                                    -4.9890109890099998e-01, -4.9450549450499998e-01, -4.9010989011000000e-01, \
                                    -4.8571428571399999e-01, -4.8131868131900002e-01, -4.7692307692300001e-01, \
                                    -4.7252747252700000e-01, -4.6813186813199997e-01, -4.6373626373600002e-01, \
                                    -4.5934065934099999e-01, -4.5494505494499998e-01, -4.5054945054899997e-01, \
                                    -4.4615384615400000e-01, -4.4175824175799999e-01, -4.3736263736300002e-01, \
                                    -4.3296703296700001e-01, -4.2857142857100000e-01, -4.2417582417600003e-01, \
                                    -4.1978021978000002e-01, -4.1538461538499999e-01, -4.1098901098899998e-01, \
                                    -4.0659340659299997e-01, -4.0219780219800000e-01, -3.9780219780199999e-01, \
                                    -3.9340659340700002e-01, -3.8901098901100001e-01, -3.8461538461500000e-01, \
                                    -3.8021978022000003e-01, -3.7582417582400002e-01, -3.7142857142899999e-01, \
                                    -3.6703296703299998e-01, -3.6263736263700003e-01, -3.5824175824200000e-01, \
                                    -3.5384615384599999e-01, -3.4945054945100001e-01, -3.4505494505500001e-01, \
                                    -3.4065934065900000e-01, -3.3626373626400002e-01, -3.3186813186800002e-01, \
                                    -3.2747252747299999e-01, -3.2307692307699998e-01, -3.1868131868100003e-01, \
                                    -3.1428571428600000e-01, -3.0989010988999999e-01, -3.0549450549500001e-01, \
                                    -3.0109890109900000e-01, -2.9670329670300000e-01, -2.9230769230800002e-01, \
                                    -2.8791208791200001e-01, -2.8351648351600001e-01, -2.7912087912099998e-01, \
                                    -2.7472527472500002e-01, -2.7032967032999999e-01, -2.6593406593399999e-01, \
                                    -2.6153846153799998e-01, -2.5714285714300000e-01, -2.5274725274700000e-01, \
                                    -2.4835164835199999e-01, -2.4395604395600001e-01, -2.3956043956000000e-01, \
                                    -2.3516483516500000e-01, -2.3076923076899999e-01, -2.2637362637399999e-01, \
                                    -2.2197802197800001e-01, -2.1758241758200000e-01, -2.1318681318700000e-01, \
                                    -2.0879120879099999e-01, -2.0439560439599999e-01, -2.0000000000000001e-01, \
                                    -1.9560439560400000e-01, -1.9120879120900000e-01, -1.8681318681299999e-01, \
                                    -1.8241758241799999e-01, -1.7802197802200001e-01, -1.7362637362600000e-01, \
                                    -1.6923076923100000e-01, -1.6483516483499999e-01, -1.6043956043999999e-01, \
                                    -1.5604395604400001e-01, -1.5164835164800000e-01, -1.4725274725300000e-01, \
                                    -1.4285714285699999e-01, -1.3846153846199999e-01, -1.3406593406600001e-01, \
                                    -1.2967032967000000e-01, -1.2527472527500000e-01, -1.2087912087900000e-01, \
                                    -1.1648351648400000e-01, -1.1208791208799999e-01, -1.0769230769200000e-01, \
                                    -1.0329670329700000e-01, -9.8901098901000004e-02, -9.4505494504999996e-02, \
                                    -9.0109890109999993e-02, -8.5714285713999999e-02, -8.1318681318999997e-02, \
                                    -7.6923076923000003e-02, -7.2527472526999995e-02, -6.8131868132000006e-02, \
                                    -6.3736263735999998e-02, -5.9340659341000003e-02, -5.4945054945000002e-02, \
                                    -5.0549450549000001e-02, -4.6153846153999999e-02, -4.1758241757999998e-02, \
                                    -3.7362637363000002e-02, -3.2967032967000001e-02, -2.8571428571000000e-02, \
                                    -2.4175824176000001e-02, -1.9780219780000000e-02, -1.5384615385000000e-02, \
                                    -1.0989010989000000e-02, -6.5934065930000002e-03, -2.1978021980000001e-03, \
                                    2.1978021980000001e-03,  6.5934065930000002e-03,  1.0989010989000000e-02, \
                                    1.5384615385000000e-02,  1.9780219780000000e-02,  2.4175824176000001e-02, \
                                    2.8571428571000000e-02,  3.2967032967000001e-02,  3.7362637363000002e-02, \
                                    4.1758241757999998e-02,  4.6153846153999999e-02,  5.0549450549000001e-02, \
                                    5.4945054945000002e-02,  5.9340659341000003e-02,  6.3736263735999998e-02, \
                                    6.8131868132000006e-02,  7.2527472526999995e-02,  7.6923076923000003e-02, \
                                    8.1318681318999997e-02,  8.5714285713999999e-02,  9.0109890109999993e-02, \
                                    9.4505494504999996e-02,  9.8901098901000004e-02,  1.0329670329700000e-01, \
                                    1.0769230769200000e-01,  1.1208791208799999e-01,  1.1648351648400000e-01, \
                                    1.2087912087900000e-01,  1.2527472527500000e-01,  1.2967032967000000e-01, \
                                    1.3406593406600001e-01,  1.3846153846199999e-01,  1.4285714285699999e-01, \
                                    1.4725274725300000e-01,  1.5164835164800000e-01,  1.5604395604400001e-01, \
                                    1.6043956043999999e-01,  1.6483516483499999e-01,  1.6923076923100000e-01, \
                                    1.7362637362600000e-01,  1.7802197802200001e-01,  1.8241758241799999e-01, \
                                    1.8681318681299999e-01,  1.9120879120900000e-01,  1.9560439560400000e-01, \
                                    2.0000000000000001e-01,  2.0439560439599999e-01,  2.0879120879099999e-01, \
                                    2.1318681318700000e-01,  2.1758241758200000e-01,  2.2197802197800001e-01, \
                                    2.2637362637399999e-01,  2.3076923076899999e-01,  2.3516483516500000e-01, \
                                    2.3956043956000000e-01,  2.4395604395600001e-01,  2.4835164835199999e-01, \
                                    2.5274725274700000e-01,  2.5714285714300000e-01,  2.6153846153799998e-01, \
                                    2.6593406593399999e-01,  2.7032967032999999e-01,  2.7472527472500002e-01, \
                                    2.7912087912099998e-01,  2.8351648351600001e-01,  2.8791208791200001e-01, \
                                    2.9230769230800002e-01,  2.9670329670300000e-01,  3.0109890109900000e-01, \
                                    3.0549450549500001e-01,  3.0989010988999999e-01,  3.1428571428600000e-01, \
                                    3.1868131868100003e-01,  3.2307692307699998e-01,  3.2747252747299999e-01, \
                                    3.3186813186800002e-01,  3.3626373626400002e-01,  3.4065934065900000e-01, \
                                    3.4505494505500001e-01,  3.4945054945100001e-01,  3.5384615384599999e-01, \
                                    3.5824175824200000e-01,  3.6263736263700003e-01,  3.6703296703299998e-01, \
                                    3.7142857142899999e-01,  3.7582417582400002e-01,  3.8021978022000003e-01, \
                                    3.8461538461500000e-01,  3.8901098901100001e-01,  3.9340659340700002e-01, \
                                    3.9780219780199999e-01,  4.0219780219800000e-01,  4.0659340659299997e-01, \
                                    4.1098901098899998e-01,  4.1538461538499999e-01,  4.1978021978000002e-01, \
                                    4.2417582417600003e-01,  4.2857142857100000e-01,  4.3296703296700001e-01, \
                                    4.3736263736300002e-01,  4.4175824175799999e-01,  4.4615384615400000e-01, \
                                    4.5054945054899997e-01,  4.5494505494499998e-01,  4.5934065934099999e-01, \
                                    4.6373626373600002e-01,  4.6813186813199997e-01,  4.7252747252700000e-01, \
                                    4.7692307692300001e-01,  4.8131868131900002e-01,  4.8571428571399999e-01, \
                                    4.9010989011000000e-01,  4.9450549450499998e-01,  4.9890109890099998e-01, \
                                    5.0329670329700005e-01,  5.0769230769200002e-01,  5.1208791208799997e-01, \
                                    5.1648351648400004e-01,  5.2087912087900001e-01,  5.2527472527499997e-01, \
                                    5.2967032967000005e-01,  5.3406593406600000e-01,  5.3846153846199996e-01, \
                                    5.4285714285700004e-01,  5.4725274725299999e-01,  5.5164835164799997e-01, \
                                    5.5604395604400003e-01,  5.6043956043999998e-01,  5.6483516483499996e-01, \
                                    5.6923076923100002e-01,  5.7362637362600000e-01,  5.7802197802199995e-01, \
                                    5.8241758241800001e-01,  5.8681318681299999e-01,  5.9120879120900005e-01, \
                                    5.9560439560400003e-01,  5.9999999999999998e-01,  6.0439560439600004e-01, \
                                    6.0879120879100002e-01,  6.1318681318699997e-01,  6.1758241758200005e-01, \
                                    6.2197802197800001e-01,  6.2637362637399996e-01,  6.3076923076900004e-01, \
                                    6.3516483516500000e-01,  6.3956043955999997e-01,  6.4395604395600003e-01, \
                                    6.4835164835199999e-01,  6.5274725274699996e-01,  6.5714285714300003e-01, \
                                    6.6153846153800000e-01,  6.6593406593399995e-01,  6.7032967033000002e-01, \
                                    6.7472527472499999e-01,  6.7912087912100005e-01,  6.8351648351600003e-01, \
                                    6.8791208791199998e-01,  6.9230769230800004e-01,  6.9670329670300002e-01, \
                                    7.0109890109899997e-01,  7.0549450549500003e-01,  7.0989010989000001e-01, \
                                    7.1428571428599996e-01,  7.1868131868100005e-01,  7.2307692307700000e-01, \
                                    7.2747252747299995e-01,  7.3186813186800004e-01,  7.3626373626399999e-01, \
                                    7.4065934065899997e-01,  7.4505494505500003e-01,  7.4945054945099998e-01, \
                                    7.5384615384599996e-01,  7.5824175824200002e-01,  7.6263736263699999e-01, \
                                    7.6703296703299995e-01,  7.7142857142900001e-01,  7.7582417582399998e-01, \
                                    7.8021978022000005e-01,  7.8461538461500002e-01,  7.8901098901099997e-01, \
                                    7.9340659340700004e-01,  7.9780219780200001e-01,  8.0219780219799997e-01, \
                                    8.0659340659300005e-01,  8.1098901098900000e-01,  8.1538461538499996e-01, \
                                    8.1978021978000004e-01,  8.2417582417599999e-01,  8.2857142857099997e-01, \
                                    8.3296703296700003e-01,  8.3736263736299998e-01,  8.4175824175799996e-01, \
                                    8.4615384615400002e-01,  8.5054945054900000e-01,  8.5494505494499995e-01, \
                                    8.5934065934100001e-01,  8.6373626373599999e-01,  8.6813186813200005e-01, \
                                    8.7252747252700003e-01,  8.7692307692299998e-01,  8.8131868131900004e-01, \
                                    8.8571428571400002e-01,  8.9010989010999997e-01,  8.9450549450500005e-01, \
                                    8.9890109890100001e-01,  9.0329670329699996e-01,  9.0769230769200004e-01, \
                                    9.1208791208800000e-01,  9.1648351648399995e-01,  9.2087912087900003e-01, \
                                    9.2527472527499999e-01,  9.2967032966999996e-01,  9.3406593406600003e-01, \
                                    9.3846153846199998e-01,  9.4285714285699995e-01,  9.4725274725300002e-01, \
                                    9.5164835164799999e-01,  9.5604395604400005e-01,  9.6043956044000001e-01, \
                                    9.6483516483499998e-01,  9.6923076923100004e-01,  9.7362637362600002e-01, \
                                    9.7802197802199997e-01,  9.8241758241800003e-01,  9.8681318681300001e-01, \
                                    9.9120879120899996e-01,  9.9560439560400005e-01,  1.0000000000000000e+00, \
                                    -1.0000000000000000e+00, -9.9642857142899999e-01, -9.9285714285700000e-01, \
                                    -9.8928571428599998e-01, -9.8571428571399999e-01, -9.8214285714299998e-01, \
                                    -9.7857142857099999e-01, -9.7499999999999998e-01, -9.7142857142899997e-01, \
                                    -9.6785714285699997e-01, -9.6428571428599996e-01, -9.6071428571399997e-01, \
                                    -9.5714285714299996e-01, -9.5357142857099997e-01, -9.4999999999999996e-01, \
                                    -9.4642857142900005e-01, -9.4285714285699995e-01, -9.3928571428600005e-01, \
                                    -9.3571428571399995e-01, -9.3214285714300005e-01, -9.2857142857099995e-01, \
                                    -9.2500000000000004e-01, -9.2142857142900003e-01, -9.1785714285700004e-01, \
                                    -9.1428571428600003e-01, -9.1071428571400004e-01, -9.0714285714300003e-01, \
                                    -9.0357142857100003e-01, -9.0000000000000002e-01, -8.9642857142900001e-01, \
                                    -8.9285714285700002e-01, -8.8928571428600001e-01, -8.8571428571400002e-01, \
                                    -8.8214285714300000e-01, -8.7857142857100001e-01, -8.7500000000000000e-01, \
                                    -8.7142857142899999e-01, -8.6785714285700000e-01, -8.6428571428599998e-01, \
                                    -8.6071428571399999e-01, -8.5714285714299998e-01, -8.5357142857099999e-01, \
                                    -8.4999999999999998e-01, -8.4642857142899997e-01, -8.4285714285699997e-01, \
                                    -8.3928571428599996e-01, -8.3571428571399997e-01, -8.3214285714299996e-01, \
                                    -8.2857142857099997e-01, -8.2499999999999996e-01, -8.2142857142900005e-01, \
                                    -8.1785714285699995e-01, -8.1428571428600005e-01, -8.1071428571399995e-01, \
                                    -8.0714285714300005e-01, -8.0357142857099995e-01, -8.0000000000000004e-01, \
                                    -7.9642857142900003e-01, -7.9285714285700004e-01, -7.8928571428600003e-01, \
                                    -7.8571428571400004e-01, -7.8214285714300003e-01, -7.7857142857100003e-01, \
                                    -7.7500000000000002e-01, -7.7142857142900001e-01, -7.6785714285700002e-01, \
                                    -7.6428571428600001e-01, -7.6071428571400002e-01, -7.5714285714300000e-01, \
                                    -7.5357142857100001e-01, -7.5000000000000000e-01, -7.4642857142899999e-01, \
                                    -7.4285714285700000e-01, -7.3928571428599998e-01, -7.3571428571399999e-01, \
                                    -7.3214285714299998e-01, -7.2857142857099999e-01, -7.2499999999999998e-01, \
                                    -7.2142857142899997e-01, -7.1785714285699997e-01, -7.1428571428599996e-01, \
                                    -7.1071428571399997e-01, -7.0714285714299996e-01, -7.0357142857099997e-01, \
                                    -6.9999999999999996e-01, -6.9642857142900005e-01, -6.9285714285699995e-01, \
                                    -6.8928571428600005e-01, -6.8571428571399995e-01, -6.8214285714300005e-01, \
                                    -6.7857142857099995e-01, -6.7500000000000004e-01, -6.7142857142900003e-01, \
                                    -6.6785714285700004e-01, -6.6428571428600003e-01, -6.6071428571400004e-01, \
                                    -6.5714285714300003e-01, -6.5357142857100003e-01, -6.5000000000000002e-01, \
                                    -6.4642857142900001e-01, -6.4285714285700002e-01, -6.3928571428600001e-01, \
                                    -6.3571428571400002e-01, -6.3214285714300000e-01, -6.2857142857100001e-01, \
                                    -6.2500000000000000e-01, -6.2142857142899999e-01, -6.1785714285700000e-01, \
                                    -6.1428571428599998e-01, -6.1071428571399999e-01, -6.0714285714299998e-01, \
                                    -6.0357142857099999e-01, -5.9999999999999998e-01, -5.9642857142899997e-01, \
                                    -5.9285714285699997e-01, -5.8928571428599996e-01, -5.8571428571399997e-01, \
                                    -5.8214285714299996e-01, -5.7857142857099997e-01, -5.7499999999999996e-01, \
                                    -5.7142857142900005e-01, -5.6785714285699995e-01, -5.6428571428600005e-01, \
                                    -5.6071428571399995e-01, -5.5714285714300005e-01, -5.5357142857099995e-01, \
                                    -5.5000000000000004e-01, -5.4642857142900003e-01, -5.4285714285700004e-01, \
                                    -5.3928571428600003e-01, -5.3571428571400004e-01, -5.3214285714300003e-01, \
                                    -5.2857142857100003e-01, -5.2500000000000002e-01, -5.2142857142900001e-01, \
                                    -5.1785714285700002e-01, -5.1428571428600001e-01, -5.1071428571400002e-01, \
                                    -5.0714285714300000e-01, -5.0357142857100001e-01, -5.0000000000000000e-01, \
                                    -4.9642857142899999e-01, -4.9285714285700000e-01, -4.8928571428599998e-01, \
                                    -4.8571428571399999e-01, -4.8214285714299998e-01, -4.7857142857099999e-01, \
                                    -4.7499999999999998e-01, -4.7142857142900002e-01, -4.6785714285699997e-01, \
                                    -4.6428571428600002e-01, -4.6071428571400003e-01, -4.5714285714300001e-01, \
                                    -4.5357142857100002e-01, -4.5000000000000001e-01, -4.4642857142900000e-01, \
                                    -4.4285714285700001e-01, -4.3928571428600000e-01, -4.3571428571400000e-01, \
                                    -4.3214285714299999e-01, -4.2857142857100000e-01, -4.2499999999999999e-01, \
                                    -4.2142857142899998e-01, -4.1785714285699999e-01, -4.1428571428599997e-01, \
                                    -4.1071428571399998e-01, -4.0714285714300003e-01, -4.0357142857099998e-01, \
                                    -4.0000000000000002e-01, -3.9642857142900001e-01, -3.9285714285700002e-01, \
                                    -3.8928571428600001e-01, -3.8571428571400002e-01, -3.8214285714300000e-01, \
                                    -3.7857142857100001e-01, -3.7500000000000000e-01, -3.7142857142899999e-01, \
                                    -3.6785714285700000e-01, -3.6428571428599998e-01, -3.6071428571399999e-01, \
                                    -3.5714285714299998e-01, -3.5357142857099999e-01, -3.4999999999999998e-01, \
                                    -3.4642857142900002e-01, -3.4285714285699997e-01, -3.3928571428600002e-01, \
                                    -3.3571428571400003e-01, -3.3214285714300001e-01, -3.2857142857100002e-01, \
                                    -3.2500000000000001e-01, -3.2142857142900000e-01, -3.1785714285700001e-01, \
                                    -3.1428571428600000e-01, -3.1071428571400000e-01, -3.0714285714299999e-01, \
                                    -3.0357142857100000e-01, -2.9999999999999999e-01, -2.9642857142899998e-01, \
                                    -2.9285714285699999e-01, -2.8928571428599997e-01, -2.8571428571399998e-01, \
                                    -2.8214285714300003e-01, -2.7857142857099998e-01, -2.7500000000000002e-01, \
                                    -2.7142857142900001e-01, -2.6785714285700002e-01, -2.6428571428600001e-01, \
                                    -2.6071428571400002e-01, -2.5714285714300000e-01, -2.5357142857100001e-01, \
                                    -2.5000000000000000e-01, -2.4642857142899999e-01, -2.4285714285700000e-01, \
                                    -2.3928571428600001e-01, -2.3571428571399999e-01, -2.3214285714300001e-01, \
                                    -2.2857142857099999e-01, -2.2500000000000001e-01, -2.2142857142899999e-01, \
                                    -2.1785714285700000e-01, -2.1428571428599999e-01, -2.1071428571400000e-01, \
                                    -2.0714285714299999e-01, -2.0357142857100000e-01, -2.0000000000000001e-01, \
                                    -1.9642857142900000e-01, -1.9285714285700001e-01, -1.8928571428600000e-01, \
                                    -1.8571428571400000e-01, -1.8214285714299999e-01, -1.7857142857100000e-01, \
                                    -1.7499999999999999e-01, -1.7142857142900000e-01, -1.6785714285700001e-01, \
                                    -1.6428571428600000e-01, -1.6071428571400001e-01, -1.5714285714300000e-01, \
                                    -1.5357142857100001e-01, -1.4999999999999999e-01, -1.4642857142900001e-01, \
                                    -1.4285714285699999e-01, -1.3928571428600001e-01, -1.3571428571399999e-01, \
                                    -1.3214285714300000e-01, -1.2857142857100001e-01, -1.2500000000000000e-01, \
                                    -1.2142857142900000e-01, -1.1785714285700000e-01, -1.1428571428600000e-01, \
                                    -1.1071428571399999e-01, -1.0714285714299999e-01, -1.0357142857100000e-01, \
                                    -1.0000000000000001e-01, -9.6428571429000007e-02, -9.2857142857000002e-02, \
                                    -8.9285714286000004e-02, -8.5714285713999999e-02, -8.2142857143000000e-02, \
                                    -7.8571428570999996e-02, -7.4999999999999997e-02, -7.1428571428999998e-02, \
                                    -6.7857142856999994e-02, -6.4285714285999995e-02, -6.0714285713999998e-02, \
                                    -5.7142857142999999e-02, -5.3571428571000002e-02, -5.0000000000000003e-02, \
                                    -4.6428571428999997e-02, -4.2857142857000000e-02, -3.9285714286000001e-02, \
                                    -3.5714285714000003e-02, -3.2142857142999998e-02, -2.8571428571000000e-02, \
                                    -2.5000000000000001e-02, -2.1428571428999999e-02, -1.7857142857000002e-02, \
                                    -1.4285714285999999e-02, -1.0714285714000000e-02, -7.1428571429999997e-03, \
                                    -3.5714285710000001e-03,  0.0000000000000000e+00,  3.5714285710000001e-03, \
                                    7.1428571429999997e-03,  1.0714285714000000e-02,  1.4285714285999999e-02, \
                                    1.7857142857000002e-02,  2.1428571428999999e-02,  2.5000000000000001e-02, \
                                    2.8571428571000000e-02,  3.2142857142999998e-02,  3.5714285714000003e-02, \
                                    3.9285714286000001e-02,  4.2857142857000000e-02,  4.6428571428999997e-02, \
                                    5.0000000000000003e-02,  5.3571428571000002e-02,  5.7142857142999999e-02, \
                                    6.0714285713999998e-02,  6.4285714285999995e-02,  6.7857142856999994e-02, \
                                    7.1428571428999998e-02,  7.4999999999999997e-02,  7.8571428570999996e-02, \
                                    8.2142857143000000e-02,  8.5714285713999999e-02,  8.9285714286000004e-02, \
                                    9.2857142857000002e-02,  9.6428571429000007e-02,  1.0000000000000001e-01, \
                                    1.0357142857100000e-01,  1.0714285714299999e-01,  1.1071428571399999e-01, \
                                    1.1428571428600000e-01,  1.1785714285700000e-01,  1.2142857142900000e-01, \
                                    1.2500000000000000e-01,  1.2857142857100001e-01,  1.3214285714300000e-01, \
                                    1.3571428571399999e-01,  1.3928571428600001e-01,  1.4285714285699999e-01, \
                                    1.4642857142900001e-01,  1.4999999999999999e-01,  1.5357142857100001e-01, \
                                    1.5714285714300000e-01,  1.6071428571400001e-01,  1.6428571428600000e-01, \
                                    1.6785714285700001e-01,  1.7142857142900000e-01,  1.7499999999999999e-01, \
                                    1.7857142857100000e-01,  1.8214285714299999e-01,  1.8571428571400000e-01, \
                                    1.8928571428600000e-01,  1.9285714285700001e-01,  1.9642857142900000e-01, \
                                    2.0000000000000001e-01,  2.0357142857100000e-01,  2.0714285714299999e-01, \
                                    2.1071428571400000e-01,  2.1428571428599999e-01,  2.1785714285700000e-01, \
                                    2.2142857142899999e-01,  2.2500000000000001e-01,  2.2857142857099999e-01, \
                                    2.3214285714300001e-01,  2.3571428571399999e-01,  2.3928571428600001e-01, \
                                    2.4285714285700000e-01,  2.4642857142899999e-01,  2.5000000000000000e-01, \
                                    2.5357142857100001e-01,  2.5714285714300000e-01,  2.6071428571400002e-01, \
                                    2.6428571428600001e-01,  2.6785714285700002e-01,  2.7142857142900001e-01, \
                                    2.7500000000000002e-01,  2.7857142857099998e-01,  2.8214285714300003e-01, \
                                    2.8571428571399998e-01,  2.8928571428599997e-01,  2.9285714285699999e-01, \
                                    2.9642857142899998e-01,  2.9999999999999999e-01,  3.0357142857100000e-01, \
                                    3.0714285714299999e-01,  3.1071428571400000e-01,  3.1428571428600000e-01, \
                                    3.1785714285700001e-01,  3.2142857142900000e-01,  3.2500000000000001e-01, \
                                    3.2857142857100002e-01,  3.3214285714300001e-01,  3.3571428571400003e-01, \
                                    3.3928571428600002e-01,  3.4285714285699997e-01,  3.4642857142900002e-01, \
                                    3.4999999999999998e-01,  3.5357142857099999e-01,  3.5714285714299998e-01, \
                                    3.6071428571399999e-01,  3.6428571428599998e-01,  3.6785714285700000e-01, \
                                    3.7142857142899999e-01,  3.7500000000000000e-01,  3.7857142857100001e-01, \
                                    3.8214285714300000e-01,  3.8571428571400002e-01,  3.8928571428600001e-01, \
                                    3.9285714285700002e-01,  3.9642857142900001e-01,  4.0000000000000002e-01, \
                                    4.0357142857099998e-01,  4.0714285714300003e-01,  4.1071428571399998e-01, \
                                    4.1428571428599997e-01,  4.1785714285699999e-01,  4.2142857142899998e-01, \
                                    4.2499999999999999e-01,  4.2857142857100000e-01,  4.3214285714299999e-01, \
                                    4.3571428571400000e-01,  4.3928571428600000e-01,  4.4285714285700001e-01, \
                                    4.4642857142900000e-01,  4.5000000000000001e-01,  4.5357142857100002e-01, \
                                    4.5714285714300001e-01,  4.6071428571400003e-01,  4.6428571428600002e-01, \
                                    4.6785714285699997e-01,  4.7142857142900002e-01,  4.7499999999999998e-01, \
                                    4.7857142857099999e-01,  4.8214285714299998e-01,  4.8571428571399999e-01, \
                                    4.8928571428599998e-01,  4.9285714285700000e-01,  4.9642857142899999e-01, \
                                    5.0000000000000000e-01,  5.0357142857100001e-01,  5.0714285714300000e-01, \
                                    5.1071428571400002e-01,  5.1428571428600001e-01,  5.1785714285700002e-01, \
                                    5.2142857142900001e-01,  5.2500000000000002e-01,  5.2857142857100003e-01, \
                                    5.3214285714300003e-01,  5.3571428571400004e-01,  5.3928571428600003e-01, \
                                    5.4285714285700004e-01,  5.4642857142900003e-01,  5.5000000000000004e-01, \
                                    5.5357142857099995e-01,  5.5714285714300005e-01,  5.6071428571399995e-01, \
                                    5.6428571428600005e-01,  5.6785714285699995e-01,  5.7142857142900005e-01, \
                                    5.7499999999999996e-01,  5.7857142857099997e-01,  5.8214285714299996e-01, \
                                    5.8571428571399997e-01,  5.8928571428599996e-01,  5.9285714285699997e-01, \
                                    5.9642857142899997e-01,  5.9999999999999998e-01,  6.0357142857099999e-01, \
                                    6.0714285714299998e-01,  6.1071428571399999e-01,  6.1428571428599998e-01, \
                                    6.1785714285700000e-01,  6.2142857142899999e-01,  6.2500000000000000e-01, \
                                    6.2857142857100001e-01,  6.3214285714300000e-01,  6.3571428571400002e-01, \
                                    6.3928571428600001e-01,  6.4285714285700002e-01,  6.4642857142900001e-01, \
                                    6.5000000000000002e-01,  6.5357142857100003e-01,  6.5714285714300003e-01, \
                                    6.6071428571400004e-01,  6.6428571428600003e-01,  6.6785714285700004e-01, \
                                    6.7142857142900003e-01,  6.7500000000000004e-01,  6.7857142857099995e-01, \
                                    6.8214285714300005e-01,  6.8571428571399995e-01,  6.8928571428600005e-01, \
                                    6.9285714285699995e-01,  6.9642857142900005e-01,  6.9999999999999996e-01, \
                                    7.0357142857099997e-01,  7.0714285714299996e-01,  7.1071428571399997e-01, \
                                    7.1428571428599996e-01,  7.1785714285699997e-01,  7.2142857142899997e-01, \
                                    7.2499999999999998e-01,  7.2857142857099999e-01,  7.3214285714299998e-01, \
                                    7.3571428571399999e-01,  7.3928571428599998e-01,  7.4285714285700000e-01, \
                                    7.4642857142899999e-01,  7.5000000000000000e-01,  7.5357142857100001e-01, \
                                    7.5714285714300000e-01,  7.6071428571400002e-01,  7.6428571428600001e-01, \
                                    7.6785714285700002e-01,  7.7142857142900001e-01,  7.7500000000000002e-01, \
                                    7.7857142857100003e-01,  7.8214285714300003e-01,  7.8571428571400004e-01, \
                                    7.8928571428600003e-01,  7.9285714285700004e-01,  7.9642857142900003e-01, \
                                    8.0000000000000004e-01,  8.0357142857099995e-01,  8.0714285714300005e-01, \
                                    8.1071428571399995e-01,  8.1428571428600005e-01,  8.1785714285699995e-01, \
                                    8.2142857142900005e-01,  8.2499999999999996e-01,  8.2857142857099997e-01, \
                                    8.3214285714299996e-01,  8.3571428571399997e-01,  8.3928571428599996e-01, \
                                    8.4285714285699997e-01,  8.4642857142899997e-01,  8.4999999999999998e-01, \
                                    8.5357142857099999e-01,  8.5714285714299998e-01,  8.6071428571399999e-01, \
                                    8.6428571428599998e-01,  8.6785714285700000e-01,  8.7142857142899999e-01, \
                                    8.7500000000000000e-01,  8.7857142857100001e-01,  8.8214285714300000e-01, \
                                    8.8571428571400002e-01,  8.8928571428600001e-01,  8.9285714285700002e-01, \
                                    8.9642857142900001e-01,  9.0000000000000002e-01,  9.0357142857100003e-01, \
                                    9.0714285714300003e-01,  9.1071428571400004e-01,  9.1428571428600003e-01, \
                                    9.1785714285700004e-01,  9.2142857142900003e-01,  9.2500000000000004e-01, \
                                    9.2857142857099995e-01,  9.3214285714300005e-01,  9.3571428571399995e-01, \
                                    9.3928571428600005e-01,  9.4285714285699995e-01,  9.4642857142900005e-01, \
                                    9.4999999999999996e-01,  9.5357142857099997e-01,  9.5714285714299996e-01, \
                                    9.6071428571399997e-01,  9.6428571428599996e-01,  9.6785714285699997e-01, \
                                    9.7142857142899997e-01,  9.7499999999999998e-01,  9.7857142857099999e-01, \
                                    9.8214285714299998e-01,  9.8571428571399999e-01,  9.8928571428599998e-01, \
                                    9.9285714285700000e-01,  9.9642857142899999e-01,  1.0000000000000000e+00, \
                                    -1.0000000000000000e+00, -9.9705882352899999e-01, -9.9411764705899996e-01, \
                                    -9.9117647058799996e-01, -9.8823529411800004e-01, -9.8529411764700003e-01, \
                                    -9.8235294117600003e-01, -9.7941176470600000e-01, -9.7647058823499999e-01, \
                                    -9.7352941176499996e-01, -9.7058823529399996e-01, -9.6764705882400004e-01, \
                                    -9.6470588235300003e-01, -9.6176470588200003e-01, -9.5882352941200000e-01, \
                                    -9.5588235294099999e-01, -9.5294117647099996e-01, -9.4999999999999996e-01, \
                                    -9.4705882352899995e-01, -9.4411764705900003e-01, -9.4117647058800002e-01, \
                                    -9.3823529411800000e-01, -9.3529411764699999e-01, -9.3235294117599998e-01, \
                                    -9.2941176470599995e-01, -9.2647058823499995e-01, -9.2352941176500003e-01, \
                                    -9.2058823529400002e-01, -9.1764705882399999e-01, -9.1470588235299999e-01, \
                                    -9.1176470588199998e-01, -9.0882352941199995e-01, -9.0588235294099995e-01, \
                                    -9.0294117647100003e-01, -9.0000000000000002e-01, -8.9705882352900002e-01, \
                                    -8.9411764705899999e-01, -8.9117647058799998e-01, -8.8823529411799995e-01, \
                                    -8.8529411764699995e-01, -8.8235294117600005e-01, -8.7941176470600002e-01, \
                                    -8.7647058823500001e-01, -8.7352941176499999e-01, -8.7058823529399998e-01, \
                                    -8.6764705882399995e-01, -8.6470588235300005e-01, -8.6176470588200005e-01, \
                                    -8.5882352941200002e-01, -8.5588235294100001e-01, -8.5294117647099998e-01, \
                                    -8.4999999999999998e-01, -8.4705882352899997e-01, -8.4411764705900005e-01, \
                                    -8.4117647058800005e-01, -8.3823529411800002e-01, -8.3529411764700001e-01, \
                                    -8.3235294117600001e-01, -8.2941176470599998e-01, -8.2647058823499997e-01, \
                                    -8.2352941176500005e-01, -8.2058823529400005e-01, -8.1764705882400002e-01, \
                                    -8.1470588235300001e-01, -8.1176470588200000e-01, -8.0882352941199998e-01, \
                                    -8.0588235294099997e-01, -8.0294117647100005e-01, -8.0000000000000004e-01, \
                                    -7.9705882352900004e-01, -7.9411764705900001e-01, -7.9117647058800000e-01, \
                                    -7.8823529411799997e-01, -7.8529411764699997e-01, -7.8235294117599996e-01, \
                                    -7.7941176470600004e-01, -7.7647058823500004e-01, -7.7352941176500001e-01, \
                                    -7.7058823529400000e-01, -7.6764705882399997e-01, -7.6470588235299997e-01, \
                                    -7.6176470588199996e-01, -7.5882352941200004e-01, -7.5588235294100004e-01, \
                                    -7.5294117647100001e-01, -7.5000000000000000e-01, -7.4705882352899999e-01, \
                                    -7.4411764705899996e-01, -7.4117647058799996e-01, -7.3823529411800004e-01, \
                                    -7.3529411764700003e-01, -7.3235294117600003e-01, -7.2941176470600000e-01, \
                                    -7.2647058823499999e-01, -7.2352941176499996e-01, -7.2058823529399996e-01, \
                                    -7.1764705882400004e-01, -7.1470588235300003e-01, -7.1176470588200003e-01, \
                                    -7.0882352941200000e-01, -7.0588235294099999e-01, -7.0294117647099996e-01, \
                                    -6.9999999999999996e-01, -6.9705882352899995e-01, -6.9411764705900003e-01, \
                                    -6.9117647058800002e-01, -6.8823529411800000e-01, -6.8529411764699999e-01, \
                                    -6.8235294117599998e-01, -6.7941176470599995e-01, -6.7647058823499995e-01, \
                                    -6.7352941176500003e-01, -6.7058823529400002e-01, -6.6764705882399999e-01, \
                                    -6.6470588235299999e-01, -6.6176470588199998e-01, -6.5882352941199995e-01, \
                                    -6.5588235294099995e-01, -6.5294117647100003e-01, -6.5000000000000002e-01, \
                                    -6.4705882352900002e-01, -6.4411764705899999e-01, -6.4117647058799998e-01, \
                                    -6.3823529411799995e-01, -6.3529411764699995e-01, -6.3235294117600005e-01, \
                                    -6.2941176470600002e-01, -6.2647058823500001e-01, -6.2352941176499999e-01, \
                                    -6.2058823529399998e-01, -6.1764705882399995e-01, -6.1470588235300005e-01, \
                                    -6.1176470588200005e-01, -6.0882352941200002e-01, -6.0588235294100001e-01, \
                                    -6.0294117647099998e-01, -5.9999999999999998e-01, -5.9705882352899997e-01, \
                                    -5.9411764705900005e-01, -5.9117647058800005e-01, -5.8823529411800002e-01, \
                                    -5.8529411764700001e-01, -5.8235294117600001e-01, -5.7941176470599998e-01, \
                                    -5.7647058823499997e-01, -5.7352941176500005e-01, -5.7058823529400005e-01, \
                                    -5.6764705882400002e-01, -5.6470588235300001e-01, -5.6176470588200000e-01, \
                                    -5.5882352941199998e-01, -5.5588235294099997e-01, -5.5294117647100005e-01, \
                                    -5.5000000000000004e-01, -5.4705882352900004e-01, -5.4411764705900001e-01, \
                                    -5.4117647058800000e-01, -5.3823529411799997e-01, -5.3529411764699997e-01, \
                                    -5.3235294117599996e-01, -5.2941176470600004e-01, -5.2647058823500004e-01, \
                                    -5.2352941176500001e-01, -5.2058823529400000e-01, -5.1764705882399997e-01, \
                                    -5.1470588235299997e-01, -5.1176470588199996e-01, -5.0882352941200004e-01, \
                                    -5.0588235294100004e-01, -5.0294117647100001e-01, -5.0000000000000000e-01, \
                                    -4.9705882352899999e-01, -4.9411764705900002e-01, -4.9117647058800001e-01, \
                                    -4.8823529411799999e-01, -4.8529411764699998e-01, -4.8235294117600003e-01, \
                                    -4.7941176470600000e-01, -4.7647058823499999e-01, -4.7352941176500002e-01, \
                                    -4.7058823529400001e-01, -4.6764705882399998e-01, -4.6470588235299998e-01, \
                                    -4.6176470588200003e-01, -4.5882352941200000e-01, -4.5588235294099999e-01, \
                                    -4.5294117647100002e-01, -4.5000000000000001e-01, -4.4705882352900000e-01, \
                                    -4.4411764705899998e-01, -4.4117647058800002e-01, -4.3823529411800000e-01, \
                                    -4.3529411764699999e-01, -4.3235294117599998e-01, -4.2941176470600001e-01, \
                                    -4.2647058823500000e-01, -4.2352941176499997e-01, -4.2058823529400002e-01, \
                                    -4.1764705882399999e-01, -4.1470588235299999e-01, -4.1176470588199998e-01, \
                                    -4.0882352941200001e-01, -4.0588235294100000e-01, -4.0294117647099997e-01, \
                                    -4.0000000000000002e-01, -3.9705882352900002e-01, -3.9411764705899999e-01, \
                                    -3.9117647058799998e-01, -3.8823529411800001e-01, -3.8529411764700000e-01, \
                                    -3.8235294117599999e-01, -3.7941176470600002e-01, -3.7647058823500001e-01, \
                                    -3.7352941176499999e-01, -3.7058823529399998e-01, -3.6764705882400001e-01, \
                                    -3.6470588235300000e-01, -3.6176470588199999e-01, -3.5882352941200002e-01, \
                                    -3.5588235294100001e-01, -3.5294117647099998e-01, -3.4999999999999998e-01, \
                                    -3.4705882352900003e-01, -3.4411764705900000e-01, -3.4117647058799999e-01, \
                                    -3.3823529411800002e-01, -3.3529411764700001e-01, -3.3235294117600001e-01, \
                                    -3.2941176470599998e-01, -3.2647058823500003e-01, -3.2352941176500000e-01, \
                                    -3.2058823529399999e-01, -3.1764705882400002e-01, -3.1470588235300001e-01, \
                                    -3.1176470588200000e-01, -3.0882352941199998e-01, -3.0588235294100002e-01, \
                                    -3.0294117647100000e-01, -2.9999999999999999e-01, -2.9705882352899998e-01, \
                                    -2.9411764705900001e-01, -2.9117647058800000e-01, -2.8823529411799997e-01, \
                                    -2.8529411764700002e-01, -2.8235294117600002e-01, -2.7941176470599999e-01, \
                                    -2.7647058823499998e-01, -2.7352941176500001e-01, -2.7058823529400000e-01, \
                                    -2.6764705882399997e-01, -2.6470588235300002e-01, -2.6176470588200001e-01, \
                                    -2.5882352941199999e-01, -2.5588235294099998e-01, -2.5294117647100001e-01, \
                                    -2.5000000000000000e-01, -2.4705882352899999e-01, -2.4411764705899999e-01, \
                                    -2.4117647058800001e-01, -2.3823529411800001e-01, -2.3529411764700001e-01, \
                                    -2.3235294117600000e-01, -2.2941176470600000e-01, -2.2647058823499999e-01, \
                                    -2.2352941176499999e-01, -2.2058823529400001e-01, -2.1764705882400001e-01, \
                                    -2.1470588235300000e-01, -2.1176470588200000e-01, -2.0882352941200000e-01, \
                                    -2.0588235294099999e-01, -2.0294117647099999e-01, -2.0000000000000001e-01, \
                                    -1.9705882352900000e-01, -1.9411764705900000e-01, -1.9117647058800000e-01, \
                                    -1.8823529411800000e-01, -1.8529411764699999e-01, -1.8235294117600001e-01, \
                                    -1.7941176470600001e-01, -1.7647058823500000e-01, -1.7352941176500000e-01, \
                                    -1.7058823529400000e-01, -1.6764705882399999e-01, -1.6470588235299999e-01, \
                                    -1.6176470588200001e-01, -1.5882352941200001e-01, -1.5588235294100000e-01, \
                                    -1.5294117647100000e-01, -1.4999999999999999e-01, -1.4705882352899999e-01, \
                                    -1.4411764705899999e-01, -1.4117647058800001e-01, -1.3823529411800001e-01, \
                                    -1.3529411764700000e-01, -1.3235294117599999e-01, -1.2941176470599999e-01, \
                                    -1.2647058823499999e-01, -1.2352941176500000e-01, -1.2058823529400001e-01, \
                                    -1.1764705882400001e-01, -1.1470588235300000e-01, -1.1176470588200001e-01, \
                                    -1.0882352941200001e-01, -1.0588235294100000e-01, -1.0294117647100000e-01, \
                                    -1.0000000000000001e-01, -9.7058823528999999e-02, -9.4117647058999998e-02, \
                                    -9.1176470588000005e-02, -8.8235294118000004e-02, -8.5294117646999998e-02, \
                                    -8.2352941176000005e-02, -7.9411764706000004e-02, -7.6470588234999998e-02, \
                                    -7.3529411764999997e-02, -7.0588235294000004e-02, -6.7647058824000003e-02, \
                                    -6.4705882352999997e-02, -6.1764705881999997e-02, -5.8823529412000003e-02, \
                                    -5.5882352941000003e-02, -5.2941176471000002e-02, -5.0000000000000003e-02, \
                                    -4.7058823529000003e-02, -4.4117647059000002e-02, -4.1176470588000003e-02, \
                                    -3.8235294118000002e-02, -3.5294117647000002e-02, -3.2352941176000002e-02, \
                                    -2.9411764706000001e-02, -2.6470588234999998e-02, -2.3529411765000001e-02, \
                                    -2.0588235294000001e-02, -1.7647058824000000e-02, -1.4705882353000001e-02, \
                                    -1.1764705881999999e-02, -8.8235294120000002e-03, -5.8823529409999997e-03, \
                                    -2.9411764710000001e-03,  0.0000000000000000e+00,  2.9411764710000001e-03, \
                                    5.8823529409999997e-03,  8.8235294120000002e-03,  1.1764705881999999e-02, \
                                    1.4705882353000001e-02,  1.7647058824000000e-02,  2.0588235294000001e-02, \
                                    2.3529411765000001e-02,  2.6470588234999998e-02,  2.9411764706000001e-02, \
                                    3.2352941176000002e-02,  3.5294117647000002e-02,  3.8235294118000002e-02, \
                                    4.1176470588000003e-02,  4.4117647059000002e-02,  4.7058823529000003e-02, \
                                    5.0000000000000003e-02,  5.2941176471000002e-02,  5.5882352941000003e-02, \
                                    5.8823529412000003e-02,  6.1764705881999997e-02,  6.4705882352999997e-02, \
                                    6.7647058824000003e-02,  7.0588235294000004e-02,  7.3529411764999997e-02, \
                                    7.6470588234999998e-02,  7.9411764706000004e-02,  8.2352941176000005e-02, \
                                    8.5294117646999998e-02,  8.8235294118000004e-02,  9.1176470588000005e-02, \
                                    9.4117647058999998e-02,  9.7058823528999999e-02,  1.0000000000000001e-01, \
                                    1.0294117647100000e-01,  1.0588235294100000e-01,  1.0882352941200001e-01, \
                                    1.1176470588200001e-01,  1.1470588235300000e-01,  1.1764705882400001e-01, \
                                    1.2058823529400001e-01,  1.2352941176500000e-01,  1.2647058823499999e-01, \
                                    1.2941176470599999e-01,  1.3235294117599999e-01,  1.3529411764700000e-01, \
                                    1.3823529411800001e-01,  1.4117647058800001e-01,  1.4411764705899999e-01, \
                                    1.4705882352899999e-01,  1.4999999999999999e-01,  1.5294117647100000e-01, \
                                    1.5588235294100000e-01,  1.5882352941200001e-01,  1.6176470588200001e-01, \
                                    1.6470588235299999e-01,  1.6764705882399999e-01,  1.7058823529400000e-01, \
                                    1.7352941176500000e-01,  1.7647058823500000e-01,  1.7941176470600001e-01, \
                                    1.8235294117600001e-01,  1.8529411764699999e-01,  1.8823529411800000e-01, \
                                    1.9117647058800000e-01,  1.9411764705900000e-01,  1.9705882352900000e-01, \
                                    2.0000000000000001e-01,  2.0294117647099999e-01,  2.0588235294099999e-01, \
                                    2.0882352941200000e-01,  2.1176470588200000e-01,  2.1470588235300000e-01, \
                                    2.1764705882400001e-01,  2.2058823529400001e-01,  2.2352941176499999e-01, \
                                    2.2647058823499999e-01,  2.2941176470600000e-01,  2.3235294117600000e-01, \
                                    2.3529411764700001e-01,  2.3823529411800001e-01,  2.4117647058800001e-01, \
                                    2.4411764705899999e-01,  2.4705882352899999e-01,  2.5000000000000000e-01, \
                                    2.5294117647100001e-01,  2.5588235294099998e-01,  2.5882352941199999e-01, \
                                    2.6176470588200001e-01,  2.6470588235300002e-01,  2.6764705882399997e-01, \
                                    2.7058823529400000e-01,  2.7352941176500001e-01,  2.7647058823499998e-01, \
                                    2.7941176470599999e-01,  2.8235294117600002e-01,  2.8529411764700002e-01, \
                                    2.8823529411799997e-01,  2.9117647058800000e-01,  2.9411764705900001e-01, \
                                    2.9705882352899998e-01,  2.9999999999999999e-01,  3.0294117647100000e-01, \
                                    3.0588235294100002e-01,  3.0882352941199998e-01,  3.1176470588200000e-01, \
                                    3.1470588235300001e-01,  3.1764705882400002e-01,  3.2058823529399999e-01, \
                                    3.2352941176500000e-01,  3.2647058823500003e-01,  3.2941176470599998e-01, \
                                    3.3235294117600001e-01,  3.3529411764700001e-01,  3.3823529411800002e-01, \
                                    3.4117647058799999e-01,  3.4411764705900000e-01,  3.4705882352900003e-01, \
                                    3.4999999999999998e-01,  3.5294117647099998e-01,  3.5588235294100001e-01, \
                                    3.5882352941200002e-01,  3.6176470588199999e-01,  3.6470588235300000e-01, \
                                    3.6764705882400001e-01,  3.7058823529399998e-01,  3.7352941176499999e-01, \
                                    3.7647058823500001e-01,  3.7941176470600002e-01,  3.8235294117599999e-01, \
                                    3.8529411764700000e-01,  3.8823529411800001e-01,  3.9117647058799998e-01, \
                                    3.9411764705899999e-01,  3.9705882352900002e-01,  4.0000000000000002e-01, \
                                    4.0294117647099997e-01,  4.0588235294100000e-01,  4.0882352941200001e-01, \
                                    4.1176470588199998e-01,  4.1470588235299999e-01,  4.1764705882399999e-01, \
                                    4.2058823529400002e-01,  4.2352941176499997e-01,  4.2647058823500000e-01, \
                                    4.2941176470600001e-01,  4.3235294117599998e-01,  4.3529411764699999e-01, \
                                    4.3823529411800000e-01,  4.4117647058800002e-01,  4.4411764705899998e-01, \
                                    4.4705882352900000e-01,  4.5000000000000001e-01,  4.5294117647100002e-01, \
                                    4.5588235294099999e-01,  4.5882352941200000e-01,  4.6176470588200003e-01, \
                                    4.6470588235299998e-01,  4.6764705882399998e-01,  4.7058823529400001e-01, \
                                    4.7352941176500002e-01,  4.7647058823499999e-01,  4.7941176470600000e-01, \
                                    4.8235294117600003e-01,  4.8529411764699998e-01,  4.8823529411799999e-01, \
                                    4.9117647058800001e-01,  4.9411764705900002e-01,  4.9705882352899999e-01, \
                                    5.0000000000000000e-01,  5.0294117647100001e-01,  5.0588235294100004e-01, \
                                    5.0882352941200004e-01,  5.1176470588199996e-01,  5.1470588235299997e-01, \
                                    5.1764705882399997e-01,  5.2058823529400000e-01,  5.2352941176500001e-01, \
                                    5.2647058823500004e-01,  5.2941176470600004e-01,  5.3235294117599996e-01, \
                                    5.3529411764699997e-01,  5.3823529411799997e-01,  5.4117647058800000e-01, \
                                    5.4411764705900001e-01,  5.4705882352900004e-01,  5.5000000000000004e-01, \
                                    5.5294117647100005e-01,  5.5588235294099997e-01,  5.5882352941199998e-01, \
                                    5.6176470588200000e-01,  5.6470588235300001e-01,  5.6764705882400002e-01, \
                                    5.7058823529400005e-01,  5.7352941176500005e-01,  5.7647058823499997e-01, \
                                    5.7941176470599998e-01,  5.8235294117600001e-01,  5.8529411764700001e-01, \
                                    5.8823529411800002e-01,  5.9117647058800005e-01,  5.9411764705900005e-01, \
                                    5.9705882352899997e-01,  5.9999999999999998e-01,  6.0294117647099998e-01, \
                                    6.0588235294100001e-01,  6.0882352941200002e-01,  6.1176470588200005e-01, \
                                    6.1470588235300005e-01,  6.1764705882399995e-01,  6.2058823529399998e-01, \
                                    6.2352941176499999e-01,  6.2647058823500001e-01,  6.2941176470600002e-01, \
                                    6.3235294117600005e-01,  6.3529411764699995e-01,  6.3823529411799995e-01, \
                                    6.4117647058799998e-01,  6.4411764705899999e-01,  6.4705882352900002e-01, \
                                    6.5000000000000002e-01,  6.5294117647100003e-01,  6.5588235294099995e-01, \
                                    6.5882352941199995e-01,  6.6176470588199998e-01,  6.6470588235299999e-01, \
                                    6.6764705882399999e-01,  6.7058823529400002e-01,  6.7352941176500003e-01, \
                                    6.7647058823499995e-01,  6.7941176470599995e-01,  6.8235294117599998e-01, \
                                    6.8529411764699999e-01,  6.8823529411800000e-01,  6.9117647058800002e-01, \
                                    6.9411764705900003e-01,  6.9705882352899995e-01,  6.9999999999999996e-01, \
                                    7.0294117647099996e-01,  7.0588235294099999e-01,  7.0882352941200000e-01, \
                                    7.1176470588200003e-01,  7.1470588235300003e-01,  7.1764705882400004e-01, \
                                    7.2058823529399996e-01,  7.2352941176499996e-01,  7.2647058823499999e-01, \
                                    7.2941176470600000e-01,  7.3235294117600003e-01,  7.3529411764700003e-01, \
                                    7.3823529411800004e-01,  7.4117647058799996e-01,  7.4411764705899996e-01, \
                                    7.4705882352899999e-01,  7.5000000000000000e-01,  7.5294117647100001e-01, \
                                    7.5588235294100004e-01,  7.5882352941200004e-01,  7.6176470588199996e-01, \
                                    7.6470588235299997e-01,  7.6764705882399997e-01,  7.7058823529400000e-01, \
                                    7.7352941176500001e-01,  7.7647058823500004e-01,  7.7941176470600004e-01, \
                                    7.8235294117599996e-01,  7.8529411764699997e-01,  7.8823529411799997e-01, \
                                    7.9117647058800000e-01,  7.9411764705900001e-01,  7.9705882352900004e-01, \
                                    8.0000000000000004e-01,  8.0294117647100005e-01,  8.0588235294099997e-01, \
                                    8.0882352941199998e-01,  8.1176470588200000e-01,  8.1470588235300001e-01, \
                                    8.1764705882400002e-01,  8.2058823529400005e-01,  8.2352941176500005e-01, \
                                    8.2647058823499997e-01,  8.2941176470599998e-01,  8.3235294117600001e-01, \
                                    8.3529411764700001e-01,  8.3823529411800002e-01,  8.4117647058800005e-01, \
                                    8.4411764705900005e-01,  8.4705882352899997e-01,  8.4999999999999998e-01, \
                                    8.5294117647099998e-01,  8.5588235294100001e-01,  8.5882352941200002e-01, \
                                    8.6176470588200005e-01,  8.6470588235300005e-01,  8.6764705882399995e-01, \
                                    8.7058823529399998e-01,  8.7352941176499999e-01,  8.7647058823500001e-01, \
                                    8.7941176470600002e-01,  8.8235294117600005e-01,  8.8529411764699995e-01, \
                                    8.8823529411799995e-01,  8.9117647058799998e-01,  8.9411764705899999e-01, \
                                    8.9705882352900002e-01,  9.0000000000000002e-01,  9.0294117647100003e-01, \
                                    9.0588235294099995e-01,  9.0882352941199995e-01,  9.1176470588199998e-01, \
                                    9.1470588235299999e-01,  9.1764705882399999e-01,  9.2058823529400002e-01, \
                                    9.2352941176500003e-01,  9.2647058823499995e-01,  9.2941176470599995e-01, \
                                    9.3235294117599998e-01,  9.3529411764699999e-01,  9.3823529411800000e-01, \
                                    9.4117647058800002e-01,  9.4411764705900003e-01,  9.4705882352899995e-01, \
                                    9.4999999999999996e-01,  9.5294117647099996e-01,  9.5588235294099999e-01, \
                                    9.5882352941200000e-01,  9.6176470588200003e-01,  9.6470588235300003e-01, \
                                    9.6764705882400004e-01,  9.7058823529399996e-01,  9.7352941176499996e-01, \
                                    9.7647058823499999e-01,  9.7941176470600000e-01,  9.8235294117600003e-01, \
                                    9.8529411764700003e-01,  9.8823529411800004e-01,  9.9117647058799996e-01, \
                                    9.9411764705899996e-01,  9.9705882352899999e-01,  1.0000000000000000e+00, \
                                    -1.0000000000000000e+00, -9.9754901960800002e-01, -9.9509803921600004e-01, \
                                    -9.9264705882399995e-01, -9.9019607843099999e-01, -9.8774509803900001e-01, \
                                    -9.8529411764700003e-01, -9.8284313725500005e-01, -9.8039215686299996e-01, \
                                    -9.7794117647099998e-01, -9.7549019607800003e-01, -9.7303921568600005e-01, \
                                    -9.7058823529399996e-01, -9.6813725490199998e-01, -9.6568627451000000e-01, \
                                    -9.6323529411800002e-01, -9.6078431372499995e-01, -9.5833333333299997e-01, \
                                    -9.5588235294099999e-01, -9.5343137254900001e-01, -9.5098039215700003e-01, \
                                    -9.4852941176500005e-01, -9.4607843137299996e-01, -9.4362745098000000e-01, \
                                    -9.4117647058800002e-01, -9.3872549019600005e-01, -9.3627450980399995e-01, \
                                    -9.3382352941199998e-01, -9.3137254902000000e-01, -9.2892156862700004e-01, \
                                    -9.2647058823499995e-01, -9.2401960784299997e-01, -9.2156862745099999e-01, \
                                    -9.1911764705900001e-01, -9.1666666666700003e-01, -9.1421568627500005e-01, \
                                    -9.1176470588199998e-01, -9.0931372549000000e-01, -9.0686274509800002e-01, \
                                    -9.0441176470600004e-01, -9.0196078431399995e-01, -8.9950980392199997e-01, \
                                    -8.9705882352900002e-01, -8.9460784313700004e-01, -8.9215686274499995e-01, \
                                    -8.8970588235299997e-01, -8.8725490196099999e-01, -8.8480392156900001e-01, \
                                    -8.8235294117600005e-01, -8.7990196078399996e-01, -8.7745098039199998e-01, \
                                    -8.7500000000000000e-01, -8.7254901960800002e-01, -8.7009803921600004e-01, \
                                    -8.6764705882399995e-01, -8.6519607843099999e-01, -8.6274509803900001e-01, \
                                    -8.6029411764700003e-01, -8.5784313725500005e-01, -8.5539215686299996e-01, \
                                    -8.5294117647099998e-01, -8.5049019607800003e-01, -8.4803921568600005e-01, \
                                    -8.4558823529399996e-01, -8.4313725490199998e-01, -8.4068627451000000e-01, \
                                    -8.3823529411800002e-01, -8.3578431372499995e-01, -8.3333333333299997e-01, \
                                    -8.3088235294099999e-01, -8.2843137254900001e-01, -8.2598039215700003e-01, \
                                    -8.2352941176500005e-01, -8.2107843137299996e-01, -8.1862745098000000e-01, \
                                    -8.1617647058800002e-01, -8.1372549019600005e-01, -8.1127450980399995e-01, \
                                    -8.0882352941199998e-01, -8.0637254902000000e-01, -8.0392156862700004e-01, \
                                    -8.0147058823499995e-01, -7.9901960784299997e-01, -7.9656862745099999e-01, \
                                    -7.9411764705900001e-01, -7.9166666666700003e-01, -7.8921568627500005e-01, \
                                    -7.8676470588199998e-01, -7.8431372549000000e-01, -7.8186274509800002e-01, \
                                    -7.7941176470600004e-01, -7.7696078431399995e-01, -7.7450980392199997e-01, \
                                    -7.7205882352900002e-01, -7.6960784313700004e-01, -7.6715686274499995e-01, \
                                    -7.6470588235299997e-01, -7.6225490196099999e-01, -7.5980392156900001e-01, \
                                    -7.5735294117600005e-01, -7.5490196078399996e-01, -7.5245098039199998e-01, \
                                    -7.5000000000000000e-01, -7.4754901960800002e-01, -7.4509803921600004e-01, \
                                    -7.4264705882399995e-01, -7.4019607843099999e-01, -7.3774509803900001e-01, \
                                    -7.3529411764700003e-01, -7.3284313725500005e-01, -7.3039215686299996e-01, \
                                    -7.2794117647099998e-01, -7.2549019607800003e-01, -7.2303921568600005e-01, \
                                    -7.2058823529399996e-01, -7.1813725490199998e-01, -7.1568627451000000e-01, \
                                    -7.1323529411800002e-01, -7.1078431372499995e-01, -7.0833333333299997e-01, \
                                    -7.0588235294099999e-01, -7.0343137254900001e-01, -7.0098039215700003e-01, \
                                    -6.9852941176500005e-01, -6.9607843137299996e-01, -6.9362745098000000e-01, \
                                    -6.9117647058800002e-01, -6.8872549019600005e-01, -6.8627450980399995e-01, \
                                    -6.8382352941199998e-01, -6.8137254902000000e-01, -6.7892156862700004e-01, \
                                    -6.7647058823499995e-01, -6.7401960784299997e-01, -6.7156862745099999e-01, \
                                    -6.6911764705900001e-01, -6.6666666666700003e-01, -6.6421568627500005e-01, \
                                    -6.6176470588199998e-01, -6.5931372549000000e-01, -6.5686274509800002e-01, \
                                    -6.5441176470600004e-01, -6.5196078431399995e-01, -6.4950980392199997e-01, \
                                    -6.4705882352900002e-01, -6.4460784313700004e-01, -6.4215686274499995e-01, \
                                    -6.3970588235299997e-01, -6.3725490196099999e-01, -6.3480392156900001e-01, \
                                    -6.3235294117600005e-01, -6.2990196078399996e-01, -6.2745098039199998e-01, \
                                    -6.2500000000000000e-01, -6.2254901960800002e-01, -6.2009803921600004e-01, \
                                    -6.1764705882399995e-01, -6.1519607843099999e-01, -6.1274509803900001e-01, \
                                    -6.1029411764700003e-01, -6.0784313725500005e-01, -6.0539215686299996e-01, \
                                    -6.0294117647099998e-01, -6.0049019607800003e-01, -5.9803921568600005e-01, \
                                    -5.9558823529399996e-01, -5.9313725490199998e-01, -5.9068627451000000e-01, \
                                    -5.8823529411800002e-01, -5.8578431372499995e-01, -5.8333333333299997e-01, \
                                    -5.8088235294099999e-01, -5.7843137254900001e-01, -5.7598039215700003e-01, \
                                    -5.7352941176500005e-01, -5.7107843137299996e-01, -5.6862745098000000e-01, \
                                    -5.6617647058800002e-01, -5.6372549019600005e-01, -5.6127450980399995e-01, \
                                    -5.5882352941199998e-01, -5.5637254902000000e-01, -5.5392156862700004e-01, \
                                    -5.5147058823499995e-01, -5.4901960784299997e-01, -5.4656862745099999e-01, \
                                    -5.4411764705900001e-01, -5.4166666666700003e-01, -5.3921568627500005e-01, \
                                    -5.3676470588199998e-01, -5.3431372549000000e-01, -5.3186274509800002e-01, \
                                    -5.2941176470600004e-01, -5.2696078431399995e-01, -5.2450980392199997e-01, \
                                    -5.2205882352900002e-01, -5.1960784313700004e-01, -5.1715686274499995e-01, \
                                    -5.1470588235299997e-01, -5.1225490196099999e-01, -5.0980392156900001e-01, \
                                    -5.0735294117600005e-01, -5.0490196078399996e-01, -5.0245098039199998e-01, \
                                    -5.0000000000000000e-01, -4.9754901960800002e-01, -4.9509803921599999e-01, \
                                    -4.9264705882400001e-01, -4.9019607843099999e-01, -4.8774509803900001e-01, \
                                    -4.8529411764699998e-01, -4.8284313725500000e-01, -4.8039215686300002e-01, \
                                    -4.7794117647099998e-01, -4.7549019607800003e-01, -4.7303921568599999e-01, \
                                    -4.7058823529400001e-01, -4.6813725490199998e-01, -4.6568627451000000e-01, \
                                    -4.6323529411800002e-01, -4.6078431372500001e-01, -4.5833333333300003e-01, \
                                    -4.5588235294099999e-01, -4.5343137254900001e-01, -4.5098039215699998e-01, \
                                    -4.4852941176500000e-01, -4.4607843137300002e-01, -4.4362745098000000e-01, \
                                    -4.4117647058800002e-01, -4.3872549019599999e-01, -4.3627450980400001e-01, \
                                    -4.3382352941199998e-01, -4.3137254902000000e-01, -4.2892156862699998e-01, \
                                    -4.2647058823500000e-01, -4.2401960784300002e-01, -4.2156862745099999e-01, \
                                    -4.1911764705900001e-01, -4.1666666666699997e-01, -4.1421568627499999e-01, \
                                    -4.1176470588199998e-01, -4.0931372549000000e-01, -4.0686274509800002e-01, \
                                    -4.0441176470599999e-01, -4.0196078431400001e-01, -3.9950980392199997e-01, \
                                    -3.9705882352900002e-01, -3.9460784313699998e-01, -3.9215686274500000e-01, \
                                    -3.8970588235300002e-01, -3.8725490196099999e-01, -3.8480392156900001e-01, \
                                    -3.8235294117599999e-01, -3.7990196078400001e-01, -3.7745098039199998e-01, \
                                    -3.7500000000000000e-01, -3.7254901960800002e-01, -3.7009803921599999e-01, \
                                    -3.6764705882400001e-01, -3.6519607843099999e-01, -3.6274509803900001e-01, \
                                    -3.6029411764699998e-01, -3.5784313725500000e-01, -3.5539215686300002e-01, \
                                    -3.5294117647099998e-01, -3.5049019607800003e-01, -3.4803921568599999e-01, \
                                    -3.4558823529400001e-01, -3.4313725490199998e-01, -3.4068627451000000e-01, \
                                    -3.3823529411800002e-01, -3.3578431372500001e-01, -3.3333333333300003e-01, \
                                    -3.3088235294099999e-01, -3.2843137254900001e-01, -3.2598039215699998e-01, \
                                    -3.2352941176500000e-01, -3.2107843137300002e-01, -3.1862745098000000e-01, \
                                    -3.1617647058800002e-01, -3.1372549019599999e-01, -3.1127450980400001e-01, \
                                    -3.0882352941199998e-01, -3.0637254902000000e-01, -3.0392156862699998e-01, \
                                    -3.0147058823500000e-01, -2.9901960784300002e-01, -2.9656862745099999e-01, \
                                    -2.9411764705900001e-01, -2.9166666666699997e-01, -2.8921568627499999e-01, \
                                    -2.8676470588199998e-01, -2.8431372549000000e-01, -2.8186274509800002e-01, \
                                    -2.7941176470599999e-01, -2.7696078431400001e-01, -2.7450980392199997e-01, \
                                    -2.7205882352900002e-01, -2.6960784313699998e-01, -2.6715686274500000e-01, \
                                    -2.6470588235300002e-01, -2.6225490196099999e-01, -2.5980392156900001e-01, \
                                    -2.5735294117599999e-01, -2.5490196078400001e-01, -2.5245098039199998e-01, \
                                    -2.5000000000000000e-01, -2.4754901960799999e-01, -2.4509803921600001e-01, \
                                    -2.4264705882400001e-01, -2.4019607843099999e-01, -2.3774509803900001e-01, \
                                    -2.3529411764700001e-01, -2.3284313725500000e-01, -2.3039215686299999e-01, \
                                    -2.2794117647100001e-01, -2.2549019607800000e-01, -2.2303921568599999e-01, \
                                    -2.2058823529400001e-01, -2.1813725490200001e-01, -2.1568627451000000e-01, \
                                    -2.1323529411799999e-01, -2.1078431372500001e-01, -2.0833333333300000e-01, \
                                    -2.0588235294099999e-01, -2.0343137254900001e-01, -2.0098039215700000e-01, \
                                    -1.9852941176500000e-01, -1.9607843137299999e-01, -1.9362745098000000e-01, \
                                    -1.9117647058800000e-01, -1.8872549019599999e-01, -1.8627450980400001e-01, \
                                    -1.8382352941200000e-01, -1.8137254902000000e-01, -1.7892156862700001e-01, \
                                    -1.7647058823500000e-01, -1.7401960784300000e-01, -1.7156862745099999e-01, \
                                    -1.6911764705900001e-01, -1.6666666666700000e-01, -1.6421568627499999e-01, \
                                    -1.6176470588200001e-01, -1.5931372549000000e-01, -1.5686274509799999e-01, \
                                    -1.5441176470599999e-01, -1.5196078431400001e-01, -1.4950980392200000e-01, \
                                    -1.4705882352899999e-01, -1.4460784313700001e-01, -1.4215686274500000e-01, \
                                    -1.3970588235299999e-01, -1.3725490196099999e-01, -1.3480392156900001e-01, \
                                    -1.3235294117599999e-01, -1.2990196078399999e-01, -1.2745098039200001e-01, \
                                    -1.2500000000000000e-01, -1.2254901960800001e-01, -1.2009803921600000e-01, \
                                    -1.1764705882400001e-01, -1.1519607843100001e-01, -1.1274509803900000e-01, \
                                    -1.1029411764700001e-01, -1.0784313725500000e-01, -1.0539215686300001e-01, \
                                    -1.0294117647100000e-01, -1.0049019607800000e-01, -9.8039215686000006e-02, \
                                    -9.5588235293999999e-02, -9.3137254902000005e-02, -9.0686274509999998e-02, \
                                    -8.8235294118000004e-02, -8.5784313725000005e-02, -8.3333333332999998e-02, \
                                    -8.0882352941000005e-02, -7.8431372548999997e-02, -7.5980392157000004e-02, \
                                    -7.3529411764999997e-02, -7.1078431373000003e-02, -6.8627450980000004e-02, \
                                    -6.6176470587999997e-02, -6.3725490196000004e-02, -6.1274509804000003e-02, \
                                    -5.8823529412000003e-02, -5.6372549020000003e-02, -5.3921568626999997e-02, \
                                    -5.1470588235000003e-02, -4.9019607843000003e-02, -4.6568627451000003e-02, \
                                    -4.4117647059000002e-02, -4.1666666667000002e-02, -3.9215686275000002e-02, \
                                    -3.6764705882000003e-02, -3.4313725490000002e-02, -3.1862745098000002e-02, \
                                    -2.9411764706000001e-02, -2.6960784314000001e-02, -2.4509803922000001e-02, \
                                    -2.2058823528999998e-02, -1.9607843137000001e-02, -1.7156862745000001e-02, \
                                    -1.4705882353000001e-02, -1.2254901961000000e-02, -9.8039215690000001e-03, \
                                    -7.3529411760000002e-03, -4.9019607839999998e-03, -2.4509803919999999e-03, \
                                    0.0000000000000000e+00,  2.4509803919999999e-03,  4.9019607839999998e-03, \
                                    7.3529411760000002e-03,  9.8039215690000001e-03,  1.2254901961000000e-02, \
                                    1.4705882353000001e-02,  1.7156862745000001e-02,  1.9607843137000001e-02, \
                                    2.2058823528999998e-02,  2.4509803922000001e-02,  2.6960784314000001e-02, \
                                    2.9411764706000001e-02,  3.1862745098000002e-02,  3.4313725490000002e-02, \
                                    3.6764705882000003e-02,  3.9215686275000002e-02,  4.1666666667000002e-02, \
                                    4.4117647059000002e-02,  4.6568627451000003e-02,  4.9019607843000003e-02, \
                                    5.1470588235000003e-02,  5.3921568626999997e-02,  5.6372549020000003e-02, \
                                    5.8823529412000003e-02,  6.1274509804000003e-02,  6.3725490196000004e-02, \
                                    6.6176470587999997e-02,  6.8627450980000004e-02,  7.1078431373000003e-02, \
                                    7.3529411764999997e-02,  7.5980392157000004e-02,  7.8431372548999997e-02, \
                                    8.0882352941000005e-02,  8.3333333332999998e-02,  8.5784313725000005e-02, \
                                    8.8235294118000004e-02,  9.0686274509999998e-02,  9.3137254902000005e-02, \
                                    9.5588235293999999e-02,  9.8039215686000006e-02,  1.0049019607800000e-01, \
                                    1.0294117647100000e-01,  1.0539215686300001e-01,  1.0784313725500000e-01, \
                                    1.1029411764700001e-01,  1.1274509803900000e-01,  1.1519607843100001e-01, \
                                    1.1764705882400001e-01,  1.2009803921600000e-01,  1.2254901960800001e-01, \
                                    1.2500000000000000e-01,  1.2745098039200001e-01,  1.2990196078399999e-01, \
                                    1.3235294117599999e-01,  1.3480392156900001e-01,  1.3725490196099999e-01, \
                                    1.3970588235299999e-01,  1.4215686274500000e-01,  1.4460784313700001e-01, \
                                    1.4705882352899999e-01,  1.4950980392200000e-01,  1.5196078431400001e-01, \
                                    1.5441176470599999e-01,  1.5686274509799999e-01,  1.5931372549000000e-01, \
                                    1.6176470588200001e-01,  1.6421568627499999e-01,  1.6666666666700000e-01, \
                                    1.6911764705900001e-01,  1.7156862745099999e-01,  1.7401960784300000e-01, \
                                    1.7647058823500000e-01,  1.7892156862700001e-01,  1.8137254902000000e-01, \
                                    1.8382352941200000e-01,  1.8627450980400001e-01,  1.8872549019599999e-01, \
                                    1.9117647058800000e-01,  1.9362745098000000e-01,  1.9607843137299999e-01, \
                                    1.9852941176500000e-01,  2.0098039215700000e-01,  2.0343137254900001e-01, \
                                    2.0588235294099999e-01,  2.0833333333300000e-01,  2.1078431372500001e-01, \
                                    2.1323529411799999e-01,  2.1568627451000000e-01,  2.1813725490200001e-01, \
                                    2.2058823529400001e-01,  2.2303921568599999e-01,  2.2549019607800000e-01, \
                                    2.2794117647100001e-01,  2.3039215686299999e-01,  2.3284313725500000e-01, \
                                    2.3529411764700001e-01,  2.3774509803900001e-01,  2.4019607843099999e-01, \
                                    2.4264705882400001e-01,  2.4509803921600001e-01,  2.4754901960799999e-01, \
                                    2.5000000000000000e-01,  2.5245098039199998e-01,  2.5490196078400001e-01, \
                                    2.5735294117599999e-01,  2.5980392156900001e-01,  2.6225490196099999e-01, \
                                    2.6470588235300002e-01,  2.6715686274500000e-01,  2.6960784313699998e-01, \
                                    2.7205882352900002e-01,  2.7450980392199997e-01,  2.7696078431400001e-01, \
                                    2.7941176470599999e-01,  2.8186274509800002e-01,  2.8431372549000000e-01, \
                                    2.8676470588199998e-01,  2.8921568627499999e-01,  2.9166666666699997e-01, \
                                    2.9411764705900001e-01,  2.9656862745099999e-01,  2.9901960784300002e-01, \
                                    3.0147058823500000e-01,  3.0392156862699998e-01,  3.0637254902000000e-01, \
                                    3.0882352941199998e-01,  3.1127450980400001e-01,  3.1372549019599999e-01, \
                                    3.1617647058800002e-01,  3.1862745098000000e-01,  3.2107843137300002e-01, \
                                    3.2352941176500000e-01,  3.2598039215699998e-01,  3.2843137254900001e-01, \
                                    3.3088235294099999e-01,  3.3333333333300003e-01,  3.3578431372500001e-01, \
                                    3.3823529411800002e-01,  3.4068627451000000e-01,  3.4313725490199998e-01, \
                                    3.4558823529400001e-01,  3.4803921568599999e-01,  3.5049019607800003e-01, \
                                    3.5294117647099998e-01,  3.5539215686300002e-01,  3.5784313725500000e-01, \
                                    3.6029411764699998e-01,  3.6274509803900001e-01,  3.6519607843099999e-01, \
                                    3.6764705882400001e-01,  3.7009803921599999e-01,  3.7254901960800002e-01, \
                                    3.7500000000000000e-01,  3.7745098039199998e-01,  3.7990196078400001e-01, \
                                    3.8235294117599999e-01,  3.8480392156900001e-01,  3.8725490196099999e-01, \
                                    3.8970588235300002e-01,  3.9215686274500000e-01,  3.9460784313699998e-01, \
                                    3.9705882352900002e-01,  3.9950980392199997e-01,  4.0196078431400001e-01, \
                                    4.0441176470599999e-01,  4.0686274509800002e-01,  4.0931372549000000e-01, \
                                    4.1176470588199998e-01,  4.1421568627499999e-01,  4.1666666666699997e-01, \
                                    4.1911764705900001e-01,  4.2156862745099999e-01,  4.2401960784300002e-01, \
                                    4.2647058823500000e-01,  4.2892156862699998e-01,  4.3137254902000000e-01, \
                                    4.3382352941199998e-01,  4.3627450980400001e-01,  4.3872549019599999e-01, \
                                    4.4117647058800002e-01,  4.4362745098000000e-01,  4.4607843137300002e-01, \
                                    4.4852941176500000e-01,  4.5098039215699998e-01,  4.5343137254900001e-01, \
                                    4.5588235294099999e-01,  4.5833333333300003e-01,  4.6078431372500001e-01, \
                                    4.6323529411800002e-01,  4.6568627451000000e-01,  4.6813725490199998e-01, \
                                    4.7058823529400001e-01,  4.7303921568599999e-01,  4.7549019607800003e-01, \
                                    4.7794117647099998e-01,  4.8039215686300002e-01,  4.8284313725500000e-01, \
                                    4.8529411764699998e-01,  4.8774509803900001e-01,  4.9019607843099999e-01, \
                                    4.9264705882400001e-01,  4.9509803921599999e-01,  4.9754901960800002e-01, \
                                    5.0000000000000000e-01,  5.0245098039199998e-01,  5.0490196078399996e-01, \
                                    5.0735294117600005e-01,  5.0980392156900001e-01,  5.1225490196099999e-01, \
                                    5.1470588235299997e-01,  5.1715686274499995e-01,  5.1960784313700004e-01, \
                                    5.2205882352900002e-01,  5.2450980392199997e-01,  5.2696078431399995e-01, \
                                    5.2941176470600004e-01,  5.3186274509800002e-01,  5.3431372549000000e-01, \
                                    5.3676470588199998e-01,  5.3921568627500005e-01,  5.4166666666700003e-01, \
                                    5.4411764705900001e-01,  5.4656862745099999e-01,  5.4901960784299997e-01, \
                                    5.5147058823499995e-01,  5.5392156862700004e-01,  5.5637254902000000e-01, \
                                    5.5882352941199998e-01,  5.6127450980399995e-01,  5.6372549019600005e-01, \
                                    5.6617647058800002e-01,  5.6862745098000000e-01,  5.7107843137299996e-01, \
                                    5.7352941176500005e-01,  5.7598039215700003e-01,  5.7843137254900001e-01, \
                                    5.8088235294099999e-01,  5.8333333333299997e-01,  5.8578431372499995e-01, \
                                    5.8823529411800002e-01,  5.9068627451000000e-01,  5.9313725490199998e-01, \
                                    5.9558823529399996e-01,  5.9803921568600005e-01,  6.0049019607800003e-01, \
                                    6.0294117647099998e-01,  6.0539215686299996e-01,  6.0784313725500005e-01, \
                                    6.1029411764700003e-01,  6.1274509803900001e-01,  6.1519607843099999e-01, \
                                    6.1764705882399995e-01,  6.2009803921600004e-01,  6.2254901960800002e-01, \
                                    6.2500000000000000e-01,  6.2745098039199998e-01,  6.2990196078399996e-01, \
                                    6.3235294117600005e-01,  6.3480392156900001e-01,  6.3725490196099999e-01, \
                                    6.3970588235299997e-01,  6.4215686274499995e-01,  6.4460784313700004e-01, \
                                    6.4705882352900002e-01,  6.4950980392199997e-01,  6.5196078431399995e-01, \
                                    6.5441176470600004e-01,  6.5686274509800002e-01,  6.5931372549000000e-01, \
                                    6.6176470588199998e-01,  6.6421568627500005e-01,  6.6666666666700003e-01, \
                                    6.6911764705900001e-01,  6.7156862745099999e-01,  6.7401960784299997e-01, \
                                    6.7647058823499995e-01,  6.7892156862700004e-01,  6.8137254902000000e-01, \
                                    6.8382352941199998e-01,  6.8627450980399995e-01,  6.8872549019600005e-01, \
                                    6.9117647058800002e-01,  6.9362745098000000e-01,  6.9607843137299996e-01, \
                                    6.9852941176500005e-01,  7.0098039215700003e-01,  7.0343137254900001e-01, \
                                    7.0588235294099999e-01,  7.0833333333299997e-01,  7.1078431372499995e-01, \
                                    7.1323529411800002e-01,  7.1568627451000000e-01,  7.1813725490199998e-01, \
                                    7.2058823529399996e-01,  7.2303921568600005e-01,  7.2549019607800003e-01, \
                                    7.2794117647099998e-01,  7.3039215686299996e-01,  7.3284313725500005e-01, \
                                    7.3529411764700003e-01,  7.3774509803900001e-01,  7.4019607843099999e-01, \
                                    7.4264705882399995e-01,  7.4509803921600004e-01,  7.4754901960800002e-01, \
                                    7.5000000000000000e-01,  7.5245098039199998e-01,  7.5490196078399996e-01, \
                                    7.5735294117600005e-01,  7.5980392156900001e-01,  7.6225490196099999e-01, \
                                    7.6470588235299997e-01,  7.6715686274499995e-01,  7.6960784313700004e-01, \
                                    7.7205882352900002e-01,  7.7450980392199997e-01,  7.7696078431399995e-01, \
                                    7.7941176470600004e-01,  7.8186274509800002e-01,  7.8431372549000000e-01, \
                                    7.8676470588199998e-01,  7.8921568627500005e-01,  7.9166666666700003e-01, \
                                    7.9411764705900001e-01,  7.9656862745099999e-01,  7.9901960784299997e-01, \
                                    8.0147058823499995e-01,  8.0392156862700004e-01,  8.0637254902000000e-01, \
                                    8.0882352941199998e-01,  8.1127450980399995e-01,  8.1372549019600005e-01, \
                                    8.1617647058800002e-01,  8.1862745098000000e-01,  8.2107843137299996e-01, \
                                    8.2352941176500005e-01,  8.2598039215700003e-01,  8.2843137254900001e-01, \
                                    8.3088235294099999e-01,  8.3333333333299997e-01,  8.3578431372499995e-01, \
                                    8.3823529411800002e-01,  8.4068627451000000e-01,  8.4313725490199998e-01, \
                                    8.4558823529399996e-01,  8.4803921568600005e-01,  8.5049019607800003e-01, \
                                    8.5294117647099998e-01,  8.5539215686299996e-01,  8.5784313725500005e-01, \
                                    8.6029411764700003e-01,  8.6274509803900001e-01,  8.6519607843099999e-01, \
                                    8.6764705882399995e-01,  8.7009803921600004e-01,  8.7254901960800002e-01, \
                                    8.7500000000000000e-01,  8.7745098039199998e-01,  8.7990196078399996e-01, \
                                    8.8235294117600005e-01,  8.8480392156900001e-01,  8.8725490196099999e-01, \
                                    8.8970588235299997e-01,  8.9215686274499995e-01,  8.9460784313700004e-01, \
                                    8.9705882352900002e-01,  8.9950980392199997e-01,  9.0196078431399995e-01, \
                                    9.0441176470600004e-01,  9.0686274509800002e-01,  9.0931372549000000e-01, \
                                    9.1176470588199998e-01,  9.1421568627500005e-01,  9.1666666666700003e-01, \
                                    9.1911764705900001e-01,  9.2156862745099999e-01,  9.2401960784299997e-01, \
                                    9.2647058823499995e-01,  9.2892156862700004e-01,  9.3137254902000000e-01, \
                                    9.3382352941199998e-01,  9.3627450980399995e-01,  9.3872549019600005e-01, \
                                    9.4117647058800002e-01,  9.4362745098000000e-01,  9.4607843137299996e-01, \
                                    9.4852941176500005e-01,  9.5098039215700003e-01,  9.5343137254900001e-01, \
                                    9.5588235294099999e-01,  9.5833333333299997e-01,  9.6078431372499995e-01, \
                                    9.6323529411800002e-01,  9.6568627451000000e-01,  9.6813725490199998e-01, \
                                    9.7058823529399996e-01,  9.7303921568600005e-01,  9.7549019607800003e-01, \
                                    9.7794117647099998e-01,  9.8039215686299996e-01,  9.8284313725500005e-01, \
                                    9.8529411764700003e-01,  9.8774509803900001e-01,  9.9019607843099999e-01, \
                                    9.9264705882399995e-01,  9.9509803921600004e-01,  9.9754901960800002e-01, \
                                    1.0000000000000000e+00, -1.0000000000000000e+00, -9.9793601651200003e-01, \
                                    -9.9587203302399996e-01, -9.9380804953599999e-01, -9.9174406604700005e-01, \
                                    -9.8968008255899997e-01, -9.8761609907100001e-01, -9.8555211558300004e-01, \
                                    -9.8348813209499997e-01, -9.8142414860700000e-01, -9.7936016511900004e-01, \
                                    -9.7729618163099996e-01, -9.7523219814200002e-01, -9.7316821465400005e-01, \
                                    -9.7110423116599998e-01, -9.6904024767800001e-01, -9.6697626419000005e-01, \
                                    -9.6491228070199997e-01, -9.6284829721400000e-01, -9.6078431372499995e-01, \
                                    -9.5872033023699998e-01, -9.5665634674900002e-01, -9.5459236326100005e-01, \
                                    -9.5252837977299998e-01, -9.5046439628500001e-01, -9.4840041279700005e-01, \
                                    -9.4633642930899997e-01, -9.4427244582000003e-01, -9.4220846233199995e-01, \
                                    -9.4014447884399999e-01, -9.3808049535600002e-01, -9.3601651186799995e-01, \
                                    -9.3395252837999998e-01, -9.3188854489200001e-01, -9.2982456140400005e-01, \
                                    -9.2776057791500000e-01, -9.2569659442700003e-01, -9.2363261093899995e-01, \
                                    -9.2156862745099999e-01, -9.1950464396300002e-01, -9.1744066047499995e-01, \
                                    -9.1537667698699998e-01, -9.1331269349800004e-01, -9.1124871000999996e-01, \
                                    -9.0918472652200000e-01, -9.0712074303400003e-01, -9.0505675954599996e-01, \
                                    -9.0299277605799999e-01, -9.0092879257000003e-01, -8.9886480908199995e-01, \
                                    -8.9680082559300001e-01, -8.9473684210500004e-01, -8.9267285861699996e-01, \
                                    -8.9060887512900000e-01, -8.8854489164100003e-01, -8.8648090815299996e-01, \
                                    -8.8441692466499999e-01, -8.8235294117600005e-01, -8.8028895768799997e-01, \
                                    -8.7822497420000001e-01, -8.7616099071200004e-01, -8.7409700722399997e-01, \
                                    -8.7203302373600000e-01, -8.6996904024800004e-01, -8.6790505675999996e-01, \
                                    -8.6584107327100002e-01, -8.6377708978300005e-01, -8.6171310629499998e-01, \
                                    -8.5964912280700001e-01, -8.5758513931900004e-01, -8.5552115583099997e-01, \
                                    -8.5345717234300000e-01, -8.5139318885399995e-01, -8.4932920536599998e-01, \
                                    -8.4726522187800002e-01, -8.4520123839000005e-01, -8.4313725490199998e-01, \
                                    -8.4107327141400001e-01, -8.3900928792600005e-01, -8.3694530443799997e-01, \
                                    -8.3488132094900003e-01, -8.3281733746099995e-01, -8.3075335397299999e-01, \
                                    -8.2868937048500002e-01, -8.2662538699699994e-01, -8.2456140350899998e-01, \
                                    -8.2249742002100001e-01, -8.2043343653300005e-01, -8.1836945304399999e-01, \
                                    -8.1630546955600003e-01, -8.1424148606799995e-01, -8.1217750257999999e-01, \
                                    -8.1011351909200002e-01, -8.0804953560399995e-01, -8.0598555211599998e-01, \
                                    -8.0392156862700004e-01, -8.0185758513899996e-01, -7.9979360165100000e-01, \
                                    -7.9772961816300003e-01, -7.9566563467499996e-01, -7.9360165118699999e-01, \
                                    -7.9153766769900002e-01, -7.8947368421099995e-01, -7.8740970072200001e-01, \
                                    -7.8534571723400004e-01, -7.8328173374599996e-01, -7.8121775025800000e-01, \
                                    -7.7915376677000003e-01, -7.7708978328199996e-01, -7.7502579979399999e-01, \
                                    -7.7296181630500005e-01, -7.7089783281699997e-01, -7.6883384932900001e-01, \
                                    -7.6676986584100004e-01, -7.6470588235299997e-01, -7.6264189886500000e-01, \
                                    -7.6057791537700004e-01, -7.5851393188899996e-01, -7.5644994840000002e-01, \
                                    -7.5438596491200005e-01, -7.5232198142399997e-01, -7.5025799793600001e-01, \
                                    -7.4819401444800004e-01, -7.4613003095999997e-01, -7.4406604747200000e-01, \
                                    -7.4200206398299995e-01, -7.3993808049499998e-01, -7.3787409700700002e-01, \
                                    -7.3581011351900005e-01, -7.3374613003099998e-01, -7.3168214654300001e-01, \
                                    -7.2961816305500005e-01, -7.2755417956699997e-01, -7.2549019607800003e-01, \
                                    -7.2342621258999995e-01, -7.2136222910199999e-01, -7.1929824561400002e-01, \
                                    -7.1723426212600006e-01, -7.1517027863799998e-01, -7.1310629515000001e-01, \
                                    -7.1104231166200005e-01, -7.0897832817299999e-01, -7.0691434468500003e-01, \
                                    -7.0485036119699995e-01, -7.0278637770899999e-01, -7.0072239422100002e-01, \
                                    -6.9865841073299995e-01, -6.9659442724499998e-01, -6.9453044375600004e-01, \
                                    -6.9246646026799996e-01, -6.9040247678000000e-01, -6.8833849329200003e-01, \
                                    -6.8627450980399995e-01, -6.8421052631599999e-01, -6.8214654282800002e-01, \
                                    -6.8008255933999995e-01, -6.7801857585100000e-01, -6.7595459236300004e-01, \
                                    -6.7389060887499996e-01, -6.7182662538700000e-01, -6.6976264189900003e-01, \
                                    -6.6769865841099996e-01, -6.6563467492299999e-01, -6.6357069143400005e-01, \
                                    -6.6150670794599997e-01, -6.5944272445800001e-01, -6.5737874097000004e-01, \
                                    -6.5531475748199997e-01, -6.5325077399400000e-01, -6.5118679050600003e-01, \
                                    -6.4912280701799996e-01, -6.4705882352900002e-01, -6.4499484004100005e-01, \
                                    -6.4293085655299997e-01, -6.4086687306500001e-01, -6.3880288957700004e-01, \
                                    -6.3673890608899997e-01, -6.3467492260100000e-01, -6.3261093911199995e-01, \
                                    -6.3054695562399998e-01, -6.2848297213600002e-01, -6.2641898864800005e-01, \
                                    -6.2435500515999998e-01, -6.2229102167200001e-01, -6.2022703818400005e-01, \
                                    -6.1816305469599997e-01, -6.1609907120700003e-01, -6.1403508771899995e-01, \
                                    -6.1197110423099998e-01, -6.0990712074300002e-01, -6.0784313725500005e-01, \
                                    -6.0577915376699998e-01, -6.0371517027900001e-01, -6.0165118679100005e-01, \
                                    -5.9958720330199999e-01, -5.9752321981400003e-01, -5.9545923632599995e-01, \
                                    -5.9339525283799999e-01, -5.9133126935000002e-01, -5.8926728586199995e-01, \
                                    -5.8720330237399998e-01, -5.8513931888500004e-01, -5.8307533539699996e-01, \
                                    -5.8101135190900000e-01, -5.7894736842100003e-01, -5.7688338493299995e-01, \
                                    -5.7481940144499999e-01, -5.7275541795700002e-01, -5.7069143446899995e-01, \
                                    -5.6862745098000000e-01, -5.6656346749200004e-01, -5.6449948400399996e-01, \
                                    -5.6243550051600000e-01, -5.6037151702800003e-01, -5.5830753353999996e-01, \
                                    -5.5624355005199999e-01, -5.5417956656300005e-01, -5.5211558307499997e-01, \
                                    -5.5005159958700001e-01, -5.4798761609900004e-01, -5.4592363261099996e-01, \
                                    -5.4385964912300000e-01, -5.4179566563500003e-01, -5.3973168214699996e-01, \
                                    -5.3766769865800002e-01, -5.3560371517000005e-01, -5.3353973168199997e-01, \
                                    -5.3147574819400001e-01, -5.2941176470600004e-01, -5.2734778121799997e-01, \
                                    -5.2528379773000000e-01, -5.2321981424099995e-01, -5.2115583075299998e-01, \
                                    -5.1909184726500002e-01, -5.1702786377700005e-01, -5.1496388028899998e-01, \
                                    -5.1289989680100001e-01, -5.1083591331300005e-01, -5.0877192982499997e-01, \
                                    -5.0670794633600003e-01, -5.0464396284799995e-01, -5.0257997935999998e-01, \
                                    -5.0051599587200002e-01, -4.9845201238400000e-01, -4.9638802889599998e-01, \
                                    -4.9432404540800001e-01, -4.9226006191999999e-01, -4.9019607843099999e-01, \
                                    -4.8813209494299997e-01, -4.8606811145500001e-01, -4.8400412796699999e-01, \
                                    -4.8194014447900002e-01, -4.7987616099100000e-01, -4.7781217750299998e-01, \
                                    -4.7574819401399998e-01, -4.7368421052600002e-01, -4.7162022703800000e-01, \
                                    -4.6955624354999997e-01, -4.6749226006200001e-01, -4.6542827657399999e-01, \
                                    -4.6336429308600002e-01, -4.6130030959800000e-01, -4.5923632610900000e-01, \
                                    -4.5717234262099998e-01, -4.5510835913300002e-01, -4.5304437564500000e-01, \
                                    -4.5098039215699998e-01, -4.4891640866900001e-01, -4.4685242518099999e-01, \
                                    -4.4478844169199999e-01, -4.4272445820400003e-01, -4.4066047471600001e-01, \
                                    -4.3859649122799998e-01, -4.3653250774000002e-01, -4.3446852425200000e-01, \
                                    -4.3240454076399998e-01, -4.3034055727600001e-01, -4.2827657378700001e-01, \
                                    -4.2621259029899999e-01, -4.2414860681099997e-01, -4.2208462332300001e-01, \
                                    -4.2002063983499999e-01, -4.1795665634700002e-01, -4.1589267285900000e-01, \
                                    -4.1382868937000000e-01, -4.1176470588199998e-01, -4.0970072239400002e-01, \
                                    -4.0763673890600000e-01, -4.0557275541799997e-01, -4.0350877193000001e-01, \
                                    -4.0144478844199999e-01, -3.9938080495400002e-01, -3.9731682146500003e-01, \
                                    -3.9525283797700000e-01, -3.9318885448899998e-01, -3.9112487100100002e-01, \
                                    -3.8906088751300000e-01, -3.8699690402499998e-01, -3.8493292053700001e-01, \
                                    -3.8286893704899999e-01, -3.8080495355999999e-01, -3.7874097007200003e-01, \
                                    -3.7667698658400001e-01, -3.7461300309599999e-01, -3.7254901960800002e-01, \
                                    -3.7048503612000000e-01, -3.6842105263199998e-01, -3.6635706914299998e-01, \
                                    -3.6429308565500002e-01, -3.6222910216699999e-01, -3.6016511867899997e-01, \
                                    -3.5810113519100001e-01, -3.5603715170299999e-01, -3.5397316821500002e-01, \
                                    -3.5190918472700000e-01, -3.4984520123800000e-01, -3.4778121774999998e-01, \
                                    -3.4571723426200002e-01, -3.4365325077400000e-01, -3.4158926728599998e-01, \
                                    -3.3952528379800001e-01, -3.3746130030999999e-01, -3.3539731682099999e-01, \
                                    -3.3333333333300003e-01, -3.3126934984500001e-01, -3.2920536635699998e-01, \
                                    -3.2714138286900002e-01, -3.2507739938100000e-01, -3.2301341589299998e-01, \
                                    -3.2094943240500001e-01, -3.1888544891600001e-01, -3.1682146542799999e-01, \
                                    -3.1475748193999997e-01, -3.1269349845200001e-01, -3.1062951496399999e-01, \
                                    -3.0856553147600002e-01, -3.0650154798800000e-01, -3.0443756449900000e-01, \
                                    -3.0237358101099998e-01, -3.0030959752300002e-01, -2.9824561403500000e-01, \
                                    -2.9618163054699997e-01, -2.9411764705900001e-01, -2.9205366357099999e-01, \
                                    -2.8998968008300002e-01, -2.8792569659400002e-01, -2.8586171310600000e-01, \
                                    -2.8379772961799998e-01, -2.8173374613000002e-01, -2.7966976264200000e-01, \
                                    -2.7760577915399998e-01, -2.7554179566600001e-01, -2.7347781217799999e-01, \
                                    -2.7141382868899999e-01, -2.6934984520100003e-01, -2.6728586171300001e-01, \
                                    -2.6522187822499999e-01, -2.6315789473700002e-01, -2.6109391124900000e-01, \
                                    -2.5902992776099998e-01, -2.5696594427199998e-01, -2.5490196078400001e-01, \
                                    -2.5283797729599999e-01, -2.5077399380799997e-01, -2.4871001032000001e-01, \
                                    -2.4664602683199999e-01, -2.4458204334399999e-01, -2.4251805985600000e-01, \
                                    -2.4045407636700000e-01, -2.3839009287900001e-01, -2.3632610939099999e-01, \
                                    -2.3426212590300000e-01, -2.3219814241500000e-01, -2.3013415892700001e-01, \
                                    -2.2807017543899999e-01, -2.2600619194999999e-01, -2.2394220846200000e-01, \
                                    -2.2187822497400000e-01, -2.1981424148600001e-01, -2.1775025799799999e-01, \
                                    -2.1568627451000000e-01, -2.1362229102200000e-01, -2.1155830753400001e-01, \
                                    -2.0949432404500001e-01, -2.0743034055699999e-01, -2.0536635706900000e-01, \
                                    -2.0330237358100001e-01, -2.0123839009300001e-01, -1.9917440660499999e-01, \
                                    -1.9711042311700000e-01, -1.9504643962800000e-01, -1.9298245614000001e-01, \
                                    -1.9091847265199999e-01, -1.8885448916399999e-01, -1.8679050567600000e-01, \
                                    -1.8472652218800001e-01, -1.8266253869999999e-01, -1.8059855521199999e-01, \
                                    -1.7853457172300000e-01, -1.7647058823500000e-01, -1.7440660474700001e-01, \
                                    -1.7234262125899999e-01, -1.7027863777100000e-01, -1.6821465428300000e-01, \
                                    -1.6615067079500001e-01, -1.6408668730699999e-01, -1.6202270381799999e-01, \
                                    -1.5995872033000000e-01, -1.5789473684200001e-01, -1.5583075335400001e-01, \
                                    -1.5376676986599999e-01, -1.5170278637800000e-01, -1.4963880289000001e-01, \
                                    -1.4757481940100001e-01, -1.4551083591299999e-01, -1.4344685242499999e-01, \
                                    -1.4138286893700000e-01, -1.3931888544900001e-01, -1.3725490196099999e-01, \
                                    -1.3519091847299999e-01, -1.3312693498500000e-01, -1.3106295149600000e-01, \
                                    -1.2899896800800001e-01, -1.2693498451999999e-01, -1.2487100103200000e-01, \
                                    -1.2280701754400000e-01, -1.2074303405600000e-01, -1.1867905056800000e-01, \
                                    -1.1661506707900000e-01, -1.1455108359100000e-01, -1.1248710010300000e-01, \
                                    -1.1042311661500000e-01, -1.0835913312700000e-01, -1.0629514963900000e-01, \
                                    -1.0423116615100000e-01, -1.0216718266300000e-01, -1.0010319917400000e-01, \
                                    -9.8039215686000006e-02, -9.5975232197999999e-02, -9.3911248710000006e-02, \
                                    -9.1847265221999999e-02, -8.9783281734000006e-02, -8.7719298245999999e-02, \
                                    -8.5655314757000001e-02, -8.3591331268999994e-02, -8.1527347781000001e-02, \
                                    -7.9463364292999994e-02, -7.7399380805000001e-02, -7.5335397316999994e-02, \
                                    -7.3271413829000001e-02, -7.1207430340999994e-02, -6.9143446851999996e-02, \
                                    -6.7079463364000003e-02, -6.5015479875999996e-02, -6.2951496388000003e-02, \
                                    -6.0887512900000003e-02, -5.8823529412000003e-02, -5.6759545924000003e-02, \
                                    -5.4695562436000003e-02, -5.2631578946999998e-02, -5.0567595458999998e-02, \
                                    -4.8503611970999998e-02, -4.6439628482999998e-02, -4.4375644994999998e-02, \
                                    -4.2311661506999998e-02, -4.0247678018999998e-02, -3.8183694529999999e-02, \
                                    -3.6119711041999999e-02, -3.4055727554000000e-02, -3.1991744066000000e-02, \
                                    -2.9927760578000000e-02, -2.7863777090000000e-02, -2.5799793602000000e-02, \
                                    -2.3735810114000000e-02, -2.1671826625000001e-02, -1.9607843137000001e-02, \
                                    -1.7543859649000001e-02, -1.5479876161000000e-02, -1.3415892673000000e-02, \
                                    -1.1351909185000000e-02, -9.2879256970000001e-03, -7.2239422079999997e-03, \
                                    -5.1599587199999998e-03, -3.0959752319999999e-03, -1.0319917440000000e-03, \
                                    1.0319917440000000e-03,  3.0959752319999999e-03,  5.1599587199999998e-03, \
                                    7.2239422079999997e-03,  9.2879256970000001e-03,  1.1351909185000000e-02, \
                                    1.3415892673000000e-02,  1.5479876161000000e-02,  1.7543859649000001e-02, \
                                    1.9607843137000001e-02,  2.1671826625000001e-02,  2.3735810114000000e-02, \
                                    2.5799793602000000e-02,  2.7863777090000000e-02,  2.9927760578000000e-02, \
                                    3.1991744066000000e-02,  3.4055727554000000e-02,  3.6119711041999999e-02, \
                                    3.8183694529999999e-02,  4.0247678018999998e-02,  4.2311661506999998e-02, \
                                    4.4375644994999998e-02,  4.6439628482999998e-02,  4.8503611970999998e-02, \
                                    5.0567595458999998e-02,  5.2631578946999998e-02,  5.4695562434999997e-02, \
                                    5.6759545924000003e-02,  5.8823529412000003e-02,  6.0887512900000003e-02, \
                                    6.2951496388000003e-02,  6.5015479875999996e-02,  6.7079463364000003e-02, \
                                    6.9143446851999996e-02,  7.1207430340999994e-02,  7.3271413829000001e-02, \
                                    7.5335397316999994e-02,  7.7399380805000001e-02,  7.9463364292999994e-02, \
                                    8.1527347781000001e-02,  8.3591331268999994e-02,  8.5655314757000001e-02, \
                                    8.7719298245999999e-02,  8.9783281734000006e-02,  9.1847265221999999e-02, \
                                    9.3911248710000006e-02,  9.5975232197999999e-02,  9.8039215686000006e-02, \
                                    1.0010319917400000e-01,  1.0216718266300000e-01,  1.0423116615100000e-01, \
                                    1.0629514963900000e-01,  1.0835913312700000e-01,  1.1042311661500000e-01, \
                                    1.1248710010300000e-01,  1.1455108359100000e-01,  1.1661506707900000e-01, \
                                    1.1867905056800000e-01,  1.2074303405600000e-01,  1.2280701754400000e-01, \
                                    1.2487100103200000e-01,  1.2693498451999999e-01,  1.2899896800800001e-01, \
                                    1.3106295149600000e-01,  1.3312693498500000e-01,  1.3519091847299999e-01, \
                                    1.3725490196099999e-01,  1.3931888544900001e-01,  1.4138286893700000e-01, \
                                    1.4344685242499999e-01,  1.4551083591299999e-01,  1.4757481940100001e-01, \
                                    1.4963880289000001e-01,  1.5170278637800000e-01,  1.5376676986599999e-01, \
                                    1.5583075335400001e-01,  1.5789473684200001e-01,  1.5995872033000000e-01, \
                                    1.6202270381799999e-01,  1.6408668730600001e-01,  1.6615067079500001e-01, \
                                    1.6821465428300000e-01,  1.7027863777100000e-01,  1.7234262125899999e-01, \
                                    1.7440660474700001e-01,  1.7647058823500000e-01,  1.7853457172300000e-01, \
                                    1.8059855521199999e-01,  1.8266253869999999e-01,  1.8472652218800001e-01, \
                                    1.8679050567600000e-01,  1.8885448916399999e-01,  1.9091847265199999e-01, \
                                    1.9298245614000001e-01,  1.9504643962800000e-01,  1.9711042311700000e-01, \
                                    1.9917440660499999e-01,  2.0123839009300001e-01,  2.0330237358100001e-01, \
                                    2.0536635706900000e-01,  2.0743034055699999e-01,  2.0949432404500001e-01, \
                                    2.1155830753400001e-01,  2.1362229102200000e-01,  2.1568627451000000e-01, \
                                    2.1775025799799999e-01,  2.1981424148600001e-01,  2.2187822497400000e-01, \
                                    2.2394220846200000e-01,  2.2600619194999999e-01,  2.2807017543899999e-01, \
                                    2.3013415892700001e-01,  2.3219814241500000e-01,  2.3426212590300000e-01, \
                                    2.3632610939099999e-01,  2.3839009287900001e-01,  2.4045407636700000e-01, \
                                    2.4251805985600000e-01,  2.4458204334399999e-01,  2.4664602683199999e-01, \
                                    2.4871001032000001e-01,  2.5077399380799997e-01,  2.5283797729599999e-01, \
                                    2.5490196078400001e-01,  2.5696594427199998e-01,  2.5902992776099998e-01, \
                                    2.6109391124900000e-01,  2.6315789473700002e-01,  2.6522187822499999e-01, \
                                    2.6728586171300001e-01,  2.6934984520100003e-01,  2.7141382868899999e-01, \
                                    2.7347781217700001e-01,  2.7554179566600001e-01,  2.7760577915399998e-01, \
                                    2.7966976264200000e-01,  2.8173374613000002e-01,  2.8379772961799998e-01, \
                                    2.8586171310600000e-01,  2.8792569659400002e-01,  2.8998968008300002e-01, \
                                    2.9205366357099999e-01,  2.9411764705900001e-01,  2.9618163054699997e-01, \
                                    2.9824561403500000e-01,  3.0030959752300002e-01,  3.0237358101099998e-01, \
                                    3.0443756449900000e-01,  3.0650154798800000e-01,  3.0856553147600002e-01, \
                                    3.1062951496399999e-01,  3.1269349845200001e-01,  3.1475748193999997e-01, \
                                    3.1682146542799999e-01,  3.1888544891600001e-01,  3.2094943240500001e-01, \
                                    3.2301341589299998e-01,  3.2507739938100000e-01,  3.2714138286900002e-01, \
                                    3.2920536635699998e-01,  3.3126934984500001e-01,  3.3333333333300003e-01, \
                                    3.3539731682099999e-01,  3.3746130030999999e-01,  3.3952528379800001e-01, \
                                    3.4158926728599998e-01,  3.4365325077400000e-01,  3.4571723426200002e-01, \
                                    3.4778121774999998e-01,  3.4984520123800000e-01,  3.5190918472700000e-01, \
                                    3.5397316821500002e-01,  3.5603715170299999e-01,  3.5810113519100001e-01, \
                                    3.6016511867899997e-01,  3.6222910216699999e-01,  3.6429308565500002e-01, \
                                    3.6635706914299998e-01,  3.6842105263199998e-01,  3.7048503612000000e-01, \
                                    3.7254901960800002e-01,  3.7461300309599999e-01,  3.7667698658400001e-01, \
                                    3.7874097007200003e-01,  3.8080495355999999e-01,  3.8286893704800001e-01, \
                                    3.8493292053700001e-01,  3.8699690402499998e-01,  3.8906088751300000e-01, \
                                    3.9112487100100002e-01,  3.9318885448899998e-01,  3.9525283797700000e-01, \
                                    3.9731682146500003e-01,  3.9938080495400002e-01,  4.0144478844199999e-01, \
                                    4.0350877193000001e-01,  4.0557275541799997e-01,  4.0763673890600000e-01, \
                                    4.0970072239400002e-01,  4.1176470588199998e-01,  4.1382868937000000e-01, \
                                    4.1589267285900000e-01,  4.1795665634700002e-01,  4.2002063983499999e-01, \
                                    4.2208462332300001e-01,  4.2414860681099997e-01,  4.2621259029899999e-01, \
                                    4.2827657378700001e-01,  4.3034055727600001e-01,  4.3240454076399998e-01, \
                                    4.3446852425200000e-01,  4.3653250774000002e-01,  4.3859649122799998e-01, \
                                    4.4066047471600001e-01,  4.4272445820400003e-01,  4.4478844169199999e-01, \
                                    4.4685242518099999e-01,  4.4891640866900001e-01,  4.5098039215699998e-01, \
                                    4.5304437564500000e-01,  4.5510835913300002e-01,  4.5717234262099998e-01, \
                                    4.5923632610900000e-01,  4.6130030959800000e-01,  4.6336429308600002e-01, \
                                    4.6542827657399999e-01,  4.6749226006200001e-01,  4.6955624354999997e-01, \
                                    4.7162022703800000e-01,  4.7368421052600002e-01,  4.7574819401399998e-01, \
                                    4.7781217750299998e-01,  4.7987616099100000e-01,  4.8194014447900002e-01, \
                                    4.8400412796699999e-01,  4.8606811145500001e-01,  4.8813209494299997e-01, \
                                    4.9019607843099999e-01,  4.9226006191900001e-01,  4.9432404540800001e-01, \
                                    4.9638802889599998e-01,  4.9845201238400000e-01,  5.0051599587200002e-01, \
                                    5.0257997935999998e-01,  5.0464396284799995e-01,  5.0670794633600003e-01, \
                                    5.0877192982499997e-01,  5.1083591331300005e-01,  5.1289989680100001e-01, \
                                    5.1496388028899998e-01,  5.1702786377700005e-01,  5.1909184726500002e-01, \
                                    5.2115583075299998e-01,  5.2321981424099995e-01,  5.2528379773000000e-01, \
                                    5.2734778121799997e-01,  5.2941176470600004e-01,  5.3147574819400001e-01, \
                                    5.3353973168199997e-01,  5.3560371517000005e-01,  5.3766769865800002e-01, \
                                    5.3973168214699996e-01,  5.4179566563500003e-01,  5.4385964912300000e-01, \
                                    5.4592363261099996e-01,  5.4798761609900004e-01,  5.5005159958700001e-01, \
                                    5.5211558307499997e-01,  5.5417956656300005e-01,  5.5624355005199999e-01, \
                                    5.5830753353999996e-01,  5.6037151702800003e-01,  5.6243550051600000e-01, \
                                    5.6449948400399996e-01,  5.6656346749200004e-01,  5.6862745098000000e-01, \
                                    5.7069143446899995e-01,  5.7275541795700002e-01,  5.7481940144499999e-01, \
                                    5.7688338493299995e-01,  5.7894736842100003e-01,  5.8101135190900000e-01, \
                                    5.8307533539699996e-01,  5.8513931888500004e-01,  5.8720330237399998e-01, \
                                    5.8926728586199995e-01,  5.9133126935000002e-01,  5.9339525283799999e-01, \
                                    5.9545923632599995e-01,  5.9752321981400003e-01,  5.9958720330199999e-01, \
                                    6.0165118678999996e-01,  6.0371517027900001e-01,  6.0577915376699998e-01, \
                                    6.0784313725500005e-01,  6.0990712074300002e-01,  6.1197110423099998e-01, \
                                    6.1403508771899995e-01,  6.1609907120700003e-01,  6.1816305469599997e-01, \
                                    6.2022703818400005e-01,  6.2229102167200001e-01,  6.2435500515999998e-01, \
                                    6.2641898864800005e-01,  6.2848297213600002e-01,  6.3054695562399998e-01, \
                                    6.3261093911199995e-01,  6.3467492260100000e-01,  6.3673890608899997e-01, \
                                    6.3880288957700004e-01,  6.4086687306500001e-01,  6.4293085655299997e-01, \
                                    6.4499484004100005e-01,  6.4705882352900002e-01,  6.4912280701799996e-01, \
                                    6.5118679050600003e-01,  6.5325077399400000e-01,  6.5531475748199997e-01, \
                                    6.5737874097000004e-01,  6.5944272445800001e-01,  6.6150670794599997e-01, \
                                    6.6357069143400005e-01,  6.6563467492299999e-01,  6.6769865841099996e-01, \
                                    6.6976264189900003e-01,  6.7182662538700000e-01,  6.7389060887499996e-01, \
                                    6.7595459236300004e-01,  6.7801857585100000e-01,  6.8008255933999995e-01, \
                                    6.8214654282800002e-01,  6.8421052631599999e-01,  6.8627450980399995e-01, \
                                    6.8833849329200003e-01,  6.9040247678000000e-01,  6.9246646026799996e-01, \
                                    6.9453044375600004e-01,  6.9659442724499998e-01,  6.9865841073299995e-01, \
                                    7.0072239422100002e-01,  7.0278637770899999e-01,  7.0485036119699995e-01, \
                                    7.0691434468500003e-01,  7.0897832817299999e-01,  7.1104231166099996e-01, \
                                    7.1310629515000001e-01,  7.1517027863799998e-01,  7.1723426212600006e-01, \
                                    7.1929824561400002e-01,  7.2136222910199999e-01,  7.2342621258999995e-01, \
                                    7.2549019607800003e-01,  7.2755417956699997e-01,  7.2961816305500005e-01, \
                                    7.3168214654300001e-01,  7.3374613003099998e-01,  7.3581011351900005e-01, \
                                    7.3787409700700002e-01,  7.3993808049499998e-01,  7.4200206398299995e-01, \
                                    7.4406604747200000e-01,  7.4613003095999997e-01,  7.4819401444800004e-01, \
                                    7.5025799793600001e-01,  7.5232198142399997e-01,  7.5438596491200005e-01, \
                                    7.5644994840000002e-01,  7.5851393188899996e-01,  7.6057791537700004e-01, \
                                    7.6264189886500000e-01,  7.6470588235299997e-01,  7.6676986584100004e-01, \
                                    7.6883384932900001e-01,  7.7089783281699997e-01,  7.7296181630500005e-01, \
                                    7.7502579979399999e-01,  7.7708978328199996e-01,  7.7915376677000003e-01, \
                                    7.8121775025800000e-01,  7.8328173374599996e-01,  7.8534571723400004e-01, \
                                    7.8740970072200001e-01,  7.8947368421099995e-01,  7.9153766769900002e-01, \
                                    7.9360165118699999e-01,  7.9566563467499996e-01,  7.9772961816300003e-01, \
                                    7.9979360165100000e-01,  8.0185758513899996e-01,  8.0392156862700004e-01, \
                                    8.0598555211599998e-01,  8.0804953560399995e-01,  8.1011351909200002e-01, \
                                    8.1217750257999999e-01,  8.1424148606799995e-01,  8.1630546955600003e-01, \
                                    8.1836945304399999e-01,  8.2043343653199996e-01,  8.2249742002100001e-01, \
                                    8.2456140350899998e-01,  8.2662538699699994e-01,  8.2868937048500002e-01, \
                                    8.3075335397299999e-01,  8.3281733746099995e-01,  8.3488132094900003e-01, \
                                    8.3694530443799997e-01,  8.3900928792600005e-01,  8.4107327141400001e-01, \
                                    8.4313725490199998e-01,  8.4520123839000005e-01,  8.4726522187800002e-01, \
                                    8.4932920536599998e-01,  8.5139318885399995e-01,  8.5345717234300000e-01, \
                                    8.5552115583099997e-01,  8.5758513931900004e-01,  8.5964912280700001e-01, \
                                    8.6171310629499998e-01,  8.6377708978300005e-01,  8.6584107327100002e-01, \
                                    8.6790505675999996e-01,  8.6996904024800004e-01,  8.7203302373600000e-01, \
                                    8.7409700722399997e-01,  8.7616099071200004e-01,  8.7822497420000001e-01, \
                                    8.8028895768799997e-01,  8.8235294117600005e-01,  8.8441692466499999e-01, \
                                    8.8648090815299996e-01,  8.8854489164100003e-01,  8.9060887512900000e-01, \
                                    8.9267285861699996e-01,  8.9473684210500004e-01,  8.9680082559300001e-01, \
                                    8.9886480908199995e-01,  9.0092879257000003e-01,  9.0299277605799999e-01, \
                                    9.0505675954599996e-01,  9.0712074303400003e-01,  9.0918472652200000e-01, \
                                    9.1124871000999996e-01,  9.1331269349800004e-01,  9.1537667698699998e-01, \
                                    9.1744066047499995e-01,  9.1950464396300002e-01,  9.2156862745099999e-01, \
                                    9.2363261093899995e-01,  9.2569659442700003e-01,  9.2776057791500000e-01, \
                                    9.2982456140299996e-01,  9.3188854489200001e-01,  9.3395252837999998e-01, \
                                    9.3601651186799995e-01,  9.3808049535600002e-01,  9.4014447884399999e-01, \
                                    9.4220846233199995e-01,  9.4427244582000003e-01,  9.4633642930899997e-01, \
                                    9.4840041279700005e-01,  9.5046439628500001e-01,  9.5252837977299998e-01, \
                                    9.5459236326100005e-01,  9.5665634674900002e-01,  9.5872033023699998e-01, \
                                    9.6078431372499995e-01,  9.6284829721400000e-01,  9.6491228070199997e-01, \
                                    9.6697626419000005e-01,  9.6904024767800001e-01,  9.7110423116599998e-01, \
                                    9.7316821465400005e-01,  9.7523219814200002e-01,  9.7729618163099996e-01, \
                                    9.7936016511900004e-01,  9.8142414860700000e-01,  9.8348813209499997e-01, \
                                    9.8555211558300004e-01,  9.8761609907100001e-01,  9.8968008255899997e-01, \
                                    9.9174406604700005e-01,  9.9380804953599999e-01,  9.9587203302399996e-01, \
                                    9.9793601651200003e-01,  1.0000000000000000e+00, -1.0000000000000000e+00, \
                                    -9.9824561403500001e-01, -9.9649122807000001e-01, -9.9473684210500002e-01, \
                                    -9.9298245614000002e-01, -9.9122807017500003e-01, -9.8947368421100002e-01, \
                                    -9.8771929824600002e-01, -9.8596491228100003e-01, -9.8421052631600003e-01, \
                                    -9.8245614035100004e-01, -9.8070175438600005e-01, -9.7894736842100005e-01, \
                                    -9.7719298245599995e-01, -9.7543859649099995e-01, -9.7368421052599996e-01, \
                                    -9.7192982456099997e-01, -9.7017543859599997e-01, -9.6842105263199996e-01, \
                                    -9.6666666666699996e-01, -9.6491228070199997e-01, -9.6315789473699998e-01, \
                                    -9.6140350877199998e-01, -9.5964912280699999e-01, -9.5789473684199999e-01, \
                                    -9.5614035087700000e-01, -9.5438596491200001e-01, -9.5263157894700001e-01, \
                                    -9.5087719298200002e-01, -9.4912280701800000e-01, -9.4736842105300001e-01, \
                                    -9.4561403508800002e-01, -9.4385964912300002e-01, -9.4210526315800003e-01, \
                                    -9.4035087719300003e-01, -9.3859649122800004e-01, -9.3684210526300005e-01, \
                                    -9.3508771929800005e-01, -9.3333333333299995e-01, -9.3157894736799995e-01, \
                                    -9.2982456140400005e-01, -9.2807017543899994e-01, -9.2631578947399995e-01, \
                                    -9.2456140350899996e-01, -9.2280701754399996e-01, -9.2105263157899997e-01, \
                                    -9.1929824561399998e-01, -9.1754385964899998e-01, -9.1578947368399999e-01, \
                                    -9.1403508771899999e-01, -9.1228070175400000e-01, -9.1052631578900001e-01, \
                                    -9.0877192982499999e-01, -9.0701754386000000e-01, -9.0526315789500000e-01, \
                                    -9.0350877193000001e-01, -9.0175438596500002e-01, -9.0000000000000002e-01, \
                                    -8.9824561403500003e-01, -8.9649122807000003e-01, -8.9473684210500004e-01, \
                                    -8.9298245614000005e-01, -8.9122807017500005e-01, -8.8947368421100004e-01, \
                                    -8.8771929824600004e-01, -8.8596491228100005e-01, -8.8421052631599995e-01, \
                                    -8.8245614035099995e-01, -8.8070175438599996e-01, -8.7894736842099996e-01, \
                                    -8.7719298245599997e-01, -8.7543859649099998e-01, -8.7368421052599998e-01, \
                                    -8.7192982456099999e-01, -8.7017543859599999e-01, -8.6842105263199998e-01, \
                                    -8.6666666666699999e-01, -8.6491228070199999e-01, -8.6315789473700000e-01, \
                                    -8.6140350877200000e-01, -8.5964912280700001e-01, -8.5789473684200002e-01, \
                                    -8.5614035087700002e-01, -8.5438596491200003e-01, -8.5263157894700004e-01, \
                                    -8.5087719298200004e-01, -8.4912280701800003e-01, -8.4736842105300003e-01, \
                                    -8.4561403508800004e-01, -8.4385964912300004e-01, -8.4210526315800005e-01, \
                                    -8.4035087719299995e-01, -8.3859649122799995e-01, -8.3684210526299996e-01, \
                                    -8.3508771929799996e-01, -8.3333333333299997e-01, -8.3157894736799998e-01, \
                                    -8.2982456140399996e-01, -8.2807017543899997e-01, -8.2631578947399997e-01, \
                                    -8.2456140350899998e-01, -8.2280701754399999e-01, -8.2105263157899999e-01, \
                                    -8.1929824561400000e-01, -8.1754385964900000e-01, -8.1578947368400001e-01, \
                                    -8.1403508771900002e-01, -8.1228070175400002e-01, -8.1052631578900003e-01, \
                                    -8.0877192982500001e-01, -8.0701754386000002e-01, -8.0526315789500003e-01, \
                                    -8.0350877193000003e-01, -8.0175438596500004e-01, -8.0000000000000004e-01, \
                                    -7.9824561403500005e-01, -7.9649122806999995e-01, -7.9473684210499995e-01, \
                                    -7.9298245613999996e-01, -7.9122807017499996e-01, -7.8947368421099995e-01, \
                                    -7.8771929824599995e-01, -7.8596491228099996e-01, -7.8421052631599997e-01, \
                                    -7.8245614035099997e-01, -7.8070175438599998e-01, -7.7894736842099999e-01, \
                                    -7.7719298245599999e-01, -7.7543859649100000e-01, -7.7368421052600000e-01, \
                                    -7.7192982456100001e-01, -7.7017543859600002e-01, -7.6842105263200000e-01, \
                                    -7.6666666666700001e-01, -7.6491228070200001e-01, -7.6315789473700002e-01, \
                                    -7.6140350877200003e-01, -7.5964912280700003e-01, -7.5789473684200004e-01, \
                                    -7.5614035087700004e-01, -7.5438596491200005e-01, -7.5263157894699995e-01, \
                                    -7.5087719298199995e-01, -7.4912280701800005e-01, -7.4736842105300005e-01, \
                                    -7.4561403508799995e-01, -7.4385964912299996e-01, -7.4210526315799996e-01, \
                                    -7.4035087719299997e-01, -7.3859649122799997e-01, -7.3684210526299998e-01, \
                                    -7.3508771929799999e-01, -7.3333333333299999e-01, -7.3157894736800000e-01, \
                                    -7.2982456140399998e-01, -7.2807017543899999e-01, -7.2631578947400000e-01, \
                                    -7.2456140350900000e-01, -7.2280701754400001e-01, -7.2105263157900001e-01, \
                                    -7.1929824561400002e-01, -7.1754385964900003e-01, -7.1578947368400003e-01, \
                                    -7.1403508771900004e-01, -7.1228070175400005e-01, -7.1052631578900005e-01, \
                                    -7.0877192982500004e-01, -7.0701754386000004e-01, -7.0526315789500005e-01, \
                                    -7.0350877193000005e-01, -7.0175438596499995e-01, -6.9999999999999996e-01, \
                                    -6.9824561403499996e-01, -6.9649122806999997e-01, -6.9473684210499997e-01, \
                                    -6.9298245613999998e-01, -6.9122807017499999e-01, -6.8947368421099997e-01, \
                                    -6.8771929824599998e-01, -6.8596491228099998e-01, -6.8421052631599999e-01, \
                                    -6.8245614035100000e-01, -6.8070175438600000e-01, -6.7894736842100001e-01, \
                                    -6.7719298245600001e-01, -6.7543859649100002e-01, -6.7368421052600003e-01, \
                                    -6.7192982456100003e-01, -6.7017543859600004e-01, -6.6842105263200002e-01, \
                                    -6.6666666666700003e-01, -6.6491228070200004e-01, -6.6315789473700004e-01, \
                                    -6.6140350877200005e-01, -6.5964912280700005e-01, -6.5789473684199995e-01, \
                                    -6.5614035087699996e-01, -6.5438596491199996e-01, -6.5263157894699997e-01, \
                                    -6.5087719298199997e-01, -6.4912280701799996e-01, -6.4736842105299996e-01, \
                                    -6.4561403508799997e-01, -6.4385964912299998e-01, -6.4210526315799998e-01, \
                                    -6.4035087719299999e-01, -6.3859649122800000e-01, -6.3684210526300000e-01, \
                                    -6.3508771929800001e-01, -6.3333333333300001e-01, -6.3157894736800002e-01, \
                                    -6.2982456140400001e-01, -6.2807017543900001e-01, -6.2631578947400002e-01, \
                                    -6.2456140350900002e-01, -6.2280701754400003e-01, -6.2105263157900004e-01, \
                                    -6.1929824561400004e-01, -6.1754385964900005e-01, -6.1578947368400005e-01, \
                                    -6.1403508771899995e-01, -6.1228070175399996e-01, -6.1052631578899996e-01, \
                                    -6.0877192982499995e-01, -6.0701754385999995e-01, -6.0526315789499996e-01, \
                                    -6.0350877192999997e-01, -6.0175438596499997e-01, -5.9999999999999998e-01, \
                                    -5.9824561403499998e-01, -5.9649122806999999e-01, -5.9473684210500000e-01, \
                                    -5.9298245614000000e-01, -5.9122807017500001e-01, -5.8947368421099999e-01, \
                                    -5.8771929824600000e-01, -5.8596491228100001e-01, -5.8421052631600001e-01, \
                                    -5.8245614035100002e-01, -5.8070175438600002e-01, -5.7894736842100003e-01, \
                                    -5.7719298245600004e-01, -5.7543859649100004e-01, -5.7368421052600005e-01, \
                                    -5.7192982456100006e-01, -5.7017543859599995e-01, -5.6842105263200005e-01, \
                                    -5.6666666666700005e-01, -5.6491228070199995e-01, -5.6315789473699995e-01, \
                                    -5.6140350877199996e-01, -5.5964912280699997e-01, -5.5789473684199997e-01, \
                                    -5.5614035087699998e-01, -5.5438596491199998e-01, -5.5263157894699999e-01, \
                                    -5.5087719298200000e-01, -5.4912280701799998e-01, -5.4736842105299999e-01, \
                                    -5.4561403508799999e-01, -5.4385964912300000e-01, -5.4210526315800001e-01, \
                                    -5.4035087719300001e-01, -5.3859649122800002e-01, -5.3684210526300002e-01, \
                                    -5.3508771929800003e-01, -5.3333333333300004e-01, -5.3157894736800004e-01, \
                                    -5.2982456140400003e-01, -5.2807017543900003e-01, -5.2631578947400004e-01, \
                                    -5.2456140350900005e-01, -5.2280701754400005e-01, -5.2105263157899995e-01, \
                                    -5.1929824561399995e-01, -5.1754385964899996e-01, -5.1578947368399997e-01, \
                                    -5.1403508771899997e-01, -5.1228070175399998e-01, -5.1052631578899998e-01, \
                                    -5.0877192982499997e-01, -5.0701754385999998e-01, -5.0526315789499998e-01, \
                                    -5.0350877192999999e-01, -5.0175438596499999e-01, -5.0000000000000000e-01, \
                                    -4.9824561403500001e-01, -4.9649122807000001e-01, -4.9473684210500002e-01, \
                                    -4.9298245614000002e-01, -4.9122807017499998e-01, -4.8947368421100002e-01, \
                                    -4.8771929824600002e-01, -4.8596491228100003e-01, -4.8421052631599998e-01, \
                                    -4.8245614035099998e-01, -4.8070175438599999e-01, -4.7894736842100000e-01, \
                                    -4.7719298245600000e-01, -4.7543859649100001e-01, -4.7368421052600002e-01, \
                                    -4.7192982456100002e-01, -4.7017543859599997e-01, -4.6842105263200001e-01, \
                                    -4.6666666666700002e-01, -4.6491228070200002e-01, -4.6315789473699998e-01, \
                                    -4.6140350877199998e-01, -4.5964912280699999e-01, -4.5789473684199999e-01, \
                                    -4.5614035087700000e-01, -4.5438596491200001e-01, -4.5263157894700001e-01, \
                                    -4.5087719298200002e-01, -4.4912280701800000e-01, -4.4736842105300001e-01, \
                                    -4.4561403508800002e-01, -4.4385964912300002e-01, -4.4210526315799997e-01, \
                                    -4.4035087719299998e-01, -4.3859649122799998e-01, -4.3684210526299999e-01, \
                                    -4.3508771929800000e-01, -4.3333333333300000e-01, -4.3157894736800001e-01, \
                                    -4.2982456140399999e-01, -4.2807017543900000e-01, -4.2631578947400001e-01, \
                                    -4.2456140350900001e-01, -4.2280701754400002e-01, -4.2105263157900003e-01, \
                                    -4.1929824561399998e-01, -4.1754385964899998e-01, -4.1578947368399999e-01, \
                                    -4.1403508771899999e-01, -4.1228070175400000e-01, -4.1052631578900001e-01, \
                                    -4.0877192982499999e-01, -4.0701754386000000e-01, -4.0526315789500000e-01, \
                                    -4.0350877193000001e-01, -4.0175438596500002e-01, -4.0000000000000002e-01, \
                                    -3.9824561403499997e-01, -3.9649122806999998e-01, -3.9473684210499999e-01, \
                                    -3.9298245613999999e-01, -3.9122807017500000e-01, -3.8947368421099998e-01, \
                                    -3.8771929824599999e-01, -3.8596491228099999e-01, -3.8421052631600000e-01, \
                                    -3.8245614035100001e-01, -3.8070175438600001e-01, -3.7894736842100002e-01, \
                                    -3.7719298245600003e-01, -3.7543859649099998e-01, -3.7368421052599998e-01, \
                                    -3.7192982456099999e-01, -3.7017543859599999e-01, -3.6842105263199998e-01, \
                                    -3.6666666666699999e-01, -3.6491228070199999e-01, -3.6315789473700000e-01, \
                                    -3.6140350877200000e-01, -3.5964912280700001e-01, -3.5789473684200002e-01, \
                                    -3.5614035087700002e-01, -3.5438596491199997e-01, -3.5263157894699998e-01, \
                                    -3.5087719298199999e-01, -3.4912280701800003e-01, -3.4736842105299998e-01, \
                                    -3.4561403508799998e-01, -3.4385964912299999e-01, -3.4210526315799999e-01, \
                                    -3.4035087719300000e-01, -3.3859649122800001e-01, -3.3684210526300001e-01, \
                                    -3.3508771929800002e-01, -3.3333333333300003e-01, -3.3157894736799998e-01, \
                                    -3.2982456140400002e-01, -3.2807017543900002e-01, -3.2631578947399997e-01, \
                                    -3.2456140350899998e-01, -3.2280701754399999e-01, -3.2105263157899999e-01, \
                                    -3.1929824561400000e-01, -3.1754385964900000e-01, -3.1578947368400001e-01, \
                                    -3.1403508771900002e-01, -3.1228070175400002e-01, -3.1052631578899997e-01, \
                                    -3.0877192982500001e-01, -3.0701754386000002e-01, -3.0526315789500003e-01, \
                                    -3.0350877192999998e-01, -3.0175438596499998e-01, -2.9999999999999999e-01, \
                                    -2.9824561403500000e-01, -2.9649122807000000e-01, -2.9473684210500001e-01, \
                                    -2.9298245614000001e-01, -2.9122807017500002e-01, -2.8947368421100000e-01, \
                                    -2.8771929824600001e-01, -2.8596491228100002e-01, -2.8421052631600002e-01, \
                                    -2.8245614035099997e-01, -2.8070175438599998e-01, -2.7894736842099999e-01, \
                                    -2.7719298245599999e-01, -2.7543859649100000e-01, -2.7368421052600000e-01, \
                                    -2.7192982456100001e-01, -2.7017543859600002e-01, -2.6842105263200000e-01, \
                                    -2.6666666666700001e-01, -2.6491228070200001e-01, -2.6315789473700002e-01, \
                                    -2.6140350877200003e-01, -2.5964912280699998e-01, -2.5789473684199998e-01, \
                                    -2.5614035087699999e-01, -2.5438596491200000e-01, -2.5263157894700000e-01, \
                                    -2.5087719298200001e-01, -2.4912280701799999e-01, -2.4736842105300000e-01, \
                                    -2.4561403508800000e-01, -2.4385964912300001e-01, -2.4210526315799999e-01, \
                                    -2.4035087719300000e-01, -2.3859649122800000e-01, -2.3684210526300001e-01, \
                                    -2.3508771929799999e-01, -2.3333333333299999e-01, -2.3157894736800000e-01, \
                                    -2.2982456140400001e-01, -2.2807017543899999e-01, -2.2631578947400000e-01, \
                                    -2.2456140350900000e-01, -2.2280701754400001e-01, -2.2105263157899999e-01, \
                                    -2.1929824561399999e-01, -2.1754385964900000e-01, -2.1578947368400000e-01, \
                                    -2.1403508771900001e-01, -2.1228070175399999e-01, -2.1052631578900000e-01, \
                                    -2.0877192982500001e-01, -2.0701754385999999e-01, -2.0526315789499999e-01, \
                                    -2.0350877193000000e-01, -2.0175438596500000e-01, -2.0000000000000001e-01, \
                                    -1.9824561403499999e-01, -1.9649122807000000e-01, -1.9473684210500000e-01, \
                                    -1.9298245614000001e-01, -1.9122807017499999e-01, -1.8947368421100000e-01, \
                                    -1.8771929824600000e-01, -1.8596491228100001e-01, -1.8421052631599999e-01, \
                                    -1.8245614035100000e-01, -1.8070175438600000e-01, -1.7894736842100001e-01, \
                                    -1.7719298245599999e-01, -1.7543859649099999e-01, -1.7368421052600000e-01, \
                                    -1.7192982456100001e-01, -1.7017543859600001e-01, -1.6842105263200000e-01, \
                                    -1.6666666666700000e-01, -1.6491228070200001e-01, -1.6315789473699999e-01, \
                                    -1.6140350877199999e-01, -1.5964912280700000e-01, -1.5789473684200001e-01, \
                                    -1.5614035087700001e-01, -1.5438596491199999e-01, -1.5263157894700000e-01, \
                                    -1.5087719298200000e-01, -1.4912280701799999e-01, -1.4736842105299999e-01, \
                                    -1.4561403508800000e-01, -1.4385964912300001e-01, -1.4210526315800001e-01, \
                                    -1.4035087719299999e-01, -1.3859649122800000e-01, -1.3684210526300000e-01, \
                                    -1.3508771929800001e-01, -1.3333333333299999e-01, -1.3157894736799999e-01, \
                                    -1.2982456140400001e-01, -1.2807017543900001e-01, -1.2631578947399999e-01, \
                                    -1.2456140350900000e-01, -1.2280701754400000e-01, -1.2105263157899999e-01, \
                                    -1.1929824561400000e-01, -1.1754385964899999e-01, -1.1578947368400000e-01, \
                                    -1.1403508771900001e-01, -1.1228070175400000e-01, -1.1052631578900000e-01, \
                                    -1.0877192982500000e-01, -1.0701754385999999e-01, -1.0526315789500000e-01, \
                                    -1.0350877192999999e-01, -1.0175438596500000e-01, -1.0000000000000001e-01, \
                                    -9.8245614034999998e-02, -9.6491228070000004e-02, -9.4736842104999996e-02, \
                                    -9.2982456140000003e-02, -9.1228070174999995e-02, -8.9473684211000007e-02, \
                                    -8.7719298245999999e-02, -8.5964912281000005e-02, -8.4210526315999998e-02, \
                                    -8.2456140351000004e-02, -8.0701754385999996e-02, -7.8947368421000003e-02, \
                                    -7.7192982455999995e-02, -7.5438596491000001e-02, -7.3684210525999994e-02, \
                                    -7.1929824561000000e-02, -7.0175438596000006e-02, -6.8421052632000004e-02, \
                                    -6.6666666666999996e-02, -6.4912280702000003e-02, -6.3157894736999995e-02, \
                                    -6.1403508772000001e-02, -5.9649122807000000e-02, -5.7894736842000000e-02, \
                                    -5.6140350876999999e-02, -5.4385964911999998e-02, -5.2631578946999998e-02, \
                                    -5.0877192981999997e-02, -4.9122807018000002e-02, -4.7368421053000001e-02, \
                                    -4.5614035088000000e-02, -4.3859649123000000e-02, -4.2105263157999999e-02, \
                                    -4.0350877192999998e-02, -3.8596491227999997e-02, -3.6842105262999997e-02, \
                                    -3.5087719298000003e-02, -3.3333333333000002e-02, -3.1578947368000002e-02, \
                                    -2.9824561404000000e-02, -2.8070175438999999e-02, -2.6315789474000002e-02, \
                                    -2.4561403509000001e-02, -2.2807017544000000e-02, -2.1052631578999999e-02, \
                                    -1.9298245613999999e-02, -1.7543859649000001e-02, -1.5789473684000001e-02, \
                                    -1.4035087719000000e-02, -1.2280701753999999e-02, -1.0526315789000000e-02, \
                                    -8.7719298250000001e-03, -7.0175438600000003e-03, -5.2631578950000004e-03, \
                                    -3.5087719300000001e-03, -1.7543859650000001e-03,  0.0000000000000000e+00, \
                                    1.7543859650000001e-03,  3.5087719300000001e-03,  5.2631578950000004e-03, \
                                    7.0175438600000003e-03,  8.7719298250000001e-03,  1.0526315789000000e-02, \
                                    1.2280701753999999e-02,  1.4035087719000000e-02,  1.5789473684000001e-02, \
                                    1.7543859649000001e-02,  1.9298245613999999e-02,  2.1052631578999999e-02, \
                                    2.2807017544000000e-02,  2.4561403509000001e-02,  2.6315789474000002e-02, \
                                    2.8070175438999999e-02,  2.9824561404000000e-02,  3.1578947368000002e-02, \
                                    3.3333333333000002e-02,  3.5087719298000003e-02,  3.6842105262999997e-02, \
                                    3.8596491227999997e-02,  4.0350877192999998e-02,  4.2105263157999999e-02, \
                                    4.3859649123000000e-02,  4.5614035088000000e-02,  4.7368421053000001e-02, \
                                    4.9122807018000002e-02,  5.0877192981999997e-02,  5.2631578946999998e-02, \
                                    5.4385964911999998e-02,  5.6140350876999999e-02,  5.7894736842000000e-02, \
                                    5.9649122807000000e-02,  6.1403508772000001e-02,  6.3157894736999995e-02, \
                                    6.4912280702000003e-02,  6.6666666666999996e-02,  6.8421052632000004e-02, \
                                    7.0175438596000006e-02,  7.1929824561000000e-02,  7.3684210525999994e-02, \
                                    7.5438596491000001e-02,  7.7192982455999995e-02,  7.8947368421000003e-02, \
                                    8.0701754385999996e-02,  8.2456140351000004e-02,  8.4210526315999998e-02, \
                                    8.5964912281000005e-02,  8.7719298245999999e-02,  8.9473684211000007e-02, \
                                    9.1228070174999995e-02,  9.2982456140000003e-02,  9.4736842104999996e-02, \
                                    9.6491228070000004e-02,  9.8245614034999998e-02,  1.0000000000000001e-01, \
                                    1.0175438596500000e-01,  1.0350877192999999e-01,  1.0526315789500000e-01, \
                                    1.0701754385999999e-01,  1.0877192982500000e-01,  1.1052631578900000e-01, \
                                    1.1228070175400000e-01,  1.1403508771900001e-01,  1.1578947368400000e-01, \
                                    1.1754385964899999e-01,  1.1929824561400000e-01,  1.2105263157899999e-01, \
                                    1.2280701754400000e-01,  1.2456140350900000e-01,  1.2631578947399999e-01, \
                                    1.2807017543900001e-01,  1.2982456140400001e-01,  1.3157894736799999e-01, \
                                    1.3333333333299999e-01,  1.3508771929800001e-01,  1.3684210526300000e-01, \
                                    1.3859649122800000e-01,  1.4035087719299999e-01,  1.4210526315800001e-01, \
                                    1.4385964912300001e-01,  1.4561403508800000e-01,  1.4736842105299999e-01, \
                                    1.4912280701799999e-01,  1.5087719298200000e-01,  1.5263157894700000e-01, \
                                    1.5438596491199999e-01,  1.5614035087700001e-01,  1.5789473684200001e-01, \
                                    1.5964912280700000e-01,  1.6140350877199999e-01,  1.6315789473699999e-01, \
                                    1.6491228070200001e-01,  1.6666666666700000e-01,  1.6842105263200000e-01, \
                                    1.7017543859600001e-01,  1.7192982456100001e-01,  1.7368421052600000e-01, \
                                    1.7543859649099999e-01,  1.7719298245599999e-01,  1.7894736842100001e-01, \
                                    1.8070175438600000e-01,  1.8245614035100000e-01,  1.8421052631599999e-01, \
                                    1.8596491228100001e-01,  1.8771929824600000e-01,  1.8947368421100000e-01, \
                                    1.9122807017499999e-01,  1.9298245614000001e-01,  1.9473684210500000e-01, \
                                    1.9649122807000000e-01,  1.9824561403499999e-01,  2.0000000000000001e-01, \
                                    2.0175438596500000e-01,  2.0350877193000000e-01,  2.0526315789499999e-01, \
                                    2.0701754385999999e-01,  2.0877192982500001e-01,  2.1052631578900000e-01, \
                                    2.1228070175399999e-01,  2.1403508771900001e-01,  2.1578947368400000e-01, \
                                    2.1754385964900000e-01,  2.1929824561399999e-01,  2.2105263157899999e-01, \
                                    2.2280701754400001e-01,  2.2456140350900000e-01,  2.2631578947400000e-01, \
                                    2.2807017543899999e-01,  2.2982456140400001e-01,  2.3157894736800000e-01, \
                                    2.3333333333299999e-01,  2.3508771929799999e-01,  2.3684210526300001e-01, \
                                    2.3859649122800000e-01,  2.4035087719300000e-01,  2.4210526315799999e-01, \
                                    2.4385964912300001e-01,  2.4561403508800000e-01,  2.4736842105300000e-01, \
                                    2.4912280701799999e-01,  2.5087719298200001e-01,  2.5263157894700000e-01, \
                                    2.5438596491200000e-01,  2.5614035087699999e-01,  2.5789473684199998e-01, \
                                    2.5964912280699998e-01,  2.6140350877200003e-01,  2.6315789473700002e-01, \
                                    2.6491228070200001e-01,  2.6666666666700001e-01,  2.6842105263200000e-01, \
                                    2.7017543859600002e-01,  2.7192982456100001e-01,  2.7368421052600000e-01, \
                                    2.7543859649100000e-01,  2.7719298245599999e-01,  2.7894736842099999e-01, \
                                    2.8070175438599998e-01,  2.8245614035099997e-01,  2.8421052631600002e-01, \
                                    2.8596491228100002e-01,  2.8771929824600001e-01,  2.8947368421100000e-01, \
                                    2.9122807017500002e-01,  2.9298245614000001e-01,  2.9473684210500001e-01, \
                                    2.9649122807000000e-01,  2.9824561403500000e-01,  2.9999999999999999e-01, \
                                    3.0175438596499998e-01,  3.0350877192999998e-01,  3.0526315789500003e-01, \
                                    3.0701754386000002e-01,  3.0877192982500001e-01,  3.1052631578899997e-01, \
                                    3.1228070175400002e-01,  3.1403508771900002e-01,  3.1578947368400001e-01, \
                                    3.1754385964900000e-01,  3.1929824561400000e-01,  3.2105263157899999e-01, \
                                    3.2280701754399999e-01,  3.2456140350899998e-01,  3.2631578947399997e-01, \
                                    3.2807017543900002e-01,  3.2982456140400002e-01,  3.3157894736799998e-01, \
                                    3.3333333333300003e-01,  3.3508771929800002e-01,  3.3684210526300001e-01, \
                                    3.3859649122800001e-01,  3.4035087719300000e-01,  3.4210526315799999e-01, \
                                    3.4385964912299999e-01,  3.4561403508799998e-01,  3.4736842105299998e-01, \
                                    3.4912280701800003e-01,  3.5087719298199999e-01,  3.5263157894699998e-01, \
                                    3.5438596491199997e-01,  3.5614035087700002e-01,  3.5789473684200002e-01, \
                                    3.5964912280700001e-01,  3.6140350877200000e-01,  3.6315789473700000e-01, \
                                    3.6491228070199999e-01,  3.6666666666699999e-01,  3.6842105263199998e-01, \
                                    3.7017543859599999e-01,  3.7192982456099999e-01,  3.7368421052599998e-01, \
                                    3.7543859649099998e-01,  3.7719298245600003e-01,  3.7894736842100002e-01, \
                                    3.8070175438600001e-01,  3.8245614035100001e-01,  3.8421052631600000e-01, \
                                    3.8596491228099999e-01,  3.8771929824599999e-01,  3.8947368421099998e-01, \
                                    3.9122807017500000e-01,  3.9298245613999999e-01,  3.9473684210499999e-01, \
                                    3.9649122806999998e-01,  3.9824561403499997e-01,  4.0000000000000002e-01, \
                                    4.0175438596500002e-01,  4.0350877193000001e-01,  4.0526315789500000e-01, \
                                    4.0701754386000000e-01,  4.0877192982499999e-01,  4.1052631578900001e-01, \
                                    4.1228070175400000e-01,  4.1403508771899999e-01,  4.1578947368399999e-01, \
                                    4.1754385964899998e-01,  4.1929824561399998e-01,  4.2105263157900003e-01, \
                                    4.2280701754400002e-01,  4.2456140350900001e-01,  4.2631578947400001e-01, \
                                    4.2807017543900000e-01,  4.2982456140399999e-01,  4.3157894736800001e-01, \
                                    4.3333333333300000e-01,  4.3508771929800000e-01,  4.3684210526299999e-01, \
                                    4.3859649122799998e-01,  4.4035087719299998e-01,  4.4210526315799997e-01, \
                                    4.4385964912300002e-01,  4.4561403508800002e-01,  4.4736842105300001e-01, \
                                    4.4912280701800000e-01,  4.5087719298200002e-01,  4.5263157894700001e-01, \
                                    4.5438596491200001e-01,  4.5614035087700000e-01,  4.5789473684199999e-01, \
                                    4.5964912280699999e-01,  4.6140350877199998e-01,  4.6315789473699998e-01, \
                                    4.6491228070200002e-01,  4.6666666666700002e-01,  4.6842105263200001e-01, \
                                    4.7017543859599997e-01,  4.7192982456100002e-01,  4.7368421052600002e-01, \
                                    4.7543859649100001e-01,  4.7719298245600000e-01,  4.7894736842100000e-01, \
                                    4.8070175438599999e-01,  4.8245614035099998e-01,  4.8421052631599998e-01, \
                                    4.8596491228100003e-01,  4.8771929824600002e-01,  4.8947368421100002e-01, \
                                    4.9122807017499998e-01,  4.9298245614000002e-01,  4.9473684210500002e-01, \
                                    4.9649122807000001e-01,  4.9824561403500001e-01,  5.0000000000000000e-01, \
                                    5.0175438596499999e-01,  5.0350877192999999e-01,  5.0526315789499998e-01, \
                                    5.0701754385999998e-01,  5.0877192982499997e-01,  5.1052631578899998e-01, \
                                    5.1228070175399998e-01,  5.1403508771899997e-01,  5.1578947368399997e-01, \
                                    5.1754385964899996e-01,  5.1929824561399995e-01,  5.2105263157899995e-01, \
                                    5.2280701754400005e-01,  5.2456140350900005e-01,  5.2631578947400004e-01, \
                                    5.2807017543900003e-01,  5.2982456140400003e-01,  5.3157894736800004e-01, \
                                    5.3333333333300004e-01,  5.3508771929800003e-01,  5.3684210526300002e-01, \
                                    5.3859649122800002e-01,  5.4035087719300001e-01,  5.4210526315800001e-01, \
                                    5.4385964912300000e-01,  5.4561403508799999e-01,  5.4736842105299999e-01, \
                                    5.4912280701799998e-01,  5.5087719298200000e-01,  5.5263157894699999e-01, \
                                    5.5438596491199998e-01,  5.5614035087699998e-01,  5.5789473684199997e-01, \
                                    5.5964912280699997e-01,  5.6140350877199996e-01,  5.6315789473699995e-01, \
                                    5.6491228070199995e-01,  5.6666666666700005e-01,  5.6842105263200005e-01, \
                                    5.7017543859599995e-01,  5.7192982456100006e-01,  5.7368421052600005e-01, \
                                    5.7543859649100004e-01,  5.7719298245600004e-01,  5.7894736842100003e-01, \
                                    5.8070175438600002e-01,  5.8245614035100002e-01,  5.8421052631600001e-01, \
                                    5.8596491228100001e-01,  5.8771929824600000e-01,  5.8947368421099999e-01, \
                                    5.9122807017500001e-01,  5.9298245614000000e-01,  5.9473684210500000e-01, \
                                    5.9649122806999999e-01,  5.9824561403499998e-01,  5.9999999999999998e-01, \
                                    6.0175438596499997e-01,  6.0350877192999997e-01,  6.0526315789499996e-01, \
                                    6.0701754385999995e-01,  6.0877192982499995e-01,  6.1052631578899996e-01, \
                                    6.1228070175399996e-01,  6.1403508771899995e-01,  6.1578947368400005e-01, \
                                    6.1754385964900005e-01,  6.1929824561400004e-01,  6.2105263157900004e-01, \
                                    6.2280701754400003e-01,  6.2456140350900002e-01,  6.2631578947400002e-01, \
                                    6.2807017543900001e-01,  6.2982456140400001e-01,  6.3157894736800002e-01, \
                                    6.3333333333300001e-01,  6.3508771929800001e-01,  6.3684210526300000e-01, \
                                    6.3859649122800000e-01,  6.4035087719299999e-01,  6.4210526315799998e-01, \
                                    6.4385964912299998e-01,  6.4561403508799997e-01,  6.4736842105299996e-01, \
                                    6.4912280701799996e-01,  6.5087719298199997e-01,  6.5263157894699997e-01, \
                                    6.5438596491199996e-01,  6.5614035087699996e-01,  6.5789473684199995e-01, \
                                    6.5964912280700005e-01,  6.6140350877200005e-01,  6.6315789473700004e-01, \
                                    6.6491228070200004e-01,  6.6666666666700003e-01,  6.6842105263200002e-01, \
                                    6.7017543859600004e-01,  6.7192982456100003e-01,  6.7368421052600003e-01, \
                                    6.7543859649100002e-01,  6.7719298245600001e-01,  6.7894736842100001e-01, \
                                    6.8070175438600000e-01,  6.8245614035100000e-01,  6.8421052631599999e-01, \
                                    6.8596491228099998e-01,  6.8771929824599998e-01,  6.8947368421099997e-01, \
                                    6.9122807017499999e-01,  6.9298245613999998e-01,  6.9473684210499997e-01, \
                                    6.9649122806999997e-01,  6.9824561403499996e-01,  6.9999999999999996e-01, \
                                    7.0175438596499995e-01,  7.0350877193000005e-01,  7.0526315789500005e-01, \
                                    7.0701754386000004e-01,  7.0877192982500004e-01,  7.1052631578900005e-01, \
                                    7.1228070175400005e-01,  7.1403508771900004e-01,  7.1578947368400003e-01, \
                                    7.1754385964900003e-01,  7.1929824561400002e-01,  7.2105263157900001e-01, \
                                    7.2280701754400001e-01,  7.2456140350900000e-01,  7.2631578947400000e-01, \
                                    7.2807017543899999e-01,  7.2982456140399998e-01,  7.3157894736800000e-01, \
                                    7.3333333333299999e-01,  7.3508771929799999e-01,  7.3684210526299998e-01, \
                                    7.3859649122799997e-01,  7.4035087719299997e-01,  7.4210526315799996e-01, \
                                    7.4385964912299996e-01,  7.4561403508799995e-01,  7.4736842105300005e-01, \
                                    7.4912280701800005e-01,  7.5087719298199995e-01,  7.5263157894699995e-01, \
                                    7.5438596491200005e-01,  7.5614035087700004e-01,  7.5789473684200004e-01, \
                                    7.5964912280700003e-01,  7.6140350877200003e-01,  7.6315789473700002e-01, \
                                    7.6491228070200001e-01,  7.6666666666700001e-01,  7.6842105263200000e-01, \
                                    7.7017543859600002e-01,  7.7192982456100001e-01,  7.7368421052600000e-01, \
                                    7.7543859649100000e-01,  7.7719298245599999e-01,  7.7894736842099999e-01, \
                                    7.8070175438599998e-01,  7.8245614035099997e-01,  7.8421052631599997e-01, \
                                    7.8596491228099996e-01,  7.8771929824599995e-01,  7.8947368421099995e-01, \
                                    7.9122807017499996e-01,  7.9298245613999996e-01,  7.9473684210499995e-01, \
                                    7.9649122806999995e-01,  7.9824561403500005e-01,  8.0000000000000004e-01, \
                                    8.0175438596500004e-01,  8.0350877193000003e-01,  8.0526315789500003e-01, \
                                    8.0701754386000002e-01,  8.0877192982500001e-01,  8.1052631578900003e-01, \
                                    8.1228070175400002e-01,  8.1403508771900002e-01,  8.1578947368400001e-01, \
                                    8.1754385964900000e-01,  8.1929824561400000e-01,  8.2105263157899999e-01, \
                                    8.2280701754399999e-01,  8.2456140350899998e-01,  8.2631578947399997e-01, \
                                    8.2807017543899997e-01,  8.2982456140399996e-01,  8.3157894736799998e-01, \
                                    8.3333333333299997e-01,  8.3508771929799996e-01,  8.3684210526299996e-01, \
                                    8.3859649122799995e-01,  8.4035087719299995e-01,  8.4210526315800005e-01, \
                                    8.4385964912300004e-01,  8.4561403508800004e-01,  8.4736842105300003e-01, \
                                    8.4912280701800003e-01,  8.5087719298200004e-01,  8.5263157894700004e-01, \
                                    8.5438596491200003e-01,  8.5614035087700002e-01,  8.5789473684200002e-01, \
                                    8.5964912280700001e-01,  8.6140350877200000e-01,  8.6315789473700000e-01, \
                                    8.6491228070199999e-01,  8.6666666666699999e-01,  8.6842105263199998e-01, \
                                    8.7017543859599999e-01,  8.7192982456099999e-01,  8.7368421052599998e-01, \
                                    8.7543859649099998e-01,  8.7719298245599997e-01,  8.7894736842099996e-01, \
                                    8.8070175438599996e-01,  8.8245614035099995e-01,  8.8421052631599995e-01, \
                                    8.8596491228100005e-01,  8.8771929824600004e-01,  8.8947368421100004e-01, \
                                    8.9122807017500005e-01,  8.9298245614000005e-01,  8.9473684210500004e-01, \
                                    8.9649122807000003e-01,  8.9824561403500003e-01,  9.0000000000000002e-01, \
                                    9.0175438596500002e-01,  9.0350877193000001e-01,  9.0526315789500000e-01, \
                                    9.0701754386000000e-01,  9.0877192982499999e-01,  9.1052631578900001e-01, \
                                    9.1228070175400000e-01,  9.1403508771899999e-01,  9.1578947368399999e-01, \
                                    9.1754385964899998e-01,  9.1929824561399998e-01,  9.2105263157899997e-01, \
                                    9.2280701754399996e-01,  9.2456140350899996e-01,  9.2631578947399995e-01, \
                                    9.2807017543899994e-01,  9.2982456140400005e-01,  9.3157894736799995e-01, \
                                    9.3333333333299995e-01,  9.3508771929800005e-01,  9.3684210526300005e-01, \
                                    9.3859649122800004e-01,  9.4035087719300003e-01,  9.4210526315800003e-01, \
                                    9.4385964912300002e-01,  9.4561403508800002e-01,  9.4736842105300001e-01, \
                                    9.4912280701800000e-01,  9.5087719298200002e-01,  9.5263157894700001e-01, \
                                    9.5438596491200001e-01,  9.5614035087700000e-01,  9.5789473684199999e-01, \
                                    9.5964912280699999e-01,  9.6140350877199998e-01,  9.6315789473699998e-01, \
                                    9.6491228070199997e-01,  9.6666666666699996e-01,  9.6842105263199996e-01, \
                                    9.7017543859599997e-01,  9.7192982456099997e-01,  9.7368421052599996e-01, \
                                    9.7543859649099995e-01,  9.7719298245599995e-01,  9.7894736842100005e-01, \
                                    9.8070175438600005e-01,  9.8245614035100004e-01,  9.8421052631600003e-01, \
                                    9.8596491228100003e-01,  9.8771929824600002e-01,  9.8947368421100002e-01, \
                                    9.9122807017500003e-01,  9.9298245614000002e-01,  9.9473684210500002e-01, \
                                    9.9649122807000001e-01,  9.9824561403500001e-01,  1.0000000000000000e+00, \
                                    -1.0000000000000000e+00, -9.9849624060200004e-01, -9.9699248120299999e-01, \
                                    -9.9548872180500003e-01, -9.9398496240599998e-01, -9.9248120300800002e-01, \
                                    -9.9097744360899997e-01, -9.8947368421100002e-01, -9.8796992481199997e-01, \
                                    -9.8646616541400001e-01, -9.8496240601499996e-01, -9.8345864661700000e-01, \
                                    -9.8195488721799995e-01, -9.8045112781999999e-01, -9.7894736842100005e-01, \
                                    -9.7744360902299998e-01, -9.7593984962400004e-01, -9.7443609022599997e-01, \
                                    -9.7293233082700004e-01, -9.7142857142899997e-01, -9.6992481203000003e-01, \
                                    -9.6842105263199996e-01, -9.6691729323300002e-01, -9.6541353383499995e-01, \
                                    -9.6390977443600001e-01, -9.6240601503800005e-01, -9.6090225563900000e-01, \
                                    -9.5939849624100004e-01, -9.5789473684199999e-01, -9.5639097744400003e-01, \
                                    -9.5488721804499999e-01, -9.5338345864700003e-01, -9.5187969924799998e-01, \
                                    -9.5037593985000002e-01, -9.4887218045099997e-01, -9.4736842105300001e-01, \
                                    -9.4586466165399996e-01, -9.4436090225600000e-01, -9.4285714285699995e-01, \
                                    -9.4135338345899999e-01, -9.3984962406000006e-01, -9.3834586466199998e-01, \
                                    -9.3684210526300005e-01, -9.3533834586499998e-01, -9.3383458646600004e-01, \
                                    -9.3233082706799997e-01, -9.3082706766900003e-01, -9.2932330827099996e-01, \
                                    -9.2781954887200002e-01, -9.2631578947399995e-01, -9.2481203007500001e-01, \
                                    -9.2330827067700005e-01, -9.2180451127800000e-01, -9.2030075188000005e-01, \
                                    -9.1879699248100000e-01, -9.1729323308300004e-01, -9.1578947368399999e-01, \
                                    -9.1428571428600003e-01, -9.1278195488699998e-01, -9.1127819548900002e-01, \
                                    -9.0977443608999997e-01, -9.0827067669200001e-01, -9.0676691729299996e-01, \
                                    -9.0526315789500000e-01, -9.0375939849599995e-01, -9.0225563909800000e-01, \
                                    -9.0075187969899995e-01, -8.9924812030099999e-01, -8.9774436090200005e-01, \
                                    -8.9624060150399998e-01, -8.9473684210500004e-01, -8.9323308270699997e-01, \
                                    -8.9172932330800003e-01, -8.9022556390999996e-01, -8.8872180451100002e-01, \
                                    -8.8721804511299995e-01, -8.8571428571400002e-01, -8.8421052631599995e-01, \
                                    -8.8270676691700001e-01, -8.8120300751900005e-01, -8.7969924812000000e-01, \
                                    -8.7819548872200004e-01, -8.7669172932299999e-01, -8.7518796992500003e-01, \
                                    -8.7368421052599998e-01, -8.7218045112800002e-01, -8.7067669172899997e-01, \
                                    -8.6917293233100001e-01, -8.6766917293199997e-01, -8.6616541353400001e-01, \
                                    -8.6466165413499996e-01, -8.6315789473700000e-01, -8.6165413533799995e-01, \
                                    -8.6015037593999999e-01, -8.5864661654100005e-01, -8.5714285714299998e-01, \
                                    -8.5563909774400004e-01, -8.5413533834599997e-01, -8.5263157894700004e-01, \
                                    -8.5112781954899996e-01, -8.4962406015000003e-01, -8.4812030075199996e-01, \
                                    -8.4661654135300002e-01, -8.4511278195499995e-01, -8.4360902255600001e-01, \
                                    -8.4210526315800005e-01, -8.4060150375900000e-01, -8.3909774436100004e-01, \
                                    -8.3759398496199999e-01, -8.3609022556400003e-01, -8.3458646616499998e-01, \
                                    -8.3308270676700003e-01, -8.3157894736799998e-01, -8.3007518797000002e-01, \
                                    -8.2857142857099997e-01, -8.2706766917300001e-01, -8.2556390977399996e-01, \
                                    -8.2406015037600000e-01, -8.2255639097699995e-01, -8.2105263157899999e-01, \
                                    -8.1954887218000005e-01, -8.1804511278199998e-01, -8.1654135338300005e-01, \
                                    -8.1503759398499998e-01, -8.1353383458600004e-01, -8.1203007518799997e-01, \
                                    -8.1052631578900003e-01, -8.0902255639099996e-01, -8.0751879699200002e-01, \
                                    -8.0601503759399995e-01, -8.0451127819500001e-01, -8.0300751879700005e-01, \
                                    -8.0150375939800000e-01, -8.0000000000000004e-01, -7.9849624060199997e-01, \
                                    -7.9699248120300004e-01, -7.9548872180499997e-01, -7.9398496240600003e-01, \
                                    -7.9248120300799996e-01, -7.9097744360900002e-01, -7.8947368421099995e-01, \
                                    -7.8796992481200001e-01, -7.8646616541400005e-01, -7.8496240601500000e-01, \
                                    -7.8345864661700004e-01, -7.8195488721799999e-01, -7.8045112782000003e-01, \
                                    -7.7894736842099999e-01, -7.7744360902300003e-01, -7.7593984962399998e-01, \
                                    -7.7443609022600002e-01, -7.7293233082699997e-01, -7.7142857142900001e-01, \
                                    -7.6992481202999996e-01, -7.6842105263200000e-01, -7.6691729323299995e-01, \
                                    -7.6541353383499999e-01, -7.6390977443600006e-01, -7.6240601503799998e-01, \
                                    -7.6090225563900005e-01, -7.5939849624099998e-01, -7.5789473684200004e-01, \
                                    -7.5639097744399997e-01, -7.5488721804500003e-01, -7.5338345864699996e-01, \
                                    -7.5187969924800002e-01, -7.5037593984999995e-01, -7.4887218045100001e-01, \
                                    -7.4736842105300005e-01, -7.4586466165400001e-01, -7.4436090225600005e-01, \
                                    -7.4285714285700000e-01, -7.4135338345900004e-01, -7.3984962405999999e-01, \
                                    -7.3834586466200003e-01, -7.3684210526299998e-01, -7.3533834586500002e-01, \
                                    -7.3383458646599997e-01, -7.3233082706800001e-01, -7.3082706766899996e-01, \
                                    -7.2932330827100000e-01, -7.2781954887199996e-01, -7.2631578947400000e-01, \
                                    -7.2481203007499995e-01, -7.2330827067699999e-01, -7.2180451127800005e-01, \
                                    -7.2030075187999998e-01, -7.1879699248100004e-01, -7.1729323308299997e-01, \
                                    -7.1578947368400003e-01, -7.1428571428599996e-01, -7.1278195488700002e-01, \
                                    -7.1127819548899995e-01, -7.0977443609000002e-01, -7.0827067669199995e-01, \
                                    -7.0676691729300001e-01, -7.0526315789500005e-01, -7.0375939849600000e-01, \
                                    -7.0225563909800004e-01, -7.0075187969899999e-01, -6.9924812030100003e-01, \
                                    -6.9774436090199998e-01, -6.9624060150400002e-01, -6.9473684210499997e-01, \
                                    -6.9323308270700001e-01, -6.9172932330799997e-01, -6.9022556391000001e-01, \
                                    -6.8872180451099996e-01, -6.8721804511300000e-01, -6.8571428571399995e-01, \
                                    -6.8421052631599999e-01, -6.8270676691700005e-01, -6.8120300751899998e-01, \
                                    -6.7969924812000004e-01, -6.7819548872199997e-01, -6.7669172932300004e-01, \
                                    -6.7518796992499996e-01, -6.7368421052600003e-01, -6.7218045112799996e-01, \
                                    -6.7067669172900002e-01, -6.6917293233099995e-01, -6.6766917293200001e-01, \
                                    -6.6616541353400005e-01, -6.6466165413500000e-01, -6.6315789473700004e-01, \
                                    -6.6165413533799999e-01, -6.6015037594000003e-01, -6.5864661654099999e-01, \
                                    -6.5714285714300003e-01, -6.5563909774399998e-01, -6.5413533834600002e-01, \
                                    -6.5263157894699997e-01, -6.5112781954900001e-01, -6.4962406014999996e-01, \
                                    -6.4812030075200000e-01, -6.4661654135299995e-01, -6.4511278195499999e-01, \
                                    -6.4360902255600005e-01, -6.4210526315799998e-01, -6.4060150375900005e-01, \
                                    -6.3909774436099998e-01, -6.3759398496200004e-01, -6.3609022556399997e-01, \
                                    -6.3458646616500003e-01, -6.3308270676699996e-01, -6.3157894736800002e-01, \
                                    -6.3007518796999995e-01, -6.2857142857100001e-01, -6.2706766917300005e-01, \
                                    -6.2556390977400000e-01, -6.2406015037600004e-01, -6.2255639097700000e-01, \
                                    -6.2105263157900004e-01, -6.1954887217999999e-01, -6.1804511278200003e-01, \
                                    -6.1654135338299998e-01, -6.1503759398500002e-01, -6.1353383458599997e-01, \
                                    -6.1203007518800001e-01, -6.1052631578899996e-01, -6.0902255639100000e-01, \
                                    -6.0751879699199995e-01, -6.0601503759399999e-01, -6.0451127819499995e-01, \
                                    -6.0300751879699999e-01, -6.0150375939800005e-01, -5.9999999999999998e-01, \
                                    -5.9849624060200002e-01, -5.9699248120299997e-01, -5.9548872180500001e-01, \
                                    -5.9398496240599996e-01, -5.9248120300800000e-01, -5.9097744360899995e-01, \
                                    -5.8947368421099999e-01, -5.8796992481200006e-01, -5.8646616541399998e-01, \
                                    -5.8496240601500005e-01, -5.8345864661699998e-01, -5.8195488721800004e-01, \
                                    -5.8045112781999997e-01, -5.7894736842100003e-01, -5.7744360902299996e-01, \
                                    -5.7593984962400002e-01, -5.7443609022599995e-01, -5.7293233082700001e-01, \
                                    -5.7142857142900005e-01, -5.6992481203000001e-01, -5.6842105263200005e-01, \
                                    -5.6691729323300000e-01, -5.6541353383500004e-01, -5.6390977443599999e-01, \
                                    -5.6240601503800003e-01, -5.6090225563899998e-01, -5.5939849624100002e-01, \
                                    -5.5789473684199997e-01, -5.5639097744400001e-01, -5.5488721804499996e-01, \
                                    -5.5338345864700000e-01, -5.5187969924799996e-01, -5.5037593985000000e-01, \
                                    -5.4887218045099995e-01, -5.4736842105299999e-01, -5.4586466165400005e-01, \
                                    -5.4436090225599998e-01, -5.4285714285700004e-01, -5.4135338345899997e-01, \
                                    -5.3984962406000003e-01, -5.3834586466199996e-01, -5.3684210526300002e-01, \
                                    -5.3533834586499995e-01, -5.3383458646600002e-01, -5.3233082706799995e-01, \
                                    -5.3082706766900001e-01, -5.2932330827100005e-01, -5.2781954887200000e-01, \
                                    -5.2631578947400004e-01, -5.2481203007499999e-01, -5.2330827067700003e-01, \
                                    -5.2180451127799998e-01, -5.2030075188000002e-01, -5.1879699248099997e-01, \
                                    -5.1729323308300001e-01, -5.1578947368399997e-01, -5.1428571428600001e-01, \
                                    -5.1278195488699996e-01, -5.1127819548900000e-01, -5.0977443608999995e-01, \
                                    -5.0827067669199999e-01, -5.0676691729300005e-01, -5.0526315789499998e-01, \
                                    -5.0375939849600004e-01, -5.0225563909799997e-01, -5.0075187969900004e-01, \
                                    -4.9924812030100002e-01, -4.9774436090200003e-01, -4.9624060150400001e-01, \
                                    -4.9473684210500002e-01, -4.9323308270700000e-01, -4.9172932330800001e-01, \
                                    -4.9022556391000000e-01, -4.8872180451100000e-01, -4.8721804511299999e-01, \
                                    -4.8571428571399999e-01, -4.8421052631599998e-01, -4.8270676691699999e-01, \
                                    -4.8120300751900003e-01, -4.7969924811999998e-01, -4.7819548872200002e-01, \
                                    -4.7669172932300002e-01, -4.7518796992500001e-01, -4.7368421052600002e-01, \
                                    -4.7218045112800000e-01, -4.7067669172900001e-01, -4.6917293233099999e-01, \
                                    -4.6766917293200000e-01, -4.6616541353399998e-01, -4.6466165413499999e-01, \
                                    -4.6315789473699998e-01, -4.6165413533799998e-01, -4.6015037594000002e-01, \
                                    -4.5864661654099997e-01, -4.5714285714300001e-01, -4.5563909774400002e-01, \
                                    -4.5413533834600001e-01, -4.5263157894700001e-01, -4.5112781954900000e-01, \
                                    -4.4962406015000000e-01, -4.4812030075199999e-01, -4.4661654135300000e-01, \
                                    -4.4511278195499998e-01, -4.4360902255599999e-01, -4.4210526315799997e-01, \
                                    -4.4060150375899998e-01, -4.3909774436100002e-01, -4.3759398496200003e-01, \
                                    -4.3609022556400001e-01, -4.3458646616500002e-01, -4.3308270676700000e-01, \
                                    -4.3157894736800001e-01, -4.3007518796999999e-01, -4.2857142857100000e-01, \
                                    -4.2706766917299999e-01, -4.2556390977399999e-01, -4.2406015037599998e-01, \
                                    -4.2255639097699998e-01, -4.2105263157900003e-01, -4.1954887217999998e-01, \
                                    -4.1804511278200002e-01, -4.1654135338300002e-01, -4.1503759398500001e-01, \
                                    -4.1353383458600002e-01, -4.1203007518800000e-01, -4.1052631578900001e-01, \
                                    -4.0902255639099999e-01, -4.0751879699200000e-01, -4.0601503759399998e-01, \
                                    -4.0451127819499999e-01, -4.0300751879699998e-01, -4.0150375939900002e-01, \
                                    -4.0000000000000002e-01, -3.9849624060200001e-01, -3.9699248120300001e-01, \
                                    -3.9548872180500000e-01, -3.9398496240600001e-01, -3.9248120300799999e-01, \
                                    -3.9097744360900000e-01, -3.8947368421099998e-01, -3.8796992481199999e-01, \
                                    -3.8646616541399997e-01, -3.8496240601499998e-01, -3.8345864661700002e-01, \
                                    -3.8195488721800003e-01, -3.8045112782000001e-01, -3.7894736842100002e-01, \
                                    -3.7744360902300000e-01, -3.7593984962400001e-01, -3.7443609022600000e-01, \
                                    -3.7293233082700000e-01, -3.7142857142899999e-01, -3.6992481202999999e-01, \
                                    -3.6842105263199998e-01, -3.6691729323299999e-01, -3.6541353383500003e-01, \
                                    -3.6390977443599998e-01, -3.6240601503800002e-01, -3.6090225563900002e-01, \
                                    -3.5939849624100001e-01, -3.5789473684200002e-01, -3.5639097744400000e-01, \
                                    -3.5488721804500001e-01, -3.5338345864699999e-01, -3.5187969924800000e-01, \
                                    -3.5037593984999998e-01, -3.4887218045099999e-01, -3.4736842105299998e-01, \
                                    -3.4586466165399998e-01, -3.4436090225600002e-01, -3.4285714285699997e-01, \
                                    -3.4135338345900001e-01, -3.3984962406000002e-01, -3.3834586466200001e-01, \
                                    -3.3684210526300001e-01, -3.3533834586500000e-01, -3.3383458646600001e-01, \
                                    -3.3233082706799999e-01, -3.3082706766900000e-01, -3.2932330827099998e-01, \
                                    -3.2781954887199999e-01, -3.2631578947399997e-01, -3.2481203007499998e-01, \
                                    -3.2330827067700002e-01, -3.2180451127800003e-01, -3.2030075188000001e-01, \
                                    -3.1879699248100002e-01, -3.1729323308300000e-01, -3.1578947368400001e-01, \
                                    -3.1428571428600000e-01, -3.1278195488700000e-01, -3.1127819548899999e-01, \
                                    -3.0977443608999999e-01, -3.0827067669199998e-01, -3.0676691729299999e-01, \
                                    -3.0526315789500003e-01, -3.0375939849599998e-01, -3.0225563909800002e-01, \
                                    -3.0075187969900002e-01, -2.9924812030100001e-01, -2.9774436090200002e-01, \
                                    -2.9624060150400000e-01, -2.9473684210500001e-01, -2.9323308270699999e-01, \
                                    -2.9172932330800000e-01, -2.9022556390999998e-01, -2.8872180451099999e-01, \
                                    -2.8721804511299998e-01, -2.8571428571399998e-01, -2.8421052631600002e-01, \
                                    -2.8270676691699997e-01, -2.8120300751900001e-01, -2.7969924812000002e-01, \
                                    -2.7819548872200001e-01, -2.7669172932300001e-01, -2.7518796992500000e-01, \
                                    -2.7368421052600000e-01, -2.7218045112799999e-01, -2.7067669172900000e-01, \
                                    -2.6917293233099998e-01, -2.6766917293199999e-01, -2.6616541353399997e-01, \
                                    -2.6466165413499998e-01, -2.6315789473700002e-01, -2.6165413533800003e-01, \
                                    -2.6015037594000001e-01, -2.5864661654100002e-01, -2.5714285714300000e-01, \
                                    -2.5563909774400001e-01, -2.5413533834599999e-01, -2.5263157894700000e-01, \
                                    -2.5112781954899999e-01, -2.4962406014999999e-01, -2.4812030075200001e-01, \
                                    -2.4661654135300001e-01, -2.4511278195500000e-01, -2.4360902255600000e-01, \
                                    -2.4210526315799999e-01, -2.4060150375900000e-01, -2.3909774436100001e-01, \
                                    -2.3759398496199999e-01, -2.3609022556400000e-01, -2.3458646616500001e-01, \
                                    -2.3308270676699999e-01, -2.3157894736800000e-01, -2.3007518797000001e-01, \
                                    -2.2857142857099999e-01, -2.2706766917300000e-01, -2.2556390977400001e-01, \
                                    -2.2406015037599999e-01, -2.2255639097700000e-01, -2.2105263157899999e-01, \
                                    -2.1954887217999999e-01, -2.1804511278200001e-01, -2.1654135338300001e-01, \
                                    -2.1503759398500000e-01, -2.1353383458600000e-01, -2.1203007518799999e-01, \
                                    -2.1052631578900000e-01, -2.0902255639100001e-01, -2.0751879699199999e-01, \
                                    -2.0601503759400000e-01, -2.0451127819500001e-01, -2.0300751879699999e-01, \
                                    -2.0150375939900000e-01, -2.0000000000000001e-01, -1.9849624060200000e-01, \
                                    -1.9699248120300000e-01, -1.9548872180499999e-01, -1.9398496240599999e-01, \
                                    -1.9248120300800001e-01, -1.9097744360900001e-01, -1.8947368421100000e-01, \
                                    -1.8796992481200001e-01, -1.8646616541399999e-01, -1.8496240601500000e-01, \
                                    -1.8345864661700001e-01, -1.8195488721799999e-01, -1.8045112782000000e-01, \
                                    -1.7894736842100001e-01, -1.7744360902299999e-01, -1.7593984962400000e-01, \
                                    -1.7443609022600001e-01, -1.7293233082699999e-01, -1.7142857142900000e-01, \
                                    -1.6992481203000001e-01, -1.6842105263200000e-01, -1.6691729323300000e-01, \
                                    -1.6541353383499999e-01, -1.6390977443599999e-01, -1.6240601503800001e-01, \
                                    -1.6090225563900001e-01, -1.5939849624100000e-01, -1.5789473684200001e-01, \
                                    -1.5639097744399999e-01, -1.5488721804500000e-01, -1.5338345864700001e-01, \
                                    -1.5187969924799999e-01, -1.5037593985000000e-01, -1.4887218045100001e-01, \
                                    -1.4736842105299999e-01, -1.4586466165400000e-01, -1.4436090225600001e-01, \
                                    -1.4285714285699999e-01, -1.4135338345900000e-01, -1.3984962406000001e-01, \
                                    -1.3834586466200000e-01, -1.3684210526300000e-01, -1.3533834586499999e-01, \
                                    -1.3383458646599999e-01, -1.3233082706800001e-01, -1.3082706766900001e-01, \
                                    -1.2932330827100000e-01, -1.2781954887200001e-01, -1.2631578947399999e-01, \
                                    -1.2481203007500000e-01, -1.2330827067700000e-01, -1.2180451127800000e-01, \
                                    -1.2030075188000000e-01, -1.1879699248099999e-01, -1.1729323308300001e-01, \
                                    -1.1578947368400000e-01, -1.1428571428600000e-01, -1.1278195488700000e-01, \
                                    -1.1127819548900000e-01, -1.0977443609000000e-01, -1.0827067669200000e-01, \
                                    -1.0676691729300000e-01, -1.0526315789500000e-01, -1.0375939849599999e-01, \
                                    -1.0225563909800001e-01, -1.0075187969900000e-01, -9.9248120300999998e-02, \
                                    -9.7744360902000005e-02, -9.6240601504000003e-02, -9.4736842104999996e-02, \
                                    -9.3233082706999995e-02, -9.1729323308000002e-02, -9.0225563910000001e-02, \
                                    -8.8721804510999994e-02, -8.7218045113000006e-02, -8.5714285713999999e-02, \
                                    -8.4210526315999998e-02, -8.2706766917000005e-02, -8.1203007519000003e-02, \
                                    -7.9699248119999996e-02, -7.8195488721999995e-02, -7.6691729323000002e-02, \
                                    -7.5187969925000001e-02, -7.3684210525999994e-02, -7.2180451128000006e-02, \
                                    -7.0676691728999999e-02, -6.9172932330999998e-02, -6.7669172932000005e-02, \
                                    -6.6165413534000003e-02, -6.4661654134999996e-02, -6.3157894736999995e-02, \
                                    -6.1654135338000002e-02, -6.0150375940000000e-02, -5.8646616541000000e-02, \
                                    -5.7142857142999999e-02, -5.5639097743999999e-02, -5.4135338345999998e-02, \
                                    -5.2631578946999998e-02, -5.1127819549000003e-02, -4.9624060150000003e-02, \
                                    -4.8120300752000002e-02, -4.6616541353000002e-02, -4.5112781955000000e-02, \
                                    -4.3609022556000000e-02, -4.2105263157999999e-02, -4.0601503758999999e-02, \
                                    -3.9097744360999998e-02, -3.7593984961999997e-02, -3.6090225564000003e-02, \
                                    -3.4586466165000003e-02, -3.3082706767000002e-02, -3.1578947368000002e-02, \
                                    -3.0075187970000000e-02, -2.8571428571000000e-02, -2.7067669172999999e-02, \
                                    -2.5563909773999999e-02, -2.4060150376000001e-02, -2.2556390977000001e-02, \
                                    -2.1052631578999999e-02, -1.9548872179999999e-02, -1.8045112782000002e-02, \
                                    -1.6541353383000001e-02, -1.5037593985000000e-02, -1.3533834586000000e-02, \
                                    -1.2030075188000000e-02, -1.0526315789000000e-02, -9.0225563910000008e-03, \
                                    -7.5187969919999998e-03, -6.0150375940000002e-03, -4.5112781950000002e-03, \
                                    -3.0075187970000001e-03, -1.5037593990000001e-03,  0.0000000000000000e+00, \
                                    1.5037593980000001e-03,  3.0075187970000001e-03,  4.5112781950000002e-03, \
                                    6.0150375940000002e-03,  7.5187969919999998e-03,  9.0225563910000008e-03, \
                                    1.0526315789000000e-02,  1.2030075188000000e-02,  1.3533834586000000e-02, \
                                    1.5037593985000000e-02,  1.6541353383000001e-02,  1.8045112782000002e-02, \
                                    1.9548872179999999e-02,  2.1052631578999999e-02,  2.2556390977000001e-02, \
                                    2.4060150376000001e-02,  2.5563909773999999e-02,  2.7067669172999999e-02, \
                                    2.8571428571000000e-02,  3.0075187970000000e-02,  3.1578947368000002e-02, \
                                    3.3082706767000002e-02,  3.4586466165000003e-02,  3.6090225564000003e-02, \
                                    3.7593984961999997e-02,  3.9097744360999998e-02,  4.0601503758999999e-02, \
                                    4.2105263157999999e-02,  4.3609022556000000e-02,  4.5112781955000000e-02, \
                                    4.6616541353000002e-02,  4.8120300752000002e-02,  4.9624060150000003e-02, \
                                    5.1127819549000003e-02,  5.2631578946999998e-02,  5.4135338345999998e-02, \
                                    5.5639097743999999e-02,  5.7142857142999999e-02,  5.8646616541000000e-02, \
                                    6.0150375940000000e-02,  6.1654135338000002e-02,  6.3157894736999995e-02, \
                                    6.4661654134999996e-02,  6.6165413534000003e-02,  6.7669172932000005e-02, \
                                    6.9172932330999998e-02,  7.0676691728999999e-02,  7.2180451128000006e-02, \
                                    7.3684210525999994e-02,  7.5187969925000001e-02,  7.6691729323000002e-02, \
                                    7.8195488721999995e-02,  7.9699248119999996e-02,  8.1203007519000003e-02, \
                                    8.2706766917000005e-02,  8.4210526315999998e-02,  8.5714285713999999e-02, \
                                    8.7218045113000006e-02,  8.8721804510999994e-02,  9.0225563910000001e-02, \
                                    9.1729323308000002e-02,  9.3233082706999995e-02,  9.4736842104999996e-02, \
                                    9.6240601504000003e-02,  9.7744360902000005e-02,  9.9248120300999998e-02, \
                                    1.0075187969900000e-01,  1.0225563909800001e-01,  1.0375939849599999e-01, \
                                    1.0526315789500000e-01,  1.0676691729300000e-01,  1.0827067669200000e-01, \
                                    1.0977443609000000e-01,  1.1127819548900000e-01,  1.1278195488700000e-01, \
                                    1.1428571428600000e-01,  1.1578947368400000e-01,  1.1729323308300001e-01, \
                                    1.1879699248099999e-01,  1.2030075188000000e-01,  1.2180451127800000e-01, \
                                    1.2330827067700000e-01,  1.2481203007500000e-01,  1.2631578947399999e-01, \
                                    1.2781954887200001e-01,  1.2932330827100000e-01,  1.3082706766900001e-01, \
                                    1.3233082706800001e-01,  1.3383458646599999e-01,  1.3533834586499999e-01, \
                                    1.3684210526300000e-01,  1.3834586466200000e-01,  1.3984962406000001e-01, \
                                    1.4135338345900000e-01,  1.4285714285699999e-01,  1.4436090225600001e-01, \
                                    1.4586466165400000e-01,  1.4736842105299999e-01,  1.4887218045100001e-01, \
                                    1.5037593985000000e-01,  1.5187969924799999e-01,  1.5338345864700001e-01, \
                                    1.5488721804500000e-01,  1.5639097744399999e-01,  1.5789473684200001e-01, \
                                    1.5939849624100000e-01,  1.6090225563900001e-01,  1.6240601503800001e-01, \
                                    1.6390977443599999e-01,  1.6541353383499999e-01,  1.6691729323300000e-01, \
                                    1.6842105263200000e-01,  1.6992481203000001e-01,  1.7142857142900000e-01, \
                                    1.7293233082699999e-01,  1.7443609022600001e-01,  1.7593984962400000e-01, \
                                    1.7744360902299999e-01,  1.7894736842100001e-01,  1.8045112782000000e-01, \
                                    1.8195488721799999e-01,  1.8345864661700001e-01,  1.8496240601500000e-01, \
                                    1.8646616541399999e-01,  1.8796992481200001e-01,  1.8947368421100000e-01, \
                                    1.9097744360900001e-01,  1.9248120300800001e-01,  1.9398496240599999e-01, \
                                    1.9548872180499999e-01,  1.9699248120300000e-01,  1.9849624060099999e-01, \
                                    2.0000000000000001e-01,  2.0150375939800000e-01,  2.0300751879699999e-01, \
                                    2.0451127819500001e-01,  2.0601503759400000e-01,  2.0751879699199999e-01, \
                                    2.0902255639100001e-01,  2.1052631578900000e-01,  2.1203007518799999e-01, \
                                    2.1353383458600000e-01,  2.1503759398500000e-01,  2.1654135338300001e-01, \
                                    2.1804511278200001e-01,  2.1954887217999999e-01,  2.2105263157899999e-01, \
                                    2.2255639097700000e-01,  2.2406015037599999e-01,  2.2556390977400001e-01, \
                                    2.2706766917300000e-01,  2.2857142857099999e-01,  2.3007518797000001e-01, \
                                    2.3157894736800000e-01,  2.3308270676699999e-01,  2.3458646616500001e-01, \
                                    2.3609022556400000e-01,  2.3759398496199999e-01,  2.3909774436100001e-01, \
                                    2.4060150375900000e-01,  2.4210526315799999e-01,  2.4360902255600000e-01, \
                                    2.4511278195500000e-01,  2.4661654135300001e-01,  2.4812030075200001e-01, \
                                    2.4962406014999999e-01,  2.5112781954899999e-01,  2.5263157894700000e-01, \
                                    2.5413533834599999e-01,  2.5563909774400001e-01,  2.5714285714300000e-01, \
                                    2.5864661654100002e-01,  2.6015037594000001e-01,  2.6165413533800003e-01, \
                                    2.6315789473700002e-01,  2.6466165413499998e-01,  2.6616541353399997e-01, \
                                    2.6766917293199999e-01,  2.6917293233099998e-01,  2.7067669172900000e-01, \
                                    2.7218045112799999e-01,  2.7368421052600000e-01,  2.7518796992500000e-01, \
                                    2.7669172932300001e-01,  2.7819548872200001e-01,  2.7969924812000002e-01, \
                                    2.8120300751900001e-01,  2.8270676691699997e-01,  2.8421052631600002e-01, \
                                    2.8571428571399998e-01,  2.8721804511299998e-01,  2.8872180451099999e-01, \
                                    2.9022556390999998e-01,  2.9172932330800000e-01,  2.9323308270699999e-01, \
                                    2.9473684210500001e-01,  2.9624060150400000e-01,  2.9774436090200002e-01, \
                                    2.9924812030100001e-01,  3.0075187969900002e-01,  3.0225563909800002e-01, \
                                    3.0375939849599998e-01,  3.0526315789500003e-01,  3.0676691729299999e-01, \
                                    3.0827067669199998e-01,  3.0977443608999999e-01,  3.1127819548899999e-01, \
                                    3.1278195488700000e-01,  3.1428571428600000e-01,  3.1578947368400001e-01, \
                                    3.1729323308300000e-01,  3.1879699248100002e-01,  3.2030075188000001e-01, \
                                    3.2180451127800003e-01,  3.2330827067700002e-01,  3.2481203007499998e-01, \
                                    3.2631578947399997e-01,  3.2781954887199999e-01,  3.2932330827099998e-01, \
                                    3.3082706766900000e-01,  3.3233082706799999e-01,  3.3383458646600001e-01, \
                                    3.3533834586500000e-01,  3.3684210526300001e-01,  3.3834586466200001e-01, \
                                    3.3984962406000002e-01,  3.4135338345900001e-01,  3.4285714285699997e-01, \
                                    3.4436090225600002e-01,  3.4586466165399998e-01,  3.4736842105299998e-01, \
                                    3.4887218045099999e-01,  3.5037593984999998e-01,  3.5187969924800000e-01, \
                                    3.5338345864699999e-01,  3.5488721804500001e-01,  3.5639097744400000e-01, \
                                    3.5789473684200002e-01,  3.5939849624100001e-01,  3.6090225563900002e-01, \
                                    3.6240601503800002e-01,  3.6390977443599998e-01,  3.6541353383500003e-01, \
                                    3.6691729323299999e-01,  3.6842105263199998e-01,  3.6992481202999999e-01, \
                                    3.7142857142899999e-01,  3.7293233082700000e-01,  3.7443609022600000e-01, \
                                    3.7593984962400001e-01,  3.7744360902300000e-01,  3.7894736842100002e-01, \
                                    3.8045112782000001e-01,  3.8195488721800003e-01,  3.8345864661700002e-01, \
                                    3.8496240601499998e-01,  3.8646616541399997e-01,  3.8796992481199999e-01, \
                                    3.8947368421099998e-01,  3.9097744360900000e-01,  3.9248120300799999e-01, \
                                    3.9398496240600001e-01,  3.9548872180500000e-01,  3.9699248120300001e-01, \
                                    3.9849624060099997e-01,  4.0000000000000002e-01,  4.0150375939799998e-01, \
                                    4.0300751879699998e-01,  4.0451127819499999e-01,  4.0601503759399998e-01, \
                                    4.0751879699200000e-01,  4.0902255639099999e-01,  4.1052631578900001e-01, \
                                    4.1203007518800000e-01,  4.1353383458600002e-01,  4.1503759398500001e-01, \
                                    4.1654135338300002e-01,  4.1804511278200002e-01,  4.1954887217999998e-01, \
                                    4.2105263157900003e-01,  4.2255639097699998e-01,  4.2406015037599998e-01, \
                                    4.2556390977399999e-01,  4.2706766917299999e-01,  4.2857142857100000e-01, \
                                    4.3007518796999999e-01,  4.3157894736800001e-01,  4.3308270676700000e-01, \
                                    4.3458646616500002e-01,  4.3609022556400001e-01,  4.3759398496200003e-01, \
                                    4.3909774436100002e-01,  4.4060150375899998e-01,  4.4210526315799997e-01, \
                                    4.4360902255599999e-01,  4.4511278195499998e-01,  4.4661654135300000e-01, \
                                    4.4812030075199999e-01,  4.4962406015000000e-01,  4.5112781954900000e-01, \
                                    4.5263157894700001e-01,  4.5413533834600001e-01,  4.5563909774400002e-01, \
                                    4.5714285714300001e-01,  4.5864661654099997e-01,  4.6015037594000002e-01, \
                                    4.6165413533799998e-01,  4.6315789473699998e-01,  4.6466165413499999e-01, \
                                    4.6616541353399998e-01,  4.6766917293200000e-01,  4.6917293233099999e-01, \
                                    4.7067669172900001e-01,  4.7218045112800000e-01,  4.7368421052600002e-01, \
                                    4.7518796992500001e-01,  4.7669172932300002e-01,  4.7819548872200002e-01, \
                                    4.7969924811999998e-01,  4.8120300751900003e-01,  4.8270676691699999e-01, \
                                    4.8421052631599998e-01,  4.8571428571399999e-01,  4.8721804511299999e-01, \
                                    4.8872180451100000e-01,  4.9022556391000000e-01,  4.9172932330800001e-01, \
                                    4.9323308270700000e-01,  4.9473684210500002e-01,  4.9624060150400001e-01, \
                                    4.9774436090200003e-01,  4.9924812030100002e-01,  5.0075187969900004e-01, \
                                    5.0225563909799997e-01,  5.0375939849600004e-01,  5.0526315789499998e-01, \
                                    5.0676691729300005e-01,  5.0827067669199999e-01,  5.0977443608999995e-01, \
                                    5.1127819548900000e-01,  5.1278195488699996e-01,  5.1428571428600001e-01, \
                                    5.1578947368399997e-01,  5.1729323308300001e-01,  5.1879699248099997e-01, \
                                    5.2030075188000002e-01,  5.2180451127799998e-01,  5.2330827067700003e-01, \
                                    5.2481203007499999e-01,  5.2631578947400004e-01,  5.2781954887200000e-01, \
                                    5.2932330827100005e-01,  5.3082706766900001e-01,  5.3233082706799995e-01, \
                                    5.3383458646600002e-01,  5.3533834586499995e-01,  5.3684210526300002e-01, \
                                    5.3834586466199996e-01,  5.3984962406000003e-01,  5.4135338345899997e-01, \
                                    5.4285714285700004e-01,  5.4436090225599998e-01,  5.4586466165400005e-01, \
                                    5.4736842105299999e-01,  5.4887218045099995e-01,  5.5037593985000000e-01, \
                                    5.5187969924799996e-01,  5.5338345864700000e-01,  5.5488721804499996e-01, \
                                    5.5639097744400001e-01,  5.5789473684199997e-01,  5.5939849624100002e-01, \
                                    5.6090225563899998e-01,  5.6240601503800003e-01,  5.6390977443599999e-01, \
                                    5.6541353383500004e-01,  5.6691729323300000e-01,  5.6842105263200005e-01, \
                                    5.6992481203000001e-01,  5.7142857142900005e-01,  5.7293233082700001e-01, \
                                    5.7443609022599995e-01,  5.7593984962400002e-01,  5.7744360902299996e-01, \
                                    5.7894736842100003e-01,  5.8045112781999997e-01,  5.8195488721800004e-01, \
                                    5.8345864661699998e-01,  5.8496240601500005e-01,  5.8646616541399998e-01, \
                                    5.8796992481200006e-01,  5.8947368421099999e-01,  5.9097744360899995e-01, \
                                    5.9248120300800000e-01,  5.9398496240599996e-01,  5.9548872180500001e-01, \
                                    5.9699248120299997e-01,  5.9849624060100004e-01,  5.9999999999999998e-01, \
                                    6.0150375939800005e-01,  6.0300751879699999e-01,  6.0451127819499995e-01, \
                                    6.0601503759399999e-01,  6.0751879699199995e-01,  6.0902255639100000e-01, \
                                    6.1052631578899996e-01,  6.1203007518800001e-01,  6.1353383458599997e-01, \
                                    6.1503759398500002e-01,  6.1654135338299998e-01,  6.1804511278200003e-01, \
                                    6.1954887217999999e-01,  6.2105263157900004e-01,  6.2255639097700000e-01, \
                                    6.2406015037600004e-01,  6.2556390977400000e-01,  6.2706766917300005e-01, \
                                    6.2857142857100001e-01,  6.3007518796999995e-01,  6.3157894736800002e-01, \
                                    6.3308270676699996e-01,  6.3458646616500003e-01,  6.3609022556399997e-01, \
                                    6.3759398496200004e-01,  6.3909774436099998e-01,  6.4060150375900005e-01, \
                                    6.4210526315799998e-01,  6.4360902255600005e-01,  6.4511278195499999e-01, \
                                    6.4661654135299995e-01,  6.4812030075200000e-01,  6.4962406014999996e-01, \
                                    6.5112781954900001e-01,  6.5263157894699997e-01,  6.5413533834600002e-01, \
                                    6.5563909774399998e-01,  6.5714285714300003e-01,  6.5864661654099999e-01, \
                                    6.6015037594000003e-01,  6.6165413533799999e-01,  6.6315789473700004e-01, \
                                    6.6466165413500000e-01,  6.6616541353400005e-01,  6.6766917293200001e-01, \
                                    6.6917293233099995e-01,  6.7067669172900002e-01,  6.7218045112799996e-01, \
                                    6.7368421052600003e-01,  6.7518796992499996e-01,  6.7669172932300004e-01, \
                                    6.7819548872199997e-01,  6.7969924812000004e-01,  6.8120300751899998e-01, \
                                    6.8270676691700005e-01,  6.8421052631599999e-01,  6.8571428571399995e-01, \
                                    6.8721804511300000e-01,  6.8872180451099996e-01,  6.9022556391000001e-01, \
                                    6.9172932330799997e-01,  6.9323308270700001e-01,  6.9473684210499997e-01, \
                                    6.9624060150400002e-01,  6.9774436090199998e-01,  6.9924812030100003e-01, \
                                    7.0075187969899999e-01,  7.0225563909800004e-01,  7.0375939849600000e-01, \
                                    7.0526315789500005e-01,  7.0676691729300001e-01,  7.0827067669199995e-01, \
                                    7.0977443609000002e-01,  7.1127819548899995e-01,  7.1278195488700002e-01, \
                                    7.1428571428599996e-01,  7.1578947368400003e-01,  7.1729323308299997e-01, \
                                    7.1879699248100004e-01,  7.2030075187999998e-01,  7.2180451127800005e-01, \
                                    7.2330827067699999e-01,  7.2481203007499995e-01,  7.2631578947400000e-01, \
                                    7.2781954887199996e-01,  7.2932330827100000e-01,  7.3082706766899996e-01, \
                                    7.3233082706800001e-01,  7.3383458646599997e-01,  7.3533834586500002e-01, \
                                    7.3684210526299998e-01,  7.3834586466200003e-01,  7.3984962405999999e-01, \
                                    7.4135338345900004e-01,  7.4285714285700000e-01,  7.4436090225600005e-01, \
                                    7.4586466165400001e-01,  7.4736842105300005e-01,  7.4887218045100001e-01, \
                                    7.5037593984999995e-01,  7.5187969924800002e-01,  7.5338345864699996e-01, \
                                    7.5488721804500003e-01,  7.5639097744399997e-01,  7.5789473684200004e-01, \
                                    7.5939849624099998e-01,  7.6090225563900005e-01,  7.6240601503799998e-01, \
                                    7.6390977443600006e-01,  7.6541353383499999e-01,  7.6691729323299995e-01, \
                                    7.6842105263200000e-01,  7.6992481202999996e-01,  7.7142857142900001e-01, \
                                    7.7293233082699997e-01,  7.7443609022600002e-01,  7.7593984962399998e-01, \
                                    7.7744360902300003e-01,  7.7894736842099999e-01,  7.8045112782000003e-01, \
                                    7.8195488721799999e-01,  7.8345864661700004e-01,  7.8496240601500000e-01, \
                                    7.8646616541400005e-01,  7.8796992481200001e-01,  7.8947368421099995e-01, \
                                    7.9097744360900002e-01,  7.9248120300799996e-01,  7.9398496240600003e-01, \
                                    7.9548872180499997e-01,  7.9699248120300004e-01,  7.9849624060100000e-01, \
                                    8.0000000000000004e-01,  8.0150375939800000e-01,  8.0300751879700005e-01, \
                                    8.0451127819500001e-01,  8.0601503759399995e-01,  8.0751879699200002e-01, \
                                    8.0902255639099996e-01,  8.1052631578900003e-01,  8.1203007518799997e-01, \
                                    8.1353383458600004e-01,  8.1503759398499998e-01,  8.1654135338300005e-01, \
                                    8.1804511278199998e-01,  8.1954887218000005e-01,  8.2105263157899999e-01, \
                                    8.2255639097699995e-01,  8.2406015037600000e-01,  8.2556390977399996e-01, \
                                    8.2706766917300001e-01,  8.2857142857099997e-01,  8.3007518797000002e-01, \
                                    8.3157894736799998e-01,  8.3308270676700003e-01,  8.3458646616499998e-01, \
                                    8.3609022556400003e-01,  8.3759398496199999e-01,  8.3909774436100004e-01, \
                                    8.4060150375900000e-01,  8.4210526315800005e-01,  8.4360902255600001e-01, \
                                    8.4511278195499995e-01,  8.4661654135300002e-01,  8.4812030075199996e-01, \
                                    8.4962406015000003e-01,  8.5112781954899996e-01,  8.5263157894700004e-01, \
                                    8.5413533834599997e-01,  8.5563909774400004e-01,  8.5714285714299998e-01, \
                                    8.5864661654100005e-01,  8.6015037593999999e-01,  8.6165413533799995e-01, \
                                    8.6315789473700000e-01,  8.6466165413499996e-01,  8.6616541353400001e-01, \
                                    8.6766917293199997e-01,  8.6917293233100001e-01,  8.7067669172899997e-01, \
                                    8.7218045112800002e-01,  8.7368421052599998e-01,  8.7518796992500003e-01, \
                                    8.7669172932299999e-01,  8.7819548872200004e-01,  8.7969924812000000e-01, \
                                    8.8120300751900005e-01,  8.8270676691700001e-01,  8.8421052631599995e-01, \
                                    8.8571428571400002e-01,  8.8721804511299995e-01,  8.8872180451100002e-01, \
                                    8.9022556390999996e-01,  8.9172932330800003e-01,  8.9323308270699997e-01, \
                                    8.9473684210500004e-01,  8.9624060150399998e-01,  8.9774436090200005e-01, \
                                    8.9924812030099999e-01,  9.0075187969899995e-01,  9.0225563909800000e-01, \
                                    9.0375939849599995e-01,  9.0526315789500000e-01,  9.0676691729299996e-01, \
                                    9.0827067669200001e-01,  9.0977443608999997e-01,  9.1127819548900002e-01, \
                                    9.1278195488699998e-01,  9.1428571428600003e-01,  9.1578947368399999e-01, \
                                    9.1729323308300004e-01,  9.1879699248100000e-01,  9.2030075188000005e-01, \
                                    9.2180451127800000e-01,  9.2330827067700005e-01,  9.2481203007500001e-01, \
                                    9.2631578947399995e-01,  9.2781954887200002e-01,  9.2932330827099996e-01, \
                                    9.3082706766900003e-01,  9.3233082706799997e-01,  9.3383458646600004e-01, \
                                    9.3533834586499998e-01,  9.3684210526300005e-01,  9.3834586466199998e-01, \
                                    9.3984962406000006e-01,  9.4135338345899999e-01,  9.4285714285699995e-01, \
                                    9.4436090225600000e-01,  9.4586466165399996e-01,  9.4736842105300001e-01, \
                                    9.4887218045099997e-01,  9.5037593985000002e-01,  9.5187969924799998e-01, \
                                    9.5338345864700003e-01,  9.5488721804499999e-01,  9.5639097744400003e-01, \
                                    9.5789473684199999e-01,  9.5939849624100004e-01,  9.6090225563900000e-01, \
                                    9.6240601503800005e-01,  9.6390977443600001e-01,  9.6541353383499995e-01, \
                                    9.6691729323300002e-01,  9.6842105263199996e-01,  9.6992481203000003e-01, \
                                    9.7142857142899997e-01,  9.7293233082700004e-01,  9.7443609022599997e-01, \
                                    9.7593984962400004e-01,  9.7744360902299998e-01,  9.7894736842100005e-01, \
                                    9.8045112781999999e-01,  9.8195488721799995e-01,  9.8345864661700000e-01, \
                                    9.8496240601499996e-01,  9.8646616541400001e-01,  9.8796992481199997e-01, \
                                    9.8947368421100002e-01,  9.9097744360899997e-01,  9.9248120300800002e-01, \
                                    9.9398496240599998e-01,  9.9548872180400005e-01,  9.9699248120299999e-01, \
                                    9.9849624060099995e-01,  1.0000000000000000e+00, -1.0000000000000000e+00, \
                                    -9.9870129870100000e-01, -9.9740259740299997e-01, -9.9610389610399996e-01, \
                                    -9.9480519480499996e-01, -9.9350649350599995e-01, -9.9220779220800004e-01, \
                                    -9.9090909090900003e-01, -9.8961038961000003e-01, -9.8831168831200000e-01, \
                                    -9.8701298701300000e-01, -9.8571428571399999e-01, -9.8441558441599997e-01, \
                                    -9.8311688311699996e-01, -9.8181818181799996e-01, -9.8051948051899995e-01, \
                                    -9.7922077922100004e-01, -9.7792207792200003e-01, -9.7662337662300003e-01, \
                                    -9.7532467532500000e-01, -9.7402597402600000e-01, -9.7272727272699999e-01, \
                                    -9.7142857142899997e-01, -9.7012987012999996e-01, -9.6883116883099996e-01, \
                                    -9.6753246753199995e-01, -9.6623376623400004e-01, -9.6493506493500003e-01, \
                                    -9.6363636363600003e-01, -9.6233766233800000e-01, -9.6103896103899999e-01, \
                                    -9.5974025973999999e-01, -9.5844155844199996e-01, -9.5714285714299996e-01, \
                                    -9.5584415584399995e-01, -9.5454545454499995e-01, -9.5324675324700003e-01, \
                                    -9.5194805194800003e-01, -9.5064935064900002e-01, -9.4935064935100000e-01, \
                                    -9.4805194805199999e-01, -9.4675324675299999e-01, -9.4545454545499996e-01, \
                                    -9.4415584415599996e-01, -9.4285714285699995e-01, -9.4155844155799995e-01, \
                                    -9.4025974026000003e-01, -9.3896103896100003e-01, -9.3766233766200002e-01, \
                                    -9.3636363636400000e-01, -9.3506493506499999e-01, -9.3376623376599999e-01, \
                                    -9.3246753246799996e-01, -9.3116883116899996e-01, -9.2987012986999995e-01, \
                                    -9.2857142857099995e-01, -9.2727272727300003e-01, -9.2597402597400003e-01, \
                                    -9.2467532467500002e-01, -9.2337662337699999e-01, -9.2207792207799999e-01, \
                                    -9.2077922077899998e-01, -9.1948051948099996e-01, -9.1818181818199995e-01, \
                                    -9.1688311688299995e-01, -9.1558441558400006e-01, -9.1428571428600003e-01, \
                                    -9.1298701298700002e-01, -9.1168831168800002e-01, -9.1038961038999999e-01, \
                                    -9.0909090909099999e-01, -9.0779220779199998e-01, -9.0649350649399996e-01, \
                                    -9.0519480519499995e-01, -9.0389610389599995e-01, -9.0259740259700005e-01, \
                                    -9.0129870129900003e-01, -9.0000000000000002e-01, -8.9870129870100002e-01, \
                                    -8.9740259740299999e-01, -8.9610389610399999e-01, -8.9480519480499998e-01, \
                                    -8.9350649350599998e-01, -8.9220779220799995e-01, -8.9090909090899995e-01, \
                                    -8.8961038961000005e-01, -8.8831168831200003e-01, -8.8701298701300002e-01, \
                                    -8.8571428571400002e-01, -8.8441558441599999e-01, -8.8311688311699998e-01, \
                                    -8.8181818181799998e-01, -8.8051948051899998e-01, -8.7922077922099995e-01, \
                                    -8.7792207792200005e-01, -8.7662337662300005e-01, -8.7532467532500002e-01, \
                                    -8.7402597402600002e-01, -8.7272727272700001e-01, -8.7142857142899999e-01, \
                                    -8.7012987012999998e-01, -8.6883116883099998e-01, -8.6753246753199997e-01, \
                                    -8.6623376623399995e-01, -8.6493506493500005e-01, -8.6363636363600005e-01, \
                                    -8.6233766233800002e-01, -8.6103896103900002e-01, -8.5974025974000001e-01, \
                                    -8.5844155844199999e-01, -8.5714285714299998e-01, -8.5584415584399998e-01, \
                                    -8.5454545454499997e-01, -8.5324675324699994e-01, -8.5194805194800005e-01, \
                                    -8.5064935064900005e-01, -8.4935064935100002e-01, -8.4805194805200002e-01, \
                                    -8.4675324675300001e-01, -8.4545454545499998e-01, -8.4415584415599998e-01, \
                                    -8.4285714285699997e-01, -8.4155844155799997e-01, -8.4025974026000005e-01, \
                                    -8.3896103896100005e-01, -8.3766233766200004e-01, -8.3636363636400002e-01, \
                                    -8.3506493506500001e-01, -8.3376623376600001e-01, -8.3246753246799998e-01, \
                                    -8.3116883116899998e-01, -8.2987012986999997e-01, -8.2857142857099997e-01, \
                                    -8.2727272727300005e-01, -8.2597402597400005e-01, -8.2467532467500004e-01, \
                                    -8.2337662337700002e-01, -8.2207792207800001e-01, -8.2077922077900001e-01, \
                                    -8.1948051948099998e-01, -8.1818181818199998e-01, -8.1688311688299997e-01, \
                                    -8.1558441558399997e-01, -8.1428571428600005e-01, -8.1298701298700005e-01, \
                                    -8.1168831168800004e-01, -8.1038961039000001e-01, -8.0909090909100001e-01, \
                                    -8.0779220779200001e-01, -8.0649350649399998e-01, -8.0519480519499997e-01, \
                                    -8.0389610389599997e-01, -8.0259740259699996e-01, -8.0129870129900005e-01, \
                                    -8.0000000000000004e-01, -7.9870129870100004e-01, -7.9740259740300001e-01, \
                                    -7.9610389610400001e-01, -7.9480519480500000e-01, -7.9350649350699998e-01, \
                                    -7.9220779220799997e-01, -7.9090909090899997e-01, -7.8961038960999996e-01, \
                                    -7.8831168831200005e-01, -7.8701298701300004e-01, -7.8571428571400004e-01, \
                                    -7.8441558441600001e-01, -7.8311688311700001e-01, -7.8181818181800000e-01, \
                                    -7.8051948051900000e-01, -7.7922077922099997e-01, -7.7792207792199997e-01, \
                                    -7.7662337662299996e-01, -7.7532467532500005e-01, -7.7402597402600004e-01, \
                                    -7.7272727272700004e-01, -7.7142857142900001e-01, -7.7012987013000000e-01, \
                                    -7.6883116883100000e-01, -7.6753246753200000e-01, -7.6623376623399997e-01, \
                                    -7.6493506493499996e-01, -7.6363636363599996e-01, -7.6233766233800004e-01, \
                                    -7.6103896103900004e-01, -7.5974025974000003e-01, -7.5844155844200001e-01, \
                                    -7.5714285714300000e-01, -7.5584415584400000e-01, -7.5454545454499999e-01, \
                                    -7.5324675324699997e-01, -7.5194805194799996e-01, -7.5064935064899996e-01, \
                                    -7.4935064935100004e-01, -7.4805194805200004e-01, -7.4675324675300003e-01, \
                                    -7.4545454545500001e-01, -7.4415584415600000e-01, -7.4285714285700000e-01, \
                                    -7.4155844155799999e-01, -7.4025974025999997e-01, -7.3896103896099996e-01, \
                                    -7.3766233766199996e-01, -7.3636363636400004e-01, -7.3506493506500004e-01, \
                                    -7.3376623376600003e-01, -7.3246753246800000e-01, -7.3116883116900000e-01, \
                                    -7.2987012987000000e-01, -7.2857142857099999e-01, -7.2727272727299996e-01, \
                                    -7.2597402597399996e-01, -7.2467532467499995e-01, -7.2337662337700004e-01, \
                                    -7.2207792207800003e-01, -7.2077922077900003e-01, -7.1948051948100000e-01, \
                                    -7.1818181818200000e-01, -7.1688311688299999e-01, -7.1558441558399999e-01, \
                                    -7.1428571428599996e-01, -7.1298701298699996e-01, -7.1168831168799995e-01, \
                                    -7.1038961039000004e-01, -7.0909090909100003e-01, -7.0779220779200003e-01, \
                                    -7.0649350649400000e-01, -7.0519480519500000e-01, -7.0389610389599999e-01, \
                                    -7.0259740259699999e-01, -7.0129870129899996e-01, -6.9999999999999996e-01, \
                                    -6.9870129870099995e-01, -6.9740259740300004e-01, -6.9610389610400003e-01, \
                                    -6.9480519480500003e-01, -6.9350649350700000e-01, -6.9220779220799999e-01, \
                                    -6.9090909090899999e-01, -6.8961038960999999e-01, -6.8831168831199996e-01, \
                                    -6.8701298701299995e-01, -6.8571428571399995e-01, -6.8441558441600003e-01, \
                                    -6.8311688311700003e-01, -6.8181818181800002e-01, -6.8051948051900002e-01, \
                                    -6.7922077922099999e-01, -6.7792207792199999e-01, -6.7662337662299998e-01, \
                                    -6.7532467532499996e-01, -6.7402597402599995e-01, -6.7272727272699995e-01, \
                                    -6.7142857142900003e-01, -6.7012987013000003e-01, -6.6883116883100002e-01, \
                                    -6.6753246753200002e-01, -6.6623376623399999e-01, -6.6493506493499999e-01, \
                                    -6.6363636363599998e-01, -6.6233766233799996e-01, -6.6103896103899995e-01, \
                                    -6.5974025973999995e-01, -6.5844155844200003e-01, -6.5714285714300003e-01, \
                                    -6.5584415584400002e-01, -6.5454545454500002e-01, -6.5324675324699999e-01, \
                                    -6.5194805194799998e-01, -6.5064935064899998e-01, -6.4935064935099995e-01, \
                                    -6.4805194805199995e-01, -6.4675324675300006e-01, -6.4545454545500003e-01, \
                                    -6.4415584415600002e-01, -6.4285714285700002e-01, -6.4155844155800001e-01, \
                                    -6.4025974025999999e-01, -6.3896103896099998e-01, -6.3766233766199998e-01, \
                                    -6.3636363636399995e-01, -6.3506493506499995e-01, -6.3376623376600005e-01, \
                                    -6.3246753246800003e-01, -6.3116883116900002e-01, -6.2987012987000002e-01, \
                                    -6.2857142857100001e-01, -6.2727272727299999e-01, -6.2597402597399998e-01, \
                                    -6.2467532467499998e-01, -6.2337662337699995e-01, -6.2207792207799995e-01, \
                                    -6.2077922077900005e-01, -6.1948051948100002e-01, -6.1818181818200002e-01, \
                                    -6.1688311688300002e-01, -6.1558441558400001e-01, -6.1428571428599998e-01, \
                                    -6.1298701298699998e-01, -6.1168831168799997e-01, -6.1038961038999995e-01, \
                                    -6.0909090909100005e-01, -6.0779220779200005e-01, -6.0649350649400002e-01, \
                                    -6.0519480519500002e-01, -6.0389610389600001e-01, -6.0259740259700001e-01, \
                                    -6.0129870129899998e-01, -5.9999999999999998e-01, -5.9870129870099997e-01, \
                                    -5.9740259740299995e-01, -5.9610389610400005e-01, -5.9480519480500005e-01, \
                                    -5.9350649350700002e-01, -5.9220779220800002e-01, -5.9090909090900001e-01, \
                                    -5.8961038961000001e-01, -5.8831168831199998e-01, -5.8701298701299998e-01, \
                                    -5.8571428571399997e-01, -5.8441558441599994e-01, -5.8311688311700005e-01, \
                                    -5.8181818181800005e-01, -5.8051948051900004e-01, -5.7922077922100002e-01, \
                                    -5.7792207792200001e-01, -5.7662337662300001e-01, -5.7532467532499998e-01, \
                                    -5.7402597402599997e-01, -5.7272727272699997e-01, -5.7142857142900005e-01, \
                                    -5.7012987013000005e-01, -5.6883116883100004e-01, -5.6753246753200004e-01, \
                                    -5.6623376623400001e-01, -5.6493506493500001e-01, -5.6363636363600000e-01, \
                                    -5.6233766233799998e-01, -5.6103896103899997e-01, -5.5974025973999997e-01, \
                                    -5.5844155844200005e-01, -5.5714285714300005e-01, -5.5584415584400004e-01, \
                                    -5.5454545454500004e-01, -5.5324675324700001e-01, -5.5194805194800001e-01, \
                                    -5.5064935064900000e-01, -5.4935064935099998e-01, -5.4805194805199997e-01, \
                                    -5.4675324675299997e-01, -5.4545454545500005e-01, -5.4415584415600005e-01, \
                                    -5.4285714285700004e-01, -5.4155844155800004e-01, -5.4025974026000001e-01, \
                                    -5.3896103896100001e-01, -5.3766233766200000e-01, -5.3636363636399997e-01, \
                                    -5.3506493506499997e-01, -5.3376623376599996e-01, -5.3246753246800005e-01, \
                                    -5.3116883116900004e-01, -5.2987012987000004e-01, -5.2857142857100003e-01, \
                                    -5.2727272727300001e-01, -5.2597402597400000e-01, -5.2467532467500000e-01, \
                                    -5.2337662337699997e-01, -5.2207792207799997e-01, -5.2077922077899996e-01, \
                                    -5.1948051948100005e-01, -5.1818181818200004e-01, -5.1688311688300004e-01, \
                                    -5.1558441558400003e-01, -5.1428571428600001e-01, -5.1298701298700000e-01, \
                                    -5.1168831168800000e-01, -5.1038961038999997e-01, -5.0909090909099997e-01, \
                                    -5.0779220779199996e-01, -5.0649350649400005e-01, -5.0519480519500004e-01, \
                                    -5.0389610389600004e-01, -5.0259740259700003e-01, -5.0129870129900000e-01, \
                                    -5.0000000000000000e-01, -4.9870129870100000e-01, -4.9740259740300002e-01, \
                                    -4.9610389610400002e-01, -4.9480519480500001e-01, -4.9350649350699999e-01, \
                                    -4.9220779220799998e-01, -4.9090909090899998e-01, -4.8961038960999997e-01, \
                                    -4.8831168831200000e-01, -4.8701298701300000e-01, -4.8571428571399999e-01, \
                                    -4.8441558441600002e-01, -4.8311688311700002e-01, -4.8181818181800001e-01, \
                                    -4.8051948051999999e-01, -4.7922077922099998e-01, -4.7792207792199998e-01, \
                                    -4.7662337662299997e-01, -4.7532467532500000e-01, -4.7402597402600000e-01, \
                                    -4.7272727272699999e-01, -4.7142857142900002e-01, -4.7012987013000002e-01, \
                                    -4.6883116883100001e-01, -4.6753246753200001e-01, -4.6623376623399998e-01, \
                                    -4.6493506493499998e-01, -4.6363636363600003e-01, -4.6233766233800000e-01, \
                                    -4.6103896103899999e-01, -4.5974025973999999e-01, -4.5844155844200002e-01, \
                                    -4.5714285714300001e-01, -4.5584415584400001e-01, -4.5454545454500001e-01, \
                                    -4.5324675324699998e-01, -4.5194805194799997e-01, -4.5064935064900002e-01, \
                                    -4.4935064935100000e-01, -4.4805194805199999e-01, -4.4675324675299999e-01, \
                                    -4.4545454545500002e-01, -4.4415584415600001e-01, -4.4285714285700001e-01, \
                                    -4.4155844155800000e-01, -4.4025974025999998e-01, -4.3896103896100003e-01, \
                                    -4.3766233766200002e-01, -4.3636363636400000e-01, -4.3506493506499999e-01, \
                                    -4.3376623376599999e-01, -4.3246753246800002e-01, -4.3116883116900001e-01, \
                                    -4.2987012987000001e-01, -4.2857142857100000e-01, -4.2727272727299997e-01, \
                                    -4.2597402597400003e-01, -4.2467532467500002e-01, -4.2337662337699999e-01, \
                                    -4.2207792207799999e-01, -4.2077922077899998e-01, -4.1948051948100001e-01, \
                                    -4.1818181818200001e-01, -4.1688311688300000e-01, -4.1558441558400000e-01, \
                                    -4.1428571428599997e-01, -4.1298701298700002e-01, -4.1168831168800002e-01, \
                                    -4.1038961038999999e-01, -4.0909090909099999e-01, -4.0779220779199998e-01, \
                                    -4.0649350649400001e-01, -4.0519480519500001e-01, -4.0389610389600000e-01, \
                                    -4.0259740259700000e-01, -4.0129870129900003e-01, -4.0000000000000002e-01, \
                                    -3.9870129870100002e-01, -3.9740259740299999e-01, -3.9610389610399999e-01, \
                                    -3.9480519480499998e-01, -3.9350649350700001e-01, -3.9220779220800001e-01, \
                                    -3.9090909090900000e-01, -3.8961038961000000e-01, -3.8831168831200003e-01, \
                                    -3.8701298701300002e-01, -3.8571428571400002e-01, -3.8441558441599999e-01, \
                                    -3.8311688311699998e-01, -3.8181818181799998e-01, -3.8051948052000001e-01, \
                                    -3.7922077922100000e-01, -3.7792207792200000e-01, -3.7662337662299999e-01, \
                                    -3.7532467532500002e-01, -3.7402597402600002e-01, -3.7272727272700001e-01, \
                                    -3.7142857142899999e-01, -3.7012987012999998e-01, -3.6883116883099998e-01, \
                                    -3.6753246753199997e-01, -3.6623376623400000e-01, -3.6493506493500000e-01, \
                                    -3.6363636363599999e-01, -3.6233766233800002e-01, -3.6103896103900002e-01, \
                                    -3.5974025974000001e-01, -3.5844155844199999e-01, -3.5714285714299998e-01, \
                                    -3.5584415584399998e-01, -3.5454545454500003e-01, -3.5324675324700000e-01, \
                                    -3.5194805194800000e-01, -3.5064935064899999e-01, -3.4935064935100002e-01, \
                                    -3.4805194805200002e-01, -3.4675324675300001e-01, -3.4545454545499998e-01, \
                                    -3.4415584415599998e-01, -3.4285714285699997e-01, -3.4155844155800003e-01, \
                                    -3.4025974026000000e-01, -3.3896103896099999e-01, -3.3766233766199999e-01, \
                                    -3.3636363636400002e-01, -3.3506493506500001e-01, -3.3376623376600001e-01, \
                                    -3.3246753246799998e-01, -3.3116883116899998e-01, -3.2987012986999997e-01, \
                                    -3.2857142857100002e-01, -3.2727272727300000e-01, -3.2597402597399999e-01, \
                                    -3.2467532467499999e-01, -3.2337662337700002e-01, -3.2207792207800001e-01, \
                                    -3.2077922077900001e-01, -3.1948051948099998e-01, -3.1818181818199998e-01, \
                                    -3.1688311688300003e-01, -3.1558441558400002e-01, -3.1428571428600000e-01, \
                                    -3.1298701298699999e-01, -3.1168831168799999e-01, -3.1038961039000001e-01, \
                                    -3.0909090909100001e-01, -3.0779220779200001e-01, -3.0649350649399998e-01, \
                                    -3.0519480519499997e-01, -3.0389610389600002e-01, -3.0259740259700002e-01, \
                                    -3.0129870129899999e-01, -2.9999999999999999e-01, -2.9870129870099998e-01, \
                                    -2.9740259740300001e-01, -2.9610389610400001e-01, -2.9480519480500000e-01, \
                                    -2.9350649350699998e-01, -2.9220779220799997e-01, -2.9090909090900002e-01, \
                                    -2.8961038961000002e-01, -2.8831168831199999e-01, -2.8701298701299999e-01, \
                                    -2.8571428571399998e-01, -2.8441558441600001e-01, -2.8311688311700001e-01, \
                                    -2.8181818181800000e-01, -2.8051948051999998e-01, -2.7922077922100003e-01, \
                                    -2.7792207792200002e-01, -2.7662337662300002e-01, -2.7532467532499999e-01, \
                                    -2.7402597402599999e-01, -2.7272727272699998e-01, -2.7142857142900001e-01, \
                                    -2.7012987013000000e-01, -2.6883116883100000e-01, -2.6753246753200000e-01, \
                                    -2.6623376623400002e-01, -2.6493506493500002e-01, -2.6363636363600002e-01, \
                                    -2.6233766233799999e-01, -2.6103896103899998e-01, -2.5974025973999998e-01, \
                                    -2.5844155844200001e-01, -2.5714285714300000e-01, -2.5584415584400000e-01, \
                                    -2.5454545454499999e-01, -2.5324675324700002e-01, -2.5194805194800002e-01, \
                                    -2.5064935064900001e-01, -2.4935064935099999e-01, -2.4805194805200001e-01, \
                                    -2.4675324675300001e-01, -2.4545454545500001e-01, -2.4415584415600000e-01, \
                                    -2.4285714285700000e-01, -2.4155844155799999e-01, -2.4025974025999999e-01, \
                                    -2.3896103896099999e-01, -2.3766233766200001e-01, -2.3636363636400001e-01, \
                                    -2.3506493506500001e-01, -2.3376623376600000e-01, -2.3246753246800000e-01, \
                                    -2.3116883116900000e-01, -2.2987012987000000e-01, -2.2857142857099999e-01, \
                                    -2.2727272727299999e-01, -2.2597402597399999e-01, -2.2467532467500001e-01, \
                                    -2.2337662337700001e-01, -2.2207792207800001e-01, -2.2077922077900000e-01, \
                                    -2.1948051948100000e-01, -2.1818181818200000e-01, -2.1688311688299999e-01, \
                                    -2.1558441558399999e-01, -2.1428571428599999e-01, -2.1298701298700001e-01, \
                                    -2.1168831168800001e-01, -2.1038961039000001e-01, -2.0909090909100000e-01, \
                                    -2.0779220779200000e-01, -2.0649350649400000e-01, -2.0519480519500000e-01, \
                                    -2.0389610389599999e-01, -2.0259740259699999e-01, -2.0129870129899999e-01, \
                                    -2.0000000000000001e-01, -1.9870129870100001e-01, -1.9740259740300001e-01, \
                                    -1.9610389610400000e-01, -1.9480519480500000e-01, -1.9350649350700000e-01, \
                                    -1.9220779220799999e-01, -1.9090909090899999e-01, -1.8961038961000001e-01, \
                                    -1.8831168831199999e-01, -1.8701298701300001e-01, -1.8571428571400000e-01, \
                                    -1.8441558441600001e-01, -1.8311688311700000e-01, -1.8181818181800000e-01, \
                                    -1.8051948052000000e-01, -1.7922077922099999e-01, -1.7792207792199999e-01, \
                                    -1.7662337662300001e-01, -1.7532467532500001e-01, -1.7402597402600001e-01, \
                                    -1.7272727272700000e-01, -1.7142857142900000e-01, -1.7012987013000000e-01, \
                                    -1.6883116883099999e-01, -1.6753246753199999e-01, -1.6623376623399999e-01, \
                                    -1.6493506493499999e-01, -1.6363636363600001e-01, -1.6233766233800001e-01, \
                                    -1.6103896103900001e-01, -1.5974025974000000e-01, -1.5844155844200000e-01, \
                                    -1.5714285714300000e-01, -1.5584415584399999e-01, -1.5454545454499999e-01, \
                                    -1.5324675324699999e-01, -1.5194805194800001e-01, -1.5064935064900001e-01, \
                                    -1.4935064935100001e-01, -1.4805194805200000e-01, -1.4675324675300000e-01, \
                                    -1.4545454545500000e-01, -1.4415584415600000e-01, -1.4285714285699999e-01, \
                                    -1.4155844155799999e-01, -1.4025974025999999e-01, -1.3896103896100001e-01, \
                                    -1.3766233766200001e-01, -1.3636363636400001e-01, -1.3506493506500000e-01, \
                                    -1.3376623376600000e-01, -1.3246753246800000e-01, -1.3116883116899999e-01, \
                                    -1.2987012986999999e-01, -1.2857142857100001e-01, -1.2727272727300001e-01, \
                                    -1.2597402597400001e-01, -1.2467532467500000e-01, -1.2337662337700001e-01, \
                                    -1.2207792207800000e-01, -1.2077922077900000e-01, -1.1948051948100000e-01, \
                                    -1.1818181818200001e-01, -1.1688311688300000e-01, -1.1558441558400000e-01, \
                                    -1.1428571428600000e-01, -1.1298701298699999e-01, -1.1168831168800000e-01, \
                                    -1.1038961039000000e-01, -1.0909090909100000e-01, -1.0779220779199999e-01, \
                                    -1.0649350649400000e-01, -1.0519480519500000e-01, -1.0389610389600000e-01, \
                                    -1.0259740259700000e-01, -1.0129870129900000e-01, -1.0000000000000001e-01, \
                                    -9.8701298701000001e-02, -9.7402597403000002e-02, -9.6103896103999997e-02, \
                                    -9.4805194805000007e-02, -9.3506493506999994e-02, -9.2207792208000003e-02, \
                                    -9.0909090908999998e-02, -8.9610389609999994e-02, -8.8311688311999995e-02, \
                                    -8.7012987013000004e-02, -8.5714285713999999e-02, -8.4415584416000000e-02, \
                                    -8.3116883116999996e-02, -8.1818181818000005e-02, -8.0519480520000006e-02, \
                                    -7.9220779221000001e-02, -7.7922077921999996e-02, -7.6623376623000006e-02, \
                                    -7.5324675325000007e-02, -7.4025974026000002e-02, -7.2727272726999997e-02, \
                                    -7.1428571428999998e-02, -7.0129870129999994e-02, -6.8831168831000003e-02, \
                                    -6.7532467531999998e-02, -6.6233766233999999e-02, -6.4935064934999995e-02, \
                                    -6.3636363636000004e-02, -6.2337662337999998e-02, -6.1038961039000000e-02, \
                                    -5.9740259740000003e-02, -5.8441558441999997e-02, -5.7142857142999999e-02, \
                                    -5.5844155844000001e-02, -5.4545454544999997e-02, -5.3246753246999998e-02, \
                                    -5.1948051948000000e-02, -5.0649350649000002e-02, -4.9350649351000003e-02, \
                                    -4.8051948051999999e-02, -4.6753246753000001e-02, -4.5454545455000002e-02, \
                                    -4.4155844155999997e-02, -4.2857142857000000e-02, -4.1558441558000002e-02, \
                                    -4.0259740260000003e-02, -3.8961038960999998e-02, -3.7662337662000001e-02, \
                                    -3.6363636364000002e-02, -3.5064935064999997e-02, -3.3766233765999999e-02, \
                                    -3.2467532468000000e-02, -3.1168831168999999e-02, -2.9870129870000001e-02, \
                                    -2.8571428571000000e-02, -2.7272727273000001e-02, -2.5974025974000000e-02, \
                                    -2.4675324674999999e-02, -2.3376623377000000e-02, -2.2077922077999999e-02, \
                                    -2.0779220779000001e-02, -1.9480519480999998e-02, -1.8181818182000001e-02, \
                                    -1.6883116883000000e-02, -1.5584415584000000e-02, -1.4285714285999999e-02, \
                                    -1.2987012987000000e-02, -1.1688311688000001e-02, -1.0389610390000000e-02, \
                                    -9.0909090910000004e-03, -7.7922077920000001e-03, -6.4935064940000002e-03, \
                                    -5.1948051949999999e-03, -3.8961038960000000e-03, -2.5974025970000002e-03, \
                                    -1.2987012990000001e-03,  0.0000000000000000e+00,  1.2987012990000001e-03, \
                                    2.5974025970000002e-03,  3.8961038960000000e-03,  5.1948051949999999e-03, \
                                    6.4935064929999998e-03,  7.7922077920000001e-03,  9.0909090910000004e-03, \
                                    1.0389610390000000e-02,  1.1688311688000001e-02,  1.2987012987000000e-02, \
                                    1.4285714285999999e-02,  1.5584415584000000e-02,  1.6883116883000000e-02, \
                                    1.8181818182000001e-02,  1.9480519480000000e-02,  2.0779220779000001e-02, \
                                    2.2077922077999999e-02,  2.3376623377000000e-02,  2.4675324674999999e-02, \
                                    2.5974025974000000e-02,  2.7272727273000001e-02,  2.8571428571000000e-02, \
                                    2.9870129870000001e-02,  3.1168831168999999e-02,  3.2467532468000000e-02, \
                                    3.3766233765999999e-02,  3.5064935064999997e-02,  3.6363636364000002e-02, \
                                    3.7662337662000001e-02,  3.8961038960999998e-02,  4.0259740260000003e-02, \
                                    4.1558441558000002e-02,  4.2857142857000000e-02,  4.4155844155999997e-02, \
                                    4.5454545455000002e-02,  4.6753246753000001e-02,  4.8051948051999999e-02, \
                                    4.9350649351000003e-02,  5.0649350649000002e-02,  5.1948051948000000e-02, \
                                    5.3246753246999998e-02,  5.4545454544999997e-02,  5.5844155844000001e-02, \
                                    5.7142857142999999e-02,  5.8441558441999997e-02,  5.9740259740000003e-02, \
                                    6.1038961039000000e-02,  6.2337662337999998e-02,  6.3636363636000004e-02, \
                                    6.4935064934999995e-02,  6.6233766233999999e-02,  6.7532467531999998e-02, \
                                    6.8831168831000003e-02,  7.0129870129999994e-02,  7.1428571428999998e-02, \
                                    7.2727272726999997e-02,  7.4025974026000002e-02,  7.5324675325000007e-02, \
                                    7.6623376623000006e-02,  7.7922077921999996e-02,  7.9220779221000001e-02, \
                                    8.0519480519000000e-02,  8.1818181818000005e-02,  8.3116883116999996e-02, \
                                    8.4415584416000000e-02,  8.5714285713999999e-02,  8.7012987013000004e-02, \
                                    8.8311688311999995e-02,  8.9610389609999994e-02,  9.0909090908999998e-02, \
                                    9.2207792208000003e-02,  9.3506493506000002e-02,  9.4805194805000007e-02, \
                                    9.6103896103999997e-02,  9.7402597403000002e-02,  9.8701298701000001e-02, \
                                    1.0000000000000001e-01,  1.0129870129900000e-01,  1.0259740259700000e-01, \
                                    1.0389610389600000e-01,  1.0519480519500000e-01,  1.0649350649300000e-01, \
                                    1.0779220779199999e-01,  1.0909090909100000e-01,  1.1038961039000000e-01, \
                                    1.1168831168800000e-01,  1.1298701298699999e-01,  1.1428571428600000e-01, \
                                    1.1558441558400000e-01,  1.1688311688300000e-01,  1.1818181818200001e-01, \
                                    1.1948051948000001e-01,  1.2077922077900000e-01,  1.2207792207800000e-01, \
                                    1.2337662337700001e-01,  1.2467532467500000e-01,  1.2597402597400001e-01, \
                                    1.2727272727300001e-01,  1.2857142857100001e-01,  1.2987012986999999e-01, \
                                    1.3116883116899999e-01,  1.3246753246800000e-01,  1.3376623376600000e-01, \
                                    1.3506493506500000e-01,  1.3636363636400001e-01,  1.3766233766200001e-01, \
                                    1.3896103896100001e-01,  1.4025974025999999e-01,  1.4155844155799999e-01, \
                                    1.4285714285699999e-01,  1.4415584415600000e-01,  1.4545454545500000e-01, \
                                    1.4675324675300000e-01,  1.4805194805200000e-01,  1.4935064935100001e-01, \
                                    1.5064935064900001e-01,  1.5194805194800001e-01,  1.5324675324699999e-01, \
                                    1.5454545454499999e-01,  1.5584415584399999e-01,  1.5714285714300000e-01, \
                                    1.5844155844200000e-01,  1.5974025974000000e-01,  1.6103896103900001e-01, \
                                    1.6233766233800001e-01,  1.6363636363600001e-01,  1.6493506493499999e-01, \
                                    1.6623376623399999e-01,  1.6753246753199999e-01,  1.6883116883099999e-01, \
                                    1.7012987013000000e-01,  1.7142857142900000e-01,  1.7272727272700000e-01, \
                                    1.7402597402600001e-01,  1.7532467532500001e-01,  1.7662337662300001e-01, \
                                    1.7792207792199999e-01,  1.7922077922099999e-01,  1.8051948051899999e-01, \
                                    1.8181818181800000e-01,  1.8311688311700000e-01,  1.8441558441600001e-01, \
                                    1.8571428571400000e-01,  1.8701298701300001e-01,  1.8831168831199999e-01, \
                                    1.8961038961000001e-01,  1.9090909090899999e-01,  1.9220779220799999e-01, \
                                    1.9350649350599999e-01,  1.9480519480500000e-01,  1.9610389610400000e-01, \
                                    1.9740259740300001e-01,  1.9870129870100001e-01,  2.0000000000000001e-01, \
                                    2.0129870129899999e-01,  2.0259740259699999e-01,  2.0389610389599999e-01, \
                                    2.0519480519500000e-01,  2.0649350649300000e-01,  2.0779220779200000e-01, \
                                    2.0909090909100000e-01,  2.1038961039000001e-01,  2.1168831168800001e-01, \
                                    2.1298701298700001e-01,  2.1428571428599999e-01,  2.1558441558399999e-01, \
                                    2.1688311688299999e-01,  2.1818181818200000e-01,  2.1948051948000000e-01, \
                                    2.2077922077900000e-01,  2.2207792207800001e-01,  2.2337662337700001e-01, \
                                    2.2467532467500001e-01,  2.2597402597399999e-01,  2.2727272727299999e-01, \
                                    2.2857142857099999e-01,  2.2987012987000000e-01,  2.3116883116900000e-01, \
                                    2.3246753246800000e-01,  2.3376623376600000e-01,  2.3506493506500001e-01, \
                                    2.3636363636400001e-01,  2.3766233766200001e-01,  2.3896103896099999e-01, \
                                    2.4025974025999999e-01,  2.4155844155799999e-01,  2.4285714285700000e-01, \
                                    2.4415584415600000e-01,  2.4545454545500001e-01,  2.4675324675300001e-01, \
                                    2.4805194805200001e-01,  2.4935064935099999e-01,  2.5064935064900001e-01, \
                                    2.5194805194800002e-01,  2.5324675324700002e-01,  2.5454545454499999e-01, \
                                    2.5584415584400000e-01,  2.5714285714300000e-01,  2.5844155844200001e-01, \
                                    2.5974025973999998e-01,  2.6103896103899998e-01,  2.6233766233799999e-01, \
                                    2.6363636363600002e-01,  2.6493506493500002e-01,  2.6623376623400002e-01, \
                                    2.6753246753200000e-01,  2.6883116883100000e-01,  2.7012987013000000e-01, \
                                    2.7142857142900001e-01,  2.7272727272699998e-01,  2.7402597402599999e-01, \
                                    2.7532467532499999e-01,  2.7662337662300002e-01,  2.7792207792200002e-01, \
                                    2.7922077922100003e-01,  2.8051948051900000e-01,  2.8181818181800000e-01, \
                                    2.8311688311700001e-01,  2.8441558441600001e-01,  2.8571428571399998e-01, \
                                    2.8701298701299999e-01,  2.8831168831199999e-01,  2.8961038961000002e-01, \
                                    2.9090909090900002e-01,  2.9220779220799997e-01,  2.9350649350600000e-01, \
                                    2.9480519480500000e-01,  2.9610389610400001e-01,  2.9740259740300001e-01, \
                                    2.9870129870099998e-01,  2.9999999999999999e-01,  3.0129870129899999e-01, \
                                    3.0259740259700002e-01,  3.0389610389600002e-01,  3.0519480519499997e-01, \
                                    3.0649350649300000e-01,  3.0779220779200001e-01,  3.0909090909100001e-01, \
                                    3.1038961039000001e-01,  3.1168831168799999e-01,  3.1298701298699999e-01, \
                                    3.1428571428600000e-01,  3.1558441558400002e-01,  3.1688311688300003e-01, \
                                    3.1818181818199998e-01,  3.1948051948000000e-01,  3.2077922077900001e-01, \
                                    3.2207792207800001e-01,  3.2337662337700002e-01,  3.2467532467499999e-01, \
                                    3.2597402597399999e-01,  3.2727272727300000e-01,  3.2857142857100002e-01, \
                                    3.2987012986999997e-01,  3.3116883116899998e-01,  3.3246753246799998e-01, \
                                    3.3376623376600001e-01,  3.3506493506500001e-01,  3.3636363636400002e-01, \
                                    3.3766233766199999e-01,  3.3896103896099999e-01,  3.4025974026000000e-01, \
                                    3.4155844155800003e-01,  3.4285714285699997e-01,  3.4415584415599998e-01, \
                                    3.4545454545499998e-01,  3.4675324675300001e-01,  3.4805194805200002e-01, \
                                    3.4935064935100002e-01,  3.5064935064899999e-01,  3.5194805194800000e-01, \
                                    3.5324675324700000e-01,  3.5454545454500003e-01,  3.5584415584399998e-01, \
                                    3.5714285714299998e-01,  3.5844155844199999e-01,  3.5974025974000001e-01, \
                                    3.6103896103900002e-01,  3.6233766233800002e-01,  3.6363636363599999e-01, \
                                    3.6493506493500000e-01,  3.6623376623400000e-01,  3.6753246753199997e-01, \
                                    3.6883116883099998e-01,  3.7012987012999998e-01,  3.7142857142899999e-01, \
                                    3.7272727272700001e-01,  3.7402597402600002e-01,  3.7532467532500002e-01, \
                                    3.7662337662299999e-01,  3.7792207792200000e-01,  3.7922077922100000e-01, \
                                    3.8051948051899998e-01,  3.8181818181799998e-01,  3.8311688311699998e-01, \
                                    3.8441558441599999e-01,  3.8571428571400002e-01,  3.8701298701300002e-01, \
                                    3.8831168831200003e-01,  3.8961038961000000e-01,  3.9090909090900000e-01, \
                                    3.9220779220800001e-01,  3.9350649350599998e-01,  3.9480519480499998e-01, \
                                    3.9610389610399999e-01,  3.9740259740299999e-01,  3.9870129870100002e-01, \
                                    4.0000000000000002e-01,  4.0129870129900003e-01,  4.0259740259700000e-01, \
                                    4.0389610389600000e-01,  4.0519480519500001e-01,  4.0649350649299998e-01, \
                                    4.0779220779199998e-01,  4.0909090909099999e-01,  4.1038961038999999e-01, \
                                    4.1168831168800002e-01,  4.1298701298700002e-01,  4.1428571428599997e-01, \
                                    4.1558441558400000e-01,  4.1688311688300000e-01,  4.1818181818200001e-01, \
                                    4.1948051947999998e-01,  4.2077922077899998e-01,  4.2207792207799999e-01, \
                                    4.2337662337699999e-01,  4.2467532467500002e-01,  4.2597402597400003e-01, \
                                    4.2727272727299997e-01,  4.2857142857100000e-01,  4.2987012987000001e-01, \
                                    4.3116883116900001e-01,  4.3246753246800002e-01,  4.3376623376599999e-01, \
                                    4.3506493506499999e-01,  4.3636363636400000e-01,  4.3766233766200002e-01, \
                                    4.3896103896100003e-01,  4.4025974025999998e-01,  4.4155844155800000e-01, \
                                    4.4285714285700001e-01,  4.4415584415600001e-01,  4.4545454545500002e-01, \
                                    4.4675324675299999e-01,  4.4805194805199999e-01,  4.4935064935100000e-01, \
                                    4.5064935064900002e-01,  4.5194805194799997e-01,  4.5324675324699998e-01, \
                                    4.5454545454500001e-01,  4.5584415584400001e-01,  4.5714285714300001e-01, \
                                    4.5844155844200002e-01,  4.5974025973999999e-01,  4.6103896103899999e-01, \
                                    4.6233766233800000e-01,  4.6363636363600003e-01,  4.6493506493499998e-01, \
                                    4.6623376623399998e-01,  4.6753246753200001e-01,  4.6883116883100001e-01, \
                                    4.7012987013000002e-01,  4.7142857142900002e-01,  4.7272727272699999e-01, \
                                    4.7402597402600000e-01,  4.7532467532500000e-01,  4.7662337662299997e-01, \
                                    4.7792207792199998e-01,  4.7922077922099998e-01,  4.8051948051900001e-01, \
                                    4.8181818181800001e-01,  4.8311688311700002e-01,  4.8441558441600002e-01, \
                                    4.8571428571399999e-01,  4.8701298701300000e-01,  4.8831168831200000e-01, \
                                    4.8961038960999997e-01,  4.9090909090899998e-01,  4.9220779220799998e-01, \
                                    4.9350649350600001e-01,  4.9480519480500001e-01,  4.9610389610400002e-01, \
                                    4.9740259740300002e-01,  4.9870129870100000e-01,  5.0000000000000000e-01, \
                                    5.0129870129900000e-01,  5.0259740259700003e-01,  5.0389610389600004e-01, \
                                    5.0519480519500004e-01,  5.0649350649299996e-01,  5.0779220779199996e-01, \
                                    5.0909090909099997e-01,  5.1038961038999997e-01,  5.1168831168800000e-01, \
                                    5.1298701298700000e-01,  5.1428571428600001e-01,  5.1558441558400003e-01, \
                                    5.1688311688300004e-01,  5.1818181818200004e-01,  5.1948051947999996e-01, \
                                    5.2077922077899996e-01,  5.2207792207799997e-01,  5.2337662337699997e-01, \
                                    5.2467532467500000e-01,  5.2597402597400000e-01,  5.2727272727300001e-01, \
                                    5.2857142857100003e-01,  5.2987012987000004e-01,  5.3116883116900004e-01, \
                                    5.3246753246800005e-01,  5.3376623376599996e-01,  5.3506493506499997e-01, \
                                    5.3636363636399997e-01,  5.3766233766200000e-01,  5.3896103896100001e-01, \
                                    5.4025974026000001e-01,  5.4155844155800004e-01,  5.4285714285700004e-01, \
                                    5.4415584415600005e-01,  5.4545454545500005e-01,  5.4675324675299997e-01, \
                                    5.4805194805199997e-01,  5.4935064935099998e-01,  5.5064935064900000e-01, \
                                    5.5194805194800001e-01,  5.5324675324700001e-01,  5.5454545454500004e-01, \
                                    5.5584415584400004e-01,  5.5714285714300005e-01,  5.5844155844200005e-01, \
                                    5.5974025973999997e-01,  5.6103896103899997e-01,  5.6233766233799998e-01, \
                                    5.6363636363600000e-01,  5.6493506493500001e-01,  5.6623376623400001e-01, \
                                    5.6753246753200004e-01,  5.6883116883100004e-01,  5.7012987013000005e-01, \
                                    5.7142857142900005e-01,  5.7272727272699997e-01,  5.7402597402599997e-01, \
                                    5.7532467532499998e-01,  5.7662337662300001e-01,  5.7792207792200001e-01, \
                                    5.7922077922100002e-01,  5.8051948051900004e-01,  5.8181818181800005e-01, \
                                    5.8311688311700005e-01,  5.8441558441599994e-01,  5.8571428571399997e-01, \
                                    5.8701298701299998e-01,  5.8831168831199998e-01,  5.8961038961000001e-01, \
                                    5.9090909090900001e-01,  5.9220779220800002e-01,  5.9350649350600004e-01, \
                                    5.9480519480500005e-01,  5.9610389610400005e-01,  5.9740259740299995e-01, \
                                    5.9870129870099997e-01,  5.9999999999999998e-01,  6.0129870129899998e-01, \
                                    6.0259740259700001e-01,  6.0389610389600001e-01,  6.0519480519500002e-01, \
                                    6.0649350649300005e-01,  6.0779220779200005e-01,  6.0909090909100005e-01, \
                                    6.1038961038999995e-01,  6.1168831168799997e-01,  6.1298701298699998e-01, \
                                    6.1428571428599998e-01,  6.1558441558400001e-01,  6.1688311688300002e-01, \
                                    6.1818181818200002e-01,  6.1948051948000005e-01,  6.2077922077900005e-01, \
                                    6.2207792207799995e-01,  6.2337662337699995e-01,  6.2467532467499998e-01, \
                                    6.2597402597399998e-01,  6.2727272727299999e-01,  6.2857142857100001e-01, \
                                    6.2987012987000002e-01,  6.3116883116900002e-01,  6.3246753246800003e-01, \
                                    6.3376623376600005e-01,  6.3506493506499995e-01,  6.3636363636399995e-01, \
                                    6.3766233766199998e-01,  6.3896103896099998e-01,  6.4025974025999999e-01, \
                                    6.4155844155800001e-01,  6.4285714285700002e-01,  6.4415584415600002e-01, \
                                    6.4545454545500003e-01,  6.4675324675300006e-01,  6.4805194805199995e-01, \
                                    6.4935064935099995e-01,  6.5064935064899998e-01,  6.5194805194799998e-01, \
                                    6.5324675324699999e-01,  6.5454545454500002e-01,  6.5584415584400002e-01, \
                                    6.5714285714300003e-01,  6.5844155844200003e-01,  6.5974025973999995e-01, \
                                    6.6103896103899995e-01,  6.6233766233799996e-01,  6.6363636363599998e-01, \
                                    6.6493506493499999e-01,  6.6623376623399999e-01,  6.6753246753200002e-01, \
                                    6.6883116883100002e-01,  6.7012987013000003e-01,  6.7142857142900003e-01, \
                                    6.7272727272699995e-01,  6.7402597402599995e-01,  6.7532467532499996e-01, \
                                    6.7662337662299998e-01,  6.7792207792199999e-01,  6.7922077922099999e-01, \
                                    6.8051948051900002e-01,  6.8181818181800002e-01,  6.8311688311700003e-01, \
                                    6.8441558441600003e-01,  6.8571428571399995e-01,  6.8701298701299995e-01, \
                                    6.8831168831199996e-01,  6.8961038960999999e-01,  6.9090909090899999e-01, \
                                    6.9220779220799999e-01,  6.9350649350600002e-01,  6.9480519480500003e-01, \
                                    6.9610389610400003e-01,  6.9740259740300004e-01,  6.9870129870099995e-01, \
                                    6.9999999999999996e-01,  7.0129870129899996e-01,  7.0259740259699999e-01, \
                                    7.0389610389599999e-01,  7.0519480519500000e-01,  7.0649350649300002e-01, \
                                    7.0779220779200003e-01,  7.0909090909100003e-01,  7.1038961039000004e-01, \
                                    7.1168831168799995e-01,  7.1298701298699996e-01,  7.1428571428599996e-01, \
                                    7.1558441558399999e-01,  7.1688311688299999e-01,  7.1818181818200000e-01, \
                                    7.1948051948000002e-01,  7.2077922077900003e-01,  7.2207792207800003e-01, \
                                    7.2337662337700004e-01,  7.2467532467499995e-01,  7.2597402597399996e-01, \
                                    7.2727272727299996e-01,  7.2857142857099999e-01,  7.2987012987000000e-01, \
                                    7.3116883116900000e-01,  7.3246753246800000e-01,  7.3376623376600003e-01, \
                                    7.3506493506500004e-01,  7.3636363636400004e-01,  7.3766233766199996e-01, \
                                    7.3896103896099996e-01,  7.4025974025999997e-01,  7.4155844155799999e-01, \
                                    7.4285714285700000e-01,  7.4415584415600000e-01,  7.4545454545500001e-01, \
                                    7.4675324675300003e-01,  7.4805194805200004e-01,  7.4935064935100004e-01, \
                                    7.5064935064899996e-01,  7.5194805194799996e-01,  7.5324675324699997e-01, \
                                    7.5454545454499999e-01,  7.5584415584400000e-01,  7.5714285714300000e-01, \
                                    7.5844155844200001e-01,  7.5974025974000003e-01,  7.6103896103900004e-01, \
                                    7.6233766233800004e-01,  7.6363636363599996e-01,  7.6493506493499996e-01, \
                                    7.6623376623399997e-01,  7.6753246753200000e-01,  7.6883116883100000e-01, \
                                    7.7012987013000000e-01,  7.7142857142900001e-01,  7.7272727272700004e-01, \
                                    7.7402597402600004e-01,  7.7532467532500005e-01,  7.7662337662299996e-01, \
                                    7.7792207792199997e-01,  7.7922077922099997e-01,  7.8051948051900000e-01, \
                                    7.8181818181800000e-01,  7.8311688311700001e-01,  7.8441558441600001e-01, \
                                    7.8571428571400004e-01,  7.8701298701300004e-01,  7.8831168831200005e-01, \
                                    7.8961038960999996e-01,  7.9090909090899997e-01,  7.9220779220799997e-01, \
                                    7.9350649350600000e-01,  7.9480519480500000e-01,  7.9610389610400001e-01, \
                                    7.9740259740300001e-01,  7.9870129870100004e-01,  8.0000000000000004e-01, \
                                    8.0129870129900005e-01,  8.0259740259699996e-01,  8.0389610389599997e-01, \
                                    8.0519480519499997e-01,  8.0649350649300000e-01,  8.0779220779200001e-01, \
                                    8.0909090909100001e-01,  8.1038961039000001e-01,  8.1168831168800004e-01, \
                                    8.1298701298700005e-01,  8.1428571428600005e-01,  8.1558441558399997e-01, \
                                    8.1688311688299997e-01,  8.1818181818199998e-01,  8.1948051948000000e-01, \
                                    8.2077922077900001e-01,  8.2207792207800001e-01,  8.2337662337700002e-01, \
                                    8.2467532467500004e-01,  8.2597402597400005e-01,  8.2727272727300005e-01, \
                                    8.2857142857099997e-01,  8.2987012986999997e-01,  8.3116883116899998e-01, \
                                    8.3246753246700000e-01,  8.3376623376600001e-01,  8.3506493506500001e-01, \
                                    8.3636363636400002e-01,  8.3766233766200004e-01,  8.3896103896100005e-01, \
                                    8.4025974026000005e-01,  8.4155844155799997e-01,  8.4285714285699997e-01, \
                                    8.4415584415599998e-01,  8.4545454545499998e-01,  8.4675324675300001e-01, \
                                    8.4805194805200002e-01,  8.4935064935100002e-01,  8.5064935064900005e-01, \
                                    8.5194805194800005e-01,  8.5324675324699994e-01,  8.5454545454499997e-01, \
                                    8.5584415584399998e-01,  8.5714285714299998e-01,  8.5844155844199999e-01, \
                                    8.5974025974000001e-01,  8.6103896103900002e-01,  8.6233766233800002e-01, \
                                    8.6363636363600005e-01,  8.6493506493500005e-01,  8.6623376623399995e-01, \
                                    8.6753246753199997e-01,  8.6883116883099998e-01,  8.7012987012999998e-01, \
                                    8.7142857142899999e-01,  8.7272727272700001e-01,  8.7402597402600002e-01, \
                                    8.7532467532500002e-01,  8.7662337662300005e-01,  8.7792207792200005e-01, \
                                    8.7922077922099995e-01,  8.8051948051899998e-01,  8.8181818181799998e-01, \
                                    8.8311688311699998e-01,  8.8441558441599999e-01,  8.8571428571400002e-01, \
                                    8.8701298701300002e-01,  8.8831168831200003e-01,  8.8961038961000005e-01, \
                                    8.9090909090899995e-01,  8.9220779220799995e-01,  8.9350649350599998e-01, \
                                    8.9480519480499998e-01,  8.9610389610399999e-01,  8.9740259740299999e-01, \
                                    8.9870129870100002e-01,  9.0000000000000002e-01,  9.0129870129900003e-01, \
                                    9.0259740259700005e-01,  9.0389610389599995e-01,  9.0519480519499995e-01, \
                                    9.0649350649299998e-01,  9.0779220779199998e-01,  9.0909090909099999e-01, \
                                    9.1038961038999999e-01,  9.1168831168800002e-01,  9.1298701298700002e-01, \
                                    9.1428571428600003e-01,  9.1558441558400006e-01,  9.1688311688299995e-01, \
                                    9.1818181818199995e-01,  9.1948051947999998e-01,  9.2077922077899998e-01, \
                                    9.2207792207799999e-01,  9.2337662337699999e-01,  9.2467532467500002e-01, \
                                    9.2597402597400003e-01,  9.2727272727300003e-01,  9.2857142857099995e-01, \
                                    9.2987012986999995e-01,  9.3116883116899996e-01,  9.3246753246699998e-01, \
                                    9.3376623376599999e-01,  9.3506493506499999e-01,  9.3636363636400000e-01, \
                                    9.3766233766200002e-01,  9.3896103896100003e-01,  9.4025974026000003e-01, \
                                    9.4155844155799995e-01,  9.4285714285699995e-01,  9.4415584415599996e-01, \
                                    9.4545454545499996e-01,  9.4675324675299999e-01,  9.4805194805199999e-01, \
                                    9.4935064935100000e-01,  9.5064935064900002e-01,  9.5194805194800003e-01, \
                                    9.5324675324700003e-01,  9.5454545454499995e-01,  9.5584415584399995e-01, \
                                    9.5714285714299996e-01,  9.5844155844199996e-01,  9.5974025973999999e-01, \
                                    9.6103896103899999e-01,  9.6233766233800000e-01,  9.6363636363600003e-01, \
                                    9.6493506493500003e-01,  9.6623376623400004e-01,  9.6753246753199995e-01, \
                                    9.6883116883099996e-01,  9.7012987012999996e-01,  9.7142857142899997e-01, \
                                    9.7272727272699999e-01,  9.7402597402600000e-01,  9.7532467532500000e-01, \
                                    9.7662337662300003e-01,  9.7792207792200003e-01,  9.7922077922100004e-01, \
                                    9.8051948051899995e-01,  9.8181818181799996e-01,  9.8311688311699996e-01, \
                                    9.8441558441599997e-01,  9.8571428571399999e-01,  9.8701298701300000e-01, \
                                    9.8831168831200000e-01,  9.8961038961000003e-01,  9.9090909090900003e-01, \
                                    9.9220779220800004e-01,  9.9350649350599995e-01,  9.9480519480499996e-01, \
                                    9.9610389610399996e-01,  9.9740259740299997e-01,  9.9870129870100000e-01, \
                                    1.0000000000000000e+00, -1.0000000000000000e+00, -9.9887069452300004e-01, \
                                    -9.9774138904599996e-01, -9.9661208356900000e-01, -9.9548277809100005e-01, \
                                    -9.9435347261399998e-01, -9.9322416713700001e-01, -9.9209486166000005e-01, \
                                    -9.9096555618299997e-01, -9.8983625070600001e-01, -9.8870694522900004e-01, \
                                    -9.8757763975199997e-01, -9.8644833427400003e-01, -9.8531902879699995e-01, \
                                    -9.8418972331999999e-01, -9.8306041784300002e-01, -9.8193111236599995e-01, \
                                    -9.8080180688899998e-01, -9.7967250141200002e-01, -9.7854319593500005e-01, \
                                    -9.7741389045700000e-01, -9.7628458498000004e-01, -9.7515527950299996e-01, \
                                    -9.7402597402600000e-01, -9.7289666854900003e-01, -9.7176736307199996e-01, \
                                    -9.7063805759499999e-01, -9.6950875211700005e-01, -9.6837944663999997e-01, \
                                    -9.6725014116300001e-01, -9.6612083568600005e-01, -9.6499153020899997e-01, \
                                    -9.6386222473200001e-01, -9.6273291925500004e-01, -9.6160361377799997e-01, \
                                    -9.6047430830000002e-01, -9.5934500282299995e-01, -9.5821569734599998e-01, \
                                    -9.5708639186900002e-01, -9.5595708639200005e-01, -9.5482778091499998e-01, \
                                    -9.5369847543800002e-01, -9.5256916995999996e-01, -9.5143986448300000e-01, \
                                    -9.5031055900600003e-01, -9.4918125352899996e-01, -9.4805194805199999e-01, \
                                    -9.4692264257500003e-01, -9.4579333709799995e-01, -9.4466403162099999e-01, \
                                    -9.4353472614300005e-01, -9.4240542066599997e-01, -9.4127611518900001e-01, \
                                    -9.4014680971200004e-01, -9.3901750423499997e-01, -9.3788819875800000e-01, \
                                    -9.3675889328100004e-01, -9.3562958780399996e-01, -9.3450028232600002e-01, \
                                    -9.3337097684899994e-01, -9.3224167137199998e-01, -9.3111236589500002e-01, \
                                    -9.2998306041800005e-01, -9.2885375494099998e-01, -9.2772444946400001e-01, \
                                    -9.2659514398599996e-01, -9.2546583850899999e-01, -9.2433653303200003e-01, \
                                    -9.2320722755499995e-01, -9.2207792207799999e-01, -9.2094861660100003e-01, \
                                    -9.1981931112399995e-01, -9.1869000564699999e-01, -9.1756070016900004e-01, \
                                    -9.1643139469199997e-01, -9.1530208921500000e-01, -9.1417278373800004e-01, \
                                    -9.1304347826099996e-01, -9.1191417278400000e-01, -9.1078486730700003e-01, \
                                    -9.0965556182899998e-01, -9.0852625635200002e-01, -9.0739695087500005e-01, \
                                    -9.0626764539799998e-01, -9.0513833992100001e-01, -9.0400903444400005e-01, \
                                    -9.0287972896699997e-01, -9.0175042349000001e-01, -9.0062111801199995e-01, \
                                    -8.9949181253499999e-01, -8.9836250705800003e-01, -8.9723320158099995e-01, \
                                    -8.9610389610399999e-01, -8.9497459062700002e-01, -8.9384528514999995e-01, \
                                    -8.9271597967299998e-01, -8.9158667419500004e-01, -8.9045736871799996e-01, \
                                    -8.8932806324100000e-01, -8.8819875776400004e-01, -8.8706945228699996e-01, \
                                    -8.8594014681000000e-01, -8.8481084133300003e-01, -8.8368153585499998e-01, \
                                    -8.8255223037800001e-01, -8.8142292490100005e-01, -8.8029361942399997e-01, \
                                    -8.7916431394700001e-01, -8.7803500847000004e-01, -8.7690570299299997e-01, \
                                    -8.7577639751600000e-01, -8.7464709203799995e-01, -8.7351778656099999e-01, \
                                    -8.7238848108400002e-01, -8.7125917560699995e-01, -8.7012987012999998e-01, \
                                    -8.6900056465300002e-01, -8.6787125917600005e-01, -8.6674195369800000e-01, \
                                    -8.6561264822100004e-01, -8.6448334274399996e-01, -8.6335403726700000e-01, \
                                    -8.6222473179000003e-01, -8.6109542631299996e-01, -8.5996612083599999e-01, \
                                    -8.5883681535900003e-01, -8.5770750988099997e-01, -8.5657820440400001e-01, \
                                    -8.5544889892700005e-01, -8.5431959344999997e-01, -8.5319028797300001e-01, \
                                    -8.5206098249600004e-01, -8.5093167701899997e-01, -8.4980237154200000e-01, \
                                    -8.4867306606399995e-01, -8.4754376058699998e-01, -8.4641445511000002e-01, \
                                    -8.4528514963300005e-01, -8.4415584415599998e-01, -8.4302653867900001e-01, \
                                    -8.4189723320200005e-01, -8.4076792772400000e-01, -8.3963862224700003e-01, \
                                    -8.3850931676999996e-01, -8.3738001129299999e-01, -8.3625070581600003e-01, \
                                    -8.3512140033899995e-01, -8.3399209486199999e-01, -8.3286278938500002e-01, \
                                    -8.3173348390699997e-01, -8.3060417843000001e-01, -8.2947487295300004e-01, \
                                    -8.2834556747599997e-01, -8.2721626199900000e-01, -8.2608695652200004e-01, \
                                    -8.2495765104499996e-01, -8.2382834556700002e-01, -8.2269904008999994e-01, \
                                    -8.2156973461299998e-01, -8.2044042913600002e-01, -8.1931112365900005e-01, \
                                    -8.1818181818199998e-01, -8.1705251270500001e-01, -8.1592320722800005e-01, \
                                    -8.1479390174999999e-01, -8.1366459627300003e-01, -8.1253529079599995e-01, \
                                    -8.1140598531899999e-01, -8.1027667984200002e-01, -8.0914737436499995e-01, \
                                    -8.0801806888799999e-01, -8.0688876341100002e-01, -8.0575945793299997e-01, \
                                    -8.0463015245600000e-01, -8.0350084697900004e-01, -8.0237154150199996e-01, \
                                    -8.0124223602500000e-01, -8.0011293054800003e-01, -7.9898362507099996e-01, \
                                    -7.9785431959300002e-01, -7.9672501411600005e-01, -7.9559570863899998e-01, \
                                    -7.9446640316200001e-01, -7.9333709768500005e-01, -7.9220779220799997e-01, \
                                    -7.9107848673100001e-01, -7.8994918125400004e-01, -7.8881987577599999e-01, \
                                    -7.8769057029900003e-01, -7.8656126482199995e-01, -7.8543195934499999e-01, \
                                    -7.8430265386800002e-01, -7.8317334839099995e-01, -7.8204404291399998e-01, \
                                    -7.8091473743600004e-01, -7.7978543195899996e-01, -7.7865612648200000e-01, \
                                    -7.7752682100500004e-01, -7.7639751552799996e-01, -7.7526821005100000e-01, \
                                    -7.7413890457400003e-01, -7.7300959909699996e-01, -7.7188029361900001e-01, \
                                    -7.7075098814200005e-01, -7.6962168266499997e-01, -7.6849237718800001e-01, \
                                    -7.6736307171100004e-01, -7.6623376623399997e-01, -7.6510446075700000e-01, \
                                    -7.6397515528000004e-01, -7.6284584980199999e-01, -7.6171654432500002e-01, \
                                    -7.6058723884799995e-01, -7.5945793337099998e-01, -7.5832862789400002e-01, \
                                    -7.5719932241700005e-01, -7.5607001693999998e-01, -7.5494071146200004e-01, \
                                    -7.5381140598499996e-01, -7.5268210050800000e-01, -7.5155279503100003e-01, \
                                    -7.5042348955399996e-01, -7.4929418407699999e-01, -7.4816487860000003e-01, \
                                    -7.4703557312299995e-01, -7.4590626764500001e-01, -7.4477696216800005e-01, \
                                    -7.4364765669099997e-01, -7.4251835121400001e-01, -7.4138904573700004e-01, \
                                    -7.4025974025999997e-01, -7.3913043478300000e-01, -7.3800112930499995e-01, \
                                    -7.3687182382799998e-01, -7.3574251835100002e-01, -7.3461321287400005e-01, \
                                    -7.3348390739699998e-01, -7.3235460192000001e-01, -7.3122529644300005e-01, \
                                    -7.3009599096599997e-01, -7.2896668548800003e-01, -7.2783738001099996e-01, \
                                    -7.2670807453399999e-01, -7.2557876905700003e-01, -7.2444946357999995e-01, \
                                    -7.2332015810299999e-01, -7.2219085262600002e-01, -7.2106154714899995e-01, \
                                    -7.1993224167100001e-01, -7.1880293619400004e-01, -7.1767363071699997e-01, \
                                    -7.1654432524000000e-01, -7.1541501976300004e-01, -7.1428571428599996e-01, \
                                    -7.1315640880900000e-01, -7.1202710333100006e-01, -7.1089779785399998e-01, \
                                    -7.0976849237700002e-01, -7.0863918690000005e-01, -7.0750988142299998e-01, \
                                    -7.0638057594600001e-01, -7.0525127046900005e-01, -7.0412196499199997e-01, \
                                    -7.0299265951400003e-01, -7.0186335403699995e-01, -7.0073404855999999e-01, \
                                    -6.9960474308300002e-01, -6.9847543760599995e-01, -6.9734613212899998e-01, \
                                    -6.9621682665200002e-01, -6.9508752117399997e-01, -6.9395821569700000e-01, \
                                    -6.9282891022000004e-01, -6.9169960474299996e-01, -6.9057029926600000e-01, \
                                    -6.8944099378900003e-01, -6.8831168831199996e-01, -6.8718238283499999e-01, \
                                    -6.8605307735700005e-01, -6.8492377187999998e-01, -6.8379446640300001e-01, \
                                    -6.8266516092600005e-01, -6.8153585544899997e-01, -6.8040654997200001e-01, \
                                    -6.7927724449500004e-01, -6.7814793901799997e-01, -6.7701863354000003e-01, \
                                    -6.7588932806299995e-01, -6.7476002258599999e-01, -6.7363071710900002e-01, \
                                    -6.7250141163199995e-01, -6.7137210615499998e-01, -6.7024280067800002e-01, \
                                    -6.6911349519999996e-01, -6.6798418972300000e-01, -6.6685488424600003e-01, \
                                    -6.6572557876899996e-01, -6.6459627329199999e-01, -6.6346696781500003e-01, \
                                    -6.6233766233799996e-01, -6.6120835686099999e-01, -6.6007905138300005e-01, \
                                    -6.5894974590599997e-01, -6.5782044042900001e-01, -6.5669113495200004e-01, \
                                    -6.5556182947499997e-01, -6.5443252399800000e-01, -6.5330321852100004e-01, \
                                    -6.5217391304299999e-01, -6.5104460756600002e-01, -6.4991530208899995e-01, \
                                    -6.4878599661199998e-01, -6.4765669113500002e-01, -6.4652738565800005e-01, \
                                    -6.4539808018099998e-01, -6.4426877470400001e-01, -6.4313946922599996e-01, \
                                    -6.4201016374900000e-01, -6.4088085827200003e-01, -6.3975155279499996e-01, \
                                    -6.3862224731799999e-01, -6.3749294184100003e-01, -6.3636363636399995e-01, \
                                    -6.3523433088699999e-01, -6.3410502540900004e-01, -6.3297571993199997e-01, \
                                    -6.3184641445500001e-01, -6.3071710897800004e-01, -6.2958780350099997e-01, \
                                    -6.2845849802400000e-01, -6.2732919254700004e-01, -6.2619988706899998e-01, \
                                    -6.2507058159200002e-01, -6.2394127611500005e-01, -6.2281197063799998e-01, \
                                    -6.2168266516100001e-01, -6.2055335968400005e-01, -6.1942405420699997e-01, \
                                    -6.1829474873000001e-01, -6.1716544325199996e-01, -6.1603613777499999e-01, \
                                    -6.1490683229800003e-01, -6.1377752682099995e-01, -6.1264822134399999e-01, \
                                    -6.1151891586700002e-01, -6.1038961038999995e-01, -6.0926030491200001e-01, \
                                    -6.0813099943500004e-01, -6.0700169395799997e-01, -6.0587238848100000e-01, \
                                    -6.0474308300400004e-01, -6.0361377752699996e-01, -6.0248447205000000e-01, \
                                    -6.0135516657300003e-01, -6.0022586109499998e-01, -5.9909655561800002e-01, \
                                    -5.9796725014100005e-01, -5.9683794466399998e-01, -5.9570863918700001e-01, \
                                    -5.9457933371000005e-01, -5.9345002823299997e-01, -5.9232072275600001e-01, \
                                    -5.9119141727799995e-01, -5.9006211180099999e-01, -5.8893280632400002e-01, \
                                    -5.8780350084699995e-01, -5.8667419536999998e-01, -5.8554488989300002e-01, \
                                    -5.8441558441599994e-01, -5.8328627893800000e-01, -5.8215697346100004e-01, \
                                    -5.8102766798399996e-01, -5.7989836250700000e-01, -5.7876905703000003e-01, \
                                    -5.7763975155299996e-01, -5.7651044607599999e-01, -5.7538114059900003e-01, \
                                    -5.7425183512099998e-01, -5.7312252964400001e-01, -5.7199322416700005e-01, \
                                    -5.7086391868999997e-01, -5.6973461321300001e-01, -5.6860530773600004e-01, \
                                    -5.6747600225899997e-01, -5.6634669678100003e-01, -5.6521739130399995e-01, \
                                    -5.6408808582699999e-01, -5.6295878035000002e-01, -5.6182947487299995e-01, \
                                    -5.6070016939599998e-01, -5.5957086391900002e-01, -5.5844155844200005e-01, \
                                    -5.5731225296400000e-01, -5.5618294748700003e-01, -5.5505364200999996e-01, \
                                    -5.5392433653299999e-01, -5.5279503105600003e-01, -5.5166572557899995e-01, \
                                    -5.5053642010199999e-01, -5.4940711462500003e-01, -5.4827780914699997e-01, \
                                    -5.4714850367000001e-01, -5.4601919819300004e-01, -5.4488989271599997e-01, \
                                    -5.4376058723900000e-01, -5.4263128176200004e-01, -5.4150197628499996e-01, \
                                    -5.4037267080700002e-01, -5.3924336532999995e-01, -5.3811405985299998e-01, \
                                    -5.3698475437600002e-01, -5.3585544889900005e-01, -5.3472614342199998e-01, \
                                    -5.3359683794500001e-01, -5.3246753246800005e-01, -5.3133822699000000e-01, \
                                    -5.3020892151300003e-01, -5.2907961603599996e-01, -5.2795031055899999e-01, \
                                    -5.2682100508200003e-01, -5.2569169960499995e-01, -5.2456239412799999e-01, \
                                    -5.2343308865000004e-01, -5.2230378317299997e-01, -5.2117447769600000e-01, \
                                    -5.2004517221900004e-01, -5.1891586674199996e-01, -5.1778656126500000e-01, \
                                    -5.1665725578800004e-01, -5.1552795031099996e-01, -5.1439864483300002e-01, \
                                    -5.1326933935600005e-01, -5.1214003387899998e-01, -5.1101072840200001e-01, \
                                    -5.0988142292500005e-01, -5.0875211744799997e-01, -5.0762281197100001e-01, \
                                    -5.0649350649400005e-01, -5.0536420101599999e-01, -5.0423489553900003e-01, \
                                    -5.0310559006199995e-01, -5.0197628458499999e-01, -5.0084697910800002e-01, \
                                    -4.9971767363100000e-01, -4.9858836815399998e-01, -4.9745906267599999e-01, \
                                    -4.9632975719900002e-01, -4.9520045172200000e-01, -4.9407114624499998e-01, \
                                    -4.9294184076800002e-01, -4.9181253529100000e-01, -4.9068322981399998e-01, \
                                    -4.8955392433700001e-01, -4.8842461885900001e-01, -4.8729531338199999e-01, \
                                    -4.8616600790499997e-01, -4.8503670242800001e-01, -4.8390739695099999e-01, \
                                    -4.8277809147400003e-01, -4.8164878599700001e-01, -4.8051948051900001e-01, \
                                    -4.7939017504199999e-01, -4.7826086956500002e-01, -4.7713156408800000e-01, \
                                    -4.7600225861099998e-01, -4.7487295313400002e-01, -4.7374364765700000e-01, \
                                    -4.7261434217999998e-01, -4.7148503670199998e-01, -4.7035573122500002e-01, \
                                    -4.6922642574800000e-01, -4.6809712027099998e-01, -4.6696781479400001e-01, \
                                    -4.6583850931699999e-01, -4.6470920383999997e-01, -4.6357989836300001e-01, \
                                    -4.6245059288500001e-01, -4.6132128740799999e-01, -4.6019198193100003e-01, \
                                    -4.5906267645400001e-01, -4.5793337097699999e-01, -4.5680406550000002e-01, \
                                    -4.5567476002300000e-01, -4.5454545454500001e-01, -4.5341614906799999e-01, \
                                    -4.5228684359100002e-01, -4.5115753811400000e-01, -4.5002823263699998e-01, \
                                    -4.4889892716000002e-01, -4.4776962168300000e-01, -4.4664031620599998e-01, \
                                    -4.4551101072799998e-01, -4.4438170525100001e-01, -4.4325239977399999e-01, \
                                    -4.4212309429699997e-01, -4.4099378882000001e-01, -4.3986448334299999e-01, \
                                    -4.3873517786600003e-01, -4.3760587238799997e-01, -4.3647656691100001e-01, \
                                    -4.3534726143399999e-01, -4.3421795595700002e-01, -4.3308865048000000e-01, \
                                    -4.3195934500299998e-01, -4.3083003952600002e-01, -4.2970073404900000e-01, \
                                    -4.2857142857100000e-01, -4.2744212309399998e-01, -4.2631281761700002e-01, \
                                    -4.2518351214000000e-01, -4.2405420666299998e-01, -4.2292490118600001e-01, \
                                    -4.2179559570899999e-01, -4.2066629023199997e-01, -4.1953698475399998e-01, \
                                    -4.1840767927700001e-01, -4.1727837379999999e-01, -4.1614906832300003e-01, \
                                    -4.1501976284600001e-01, -4.1389045736899999e-01, -4.1276115189200002e-01, \
                                    -4.1163184641400002e-01, -4.1050254093700000e-01, -4.0937323545999998e-01, \
                                    -4.0824392998300002e-01, -4.0711462450600000e-01, -4.0598531902899998e-01, \
                                    -4.0485601355200002e-01, -4.0372670807500000e-01, -4.0259740259700000e-01, \
                                    -4.0146809711999998e-01, -4.0033879164300001e-01, -3.9920948616599999e-01, \
                                    -3.9808018068899997e-01, -3.9695087521200001e-01, -3.9582156973499999e-01, \
                                    -3.9469226425699999e-01, -3.9356295878000003e-01, -3.9243365330300001e-01, \
                                    -3.9130434782599999e-01, -3.9017504234900002e-01, -3.8904573687200000e-01, \
                                    -3.8791643139499998e-01, -3.8678712591800002e-01, -3.8565782044000002e-01, \
                                    -3.8452851496300000e-01, -3.8339920948599998e-01, -3.8226990400900002e-01, \
                                    -3.8114059853200000e-01, -3.8001129305499998e-01, -3.7888198757800001e-01, \
                                    -3.7775268210099999e-01, -3.7662337662299999e-01, -3.7549407114599997e-01, \
                                    -3.7436476566900001e-01, -3.7323546019199999e-01, -3.7210615471500003e-01, \
                                    -3.7097684923800001e-01, -3.6984754376099999e-01, -3.6871823828299999e-01, \
                                    -3.6758893280600002e-01, -3.6645962732900000e-01, -3.6533032185199998e-01, \
                                    -3.6420101637500002e-01, -3.6307171089800000e-01, -3.6194240542099998e-01, \
                                    -3.6081309994400002e-01, -3.5968379446600002e-01, -3.5855448898900000e-01, \
                                    -3.5742518351199998e-01, -3.5629587803500001e-01, -3.5516657255799999e-01, \
                                    -3.5403726708099997e-01, -3.5290796160400001e-01, -3.5177865612600001e-01, \
                                    -3.5064935064899999e-01, -3.4952004517200003e-01, -3.4839073969500001e-01, \
                                    -3.4726143421799999e-01, -3.4613212874100002e-01, -3.4500282326400000e-01, \
                                    -3.4387351778699998e-01, -3.4274421230899998e-01, -3.4161490683200002e-01, \
                                    -3.4048560135500000e-01, -3.3935629587799998e-01, -3.3822699040100002e-01, \
                                    -3.3709768492400000e-01, -3.3596837944699998e-01, -3.3483907397000001e-01, \
                                    -3.3370976849200001e-01, -3.3258046301499999e-01, -3.3145115753799997e-01, \
                                    -3.3032185206100001e-01, -3.2919254658399999e-01, -3.2806324110700003e-01, \
                                    -3.2693393563000001e-01, -3.2580463015200001e-01, -3.2467532467499999e-01, \
                                    -3.2354601919800002e-01, -3.2241671372100000e-01, -3.2128740824399998e-01, \
                                    -3.2015810276700002e-01, -3.1902879729000000e-01, -3.1789949181299998e-01, \
                                    -3.1677018633499998e-01, -3.1564088085800002e-01, -3.1451157538100000e-01, \
                                    -3.1338226990399998e-01, -3.1225296442700001e-01, -3.1112365894999999e-01, \
                                    -3.0999435347299997e-01, -3.0886504799499997e-01, -3.0773574251800001e-01, \
                                    -3.0660643704099999e-01, -3.0547713156400003e-01, -3.0434782608700001e-01, \
                                    -3.0321852060999999e-01, -3.0208921513300002e-01, -3.0095990965600000e-01, \
                                    -2.9983060417800000e-01, -2.9870129870099998e-01, -2.9757199322400002e-01, \
                                    -2.9644268774700000e-01, -2.9531338226999998e-01, -2.9418407679300002e-01, \
                                    -2.9305477131600000e-01, -2.9192546583899998e-01, -2.9079616036099998e-01, \
                                    -2.8966685488400001e-01, -2.8853754940699999e-01, -2.8740824392999997e-01, \
                                    -2.8627893845300001e-01, -2.8514963297599999e-01, -2.8402032749900002e-01, \
                                    -2.8289102202100003e-01, -2.8176171654400001e-01, -2.8063241106699999e-01, \
                                    -2.7950310559000002e-01, -2.7837380011300000e-01, -2.7724449463599998e-01, \
                                    -2.7611518915900002e-01, -2.7498588368200000e-01, -2.7385657820400000e-01, \
                                    -2.7272727272699998e-01, -2.7159796725000002e-01, -2.7046866177300000e-01, \
                                    -2.6933935629599998e-01, -2.6821005081900001e-01, -2.6708074534199999e-01, \
                                    -2.6595143986399999e-01, -2.6482213438699997e-01, -2.6369282891000001e-01, \
                                    -2.6256352343299999e-01, -2.6143421795600003e-01, -2.6030491247900001e-01, \
                                    -2.5917560700199999e-01, -2.5804630152500002e-01, -2.5691699604700002e-01, \
                                    -2.5578769057000000e-01, -2.5465838509299998e-01, -2.5352907961600002e-01, \
                                    -2.5239977413900000e-01, -2.5127046866199998e-01, -2.5014116318500002e-01, \
                                    -2.4901185770800000e-01, -2.4788255223000000e-01, -2.4675324675300001e-01, \
                                    -2.4562394127600001e-01, -2.4449463579899999e-01, -2.4336533032200000e-01, \
                                    -2.4223602484500001e-01, -2.4110671936799999e-01, -2.3997741388999999e-01, \
                                    -2.3884810841300000e-01, -2.3771880293600001e-01, -2.3658949745899999e-01, \
                                    -2.3546019198199999e-01, -2.3433088650500000e-01, -2.3320158102800001e-01, \
                                    -2.3207227555099999e-01, -2.3094297007299999e-01, -2.2981366459600000e-01, \
                                    -2.2868435911900001e-01, -2.2755505364199999e-01, -2.2642574816500000e-01, \
                                    -2.2529644268800000e-01, -2.2416713721100001e-01, -2.2303783173300001e-01, \
                                    -2.2190852625599999e-01, -2.2077922077900000e-01, -2.1964991530200001e-01, \
                                    -2.1852060982499999e-01, -2.1739130434800000e-01, -2.1626199887100001e-01, \
                                    -2.1513269339400001e-01, -2.1400338791599999e-01, -2.1287408243900000e-01, \
                                    -2.1174477696200000e-01, -2.1061547148500001e-01, -2.0948616600799999e-01, \
                                    -2.0835686053100000e-01, -2.0722755505400001e-01, -2.0609824957699999e-01, \
                                    -2.0496894409899999e-01, -2.0383963862200000e-01, -2.0271033314500000e-01, \
                                    -2.0158102766800001e-01, -2.0045172219099999e-01, -1.9932241671400000e-01, \
                                    -1.9819311123700001e-01, -1.9706380575900001e-01, -1.9593450028199999e-01, \
                                    -1.9480519480500000e-01, -1.9367588932800001e-01, -1.9254658385100001e-01, \
                                    -1.9141727837399999e-01, -1.9028797289700000e-01, -1.8915866742000001e-01, \
                                    -1.8802936194200001e-01, -1.8690005646499999e-01, -1.8577075098800000e-01, \
                                    -1.8464144551100001e-01, -1.8351214003399999e-01, -1.8238283455700000e-01, \
                                    -1.8125352908000000e-01, -1.8012422360200001e-01, -1.7899491812500001e-01, \
                                    -1.7786561264799999e-01, -1.7673630717100000e-01, -1.7560700169400001e-01, \
                                    -1.7447769621699999e-01, -1.7334839074000000e-01, -1.7221908526300000e-01, \
                                    -1.7108977978500001e-01, -1.6996047430799999e-01, -1.6883116883099999e-01, \
                                    -1.6770186335400000e-01, -1.6657255787700001e-01, -1.6544325239999999e-01, \
                                    -1.6431394692300000e-01, -1.6318464144600001e-01, -1.6205533596800001e-01, \
                                    -1.6092603049099999e-01, -1.5979672501400000e-01, -1.5866741953700000e-01, \
                                    -1.5753811406000001e-01, -1.5640880858299999e-01, -1.5527950310600000e-01, \
                                    -1.5415019762800000e-01, -1.5302089215100001e-01, -1.5189158667399999e-01, \
                                    -1.5076228119700000e-01, -1.4963297572000001e-01, -1.4850367024300001e-01, \
                                    -1.4737436476599999e-01, -1.4624505928900000e-01, -1.4511575381100000e-01, \
                                    -1.4398644833400001e-01, -1.4285714285699999e-01, -1.4172783738000000e-01, \
                                    -1.4059853190300001e-01, -1.3946922642599999e-01, -1.3833992094899999e-01, \
                                    -1.3721061547100000e-01, -1.3608130999400000e-01, -1.3495200451700001e-01, \
                                    -1.3382269903999999e-01, -1.3269339356300000e-01, -1.3156408808600001e-01, \
                                    -1.3043478260899999e-01, -1.2930547713200000e-01, -1.2817617165400000e-01, \
                                    -1.2704686617700001e-01, -1.2591756069999999e-01, -1.2478825522299999e-01, \
                                    -1.2365894974600000e-01, -1.2252964426900000e-01, -1.2140033879200000e-01, \
                                    -1.2027103331500000e-01, -1.1914172783700000e-01, -1.1801242235999999e-01, \
                                    -1.1688311688300000e-01, -1.1575381140600000e-01, -1.1462450592900000e-01, \
                                    -1.1349520045200000e-01, -1.1236589497500001e-01, -1.1123658949699999e-01, \
                                    -1.1010728402000000e-01, -1.0897797854300000e-01, -1.0784867306600000e-01, \
                                    -1.0671936758900000e-01, -1.0559006211200000e-01, -1.0446075663500000e-01, \
                                    -1.0333145115800001e-01, -1.0220214567999999e-01, -1.0107284020300000e-01, \
                                    -9.9943534725999997e-02, -9.8814229249000005e-02, -9.7684923771999999e-02, \
                                    -9.6555618295000006e-02, -9.5426312818000000e-02, -9.4297007340000003e-02, \
                                    -9.3167701862999996e-02, -9.2038396386000004e-02, -9.0909090908999998e-02, \
                                    -8.9779785432000006e-02, -8.8650479955000000e-02, -8.7521174477999994e-02, \
                                    -8.6391869001000002e-02, -8.5262563523000004e-02, -8.4133258045999998e-02, \
                                    -8.3003952569000006e-02, -8.1874647092000000e-02, -8.0745341614999994e-02, \
                                    -7.9616036138000001e-02, -7.8486730660999995e-02, -7.7357425184000003e-02, \
                                    -7.6228119706000005e-02, -7.5098814228999999e-02, -7.3969508751999993e-02, \
                                    -7.2840203275000001e-02, -7.1710897797999995e-02, -7.0581592321000003e-02, \
                                    -6.9452286843999997e-02, -6.8322981365999999e-02, -6.7193675889000007e-02, \
                                    -6.6064370412000001e-02, -6.4935064934999995e-02, -6.3805759458000003e-02, \
                                    -6.2676453980999997e-02, -6.1547148503999997e-02, -6.0417843026999998e-02, \
                                    -5.9288537549000001e-02, -5.8159232072000001e-02, -5.7029926595000002e-02, \
                                    -5.5900621118000003e-02, -5.4771315640999997e-02, -5.3642010163999998e-02, \
                                    -5.2512704686999999e-02, -5.1383399210000000e-02, -5.0254093732000002e-02, \
                                    -4.9124788255000003e-02, -4.7995482777999997e-02, -4.6866177300999998e-02, \
                                    -4.5736871823999999e-02, -4.4607566346999999e-02, -4.3478260870000000e-02, \
                                    -4.2348955392000003e-02, -4.1219649915000003e-02, -4.0090344437999997e-02, \
                                    -3.8961038960999998e-02, -3.7831733483999999e-02, -3.6702428007000000e-02, \
                                    -3.5573122530000001e-02, -3.4443817053000002e-02, -3.3314511574999997e-02, \
                                    -3.2185206097999998e-02, -3.1055900620999999e-02, -2.9926595144000000e-02, \
                                    -2.8797289667000001e-02, -2.7667984190000001e-02, -2.6538678712999999e-02, \
                                    -2.5409373235000001e-02, -2.4280067757999999e-02, -2.3150762280999999e-02, \
                                    -2.2021456804000000e-02, -2.0892151327000001e-02, -1.9762845849999999e-02, \
                                    -1.8633540372999999e-02, -1.7504234896000000e-02, -1.6374929417999999e-02, \
                                    -1.5245623941000000e-02, -1.4116318464000001e-02, -1.2987012987000000e-02, \
                                    -1.1857707509999999e-02, -1.0728402033000000e-02, -9.5990965559999992e-03, \
                                    -8.4697910790000001e-03, -7.3404856009999997e-03, -6.2111801239999997e-03, \
                                    -5.0818746469999997e-03, -3.9525691699999997e-03, -2.8232636930000002e-03, \
                                    -1.6939582160000000e-03, -5.6465273899999999e-04,  5.6465273899999999e-04, \
                                    1.6939582160000000e-03,  2.8232636930000002e-03,  3.9525691699999997e-03, \
                                    5.0818746469999997e-03,  6.2111801239999997e-03,  7.3404856009999997e-03, \
                                    8.4697910779999996e-03,  9.5990965559999992e-03,  1.0728402033000000e-02, \
                                    1.1857707509999999e-02,  1.2987012987000000e-02,  1.4116318464000001e-02, \
                                    1.5245623941000000e-02,  1.6374929417999999e-02,  1.7504234896000000e-02, \
                                    1.8633540372999999e-02,  1.9762845849999999e-02,  2.0892151327000001e-02, \
                                    2.2021456804000000e-02,  2.3150762280999999e-02,  2.4280067757999999e-02, \
                                    2.5409373235000001e-02,  2.6538678712999999e-02,  2.7667984190000001e-02, \
                                    2.8797289667000001e-02,  2.9926595144000000e-02,  3.1055900620999999e-02, \
                                    3.2185206097999998e-02,  3.3314511574999997e-02,  3.4443817052000003e-02, \
                                    3.5573122530000001e-02,  3.6702428007000000e-02,  3.7831733483999999e-02, \
                                    3.8961038960999998e-02,  4.0090344437999997e-02,  4.1219649915000003e-02, \
                                    4.2348955392000003e-02,  4.3478260870000000e-02,  4.4607566346999999e-02, \
                                    4.5736871823999999e-02,  4.6866177300999998e-02,  4.7995482777999997e-02, \
                                    4.9124788255000003e-02,  5.0254093732000002e-02,  5.1383399209000001e-02, \
                                    5.2512704686999999e-02,  5.3642010163999998e-02,  5.4771315640999997e-02, \
                                    5.5900621118000003e-02,  5.7029926595000002e-02,  5.8159232072000001e-02, \
                                    5.9288537549000001e-02,  6.0417843026999998e-02,  6.1547148503999997e-02, \
                                    6.2676453980999997e-02,  6.3805759458000003e-02,  6.4935064934999995e-02, \
                                    6.6064370412000001e-02,  6.7193675889000007e-02,  6.8322981365999999e-02, \
                                    6.9452286843999997e-02,  7.0581592321000003e-02,  7.1710897797999995e-02, \
                                    7.2840203275000001e-02,  7.3969508751999993e-02,  7.5098814228999999e-02, \
                                    7.6228119706000005e-02,  7.7357425182999998e-02,  7.8486730660999995e-02, \
                                    7.9616036138000001e-02,  8.0745341614999994e-02,  8.1874647092000000e-02, \
                                    8.3003952569000006e-02,  8.4133258045999998e-02,  8.5262563523000004e-02, \
                                    8.6391869001000002e-02,  8.7521174477999994e-02,  8.8650479955000000e-02, \
                                    8.9779785432000006e-02,  9.0909090908999998e-02,  9.2038396386000004e-02, \
                                    9.3167701862999996e-02,  9.4297007340000003e-02,  9.5426312818000000e-02, \
                                    9.6555618295000006e-02,  9.7684923771999999e-02,  9.8814229249000005e-02, \
                                    9.9943534725999997e-02,  1.0107284020300000e-01,  1.0220214567999999e-01, \
                                    1.0333145115800001e-01,  1.0446075663500000e-01,  1.0559006211200000e-01, \
                                    1.0671936758900000e-01,  1.0784867306600000e-01,  1.0897797854300000e-01, \
                                    1.1010728402000000e-01,  1.1123658949699999e-01,  1.1236589497500001e-01, \
                                    1.1349520045200000e-01,  1.1462450592900000e-01,  1.1575381140600000e-01, \
                                    1.1688311688300000e-01,  1.1801242235999999e-01,  1.1914172783700000e-01, \
                                    1.2027103331400001e-01,  1.2140033879200000e-01,  1.2252964426900000e-01, \
                                    1.2365894974600000e-01,  1.2478825522299999e-01,  1.2591756069999999e-01, \
                                    1.2704686617700001e-01,  1.2817617165400000e-01,  1.2930547713200000e-01, \
                                    1.3043478260899999e-01,  1.3156408808600001e-01,  1.3269339356300000e-01, \
                                    1.3382269903999999e-01,  1.3495200451700001e-01,  1.3608130999400000e-01, \
                                    1.3721061547100000e-01,  1.3833992094899999e-01,  1.3946922642599999e-01, \
                                    1.4059853190300001e-01,  1.4172783738000000e-01,  1.4285714285699999e-01, \
                                    1.4398644833400001e-01,  1.4511575381100000e-01,  1.4624505928900000e-01, \
                                    1.4737436476599999e-01,  1.4850367024300001e-01,  1.4963297572000001e-01, \
                                    1.5076228119700000e-01,  1.5189158667399999e-01,  1.5302089215100001e-01, \
                                    1.5415019762800000e-01,  1.5527950310600000e-01,  1.5640880858299999e-01, \
                                    1.5753811406000001e-01,  1.5866741953700000e-01,  1.5979672501400000e-01, \
                                    1.6092603049099999e-01,  1.6205533596800001e-01,  1.6318464144500000e-01, \
                                    1.6431394692300000e-01,  1.6544325239999999e-01,  1.6657255787700001e-01, \
                                    1.6770186335400000e-01,  1.6883116883099999e-01,  1.6996047430799999e-01, \
                                    1.7108977978500001e-01,  1.7221908526300000e-01,  1.7334839074000000e-01, \
                                    1.7447769621699999e-01,  1.7560700169400001e-01,  1.7673630717100000e-01, \
                                    1.7786561264799999e-01,  1.7899491812500001e-01,  1.8012422360200001e-01, \
                                    1.8125352908000000e-01,  1.8238283455700000e-01,  1.8351214003399999e-01, \
                                    1.8464144551100001e-01,  1.8577075098800000e-01,  1.8690005646499999e-01, \
                                    1.8802936194200001e-01,  1.8915866742000001e-01,  1.9028797289700000e-01, \
                                    1.9141727837399999e-01,  1.9254658385100001e-01,  1.9367588932800001e-01, \
                                    1.9480519480500000e-01,  1.9593450028199999e-01,  1.9706380575900001e-01, \
                                    1.9819311123700001e-01,  1.9932241671400000e-01,  2.0045172219099999e-01, \
                                    2.0158102766800001e-01,  2.0271033314500000e-01,  2.0383963862200000e-01, \
                                    2.0496894409899999e-01,  2.0609824957600001e-01,  2.0722755505400001e-01, \
                                    2.0835686053100000e-01,  2.0948616600799999e-01,  2.1061547148500001e-01, \
                                    2.1174477696200000e-01,  2.1287408243900000e-01,  2.1400338791599999e-01, \
                                    2.1513269339400001e-01,  2.1626199887100001e-01,  2.1739130434800000e-01, \
                                    2.1852060982499999e-01,  2.1964991530200001e-01,  2.2077922077900000e-01, \
                                    2.2190852625599999e-01,  2.2303783173300001e-01,  2.2416713721100001e-01, \
                                    2.2529644268800000e-01,  2.2642574816500000e-01,  2.2755505364199999e-01, \
                                    2.2868435911900001e-01,  2.2981366459600000e-01,  2.3094297007299999e-01, \
                                    2.3207227555099999e-01,  2.3320158102800001e-01,  2.3433088650500000e-01, \
                                    2.3546019198199999e-01,  2.3658949745899999e-01,  2.3771880293600001e-01, \
                                    2.3884810841300000e-01,  2.3997741388999999e-01,  2.4110671936799999e-01, \
                                    2.4223602484500001e-01,  2.4336533032200000e-01,  2.4449463579899999e-01, \
                                    2.4562394127600001e-01,  2.4675324675300001e-01,  2.4788255223000000e-01, \
                                    2.4901185770699999e-01,  2.5014116318500002e-01,  2.5127046866199998e-01, \
                                    2.5239977413900000e-01,  2.5352907961600002e-01,  2.5465838509299998e-01, \
                                    2.5578769057000000e-01,  2.5691699604700002e-01,  2.5804630152500002e-01, \
                                    2.5917560700199999e-01,  2.6030491247900001e-01,  2.6143421795600003e-01, \
                                    2.6256352343299999e-01,  2.6369282891000001e-01,  2.6482213438699997e-01, \
                                    2.6595143986399999e-01,  2.6708074534199999e-01,  2.6821005081900001e-01, \
                                    2.6933935629599998e-01,  2.7046866177300000e-01,  2.7159796725000002e-01, \
                                    2.7272727272699998e-01,  2.7385657820400000e-01,  2.7498588368200000e-01, \
                                    2.7611518915900002e-01,  2.7724449463599998e-01,  2.7837380011300000e-01, \
                                    2.7950310559000002e-01,  2.8063241106699999e-01,  2.8176171654400001e-01, \
                                    2.8289102202100003e-01,  2.8402032749900002e-01,  2.8514963297599999e-01, \
                                    2.8627893845300001e-01,  2.8740824392999997e-01,  2.8853754940699999e-01, \
                                    2.8966685488400001e-01,  2.9079616036099998e-01,  2.9192546583800000e-01, \
                                    2.9305477131600000e-01,  2.9418407679300002e-01,  2.9531338226999998e-01, \
                                    2.9644268774700000e-01,  2.9757199322400002e-01,  2.9870129870099998e-01, \
                                    2.9983060417800000e-01,  3.0095990965600000e-01,  3.0208921513300002e-01, \
                                    3.0321852060999999e-01,  3.0434782608700001e-01,  3.0547713156400003e-01, \
                                    3.0660643704099999e-01,  3.0773574251800001e-01,  3.0886504799499997e-01, \
                                    3.0999435347299997e-01,  3.1112365894999999e-01,  3.1225296442700001e-01, \
                                    3.1338226990399998e-01,  3.1451157538100000e-01,  3.1564088085800002e-01, \
                                    3.1677018633499998e-01,  3.1789949181299998e-01,  3.1902879729000000e-01, \
                                    3.2015810276700002e-01,  3.2128740824399998e-01,  3.2241671372100000e-01, \
                                    3.2354601919800002e-01,  3.2467532467499999e-01,  3.2580463015200001e-01, \
                                    3.2693393563000001e-01,  3.2806324110700003e-01,  3.2919254658399999e-01, \
                                    3.3032185206100001e-01,  3.3145115753799997e-01,  3.3258046301499999e-01, \
                                    3.3370976849200001e-01,  3.3483907396899998e-01,  3.3596837944699998e-01, \
                                    3.3709768492400000e-01,  3.3822699040100002e-01,  3.3935629587799998e-01, \
                                    3.4048560135500000e-01,  3.4161490683200002e-01,  3.4274421230899998e-01, \
                                    3.4387351778699998e-01,  3.4500282326400000e-01,  3.4613212874100002e-01, \
                                    3.4726143421799999e-01,  3.4839073969500001e-01,  3.4952004517200003e-01, \
                                    3.5064935064899999e-01,  3.5177865612600001e-01,  3.5290796160400001e-01, \
                                    3.5403726708099997e-01,  3.5516657255799999e-01,  3.5629587803500001e-01, \
                                    3.5742518351199998e-01,  3.5855448898900000e-01,  3.5968379446600002e-01, \
                                    3.6081309994400002e-01,  3.6194240542099998e-01,  3.6307171089800000e-01, \
                                    3.6420101637500002e-01,  3.6533032185199998e-01,  3.6645962732900000e-01, \
                                    3.6758893280600002e-01,  3.6871823828299999e-01,  3.6984754376099999e-01, \
                                    3.7097684923800001e-01,  3.7210615471500003e-01,  3.7323546019199999e-01, \
                                    3.7436476566900001e-01,  3.7549407114599997e-01,  3.7662337662299999e-01, \
                                    3.7775268210000001e-01,  3.7888198757800001e-01,  3.8001129305499998e-01, \
                                    3.8114059853200000e-01,  3.8226990400900002e-01,  3.8339920948599998e-01, \
                                    3.8452851496300000e-01,  3.8565782044000002e-01,  3.8678712591800002e-01, \
                                    3.8791643139499998e-01,  3.8904573687200000e-01,  3.9017504234900002e-01, \
                                    3.9130434782599999e-01,  3.9243365330300001e-01,  3.9356295878000003e-01, \
                                    3.9469226425699999e-01,  3.9582156973499999e-01,  3.9695087521200001e-01, \
                                    3.9808018068899997e-01,  3.9920948616599999e-01,  4.0033879164300001e-01, \
                                    4.0146809711999998e-01,  4.0259740259700000e-01,  4.0372670807500000e-01, \
                                    4.0485601355200002e-01,  4.0598531902899998e-01,  4.0711462450600000e-01, \
                                    4.0824392998300002e-01,  4.0937323545999998e-01,  4.1050254093700000e-01, \
                                    4.1163184641400002e-01,  4.1276115189200002e-01,  4.1389045736899999e-01, \
                                    4.1501976284600001e-01,  4.1614906832300003e-01,  4.1727837379999999e-01, \
                                    4.1840767927700001e-01,  4.1953698475399998e-01,  4.2066629023100000e-01, \
                                    4.2179559570899999e-01,  4.2292490118600001e-01,  4.2405420666299998e-01, \
                                    4.2518351214000000e-01,  4.2631281761700002e-01,  4.2744212309399998e-01, \
                                    4.2857142857100000e-01,  4.2970073404900000e-01,  4.3083003952600002e-01, \
                                    4.3195934500299998e-01,  4.3308865048000000e-01,  4.3421795595700002e-01, \
                                    4.3534726143399999e-01,  4.3647656691100001e-01,  4.3760587238799997e-01, \
                                    4.3873517786600003e-01,  4.3986448334299999e-01,  4.4099378882000001e-01, \
                                    4.4212309429699997e-01,  4.4325239977399999e-01,  4.4438170525100001e-01, \
                                    4.4551101072799998e-01,  4.4664031620599998e-01,  4.4776962168300000e-01, \
                                    4.4889892716000002e-01,  4.5002823263699998e-01,  4.5115753811400000e-01, \
                                    4.5228684359100002e-01,  4.5341614906799999e-01,  4.5454545454500001e-01, \
                                    4.5567476002300000e-01,  4.5680406550000002e-01,  4.5793337097699999e-01, \
                                    4.5906267645400001e-01,  4.6019198193100003e-01,  4.6132128740799999e-01, \
                                    4.6245059288500001e-01,  4.6357989836199998e-01,  4.6470920383999997e-01, \
                                    4.6583850931699999e-01,  4.6696781479400001e-01,  4.6809712027099998e-01, \
                                    4.6922642574800000e-01,  4.7035573122500002e-01,  4.7148503670199998e-01, \
                                    4.7261434217999998e-01,  4.7374364765700000e-01,  4.7487295313400002e-01, \
                                    4.7600225861099998e-01,  4.7713156408800000e-01,  4.7826086956500002e-01, \
                                    4.7939017504199999e-01,  4.8051948051900001e-01,  4.8164878599700001e-01, \
                                    4.8277809147400003e-01,  4.8390739695099999e-01,  4.8503670242800001e-01, \
                                    4.8616600790499997e-01,  4.8729531338199999e-01,  4.8842461885900001e-01, \
                                    4.8955392433700001e-01,  4.9068322981399998e-01,  4.9181253529100000e-01, \
                                    4.9294184076800002e-01,  4.9407114624499998e-01,  4.9520045172200000e-01, \
                                    4.9632975719900002e-01,  4.9745906267599999e-01,  4.9858836815399998e-01, \
                                    4.9971767363100000e-01,  5.0084697910800002e-01,  5.0197628458499999e-01, \
                                    5.0310559006199995e-01,  5.0423489553900003e-01,  5.0536420101599999e-01, \
                                    5.0649350649299996e-01,  5.0762281197100001e-01,  5.0875211744799997e-01, \
                                    5.0988142292500005e-01,  5.1101072840200001e-01,  5.1214003387899998e-01, \
                                    5.1326933935600005e-01,  5.1439864483300002e-01,  5.1552795031099996e-01, \
                                    5.1665725578800004e-01,  5.1778656126500000e-01,  5.1891586674199996e-01, \
                                    5.2004517221900004e-01,  5.2117447769600000e-01,  5.2230378317299997e-01, \
                                    5.2343308865000004e-01,  5.2456239412799999e-01,  5.2569169960499995e-01, \
                                    5.2682100508200003e-01,  5.2795031055899999e-01,  5.2907961603599996e-01, \
                                    5.3020892151300003e-01,  5.3133822699000000e-01,  5.3246753246800005e-01, \
                                    5.3359683794500001e-01,  5.3472614342199998e-01,  5.3585544889900005e-01, \
                                    5.3698475437600002e-01,  5.3811405985299998e-01,  5.3924336532999995e-01, \
                                    5.4037267080700002e-01,  5.4150197628499996e-01,  5.4263128176200004e-01, \
                                    5.4376058723900000e-01,  5.4488989271599997e-01,  5.4601919819300004e-01, \
                                    5.4714850367000001e-01,  5.4827780914699997e-01,  5.4940711462400005e-01, \
                                    5.5053642010199999e-01,  5.5166572557899995e-01,  5.5279503105600003e-01, \
                                    5.5392433653299999e-01,  5.5505364200999996e-01,  5.5618294748700003e-01, \
                                    5.5731225296400000e-01,  5.5844155844200005e-01,  5.5957086391900002e-01, \
                                    5.6070016939599998e-01,  5.6182947487299995e-01,  5.6295878035000002e-01, \
                                    5.6408808582699999e-01,  5.6521739130399995e-01,  5.6634669678100003e-01, \
                                    5.6747600225899997e-01,  5.6860530773600004e-01,  5.6973461321300001e-01, \
                                    5.7086391868999997e-01,  5.7199322416700005e-01,  5.7312252964400001e-01, \
                                    5.7425183512099998e-01,  5.7538114059900003e-01,  5.7651044607599999e-01, \
                                    5.7763975155299996e-01,  5.7876905703000003e-01,  5.7989836250700000e-01, \
                                    5.8102766798399996e-01,  5.8215697346100004e-01,  5.8328627893800000e-01, \
                                    5.8441558441599994e-01,  5.8554488989300002e-01,  5.8667419536999998e-01, \
                                    5.8780350084699995e-01,  5.8893280632400002e-01,  5.9006211180099999e-01, \
                                    5.9119141727799995e-01,  5.9232072275500003e-01,  5.9345002823299997e-01, \
                                    5.9457933371000005e-01,  5.9570863918700001e-01,  5.9683794466399998e-01, \
                                    5.9796725014100005e-01,  5.9909655561800002e-01,  6.0022586109499998e-01, \
                                    6.0135516657300003e-01,  6.0248447205000000e-01,  6.0361377752699996e-01, \
                                    6.0474308300400004e-01,  6.0587238848100000e-01,  6.0700169395799997e-01, \
                                    6.0813099943500004e-01,  6.0926030491200001e-01,  6.1038961038999995e-01, \
                                    6.1151891586700002e-01,  6.1264822134399999e-01,  6.1377752682099995e-01, \
                                    6.1490683229800003e-01,  6.1603613777499999e-01,  6.1716544325199996e-01, \
                                    6.1829474873000001e-01,  6.1942405420699997e-01,  6.2055335968400005e-01, \
                                    6.2168266516100001e-01,  6.2281197063799998e-01,  6.2394127611500005e-01, \
                                    6.2507058159200002e-01,  6.2619988706899998e-01,  6.2732919254700004e-01, \
                                    6.2845849802400000e-01,  6.2958780350099997e-01,  6.3071710897800004e-01, \
                                    6.3184641445500001e-01,  6.3297571993199997e-01,  6.3410502540900004e-01, \
                                    6.3523433088600001e-01,  6.3636363636399995e-01,  6.3749294184100003e-01, \
                                    6.3862224731799999e-01,  6.3975155279499996e-01,  6.4088085827200003e-01, \
                                    6.4201016374900000e-01,  6.4313946922599996e-01,  6.4426877470400001e-01, \
                                    6.4539808018099998e-01,  6.4652738565800005e-01,  6.4765669113500002e-01, \
                                    6.4878599661199998e-01,  6.4991530208899995e-01,  6.5104460756600002e-01, \
                                    6.5217391304299999e-01,  6.5330321852100004e-01,  6.5443252399800000e-01, \
                                    6.5556182947499997e-01,  6.5669113495200004e-01,  6.5782044042900001e-01, \
                                    6.5894974590599997e-01,  6.6007905138300005e-01,  6.6120835686099999e-01, \
                                    6.6233766233799996e-01,  6.6346696781500003e-01,  6.6459627329199999e-01, \
                                    6.6572557876899996e-01,  6.6685488424600003e-01,  6.6798418972300000e-01, \
                                    6.6911349519999996e-01,  6.7024280067800002e-01,  6.7137210615499998e-01, \
                                    6.7250141163199995e-01,  6.7363071710900002e-01,  6.7476002258599999e-01, \
                                    6.7588932806299995e-01,  6.7701863354000003e-01,  6.7814793901699999e-01, \
                                    6.7927724449500004e-01,  6.8040654997200001e-01,  6.8153585544899997e-01, \
                                    6.8266516092600005e-01,  6.8379446640300001e-01,  6.8492377187999998e-01, \
                                    6.8605307735700005e-01,  6.8718238283499999e-01,  6.8831168831199996e-01, \
                                    6.8944099378900003e-01,  6.9057029926600000e-01,  6.9169960474299996e-01, \
                                    6.9282891022000004e-01,  6.9395821569700000e-01,  6.9508752117399997e-01, \
                                    6.9621682665200002e-01,  6.9734613212899998e-01,  6.9847543760599995e-01, \
                                    6.9960474308300002e-01,  7.0073404855999999e-01,  7.0186335403699995e-01, \
                                    7.0299265951400003e-01,  7.0412196499199997e-01,  7.0525127046900005e-01, \
                                    7.0638057594600001e-01,  7.0750988142299998e-01,  7.0863918690000005e-01, \
                                    7.0976849237700002e-01,  7.1089779785399998e-01,  7.1202710333100006e-01, \
                                    7.1315640880900000e-01,  7.1428571428599996e-01,  7.1541501976300004e-01, \
                                    7.1654432524000000e-01,  7.1767363071699997e-01,  7.1880293619400004e-01, \
                                    7.1993224167100001e-01,  7.2106154714799997e-01,  7.2219085262600002e-01, \
                                    7.2332015810299999e-01,  7.2444946357999995e-01,  7.2557876905700003e-01, \
                                    7.2670807453399999e-01,  7.2783738001099996e-01,  7.2896668548800003e-01, \
                                    7.3009599096599997e-01,  7.3122529644300005e-01,  7.3235460192000001e-01, \
                                    7.3348390739699998e-01,  7.3461321287400005e-01,  7.3574251835100002e-01, \
                                    7.3687182382799998e-01,  7.3800112930499995e-01,  7.3913043478300000e-01, \
                                    7.4025974025999997e-01,  7.4138904573700004e-01,  7.4251835121400001e-01, \
                                    7.4364765669099997e-01,  7.4477696216800005e-01,  7.4590626764500001e-01, \
                                    7.4703557312299995e-01,  7.4816487860000003e-01,  7.4929418407699999e-01, \
                                    7.5042348955399996e-01,  7.5155279503100003e-01,  7.5268210050800000e-01, \
                                    7.5381140598499996e-01,  7.5494071146200004e-01,  7.5607001693999998e-01, \
                                    7.5719932241700005e-01,  7.5832862789400002e-01,  7.5945793337099998e-01, \
                                    7.6058723884799995e-01,  7.6171654432500002e-01,  7.6284584980199999e-01, \
                                    7.6397515527899995e-01,  7.6510446075700000e-01,  7.6623376623399997e-01, \
                                    7.6736307171100004e-01,  7.6849237718800001e-01,  7.6962168266499997e-01, \
                                    7.7075098814200005e-01,  7.7188029361900001e-01,  7.7300959909699996e-01, \
                                    7.7413890457400003e-01,  7.7526821005100000e-01,  7.7639751552799996e-01, \
                                    7.7752682100500004e-01,  7.7865612648200000e-01,  7.7978543195899996e-01, \
                                    7.8091473743600004e-01,  7.8204404291399998e-01,  7.8317334839099995e-01, \
                                    7.8430265386800002e-01,  7.8543195934499999e-01,  7.8656126482199995e-01, \
                                    7.8769057029900003e-01,  7.8881987577599999e-01,  7.8994918125400004e-01, \
                                    7.9107848673100001e-01,  7.9220779220799997e-01,  7.9333709768500005e-01, \
                                    7.9446640316200001e-01,  7.9559570863899998e-01,  7.9672501411600005e-01, \
                                    7.9785431959300002e-01,  7.9898362507099996e-01,  8.0011293054800003e-01, \
                                    8.0124223602500000e-01,  8.0237154150199996e-01,  8.0350084697900004e-01, \
                                    8.0463015245600000e-01,  8.0575945793299997e-01,  8.0688876341000004e-01, \
                                    8.0801806888799999e-01,  8.0914737436499995e-01,  8.1027667984200002e-01, \
                                    8.1140598531899999e-01,  8.1253529079599995e-01,  8.1366459627300003e-01, \
                                    8.1479390174999999e-01,  8.1592320722800005e-01,  8.1705251270500001e-01, \
                                    8.1818181818199998e-01,  8.1931112365900005e-01,  8.2044042913600002e-01, \
                                    8.2156973461299998e-01,  8.2269904008999994e-01,  8.2382834556700002e-01, \
                                    8.2495765104499996e-01,  8.2608695652200004e-01,  8.2721626199900000e-01, \
                                    8.2834556747599997e-01,  8.2947487295300004e-01,  8.3060417843000001e-01, \
                                    8.3173348390699997e-01,  8.3286278938500002e-01,  8.3399209486199999e-01, \
                                    8.3512140033899995e-01,  8.3625070581600003e-01,  8.3738001129299999e-01, \
                                    8.3850931676999996e-01,  8.3963862224700003e-01,  8.4076792772400000e-01, \
                                    8.4189723320200005e-01,  8.4302653867900001e-01,  8.4415584415599998e-01, \
                                    8.4528514963300005e-01,  8.4641445511000002e-01,  8.4754376058699998e-01, \
                                    8.4867306606399995e-01,  8.4980237154100002e-01,  8.5093167701899997e-01, \
                                    8.5206098249600004e-01,  8.5319028797300001e-01,  8.5431959344999997e-01, \
                                    8.5544889892700005e-01,  8.5657820440400001e-01,  8.5770750988099997e-01, \
                                    8.5883681535900003e-01,  8.5996612083599999e-01,  8.6109542631299996e-01, \
                                    8.6222473179000003e-01,  8.6335403726700000e-01,  8.6448334274399996e-01, \
                                    8.6561264822100004e-01,  8.6674195369800000e-01,  8.6787125917600005e-01, \
                                    8.6900056465300002e-01,  8.7012987012999998e-01,  8.7125917560699995e-01, \
                                    8.7238848108400002e-01,  8.7351778656099999e-01,  8.7464709203799995e-01, \
                                    8.7577639751600000e-01,  8.7690570299299997e-01,  8.7803500847000004e-01, \
                                    8.7916431394700001e-01,  8.8029361942399997e-01,  8.8142292490100005e-01, \
                                    8.8255223037800001e-01,  8.8368153585499998e-01,  8.8481084133300003e-01, \
                                    8.8594014681000000e-01,  8.8706945228699996e-01,  8.8819875776400004e-01, \
                                    8.8932806324100000e-01,  8.9045736871799996e-01,  8.9158667419500004e-01, \
                                    8.9271597967200000e-01,  8.9384528514999995e-01,  8.9497459062700002e-01, \
                                    8.9610389610399999e-01,  8.9723320158099995e-01,  8.9836250705800003e-01, \
                                    8.9949181253499999e-01,  9.0062111801199995e-01,  9.0175042349000001e-01, \
                                    9.0287972896699997e-01,  9.0400903444400005e-01,  9.0513833992100001e-01, \
                                    9.0626764539799998e-01,  9.0739695087500005e-01,  9.0852625635200002e-01, \
                                    9.0965556182899998e-01,  9.1078486730700003e-01,  9.1191417278400000e-01, \
                                    9.1304347826099996e-01,  9.1417278373800004e-01,  9.1530208921500000e-01, \
                                    9.1643139469199997e-01,  9.1756070016900004e-01,  9.1869000564699999e-01, \
                                    9.1981931112399995e-01,  9.2094861660100003e-01,  9.2207792207799999e-01, \
                                    9.2320722755499995e-01,  9.2433653303200003e-01,  9.2546583850899999e-01, \
                                    9.2659514398599996e-01,  9.2772444946400001e-01,  9.2885375494099998e-01, \
                                    9.2998306041800005e-01,  9.3111236589500002e-01,  9.3224167137199998e-01, \
                                    9.3337097684899994e-01,  9.3450028232600002e-01,  9.3562958780299998e-01, \
                                    9.3675889328100004e-01,  9.3788819875800000e-01,  9.3901750423499997e-01, \
                                    9.4014680971200004e-01,  9.4127611518900001e-01,  9.4240542066599997e-01, \
                                    9.4353472614300005e-01,  9.4466403162099999e-01,  9.4579333709799995e-01, \
                                    9.4692264257500003e-01,  9.4805194805199999e-01,  9.4918125352899996e-01, \
                                    9.5031055900600003e-01,  9.5143986448300000e-01,  9.5256916995999996e-01, \
                                    9.5369847543800002e-01,  9.5482778091499998e-01,  9.5595708639200005e-01, \
                                    9.5708639186900002e-01,  9.5821569734599998e-01,  9.5934500282299995e-01, \
                                    9.6047430830000002e-01,  9.6160361377799997e-01,  9.6273291925500004e-01, \
                                    9.6386222473200001e-01,  9.6499153020899997e-01,  9.6612083568600005e-01, \
                                    9.6725014116300001e-01,  9.6837944663999997e-01,  9.6950875211700005e-01, \
                                    9.7063805759499999e-01,  9.7176736307199996e-01,  9.7289666854900003e-01, \
                                    9.7402597402600000e-01,  9.7515527950299996e-01,  9.7628458498000004e-01, \
                                    9.7741389045700000e-01,  9.7854319593399997e-01,  9.7967250141200002e-01, \
                                    9.8080180688899998e-01,  9.8193111236599995e-01,  9.8306041784300002e-01, \
                                    9.8418972331999999e-01,  9.8531902879699995e-01,  9.8644833427400003e-01, \
                                    9.8757763975199997e-01,  9.8870694522900004e-01,  9.8983625070600001e-01, \
                                    9.9096555618299997e-01,  9.9209486166000005e-01,  9.9322416713700001e-01, \
                                    9.9435347261399998e-01,  9.9548277809100005e-01,  9.9661208356900000e-01, \
                                    9.9774138904599996e-01,  9.9887069452300004e-01,  1.0000000000000000e+00, \
                                    -1.0000000000000000e+00, -9.9901185770800005e-01, -9.9802371541500001e-01, \
                                    -9.9703557312299995e-01, -9.9604743083000002e-01, -9.9505928853799996e-01, \
                                    -9.9407114624500004e-01, -9.9308300395299998e-01, -9.9209486166000005e-01, \
                                    -9.9110671936799999e-01, -9.9011857707499995e-01, -9.8913043478300000e-01, \
                                    -9.8814229248999996e-01, -9.8715415019800001e-01, -9.8616600790499997e-01, \
                                    -9.8517786561300003e-01, -9.8418972331999999e-01, -9.8320158102800004e-01, \
                                    -9.8221343873500000e-01, -9.8122529644300005e-01, -9.8023715415000001e-01, \
                                    -9.7924901185799995e-01, -9.7826086956500002e-01, -9.7727272727299996e-01, \
                                    -9.7628458498000004e-01, -9.7529644268799998e-01, -9.7430830039500005e-01, \
                                    -9.7332015810299999e-01, -9.7233201580999995e-01, -9.7134387351800000e-01, \
                                    -9.7035573122499996e-01, -9.6936758893300001e-01, -9.6837944663999997e-01, \
                                    -9.6739130434800003e-01, -9.6640316205499999e-01, -9.6541501976300004e-01, \
                                    -9.6442687747000000e-01, -9.6343873517800005e-01, -9.6245059288500001e-01, \
                                    -9.6146245059299995e-01, -9.6047430830000002e-01, -9.5948616600799996e-01, \
                                    -9.5849802371500004e-01, -9.5750988142299998e-01, -9.5652173913000005e-01, \
                                    -9.5553359683799999e-01, -9.5454545454499995e-01, -9.5355731225300000e-01, \
                                    -9.5256916995999996e-01, -9.5158102766800001e-01, -9.5059288537499997e-01, \
                                    -9.4960474308300002e-01, -9.4861660079099996e-01, -9.4762845849800004e-01, \
                                    -9.4664031620599998e-01, -9.4565217391300005e-01, -9.4466403162099999e-01, \
                                    -9.4367588932799995e-01, -9.4268774703600000e-01, -9.4169960474299996e-01, \
                                    -9.4071146245100001e-01, -9.3972332015799998e-01, -9.3873517786600003e-01, \
                                    -9.3774703557299999e-01, -9.3675889328100004e-01, -9.3577075098800000e-01, \
                                    -9.3478260869600005e-01, -9.3379446640300001e-01, -9.3280632411099995e-01, \
                                    -9.3181818181800002e-01, -9.3083003952599996e-01, -9.2984189723300004e-01, \
                                    -9.2885375494099998e-01, -9.2786561264800005e-01, -9.2687747035599999e-01, \
                                    -9.2588932806299995e-01, -9.2490118577100000e-01, -9.2391304347799996e-01, \
                                    -9.2292490118600001e-01, -9.2193675889299997e-01, -9.2094861660100003e-01, \
                                    -9.1996047430799999e-01, -9.1897233201600004e-01, -9.1798418972300000e-01, \
                                    -9.1699604743100005e-01, -9.1600790513800001e-01, -9.1501976284599995e-01, \
                                    -9.1403162055300002e-01, -9.1304347826099996e-01, -9.1205533596800004e-01, \
                                    -9.1106719367599998e-01, -9.1007905138300005e-01, -9.0909090909099999e-01, \
                                    -9.0810276679799995e-01, -9.0711462450600000e-01, -9.0612648221299996e-01, \
                                    -9.0513833992100001e-01, -9.0415019762799997e-01, -9.0316205533600002e-01, \
                                    -9.0217391304299999e-01, -9.0118577075100004e-01, -9.0019762845800000e-01, \
                                    -8.9920948616600005e-01, -8.9822134387399999e-01, -8.9723320158099995e-01, \
                                    -8.9624505928900000e-01, -8.9525691699599996e-01, -8.9426877470400001e-01, \
                                    -8.9328063241099998e-01, -8.9229249011900003e-01, -8.9130434782599999e-01, \
                                    -8.9031620553400004e-01, -8.8932806324100000e-01, -8.8833992094900005e-01, \
                                    -8.8735177865600001e-01, -8.8636363636399995e-01, -8.8537549407100002e-01, \
                                    -8.8438735177899996e-01, -8.8339920948600004e-01, -8.8241106719399998e-01, \
                                    -8.8142292490100005e-01, -8.8043478260899999e-01, -8.7944664031599995e-01, \
                                    -8.7845849802400000e-01, -8.7747035573099996e-01, -8.7648221343900001e-01, \
                                    -8.7549407114599997e-01, -8.7450592885400003e-01, -8.7351778656099999e-01, \
                                    -8.7252964426900004e-01, -8.7154150197600000e-01, -8.7055335968400005e-01, \
                                    -8.6956521739100001e-01, -8.6857707509899995e-01, -8.6758893280600002e-01, \
                                    -8.6660079051399996e-01, -8.6561264822100004e-01, -8.6462450592899998e-01, \
                                    -8.6363636363600005e-01, -8.6264822134399999e-01, -8.6166007905099995e-01, \
                                    -8.6067193675900000e-01, -8.5968379446599996e-01, -8.5869565217400001e-01, \
                                    -8.5770750988099997e-01, -8.5671936758900002e-01, -8.5573122529599999e-01, \
                                    -8.5474308300400004e-01, -8.5375494071100000e-01, -8.5276679841900005e-01, \
                                    -8.5177865612600001e-01, -8.5079051383399995e-01, -8.4980237154200000e-01, \
                                    -8.4881422924899996e-01, -8.4782608695700001e-01, -8.4683794466399998e-01, \
                                    -8.4584980237200003e-01, -8.4486166007899999e-01, -8.4387351778700004e-01, \
                                    -8.4288537549400000e-01, -8.4189723320200005e-01, -8.4090909090900001e-01, \
                                    -8.3992094861699995e-01, -8.3893280632400002e-01, -8.3794466403199996e-01, \
                                    -8.3695652173900004e-01, -8.3596837944699998e-01, -8.3498023715400005e-01, \
                                    -8.3399209486199999e-01, -8.3300395256899995e-01, -8.3201581027700000e-01, \
                                    -8.3102766798399996e-01, -8.3003952569200001e-01, -8.2905138339899997e-01, \
                                    -8.2806324110700003e-01, -8.2707509881399999e-01, -8.2608695652200004e-01, \
                                    -8.2509881422900000e-01, -8.2411067193700005e-01, -8.2312252964400001e-01, \
                                    -8.2213438735199995e-01, -8.2114624505900002e-01, -8.2015810276699996e-01, \
                                    -8.1916996047400004e-01, -8.1818181818199998e-01, -8.1719367588900005e-01, \
                                    -8.1620553359699999e-01, -8.1521739130399995e-01, -8.1422924901200000e-01, \
                                    -8.1324110671899996e-01, -8.1225296442700001e-01, -8.1126482213399997e-01, \
                                    -8.1027667984200002e-01, -8.0928853754899999e-01, -8.0830039525700004e-01, \
                                    -8.0731225296400000e-01, -8.0632411067200005e-01, -8.0533596837900001e-01, \
                                    -8.0434782608699995e-01, -8.0335968379400002e-01, -8.0237154150199996e-01, \
                                    -8.0138339920900004e-01, -8.0039525691699998e-01, -7.9940711462500003e-01, \
                                    -7.9841897233199999e-01, -7.9743083004000004e-01, -7.9644268774700000e-01, \
                                    -7.9545454545500005e-01, -7.9446640316200001e-01, -7.9347826086999995e-01, \
                                    -7.9249011857700002e-01, -7.9150197628499996e-01, -7.9051383399200004e-01, \
                                    -7.8952569169999998e-01, -7.8853754940700005e-01, -7.8754940711499999e-01, \
                                    -7.8656126482199995e-01, -7.8557312253000000e-01, -7.8458498023699996e-01, \
                                    -7.8359683794500001e-01, -7.8260869565199997e-01, -7.8162055336000003e-01, \
                                    -7.8063241106699999e-01, -7.7964426877500004e-01, -7.7865612648200000e-01, \
                                    -7.7766798419000005e-01, -7.7667984189700001e-01, -7.7569169960499995e-01, \
                                    -7.7470355731200002e-01, -7.7371541501999996e-01, -7.7272727272700004e-01, \
                                    -7.7173913043499998e-01, -7.7075098814200005e-01, -7.6976284584999999e-01, \
                                    -7.6877470355699995e-01, -7.6778656126500000e-01, -7.6679841897199996e-01, \
                                    -7.6581027668000001e-01, -7.6482213438699997e-01, -7.6383399209500003e-01, \
                                    -7.6284584980199999e-01, -7.6185770751000004e-01, -7.6086956521700000e-01, \
                                    -7.5988142292500005e-01, -7.5889328063200001e-01, -7.5790513833999995e-01, \
                                    -7.5691699604700002e-01, -7.5592885375499996e-01, -7.5494071146200004e-01, \
                                    -7.5395256916999998e-01, -7.5296442687700005e-01, -7.5197628458499999e-01, \
                                    -7.5098814229199995e-01, -7.5000000000000000e-01, -7.4901185770800005e-01, \
                                    -7.4802371541500001e-01, -7.4703557312299995e-01, -7.4604743083000002e-01, \
                                    -7.4505928853799996e-01, -7.4407114624500004e-01, -7.4308300395299998e-01, \
                                    -7.4209486166000005e-01, -7.4110671936799999e-01, -7.4011857707499995e-01, \
                                    -7.3913043478300000e-01, -7.3814229248999996e-01, -7.3715415019800001e-01, \
                                    -7.3616600790499997e-01, -7.3517786561300003e-01, -7.3418972331999999e-01, \
                                    -7.3320158102800004e-01, -7.3221343873500000e-01, -7.3122529644300005e-01, \
                                    -7.3023715415000001e-01, -7.2924901185799995e-01, -7.2826086956500002e-01, \
                                    -7.2727272727299996e-01, -7.2628458498000004e-01, -7.2529644268799998e-01, \
                                    -7.2430830039500005e-01, -7.2332015810299999e-01, -7.2233201580999995e-01, \
                                    -7.2134387351800000e-01, -7.2035573122499996e-01, -7.1936758893300001e-01, \
                                    -7.1837944663999997e-01, -7.1739130434800003e-01, -7.1640316205499999e-01, \
                                    -7.1541501976300004e-01, -7.1442687747000000e-01, -7.1343873517800005e-01, \
                                    -7.1245059288500001e-01, -7.1146245059299995e-01, -7.1047430830000002e-01, \
                                    -7.0948616600799996e-01, -7.0849802371500004e-01, -7.0750988142299998e-01, \
                                    -7.0652173913000005e-01, -7.0553359683799999e-01, -7.0454545454499995e-01, \
                                    -7.0355731225300000e-01, -7.0256916995999996e-01, -7.0158102766800001e-01, \
                                    -7.0059288537499997e-01, -6.9960474308300002e-01, -6.9861660079099996e-01, \
                                    -6.9762845849800004e-01, -6.9664031620599998e-01, -6.9565217391300005e-01, \
                                    -6.9466403162099999e-01, -6.9367588932799995e-01, -6.9268774703600000e-01, \
                                    -6.9169960474299996e-01, -6.9071146245100001e-01, -6.8972332015799998e-01, \
                                    -6.8873517786600003e-01, -6.8774703557299999e-01, -6.8675889328100004e-01, \
                                    -6.8577075098800000e-01, -6.8478260869600005e-01, -6.8379446640300001e-01, \
                                    -6.8280632411099995e-01, -6.8181818181800002e-01, -6.8083003952599996e-01, \
                                    -6.7984189723300004e-01, -6.7885375494099998e-01, -6.7786561264800005e-01, \
                                    -6.7687747035599999e-01, -6.7588932806299995e-01, -6.7490118577100000e-01, \
                                    -6.7391304347799996e-01, -6.7292490118600001e-01, -6.7193675889299997e-01, \
                                    -6.7094861660100003e-01, -6.6996047430799999e-01, -6.6897233201600004e-01, \
                                    -6.6798418972300000e-01, -6.6699604743100005e-01, -6.6600790513800001e-01, \
                                    -6.6501976284599995e-01, -6.6403162055300002e-01, -6.6304347826099996e-01, \
                                    -6.6205533596800004e-01, -6.6106719367599998e-01, -6.6007905138300005e-01, \
                                    -6.5909090909099999e-01, -6.5810276679799995e-01, -6.5711462450600000e-01, \
                                    -6.5612648221299996e-01, -6.5513833992100001e-01, -6.5415019762799997e-01, \
                                    -6.5316205533600002e-01, -6.5217391304299999e-01, -6.5118577075100004e-01, \
                                    -6.5019762845899998e-01, -6.4920948616600005e-01, -6.4822134387399999e-01, \
                                    -6.4723320158099995e-01, -6.4624505928900000e-01, -6.4525691699599996e-01, \
                                    -6.4426877470400001e-01, -6.4328063241099998e-01, -6.4229249011900003e-01, \
                                    -6.4130434782599999e-01, -6.4031620553400004e-01, -6.3932806324100000e-01, \
                                    -6.3833992094900005e-01, -6.3735177865600001e-01, -6.3636363636399995e-01, \
                                    -6.3537549407100002e-01, -6.3438735177899996e-01, -6.3339920948600004e-01, \
                                    -6.3241106719399998e-01, -6.3142292490100005e-01, -6.3043478260899999e-01, \
                                    -6.2944664031599995e-01, -6.2845849802400000e-01, -6.2747035573099996e-01, \
                                    -6.2648221343900001e-01, -6.2549407114599997e-01, -6.2450592885400003e-01, \
                                    -6.2351778656099999e-01, -6.2252964426900004e-01, -6.2154150197600000e-01, \
                                    -6.2055335968400005e-01, -6.1956521739100001e-01, -6.1857707509899995e-01, \
                                    -6.1758893280600002e-01, -6.1660079051399996e-01, -6.1561264822100004e-01, \
                                    -6.1462450592899998e-01, -6.1363636363600005e-01, -6.1264822134399999e-01, \
                                    -6.1166007905099995e-01, -6.1067193675900000e-01, -6.0968379446599996e-01, \
                                    -6.0869565217400001e-01, -6.0770750988099997e-01, -6.0671936758900002e-01, \
                                    -6.0573122529599999e-01, -6.0474308300400004e-01, -6.0375494071100000e-01, \
                                    -6.0276679841900005e-01, -6.0177865612600001e-01, -6.0079051383399995e-01, \
                                    -5.9980237154200000e-01, -5.9881422924899996e-01, -5.9782608695700001e-01, \
                                    -5.9683794466399998e-01, -5.9584980237200003e-01, -5.9486166007899999e-01, \
                                    -5.9387351778700004e-01, -5.9288537549400000e-01, -5.9189723320200005e-01, \
                                    -5.9090909090900001e-01, -5.8992094861699995e-01, -5.8893280632400002e-01, \
                                    -5.8794466403199996e-01, -5.8695652173900004e-01, -5.8596837944699998e-01, \
                                    -5.8498023715400005e-01, -5.8399209486199999e-01, -5.8300395256899995e-01, \
                                    -5.8201581027700000e-01, -5.8102766798399996e-01, -5.8003952569200001e-01, \
                                    -5.7905138339899997e-01, -5.7806324110700003e-01, -5.7707509881399999e-01, \
                                    -5.7608695652200004e-01, -5.7509881422900000e-01, -5.7411067193700005e-01, \
                                    -5.7312252964400001e-01, -5.7213438735199995e-01, -5.7114624505900002e-01, \
                                    -5.7015810276699996e-01, -5.6916996047400004e-01, -5.6818181818199998e-01, \
                                    -5.6719367588900005e-01, -5.6620553359699999e-01, -5.6521739130399995e-01, \
                                    -5.6422924901200000e-01, -5.6324110671899996e-01, -5.6225296442700001e-01, \
                                    -5.6126482213399997e-01, -5.6027667984200002e-01, -5.5928853754899999e-01, \
                                    -5.5830039525700004e-01, -5.5731225296400000e-01, -5.5632411067200005e-01, \
                                    -5.5533596837900001e-01, -5.5434782608699995e-01, -5.5335968379400002e-01, \
                                    -5.5237154150199996e-01, -5.5138339920900004e-01, -5.5039525691699998e-01, \
                                    -5.4940711462500003e-01, -5.4841897233199999e-01, -5.4743083004000004e-01, \
                                    -5.4644268774700000e-01, -5.4545454545500005e-01, -5.4446640316200001e-01, \
                                    -5.4347826086999995e-01, -5.4249011857700002e-01, -5.4150197628499996e-01, \
                                    -5.4051383399200004e-01, -5.3952569169999998e-01, -5.3853754940700005e-01, \
                                    -5.3754940711499999e-01, -5.3656126482199995e-01, -5.3557312253000000e-01, \
                                    -5.3458498023699996e-01, -5.3359683794500001e-01, -5.3260869565199997e-01, \
                                    -5.3162055336000003e-01, -5.3063241106699999e-01, -5.2964426877500004e-01, \
                                    -5.2865612648200000e-01, -5.2766798419000005e-01, -5.2667984189700001e-01, \
                                    -5.2569169960499995e-01, -5.2470355731200002e-01, -5.2371541501999996e-01, \
                                    -5.2272727272700004e-01, -5.2173913043499998e-01, -5.2075098814200005e-01, \
                                    -5.1976284584999999e-01, -5.1877470355699995e-01, -5.1778656126500000e-01, \
                                    -5.1679841897199996e-01, -5.1581027668000001e-01, -5.1482213438699997e-01, \
                                    -5.1383399209500003e-01, -5.1284584980199999e-01, -5.1185770751000004e-01, \
                                    -5.1086956521700000e-01, -5.0988142292500005e-01, -5.0889328063200001e-01, \
                                    -5.0790513833999995e-01, -5.0691699604700002e-01, -5.0592885375499996e-01, \
                                    -5.0494071146200004e-01, -5.0395256916999998e-01, -5.0296442687700005e-01, \
                                    -5.0197628458499999e-01, -5.0098814229199995e-01, -5.0000000000000000e-01, \
                                    -4.9901185770800000e-01, -4.9802371541500001e-01, -4.9703557312300001e-01, \
                                    -4.9604743083000002e-01, -4.9505928853800002e-01, -4.9407114624499998e-01, \
                                    -4.9308300395299998e-01, -4.9209486165999999e-01, -4.9110671936799999e-01, \
                                    -4.9011857707500001e-01, -4.8913043478300000e-01, -4.8814229249000002e-01, \
                                    -4.8715415019800001e-01, -4.8616600790499997e-01, -4.8517786561300003e-01, \
                                    -4.8418972331999999e-01, -4.8320158102799998e-01, -4.8221343873500000e-01, \
                                    -4.8122529644299999e-01, -4.8023715415000001e-01, -4.7924901185800001e-01, \
                                    -4.7826086956500002e-01, -4.7727272727300002e-01, -4.7628458497999998e-01, \
                                    -4.7529644268799998e-01, -4.7430830039499999e-01, -4.7332015810299999e-01, \
                                    -4.7233201581000001e-01, -4.7134387351800000e-01, -4.7035573122500002e-01, \
                                    -4.6936758893300001e-01, -4.6837944663999997e-01, -4.6739130434800003e-01, \
                                    -4.6640316205499999e-01, -4.6541501976299998e-01, -4.6442687747000000e-01, \
                                    -4.6343873517799999e-01, -4.6245059288500001e-01, -4.6146245059300001e-01, \
                                    -4.6047430830000002e-01, -4.5948616600800002e-01, -4.5849802371499998e-01, \
                                    -4.5750988142299998e-01, -4.5652173912999999e-01, -4.5553359683799999e-01, \
                                    -4.5454545454500001e-01, -4.5355731225300000e-01, -4.5256916996000002e-01, \
                                    -4.5158102766800001e-01, -4.5059288537499997e-01, -4.4960474308300002e-01, \
                                    -4.4861660079100002e-01, -4.4762845849799998e-01, -4.4664031620599998e-01, \
                                    -4.4565217391299999e-01, -4.4466403162099999e-01, -4.4367588932800001e-01, \
                                    -4.4268774703600000e-01, -4.4169960474300002e-01, -4.4071146245100001e-01, \
                                    -4.3972332015799998e-01, -4.3873517786600003e-01, -4.3774703557299999e-01, \
                                    -4.3675889328099998e-01, -4.3577075098800000e-01, -4.3478260869599999e-01, \
                                    -4.3379446640300001e-01, -4.3280632411100001e-01, -4.3181818181800002e-01, \
                                    -4.3083003952600002e-01, -4.2984189723299998e-01, -4.2885375494099998e-01, \
                                    -4.2786561264799999e-01, -4.2687747035599999e-01, -4.2588932806300001e-01, \
                                    -4.2490118577100000e-01, -4.2391304347800002e-01, -4.2292490118600001e-01, \
                                    -4.2193675889299997e-01, -4.2094861660100003e-01, -4.1996047430799999e-01, \
                                    -4.1897233201599998e-01, -4.1798418972300000e-01, -4.1699604743099999e-01, \
                                    -4.1600790513800001e-01, -4.1501976284600001e-01, -4.1403162055300002e-01, \
                                    -4.1304347826100002e-01, -4.1205533596799998e-01, -4.1106719367599998e-01, \
                                    -4.1007905138299999e-01, -4.0909090909099999e-01, -4.0810276679800001e-01, \
                                    -4.0711462450600000e-01, -4.0612648221300002e-01, -4.0513833992100001e-01, \
                                    -4.0415019762799997e-01, -4.0316205533600002e-01, -4.0217391304299999e-01, \
                                    -4.0118577075099998e-01, -4.0019762845899998e-01, -3.9920948616599999e-01, \
                                    -3.9822134387399999e-01, -3.9723320158100001e-01, -3.9624505928900000e-01, \
                                    -3.9525691699600002e-01, -3.9426877470400001e-01, -3.9328063241099998e-01, \
                                    -3.9229249011900003e-01, -3.9130434782599999e-01, -3.9031620553399998e-01, \
                                    -3.8932806324100000e-01, -3.8833992094899999e-01, -3.8735177865600001e-01, \
                                    -3.8636363636400001e-01, -3.8537549407100002e-01, -3.8438735177900002e-01, \
                                    -3.8339920948599998e-01, -3.8241106719399998e-01, -3.8142292490099999e-01, \
                                    -3.8043478260899999e-01, -3.7944664031600001e-01, -3.7845849802400000e-01, \
                                    -3.7747035573100002e-01, -3.7648221343900001e-01, -3.7549407114599997e-01, \
                                    -3.7450592885400003e-01, -3.7351778656099999e-01, -3.7252964426899998e-01, \
                                    -3.7154150197600000e-01, -3.7055335968399999e-01, -3.6956521739100001e-01, \
                                    -3.6857707509900001e-01, -3.6758893280600002e-01, -3.6660079051400002e-01, \
                                    -3.6561264822099998e-01, -3.6462450592899998e-01, -3.6363636363599999e-01, \
                                    -3.6264822134399999e-01, -3.6166007905100001e-01, -3.6067193675900000e-01, \
                                    -3.5968379446600002e-01, -3.5869565217400001e-01, -3.5770750988099997e-01, \
                                    -3.5671936758900002e-01, -3.5573122529599999e-01, -3.5474308300399998e-01, \
                                    -3.5375494071100000e-01, -3.5276679841899999e-01, -3.5177865612600001e-01, \
                                    -3.5079051383400001e-01, -3.4980237154200000e-01, -3.4881422924900002e-01, \
                                    -3.4782608695700001e-01, -3.4683794466399998e-01, -3.4584980237200003e-01, \
                                    -3.4486166007899999e-01, -3.4387351778699998e-01, -3.4288537549400000e-01, \
                                    -3.4189723320199999e-01, -3.4090909090900001e-01, -3.3992094861700001e-01, \
                                    -3.3893280632400002e-01, -3.3794466403200002e-01, -3.3695652173899998e-01, \
                                    -3.3596837944699998e-01, -3.3498023715399999e-01, -3.3399209486199999e-01, \
                                    -3.3300395256900001e-01, -3.3201581027700000e-01, -3.3102766798400002e-01, \
                                    -3.3003952569200001e-01, -3.2905138339899997e-01, -3.2806324110700003e-01, \
                                    -3.2707509881399999e-01, -3.2608695652199998e-01, -3.2509881422900000e-01, \
                                    -3.2411067193699999e-01, -3.2312252964400001e-01, -3.2213438735200001e-01, \
                                    -3.2114624505900002e-01, -3.2015810276700002e-01, -3.1916996047399998e-01, \
                                    -3.1818181818199998e-01, -3.1719367588899999e-01, -3.1620553359699999e-01, \
                                    -3.1521739130400001e-01, -3.1422924901200000e-01, -3.1324110671900002e-01, \
                                    -3.1225296442700001e-01, -3.1126482213399997e-01, -3.1027667984200002e-01, \
                                    -3.0928853754899999e-01, -3.0830039525699998e-01, -3.0731225296400000e-01, \
                                    -3.0632411067199999e-01, -3.0533596837900001e-01, -3.0434782608700001e-01, \
                                    -3.0335968379400002e-01, -3.0237154150200002e-01, -3.0138339920899998e-01, \
                                    -3.0039525691699998e-01, -2.9940711462500003e-01, -2.9841897233199999e-01, \
                                    -2.9743083003999998e-01, -2.9644268774700000e-01, -2.9545454545499999e-01, \
                                    -2.9446640316200001e-01, -2.9347826087000001e-01, -2.9249011857700002e-01, \
                                    -2.9150197628500002e-01, -2.9051383399199998e-01, -2.8952569169999998e-01, \
                                    -2.8853754940699999e-01, -2.8754940711499999e-01, -2.8656126482200001e-01, \
                                    -2.8557312253000000e-01, -2.8458498023700002e-01, -2.8359683794500001e-01, \
                                    -2.8260869565199997e-01, -2.8162055336000003e-01, -2.8063241106699999e-01, \
                                    -2.7964426877499998e-01, -2.7865612648200000e-01, -2.7766798418999999e-01, \
                                    -2.7667984189700001e-01, -2.7569169960500001e-01, -2.7470355731200002e-01, \
                                    -2.7371541502000002e-01, -2.7272727272699998e-01, -2.7173913043499998e-01, \
                                    -2.7075098814199999e-01, -2.6976284584999999e-01, -2.6877470355700001e-01, \
                                    -2.6778656126500000e-01, -2.6679841897200002e-01, -2.6581027668000001e-01, \
                                    -2.6482213438699997e-01, -2.6383399209500003e-01, -2.6284584980199999e-01, \
                                    -2.6185770750999998e-01, -2.6086956521700000e-01, -2.5988142292499999e-01, \
                                    -2.5889328063200001e-01, -2.5790513834000001e-01, -2.5691699604700002e-01, \
                                    -2.5592885375500002e-01, -2.5494071146199998e-01, -2.5395256916999998e-01, \
                                    -2.5296442687699999e-01, -2.5197628458499999e-01, -2.5098814229200000e-01, \
                                    -2.5000000000000000e-01, -2.4901185770800000e-01, -2.4802371541500001e-01, \
                                    -2.4703557312300001e-01, -2.4604743083000000e-01, -2.4505928853799999e-01, \
                                    -2.4407114624500001e-01, -2.4308300395300000e-01, -2.4209486165999999e-01, \
                                    -2.4110671936799999e-01, -2.4011857707500001e-01, -2.3913043478300000e-01, \
                                    -2.3814229248999999e-01, -2.3715415019800001e-01, -2.3616600790500000e-01, \
                                    -2.3517786561300000e-01, -2.3418972331999999e-01, -2.3320158102800001e-01, \
                                    -2.3221343873500000e-01, -2.3122529644299999e-01, -2.3023715415000001e-01, \
                                    -2.2924901185800001e-01, -2.2826086956500000e-01, -2.2727272727299999e-01, \
                                    -2.2628458498000001e-01, -2.2529644268800000e-01, -2.2430830039499999e-01, \
                                    -2.2332015810299999e-01, -2.2233201581000001e-01, -2.2134387351800000e-01, \
                                    -2.2035573122499999e-01, -2.1936758893300001e-01, -2.1837944664000000e-01, \
                                    -2.1739130434800000e-01, -2.1640316205499999e-01, -2.1541501976300001e-01, \
                                    -2.1442687747000000e-01, -2.1343873517799999e-01, -2.1245059288500001e-01, \
                                    -2.1146245059300001e-01, -2.1047430830000000e-01, -2.0948616600799999e-01, \
                                    -2.0849802371500001e-01, -2.0750988142300000e-01, -2.0652173912999999e-01, \
                                    -2.0553359683799999e-01, -2.0454545454500001e-01, -2.0355731225300000e-01, \
                                    -2.0256916995999999e-01, -2.0158102766800001e-01, -2.0059288537500000e-01, \
                                    -1.9960474308300000e-01, -1.9861660079099999e-01, -1.9762845849800001e-01, \
                                    -1.9664031620600000e-01, -1.9565217391299999e-01, -1.9466403162099999e-01, \
                                    -1.9367588932800001e-01, -1.9268774703600000e-01, -1.9169960474299999e-01, \
                                    -1.9071146245100001e-01, -1.8972332015800000e-01, -1.8873517786600000e-01, \
                                    -1.8774703557299999e-01, -1.8675889328100001e-01, -1.8577075098800000e-01, \
                                    -1.8478260869599999e-01, -1.8379446640300001e-01, -1.8280632411100001e-01, \
                                    -1.8181818181800000e-01, -1.8083003952599999e-01, -1.7984189723300001e-01, \
                                    -1.7885375494100000e-01, -1.7786561264799999e-01, -1.7687747035599999e-01, \
                                    -1.7588932806300001e-01, -1.7490118577100000e-01, -1.7391304347799999e-01, \
                                    -1.7292490118600001e-01, -1.7193675889300000e-01, -1.7094861660100000e-01, \
                                    -1.6996047430799999e-01, -1.6897233201600001e-01, -1.6798418972300000e-01, \
                                    -1.6699604743099999e-01, -1.6600790513800001e-01, -1.6501976284600001e-01, \
                                    -1.6403162055300000e-01, -1.6304347826099999e-01, -1.6205533596800001e-01, \
                                    -1.6106719367600000e-01, -1.6007905138299999e-01, -1.5909090909099999e-01, \
                                    -1.5810276679800001e-01, -1.5711462450600000e-01, -1.5612648221299999e-01, \
                                    -1.5513833992100001e-01, -1.5415019762800000e-01, -1.5316205533600000e-01, \
                                    -1.5217391304299999e-01, -1.5118577075100001e-01, -1.5019762845900000e-01, \
                                    -1.4920948616599999e-01, -1.4822134387399999e-01, -1.4723320158100001e-01, \
                                    -1.4624505928900000e-01, -1.4525691699599999e-01, -1.4426877470400001e-01, \
                                    -1.4328063241100000e-01, -1.4229249011900000e-01, -1.4130434782599999e-01, \
                                    -1.4031620553400001e-01, -1.3932806324100000e-01, -1.3833992094899999e-01, \
                                    -1.3735177865600001e-01, -1.3636363636400001e-01, -1.3537549407100000e-01, \
                                    -1.3438735177899999e-01, -1.3339920948600001e-01, -1.3241106719400000e-01, \
                                    -1.3142292490099999e-01, -1.3043478260899999e-01, -1.2944664031600001e-01, \
                                    -1.2845849802400000e-01, -1.2747035573099999e-01, -1.2648221343900001e-01, \
                                    -1.2549407114600000e-01, -1.2450592885400000e-01, -1.2351778656100000e-01, \
                                    -1.2252964426900000e-01, -1.2154150197600000e-01, -1.2055335968399999e-01, \
                                    -1.1956521739100000e-01, -1.1857707509900001e-01, -1.1758893280600000e-01, \
                                    -1.1660079051400001e-01, -1.1561264822099999e-01, -1.1462450592900000e-01, \
                                    -1.1363636363600001e-01, -1.1264822134400000e-01, -1.1166007905100001e-01, \
                                    -1.1067193675900000e-01, -1.0968379446600000e-01, -1.0869565217400000e-01, \
                                    -1.0770750988100000e-01, -1.0671936758900000e-01, -1.0573122529600000e-01, \
                                    -1.0474308300400000e-01, -1.0375494071100000e-01, -1.0276679841899999e-01, \
                                    -1.0177865612600000e-01, -1.0079051383400001e-01, -9.9802371542000001e-02, \
                                    -9.8814229249000005e-02, -9.7826086957000000e-02, -9.6837944664000003e-02, \
                                    -9.5849802371999998e-02, -9.4861660079000001e-02, -9.3873517786999996e-02, \
                                    -9.2885375494000000e-02, -9.1897233201999995e-02, -9.0909090908999998e-02, \
                                    -8.9920948616999993e-02, -8.8932806323999997e-02, -8.7944664032000006e-02, \
                                    -8.6956521738999995e-02, -8.5968379447000004e-02, -8.4980237153999993e-02, \
                                    -8.3992094862000002e-02, -8.3003952569000006e-02, -8.2015810277000001e-02, \
                                    -8.1027667984000004e-02, -8.0039525691999999e-02, -7.9051383399000003e-02, \
                                    -7.8063241106999998e-02, -7.7075098814000001e-02, -7.6086956521999996e-02, \
                                    -7.5098814228999999e-02, -7.4110671936999994e-02, -7.3122529643999998e-02, \
                                    -7.2134387352000007e-02, -7.1146245058999996e-02, -7.0158102767000005e-02, \
                                    -6.9169960473999995e-02, -6.8181818182000004e-02, -6.7193675889000007e-02, \
                                    -6.6205533597000002e-02, -6.5217391304000005e-02, -6.4229249012000000e-02, \
                                    -6.3241106719000004e-02, -6.2252964426999999e-02, -6.1264822134000002e-02, \
                                    -6.0276679841999997e-02, -5.9288537549000001e-02, -5.8300395257000003e-02, \
                                    -5.7312252963999999e-02, -5.6324110672000001e-02, -5.5335968378999997e-02, \
                                    -5.4347826086999999e-02, -5.3359683794000003e-02, -5.2371541501999998e-02, \
                                    -5.1383399209000001e-02, -5.0395256917000003e-02, -4.9407114624999998e-02, \
                                    -4.8418972332000002e-02, -4.7430830039999997e-02, -4.6442687747000000e-02, \
                                    -4.5454545455000002e-02, -4.4466403161999998e-02, -4.3478260870000000e-02, \
                                    -4.2490118576999997e-02, -4.1501976284999999e-02, -4.0513833992000002e-02, \
                                    -3.9525691699999997e-02, -3.8537549407000000e-02, -3.7549407115000002e-02, \
                                    -3.6561264821999999e-02, -3.5573122530000001e-02, -3.4584980236999997e-02, \
                                    -3.3596837944999999e-02, -3.2608695652000003e-02, -3.1620553359999998e-02, \
                                    -3.0632411067000001e-02, -2.9644268775000000e-02, -2.8656126481999999e-02, \
                                    -2.7667984190000001e-02, -2.6679841897000001e-02, -2.5691699605000000e-02, \
                                    -2.4703557312000000e-02, -2.3715415019999998e-02, -2.2727272727000002e-02, \
                                    -2.1739130435000000e-02, -2.0750988142000000e-02, -1.9762845849999999e-02, \
                                    -1.8774703556999998e-02, -1.7786561265000000e-02, -1.6798418972000000e-02, \
                                    -1.5810276679999999e-02, -1.4822134387000000e-02, -1.3833992095000001e-02, \
                                    -1.2845849802000001e-02, -1.1857707509999999e-02, -1.0869565217000001e-02, \
                                    -9.8814229249999993e-03, -8.8932806319999991e-03, -7.9051383399999994e-03, \
                                    -6.9169960470000002e-03, -5.9288537549999996e-03, -4.9407114620000003e-03, \
                                    -3.9525691699999997e-03, -2.9644268770000000e-03, -1.9762845849999999e-03, \
                                    -9.8814229199999993e-04,  0.0000000000000000e+00,  9.8814229199999993e-04, \
                                    1.9762845849999999e-03,  2.9644268770000000e-03,  3.9525691699999997e-03, \
                                    4.9407114620000003e-03,  5.9288537549999996e-03,  6.9169960470000002e-03, \
                                    7.9051383399999994e-03,  8.8932806319999991e-03,  9.8814229249999993e-03, \
                                    1.0869565217000001e-02,  1.1857707509999999e-02,  1.2845849802000001e-02, \
                                    1.3833992095000001e-02,  1.4822134387000000e-02,  1.5810276679999999e-02, \
                                    1.6798418972000000e-02,  1.7786561265000000e-02,  1.8774703556999998e-02, \
                                    1.9762845849999999e-02,  2.0750988142000000e-02,  2.1739130435000000e-02, \
                                    2.2727272727000002e-02,  2.3715415019999998e-02,  2.4703557312000000e-02, \
                                    2.5691699605000000e-02,  2.6679841897000001e-02,  2.7667984190000001e-02, \
                                    2.8656126481999999e-02,  2.9644268775000000e-02,  3.0632411067000001e-02, \
                                    3.1620553359999998e-02,  3.2608695652000003e-02,  3.3596837944999999e-02, \
                                    3.4584980236999997e-02,  3.5573122530000001e-02,  3.6561264821999999e-02, \
                                    3.7549407115000002e-02,  3.8537549407000000e-02,  3.9525691699999997e-02, \
                                    4.0513833992000002e-02,  4.1501976284999999e-02,  4.2490118576999997e-02, \
                                    4.3478260870000000e-02,  4.4466403161999998e-02,  4.5454545455000002e-02, \
                                    4.6442687747000000e-02,  4.7430830039999997e-02,  4.8418972332000002e-02, \
                                    4.9407114624999998e-02,  5.0395256917000003e-02,  5.1383399209000001e-02, \
                                    5.2371541501999998e-02,  5.3359683794000003e-02,  5.4347826086999999e-02, \
                                    5.5335968378999997e-02,  5.6324110672000001e-02,  5.7312252963999999e-02, \
                                    5.8300395257000003e-02,  5.9288537549000001e-02,  6.0276679841999997e-02, \
                                    6.1264822134000002e-02,  6.2252964426999999e-02,  6.3241106719000004e-02, \
                                    6.4229249012000000e-02,  6.5217391304000005e-02,  6.6205533597000002e-02, \
                                    6.7193675889000007e-02,  6.8181818182000004e-02,  6.9169960473999995e-02, \
                                    7.0158102767000005e-02,  7.1146245058999996e-02,  7.2134387352000007e-02, \
                                    7.3122529643999998e-02,  7.4110671936999994e-02,  7.5098814228999999e-02, \
                                    7.6086956521999996e-02,  7.7075098814000001e-02,  7.8063241106999998e-02, \
                                    7.9051383399000003e-02,  8.0039525691999999e-02,  8.1027667984000004e-02, \
                                    8.2015810277000001e-02,  8.3003952569000006e-02,  8.3992094862000002e-02, \
                                    8.4980237153999993e-02,  8.5968379447000004e-02,  8.6956521738999995e-02, \
                                    8.7944664032000006e-02,  8.8932806323999997e-02,  8.9920948616999993e-02, \
                                    9.0909090908999998e-02,  9.1897233201999995e-02,  9.2885375494000000e-02, \
                                    9.3873517786999996e-02,  9.4861660079000001e-02,  9.5849802371999998e-02, \
                                    9.6837944664000003e-02,  9.7826086957000000e-02,  9.8814229249000005e-02, \
                                    9.9802371540999996e-02,  1.0079051383400001e-01,  1.0177865612600000e-01, \
                                    1.0276679841899999e-01,  1.0375494071100000e-01,  1.0474308300400000e-01, \
                                    1.0573122529600000e-01,  1.0671936758900000e-01,  1.0770750988100000e-01, \
                                    1.0869565217400000e-01,  1.0968379446600000e-01,  1.1067193675900000e-01, \
                                    1.1166007905100001e-01,  1.1264822134400000e-01,  1.1363636363600001e-01, \
                                    1.1462450592900000e-01,  1.1561264822099999e-01,  1.1660079051400001e-01, \
                                    1.1758893280600000e-01,  1.1857707509900001e-01,  1.1956521739100000e-01, \
                                    1.2055335968399999e-01,  1.2154150197600000e-01,  1.2252964426900000e-01, \
                                    1.2351778656100000e-01,  1.2450592885400000e-01,  1.2549407114600000e-01, \
                                    1.2648221343900001e-01,  1.2747035573099999e-01,  1.2845849802400000e-01, \
                                    1.2944664031600001e-01,  1.3043478260899999e-01,  1.3142292490099999e-01, \
                                    1.3241106719400000e-01,  1.3339920948600001e-01,  1.3438735177899999e-01, \
                                    1.3537549407100000e-01,  1.3636363636400001e-01,  1.3735177865600001e-01, \
                                    1.3833992094899999e-01,  1.3932806324100000e-01,  1.4031620553400001e-01, \
                                    1.4130434782599999e-01,  1.4229249011900000e-01,  1.4328063241100000e-01, \
                                    1.4426877470400001e-01,  1.4525691699599999e-01,  1.4624505928900000e-01, \
                                    1.4723320158100001e-01,  1.4822134387399999e-01,  1.4920948616599999e-01, \
                                    1.5019762845800000e-01,  1.5118577075100001e-01,  1.5217391304299999e-01, \
                                    1.5316205533600000e-01,  1.5415019762800000e-01,  1.5513833992100001e-01, \
                                    1.5612648221299999e-01,  1.5711462450600000e-01,  1.5810276679800001e-01, \
                                    1.5909090909099999e-01,  1.6007905138299999e-01,  1.6106719367600000e-01, \
                                    1.6205533596800001e-01,  1.6304347826099999e-01,  1.6403162055300000e-01, \
                                    1.6501976284600001e-01,  1.6600790513800001e-01,  1.6699604743099999e-01, \
                                    1.6798418972300000e-01,  1.6897233201600001e-01,  1.6996047430799999e-01, \
                                    1.7094861660100000e-01,  1.7193675889300000e-01,  1.7292490118600001e-01, \
                                    1.7391304347799999e-01,  1.7490118577100000e-01,  1.7588932806300001e-01, \
                                    1.7687747035599999e-01,  1.7786561264799999e-01,  1.7885375494100000e-01, \
                                    1.7984189723300001e-01,  1.8083003952599999e-01,  1.8181818181800000e-01, \
                                    1.8280632411100001e-01,  1.8379446640300001e-01,  1.8478260869599999e-01, \
                                    1.8577075098800000e-01,  1.8675889328100001e-01,  1.8774703557299999e-01, \
                                    1.8873517786600000e-01,  1.8972332015800000e-01,  1.9071146245100001e-01, \
                                    1.9169960474299999e-01,  1.9268774703600000e-01,  1.9367588932800001e-01, \
                                    1.9466403162099999e-01,  1.9565217391299999e-01,  1.9664031620600000e-01, \
                                    1.9762845849800001e-01,  1.9861660079099999e-01,  1.9960474308300000e-01, \
                                    2.0059288537500000e-01,  2.0158102766800001e-01,  2.0256916995999999e-01, \
                                    2.0355731225300000e-01,  2.0454545454500001e-01,  2.0553359683799999e-01, \
                                    2.0652173912999999e-01,  2.0750988142300000e-01,  2.0849802371500001e-01, \
                                    2.0948616600799999e-01,  2.1047430830000000e-01,  2.1146245059300001e-01, \
                                    2.1245059288500001e-01,  2.1343873517799999e-01,  2.1442687747000000e-01, \
                                    2.1541501976300001e-01,  2.1640316205499999e-01,  2.1739130434800000e-01, \
                                    2.1837944664000000e-01,  2.1936758893300001e-01,  2.2035573122499999e-01, \
                                    2.2134387351800000e-01,  2.2233201581000001e-01,  2.2332015810299999e-01, \
                                    2.2430830039499999e-01,  2.2529644268800000e-01,  2.2628458498000001e-01, \
                                    2.2727272727299999e-01,  2.2826086956500000e-01,  2.2924901185800001e-01, \
                                    2.3023715415000001e-01,  2.3122529644299999e-01,  2.3221343873500000e-01, \
                                    2.3320158102800001e-01,  2.3418972331999999e-01,  2.3517786561300000e-01, \
                                    2.3616600790500000e-01,  2.3715415019800001e-01,  2.3814229248999999e-01, \
                                    2.3913043478300000e-01,  2.4011857707500001e-01,  2.4110671936799999e-01, \
                                    2.4209486165999999e-01,  2.4308300395300000e-01,  2.4407114624500001e-01, \
                                    2.4505928853799999e-01,  2.4604743083000000e-01,  2.4703557312300001e-01, \
                                    2.4802371541500001e-01,  2.4901185770800000e-01,  2.5000000000000000e-01, \
                                    2.5098814229200000e-01,  2.5197628458499999e-01,  2.5296442687699999e-01, \
                                    2.5395256916999998e-01,  2.5494071146199998e-01,  2.5592885375500002e-01, \
                                    2.5691699604700002e-01,  2.5790513834000001e-01,  2.5889328063200001e-01, \
                                    2.5988142292499999e-01,  2.6086956521700000e-01,  2.6185770750999998e-01, \
                                    2.6284584980199999e-01,  2.6383399209500003e-01,  2.6482213438699997e-01, \
                                    2.6581027668000001e-01,  2.6679841897200002e-01,  2.6778656126500000e-01, \
                                    2.6877470355700001e-01,  2.6976284584999999e-01,  2.7075098814199999e-01, \
                                    2.7173913043499998e-01,  2.7272727272699998e-01,  2.7371541502000002e-01, \
                                    2.7470355731200002e-01,  2.7569169960500001e-01,  2.7667984189700001e-01, \
                                    2.7766798418999999e-01,  2.7865612648200000e-01,  2.7964426877499998e-01, \
                                    2.8063241106699999e-01,  2.8162055336000003e-01,  2.8260869565199997e-01, \
                                    2.8359683794500001e-01,  2.8458498023700002e-01,  2.8557312253000000e-01, \
                                    2.8656126482200001e-01,  2.8754940711499999e-01,  2.8853754940699999e-01, \
                                    2.8952569169999998e-01,  2.9051383399199998e-01,  2.9150197628500002e-01, \
                                    2.9249011857700002e-01,  2.9347826087000001e-01,  2.9446640316200001e-01, \
                                    2.9545454545499999e-01,  2.9644268774700000e-01,  2.9743083003999998e-01, \
                                    2.9841897233199999e-01,  2.9940711462399999e-01,  3.0039525691699998e-01, \
                                    3.0138339920899998e-01,  3.0237154150200002e-01,  3.0335968379400002e-01, \
                                    3.0434782608700001e-01,  3.0533596837900001e-01,  3.0632411067199999e-01, \
                                    3.0731225296400000e-01,  3.0830039525699998e-01,  3.0928853754899999e-01, \
                                    3.1027667984200002e-01,  3.1126482213399997e-01,  3.1225296442700001e-01, \
                                    3.1324110671900002e-01,  3.1422924901200000e-01,  3.1521739130400001e-01, \
                                    3.1620553359699999e-01,  3.1719367588899999e-01,  3.1818181818199998e-01, \
                                    3.1916996047399998e-01,  3.2015810276700002e-01,  3.2114624505900002e-01, \
                                    3.2213438735200001e-01,  3.2312252964400001e-01,  3.2411067193699999e-01, \
                                    3.2509881422900000e-01,  3.2608695652199998e-01,  3.2707509881399999e-01, \
                                    3.2806324110700003e-01,  3.2905138339899997e-01,  3.3003952569200001e-01, \
                                    3.3102766798400002e-01,  3.3201581027700000e-01,  3.3300395256900001e-01, \
                                    3.3399209486199999e-01,  3.3498023715399999e-01,  3.3596837944699998e-01, \
                                    3.3695652173899998e-01,  3.3794466403200002e-01,  3.3893280632400002e-01, \
                                    3.3992094861700001e-01,  3.4090909090900001e-01,  3.4189723320199999e-01, \
                                    3.4288537549400000e-01,  3.4387351778699998e-01,  3.4486166007899999e-01, \
                                    3.4584980237200003e-01,  3.4683794466399998e-01,  3.4782608695700001e-01, \
                                    3.4881422924900002e-01,  3.4980237154100002e-01,  3.5079051383400001e-01, \
                                    3.5177865612600001e-01,  3.5276679841899999e-01,  3.5375494071100000e-01, \
                                    3.5474308300399998e-01,  3.5573122529599999e-01,  3.5671936758900002e-01, \
                                    3.5770750988099997e-01,  3.5869565217400001e-01,  3.5968379446600002e-01, \
                                    3.6067193675900000e-01,  3.6166007905100001e-01,  3.6264822134399999e-01, \
                                    3.6363636363599999e-01,  3.6462450592899998e-01,  3.6561264822099998e-01, \
                                    3.6660079051400002e-01,  3.6758893280600002e-01,  3.6857707509900001e-01, \
                                    3.6956521739100001e-01,  3.7055335968399999e-01,  3.7154150197600000e-01, \
                                    3.7252964426899998e-01,  3.7351778656099999e-01,  3.7450592885400003e-01, \
                                    3.7549407114599997e-01,  3.7648221343900001e-01,  3.7747035573100002e-01, \
                                    3.7845849802400000e-01,  3.7944664031600001e-01,  3.8043478260899999e-01, \
                                    3.8142292490099999e-01,  3.8241106719399998e-01,  3.8339920948599998e-01, \
                                    3.8438735177900002e-01,  3.8537549407100002e-01,  3.8636363636400001e-01, \
                                    3.8735177865600001e-01,  3.8833992094899999e-01,  3.8932806324100000e-01, \
                                    3.9031620553399998e-01,  3.9130434782599999e-01,  3.9229249011900003e-01, \
                                    3.9328063241099998e-01,  3.9426877470400001e-01,  3.9525691699600002e-01, \
                                    3.9624505928900000e-01,  3.9723320158100001e-01,  3.9822134387399999e-01, \
                                    3.9920948616599999e-01,  4.0019762845800000e-01,  4.0118577075099998e-01, \
                                    4.0217391304299999e-01,  4.0316205533600002e-01,  4.0415019762799997e-01, \
                                    4.0513833992100001e-01,  4.0612648221300002e-01,  4.0711462450600000e-01, \
                                    4.0810276679800001e-01,  4.0909090909099999e-01,  4.1007905138299999e-01, \
                                    4.1106719367599998e-01,  4.1205533596799998e-01,  4.1304347826100002e-01, \
                                    4.1403162055300002e-01,  4.1501976284600001e-01,  4.1600790513800001e-01, \
                                    4.1699604743099999e-01,  4.1798418972300000e-01,  4.1897233201599998e-01, \
                                    4.1996047430799999e-01,  4.2094861660100003e-01,  4.2193675889299997e-01, \
                                    4.2292490118600001e-01,  4.2391304347800002e-01,  4.2490118577100000e-01, \
                                    4.2588932806300001e-01,  4.2687747035599999e-01,  4.2786561264799999e-01, \
                                    4.2885375494099998e-01,  4.2984189723299998e-01,  4.3083003952600002e-01, \
                                    4.3181818181800002e-01,  4.3280632411100001e-01,  4.3379446640300001e-01, \
                                    4.3478260869599999e-01,  4.3577075098800000e-01,  4.3675889328099998e-01, \
                                    4.3774703557299999e-01,  4.3873517786600003e-01,  4.3972332015799998e-01, \
                                    4.4071146245100001e-01,  4.4169960474300002e-01,  4.4268774703600000e-01, \
                                    4.4367588932800001e-01,  4.4466403162099999e-01,  4.4565217391299999e-01, \
                                    4.4664031620599998e-01,  4.4762845849799998e-01,  4.4861660079100002e-01, \
                                    4.4960474308300002e-01,  4.5059288537499997e-01,  4.5158102766800001e-01, \
                                    4.5256916996000002e-01,  4.5355731225300000e-01,  4.5454545454500001e-01, \
                                    4.5553359683799999e-01,  4.5652173912999999e-01,  4.5750988142299998e-01, \
                                    4.5849802371499998e-01,  4.5948616600800002e-01,  4.6047430830000002e-01, \
                                    4.6146245059300001e-01,  4.6245059288500001e-01,  4.6343873517799999e-01, \
                                    4.6442687747000000e-01,  4.6541501976299998e-01,  4.6640316205499999e-01, \
                                    4.6739130434800003e-01,  4.6837944663999997e-01,  4.6936758893300001e-01, \
                                    4.7035573122500002e-01,  4.7134387351800000e-01,  4.7233201581000001e-01, \
                                    4.7332015810299999e-01,  4.7430830039499999e-01,  4.7529644268799998e-01, \
                                    4.7628458497999998e-01,  4.7727272727300002e-01,  4.7826086956500002e-01, \
                                    4.7924901185800001e-01,  4.8023715415000001e-01,  4.8122529644299999e-01, \
                                    4.8221343873500000e-01,  4.8320158102799998e-01,  4.8418972331999999e-01, \
                                    4.8517786561300003e-01,  4.8616600790499997e-01,  4.8715415019800001e-01, \
                                    4.8814229249000002e-01,  4.8913043478300000e-01,  4.9011857707500001e-01, \
                                    4.9110671936799999e-01,  4.9209486165999999e-01,  4.9308300395299998e-01, \
                                    4.9407114624499998e-01,  4.9505928853800002e-01,  4.9604743083000002e-01, \
                                    4.9703557312300001e-01,  4.9802371541500001e-01,  4.9901185770800000e-01, \
                                    5.0000000000000000e-01,  5.0098814229199995e-01,  5.0197628458499999e-01, \
                                    5.0296442687700005e-01,  5.0395256916999998e-01,  5.0494071146200004e-01, \
                                    5.0592885375499996e-01,  5.0691699604700002e-01,  5.0790513833999995e-01, \
                                    5.0889328063200001e-01,  5.0988142292500005e-01,  5.1086956521700000e-01, \
                                    5.1185770751000004e-01,  5.1284584980199999e-01,  5.1383399209500003e-01, \
                                    5.1482213438699997e-01,  5.1581027668000001e-01,  5.1679841897199996e-01, \
                                    5.1778656126500000e-01,  5.1877470355699995e-01,  5.1976284584999999e-01, \
                                    5.2075098814200005e-01,  5.2173913043499998e-01,  5.2272727272700004e-01, \
                                    5.2371541501999996e-01,  5.2470355731200002e-01,  5.2569169960499995e-01, \
                                    5.2667984189700001e-01,  5.2766798419000005e-01,  5.2865612648200000e-01, \
                                    5.2964426877500004e-01,  5.3063241106699999e-01,  5.3162055336000003e-01, \
                                    5.3260869565199997e-01,  5.3359683794500001e-01,  5.3458498023699996e-01, \
                                    5.3557312253000000e-01,  5.3656126482199995e-01,  5.3754940711499999e-01, \
                                    5.3853754940700005e-01,  5.3952569169999998e-01,  5.4051383399200004e-01, \
                                    5.4150197628499996e-01,  5.4249011857700002e-01,  5.4347826086999995e-01, \
                                    5.4446640316200001e-01,  5.4545454545500005e-01,  5.4644268774700000e-01, \
                                    5.4743083004000004e-01,  5.4841897233199999e-01,  5.4940711462400005e-01, \
                                    5.5039525691699998e-01,  5.5138339920900004e-01,  5.5237154150199996e-01, \
                                    5.5335968379400002e-01,  5.5434782608699995e-01,  5.5533596837900001e-01, \
                                    5.5632411067200005e-01,  5.5731225296400000e-01,  5.5830039525700004e-01, \
                                    5.5928853754899999e-01,  5.6027667984200002e-01,  5.6126482213399997e-01, \
                                    5.6225296442700001e-01,  5.6324110671899996e-01,  5.6422924901200000e-01, \
                                    5.6521739130399995e-01,  5.6620553359699999e-01,  5.6719367588900005e-01, \
                                    5.6818181818199998e-01,  5.6916996047400004e-01,  5.7015810276699996e-01, \
                                    5.7114624505900002e-01,  5.7213438735199995e-01,  5.7312252964400001e-01, \
                                    5.7411067193700005e-01,  5.7509881422900000e-01,  5.7608695652200004e-01, \
                                    5.7707509881399999e-01,  5.7806324110700003e-01,  5.7905138339899997e-01, \
                                    5.8003952569200001e-01,  5.8102766798399996e-01,  5.8201581027700000e-01, \
                                    5.8300395256899995e-01,  5.8399209486199999e-01,  5.8498023715400005e-01, \
                                    5.8596837944699998e-01,  5.8695652173900004e-01,  5.8794466403199996e-01, \
                                    5.8893280632400002e-01,  5.8992094861699995e-01,  5.9090909090900001e-01, \
                                    5.9189723320200005e-01,  5.9288537549400000e-01,  5.9387351778700004e-01, \
                                    5.9486166007899999e-01,  5.9584980237200003e-01,  5.9683794466399998e-01, \
                                    5.9782608695700001e-01,  5.9881422924899996e-01,  5.9980237154100002e-01, \
                                    6.0079051383399995e-01,  6.0177865612600001e-01,  6.0276679841900005e-01, \
                                    6.0375494071100000e-01,  6.0474308300400004e-01,  6.0573122529599999e-01, \
                                    6.0671936758900002e-01,  6.0770750988099997e-01,  6.0869565217400001e-01, \
                                    6.0968379446599996e-01,  6.1067193675900000e-01,  6.1166007905099995e-01, \
                                    6.1264822134399999e-01,  6.1363636363600005e-01,  6.1462450592899998e-01, \
                                    6.1561264822100004e-01,  6.1660079051399996e-01,  6.1758893280600002e-01, \
                                    6.1857707509899995e-01,  6.1956521739100001e-01,  6.2055335968400005e-01, \
                                    6.2154150197600000e-01,  6.2252964426900004e-01,  6.2351778656099999e-01, \
                                    6.2450592885400003e-01,  6.2549407114599997e-01,  6.2648221343900001e-01, \
                                    6.2747035573099996e-01,  6.2845849802400000e-01,  6.2944664031599995e-01, \
                                    6.3043478260899999e-01,  6.3142292490100005e-01,  6.3241106719399998e-01, \
                                    6.3339920948600004e-01,  6.3438735177899996e-01,  6.3537549407100002e-01, \
                                    6.3636363636399995e-01,  6.3735177865600001e-01,  6.3833992094900005e-01, \
                                    6.3932806324100000e-01,  6.4031620553400004e-01,  6.4130434782599999e-01, \
                                    6.4229249011900003e-01,  6.4328063241099998e-01,  6.4426877470400001e-01, \
                                    6.4525691699599996e-01,  6.4624505928900000e-01,  6.4723320158099995e-01, \
                                    6.4822134387399999e-01,  6.4920948616600005e-01,  6.5019762845800000e-01, \
                                    6.5118577075100004e-01,  6.5217391304299999e-01,  6.5316205533600002e-01, \
                                    6.5415019762799997e-01,  6.5513833992100001e-01,  6.5612648221299996e-01, \
                                    6.5711462450600000e-01,  6.5810276679799995e-01,  6.5909090909099999e-01, \
                                    6.6007905138300005e-01,  6.6106719367599998e-01,  6.6205533596800004e-01, \
                                    6.6304347826099996e-01,  6.6403162055300002e-01,  6.6501976284599995e-01, \
                                    6.6600790513800001e-01,  6.6699604743100005e-01,  6.6798418972300000e-01, \
                                    6.6897233201600004e-01,  6.6996047430799999e-01,  6.7094861660100003e-01, \
                                    6.7193675889299997e-01,  6.7292490118600001e-01,  6.7391304347799996e-01, \
                                    6.7490118577100000e-01,  6.7588932806299995e-01,  6.7687747035599999e-01, \
                                    6.7786561264800005e-01,  6.7885375494099998e-01,  6.7984189723300004e-01, \
                                    6.8083003952599996e-01,  6.8181818181800002e-01,  6.8280632411099995e-01, \
                                    6.8379446640300001e-01,  6.8478260869600005e-01,  6.8577075098800000e-01, \
                                    6.8675889328100004e-01,  6.8774703557299999e-01,  6.8873517786600003e-01, \
                                    6.8972332015799998e-01,  6.9071146245100001e-01,  6.9169960474299996e-01, \
                                    6.9268774703600000e-01,  6.9367588932799995e-01,  6.9466403162099999e-01, \
                                    6.9565217391300005e-01,  6.9664031620599998e-01,  6.9762845849800004e-01, \
                                    6.9861660079099996e-01,  6.9960474308300002e-01,  7.0059288537499997e-01, \
                                    7.0158102766800001e-01,  7.0256916995999996e-01,  7.0355731225300000e-01, \
                                    7.0454545454499995e-01,  7.0553359683799999e-01,  7.0652173913000005e-01, \
                                    7.0750988142299998e-01,  7.0849802371500004e-01,  7.0948616600799996e-01, \
                                    7.1047430830000002e-01,  7.1146245059299995e-01,  7.1245059288500001e-01, \
                                    7.1343873517800005e-01,  7.1442687747000000e-01,  7.1541501976300004e-01, \
                                    7.1640316205499999e-01,  7.1739130434800003e-01,  7.1837944663999997e-01, \
                                    7.1936758893300001e-01,  7.2035573122499996e-01,  7.2134387351800000e-01, \
                                    7.2233201580999995e-01,  7.2332015810299999e-01,  7.2430830039500005e-01, \
                                    7.2529644268799998e-01,  7.2628458498000004e-01,  7.2727272727299996e-01, \
                                    7.2826086956500002e-01,  7.2924901185799995e-01,  7.3023715415000001e-01, \
                                    7.3122529644300005e-01,  7.3221343873500000e-01,  7.3320158102800004e-01, \
                                    7.3418972331999999e-01,  7.3517786561300003e-01,  7.3616600790499997e-01, \
                                    7.3715415019800001e-01,  7.3814229248999996e-01,  7.3913043478300000e-01, \
                                    7.4011857707499995e-01,  7.4110671936799999e-01,  7.4209486166000005e-01, \
                                    7.4308300395299998e-01,  7.4407114624500004e-01,  7.4505928853799996e-01, \
                                    7.4604743083000002e-01,  7.4703557312299995e-01,  7.4802371541500001e-01, \
                                    7.4901185770800005e-01,  7.5000000000000000e-01,  7.5098814229199995e-01, \
                                    7.5197628458499999e-01,  7.5296442687700005e-01,  7.5395256916999998e-01, \
                                    7.5494071146200004e-01,  7.5592885375499996e-01,  7.5691699604700002e-01, \
                                    7.5790513833999995e-01,  7.5889328063200001e-01,  7.5988142292500005e-01, \
                                    7.6086956521700000e-01,  7.6185770751000004e-01,  7.6284584980199999e-01, \
                                    7.6383399209500003e-01,  7.6482213438699997e-01,  7.6581027668000001e-01, \
                                    7.6679841897199996e-01,  7.6778656126500000e-01,  7.6877470355699995e-01, \
                                    7.6976284584999999e-01,  7.7075098814200005e-01,  7.7173913043499998e-01, \
                                    7.7272727272700004e-01,  7.7371541501999996e-01,  7.7470355731200002e-01, \
                                    7.7569169960499995e-01,  7.7667984189700001e-01,  7.7766798419000005e-01, \
                                    7.7865612648200000e-01,  7.7964426877500004e-01,  7.8063241106699999e-01, \
                                    7.8162055336000003e-01,  7.8260869565199997e-01,  7.8359683794500001e-01, \
                                    7.8458498023699996e-01,  7.8557312253000000e-01,  7.8656126482199995e-01, \
                                    7.8754940711499999e-01,  7.8853754940700005e-01,  7.8952569169999998e-01, \
                                    7.9051383399200004e-01,  7.9150197628499996e-01,  7.9249011857700002e-01, \
                                    7.9347826086999995e-01,  7.9446640316200001e-01,  7.9545454545500005e-01, \
                                    7.9644268774700000e-01,  7.9743083004000004e-01,  7.9841897233199999e-01, \
                                    7.9940711462400005e-01,  8.0039525691699998e-01,  8.0138339920900004e-01, \
                                    8.0237154150199996e-01,  8.0335968379400002e-01,  8.0434782608699995e-01, \
                                    8.0533596837900001e-01,  8.0632411067200005e-01,  8.0731225296400000e-01, \
                                    8.0830039525700004e-01,  8.0928853754899999e-01,  8.1027667984200002e-01, \
                                    8.1126482213399997e-01,  8.1225296442700001e-01,  8.1324110671899996e-01, \
                                    8.1422924901200000e-01,  8.1521739130399995e-01,  8.1620553359699999e-01, \
                                    8.1719367588900005e-01,  8.1818181818199998e-01,  8.1916996047400004e-01, \
                                    8.2015810276699996e-01,  8.2114624505900002e-01,  8.2213438735199995e-01, \
                                    8.2312252964400001e-01,  8.2411067193700005e-01,  8.2509881422900000e-01, \
                                    8.2608695652200004e-01,  8.2707509881399999e-01,  8.2806324110700003e-01, \
                                    8.2905138339899997e-01,  8.3003952569200001e-01,  8.3102766798399996e-01, \
                                    8.3201581027700000e-01,  8.3300395256899995e-01,  8.3399209486199999e-01, \
                                    8.3498023715400005e-01,  8.3596837944699998e-01,  8.3695652173900004e-01, \
                                    8.3794466403199996e-01,  8.3893280632400002e-01,  8.3992094861699995e-01, \
                                    8.4090909090900001e-01,  8.4189723320200005e-01,  8.4288537549400000e-01, \
                                    8.4387351778700004e-01,  8.4486166007899999e-01,  8.4584980237200003e-01, \
                                    8.4683794466399998e-01,  8.4782608695700001e-01,  8.4881422924899996e-01, \
                                    8.4980237154100002e-01,  8.5079051383399995e-01,  8.5177865612600001e-01, \
                                    8.5276679841900005e-01,  8.5375494071100000e-01,  8.5474308300400004e-01, \
                                    8.5573122529599999e-01,  8.5671936758900002e-01,  8.5770750988099997e-01, \
                                    8.5869565217400001e-01,  8.5968379446599996e-01,  8.6067193675900000e-01, \
                                    8.6166007905099995e-01,  8.6264822134399999e-01,  8.6363636363600005e-01, \
                                    8.6462450592899998e-01,  8.6561264822100004e-01,  8.6660079051399996e-01, \
                                    8.6758893280600002e-01,  8.6857707509899995e-01,  8.6956521739100001e-01, \
                                    8.7055335968400005e-01,  8.7154150197600000e-01,  8.7252964426900004e-01, \
                                    8.7351778656099999e-01,  8.7450592885400003e-01,  8.7549407114599997e-01, \
                                    8.7648221343900001e-01,  8.7747035573099996e-01,  8.7845849802400000e-01, \
                                    8.7944664031599995e-01,  8.8043478260899999e-01,  8.8142292490100005e-01, \
                                    8.8241106719399998e-01,  8.8339920948600004e-01,  8.8438735177899996e-01, \
                                    8.8537549407100002e-01,  8.8636363636399995e-01,  8.8735177865600001e-01, \
                                    8.8833992094900005e-01,  8.8932806324100000e-01,  8.9031620553400004e-01, \
                                    8.9130434782599999e-01,  8.9229249011900003e-01,  8.9328063241099998e-01, \
                                    8.9426877470400001e-01,  8.9525691699599996e-01,  8.9624505928900000e-01, \
                                    8.9723320158099995e-01,  8.9822134387399999e-01,  8.9920948616600005e-01, \
                                    9.0019762845800000e-01,  9.0118577075100004e-01,  9.0217391304299999e-01, \
                                    9.0316205533600002e-01,  9.0415019762799997e-01,  9.0513833992100001e-01, \
                                    9.0612648221299996e-01,  9.0711462450600000e-01,  9.0810276679799995e-01, \
                                    9.0909090909099999e-01,  9.1007905138300005e-01,  9.1106719367599998e-01, \
                                    9.1205533596800004e-01,  9.1304347826099996e-01,  9.1403162055300002e-01, \
                                    9.1501976284599995e-01,  9.1600790513800001e-01,  9.1699604743100005e-01, \
                                    9.1798418972300000e-01,  9.1897233201600004e-01,  9.1996047430799999e-01, \
                                    9.2094861660100003e-01,  9.2193675889299997e-01,  9.2292490118600001e-01, \
                                    9.2391304347799996e-01,  9.2490118577100000e-01,  9.2588932806299995e-01, \
                                    9.2687747035599999e-01,  9.2786561264800005e-01,  9.2885375494099998e-01, \
                                    9.2984189723300004e-01,  9.3083003952599996e-01,  9.3181818181800002e-01, \
                                    9.3280632411099995e-01,  9.3379446640300001e-01,  9.3478260869600005e-01, \
                                    9.3577075098800000e-01,  9.3675889328100004e-01,  9.3774703557299999e-01, \
                                    9.3873517786600003e-01,  9.3972332015799998e-01,  9.4071146245100001e-01, \
                                    9.4169960474299996e-01,  9.4268774703600000e-01,  9.4367588932799995e-01, \
                                    9.4466403162099999e-01,  9.4565217391300005e-01,  9.4664031620599998e-01, \
                                    9.4762845849800004e-01,  9.4861660079099996e-01,  9.4960474308300002e-01, \
                                    9.5059288537499997e-01,  9.5158102766800001e-01,  9.5256916995999996e-01, \
                                    9.5355731225300000e-01,  9.5454545454499995e-01,  9.5553359683799999e-01, \
                                    9.5652173913000005e-01,  9.5750988142299998e-01,  9.5849802371500004e-01, \
                                    9.5948616600799996e-01,  9.6047430830000002e-01,  9.6146245059299995e-01, \
                                    9.6245059288500001e-01,  9.6343873517800005e-01,  9.6442687747000000e-01, \
                                    9.6541501976300004e-01,  9.6640316205499999e-01,  9.6739130434800003e-01, \
                                    9.6837944663999997e-01,  9.6936758893300001e-01,  9.7035573122499996e-01, \
                                    9.7134387351800000e-01,  9.7233201580999995e-01,  9.7332015810299999e-01, \
                                    9.7430830039500005e-01,  9.7529644268799998e-01,  9.7628458498000004e-01, \
                                    9.7727272727299996e-01,  9.7826086956500002e-01,  9.7924901185799995e-01, \
                                    9.8023715415000001e-01,  9.8122529644300005e-01,  9.8221343873500000e-01, \
                                    9.8320158102800004e-01,  9.8418972331999999e-01,  9.8517786561300003e-01, \
                                    9.8616600790499997e-01,  9.8715415019800001e-01,  9.8814229248999996e-01, \
                                    9.8913043478300000e-01,  9.9011857707499995e-01,  9.9110671936799999e-01, \
                                    9.9209486166000005e-01,  9.9308300395299998e-01,  9.9407114624500004e-01, \
                                    9.9505928853799996e-01,  9.9604743083000002e-01,  9.9703557312299995e-01, \
                                    9.9802371541500001e-01,  9.9901185770699996e-01,  1.0000000000000000e+00, \
                                    -1.0000000000000000e+00, -9.9913043478300001e-01, -9.9826086956500004e-01, \
                                    -9.9739130434800005e-01, -9.9652173912999997e-01, -9.9565217391299998e-01, \
                                    -9.9478260869599999e-01, -9.9391304347800002e-01, -9.9304347826100003e-01, \
                                    -9.9217391304299996e-01, -9.9130434782599997e-01, -9.9043478260899998e-01, \
                                    -9.8956521739100001e-01, -9.8869565217400002e-01, -9.8782608695700003e-01, \
                                    -9.8695652173899995e-01, -9.8608695652199996e-01, -9.8521739130399999e-01, \
                                    -9.8434782608700000e-01, -9.8347826087000001e-01, -9.8260869565200004e-01, \
                                    -9.8173913043500005e-01, -9.8086956521699997e-01, -9.7999999999999998e-01, \
                                    -9.7913043478299999e-01, -9.7826086956500002e-01, -9.7739130434800003e-01, \
                                    -9.7652173912999995e-01, -9.7565217391299996e-01, -9.7478260869599997e-01, \
                                    -9.7391304347800001e-01, -9.7304347826100002e-01, -9.7217391304300005e-01, \
                                    -9.7130434782599995e-01, -9.7043478260899996e-01, -9.6956521739099999e-01, \
                                    -9.6869565217400000e-01, -9.6782608695700001e-01, -9.6695652173900004e-01, \
                                    -9.6608695652200005e-01, -9.6521739130399997e-01, -9.6434782608699998e-01, \
                                    -9.6347826086999999e-01, -9.6260869565200002e-01, -9.6173913043500003e-01, \
                                    -9.6086956521699995e-01, -9.5999999999999996e-01, -9.5913043478299997e-01, \
                                    -9.5826086956500001e-01, -9.5739130434800002e-01, -9.5652173913000005e-01, \
                                    -9.5565217391299995e-01, -9.5478260869599996e-01, -9.5391304347799999e-01, \
                                    -9.5304347826100000e-01, -9.5217391304300003e-01, -9.5130434782600004e-01, \
                                    -9.5043478260900005e-01, -9.4956521739099997e-01, -9.4869565217399998e-01, \
                                    -9.4782608695699999e-01, -9.4695652173900002e-01, -9.4608695652200003e-01, \
                                    -9.4521739130399995e-01, -9.4434782608699996e-01, -9.4347826086999997e-01, \
                                    -9.4260869565200001e-01, -9.4173913043500002e-01, -9.4086956521700005e-01, \
                                    -9.3999999999999995e-01, -9.3913043478299996e-01, -9.3826086956499999e-01, \
                                    -9.3739130434800000e-01, -9.3652173913000003e-01, -9.3565217391300004e-01, \
                                    -9.3478260869600005e-01, -9.3391304347799997e-01, -9.3304347826099998e-01, \
                                    -9.3217391304300001e-01, -9.3130434782600002e-01, -9.3043478260900003e-01, \
                                    -9.2956521739099995e-01, -9.2869565217399996e-01, -9.2782608695699997e-01, \
                                    -9.2695652173900001e-01, -9.2608695652200002e-01, -9.2521739130400005e-01, \
                                    -9.2434782608699995e-01, -9.2347826086999996e-01, -9.2260869565199999e-01, \
                                    -9.2173913043500000e-01, -9.2086956521700003e-01, -9.2000000000000004e-01, \
                                    -9.1913043478300005e-01, -9.1826086956499997e-01, -9.1739130434799998e-01, \
                                    -9.1652173913000001e-01, -9.1565217391300002e-01, -9.1478260869600003e-01, \
                                    -9.1391304347799995e-01, -9.1304347826099996e-01, -9.1217391304300000e-01, \
                                    -9.1130434782600001e-01, -9.1043478260900002e-01, -9.0956521739100005e-01, \
                                    -9.0869565217399995e-01, -9.0782608695699996e-01, -9.0695652173899999e-01, \
                                    -9.0608695652200000e-01, -9.0521739130400003e-01, -9.0434782608700004e-01, \
                                    -9.0347826087000005e-01, -9.0260869565199997e-01, -9.0173913043499998e-01, \
                                    -9.0086956521700001e-01, -9.0000000000000002e-01, -8.9913043478300003e-01, \
                                    -8.9826086956499995e-01, -8.9739130434799996e-01, -8.9652173912999999e-01, \
                                    -8.9565217391300000e-01, -8.9478260869600001e-01, -8.9391304347800005e-01, \
                                    -8.9304347826099995e-01, -8.9217391304299998e-01, -8.9130434782599999e-01, \
                                    -8.9043478260900000e-01, -8.8956521739100003e-01, -8.8869565217400004e-01, \
                                    -8.8782608695700005e-01, -8.8695652173899997e-01, -8.8608695652199998e-01, \
                                    -8.8521739130400001e-01, -8.8434782608700002e-01, -8.8347826087000003e-01, \
                                    -8.8260869565199995e-01, -8.8173913043499996e-01, -8.8086956521699999e-01, \
                                    -8.8000000000000000e-01, -8.7913043478300001e-01, -8.7826086956500005e-01, \
                                    -8.7739130434799995e-01, -8.7652173912999998e-01, -8.7565217391299999e-01, \
                                    -8.7478260869600000e-01, -8.7391304347800003e-01, -8.7304347826100004e-01, \
                                    -8.7217391304299996e-01, -8.7130434782599997e-01, -8.7043478260899998e-01, \
                                    -8.6956521739100001e-01, -8.6869565217400002e-01, -8.6782608695700003e-01, \
                                    -8.6695652173899995e-01, -8.6608695652199996e-01, -8.6521739130399999e-01, \
                                    -8.6434782608700000e-01, -8.6347826087000001e-01, -8.6260869565200005e-01, \
                                    -8.6173913043499994e-01, -8.6086956521699998e-01, -8.5999999999999999e-01, \
                                    -8.5913043478300000e-01, -8.5826086956500003e-01, -8.5739130434800004e-01, \
                                    -8.5652173912999996e-01, -8.5565217391299997e-01, -8.5478260869599998e-01, \
                                    -8.5391304347800001e-01, -8.5304347826100002e-01, -8.5217391304300005e-01, \
                                    -8.5130434782599995e-01, -8.5043478260899996e-01, -8.4956521739099999e-01, \
                                    -8.4869565217400000e-01, -8.4782608695700001e-01, -8.4695652173900005e-01, \
                                    -8.4608695652200006e-01, -8.4521739130399998e-01, -8.4434782608699999e-01, \
                                    -8.4347826087000000e-01, -8.4260869565200003e-01, -8.4173913043500004e-01, \
                                    -8.4086956521699996e-01, -8.3999999999999997e-01, -8.3913043478299998e-01, \
                                    -8.3826086956500001e-01, -8.3739130434800002e-01, -8.3652173913000005e-01, \
                                    -8.3565217391299995e-01, -8.3478260869599996e-01, -8.3391304347799999e-01, \
                                    -8.3304347826100000e-01, -8.3217391304300004e-01, -8.3130434782600005e-01, \
                                    -8.3043478260900006e-01, -8.2956521739099998e-01, -8.2869565217399999e-01, \
                                    -8.2782608695700000e-01, -8.2695652173900003e-01, -8.2608695652200004e-01, \
                                    -8.2521739130399996e-01, -8.2434782608699997e-01, -8.2347826086999998e-01, \
                                    -8.2260869565200001e-01, -8.2173913043500002e-01, -8.2086956521700005e-01, \
                                    -8.1999999999999995e-01, -8.1913043478299996e-01, -8.1826086956499999e-01, \
                                    -8.1739130434800000e-01, -8.1652173913000003e-01, -8.1565217391300004e-01, \
                                    -8.1478260869600005e-01, -8.1391304347799998e-01, -8.1304347826099999e-01, \
                                    -8.1217391304300002e-01, -8.1130434782600003e-01, -8.1043478260900004e-01, \
                                    -8.0956521739099996e-01, -8.0869565217399997e-01, -8.0782608695699998e-01, \
                                    -8.0695652173900001e-01, -8.0608695652200002e-01, -8.0521739130400005e-01, \
                                    -8.0434782608699995e-01, -8.0347826086999996e-01, -8.0260869565199999e-01, \
                                    -8.0173913043500000e-01, -8.0086956521700003e-01, -8.0000000000000004e-01, \
                                    -7.9913043478300005e-01, -7.9826086956499998e-01, -7.9739130434799999e-01, \
                                    -7.9652173913000002e-01, -7.9565217391300003e-01, -7.9478260869600004e-01, \
                                    -7.9391304347799996e-01, -7.9304347826099997e-01, -7.9217391304300000e-01, \
                                    -7.9130434782600001e-01, -7.9043478260900002e-01, -7.8956521739100005e-01, \
                                    -7.8869565217399995e-01, -7.8782608695699996e-01, -7.8695652173899999e-01, \
                                    -7.8608695652200000e-01, -7.8521739130400003e-01, -7.8434782608700004e-01, \
                                    -7.8347826087000005e-01, -7.8260869565199997e-01, -7.8173913043499998e-01, \
                                    -7.8086956521700002e-01, -7.8000000000000003e-01, -7.7913043478300004e-01, \
                                    -7.7826086956499996e-01, -7.7739130434799997e-01, -7.7652173913000000e-01, \
                                    -7.7565217391300001e-01, -7.7478260869600002e-01, -7.7391304347800005e-01, \
                                    -7.7304347826099995e-01, -7.7217391304299998e-01, -7.7130434782599999e-01, \
                                    -7.7043478260900000e-01, -7.6956521739100003e-01, -7.6869565217400004e-01, \
                                    -7.6782608695700005e-01, -7.6695652173899997e-01, -7.6608695652199998e-01, \
                                    -7.6521739130400002e-01, -7.6434782608700003e-01, -7.6347826087000004e-01, \
                                    -7.6260869565199996e-01, -7.6173913043499997e-01, -7.6086956521700000e-01, \
                                    -7.6000000000000001e-01, -7.5913043478300002e-01, -7.5826086956500005e-01, \
                                    -7.5739130434799995e-01, -7.5652173912999998e-01, -7.5565217391299999e-01, \
                                    -7.5478260869600000e-01, -7.5391304347800003e-01, -7.5304347826100004e-01, \
                                    -7.5217391304299996e-01, -7.5130434782599997e-01, -7.5043478260899998e-01, \
                                    -7.4956521739100002e-01, -7.4869565217400003e-01, -7.4782608695700004e-01, \
                                    -7.4695652173899996e-01, -7.4608695652199997e-01, -7.4521739130400000e-01, \
                                    -7.4434782608700001e-01, -7.4347826087000002e-01, -7.4260869565200005e-01, \
                                    -7.4173913043499995e-01, -7.4086956521699998e-01, -7.3999999999999999e-01, \
                                    -7.3913043478300000e-01, -7.3826086956500003e-01, -7.3739130434800004e-01, \
                                    -7.3652173912999996e-01, -7.3565217391299997e-01, -7.3478260869599998e-01, \
                                    -7.3391304347800002e-01, -7.3304347826100003e-01, -7.3217391304299995e-01, \
                                    -7.3130434782599996e-01, -7.3043478260899997e-01, -7.2956521739100000e-01, \
                                    -7.2869565217400001e-01, -7.2782608695700002e-01, -7.2695652173900005e-01, \
                                    -7.2608695652199995e-01, -7.2521739130399998e-01, -7.2434782608699999e-01, \
                                    -7.2347826087000000e-01, -7.2260869565200003e-01, -7.2173913043500004e-01, \
                                    -7.2086956521699996e-01, -7.1999999999999997e-01, -7.1913043478299998e-01, \
                                    -7.1826086956500002e-01, -7.1739130434800003e-01, -7.1652173912999995e-01, \
                                    -7.1565217391299996e-01, -7.1478260869599997e-01, -7.1391304347800000e-01, \
                                    -7.1304347826100001e-01, -7.1217391304300004e-01, -7.1130434782600005e-01, \
                                    -7.1043478260899995e-01, -7.0956521739099998e-01, -7.0869565217399999e-01, \
                                    -7.0782608695700000e-01, -7.0695652173900003e-01, -7.0608695652200004e-01, \
                                    -7.0521739130399996e-01, -7.0434782608699997e-01, -7.0347826086999998e-01, \
                                    -7.0260869565200001e-01, -7.0173913043500002e-01, -7.0086956521699995e-01, \
                                    -6.9999999999999996e-01, -6.9913043478299997e-01, -6.9826086956500000e-01, \
                                    -6.9739130434800001e-01, -6.9652173913000004e-01, -6.9565217391300005e-01, \
                                    -6.9478260869599995e-01, -6.9391304347799998e-01, -6.9304347826099999e-01, \
                                    -6.9217391304300002e-01, -6.9130434782600003e-01, -6.9043478260900004e-01, \
                                    -6.8956521739099996e-01, -6.8869565217399997e-01, -6.8782608695699998e-01, \
                                    -6.8695652173900001e-01, -6.8608695652200002e-01, -6.8521739130399995e-01, \
                                    -6.8434782608699996e-01, -6.8347826086999997e-01, -6.8260869565200000e-01, \
                                    -6.8173913043500001e-01, -6.8086956521700004e-01, -6.8000000000000005e-01, \
                                    -6.7913043478299995e-01, -6.7826086956499998e-01, -6.7739130434799999e-01, \
                                    -6.7652173913000002e-01, -6.7565217391300003e-01, -6.7478260869600004e-01, \
                                    -6.7391304347799996e-01, -6.7304347826099997e-01, -6.7217391304300000e-01, \
                                    -6.7130434782600001e-01, -6.7043478260900002e-01, -6.6956521739099994e-01, \
                                    -6.6869565217399995e-01, -6.6782608695699996e-01, -6.6695652173900000e-01, \
                                    -6.6608695652200001e-01, -6.6521739130400004e-01, -6.6434782608700005e-01, \
                                    -6.6347826086999995e-01, -6.6260869565199998e-01, -6.6173913043499999e-01, \
                                    -6.6086956521700002e-01, -6.6000000000000003e-01, -6.5913043478300004e-01, \
                                    -6.5826086956499996e-01, -6.5739130434799997e-01, -6.5652173913000000e-01, \
                                    -6.5565217391300001e-01, -6.5478260869600002e-01, -6.5391304347799994e-01, \
                                    -6.5304347826099995e-01, -6.5217391304299999e-01, -6.5130434782600000e-01, \
                                    -6.5043478260900001e-01, -6.4956521739100004e-01, -6.4869565217400005e-01, \
                                    -6.4782608695699995e-01, -6.4695652173899998e-01, -6.4608695652199999e-01, \
                                    -6.4521739130400002e-01, -6.4434782608700003e-01, -6.4347826087000004e-01, \
                                    -6.4260869565199996e-01, -6.4173913043499997e-01, -6.4086956521700000e-01, \
                                    -6.4000000000000001e-01, -6.3913043478300002e-01, -6.3826086956500006e-01, \
                                    -6.3739130434799995e-01, -6.3652173912999999e-01, -6.3565217391300000e-01, \
                                    -6.3478260869600001e-01, -6.3391304347800004e-01, -6.3304347826100005e-01, \
                                    -6.3217391304299997e-01, -6.3130434782599998e-01, -6.3043478260899999e-01, \
                                    -6.2956521739100002e-01, -6.2869565217400003e-01, -6.2782608695700004e-01, \
                                    -6.2695652173899996e-01, -6.2608695652199997e-01, -6.2521739130400000e-01, \
                                    -6.2434782608700001e-01, -6.2347826087000002e-01, -6.2260869565200005e-01, \
                                    -6.2173913043499995e-01, -6.2086956521699999e-01, -6.2000000000000000e-01, \
                                    -6.1913043478300001e-01, -6.1826086956500004e-01, -6.1739130434800005e-01, \
                                    -6.1652173912999997e-01, -6.1565217391299998e-01, -6.1478260869599999e-01, \
                                    -6.1391304347800002e-01, -6.1304347826100003e-01, -6.1217391304299995e-01, \
                                    -6.1130434782599996e-01, -6.1043478260899997e-01, -6.0956521739100000e-01, \
                                    -6.0869565217400001e-01, -6.0782608695700002e-01, -6.0695652173900005e-01, \
                                    -6.0608695652199995e-01, -6.0521739130399999e-01, -6.0434782608700000e-01, \
                                    -6.0347826087000001e-01, -6.0260869565200004e-01, -6.0173913043500005e-01, \
                                    -6.0086956521699997e-01, -5.9999999999999998e-01, -5.9913043478299999e-01, \
                                    -5.9826086956500002e-01, -5.9739130434800003e-01, -5.9652173912999995e-01, \
                                    -5.9565217391299996e-01, -5.9478260869599997e-01, -5.9391304347800000e-01, \
                                    -5.9304347826100001e-01, -5.9217391304300004e-01, -5.9130434782600005e-01, \
                                    -5.9043478260899995e-01, -5.8956521739099998e-01, -5.8869565217399999e-01, \
                                    -5.8782608695700000e-01, -5.8695652173900004e-01, -5.8608695652200005e-01, \
                                    -5.8521739130399997e-01, -5.8434782608699998e-01, -5.8347826086999999e-01, \
                                    -5.8260869565200002e-01, -5.8173913043500003e-01, -5.8086956521699995e-01, \
                                    -5.7999999999999996e-01, -5.7913043478299997e-01, -5.7826086956500000e-01, \
                                    -5.7739130434800001e-01, -5.7652173913000004e-01, -5.7565217391300005e-01, \
                                    -5.7478260869599995e-01, -5.7391304347799998e-01, -5.7304347826099999e-01, \
                                    -5.7217391304300003e-01, -5.7130434782600004e-01, -5.7043478260900005e-01, \
                                    -5.6956521739099997e-01, -5.6869565217399998e-01, -5.6782608695699999e-01, \
                                    -5.6695652173900002e-01, -5.6608695652200003e-01, -5.6521739130399995e-01, \
                                    -5.6434782608699996e-01, -5.6347826086999997e-01, -5.6260869565200000e-01, \
                                    -5.6173913043500001e-01, -5.6086956521700004e-01, -5.6000000000000005e-01, \
                                    -5.5913043478299995e-01, -5.5826086956499998e-01, -5.5739130434799999e-01, \
                                    -5.5652173913000003e-01, -5.5565217391300004e-01, -5.5478260869600005e-01, \
                                    -5.5391304347799997e-01, -5.5304347826099998e-01, -5.5217391304300001e-01, \
                                    -5.5130434782600002e-01, -5.5043478260900003e-01, -5.4956521739099995e-01, \
                                    -5.4869565217399996e-01, -5.4782608695699997e-01, -5.4695652173900000e-01, \
                                    -5.4608695652200001e-01, -5.4521739130400004e-01, -5.4434782608700005e-01, \
                                    -5.4347826086999995e-01, -5.4260869565199998e-01, -5.4173913043499999e-01, \
                                    -5.4086956521700003e-01, -5.4000000000000004e-01, -5.3913043478300005e-01, \
                                    -5.3826086956499997e-01, -5.3739130434799998e-01, -5.3652173913000001e-01, \
                                    -5.3565217391300002e-01, -5.3478260869600003e-01, -5.3391304347799995e-01, \
                                    -5.3304347826099996e-01, -5.3217391304299999e-01, -5.3130434782600000e-01, \
                                    -5.3043478260900001e-01, -5.2956521739100004e-01, -5.2869565217400005e-01, \
                                    -5.2782608695699995e-01, -5.2695652173899998e-01, -5.2608695652199999e-01, \
                                    -5.2521739130400003e-01, -5.2434782608700004e-01, -5.2347826087000005e-01, \
                                    -5.2260869565199997e-01, -5.2173913043499998e-01, -5.2086956521700001e-01, \
                                    -5.2000000000000002e-01, -5.1913043478300003e-01, -5.1826086956499995e-01, \
                                    -5.1739130434799996e-01, -5.1652173912999999e-01, -5.1565217391300000e-01, \
                                    -5.1478260869600001e-01, -5.1391304347800004e-01, -5.1304347826100005e-01, \
                                    -5.1217391304299997e-01, -5.1130434782599998e-01, -5.1043478260899999e-01, \
                                    -5.0956521739100002e-01, -5.0869565217400003e-01, -5.0782608695599996e-01, \
                                    -5.0695652173899997e-01, -5.0608695652199998e-01, -5.0521739130400001e-01, \
                                    -5.0434782608700002e-01, -5.0347826087000003e-01, -5.0260869565199995e-01, \
                                    -5.0173913043499996e-01, -5.0086956521699999e-01, -5.0000000000000000e-01, \
                                    -4.9913043478300001e-01, -4.9826086956499999e-01, -4.9739130434800000e-01, \
                                    -4.9652173912999997e-01, -4.9565217391299998e-01, -4.9478260869599999e-01, \
                                    -4.9391304347800002e-01, -4.9304347826099998e-01, -4.9217391304300001e-01, \
                                    -4.9130434782600002e-01, -4.9043478260899998e-01, -4.8956521739100001e-01, \
                                    -4.8869565217400002e-01, -4.8782608695599999e-01, -4.8695652173900000e-01, \
                                    -4.8608695652200001e-01, -4.8521739130399999e-01, -4.8434782608700000e-01, \
                                    -4.8347826087000001e-01, -4.8260869565199999e-01, -4.8173913043500000e-01, \
                                    -4.8086956521699997e-01, -4.7999999999999998e-01, -4.7913043478299999e-01, \
                                    -4.7826086956500002e-01, -4.7739130434799998e-01, -4.7652173913000001e-01, \
                                    -4.7565217391300002e-01, -4.7478260869599997e-01, -4.7391304347800001e-01, \
                                    -4.7304347826100002e-01, -4.7217391304299999e-01, -4.7130434782600000e-01, \
                                    -4.7043478260900001e-01, -4.6956521739099999e-01, -4.6869565217400000e-01, \
                                    -4.6782608695599998e-01, -4.6695652173899999e-01, -4.6608695652200000e-01, \
                                    -4.6521739130400003e-01, -4.6434782608699998e-01, -4.6347826086999999e-01, \
                                    -4.6260869565200002e-01, -4.6173913043499998e-01, -4.6086956521700001e-01, \
                                    -4.6000000000000002e-01, -4.5913043478299997e-01, -4.5826086956500001e-01, \
                                    -4.5739130434800002e-01, -4.5652173912999999e-01, -4.5565217391300000e-01, \
                                    -4.5478260869600001e-01, -4.5391304347799999e-01, -4.5304347826100000e-01, \
                                    -4.5217391304299998e-01, -4.5130434782599999e-01, -4.5043478260900000e-01, \
                                    -4.4956521739100003e-01, -4.4869565217399998e-01, -4.4782608695699999e-01, \
                                    -4.4695652173900002e-01, -4.4608695652199998e-01, -4.4521739130400001e-01, \
                                    -4.4434782608700002e-01, -4.4347826086999997e-01, -4.4260869565200001e-01, \
                                    -4.4173913043500002e-01, -4.4086956521699999e-01, -4.4000000000000000e-01, \
                                    -4.3913043478300001e-01, -4.3826086956499999e-01, -4.3739130434800000e-01, \
                                    -4.3652173912999997e-01, -4.3565217391299998e-01, -4.3478260869599999e-01, \
                                    -4.3391304347800003e-01, -4.3304347826099998e-01, -4.3217391304300001e-01, \
                                    -4.3130434782600002e-01, -4.3043478260899998e-01, -4.2956521739100001e-01, \
                                    -4.2869565217400002e-01, -4.2782608695699997e-01, -4.2695652173900001e-01, \
                                    -4.2608695652200002e-01, -4.2521739130399999e-01, -4.2434782608700000e-01, \
                                    -4.2347826087000001e-01, -4.2260869565199999e-01, -4.2173913043500000e-01, \
                                    -4.2086956521699997e-01, -4.1999999999999998e-01, -4.1913043478299999e-01, \
                                    -4.1826086956500003e-01, -4.1739130434799998e-01, -4.1652173913000001e-01, \
                                    -4.1565217391300002e-01, -4.1478260869599998e-01, -4.1391304347800001e-01, \
                                    -4.1304347826100002e-01, -4.1217391304300000e-01, -4.1130434782600001e-01, \
                                    -4.1043478260900002e-01, -4.0956521739099999e-01, -4.0869565217400000e-01, \
                                    -4.0782608695700001e-01, -4.0695652173899999e-01, -4.0608695652200000e-01, \
                                    -4.0521739130399997e-01, -4.0434782608699998e-01, -4.0347826086999999e-01, \
                                    -4.0260869565200003e-01, -4.0173913043499998e-01, -4.0086956521700001e-01, \
                                    -4.0000000000000002e-01, -3.9913043478299998e-01, -3.9826086956500001e-01, \
                                    -3.9739130434800002e-01, -3.9652173912999999e-01, -3.9565217391300000e-01, \
                                    -3.9478260869600001e-01, -3.9391304347799999e-01, -3.9304347826100000e-01, \
                                    -3.9217391304299998e-01, -3.9130434782599999e-01, -3.9043478260900000e-01, \
                                    -3.8956521739099997e-01, -3.8869565217399998e-01, -3.8782608695699999e-01, \
                                    -3.8695652173900003e-01, -3.8608695652199998e-01, -3.8521739130400001e-01, \
                                    -3.8434782608700002e-01, -3.8347826086999998e-01, -3.8260869565200001e-01, \
                                    -3.8173913043500002e-01, -3.8086956521699999e-01, -3.8000000000000000e-01, \
                                    -3.7913043478300001e-01, -3.7826086956499999e-01, -3.7739130434800000e-01, \
                                    -3.7652173912999998e-01, -3.7565217391299999e-01, -3.7478260869600000e-01, \
                                    -3.7391304347799997e-01, -3.7304347826099998e-01, -3.7217391304300002e-01, \
                                    -3.7130434782600003e-01, -3.7043478260899998e-01, -3.6956521739100001e-01, \
                                    -3.6869565217400002e-01, -3.6782608695699998e-01, -3.6695652173900001e-01, \
                                    -3.6608695652200002e-01, -3.6521739130399999e-01, -3.6434782608700000e-01, \
                                    -3.6347826087000001e-01, -3.6260869565199999e-01, -3.6173913043500000e-01, \
                                    -3.6086956521699998e-01, -3.5999999999999999e-01, -3.5913043478300000e-01, \
                                    -3.5826086956499997e-01, -3.5739130434799998e-01, -3.5652173913000001e-01, \
                                    -3.5565217391300002e-01, -3.5478260869599998e-01, -3.5391304347800001e-01, \
                                    -3.5304347826100002e-01, -3.5217391304300000e-01, -3.5130434782600001e-01, \
                                    -3.5043478260900002e-01, -3.4956521739099999e-01, -3.4869565217400000e-01, \
                                    -3.4782608695700001e-01, -3.4695652173899999e-01, -3.4608695652200000e-01, \
                                    -3.4521739130399998e-01, -3.4434782608699999e-01, -3.4347826087000000e-01, \
                                    -3.4260869565199997e-01, -3.4173913043499998e-01, -3.4086956521700001e-01, \
                                    -3.4000000000000002e-01, -3.3913043478299998e-01, -3.3826086956500001e-01, \
                                    -3.3739130434800002e-01, -3.3652173913000000e-01, -3.3565217391300001e-01, \
                                    -3.3478260869600002e-01, -3.3391304347799999e-01, -3.3304347826100000e-01, \
                                    -3.3217391304299998e-01, -3.3130434782599999e-01, -3.3043478260900000e-01, \
                                    -3.2956521739099998e-01, -3.2869565217399999e-01, -3.2782608695700000e-01, \
                                    -3.2695652173899997e-01, -3.2608695652199998e-01, -3.2521739130400001e-01, \
                                    -3.2434782608700002e-01, -3.2347826086999998e-01, -3.2260869565200001e-01, \
                                    -3.2173913043500002e-01, -3.2086956521700000e-01, -3.2000000000000001e-01, \
                                    -3.1913043478300002e-01, -3.1826086956499999e-01, -3.1739130434800000e-01, \
                                    -3.1652173912999998e-01, -3.1565217391299999e-01, -3.1478260869600000e-01, \
                                    -3.1391304347799998e-01, -3.1304347826099999e-01, -3.1217391304300002e-01, \
                                    -3.1130434782600003e-01, -3.1043478260899998e-01, -3.0956521739100001e-01, \
                                    -3.0869565217400002e-01, -3.0782608695699998e-01, -3.0695652173900001e-01, \
                                    -3.0608695652200002e-01, -3.0521739130400000e-01, -3.0434782608700001e-01, \
                                    -3.0347826087000002e-01, -3.0260869565199999e-01, -3.0173913043500000e-01, \
                                    -3.0086956521699998e-01, -2.9999999999999999e-01, -2.9913043478300000e-01, \
                                    -2.9826086956499998e-01, -2.9739130434799999e-01, -2.9652173913000002e-01, \
                                    -2.9565217391300003e-01, -2.9478260869599998e-01, -2.9391304347800001e-01, \
                                    -2.9304347826100002e-01, -2.9217391304300000e-01, -2.9130434782600001e-01, \
                                    -2.9043478260900002e-01, -2.8956521739100000e-01, -2.8869565217400001e-01, \
                                    -2.8782608695700002e-01, -2.8695652173899999e-01, -2.8608695652200000e-01, \
                                    -2.8521739130399998e-01, -2.8434782608699999e-01, -2.8347826087000000e-01, \
                                    -2.8260869565199997e-01, -2.8173913043499998e-01, -2.8086956521700002e-01, \
                                    -2.8000000000000003e-01, -2.7913043478299998e-01, -2.7826086956500001e-01, \
                                    -2.7739130434800002e-01, -2.7652173913000000e-01, -2.7565217391300001e-01, \
                                    -2.7478260869600002e-01, -2.7391304347800000e-01, -2.7304347826100001e-01, \
                                    -2.7217391304299998e-01, -2.7130434782599999e-01, -2.7043478260900000e-01, \
                                    -2.6956521739099998e-01, -2.6869565217399999e-01, -2.6782608695700000e-01, \
                                    -2.6695652173899997e-01, -2.6608695652199998e-01, -2.6521739130400002e-01, \
                                    -2.6434782608700003e-01, -2.6347826086999998e-01, -2.6260869565200001e-01, \
                                    -2.6173913043500002e-01, -2.6086956521700000e-01, -2.6000000000000001e-01, \
                                    -2.5913043478300002e-01, -2.5826086956500000e-01, -2.5739130434800001e-01, \
                                    -2.5652173912999998e-01, -2.5565217391299999e-01, -2.5478260869600000e-01, \
                                    -2.5391304347799998e-01, -2.5304347826099999e-01, -2.5217391304300002e-01, \
                                    -2.5130434782599997e-01, -2.5043478260899998e-01, -2.4956521739099999e-01, \
                                    -2.4869565217400000e-01, -2.4782608695700001e-01, -2.4695652173900001e-01, \
                                    -2.4608695652199999e-01, -2.4521739130400000e-01, -2.4434782608700001e-01, \
                                    -2.4347826086999999e-01, -2.4260869565199999e-01, -2.4173913043500000e-01, \
                                    -2.4086956521700001e-01, -2.3999999999999999e-01, -2.3913043478300000e-01, \
                                    -2.3826086956500001e-01, -2.3739130434799999e-01, -2.3652173912999999e-01, \
                                    -2.3565217391300000e-01, -2.3478260869600001e-01, -2.3391304347799999e-01, \
                                    -2.3304347826100000e-01, -2.3217391304300000e-01, -2.3130434782600001e-01, \
                                    -2.3043478260899999e-01, -2.2956521739100000e-01, -2.2869565217400001e-01, \
                                    -2.2782608695699999e-01, -2.2695652173899999e-01, -2.2608695652200000e-01, \
                                    -2.2521739130400001e-01, -2.2434782608699999e-01, -2.2347826087000000e-01, \
                                    -2.2260869565200000e-01, -2.2173913043499999e-01, -2.2086956521699999e-01, \
                                    -2.2000000000000000e-01, -2.1913043478300001e-01, -2.1826086956499999e-01, \
                                    -2.1739130434800000e-01, -2.1652173913000000e-01, -2.1565217391300001e-01, \
                                    -2.1478260869599999e-01, -2.1391304347800000e-01, -2.1304347826100001e-01, \
                                    -2.1217391304300001e-01, -2.1130434782599999e-01, -2.1043478260900000e-01, \
                                    -2.0956521739100001e-01, -2.0869565217399999e-01, -2.0782608695700000e-01, \
                                    -2.0695652173900000e-01, -2.0608695652199999e-01, -2.0521739130399999e-01, \
                                    -2.0434782608700000e-01, -2.0347826087000001e-01, -2.0260869565199999e-01, \
                                    -2.0173913043500000e-01, -2.0086956521700000e-01, -2.0000000000000001e-01, \
                                    -1.9913043478299999e-01, -1.9826086956500000e-01, -1.9739130434800001e-01, \
                                    -1.9652173913000001e-01, -1.9565217391299999e-01, -1.9478260869600000e-01, \
                                    -1.9391304347800001e-01, -1.9304347826099999e-01, -1.9217391304299999e-01, \
                                    -1.9130434782600000e-01, -1.9043478260899999e-01, -1.8956521739099999e-01, \
                                    -1.8869565217400000e-01, -1.8782608695700001e-01, -1.8695652173899999e-01, \
                                    -1.8608695652200000e-01, -1.8521739130400000e-01, -1.8434782608700001e-01, \
                                    -1.8347826086999999e-01, -1.8260869565200000e-01, -1.8173913043500001e-01, \
                                    -1.8086956521700001e-01, -1.7999999999999999e-01, -1.7913043478300000e-01, \
                                    -1.7826086956500001e-01, -1.7739130434799999e-01, -1.7652173912999999e-01, \
                                    -1.7565217391300000e-01, -1.7478260869600001e-01, -1.7391304347799999e-01, \
                                    -1.7304347826100000e-01, -1.7217391304300000e-01, -1.7130434782599999e-01, \
                                    -1.7043478260900000e-01, -1.6956521739100000e-01, -1.6869565217400001e-01, \
                                    -1.6782608695699999e-01, -1.6695652173900000e-01, -1.6608695652200001e-01, \
                                    -1.6521739130400001e-01, -1.6434782608699999e-01, -1.6347826087000000e-01, \
                                    -1.6260869565200001e-01, -1.6173913043499999e-01, -1.6086956521699999e-01, \
                                    -1.6000000000000000e-01, -1.5913043478300001e-01, -1.5826086956499999e-01, \
                                    -1.5739130434800000e-01, -1.5652173913000000e-01, -1.5565217391300001e-01, \
                                    -1.5478260869600000e-01, -1.5391304347800000e-01, -1.5304347826100001e-01, \
                                    -1.5217391304299999e-01, -1.5130434782600000e-01, -1.5043478260900001e-01, \
                                    -1.4956521739100001e-01, -1.4869565217399999e-01, -1.4782608695700000e-01, \
                                    -1.4695652173900001e-01, -1.4608695652199999e-01, -1.4521739130399999e-01, \
                                    -1.4434782608700000e-01, -1.4347826087000001e-01, -1.4260869565199999e-01, \
                                    -1.4173913043500000e-01, -1.4086956521700000e-01, -1.4000000000000001e-01, \
                                    -1.3913043478300000e-01, -1.3826086956500000e-01, -1.3739130434800001e-01, \
                                    -1.3652173913000001e-01, -1.3565217391300000e-01, -1.3478260869600001e-01, \
                                    -1.3391304347800001e-01, -1.3304347826099999e-01, -1.3217391304300000e-01, \
                                    -1.3130434782600001e-01, -1.3043478260899999e-01, -1.2956521739099999e-01, \
                                    -1.2869565217400000e-01, -1.2782608695700001e-01, -1.2695652173899999e-01, \
                                    -1.2608695652200000e-01, -1.2521739130400000e-01, -1.2434782608700000e-01, \
                                    -1.2347826087000000e-01, -1.2260869565200000e-01, -1.2173913043500000e-01, \
                                    -1.2086956521700000e-01, -1.2000000000000000e-01, -1.1913043478300001e-01, \
                                    -1.1826086956500000e-01, -1.1739130434800001e-01, -1.1652173913000000e-01, \
                                    -1.1565217391300001e-01, -1.1478260869600000e-01, -1.1391304347800001e-01, \
                                    -1.1304347826100000e-01, -1.1217391304300001e-01, -1.1130434782600000e-01, \
                                    -1.1043478260900000e-01, -1.0956521739100000e-01, -1.0869565217400000e-01, \
                                    -1.0782608695699999e-01, -1.0695652173900000e-01, -1.0608695652199999e-01, \
                                    -1.0521739130400000e-01, -1.0434782608700000e-01, -1.0347826087000001e-01, \
                                    -1.0260869565200000e-01, -1.0173913043500001e-01, -1.0086956521700000e-01, \
                                    -1.0000000000000001e-01, -9.9130434783000002e-02, -9.8260869565000006e-02, \
                                    -9.7391304348000002e-02, -9.6521739130000006e-02, -9.5652173913000002e-02, \
                                    -9.4782608695999998e-02, -9.3913043478000002e-02, -9.3043478260999998e-02, \
                                    -9.2173913043000003e-02, -9.1304347825999999e-02, -9.0434782608999995e-02, \
                                    -8.9565217390999999e-02, -8.8695652173999995e-02, -8.7826086957000005e-02, \
                                    -8.6956521738999995e-02, -8.6086956522000005e-02, -8.5217391303999995e-02, \
                                    -8.4347826087000005e-02, -8.3478260870000001e-02, -8.2608695652000005e-02, \
                                    -8.1739130435000001e-02, -8.0869565217000006e-02, -8.0000000000000002e-02, \
                                    -7.9130434782999998e-02, -7.8260869565000002e-02, -7.7391304347999998e-02, \
                                    -7.6521739130000002e-02, -7.5652173912999998e-02, -7.4782608695999994e-02, \
                                    -7.3913043477999998e-02, -7.3043478260999994e-02, -7.2173913042999999e-02, \
                                    -7.1304347825999995e-02, -7.0434782609000005e-02, -6.9565217390999995e-02, \
                                    -6.8695652174000005e-02, -6.7826086957000001e-02, -6.6956521739000005e-02, \
                                    -6.6086956522000001e-02, -6.5217391304000005e-02, -6.4347826087000001e-02, \
                                    -6.3478260869999997e-02, -6.2608695652000002e-02, -6.1739130434999998e-02, \
                                    -6.0869565217000002e-02, -5.9999999999999998e-02, -5.9130434783000001e-02, \
                                    -5.8260869564999998e-02, -5.7391304348000001e-02, -5.6521739129999998e-02, \
                                    -5.5652173913000001e-02, -5.4782608695999997e-02, -5.3913043478000001e-02, \
                                    -5.3043478260999997e-02, -5.2173913043000002e-02, -5.1304347825999998e-02, \
                                    -5.0434782609000001e-02, -4.9565217390999998e-02, -4.8695652174000001e-02, \
                                    -4.7826086956999997e-02, -4.6956521739000001e-02, -4.6086956521999997e-02, \
                                    -4.5217391304000001e-02, -4.4347826086999997e-02, -4.3478260870000000e-02, \
                                    -4.2608695651999998e-02, -4.1739130435000001e-02, -4.0869565216999998e-02, \
                                    -4.0000000000000001e-02, -3.9130434782999997e-02, -3.8260869565000001e-02, \
                                    -3.7391304347999997e-02, -3.6521739130000001e-02, -3.5652173912999997e-02, \
                                    -3.4782608696000000e-02, -3.3913043477999998e-02, -3.3043478261000001e-02, \
                                    -3.2173913042999998e-02, -3.1304347826000001e-02, -3.0434782609000000e-02, \
                                    -2.9565217391000001e-02, -2.8695652174000000e-02, -2.7826086957000000e-02, \
                                    -2.6956521739000001e-02, -2.6086956522000000e-02, -2.5217391304000001e-02, \
                                    -2.4347826087000000e-02, -2.3478260870000000e-02, -2.2608695652000001e-02, \
                                    -2.1739130435000000e-02, -2.0869565217000001e-02, -2.0000000000000000e-02, \
                                    -1.9130434783000000e-02, -1.8260869565000001e-02, -1.7391304348000000e-02, \
                                    -1.6521739130000001e-02, -1.5652173913000000e-02, -1.4782608696000000e-02, \
                                    -1.3913043478000001e-02, -1.3043478261000000e-02, -1.2173913042999999e-02, \
                                    -1.1304347826000000e-02, -1.0434782609000000e-02, -9.5652173910000006e-03, \
                                    -8.6956521740000001e-03, -7.8260869569999995e-03, -6.9565217390000003e-03, \
                                    -6.0869565219999998e-03, -5.2173913039999997e-03, -4.3478260870000000e-03, \
                                    -3.4782608699999999e-03, -2.6086956519999998e-03, -1.7391304350000000e-03, \
                                    -8.6956521699999999e-04,  0.0000000000000000e+00,  8.6956521699999999e-04, \
                                    1.7391304350000000e-03,  2.6086956519999998e-03,  3.4782608699999999e-03, \
                                    4.3478260870000000e-03,  5.2173913039999997e-03,  6.0869565219999998e-03, \
                                    6.9565217390000003e-03,  7.8260869569999995e-03,  8.6956521740000001e-03, \
                                    9.5652173910000006e-03,  1.0434782609000000e-02,  1.1304347826000000e-02, \
                                    1.2173913042999999e-02,  1.3043478261000000e-02,  1.3913043478000001e-02, \
                                    1.4782608696000000e-02,  1.5652173913000000e-02,  1.6521739130000001e-02, \
                                    1.7391304348000000e-02,  1.8260869565000001e-02,  1.9130434783000000e-02, \
                                    2.0000000000000000e-02,  2.0869565217000001e-02,  2.1739130435000000e-02, \
                                    2.2608695652000001e-02,  2.3478260870000000e-02,  2.4347826087000000e-02, \
                                    2.5217391304000001e-02,  2.6086956522000000e-02,  2.6956521739000001e-02, \
                                    2.7826086957000000e-02,  2.8695652174000000e-02,  2.9565217391000001e-02, \
                                    3.0434782609000000e-02,  3.1304347826000001e-02,  3.2173913042999998e-02, \
                                    3.3043478261000001e-02,  3.3913043477999998e-02,  3.4782608696000000e-02, \
                                    3.5652173912999997e-02,  3.6521739130000001e-02,  3.7391304347999997e-02, \
                                    3.8260869565000001e-02,  3.9130434782999997e-02,  4.0000000000000001e-02, \
                                    4.0869565216999998e-02,  4.1739130435000001e-02,  4.2608695651999998e-02, \
                                    4.3478260870000000e-02,  4.4347826086999997e-02,  4.5217391304000001e-02, \
                                    4.6086956521999997e-02,  4.6956521739000001e-02,  4.7826086956999997e-02, \
                                    4.8695652174000001e-02,  4.9565217390999998e-02,  5.0434782609000001e-02, \
                                    5.1304347825999998e-02,  5.2173913043000002e-02,  5.3043478260999997e-02, \
                                    5.3913043478000001e-02,  5.4782608695999997e-02,  5.5652173913000001e-02, \
                                    5.6521739129999998e-02,  5.7391304348000001e-02,  5.8260869564999998e-02, \
                                    5.9130434783000001e-02,  5.9999999999999998e-02,  6.0869565217000002e-02, \
                                    6.1739130434999998e-02,  6.2608695652000002e-02,  6.3478260869999997e-02, \
                                    6.4347826087000001e-02,  6.5217391304000005e-02,  6.6086956522000001e-02, \
                                    6.6956521739000005e-02,  6.7826086957000001e-02,  6.8695652174000005e-02, \
                                    6.9565217390999995e-02,  7.0434782609000005e-02,  7.1304347825999995e-02, \
                                    7.2173913042999999e-02,  7.3043478260999994e-02,  7.3913043477999998e-02, \
                                    7.4782608695999994e-02,  7.5652173912999998e-02,  7.6521739130000002e-02, \
                                    7.7391304347999998e-02,  7.8260869565000002e-02,  7.9130434782999998e-02, \
                                    8.0000000000000002e-02,  8.0869565217000006e-02,  8.1739130435000001e-02, \
                                    8.2608695652000005e-02,  8.3478260870000001e-02,  8.4347826087000005e-02, \
                                    8.5217391303999995e-02,  8.6086956522000005e-02,  8.6956521738999995e-02, \
                                    8.7826086957000005e-02,  8.8695652173999995e-02,  8.9565217390999999e-02, \
                                    9.0434782608999995e-02,  9.1304347825999999e-02,  9.2173913043000003e-02, \
                                    9.3043478260999998e-02,  9.3913043478000002e-02,  9.4782608695999998e-02, \
                                    9.5652173913000002e-02,  9.6521739130000006e-02,  9.7391304348000002e-02, \
                                    9.8260869565000006e-02,  9.9130434783000002e-02,  1.0000000000000001e-01, \
                                    1.0086956521700000e-01,  1.0173913043500001e-01,  1.0260869565200000e-01, \
                                    1.0347826087000001e-01,  1.0434782608700000e-01,  1.0521739130400000e-01, \
                                    1.0608695652199999e-01,  1.0695652173900000e-01,  1.0782608695699999e-01, \
                                    1.0869565217400000e-01,  1.0956521739100000e-01,  1.1043478260900000e-01, \
                                    1.1130434782600000e-01,  1.1217391304300001e-01,  1.1304347826100000e-01, \
                                    1.1391304347800001e-01,  1.1478260869600000e-01,  1.1565217391300001e-01, \
                                    1.1652173913000000e-01,  1.1739130434800001e-01,  1.1826086956500000e-01, \
                                    1.1913043478300001e-01,  1.2000000000000000e-01,  1.2086956521700000e-01, \
                                    1.2173913043500000e-01,  1.2260869565200000e-01,  1.2347826087000000e-01, \
                                    1.2434782608700000e-01,  1.2521739130400000e-01,  1.2608695652200000e-01, \
                                    1.2695652173899999e-01,  1.2782608695700001e-01,  1.2869565217400000e-01, \
                                    1.2956521739099999e-01,  1.3043478260899999e-01,  1.3130434782600001e-01, \
                                    1.3217391304300000e-01,  1.3304347826099999e-01,  1.3391304347800001e-01, \
                                    1.3478260869600001e-01,  1.3565217391300000e-01,  1.3652173913000001e-01, \
                                    1.3739130434800001e-01,  1.3826086956500000e-01,  1.3913043478300000e-01, \
                                    1.4000000000000001e-01,  1.4086956521700000e-01,  1.4173913043500000e-01, \
                                    1.4260869565199999e-01,  1.4347826087000001e-01,  1.4434782608700000e-01, \
                                    1.4521739130399999e-01,  1.4608695652199999e-01,  1.4695652173900001e-01, \
                                    1.4782608695700000e-01,  1.4869565217399999e-01,  1.4956521739100001e-01, \
                                    1.5043478260900001e-01,  1.5130434782600000e-01,  1.5217391304299999e-01, \
                                    1.5304347826100001e-01,  1.5391304347800000e-01,  1.5478260869600000e-01, \
                                    1.5565217391300001e-01,  1.5652173913000000e-01,  1.5739130434800000e-01, \
                                    1.5826086956499999e-01,  1.5913043478300001e-01,  1.6000000000000000e-01, \
                                    1.6086956521699999e-01,  1.6173913043499999e-01,  1.6260869565200001e-01, \
                                    1.6347826087000000e-01,  1.6434782608699999e-01,  1.6521739130400001e-01, \
                                    1.6608695652200001e-01,  1.6695652173900000e-01,  1.6782608695699999e-01, \
                                    1.6869565217400001e-01,  1.6956521739100000e-01,  1.7043478260900000e-01, \
                                    1.7130434782599999e-01,  1.7217391304300000e-01,  1.7304347826100000e-01, \
                                    1.7391304347799999e-01,  1.7478260869600001e-01,  1.7565217391300000e-01, \
                                    1.7652173912999999e-01,  1.7739130434799999e-01,  1.7826086956500001e-01, \
                                    1.7913043478300000e-01,  1.7999999999999999e-01,  1.8086956521700001e-01, \
                                    1.8173913043500001e-01,  1.8260869565200000e-01,  1.8347826086999999e-01, \
                                    1.8434782608700001e-01,  1.8521739130400000e-01,  1.8608695652200000e-01, \
                                    1.8695652173899999e-01,  1.8782608695700001e-01,  1.8869565217400000e-01, \
                                    1.8956521739099999e-01,  1.9043478260899999e-01,  1.9130434782600000e-01, \
                                    1.9217391304299999e-01,  1.9304347826099999e-01,  1.9391304347800001e-01, \
                                    1.9478260869600000e-01,  1.9565217391299999e-01,  1.9652173913000001e-01, \
                                    1.9739130434800001e-01,  1.9826086956500000e-01,  1.9913043478299999e-01, \
                                    2.0000000000000001e-01,  2.0086956521700000e-01,  2.0173913043500000e-01, \
                                    2.0260869565199999e-01,  2.0347826087000001e-01,  2.0434782608700000e-01, \
                                    2.0521739130399999e-01,  2.0608695652199999e-01,  2.0695652173900000e-01, \
                                    2.0782608695700000e-01,  2.0869565217399999e-01,  2.0956521739100001e-01, \
                                    2.1043478260900000e-01,  2.1130434782599999e-01,  2.1217391304300001e-01, \
                                    2.1304347826100001e-01,  2.1391304347800000e-01,  2.1478260869599999e-01, \
                                    2.1565217391300001e-01,  2.1652173913000000e-01,  2.1739130434800000e-01, \
                                    2.1826086956499999e-01,  2.1913043478300001e-01,  2.2000000000000000e-01, \
                                    2.2086956521699999e-01,  2.2173913043499999e-01,  2.2260869565200000e-01, \
                                    2.2347826087000000e-01,  2.2434782608699999e-01,  2.2521739130400001e-01, \
                                    2.2608695652200000e-01,  2.2695652173899999e-01,  2.2782608695699999e-01, \
                                    2.2869565217400001e-01,  2.2956521739100000e-01,  2.3043478260899999e-01, \
                                    2.3130434782600001e-01,  2.3217391304300000e-01,  2.3304347826100000e-01, \
                                    2.3391304347799999e-01,  2.3478260869600001e-01,  2.3565217391300000e-01, \
                                    2.3652173912999999e-01,  2.3739130434799999e-01,  2.3826086956500001e-01, \
                                    2.3913043478300000e-01,  2.3999999999999999e-01,  2.4086956521700001e-01, \
                                    2.4173913043500000e-01,  2.4260869565199999e-01,  2.4347826086999999e-01, \
                                    2.4434782608700001e-01,  2.4521739130400000e-01,  2.4608695652199999e-01, \
                                    2.4695652173900001e-01,  2.4782608695700001e-01,  2.4869565217400000e-01, \
                                    2.4956521739099999e-01,  2.5043478260899998e-01,  2.5130434782599997e-01, \
                                    2.5217391304300002e-01,  2.5304347826099999e-01,  2.5391304347799998e-01, \
                                    2.5478260869600000e-01,  2.5565217391299999e-01,  2.5652173912999998e-01, \
                                    2.5739130434800001e-01,  2.5826086956500000e-01,  2.5913043478300002e-01, \
                                    2.6000000000000001e-01,  2.6086956521700000e-01,  2.6173913043500002e-01, \
                                    2.6260869565200001e-01,  2.6347826086999998e-01,  2.6434782608700003e-01, \
                                    2.6521739130400002e-01,  2.6608695652199998e-01,  2.6695652173899997e-01, \
                                    2.6782608695700000e-01,  2.6869565217399999e-01,  2.6956521739099998e-01, \
                                    2.7043478260900000e-01,  2.7130434782599999e-01,  2.7217391304299998e-01, \
                                    2.7304347826100001e-01,  2.7391304347800000e-01,  2.7478260869600002e-01, \
                                    2.7565217391300001e-01,  2.7652173913000000e-01,  2.7739130434800002e-01, \
                                    2.7826086956500001e-01,  2.7913043478299998e-01,  2.8000000000000003e-01, \
                                    2.8086956521700002e-01,  2.8173913043499998e-01,  2.8260869565199997e-01, \
                                    2.8347826087000000e-01,  2.8434782608699999e-01,  2.8521739130399998e-01, \
                                    2.8608695652200000e-01,  2.8695652173899999e-01,  2.8782608695700002e-01, \
                                    2.8869565217400001e-01,  2.8956521739100000e-01,  2.9043478260900002e-01, \
                                    2.9130434782600001e-01,  2.9217391304300000e-01,  2.9304347826100002e-01, \
                                    2.9391304347800001e-01,  2.9478260869599998e-01,  2.9565217391300003e-01, \
                                    2.9652173913000002e-01,  2.9739130434799999e-01,  2.9826086956499998e-01, \
                                    2.9913043478300000e-01,  2.9999999999999999e-01,  3.0086956521699998e-01, \
                                    3.0173913043500000e-01,  3.0260869565199999e-01,  3.0347826087000002e-01, \
                                    3.0434782608700001e-01,  3.0521739130400000e-01,  3.0608695652200002e-01, \
                                    3.0695652173900001e-01,  3.0782608695699998e-01,  3.0869565217400002e-01, \
                                    3.0956521739100001e-01,  3.1043478260899998e-01,  3.1130434782600003e-01, \
                                    3.1217391304300002e-01,  3.1304347826099999e-01,  3.1391304347799998e-01, \
                                    3.1478260869600000e-01,  3.1565217391299999e-01,  3.1652173912999998e-01, \
                                    3.1739130434800000e-01,  3.1826086956499999e-01,  3.1913043478300002e-01, \
                                    3.2000000000000001e-01,  3.2086956521700000e-01,  3.2173913043500002e-01, \
                                    3.2260869565200001e-01,  3.2347826086999998e-01,  3.2434782608700002e-01, \
                                    3.2521739130400001e-01,  3.2608695652199998e-01,  3.2695652173899997e-01, \
                                    3.2782608695700000e-01,  3.2869565217399999e-01,  3.2956521739099998e-01, \
                                    3.3043478260900000e-01,  3.3130434782599999e-01,  3.3217391304299998e-01, \
                                    3.3304347826100000e-01,  3.3391304347799999e-01,  3.3478260869600002e-01, \
                                    3.3565217391300001e-01,  3.3652173913000000e-01,  3.3739130434800002e-01, \
                                    3.3826086956500001e-01,  3.3913043478299998e-01,  3.4000000000000002e-01, \
                                    3.4086956521700001e-01,  3.4173913043499998e-01,  3.4260869565199997e-01, \
                                    3.4347826087000000e-01,  3.4434782608699999e-01,  3.4521739130399998e-01, \
                                    3.4608695652200000e-01,  3.4695652173899999e-01,  3.4782608695700001e-01, \
                                    3.4869565217400000e-01,  3.4956521739099999e-01,  3.5043478260900002e-01, \
                                    3.5130434782600001e-01,  3.5217391304300000e-01,  3.5304347826100002e-01, \
                                    3.5391304347800001e-01,  3.5478260869599998e-01,  3.5565217391300002e-01, \
                                    3.5652173913000001e-01,  3.5739130434799998e-01,  3.5826086956499997e-01, \
                                    3.5913043478300000e-01,  3.5999999999999999e-01,  3.6086956521699998e-01, \
                                    3.6173913043500000e-01,  3.6260869565199999e-01,  3.6347826087000001e-01, \
                                    3.6434782608700000e-01,  3.6521739130399999e-01,  3.6608695652200002e-01, \
                                    3.6695652173900001e-01,  3.6782608695699998e-01,  3.6869565217400002e-01, \
                                    3.6956521739100001e-01,  3.7043478260899998e-01,  3.7130434782600003e-01, \
                                    3.7217391304300002e-01,  3.7304347826099998e-01,  3.7391304347799997e-01, \
                                    3.7478260869600000e-01,  3.7565217391299999e-01,  3.7652173912999998e-01, \
                                    3.7739130434800000e-01,  3.7826086956499999e-01,  3.7913043478300001e-01, \
                                    3.8000000000000000e-01,  3.8086956521699999e-01,  3.8173913043500002e-01, \
                                    3.8260869565200001e-01,  3.8347826086999998e-01,  3.8434782608700002e-01, \
                                    3.8521739130400001e-01,  3.8608695652199998e-01,  3.8695652173900003e-01, \
                                    3.8782608695699999e-01,  3.8869565217399998e-01,  3.8956521739099997e-01, \
                                    3.9043478260900000e-01,  3.9130434782599999e-01,  3.9217391304299998e-01, \
                                    3.9304347826100000e-01,  3.9391304347799999e-01,  3.9478260869600001e-01, \
                                    3.9565217391300000e-01,  3.9652173912999999e-01,  3.9739130434800002e-01, \
                                    3.9826086956500001e-01,  3.9913043478299998e-01,  4.0000000000000002e-01, \
                                    4.0086956521700001e-01,  4.0173913043499998e-01,  4.0260869565200003e-01, \
                                    4.0347826086999999e-01,  4.0434782608699998e-01,  4.0521739130399997e-01, \
                                    4.0608695652200000e-01,  4.0695652173899999e-01,  4.0782608695700001e-01, \
                                    4.0869565217400000e-01,  4.0956521739099999e-01,  4.1043478260900002e-01, \
                                    4.1130434782600001e-01,  4.1217391304300000e-01,  4.1304347826100002e-01, \
                                    4.1391304347800001e-01,  4.1478260869599998e-01,  4.1565217391300002e-01, \
                                    4.1652173913000001e-01,  4.1739130434799998e-01,  4.1826086956500003e-01, \
                                    4.1913043478299999e-01,  4.1999999999999998e-01,  4.2086956521699997e-01, \
                                    4.2173913043500000e-01,  4.2260869565199999e-01,  4.2347826087000001e-01, \
                                    4.2434782608700000e-01,  4.2521739130399999e-01,  4.2608695652200002e-01, \
                                    4.2695652173900001e-01,  4.2782608695699997e-01,  4.2869565217400002e-01, \
                                    4.2956521739100001e-01,  4.3043478260899998e-01,  4.3130434782600002e-01, \
                                    4.3217391304300001e-01,  4.3304347826099998e-01,  4.3391304347800003e-01, \
                                    4.3478260869599999e-01,  4.3565217391299998e-01,  4.3652173912999997e-01, \
                                    4.3739130434800000e-01,  4.3826086956499999e-01,  4.3913043478300001e-01, \
                                    4.4000000000000000e-01,  4.4086956521699999e-01,  4.4173913043500002e-01, \
                                    4.4260869565200001e-01,  4.4347826086999997e-01,  4.4434782608700002e-01, \
                                    4.4521739130400001e-01,  4.4608695652199998e-01,  4.4695652173900002e-01, \
                                    4.4782608695699999e-01,  4.4869565217399998e-01,  4.4956521739100003e-01, \
                                    4.5043478260900000e-01,  4.5130434782599999e-01,  4.5217391304299998e-01, \
                                    4.5304347826100000e-01,  4.5391304347799999e-01,  4.5478260869600001e-01, \
                                    4.5565217391300000e-01,  4.5652173912999999e-01,  4.5739130434800002e-01, \
                                    4.5826086956500001e-01,  4.5913043478299997e-01,  4.6000000000000002e-01, \
                                    4.6086956521700001e-01,  4.6173913043499998e-01,  4.6260869565200002e-01, \
                                    4.6347826086999999e-01,  4.6434782608699998e-01,  4.6521739130400003e-01, \
                                    4.6608695652200000e-01,  4.6695652173899999e-01,  4.6782608695700001e-01, \
                                    4.6869565217400000e-01,  4.6956521739099999e-01,  4.7043478260900001e-01, \
                                    4.7130434782600000e-01,  4.7217391304299999e-01,  4.7304347826100002e-01, \
                                    4.7391304347800001e-01,  4.7478260869599997e-01,  4.7565217391300002e-01, \
                                    4.7652173913000001e-01,  4.7739130434799998e-01,  4.7826086956500002e-01, \
                                    4.7913043478299999e-01,  4.7999999999999998e-01,  4.8086956521699997e-01, \
                                    4.8173913043500000e-01,  4.8260869565199999e-01,  4.8347826087000001e-01, \
                                    4.8434782608700000e-01,  4.8521739130399999e-01,  4.8608695652200001e-01, \
                                    4.8695652173900000e-01,  4.8782608695700003e-01,  4.8869565217400002e-01, \
                                    4.8956521739100001e-01,  4.9043478260899998e-01,  4.9130434782600002e-01, \
                                    4.9217391304300001e-01,  4.9304347826099998e-01,  4.9391304347800002e-01, \
                                    4.9478260869599999e-01,  4.9565217391299998e-01,  4.9652173912999997e-01, \
                                    4.9739130434800000e-01,  4.9826086956499999e-01,  4.9913043478300001e-01, \
                                    5.0000000000000000e-01,  5.0086956521699999e-01,  5.0173913043499996e-01, \
                                    5.0260869565199995e-01,  5.0347826087000003e-01,  5.0434782608700002e-01, \
                                    5.0521739130400001e-01,  5.0608695652199998e-01,  5.0695652173899997e-01, \
                                    5.0782608695700004e-01,  5.0869565217400003e-01,  5.0956521739100002e-01, \
                                    5.1043478260899999e-01,  5.1130434782599998e-01,  5.1217391304299997e-01, \
                                    5.1304347826100005e-01,  5.1391304347800004e-01,  5.1478260869600001e-01, \
                                    5.1565217391300000e-01,  5.1652173912999999e-01,  5.1739130434799996e-01, \
                                    5.1826086956499995e-01,  5.1913043478300003e-01,  5.2000000000000002e-01, \
                                    5.2086956521700001e-01,  5.2173913043499998e-01,  5.2260869565199997e-01, \
                                    5.2347826087000005e-01,  5.2434782608700004e-01,  5.2521739130400003e-01, \
                                    5.2608695652199999e-01,  5.2695652173899998e-01,  5.2782608695699995e-01, \
                                    5.2869565217400005e-01,  5.2956521739100004e-01,  5.3043478260900001e-01, \
                                    5.3130434782600000e-01,  5.3217391304299999e-01,  5.3304347826099996e-01, \
                                    5.3391304347799995e-01,  5.3478260869600003e-01,  5.3565217391300002e-01, \
                                    5.3652173913000001e-01,  5.3739130434799998e-01,  5.3826086956499997e-01, \
                                    5.3913043478300005e-01,  5.4000000000000004e-01,  5.4086956521700003e-01, \
                                    5.4173913043499999e-01,  5.4260869565199998e-01,  5.4347826086999995e-01, \
                                    5.4434782608700005e-01,  5.4521739130400004e-01,  5.4608695652200001e-01, \
                                    5.4695652173900000e-01,  5.4782608695699997e-01,  5.4869565217399996e-01, \
                                    5.4956521739099995e-01,  5.5043478260900003e-01,  5.5130434782600002e-01, \
                                    5.5217391304300001e-01,  5.5304347826099998e-01,  5.5391304347799997e-01, \
                                    5.5478260869600005e-01,  5.5565217391300004e-01,  5.5652173913000003e-01, \
                                    5.5739130434799999e-01,  5.5826086956499998e-01,  5.5913043478299995e-01, \
                                    5.6000000000000005e-01,  5.6086956521700004e-01,  5.6173913043500001e-01, \
                                    5.6260869565200000e-01,  5.6347826086999997e-01,  5.6434782608699996e-01, \
                                    5.6521739130399995e-01,  5.6608695652200003e-01,  5.6695652173900002e-01, \
                                    5.6782608695699999e-01,  5.6869565217399998e-01,  5.6956521739099997e-01, \
                                    5.7043478260900005e-01,  5.7130434782600004e-01,  5.7217391304300003e-01, \
                                    5.7304347826099999e-01,  5.7391304347799998e-01,  5.7478260869599995e-01, \
                                    5.7565217391300005e-01,  5.7652173913000004e-01,  5.7739130434800001e-01, \
                                    5.7826086956500000e-01,  5.7913043478299997e-01,  5.7999999999999996e-01, \
                                    5.8086956521699995e-01,  5.8173913043500003e-01,  5.8260869565200002e-01, \
                                    5.8347826086999999e-01,  5.8434782608699998e-01,  5.8521739130399997e-01, \
                                    5.8608695652200005e-01,  5.8695652173900004e-01,  5.8782608695700000e-01, \
                                    5.8869565217399999e-01,  5.8956521739099998e-01,  5.9043478260899995e-01, \
                                    5.9130434782600005e-01,  5.9217391304300004e-01,  5.9304347826100001e-01, \
                                    5.9391304347800000e-01,  5.9478260869599997e-01,  5.9565217391299996e-01, \
                                    5.9652173912999995e-01,  5.9739130434800003e-01,  5.9826086956500002e-01, \
                                    5.9913043478299999e-01,  5.9999999999999998e-01,  6.0086956521699997e-01, \
                                    6.0173913043500005e-01,  6.0260869565200004e-01,  6.0347826087000001e-01, \
                                    6.0434782608700000e-01,  6.0521739130399999e-01,  6.0608695652199995e-01, \
                                    6.0695652173900005e-01,  6.0782608695700002e-01,  6.0869565217400001e-01, \
                                    6.0956521739100000e-01,  6.1043478260899997e-01,  6.1130434782599996e-01, \
                                    6.1217391304299995e-01,  6.1304347826100003e-01,  6.1391304347800002e-01, \
                                    6.1478260869599999e-01,  6.1565217391299998e-01,  6.1652173912999997e-01, \
                                    6.1739130434800005e-01,  6.1826086956500004e-01,  6.1913043478300001e-01, \
                                    6.2000000000000000e-01,  6.2086956521699999e-01,  6.2173913043499995e-01, \
                                    6.2260869565200005e-01,  6.2347826087000002e-01,  6.2434782608700001e-01, \
                                    6.2521739130400000e-01,  6.2608695652199997e-01,  6.2695652173899996e-01, \
                                    6.2782608695700004e-01,  6.2869565217400003e-01,  6.2956521739100002e-01, \
                                    6.3043478260899999e-01,  6.3130434782599998e-01,  6.3217391304399995e-01, \
                                    6.3304347826100005e-01,  6.3391304347800004e-01,  6.3478260869600001e-01, \
                                    6.3565217391300000e-01,  6.3652173912999999e-01,  6.3739130434799995e-01, \
                                    6.3826086956500006e-01,  6.3913043478300002e-01,  6.4000000000000001e-01, \
                                    6.4086956521700000e-01,  6.4173913043499997e-01,  6.4260869565199996e-01, \
                                    6.4347826087000004e-01,  6.4434782608700003e-01,  6.4521739130400002e-01, \
                                    6.4608695652199999e-01,  6.4695652173899998e-01,  6.4782608695699995e-01, \
                                    6.4869565217400005e-01,  6.4956521739100004e-01,  6.5043478260900001e-01, \
                                    6.5130434782600000e-01,  6.5217391304399996e-01,  6.5304347826099995e-01, \
                                    6.5391304347799994e-01,  6.5478260869600002e-01,  6.5565217391300001e-01, \
                                    6.5652173913000000e-01,  6.5739130434799997e-01,  6.5826086956499996e-01, \
                                    6.5913043478300004e-01,  6.6000000000000003e-01,  6.6086956521700002e-01, \
                                    6.6173913043499999e-01,  6.6260869565199998e-01,  6.6347826086999995e-01, \
                                    6.6434782608700005e-01,  6.6521739130400004e-01,  6.6608695652200001e-01, \
                                    6.6695652173900000e-01,  6.6782608695699996e-01,  6.6869565217399995e-01, \
                                    6.6956521739099994e-01,  6.7043478260900002e-01,  6.7130434782600001e-01, \
                                    6.7217391304399998e-01,  6.7304347826099997e-01,  6.7391304347799996e-01, \
                                    6.7478260869600004e-01,  6.7565217391300003e-01,  6.7652173913000002e-01, \
                                    6.7739130434799999e-01,  6.7826086956499998e-01,  6.7913043478299995e-01, \
                                    6.8000000000000005e-01,  6.8086956521700004e-01,  6.8173913043500001e-01, \
                                    6.8260869565200000e-01,  6.8347826086999997e-01,  6.8434782608699996e-01, \
                                    6.8521739130399995e-01,  6.8608695652200002e-01,  6.8695652173900001e-01, \
                                    6.8782608695699998e-01,  6.8869565217399997e-01,  6.8956521739099996e-01, \
                                    6.9043478260900004e-01,  6.9130434782600003e-01,  6.9217391304400000e-01, \
                                    6.9304347826099999e-01,  6.9391304347799998e-01,  6.9478260869599995e-01, \
                                    6.9565217391300005e-01,  6.9652173913000004e-01,  6.9739130434800001e-01, \
                                    6.9826086956500000e-01,  6.9913043478299997e-01,  6.9999999999999996e-01, \
                                    7.0086956521699995e-01,  7.0173913043500002e-01,  7.0260869565200001e-01, \
                                    7.0347826086999998e-01,  7.0434782608699997e-01,  7.0521739130399996e-01, \
                                    7.0608695652200004e-01,  7.0695652173900003e-01,  7.0782608695700000e-01, \
                                    7.0869565217399999e-01,  7.0956521739099998e-01,  7.1043478260899995e-01, \
                                    7.1130434782600005e-01,  7.1217391304400002e-01,  7.1304347826100001e-01, \
                                    7.1391304347800000e-01,  7.1478260869599997e-01,  7.1565217391299996e-01, \
                                    7.1652173912999995e-01,  7.1739130434800003e-01,  7.1826086956500002e-01, \
                                    7.1913043478299998e-01,  7.1999999999999997e-01,  7.2086956521699996e-01, \
                                    7.2173913043500004e-01,  7.2260869565200003e-01,  7.2347826087000000e-01, \
                                    7.2434782608699999e-01,  7.2521739130399998e-01,  7.2608695652199995e-01, \
                                    7.2695652173900005e-01,  7.2782608695700002e-01,  7.2869565217400001e-01, \
                                    7.2956521739100000e-01,  7.3043478260899997e-01,  7.3130434782599996e-01, \
                                    7.3217391304400004e-01,  7.3304347826100003e-01,  7.3391304347800002e-01, \
                                    7.3478260869599998e-01,  7.3565217391299997e-01,  7.3652173912999996e-01, \
                                    7.3739130434800004e-01,  7.3826086956500003e-01,  7.3913043478300000e-01, \
                                    7.3999999999999999e-01,  7.4086956521699998e-01,  7.4173913043499995e-01, \
                                    7.4260869565200005e-01,  7.4347826087000002e-01,  7.4434782608700001e-01, \
                                    7.4521739130400000e-01,  7.4608695652199997e-01,  7.4695652173899996e-01, \
                                    7.4782608695700004e-01,  7.4869565217400003e-01,  7.4956521739100002e-01, \
                                    7.5043478260899998e-01,  7.5130434782599997e-01,  7.5217391304400005e-01, \
                                    7.5304347826100004e-01,  7.5391304347800003e-01,  7.5478260869600000e-01, \
                                    7.5565217391299999e-01,  7.5652173912999998e-01,  7.5739130434799995e-01, \
                                    7.5826086956500005e-01,  7.5913043478300002e-01,  7.6000000000000001e-01, \
                                    7.6086956521700000e-01,  7.6173913043499997e-01,  7.6260869565199996e-01, \
                                    7.6347826087000004e-01,  7.6434782608700003e-01,  7.6521739130400002e-01, \
                                    7.6608695652199998e-01,  7.6695652173899997e-01,  7.6782608695700005e-01, \
                                    7.6869565217400004e-01,  7.6956521739100003e-01,  7.7043478260900000e-01, \
                                    7.7130434782599999e-01,  7.7217391304399996e-01,  7.7304347826099995e-01, \
                                    7.7391304347800005e-01,  7.7478260869600002e-01,  7.7565217391300001e-01, \
                                    7.7652173913000000e-01,  7.7739130434799997e-01,  7.7826086956499996e-01, \
                                    7.7913043478300004e-01,  7.8000000000000003e-01,  7.8086956521700002e-01, \
                                    7.8173913043499998e-01,  7.8260869565199997e-01,  7.8347826087000005e-01, \
                                    7.8434782608700004e-01,  7.8521739130400003e-01,  7.8608695652200000e-01, \
                                    7.8695652173899999e-01,  7.8782608695699996e-01,  7.8869565217399995e-01, \
                                    7.8956521739100005e-01,  7.9043478260900002e-01,  7.9130434782600001e-01, \
                                    7.9217391304399998e-01,  7.9304347826099997e-01,  7.9391304347799996e-01, \
                                    7.9478260869600004e-01,  7.9565217391300003e-01,  7.9652173913000002e-01, \
                                    7.9739130434799999e-01,  7.9826086956499998e-01,  7.9913043478300005e-01, \
                                    8.0000000000000004e-01,  8.0086956521700003e-01,  8.0173913043500000e-01, \
                                    8.0260869565199999e-01,  8.0347826086999996e-01,  8.0434782608699995e-01, \
                                    8.0521739130400005e-01,  8.0608695652200002e-01,  8.0695652173900001e-01, \
                                    8.0782608695699998e-01,  8.0869565217399997e-01,  8.0956521739099996e-01, \
                                    8.1043478260900004e-01,  8.1130434782600003e-01,  8.1217391304400000e-01, \
                                    8.1304347826099999e-01,  8.1391304347799998e-01,  8.1478260869600005e-01, \
                                    8.1565217391300004e-01,  8.1652173913000003e-01,  8.1739130434800000e-01, \
                                    8.1826086956499999e-01,  8.1913043478299996e-01,  8.1999999999999995e-01, \
                                    8.2086956521700005e-01,  8.2173913043500002e-01,  8.2260869565200001e-01, \
                                    8.2347826086999998e-01,  8.2434782608699997e-01,  8.2521739130399996e-01, \
                                    8.2608695652200004e-01,  8.2695652173900003e-01,  8.2782608695700000e-01, \
                                    8.2869565217399999e-01,  8.2956521739099998e-01,  8.3043478260900006e-01, \
                                    8.3130434782600005e-01,  8.3217391304400001e-01,  8.3304347826100000e-01, \
                                    8.3391304347799999e-01,  8.3478260869599996e-01,  8.3565217391299995e-01, \
                                    8.3652173913000005e-01,  8.3739130434800002e-01,  8.3826086956500001e-01, \
                                    8.3913043478299998e-01,  8.3999999999999997e-01,  8.4086956521699996e-01, \
                                    8.4173913043500004e-01,  8.4260869565200003e-01,  8.4347826087000000e-01, \
                                    8.4434782608699999e-01,  8.4521739130399998e-01,  8.4608695652200006e-01, \
                                    8.4695652173900005e-01,  8.4782608695700001e-01,  8.4869565217400000e-01, \
                                    8.4956521739099999e-01,  8.5043478260899996e-01,  8.5130434782599995e-01, \
                                    8.5217391304400003e-01,  8.5304347826100002e-01,  8.5391304347800001e-01, \
                                    8.5478260869599998e-01,  8.5565217391299997e-01,  8.5652173912999996e-01, \
                                    8.5739130434800004e-01,  8.5826086956500003e-01,  8.5913043478300000e-01, \
                                    8.5999999999999999e-01,  8.6086956521699998e-01,  8.6173913043499994e-01, \
                                    8.6260869565200005e-01,  8.6347826087000001e-01,  8.6434782608700000e-01, \
                                    8.6521739130399999e-01,  8.6608695652199996e-01,  8.6695652173899995e-01, \
                                    8.6782608695700003e-01,  8.6869565217400002e-01,  8.6956521739100001e-01, \
                                    8.7043478260899998e-01,  8.7130434782599997e-01,  8.7217391304400005e-01, \
                                    8.7304347826100004e-01,  8.7391304347800003e-01,  8.7478260869600000e-01, \
                                    8.7565217391299999e-01,  8.7652173912999998e-01,  8.7739130434799995e-01, \
                                    8.7826086956500005e-01,  8.7913043478300001e-01,  8.8000000000000000e-01, \
                                    8.8086956521699999e-01,  8.8173913043499996e-01,  8.8260869565199995e-01, \
                                    8.8347826087000003e-01,  8.8434782608700002e-01,  8.8521739130400001e-01, \
                                    8.8608695652199998e-01,  8.8695652173899997e-01,  8.8782608695700005e-01, \
                                    8.8869565217400004e-01,  8.8956521739100003e-01,  8.9043478260900000e-01, \
                                    8.9130434782599999e-01,  8.9217391304399996e-01,  8.9304347826099995e-01, \
                                    8.9391304347800005e-01,  8.9478260869600001e-01,  8.9565217391300000e-01, \
                                    8.9652173912999999e-01,  8.9739130434799996e-01,  8.9826086956499995e-01, \
                                    8.9913043478300003e-01,  9.0000000000000002e-01,  9.0086956521700001e-01, \
                                    9.0173913043499998e-01,  9.0260869565199997e-01,  9.0347826087000005e-01, \
                                    9.0434782608700004e-01,  9.0521739130400003e-01,  9.0608695652200000e-01, \
                                    9.0695652173899999e-01,  9.0782608695699996e-01,  9.0869565217399995e-01, \
                                    9.0956521739100005e-01,  9.1043478260900002e-01,  9.1130434782600001e-01, \
                                    9.1217391304399997e-01,  9.1304347826099996e-01,  9.1391304347799995e-01, \
                                    9.1478260869600003e-01,  9.1565217391300002e-01,  9.1652173913000001e-01, \
                                    9.1739130434799998e-01,  9.1826086956499997e-01,  9.1913043478300005e-01, \
                                    9.2000000000000004e-01,  9.2086956521700003e-01,  9.2173913043500000e-01, \
                                    9.2260869565199999e-01,  9.2347826086999996e-01,  9.2434782608699995e-01, \
                                    9.2521739130400005e-01,  9.2608695652200002e-01,  9.2695652173900001e-01, \
                                    9.2782608695699997e-01,  9.2869565217399996e-01,  9.2956521739099995e-01, \
                                    9.3043478260900003e-01,  9.3130434782600002e-01,  9.3217391304399999e-01, \
                                    9.3304347826099998e-01,  9.3391304347799997e-01,  9.3478260869600005e-01, \
                                    9.3565217391300004e-01,  9.3652173913000003e-01,  9.3739130434800000e-01, \
                                    9.3826086956499999e-01,  9.3913043478299996e-01,  9.3999999999999995e-01, \
                                    9.4086956521700005e-01,  9.4173913043500002e-01,  9.4260869565200001e-01, \
                                    9.4347826086999997e-01,  9.4434782608699996e-01,  9.4521739130399995e-01, \
                                    9.4608695652200003e-01,  9.4695652173900002e-01,  9.4782608695699999e-01, \
                                    9.4869565217399998e-01,  9.4956521739099997e-01,  9.5043478260900005e-01, \
                                    9.5130434782600004e-01,  9.5217391304400001e-01,  9.5304347826100000e-01, \
                                    9.5391304347799999e-01,  9.5478260869599996e-01,  9.5565217391299995e-01, \
                                    9.5652173913000005e-01,  9.5739130434800002e-01,  9.5826086956500001e-01, \
                                    9.5913043478299997e-01,  9.5999999999999996e-01,  9.6086956521699995e-01, \
                                    9.6173913043500003e-01,  9.6260869565200002e-01,  9.6347826086999999e-01, \
                                    9.6434782608699998e-01,  9.6521739130399997e-01,  9.6608695652200005e-01, \
                                    9.6695652173900004e-01,  9.6782608695700001e-01,  9.6869565217400000e-01, \
                                    9.6956521739099999e-01,  9.7043478260899996e-01,  9.7130434782599995e-01, \
                                    9.7217391304400003e-01,  9.7304347826100002e-01,  9.7391304347800001e-01, \
                                    9.7478260869599997e-01,  9.7565217391299996e-01,  9.7652173912999995e-01, \
                                    9.7739130434800003e-01,  9.7826086956500002e-01,  9.7913043478299999e-01, \
                                    9.7999999999999998e-01,  9.8086956521699997e-01,  9.8173913043500005e-01, \
                                    9.8260869565200004e-01,  9.8347826087000001e-01,  9.8434782608700000e-01, \
                                    9.8521739130399999e-01,  9.8608695652199996e-01,  9.8695652173899995e-01, \
                                    9.8782608695700003e-01,  9.8869565217400002e-01,  9.8956521739100001e-01, \
                                    9.9043478260899998e-01,  9.9130434782599997e-01,  9.9217391304400004e-01, \
                                    9.9304347826100003e-01,  9.9391304347800002e-01,  9.9478260869599999e-01, \
                                    9.9565217391299998e-01,  9.9652173912999997e-01,  9.9739130434800005e-01, \
                                    9.9826086956500004e-01,  9.9913043478300001e-01,  1.0000000000000000e+00, \
                                    -1.0000000000000000e+00, -9.9923076923099996e-01, -9.9846153846200003e-01, \
                                    -9.9769230769200001e-01, -9.9692307692299997e-01, -9.9615384615400004e-01, \
                                    -9.9538461538500000e-01, -9.9461538461499999e-01, -9.9384615384599995e-01, \
                                    -9.9307692307700002e-01, -9.9230769230799998e-01, -9.9153846153799996e-01, \
                                    -9.9076923076900003e-01, -9.8999999999999999e-01, -9.8923076923099995e-01, \
                                    -9.8846153846200002e-01, -9.8769230769200000e-01, -9.8692307692299996e-01, \
                                    -9.8615384615400004e-01, -9.8538461538500000e-01, -9.8461538461499998e-01, \
                                    -9.8384615384600005e-01, -9.8307692307700001e-01, -9.8230769230799997e-01, \
                                    -9.8153846153799995e-01, -9.8076923076900002e-01, -9.7999999999999998e-01, \
                                    -9.7923076923100005e-01, -9.7846153846200001e-01, -9.7769230769200000e-01, \
                                    -9.7692307692299996e-01, -9.7615384615400003e-01, -9.7538461538499999e-01, \
                                    -9.7461538461499997e-01, -9.7384615384600004e-01, -9.7307692307700000e-01, \
                                    -9.7230769230799996e-01, -9.7153846153800005e-01, -9.7076923076900001e-01, \
                                    -9.6999999999999997e-01, -9.6923076923100004e-01, -9.6846153846200000e-01, \
                                    -9.6769230769199999e-01, -9.6692307692299995e-01, -9.6615384615400002e-01, \
                                    -9.6538461538499998e-01, -9.6461538461499996e-01, -9.6384615384600003e-01, \
                                    -9.6307692307699999e-01, -9.6230769230799995e-01, -9.6153846153800004e-01, \
                                    -9.6076923076900000e-01, -9.5999999999999996e-01, -9.5923076923100004e-01, \
                                    -9.5846153846200000e-01, -9.5769230769199998e-01, -9.5692307692300005e-01, \
                                    -9.5615384615400001e-01, -9.5538461538499997e-01, -9.5461538461499995e-01, \
                                    -9.5384615384600002e-01, -9.5307692307699998e-01, -9.5230769230800005e-01, \
                                    -9.5153846153800004e-01, -9.5076923076900000e-01, -9.4999999999999996e-01, \
                                    -9.4923076923100003e-01, -9.4846153846199999e-01, -9.4769230769199997e-01, \
                                    -9.4692307692300004e-01, -9.4615384615400000e-01, -9.4538461538499996e-01, \
                                    -9.4461538461500005e-01, -9.4384615384600001e-01, -9.4307692307699997e-01, \
                                    -9.4230769230800004e-01, -9.4153846153800003e-01, -9.4076923076899999e-01, \
                                    -9.3999999999999995e-01, -9.3923076923100002e-01, -9.3846153846199998e-01, \
                                    -9.3769230769199996e-01, -9.3692307692300003e-01, -9.3615384615399999e-01, \
                                    -9.3538461538499995e-01, -9.3461538461500004e-01, -9.3384615384600000e-01, \
                                    -9.3307692307699996e-01, -9.3230769230800004e-01, -9.3153846153800002e-01, \
                                    -9.3076923076899998e-01, -9.3000000000000005e-01, -9.2923076923100001e-01, \
                                    -9.2846153846199997e-01, -9.2769230769199995e-01, -9.2692307692300002e-01, \
                                    -9.2615384615399998e-01, -9.2538461538500005e-01, -9.2461538461500004e-01, \
                                    -9.2384615384600000e-01, -9.2307692307699996e-01, -9.2230769230800003e-01, \
                                    -9.2153846153800001e-01, -9.2076923076899997e-01, -9.2000000000000004e-01, \
                                    -9.1923076923100000e-01, -9.1846153846199996e-01, -9.1769230769200005e-01, \
                                    -9.1692307692300001e-01, -9.1615384615399997e-01, -9.1538461538500004e-01, \
                                    -9.1461538461500003e-01, -9.1384615384599999e-01, -9.1307692307699995e-01, \
                                    -9.1230769230800002e-01, -9.1153846153800000e-01, -9.1076923076899996e-01, \
                                    -9.1000000000000003e-01, -9.0923076923099999e-01, -9.0846153846199995e-01, \
                                    -9.0769230769200004e-01, -9.0692307692300000e-01, -9.0615384615399996e-01, \
                                    -9.0538461538500004e-01, -9.0461538461500002e-01, -9.0384615384599998e-01, \
                                    -9.0307692307700005e-01, -9.0230769230800001e-01, -9.0153846153799999e-01, \
                                    -9.0076923076899995e-01, -9.0000000000000002e-01, -8.9923076923099998e-01, \
                                    -8.9846153846200005e-01, -8.9769230769200004e-01, -8.9692307692300000e-01, \
                                    -8.9615384615399996e-01, -8.9538461538500003e-01, -8.9461538461500001e-01, \
                                    -8.9384615384599997e-01, -8.9307692307700004e-01, -8.9230769230800000e-01, \
                                    -8.9153846153799998e-01, -8.9076923076900005e-01, -8.9000000000000001e-01, \
                                    -8.8923076923099997e-01, -8.8846153846200004e-01, -8.8769230769200003e-01, \
                                    -8.8692307692299999e-01, -8.8615384615399995e-01, -8.8538461538500002e-01, \
                                    -8.8461538461500000e-01, -8.8384615384599996e-01, -8.8307692307700003e-01, \
                                    -8.8230769230799999e-01, -8.8153846153799997e-01, -8.8076923076900004e-01, \
                                    -8.8000000000000000e-01, -8.7923076923099996e-01, -8.7846153846200004e-01, \
                                    -8.7769230769200002e-01, -8.7692307692299998e-01, -8.7615384615400005e-01, \
                                    -8.7538461538500001e-01, -8.7461538461499999e-01, -8.7384615384599995e-01, \
                                    -8.7307692307700002e-01, -8.7230769230799998e-01, -8.7153846153799996e-01, \
                                    -8.7076923076900004e-01, -8.7000000000000000e-01, -8.6923076923099996e-01, \
                                    -8.6846153846200003e-01, -8.6769230769200001e-01, -8.6692307692299997e-01, \
                                    -8.6615384615400004e-01, -8.6538461538500000e-01, -8.6461538461499998e-01, \
                                    -8.6384615384600005e-01, -8.6307692307700001e-01, -8.6230769230799997e-01, \
                                    -8.6153846153799996e-01, -8.6076923076900003e-01, -8.5999999999999999e-01, \
                                    -8.5923076923099995e-01, -8.5846153846200002e-01, -8.5769230769200000e-01, \
                                    -8.5692307692299996e-01, -8.5615384615400003e-01, -8.5538461538499999e-01, \
                                    -8.5461538461499997e-01, -8.5384615384600004e-01, -8.5307692307700000e-01, \
                                    -8.5230769230799996e-01, -8.5153846153799995e-01, -8.5076923076900002e-01, \
                                    -8.4999999999999998e-01, -8.4923076923100005e-01, -8.4846153846200001e-01, \
                                    -8.4769230769199999e-01, -8.4692307692299995e-01, -8.4615384615400002e-01, \
                                    -8.4538461538499998e-01, -8.4461538461499996e-01, -8.4384615384600004e-01, \
                                    -8.4307692307700000e-01, -8.4230769230799996e-01, -8.4153846153800005e-01, \
                                    -8.4076923076900001e-01, -8.3999999999999997e-01, -8.3923076923100004e-01, \
                                    -8.3846153846200000e-01, -8.3769230769199998e-01, -8.3692307692300005e-01, \
                                    -8.3615384615400001e-01, -8.3538461538499997e-01, -8.3461538461499996e-01, \
                                    -8.3384615384600003e-01, -8.3307692307699999e-01, -8.3230769230799995e-01, \
                                    -8.3153846153800004e-01, -8.3076923076900000e-01, -8.2999999999999996e-01, \
                                    -8.2923076923100003e-01, -8.2846153846199999e-01, -8.2769230769199997e-01, \
                                    -8.2692307692300004e-01, -8.2615384615400000e-01, -8.2538461538499996e-01, \
                                    -8.2461538461499995e-01, -8.2384615384600002e-01, -8.2307692307699998e-01, \
                                    -8.2230769230800005e-01, -8.2153846153800003e-01, -8.2076923076899999e-01, \
                                    -8.1999999999999995e-01, -8.1923076923100002e-01, -8.1846153846199998e-01, \
                                    -8.1769230769199996e-01, -8.1692307692300004e-01, -8.1615384615400000e-01, \
                                    -8.1538461538499996e-01, -8.1461538461500005e-01, -8.1384615384600001e-01, \
                                    -8.1307692307699997e-01, -8.1230769230800004e-01, -8.1153846153800002e-01, \
                                    -8.1076923076899998e-01, -8.1000000000000005e-01, -8.0923076923100001e-01, \
                                    -8.0846153846199997e-01, -8.0769230769199996e-01, -8.0692307692300003e-01, \
                                    -8.0615384615399999e-01, -8.0538461538499995e-01, -8.0461538461500004e-01, \
                                    -8.0384615384600000e-01, -8.0307692307699996e-01, -8.0230769230800003e-01, \
                                    -8.0153846153800001e-01, -8.0076923076899997e-01, -8.0000000000000004e-01, \
                                    -7.9923076923100000e-01, -7.9846153846199996e-01, -7.9769230769199995e-01, \
                                    -7.9692307692300002e-01, -7.9615384615399998e-01, -7.9538461538500005e-01, \
                                    -7.9461538461500003e-01, -7.9384615384599999e-01, -7.9307692307699995e-01, \
                                    -7.9230769230800002e-01, -7.9153846153800000e-01, -7.9076923076899996e-01, \
                                    -7.9000000000000004e-01, -7.8923076923100000e-01, -7.8846153846199996e-01, \
                                    -7.8769230769200005e-01, -7.8692307692300001e-01, -7.8615384615399997e-01, \
                                    -7.8538461538500004e-01, -7.8461538461500002e-01, -7.8384615384599998e-01, \
                                    -7.8307692307700005e-01, -7.8230769230800001e-01, -7.8153846153800000e-01, \
                                    -7.8076923076899996e-01, -7.8000000000000003e-01, -7.7923076923099999e-01, \
                                    -7.7846153846199995e-01, -7.7769230769200004e-01, -7.7692307692300000e-01, \
                                    -7.7615384615399996e-01, -7.7538461538500003e-01, -7.7461538461500001e-01, \
                                    -7.7384615384599997e-01, -7.7307692307700004e-01, -7.7230769230800000e-01, \
                                    -7.7153846153799999e-01, -7.7076923076899995e-01, -7.7000000000000002e-01, \
                                    -7.6923076923099998e-01, -7.6846153846200005e-01, -7.6769230769200003e-01, \
                                    -7.6692307692299999e-01, -7.6615384615399995e-01, -7.6538461538500002e-01, \
                                    -7.6461538461500000e-01, -7.6384615384599996e-01, -7.6307692307700004e-01, \
                                    -7.6230769230800000e-01, -7.6153846153799998e-01, -7.6076923076900005e-01, \
                                    -7.6000000000000001e-01, -7.5923076923099997e-01, -7.5846153846200004e-01, \
                                    -7.5769230769200002e-01, -7.5692307692299998e-01, -7.5615384615400005e-01, \
                                    -7.5538461538500001e-01, -7.5461538461500000e-01, -7.5384615384599996e-01, \
                                    -7.5307692307700003e-01, -7.5230769230799999e-01, -7.5153846153799997e-01, \
                                    -7.5076923076900004e-01, -7.5000000000000000e-01, -7.4923076923099996e-01, \
                                    -7.4846153846200003e-01, -7.4769230769200001e-01, -7.4692307692299997e-01, \
                                    -7.4615384615400004e-01, -7.4538461538500000e-01, -7.4461538461499999e-01, \
                                    -7.4384615384599995e-01, -7.4307692307700002e-01, -7.4230769230799998e-01, \
                                    -7.4153846153799996e-01, -7.4076923076900003e-01, -7.3999999999999999e-01, \
                                    -7.3923076923099995e-01, -7.3846153846200002e-01, -7.3769230769200000e-01, \
                                    -7.3692307692299996e-01, -7.3615384615400004e-01, -7.3538461538500000e-01, \
                                    -7.3461538461499998e-01, -7.3384615384600005e-01, -7.3307692307700001e-01, \
                                    -7.3230769230799997e-01, -7.3153846153799995e-01, -7.3076923076900002e-01, \
                                    -7.2999999999999998e-01, -7.2923076923100005e-01, -7.2846153846200001e-01, \
                                    -7.2769230769200000e-01, -7.2692307692299996e-01, -7.2615384615400003e-01, \
                                    -7.2538461538499999e-01, -7.2461538461499997e-01, -7.2384615384600004e-01, \
                                    -7.2307692307700000e-01, -7.2230769230799996e-01, -7.2153846153800005e-01, \
                                    -7.2076923076900001e-01, -7.1999999999999997e-01, -7.1923076923100004e-01, \
                                    -7.1846153846200000e-01, -7.1769230769199999e-01, -7.1692307692299995e-01, \
                                    -7.1615384615400002e-01, -7.1538461538499998e-01, -7.1461538461499996e-01, \
                                    -7.1384615384600003e-01, -7.1307692307699999e-01, -7.1230769230799995e-01, \
                                    -7.1153846153800004e-01, -7.1076923076900000e-01, -7.0999999999999996e-01, \
                                    -7.0923076923100004e-01, -7.0846153846200000e-01, -7.0769230769199998e-01, \
                                    -7.0692307692300005e-01, -7.0615384615400001e-01, -7.0538461538499997e-01, \
                                    -7.0461538461499995e-01, -7.0384615384600002e-01, -7.0307692307699998e-01, \
                                    -7.0230769230800005e-01, -7.0153846153800004e-01, -7.0076923076900000e-01, \
                                    -6.9999999999999996e-01, -6.9923076923100003e-01, -6.9846153846199999e-01, \
                                    -6.9769230769199997e-01, -6.9692307692300004e-01, -6.9615384615400000e-01, \
                                    -6.9538461538499996e-01, -6.9461538461500005e-01, -6.9384615384600001e-01, \
                                    -6.9307692307699997e-01, -6.9230769230800004e-01, -6.9153846153800003e-01, \
                                    -6.9076923076899999e-01, -6.8999999999999995e-01, -6.8923076923100002e-01, \
                                    -6.8846153846199998e-01, -6.8769230769199996e-01, -6.8692307692300003e-01, \
                                    -6.8615384615399999e-01, -6.8538461538499995e-01, -6.8461538461500004e-01, \
                                    -6.8384615384600000e-01, -6.8307692307699996e-01, -6.8230769230800004e-01, \
                                    -6.8153846153800002e-01, -6.8076923076899998e-01, -6.8000000000000005e-01, \
                                    -6.7923076923100001e-01, -6.7846153846199997e-01, -6.7769230769199995e-01, \
                                    -6.7692307692300002e-01, -6.7615384615399998e-01, -6.7538461538500005e-01, \
                                    -6.7461538461500004e-01, -6.7384615384600000e-01, -6.7307692307699996e-01, \
                                    -6.7230769230800003e-01, -6.7153846153800001e-01, -6.7076923076899997e-01, \
                                    -6.7000000000000004e-01, -6.6923076923100000e-01, -6.6846153846199996e-01, \
                                    -6.6769230769200005e-01, -6.6692307692300001e-01, -6.6615384615399997e-01, \
                                    -6.6538461538500004e-01, -6.6461538461500003e-01, -6.6384615384599999e-01, \
                                    -6.6307692307699995e-01, -6.6230769230800002e-01, -6.6153846153800000e-01, \
                                    -6.6076923076899996e-01, -6.6000000000000003e-01, -6.5923076923099999e-01, \
                                    -6.5846153846199995e-01, -6.5769230769200004e-01, -6.5692307692300000e-01, \
                                    -6.5615384615399996e-01, -6.5538461538500004e-01, -6.5461538461500002e-01, \
                                    -6.5384615384599998e-01, -6.5307692307700005e-01, -6.5230769230800001e-01, \
                                    -6.5153846153799999e-01, -6.5076923076899995e-01, -6.5000000000000002e-01, \
                                    -6.4923076923099998e-01, -6.4846153846200005e-01, -6.4769230769200004e-01, \
                                    -6.4692307692300000e-01, -6.4615384615399996e-01, -6.4538461538500003e-01, \
                                    -6.4461538461500001e-01, -6.4384615384599997e-01, -6.4307692307700004e-01, \
                                    -6.4230769230800000e-01, -6.4153846153799998e-01, -6.4076923076900005e-01, \
                                    -6.4000000000000001e-01, -6.3923076923099997e-01, -6.3846153846200004e-01, \
                                    -6.3769230769200003e-01, -6.3692307692299999e-01, -6.3615384615399995e-01, \
                                    -6.3538461538500002e-01, -6.3461538461500000e-01, -6.3384615384599996e-01, \
                                    -6.3307692307700003e-01, -6.3230769230799999e-01, -6.3153846153799997e-01, \
                                    -6.3076923076900004e-01, -6.3000000000000000e-01, -6.2923076923099996e-01, \
                                    -6.2846153846200004e-01, -6.2769230769200002e-01, -6.2692307692299998e-01, \
                                    -6.2615384615400005e-01, -6.2538461538500001e-01, -6.2461538461499999e-01, \
                                    -6.2384615384599995e-01, -6.2307692307700002e-01, -6.2230769230799998e-01, \
                                    -6.2153846153799996e-01, -6.2076923076900004e-01, -6.2000000000000000e-01, \
                                    -6.1923076923099996e-01, -6.1846153846200003e-01, -6.1769230769200001e-01, \
                                    -6.1692307692299997e-01, -6.1615384615400004e-01, -6.1538461538500000e-01, \
                                    -6.1461538461499998e-01, -6.1384615384600005e-01, -6.1307692307700001e-01, \
                                    -6.1230769230799997e-01, -6.1153846153799996e-01, -6.1076923076900003e-01, \
                                    -6.0999999999999999e-01, -6.0923076923099995e-01, -6.0846153846200002e-01, \
                                    -6.0769230769200000e-01, -6.0692307692299996e-01, -6.0615384615400003e-01, \
                                    -6.0538461538499999e-01, -6.0461538461499997e-01, -6.0384615384600004e-01, \
                                    -6.0307692307700000e-01, -6.0230769230799996e-01, -6.0153846153799995e-01, \
                                    -6.0076923076900002e-01, -5.9999999999999998e-01, -5.9923076923100005e-01, \
                                    -5.9846153846200001e-01, -5.9769230769199999e-01, -5.9692307692299995e-01, \
                                    -5.9615384615400002e-01, -5.9538461538499998e-01, -5.9461538461499996e-01, \
                                    -5.9384615384600004e-01, -5.9307692307700000e-01, -5.9230769230799996e-01, \
                                    -5.9153846153800005e-01, -5.9076923076900001e-01, -5.8999999999999997e-01, \
                                    -5.8923076923100004e-01, -5.8846153846200000e-01, -5.8769230769199998e-01, \
                                    -5.8692307692300005e-01, -5.8615384615400001e-01, -5.8538461538499997e-01, \
                                    -5.8461538461499996e-01, -5.8384615384600003e-01, -5.8307692307699999e-01, \
                                    -5.8230769230799995e-01, -5.8153846153800004e-01, -5.8076923076900000e-01, \
                                    -5.7999999999999996e-01, -5.7923076923100003e-01, -5.7846153846199999e-01, \
                                    -5.7769230769199997e-01, -5.7692307692300004e-01, -5.7615384615400000e-01, \
                                    -5.7538461538499996e-01, -5.7461538461499995e-01, -5.7384615384600002e-01, \
                                    -5.7307692307699998e-01, -5.7230769230800005e-01, -5.7153846153800003e-01, \
                                    -5.7076923076899999e-01, -5.6999999999999995e-01, -5.6923076923100002e-01, \
                                    -5.6846153846199998e-01, -5.6769230769199996e-01, -5.6692307692300004e-01, \
                                    -5.6615384615400000e-01, -5.6538461538499996e-01, -5.6461538461500005e-01, \
                                    -5.6384615384600001e-01, -5.6307692307699997e-01, -5.6230769230800004e-01, \
                                    -5.6153846153800002e-01, -5.6076923076899998e-01, -5.6000000000000005e-01, \
                                    -5.5923076923100001e-01, -5.5846153846199997e-01, -5.5769230769199996e-01, \
                                    -5.5692307692300003e-01, -5.5615384615399999e-01, -5.5538461538499995e-01, \
                                    -5.5461538461500004e-01, -5.5384615384600000e-01, -5.5307692307699996e-01, \
                                    -5.5230769230800003e-01, -5.5153846153800001e-01, -5.5076923076899997e-01, \
                                    -5.5000000000000004e-01, -5.4923076923100000e-01, -5.4846153846199996e-01, \
                                    -5.4769230769199995e-01, -5.4692307692300002e-01, -5.4615384615399998e-01, \
                                    -5.4538461538500005e-01, -5.4461538461500003e-01, -5.4384615384599999e-01, \
                                    -5.4307692307699995e-01, -5.4230769230800002e-01, -5.4153846153800000e-01, \
                                    -5.4076923076899996e-01, -5.4000000000000004e-01, -5.3923076923100000e-01, \
                                    -5.3846153846199996e-01, -5.3769230769200005e-01, -5.3692307692300001e-01, \
                                    -5.3615384615399997e-01, -5.3538461538500004e-01, -5.3461538461500002e-01, \
                                    -5.3384615384599998e-01, -5.3307692307700005e-01, -5.3230769230800001e-01, \
                                    -5.3153846153800000e-01, -5.3076923076899996e-01, -5.3000000000000003e-01, \
                                    -5.2923076923099999e-01, -5.2846153846199995e-01, -5.2769230769200004e-01, \
                                    -5.2692307692300000e-01, -5.2615384615399996e-01, -5.2538461538500003e-01, \
                                    -5.2461538461500001e-01, -5.2384615384599997e-01, -5.2307692307700004e-01, \
                                    -5.2230769230800000e-01, -5.2153846153799999e-01, -5.2076923076899995e-01, \
                                    -5.2000000000000002e-01, -5.1923076923099998e-01, -5.1846153846200005e-01, \
                                    -5.1769230769200003e-01, -5.1692307692299999e-01, -5.1615384615399995e-01, \
                                    -5.1538461538500002e-01, -5.1461538461500000e-01, -5.1384615384599996e-01, \
                                    -5.1307692307700004e-01, -5.1230769230800000e-01, -5.1153846153799998e-01, \
                                    -5.1076923076900005e-01, -5.1000000000000001e-01, -5.0923076923099997e-01, \
                                    -5.0846153846200004e-01, -5.0769230769200002e-01, -5.0692307692299998e-01, \
                                    -5.0615384615400005e-01, -5.0538461538500001e-01, -5.0461538461500000e-01, \
                                    -5.0384615384599996e-01, -5.0307692307700003e-01, -5.0230769230799999e-01, \
                                    -5.0153846153799997e-01, -5.0076923076900004e-01, -5.0000000000000000e-01, \
                                    -4.9923076923100002e-01, -4.9846153846199998e-01, -4.9769230769200001e-01, \
                                    -4.9692307692299997e-01, -4.9615384615399999e-01, -4.9538461538500000e-01, \
                                    -4.9461538461499999e-01, -4.9384615384600000e-01, -4.9307692307700002e-01, \
                                    -4.9230769230799998e-01, -4.9153846153800002e-01, -4.9076923076899998e-01, \
                                    -4.8999999999999999e-01, -4.8923076923100001e-01, -4.8846153846200002e-01, \
                                    -4.8769230769200000e-01, -4.8692307692300002e-01, -4.8615384615399998e-01, \
                                    -4.8538461538500000e-01, -4.8461538461499998e-01, -4.8384615384599999e-01, \
                                    -4.8307692307700001e-01, -4.8230769230800002e-01, -4.8153846153800001e-01, \
                                    -4.8076923076900002e-01, -4.7999999999999998e-01, -4.7923076923100000e-01, \
                                    -4.7846153846200001e-01, -4.7769230769200000e-01, -4.7692307692300001e-01, \
                                    -4.7615384615400003e-01, -4.7538461538499999e-01, -4.7461538461500002e-01, \
                                    -4.7384615384599998e-01, -4.7307692307700000e-01, -4.7230769230800002e-01, \
                                    -4.7153846153800000e-01, -4.7076923076900001e-01, -4.6999999999999997e-01, \
                                    -4.6923076923099999e-01, -4.6846153846200000e-01, -4.6769230769199999e-01, \
                                    -4.6692307692300000e-01, -4.6615384615400002e-01, -4.6538461538499998e-01, \
                                    -4.6461538461500002e-01, -4.6384615384599998e-01, -4.6307692307699999e-01, \
                                    -4.6230769230800001e-01, -4.6153846153799999e-01, -4.6076923076900000e-01, \
                                    -4.6000000000000002e-01, -4.5923076923099998e-01, -4.5846153846200000e-01, \
                                    -4.5769230769199998e-01, -4.5692307692299999e-01, -4.5615384615400001e-01, \
                                    -4.5538461538500002e-01, -4.5461538461500001e-01, -4.5384615384600002e-01, \
                                    -4.5307692307699998e-01, -4.5230769230800000e-01, -4.5153846153799998e-01, \
                                    -4.5076923076900000e-01, -4.5000000000000001e-01, -4.4923076923100003e-01, \
                                    -4.4846153846199999e-01, -4.4769230769200002e-01, -4.4692307692299998e-01, \
                                    -4.4615384615400000e-01, -4.4538461538500002e-01, -4.4461538461500000e-01, \
                                    -4.4384615384600001e-01, -4.4307692307699997e-01, -4.4230769230799999e-01, \
                                    -4.4153846153800003e-01, -4.4076923076899999e-01, -4.4000000000000000e-01, \
                                    -4.3923076923100002e-01, -4.3846153846199998e-01, -4.3769230769200002e-01, \
                                    -4.3692307692299998e-01, -4.3615384615399999e-01, -4.3538461538500001e-01, \
                                    -4.3461538461499999e-01, -4.3384615384600000e-01, -4.3307692307700002e-01, \
                                    -4.3230769230799998e-01, -4.3153846153800002e-01, -4.3076923076899998e-01, \
                                    -4.2999999999999999e-01, -4.2923076923100001e-01, -4.2846153846200002e-01, \
                                    -4.2769230769200001e-01, -4.2692307692300002e-01, -4.2615384615399998e-01, \
                                    -4.2538461538500000e-01, -4.2461538461499998e-01, -4.2384615384600000e-01, \
                                    -4.2307692307700001e-01, -4.2230769230800003e-01, -4.2153846153800001e-01, \
                                    -4.2076923076900002e-01, -4.1999999999999998e-01, -4.1923076923100000e-01, \
                                    -4.1846153846200002e-01, -4.1769230769200000e-01, -4.1692307692300001e-01, \
                                    -4.1615384615399997e-01, -4.1538461538499999e-01, -4.1461538461500003e-01, \
                                    -4.1384615384599999e-01, -4.1307692307700000e-01, -4.1230769230800002e-01, \
                                    -4.1153846153800000e-01, -4.1076923076900002e-01, -4.0999999999999998e-01, \
                                    -4.0923076923099999e-01, -4.0846153846200001e-01, -4.0769230769199999e-01, \
                                    -4.0692307692300000e-01, -4.0615384615400002e-01, -4.0538461538499998e-01, \
                                    -4.0461538461500002e-01, -4.0384615384599998e-01, -4.0307692307699999e-01, \
                                    -4.0230769230800001e-01, -4.0153846153799999e-01, -4.0076923076900001e-01, \
                                    -4.0000000000000002e-01, -3.9923076923099998e-01, -3.9846153846200000e-01, \
                                    -3.9769230769199998e-01, -3.9692307692300000e-01, -3.9615384615400001e-01, \
                                    -3.9538461538500003e-01, -3.9461538461500001e-01, -3.9384615384600002e-01, \
                                    -3.9307692307699998e-01, -3.9230769230800000e-01, -3.9153846153799998e-01, \
                                    -3.9076923076900000e-01, -3.9000000000000001e-01, -3.8923076923099997e-01, \
                                    -3.8846153846199999e-01, -3.8769230769200003e-01, -3.8692307692299999e-01, \
                                    -3.8615384615400000e-01, -3.8538461538500002e-01, -3.8461538461500000e-01, \
                                    -3.8384615384600002e-01, -3.8307692307699998e-01, -3.8230769230799999e-01, \
                                    -3.8153846153799997e-01, -3.8076923076899999e-01, -3.8000000000000000e-01, \
                                    -3.7923076923100002e-01, -3.7846153846199998e-01, -3.7769230769200002e-01, \
                                    -3.7692307692299998e-01, -3.7615384615399999e-01, -3.7538461538500001e-01, \
                                    -3.7461538461499999e-01, -3.7384615384600001e-01, -3.7307692307700002e-01, \
                                    -3.7230769230799998e-01, -3.7153846153800002e-01, -3.7076923076899998e-01, \
                                    -3.7000000000000000e-01, -3.6923076923100001e-01, -3.6846153846200003e-01, \
                                    -3.6769230769200001e-01, -3.6692307692300002e-01, -3.6615384615399998e-01, \
                                    -3.6538461538500000e-01, -3.6461538461499998e-01, -3.6384615384600000e-01, \
                                    -3.6307692307700001e-01, -3.6230769230799997e-01, -3.6153846153800001e-01, \
                                    -3.6076923076900003e-01, -3.5999999999999999e-01, -3.5923076923100000e-01, \
                                    -3.5846153846200002e-01, -3.5769230769200000e-01, -3.5692307692300002e-01, \
                                    -3.5615384615399998e-01, -3.5538461538499999e-01, -3.5461538461499997e-01, \
                                    -3.5384615384599999e-01, -3.5307692307700000e-01, -3.5230769230800002e-01, \
                                    -3.5153846153800000e-01, -3.5076923076900002e-01, -3.4999999999999998e-01, \
                                    -3.4923076923099999e-01, -3.4846153846200001e-01, -3.4769230769199999e-01, \
                                    -3.4692307692300001e-01, -3.4615384615400002e-01, -3.4538461538499998e-01, \
                                    -3.4461538461500002e-01, -3.4384615384599998e-01, -3.4307692307700000e-01, \
                                    -3.4230769230800001e-01, -3.4153846153799999e-01, -3.4076923076900001e-01, \
                                    -3.4000000000000002e-01, -3.3923076923099998e-01, -3.3846153846200000e-01, \
                                    -3.3769230769199998e-01, -3.3692307692300000e-01, -3.3615384615400001e-01, \
                                    -3.3538461538499997e-01, -3.3461538461500001e-01, -3.3384615384600003e-01, \
                                    -3.3307692307699999e-01, -3.3230769230800000e-01, -3.3153846153799998e-01, \
                                    -3.3076923076900000e-01, -3.3000000000000002e-01, -3.2923076923099998e-01, \
                                    -3.2846153846199999e-01, -3.2769230769199997e-01, -3.2692307692299999e-01, \
                                    -3.2615384615400000e-01, -3.2538461538500002e-01, -3.2461538461500000e-01, \
                                    -3.2384615384600002e-01, -3.2307692307699998e-01, -3.2230769230799999e-01, \
                                    -3.2153846153799998e-01, -3.2076923076899999e-01, -3.2000000000000001e-01, \
                                    -3.1923076923100002e-01, -3.1846153846199998e-01, -3.1769230769200002e-01, \
                                    -3.1692307692299998e-01, -3.1615384615400000e-01, -3.1538461538500001e-01, \
                                    -3.1461538461499999e-01, -3.1384615384600001e-01, -3.1307692307700002e-01, \
                                    -3.1230769230799998e-01, -3.1153846153800002e-01, -3.1076923076899998e-01, \
                                    -3.1000000000000000e-01, -3.0923076923100001e-01, -3.0846153846199997e-01, \
                                    -3.0769230769200001e-01, -3.0692307692300003e-01, -3.0615384615399999e-01, \
                                    -3.0538461538500000e-01, -3.0461538461499998e-01, -3.0384615384600000e-01, \
                                    -3.0307692307700002e-01, -3.0230769230799998e-01, -3.0153846153800001e-01, \
                                    -3.0076923076899997e-01, -2.9999999999999999e-01, -2.9923076923100000e-01, \
                                    -2.9846153846200002e-01, -2.9769230769200000e-01, -2.9692307692300002e-01, \
                                    -2.9615384615399998e-01, -2.9538461538499999e-01, -2.9461538461499998e-01, \
                                    -2.9384615384599999e-01, -2.9307692307700001e-01, -2.9230769230800002e-01, \
                                    -2.9153846153800000e-01, -2.9076923076900002e-01, -2.8999999999999998e-01, \
                                    -2.8923076923100000e-01, -2.8846153846200001e-01, -2.8769230769199999e-01, \
                                    -2.8692307692300001e-01, -2.8615384615400002e-01, -2.8538461538499998e-01, \
                                    -2.8461538461500002e-01, -2.8384615384599998e-01, -2.8307692307700000e-01, \
                                    -2.8230769230800001e-01, -2.8153846153800000e-01, -2.8076923076900001e-01, \
                                    -2.8000000000000003e-01, -2.7923076923099999e-01, -2.7846153846200000e-01, \
                                    -2.7769230769199998e-01, -2.7692307692300000e-01, -2.7615384615400002e-01, \
                                    -2.7538461538499998e-01, -2.7461538461500001e-01, -2.7384615384599997e-01, \
                                    -2.7307692307699999e-01, -2.7230769230800000e-01, -2.7153846153799999e-01, \
                                    -2.7076923076900000e-01, -2.7000000000000002e-01, -2.6923076923099998e-01, \
                                    -2.6846153846199999e-01, -2.6769230769199998e-01, -2.6692307692299999e-01, \
                                    -2.6615384615400001e-01, -2.6538461538500002e-01, -2.6461538461500000e-01, \
                                    -2.6384615384600002e-01, -2.6307692307699998e-01, -2.6230769230800000e-01, \
                                    -2.6153846153799998e-01, -2.6076923076899999e-01, -2.6000000000000001e-01, \
                                    -2.5923076923100002e-01, -2.5846153846199998e-01, -2.5769230769200002e-01, \
                                    -2.5692307692299998e-01, -2.5615384615400000e-01, -2.5538461538500001e-01, \
                                    -2.5461538461500000e-01, -2.5384615384600001e-01, -2.5307692307700003e-01, \
                                    -2.5230769230799999e-01, -2.5153846153800002e-01, -2.5076923076899998e-01, \
                                    -2.5000000000000000e-01, -2.4923076923099999e-01, -2.4846153846200000e-01, \
                                    -2.4769230769200001e-01, -2.4692307692300000e-01, -2.4615384615399999e-01, \
                                    -2.4538461538500000e-01, -2.4461538461499999e-01, -2.4384615384600000e-01, \
                                    -2.4307692307699999e-01, -2.4230769230800001e-01, -2.4153846153799999e-01, \
                                    -2.4076923076900000e-01, -2.3999999999999999e-01, -2.3923076923100001e-01, \
                                    -2.3846153846199999e-01, -2.3769230769200000e-01, -2.3692307692299999e-01, \
                                    -2.3615384615400001e-01, -2.3538461538500000e-01, -2.3461538461500001e-01, \
                                    -2.3384615384599999e-01, -2.3307692307700001e-01, -2.3230769230800000e-01, \
                                    -2.3153846153800001e-01, -2.3076923076899999e-01, -2.3000000000000001e-01, \
                                    -2.2923076923100000e-01, -2.2846153846200001e-01, -2.2769230769200000e-01, \
                                    -2.2692307692300001e-01, -2.2615384615400000e-01, -2.2538461538499999e-01, \
                                    -2.2461538461500000e-01, -2.2384615384600001e-01, -2.2307692307700000e-01, \
                                    -2.2230769230799999e-01, -2.2153846153800000e-01, -2.2076923076900001e-01, \
                                    -2.2000000000000000e-01, -2.1923076923099999e-01, -2.1846153846200000e-01, \
                                    -2.1769230769199999e-01, -2.1692307692300000e-01, -2.1615384615399999e-01, \
                                    -2.1538461538500001e-01, -2.1461538461499999e-01, -2.1384615384600000e-01, \
                                    -2.1307692307699999e-01, -2.1230769230800001e-01, -2.1153846153799999e-01, \
                                    -2.1076923076900000e-01, -2.0999999999999999e-01, -2.0923076923100001e-01, \
                                    -2.0846153846200000e-01, -2.0769230769200001e-01, -2.0692307692299999e-01, \
                                    -2.0615384615400001e-01, -2.0538461538500000e-01, -2.0461538461500001e-01, \
                                    -2.0384615384599999e-01, -2.0307692307700001e-01, -2.0230769230800000e-01, \
                                    -2.0153846153800001e-01, -2.0076923076900000e-01, -2.0000000000000001e-01, \
                                    -1.9923076923100000e-01, -1.9846153846199999e-01, -1.9769230769200000e-01, \
                                    -1.9692307692300001e-01, -1.9615384615400000e-01, -1.9538461538499999e-01, \
                                    -1.9461538461500000e-01, -1.9384615384600001e-01, -1.9307692307700000e-01, \
                                    -1.9230769230799999e-01, -1.9153846153800000e-01, -1.9076923076899999e-01, \
                                    -1.9000000000000000e-01, -1.8923076923099999e-01, -1.8846153846200001e-01, \
                                    -1.8769230769199999e-01, -1.8692307692300000e-01, -1.8615384615399999e-01, \
                                    -1.8538461538500001e-01, -1.8461538461499999e-01, -1.8384615384600000e-01, \
                                    -1.8307692307699999e-01, -1.8230769230800001e-01, -1.8153846153799999e-01, \
                                    -1.8076923076900001e-01, -1.7999999999999999e-01, -1.7923076923100001e-01, \
                                    -1.7846153846200000e-01, -1.7769230769200001e-01, -1.7692307692299999e-01, \
                                    -1.7615384615400001e-01, -1.7538461538500000e-01, -1.7461538461500001e-01, \
                                    -1.7384615384600000e-01, -1.7307692307700001e-01, -1.7230769230800000e-01, \
                                    -1.7153846153800001e-01, -1.7076923076900000e-01, -1.7000000000000001e-01, \
                                    -1.6923076923100000e-01, -1.6846153846199999e-01, -1.6769230769200000e-01, \
                                    -1.6692307692300001e-01, -1.6615384615400000e-01, -1.6538461538499999e-01, \
                                    -1.6461538461500000e-01, -1.6384615384599999e-01, -1.6307692307700000e-01, \
                                    -1.6230769230799999e-01, -1.6153846153800000e-01, -1.6076923076899999e-01, \
                                    -1.6000000000000000e-01, -1.5923076923099999e-01, -1.5846153846200001e-01, \
                                    -1.5769230769199999e-01, -1.5692307692300000e-01, -1.5615384615399999e-01, \
                                    -1.5538461538500001e-01, -1.5461538461499999e-01, -1.5384615384600001e-01, \
                                    -1.5307692307699999e-01, -1.5230769230800001e-01, -1.5153846153799999e-01, \
                                    -1.5076923076900001e-01, -1.4999999999999999e-01, -1.4923076923100001e-01, \
                                    -1.4846153846200000e-01, -1.4769230769200001e-01, -1.4692307692300000e-01, \
                                    -1.4615384615400001e-01, -1.4538461538500000e-01, -1.4461538461500001e-01, \
                                    -1.4384615384600000e-01, -1.4307692307700001e-01, -1.4230769230800000e-01, \
                                    -1.4153846153800001e-01, -1.4076923076900000e-01, -1.4000000000000001e-01, \
                                    -1.3923076923100000e-01, -1.3846153846199999e-01, -1.3769230769200000e-01, \
                                    -1.3692307692299999e-01, -1.3615384615400000e-01, -1.3538461538499999e-01, \
                                    -1.3461538461500000e-01, -1.3384615384599999e-01, -1.3307692307700000e-01, \
                                    -1.3230769230799999e-01, -1.3153846153800000e-01, -1.3076923076899999e-01, \
                                    -1.3000000000000000e-01, -1.2923076923099999e-01, -1.2846153846200001e-01, \
                                    -1.2769230769199999e-01, -1.2692307692300001e-01, -1.2615384615399999e-01, \
                                    -1.2538461538500001e-01, -1.2461538461500000e-01, -1.2384615384600001e-01, \
                                    -1.2307692307699999e-01, -1.2230769230800000e-01, -1.2153846153800001e-01, \
                                    -1.2076923076899999e-01, -1.2000000000000000e-01, -1.1923076923100000e-01, \
                                    -1.1846153846200000e-01, -1.1769230769199999e-01, -1.1692307692300000e-01, \
                                    -1.1615384615400000e-01, -1.1538461538500000e-01, -1.1461538461500000e-01, \
                                    -1.1384615384600000e-01, -1.1307692307700000e-01, -1.1230769230800000e-01, \
                                    -1.1153846153800000e-01, -1.1076923076900000e-01, -1.1000000000000000e-01, \
                                    -1.0923076923100000e-01, -1.0846153846200000e-01, -1.0769230769200000e-01, \
                                    -1.0692307692300000e-01, -1.0615384615400000e-01, -1.0538461538500001e-01, \
                                    -1.0461538461500000e-01, -1.0384615384600000e-01, -1.0307692307700000e-01, \
                                    -1.0230769230800001e-01, -1.0153846153800000e-01, -1.0076923076900000e-01, \
                                    -1.0000000000000001e-01, -9.9230769230999993e-02, -9.8461538461999995e-02, \
                                    -9.7692307692000005e-02, -9.6923076923000007e-02, -9.6153846153999994e-02, \
                                    -9.5384615384999996e-02, -9.4615384615000006e-02, -9.3846153845999994e-02, \
                                    -9.3076923076999996e-02, -9.2307692307999997e-02, -9.1538461537999993e-02, \
                                    -9.0769230768999995e-02, -8.9999999999999997e-02, -8.9230769230999998e-02, \
                                    -8.8461538462000000e-02, -8.7692307691999996e-02, -8.6923076922999998e-02, \
                                    -8.6153846153999999e-02, -8.5384615385000001e-02, -8.4615384614999997e-02, \
                                    -8.3846153845999999e-02, -8.3076923077000001e-02, -8.2307692308000002e-02, \
                                    -8.1538461537999998e-02, -8.0769230769000000e-02, -8.0000000000000002e-02, \
                                    -7.9230769231000003e-02, -7.8461538462000005e-02, -7.7692307692000001e-02, \
                                    -7.6923076923000003e-02, -7.6153846154000004e-02, -7.5384615385000006e-02, \
                                    -7.4615384615000002e-02, -7.3846153846000004e-02, -7.3076923077000006e-02, \
                                    -7.2307692307999993e-02, -7.1538461538000003e-02, -7.0769230769000005e-02, \
                                    -7.0000000000000007e-02, -6.9230769230999994e-02, -6.8461538461999996e-02, \
                                    -6.7692307692000006e-02, -6.6923076922999994e-02, -6.6153846153999996e-02, \
                                    -6.5384615384999997e-02, -6.4615384614999993e-02, -6.3846153845999995e-02, \
                                    -6.3076923076999997e-02, -6.2307692307999998e-02, -6.1538461538000001e-02, \
                                    -6.0769230769000003e-02, -5.9999999999999998e-02, -5.9230769230999999e-02, \
                                    -5.8461538462000001e-02, -5.7692307691999997e-02, -5.6923076922999999e-02, \
                                    -5.6153846154000001e-02, -5.5384615385000002e-02, -5.4615384614999998e-02, \
                                    -5.3846153846000000e-02, -5.3076923077000002e-02, -5.2307692308000003e-02, \
                                    -5.1538461537999999e-02, -5.0769230769000001e-02, -5.0000000000000003e-02, \
                                    -4.9230769230999998e-02, -4.8461538461999999e-02, -4.7692307692000002e-02, \
                                    -4.6923076922999997e-02, -4.6153846153999999e-02, -4.5384615385000000e-02, \
                                    -4.4615384615000003e-02, -4.3846153845999998e-02, -4.3076923077000000e-02, \
                                    -4.2307692308000001e-02, -4.1538461537999997e-02, -4.0769230768999999e-02, \
                                    -4.0000000000000001e-02, -3.9230769231000003e-02, -3.8461538461999997e-02, \
                                    -3.7692307692000000e-02, -3.6923076923000002e-02, -3.6153846153999997e-02, \
                                    -3.5384615384999998e-02, -3.4615384615000001e-02, -3.3846153846000003e-02, \
                                    -3.3076923076999998e-02, -3.2307692307999999e-02, -3.1538461538000002e-02, \
                                    -3.0769230769000001e-02, -2.9999999999999999e-02, -2.9230769231000001e-02, \
                                    -2.8461538461999999e-02, -2.7692307691999998e-02, -2.6923076923000000e-02, \
                                    -2.6153846154000002e-02, -2.5384615385000000e-02, -2.4615384614999999e-02, \
                                    -2.3846153846000001e-02, -2.3076923076999999e-02, -2.2307692308000001e-02, \
                                    -2.1538461538000001e-02, -2.0769230768999999e-02, -2.0000000000000000e-02, \
                                    -1.9230769230999999e-02, -1.8461538462000000e-02, -1.7692307692000000e-02, \
                                    -1.6923076923000002e-02, -1.6153846154000000e-02, -1.5384615385000000e-02, \
                                    -1.4615384614999999e-02, -1.3846153845999999e-02, -1.3076923077000001e-02, \
                                    -1.2307692308000001e-02, -1.1538461538000000e-02, -1.0769230769000000e-02, \
                                    -1.0000000000000000e-02, -9.2307692310000002e-03, -8.4615384620000001e-03, \
                                    -7.6923076919999996e-03, -6.9230769229999996e-03, -6.1538461540000004e-03, \
                                    -5.3846153850000003e-03, -4.6153846149999999e-03, -3.8461538459999998e-03, \
                                    -3.0769230770000002e-03, -2.3076923080000001e-03, -1.5384615380000001e-03, \
                                    -7.6923076900000005e-04,  0.0000000000000000e+00,  7.6923076900000005e-04, \
                                    1.5384615380000001e-03,  2.3076923080000001e-03,  3.0769230770000002e-03, \
                                    3.8461538459999998e-03,  4.6153846149999999e-03,  5.3846153850000003e-03, \
                                    6.1538461540000004e-03,  6.9230769229999996e-03,  7.6923076919999996e-03, \
                                    8.4615384620000001e-03,  9.2307692310000002e-03,  1.0000000000000000e-02, \
                                    1.0769230769000000e-02,  1.1538461538000000e-02,  1.2307692308000001e-02, \
                                    1.3076923077000001e-02,  1.3846153845999999e-02,  1.4615384614999999e-02, \
                                    1.5384615385000000e-02,  1.6153846154000000e-02,  1.6923076923000002e-02, \
                                    1.7692307692000000e-02,  1.8461538462000000e-02,  1.9230769230999999e-02, \
                                    2.0000000000000000e-02,  2.0769230768999999e-02,  2.1538461538000001e-02, \
                                    2.2307692308000001e-02,  2.3076923076999999e-02,  2.3846153846000001e-02, \
                                    2.4615384614999999e-02,  2.5384615385000000e-02,  2.6153846154000002e-02, \
                                    2.6923076923000000e-02,  2.7692307691999998e-02,  2.8461538461999999e-02, \
                                    2.9230769231000001e-02,  2.9999999999999999e-02,  3.0769230769000001e-02, \
                                    3.1538461538000002e-02,  3.2307692307999999e-02,  3.3076923076999998e-02, \
                                    3.3846153846000003e-02,  3.4615384615000001e-02,  3.5384615384999998e-02, \
                                    3.6153846153999997e-02,  3.6923076923000002e-02,  3.7692307692000000e-02, \
                                    3.8461538461999997e-02,  3.9230769231000003e-02,  4.0000000000000001e-02, \
                                    4.0769230768999999e-02,  4.1538461537999997e-02,  4.2307692308000001e-02, \
                                    4.3076923077000000e-02,  4.3846153845999998e-02,  4.4615384615000003e-02, \
                                    4.5384615385000000e-02,  4.6153846153999999e-02,  4.6923076922999997e-02, \
                                    4.7692307692000002e-02,  4.8461538461999999e-02,  4.9230769230999998e-02, \
                                    5.0000000000000003e-02,  5.0769230769000001e-02,  5.1538461537999999e-02, \
                                    5.2307692308000003e-02,  5.3076923077000002e-02,  5.3846153846000000e-02, \
                                    5.4615384614999998e-02,  5.5384615385000002e-02,  5.6153846154000001e-02, \
                                    5.6923076922999999e-02,  5.7692307691999997e-02,  5.8461538462000001e-02, \
                                    5.9230769230999999e-02,  5.9999999999999998e-02,  6.0769230769000003e-02, \
                                    6.1538461538000001e-02,  6.2307692307999998e-02,  6.3076923076999997e-02, \
                                    6.3846153845999995e-02,  6.4615384614999993e-02,  6.5384615384999997e-02, \
                                    6.6153846153999996e-02,  6.6923076922999994e-02,  6.7692307692000006e-02, \
                                    6.8461538461999996e-02,  6.9230769230999994e-02,  7.0000000000000007e-02, \
                                    7.0769230769000005e-02,  7.1538461538000003e-02,  7.2307692307999993e-02, \
                                    7.3076923077000006e-02,  7.3846153846000004e-02,  7.4615384615000002e-02, \
                                    7.5384615385000006e-02,  7.6153846154000004e-02,  7.6923076923000003e-02, \
                                    7.7692307692000001e-02,  7.8461538462000005e-02,  7.9230769231000003e-02, \
                                    8.0000000000000002e-02,  8.0769230769000000e-02,  8.1538461537999998e-02, \
                                    8.2307692308000002e-02,  8.3076923077000001e-02,  8.3846153845999999e-02, \
                                    8.4615384614999997e-02,  8.5384615385000001e-02,  8.6153846153999999e-02, \
                                    8.6923076922999998e-02,  8.7692307691999996e-02,  8.8461538462000000e-02, \
                                    8.9230769230999998e-02,  8.9999999999999997e-02,  9.0769230768999995e-02, \
                                    9.1538461537999993e-02,  9.2307692307999997e-02,  9.3076923076999996e-02, \
                                    9.3846153845999994e-02,  9.4615384615000006e-02,  9.5384615384999996e-02, \
                                    9.6153846153999994e-02,  9.6923076923000007e-02,  9.7692307692000005e-02, \
                                    9.8461538461999995e-02,  9.9230769230999993e-02,  1.0000000000000001e-01, \
                                    1.0076923076900000e-01,  1.0153846153800000e-01,  1.0230769230800001e-01, \
                                    1.0307692307700000e-01,  1.0384615384600000e-01,  1.0461538461500000e-01, \
                                    1.0538461538500001e-01,  1.0615384615400000e-01,  1.0692307692300000e-01, \
                                    1.0769230769200000e-01,  1.0846153846200000e-01,  1.0923076923100000e-01, \
                                    1.1000000000000000e-01,  1.1076923076900000e-01,  1.1153846153800000e-01, \
                                    1.1230769230800000e-01,  1.1307692307700000e-01,  1.1384615384600000e-01, \
                                    1.1461538461500000e-01,  1.1538461538500000e-01,  1.1615384615400000e-01, \
                                    1.1692307692300000e-01,  1.1769230769199999e-01,  1.1846153846200000e-01, \
                                    1.1923076923100000e-01,  1.2000000000000000e-01,  1.2076923076899999e-01, \
                                    1.2153846153800001e-01,  1.2230769230800000e-01,  1.2307692307699999e-01, \
                                    1.2384615384600001e-01,  1.2461538461500000e-01,  1.2538461538500001e-01, \
                                    1.2615384615399999e-01,  1.2692307692300001e-01,  1.2769230769199999e-01, \
                                    1.2846153846200001e-01,  1.2923076923099999e-01,  1.3000000000000000e-01, \
                                    1.3076923076899999e-01,  1.3153846153800000e-01,  1.3230769230799999e-01, \
                                    1.3307692307700000e-01,  1.3384615384599999e-01,  1.3461538461500000e-01, \
                                    1.3538461538499999e-01,  1.3615384615400000e-01,  1.3692307692299999e-01, \
                                    1.3769230769200000e-01,  1.3846153846199999e-01,  1.3923076923100000e-01, \
                                    1.4000000000000001e-01,  1.4076923076900000e-01,  1.4153846153800001e-01, \
                                    1.4230769230800000e-01,  1.4307692307700001e-01,  1.4384615384600000e-01, \
                                    1.4461538461500001e-01,  1.4538461538500000e-01,  1.4615384615400001e-01, \
                                    1.4692307692300000e-01,  1.4769230769200001e-01,  1.4846153846200000e-01, \
                                    1.4923076923100001e-01,  1.4999999999999999e-01,  1.5076923076900001e-01, \
                                    1.5153846153799999e-01,  1.5230769230800001e-01,  1.5307692307699999e-01, \
                                    1.5384615384600001e-01,  1.5461538461499999e-01,  1.5538461538500001e-01, \
                                    1.5615384615399999e-01,  1.5692307692300000e-01,  1.5769230769199999e-01, \
                                    1.5846153846200001e-01,  1.5923076923099999e-01,  1.6000000000000000e-01, \
                                    1.6076923076899999e-01,  1.6153846153800000e-01,  1.6230769230799999e-01, \
                                    1.6307692307700000e-01,  1.6384615384599999e-01,  1.6461538461500000e-01, \
                                    1.6538461538499999e-01,  1.6615384615400000e-01,  1.6692307692300001e-01, \
                                    1.6769230769200000e-01,  1.6846153846199999e-01,  1.6923076923100000e-01, \
                                    1.7000000000000001e-01,  1.7076923076900000e-01,  1.7153846153800001e-01, \
                                    1.7230769230800000e-01,  1.7307692307700001e-01,  1.7384615384600000e-01, \
                                    1.7461538461500001e-01,  1.7538461538500000e-01,  1.7615384615400001e-01, \
                                    1.7692307692299999e-01,  1.7769230769200001e-01,  1.7846153846200000e-01, \
                                    1.7923076923100001e-01,  1.7999999999999999e-01,  1.8076923076900001e-01, \
                                    1.8153846153799999e-01,  1.8230769230800001e-01,  1.8307692307699999e-01, \
                                    1.8384615384600000e-01,  1.8461538461499999e-01,  1.8538461538500001e-01, \
                                    1.8615384615399999e-01,  1.8692307692300000e-01,  1.8769230769199999e-01, \
                                    1.8846153846200001e-01,  1.8923076923099999e-01,  1.9000000000000000e-01, \
                                    1.9076923076899999e-01,  1.9153846153800000e-01,  1.9230769230799999e-01, \
                                    1.9307692307700000e-01,  1.9384615384600001e-01,  1.9461538461500000e-01, \
                                    1.9538461538499999e-01,  1.9615384615400000e-01,  1.9692307692300001e-01, \
                                    1.9769230769200000e-01,  1.9846153846199999e-01,  1.9923076923100000e-01, \
                                    2.0000000000000001e-01,  2.0076923076900000e-01,  2.0153846153800001e-01, \
                                    2.0230769230800000e-01,  2.0307692307700001e-01,  2.0384615384599999e-01, \
                                    2.0461538461500001e-01,  2.0538461538500000e-01,  2.0615384615400001e-01, \
                                    2.0692307692299999e-01,  2.0769230769200001e-01,  2.0846153846200000e-01, \
                                    2.0923076923100001e-01,  2.0999999999999999e-01,  2.1076923076900000e-01, \
                                    2.1153846153799999e-01,  2.1230769230800001e-01,  2.1307692307699999e-01, \
                                    2.1384615384600000e-01,  2.1461538461499999e-01,  2.1538461538500001e-01, \
                                    2.1615384615399999e-01,  2.1692307692300000e-01,  2.1769230769199999e-01, \
                                    2.1846153846200000e-01,  2.1923076923099999e-01,  2.2000000000000000e-01, \
                                    2.2076923076900001e-01,  2.2153846153800000e-01,  2.2230769230799999e-01, \
                                    2.2307692307700000e-01,  2.2384615384600001e-01,  2.2461538461500000e-01, \
                                    2.2538461538499999e-01,  2.2615384615400000e-01,  2.2692307692300001e-01, \
                                    2.2769230769200000e-01,  2.2846153846200001e-01,  2.2923076923100000e-01, \
                                    2.3000000000000001e-01,  2.3076923076899999e-01,  2.3153846153800001e-01, \
                                    2.3230769230800000e-01,  2.3307692307700001e-01,  2.3384615384599999e-01, \
                                    2.3461538461500001e-01,  2.3538461538500000e-01,  2.3615384615400001e-01, \
                                    2.3692307692299999e-01,  2.3769230769200000e-01,  2.3846153846199999e-01, \
                                    2.3923076923100001e-01,  2.3999999999999999e-01,  2.4076923076900000e-01, \
                                    2.4153846153799999e-01,  2.4230769230800001e-01,  2.4307692307699999e-01, \
                                    2.4384615384600000e-01,  2.4461538461499999e-01,  2.4538461538500000e-01, \
                                    2.4615384615399999e-01,  2.4692307692300000e-01,  2.4769230769200001e-01, \
                                    2.4846153846200000e-01,  2.4923076923099999e-01,  2.5000000000000000e-01, \
                                    2.5076923076899998e-01,  2.5153846153800002e-01,  2.5230769230799999e-01, \
                                    2.5307692307700003e-01,  2.5384615384600001e-01,  2.5461538461500000e-01, \
                                    2.5538461538500001e-01,  2.5615384615400000e-01,  2.5692307692299998e-01, \
                                    2.5769230769200002e-01,  2.5846153846199998e-01,  2.5923076923100002e-01, \
                                    2.6000000000000001e-01,  2.6076923076899999e-01,  2.6153846153799998e-01, \
                                    2.6230769230800000e-01,  2.6307692307699998e-01,  2.6384615384600002e-01, \
                                    2.6461538461500000e-01,  2.6538461538500002e-01,  2.6615384615400001e-01, \
                                    2.6692307692299999e-01,  2.6769230769199998e-01,  2.6846153846199999e-01, \
                                    2.6923076923099998e-01,  2.7000000000000002e-01,  2.7076923076900000e-01, \
                                    2.7153846153799999e-01,  2.7230769230800000e-01,  2.7307692307699999e-01, \
                                    2.7384615384599997e-01,  2.7461538461500001e-01,  2.7538461538499998e-01, \
                                    2.7615384615400002e-01,  2.7692307692300000e-01,  2.7769230769199998e-01, \
                                    2.7846153846200000e-01,  2.7923076923099999e-01,  2.8000000000000003e-01, \
                                    2.8076923076900001e-01,  2.8153846153800000e-01,  2.8230769230800001e-01, \
                                    2.8307692307700000e-01,  2.8384615384599998e-01,  2.8461538461500002e-01, \
                                    2.8538461538499998e-01,  2.8615384615400002e-01,  2.8692307692300001e-01, \
                                    2.8769230769199999e-01,  2.8846153846200001e-01,  2.8923076923100000e-01, \
                                    2.8999999999999998e-01,  2.9076923076900002e-01,  2.9153846153800000e-01, \
                                    2.9230769230800002e-01,  2.9307692307700001e-01,  2.9384615384599999e-01, \
                                    2.9461538461499998e-01,  2.9538461538499999e-01,  2.9615384615399998e-01, \
                                    2.9692307692300002e-01,  2.9769230769200000e-01,  2.9846153846200002e-01, \
                                    2.9923076923100000e-01,  2.9999999999999999e-01,  3.0076923076899997e-01, \
                                    3.0153846153800001e-01,  3.0230769230799998e-01,  3.0307692307700002e-01, \
                                    3.0384615384600000e-01,  3.0461538461499998e-01,  3.0538461538500000e-01, \
                                    3.0615384615399999e-01,  3.0692307692300003e-01,  3.0769230769200001e-01, \
                                    3.0846153846199997e-01,  3.0923076923100001e-01,  3.1000000000000000e-01, \
                                    3.1076923076899998e-01,  3.1153846153800002e-01,  3.1230769230799998e-01, \
                                    3.1307692307700002e-01,  3.1384615384600001e-01,  3.1461538461499999e-01, \
                                    3.1538461538500001e-01,  3.1615384615400000e-01,  3.1692307692299998e-01, \
                                    3.1769230769200002e-01,  3.1846153846199998e-01,  3.1923076923100002e-01, \
                                    3.2000000000000001e-01,  3.2076923076899999e-01,  3.2153846153799998e-01, \
                                    3.2230769230799999e-01,  3.2307692307699998e-01,  3.2384615384600002e-01, \
                                    3.2461538461500000e-01,  3.2538461538500002e-01,  3.2615384615400000e-01, \
                                    3.2692307692299999e-01,  3.2769230769199997e-01,  3.2846153846199999e-01, \
                                    3.2923076923099998e-01,  3.3000000000000002e-01,  3.3076923076900000e-01, \
                                    3.3153846153799998e-01,  3.3230769230800000e-01,  3.3307692307699999e-01, \
                                    3.3384615384600003e-01,  3.3461538461500001e-01,  3.3538461538499997e-01, \
                                    3.3615384615400001e-01,  3.3692307692300000e-01,  3.3769230769199998e-01, \
                                    3.3846153846200000e-01,  3.3923076923099998e-01,  3.4000000000000002e-01, \
                                    3.4076923076900001e-01,  3.4153846153799999e-01,  3.4230769230800001e-01, \
                                    3.4307692307700000e-01,  3.4384615384599998e-01,  3.4461538461500002e-01, \
                                    3.4538461538499998e-01,  3.4615384615400002e-01,  3.4692307692300001e-01, \
                                    3.4769230769199999e-01,  3.4846153846200001e-01,  3.4923076923099999e-01, \
                                    3.4999999999999998e-01,  3.5076923076900002e-01,  3.5153846153800000e-01, \
                                    3.5230769230800002e-01,  3.5307692307700000e-01,  3.5384615384599999e-01, \
                                    3.5461538461499997e-01,  3.5538461538499999e-01,  3.5615384615399998e-01, \
                                    3.5692307692300002e-01,  3.5769230769200000e-01,  3.5846153846200002e-01, \
                                    3.5923076923100000e-01,  3.5999999999999999e-01,  3.6076923076900003e-01, \
                                    3.6153846153800001e-01,  3.6230769230799997e-01,  3.6307692307700001e-01, \
                                    3.6384615384600000e-01,  3.6461538461499998e-01,  3.6538461538500000e-01, \
                                    3.6615384615399998e-01,  3.6692307692300002e-01,  3.6769230769200001e-01, \
                                    3.6846153846200003e-01,  3.6923076923100001e-01,  3.7000000000000000e-01, \
                                    3.7076923076899998e-01,  3.7153846153800002e-01,  3.7230769230799998e-01, \
                                    3.7307692307700002e-01,  3.7384615384600001e-01,  3.7461538461499999e-01, \
                                    3.7538461538500001e-01,  3.7615384615399999e-01,  3.7692307692299998e-01, \
                                    3.7769230769200002e-01,  3.7846153846199998e-01,  3.7923076923100002e-01, \
                                    3.8000000000000000e-01,  3.8076923076899999e-01,  3.8153846153799997e-01, \
                                    3.8230769230799999e-01,  3.8307692307699998e-01,  3.8384615384600002e-01, \
                                    3.8461538461500000e-01,  3.8538461538500002e-01,  3.8615384615400000e-01, \
                                    3.8692307692299999e-01,  3.8769230769200003e-01,  3.8846153846199999e-01, \
                                    3.8923076923099997e-01,  3.9000000000000001e-01,  3.9076923076900000e-01, \
                                    3.9153846153799998e-01,  3.9230769230800000e-01,  3.9307692307699998e-01, \
                                    3.9384615384600002e-01,  3.9461538461500001e-01,  3.9538461538500003e-01, \
                                    3.9615384615400001e-01,  3.9692307692300000e-01,  3.9769230769199998e-01, \
                                    3.9846153846200000e-01,  3.9923076923099998e-01,  4.0000000000000002e-01, \
                                    4.0076923076900001e-01,  4.0153846153799999e-01,  4.0230769230800001e-01, \
                                    4.0307692307699999e-01,  4.0384615384599998e-01,  4.0461538461500002e-01, \
                                    4.0538461538499998e-01,  4.0615384615400002e-01,  4.0692307692300000e-01, \
                                    4.0769230769199999e-01,  4.0846153846200001e-01,  4.0923076923099999e-01, \
                                    4.0999999999999998e-01,  4.1076923076900002e-01,  4.1153846153800000e-01, \
                                    4.1230769230800002e-01,  4.1307692307700000e-01,  4.1384615384599999e-01, \
                                    4.1461538461500003e-01,  4.1538461538499999e-01,  4.1615384615399997e-01, \
                                    4.1692307692300001e-01,  4.1769230769200000e-01,  4.1846153846200002e-01, \
                                    4.1923076923100000e-01,  4.1999999999999998e-01,  4.2076923076900002e-01, \
                                    4.2153846153800001e-01,  4.2230769230800003e-01,  4.2307692307700001e-01, \
                                    4.2384615384600000e-01,  4.2461538461499998e-01,  4.2538461538500000e-01, \
                                    4.2615384615399998e-01,  4.2692307692300002e-01,  4.2769230769200001e-01, \
                                    4.2846153846200002e-01,  4.2923076923100001e-01,  4.2999999999999999e-01, \
                                    4.3076923076899998e-01,  4.3153846153800002e-01,  4.3230769230799998e-01, \
                                    4.3307692307700002e-01,  4.3384615384600000e-01,  4.3461538461499999e-01, \
                                    4.3538461538500001e-01,  4.3615384615399999e-01,  4.3692307692299998e-01, \
                                    4.3769230769200002e-01,  4.3846153846199998e-01,  4.3923076923100002e-01, \
                                    4.4000000000000000e-01,  4.4076923076899999e-01,  4.4153846153800003e-01, \
                                    4.4230769230799999e-01,  4.4307692307699997e-01,  4.4384615384600001e-01, \
                                    4.4461538461500000e-01,  4.4538461538500002e-01,  4.4615384615400000e-01, \
                                    4.4692307692299998e-01,  4.4769230769200002e-01,  4.4846153846199999e-01, \
                                    4.4923076923100003e-01,  4.5000000000000001e-01,  4.5076923076900000e-01, \
                                    4.5153846153799998e-01,  4.5230769230800000e-01,  4.5307692307699998e-01, \
                                    4.5384615384600002e-01,  4.5461538461500001e-01,  4.5538461538500002e-01, \
                                    4.5615384615400001e-01,  4.5692307692299999e-01,  4.5769230769199998e-01, \
                                    4.5846153846200000e-01,  4.5923076923099998e-01,  4.6000000000000002e-01, \
                                    4.6076923076900000e-01,  4.6153846153799999e-01,  4.6230769230800001e-01, \
                                    4.6307692307699999e-01,  4.6384615384599998e-01,  4.6461538461500002e-01, \
                                    4.6538461538499998e-01,  4.6615384615400002e-01,  4.6692307692300000e-01, \
                                    4.6769230769199999e-01,  4.6846153846200000e-01,  4.6923076923099999e-01, \
                                    4.6999999999999997e-01,  4.7076923076900001e-01,  4.7153846153800000e-01, \
                                    4.7230769230800002e-01,  4.7307692307700000e-01,  4.7384615384599998e-01, \
                                    4.7461538461500002e-01,  4.7538461538499999e-01,  4.7615384615400003e-01, \
                                    4.7692307692300001e-01,  4.7769230769200000e-01,  4.7846153846200001e-01, \
                                    4.7923076923100000e-01,  4.7999999999999998e-01,  4.8076923076900002e-01, \
                                    4.8153846153800001e-01,  4.8230769230800002e-01,  4.8307692307700001e-01, \
                                    4.8384615384599999e-01,  4.8461538461499998e-01,  4.8538461538500000e-01, \
                                    4.8615384615399998e-01,  4.8692307692300002e-01,  4.8769230769200000e-01, \
                                    4.8846153846200002e-01,  4.8923076923100001e-01,  4.8999999999999999e-01, \
                                    4.9076923076899998e-01,  4.9153846153800002e-01,  4.9230769230799998e-01, \
                                    4.9307692307700002e-01,  4.9384615384600000e-01,  4.9461538461499999e-01, \
                                    4.9538461538500000e-01,  4.9615384615399999e-01,  4.9692307692299997e-01, \
                                    4.9769230769200001e-01,  4.9846153846199998e-01,  4.9923076923100002e-01, \
                                    5.0000000000000000e-01,  5.0076923076900004e-01,  5.0153846153799997e-01, \
                                    5.0230769230799999e-01,  5.0307692307700003e-01,  5.0384615384599996e-01, \
                                    5.0461538461500000e-01,  5.0538461538500001e-01,  5.0615384615400005e-01, \
                                    5.0692307692299998e-01,  5.0769230769200002e-01,  5.0846153846200004e-01, \
                                    5.0923076923099997e-01,  5.1000000000000001e-01,  5.1076923076900005e-01, \
                                    5.1153846153799998e-01,  5.1230769230800000e-01,  5.1307692307700004e-01, \
                                    5.1384615384599996e-01,  5.1461538461500000e-01,  5.1538461538500002e-01, \
                                    5.1615384615399995e-01,  5.1692307692299999e-01,  5.1769230769200003e-01, \
                                    5.1846153846200005e-01,  5.1923076923099998e-01,  5.2000000000000002e-01, \
                                    5.2076923076899995e-01,  5.2153846153799999e-01,  5.2230769230800000e-01, \
                                    5.2307692307700004e-01,  5.2384615384599997e-01,  5.2461538461500001e-01, \
                                    5.2538461538500003e-01,  5.2615384615399996e-01,  5.2692307692300000e-01, \
                                    5.2769230769200004e-01,  5.2846153846199995e-01,  5.2923076923099999e-01, \
                                    5.3000000000000003e-01,  5.3076923076899996e-01,  5.3153846153800000e-01, \
                                    5.3230769230800001e-01,  5.3307692307700005e-01,  5.3384615384599998e-01, \
                                    5.3461538461500002e-01,  5.3538461538500004e-01,  5.3615384615399997e-01, \
                                    5.3692307692300001e-01,  5.3769230769200005e-01,  5.3846153846199996e-01, \
                                    5.3923076923100000e-01,  5.4000000000000004e-01,  5.4076923076899996e-01, \
                                    5.4153846153800000e-01,  5.4230769230800002e-01,  5.4307692307699995e-01, \
                                    5.4384615384599999e-01,  5.4461538461500003e-01,  5.4538461538500005e-01, \
                                    5.4615384615399998e-01,  5.4692307692300002e-01,  5.4769230769199995e-01, \
                                    5.4846153846199996e-01,  5.4923076923100000e-01,  5.5000000000000004e-01, \
                                    5.5076923076899997e-01,  5.5153846153800001e-01,  5.5230769230800003e-01, \
                                    5.5307692307699996e-01,  5.5384615384600000e-01,  5.5461538461500004e-01, \
                                    5.5538461538499995e-01,  5.5615384615399999e-01,  5.5692307692300003e-01, \
                                    5.5769230769199996e-01,  5.5846153846199997e-01,  5.5923076923100001e-01, \
                                    5.6000000000000005e-01,  5.6076923076899998e-01,  5.6153846153800002e-01, \
                                    5.6230769230800004e-01,  5.6307692307699997e-01,  5.6384615384600001e-01, \
                                    5.6461538461500005e-01,  5.6538461538499996e-01,  5.6615384615400000e-01, \
                                    5.6692307692300004e-01,  5.6769230769199996e-01,  5.6846153846199998e-01, \
                                    5.6923076923100002e-01,  5.6999999999999995e-01,  5.7076923076899999e-01, \
                                    5.7153846153800003e-01,  5.7230769230800005e-01,  5.7307692307699998e-01, \
                                    5.7384615384600002e-01,  5.7461538461499995e-01,  5.7538461538499996e-01, \
                                    5.7615384615400000e-01,  5.7692307692300004e-01,  5.7769230769199997e-01, \
                                    5.7846153846199999e-01,  5.7923076923100003e-01,  5.7999999999999996e-01, \
                                    5.8076923076900000e-01,  5.8153846153800004e-01,  5.8230769230799995e-01, \
                                    5.8307692307699999e-01,  5.8384615384600003e-01,  5.8461538461499996e-01, \
                                    5.8538461538499997e-01,  5.8615384615400001e-01,  5.8692307692300005e-01, \
                                    5.8769230769199998e-01,  5.8846153846200000e-01,  5.8923076923100004e-01, \
                                    5.8999999999999997e-01,  5.9076923076900001e-01,  5.9153846153800005e-01, \
                                    5.9230769230799996e-01,  5.9307692307700000e-01,  5.9384615384600004e-01, \
                                    5.9461538461499996e-01,  5.9538461538499998e-01,  5.9615384615400002e-01, \
                                    5.9692307692299995e-01,  5.9769230769199999e-01,  5.9846153846200001e-01, \
                                    5.9923076923100005e-01,  5.9999999999999998e-01,  6.0076923076900002e-01, \
                                    6.0153846153799995e-01,  6.0230769230799996e-01,  6.0307692307700000e-01, \
                                    6.0384615384600004e-01,  6.0461538461499997e-01,  6.0538461538499999e-01, \
                                    6.0615384615400003e-01,  6.0692307692299996e-01,  6.0769230769200000e-01, \
                                    6.0846153846200002e-01,  6.0923076923099995e-01,  6.0999999999999999e-01, \
                                    6.1076923076900003e-01,  6.1153846153799996e-01,  6.1230769230799997e-01, \
                                    6.1307692307700001e-01,  6.1384615384600005e-01,  6.1461538461499998e-01, \
                                    6.1538461538500000e-01,  6.1615384615400004e-01,  6.1692307692299997e-01, \
                                    6.1769230769200001e-01,  6.1846153846200003e-01,  6.1923076923099996e-01, \
                                    6.2000000000000000e-01,  6.2076923076900004e-01,  6.2153846153799996e-01, \
                                    6.2230769230799998e-01,  6.2307692307700002e-01,  6.2384615384599995e-01, \
                                    6.2461538461499999e-01,  6.2538461538500001e-01,  6.2615384615400005e-01, \
                                    6.2692307692299998e-01,  6.2769230769200002e-01,  6.2846153846200004e-01, \
                                    6.2923076923099996e-01,  6.3000000000000000e-01,  6.3076923076900004e-01, \
                                    6.3153846153799997e-01,  6.3230769230799999e-01,  6.3307692307700003e-01, \
                                    6.3384615384599996e-01,  6.3461538461500000e-01,  6.3538461538500002e-01, \
                                    6.3615384615399995e-01,  6.3692307692299999e-01,  6.3769230769200003e-01, \
                                    6.3846153846200004e-01,  6.3923076923099997e-01,  6.4000000000000001e-01, \
                                    6.4076923076900005e-01,  6.4153846153799998e-01,  6.4230769230800000e-01, \
                                    6.4307692307700004e-01,  6.4384615384599997e-01,  6.4461538461500001e-01, \
                                    6.4538461538500003e-01,  6.4615384615399996e-01,  6.4692307692300000e-01, \
                                    6.4769230769200004e-01,  6.4846153846200005e-01,  6.4923076923099998e-01, \
                                    6.5000000000000002e-01,  6.5076923076899995e-01,  6.5153846153799999e-01, \
                                    6.5230769230800001e-01,  6.5307692307700005e-01,  6.5384615384599998e-01, \
                                    6.5461538461500002e-01,  6.5538461538500004e-01,  6.5615384615399996e-01, \
                                    6.5692307692300000e-01,  6.5769230769200004e-01,  6.5846153846199995e-01, \
                                    6.5923076923099999e-01,  6.6000000000000003e-01,  6.6076923076899996e-01, \
                                    6.6153846153800000e-01,  6.6230769230800002e-01,  6.6307692307699995e-01, \
                                    6.6384615384599999e-01,  6.6461538461500003e-01,  6.6538461538500004e-01, \
                                    6.6615384615399997e-01,  6.6692307692300001e-01,  6.6769230769200005e-01, \
                                    6.6846153846199996e-01,  6.6923076923100000e-01,  6.7000000000000004e-01, \
                                    6.7076923076899997e-01,  6.7153846153800001e-01,  6.7230769230800003e-01, \
                                    6.7307692307699996e-01,  6.7384615384600000e-01,  6.7461538461500004e-01, \
                                    6.7538461538500005e-01,  6.7615384615399998e-01,  6.7692307692300002e-01, \
                                    6.7769230769199995e-01,  6.7846153846199997e-01,  6.7923076923100001e-01, \
                                    6.8000000000000005e-01,  6.8076923076899998e-01,  6.8153846153800002e-01, \
                                    6.8230769230800004e-01,  6.8307692307699996e-01,  6.8384615384600000e-01, \
                                    6.8461538461500004e-01,  6.8538461538499995e-01,  6.8615384615399999e-01, \
                                    6.8692307692300003e-01,  6.8769230769199996e-01,  6.8846153846199998e-01, \
                                    6.8923076923100002e-01,  6.8999999999999995e-01,  6.9076923076899999e-01, \
                                    6.9153846153800003e-01,  6.9230769230800004e-01,  6.9307692307699997e-01, \
                                    6.9384615384600001e-01,  6.9461538461500005e-01,  6.9538461538499996e-01, \
                                    6.9615384615400000e-01,  6.9692307692300004e-01,  6.9769230769199997e-01, \
                                    6.9846153846199999e-01,  6.9923076923100003e-01,  6.9999999999999996e-01, \
                                    7.0076923076900000e-01,  7.0153846153800004e-01,  7.0230769230800005e-01, \
                                    7.0307692307699998e-01,  7.0384615384600002e-01,  7.0461538461499995e-01, \
                                    7.0538461538499997e-01,  7.0615384615400001e-01,  7.0692307692300005e-01, \
                                    7.0769230769199998e-01,  7.0846153846200000e-01,  7.0923076923100004e-01, \
                                    7.0999999999999996e-01,  7.1076923076900000e-01,  7.1153846153800004e-01, \
                                    7.1230769230799995e-01,  7.1307692307699999e-01,  7.1384615384600003e-01, \
                                    7.1461538461499996e-01,  7.1538461538499998e-01,  7.1615384615400002e-01, \
                                    7.1692307692299995e-01,  7.1769230769199999e-01,  7.1846153846200000e-01, \
                                    7.1923076923100004e-01,  7.1999999999999997e-01,  7.2076923076900001e-01, \
                                    7.2153846153800005e-01,  7.2230769230799996e-01,  7.2307692307700000e-01, \
                                    7.2384615384600004e-01,  7.2461538461499997e-01,  7.2538461538499999e-01, \
                                    7.2615384615400003e-01,  7.2692307692299996e-01,  7.2769230769200000e-01, \
                                    7.2846153846200001e-01,  7.2923076923100005e-01,  7.2999999999999998e-01, \
                                    7.3076923076900002e-01,  7.3153846153799995e-01,  7.3230769230799997e-01, \
                                    7.3307692307700001e-01,  7.3384615384600005e-01,  7.3461538461499998e-01, \
                                    7.3538461538500000e-01,  7.3615384615400004e-01,  7.3692307692299996e-01, \
                                    7.3769230769200000e-01,  7.3846153846100004e-01,  7.3923076923099995e-01, \
                                    7.3999999999999999e-01,  7.4076923076900003e-01,  7.4153846153799996e-01, \
                                    7.4230769230799998e-01,  7.4307692307700002e-01,  7.4384615384599995e-01, \
                                    7.4461538461499999e-01,  7.4538461538500000e-01,  7.4615384615400004e-01, \
                                    7.4692307692299997e-01,  7.4769230769200001e-01,  7.4846153846100005e-01, \
                                    7.4923076923099996e-01,  7.5000000000000000e-01,  7.5076923076900004e-01, \
                                    7.5153846153799997e-01,  7.5230769230799999e-01,  7.5307692307700003e-01, \
                                    7.5384615384599996e-01,  7.5461538461500000e-01,  7.5538461538500001e-01, \
                                    7.5615384615400005e-01,  7.5692307692299998e-01,  7.5769230769200002e-01, \
                                    7.5846153846099995e-01,  7.5923076923099997e-01,  7.6000000000000001e-01, \
                                    7.6076923076900005e-01,  7.6153846153799998e-01,  7.6230769230800000e-01, \
                                    7.6307692307700004e-01,  7.6384615384599996e-01,  7.6461538461500000e-01, \
                                    7.6538461538500002e-01,  7.6615384615399995e-01,  7.6692307692299999e-01, \
                                    7.6769230769200003e-01,  7.6846153846099996e-01,  7.6923076923099998e-01, \
                                    7.7000000000000002e-01,  7.7076923076899995e-01,  7.7153846153799999e-01, \
                                    7.7230769230800000e-01,  7.7307692307700004e-01,  7.7384615384599997e-01, \
                                    7.7461538461500001e-01,  7.7538461538500003e-01,  7.7615384615399996e-01, \
                                    7.7692307692300000e-01,  7.7769230769200004e-01,  7.7846153846099997e-01, \
                                    7.7923076923099999e-01,  7.8000000000000003e-01,  7.8076923076899996e-01, \
                                    7.8153846153800000e-01,  7.8230769230800001e-01,  7.8307692307700005e-01, \
                                    7.8384615384599998e-01,  7.8461538461500002e-01,  7.8538461538500004e-01, \
                                    7.8615384615399997e-01,  7.8692307692300001e-01,  7.8769230769200005e-01, \
                                    7.8846153846099998e-01,  7.8923076923100000e-01,  7.9000000000000004e-01, \
                                    7.9076923076899996e-01,  7.9153846153800000e-01,  7.9230769230800002e-01, \
                                    7.9307692307699995e-01,  7.9384615384599999e-01,  7.9461538461500003e-01, \
                                    7.9538461538500005e-01,  7.9615384615399998e-01,  7.9692307692300002e-01, \
                                    7.9769230769199995e-01,  7.9846153846099999e-01,  7.9923076923100000e-01, \
                                    8.0000000000000004e-01,  8.0076923076899997e-01,  8.0153846153800001e-01, \
                                    8.0230769230800003e-01,  8.0307692307699996e-01,  8.0384615384600000e-01, \
                                    8.0461538461500004e-01,  8.0538461538499995e-01,  8.0615384615399999e-01, \
                                    8.0692307692300003e-01,  8.0769230769199996e-01,  8.0846153846100000e-01, \
                                    8.0923076923100001e-01,  8.1000000000000005e-01,  8.1076923076899998e-01, \
                                    8.1153846153800002e-01,  8.1230769230800004e-01,  8.1307692307699997e-01, \
                                    8.1384615384600001e-01,  8.1461538461500005e-01,  8.1538461538499996e-01, \
                                    8.1615384615400000e-01,  8.1692307692300004e-01,  8.1769230769199996e-01, \
                                    8.1846153846100000e-01,  8.1923076923100002e-01,  8.1999999999999995e-01, \
                                    8.2076923076899999e-01,  8.2153846153800003e-01,  8.2230769230800005e-01, \
                                    8.2307692307699998e-01,  8.2384615384600002e-01,  8.2461538461499995e-01, \
                                    8.2538461538499996e-01,  8.2615384615400000e-01,  8.2692307692300004e-01, \
                                    8.2769230769199997e-01,  8.2846153846100001e-01,  8.2923076923100003e-01, \
                                    8.2999999999999996e-01,  8.3076923076900000e-01,  8.3153846153800004e-01, \
                                    8.3230769230799995e-01,  8.3307692307699999e-01,  8.3384615384600003e-01, \
                                    8.3461538461499996e-01,  8.3538461538499997e-01,  8.3615384615400001e-01, \
                                    8.3692307692300005e-01,  8.3769230769199998e-01,  8.3846153846100002e-01, \
                                    8.3923076923100004e-01,  8.3999999999999997e-01,  8.4076923076900001e-01, \
                                    8.4153846153800005e-01,  8.4230769230799996e-01,  8.4307692307700000e-01, \
                                    8.4384615384600004e-01,  8.4461538461499996e-01,  8.4538461538499998e-01, \
                                    8.4615384615400002e-01,  8.4692307692299995e-01,  8.4769230769199999e-01, \
                                    8.4846153846100003e-01,  8.4923076923100005e-01,  8.4999999999999998e-01, \
                                    8.5076923076900002e-01,  8.5153846153799995e-01,  8.5230769230799996e-01, \
                                    8.5307692307700000e-01,  8.5384615384600004e-01,  8.5461538461499997e-01, \
                                    8.5538461538499999e-01,  8.5615384615400003e-01,  8.5692307692299996e-01, \
                                    8.5769230769200000e-01,  8.5846153846100004e-01,  8.5923076923099995e-01, \
                                    8.5999999999999999e-01,  8.6076923076900003e-01,  8.6153846153799996e-01, \
                                    8.6230769230799997e-01,  8.6307692307700001e-01,  8.6384615384600005e-01, \
                                    8.6461538461499998e-01,  8.6538461538500000e-01,  8.6615384615400004e-01, \
                                    8.6692307692299997e-01,  8.6769230769200001e-01,  8.6846153846100005e-01, \
                                    8.6923076923099996e-01,  8.7000000000000000e-01,  8.7076923076900004e-01, \
                                    8.7153846153799996e-01,  8.7230769230799998e-01,  8.7307692307700002e-01, \
                                    8.7384615384599995e-01,  8.7461538461499999e-01,  8.7538461538500001e-01, \
                                    8.7615384615400005e-01,  8.7692307692299998e-01,  8.7769230769200002e-01, \
                                    8.7846153846099995e-01,  8.7923076923099996e-01,  8.8000000000000000e-01, \
                                    8.8076923076900004e-01,  8.8153846153799997e-01,  8.8230769230799999e-01, \
                                    8.8307692307700003e-01,  8.8384615384599996e-01,  8.8461538461500000e-01, \
                                    8.8538461538500002e-01,  8.8615384615399995e-01,  8.8692307692299999e-01, \
                                    8.8769230769200003e-01,  8.8846153846099996e-01,  8.8923076923099997e-01, \
                                    8.9000000000000001e-01,  8.9076923076900005e-01,  8.9153846153799998e-01, \
                                    8.9230769230800000e-01,  8.9307692307700004e-01,  8.9384615384599997e-01, \
                                    8.9461538461500001e-01,  8.9538461538500003e-01,  8.9615384615399996e-01, \
                                    8.9692307692300000e-01,  8.9769230769200004e-01,  8.9846153846099996e-01, \
                                    8.9923076923099998e-01,  9.0000000000000002e-01,  9.0076923076899995e-01, \
                                    9.0153846153799999e-01,  9.0230769230800001e-01,  9.0307692307700005e-01, \
                                    9.0384615384599998e-01,  9.0461538461500002e-01,  9.0538461538500004e-01, \
                                    9.0615384615399996e-01,  9.0692307692300000e-01,  9.0769230769200004e-01, \
                                    9.0846153846099997e-01,  9.0923076923099999e-01,  9.1000000000000003e-01, \
                                    9.1076923076899996e-01,  9.1153846153800000e-01,  9.1230769230800002e-01, \
                                    9.1307692307699995e-01,  9.1384615384599999e-01,  9.1461538461500003e-01, \
                                    9.1538461538500004e-01,  9.1615384615399997e-01,  9.1692307692300001e-01, \
                                    9.1769230769200005e-01,  9.1846153846099998e-01,  9.1923076923100000e-01, \
                                    9.2000000000000004e-01,  9.2076923076899997e-01,  9.2153846153800001e-01, \
                                    9.2230769230800003e-01,  9.2307692307699996e-01,  9.2384615384600000e-01, \
                                    9.2461538461500004e-01,  9.2538461538500005e-01,  9.2615384615399998e-01, \
                                    9.2692307692300002e-01,  9.2769230769199995e-01,  9.2846153846099999e-01, \
                                    9.2923076923100001e-01,  9.3000000000000005e-01,  9.3076923076899998e-01, \
                                    9.3153846153800002e-01,  9.3230769230800004e-01,  9.3307692307699996e-01, \
                                    9.3384615384600000e-01,  9.3461538461500004e-01,  9.3538461538499995e-01, \
                                    9.3615384615399999e-01,  9.3692307692300003e-01,  9.3769230769199996e-01, \
                                    9.3846153846100000e-01,  9.3923076923100002e-01,  9.3999999999999995e-01, \
                                    9.4076923076899999e-01,  9.4153846153800003e-01,  9.4230769230800004e-01, \
                                    9.4307692307699997e-01,  9.4384615384600001e-01,  9.4461538461500005e-01, \
                                    9.4538461538499996e-01,  9.4615384615400000e-01,  9.4692307692300004e-01, \
                                    9.4769230769199997e-01,  9.4846153846100001e-01,  9.4923076923100003e-01, \
                                    9.4999999999999996e-01,  9.5076923076900000e-01,  9.5153846153800004e-01, \
                                    9.5230769230800005e-01,  9.5307692307699998e-01,  9.5384615384600002e-01, \
                                    9.5461538461499995e-01,  9.5538461538499997e-01,  9.5615384615400001e-01, \
                                    9.5692307692300005e-01,  9.5769230769199998e-01,  9.5846153846100002e-01, \
                                    9.5923076923100004e-01,  9.5999999999999996e-01,  9.6076923076900000e-01, \
                                    9.6153846153800004e-01,  9.6230769230799995e-01,  9.6307692307699999e-01, \
                                    9.6384615384600003e-01,  9.6461538461499996e-01,  9.6538461538499998e-01, \
                                    9.6615384615400002e-01,  9.6692307692299995e-01,  9.6769230769199999e-01, \
                                    9.6846153846100003e-01,  9.6923076923100004e-01,  9.6999999999999997e-01, \
                                    9.7076923076900001e-01,  9.7153846153800005e-01,  9.7230769230799996e-01, \
                                    9.7307692307700000e-01,  9.7384615384600004e-01,  9.7461538461499997e-01, \
                                    9.7538461538499999e-01,  9.7615384615400003e-01,  9.7692307692299996e-01, \
                                    9.7769230769200000e-01,  9.7846153846100004e-01,  9.7923076923100005e-01, \
                                    9.7999999999999998e-01,  9.8076923076900002e-01,  9.8153846153799995e-01, \
                                    9.8230769230799997e-01,  9.8307692307700001e-01,  9.8384615384600005e-01, \
                                    9.8461538461499998e-01,  9.8538461538500000e-01,  9.8615384615400004e-01, \
                                    9.8692307692299996e-01,  9.8769230769200000e-01,  9.8846153846100004e-01, \
                                    9.8923076923099995e-01,  9.8999999999999999e-01,  9.9076923076900003e-01, \
                                    9.9153846153799996e-01,  9.9230769230799998e-01,  9.9307692307700002e-01, \
                                    9.9384615384599995e-01,  9.9461538461499999e-01,  9.9538461538500000e-01, \
                                    9.9615384615400004e-01,  9.9692307692299997e-01,  9.9769230769200001e-01, \
                                    9.9846153846100005e-01,  9.9923076923099996e-01,  1.0000000000000000e+00, \
                                    -1.0000000000000000e+00, -9.9931623931600000e-01, -9.9863247863200000e-01, \
                                    -9.9794871794899997e-01, -9.9726495726499997e-01, -9.9658119658099997e-01, \
                                    -9.9589743589699997e-01, -9.9521367521399995e-01, -9.9452991452999995e-01, \
                                    -9.9384615384599995e-01, -9.9316239316199995e-01, -9.9247863247900003e-01, \
                                    -9.9179487179500003e-01, -9.9111111111100003e-01, -9.9042735042700003e-01, \
                                    -9.8974358974400001e-01, -9.8905982906000001e-01, -9.8837606837600001e-01, \
                                    -9.8769230769200000e-01, -9.8700854700899998e-01, -9.8632478632499998e-01, \
                                    -9.8564102564099998e-01, -9.8495726495699998e-01, -9.8427350427399996e-01, \
                                    -9.8358974358999995e-01, -9.8290598290599995e-01, -9.8222222222199995e-01, \
                                    -9.8153846153799995e-01, -9.8085470085500004e-01, -9.8017094017100004e-01, \
                                    -9.7948717948700004e-01, -9.7880341880300004e-01, -9.7811965812000001e-01, \
                                    -9.7743589743600001e-01, -9.7675213675200001e-01, -9.7606837606800001e-01, \
                                    -9.7538461538499999e-01, -9.7470085470099999e-01, -9.7401709401699998e-01, \
                                    -9.7333333333299998e-01, -9.7264957264999996e-01, -9.7196581196599996e-01, \
                                    -9.7128205128199996e-01, -9.7059829059799996e-01, -9.6991452991500005e-01, \
                                    -9.6923076923100004e-01, -9.6854700854700004e-01, -9.6786324786300004e-01, \
                                    -9.6717948717900004e-01, -9.6649572649600002e-01, -9.6581196581200002e-01, \
                                    -9.6512820512800002e-01, -9.6444444444400002e-01, -9.6376068376099999e-01, \
                                    -9.6307692307699999e-01, -9.6239316239299999e-01, -9.6170940170899999e-01, \
                                    -9.6102564102599997e-01, -9.6034188034199996e-01, -9.5965811965799996e-01, \
                                    -9.5897435897399996e-01, -9.5829059829100005e-01, -9.5760683760700005e-01, \
                                    -9.5692307692300005e-01, -9.5623931623900005e-01, -9.5555555555600002e-01, \
                                    -9.5487179487200002e-01, -9.5418803418800002e-01, -9.5350427350400002e-01, \
                                    -9.5282051282100000e-01, -9.5213675213700000e-01, -9.5145299145300000e-01, \
                                    -9.5076923076900000e-01, -9.5008547008499999e-01, -9.4940170940199997e-01, \
                                    -9.4871794871799997e-01, -9.4803418803399997e-01, -9.4735042734999997e-01, \
                                    -9.4666666666699995e-01, -9.4598290598300006e-01, -9.4529914529900005e-01, \
                                    -9.4461538461500005e-01, -9.4393162393200003e-01, -9.4324786324800003e-01, \
                                    -9.4256410256400003e-01, -9.4188034188000003e-01, -9.4119658119700000e-01, \
                                    -9.4051282051300000e-01, -9.3982905982900000e-01, -9.3914529914500000e-01, \
                                    -9.3846153846199998e-01, -9.3777777777799998e-01, -9.3709401709399998e-01, \
                                    -9.3641025640999997e-01, -9.3572649572699995e-01, -9.3504273504299995e-01, \
                                    -9.3435897435899995e-01, -9.3367521367499995e-01, -9.3299145299099995e-01, \
                                    -9.3230769230800004e-01, -9.3162393162400003e-01, -9.3094017094000003e-01, \
                                    -9.3025641025600003e-01, -9.2957264957300001e-01, -9.2888888888900001e-01, \
                                    -9.2820512820500001e-01, -9.2752136752100001e-01, -9.2683760683799998e-01, \
                                    -9.2615384615399998e-01, -9.2547008546999998e-01, -9.2478632478599998e-01, \
                                    -9.2410256410299996e-01, -9.2341880341899996e-01, -9.2273504273499996e-01, \
                                    -9.2205128205099995e-01, -9.2136752136800004e-01, -9.2068376068400004e-01, \
                                    -9.2000000000000004e-01, -9.1931623931600004e-01, -9.1863247863200004e-01, \
                                    -9.1794871794900001e-01, -9.1726495726500001e-01, -9.1658119658100001e-01, \
                                    -9.1589743589700001e-01, -9.1521367521399999e-01, -9.1452991452999999e-01, \
                                    -9.1384615384599999e-01, -9.1316239316199999e-01, -9.1247863247899996e-01, \
                                    -9.1179487179499996e-01, -9.1111111111099996e-01, -9.1042735042699996e-01, \
                                    -9.0974358974400005e-01, -9.0905982906000005e-01, -9.0837606837600005e-01, \
                                    -9.0769230769200004e-01, -9.0700854700900002e-01, -9.0632478632500002e-01, \
                                    -9.0564102564100002e-01, -9.0495726495700002e-01, -9.0427350427400000e-01, \
                                    -9.0358974358999999e-01, -9.0290598290599999e-01, -9.0222222222199999e-01, \
                                    -9.0153846153799999e-01, -9.0085470085499997e-01, -9.0017094017099997e-01, \
                                    -8.9948717948699997e-01, -8.9880341880299996e-01, -8.9811965812000005e-01, \
                                    -8.9743589743600005e-01, -8.9675213675200005e-01, -8.9606837606800005e-01, \
                                    -8.9538461538500003e-01, -8.9470085470100003e-01, -8.9401709401700002e-01, \
                                    -8.9333333333300002e-01, -8.9264957265000000e-01, -8.9196581196600000e-01, \
                                    -8.9128205128200000e-01, -8.9059829059800000e-01, -8.8991452991499997e-01, \
                                    -8.8923076923099997e-01, -8.8854700854699997e-01, -8.8786324786299997e-01, \
                                    -8.8717948717899997e-01, -8.8649572649599995e-01, -8.8581196581199995e-01, \
                                    -8.8512820512799995e-01, -8.8444444444400006e-01, -8.8376068376100003e-01, \
                                    -8.8307692307700003e-01, -8.8239316239300003e-01, -8.8170940170900003e-01, \
                                    -8.8102564102600001e-01, -8.8034188034200000e-01, -8.7965811965800000e-01, \
                                    -8.7897435897400000e-01, -8.7829059829099998e-01, -8.7760683760699998e-01, \
                                    -8.7692307692299998e-01, -8.7623931623899998e-01, -8.7555555555599995e-01, \
                                    -8.7487179487199995e-01, -8.7418803418799995e-01, -8.7350427350399995e-01, \
                                    -8.7282051282100004e-01, -8.7213675213700004e-01, -8.7145299145300004e-01, \
                                    -8.7076923076900004e-01, -8.7008547008500003e-01, -8.6940170940200001e-01, \
                                    -8.6871794871800001e-01, -8.6803418803400001e-01, -8.6735042735000001e-01, \
                                    -8.6666666666699999e-01, -8.6598290598299998e-01, -8.6529914529899998e-01, \
                                    -8.6461538461499998e-01, -8.6393162393199996e-01, -8.6324786324799996e-01, \
                                    -8.6256410256399996e-01, -8.6188034187999996e-01, -8.6119658119700004e-01, \
                                    -8.6051282051300004e-01, -8.5982905982900004e-01, -8.5914529914500004e-01, \
                                    -8.5846153846200002e-01, -8.5777777777800002e-01, -8.5709401709400002e-01, \
                                    -8.5641025641000001e-01, -8.5572649572699999e-01, -8.5504273504299999e-01, \
                                    -8.5435897435899999e-01, -8.5367521367499999e-01, -8.5299145299099999e-01, \
                                    -8.5230769230799996e-01, -8.5162393162399996e-01, -8.5094017093999996e-01, \
                                    -8.5025641025599996e-01, -8.4957264957300005e-01, -8.4888888888900005e-01, \
                                    -8.4820512820500005e-01, -8.4752136752100005e-01, -8.4683760683800002e-01, \
                                    -8.4615384615400002e-01, -8.4547008547000002e-01, -8.4478632478600002e-01, \
                                    -8.4410256410300000e-01, -8.4341880341900000e-01, -8.4273504273500000e-01, \
                                    -8.4205128205099999e-01, -8.4136752136799997e-01, -8.4068376068399997e-01, \
                                    -8.3999999999999997e-01, -8.3931623931599997e-01, -8.3863247863199997e-01, \
                                    -8.3794871794900005e-01, -8.3726495726500005e-01, -8.3658119658100005e-01, \
                                    -8.3589743589700005e-01, -8.3521367521400003e-01, -8.3452991453000003e-01, \
                                    -8.3384615384600003e-01, -8.3316239316200003e-01, -8.3247863247900000e-01, \
                                    -8.3179487179500000e-01, -8.3111111111100000e-01, -8.3042735042700000e-01, \
                                    -8.2974358974399998e-01, -8.2905982905999998e-01, -8.2837606837599997e-01, \
                                    -8.2769230769199997e-01, -8.2700854700899995e-01, -8.2632478632499995e-01, \
                                    -8.2564102564099995e-01, -8.2495726495699995e-01, -8.2427350427400004e-01, \
                                    -8.2358974359000003e-01, -8.2290598290600003e-01, -8.2222222222200003e-01, \
                                    -8.2153846153800003e-01, -8.2085470085500001e-01, -8.2017094017100001e-01, \
                                    -8.1948717948700001e-01, -8.1880341880300000e-01, -8.1811965811999998e-01, \
                                    -8.1743589743599998e-01, -8.1675213675199998e-01, -8.1606837606799998e-01, \
                                    -8.1538461538499996e-01, -8.1470085470099995e-01, -8.1401709401699995e-01, \
                                    -8.1333333333299995e-01, -8.1264957265000004e-01, -8.1196581196600004e-01, \
                                    -8.1128205128200004e-01, -8.1059829059800004e-01, -8.0991452991500001e-01, \
                                    -8.0923076923100001e-01, -8.0854700854700001e-01, -8.0786324786300001e-01, \
                                    -8.0717948717999999e-01, -8.0649572649599999e-01, -8.0581196581199999e-01, \
                                    -8.0512820512799999e-01, -8.0444444444399998e-01, -8.0376068376099996e-01, \
                                    -8.0307692307699996e-01, -8.0239316239299996e-01, -8.0170940170899996e-01, \
                                    -8.0102564102600005e-01, -8.0034188034200004e-01, -7.9965811965800004e-01, \
                                    -7.9897435897400004e-01, -7.9829059829100002e-01, -7.9760683760700002e-01, \
                                    -7.9692307692300002e-01, -7.9623931623900002e-01, -7.9555555555599999e-01, \
                                    -7.9487179487199999e-01, -7.9418803418799999e-01, -7.9350427350399999e-01, \
                                    -7.9282051282099997e-01, -7.9213675213699997e-01, -7.9145299145299997e-01, \
                                    -7.9076923076899996e-01, -7.9008547008499996e-01, -7.8940170940200005e-01, \
                                    -7.8871794871800005e-01, -7.8803418803400005e-01, -7.8735042735000005e-01, \
                                    -7.8666666666700003e-01, -7.8598290598300002e-01, -7.8529914529900002e-01, \
                                    -7.8461538461500002e-01, -7.8393162393200000e-01, -7.8324786324800000e-01, \
                                    -7.8256410256400000e-01, -7.8188034188000000e-01, -7.8119658119699997e-01, \
                                    -7.8051282051299997e-01, -7.7982905982899997e-01, -7.7914529914499997e-01, \
                                    -7.7846153846199995e-01, -7.7777777777799995e-01, -7.7709401709399994e-01, \
                                    -7.7641025641000005e-01, -7.7572649572700003e-01, -7.7504273504300003e-01, \
                                    -7.7435897435900003e-01, -7.7367521367500003e-01, -7.7299145299100003e-01, \
                                    -7.7230769230800000e-01, -7.7162393162400000e-01, -7.7094017094000000e-01, \
                                    -7.7025641025600000e-01, -7.6957264957299998e-01, -7.6888888888899998e-01, \
                                    -7.6820512820499998e-01, -7.6752136752099998e-01, -7.6683760683799995e-01, \
                                    -7.6615384615399995e-01, -7.6547008546999995e-01, -7.6478632478599995e-01, \
                                    -7.6410256410300004e-01, -7.6341880341900004e-01, -7.6273504273500004e-01, \
                                    -7.6205128205100003e-01, -7.6136752136800001e-01, -7.6068376068400001e-01, \
                                    -7.6000000000000001e-01, -7.5931623931600001e-01, -7.5863247863200001e-01, \
                                    -7.5794871794899998e-01, -7.5726495726499998e-01, -7.5658119658099998e-01, \
                                    -7.5589743589699998e-01, -7.5521367521399996e-01, -7.5452991452999996e-01, \
                                    -7.5384615384599996e-01, -7.5316239316199995e-01, -7.5247863247900004e-01, \
                                    -7.5179487179500004e-01, -7.5111111111100004e-01, -7.5042735042700004e-01, \
                                    -7.4974358974400002e-01, -7.4905982906000002e-01, -7.4837606837600001e-01, \
                                    -7.4769230769200001e-01, -7.4700854700899999e-01, -7.4632478632499999e-01, \
                                    -7.4564102564099999e-01, -7.4495726495699999e-01, -7.4427350427399996e-01, \
                                    -7.4358974358999996e-01, -7.4290598290599996e-01, -7.4222222222199996e-01, \
                                    -7.4153846153799996e-01, -7.4085470085500005e-01, -7.4017094017100005e-01, \
                                    -7.3948717948700005e-01, -7.3880341880300004e-01, -7.3811965812000002e-01, \
                                    -7.3743589743600002e-01, -7.3675213675200002e-01, -7.3606837606800002e-01, \
                                    -7.3538461538500000e-01, -7.3470085470099999e-01, -7.3401709401699999e-01, \
                                    -7.3333333333299999e-01, -7.3264957264999997e-01, -7.3196581196599997e-01, \
                                    -7.3128205128199997e-01, -7.3059829059799997e-01, -7.2991452991500005e-01, \
                                    -7.2923076923100005e-01, -7.2854700854700005e-01, -7.2786324786300005e-01, \
                                    -7.2717948718000003e-01, -7.2649572649600003e-01, -7.2581196581200003e-01, \
                                    -7.2512820512800003e-01, -7.2444444444400002e-01, -7.2376068376100000e-01, \
                                    -7.2307692307700000e-01, -7.2239316239300000e-01, -7.2170940170900000e-01, \
                                    -7.2102564102599997e-01, -7.2034188034199997e-01, -7.1965811965799997e-01, \
                                    -7.1897435897399997e-01, -7.1829059829099995e-01, -7.1760683760699995e-01, \
                                    -7.1692307692299995e-01, -7.1623931623899995e-01, -7.1555555555600003e-01, \
                                    -7.1487179487200003e-01, -7.1418803418800003e-01, -7.1350427350400003e-01, \
                                    -7.1282051282100001e-01, -7.1213675213700001e-01, -7.1145299145300001e-01, \
                                    -7.1076923076900000e-01, -7.1008547008500000e-01, -7.0940170940199998e-01, \
                                    -7.0871794871799998e-01, -7.0803418803399998e-01, -7.0735042734999998e-01, \
                                    -7.0666666666699995e-01, -7.0598290598299995e-01, -7.0529914529899995e-01, \
                                    -7.0461538461499995e-01, -7.0393162393200004e-01, -7.0324786324800004e-01, \
                                    -7.0256410256400004e-01, -7.0188034188000004e-01, -7.0119658119700001e-01, \
                                    -7.0051282051300001e-01, -6.9982905982900001e-01, -6.9914529914500001e-01, \
                                    -6.9846153846199999e-01, -6.9777777777799999e-01, -6.9709401709399998e-01, \
                                    -6.9641025640999998e-01, -6.9572649572699996e-01, -6.9504273504299996e-01, \
                                    -6.9435897435899996e-01, -6.9367521367499996e-01, -6.9299145299099996e-01, \
                                    -6.9230769230800004e-01, -6.9162393162400004e-01, -6.9094017094000004e-01, \
                                    -6.9025641025600004e-01, -6.8957264957300002e-01, -6.8888888888900002e-01, \
                                    -6.8820512820500002e-01, -6.8752136752100002e-01, -6.8683760683799999e-01, \
                                    -6.8615384615399999e-01, -6.8547008546999999e-01, -6.8478632478599999e-01, \
                                    -6.8410256410299997e-01, -6.8341880341899996e-01, -6.8273504273499996e-01, \
                                    -6.8205128205099996e-01, -6.8136752136800005e-01, -6.8068376068400005e-01, \
                                    -6.8000000000000005e-01, -6.7931623931600005e-01, -6.7863247863300002e-01, \
                                    -6.7794871794900002e-01, -6.7726495726500002e-01, -6.7658119658100002e-01, \
                                    -6.7589743589700002e-01, -6.7521367521400000e-01, -6.7452991453000000e-01, \
                                    -6.7384615384600000e-01, -6.7316239316199999e-01, -6.7247863247899997e-01, \
                                    -6.7179487179499997e-01, -6.7111111111099997e-01, -6.7042735042699997e-01, \
                                    -6.6974358974399995e-01, -6.6905982906000006e-01, -6.6837606837600005e-01, \
                                    -6.6769230769200005e-01, -6.6700854700900003e-01, -6.6632478632500003e-01, \
                                    -6.6564102564100003e-01, -6.6495726495700003e-01, -6.6427350427400000e-01, \
                                    -6.6358974359000000e-01, -6.6290598290600000e-01, -6.6222222222200000e-01, \
                                    -6.6153846153800000e-01, -6.6085470085499998e-01, -6.6017094017099998e-01, \
                                    -6.5948717948699997e-01, -6.5880341880299997e-01, -6.5811965811999995e-01, \
                                    -6.5743589743599995e-01, -6.5675213675199995e-01, -6.5606837606799995e-01, \
                                    -6.5538461538500004e-01, -6.5470085470100003e-01, -6.5401709401700003e-01, \
                                    -6.5333333333300003e-01, -6.5264957265000001e-01, -6.5196581196600001e-01, \
                                    -6.5128205128200001e-01, -6.5059829059800001e-01, -6.4991452991499998e-01, \
                                    -6.4923076923099998e-01, -6.4854700854699998e-01, -6.4786324786299998e-01, \
                                    -6.4717948717999996e-01, -6.4649572649599996e-01, -6.4581196581199996e-01, \
                                    -6.4512820512799995e-01, -6.4444444444399995e-01, -6.4376068376100004e-01, \
                                    -6.4307692307700004e-01, -6.4239316239300004e-01, -6.4170940170900004e-01, \
                                    -6.4102564102600001e-01, -6.4034188034200001e-01, -6.3965811965800001e-01, \
                                    -6.3897435897400001e-01, -6.3829059829099999e-01, -6.3760683760699999e-01, \
                                    -6.3692307692299999e-01, -6.3623931623899999e-01, -6.3555555555599996e-01, \
                                    -6.3487179487199996e-01, -6.3418803418799996e-01, -6.3350427350399996e-01, \
                                    -6.3282051282100005e-01, -6.3213675213700005e-01, -6.3145299145300005e-01, \
                                    -6.3076923076900004e-01, -6.3008547008500004e-01, -6.2940170940200002e-01, \
                                    -6.2871794871800002e-01, -6.2803418803400002e-01, -6.2735042735000002e-01, \
                                    -6.2666666666699999e-01, -6.2598290598299999e-01, -6.2529914529899999e-01, \
                                    -6.2461538461499999e-01, -6.2393162393199997e-01, -6.2324786324799997e-01, \
                                    -6.2256410256399997e-01, -6.2188034187999996e-01, -6.2119658119700005e-01, \
                                    -6.2051282051300005e-01, -6.1982905982900005e-01, -6.1914529914500005e-01, \
                                    -6.1846153846200003e-01, -6.1777777777800003e-01, -6.1709401709400002e-01, \
                                    -6.1641025641000002e-01, -6.1572649572700000e-01, -6.1504273504300000e-01, \
                                    -6.1435897435900000e-01, -6.1367521367500000e-01, -6.1299145299100000e-01, \
                                    -6.1230769230799997e-01, -6.1162393162399997e-01, -6.1094017093999997e-01, \
                                    -6.1025641025599997e-01, -6.0957264957299995e-01, -6.0888888888899995e-01, \
                                    -6.0820512820499995e-01, -6.0752136752100006e-01, -6.0683760683800003e-01, \
                                    -6.0615384615400003e-01, -6.0547008547000003e-01, -6.0478632478600003e-01, \
                                    -6.0410256410300001e-01, -6.0341880341900000e-01, -6.0273504273500000e-01, \
                                    -6.0205128205100000e-01, -6.0136752136799998e-01, -6.0068376068399998e-01, \
                                    -5.9999999999999998e-01, -5.9931623931599998e-01, -5.9863247863299995e-01, \
                                    -5.9794871794899995e-01, -5.9726495726499995e-01, -5.9658119658099995e-01, \
                                    -5.9589743589699995e-01, -5.9521367521400004e-01, -5.9452991453000004e-01, \
                                    -5.9384615384600004e-01, -5.9316239316200003e-01, -5.9247863247900001e-01, \
                                    -5.9179487179500001e-01, -5.9111111111100001e-01, -5.9042735042700001e-01, \
                                    -5.8974358974399999e-01, -5.8905982905999998e-01, -5.8837606837599998e-01, \
                                    -5.8769230769199998e-01, -5.8700854700899996e-01, -5.8632478632499996e-01, \
                                    -5.8564102564099996e-01, -5.8495726495699996e-01, -5.8427350427400004e-01, \
                                    -5.8358974359000004e-01, -5.8290598290600004e-01, -5.8222222222200004e-01, \
                                    -5.8153846153800004e-01, -5.8085470085500002e-01, -5.8017094017100002e-01, \
                                    -5.7948717948700001e-01, -5.7880341880300001e-01, -5.7811965811999999e-01, \
                                    -5.7743589743599999e-01, -5.7675213675199999e-01, -5.7606837606799999e-01, \
                                    -5.7538461538499996e-01, -5.7470085470099996e-01, -5.7401709401699996e-01, \
                                    -5.7333333333299996e-01, -5.7264957265000005e-01, -5.7196581196600005e-01, \
                                    -5.7128205128200005e-01, -5.7059829059800005e-01, -5.6991452991500002e-01, \
                                    -5.6923076923100002e-01, -5.6854700854700002e-01, -5.6786324786300002e-01, \
                                    -5.6717948718000000e-01, -5.6649572649600000e-01, -5.6581196581200000e-01, \
                                    -5.6512820512799999e-01, -5.6444444444399999e-01, -5.6376068376099997e-01, \
                                    -5.6307692307699997e-01, -5.6239316239299997e-01, -5.6170940170899997e-01, \
                                    -5.6102564102600005e-01, -5.6034188034200005e-01, -5.5965811965800005e-01, \
                                    -5.5897435897400005e-01, -5.5829059829100003e-01, -5.5760683760700003e-01, \
                                    -5.5692307692300003e-01, -5.5623931623900003e-01, -5.5555555555600000e-01, \
                                    -5.5487179487200000e-01, -5.5418803418800000e-01, -5.5350427350400000e-01, \
                                    -5.5282051282099998e-01, -5.5213675213699998e-01, -5.5145299145299997e-01, \
                                    -5.5076923076899997e-01, -5.5008547008599995e-01, -5.4940170940199995e-01, \
                                    -5.4871794871799995e-01, -5.4803418803399995e-01, -5.4735042734999995e-01, \
                                    -5.4666666666700003e-01, -5.4598290598300003e-01, -5.4529914529900003e-01, \
                                    -5.4461538461500003e-01, -5.4393162393200001e-01, -5.4324786324800001e-01, \
                                    -5.4256410256400001e-01, -5.4188034188000000e-01, -5.4119658119699998e-01, \
                                    -5.4051282051299998e-01, -5.3982905982899998e-01, -5.3914529914499998e-01, \
                                    -5.3846153846199996e-01, -5.3777777777799995e-01, -5.3709401709399995e-01, \
                                    -5.3641025640999995e-01, -5.3572649572700004e-01, -5.3504273504300004e-01, \
                                    -5.3435897435900004e-01, -5.3367521367500004e-01, -5.3299145299100004e-01, \
                                    -5.3230769230800001e-01, -5.3162393162400001e-01, -5.3094017094000001e-01, \
                                    -5.3025641025600001e-01, -5.2957264957299999e-01, -5.2888888888899999e-01, \
                                    -5.2820512820499999e-01, -5.2752136752099998e-01, -5.2683760683799996e-01, \
                                    -5.2615384615399996e-01, -5.2547008546999996e-01, -5.2478632478599996e-01, \
                                    -5.2410256410300005e-01, -5.2341880341900004e-01, -5.2273504273500004e-01, \
                                    -5.2205128205100004e-01, -5.2136752136800002e-01, -5.2068376068400002e-01, \
                                    -5.2000000000000002e-01, -5.1931623931600002e-01, -5.1863247863299999e-01, \
                                    -5.1794871794899999e-01, -5.1726495726499999e-01, -5.1658119658099999e-01, \
                                    -5.1589743589699999e-01, -5.1521367521399997e-01, -5.1452991452999997e-01, \
                                    -5.1384615384599996e-01, -5.1316239316199996e-01, -5.1247863247900005e-01, \
                                    -5.1179487179500005e-01, -5.1111111111100005e-01, -5.1042735042700005e-01, \
                                    -5.0974358974400003e-01, -5.0905982906000002e-01, -5.0837606837600002e-01, \
                                    -5.0769230769200002e-01, -5.0700854700900000e-01, -5.0632478632500000e-01, \
                                    -5.0564102564100000e-01, -5.0495726495700000e-01, -5.0427350427399997e-01, \
                                    -5.0358974358999997e-01, -5.0290598290599997e-01, -5.0222222222199997e-01, \
                                    -5.0153846153799997e-01, -5.0085470085499995e-01, -5.0017094017099994e-01, \
                                    -4.9948717948700000e-01, -4.9880341880300000e-01, -4.9811965811999998e-01, \
                                    -4.9743589743599997e-01, -4.9675213675199997e-01, -4.9606837606800003e-01, \
                                    -4.9538461538500000e-01, -4.9470085470100000e-01, -4.9401709401700000e-01, \
                                    -4.9333333333300000e-01, -4.9264957264999998e-01, -4.9196581196599998e-01, \
                                    -4.9128205128199998e-01, -4.9059829059799998e-01, -4.8991452991500001e-01, \
                                    -4.8923076923100001e-01, -4.8854700854700001e-01, -4.8786324786300000e-01, \
                                    -4.8717948717999998e-01, -4.8649572649599998e-01, -4.8581196581199998e-01, \
                                    -4.8512820512799998e-01, -4.8444444444399998e-01, -4.8376068376100001e-01, \
                                    -4.8307692307700001e-01, -4.8239316239300001e-01, -4.8170940170900001e-01, \
                                    -4.8102564102599998e-01, -4.8034188034199998e-01, -4.7965811965799998e-01, \
                                    -4.7897435897399998e-01, -4.7829059829100001e-01, -4.7760683760700001e-01, \
                                    -4.7692307692300001e-01, -4.7623931623900001e-01, -4.7555555555599999e-01, \
                                    -4.7487179487199999e-01, -4.7418803418799998e-01, -4.7350427350399998e-01, \
                                    -4.7282051282100002e-01, -4.7213675213700002e-01, -4.7145299145300001e-01, \
                                    -4.7076923076900001e-01, -4.7008547008599999e-01, -4.6940170940199999e-01, \
                                    -4.6871794871799999e-01, -4.6803418803399999e-01, -4.6735042734999999e-01, \
                                    -4.6666666666700002e-01, -4.6598290598300002e-01, -4.6529914529900002e-01, \
                                    -4.6461538461500002e-01, -4.6393162393199999e-01, -4.6324786324799999e-01, \
                                    -4.6256410256399999e-01, -4.6188034187999999e-01, -4.6119658119700002e-01, \
                                    -4.6051282051300002e-01, -4.5982905982900002e-01, -4.5914529914500002e-01, \
                                    -4.5846153846200000e-01, -4.5777777777799999e-01, -4.5709401709399999e-01, \
                                    -4.5641025640999999e-01, -4.5572649572700002e-01, -4.5504273504300002e-01, \
                                    -4.5435897435900002e-01, -4.5367521367500002e-01, -4.5299145299100002e-01, \
                                    -4.5230769230800000e-01, -4.5162393162400000e-01, -4.5094017094000000e-01, \
                                    -4.5025641025599999e-01, -4.4957264957300003e-01, -4.4888888888900003e-01, \
                                    -4.4820512820500003e-01, -4.4752136752100002e-01, -4.4683760683800000e-01, \
                                    -4.4615384615400000e-01, -4.4547008547000000e-01, -4.4478632478600000e-01, \
                                    -4.4410256410299997e-01, -4.4341880341899997e-01, -4.4273504273499997e-01, \
                                    -4.4205128205100003e-01, -4.4136752136800000e-01, -4.4068376068400000e-01, \
                                    -4.4000000000000000e-01, -4.3931623931600000e-01, -4.3863247863299998e-01, \
                                    -4.3794871794899998e-01, -4.3726495726499998e-01, -4.3658119658099998e-01, \
                                    -4.3589743589699997e-01, -4.3521367521400001e-01, -4.3452991453000001e-01, \
                                    -4.3384615384600000e-01, -4.3316239316200000e-01, -4.3247863247899998e-01, \
                                    -4.3179487179499998e-01, -4.3111111111099998e-01, -4.3042735042699998e-01, \
                                    -4.2974358974400001e-01, -4.2905982906000001e-01, -4.2837606837600001e-01, \
                                    -4.2769230769200001e-01, -4.2700854700899998e-01, -4.2632478632499998e-01, \
                                    -4.2564102564099998e-01, -4.2495726495699998e-01, -4.2427350427400001e-01, \
                                    -4.2358974359000001e-01, -4.2290598290600001e-01, -4.2222222222200001e-01, \
                                    -4.2153846153800001e-01, -4.2085470085499999e-01, -4.2017094017099998e-01, \
                                    -4.1948717948699998e-01, -4.1880341880299998e-01, -4.1811965812000002e-01, \
                                    -4.1743589743600001e-01, -4.1675213675200001e-01, -4.1606837606800001e-01, \
                                    -4.1538461538499999e-01, -4.1470085470099999e-01, -4.1401709401699999e-01, \
                                    -4.1333333333299999e-01, -4.1264957265000002e-01, -4.1196581196600002e-01, \
                                    -4.1128205128200002e-01, -4.1059829059800002e-01, -4.0991452991499999e-01, \
                                    -4.0923076923099999e-01, -4.0854700854699999e-01, -4.0786324786299999e-01, \
                                    -4.0717948718000002e-01, -4.0649572649600002e-01, -4.0581196581200002e-01, \
                                    -4.0512820512800002e-01, -4.0444444444400002e-01, -4.0376068376099999e-01, \
                                    -4.0307692307699999e-01, -4.0239316239299999e-01, -4.0170940170899999e-01, \
                                    -4.0102564102600002e-01, -4.0034188034200002e-01, -3.9965811965800002e-01, \
                                    -3.9897435897400002e-01, -3.9829059829100000e-01, -3.9760683760700000e-01, \
                                    -3.9692307692300000e-01, -3.9623931623899999e-01, -3.9555555555600003e-01, \
                                    -3.9487179487200003e-01, -3.9418803418800002e-01, -3.9350427350400002e-01, \
                                    -3.9282051282100000e-01, -3.9213675213700000e-01, -3.9145299145300000e-01, \
                                    -3.9076923076900000e-01, -3.9008547008599997e-01, -3.8940170940199997e-01, \
                                    -3.8871794871799997e-01, -3.8803418803400003e-01, -3.8735042735000003e-01, \
                                    -3.8666666666700000e-01, -3.8598290598300000e-01, -3.8529914529900000e-01, \
                                    -3.8461538461500000e-01, -3.8393162393199998e-01, -3.8324786324799998e-01, \
                                    -3.8256410256399997e-01, -3.8188034187999997e-01, -3.8119658119700001e-01, \
                                    -3.8051282051300001e-01, -3.7982905982900000e-01, -3.7914529914500000e-01, \
                                    -3.7846153846199998e-01, -3.7777777777799998e-01, -3.7709401709399998e-01, \
                                    -3.7641025640999998e-01, -3.7572649572700001e-01, -3.7504273504300001e-01, \
                                    -3.7435897435900001e-01, -3.7367521367500001e-01, -3.7299145299100001e-01, \
                                    -3.7230769230799998e-01, -3.7162393162399998e-01, -3.7094017093999998e-01, \
                                    -3.7025641025599998e-01, -3.6957264957300001e-01, -3.6888888888900001e-01, \
                                    -3.6820512820500001e-01, -3.6752136752100001e-01, -3.6683760683799999e-01, \
                                    -3.6615384615399998e-01, -3.6547008546999998e-01, -3.6478632478599998e-01, \
                                    -3.6410256410300001e-01, -3.6341880341900001e-01, -3.6273504273500001e-01, \
                                    -3.6205128205100001e-01, -3.6136752136799999e-01, -3.6068376068399999e-01, \
                                    -3.5999999999999999e-01, -3.5931623931599999e-01, -3.5863247863300002e-01, \
                                    -3.5794871794900002e-01, -3.5726495726500002e-01, -3.5658119658100002e-01, \
                                    -3.5589743589700001e-01, -3.5521367521399999e-01, -3.5452991452999999e-01, \
                                    -3.5384615384599999e-01, -3.5316239316199999e-01, -3.5247863247900002e-01, \
                                    -3.5179487179500002e-01, -3.5111111111100002e-01, -3.5042735042700002e-01, \
                                    -3.4974358974399999e-01, -3.4905982905999999e-01, -3.4837606837599999e-01, \
                                    -3.4769230769199999e-01, -3.4700854700900002e-01, -3.4632478632500002e-01, \
                                    -3.4564102564100002e-01, -3.4495726495700002e-01, -3.4427350427400000e-01, \
                                    -3.4358974359000000e-01, -3.4290598290600000e-01, -3.4222222222199999e-01, \
                                    -3.4153846153799999e-01, -3.4085470085500003e-01, -3.4017094017100002e-01, \
                                    -3.3948717948700002e-01, -3.3880341880300002e-01, -3.3811965812000000e-01, \
                                    -3.3743589743600000e-01, -3.3675213675200000e-01, -3.3606837606800000e-01, \
                                    -3.3538461538499997e-01, -3.3470085470099997e-01, -3.3401709401700003e-01, \
                                    -3.3333333333300003e-01, -3.3264957265000000e-01, -3.3196581196600000e-01, \
                                    -3.3128205128200000e-01, -3.3059829059800000e-01, -3.2991452991499998e-01, \
                                    -3.2923076923099998e-01, -3.2854700854699997e-01, -3.2786324786299997e-01, \
                                    -3.2717948718000001e-01, -3.2649572649600000e-01, -3.2581196581200000e-01, \
                                    -3.2512820512800000e-01, -3.2444444444400000e-01, -3.2376068376099998e-01, \
                                    -3.2307692307699998e-01, -3.2239316239299998e-01, -3.2170940170899998e-01, \
                                    -3.2102564102600001e-01, -3.2034188034200001e-01, -3.1965811965800001e-01, \
                                    -3.1897435897400001e-01, -3.1829059829099998e-01, -3.1760683760699998e-01, \
                                    -3.1692307692299998e-01, -3.1623931623899998e-01, -3.1555555555600001e-01, \
                                    -3.1487179487200001e-01, -3.1418803418800001e-01, -3.1350427350400001e-01, \
                                    -3.1282051282099999e-01, -3.1213675213699998e-01, -3.1145299145299998e-01, \
                                    -3.1076923076899998e-01, -3.1008547008600001e-01, -3.0940170940200001e-01, \
                                    -3.0871794871800001e-01, -3.0803418803400001e-01, -3.0735042735000001e-01, \
                                    -3.0666666666699999e-01, -3.0598290598299999e-01, -3.0529914529899999e-01, \
                                    -3.0461538461499998e-01, -3.0393162393200002e-01, -3.0324786324800002e-01, \
                                    -3.0256410256400001e-01, -3.0188034188000001e-01, -3.0119658119699999e-01, \
                                    -3.0051282051299999e-01, -2.9982905982899999e-01, -2.9914529914499999e-01, \
                                    -2.9846153846200002e-01, -2.9777777777800002e-01, -2.9709401709400002e-01, \
                                    -2.9641025641000002e-01, -2.9572649572699999e-01, -2.9504273504299999e-01, \
                                    -2.9435897435899999e-01, -2.9367521367499999e-01, -2.9299145299099999e-01, \
                                    -2.9230769230800002e-01, -2.9162393162400002e-01, -2.9094017094000002e-01, \
                                    -2.9025641025600002e-01, -2.8957264957300000e-01, -2.8888888888900000e-01, \
                                    -2.8820512820499999e-01, -2.8752136752099999e-01, -2.8683760683800003e-01, \
                                    -2.8615384615400002e-01, -2.8547008547000002e-01, -2.8478632478600002e-01, \
                                    -2.8410256410300000e-01, -2.8341880341900000e-01, -2.8273504273500000e-01, \
                                    -2.8205128205100000e-01, -2.8136752136799997e-01, -2.8068376068400003e-01, \
                                    -2.8000000000000003e-01, -2.7931623931600003e-01, -2.7863247863300000e-01, \
                                    -2.7794871794900000e-01, -2.7726495726500000e-01, -2.7658119658100000e-01, \
                                    -2.7589743589700000e-01, -2.7521367521399998e-01, -2.7452991452999997e-01, \
                                    -2.7384615384599997e-01, -2.7316239316199997e-01, -2.7247863247900000e-01, \
                                    -2.7179487179500000e-01, -2.7111111111100000e-01, -2.7042735042700000e-01, \
                                    -2.6974358974399998e-01, -2.6905982905999998e-01, -2.6837606837599998e-01, \
                                    -2.6769230769199998e-01, -2.6700854700900001e-01, -2.6632478632500001e-01, \
                                    -2.6564102564100001e-01, -2.6495726495700000e-01, -2.6427350427399998e-01, \
                                    -2.6358974358999998e-01, -2.6290598290599998e-01, -2.6222222222199998e-01, \
                                    -2.6153846153799998e-01, -2.6085470085500001e-01, -2.6017094017100001e-01, \
                                    -2.5948717948700001e-01, -2.5880341880300001e-01, -2.5811965811999998e-01, \
                                    -2.5743589743599998e-01, -2.5675213675199998e-01, -2.5606837606799998e-01, \
                                    -2.5538461538500001e-01, -2.5470085470100001e-01, -2.5401709401700001e-01, \
                                    -2.5333333333300001e-01, -2.5264957264999999e-01, -2.5196581196599999e-01, \
                                    -2.5128205128199999e-01, -2.5059829059799998e-01, -2.4991452991499999e-01, \
                                    -2.4923076923099999e-01, -2.4854700854699999e-01, -2.4786324786300001e-01, \
                                    -2.4717948717999999e-01, -2.4649572649599999e-01, -2.4581196581199999e-01, \
                                    -2.4512820512799999e-01, -2.4444444444399999e-01, -2.4376068376099999e-01, \
                                    -2.4307692307699999e-01, -2.4239316239299999e-01, -2.4170940170899999e-01, \
                                    -2.4102564102599999e-01, -2.4034188034199999e-01, -2.3965811965799999e-01, \
                                    -2.3897435897399999e-01, -2.3829059829099999e-01, -2.3760683760699999e-01, \
                                    -2.3692307692299999e-01, -2.3623931623899999e-01, -2.3555555555600000e-01, \
                                    -2.3487179487199999e-01, -2.3418803418799999e-01, -2.3350427350399999e-01, \
                                    -2.3282051282100000e-01, -2.3213675213700000e-01, -2.3145299145300000e-01, \
                                    -2.3076923076899999e-01, -2.3008547008600000e-01, -2.2940170940200000e-01, \
                                    -2.2871794871800000e-01, -2.2803418803400000e-01, -2.2735042735000000e-01, \
                                    -2.2666666666700000e-01, -2.2598290598300000e-01, -2.2529914529900000e-01, \
                                    -2.2461538461500000e-01, -2.2393162393200000e-01, -2.2324786324800000e-01, \
                                    -2.2256410256400000e-01, -2.2188034188000000e-01, -2.2119658119700000e-01, \
                                    -2.2051282051300000e-01, -2.1982905982900000e-01, -2.1914529914500000e-01, \
                                    -2.1846153846200000e-01, -2.1777777777800000e-01, -2.1709401709400000e-01, \
                                    -2.1641025641000000e-01, -2.1572649572700001e-01, -2.1504273504300001e-01, \
                                    -2.1435897435900000e-01, -2.1367521367500000e-01, -2.1299145299100000e-01, \
                                    -2.1230769230800001e-01, -2.1162393162400001e-01, -2.1094017094000000e-01, \
                                    -2.1025641025600000e-01, -2.0957264957300001e-01, -2.0888888888900001e-01, \
                                    -2.0820512820500001e-01, -2.0752136752100001e-01, -2.0683760683800001e-01, \
                                    -2.0615384615400001e-01, -2.0547008547000001e-01, -2.0478632478600001e-01, \
                                    -2.0410256410300001e-01, -2.0341880341900001e-01, -2.0273504273500001e-01, \
                                    -2.0205128205100001e-01, -2.0136752136800001e-01, -2.0068376068400001e-01, \
                                    -2.0000000000000001e-01, -1.9931623931600001e-01, -1.9863247863299999e-01, \
                                    -1.9794871794900001e-01, -1.9726495726500001e-01, -1.9658119658100001e-01, \
                                    -1.9589743589700001e-01, -1.9521367521399999e-01, -1.9452991452999999e-01, \
                                    -1.9384615384600001e-01, -1.9316239316200001e-01, -1.9247863247899999e-01, \
                                    -1.9179487179499999e-01, -1.9111111111099999e-01, -1.9042735042699999e-01, \
                                    -1.8974358974399999e-01, -1.8905982905999999e-01, -1.8837606837599999e-01, \
                                    -1.8769230769199999e-01, -1.8700854700899999e-01, -1.8632478632499999e-01, \
                                    -1.8564102564099999e-01, -1.8495726495699999e-01, -1.8427350427399999e-01, \
                                    -1.8358974358999999e-01, -1.8290598290599999e-01, -1.8222222222199999e-01, \
                                    -1.8153846153799999e-01, -1.8085470085499999e-01, -1.8017094017099999e-01, \
                                    -1.7948717948699999e-01, -1.7880341880299999e-01, -1.7811965812000000e-01, \
                                    -1.7743589743600000e-01, -1.7675213675199999e-01, -1.7606837606799999e-01, \
                                    -1.7538461538500000e-01, -1.7470085470100000e-01, -1.7401709401700000e-01, \
                                    -1.7333333333299999e-01, -1.7264957265000000e-01, -1.7196581196600000e-01, \
                                    -1.7128205128200000e-01, -1.7059829059800000e-01, -1.6991452991500000e-01, \
                                    -1.6923076923100000e-01, -1.6854700854700000e-01, -1.6786324786300000e-01, \
                                    -1.6717948718000000e-01, -1.6649572649600000e-01, -1.6581196581200000e-01, \
                                    -1.6512820512800000e-01, -1.6444444444400000e-01, -1.6376068376100000e-01, \
                                    -1.6307692307700000e-01, -1.6239316239300000e-01, -1.6170940170900000e-01, \
                                    -1.6102564102600000e-01, -1.6034188034200000e-01, -1.5965811965800000e-01, \
                                    -1.5897435897400000e-01, -1.5829059829100001e-01, -1.5760683760700001e-01, \
                                    -1.5692307692300000e-01, -1.5623931623900000e-01, -1.5555555555600001e-01, \
                                    -1.5487179487200001e-01, -1.5418803418800001e-01, -1.5350427350400001e-01, \
                                    -1.5282051282100001e-01, -1.5213675213700001e-01, -1.5145299145300001e-01, \
                                    -1.5076923076900001e-01, -1.5008547008500001e-01, -1.4940170940200001e-01, \
                                    -1.4871794871800001e-01, -1.4803418803400001e-01, -1.4735042735000001e-01, \
                                    -1.4666666666700001e-01, -1.4598290598300001e-01, -1.4529914529900001e-01, \
                                    -1.4461538461500001e-01, -1.4393162393200001e-01, -1.4324786324800001e-01, \
                                    -1.4256410256400001e-01, -1.4188034188000001e-01, -1.4119658119699999e-01, \
                                    -1.4051282051299999e-01, -1.3982905982900001e-01, -1.3914529914500001e-01, \
                                    -1.3846153846199999e-01, -1.3777777777799999e-01, -1.3709401709399999e-01, \
                                    -1.3641025641000001e-01, -1.3572649572699999e-01, -1.3504273504299999e-01, \
                                    -1.3435897435899999e-01, -1.3367521367499999e-01, -1.3299145299099999e-01, \
                                    -1.3230769230799999e-01, -1.3162393162399999e-01, -1.3094017093999999e-01, \
                                    -1.3025641025599999e-01, -1.2957264957299999e-01, -1.2888888888899999e-01, \
                                    -1.2820512820499999e-01, -1.2752136752099999e-01, -1.2683760683799999e-01, \
                                    -1.2615384615399999e-01, -1.2547008546999999e-01, -1.2478632478600001e-01, \
                                    -1.2410256410300000e-01, -1.2341880341899999e-01, -1.2273504273499999e-01, \
                                    -1.2205128205100001e-01, -1.2136752136800000e-01, -1.2068376068400000e-01, \
                                    -1.2000000000000000e-01, -1.1931623931599999e-01, -1.1863247863300000e-01, \
                                    -1.1794871794900000e-01, -1.1726495726500000e-01, -1.1658119658100000e-01, \
                                    -1.1589743589700000e-01, -1.1521367521400000e-01, -1.1452991453000000e-01, \
                                    -1.1384615384600000e-01, -1.1316239316200000e-01, -1.1247863247900000e-01, \
                                    -1.1179487179500000e-01, -1.1111111111100000e-01, -1.1042735042700000e-01, \
                                    -1.0974358974400000e-01, -1.0905982906000000e-01, -1.0837606837600000e-01, \
                                    -1.0769230769200000e-01, -1.0700854700900000e-01, -1.0632478632500000e-01, \
                                    -1.0564102564100000e-01, -1.0495726495700000e-01, -1.0427350427400001e-01, \
                                    -1.0358974359000001e-01, -1.0290598290600000e-01, -1.0222222222200000e-01, \
                                    -1.0153846153800000e-01, -1.0085470085500001e-01, -1.0017094017100001e-01, \
                                    -9.9487179487000005e-02, -9.8803418803000004e-02, -9.8119658119999995e-02, \
                                    -9.7435897435999994e-02, -9.6752136752000006e-02, -9.6068376068000005e-02, \
                                    -9.5384615384999996e-02, -9.4700854700999995e-02, -9.4017094016999994e-02, \
                                    -9.3333333332999993e-02, -9.2649572649999998e-02, -9.1965811965999997e-02, \
                                    -9.1282051281999996e-02, -9.0598290597999995e-02, -8.9914529914999999e-02, \
                                    -8.9230769230999998e-02, -8.8547008546999997e-02, -8.7863247862999996e-02, \
                                    -8.7179487180000001e-02, -8.6495726496000000e-02, -8.5811965811999999e-02, \
                                    -8.5128205127999998e-02, -8.4444444443999997e-02, -8.3760683761000002e-02, \
                                    -8.3076923077000001e-02, -8.2393162393000000e-02, -8.1709401708999999e-02, \
                                    -8.1025641026000003e-02, -8.0341880342000002e-02, -7.9658119658000001e-02, \
                                    -7.8974358974000000e-02, -7.8290598291000005e-02, -7.7606837607000004e-02, \
                                    -7.6923076923000003e-02, -7.6239316239000002e-02, -7.5555555556000006e-02, \
                                    -7.4871794872000005e-02, -7.4188034188000004e-02, -7.3504273504000003e-02, \
                                    -7.2820512820999994e-02, -7.2136752136999993e-02, -7.1452991453000006e-02, \
                                    -7.0769230769000005e-02, -7.0085470085999996e-02, -6.9401709401999995e-02, \
                                    -6.8717948717999994e-02, -6.8034188034000007e-02, -6.7350427350000006e-02, \
                                    -6.6666666666999996e-02, -6.5982905982999995e-02, -6.5299145298999994e-02, \
                                    -6.4615384614999993e-02, -6.3931623931999998e-02, -6.3247863247999997e-02, \
                                    -6.2564102563999996e-02, -6.1880341880000002e-02, -6.1196581197000000e-02, \
                                    -6.0512820512999999e-02, -5.9829059828999998e-02, -5.9145299145000003e-02, \
                                    -5.8461538462000001e-02, -5.7777777778000000e-02, -5.7094017093999999e-02, \
                                    -5.6410256409999998e-02, -5.5726495727000003e-02, -5.5042735043000002e-02, \
                                    -5.4358974359000001e-02, -5.3675213675000000e-02, -5.2991452990999999e-02, \
                                    -5.2307692308000003e-02, -5.1623931624000002e-02, -5.0940170940000001e-02, \
                                    -5.0256410256000000e-02, -4.9572649572999998e-02, -4.8888888888999997e-02, \
                                    -4.8205128205000003e-02, -4.7521367521000002e-02, -4.6837606838000000e-02, \
                                    -4.6153846153999999e-02, -4.5470085469999998e-02, -4.4786324785999997e-02, \
                                    -4.4102564103000001e-02, -4.3418803419000000e-02, -4.2735042734999999e-02, \
                                    -4.2051282050999998e-02, -4.1367521368000003e-02, -4.0683760684000002e-02, \
                                    -4.0000000000000001e-02, -3.9316239316000000e-02, -3.8632478632999998e-02, \
                                    -3.7948717949000003e-02, -3.7264957265000002e-02, -3.6581196581000001e-02, \
                                    -3.5897435897000000e-02, -3.5213675213999998e-02, -3.4529914529999997e-02, \
                                    -3.3846153846000003e-02, -3.3162393162000002e-02, -3.2478632479000000e-02, \
                                    -3.1794871794999999e-02, -3.1111111111000001e-02, -3.0427350427000000e-02, \
                                    -2.9743589744000001e-02, -2.9059829060000000e-02, -2.8376068375999999e-02, \
                                    -2.7692307691999998e-02, -2.7008547008999999e-02, -2.6324786324999998e-02, \
                                    -2.5641025641000001e-02, -2.4957264957000000e-02, -2.4273504274000001e-02, \
                                    -2.3589743590000000e-02, -2.2905982905999999e-02, -2.2222222222000002e-02, \
                                    -2.1538461538000001e-02, -2.0854700855000002e-02, -2.0170940171000001e-02, \
                                    -1.9487179487000000e-02, -1.8803418802999999e-02, -1.8119658120000000e-02, \
                                    -1.7435897435999999e-02, -1.6752136752000001e-02, -1.6068376068000000e-02, \
                                    -1.5384615385000000e-02, -1.4700854701000000e-02, -1.4017094016999999e-02, \
                                    -1.3333333333000000e-02, -1.2649572650000000e-02, -1.1965811966000000e-02, \
                                    -1.1282051281999999e-02, -1.0598290598000000e-02, -9.9145299149999994e-03, \
                                    -9.2307692310000002e-03, -8.5470085469999992e-03, -7.8632478629999999e-03, \
                                    -7.1794871800000002e-03, -6.4957264960000000e-03, -5.8119658119999999e-03, \
                                    -5.1282051279999998e-03, -4.4444444439999996e-03, -3.7606837609999999e-03, \
                                    -3.0769230770000002e-03, -2.3931623930000001e-03, -1.7094017089999999e-03, \
                                    -1.0256410260000000e-03, -3.4188034200000002e-04,  3.4188034200000002e-04, \
                                    1.0256410260000000e-03,  1.7094017089999999e-03,  2.3931623930000001e-03, \
                                    3.0769230770000002e-03,  3.7606837609999999e-03,  4.4444444439999996e-03, \
                                    5.1282051279999998e-03,  5.8119658119999999e-03,  6.4957264960000000e-03, \
                                    7.1794871789999997e-03,  7.8632478629999999e-03,  8.5470085469999992e-03, \
                                    9.2307692310000002e-03,  9.9145299149999994e-03,  1.0598290598000000e-02, \
                                    1.1282051281999999e-02,  1.1965811966000000e-02,  1.2649572650000000e-02, \
                                    1.3333333333000000e-02,  1.4017094016999999e-02,  1.4700854701000000e-02, \
                                    1.5384615385000000e-02,  1.6068376068000000e-02,  1.6752136752000001e-02, \
                                    1.7435897435999999e-02,  1.8119658120000000e-02,  1.8803418802999999e-02, \
                                    1.9487179487000000e-02,  2.0170940171000001e-02,  2.0854700855000002e-02, \
                                    2.1538461538000001e-02,  2.2222222222000002e-02,  2.2905982905999999e-02, \
                                    2.3589743590000000e-02,  2.4273504272999999e-02,  2.4957264957000000e-02, \
                                    2.5641025641000001e-02,  2.6324786324999998e-02,  2.7008547008999999e-02, \
                                    2.7692307691999998e-02,  2.8376068375999999e-02,  2.9059829060000000e-02, \
                                    2.9743589744000001e-02,  3.0427350427000000e-02,  3.1111111111000001e-02, \
                                    3.1794871794999999e-02,  3.2478632479000000e-02,  3.3162393162000002e-02, \
                                    3.3846153846000003e-02,  3.4529914529999997e-02,  3.5213675213999998e-02, \
                                    3.5897435897000000e-02,  3.6581196581000001e-02,  3.7264957265000002e-02, \
                                    3.7948717949000003e-02,  3.8632478631999999e-02,  3.9316239316000000e-02, \
                                    4.0000000000000001e-02,  4.0683760684000002e-02,  4.1367521366999997e-02, \
                                    4.2051282050999998e-02,  4.2735042734999999e-02,  4.3418803419000000e-02, \
                                    4.4102564103000001e-02,  4.4786324785999997e-02,  4.5470085469999998e-02, \
                                    4.6153846153999999e-02,  4.6837606838000000e-02,  4.7521367521000002e-02, \
                                    4.8205128205000003e-02,  4.8888888888999997e-02,  4.9572649572999998e-02, \
                                    5.0256410256000000e-02,  5.0940170940000001e-02,  5.1623931624000002e-02, \
                                    5.2307692308000003e-02,  5.2991452990999999e-02,  5.3675213675000000e-02, \
                                    5.4358974359000001e-02,  5.5042735043000002e-02,  5.5726495725999997e-02, \
                                    5.6410256409999998e-02,  5.7094017093999999e-02,  5.7777777778000000e-02, \
                                    5.8461538462000001e-02,  5.9145299145000003e-02,  5.9829059828999998e-02, \
                                    6.0512820512999999e-02,  6.1196581197000000e-02,  6.1880341880000002e-02, \
                                    6.2564102563999996e-02,  6.3247863247999997e-02,  6.3931623931999998e-02, \
                                    6.4615384614999993e-02,  6.5299145298999994e-02,  6.5982905982999995e-02, \
                                    6.6666666666999996e-02,  6.7350427350000006e-02,  6.8034188034000007e-02, \
                                    6.8717948717999994e-02,  6.9401709401999995e-02,  7.0085470085000004e-02, \
                                    7.0769230769000005e-02,  7.1452991453000006e-02,  7.2136752136999993e-02, \
                                    7.2820512820000002e-02,  7.3504273504000003e-02,  7.4188034188000004e-02, \
                                    7.4871794872000005e-02,  7.5555555556000006e-02,  7.6239316239000002e-02, \
                                    7.6923076923000003e-02,  7.7606837607000004e-02,  7.8290598291000005e-02, \
                                    7.8974358974000000e-02,  7.9658119658000001e-02,  8.0341880342000002e-02, \
                                    8.1025641026000003e-02,  8.1709401708999999e-02,  8.2393162393000000e-02, \
                                    8.3076923077000001e-02,  8.3760683761000002e-02,  8.4444444443999997e-02, \
                                    8.5128205127999998e-02,  8.5811965811999999e-02,  8.6495726496000000e-02, \
                                    8.7179487178999995e-02,  8.7863247862999996e-02,  8.8547008546999997e-02, \
                                    8.9230769230999998e-02,  8.9914529913999994e-02,  9.0598290597999995e-02, \
                                    9.1282051281999996e-02,  9.1965811965999997e-02,  9.2649572649999998e-02, \
                                    9.3333333332999993e-02,  9.4017094016999994e-02,  9.4700854700999995e-02, \
                                    9.5384615384999996e-02,  9.6068376068000005e-02,  9.6752136752000006e-02, \
                                    9.7435897435999994e-02,  9.8119658119999995e-02,  9.8803418803000004e-02, \
                                    9.9487179487000005e-02,  1.0017094017100001e-01,  1.0085470085500001e-01, \
                                    1.0153846153800000e-01,  1.0222222222200000e-01,  1.0290598290600000e-01, \
                                    1.0358974359000001e-01,  1.0427350427300000e-01,  1.0495726495700000e-01, \
                                    1.0564102564100000e-01,  1.0632478632500000e-01,  1.0700854700900000e-01, \
                                    1.0769230769200000e-01,  1.0837606837600000e-01,  1.0905982906000000e-01, \
                                    1.0974358974400000e-01,  1.1042735042700000e-01,  1.1111111111100000e-01, \
                                    1.1179487179500000e-01,  1.1247863247900000e-01,  1.1316239316200000e-01, \
                                    1.1384615384600000e-01,  1.1452991453000000e-01,  1.1521367521400000e-01, \
                                    1.1589743589700000e-01,  1.1658119658100000e-01,  1.1726495726500000e-01, \
                                    1.1794871794900000e-01,  1.1863247863199999e-01,  1.1931623931599999e-01, \
                                    1.2000000000000000e-01,  1.2068376068400000e-01,  1.2136752136700001e-01, \
                                    1.2205128205100001e-01,  1.2273504273499999e-01,  1.2341880341899999e-01, \
                                    1.2410256410300000e-01,  1.2478632478600001e-01,  1.2547008546999999e-01, \
                                    1.2615384615399999e-01,  1.2683760683799999e-01,  1.2752136752099999e-01, \
                                    1.2820512820499999e-01,  1.2888888888899999e-01,  1.2957264957299999e-01, \
                                    1.3025641025599999e-01,  1.3094017093999999e-01,  1.3162393162399999e-01, \
                                    1.3230769230799999e-01,  1.3299145299099999e-01,  1.3367521367499999e-01, \
                                    1.3435897435899999e-01,  1.3504273504299999e-01,  1.3572649572600001e-01, \
                                    1.3641025641000001e-01,  1.3709401709399999e-01,  1.3777777777799999e-01, \
                                    1.3846153846199999e-01,  1.3914529914500001e-01,  1.3982905982900001e-01, \
                                    1.4051282051299999e-01,  1.4119658119699999e-01,  1.4188034188000001e-01, \
                                    1.4256410256400001e-01,  1.4324786324800001e-01,  1.4393162393200001e-01, \
                                    1.4461538461500001e-01,  1.4529914529900001e-01,  1.4598290598300001e-01, \
                                    1.4666666666700001e-01,  1.4735042735000001e-01,  1.4803418803400001e-01, \
                                    1.4871794871800001e-01,  1.4940170940200001e-01,  1.5008547008500001e-01, \
                                    1.5076923076900001e-01,  1.5145299145300001e-01,  1.5213675213700001e-01, \
                                    1.5282051282000000e-01,  1.5350427350400001e-01,  1.5418803418800001e-01, \
                                    1.5487179487200001e-01,  1.5555555555600001e-01,  1.5623931623900000e-01, \
                                    1.5692307692300000e-01,  1.5760683760700001e-01,  1.5829059829100001e-01, \
                                    1.5897435897400000e-01,  1.5965811965800000e-01,  1.6034188034200000e-01, \
                                    1.6102564102600000e-01,  1.6170940170900000e-01,  1.6239316239300000e-01, \
                                    1.6307692307700000e-01,  1.6376068376100000e-01,  1.6444444444400000e-01, \
                                    1.6512820512800000e-01,  1.6581196581200000e-01,  1.6649572649600000e-01, \
                                    1.6717948717900000e-01,  1.6786324786300000e-01,  1.6854700854700000e-01, \
                                    1.6923076923100000e-01,  1.6991452991500000e-01,  1.7059829059800000e-01, \
                                    1.7128205128200000e-01,  1.7196581196600000e-01,  1.7264957265000000e-01, \
                                    1.7333333333299999e-01,  1.7401709401700000e-01,  1.7470085470100000e-01, \
                                    1.7538461538500000e-01,  1.7606837606799999e-01,  1.7675213675199999e-01, \
                                    1.7743589743600000e-01,  1.7811965812000000e-01,  1.7880341880299999e-01, \
                                    1.7948717948699999e-01,  1.8017094017099999e-01,  1.8085470085499999e-01, \
                                    1.8153846153799999e-01,  1.8222222222199999e-01,  1.8290598290599999e-01, \
                                    1.8358974358999999e-01,  1.8427350427299999e-01,  1.8495726495699999e-01, \
                                    1.8564102564099999e-01,  1.8632478632499999e-01,  1.8700854700899999e-01, \
                                    1.8769230769199999e-01,  1.8837606837599999e-01,  1.8905982905999999e-01, \
                                    1.8974358974399999e-01,  1.9042735042699999e-01,  1.9111111111099999e-01, \
                                    1.9179487179499999e-01,  1.9247863247899999e-01,  1.9316239316200001e-01, \
                                    1.9384615384600001e-01,  1.9452991452999999e-01,  1.9521367521399999e-01, \
                                    1.9589743589700001e-01,  1.9658119658100001e-01,  1.9726495726500001e-01, \
                                    1.9794871794900001e-01,  1.9863247863200001e-01,  1.9931623931600001e-01, \
                                    2.0000000000000001e-01,  2.0068376068400001e-01,  2.0136752136700001e-01, \
                                    2.0205128205100001e-01,  2.0273504273500001e-01,  2.0341880341900001e-01, \
                                    2.0410256410300001e-01,  2.0478632478600001e-01,  2.0547008547000001e-01, \
                                    2.0615384615400001e-01,  2.0683760683800001e-01,  2.0752136752100001e-01, \
                                    2.0820512820500001e-01,  2.0888888888900001e-01,  2.0957264957300001e-01, \
                                    2.1025641025600000e-01,  2.1094017094000000e-01,  2.1162393162400001e-01, \
                                    2.1230769230800001e-01,  2.1299145299100000e-01,  2.1367521367500000e-01, \
                                    2.1435897435900000e-01,  2.1504273504300001e-01,  2.1572649572600000e-01, \
                                    2.1641025641000000e-01,  2.1709401709400000e-01,  2.1777777777800000e-01, \
                                    2.1846153846200000e-01,  2.1914529914500000e-01,  2.1982905982900000e-01, \
                                    2.2051282051300000e-01,  2.2119658119700000e-01,  2.2188034188000000e-01, \
                                    2.2256410256400000e-01,  2.2324786324800000e-01,  2.2393162393200000e-01, \
                                    2.2461538461500000e-01,  2.2529914529900000e-01,  2.2598290598300000e-01, \
                                    2.2666666666700000e-01,  2.2735042735000000e-01,  2.2803418803400000e-01, \
                                    2.2871794871800000e-01,  2.2940170940200000e-01,  2.3008547008499999e-01, \
                                    2.3076923076899999e-01,  2.3145299145300000e-01,  2.3213675213700000e-01, \
                                    2.3282051281999999e-01,  2.3350427350399999e-01,  2.3418803418799999e-01, \
                                    2.3487179487199999e-01,  2.3555555555600000e-01,  2.3623931623899999e-01, \
                                    2.3692307692299999e-01,  2.3760683760699999e-01,  2.3829059829099999e-01, \
                                    2.3897435897399999e-01,  2.3965811965799999e-01,  2.4034188034199999e-01, \
                                    2.4102564102599999e-01,  2.4170940170899999e-01,  2.4239316239299999e-01, \
                                    2.4307692307699999e-01,  2.4376068376099999e-01,  2.4444444444399999e-01, \
                                    2.4512820512799999e-01,  2.4581196581199999e-01,  2.4649572649599999e-01, \
                                    2.4717948717900001e-01,  2.4786324786300001e-01,  2.4854700854699999e-01, \
                                    2.4923076923099999e-01,  2.4991452991499999e-01,  2.5059829059799998e-01, \
                                    2.5128205128199999e-01,  2.5196581196599999e-01,  2.5264957264999999e-01, \
                                    2.5333333333300001e-01,  2.5401709401700001e-01,  2.5470085470100001e-01, \
                                    2.5538461538500001e-01,  2.5606837606799998e-01,  2.5675213675199998e-01, \
                                    2.5743589743599998e-01,  2.5811965811999998e-01,  2.5880341880300001e-01, \
                                    2.5948717948700001e-01,  2.6017094017100001e-01,  2.6085470085500001e-01, \
                                    2.6153846153799998e-01,  2.6222222222199998e-01,  2.6290598290599998e-01, \
                                    2.6358974358999998e-01,  2.6427350427300000e-01,  2.6495726495700000e-01, \
                                    2.6564102564100001e-01,  2.6632478632500001e-01,  2.6700854700900001e-01, \
                                    2.6769230769199998e-01,  2.6837606837599998e-01,  2.6905982905999998e-01, \
                                    2.6974358974399998e-01,  2.7042735042700000e-01,  2.7111111111100000e-01, \
                                    2.7179487179500000e-01,  2.7247863247900000e-01,  2.7316239316199997e-01, \
                                    2.7384615384599997e-01,  2.7452991452999997e-01,  2.7521367521399998e-01, \
                                    2.7589743589700000e-01,  2.7658119658100000e-01,  2.7726495726500000e-01, \
                                    2.7794871794900000e-01,  2.7863247863200002e-01,  2.7931623931600003e-01, \
                                    2.8000000000000003e-01,  2.8068376068400003e-01,  2.8136752136700000e-01, \
                                    2.8205128205100000e-01,  2.8273504273500000e-01,  2.8341880341900000e-01, \
                                    2.8410256410300000e-01,  2.8478632478600002e-01,  2.8547008547000002e-01, \
                                    2.8615384615400002e-01,  2.8683760683800003e-01,  2.8752136752099999e-01, \
                                    2.8820512820499999e-01,  2.8888888888900000e-01,  2.8957264957300000e-01, \
                                    2.9025641025600002e-01,  2.9094017094000002e-01,  2.9162393162400002e-01, \
                                    2.9230769230800002e-01,  2.9299145299099999e-01,  2.9367521367499999e-01, \
                                    2.9435897435899999e-01,  2.9504273504299999e-01,  2.9572649572600002e-01, \
                                    2.9641025641000002e-01,  2.9709401709400002e-01,  2.9777777777800002e-01, \
                                    2.9846153846200002e-01,  2.9914529914499999e-01,  2.9982905982899999e-01, \
                                    3.0051282051299999e-01,  3.0119658119699999e-01,  3.0188034188000001e-01, \
                                    3.0256410256400001e-01,  3.0324786324800002e-01,  3.0393162393200002e-01, \
                                    3.0461538461499998e-01,  3.0529914529899999e-01,  3.0598290598299999e-01, \
                                    3.0666666666699999e-01,  3.0735042735000001e-01,  3.0803418803400001e-01, \
                                    3.0871794871800001e-01,  3.0940170940200001e-01,  3.1008547008499998e-01, \
                                    3.1076923076899998e-01,  3.1145299145299998e-01,  3.1213675213699998e-01, \
                                    3.1282051282000001e-01,  3.1350427350400001e-01,  3.1418803418800001e-01, \
                                    3.1487179487200001e-01,  3.1555555555600001e-01,  3.1623931623899998e-01, \
                                    3.1692307692299998e-01,  3.1760683760699998e-01,  3.1829059829099998e-01, \
                                    3.1897435897400001e-01,  3.1965811965800001e-01,  3.2034188034200001e-01, \
                                    3.2102564102600001e-01,  3.2170940170899998e-01,  3.2239316239299998e-01, \
                                    3.2307692307699998e-01,  3.2376068376099998e-01,  3.2444444444400000e-01, \
                                    3.2512820512800000e-01,  3.2581196581200000e-01,  3.2649572649600000e-01, \
                                    3.2717948717899997e-01,  3.2786324786299997e-01,  3.2854700854699997e-01, \
                                    3.2923076923099998e-01,  3.2991452991499998e-01,  3.3059829059800000e-01, \
                                    3.3128205128200000e-01,  3.3196581196600000e-01,  3.3264957265000000e-01, \
                                    3.3333333333300003e-01,  3.3401709401700003e-01,  3.3470085470099997e-01, \
                                    3.3538461538499997e-01,  3.3606837606800000e-01,  3.3675213675200000e-01, \
                                    3.3743589743600000e-01,  3.3811965812000000e-01,  3.3880341880300002e-01, \
                                    3.3948717948700002e-01,  3.4017094017100002e-01,  3.4085470085500003e-01, \
                                    3.4153846153799999e-01,  3.4222222222199999e-01,  3.4290598290600000e-01, \
                                    3.4358974359000000e-01,  3.4427350427300002e-01,  3.4495726495700002e-01, \
                                    3.4564102564100002e-01,  3.4632478632500002e-01,  3.4700854700900002e-01, \
                                    3.4769230769199999e-01,  3.4837606837599999e-01,  3.4905982905999999e-01, \
                                    3.4974358974399999e-01,  3.5042735042700002e-01,  3.5111111111100002e-01, \
                                    3.5179487179500002e-01,  3.5247863247900002e-01,  3.5316239316199999e-01, \
                                    3.5384615384599999e-01,  3.5452991452999999e-01,  3.5521367521399999e-01, \
                                    3.5589743589700001e-01,  3.5658119658100002e-01,  3.5726495726500002e-01, \
                                    3.5794871794900002e-01,  3.5863247863199998e-01,  3.5931623931599999e-01, \
                                    3.5999999999999999e-01,  3.6068376068399999e-01,  3.6136752136700001e-01, \
                                    3.6205128205100001e-01,  3.6273504273500001e-01,  3.6341880341900001e-01, \
                                    3.6410256410300001e-01,  3.6478632478599998e-01,  3.6547008546999998e-01, \
                                    3.6615384615399998e-01,  3.6683760683799999e-01,  3.6752136752100001e-01, \
                                    3.6820512820500001e-01,  3.6888888888900001e-01,  3.6957264957300001e-01, \
                                    3.7025641025599998e-01,  3.7094017093999998e-01,  3.7162393162399998e-01, \
                                    3.7230769230799998e-01,  3.7299145299100001e-01,  3.7367521367500001e-01, \
                                    3.7435897435900001e-01,  3.7504273504300001e-01,  3.7572649572599998e-01, \
                                    3.7641025640999998e-01,  3.7709401709399998e-01,  3.7777777777799998e-01, \
                                    3.7846153846199998e-01,  3.7914529914500000e-01,  3.7982905982900000e-01, \
                                    3.8051282051300001e-01,  3.8119658119700001e-01,  3.8188034187999997e-01, \
                                    3.8256410256399997e-01,  3.8324786324799998e-01,  3.8393162393199998e-01, \
                                    3.8461538461500000e-01,  3.8529914529900000e-01,  3.8598290598300000e-01, \
                                    3.8666666666700000e-01,  3.8735042735000003e-01,  3.8803418803400003e-01, \
                                    3.8871794871799997e-01,  3.8940170940199997e-01,  3.9008547008500000e-01, \
                                    3.9076923076900000e-01,  3.9145299145300000e-01,  3.9213675213700000e-01, \
                                    3.9282051282000002e-01,  3.9350427350400002e-01,  3.9418803418800002e-01, \
                                    3.9487179487200003e-01,  3.9555555555600003e-01,  3.9623931623899999e-01, \
                                    3.9692307692300000e-01,  3.9760683760700000e-01,  3.9829059829100000e-01, \
                                    3.9897435897400002e-01,  3.9965811965800002e-01,  4.0034188034200002e-01, \
                                    4.0102564102600002e-01,  4.0170940170899999e-01,  4.0239316239299999e-01, \
                                    4.0307692307699999e-01,  4.0376068376099999e-01,  4.0444444444400002e-01, \
                                    4.0512820512800002e-01,  4.0581196581200002e-01,  4.0649572649600002e-01, \
                                    4.0717948717899999e-01,  4.0786324786299999e-01,  4.0854700854699999e-01, \
                                    4.0923076923099999e-01,  4.0991452991499999e-01,  4.1059829059800002e-01, \
                                    4.1128205128200002e-01,  4.1196581196600002e-01,  4.1264957265000002e-01, \
                                    4.1333333333299999e-01,  4.1401709401699999e-01,  4.1470085470099999e-01, \
                                    4.1538461538499999e-01,  4.1606837606800001e-01,  4.1675213675200001e-01, \
                                    4.1743589743600001e-01,  4.1811965812000002e-01,  4.1880341880299998e-01, \
                                    4.1948717948699998e-01,  4.2017094017099998e-01,  4.2085470085499999e-01, \
                                    4.2153846153800001e-01,  4.2222222222200001e-01,  4.2290598290600001e-01, \
                                    4.2358974359000001e-01,  4.2427350427299998e-01,  4.2495726495699998e-01, \
                                    4.2564102564099998e-01,  4.2632478632499998e-01,  4.2700854700899998e-01, \
                                    4.2769230769200001e-01,  4.2837606837600001e-01,  4.2905982906000001e-01, \
                                    4.2974358974400001e-01,  4.3042735042699998e-01,  4.3111111111099998e-01, \
                                    4.3179487179499998e-01,  4.3247863247899998e-01,  4.3316239316200000e-01, \
                                    4.3384615384600000e-01,  4.3452991453000001e-01,  4.3521367521400001e-01, \
                                    4.3589743589699997e-01,  4.3658119658099998e-01,  4.3726495726499998e-01, \
                                    4.3794871794899998e-01,  4.3863247863200000e-01,  4.3931623931600000e-01, \
                                    4.4000000000000000e-01,  4.4068376068400000e-01,  4.4136752136700003e-01, \
                                    4.4205128205100003e-01,  4.4273504273499997e-01,  4.4341880341899997e-01, \
                                    4.4410256410299997e-01,  4.4478632478600000e-01,  4.4547008547000000e-01, \
                                    4.4615384615400000e-01,  4.4683760683800000e-01,  4.4752136752100002e-01, \
                                    4.4820512820500003e-01,  4.4888888888900003e-01,  4.4957264957300003e-01, \
                                    4.5025641025599999e-01,  4.5094017094000000e-01,  4.5162393162400000e-01, \
                                    4.5230769230800000e-01,  4.5299145299100002e-01,  4.5367521367500002e-01, \
                                    4.5435897435900002e-01,  4.5504273504300002e-01,  4.5572649572599999e-01, \
                                    4.5641025640999999e-01,  4.5709401709399999e-01,  4.5777777777799999e-01, \
                                    4.5846153846200000e-01,  4.5914529914500002e-01,  4.5982905982900002e-01, \
                                    4.6051282051300002e-01,  4.6119658119700002e-01,  4.6188034187999999e-01, \
                                    4.6256410256399999e-01,  4.6324786324799999e-01,  4.6393162393199999e-01, \
                                    4.6461538461500002e-01,  4.6529914529900002e-01,  4.6598290598300002e-01, \
                                    4.6666666666700002e-01,  4.6735042734999999e-01,  4.6803418803399999e-01, \
                                    4.6871794871799999e-01,  4.6940170940199999e-01,  4.7008547008500001e-01, \
                                    4.7076923076900001e-01,  4.7145299145300001e-01,  4.7213675213700002e-01, \
                                    4.7282051281999998e-01,  4.7350427350399998e-01,  4.7418803418799998e-01, \
                                    4.7487179487199999e-01,  4.7555555555599999e-01,  4.7623931623900001e-01, \
                                    4.7692307692300001e-01,  4.7760683760700001e-01,  4.7829059829100001e-01, \
                                    4.7897435897399998e-01,  4.7965811965799998e-01,  4.8034188034199998e-01, \
                                    4.8102564102599998e-01,  4.8170940170900001e-01,  4.8239316239300001e-01, \
                                    4.8307692307700001e-01,  4.8376068376100001e-01,  4.8444444444399998e-01, \
                                    4.8512820512799998e-01,  4.8581196581199998e-01,  4.8649572649599998e-01, \
                                    4.8717948717900000e-01,  4.8786324786300000e-01,  4.8854700854700001e-01, \
                                    4.8923076923100001e-01,  4.8991452991500001e-01,  4.9059829059799998e-01, \
                                    4.9128205128199998e-01,  4.9196581196599998e-01,  4.9264957264999998e-01, \
                                    4.9333333333300000e-01,  4.9401709401700000e-01,  4.9470085470100000e-01, \
                                    4.9538461538500000e-01,  4.9606837606800003e-01,  4.9675213675199997e-01, \
                                    4.9743589743599997e-01,  4.9811965811999998e-01,  4.9880341880300000e-01, \
                                    4.9948717948700000e-01,  5.0017094017099994e-01,  5.0085470085499995e-01, \
                                    5.0153846153799997e-01,  5.0222222222199997e-01,  5.0290598290599997e-01, \
                                    5.0358974358999997e-01,  5.0427350427300000e-01,  5.0495726495700000e-01, \
                                    5.0564102564100000e-01,  5.0632478632500000e-01,  5.0700854700900000e-01, \
                                    5.0769230769200002e-01,  5.0837606837600002e-01,  5.0905982906000002e-01, \
                                    5.0974358974400003e-01,  5.1042735042700005e-01,  5.1111111111100005e-01, \
                                    5.1179487179500005e-01,  5.1247863247900005e-01,  5.1316239316199996e-01, \
                                    5.1384615384599996e-01,  5.1452991452999997e-01,  5.1521367521399997e-01, \
                                    5.1589743589699999e-01,  5.1658119658099999e-01,  5.1726495726499999e-01, \
                                    5.1794871794899999e-01,  5.1863247863200002e-01,  5.1931623931600002e-01, \
                                    5.2000000000000002e-01,  5.2068376068400002e-01,  5.2136752136700004e-01, \
                                    5.2205128205100004e-01,  5.2273504273500004e-01,  5.2341880341900004e-01, \
                                    5.2410256410300005e-01,  5.2478632478599996e-01,  5.2547008546999996e-01, \
                                    5.2615384615399996e-01,  5.2683760683799996e-01,  5.2752136752099998e-01, \
                                    5.2820512820499999e-01,  5.2888888888899999e-01,  5.2957264957299999e-01, \
                                    5.3025641025600001e-01,  5.3094017094000001e-01,  5.3162393162400001e-01, \
                                    5.3230769230800001e-01,  5.3299145299100004e-01,  5.3367521367500004e-01, \
                                    5.3435897435900004e-01,  5.3504273504300004e-01,  5.3572649572599995e-01, \
                                    5.3641025640999995e-01,  5.3709401709399995e-01,  5.3777777777799995e-01, \
                                    5.3846153846199996e-01,  5.3914529914499998e-01,  5.3982905982899998e-01, \
                                    5.4051282051299998e-01,  5.4119658119699998e-01,  5.4188034188000000e-01, \
                                    5.4256410256400001e-01,  5.4324786324800001e-01,  5.4393162393200001e-01, \
                                    5.4461538461500003e-01,  5.4529914529900003e-01,  5.4598290598300003e-01, \
                                    5.4666666666700003e-01,  5.4735042734999995e-01,  5.4803418803399995e-01, \
                                    5.4871794871799995e-01,  5.4940170940199995e-01,  5.5008547008499997e-01, \
                                    5.5076923076899997e-01,  5.5145299145299997e-01,  5.5213675213699998e-01, \
                                    5.5282051282000000e-01,  5.5350427350400000e-01,  5.5418803418800000e-01, \
                                    5.5487179487200000e-01,  5.5555555555600000e-01,  5.5623931623900003e-01, \
                                    5.5692307692300003e-01,  5.5760683760700003e-01,  5.5829059829100003e-01, \
                                    5.5897435897400005e-01,  5.5965811965800005e-01,  5.6034188034200005e-01, \
                                    5.6102564102600005e-01,  5.6170940170899997e-01,  5.6239316239299997e-01, \
                                    5.6307692307699997e-01,  5.6376068376099997e-01,  5.6444444444399999e-01, \
                                    5.6512820512799999e-01,  5.6581196581200000e-01,  5.6649572649600000e-01, \
                                    5.6717948717900002e-01,  5.6786324786300002e-01,  5.6854700854700002e-01, \
                                    5.6923076923100002e-01,  5.6991452991400005e-01,  5.7059829059800005e-01, \
                                    5.7128205128200005e-01,  5.7196581196600005e-01,  5.7264957265000005e-01, \
                                    5.7333333333299996e-01,  5.7401709401699996e-01,  5.7470085470099996e-01, \
                                    5.7538461538499996e-01,  5.7606837606799999e-01,  5.7675213675199999e-01, \
                                    5.7743589743599999e-01,  5.7811965811999999e-01,  5.7880341880300001e-01, \
                                    5.7948717948700001e-01,  5.8017094017100002e-01,  5.8085470085500002e-01, \
                                    5.8153846153800004e-01,  5.8222222222200004e-01,  5.8290598290600004e-01, \
                                    5.8358974359000004e-01,  5.8427350427299996e-01,  5.8495726495699996e-01, \
                                    5.8564102564099996e-01,  5.8632478632499996e-01,  5.8700854700899996e-01, \
                                    5.8769230769199998e-01,  5.8837606837599998e-01,  5.8905982905999998e-01, \
                                    5.8974358974399999e-01,  5.9042735042700001e-01,  5.9111111111100001e-01, \
                                    5.9179487179500001e-01,  5.9247863247900001e-01,  5.9316239316200003e-01, \
                                    5.9384615384600004e-01,  5.9452991453000004e-01,  5.9521367521400004e-01, \
                                    5.9589743589699995e-01,  5.9658119658099995e-01,  5.9726495726499995e-01, \
                                    5.9794871794899995e-01,  5.9863247863199998e-01,  5.9931623931599998e-01, \
                                    5.9999999999999998e-01,  6.0068376068399998e-01,  6.0136752136700000e-01, \
                                    6.0205128205100000e-01,  6.0273504273500000e-01,  6.0341880341900000e-01, \
                                    6.0410256410300001e-01,  6.0478632478600003e-01,  6.0547008547000003e-01, \
                                    6.0615384615400003e-01,  6.0683760683800003e-01,  6.0752136752100006e-01, \
                                    6.0820512820499995e-01,  6.0888888888899995e-01,  6.0957264957299995e-01, \
                                    6.1025641025599997e-01,  6.1094017093999997e-01,  6.1162393162399997e-01, \
                                    6.1230769230799997e-01,  6.1299145299100000e-01,  6.1367521367500000e-01, \
                                    6.1435897435900000e-01,  6.1504273504300000e-01,  6.1572649572600002e-01, \
                                    6.1641025641000002e-01,  6.1709401709400002e-01,  6.1777777777800003e-01, \
                                    6.1846153846200003e-01,  6.1914529914500005e-01,  6.1982905982900005e-01, \
                                    6.2051282051300005e-01,  6.2119658119700005e-01,  6.2188034187999996e-01, \
                                    6.2256410256399997e-01,  6.2324786324799997e-01,  6.2393162393199997e-01, \
                                    6.2461538461499999e-01,  6.2529914529899999e-01,  6.2598290598299999e-01, \
                                    6.2666666666699999e-01,  6.2735042735000002e-01,  6.2803418803400002e-01, \
                                    6.2871794871800002e-01,  6.2940170940200002e-01,  6.3008547008500004e-01, \
                                    6.3076923076900004e-01,  6.3145299145300005e-01,  6.3213675213700005e-01, \
                                    6.3282051281999996e-01,  6.3350427350399996e-01,  6.3418803418799996e-01, \
                                    6.3487179487199996e-01,  6.3555555555599996e-01,  6.3623931623899999e-01, \
                                    6.3692307692299999e-01,  6.3760683760699999e-01,  6.3829059829099999e-01, \
                                    6.3897435897400001e-01,  6.3965811965800001e-01,  6.4034188034200001e-01, \
                                    6.4102564102600001e-01,  6.4170940170900004e-01,  6.4239316239300004e-01, \
                                    6.4307692307700004e-01,  6.4376068376100004e-01,  6.4444444444399995e-01, \
                                    6.4512820512799995e-01,  6.4581196581199996e-01,  6.4649572649599996e-01, \
                                    6.4717948717899998e-01,  6.4786324786299998e-01,  6.4854700854699998e-01, \
                                    6.4923076923099998e-01,  6.4991452991400001e-01,  6.5059829059800001e-01, \
                                    6.5128205128200001e-01,  6.5196581196600001e-01,  6.5264957265000001e-01, \
                                    6.5333333333300003e-01,  6.5401709401700003e-01,  6.5470085470100003e-01, \
                                    6.5538461538500004e-01,  6.5606837606799995e-01,  6.5675213675199995e-01, \
                                    6.5743589743599995e-01,  6.5811965811999995e-01,  6.5880341880299997e-01, \
                                    6.5948717948699997e-01,  6.6017094017099998e-01,  6.6085470085499998e-01, \
                                    6.6153846153800000e-01,  6.6222222222200000e-01,  6.6290598290600000e-01, \
                                    6.6358974359000000e-01,  6.6427350427300003e-01,  6.6495726495700003e-01, \
                                    6.6564102564100003e-01,  6.6632478632500003e-01,  6.6700854700900003e-01, \
                                    6.6769230769200005e-01,  6.6837606837600005e-01,  6.6905982906000006e-01, \
                                    6.6974358974399995e-01,  6.7042735042699997e-01,  6.7111111111099997e-01, \
                                    6.7179487179499997e-01,  6.7247863247899997e-01,  6.7316239316199999e-01, \
                                    6.7384615384600000e-01,  6.7452991453000000e-01,  6.7521367521400000e-01, \
                                    6.7589743589700002e-01,  6.7658119658100002e-01,  6.7726495726500002e-01, \
                                    6.7794871794900002e-01,  6.7863247863200005e-01,  6.7931623931600005e-01, \
                                    6.8000000000000005e-01,  6.8068376068400005e-01,  6.8136752136699996e-01, \
                                    6.8205128205099996e-01,  6.8273504273499996e-01,  6.8341880341899996e-01, \
                                    6.8410256410299997e-01,  6.8478632478599999e-01,  6.8547008546999999e-01, \
                                    6.8615384615399999e-01,  6.8683760683799999e-01,  6.8752136752100002e-01, \
                                    6.8820512820500002e-01,  6.8888888888900002e-01,  6.8957264957300002e-01, \
                                    6.9025641025600004e-01,  6.9094017094000004e-01,  6.9162393162400004e-01, \
                                    6.9230769230800004e-01,  6.9299145299099996e-01,  6.9367521367499996e-01, \
                                    6.9435897435899996e-01,  6.9504273504299996e-01,  6.9572649572599998e-01, \
                                    6.9641025640999998e-01,  6.9709401709399998e-01,  6.9777777777799999e-01, \
                                    6.9846153846100001e-01,  6.9914529914500001e-01,  6.9982905982900001e-01, \
                                    7.0051282051300001e-01,  7.0119658119700001e-01,  7.0188034188000004e-01, \
                                    7.0256410256400004e-01,  7.0324786324800004e-01,  7.0393162393200004e-01, \
                                    7.0461538461499995e-01,  7.0529914529899995e-01,  7.0598290598299995e-01, \
                                    7.0666666666699995e-01,  7.0735042734999998e-01,  7.0803418803399998e-01, \
                                    7.0871794871799998e-01,  7.0940170940199998e-01,  7.1008547008500000e-01, \
                                    7.1076923076900000e-01,  7.1145299145300001e-01,  7.1213675213700001e-01, \
                                    7.1282051282000003e-01,  7.1350427350400003e-01,  7.1418803418800003e-01, \
                                    7.1487179487200003e-01,  7.1555555555600003e-01,  7.1623931623899995e-01, \
                                    7.1692307692299995e-01,  7.1760683760699995e-01,  7.1829059829099995e-01, \
                                    7.1897435897399997e-01,  7.1965811965799997e-01,  7.2034188034199997e-01, \
                                    7.2102564102599997e-01,  7.2170940170900000e-01,  7.2239316239300000e-01, \
                                    7.2307692307700000e-01,  7.2376068376100000e-01,  7.2444444444400002e-01, \
                                    7.2512820512800003e-01,  7.2581196581200003e-01,  7.2649572649600003e-01, \
                                    7.2717948717900005e-01,  7.2786324786300005e-01,  7.2854700854700005e-01, \
                                    7.2923076923100005e-01,  7.2991452991399997e-01,  7.3059829059799997e-01, \
                                    7.3128205128199997e-01,  7.3196581196599997e-01,  7.3264957264999997e-01, \
                                    7.3333333333299999e-01,  7.3401709401699999e-01,  7.3470085470099999e-01, \
                                    7.3538461538500000e-01,  7.3606837606800002e-01,  7.3675213675200002e-01, \
                                    7.3743589743600002e-01,  7.3811965812000002e-01,  7.3880341880300004e-01, \
                                    7.3948717948700005e-01,  7.4017094017100005e-01,  7.4085470085500005e-01, \
                                    7.4153846153799996e-01,  7.4222222222199996e-01,  7.4290598290599996e-01, \
                                    7.4358974358999996e-01,  7.4427350427299999e-01,  7.4495726495699999e-01, \
                                    7.4564102564099999e-01,  7.4632478632499999e-01,  7.4700854700899999e-01, \
                                    7.4769230769200001e-01,  7.4837606837600001e-01,  7.4905982906000002e-01, \
                                    7.4974358974400002e-01,  7.5042735042700004e-01,  7.5111111111100004e-01, \
                                    7.5179487179500004e-01,  7.5247863247900004e-01,  7.5316239316199995e-01, \
                                    7.5384615384599996e-01,  7.5452991452999996e-01,  7.5521367521399996e-01, \
                                    7.5589743589699998e-01,  7.5658119658099998e-01,  7.5726495726499998e-01, \
                                    7.5794871794899998e-01,  7.5863247863200001e-01,  7.5931623931600001e-01, \
                                    7.6000000000000001e-01,  7.6068376068400001e-01,  7.6136752136700003e-01, \
                                    7.6205128205100003e-01,  7.6273504273500004e-01,  7.6341880341900004e-01, \
                                    7.6410256410300004e-01,  7.6478632478599995e-01,  7.6547008546999995e-01, \
                                    7.6615384615399995e-01,  7.6683760683799995e-01,  7.6752136752099998e-01, \
                                    7.6820512820499998e-01,  7.6888888888899998e-01,  7.6957264957299998e-01, \
                                    7.7025641025600000e-01,  7.7094017094000000e-01,  7.7162393162400000e-01, \
                                    7.7230769230800000e-01,  7.7299145299100003e-01,  7.7367521367500003e-01, \
                                    7.7435897435900003e-01,  7.7504273504300003e-01,  7.7572649572600005e-01, \
                                    7.7641025641000005e-01,  7.7709401709399994e-01,  7.7777777777799995e-01, \
                                    7.7846153846099997e-01,  7.7914529914499997e-01,  7.7982905982899997e-01, \
                                    7.8051282051299997e-01,  7.8119658119699997e-01,  7.8188034188000000e-01, \
                                    7.8256410256400000e-01,  7.8324786324800000e-01,  7.8393162393200000e-01, \
                                    7.8461538461500002e-01,  7.8529914529900002e-01,  7.8598290598300002e-01, \
                                    7.8666666666700003e-01,  7.8735042735000005e-01,  7.8803418803400005e-01, \
                                    7.8871794871800005e-01,  7.8940170940200005e-01,  7.9008547008499996e-01, \
                                    7.9076923076899996e-01,  7.9145299145299997e-01,  7.9213675213699997e-01, \
                                    7.9282051281999999e-01,  7.9350427350399999e-01,  7.9418803418799999e-01, \
                                    7.9487179487199999e-01,  7.9555555555599999e-01,  7.9623931623900002e-01, \
                                    7.9692307692300002e-01,  7.9760683760700002e-01,  7.9829059829100002e-01, \
                                    7.9897435897400004e-01,  7.9965811965800004e-01,  8.0034188034200004e-01, \
                                    8.0102564102600005e-01,  8.0170940170899996e-01,  8.0239316239299996e-01, \
                                    8.0307692307699996e-01,  8.0376068376099996e-01,  8.0444444444399998e-01, \
                                    8.0512820512799999e-01,  8.0581196581199999e-01,  8.0649572649599999e-01, \
                                    8.0717948717900001e-01,  8.0786324786300001e-01,  8.0854700854700001e-01, \
                                    8.0923076923100001e-01,  8.0991452991400004e-01,  8.1059829059800004e-01, \
                                    8.1128205128200004e-01,  8.1196581196600004e-01,  8.1264957265000004e-01, \
                                    8.1333333333299995e-01,  8.1401709401699995e-01,  8.1470085470099995e-01, \
                                    8.1538461538499996e-01,  8.1606837606799998e-01,  8.1675213675199998e-01, \
                                    8.1743589743599998e-01,  8.1811965811999998e-01,  8.1880341880300000e-01, \
                                    8.1948717948700001e-01,  8.2017094017100001e-01,  8.2085470085500001e-01, \
                                    8.2153846153800003e-01,  8.2222222222200003e-01,  8.2290598290600003e-01, \
                                    8.2358974359000003e-01,  8.2427350427299995e-01,  8.2495726495699995e-01, \
                                    8.2564102564099995e-01,  8.2632478632499995e-01,  8.2700854700799997e-01, \
                                    8.2769230769199997e-01,  8.2837606837599997e-01,  8.2905982905999998e-01, \
                                    8.2974358974399998e-01,  8.3042735042700000e-01,  8.3111111111100000e-01, \
                                    8.3179487179500000e-01,  8.3247863247900000e-01,  8.3316239316200003e-01, \
                                    8.3384615384600003e-01,  8.3452991453000003e-01,  8.3521367521400003e-01, \
                                    8.3589743589700005e-01,  8.3658119658100005e-01,  8.3726495726500005e-01, \
                                    8.3794871794900005e-01,  8.3863247863199997e-01,  8.3931623931599997e-01, \
                                    8.3999999999999997e-01,  8.4068376068399997e-01,  8.4136752136699999e-01, \
                                    8.4205128205099999e-01,  8.4273504273500000e-01,  8.4341880341900000e-01, \
                                    8.4410256410300000e-01,  8.4478632478600002e-01,  8.4547008547000002e-01, \
                                    8.4615384615400002e-01,  8.4683760683800002e-01,  8.4752136752100005e-01, \
                                    8.4820512820500005e-01,  8.4888888888900005e-01,  8.4957264957300005e-01, \
                                    8.5025641025599996e-01,  8.5094017093999996e-01,  8.5162393162399996e-01, \
                                    8.5230769230799996e-01,  8.5299145299099999e-01,  8.5367521367499999e-01, \
                                    8.5435897435899999e-01,  8.5504273504299999e-01,  8.5572649572600001e-01, \
                                    8.5641025641000001e-01,  8.5709401709400002e-01,  8.5777777777800002e-01, \
                                    8.5846153846100004e-01,  8.5914529914500004e-01,  8.5982905982900004e-01, \
                                    8.6051282051300004e-01,  8.6119658119700004e-01,  8.6188034187999996e-01, \
                                    8.6256410256399996e-01,  8.6324786324799996e-01,  8.6393162393199996e-01, \
                                    8.6461538461499998e-01,  8.6529914529899998e-01,  8.6598290598299998e-01, \
                                    8.6666666666699999e-01,  8.6735042735000001e-01,  8.6803418803400001e-01, \
                                    8.6871794871800001e-01,  8.6940170940200001e-01,  8.7008547008500003e-01, \
                                    8.7076923076900004e-01,  8.7145299145300004e-01,  8.7213675213700004e-01, \
                                    8.7282051281999995e-01,  8.7350427350399995e-01,  8.7418803418799995e-01, \
                                    8.7487179487199995e-01,  8.7555555555599995e-01,  8.7623931623899998e-01, \
                                    8.7692307692299998e-01,  8.7760683760699998e-01,  8.7829059829099998e-01, \
                                    8.7897435897400000e-01,  8.7965811965800000e-01,  8.8034188034200000e-01, \
                                    8.8102564102600001e-01,  8.8170940170900003e-01,  8.8239316239300003e-01, \
                                    8.8307692307700003e-01,  8.8376068376100003e-01,  8.8444444444400006e-01, \
                                    8.8512820512799995e-01,  8.8581196581199995e-01,  8.8649572649599995e-01, \
                                    8.8717948717899997e-01,  8.8786324786299997e-01,  8.8854700854699997e-01, \
                                    8.8923076923099997e-01,  8.8991452991400000e-01,  8.9059829059800000e-01, \
                                    8.9128205128200000e-01,  8.9196581196600000e-01,  8.9264957265000000e-01, \
                                    8.9333333333300002e-01,  8.9401709401700002e-01,  8.9470085470100003e-01, \
                                    8.9538461538500003e-01,  8.9606837606800005e-01,  8.9675213675200005e-01, \
                                    8.9743589743600005e-01,  8.9811965812000005e-01,  8.9880341880299996e-01, \
                                    8.9948717948699997e-01,  9.0017094017099997e-01,  9.0085470085499997e-01, \
                                    9.0153846153799999e-01,  9.0222222222199999e-01,  9.0290598290599999e-01, \
                                    9.0358974358999999e-01,  9.0427350427300002e-01,  9.0495726495700002e-01, \
                                    9.0564102564100002e-01,  9.0632478632500002e-01,  9.0700854700800004e-01, \
                                    9.0769230769200004e-01,  9.0837606837600005e-01,  9.0905982906000005e-01, \
                                    9.0974358974400005e-01,  9.1042735042699996e-01,  9.1111111111099996e-01, \
                                    9.1179487179499996e-01,  9.1247863247899996e-01,  9.1316239316199999e-01, \
                                    9.1384615384599999e-01,  9.1452991452999999e-01,  9.1521367521399999e-01, \
                                    9.1589743589700001e-01,  9.1658119658100001e-01,  9.1726495726500001e-01, \
                                    9.1794871794900001e-01,  9.1863247863200004e-01,  9.1931623931600004e-01, \
                                    9.2000000000000004e-01,  9.2068376068400004e-01,  9.2136752136699995e-01, \
                                    9.2205128205099995e-01,  9.2273504273499996e-01,  9.2341880341899996e-01, \
                                    9.2410256410299996e-01,  9.2478632478599998e-01,  9.2547008546999998e-01, \
                                    9.2615384615399998e-01,  9.2683760683799998e-01,  9.2752136752100001e-01, \
                                    9.2820512820500001e-01,  9.2888888888900001e-01,  9.2957264957300001e-01, \
                                    9.3025641025600003e-01,  9.3094017094000003e-01,  9.3162393162400003e-01, \
                                    9.3230769230800004e-01,  9.3299145299099995e-01,  9.3367521367499995e-01, \
                                    9.3435897435899995e-01,  9.3504273504299995e-01,  9.3572649572599997e-01, \
                                    9.3641025640999997e-01,  9.3709401709399998e-01,  9.3777777777799998e-01, \
                                    9.3846153846100000e-01,  9.3914529914500000e-01,  9.3982905982900000e-01, \
                                    9.4051282051300000e-01,  9.4119658119700000e-01,  9.4188034188000003e-01, \
                                    9.4256410256400003e-01,  9.4324786324800003e-01,  9.4393162393200003e-01, \
                                    9.4461538461500005e-01,  9.4529914529900005e-01,  9.4598290598300006e-01, \
                                    9.4666666666699995e-01,  9.4735042734999997e-01,  9.4803418803399997e-01, \
                                    9.4871794871799997e-01,  9.4940170940199997e-01,  9.5008547008499999e-01, \
                                    9.5076923076900000e-01,  9.5145299145300000e-01,  9.5213675213700000e-01, \
                                    9.5282051282000002e-01,  9.5350427350400002e-01,  9.5418803418800002e-01, \
                                    9.5487179487200002e-01,  9.5555555555500005e-01,  9.5623931623900005e-01, \
                                    9.5692307692300005e-01,  9.5760683760700005e-01,  9.5829059829100005e-01, \
                                    9.5897435897399996e-01,  9.5965811965799996e-01,  9.6034188034199996e-01, \
                                    9.6102564102599997e-01,  9.6170940170899999e-01,  9.6239316239299999e-01, \
                                    9.6307692307699999e-01,  9.6376068376099999e-01,  9.6444444444400002e-01, \
                                    9.6512820512800002e-01,  9.6581196581200002e-01,  9.6649572649600002e-01, \
                                    9.6717948717900004e-01,  9.6786324786300004e-01,  9.6854700854700004e-01, \
                                    9.6923076923100004e-01,  9.6991452991399996e-01,  9.7059829059799996e-01, \
                                    9.7128205128199996e-01,  9.7196581196599996e-01,  9.7264957264999996e-01, \
                                    9.7333333333299998e-01,  9.7401709401699998e-01,  9.7470085470099999e-01, \
                                    9.7538461538499999e-01,  9.7606837606800001e-01,  9.7675213675200001e-01, \
                                    9.7743589743600001e-01,  9.7811965812000001e-01,  9.7880341880300004e-01, \
                                    9.7948717948700004e-01,  9.8017094017100004e-01,  9.8085470085500004e-01, \
                                    9.8153846153799995e-01,  9.8222222222199995e-01,  9.8290598290599995e-01, \
                                    9.8358974358999995e-01,  9.8427350427299998e-01,  9.8495726495699998e-01, \
                                    9.8564102564099998e-01,  9.8632478632499998e-01,  9.8700854700800000e-01, \
                                    9.8769230769200000e-01,  9.8837606837600001e-01,  9.8905982906000001e-01, \
                                    9.8974358974400001e-01,  9.9042735042700003e-01,  9.9111111111100003e-01, \
                                    9.9179487179500003e-01,  9.9247863247900003e-01,  9.9316239316199995e-01, \
                                    9.9384615384599995e-01,  9.9452991452999995e-01,  9.9521367521399995e-01, \
                                    9.9589743589699997e-01,  9.9658119658099997e-01,  9.9726495726499997e-01, \
                                    9.9794871794899997e-01,  9.9863247863200000e-01,  9.9931623931600000e-01, \
                                    1.0000000000000000e+00
                                    };

const Scalar cdfSpearman[20500] = { \
                                    5.0000000000000000e-01,  1.0000000000000000e+00,  1.6666666666700000e-01, \
                                    5.0000000000000000e-01,  5.0000000000000000e-01,  8.3333333333299997e-01, \
                                    1.0000000000000000e+00,  4.1666666667000002e-02,  1.6666666666700000e-01, \
                                    2.0833333333300000e-01,  3.7500000000000000e-01,  4.5833333333300003e-01, \
                                    5.4166666666700003e-01,  6.2500000000000000e-01,  7.9166666666700003e-01, \
                                    8.3333333333299997e-01,  9.5833333333299997e-01,  1.0000000000000000e+00, \
                                    8.3333333329999992e-03,  4.1666666667000002e-02,  6.6666666666999996e-02, \
                                    1.1666666666700000e-01,  1.7499999999999999e-01,  2.2500000000000001e-01, \
                                    2.5833333333300001e-01,  3.4166666666700002e-01,  3.9166666666700001e-01, \
                                    4.7499999999999998e-01,  5.2500000000000002e-01,  6.0833333333299999e-01, \
                                    6.5833333333300004e-01,  7.4166666666699999e-01,  7.7500000000000002e-01, \
                                    8.2499999999999996e-01,  8.8333333333300001e-01,  9.3333333333299995e-01, \
                                    9.5833333333299997e-01,  9.9166666666699999e-01,  1.0000000000000000e+00, \
                                    1.3888888889999999e-03,  8.3333333329999992e-03,  1.6666666667000000e-02, \
                                    2.9166666667000001e-02,  5.1388888888999999e-02,  6.8055555556000000e-02, \
                                    8.7499999999999994e-02,  1.2083333333300000e-01,  1.4861111111100000e-01, \
                                    1.7777777777800000e-01,  2.0972222222199999e-01,  2.4861111111100001e-01, \
                                    2.8194444444400002e-01,  3.2916666666700001e-01,  3.5694444444399998e-01, \
                                    4.0138888888899998e-01,  4.5972222222199999e-01,  5.0000000000000000e-01, \
                                    5.4027777777800001e-01,  5.9861111111099996e-01,  6.4305555555600002e-01, \
                                    6.7083333333299999e-01,  7.1805555555599998e-01,  7.5138888888900002e-01, \
                                    7.9027777777800001e-01,  8.2222222222200003e-01,  8.5138888888900000e-01, \
                                    8.7916666666700005e-01,  9.1249999999999998e-01,  9.3194444444400004e-01, \
                                    9.4861111111100005e-01,  9.7083333333300004e-01,  9.8333333333299999e-01, \
                                    9.9166666666699999e-01,  9.9861111111099998e-01,  1.0000000000000000e+00, \
                                    1.9841269800000000e-04,  1.3888888889999999e-03,  3.3730158730000000e-03, \
                                    6.1507936510000003e-03,  1.1904761905000000e-02,  1.7063492063000001e-02, \
                                    2.4007936508000000e-02,  3.3134920635000002e-02,  4.4047619048000003e-02, \
                                    5.4761904761999998e-02,  6.9444444443999997e-02,  8.3333333332999998e-02, \
                                    1.0000000000000001e-01,  1.1785714285700000e-01,  1.3333333333299999e-01, \
                                    1.5119047619000001e-01,  1.7678571428600001e-01,  1.9781746031700001e-01, \
                                    2.2222222222200000e-01,  2.4880952380999999e-01,  2.7797619047599997e-01, \
                                    2.9742063492100002e-01,  3.3075396825400000e-01,  3.5654761904799998e-01, \
                                    3.9126984126999997e-01,  4.1984126984100001e-01,  4.5317460317500002e-01, \
                                    4.8174603174600000e-01,  5.1825396825400005e-01,  5.4682539682499998e-01, \
                                    5.8015873015899999e-01,  6.0873015873000003e-01,  6.4345238095199997e-01, \
                                    6.6924603174599995e-01,  7.0257936507899998e-01,  7.2202380952400003e-01, \
                                    7.5119047619000001e-01,  7.7777777777799995e-01,  8.0218253968300002e-01, \
                                    8.2321428571400002e-01,  8.4880952380999997e-01,  8.6666666666699999e-01, \
                                    8.8214285714300000e-01,  9.0000000000000002e-01,  9.1666666666700003e-01, \
                                    9.3055555555600000e-01,  9.4523809523799995e-01,  9.5595238095199997e-01, \
                                    9.6686507936499999e-01,  9.7599206349199996e-01,  9.8293650793700005e-01, \
                                    9.8809523809499999e-01,  9.9384920634899998e-01,  9.9662698412700002e-01, \
                                    9.9861111111099998e-01,  9.9980158730199997e-01,  1.0000000000000000e+00, \
                                    2.4801587000000001e-05,  1.9841269800000000e-04,  5.7043650800000004e-04, \
                                    1.1160714290000000e-03,  2.2817460320000002e-03,  3.6210317459999999e-03, \
                                    5.3571428570000001e-03,  7.6884920630000001e-03,  1.0887896825000000e-02, \
                                    1.3963293651000000e-02,  1.8377976189999999e-02,  2.2916666666999999e-02, \
                                    2.8794642857000001e-02,  3.4697420634999997e-02,  4.1542658730000001e-02, \
                                    4.8090277777999998e-02,  5.7490079365000002e-02,  6.6145833333000004e-02, \
                                    7.5570436507999994e-02,  8.5491071429000004e-02,  9.8313492062999996e-02, \
                                    1.0808531746000000e-01,  1.2152777777800000e-01,  1.3373015872999999e-01, \
                                    1.4960317460299999e-01,  1.6341765873000000e-01,  1.7993551587300000e-01, \
                                    1.9469246031699999e-01,  2.1393849206300000e-01,  2.3090277777800000e-01, \
                                    2.5039682539699998e-01,  2.6820436507899997e-01,  2.9107142857099999e-01, \
                                    3.0954861111100002e-01,  3.3229166666700000e-01,  3.5166170634900001e-01, \
                                    3.7601686507900001e-01,  3.9650297619000002e-01,  4.2006448412699998e-01, \
                                    4.4099702381000000e-01,  4.6743551587299997e-01,  4.8839285714300001e-01, \
                                    5.1160714285700004e-01,  5.3256448412699997e-01,  5.5900297618999994e-01, \
                                    5.7993551587299996e-01,  6.0349702381000003e-01,  6.2398313492099999e-01, \
                                    6.4833829365100004e-01,  6.6770833333299995e-01,  6.9045138888900004e-01, \
                                    7.0892857142900001e-01,  7.3179563492099997e-01,  7.4960317460299997e-01, \
                                    7.6909722222200005e-01,  7.8606150793700003e-01,  8.0530753968299995e-01, \
                                    8.2006448412699995e-01,  8.3658234126999997e-01,  8.5039682539700001e-01, \
                                    8.6626984126999995e-01,  8.7847222222200005e-01,  8.9191468253999995e-01, \
                                    9.0168650793700000e-01,  9.1450892857099997e-01,  9.2442956349200001e-01, \
                                    9.3385416666700005e-01,  9.4250992063500005e-01,  9.5190972222199999e-01, \
                                    9.5845734127000004e-01,  9.6530257936499997e-01,  9.7120535714300005e-01, \
                                    9.7708333333300001e-01,  9.8162202380999997e-01,  9.8603670634899998e-01, \
                                    9.8911210317499998e-01,  9.9231150793699996e-01,  9.9464285714300005e-01, \
                                    9.9637896825399996e-01,  9.9771825396799996e-01,  9.9888392857099995e-01, \
                                    9.9942956349199996e-01,  9.9980158730199997e-01,  9.9997519841299998e-01, \
                                    1.0000000000000000e+00,  2.7557320000000002e-06,  2.4801587000000001e-05, \
                                    8.2671958000000002e-05,  1.7636684300000000e-04,  3.7477954100000000e-04, \
                                    6.5586419800000000e-04,  1.0141093469999999e-03,  1.5376984130000000e-03, \
                                    2.2541887130000000e-03,  3.0368165780000002e-03,  4.1335978840000001e-03, \
                                    5.3847001760000002e-03,  6.9141313930000002e-03,  8.6116622570000002e-03, \
                                    1.0694995590999999e-02,  1.2745260140999999e-02,  1.5561618165999999e-02, \
                                    1.8433090829000000e-02,  2.1626984126999999e-02,  2.5159832451000001e-02, \
                                    2.9444995591000001e-02,  3.3280974427000003e-02,  3.8018077600999997e-02, \
                                    4.2862654320999997e-02,  4.8398919753000001e-02,  5.3998567019000000e-02, \
                                    6.0287147265999999e-02,  6.6388337743000000e-02,  7.3762676366999999e-02, \
                                    8.0900022045999997e-02,  8.8831018518999993e-02,  9.6899801586999998e-02, \
                                    1.0626102292800001e-01,  1.1490850969999999e-01,  1.2495866402100000e-01, \
                                    1.3479111552000000e-01,  1.4559634038800001e-01,  1.5625000000000000e-01, \
                                    1.6812996031700000e-01,  1.7929067460299999e-01,  1.9266148589099999e-01, \
                                    2.0504023368600000e-01,  2.1831183862400000e-01,  2.3149526014100000e-01, \
                                    2.4666556437400000e-01,  2.6031746031699998e-01,  2.7585427689600001e-01, \
                                    2.9047067901200002e-01,  3.0670194003500001e-01,  3.2181988536200001e-01, \
                                    3.3887235449699998e-01,  3.5403439153400001e-01,  3.7177028218699998e-01, \
                                    3.8781415343900000e-01,  4.0499063051099998e-01,  4.2159115961200000e-01, \
                                    4.4004629629600001e-01,  4.5580908289200001e-01,  4.7419532627900002e-01, \
                                    4.9078483245100002e-01,  5.0921516754899998e-01,  5.2580467372100004e-01, \
                                    5.4419091710800005e-01,  5.5995370370399999e-01,  5.7840884038800000e-01, \
                                    5.9500936948899996e-01,  6.1218584656099995e-01,  6.2822971781299997e-01, \
                                    6.4596560846600004e-01,  6.6112764550299996e-01,  6.7818011463799999e-01, \
                                    6.9329805996500005e-01,  7.0952932098800003e-01,  7.2414572310400005e-01, \
                                    7.3968253968300002e-01,  7.5333443562600000e-01,  7.6850473985900003e-01, \
                                    7.8168816137599995e-01,  7.9495976631400000e-01,  8.0733851410900004e-01, \
                                    8.2070932539700003e-01,  8.3187003968300000e-01,  8.4375000000000000e-01, \
                                    8.5440365961200004e-01,  8.6520888448000000e-01,  8.7504133597900002e-01, \
                                    8.8509149030000001e-01,  8.9373897707200001e-01,  9.0310019841300004e-01, \
                                    9.1116898148100001e-01,  9.1909997795400000e-01,  9.2623732363300004e-01, \
                                    9.3361166225699999e-01,  9.3971285273399996e-01,  9.4600143298100003e-01, \
                                    9.5160108024699996e-01,  9.5713734567900000e-01,  9.6198192239900004e-01, \
                                    9.6671902557300005e-01,  9.7055500440900000e-01,  9.7484016754900005e-01, \
                                    9.7837301587299996e-01,  9.8156690917099998e-01,  9.8443838183400001e-01, \
                                    9.8725473985900003e-01,  9.8930500440900004e-01,  9.9138833774299995e-01, \
                                    9.9308586860699999e-01,  9.9461529982399999e-01,  9.9586640211599997e-01, \
                                    9.9696318342199997e-01,  9.9774581128700002e-01,  9.9846230158700000e-01, \
                                    9.9898589065300003e-01,  9.9934413580199999e-01,  9.9962522045900004e-01, \
                                    9.9982363315699996e-01,  9.9991732804199995e-01,  9.9997519841299998e-01, \
                                    9.9999724426799996e-01,  1.0000000000000000e+00,  2.7557300000000000e-07, \
                                    2.7557320000000002e-06,  1.0471781000000000e-05,  2.4526014000000000e-05, \
                                    5.4012345999999997e-05,  1.0278880100000000e-04,  1.6727292800000000e-04, \
                                    2.6647927700000000e-04,  4.0371472700000003e-04,  5.7429453299999997e-04, \
                                    7.9998897699999996e-04,  1.0865850970000000e-03,  1.4316027340000000e-03, \
                                    1.8526785710000001e-03,  2.3553240739999999e-03,  2.9092261900000001e-03, \
                                    3.6072530860000000e-03,  4.3890542330000002e-03,  5.2653769840000000e-03, \
                                    6.2783840390000000e-03,  7.4647266310000002e-03,  8.7028769839999996e-03, \
                                    1.0116567460000000e-02,  1.1679618607000000e-02,  1.3376047178000000e-02, \
                                    1.5279982363000001e-02,  1.7325837742999999e-02,  1.9483575837999999e-02, \
                                    2.1901179452999998e-02,  2.4489362875000000e-02,  2.7215332892000000e-02, \
                                    3.0157903438999999e-02,  3.3367504409000000e-02,  3.6713238535999997e-02, \
                                    4.0302854938000003e-02,  4.4138282628000000e-02,  4.8139329805999997e-02, \
                                    5.2441302910000001e-02,  5.6927083332999999e-02,  6.1551201499000001e-02, \
                                    6.6700562168999999e-02,  7.2013613315999994e-02,  7.7410989858999996e-02, \
                                    8.3141534392000005e-02,  8.9310240299999996e-02,  9.5619764108999999e-02, \
                                    1.0221919091700001e-01,  1.0910025352699999e-01,  1.1626846340400000e-01, \
                                    1.2373539462100000e-01,  1.3158013668400001e-01,  1.3941385581999999e-01, \
                                    1.4782986111099999e-01,  1.5644758597899999e-01,  1.6520364858900000e-01, \
                                    1.7437031525600000e-01,  1.8394593254000000e-01,  1.9345293209900000e-01, \
                                    2.0345596340399999e-01,  2.1354083994699999e-01,  2.2413828262800001e-01, \
                                    2.3486524470900000e-01,  2.4588376322800001e-01,  2.5673748897699999e-01, \
                                    2.6833030202800001e-01,  2.8013806216900000e-01,  2.9182897927700002e-01, \
                                    3.0365795855400002e-01,  3.1607087742500001e-01,  3.2835703262799998e-01, \
                                    3.4104442239900001e-01,  3.5358190035300002e-01,  3.6650352733699998e-01, \
                                    3.7946538800700003e-01,  3.9251129850100003e-01,  4.0564125881800001e-01, \
                                    4.1911320546699998e-01,  4.3257220017600001e-01,  4.4581183862399998e-01, \
                                    4.5918816137599999e-01,  4.7298500881799999e-01,  4.8647982804200002e-01, \
                                    5.0000000000000000e-01,  5.1352017195800004e-01,  5.2701499118200001e-01, \
                                    5.4081183862399995e-01,  5.5418816137600002e-01,  5.6742779982400005e-01, \
                                    5.8088679453299996e-01,  5.9435874118200005e-01,  6.0748870149900003e-01, \
                                    6.2053461199299997e-01,  6.3349647266300002e-01,  6.4641809964700003e-01, \
                                    6.5895557760099999e-01,  6.7164296737200002e-01,  6.8392912257500005e-01, \
                                    6.9634204144599998e-01,  7.0817102072299998e-01,  7.1986193783100005e-01, \
                                    7.3166969797199999e-01,  7.4326251102300001e-01,  7.5411623677200001e-01, \
                                    7.6513475529099995e-01,  7.7586171737200005e-01,  7.8645916005299998e-01, \
                                    7.9654403659600004e-01,  8.0654706790099995e-01,  8.1605406745999998e-01, \
                                    8.2562968474400000e-01,  8.3479635141099995e-01,  8.4355241402100001e-01, \
                                    8.5217013888899995e-01,  8.6058614418000001e-01,  8.6841986331599996e-01, \
                                    8.7626460537899997e-01,  8.8373153659600001e-01,  8.9089974647299996e-01, \
                                    8.9778080908299995e-01,  9.0438023589100003e-01,  9.1068975969999999e-01, \
                                    9.1685846560800000e-01,  9.2258901014100003e-01,  9.2798638668400002e-01, \
                                    9.3329943783100000e-01,  9.3844879850100005e-01,  9.4307291666699999e-01, \
                                    9.4755869708999996e-01,  9.5186067019400000e-01,  9.5586171737199999e-01, \
                                    9.5969714506199999e-01,  9.6328676146400005e-01,  9.6663249559099995e-01, \
                                    9.6984209656099996e-01,  9.7278466710800005e-01,  9.7551063712499997e-01, \
                                    9.7809882054700004e-01,  9.8051642416200002e-01,  9.8267416225699999e-01, \
                                    9.8472001763700001e-01,  9.8662395282199999e-01,  9.8832038139300005e-01, \
                                    9.8988343254000000e-01,  9.9129712301600004e-01,  9.9253527336900005e-01, \
                                    9.9372161596099995e-01,  9.9473462301600002e-01,  9.9561094576700004e-01, \
                                    9.9639274691400004e-01,  9.9709077381000000e-01,  9.9764467592600004e-01, \
                                    9.9814732142899998e-01,  9.9856839726600000e-01,  9.9891341490300001e-01, \
                                    9.9920001102300005e-01,  9.9942570546700005e-01,  9.9959628527300004e-01, \
                                    9.9973352072300004e-01,  9.9983272707199999e-01,  9.9989721119899999e-01, \
                                    9.9994598765400000e-01,  9.9997547398599995e-01,  9.9998952821900000e-01, \
                                    9.9999724426799996e-01,  9.9999972442700003e-01,  1.0000000000000000e+00, \
                                    2.5052000000000002e-08,  2.7557300000000000e-07,  1.1774490000000000e-06, \
                                    3.0313050000000000e-06,  6.9394339999999997e-06,  1.4154441000000000e-05, \
                                    2.4400753999999999e-05,  4.0534310999999999e-05,  6.3832772000000000e-05, \
                                    9.5047698999999999e-05,  1.3603294899999999e-04,  1.9209956700000000e-04, \
                                    2.6009098899999999e-04,  3.4717211799999999e-04,  4.5234086900000002e-04, \
                                    5.7890412100000004e-04,  7.2989317799999995e-04,  9.1292388200000000e-04, \
                                    1.1185265349999999e-03,  1.3644380310000000e-03,  1.6496312330000001e-03, \
                                    1.9703984290000000e-03,  2.3259630029999999e-03,  2.7456359230000000e-03, \
                                    3.1985529899999999e-03,  3.7213403879999998e-03,  4.2870169950000002e-03, \
                                    4.9229898189999998e-03,  5.6077390969999997e-03,  6.3871602930000004e-03, \
                                    7.2000511060000003e-03,  8.1167578560000005e-03,  9.0972973790000005e-03, \
                                    1.0177193563000000e-02,  1.1298976872000000e-02,  1.2564809804000000e-02, \
                                    1.3866617564999999e-02,  1.5305660774000000e-02,  1.6792453302999999e-02, \
                                    1.8424047018000000e-02,  2.0124333614000001e-02,  2.1993170794999999e-02, \
                                    2.3878692680999999e-02,  2.5956614759000001e-02,  2.8114177489000001e-02, \
                                    3.0445476591000002e-02,  3.2805886243000001e-02,  3.5407848324999998e-02, \
                                    3.8046161015000003e-02,  4.0907011584000001e-02,  4.3818392255999997e-02, \
                                    4.6958223104000003e-02,  5.0155448333000001e-02,  5.3624413780999997e-02, \
                                    5.7089546255999997e-02,  6.0865750762000001e-02,  6.4682514629999993e-02, \
                                    6.8764505170999995e-02,  7.2856291084999997e-02,  7.7288009059000004e-02, \
                                    8.1747785394000003e-02,  8.6520161937000004e-02,  9.1283870451000004e-02, \
                                    9.6388337742999999e-02,  1.0152068803100001e-01,  1.0703846500700000e-01, \
                                    1.1247589987200000e-01,  1.1831093674800000e-01,  1.2415895061700000e-01, \
                                    1.3037508016700000e-01,  1.3652507215000001e-01,  1.4311092071500001e-01, \
                                    1.4964859407600001e-01,  1.5659308862400001e-01,  1.6342840608500001e-01, \
                                    1.7075860289399999e-01,  1.7798335537900001e-01,  1.8566773889700000e-01, \
                                    1.9316849046000001e-01,  2.0117474346600001e-01,  2.0906430375200000e-01, \
                                    2.1741251803799999e-01,  2.2553834475699999e-01,  2.3420176467100001e-01, \
                                    2.4267676767700000e-01,  2.5169778138499999e-01,  2.6038860830499999e-01, \
                                    2.6965688632399998e-01,  2.7870608365400001e-01,  2.8826752144500001e-01, \
                                    2.9752294773100002e-01,  3.0732814253599999e-01,  3.1683108365399998e-01, \
                                    3.2690518779099997e-01,  3.3655786535999999e-01,  3.4685643638800001e-01, \
                                    3.5679090007199998e-01,  3.6726493606700000e-01,  3.7725869809200002e-01, \
                                    3.8792698813499998e-01,  3.9819652376900000e-01,  4.0896472162100000e-01, \
                                    4.1924628226700000e-01,  4.3016644620799999e-01,  4.4060052409000000e-01, \
                                    4.5162560626100001e-01,  4.6206970498599997e-01,  4.7310215247699999e-01, \
                                    4.8365379990399998e-01,  4.9473304473300000e-01,  5.0526695526700005e-01, \
                                    5.1634620009599996e-01,  5.2689784752299995e-01,  5.3793029501400003e-01, \
                                    5.4837439373899999e-01,  5.5939947591000005e-01,  5.6983355379199996e-01, \
                                    5.8075371773300000e-01,  5.9103527837900005e-01,  6.0180347623099995e-01, \
                                    6.1207301186499996e-01,  6.2274130190800003e-01,  6.3273506393300005e-01, \
                                    6.4320909992800002e-01,  6.5314356361199999e-01,  6.6344213464000001e-01, \
                                    6.7309481220900003e-01,  6.8316891634599997e-01,  6.9267185746399995e-01, \
                                    7.0247705226900004e-01,  7.1173247855499999e-01,  7.2129391634600004e-01, \
                                    7.3034311367600002e-01,  7.3961139169500001e-01,  7.4830221861500001e-01, \
                                    7.5732323232300003e-01,  7.6579823532900004e-01,  7.7446165524300004e-01, \
                                    7.8258748196200001e-01,  7.9093569624799998e-01,  7.9882525653400005e-01, \
                                    8.0683150954000005e-01,  8.1433226110300005e-01,  8.2201664462099999e-01, \
                                    8.2924139710599998e-01,  8.3657159391500002e-01,  8.4340691137599999e-01, \
                                    8.5035140592400005e-01,  8.5688907928500002e-01,  8.6347492785000002e-01, \
                                    8.6962491983300005e-01,  8.7584104938300000e-01,  8.8168906325200003e-01, \
                                    8.8752410012799998e-01,  8.9296153499300002e-01,  8.9847931196899999e-01, \
                                    9.0361166225699996e-01,  9.0871612954900005e-01,  9.1347983806300004e-01, \
                                    9.1825221460600004e-01,  9.2271199094099998e-01,  9.2714370891499998e-01, \
                                    9.3123549482900003e-01,  9.3531748537000003e-01,  9.3913424923800004e-01, \
                                    9.4291045374399995e-01,  9.4637558621899998e-01,  9.4984455166699999e-01, \
                                    9.5304177689600000e-01,  9.5618160774399996e-01,  9.5909298841599999e-01, \
                                    9.6195383898499998e-01,  9.6459215167500001e-01,  9.6719411375700004e-01, \
                                    9.6955452340899995e-01,  9.7188582251099997e-01,  9.7404338524099998e-01, \
                                    9.7612130731900004e-01,  9.7800682920500004e-01,  9.7987566638599999e-01, \
                                    9.8157595298199996e-01,  9.8320754669699995e-01,  9.8469433922600003e-01, \
                                    9.8613338243500004e-01,  9.8743519019600001e-01,  9.8870102312800001e-01, \
                                    9.8982280643700005e-01,  9.9090270262100000e-01,  9.9188324214400003e-01, \
                                    9.9279994889400003e-01,  9.9361283970699998e-01,  9.9439226090300004e-01, \
                                    9.9507701018100003e-01,  9.9571298300500000e-01,  9.9627865961200002e-01, \
                                    9.9680144700999995e-01,  9.9725436407699997e-01,  9.9767403699699997e-01, \
                                    9.9802960157099996e-01,  9.9835036876700001e-01,  9.9863556196900005e-01, \
                                    9.9888147346500000e-01,  9.9908707611799996e-01,  9.9927010682200001e-01, \
                                    9.9942109587899997e-01,  9.9954765913099997e-01,  9.9965282788200005e-01, \
                                    9.9973990901099996e-01,  9.9980790043300005e-01,  9.9986396705100000e-01, \
                                    9.9990495230099996e-01,  9.9993616722800005e-01,  9.9995946568899996e-01, \
                                    9.9997559924599999e-01,  9.9998584555900005e-01,  9.9999306056600001e-01, \
                                    9.9999696869499999e-01,  9.9999882255100003e-01,  9.9999972442700003e-01, \
                                    9.9999997494799997e-01,  1.0000000000000000e+00,  2.0879999999999998e-09, \
                                    2.5052000000000002e-08,  1.1899800000000000e-07,  3.3611600000000002e-07, \
                                    8.0375499999999996e-07,  1.7369460000000000e-06,  3.1795300000000002e-06, \
                                    5.4884989999999998e-06,  9.0062330000000005e-06,  1.3941498000000000e-05, \
                                    2.0630411000000002e-05,  3.0056266999999999e-05,  4.1947667999999997e-05, \
                                    5.7582271000000000e-05,  7.7099950999999996e-05,  1.0147147700000000e-04, \
                                    1.3067805999999999e-04,  1.6749839699999999e-04,  2.0971955000000000e-04, \
                                    2.6139787400000000e-04,  3.2197596000000002e-04,  3.9283584899999998e-04, \
                                    4.7243057200000002e-04,  5.6822148399999996e-04,  6.7330464000000005e-04, \
                                    7.9599525300000004e-04,  9.3243947400000003e-04,  1.0888857159999999e-03, \
                                    1.2587745010000000e-03,  1.4560473280000000e-03,  1.6659902600000001e-03, \
                                    1.9065364289999999e-03,  2.1656587370000001e-03,  2.4574844840000000e-03, \
                                    2.7663101749999999e-03,  3.1188664090000002e-03,  3.4868025490000002e-03, \
                                    3.8989995019999999e-03,  4.3333947110000002e-03,  4.8154265040000000e-03, \
                                    5.3185730490000003e-03,  5.8828989299999999e-03,  6.4615796689999998e-03, \
                                    7.1041015309999999e-03,  7.7728466879999998e-03,  8.5074705390000005e-03, \
                                    9.2612007980000001e-03,  1.0097239758999999e-02,  1.0950343381000000e-02, \
                                    1.1887745260000001e-02,  1.2850192985000000e-02,  1.3900558996000000e-02, \
                                    1.4971077341000000e-02,  1.6148140214999999e-02,  1.7337171734000002e-02, \
                                    1.8638332314999999e-02,  1.9962995947999999e-02,  2.1400239582000002e-02, \
                                    2.2852266047000001e-02,  2.4440784749000001e-02,  2.6038006971000002e-02, \
                                    2.7775844590000001e-02,  2.9526256280000000e-02,  3.1422692533999999e-02, \
                                    3.3328331262000001e-02,  3.5403236648999997e-02,  3.7475945800999999e-02, \
                                    3.9717144995000002e-02,  4.1969348327999999e-02,  4.4397597002000001e-02, \
                                    4.6823785139999997e-02,  4.9453884913999997e-02,  5.2069022315999997e-02, \
                                    5.4891493056000003e-02,  5.7704786372000001e-02,  6.0736705263999997e-02, \
                                    6.3753517733999995e-02,  6.7002623790999999e-02,  7.0219650622999993e-02, \
                                    7.3679634891000004e-02,  7.7116907334000007e-02,  8.0804383534000004e-02, \
                                    8.4448150069000000e-02,  8.8366441781999996e-02,  9.2232771248000001e-02, \
                                    9.6383713541000005e-02,  1.0047718838500000e-01,  1.0485573325899999e-01, \
                                    1.0917157688000000e-01,  1.1379698731700000e-01,  1.1834369238000000e-01, \
                                    1.2320557593100000e-01,  1.2798179170999999e-01,  1.3308126736900000e-01, \
                                    1.3808235296099999e-01,  1.4343051046200000e-01,  1.4866673931800001e-01, \
                                    1.5424424260799999e-01,  1.5970226195500001e-01,  1.6552030723899999e-01, \
                                    1.7120736757499999e-01,  1.7726941830699999e-01,  1.8317206247300000e-01, \
                                    1.8945684732599999e-01,  1.9558152832900000e-01,  2.0209397630400000e-01, \
                                    2.0843524530999999e-01,  2.1516400154000001e-01,  2.2170912790299999e-01, \
                                    2.2864726130400001e-01,  2.3540095481900000e-01,  2.4256179937600000e-01, \
                                    2.4950036075000001e-01,  2.5685664515500001e-01,  2.6397963180099998e-01, \
                                    2.7153186335899998e-01,  2.7884213747900000e-01,  2.8657333294900000e-01, \
                                    2.9404547500500000e-01,  3.0194704777600001e-01,  3.0959141472599999e-01, \
                                    3.1766470508700001e-01,  3.2544681687900001e-01,  3.3365477484799999e-01, \
                                    3.4158000933600002e-01,  3.4994144069700001e-01,  3.5799476661500002e-01, \
                                    3.6647403265500000e-01,  3.7463150018699998e-01,  3.8321833371699998e-01, \
                                    3.9149146683399999e-01,  4.0019255259300002e-01,  4.0853938692500003e-01, \
                                    4.1730890669300003e-01,  4.2572803932199998e-01,  4.3457928741800000e-01, \
                                    4.4306677681200002e-01,  4.5195857592100003e-01,  4.6048714242299998e-01, \
                                    4.6941937354699997e-01,  4.7798003806299999e-01,  4.8694545279200002e-01, \
                                    4.9551289181500002e-01,  5.0448710818499998e-01,  5.1305454720800003e-01, \
                                    5.2201996193699995e-01,  5.3058062645299997e-01,  5.3951285757699996e-01, \
                                    5.4804142407900003e-01,  5.5693322318799998e-01,  5.6542071258200000e-01, \
                                    5.7427196067800002e-01,  5.8269109330699997e-01,  5.9146061307499997e-01, \
                                    5.9980744740699998e-01,  6.0850853316599995e-01,  6.1678166628300002e-01, \
                                    6.2536849981300002e-01,  6.3352596734500000e-01,  6.4200523338500004e-01, \
                                    6.5005855930300005e-01,  6.5841999066400003e-01,  6.6634522515200001e-01, \
                                    6.7455318312099999e-01,  6.8233529491300005e-01,  6.9040858527399995e-01, \
                                    6.9805295222399999e-01,  7.0595452499500000e-01,  7.1342666705100000e-01, \
                                    7.2115786252100000e-01,  7.2846813664099996e-01,  7.3602036819899996e-01, \
                                    7.4314335484500005e-01,  7.5049963924999996e-01,  7.5743820062400002e-01, \
                                    7.6459904518099997e-01,  7.7135273869599996e-01,  7.7829087209699999e-01, \
                                    7.8483599845999996e-01,  7.9156475468999998e-01,  7.9790602369600006e-01, \
                                    8.0441847167100000e-01,  8.1054315267400001e-01,  8.1682793752700000e-01, \
                                    8.2273058169299995e-01,  8.2879263242500001e-01,  8.3447969276099998e-01, \
                                    8.4029773804499996e-01,  8.4575575739200004e-01,  8.5133326068199999e-01, \
                                    8.5656948953800005e-01,  8.6191764703899998e-01,  8.6691873263100006e-01, \
                                    8.7201820828999999e-01,  8.7679442406899999e-01,  8.8165630762000002e-01, \
                                    8.8620301268299995e-01,  8.9082842311999999e-01,  8.9514426674100001e-01, \
                                    8.9952281161500003e-01,  9.0361628645900005e-01,  9.0776722875200000e-01, \
                                    9.1163355821799996e-01,  9.1555184993100003e-01,  9.1919561646600001e-01, \
                                    9.2288309266599999e-01,  9.2632036510899995e-01,  9.2978034937700005e-01, \
                                    9.3299737620900003e-01,  9.3624648226600005e-01,  9.3926329473600001e-01, \
                                    9.4229521362799995e-01,  9.4510850694399995e-01,  9.4793097768400003e-01, \
                                    9.5054611508599995e-01,  9.5317621486000004e-01,  9.5560240299800003e-01, \
                                    9.5803065167199997e-01,  9.6028285500499999e-01,  9.6252405419900000e-01, \
                                    9.6459676335099998e-01,  9.6667166873800003e-01,  9.6857730746600001e-01, \
                                    9.7047374371999995e-01,  9.7222415540999996e-01,  9.7396199302899999e-01, \
                                    9.7555921525099998e-01,  9.7714773395300003e-01,  9.7859976041800001e-01, \
                                    9.8003700405200000e-01,  9.8136166768499999e-01,  9.8266282826600004e-01, \
                                    9.8385185978500000e-01,  9.8502892265899999e-01,  9.8609944100400004e-01, \
                                    9.8714980701499999e-01,  9.8811225473999997e-01,  9.8904965661900002e-01, \
                                    9.8990276024099999e-01,  9.9073879920200003e-01,  9.9149252946099997e-01, \
                                    9.9222715331199995e-01,  9.9289589846899995e-01,  9.9353842033100004e-01, \
                                    9.9411710106999995e-01,  9.9468142695100004e-01,  9.9518457349599998e-01, \
                                    9.9566660528899997e-01,  9.9610100049799999e-01,  9.9651319745099998e-01, \
                                    9.9688113359099995e-01,  9.9723368982500005e-01,  9.9754251551600004e-01, \
                                    9.9783434126299997e-01,  9.9809346357100004e-01,  9.9833400973999997e-01, \
                                    9.9854395267200002e-01,  9.9874122549900002e-01,  9.9891111428400003e-01, \
                                    9.9906756052599999e-01,  9.9920400474700000e-01,  9.9932669535999996e-01, \
                                    9.9943177851599996e-01,  9.9952756942800003e-01,  9.9960716415100004e-01, \
                                    9.9967802403999995e-01,  9.9973860212599996e-01,  9.9979028044999996e-01, \
                                    9.9983250160299997e-01,  9.9986932194000000e-01,  9.9989852852299999e-01, \
                                    9.9992290004899997e-01,  9.9994241772900005e-01,  9.9995805233199997e-01, \
                                    9.9996994373299997e-01,  9.9997936958900002e-01,  9.9998605850199995e-01, \
                                    9.9999099376699996e-01,  9.9999451150100005e-01,  9.9999682047000005e-01, \
                                    9.9999826305399997e-01,  9.9999919624500000e-01,  9.9999966388399997e-01, \
                                    9.9999988100199999e-01,  9.9999997494799997e-01,  9.9999999791200000e-01, \
                                    1.0000000000000000e+00,  1.6100000000000001e-10,  2.0879999999999998e-09, \
                                    1.0920000000000000e-08,  3.3723999999999998e-08,  8.4630999999999999e-08, \
                                    1.9222699999999999e-07,  3.7321199999999999e-07,  6.6934099999999996e-07, \
                                    1.1432430000000000e-06,  1.8353879999999999e-06,  2.8130629999999998e-06, \
                                    4.2114839999999998e-06,  6.0722460000000001e-06,  8.5482289999999999e-06, \
                                    1.1762607000000001e-05,  1.5868905000000000e-05,  2.0954322000000000e-05, \
                                    2.7416803000000000e-05,  3.5129158000000001e-05,  4.4649601999999999e-05, \
                                    5.6067903000000001e-05,  6.9722266000000002e-05,  8.5511518000000005e-05, \
                                    1.0454823000000001e-04,  1.2622119399999999e-04,  1.5160090700000001e-04, \
                                    1.8055696899999999e-04,  2.1400924200000001e-04,  2.5146471299999999e-04, \
                                    2.9481064199999999e-04,  3.4251371100000000e-04,  3.9710996299999998e-04, \
                                    4.5748185099999999e-04,  5.2566983600000000e-04,  5.9989923300000003e-04, \
                                    6.8419989900000001e-04,  7.7525130500000000e-04,  8.7702485299999996e-04, \
                                    9.8719744099999996e-04,  1.1094565480000000e-03,  1.2406761190000000e-03, \
                                    1.3867723069999999e-03,  1.5417099620000001e-03,  1.7128980839999999e-03, \
                                    1.8957336710000001e-03,  2.0957859980000001e-03,  2.3069903669999999e-03, \
                                    2.5393685850000000e-03,  2.7838999669999999e-03,  3.0504081499999999e-03, \
                                    3.3309670330000001e-03,  3.6355255149999998e-03,  3.9545234860000004e-03, \
                                    4.3017540589999998e-03,  4.6623793190000004e-03,  5.0529664199999999e-03, \
                                    5.4614808740000003e-03,  5.9006742039999999e-03,  6.3560123330000003e-03, \
                                    6.8487327040000004e-03,  7.3578983389999998e-03,  7.9052856219999999e-03, \
                                    8.4715051860000008e-03,  9.0790502899999997e-03,  9.7053167060000001e-03, \
                                    1.0378662457999999e-02,  1.1069082185000001e-02,  1.1807973887000001e-02, \
                                    1.2570101420000000e-02,  1.3381971520000001e-02,  1.4212967941000000e-02, \
                                    1.5103597695000000e-02,  1.6014159611999999e-02,  1.6983885938000001e-02, \
                                    1.7976063449000001e-02,  1.9031398931999999e-02,  2.0109931059999999e-02, \
                                    2.1257760532999999e-02,  2.2425522329999999e-02,  2.3665583067000000e-02, \
                                    2.4931876411999999e-02,  2.6272331546000002e-02,  2.7632628913000001e-02, \
                                    2.9078765081000001e-02,  3.0546290290000000e-02,  3.2098092076000000e-02, \
                                    3.3673884628999999e-02,  3.5338442100999998e-02,  3.7026778679999997e-02, \
                                    3.8811523963000000e-02,  4.0614214586000001e-02,  4.2518454892999998e-02, \
                                    4.4447542394999998e-02,  4.6478375181000002e-02,  4.8526619181999998e-02, \
                                    5.0688776083999999e-02,  5.2871392529000000e-02,  5.5164395307999999e-02, \
                                    5.7477799656999999e-02,  5.9909514033000003e-02,  6.2360015562999999e-02, \
                                    6.4937205284000002e-02,  6.7523608722000000e-02,  7.0241434556000001e-02, \
                                    7.2978556937000005e-02,  7.5843658977000003e-02,  7.8718811730999996e-02, \
                                    8.1735833610999994e-02,  8.4765501344999994e-02,  8.7932546170000001e-02, \
                                    9.1108320049000005e-02,  9.4433007836000005e-02,  9.7762854590000003e-02, \
                                    1.0124634833399999e-01,  1.0472550372700000e-01,  1.0836304738200001e-01, \
                                    1.1200681198900000e-01,  1.1580605190800000e-01,  1.1959696135900000e-01, \
                                    1.2355704866099999e-01,  1.2751111928200001e-01,  1.3163127574600000e-01, \
                                    1.3573693812000001e-01,  1.4001761371999999e-01,  1.4428475652400000e-01, \
                                    1.4872800103700001e-01,  1.5314718010900000e-01,  1.5774652591499999e-01, \
                                    1.6233033443500000e-01,  1.6709076272900000e-01,  1.7181912319900000e-01, \
                                    1.7674002791200000e-01,  1.8162896436800000e-01,  1.8670404553700001e-01, \
                                    1.9173587408000001e-01,  1.9696541273800000e-01,  2.0215568237699999e-01, \
                                    2.0753556130699999e-01,  2.1286309787200000e-01,  2.1838988589899999e-01, \
                                    2.2386754657999999e-01,  2.2954316051099999e-01,  2.3514921790500001e-01, \
                                    2.4096869228400000e-01,  2.4672151279800000e-01,  2.5267243719499999e-01, \
                                    2.5854752099099998e-01,  2.6462959959900001e-01,  2.7064093089300001e-01, \
                                    2.7685272835399999e-01,  2.8297357943599999e-01,  2.8930901611900001e-01, \
                                    2.9555395784100003e-01,  3.0200664738400002e-01,  3.0835075787799998e-01, \
                                    3.1491153859600002e-01,  3.2137747444199999e-01,  3.2804124213000002e-01, \
                                    3.3458838920200001e-01,  3.4135116892500000e-01,  3.4800040205400001e-01, \
                                    3.5485321231000000e-01,  3.6157450863200002e-01,  3.6851114067300000e-01, \
                                    3.7531961078400000e-01,  3.8233215649399999e-01,  3.8920193939300002e-01, \
                                    3.9627811007199998e-01,  4.0322095840799999e-01,  4.1036183225900003e-01, \
                                    4.1734138241500002e-01,  4.2453405760300000e-01,  4.3157340922999998e-01, \
                                    4.3880777690700001e-01,  4.4587359094700002e-01,  4.5314183389300000e-01, \
                                    4.6024927458100001e-01,  4.6754211548500002e-01,  4.7466056031199999e-01, \
                                    4.8196998217800002e-01,  4.8911177797900002e-01,  4.9643447939000002e-01, \
                                    5.0356552061000004e-01,  5.1088822202100004e-01,  5.1803001782199998e-01, \
                                    5.2533943968800001e-01,  5.3245788451499998e-01,  5.3975072541900004e-01, \
                                    5.4685816610700000e-01,  5.5412640905300004e-01,  5.6119222309299999e-01, \
                                    5.6842659077000002e-01,  5.7546594239700000e-01,  5.8265861758500004e-01, \
                                    5.8963816774099997e-01,  5.9677904159200001e-01,  6.0372188992800002e-01, \
                                    6.1079806060700004e-01,  6.1766784350600001e-01,  6.2468038921600000e-01, \
                                    6.3148885932700005e-01,  6.3842549136799998e-01,  6.4514678769000000e-01, \
                                    6.5199959794600004e-01,  6.5864883107500005e-01,  6.6541161079800004e-01, \
                                    6.7195875787000003e-01,  6.7862252555799996e-01,  6.8508846140400004e-01, \
                                    6.9164924212199996e-01,  6.9799335261600004e-01,  7.0444604215899997e-01, \
                                    7.1069098388100005e-01,  7.1702642056400001e-01,  7.2314727164600001e-01, \
                                    7.2935906910699999e-01,  7.3537040040099999e-01,  7.4145247900900002e-01, \
                                    7.4732756280500001e-01,  7.5327848720199997e-01,  7.5903130771600003e-01, \
                                    7.6485078209500001e-01,  7.7045683948900001e-01,  7.7613245342000003e-01, \
                                    7.8161011410100001e-01,  7.8713690212800003e-01,  7.9246443869299998e-01, \
                                    7.9784431762300001e-01,  8.0303458726200005e-01,  8.0826412591999997e-01, \
                                    8.1329595446299996e-01,  8.1837103563199998e-01,  8.2325997208799995e-01, \
                                    8.2818087680100005e-01,  8.3290923727099997e-01,  8.3766966556500000e-01, \
                                    8.4225347408499995e-01,  8.4685281989100003e-01,  8.5127199896299999e-01, \
                                    8.5571524347600003e-01,  8.5998238628000001e-01,  8.6426306188000002e-01, \
                                    8.6836872425400002e-01,  8.7248888071800001e-01,  8.7644295133899996e-01, \
                                    8.8040303864100000e-01,  8.8419394809200003e-01,  8.8799318801100002e-01, \
                                    8.9163695261800002e-01,  8.9527449627300004e-01,  8.9875365166599996e-01, \
                                    9.0223714541000000e-01,  9.0556699216400005e-01,  9.0889167995099995e-01, \
                                    9.1206745382999999e-01,  9.1523449865499995e-01,  9.1826416638899999e-01, \
                                    9.2128118826899996e-01,  9.2415634102300004e-01,  9.2702144306300005e-01, \
                                    9.2975856544400004e-01,  9.3247639127799997e-01,  9.3506279471599996e-01, \
                                    9.3763998443700003e-01,  9.4009048596699996e-01,  9.4252220034300005e-01, \
                                    9.4483560469200001e-01,  9.4712860747100003e-01,  9.4931122391599998e-01, \
                                    9.5147338081800004e-01,  9.5352162481900005e-01,  9.5555245760499996e-01, \
                                    9.5748154510700001e-01,  9.5938578541399999e-01,  9.6118847603699997e-01, \
                                    9.6297322131999996e-01,  9.6466155789899999e-01,  9.6632611537099999e-01, \
                                    9.6790190792399999e-01,  9.6945370971000000e-01,  9.7092123491899995e-01, \
                                    9.7236737108700000e-01,  9.7372766845400005e-01,  9.7506812358799999e-01, \
                                    9.7633441693300005e-01,  9.7757447767000005e-01,  9.7874223946700001e-01, \
                                    9.7989006893999997e-01,  9.8096860106799999e-01,  9.8202393655099995e-01, \
                                    9.8301611406199996e-01,  9.8398584038799997e-01,  9.8489640230499997e-01, \
                                    9.8578703205899998e-01,  9.8661802848000002e-01,  9.8742989857999997e-01, \
                                    9.8819202611300005e-01,  9.8893091781499998e-01,  9.8962133754199999e-01, \
                                    9.9029468329400006e-01,  9.9092094971000000e-01,  9.9152849481399996e-01, \
                                    9.9209471437800001e-01,  9.9264210166099998e-01,  9.9315126729600001e-01, \
                                    9.9364398766700002e-01,  9.9409932579600002e-01,  9.9453851912600000e-01, \
                                    9.9494703358000003e-01,  9.9533762068099996e-01,  9.9569824594099998e-01, \
                                    9.9604547651399999e-01,  9.9636447448499998e-01,  9.9666903296700005e-01, \
                                    9.9694959184999998e-01,  9.9721610003299999e-01,  9.9746063141499997e-01, \
                                    9.9769300963300001e-01,  9.9790421400200002e-01,  9.9810426632899996e-01, \
                                    9.9828710191600001e-01,  9.9845829003800002e-01,  9.9861322769299998e-01, \
                                    9.9875932388099997e-01,  9.9889054345200001e-01,  9.9901280255900005e-01, \
                                    9.9912297514699999e-01,  9.9922474869500000e-01,  9.9931580010099996e-01, \
                                    9.9940010076700003e-01,  9.9947433016400000e-01,  9.9954251814899997e-01, \
                                    9.9960289003699998e-01,  9.9965748628899997e-01,  9.9970518935800001e-01, \
                                    9.9974853528700003e-01,  9.9978599075800001e-01,  9.9981944303100001e-01, \
                                    9.9984839909300005e-01,  9.9987377880600004e-01,  9.9989545177000005e-01, \
                                    9.9991448848200004e-01,  9.9993027773400001e-01,  9.9994393209700005e-01, \
                                    9.9995535039799999e-01,  9.9996487084200003e-01,  9.9997258319700000e-01, \
                                    9.9997904567800000e-01,  9.9998413109499995e-01,  9.9998823739300002e-01, \
                                    9.9999145177100002e-01,  9.9999392775399998e-01,  9.9999578851600002e-01, \
                                    9.9999718693700002e-01,  9.9999816461199997e-01,  9.9999885675699995e-01, \
                                    9.9999933065900004e-01,  9.9999962678800003e-01,  9.9999980777300002e-01, \
                                    9.9999991536900001e-01,  9.9999996627599996e-01,  9.9999998907999998e-01, \
                                    9.9999999791200000e-01,  9.9999999983900001e-01,  1.0000000000000000e+00, \
                                    1.1000000000000001e-11,  1.6100000000000001e-10,  9.1800000000000004e-10, \
                                    3.0859999999999999e-09,  8.1560000000000004e-09,  1.9373999999999999e-08, \
                                    3.9768999999999997e-08,  7.4192999999999995e-08,  1.3159200000000000e-07, \
                                    2.1901100000000000e-07,  3.4731099999999998e-07,  5.3423900000000002e-07, \
                                    7.9478500000000001e-07,  1.1467880000000001e-06,  1.6208620000000000e-06, \
                                    2.2390210000000000e-06,  3.0305020000000001e-06,  4.0435070000000003e-06, \
                                    5.3045550000000002e-06,  6.8678109999999998e-06,  8.7956419999999992e-06, \
                                    1.1135582000000000e-05,  1.3923993999999999e-05,  1.7292263999999999e-05, \
                                    2.1263092000000001e-05,  2.5925318999999999e-05,  3.1389707000000001e-05, \
                                    3.7757002999999999e-05,  4.5080327999999999e-05,  5.3545521000000002e-05, \
                                    6.3182106000000003e-05,  7.4179728999999997e-05,  8.6674777999999999e-05, \
                                    1.0080100100000000e-04,  1.1660752799999999e-04,  1.3448467300000000e-04, \
                                    1.5440241800000000e-04,  1.7656025100000000e-04,  2.0118694400000000e-04, \
                                    2.2852841799999999e-04,  2.5862015300000003e-04,  2.9190450599999999e-04, \
                                    3.2837382599999997e-04,  3.6839533699999999e-04,  4.1222542299999999e-04, \
                                    4.6005069000000000e-04,  5.1195169600000000e-04,  5.6864610800000002e-04, \
                                    6.3004941100000002e-04,  6.9645909700000001e-04,  7.6824754300000000e-04, \
                                    8.4585560200000005e-04,  9.2923638300000005e-04,  1.0191269839999999e-03, \
                                    1.1154063890000000e-03,  1.2187311829999999e-03,  1.3294672839999999e-03, \
                                    1.4477935650000001e-03,  1.5737529280000001e-03,  1.7086042860000000e-03, \
                                    1.8519143790000001e-03,  2.0042920730000001e-03,  2.1660835100000002e-03, \
                                    2.3381727509999999e-03,  2.5200674960000002e-03,  2.7131103940000001e-03, \
                                    2.9168247219999999e-03,  3.1324732600000000e-03,  3.3600545379999999e-03, \
                                    3.6002127670000002e-03,  3.8525049570000002e-03,  4.1192884270000001e-03, \
                                    4.3993596420000003e-03,  4.6938601379999997e-03,  5.0028039090000004e-03, \
                                    5.3278569649999998e-03,  5.6680878139999998e-03,  6.0253130770000001e-03, \
                                    6.3985562729999999e-03,  6.7900669750000000e-03,  7.1990835259999999e-03, \
                                    7.6269793760000001e-03,  8.0728041040000007e-03,  8.5398189470000004e-03, \
                                    9.0260685679999994e-03,  9.5333764119999997e-03,  1.0061331357999999e-02, \
                                    1.0612528466000000e-02,  1.1185244854000000e-02,  1.1781845536000000e-02, \
                                    1.2400803756999999e-02,  1.3045947636000000e-02,  1.3715131055000000e-02, \
                                    1.4410376169000001e-02,  1.5130476885999999e-02,  1.5879506801000001e-02, \
                                    1.6654972127000001e-02,  1.7459106413000001e-02,  1.8290575074000000e-02, \
                                    1.9153667340999998e-02,  2.0045600848000000e-02,  2.0969162538000002e-02, \
                                    2.1922333206000000e-02,  2.2910364890999999e-02,  2.3929577574000001e-02, \
                                    2.4982433253000001e-02,  2.6068196653999998e-02,  2.7191242572000000e-02, \
                                    2.8347980661000000e-02,  2.9541875466000001e-02,  3.0769951946000001e-02, \
                                    3.2038737471999999e-02,  3.3344100933999997e-02,  3.4688600962000000e-02, \
                                    3.6069884402999998e-02,  3.7495100614999999e-02,  3.8958551884999998e-02, \
                                    4.0463949849000001e-02,  4.2009367637000000e-02,  4.3600290675999999e-02, \
                                    4.5231761723000002e-02,  4.6908934297000000e-02,  4.8626614190999999e-02, \
                                    5.0393244619999999e-02,  5.2203722605000002e-02,  5.4059980989999999e-02, \
                                    5.5959785066000002e-02,  5.7912592945999999e-02,  5.9908893568999998e-02, \
                                    6.1954014235000000e-02,  6.4045885381999998e-02,  6.6190734454000005e-02, \
                                    6.8381889298000001e-02,  7.0625697456000003e-02,  7.2914422209000004e-02, \
                                    7.5259735797999994e-02,  7.7655152123000004e-02,  8.0101292522000003e-02, \
                                    8.2595496527000004e-02,  8.5150369522000002e-02,  8.7751474176999994e-02, \
                                    9.0407746521999996e-02,  9.3115214754000003e-02,  9.5881214507999996e-02, \
                                    9.8696587781000003e-02,  1.0157006425700001e-01,  1.0449065753200000e-01, \
                                    1.0747302689700000e-01,  1.1050894225400000e-01,  1.1359866784100001e-01, \
                                    1.1673783435000000e-01,  1.1994418649499999e-01,  1.2319720978900001e-01, \
                                    1.2650803997400001e-01,  1.2987156795800001e-01,  1.3329610400799999e-01, \
                                    1.3677137281400001e-01,  1.4030825828999999e-01,  1.4389009539299999e-01, \
                                    1.4753754607899999e-01,  1.5123797645600001e-01,  1.5499230184500001e-01, \
                                    1.5879556045900001e-01,  1.6266891808500000e-01,  1.6658526026500001e-01, \
                                    1.7055972969100000e-01,  1.7458674543300001e-01,  1.7867417396700000e-01, \
                                    1.8280842905500000e-01,  1.8700509245600000e-01,  1.9124130003600001e-01, \
                                    1.9554334483200000e-01,  1.9989594807500000e-01,  2.0429890266100001e-01, \
                                    2.0874563060900000e-01,  2.1326146567099999e-01,  2.1781513721599999e-01, \
                                    2.2242305561500000e-01,  2.2707882951700001e-01,  2.3179073738299999e-01, \
                                    2.3654313742700001e-01,  2.4135450331000000e-01,  2.4619761362100001e-01, \
                                    2.5110207417100000e-01,  2.5605119950999999e-01,  2.6104225556299998e-01, \
                                    2.6607082711399999e-01,  2.7116377075800002e-01,  2.7628468215500002e-01, \
                                    2.8145168750499999e-01,  2.8665926851800000e-01,  2.9191486857200000e-01, \
                                    2.9720290797600002e-01,  3.0254074441000001e-01,  3.0790081150400000e-01, \
                                    3.1331208311199998e-01,  3.1876009995700000e-01,  3.2423900961899998e-01, \
                                    3.2974504174500002e-01,  3.3530637051500001e-01,  3.4088406121499998e-01, \
                                    3.4649603229400000e-01,  3.5214009612300001e-01,  3.5781786335400001e-01, \
                                    3.6351827866500003e-01,  3.6925491914199998e-01,  3.7500361953599998e-01, \
                                    3.8079009436900002e-01,  3.8660402475299999e-01,  3.9243191825700002e-01, \
                                    3.9827541251499998e-01,  4.0416061443700002e-01,  4.1005182101999998e-01, \
                                    4.1596042569600000e-01,  4.2189055407900000e-01,  4.2783801277400002e-01, \
                                    4.3379747156600001e-01,  4.3977582374300001e-01,  4.4575518149200000e-01, \
                                    4.5175479811399999e-01,  4.5777043826699998e-01,  4.6378314291799999e-01, \
                                    4.6980107091200002e-01,  4.7584219790299997e-01,  4.8187713748200001e-01, \
                                    4.8791056284200002e-01,  4.9395603331100002e-01,  5.0000000000000000e-01, \
                                    5.0604396668899998e-01,  5.1208943715800004e-01,  5.1812286251799999e-01, \
                                    5.2415780209700003e-01,  5.3019892908800004e-01,  5.3621685708199995e-01, \
                                    5.4222956173299997e-01,  5.4824520188600001e-01,  5.5424481850800000e-01, \
                                    5.6022417625700005e-01,  5.6620252843399999e-01,  5.7216198722599998e-01, \
                                    5.7810944592100000e-01,  5.8403957430400000e-01,  5.8994817897999996e-01, \
                                    5.9583938556299998e-01,  6.0172458748500002e-01,  6.0756808174300003e-01, \
                                    6.1339597524699996e-01,  6.1920990563099998e-01,  6.2499638046399997e-01, \
                                    6.3074508085799996e-01,  6.3648172133500003e-01,  6.4218213664599999e-01, \
                                    6.4785990387699999e-01,  6.5350396770600006e-01,  6.5911593878499997e-01, \
                                    6.6469362948499999e-01,  6.7025495825500003e-01,  6.7576099038100002e-01, \
                                    6.8123990004299995e-01,  6.8668791688800002e-01,  6.9209918849600005e-01, \
                                    6.9745925558999999e-01,  7.0279709202399998e-01,  7.0808513142800000e-01, \
                                    7.1334073148199995e-01,  7.1854831249499995e-01,  7.2371531784499998e-01, \
                                    7.2883622924199998e-01,  7.3392917288600001e-01,  7.3895774443700002e-01, \
                                    7.4394880049000001e-01,  7.4889792582900006e-01,  7.5380238637899999e-01, \
                                    7.5864549669000003e-01,  7.6345686257300005e-01,  7.6820926261699995e-01, \
                                    7.7292117048300002e-01,  7.7757694438500002e-01,  7.8218486278400001e-01, \
                                    7.8673853432899998e-01,  7.9125436939100002e-01,  7.9570109733899996e-01, \
                                    8.0010405192500000e-01,  8.0445665516800002e-01,  8.0875869996399996e-01, \
                                    8.1299490754399995e-01,  8.1719157094499995e-01,  8.2132582603299997e-01, \
                                    8.2541325456699999e-01,  8.2944027030900003e-01,  8.3341473973500002e-01, \
                                    8.3733108191500005e-01,  8.4120443954099999e-01,  8.4500769815499999e-01, \
                                    8.4876202354399999e-01,  8.5246245392099995e-01,  8.5610990460699998e-01, \
                                    8.5969174170999996e-01,  8.6322862718600002e-01,  8.6670389599200004e-01, \
                                    8.7012843204199997e-01,  8.7349196002600005e-01,  8.7680279021100005e-01, \
                                    8.8005581350499995e-01,  8.8326216565000004e-01,  8.8640133215899997e-01, \
                                    8.8949105774600001e-01,  8.9252697310300000e-01,  8.9550934246799996e-01, \
                                    8.9842993574300001e-01,  9.0130341221900001e-01,  9.0411878549199998e-01, \
                                    9.0688478524600002e-01,  9.0959225347799999e-01,  9.1224852582299998e-01, \
                                    9.1484963047800005e-01,  9.1740450347299995e-01,  9.1989870747799996e-01, \
                                    9.2234484787700000e-01,  9.2474026420199995e-01,  9.2708557779099998e-01, \
                                    9.2937430254400000e-01,  9.3161811070199996e-01,  9.3380926554599997e-01, \
                                    9.3595411461800004e-01,  9.3804598576499998e-01,  9.4009110643100002e-01, \
                                    9.4208740705399996e-01,  9.4404021493400003e-01,  9.4594001901000002e-01, \
                                    9.4779627739500005e-01,  9.4960675537999994e-01,  9.5137338580899999e-01, \
                                    9.5309106570299995e-01,  9.5476823827699997e-01,  9.5639970932399998e-01, \
                                    9.5799063236299997e-01,  9.5953605015099996e-01,  9.6104144811500003e-01, \
                                    9.6250489938499995e-01,  9.6393011559700004e-01,  9.6531139903800001e-01, \
                                    9.6665589906600002e-01,  9.6796126252799997e-01,  9.6923004805400004e-01, \
                                    9.7045812453400004e-01,  9.7165201933900003e-01,  9.7280875742799999e-01, \
                                    9.7393180334600005e-01,  9.7501756674700002e-01,  9.7607042242599995e-01, \
                                    9.7708963510900004e-01,  9.7807766679399999e-01,  9.7903083746200004e-01, \
                                    9.7995439915200000e-01,  9.8084633265900001e-01,  9.8170942492600000e-01, \
                                    9.8254089358700003e-01,  9.8334502787300004e-01,  9.8412049319899997e-01, \
                                    9.8486952311400000e-01,  9.8558962383100002e-01,  9.8628486894500000e-01, \
                                    9.8695405236400002e-01,  9.8759919624299997e-01,  9.8821815446399996e-01, \
                                    9.8881475514600004e-01,  9.8938747153399997e-01,  9.8993866864199997e-01, \
                                    9.9046662358799997e-01,  9.9097393143199997e-01,  9.9146018105300004e-01, \
                                    9.9192719589599998e-01,  9.9237302062400001e-01,  9.9280091647400004e-01, \
                                    9.9320993302500005e-01,  9.9360144372699999e-01,  9.9397468692299995e-01, \
                                    9.9433191218600003e-01,  9.9467214303499996e-01,  9.9499719609100001e-01, \
                                    9.9530613986200001e-01,  9.9560064035800000e-01,  9.9588071157299995e-01, \
                                    9.9614749504300004e-01,  9.9639978723300004e-01,  9.9663994546199997e-01, \
                                    9.9686752674000001e-01,  9.9708317527799994e-01,  9.9728688960599998e-01, \
                                    9.9747993250400002e-01,  9.9766182724899999e-01,  9.9783391648999997e-01, \
                                    9.9799570792699999e-01,  9.9814808562099999e-01,  9.9829139571400005e-01, \
                                    9.9842624707200001e-01,  9.9855220643499998e-01,  9.9867053271600004e-01, \
                                    9.9878126881700002e-01,  9.9888459361100002e-01,  9.9898087301600003e-01, \
                                    9.9907076361699998e-01,  9.9915414439799999e-01,  9.9923175245700002e-01, \
                                    9.9930354090300000e-01,  9.9936995058900002e-01,  9.9943135389200000e-01, \
                                    9.9948804830399995e-01,  9.9953994931000001e-01,  9.9958777457699999e-01, \
                                    9.9963160466300005e-01,  9.9967162617399996e-01,  9.9970809549399997e-01, \
                                    9.9974137984699996e-01,  9.9977147158199997e-01,  9.9979881305600005e-01, \
                                    9.9982343974900001e-01,  9.9984559758199998e-01,  9.9986551532699997e-01, \
                                    9.9988339247199998e-01,  9.9989919899900004e-01,  9.9991332522200005e-01, \
                                    9.9992582027099997e-01,  9.9993681789400002e-01,  9.9994645447899999e-01, \
                                    9.9995491967200001e-01,  9.9996224299699998e-01,  9.9996861029299999e-01, \
                                    9.9997407468099997e-01,  9.9997873690799999e-01,  9.9998270773599995e-01, \
                                    9.9998607600599998e-01,  9.9998886441799995e-01,  9.9999120435800004e-01, \
                                    9.9999313218899999e-01,  9.9999469544499997e-01,  9.9999595649299999e-01, \
                                    9.9999696949799999e-01,  9.9999776097899995e-01,  9.9999837913800005e-01, \
                                    9.9999885321199999e-01,  9.9999920521499996e-01,  9.9999946576099996e-01, \
                                    9.9999965268900004e-01,  9.9999978098900000e-01,  9.9999986840800004e-01, \
                                    9.9999992580700003e-01,  9.9999996023100002e-01,  9.9999998062600004e-01, \
                                    9.9999999184400001e-01,  9.9999999691399999e-01,  9.9999999908199999e-01, \
                                    9.9999999983900001e-01,  9.9999999998900002e-01,  1.0000000000000000e+00, \
                                    9.9999999999999998e-13,  1.1000000000000001e-11,  7.1000000000000000e-11, \
                                    2.5899999999999998e-10,  7.2299999999999998e-10,  1.7920000000000000e-09, \
                                    3.8750000000000000e-09,  7.5290000000000008e-09,  1.3837000000000000e-08, \
                                    2.3867000000000001e-08,  3.9103999999999997e-08,  6.1849000000000000e-08, \
                                    9.4714999999999998e-08,  1.4021100000000001e-07,  2.0321899999999999e-07, \
                                    2.8736699999999998e-07,  3.9824100000000003e-07,  5.4226599999999999e-07, \
                                    7.2719600000000000e-07,  9.5922900000000002e-07,  1.2524390000000001e-06, \
                                    1.6137469999999999e-06,  2.0557570000000002e-06,  2.5939980000000000e-06, \
                                    3.2452669999999998e-06,  4.0178080000000001e-06,  4.9426949999999998e-06, \
                                    6.0313570000000003e-06,  7.3104509999999998e-06,  8.8008580000000008e-06, \
                                    1.0537512999999999e-05,  1.2530122000000001e-05,  1.4840812000000000e-05, \
                                    1.7471820999999998e-05,  2.0478154000000001e-05,  2.3887773000000001e-05, \
                                    2.7769062000000001e-05,  3.2109044000000001e-05,  3.7023872000000000e-05, \
                                    4.2503801999999997e-05,  4.8649329999999997e-05,  5.5466324000000000e-05, \
                                    6.3084507000000001e-05,  7.1462356000000002e-05,  8.0802462000000000e-05, \
                                    9.1030471000000003e-05,  1.0233513500000000e-04,  1.1469297100000000e-04, \
                                    1.2832725199999999e-04,  1.4310796700000000e-04,  1.5936274699999999e-04, \
                                    1.7696092099999999e-04,  1.9620529100000000e-04,  2.1697200800000000e-04, \
                                    2.3962343400000001e-04,  2.6393467700000002e-04,  2.9042777899999998e-04, \
                                    3.1878828299999998e-04,  3.4950426099999998e-04,  3.8235234300000001e-04, \
                                    4.1788943100000002e-04,  4.5568420399999998e-04,  4.9648750300000004e-04, \
                                    5.3984417899999998e-04,  5.8647693600000000e-04,  6.3590208900000001e-04, \
                                    6.8896963599999995e-04,  7.4504556099999999e-04,  8.0519350899999997e-04, \
                                    8.6861554999999996e-04,  9.3635889499999998e-04,  1.0077555810000000e-03, \
                                    1.0839866399999999e-03,  1.1640033250000000e-03,  1.2492808380000001e-03, \
                                    1.3387329820000000e-03,  1.4338829800000000e-03,  1.5335137980000001e-03, \
                                    1.6392958050000001e-03,  1.7498611490000000e-03,  1.8671614860000000e-03, \
                                    1.9895558480000001e-03,  2.1190962529999999e-03,  2.2541656279999999e-03, \
                                    2.3970562910000000e-03,  2.5456533089999998e-03,  2.7026210759999998e-03, \
                                    2.8657965669999998e-03,  3.0379796019999999e-03,  3.2166478310000001e-03, \
                                    3.4048505480000000e-03,  3.6000610109999998e-03,  3.8056132550000001e-03, \
                                    4.0183783479999999e-03,  4.2420847630000001e-03,  4.4735104180000001e-03, \
                                    4.7167453329999996e-03,  4.9679984589999998e-03,  5.2316173820000002e-03, \
                                    5.5038231930000002e-03,  5.7893668950000001e-03,  6.0836952240000000e-03, \
                                    6.3920369420000000e-03,  6.7098705209999998e-03,  7.0426457639999997e-03, \
                                    7.3849730940000000e-03,  7.7431859169999999e-03,  8.1115523780000004e-03, \
                                    8.4967234199999995e-03,  8.8925030119999995e-03,  9.3056224270000008e-03, \
                                    9.7299523530000008e-03,  1.0173196292000000e-02,  1.0627552550999999e-02, \
                                    1.1101416786999999e-02,  1.1587428161000000e-02,  1.2094062254999999e-02, \
                                    1.2612813547000000e-02,  1.3153414291999999e-02,  1.3706607920000001e-02, \
                                    1.4282648056000000e-02,  1.4871990659000000e-02,  1.5484772294999999e-02, \
                                    1.6111281485999999e-02,  1.6763339697000001e-02,  1.7428621177999998e-02, \
                                    1.8120023458000001e-02,  1.8826400027000000e-02,  1.9559875096999999e-02, \
                                    2.0307755183000001e-02,  2.1084503391999999e-02,  2.1876112578000002e-02, \
                                    2.2697691191000000e-02,  2.3534976094000001e-02,  2.4402551432999998e-02, \
                                    2.5286015597999999e-02,  2.6202790997999999e-02,  2.7134625611999998e-02, \
                                    2.8099823209000001e-02,  2.9082408842000002e-02,  3.0099240890999999e-02, \
                                    3.1132517770999998e-02,  3.2202607458000000e-02,  3.3289021290999997e-02, \
                                    3.4413246038999999e-02,  3.5554920009999998e-02,  3.6734416089000001e-02, \
                                    3.7931519387999997e-02,  3.9170206502000003e-02,  4.0424899277000000e-02, \
                                    4.1720681619999998e-02,  4.3035726619000000e-02,  4.4392803565000000e-02, \
                                    4.5767119805999998e-02,  4.7186671425000000e-02,  4.8622946712000001e-02, \
                                    5.0105325742000002e-02,  5.1606417303000002e-02,  5.3152780679999997e-02, \
                                    5.4717366057999997e-02,  5.6331956714000000e-02,  5.7962363188000000e-02, \
                                    5.9642127415000003e-02,  6.1341704620999998e-02,  6.3090938444999994e-02, \
                                    6.4857035765000001e-02,  6.6677128665999993e-02,  6.8513297195999995e-02, \
                                    7.0403522181000003e-02,  7.2312256194999994e-02,  7.4273385243000006e-02, \
                                    7.6252167794000000e-02,  7.8289834848999998e-02,  8.0341333577999996e-02, \
                                    8.2449950327000004e-02,  8.4577397525000000e-02,  8.6762226865000000e-02, \
                                    8.8962238624000003e-02,  9.1224223771999999e-02,  9.3499849130999999e-02, \
                                    9.5836933340000000e-02,  9.8191109637000007e-02,  1.0060467676700000e-01, \
                                    1.0303336146200000e-01,  1.0552903275800000e-01,  1.0803460906100000e-01, \
                                    1.1060479220100000e-01,  1.1319163797400000e-01,  1.1584201796200000e-01, \
                                    1.1850401695399999e-01,  1.2123539199199999e-01,  1.2397628457700000e-01, \
                                    1.2678585204900000e-01,  1.2960864188999999e-01,  1.3249670081400000e-01, \
                                    1.3539513836600001e-01,  1.3836803653599999e-01,  1.4134562206199999e-01, \
                                    1.4439356713800000e-01,  1.4745393913200000e-01,  1.5058300596300001e-01, \
                                    1.5371838125699999e-01,  1.5692976989800000e-01,  1.6014403282699999e-01, \
                                    1.6343263036000000e-01,  1.6672852283699999e-01,  1.7009450488899999e-01, \
                                    1.7346488910499999e-01,  1.7691540072500000e-01,  1.8036279559200000e-01, \
                                    1.8388480874200000e-01,  1.8741337970800001e-01,  1.9101494693400001e-01, \
                                    1.9461497471899999e-01,  1.9829583950200000e-01,  2.0197067643500000e-01, \
                                    2.0572435755900001e-01,  2.0947804700900000e-01,  2.1330444282700001e-01, \
                                    2.1712680135500001e-01,  2.2103295395700001e-01,  2.2492715669300001e-01, \
                                    2.2889929659200001e-01,  2.3286922176600000e-01,  2.3691419476200001e-01, \
                                    2.4094774223599999e-01,  2.4506549371200001e-01,  2.4916750776600000e-01, \
                                    2.5334996435099999e-01,  2.5752329489300002e-01,  2.6176971952700001e-01, \
                                    2.6600254348199998e-01,  2.7032172089299999e-01,  2.7461721142200002e-01, \
                                    2.7899151251799997e-01,  2.8335330479699999e-01,  2.8779064702800000e-01, \
                                    2.9220623637699999e-01,  2.9670607297200002e-01,  3.0117891244799999e-01, \
                                    3.0573168363699998e-01,  3.1026499701100002e-01,  3.1487050798900001e-01, \
                                    3.1945093531300001e-01,  3.2411715762700000e-01,  3.2874725461199999e-01, \
                                    3.3345522616800000e-01,  3.3814034420200001e-01,  3.4289836430199999e-01, \
                                    3.4762294804600002e-01,  3.5242936862000002e-01,  3.5719712425500000e-01, \
                                    3.6204251274999999e-01,  3.6685707386400002e-01,  3.7174020926700002e-01, \
                                    3.7658602985400003e-01,  3.8151539054200001e-01,  3.8639701468200000e-01, \
                                    3.9135190067400000e-01,  3.9627247318699999e-01,  4.0126075637100000e-01, \
                                    4.0620466261799998e-01,  4.1122654461600000e-01,  4.1619744182899998e-01, \
                                    4.2124111100099998e-01,  4.2624203658799997e-01,  4.3130610580399997e-01, \
                                    4.3632227115599997e-01,  4.4141552228800002e-01,  4.4644966767799998e-01, \
                                    4.5155011169800002e-01,  4.5660623552700003e-01,  4.6172366421000000e-01, \
                                    4.6678517868199998e-01,  4.7191781354700002e-01,  4.7698806285099998e-01, \
                                    4.8212412068600002e-01,  4.8720771714299999e-01,  4.9234584856699998e-01, \
                                    4.9742572706100002e-01,  5.0257427293900003e-01,  5.0765415143299997e-01, \
                                    5.1279228285699996e-01,  5.1787587931400003e-01,  5.2301193714899996e-01, \
                                    5.2808218645299998e-01,  5.3321482131800002e-01,  5.3827633579000000e-01, \
                                    5.4339376447300003e-01,  5.4844988830200003e-01,  5.5355033232200002e-01, \
                                    5.5858447771200004e-01,  5.6367772884400003e-01,  5.6869389419600003e-01, \
                                    5.7375796341200003e-01,  5.7875888899899997e-01,  5.8380255817100002e-01, \
                                    5.8877345538400006e-01,  5.9379533738199997e-01,  5.9873924362900000e-01, \
                                    6.0372752681300001e-01,  6.0864809932599995e-01,  6.1360298531799995e-01, \
                                    6.1848460945799999e-01,  6.2341397014599997e-01,  6.2825979073299998e-01, \
                                    6.3314292613599998e-01,  6.3795748725000001e-01,  6.4280287574499995e-01, \
                                    6.4757063138000004e-01,  6.5237705195399998e-01,  6.5710163569799995e-01, \
                                    6.6185965579799999e-01,  6.6654477383199995e-01,  6.7125274538799995e-01, \
                                    6.7588284237300000e-01,  6.8054906468700005e-01,  6.8512949201100004e-01, \
                                    6.8973500298900003e-01,  6.9426831636300002e-01,  6.9882108755200001e-01, \
                                    7.0329392702799998e-01,  7.0779376362299995e-01,  7.1220935297200005e-01, \
                                    7.1664669520299995e-01,  7.2100848748199997e-01,  7.2538278857799998e-01, \
                                    7.2967827910700001e-01,  7.3399745651799997e-01,  7.3823028047299999e-01, \
                                    7.4247670510700003e-01,  7.4665003564900001e-01,  7.5083249223399995e-01, \
                                    7.5493450628799996e-01,  7.5905225776399998e-01,  7.6308580523799996e-01, \
                                    7.6713077823400000e-01,  7.7110070340799997e-01,  7.7507284330699999e-01, \
                                    7.7896704604300004e-01,  7.8287319864500005e-01,  7.8669555717299999e-01, \
                                    7.9052195299100003e-01,  7.9427564244100002e-01,  7.9802932356500000e-01, \
                                    8.0170416049799997e-01,  8.0538502528099998e-01,  8.0898505306599999e-01, \
                                    8.1258662029200002e-01,  8.1611519125800003e-01,  8.1963720440800003e-01, \
                                    8.2308459927500000e-01,  8.2653511089499998e-01,  8.2990549511099998e-01, \
                                    8.3327147716299999e-01,  8.3656736964000000e-01,  8.3985596717300004e-01, \
                                    8.4307023010200000e-01,  8.4628161874300001e-01,  8.4941699403699999e-01, \
                                    8.5254606086800000e-01,  8.5560643286200000e-01,  8.5865437793800004e-01, \
                                    8.6163196346399995e-01,  8.6460486163399997e-01,  8.6750329918600000e-01, \
                                    8.7039135811000001e-01,  8.7321414795100005e-01,  8.7602371542299995e-01, \
                                    8.7876460800800005e-01,  8.8149598304599996e-01,  8.8415798203800000e-01, \
                                    8.8680836202600000e-01,  8.8939520779900005e-01,  8.9196539093899996e-01, \
                                    8.9447096724200004e-01,  8.9696663853799996e-01,  8.9939532323299998e-01, \
                                    9.0180889036300005e-01,  9.0416306666000001e-01,  9.0650015086900004e-01, \
                                    9.0877577622799999e-01,  9.1103776137600001e-01,  9.1323777313499999e-01, \
                                    9.1542260247499996e-01,  9.1755004967300002e-01,  9.1965866642200000e-01, \
                                    9.2171016515100002e-01,  9.2374783220599999e-01,  9.2572661475700002e-01, \
                                    9.2768774380499996e-01,  9.2959647781900001e-01,  9.3148670280400003e-01, \
                                    9.3332287133400005e-01,  9.3514296423499998e-01,  9.3690906155499998e-01, \
                                    9.3865829537900003e-01,  9.4035787258500003e-01,  9.4203763681200003e-01, \
                                    9.4366804328599996e-01,  9.4528263394199996e-01,  9.4684721932000004e-01, \
                                    9.4839358269700003e-01,  9.4989467425800000e-01,  9.5137705328800004e-01, \
                                    9.5281332857500001e-01,  9.5423288019399999e-01,  9.5560719643500003e-01, \
                                    9.5696427338099999e-01,  9.5827931838000002e-01,  9.5957510072300001e-01, \
                                    9.6082979349800002e-01,  9.6206848061200001e-01,  9.6326558391100003e-01, \
                                    9.6444507998999995e-01,  9.6558675396100002e-01,  9.6671097870900002e-01, \
                                    9.6779739254200003e-01,  9.6886748222899999e-01,  9.6990075910899998e-01, \
                                    9.7091759115800003e-01,  9.7190017679100005e-01,  9.7286537438800003e-01, \
                                    9.7379720900199995e-01,  9.7471398440199997e-01,  9.7559744856700004e-01, \
                                    9.7646502390599998e-01,  9.7730230880900004e-01,  9.7812388742199996e-01, \
                                    9.7891549660800004e-01,  9.7969224481700001e-01,  9.8044012490300003e-01, \
                                    9.8117359997300002e-01,  9.8187997654199999e-01,  9.8257137882199996e-01, \
                                    9.8323666030300005e-01,  9.8388871851399995e-01,  9.8451522770500000e-01, \
                                    9.8512800934099998e-01,  9.8571735194400001e-01,  9.8629339208000000e-01, \
                                    9.8684658570799999e-01,  9.8738718645300005e-01,  9.8790593774500002e-01, \
                                    9.8841257183900000e-01,  9.8889858321299995e-01,  9.8937244744899999e-01, \
                                    9.8982680370800002e-01,  9.9027004764700000e-01,  9.9069437757300005e-01, \
                                    9.9110749698800005e-01,  9.9150327658000004e-01,  9.9188844762200001e-01, \
                                    9.9225681408300004e-01,  9.9261502690600001e-01,  9.9295735423599996e-01, \
                                    9.9329012947899997e-01,  9.9360796305800003e-01,  9.9391630477600001e-01, \
                                    9.9421063310500002e-01,  9.9449617680699998e-01,  9.9476838261800005e-01, \
                                    9.9503200154100002e-01,  9.9528325466699996e-01,  9.9552648958199996e-01, \
                                    9.9575791523699997e-01,  9.9598162165199999e-01,  9.9619438674500005e-01, \
                                    9.9639993898900003e-01,  9.9659514945200001e-01,  9.9678335216900005e-01, \
                                    9.9696202039799997e-01,  9.9713420343299997e-01,  9.9729737892400006e-01, \
                                    9.9745434669099997e-01,  9.9760294370900005e-01,  9.9774583437200004e-01, \
                                    9.9788090374700000e-01,  9.9801044415200002e-01,  9.9813283851400003e-01, \
                                    9.9825013885100000e-01,  9.9836070419500000e-01,  9.9846648620199996e-01, \
                                    9.9856611701999998e-01,  9.9866126701799995e-01,  9.9875071916199998e-01, \
                                    9.9883599667500000e-01,  9.9891601336000002e-01,  9.9899224441900003e-01, \
                                    9.9906364110500001e-01,  9.9913138445000005e-01,  9.9919480649100001e-01, \
                                    9.9925495443900003e-01,  9.9931103036400004e-01,  9.9936409791100000e-01, \
                                    9.9941352306400000e-01,  9.9946015582100001e-01,  9.9950351249699998e-01, \
                                    9.9954431579600000e-01,  9.9958211056900004e-01,  9.9961764765700001e-01, \
                                    9.9965049573900000e-01,  9.9968121171699997e-01,  9.9970957222099999e-01, \
                                    9.9973606532299997e-01,  9.9976037656600003e-01,  9.9978302799200003e-01, \
                                    9.9980379470900005e-01,  9.9982303907900005e-01,  9.9984063725299999e-01, \
                                    9.9985689203299999e-01,  9.9987167274800004e-01,  9.9988530702900003e-01, \
                                    9.9989766486499998e-01,  9.9990896952899999e-01,  9.9991919753799996e-01, \
                                    9.9992853764400003e-01,  9.9993691549300001e-01,  9.9994453367600000e-01, \
                                    9.9995135066999996e-01,  9.9995749619800001e-01,  9.9996297612800000e-01, \
                                    9.9996789095600003e-01,  9.9997223093800003e-01,  9.9997611222700000e-01, \
                                    9.9997952184600003e-01,  9.9998252817900002e-01,  9.9998515918800002e-01, \
                                    9.9998746987800002e-01,  9.9998946248700005e-01,  9.9999119914199996e-01, \
                                    9.9999268954900000e-01,  9.9999396864300005e-01,  9.9999505730500005e-01, \
                                    9.9999598219200003e-01,  9.9999675473299998e-01,  9.9999740600200004e-01, \
                                    9.9999794424300004e-01,  9.9999838625299997e-01,  9.9999874756100005e-01, \
                                    9.9999904077099999e-01,  9.9999927280400003e-01,  9.9999945773400001e-01, \
                                    9.9999960175900005e-01,  9.9999971263300003e-01,  9.9999979678100004e-01, \
                                    9.9999985978899997e-01,  9.9999990528500005e-01,  9.9999993815099997e-01, \
                                    9.9999996089599996e-01,  9.9999997613299996e-01,  9.9999998616300001e-01, \
                                    9.9999999247100002e-01,  9.9999999612500001e-01,  9.9999999820800001e-01, \
                                    9.9999999927700001e-01,  9.9999999974099996e-01,  9.9999999992900002e-01, \
                                    9.9999999998900002e-01,  9.9999999999900002e-01,  1.0000000000000000e+00, \
                                    0.0000000000000000e+00,  9.9999999999999998e-13,  4.9999999999999997e-12, \
                                    1.9999999999999999e-11,  5.9000000000000003e-11,  1.5299999999999999e-10, \
                                    3.4699999999999999e-10,  7.0400000000000005e-10,  1.3379999999999999e-09, \
                                    2.3899999999999998e-09,  4.0419999999999999e-09,  6.5759999999999996e-09, \
                                    1.0347000000000000e-08,  1.5725000000000000e-08,  2.3336000000000001e-08, \
                                    3.3785000000000001e-08,  4.7881999999999998e-08,  6.6568000000000004e-08, \
                                    9.1114000000000004e-08,  1.2254799999999999e-07,  1.6296400000000000e-07, \
                                    2.1371900000000001e-07,  2.7712100000000001e-07,  3.5539600000000001e-07, \
                                    4.5190999999999997e-07,  5.6832099999999997e-07,  7.0979100000000003e-07, \
                                    8.7879999999999995e-07,  1.0806980000000000e-06,  1.3189230000000000e-06, \
                                    1.6008020000000000e-06,  1.9286710000000001e-06,  2.3137049999999999e-06, \
                                    2.7578030000000000e-06,  3.2726130000000000e-06,  3.8623600000000002e-06, \
                                    4.5427240000000004e-06,  5.3129130000000001e-06,  6.1949650000000001e-06, \
                                    7.1891490000000002e-06,  8.3182770000000000e-06,  9.5828230000000004e-06, \
                                    1.1012043000000000e-05,  1.2600601000000000e-05,  1.4388987000000000e-05, \
                                    1.6367269000000000e-05,  1.8577493000000000e-05,  2.1014206999999999e-05, \
                                    2.3729522000000001e-05,  2.6701836000000001e-05,  2.9999858999999998e-05, \
                                    3.3601839999999997e-05,  3.7579398000000003e-05,  4.1906212999999998e-05, \
                                    4.6668605000000003e-05,  5.1825373000000000e-05,  5.7490547000000003e-05, \
                                    6.3606386000000003e-05,  7.0288811000000000e-05,  7.7488833000000006e-05, \
                                    8.5345300999999994e-05,  9.3768271000000002e-05,  1.0293349800000000e-04, \
                                    1.1274620699999999e-04,  1.2338958300000001e-04,  1.3475145600000001e-04, \
                                    1.4704856399999999e-04,  1.6013718100000001e-04,  1.7428397700000001e-04, \
                                    1.8930721700000000e-04,  2.0548175599999999e-04,  2.2263810700000000e-04, \
                                    2.4109695799999999e-04,  2.6060206599999998e-04,  2.8154186800000001e-04, \
                                    3.0365026899999999e-04,  3.2733571900000000e-04,  3.5229010900000000e-04, \
                                    3.7897637600000001e-04,  4.0703321099999997e-04,  4.3701224700000001e-04, \
                                    4.6847740499999997e-04,  5.0200237799999999e-04,  5.3715601800000004e-04, \
                                    5.7459738200000003e-04,  6.1374556799999997e-04,  6.5536678500000001e-04, \
                                    6.9886863999999999e-04,  7.4505389399999998e-04,  7.9323596400000004e-04, \
                                    8.4431374300000003e-04,  8.9753402499999997e-04,  9.5392713400000004e-04, \
                                    1.0125936709999999e-03,  1.0746209380000000e-03,  1.1391113170000000e-03, \
                                    1.2072860479999999e-03,  1.2780167180000000e-03,  1.3526660470000000e-03, \
                                    1.4300999010000001e-03,  1.5117531899999999e-03,  1.5963189630000001e-03, \
                                    1.6853907250000001e-03,  1.7775605570000000e-03,  1.8746092189999999e-03, \
                                    1.9748998430000001e-03,  2.0803197970000000e-03,  2.1892242340000000e-03, \
                                    2.3036887960000002e-03,  2.4217367300000000e-03,  2.5456301629999999e-03, \
                                    2.6733961979999998e-03,  2.8074443939999998e-03,  2.9454736929999999e-03, \
                                    3.0901266529999999e-03,  3.2390079020000002e-03,  3.3950037640000002e-03, \
                                    3.5553840970000000e-03,  3.7231935510000000e-03,  3.8956641030000001e-03, \
                                    4.0761285139999997e-03,  4.2613595619999996e-03,  4.4549278609999996e-03, \
                                    4.6535989510000002e-03,  4.8611879089999997e-03,  5.0739499520000000e-03, \
                                    5.2960465430000004e-03,  5.5236612450000003e-03,  5.7612064840000003e-03, \
                                    6.0043823230000000e-03,  6.2578907350000004e-03,  6.5173588329999997e-03, \
                                    6.7878701579999999e-03,  7.0644361359999998e-03,  7.3524181679999996e-03, \
                                    7.6468276749999996e-03,  7.9534525239999994e-03,  8.2665173679999995e-03, \
                                    8.5922193629999997e-03,  8.9248083410000002e-03,  9.2707528819999992e-03, \
                                    9.6236541690000003e-03,  9.9904346869999997e-03,  1.0364488438000001e-02, \
                                    1.0753285288000000e-02,  1.1149429941999999e-02,  1.1560699277000000e-02, \
                                    1.1979759128000001e-02,  1.2414939909000000e-02,  1.2857804255000001e-02, \
                                    1.3317224399999999e-02,  1.3784915774000000e-02,  1.4270035348999999e-02, \
                                    1.4763332880000000e-02,  1.5274681902000001e-02,  1.5794523083999999e-02, \
                                    1.6333423469000002e-02,  1.6880944860999999e-02,  1.7447837096999999e-02, \
                                    1.8023768772000001e-02,  1.8620347878000001e-02,  1.9225690436999999e-02, \
                                    1.9852117347999999e-02,  2.0488025952000000e-02,  2.1145961004000000e-02, \
                                    2.1813120782000001e-02,  2.2503101077000001e-02,  2.3202611638000002e-02, \
                                    2.3926027919000000e-02,  2.4659064756999999e-02,  2.5416206000999999e-02, \
                                    2.6183418404000000e-02,  2.6976373481000002e-02,  2.7778837317000000e-02, \
                                    2.8607368006000000e-02,  2.9446303556999998e-02,  3.0312405425000001e-02, \
                                    3.1188440248999999e-02,  3.2092467090999999e-02,  3.3006673101999999e-02, \
                                    3.3950032311000002e-02,  3.4903702605000003e-02,  3.5886648632000001e-02, \
                                    3.6880222279000001e-02,  3.7905060627999997e-02,  3.8939646876000003e-02, \
                                    4.0005690864000000e-02,  4.1082676993999999e-02,  4.2192138008999999e-02, \
                                    4.3311767055999997e-02,  4.4464888738000002e-02,  4.5628330107999999e-02, \
                                    4.6826573854999998e-02,  4.8035173840999999e-02,  4.9278419720000001e-02, \
                                    5.0532252654999998e-02,  5.1823139482000000e-02,  5.3123458710000002e-02, \
                                    5.4460737007999999e-02,  5.5808863557000002e-02,  5.7195011673999999e-02, \
                                    5.8590882240000003e-02,  6.0025958193000002e-02,  6.1470719723000000e-02, \
                                    6.2955947624000003e-02,  6.4450925995000005e-02,  6.5986016108999998e-02, \
                                    6.7531039690999994e-02,  6.9118925979999996e-02,  7.0715061721999997e-02, \
                                    7.2353631301999996e-02,  7.4002284119999998e-02,  7.5694485443999995e-02, \
                                    7.7395125679999996e-02,  7.9140610277999998e-02,  8.0894296113000003e-02, \
                                    8.2694151581000006e-02,  8.4502365189999998e-02,  8.6355868614999998e-02, \
                                    8.8217737598000001e-02,  9.0128088869000006e-02,  9.2044775374999999e-02, \
                                    9.4009274616999997e-02,  9.5982078043000005e-02,  9.8003705371000005e-02, \
                                    1.0003149277700001e-01,  1.0210956585100001e-01,  1.0419354007300000e-01, \
                                    1.0632885307700000e-01,  1.0847026886100000e-01,  1.1066176109799999e-01, \
                                    1.1285920472100000e-01,  1.1511052660399999e-01,  1.1736503546600000e-01, \
                                    1.1967224478200000e-01,  1.2198506715100001e-01,  1.2435146842000000e-01, \
                                    1.2672097211899999e-01,  1.2914553401199999e-01,  1.3157264895900000e-01, \
                                    1.3405581300300001e-01,  1.3654180813500000e-01,  1.3908216493200001e-01, \
                                    1.4162493542400001e-01,  1.4422615253500001e-01,  1.4682652734200000e-01, \
                                    1.4948381716299999e-01,  1.5214320356000000e-01,  1.5486015870000000e-01, \
                                    1.5757600365999999e-01,  1.6035092922300001e-01,  1.6312411182000000e-01, \
                                    1.6595724001400000e-01,  1.6878890994900000e-01,  1.7167830235000001e-01, \
                                    1.7456557074300000e-01,  1.7751526347499999e-01,  1.8045914975100000e-01, \
                                    1.8346305030400001e-01,  1.8646447756699999e-01,  1.8952631090399999e-01, \
                                    1.9258213966400001e-01,  1.9570021243499999e-01,  1.9881120113299999e-01, \
                                    2.0198506346699999e-01,  2.0515212684500000e-01,  2.0837931202099999e-01, \
                                    2.1159908548500000e-01,  2.1488377686700000e-01,  2.1815688410199999e-01, \
                                    2.2149206445000000e-01,  2.2481944448700000e-01,  2.2820922593800000e-01, \
                                    2.3158690461600001e-01,  2.3502873189000001e-01,  2.3845733074600001e-01, \
                                    2.4195047172199999e-01,  2.4543103540799999e-01,  2.4897269929200000e-01, \
                                    2.5250080959999999e-01,  2.5609524679099999e-01,  2.5967151672000000e-01, \
                                    2.6331076042899998e-01,  2.6693604480900002e-01,  2.7062424569200000e-01, \
                                    2.7429375320299998e-01,  2.7802805437099998e-01,  2.8174253464999999e-01, \
                                    2.8552179180999998e-01,  2.8928186922200000e-01,  2.9310272500200002e-01, \
                                    2.9690344541899999e-01,  3.0077053728600001e-01,  3.0461240382999999e-01, \
                                    3.0851671227400002e-01,  3.1240027371899998e-01,  3.1634616137600002e-01, \
                                    3.2026640710999998e-01,  3.2425051983800002e-01,  3.2820774194100000e-01, \
                                    3.3222842534199998e-01,  3.3622320770600000e-01,  3.4027727835600002e-01, \
                                    3.4430411540099998e-01,  3.4839601178300000e-01,  3.5245523067000001e-01, \
                                    3.5657512067199998e-01,  3.6066741133899999e-01,  3.6481965767899999e-01, \
                                    3.6893915612799999e-01,  3.7312023413800000e-01,  3.7726740972900003e-01, \
                                    3.8147574745599999e-01,  3.8565097907599999e-01,  3.8988252808899998e-01, \
                                    3.9407971419900001e-01,  3.9833909863200001e-01,  4.0255881817200001e-01, \
                                    4.0683583596799999e-01,  4.1107843749200002e-01,  4.1537757335699999e-01, \
                                    4.1963686825600000e-01,  4.2395427927899998e-01,  4.2823065327100002e-01, \
                                    4.3256430022300002e-01,  4.3685800164600003e-01,  4.4120401593100000e-01, \
                                    4.4550897348200003e-01,  4.4987196713799998e-01,  4.5418837517400001e-01, \
                                    4.5855749861400003e-01,  4.6288570041100002e-01,  4.6726579584599998e-01, \
                                    4.7159951516400000e-01,  4.7598656957800001e-01,  4.8032589561400002e-01, \
                                    4.8471774304800003e-01,  4.8906326155699997e-01,  4.9345582930900000e-01, \
                                    4.9780109200500000e-01,  5.0219890799500000e-01,  5.0654417069100000e-01, \
                                    5.1093673844300003e-01,  5.1528225695200003e-01,  5.1967410438600004e-01, \
                                    5.2401343042199999e-01,  5.2840048483600000e-01,  5.3273420415399997e-01, \
                                    5.3711429958900003e-01,  5.4144250138600003e-01,  5.4581162482599999e-01, \
                                    5.5012803286199996e-01,  5.5449102651799997e-01,  5.5879598406900000e-01, \
                                    5.6314199835400003e-01,  5.6743569977700004e-01,  5.7176934672900004e-01, \
                                    5.7604572072100002e-01,  5.8036313174400000e-01,  5.8462242664300001e-01, \
                                    5.8892156250799998e-01,  5.9316416403200001e-01,  5.9744118182799999e-01, \
                                    6.0166090136799999e-01,  6.0592028580099999e-01,  6.1011747191099996e-01, \
                                    6.1434902092400001e-01,  6.1852425254400001e-01,  6.2273259027100003e-01, \
                                    6.2687976586200000e-01,  6.3106084387200001e-01,  6.3518034232099996e-01, \
                                    6.3933258866099996e-01,  6.4342487932799997e-01,  6.4754476933000005e-01, \
                                    6.5160398821700005e-01,  6.5569588459899997e-01,  6.5972272164400003e-01, \
                                    6.6377679229400000e-01,  6.6777157465799997e-01,  6.7179225805900000e-01, \
                                    6.7574948016199998e-01,  6.7973359289000002e-01,  6.8365383862399998e-01, \
                                    6.8759972628099997e-01,  6.9148328772599998e-01,  6.9538759617000001e-01, \
                                    6.9922946271399999e-01,  7.0309655458099996e-01,  7.0689727499800004e-01, \
                                    7.1071813077799995e-01,  7.1447820818999996e-01,  7.1825746535000001e-01, \
                                    7.2197194562900002e-01,  7.2570624679700002e-01,  7.2937575430799995e-01, \
                                    7.3306395519099998e-01,  7.3668923957099997e-01,  7.4032848328000000e-01, \
                                    7.4390475320899996e-01,  7.4749919040000001e-01,  7.5102730070799995e-01, \
                                    7.5456896459199996e-01,  7.5804952827799998e-01,  7.6154266925400005e-01, \
                                    7.6497126811000005e-01,  7.6841309538400004e-01,  7.7179077406200003e-01, \
                                    7.7518055551300002e-01,  7.7850793554999997e-01,  7.8184311589800004e-01, \
                                    7.8511622313300000e-01,  7.8840091451500005e-01,  7.9162068797899998e-01, \
                                    7.9484787315500005e-01,  7.9801493653300004e-01,  8.0118879886700001e-01, \
                                    8.0429978756499998e-01,  8.0741786033600005e-01,  8.1047368909600004e-01, \
                                    8.1353552243299998e-01,  8.1653694969599999e-01,  8.1954085024900003e-01, \
                                    8.2248473652499998e-01,  8.2543442925699995e-01,  8.2832169764999997e-01, \
                                    8.3121109005100002e-01,  8.3404275998599997e-01,  8.3687588818000003e-01, \
                                    8.3964907077700002e-01,  8.4242399633999998e-01,  8.4513984129999997e-01, \
                                    8.4785679644000000e-01,  8.5051618283700003e-01,  8.5317347265800003e-01, \
                                    8.5577384746499996e-01,  8.5837506457599999e-01,  8.6091783506800001e-01, \
                                    8.6345819186499995e-01,  8.6594418699700004e-01,  8.6842735104100000e-01, \
                                    8.7085446598799998e-01,  8.7327902788099998e-01,  8.7564853158000000e-01, \
                                    8.7801493284900001e-01,  8.8032775521800000e-01,  8.8263496453400003e-01, \
                                    8.8488947339599999e-01,  8.8714079527900003e-01,  8.8933823890200003e-01, \
                                    8.9152973113900003e-01,  8.9367114692299998e-01,  8.9580645992700003e-01, \
                                    8.9789043414900005e-01,  8.9996850722300004e-01,  9.0199629462899999e-01, \
                                    9.0401792195700004e-01,  9.0599072538299996e-01,  9.0795522462500000e-01, \
                                    9.0987191113099997e-01,  9.1178226240200000e-01,  9.1364413138500000e-01, \
                                    9.1549763481000002e-01,  9.1730584841899998e-01,  9.1910570388699997e-01, \
                                    9.2085938972199999e-01,  9.2260487432000005e-01,  9.2430551455599996e-01, \
                                    9.2599771588000002e-01,  9.2764636869799999e-01,  9.2928493827799996e-01, \
                                    9.3088107401999998e-01,  9.3246896030899995e-01,  9.3401398389099999e-01, \
                                    9.3554907400499998e-01,  9.3704405237599997e-01,  9.3852928027700000e-01, \
                                    9.3997404180699995e-01,  9.4140911776000002e-01,  9.4280498832600002e-01, \
                                    9.4419113644300001e-01,  9.4553926299199997e-01,  9.4687654128999998e-01, \
                                    9.4817686051799999e-01,  9.4946774734499995e-01,  9.5072158027999998e-01, \
                                    9.5196482615900002e-01,  9.5317342614500000e-01,  9.5437166989199995e-01, \
                                    9.5553511126199997e-01,  9.5668823294399996e-01,  9.5780786199099999e-01, \
                                    9.5891732300599997e-01,  9.5999430913600003e-01,  9.6106035312399996e-01, \
                                    9.6209493937199997e-01,  9.6311977772099999e-01,  9.6411335136800003e-01, \
                                    9.6509629739500002e-01,  9.6604996768899998e-01,  9.6699332689799999e-01, \
                                    9.6790753290900000e-01,  9.6881155975099997e-01,  9.6968759457499998e-01, \
                                    9.7055369644300005e-01,  9.7139263199400006e-01,  9.7222116268299996e-01, \
                                    9.7302362651899998e-01,  9.7381658159600004e-01,  9.7458379399899997e-01, \
                                    9.7534093524300003e-01,  9.7607397208100000e-01,  9.7679738836200003e-01, \
                                    9.7749689892299996e-01,  9.7818687921799996e-01,  9.7885403899599999e-01, \
                                    9.7951197404799994e-01,  9.8014788265200004e-01,  9.8077430956300005e-01, \
                                    9.8137965212199996e-01,  9.8197623122800004e-01,  9.8255216290299996e-01, \
                                    9.8311905513900000e-01,  9.8366657653099998e-01,  9.8420547691600002e-01, \
                                    9.8472531809800001e-01,  9.8523666712000002e-01,  9.8572996465100005e-01, \
                                    9.8621508422600002e-01,  9.8668277559999995e-01,  9.8714219574499995e-01, \
                                    9.8758506009100000e-01,  9.8802024087200002e-01,  9.8843930072300001e-01, \
                                    9.8885057005800003e-01,  9.8924671471199999e-01,  9.8963551156200003e-01, \
                                    9.9000956531300000e-01,  9.9037634583099998e-01,  9.9072924711800003e-01, \
                                    9.9107519165900004e-01,  9.9140778063699997e-01,  9.9173348263200001e-01, \
                                    9.9204654747599996e-01,  9.9235317232499998e-01,  9.9264758183199997e-01, \
                                    9.9293556386399995e-01,  9.9321212984200002e-01,  9.9348264116700002e-01, \
                                    9.9374210926499995e-01,  9.9399561767699995e-01,  9.9423879351599997e-01, \
                                    9.9447633875499997e-01,  9.9470395345700002e-01,  9.9492605004800005e-01, \
                                    9.9513881209099997e-01,  9.9534640104899996e-01,  9.9554507213900001e-01, \
                                    9.9573864043799998e-01,  9.9592387148600003e-01,  9.9610433589699998e-01, \
                                    9.9627680644899996e-01,  9.9644461590300004e-01,  9.9660499623599996e-01, \
                                    9.9676099209799995e-01,  9.9690987334699999e-01,  9.9705452630699998e-01, \
                                    9.9719255560599995e-01,  9.9732660380200000e-01,  9.9745436983699998e-01, \
                                    9.9757826326999999e-01,  9.9769631120400004e-01,  9.9781077576599997e-01, \
                                    9.9791968020300004e-01,  9.9802510015699997e-01,  9.9812539078100004e-01, \
                                    9.9822243944300004e-01,  9.9831460927500004e-01,  9.9840368103699995e-01, \
                                    9.9848824681000004e-01,  9.9856990009900004e-01,  9.9864733395299998e-01, \
                                    9.9872198328200001e-01,  9.9879271395199998e-01,  9.9886088868300005e-01, \
                                    9.9892537906199996e-01,  9.9898740632899996e-01,  9.9904607286600000e-01, \
                                    9.9910246597499996e-01,  9.9915568625700002e-01,  9.9920676403599995e-01, \
                                    9.9925494610599996e-01,  9.9930113135999998e-01,  9.9934463321500000e-01, \
                                    9.9938625443200002e-01,  9.9942540261799995e-01,  9.9946284398200003e-01, \
                                    9.9949799762199998e-01,  9.9953152259500000e-01,  9.9956298775300001e-01, \
                                    9.9959296678900000e-01,  9.9962102362399996e-01,  9.9964770989100005e-01, \
                                    9.9967266428099999e-01,  9.9969634973099997e-01,  9.9971845813200000e-01, \
                                    9.9973939793400002e-01,  9.9975890304199999e-01,  9.9977736189300004e-01, \
                                    9.9979451824400001e-01,  9.9981069278300005e-01,  9.9982571602299997e-01, \
                                    9.9983986281899995e-01,  9.9985295143599995e-01,  9.9986524854400005e-01, \
                                    9.9987661041700004e-01,  9.9988725379300003e-01,  9.9989706650200005e-01, \
                                    9.9990623172899995e-01,  9.9991465469899998e-01,  9.9992251116700004e-01, \
                                    9.9992971118899998e-01,  9.9993639361400000e-01,  9.9994250945300001e-01, \
                                    9.9994817462700003e-01,  9.9995333139499998e-01,  9.9995809378699996e-01, \
                                    9.9996242060200002e-01,  9.9996639815999999e-01,  9.9997000014100001e-01, \
                                    9.9997329816400005e-01,  9.9997627047799997e-01,  9.9997898579300004e-01, \
                                    9.9998142250699995e-01,  9.9998363273099999e-01,  9.9998561101299999e-01, \
                                    9.9998739939900005e-01,  9.9998898795699998e-01,  9.9999041717699999e-01, \
                                    9.9999168172300001e-01,  9.9999281085100000e-01,  9.9999380503500002e-01, \
                                    9.9999468708700001e-01,  9.9999545727600003e-01,  9.9999613763999995e-01, \
                                    9.9999672738699996e-01,  9.9999724219700004e-01,  9.9999768629499997e-01, \
                                    9.9999807132899998e-01,  9.9999839919800004e-01,  9.9999868107699996e-01, \
                                    9.9999891930200002e-01,  9.9999912120000001e-01,  9.9999929020900002e-01, \
                                    9.9999943167899996e-01,  9.9999954809000002e-01,  9.9999964460400004e-01, \
                                    9.9999972287899996e-01,  9.9999978628099995e-01,  9.9999983703600004e-01, \
                                    9.9999987745200003e-01,  9.9999990888599999e-01,  9.9999993343200000e-01, \
                                    9.9999995211799997e-01,  9.9999996621499998e-01,  9.9999997666399998e-01, \
                                    9.9999998427500003e-01,  9.9999998965299997e-01,  9.9999999342400003e-01, \
                                    9.9999999595800004e-01,  9.9999999761000002e-01,  9.9999999866199996e-01, \
                                    9.9999999929600003e-01,  9.9999999965300002e-01,  9.9999999984700005e-01, \
                                    9.9999999994099997e-01,  9.9999999998000000e-01,  9.9999999999500000e-01, \
                                    9.9999999999900002e-01,  1.0000000000000000e+00,  1.0000000000000000e+00, \
                                    0.0000000000000000e+00,  0.0000000000000000e+00,  0.0000000000000000e+00, \
                                    9.9999999999999998e-13,  4.9999999999999997e-12,  1.2000000000000001e-11, \
                                    2.9000000000000000e-11,  6.0999999999999996e-11,  1.2000000000000000e-10, \
                                    2.2100000000000001e-10,  3.8600000000000001e-10,  6.4500000000000005e-10, \
                                    1.0430000000000000e-09,  1.6260000000000000e-09,  2.4699999999999999e-09, \
                                    3.6589999999999999e-09,  5.2990000000000000e-09,  7.5230000000000006e-09, \
                                    1.0500999999999999e-08,  1.4403000000000000e-08,  1.9493000000000001e-08, \
                                    2.6023000000000001e-08,  3.4319999999999999e-08,  4.4740999999999997e-08, \
                                    5.7783000000000002e-08,  7.3818999999999994e-08,  9.3543999999999994e-08, \
                                    1.1752000000000000e-07,  1.4654199999999999e-07,  1.8131200000000000e-07, \
                                    2.2296699999999999e-07,  2.7221300000000000e-07,  3.3058100000000001e-07, \
                                    3.9898100000000002e-07,  4.7911499999999999e-07,  5.7216799999999997e-07, \
                                    6.8052199999999996e-07,  8.0504600000000002e-07,  9.4880599999999998e-07, \
                                    1.1131330000000000e-06,  1.3013420000000000e-06,  1.5148660000000000e-06, \
                                    1.7581519999999999e-06,  2.0322560000000001e-06,  2.3427520000000002e-06, \
                                    2.6909160000000000e-06,  3.0826590000000001e-06,  3.5197240000000002e-06, \
                                    4.0098220000000003e-06,  4.5533110000000002e-06,  5.1596389999999997e-06, \
                                    5.8299960000000000e-06,  6.5743989999999999e-06,  7.3935639999999997e-06, \
                                    8.3001950000000002e-06,  9.2937009999999999e-06,  1.0389499000000000e-05, \
                                    1.1586747000000001e-05,  1.2901422999999999e-05,  1.4333256000000000e-05, \
                                    1.5902332999999999e-05,  1.7604222000000000e-05,  1.9463071000000001e-05, \
                                    2.1475461000000001e-05,  2.3666640000000001e-05,  2.6031152000000001e-05, \
                                    2.8600156000000001e-05,  3.1364620999999999e-05,  3.4361157000000001e-05, \
                                    3.7578723000000003e-05,  4.1055696999999999e-05,  4.4781046999999999e-05, \
                                    4.8801426999999997e-05,  5.3096271999999999e-05,  5.7719895999999998e-05, \
                                    6.2652554000000005e-05,  6.7951494000000005e-05,  7.3591767000000006e-05, \
                                    7.9640693999999995e-05,  8.6065969999999997e-05,  9.2945758000000006e-05, \
                                    1.0024145200000000e-04,  1.0803557700000000e-04,  1.1628798800000000e-04, \
                                    1.2509529200000001e-04,  1.3439974799999999e-04,  1.4431146299999999e-04, \
                                    1.5477252600000000e-04,  1.6589921000000001e-04,  1.7762120999999999e-04, \
                                    1.9007199400000000e-04,  2.0316994800000001e-04,  2.1706690700000001e-04, \
                                    2.3166570399999999e-04,  2.4712764300000001e-04,  2.6335283499999998e-04, \
                                    2.8052288300000000e-04,  2.9851055699999998e-04,  3.1751876899999999e-04, \
                                    3.3741574599999998e-04,  3.5841808800000002e-04,  3.8037213900000001e-04, \
                                    4.0351932399999998e-04,  4.2768992099999998e-04,  4.5315335800000001e-04, \
                                    4.7971071500000002e-04,  5.0764993099999996e-04,  5.3676835499999996e-04, \
                                    5.6738028299999999e-04,  5.9924172599999995e-04,  6.3270030700000000e-04, \
                                    6.6750038899999998e-04,  7.0401801499999999e-04,  7.4195868899999998e-04, \
                                    7.8172812600000002e-04,  8.2301734300000004e-04,  8.6627211600000004e-04, \
                                    9.1113233799999999e-04,  9.5807836299999997e-04,  1.0067411929999999e-03, \
                                    1.0576340149999999e-03,  1.1103325939999999e-03,  1.1654010510000000e-03, \
                                    1.2223875630000000e-03,  1.2819029590000000e-03,  1.3434391080000001e-03, \
                                    1.4076421060000000e-03,  1.4739938260000000e-03,  1.5431951170000000e-03, \
                                    1.6146368790000000e-03,  1.6890852760000001e-03,  1.7659185870000000e-03, \
                                    1.8459388130000001e-03,  1.9284553650000000e-03,  2.0143359440000000e-03, \
                                    2.1028407390000000e-03,  2.1949217910000002e-03,  2.2897554130000002e-03, \
                                    2.3883231500000002e-03,  2.4898045290000000e-03,  2.5952588989999999e-03, \
                                    2.7037194540000002e-03,  2.8163576110000000e-03,  2.9321837510000001e-03, \
                                    3.0523972080000001e-03,  3.1759309510000001e-03,  3.3040770630000001e-03, \
                                    3.4356875620000001e-03,  3.5721822050000002e-03,  3.7122900070000000e-03, \
                                    3.8574564819999998e-03,  4.0064385679999997e-03,  4.1607868590000001e-03, \
                                    4.3190300740000003e-03,  4.4828906679999997e-03,  4.6508705549999996e-03, \
                                    4.8247038690000001e-03,  5.0028227180000003e-03,  5.1870730560000002e-03, \
                                    5.3757425750000001e-03,  5.5708882130000000e-03,  5.7706274340000004e-03, \
                                    5.9770270970000003e-03,  6.1882699900000001e-03,  6.4065472329999998e-03, \
                                    6.6297172649999996e-03,  6.8602323380000003e-03,  7.0959190290000003e-03, \
                                    7.3392049459999999e-03,  7.5878442090000003e-03,  7.8444144819999999e-03, \
                                    8.1064601859999995e-03,  8.3768732630000002e-03,  8.6529568610000003e-03, \
                                    8.9375692109999998e-03,  9.2281574240000008e-03,  9.5277351829999996e-03, \
                                    9.8332904740000004e-03,  1.0148205695999999e-02,  1.0469419067000000e-02, \
                                    1.0800244723000001e-02,  1.1137582368000000e-02,  1.1484940222000001e-02, \
                                    1.1838888212000000e-02,  1.2203373135000001e-02,  1.2574667334000001e-02, \
                                    1.2956624910000001e-02,  1.3345765924999999e-02,  1.3746115386999999e-02, \
                                    1.4153560391000001e-02,  1.4572652001000001e-02,  1.4999213139000000e-02, \
                                    1.5437672182000000e-02,  1.5883836009000001e-02,  1.6342346896999999e-02, \
                                    1.6808581744999999e-02,  1.7287786478000000e-02,  1.7774964747999999e-02, \
                                    1.8275172905000001e-02,  1.8783776488999999e-02,  1.9306056237000001e-02, \
                                    1.9836521257000000e-02,  2.0381187150000001e-02,  2.0934474413999999e-02, \
                                    2.1502142645999998e-02,  2.2078695092999999e-02,  2.2670144674000001e-02, \
                                    2.3270424216999999e-02,  2.3886325372999999e-02,  2.4511298030000000e-02, \
                                    2.5151857039000001e-02,  2.5801981081000000e-02,  2.6468457636000000e-02, \
                                    2.7144138894999999e-02,  2.7836746074999998e-02,  2.8539042297000002e-02, \
                                    2.9258380008999999e-02,  2.9987718938000001e-02,  3.0734664368999999e-02, \
                                    3.1491401497999998e-02,  3.2266591401000001e-02,  3.3051840899999997e-02, \
                                    3.3855391381000001e-02,  3.4669556992999999e-02,  3.5502873311000001e-02, \
                                    3.6346246588000002e-02,  3.7209409914000000e-02,  3.8083212876000000e-02, \
                                    3.8976806117000003e-02,  3.9881342349000003e-02,  4.0806300381999998e-02, \
                                    4.1741839888000003e-02,  4.2698791983999999e-02,  4.3666577962999997e-02, \
                                    4.4655421267999998e-02,  4.5655748177000001e-02,  4.6678075036000001e-02, \
                                    4.7711129338000001e-02,  4.8766903637000002e-02,  4.9834002285999997e-02, \
                                    5.0923680935999999e-02,  5.2025011378000002e-02,  5.3149634028999998e-02, \
                                    5.4285345140000003e-02,  5.5445417278000002e-02,  5.6616857168000002e-02, \
                                    5.7812078966999997e-02,  5.9019426868999997e-02,  6.0251618735999997e-02, \
                                    6.1494860882999998e-02,  6.2763717676999994e-02,  6.4044289748000000e-02, \
                                    6.5350204790000005e-02,  6.6668175267000002e-02,  6.8012200553000002e-02, \
                                    6.9367495769000004e-02,  7.0750048693000001e-02,  7.2144178256000002e-02, \
                                    7.3564718710999996e-02,  7.4997641758000000e-02,  7.6458124301000005e-02, \
                                    7.7929612810999999e-02,  7.9429549808999994e-02,  8.0941218246999999e-02, \
                                    8.2480783055000007e-02,  8.4032440957999999e-02,  8.5612757551999999e-02, \
                                    8.7204162178000005e-02,  8.8825526510999994e-02,  9.0458242761999999e-02, \
                                    9.2119797623999994e-02,  9.3793570349999994e-02,  9.5497494762999999e-02, \
                                    9.7211913341999995e-02,  9.8957342061000000e-02,  1.0071407322100000e-01, \
                                    1.0250101658000001e-01,  1.0429970504400000e-01,  1.0612937631000000e-01, \
                                    1.0796944052599999e-01,  1.0984193223300000e-01,  1.1172505001900000e-01, \
                                    1.1363917778200000e-01,  1.1556490691200000e-01,  1.1752299139700000e-01, \
                                    1.1949058737400001e-01,  1.2149143641100001e-01,  1.2350273726700001e-01, \
                                    1.2554620882799999e-01,  1.2760049744499999e-01,  1.2968776680700000e-01, \
                                    1.3178420103200000e-01,  1.3391520484300001e-01,  1.3605562691199999e-01, \
                                    1.3822879152100001e-01,  1.4041240438300001e-01,  1.4263017443800000e-01, \
                                    1.4485600422299999e-01,  1.4711691857600001e-01,  1.4938680906800000e-01, \
                                    1.5169040140900000e-01,  1.5400337967000000e-01,  1.5635095165800000e-01, \
                                    1.5870591630700001e-01,  1.6109708660800001e-01,  1.6349590533000000e-01, \
                                    1.6592870262100001e-01,  1.6837033824900000e-01,  1.7084745505099999e-01, \
                                    1.7333054453999999e-01,  1.7585005788100000e-01,  1.7837654509100001e-01, \
                                    1.8093786790399999e-01,  1.8350652904600001e-01,  1.8611081212899999e-01, \
                                    1.8872018879399999e-01,  1.9136683133900001e-01,  1.9401890681100001e-01, \
                                    1.9670565165000001e-01,  1.9939901986200001e-01,  2.0212863995100000e-01, \
                                    2.0486161277000001e-01,  2.0763187188400001e-01,  2.1040653675300000e-01, \
                                    2.1321646501399999e-01,  2.1603121653300000e-01,  2.1888203319499999e-01, \
                                    2.2173516780700001e-01,  2.2462608975400000e-01,  2.2751959989199999e-01, \
                                    2.3044790169200000e-01,  2.3338003065700000e-01,  2.3634867436800000e-01, \
                                    2.3931756727600001e-01,  2.4232386940100001e-01,  2.4533154672300000e-01, \
                                    2.4837432344700000e-01,  2.5141896999500002e-01,  2.5449948064000000e-01, \
                                    2.5757901171900000e-01,  2.6069617792799998e-01,  2.6381261111100002e-01, \
                                    2.6696343770699998e-01,  2.7011485167200000e-01,  2.7330230404500000e-01, \
                                    2.7648642339200002e-01,  2.7970745058000002e-01,  2.8292649050000002e-01, \
                                    2.8617979292800000e-01,  2.8943150878399998e-01,  2.9271826863000000e-01, \
                                    2.9600031006799998e-01,  2.9931927950199999e-01,  3.0263381378199999e-01, \
                                    3.0598158836000000e-01,  3.0932631556500001e-01,  3.1270593961499998e-01, \
                                    3.1607848034000002e-01,  3.1948670980499999e-01,  3.2288911281700000e-01, \
                                    3.2632436333699999e-01,  3.2975420133599997e-01,  3.3321769399700002e-01, \
                                    3.3667244672199997e-01,  3.4016265524500000e-01,  3.4364445422899997e-01, \
                                    3.4715768711700001e-01,  3.5066408177899999e-01,  3.5420360141300000e-01, \
                                    3.5773186655799999e-01,  3.6129400270099998e-01,  3.6484626022599997e-01, \
                                    3.6842936918899999e-01,  3.7200303266200002e-01,  3.7560825517700003e-01, \
                                    3.7920058172299997e-01,  3.8282618624400000e-01,  3.8643936409099999e-01, \
                                    3.9008159156000000e-01,  3.9371287965000001e-01,  3.9737487885200001e-01, \
                                    4.0102138859600001e-01,  4.0469946107400001e-01,  4.0836345971900001e-01, \
                                    4.1205569730500002e-01,  4.1573434930499997e-01,  4.1944182829200000e-01, \
                                    4.2313230908700000e-01,  4.2685331417000000e-01,  4.3055776233300003e-01, \
                                    4.3428828544499998e-01,  4.3800377878199998e-01,  4.4174717669199998e-01, \
                                    4.4547086393099999e-01,  4.4922306097900000e-01,  4.5295708378400001e-01, \
                                    4.5671616002499998e-01,  4.6045769192600000e-01,  4.6422483301700002e-01, \
                                    4.6797086599400001e-01,  4.7174417579400002e-01,  4.7549683186600000e-01, \
                                    4.7927231814700000e-01,  4.8302874994500000e-01,  4.8680962521499999e-01, \
                                    4.9056680782399997e-01,  4.9434899586499997e-01,  4.9810918642800001e-01, \
                                    5.0189081357200005e-01,  5.0565100413499997e-01,  5.0943319217600003e-01, \
                                    5.1319037478499996e-01,  5.1697125005500000e-01,  5.2072768185300000e-01, \
                                    5.2450316813400000e-01,  5.2825582420600004e-01,  5.3202913400600005e-01, \
                                    5.3577516698299998e-01,  5.3954230807400005e-01,  5.4328383997499996e-01, \
                                    5.4704291621599999e-01,  5.5077693902100000e-01,  5.5452913606900001e-01, \
                                    5.5825282330799997e-01,  5.6199622121799997e-01,  5.6571171455500002e-01, \
                                    5.6944223766699997e-01,  5.7314668582999995e-01,  5.7686769091300005e-01, \
                                    5.8055817170799995e-01,  5.8426565069500003e-01,  5.8794430269499998e-01, \
                                    5.9163654028099999e-01,  5.9530053892599999e-01,  5.9897861140399999e-01, \
                                    6.0262512114800004e-01,  6.0628712034999999e-01,  6.0991840844000000e-01, \
                                    6.1356063590900001e-01,  6.1717381375600000e-01,  6.2079941827700003e-01, \
                                    6.2439174482299997e-01,  6.2799696733800003e-01,  6.3157063081099996e-01, \
                                    6.3515373977400003e-01,  6.3870599729900002e-01,  6.4226813344199996e-01, \
                                    6.4579639858700000e-01,  6.4933591822100001e-01,  6.5284231288299999e-01, \
                                    6.5635554577099997e-01,  6.5983734475500000e-01,  6.6332755327799997e-01, \
                                    6.6678230600300004e-01,  6.7024579866400003e-01,  6.7367563666300001e-01, \
                                    6.7711088718300005e-01,  6.8051329019499995e-01,  6.8392151966000003e-01, \
                                    6.8729406038499996e-01,  6.9067368443499999e-01,  6.9401841164000000e-01, \
                                    6.9736618621799995e-01,  7.0068072049800001e-01,  7.0399968993200002e-01, \
                                    7.0728173137000006e-01,  7.1056849121599996e-01,  7.1382020707200000e-01, \
                                    7.1707350950000004e-01,  7.2029254941999998e-01,  7.2351357660799998e-01, \
                                    7.2669769595500000e-01,  7.2988514832800000e-01,  7.3303656229299996e-01, \
                                    7.3618738888900004e-01,  7.3930382207199996e-01,  7.4242098828100000e-01, \
                                    7.4550051935999995e-01,  7.4858103000499998e-01,  7.5162567655300005e-01, \
                                    7.5466845327700005e-01,  7.5767613059899996e-01,  7.6068243272400005e-01, \
                                    7.6365132563200000e-01,  7.6661996934300003e-01,  7.6955209830799998e-01, \
                                    7.7248040010800001e-01,  7.7537391024600000e-01,  7.7826483219300002e-01, \
                                    7.8111796680500001e-01,  7.8396878346700005e-01,  7.8678353498599995e-01, \
                                    7.8959346324699997e-01,  7.9236812811599999e-01,  7.9513838722999997e-01, \
                                    7.9787136004899994e-01,  8.0060098013799996e-01,  8.0329434835000002e-01, \
                                    8.0598109318900002e-01,  8.0863316866099999e-01,  8.1127981120600001e-01, \
                                    8.1388918787099995e-01,  8.1649347095400004e-01,  8.1906213209599998e-01, \
                                    8.2162345490900002e-01,  8.2414994211899995e-01,  8.2666945546000004e-01, \
                                    8.2915254494900004e-01,  8.3162966175099995e-01,  8.3407129737899999e-01, \
                                    8.3650409466999998e-01,  8.3890291339199996e-01,  8.4129408369299996e-01, \
                                    8.4364904834200005e-01,  8.4599662033000000e-01,  8.4830959859099997e-01, \
                                    8.5061319093200005e-01,  8.5288308142400004e-01,  8.5514399577699995e-01, \
                                    8.5736982556200003e-01,  8.5958759561700004e-01,  8.6177120847900002e-01, \
                                    8.6394437308799998e-01,  8.6608479515699999e-01,  8.6821579896800005e-01, \
                                    8.7031223319300000e-01,  8.7239950255499998e-01,  8.7445379117199995e-01, \
                                    8.7649726273299999e-01,  8.7850856358899998e-01,  8.8050941262600002e-01, \
                                    8.8247700860300005e-01,  8.8443509308799995e-01,  8.8636082221800006e-01, \
                                    8.8827494998099998e-01,  8.9015806776700002e-01,  8.9203055947400001e-01, \
                                    8.9387062369000003e-01,  8.9570029495600001e-01,  8.9749898342000001e-01, \
                                    8.9928592677899999e-01,  9.0104265793899996e-01,  9.0278808665800003e-01, \
                                    9.0450250523700004e-01,  9.0620642964999998e-01,  9.0788020237599998e-01, \
                                    9.0954175723800001e-01,  9.1117447348900005e-01,  9.1279583782200002e-01, \
                                    9.1438724244799996e-01,  9.1596755904200000e-01,  9.1751921694500005e-01, \
                                    9.1905878175300004e-01,  9.2057045019100003e-01,  9.2207038718900003e-01, \
                                    9.2354187569900004e-01,  9.2500235824199994e-01,  9.2643528128899999e-01, \
                                    9.2785582174400005e-01,  9.2924995130700005e-01,  9.3063250423099997e-01, \
                                    9.3198779944700005e-01,  9.3333182473300003e-01,  9.3464979521000002e-01, \
                                    9.3595571025199997e-01,  9.3723628232300005e-01,  9.3850513911699995e-01, \
                                    9.3974838126399995e-01,  9.4098057313100003e-01,  9.4218792103299998e-01, \
                                    9.4338314283199998e-01,  9.4455458272199999e-01,  9.4571465485999995e-01, \
                                    9.4685036597100003e-01,  9.4797498862200003e-01,  9.4907631906400003e-01, \
                                    9.5016599771400001e-01,  9.5123309636300002e-01,  9.5228887066199996e-01, \
                                    9.5332192496400003e-01,  9.5434425182299998e-01,  9.5534457873199996e-01, \
                                    9.5633342203700000e-01,  9.5730120801600005e-01,  9.5825816011200005e-01, \
                                    9.5919369961800005e-01,  9.6011865765100002e-01,  9.6102319388299995e-01, \
                                    9.6191678712399997e-01,  9.6279059008599999e-01,  9.6365375341199999e-01, \
                                    9.6449712668900001e-01,  9.6533044300699999e-01,  9.6614460861899998e-01, \
                                    9.6694815909999998e-01,  9.6773340859900003e-01,  9.6850859850200000e-01, \
                                    9.6926533563100004e-01,  9.7001228106199999e-01,  9.7074161999099995e-01, \
                                    9.7146095770300001e-01,  9.7216325392500003e-01,  9.7285586110500000e-01, \
                                    9.7353154236399997e-01,  9.7419801891900004e-01,  9.7484814296099997e-01, \
                                    9.7548870197000004e-01,  9.7611367462700005e-01,  9.7672957578300001e-01, \
                                    9.7732985532600003e-01,  9.7792130490700002e-01,  9.7849785735399997e-01, \
                                    9.7906552558600002e-01,  9.7961881284999996e-01,  9.8016347874300003e-01, \
                                    9.8069394376300001e-01,  9.8121622351100002e-01,  9.8172482709499997e-01, \
                                    9.8222503525200000e-01,  9.8271221352200000e-01,  9.8319141825500000e-01, \
                                    9.8365765310300002e-01,  9.8411616399099999e-01,  9.8456232781800002e-01, \
                                    9.8500078686100001e-01,  9.8542734799900000e-01,  9.8584643960899998e-01, \
                                    9.8625388461300001e-01,  9.8665423407499997e-01,  9.8704337508999995e-01, \
                                    9.8742533266599997e-01,  9.8779662686500003e-01,  9.8816111178800004e-01, \
                                    9.8851505977800003e-01,  9.8886241763200000e-01,  9.8919975527699999e-01, \
                                    9.8953058093299995e-01,  9.8985179430400005e-01,  9.9016670952600006e-01, \
                                    9.9047226481700001e-01,  9.9077184257600004e-01,  9.9106243078900003e-01, \
                                    9.9134704313900002e-01,  9.9162312673700004e-01,  9.9189353981399997e-01, \
                                    9.9215558551799998e-01,  9.9241215579099995e-01,  9.9266079505399996e-01, \
                                    9.9290408097100002e-01,  9.9313976766199996e-01,  9.9337028273500005e-01, \
                                    9.9359345276699995e-01,  9.9381173001000001e-01,  9.9402297290300001e-01, \
                                    9.9422937256599997e-01,  9.9442911178700000e-01,  9.9462425742500005e-01, \
                                    9.9481292694400003e-01,  9.9499717728199999e-01,  9.9517529613099998e-01, \
                                    9.9534912944499998e-01,  9.9551710933199999e-01,  9.9568096992599997e-01, \
                                    9.9583921314099999e-01,  9.9599356143200002e-01,  9.9614254351800002e-01, \
                                    9.9628770999299998e-01,  9.9642781779500000e-01,  9.9656431243800003e-01, \
                                    9.9669592293700005e-01,  9.9682406904900001e-01,  9.9694760279200001e-01, \
                                    9.9706781624899998e-01,  9.9718364238900004e-01,  9.9729628054599995e-01, \
                                    9.9740474110099997e-01,  9.9751019547099995e-01,  9.9761167684999996e-01, \
                                    9.9771024458699997e-01,  9.9780507820900000e-01,  9.9789715926099998e-01, \
                                    9.9798566405599998e-01,  9.9807154463500003e-01,  9.9815406118700001e-01, \
                                    9.9823408141299996e-01,  9.9831091472400002e-01,  9.9838536312100001e-01, \
                                    9.9845680488300004e-01,  9.9852600617400000e-01,  9.9859235789400003e-01, \
                                    9.9865656089199994e-01,  9.9871809704100001e-01,  9.9877761243700003e-01, \
                                    9.9883459894899995e-01,  9.9888966740600005e-01,  9.9894236598499997e-01, \
                                    9.9899325880699996e-01,  9.9904192163700001e-01,  9.9908886766200000e-01, \
                                    9.9913372788400001e-01,  9.9917698265699995e-01,  9.9921827187400003e-01, \
                                    9.9925804131100004e-01,  9.9929598198500003e-01,  9.9933249961100001e-01, \
                                    9.9936729969299998e-01,  9.9940075827399999e-01,  9.9943261971700004e-01, \
                                    9.9946323164499995e-01,  9.9949235006899995e-01,  9.9952028928500003e-01, \
                                    9.9954684664200000e-01,  9.9957231007900005e-01,  9.9959648067600004e-01, \
                                    9.9961962786100000e-01,  9.9964158191200003e-01,  9.9966258425400001e-01, \
                                    9.9968248123100001e-01,  9.9970148944299997e-01,  9.9971947711700004e-01, \
                                    9.9973664716499999e-01,  9.9975287235700006e-01,  9.9976833429599998e-01, \
                                    9.9978293309300004e-01,  9.9979683005200004e-01,  9.9980992800599999e-01, \
                                    9.9982237879000002e-01,  9.9983410079000001e-01,  9.9984522747399995e-01, \
                                    9.9985568853700002e-01,  9.9986560025200000e-01,  9.9987490470800000e-01, \
                                    9.9988371201199999e-01,  9.9989196442299999e-01,  9.9989975854799995e-01, \
                                    9.9990705424199999e-01,  9.9991393402999995e-01,  9.9992035930599998e-01, \
                                    9.9992640823300005e-01,  9.9993204850600004e-01,  9.9993734744600005e-01, \
                                    9.9994228010399999e-01,  9.9994690372799999e-01,  9.9995119857299997e-01, \
                                    9.9995521895299999e-01,  9.9995894430300003e-01,  9.9996242127699997e-01, \
                                    9.9996563884300005e-01,  9.9996863537900005e-01,  9.9997139984399996e-01, \
                                    9.9997396884800005e-01,  9.9997633336000002e-01,  9.9997852453900005e-01, \
                                    9.9998053692900002e-01,  9.9998239577799997e-01,  9.9998409766700003e-01, \
                                    9.9998566674400002e-01,  9.9998709857699997e-01,  9.9998841325300003e-01, \
                                    9.9998961050099999e-01,  9.9999070629900000e-01,  9.9999169980500002e-01, \
                                    9.9999260643599996e-01,  9.9999342560100002e-01,  9.9999417000400004e-01, \
                                    9.9999484036099995e-01,  9.9999544668899998e-01,  9.9999599017800000e-01, \
                                    9.9999648027599997e-01,  9.9999691734100005e-01,  9.9999730908399997e-01, \
                                    9.9999765724800005e-01,  9.9999796774399996e-01,  9.9999824184800001e-01, \
                                    9.9999848513400003e-01,  9.9999869865799995e-01,  9.9999888686700000e-01, \
                                    9.9999905119400001e-01,  9.9999919495400003e-01,  9.9999931947800003e-01, \
                                    9.9999942783200002e-01,  9.9999952088499999e-01,  9.9999960101899998e-01, \
                                    9.9999966941899998e-01,  9.9999972778699997e-01,  9.9999977703300003e-01, \
                                    9.9999981868800003e-01,  9.9999985345800002e-01,  9.9999988248000005e-01, \
                                    9.9999990645600001e-01,  9.9999992618099998e-01,  9.9999994221699995e-01, \
                                    9.9999995525899998e-01,  9.9999996568000005e-01,  9.9999997397700002e-01, \
                                    9.9999998050700001e-01,  9.9999998559699999e-01,  9.9999998949900004e-01, \
                                    9.9999999247700000e-01,  9.9999999470099998e-01,  9.9999999634100001e-01, \
                                    9.9999999753000002e-01,  9.9999999837400000e-01,  9.9999999895699998e-01, \
                                    9.9999999935499995e-01,  9.9999999961399999e-01,  9.9999999977900000e-01, \
                                    9.9999999987999999e-01,  9.9999999993900002e-01,  9.9999999997099998e-01, \
                                    9.9999999998800004e-01,  9.9999999999500000e-01,  9.9999999999900002e-01, \
                                    1.0000000000000000e+00,  1.0000000000000000e+00,  1.0000000000000000e+00, \
                                    1.0000000000000000e+00,  0.0000000000000000e+00,  0.0000000000000000e+00, \
                                    0.0000000000000000e+00,  0.0000000000000000e+00,  0.0000000000000000e+00, \
                                    9.9999999999999998e-13,  2.0000000000000000e-12,  4.9999999999999997e-12, \
                                    9.9999999999999994e-12,  1.8999999999999999e-11,  3.3999999999999999e-11, \
                                    5.9000000000000003e-11,  9.7000000000000001e-11,  1.5600000000000000e-10, \
                                    2.4199999999999999e-10,  3.6700000000000003e-10,  5.4299999999999999e-10, \
                                    7.8699999999999997e-10,  1.1190000000000000e-09,  1.5650000000000001e-09, \
                                    2.1550000000000001e-09,  2.9279999999999998e-09,  3.9259999999999999e-09, \
                                    5.2020000000000000e-09,  6.8219999999999998e-09,  8.8509999999999993e-09, \
                                    1.1377999999999999e-08,  1.4501000000000000e-08,  1.8329000000000002e-08, \
                                    2.2989000000000002e-08,  2.8635000000000001e-08,  3.5416999999999999e-08, \
                                    4.3534999999999999e-08,  5.3194000000000000e-08,  6.4622999999999996e-08, \
                                    7.8084000000000000e-08,  9.3896999999999997e-08,  1.1233700000000000e-07, \
                                    1.3379799999999999e-07,  1.5866800000000000e-07,  1.8738100000000000e-07, \
                                    2.2038900000000000e-07,  2.5827699999999998e-07,  3.0153199999999998e-07, \
                                    3.5084900000000002e-07,  4.0687199999999999e-07,  4.7033099999999998e-07, \
                                    5.4199800000000001e-07,  6.2284599999999999e-07,  7.1363599999999997e-07, \
                                    8.1548700000000003e-07,  9.2944200000000005e-07,  1.0566800000000001e-06, \
                                    1.1983440000000000e-06,  1.3559410000000001e-06,  1.5306579999999999e-06, \
                                    1.7242320000000000e-06,  1.9381659999999998e-06,  2.1741839999999998e-06, \
                                    2.4340450000000001e-06,  2.7200050000000001e-06,  3.0336839999999998e-06, \
                                    3.3775899999999998e-06,  3.7539170000000000e-06,  4.1652429999999997e-06, \
                                    4.6138730000000003e-06,  5.1029830000000003e-06,  5.6349260000000003e-06, \
                                    6.2132909999999998e-06,  6.8409040000000001e-06,  7.5213089999999999e-06, \
                                    8.2577260000000000e-06,  9.0546809999999996e-06,  9.9150200000000005e-06, \
                                    1.0843618999999999e-05,  1.1844298000000001e-05,  1.2922097000000000e-05, \
                                    1.4080882999999999e-05,  1.5326561999999999e-05,  1.6663086000000001e-05, \
                                    1.8097138000000001e-05,  1.9633134000000000e-05,  2.1277697000000000e-05, \
                                    2.3035858999999999e-05,  2.4915741000000002e-05,  2.6921737000000001e-05, \
                                    2.9062330999999999e-05,  3.1343315000000003e-05,  3.3773726999999999e-05, \
                                    3.6359068000000001e-05,  3.9109397000000000e-05,  4.2030599999999997e-05, \
                                    4.5134062999999997e-05,  4.8425667999999999e-05,  5.1916928000000001e-05, \
                                    5.5614783000000002e-05,  5.9532440000000002e-05,  6.3676144999999995e-05, \
                                    6.8059507999999996e-05,  7.2690202000000003e-05,  7.7583445000000003e-05, \
                                    8.2746046000000003e-05,  8.8193834000000002e-05,  9.3935026000000006e-05, \
                                    9.9987411999999997e-05,  1.0635806400000000e-04,  1.1306535300000000e-04, \
                                    1.2011813300000000e-04,  1.2753638700000001e-04,  1.3532850799999999e-04, \
                                    1.4351477300000000e-04,  1.5210432400000000e-04,  1.6112146000000000e-04, \
                                    1.7057360199999999e-04,  1.8048374600000000e-04,  1.9086338500000000e-04, \
                                    2.0173810000000001e-04,  2.1311565899999999e-04,  2.2502407399999999e-04, \
                                    2.3747359600000001e-04,  2.5049266000000002e-04,  2.6409229600000001e-04, \
                                    2.7830113400000001e-04,  2.9312912299999999e-04,  3.0861275800000000e-04, \
                                    3.2475944999999998e-04,  3.4160032700000000e-04,  3.5915166300000000e-04, \
                                    3.7744854899999998e-04,  3.9649797799999999e-04,  4.1634144399999999e-04, \
                                    4.3698917000000001e-04,  4.5848026099999997e-04,  4.8082919800000002e-04, \
                                    5.0407424399999997e-04,  5.2822507700000002e-04,  5.5333475599999996e-04, \
                                    5.7940905900000000e-04,  6.0648845500000000e-04,  6.3459561200000000e-04, \
                                    6.6377723999999996e-04,  6.9403677500000003e-04,  7.2543452400000003e-04, \
                                    7.5797894799999998e-04,  7.9172142400000005e-04,  8.2668102900000000e-04, \
                                    8.6290702999999999e-04,  9.0040678899999996e-04,  9.3925626100000001e-04, \
                                    9.7945596300000001e-04,  1.0210584980000000e-03,  1.0640929710000000e-03, \
                                    1.1086211779999999e-03,  1.1546389809999999e-03,  1.2022320090000001e-03, \
                                    1.2514037350000000e-03,  1.3022196080000000e-03,  1.3547054690000000e-03, \
                                    1.4089233730000001e-03,  1.4648738520000001e-03,  1.5226647099999999e-03, \
                                    1.5822851960000000e-03,  1.6438029610000000e-03,  1.7072550699999999e-03, \
                                    1.7727211280000000e-03,  1.8401840710000001e-03,  1.9097628380000001e-03, \
                                    1.9814519470000001e-03,  2.0553341889999999e-03,  2.1314411309999999e-03, \
                                    2.2098510850000002e-03,  2.2905510030000000e-03,  2.3736922769999999e-03, \
                                    2.4592457440000002e-03,  2.5472958060000000e-03,  2.6378904980000001e-03, \
                                    2.7311284049999999e-03,  2.8269737709999999e-03,  2.9255888529999999e-03, \
                                    3.0269515539999999e-03,  3.1311661540000001e-03,  3.2382693790000000e-03, \
                                    3.3483598759999999e-03,  3.4614028070000000e-03,  3.5776052939999999e-03, \
                                    3.6969124949999999e-03,  3.8194255150000001e-03,  3.9452057650000002e-03, \
                                    4.0743750610000001e-03,  4.2068681109999999e-03,  4.3429043920000000e-03, \
                                    4.4824345169999997e-03,  4.6255893960000004e-03,  4.7724120209999997e-03, \
                                    4.9230209999999996e-03,  5.0773536750000001e-03,  5.2356826189999999e-03, \
                                    5.3979195699999996e-03,  5.5641845380000002e-03,  5.7345538109999997e-03, \
                                    5.9091764789999997e-03,  6.0879421240000002e-03,  6.2711461769999997e-03, \
                                    6.4587005519999999e-03,  6.6507644200000000e-03,  6.8473882990000004e-03, \
                                    7.0487109529999998e-03,  7.2546326279999997e-03,  7.4655085889999999e-03, \
                                    7.6812025829999997e-03,  7.9018553950000008e-03,  8.1275574770000008e-03, \
                                    8.3584913500000003e-03,  8.5944911440000004e-03,  8.8359372689999997e-03, \
                                    9.0826951489999998e-03,  9.3349503370000007e-03,  9.5927662530000003e-03, \
                                    9.8563014790000007e-03,  1.0125403498000000e-02,  1.0400533776000000e-02, \
                                    1.0681486778000000e-02,  1.0968430772000000e-02,  1.1261472337999999e-02, \
                                    1.1560826761000001e-02,  1.1866258619000000e-02,  1.2178246041000000e-02, \
                                    1.2496600143000001e-02,  1.2821533636999999e-02,  1.3153122523000001e-02, \
                                    1.3491549522999999e-02,  1.3836589993000000e-02,  1.4188831032999999e-02, \
                                    1.4547985150000000e-02,  1.4914244110999999e-02,  1.5287737597000001e-02, \
                                    1.5668706728000002e-02,  1.6056837562000000e-02,  1.6452727319999999e-02, \
                                    1.6856110688000001e-02,  1.7267234522000002e-02,  1.7686179223000000e-02, \
                                    1.8113156839999998e-02,  1.8547856941000002e-02,  1.8991009844000001e-02, \
                                    1.9442232273000001e-02,  1.9901726423000001e-02,  2.0369660957000001e-02, \
                                    2.0846306055000000e-02,  2.1331246113000000e-02,  2.1825213489000000e-02, \
                                    2.2327846384000000e-02,  2.2839431792000001e-02,  2.3360061070000000e-02, \
                                    2.3889967182999999e-02,  2.4428743103000000e-02,  2.4977273524000001e-02, \
                                    2.5535068508999999e-02,  2.6102346222999999e-02,  2.6679303806000001e-02, \
                                    2.7266246410999999e-02,  2.7862627428000001e-02,  2.8469348094000001e-02, \
                                    2.9085935135000001e-02,  2.9712703933999999e-02,  3.0349771224999999e-02, \
                                    3.0997370125999998e-02,  3.1654994369000003e-02,  3.2323701468000003e-02, \
                                    3.3002875034999997e-02,  3.3692746267000001e-02,  3.4393537246999999e-02, \
                                    3.5105598951000003e-02,  3.5828235591999998e-02,  3.6562527890000002e-02, \
                                    3.7307878680000003e-02,  3.8064622740999997e-02,  3.8832907965000003e-02, \
                                    3.9612975145999998e-02,  4.0404193206999998e-02,  4.1207817958000000e-02, \
                                    4.2023068130999999e-02,  4.2850195520000002e-02,  4.3689469384000000e-02, \
                                    4.4541265130999999e-02,  4.5404733458000002e-02,  4.6281127156000003e-02, \
                                    4.7169727500000001e-02,  4.8070888421999997e-02,  4.8984785693999999e-02, \
                                    4.9911669185000000e-02,  5.0850741523000002e-02,  5.1803499140999999e-02, \
                                    5.2768989650999999e-02,  5.3747469250999998e-02,  5.4739251365999997e-02, \
                                    5.5744720259000000e-02,  5.6762874728999997e-02,  5.7795164469000002e-02, \
                                    5.8840717910999998e-02,  5.9899910580000000e-02,  6.0972935051000002e-02, \
                                    6.2060057420000002e-02,  6.3160318817999994e-02,  6.4275448769000001e-02, \
                                    6.5404312026000000e-02,  6.6547139850999998e-02,  6.7704325230000001e-02, \
                                    6.8876263977999994e-02,  7.0061762853999995e-02,  7.1262499581000005e-02, \
                                    7.2477414005000004e-02,  7.3706923815000006e-02,  7.4951237140000002e-02, \
                                    7.6210624825999995e-02,  7.7483951565000000e-02,  7.8773172288000001e-02, \
                                    8.0076977613000005e-02,  8.1395584374000005e-02,  8.2729455542999999e-02, \
                                    8.4078995788999994e-02,  8.5442790874000002e-02,  8.6822761398000006e-02, \
                                    8.8217664687000000e-02,  8.9627934369999995e-02,  9.1053819857999999e-02, \
                                    9.2495553080000001e-02,  9.3951834168000001e-02,  9.5424886656999997e-02, \
                                    9.6913182296999995e-02,  9.8416927924999995e-02,  9.9936611620999996e-02, \
                                    1.0147268919800000e-01,  1.0302352196099999e-01,  1.0459127019099999e-01, \
                                    1.0617450587799999e-01,  1.0777363249499999e-01,  1.0938897907400000e-01, \
                                    1.1102074651100000e-01,  1.1266745538100000e-01,  1.1433158302500000e-01, \
                                    1.1601135493799999e-01,  1.1770699473800000e-01,  1.1941904605700000e-01, \
                                    1.2114797313700000e-01,  1.2289190822300000e-01,  1.2465323774900000e-01, \
                                    1.2643036212100001e-01,  1.2822368467100001e-01,  1.3003357602400001e-01, \
                                    1.3186021035100001e-01,  1.3370188200200001e-01,  1.3556136786100001e-01, \
                                    1.3743667062900000e-01,  1.3932797483699999e-01,  1.4123591108500000e-01, \
                                    1.4316090404400000e-01,  1.4510090173900000e-01,  1.4705850659700001e-01, \
                                    1.4903193829299999e-01,  1.5102159712600000e-01,  1.5302786439800001e-01, \
                                    1.5505090982100000e-01,  1.5708883118000000e-01,  1.5914467487500000e-01, \
                                    1.6121622007799999e-01,  1.6330357854899999e-01,  1.6540750082200001e-01, \
                                    1.6752838638299999e-01,  1.6966397284400001e-01,  1.7181709027600001e-01, \
                                    1.7398573089800001e-01,  1.7617030322400001e-01,  1.7837126436000000e-01, \
                                    1.8058873303199999e-01,  1.8282063494100001e-01,  1.8507019503300001e-01, \
                                    1.8733505265000000e-01,  1.8961523981500000e-01,  1.9191161244900001e-01, \
                                    1.9422452982600000e-01,  1.9655150098800001e-01,  1.9889560752400001e-01, \
                                    2.0125466579500001e-01,  2.0362905823300001e-01,  2.0601929995400001e-01, \
                                    2.0842539278300001e-01,  2.1084516071000001e-01,  2.1328203820600000e-01, \
                                    2.1573349463100000e-01,  2.1819946264500001e-01,  2.2068090483000000e-01, \
                                    2.2317814121700000e-01,  2.2568852701000000e-01,  2.2821528632900001e-01, \
                                    2.3075613040099999e-01,  2.3331131262300001e-01,  2.3588150716900000e-01, \
                                    2.3846660893400001e-01,  2.4106431991999999e-01,  2.4367825349800001e-01, \
                                    2.4630569341500000e-01,  2.4894652016499999e-01,  2.5160181660100001e-01, \
                                    2.5427181242300001e-01,  2.5695376403999998e-01,  2.5965094696600000e-01, \
                                    2.6236104740200000e-01,  2.6508418770100001e-01,  2.6782121878100001e-01, \
                                    2.7057187330100002e-01,  2.7333375148500000e-01,  2.7611061364400002e-01, \
                                    2.7889966411799999e-01,  2.8170063218199998e-01,  2.8451478541800002e-01, \
                                    2.8734217290600000e-01,  2.9018003119199998e-01,  2.9303169815899999e-01, \
                                    2.9589484070400002e-01,  2.9876942641400001e-01,  3.0165641778100000e-01, \
                                    3.0455542811300002e-01,  3.0746406455699998e-01,  3.1038611967500002e-01, \
                                    3.1331878500900001e-01,  3.1626153656700001e-01,  3.1921592791100001e-01, \
                                    3.2218181006300001e-01,  3.2515644726199999e-01,  3.2814315105199998e-01, \
                                    3.3113957765099999e-01,  3.3414555422999997e-01,  3.3716226714600001e-01, \
                                    3.4018909443399997e-01,  3.4322369404500003e-01,  3.4626979740300001e-01, \
                                    3.4932470838599999e-01,  3.5238766832399998e-01,  3.5546046473900000e-01, \
                                    3.5854274794600000e-01,  3.6163178973299998e-01,  3.6473087367500001e-01, \
                                    3.6783775568799998e-01,  3.7095203227599999e-01,  3.7407515960600002e-01, \
                                    3.7720618783499998e-01,  3.8034298514900000e-01,  3.8348913748399999e-01, \
                                    3.8664208607299999e-01,  3.8980080243999998e-01,  3.9296731304799998e-01, \
                                    3.9614105622099999e-01,  3.9931943468699999e-01,  4.0250562006700003e-01, \
                                    4.0569751168599999e-01,  4.0889438873700001e-01,  4.1209802614500002e-01, \
                                    4.1530720785600000e-01,  4.1851997962699999e-01,  4.2173975765200000e-01, \
                                    4.2496412207700002e-01,  4.2819178970999999e-01,  4.3142510977800003e-01, \
                                    4.3466322309200001e-01,  4.3790376414700000e-01,  4.4114959865300002e-01, \
                                    4.4439891591100000e-01,  4.4765071581100002e-01,  4.5090706303299999e-01, \
                                    4.5416643975499998e-01,  4.5742705782499998e-01,  4.6069220666299998e-01, \
                                    4.6395967615000000e-01,  4.6722788834800000e-01,  4.7049949047400003e-01, \
                                    4.7377326372200002e-01,  4.7704715905900003e-01,  4.8032378328000003e-01, \
                                    4.8360160323099999e-01,  4.8687929941699998e-01,  4.9015920108900002e-01, \
                                    4.9343954384900002e-01,  4.9671881177600002e-01,  5.0000000000000000e-01, \
                                    5.0328118822400003e-01,  5.0656045615099998e-01,  5.0984079891099998e-01, \
                                    5.1312070058299997e-01,  5.1639839676900001e-01,  5.1967621671999997e-01, \
                                    5.2295284094100003e-01,  5.2622673627799998e-01,  5.2950050952600003e-01, \
                                    5.3277211165200000e-01,  5.3604032385000000e-01,  5.3930779333699996e-01, \
                                    5.4257294217499996e-01,  5.4583356024499996e-01,  5.4909293696700001e-01, \
                                    5.5234928418899998e-01,  5.5560108408900000e-01,  5.5885040134700004e-01, \
                                    5.6209623585299995e-01,  5.6533677690799999e-01,  5.6857489022200003e-01, \
                                    5.7180821028999995e-01,  5.7503587792300004e-01,  5.7826024234800000e-01, \
                                    5.8148002037299995e-01,  5.8469279214400005e-01,  5.8790197385499998e-01, \
                                    5.9110561126299999e-01,  5.9430248831400001e-01,  5.9749437993300003e-01, \
                                    6.0068056531299996e-01,  6.0385894377899996e-01,  6.0703268695199997e-01, \
                                    6.1019919755999996e-01,  6.1335791392700001e-01,  6.1651086251599996e-01, \
                                    6.1965701485100000e-01,  6.2279381216499996e-01,  6.2592484039399998e-01, \
                                    6.2904796772399996e-01,  6.3216224431199997e-01,  6.3526912632499999e-01, \
                                    6.3836821026699997e-01,  6.4145725205399995e-01,  6.4453953526100005e-01, \
                                    6.4761233167599996e-01,  6.5067529161399995e-01,  6.5373020259699999e-01, \
                                    6.5677630595500003e-01,  6.5981090556599997e-01,  6.6283773285400005e-01, \
                                    6.6585444576999997e-01,  6.6886042234900001e-01,  6.7185684894800002e-01, \
                                    6.7484355273800001e-01,  6.7781818993700005e-01,  6.8078407208900005e-01, \
                                    6.8373846343300004e-01,  6.8668121499099999e-01,  6.8961388032500004e-01, \
                                    6.9253593544299996e-01,  6.9544457188700004e-01,  6.9834358221899995e-01, \
                                    7.0123057358600005e-01,  7.0410515929600004e-01,  7.0696830184100001e-01, \
                                    7.0981996880800002e-01,  7.1265782709400005e-01,  7.1548521458199998e-01, \
                                    7.1829936781799997e-01,  7.2110033588199995e-01,  7.2388938635599998e-01, \
                                    7.2666624851499995e-01,  7.2942812669900003e-01,  7.3217878121900004e-01, \
                                    7.3491581229900005e-01,  7.3763895259800005e-01,  7.4034905303400000e-01, \
                                    7.4304623595999997e-01,  7.4572818757699999e-01,  7.4839818339899999e-01, \
                                    7.5105347983500004e-01,  7.5369430658500003e-01,  7.5632174650200001e-01, \
                                    7.5893568008000001e-01,  7.6153339106600004e-01,  7.6411849283099997e-01, \
                                    7.6668868737700002e-01,  7.6924386959900004e-01,  7.7178471367099999e-01, \
                                    7.7431147299000003e-01,  7.7682185878300003e-01,  7.7931909516999998e-01, \
                                    7.8180053735499999e-01,  7.8426650536900000e-01,  7.8671796179400000e-01, \
                                    7.8915483928999997e-01,  7.9157460721700001e-01,  7.9398070004599997e-01, \
                                    7.9637094176699996e-01,  7.9874533420500005e-01,  8.0110439247599996e-01, \
                                    8.0344849901199999e-01,  8.0577547017399997e-01,  8.0808838755099999e-01, \
                                    8.1038476018500005e-01,  8.1266494735000006e-01,  8.1492980496699996e-01, \
                                    8.1717936505900002e-01,  8.1941126696800004e-01,  8.2162873564000005e-01, \
                                    8.2382969677600004e-01,  8.2601426910200004e-01,  8.2818290972399999e-01, \
                                    8.3033602715599997e-01,  8.3247161361699995e-01,  8.3459249917800005e-01, \
                                    8.3669642145099998e-01,  8.3878377992200004e-01,  8.4085532512500005e-01, \
                                    8.4291116881999995e-01,  8.4494909017900000e-01,  8.4697213560200002e-01, \
                                    8.4897840287399995e-01,  8.5096806170700001e-01,  8.5294149340299996e-01, \
                                    8.5489909826099997e-01,  8.5683909595600005e-01,  8.5876408891500000e-01, \
                                    8.6067202516300001e-01,  8.6256332937100000e-01,  8.6443863213899996e-01, \
                                    8.6629811799800005e-01,  8.6813978964899996e-01,  8.6996642397599999e-01, \
                                    8.7177631532900002e-01,  8.7356963787899999e-01,  8.7534676225100005e-01, \
                                    8.7710809177700000e-01,  8.7885202686300001e-01,  8.8058095394299996e-01, \
                                    8.8229300526200005e-01,  8.8398864506200003e-01,  8.8566841697499998e-01, \
                                    8.8733254461900002e-01,  8.8897925348899998e-01,  8.9061102092599997e-01, \
                                    8.9222636750499995e-01,  8.9382549412199996e-01,  8.9540872980899999e-01, \
                                    8.9697647803900005e-01,  8.9852731080199999e-01,  9.0006338837900002e-01, \
                                    9.0158307207499999e-01,  9.0308681770300003e-01,  9.0457511334300000e-01, \
                                    9.0604816583199999e-01,  9.0750444691999999e-01,  9.0894618014200002e-01, \
                                    9.1037206562999995e-01,  9.1178233531300001e-01,  9.1317723860199995e-01, \
                                    9.1455720912600003e-01,  9.1592100421099998e-01,  9.1727054445699996e-01, \
                                    9.1860441562600004e-01,  9.1992302238699997e-01,  9.2122682771200004e-01, \
                                    9.2251604843500001e-01,  9.2378937517399995e-01,  9.2504876286000004e-01, \
                                    9.2629307618500001e-01,  9.2752258599500004e-01,  9.2873750041900005e-01, \
                                    9.2993823714599999e-01,  9.3112373602200005e-01,  9.3229567476999997e-01, \
                                    9.3345286014899997e-01,  9.3459568797399994e-01,  9.3572455123099996e-01, \
                                    9.3683968118200001e-01,  9.3793994258000002e-01,  9.3902706494900001e-01, \
                                    9.4010008942000001e-01,  9.4115928208900002e-01,  9.4220483553099998e-01, \
                                    9.4323712527100001e-01,  9.4425527974099999e-01,  9.4526074863400000e-01, \
                                    9.4625253074899995e-01,  9.4723101034900004e-01,  9.4819650085899998e-01, \
                                    9.4914925847700005e-01,  9.5008833081499999e-01,  9.5101521430600000e-01, \
                                    9.5192911157799998e-01,  9.5283027249999996e-01,  9.5371887284400003e-01, \
                                    9.5459526654200000e-01,  9.5545873486900001e-01,  9.5631053061600002e-01, \
                                    9.5714980447999998e-01,  9.5797693186900001e-01,  9.5879218204200001e-01, \
                                    9.5959580679300005e-01,  9.6038702485399996e-01,  9.6116709203499995e-01, \
                                    9.6193537725900002e-01,  9.6269212132000004e-01,  9.6343747210999997e-01, \
                                    9.6417176440800001e-01,  9.6489440104900004e-01,  9.6560646275299999e-01, \
                                    9.6630725373299997e-01,  9.6699712496500001e-01,  9.6767629853199999e-01, \
                                    9.6834500563100001e-01,  9.6900262987399999e-01,  9.6965022877499996e-01, \
                                    9.7028729606599995e-01,  9.7091406486499998e-01,  9.7153065190599996e-01, \
                                    9.7213737257199995e-01,  9.7273375358900005e-01,  9.7332069619399997e-01, \
                                    9.7389765377699999e-01,  9.7446493149100000e-01,  9.7502272647599997e-01, \
                                    9.7557125689699997e-01,  9.7611003281700004e-01,  9.7663993893000001e-01, \
                                    9.7716056820800001e-01,  9.7767215361600002e-01,  9.7817478651099998e-01, \
                                    9.7866875388700003e-01,  9.7915369394499996e-01,  9.7963033904300001e-01, \
                                    9.8009827357699997e-01,  9.8055776772699998e-01,  9.8100899015599996e-01, \
                                    9.8145214305899997e-01,  9.8188684315999997e-01,  9.8231382077700002e-01, \
                                    9.8273276547800004e-01,  9.8314388931200003e-01,  9.8354727267999997e-01, \
                                    9.8394316243799995e-01,  9.8433129327199997e-01,  9.8471226240300003e-01, \
                                    9.8508575588900005e-01,  9.8545201485000000e-01,  9.8581116896700005e-01, \
                                    9.8616341000700003e-01,  9.8650845047699998e-01,  9.8684687747699995e-01, \
                                    9.8717846636300000e-01,  9.8750339985699997e-01,  9.8782175395899996e-01, \
                                    9.8813374138099996e-01,  9.8843917323899999e-01,  9.8873852766199999e-01, \
                                    9.8903156922799995e-01,  9.8931851322200004e-01,  9.8959946622399997e-01, \
                                    9.8987459650200005e-01,  9.9014369852100004e-01,  9.9040723374700002e-01, \
                                    9.9066504966299995e-01,  9.9091730485100005e-01,  9.9116406273100000e-01, \
                                    9.9140550885599998e-01,  9.9164150865000000e-01,  9.9187244252300000e-01, \
                                    9.9209814460500001e-01,  9.9231879741700002e-01,  9.9253449141100003e-01, \
                                    9.9274536737200003e-01,  9.9295128904700003e-01,  9.9315261170100000e-01, \
                                    9.9334923557999999e-01,  9.9354129944799996e-01,  9.9372885382300002e-01, \
                                    9.9391205787600001e-01,  9.9409082352099998e-01,  9.9426544618900004e-01, \
                                    9.9443581546199999e-01,  9.9460208042999998e-01,  9.9476431738100002e-01, \
                                    9.9492264632500005e-01,  9.9507697900000003e-01,  9.9522758797900002e-01, \
                                    9.9537441060400000e-01,  9.9551756548299997e-01,  9.9565709560799998e-01, \
                                    9.9579313188899998e-01,  9.9592562493900005e-01,  9.9605479423499999e-01, \
                                    9.9618057448499997e-01,  9.9630308750499996e-01,  9.9642239470600003e-01, \
                                    9.9653859719299998e-01,  9.9665164012399998e-01,  9.9676173062100004e-01, \
                                    9.9686883384600000e-01,  9.9697304844599999e-01,  9.9707441114700002e-01, \
                                    9.9717302622899995e-01,  9.9726887159499999e-01,  9.9736210950199999e-01, \
                                    9.9745270419400001e-01,  9.9754075425599997e-01,  9.9762630772299998e-01, \
                                    9.9770944899699998e-01,  9.9779014891499995e-01,  9.9786855886900006e-01, \
                                    9.9794466581100005e-01,  9.9801854805300005e-01,  9.9809023716199996e-01, \
                                    9.9815981592900005e-01,  9.9822727887200002e-01,  9.9829274492999998e-01, \
                                    9.9835619703900003e-01,  9.9841771480399999e-01,  9.9847733529000005e-01, \
                                    9.9853512614800000e-01,  9.9859107662699997e-01,  9.9864529453100004e-01, \
                                    9.9869778039199997e-01,  9.9874859626500001e-01,  9.9879776799099995e-01, \
                                    9.9884536101900001e-01,  9.9889137882199996e-01,  9.9893590702900004e-01, \
                                    9.9897894150199995e-01,  9.9902054403700002e-01,  9.9906074373900000e-01, \
                                    9.9909959321099995e-01,  9.9913709296999997e-01,  9.9917331897100004e-01, \
                                    9.9920827857600003e-01,  9.9924202105200000e-01,  9.9927456547600002e-01, \
                                    9.9930596322499998e-01,  9.9933622276000000e-01,  9.9936540438800003e-01, \
                                    9.9939351154500000e-01,  9.9942059094100000e-01,  9.9944666524400005e-01, \
                                    9.9947177492299999e-01,  9.9949592575599999e-01,  9.9951917080200003e-01, \
                                    9.9954151973899996e-01,  9.9956301082999999e-01,  9.9958365855599995e-01, \
                                    9.9960350202199999e-01,  9.9962255145099999e-01,  9.9964084833699995e-01, \
                                    9.9965839967299996e-01,  9.9967524055000001e-01,  9.9969138724200002e-01, \
                                    9.9970687087700005e-01,  9.9972169886600004e-01,  9.9973590770400000e-01, \
                                    9.9974950734000001e-01,  9.9976252640399998e-01,  9.9977497592599995e-01, \
                                    9.9978688434100005e-01,  9.9979826189999998e-01,  9.9980913661500004e-01, \
                                    9.9981951625400001e-01,  9.9982942639799999e-01,  9.9983887853999998e-01, \
                                    9.9984789567599996e-01,  9.9985648522699999e-01,  9.9986467149199998e-01, \
                                    9.9987246361299997e-01,  9.9987988186700005e-01,  9.9988693464699996e-01, \
                                    9.9989364193600005e-01,  9.9990001258799999e-01,  9.9990606497400003e-01, \
                                    9.9991180616599995e-01,  9.9991725395400000e-01,  9.9992241655500003e-01, \
                                    9.9992730979800004e-01,  9.9993194049199996e-01,  9.9993632385499998e-01, \
                                    9.9994046755999999e-01,  9.9994438521700002e-01,  9.9994808307200000e-01, \
                                    9.9995157433199999e-01,  9.9995486593700000e-01,  9.9995796940000004e-01, \
                                    9.9996089060299997e-01,  9.9996364093199996e-01,  9.9996622627300003e-01, \
                                    9.9996865668500001e-01,  9.9997093766900003e-01,  9.9997307826299997e-01, \
                                    9.9997508425899995e-01,  9.9997696414100001e-01,  9.9997872230300000e-01, \
                                    9.9998036686600000e-01,  9.9998190286199995e-01,  9.9998333691399999e-01, \
                                    9.9998467343800002e-01,  9.9998591911699997e-01,  9.9998707790300001e-01, \
                                    9.9998815570199995e-01,  9.9998915638100005e-01,  9.9999008497999997e-01, \
                                    9.9999094531900001e-01,  9.9999174227400001e-01,  9.9999247869100005e-01, \
                                    9.9999315909599995e-01,  9.9999378670899997e-01,  9.9999436507399997e-01, \
                                    9.9999489701699995e-01,  9.9999538612700001e-01,  9.9999583475700005e-01, \
                                    9.9999624608299997e-01,  9.9999662240999998e-01,  9.9999696631599999e-01, \
                                    9.9999727999499999e-01,  9.9999756595500000e-01,  9.9999782581600005e-01, \
                                    9.9999806183399997e-01,  9.9999827576800004e-01,  9.9999846934199998e-01, \
                                    9.9999864405899996e-01,  9.9999880165599997e-01,  9.9999894332000006e-01, \
                                    9.9999907055799997e-01,  9.9999918451299996e-01,  9.9999928636400004e-01, \
                                    9.9999937715400000e-01,  9.9999945800199996e-01,  9.9999952966899996e-01, \
                                    9.9999959312800002e-01,  9.9999964915100004e-01,  9.9999969846799996e-01, \
                                    9.9999974172299999e-01,  9.9999977961099995e-01,  9.9999981261899995e-01, \
                                    9.9999984133200004e-01,  9.9999986620199999e-01,  9.9999988766299996e-01, \
                                    9.9999990610300005e-01,  9.9999992191599996e-01,  9.9999993537700005e-01, \
                                    9.9999994680600002e-01,  9.9999995646499995e-01,  9.9999996458300000e-01, \
                                    9.9999997136499996e-01,  9.9999997701099996e-01,  9.9999998167100002e-01, \
                                    9.9999998549900004e-01,  9.9999998862200001e-01,  9.9999999114899996e-01, \
                                    9.9999999317800004e-01,  9.9999999479799995e-01,  9.9999999607400003e-01, \
                                    9.9999999707200005e-01,  9.9999999784500004e-01,  9.9999999843499998e-01, \
                                    9.9999999888100000e-01,  9.9999999921299998e-01,  9.9999999945700002e-01, \
                                    9.9999999963300001e-01,  9.9999999975800002e-01,  9.9999999984400001e-01, \
                                    9.9999999990300004e-01,  9.9999999994099997e-01,  9.9999999996599997e-01, \
                                    9.9999999998099998e-01,  9.9999999999000000e-01,  9.9999999999500000e-01, \
                                    9.9999999999800004e-01,  9.9999999999900002e-01,  1.0000000000000000e+00, \
                                    1.0000000000000000e+00,  1.0000000000000000e+00,  1.0000000000000000e+00, \
                                    1.0000000000000000e+00,  1.0000000000000000e+00,  0.0000000000000000e+00, \
                                    0.0000000000000000e+00,  0.0000000000000000e+00,  0.0000000000000000e+00, \
                                    0.0000000000000000e+00,  0.0000000000000000e+00,  0.0000000000000000e+00, \
                                    0.0000000000000000e+00,  9.9999999999999998e-13,  2.0000000000000000e-12, \
                                    3.0000000000000001e-12,  4.9999999999999997e-12,  7.9999999999999998e-12, \
                                    1.4000000000000000e-11,  2.2000000000000002e-11,  3.3999999999999999e-11, \
                                    5.2000000000000001e-11,  7.5999999999999996e-11,  1.1100000000000000e-10, \
                                    1.5800000000000000e-10,  2.2100000000000001e-10,  3.0599999999999998e-10, \
                                    4.1700000000000001e-10,  5.6100000000000003e-10,  7.4700000000000001e-10, \
                                    9.8399999999999991e-10,  1.2830000000000000e-09,  1.6590000000000000e-09, \
                                    2.1250000000000000e-09,  2.7010000000000001e-09,  3.4079999999999998e-09, \
                                    4.2690000000000000e-09,  5.3110000000000004e-09,  6.5670000000000002e-09, \
                                    8.0709999999999999e-09,  9.8649999999999993e-09,  1.1992000000000001e-08, \
                                    1.4507000000000000e-08,  1.7459999999999999e-08,  2.0923999999999999e-08, \
                                    2.4960000000000000e-08,  2.9655000000000000e-08,  3.5089999999999999e-08, \
                                    4.1367000000000002e-08,  4.8581999999999998e-08,  5.6867999999999997e-08, \
                                    6.6329999999999999e-08,  7.7130000000000003e-08,  8.9402999999999997e-08, \
                                    1.0333300000000000e-07,  1.1907200000000000e-07,  1.3686000000000000e-07, \
                                    1.5685999999999999e-07,  1.7935000000000000e-07,  2.0453300000000000e-07, \
                                    2.3272899999999999e-07,  2.6416200000000001e-07,  2.9923000000000001e-07, \
                                    3.3816099999999998e-07,  3.8142399999999999e-07,  4.2930299999999999e-07, \
                                    4.8231299999999996e-07,  5.4075600000000003e-07,  6.0527900000000000e-07, \
                                    6.7618600000000002e-07,  7.5420599999999997e-07,  8.3970299999999996e-07, \
                                    9.3350099999999996e-07,  1.0359859999999999e-06,  1.1481370000000000e-06, \
                                    1.2703210000000001e-06,  1.4036669999999999e-06,  1.5486230000000001e-06, \
                                    1.7064110000000000e-06,  1.8774790000000001e-06,  2.0633140000000002e-06, \
                                    2.2643300000000001e-06,  2.4821730000000000e-06,  2.7173249999999999e-06, \
                                    2.9716280000000000e-06,  3.2455580000000000e-06,  3.5412430000000002e-06, \
                                    3.8590720000000001e-06,  4.2014699999999999e-06,  4.5689130000000001e-06, \
                                    4.9640019999999999e-06,  5.3871359999999998e-06,  5.8414160000000001e-06, \
                                    6.3271320000000000e-06,  6.8476500000000004e-06,  7.4032980000000003e-06, \
                                    7.9978270000000004e-06,  8.6314740000000008e-06,  9.3084709999999997e-06, \
                                    1.0028841000000000e-05,  1.0797356000000001e-05,  1.1614059000000001e-05, \
                                    1.2484058000000000e-05,  1.3407177000000000e-05,  1.4389355000000000e-05, \
                                    1.5430170000000001e-05,  1.6535993999999999e-05,  1.7706321000000001e-05, \
                                    1.8948260000000000e-05,  2.0261019000000000e-05,  2.1652459000000001e-05, \
                                    2.3121343999999999e-05,  2.4676462999999999e-05,  2.6316451000000000e-05, \
                                    2.8050691000000001e-05,  2.9877310000000000e-05,  3.1806993000000003e-05, \
                                    3.3837436000000001e-05,  3.5980019000000003e-05,  3.8232029000000002e-05, \
                                    4.0606189999999997e-05,  4.3099149999999999e-05,  4.5724705000000000e-05, \
                                    4.8478805999999997e-05,  5.1376725999999997e-05,  5.4413914000000003e-05, \
                                    5.7606687999999999e-05,  6.0949509999999997e-05,  6.4460699000000002e-05, \
                                    6.8133981000000003e-05,  7.1988725000000006e-05,  7.6017652999999994e-05, \
                                    8.0242460000000000e-05,  8.4654730999999999e-05,  8.9277540999999999e-05, \
                                    9.4101450999999999e-05,  9.9151783999999998e-05,  1.0441791800000000e-04, \
                                    1.0992707500000000e-04,  1.1566685400000000e-04,  1.2166728800000000e-04, \
                                    1.2791492600000001e-04,  1.3444134999999999e-04,  1.4123113900000000e-04, \
                                    1.4831970799999999e-04,  1.5568971100000001e-04,  1.6337816399999999e-04, \
                                    1.7136637599999999e-04,  1.7969484099999999e-04,  1.8834246599999999e-04, \
                                    1.9735285699999999e-04,  2.0670203100000000e-04,  2.1643736700000001e-04, \
                                    2.2653372000000000e-04,  2.3704051699999999e-04,  2.4792907600000000e-04, \
                                    2.5925489200000001e-04,  2.7098623500000001e-04,  2.8318048700000002e-04, \
                                    2.9580422999999999e-04,  3.0891981999999998e-04,  3.2248950600000001e-04, \
                                    3.3658070100000002e-04,  3.5115147600000001e-04,  3.6627384200000002e-04, \
                                    3.8190469700000000e-04,  3.9811874000000001e-04,  4.1486692699999999e-04, \
                                    4.3223355399999998e-04,  4.5016489600000002e-04,  4.6874695899999999e-04, \
                                    4.8792419500000002e-04,  5.0778963200000000e-04,  5.2828082199999997e-04, \
                                    5.4949841500000001e-04,  5.7137385399999997e-04,  5.9401319100000000e-04, \
                                    6.1734709100000004e-04,  6.4148535500000001e-04,  6.6634902700000000e-04, \
                                    6.9206231700000005e-04,  7.1853938700000000e-04,  7.4590547300000000e-04, \
                                    7.7407354899999999e-04,  8.0317828700000003e-04,  8.3312173700000002e-04, \
                                    8.6404990399999995e-04,  8.9585635399999999e-04,  9.2869344500000003e-04, \
                                    9.6245465800000004e-04,  9.9729720800000011e-04,  1.0330996540000000e-03, \
                                    1.0700401249999999e-03,  1.1079882760000001e-03,  1.1471215319999999e-03, \
                                    1.1873092049999999e-03,  1.2287412240000000e-03,  1.2712703960000001e-03, \
                                    1.3151039110000000e-03,  1.3600826000000001e-03,  1.4064202999999999e-03, \
                                    1.4539590949999999e-03,  1.5029189710000000e-03,  1.5531208110000001e-03, \
                                    1.6048138600000001e-03,  1.6578069960000001e-03,  1.7123458150000001e-03, \
                                    1.7682407700000001e-03,  1.8257546480000000e-03,  1.8846732400000000e-03, \
                                    1.9452837870000000e-03,  2.0073559760000002e-03,  2.0711834840000001e-03, \
                                    2.1365405580000001e-03,  2.2037282249999998e-03,  2.2724900979999999e-03, \
                                    2.3431674730000000e-03,  2.4154883239999999e-03,  2.4897870969999999e-03, \
                                    2.5657956560000000e-03,  2.6438706140000001e-03,  2.7237087420000001e-03, \
                                    2.8057005330000000e-03,  2.8895228040000001e-03,  2.9755707110000001e-03, \
                                    3.0635297830000001e-03,  3.1538038229999999e-03,  3.2460356040000002e-03, \
                                    3.3406848999999999e-03,  3.4373737330000002e-03,  3.5365490750000001e-03, \
                                    3.6378404369999998e-03,  3.7417232069999998e-03,  3.8477799350000001e-03, \
                                    3.9565313550000000e-03,  4.0675346549999998e-03,  4.1813119159999999e-03, \
                                    4.2974346440000002e-03,  4.4164371759999998e-03,  4.5378321599999997e-03, \
                                    4.6622280830000001e-03,  4.7891107550000001e-03,  4.9190679070000003e-03, \
                                    5.0516007150000000e-03,  5.1873313509999998e-03,  5.3256974230000004e-03, \
                                    5.4673809390000001e-03,  5.6117876120000002e-03,  5.7595985899999997e-03, \
                                    5.9102409920000001e-03,  6.0644102999999998e-03,  6.2214543670000002e-03, \
                                    6.3821657859999999e-03,  6.5458615940000003e-03,  6.7133015500000000e-03, \
                                    6.8838259640000002e-03,  7.0582367629999998e-03,  7.2357902860000003e-03, \
                                    7.4173688670000001e-03,  7.6021886749999996e-03,  7.7911248200000002e-03, \
                                    7.9834245920000005e-03,  8.1799798960000003e-03,  8.3799377569999996e-03, \
                                    8.5843129999999997e-03,  8.7922144159999997e-03,  9.0046089899999994e-03, \
                                    9.2206399299999998e-03,  9.4413289400000003e-03,  9.6657086489999999e-03, \
                                    9.8949041790000001e-03,  1.0127898052000000e-02,  1.0365799009000001e-02, \
                                    1.0607637677000001e-02,  1.0854540907999999e-02,  1.1105410632000001e-02, \
                                    1.1361527546000000e-02,  1.1621748006000000e-02,  1.1887289985999999e-02, \
                                    1.2157056544999999e-02,  1.2432331360000000e-02,  1.2711875540000001e-02, \
                                    1.2997102759000000e-02,  1.3286718949000000e-02,  1.3582108678999999e-02, \
                                    1.3882042225000000e-02,  1.4187922840999999e-02,  1.4498358495000000e-02, \
                                    1.4814949585999999e-02,  1.5136248004000000e-02,  1.5463768192000000e-02, \
                                    1.5796125271000001e-02,  1.6134910996999999e-02,  1.6478568240000002e-02, \
                                    1.6828848426999998e-02,  1.7184128577999998e-02,  1.7546113855999999e-02, \
                                    1.7913267128000000e-02,  1.8287320882000000e-02,  1.8666533512000000e-02, \
                                    1.9052877385000000e-02,  1.9444544421999999e-02,  1.9843393971999999e-02, \
                                    2.0247708483999999e-02,  2.0659435643000001e-02,  2.1076644495000001e-02, \
                                    2.1501476650999999e-02,  2.1931923932999999e-02,  2.2370069377999999e-02, \
                                    2.2814013572000000e-02,  2.3265868432999999e-02,  2.3723483151000001e-02, \
                                    2.4189260218999999e-02,  2.4660979212000000e-02,  2.5140892780999999e-02, \
                                    2.5626897962999998e-02,  2.6121348108000000e-02,  2.6621879806000000e-02, \
                                    2.7131088742999999e-02,  2.7646520438000002e-02,  2.8170688026999999e-02, \
                                    2.8701272162000000e-02,  2.9240817519000002e-02,  2.9786711225000002e-02, \
                                    3.0341842197000000e-02,  3.0903516830000002e-02,  3.1474433385999999e-02, \
                                    3.2052045394999999e-02,  3.2639175404000000e-02,  3.3232962116999998e-02, \
                                    3.3836515278000003e-02,  3.4446868098000002e-02,  3.5067018934000001e-02, \
                                    3.5694183273000002e-02,  3.6331388353000003e-02,  3.6975495929999998e-02, \
                                    3.7629938121000003e-02,  3.8291485797000001e-02,  3.8963346380999998e-02, \
                                    3.9642470248000002e-02,  4.0332205064000003e-02,  4.1029123854000003e-02, \
                                    4.1736911270000003e-02,  4.2452035148999999e-02,  4.3178032094000000e-02, \
                                    4.3911590564000000e-02,  4.4656273690999997e-02,  4.5408355513000001e-02, \
                                    4.6171883185999997e-02,  4.6943024223999999e-02,  4.7725549238999999e-02, \
                                    4.8515844079000003e-02,  4.9317835433000001e-02,  5.0127481137000003e-02, \
                                    5.0949096254000001e-02,  5.1778518996999999e-02,  5.2619874366999997e-02, \
                                    5.3469267132000002e-02,  5.4330863512999997e-02,  5.5200279938000002e-02, \
                                    5.6082240483000000e-02,  5.6972242499999999e-02,  5.7874672900000000e-02, \
                                    5.8785307951000003e-02,  5.9708704087999998e-02,  6.0640140086000001e-02, \
                                    6.1584615050999998e-02,  6.2537275542000004e-02,  6.3502904873000005e-02, \
                                    6.4476961666000004e-02,  6.5464265507999997e-02,  6.6459711325999996e-02, \
                                    6.7468754448000004e-02,  6.8486177888000002e-02,  6.9517031714000005e-02, \
                                    7.0556428296999998e-02,  7.1609598464000002e-02,  7.2671080011999997e-02, \
                                    7.3746630433000004e-02,  7.4830639719000003e-02,  7.5928597318000002e-02, \
                                    7.7035256664999996e-02,  7.8156142326000003e-02,  7.9285385242000003e-02, \
                                    8.0429220656000000e-02,  8.1581657766999993e-02,  8.2748451666000006e-02, \
                                    8.3923997893999999e-02,  8.5114269716999993e-02,  8.6313006272999995e-02, \
                                    8.7526767069999997e-02,  8.8749125664000006e-02,  8.9986322995000007e-02, \
                                    9.1232378729000002e-02,  9.2493557847000002e-02,  9.3763174256999995e-02, \
                                    9.5048288795000005e-02,  9.6342081782000002e-02,  9.7651077995999994e-02, \
                                    9.8968900225000003e-02,  1.0030230548900000e-01,  1.0164417507400000e-01, \
                                    1.0300191667600000e-01,  1.0436826477900001e-01,  1.0575024093900000e-01, \
                                    1.0714108598500000e-01,  1.0854783798700000e-01,  1.0996294688699999e-01, \
                                    1.1139435874200000e-01,  1.1283437583100001e-01,  1.1429032876100000e-01, \
                                    1.1575501989700000e-01,  1.1723602133900000e-01,  1.1872534068399999e-01, \
                                    1.2023126413500000e-01,  1.2174563936000000e-01,  1.2327629889000000e-01, \
                                    1.2481566539100000e-01,  1.2637160586200000e-01,  1.2793566011800001e-01, \
                                    1.2951669027900001e-01,  1.3110607820799999e-01,  1.3271198103300000e-01, \
                                    1.3432638085000001e-01,  1.3595768612199999e-01,  1.3759699221400001e-01, \
                                    1.3925347930599999e-01,  1.4091807873400000e-01,  1.4259948500500000e-01, \
                                    1.4428926519499999e-01,  1.4599613621900001e-01,  1.4771069440400000e-01, \
                                    1.4944273574000000e-01,  1.5118272361900001e-01,  1.5293965561199999e-01, \
                                    1.5470466235999999e-01,  1.5648699660199999e-01,  1.5827682028500001e-01, \
                                    1.6008425947499999e-01,  1.6189929566899999e-01,  1.6373149247300001e-01, \
                                    1.6557153957199999e-01,  1.6742900927500001e-01,  1.6929357224600000e-01, \
                                    1.7117595722800000e-01,  1.7306569765999999e-01,  1.7497262575899999e-01, \
                                    1.7688700678399999e-01,  1.7881897779700001e-01,  1.8075774623999999e-01, \
                                    1.8271438077300001e-01,  1.8467790164100001e-01,  1.8665874452100001e-01, \
                                    1.8864674440400001e-01,  1.9065232015700001e-01,  1.9266420881499999e-01, \
                                    1.9469406135100001e-01,  1.9673047149900000e-01,  1.9878414055700000e-01, \
                                    2.0084446725399999e-01,  2.0292245416599999e-01,  2.0500635301600001e-01, \
                                    2.0710815611100000e-01,  2.0921596977900001e-01,  2.1134107407700001e-01, \
                                    2.1347245704100001e-01,  2.1562136471400001e-01,  2.1777560441100000e-01, \
                                    2.1994776911500000e-01,  2.2212552021500001e-01,  2.2432040482599999e-01, \
                                    2.2652095154400001e-01,  2.2873900841100001e-01,  2.3096193598500001e-01, \
                                    2.3320261027500000e-01,  2.3544823876200000e-01,  2.3771091120099999e-01, \
                                    2.3997878928999999e-01,  2.4226395215200000e-01,  2.4455330210400000e-01, \
                                    2.4686033334400001e-01,  2.4917179299700001e-01,  2.5150003225200002e-01, \
                                    2.5383278898200001e-01,  2.5618270633000001e-01,  2.5853627858299999e-01, \
                                    2.6090722011400003e-01,  2.6328187736999997e-01,  2.6567314943300002e-01, \
                                    2.6806839092200002e-01,  2.7048046808999998e-01,  2.7289541383299998e-01, \
                                    2.7532756059699998e-01,  2.7776284136599999e-01,  2.8021435419500001e-01, \
                                    2.8266908180400002e-01,  2.8514039755199999e-01,  2.8761398134999999e-01, \
                                    2.9010436613200002e-01,  2.9259708198000001e-01,  2.9510577423099998e-01, \
                                    2.9761704465700001e-01,  3.0014447221200002e-01,  3.0267332793800000e-01, \
                                    3.0521870786900002e-01,  3.0776578458900000e-01,  3.1032832500000002e-01, \
                                    3.1289261342500002e-01,  3.1547274049899998e-01,  3.1805362696599998e-01, \
                                    3.2065053951400002e-01,  3.2324825621499997e-01,  3.2586108542400000e-01, \
                                    3.2847499247700002e-01,  3.3110418609600001e-01,  3.3373325683799998e-01, \
                                    3.3637795512500002e-01,  3.3902277082799998e-01,  3.4168211100700002e-01, \
                                    3.4434162879399999e-01,  3.4701603215400001e-01,  3.4968956369300003e-01, \
                                    3.5237813116000000e-01,  3.5506589733100002e-01,  3.5776773335000001e-01, \
                                    3.6046904295600002e-01,  3.6318456416500000e-01,  3.6589828773400002e-01, \
                                    3.6862657715800001e-01,  3.7135333088000000e-01,  3.7409348273900001e-01, \
                                    3.7683214073200000e-01,  3.7958452307099999e-01,  3.8233435456100001e-01, \
                                    3.8509805071499997e-01,  3.8785926430700002e-01,  3.9063332026399999e-01, \
                                    3.9340514762500001e-01,  3.9618996009000002e-01,  3.9897124957800001e-01, \
                                    4.0176586866899999e-01,  4.0455721906499997e-01,  4.0736065343500000e-01, \
                                    4.1016089521600002e-01,  4.1297354578700002e-01,  4.1578191503700002e-01, \
                                    4.1860280056600002e-01,  4.2141945376800000e-01,  4.2424758350399999e-01, \
                                    4.2707175534899999e-01,  4.2990753741499999e-01,  4.3273803131900002e-01, \
                                    4.3558043175099997e-01,  4.3841783090899999e-01,  4.4126586582400001e-01, \
                                    4.4410897961200002e-01,  4.4696302780899999e-01,  4.4981103108199999e-01, \
                                    4.5267008889999999e-01,  4.5552316467999998e-01,  4.5838622381200000e-01, \
                                    4.6124356929700000e-01,  4.6411098449299998e-01,  4.6697137653900000e-01, \
                                    4.6984214319399997e-01,  4.7270618232599998e-01,  4.7557927403799999e-01, \
                                    4.7844570098299999e-01,  4.8132149768900001e-01,  4.8418951498000001e-01, \
                                    4.8706700495700000e-01,  4.8993678029799997e-01,  4.9281491075500000e-01, \
                                    4.9568562562300000e-01,  4.9856478242100000e-01,  5.0143521757900000e-01, \
                                    5.0431437437700000e-01,  5.0718508924500005e-01,  5.1006321970199997e-01, \
                                    5.1293299504300005e-01,  5.1581048502000004e-01,  5.1867850231099999e-01, \
                                    5.2155429901700001e-01,  5.2442072596199996e-01,  5.2729381767399996e-01, \
                                    5.3015785680600003e-01,  5.3302862346100000e-01,  5.3588901550699997e-01, \
                                    5.3875643070300006e-01,  5.4161377618800000e-01,  5.4447683532000002e-01, \
                                    5.4732991109999996e-01,  5.5018896891799995e-01,  5.5303697219100001e-01, \
                                    5.5589102038799998e-01,  5.5873413417600004e-01,  5.6158216909100001e-01, \
                                    5.6441956824899997e-01,  5.6726196868099998e-01,  5.7009246258500001e-01, \
                                    5.7292824465100001e-01,  5.7575241649599995e-01,  5.7858054623199995e-01, \
                                    5.8139719943400003e-01,  5.8421808496299998e-01,  5.8702645421300004e-01, \
                                    5.8983910478400003e-01,  5.9263934656499995e-01,  5.9544278093500003e-01, \
                                    5.9823413133100001e-01,  6.0102875042199999e-01,  6.0381003991000004e-01, \
                                    6.0659485237499999e-01,  6.0936667973600001e-01,  6.1214073569299998e-01, \
                                    6.1490194928499997e-01,  6.1766564543900004e-01,  6.2041547692900001e-01, \
                                    6.2316785926800000e-01,  6.2590651726099999e-01,  6.2864666912000000e-01, \
                                    6.3137342284200004e-01,  6.3410171226599998e-01,  6.3681543583500000e-01, \
                                    6.3953095704399998e-01,  6.4223226664999999e-01,  6.4493410266899998e-01, \
                                    6.4762186883999995e-01,  6.5031043630700003e-01,  6.5298396784599999e-01, \
                                    6.5565837120600001e-01,  6.5831788899300003e-01,  6.6097722917199997e-01, \
                                    6.6362204487499998e-01,  6.6626674316199996e-01,  6.6889581390399999e-01, \
                                    6.7152500752300004e-01,  6.7413891457599995e-01,  6.7675174378500003e-01, \
                                    6.7934946048599998e-01,  6.8194637303399996e-01,  6.8452725950100002e-01, \
                                    6.8710738657500003e-01,  6.8967167500000004e-01,  6.9223421541100005e-01, \
                                    6.9478129213100004e-01,  6.9732667206200005e-01,  6.9985552778799998e-01, \
                                    7.0238295534299999e-01,  7.0489422576899996e-01,  7.0740291801999999e-01, \
                                    7.0989563386800003e-01,  7.1238601864999995e-01,  7.1485960244799995e-01, \
                                    7.1733091819600003e-01,  7.1978564580500004e-01,  7.2223715863399995e-01, \
                                    7.2467243940299997e-01,  7.2710458616700002e-01,  7.2951953190999996e-01, \
                                    7.3193160907800003e-01,  7.3432685056699998e-01,  7.3671812263000003e-01, \
                                    7.3909277988599997e-01,  7.4146372141700001e-01,  7.4381729367000005e-01, \
                                    7.4616721101799999e-01,  7.4849996774799998e-01,  7.5082820700300001e-01, \
                                    7.5313966665599996e-01,  7.5544669789600005e-01,  7.5773604784799997e-01, \
                                    7.6002121070999995e-01,  7.6228908879900004e-01,  7.6455176123799995e-01, \
                                    7.6679738972500000e-01,  7.6903806401499997e-01,  7.7126099158899997e-01, \
                                    7.7347904845600002e-01,  7.7567959517399998e-01,  7.7787447978500002e-01, \
                                    7.8005223088499998e-01,  7.8222439558900003e-01,  7.8437863528600005e-01, \
                                    7.8652754295899996e-01,  7.8865892592300002e-01,  7.9078403022099997e-01, \
                                    7.9289184388900003e-01,  7.9499364698399999e-01,  7.9707754583400003e-01, \
                                    7.9915553274600004e-01,  8.0121585944300000e-01,  8.0326952850099997e-01, \
                                    8.0530593864900002e-01,  8.0733579118499998e-01,  8.0934767984300005e-01, \
                                    8.1135325559600002e-01,  8.1334125547900005e-01,  8.1532209835900005e-01, \
                                    8.1728561922700005e-01,  8.1924225376000004e-01,  8.2118102220300004e-01, \
                                    8.2311299321599996e-01,  8.2502737424100003e-01,  8.2693430233999998e-01, \
                                    8.2882404277199995e-01,  8.3070642775400005e-01,  8.3257099072499996e-01, \
                                    8.3442846042800001e-01,  8.3626850752699999e-01,  8.3810070433100003e-01, \
                                    8.3991574052499995e-01,  8.4172317971499999e-01,  8.4351300339799995e-01, \
                                    8.4529533763999998e-01,  8.4706034438800004e-01,  8.4881727638100002e-01, \
                                    8.5055726426000000e-01,  8.5228930559600002e-01,  8.5400386378100002e-01, \
                                    8.5571073480500004e-01,  8.5740051499500003e-01,  8.5908192126600003e-01, \
                                    8.6074652069400004e-01,  8.6240300778599999e-01,  8.6404231387800001e-01, \
                                    8.6567361914999996e-01,  8.6728801896700003e-01,  8.6889392179199998e-01, \
                                    8.7048330972099996e-01,  8.7206433988200005e-01,  8.7362839413799998e-01, \
                                    8.7518433460900003e-01,  8.7672370110999998e-01,  8.7825436063999995e-01, \
                                    8.7976873586500004e-01,  8.8127465931600002e-01,  8.8276397866099998e-01, \
                                    8.8424498010300001e-01,  8.8570967123900002e-01,  8.8716562416900002e-01, \
                                    8.8860564125800001e-01,  8.9003705311299997e-01,  8.9145216201300004e-01, \
                                    8.9285891401499995e-01,  8.9424975906100002e-01,  8.9563173522100004e-01, \
                                    8.9699808332400000e-01,  8.9835582492599997e-01,  8.9969769451100001e-01, \
                                    9.0103109977499996e-01,  9.0234892200399996e-01,  9.0365791821800001e-01, \
                                    9.0495171120499995e-01,  9.0623682574300002e-01,  9.0750644215300003e-01, \
                                    9.0876762127099997e-01,  9.1001367700500002e-01,  9.1125087433600005e-01, \
                                    9.1247323293000004e-01,  9.1368699372700002e-01,  9.1488573028300002e-01, \
                                    9.1607600210600004e-01,  9.1725154833400002e-01,  9.1841834223300001e-01, \
                                    9.1957077934400000e-01,  9.2071461475799998e-01,  9.2184385767400001e-01, \
                                    9.2296474333500000e-01,  9.2407140268200005e-01,  9.2516936028100005e-01, \
                                    9.2625336956700000e-01,  9.2732891998800004e-01,  9.2839040153600005e-01, \
                                    9.2944357170299996e-01,  9.3048296828599997e-01,  9.3151382211199996e-01, \
                                    9.3253124555199995e-01,  9.3354028867399996e-01,  9.3453573449200000e-01, \
                                    9.3552303833399997e-01,  9.3649709512699997e-01,  9.3746272445800005e-01, \
                                    9.3841538494900001e-01,  9.3935985991399995e-01,  9.4029129591200000e-01, \
                                    9.4121469204899999e-01,  9.4212532709999997e-01,  9.4302775750000001e-01, \
                                    9.4391775951699997e-01,  9.4479972006199997e-01,  9.4566913648700002e-01, \
                                    9.4653073286800005e-01,  9.4738012563300000e-01,  9.4822148100299997e-01, \
                                    9.4905090374599999e-01,  9.4987251886299995e-01,  9.5068216456700005e-01, \
                                    9.5148415592100000e-01,  9.5227445076100004e-01,  9.5305697577600001e-01, \
                                    9.5382811681400004e-01,  9.5459164448699996e-01,  9.5534372630900000e-01, \
                                    9.5608840943600004e-01,  9.5682196790600005e-01,  9.5754796485100002e-01, \
                                    9.5826308872999999e-01,  9.5897087614599996e-01,  9.5966779493599996e-01, \
                                    9.6035752975199995e-01,  9.6103665361900004e-01,  9.6170851420299996e-01, \
                                    9.6237006187899998e-01,  9.6302450406999995e-01,  9.6366861164700002e-01, \
                                    9.6430581672700000e-01,  9.6493298106600001e-01,  9.6555313190199998e-01, \
                                    9.6616348472199998e-01,  9.6676703788300000e-01,  9.6736082459600004e-01, \
                                    9.6794795460500005e-01,  9.6852556661400002e-01,  9.6909648316999997e-01, \
                                    9.6965815780300002e-01,  9.7021328877500002e-01,  9.7075918248100002e-01, \
                                    9.7129872783799998e-01,  9.7182931197300004e-01,  9.7235347956200002e-01, \
                                    9.7286891125700004e-01,  9.7337812019400005e-01,  9.7387865189199996e-01, \
                                    9.7437310203700001e-01,  9.7485910721900004e-01,  9.7533902078800006e-01, \
                                    9.7581073978099997e-01,  9.7627651684899996e-01,  9.7673413156699995e-01, \
                                    9.7718598642800003e-01,  9.7762993062199999e-01,  9.7806807606699997e-01, \
                                    9.7849852334900000e-01,  9.7892335550499998e-01,  9.7934056435700001e-01, \
                                    9.7975229151599996e-01,  9.8015660602800003e-01,  9.8055545557799995e-01, \
                                    9.8094712261499994e-01,  9.8133346648800002e-01,  9.8171267911799998e-01, \
                                    9.8208673287199999e-01,  9.8245388614399998e-01,  9.8281587142200000e-01, \
                                    9.8317115157299995e-01,  9.8352143175999995e-01,  9.8386508900299996e-01, \
                                    9.8420387472899995e-01,  9.8453623180799998e-01,  9.8486375199599996e-01, \
                                    9.8518505041399995e-01,  9.8550164150499997e-01,  9.8581207715899999e-01, \
                                    9.8611795777500000e-01,  9.8641789132100000e-01,  9.8671328105099998e-01, \
                                    9.8700289724099999e-01,  9.8728812446000003e-01,  9.8756766864000001e-01, \
                                    9.8784294345500001e-01,  9.8811271001400003e-01,  9.8837825199399998e-01, \
                                    9.8863847245400005e-01,  9.8889458936800001e-01,  9.8914545909200002e-01, \
                                    9.8939236232299999e-01,  9.8963420099099997e-01,  9.8987210194800002e-01, \
                                    9.9010509582100004e-01,  9.9033429135100004e-01,  9.9055867105999995e-01, \
                                    9.9077936007000000e-01,  9.9099539101000000e-01,  9.9120778558400002e-01, \
                                    9.9141568700000005e-01,  9.9162006224300003e-01,  9.9182002010400006e-01, \
                                    9.9201657540800003e-01,  9.9220887518000001e-01,  9.9239781132500005e-01, \
                                    9.9258263113300005e-01,  9.9276420971400003e-01,  9.9294176323700001e-01, \
                                    9.9311617403600005e-01,  9.9328669844999995e-01,  9.9345413840600005e-01, \
                                    9.9361783421399996e-01,  9.9377854563300005e-01,  9.9393558969999996e-01, \
                                    9.9408975900800001e-01,  9.9424040141000003e-01,  9.9438821238800001e-01, \
                                    9.9453261906099999e-01,  9.9467430257699996e-01,  9.9481266864899998e-01, \
                                    9.9494839928500001e-01,  9.9508093209299997e-01,  9.9521088924500001e-01, \
                                    9.9533777191700001e-01,  9.9546216783999997e-01,  9.9558356282399996e-01, \
                                    9.9570256535599999e-01,  9.9581868808399998e-01,  9.9593246534500002e-01, \
                                    9.9604346864500004e-01,  9.9615222006500004e-01,  9.9625827679300005e-01, \
                                    9.9636215956300000e-01,  9.9646345092499999e-01,  9.9656262626699998e-01, \
                                    9.9665931510000005e-01,  9.9675396439599995e-01,  9.9684619617699999e-01, \
                                    9.9693647021700005e-01,  9.9702442928900004e-01,  9.9711047719599999e-01, \
                                    9.9719429946700000e-01,  9.9727629125799999e-01,  9.9735612938600005e-01, \
                                    9.9743420434399999e-01,  9.9751021290300002e-01,  9.9758451167600004e-01, \
                                    9.9765683252699999e-01,  9.9772750990199999e-01,  9.9779627177499997e-01, \
                                    9.9786345944199994e-01,  9.9792881651599996e-01,  9.9799264402400001e-01, \
                                    9.9805471621300001e-01,  9.9811532676000003e-01,  9.9817424535199994e-01, \
                                    9.9823175922999996e-01,  9.9828765418499998e-01,  9.9834219300399996e-01, \
                                    9.9839518614000000e-01,  9.9844687918899999e-01,  9.9849708102900003e-01, \
                                    9.9854604090499999e-01,  9.9859357969999996e-01,  9.9863991740000002e-01, \
                                    9.9868489608900002e-01,  9.9872872960400005e-01,  9.9877125877600004e-01, \
                                    9.9881269079500001e-01,  9.9885287846799997e-01,  9.9889201172400000e-01, \
                                    9.9892995987500000e-01,  9.9896690034600000e-01,  9.9900270279199999e-01, \
                                    9.9903754534199996e-01,  9.9907130655499998e-01,  9.9910414364599998e-01, \
                                    9.9913595009599998e-01,  9.9916687826299999e-01,  9.9919682171299995e-01, \
                                    9.9922592645099995e-01,  9.9925409452699998e-01,  9.9928146061300005e-01, \
                                    9.9930793768299997e-01,  9.9933365097299998e-01,  9.9935851464500003e-01, \
                                    9.9938265290899997e-01,  9.9940598680899995e-01,  9.9942862614600003e-01, \
                                    9.9945050158500004e-01,  9.9947171917800004e-01,  9.9949221036799996e-01, \
                                    9.9951207580500001e-01,  9.9953125304099999e-01,  9.9954983510399997e-01, \
                                    9.9956776644599998e-01,  9.9958513307300001e-01,  9.9960188126000005e-01, \
                                    9.9961809530300005e-01,  9.9963372615799995e-01,  9.9964884852400004e-01, \
                                    9.9966341929900004e-01,  9.9967751049400000e-01,  9.9969108017999997e-01, \
                                    9.9970419577000003e-01,  9.9971681951299995e-01,  9.9972901376500001e-01, \
                                    9.9974074510800004e-01,  9.9975207092399998e-01,  9.9976295948299998e-01, \
                                    9.9977346627999997e-01,  9.9978356263299994e-01,  9.9979329796899996e-01, \
                                    9.9980264714300005e-01,  9.9981165753400003e-01,  9.9982030515900000e-01, \
                                    9.9982863362399998e-01,  9.9983662183599997e-01,  9.9984431028900000e-01, \
                                    9.9985168029200000e-01,  9.9985876886100000e-01,  9.9986555865000004e-01, \
                                    9.9987208507400005e-01,  9.9987833271200000e-01,  9.9988433314600000e-01, \
                                    9.9989007292499998e-01,  9.9989558208200002e-01,  9.9990084821600000e-01, \
                                    9.9990589854900003e-01,  9.9991072245900003e-01,  9.9991534526900006e-01, \
                                    9.9991975753999995e-01,  9.9992398234699997e-01,  9.9992801127499997e-01, \
                                    9.9993186601899997e-01,  9.9993553930099999e-01,  9.9993905048999998e-01, \
                                    9.9994239331199997e-01,  9.9994558608600004e-01,  9.9994862327400003e-01, \
                                    9.9995152119399999e-01,  9.9995427529500003e-01,  9.9995690085000000e-01, \
                                    9.9995939380999999e-01,  9.9996176797100000e-01,  9.9996401998100004e-01, \
                                    9.9996616256399995e-01,  9.9996819300700002e-01,  9.9997012268999996e-01, \
                                    9.9997194930900002e-01,  9.9997368354899996e-01,  9.9997532353700003e-01, \
                                    9.9997687865600005e-01,  9.9997834754100001e-01,  9.9997973898100001e-01, \
                                    9.9998105173999996e-01,  9.9998229367900004e-01,  9.9998346400600002e-01, \
                                    9.9998456982999995e-01,  9.9998561064500002e-01,  9.9998659282299995e-01, \
                                    9.9998751594199997e-01,  9.9998838594100004e-01,  9.9998920264400004e-01, \
                                    9.9998997115900001e-01,  9.9999069152900000e-01,  9.9999136852600001e-01, \
                                    9.9999200217299999e-01,  9.9999259670200003e-01,  9.9999315234999997e-01, \
                                    9.9999367286800001e-01,  9.9999415858399998e-01,  9.9999461286400004e-01, \
                                    9.9999503599799999e-01,  9.9999543108699995e-01,  9.9999579852999998e-01, \
                                    9.9999614092800004e-01,  9.9999645875700005e-01,  9.9999675444199998e-01, \
                                    9.9999702837200000e-01,  9.9999728267499999e-01,  9.9999751782699997e-01, \
                                    9.9999773567000005e-01,  9.9999793668600001e-01,  9.9999812252099995e-01, \
                                    9.9999829358900005e-01,  9.9999845137700005e-01,  9.9999859633300003e-01, \
                                    9.9999872967900005e-01,  9.9999885186299997e-01,  9.9999896401400001e-01, \
                                    9.9999906649900006e-01,  9.9999916029699998e-01,  9.9999924579400001e-01, \
                                    9.9999932381400003e-01,  9.9999939472099997e-01,  9.9999945924400002e-01, \
                                    9.9999951768700002e-01,  9.9999957069699996e-01,  9.9999961857599995e-01, \
                                    9.9999966183900002e-01,  9.9999970077000000e-01,  9.9999973583799995e-01, \
                                    9.9999976727100004e-01,  9.9999979546700002e-01,  9.9999982065000004e-01, \
                                    9.9999984314000001e-01,  9.9999986314000000e-01,  9.9999988092799996e-01, \
                                    9.9999989666699995e-01,  9.9999991059700000e-01,  9.9999992286999995e-01, \
                                    9.9999993366999995e-01,  9.9999994313200002e-01,  9.9999995141800002e-01, \
                                    9.9999995863299995e-01,  9.9999996490999998e-01,  9.9999997034499999e-01, \
                                    9.9999997504000004e-01,  9.9999997907600002e-01,  9.9999998254000000e-01, \
                                    9.9999998549299995e-01,  9.9999998800800005e-01,  9.9999999013499996e-01, \
                                    9.9999999192900002e-01,  9.9999999343299995e-01,  9.9999999468900003e-01, \
                                    9.9999999573099996e-01,  9.9999999659200001e-01,  9.9999999729900002e-01, \
                                    9.9999999787500005e-01,  9.9999999834099995e-01,  9.9999999871699996e-01, \
                                    9.9999999901600001e-01,  9.9999999925299998e-01,  9.9999999943899998e-01, \
                                    9.9999999958300001e-01,  9.9999999969400000e-01,  9.9999999977900000e-01, \
                                    9.9999999984200005e-01,  9.9999999988900001e-01,  9.9999999992400002e-01, \
                                    9.9999999994800004e-01,  9.9999999996599997e-01,  9.9999999997800004e-01, \
                                    9.9999999998599998e-01,  9.9999999999199995e-01,  9.9999999999500000e-01, \
                                    9.9999999999699996e-01,  9.9999999999800004e-01,  9.9999999999900002e-01, \
                                    1.0000000000000000e+00,  1.0000000000000000e+00,  1.0000000000000000e+00, \
                                    1.0000000000000000e+00,  1.0000000000000000e+00,  1.0000000000000000e+00, \
                                    1.0000000000000000e+00,  1.0000000000000000e+00,  1.0000000000000000e+00, \
                                    0.0000000000000000e+00,  0.0000000000000000e+00,  0.0000000000000000e+00, \
                                    0.0000000000000000e+00,  0.0000000000000000e+00,  0.0000000000000000e+00, \
                                    0.0000000000000000e+00,  0.0000000000000000e+00,  0.0000000000000000e+00, \
                                    0.0000000000000000e+00,  0.0000000000000000e+00,  0.0000000000000000e+00, \
                                    9.9999999999999998e-13,  9.9999999999999998e-13,  2.0000000000000000e-12, \
                                    3.0000000000000001e-12,  4.9999999999999997e-12,  7.0000000000000001e-12, \
                                    9.9999999999999994e-12,  1.5000000000000000e-11,  2.0999999999999999e-11, \
                                    3.0000000000000000e-11,  4.1000000000000001e-11,  5.6000000000000000e-11, \
                                    7.5999999999999996e-11,  1.0200000000000000e-10,  1.3500000000000000e-10, \
                                    1.7700000000000001e-10,  2.2900000000000001e-10,  2.9500000000000002e-10, \
                                    3.7699999999999999e-10,  4.7900000000000000e-10,  6.0299999999999999e-10, \
                                    7.5399999999999998e-10,  9.3699999999999997e-10,  1.1590000000000000e-09, \
                                    1.4240000000000000e-09,  1.7410000000000001e-09,  2.1179999999999999e-09, \
                                    2.5639999999999998e-09,  3.0899999999999999e-09,  3.7070000000000001e-09, \
                                    4.4290000000000003e-09,  5.2709999999999997e-09,  6.2479999999999999e-09, \
                                    7.3799999999999997e-09,  8.6860000000000008e-09,  1.0188999999999999e-08, \
                                    1.1913000000000001e-08,  1.3887000000000001e-08,  1.6136000000000000e-08, \
                                    1.8699999999999999e-08,  2.1607000000000000e-08,  2.4902000000000000e-08, \
                                    2.8622000000000000e-08,  3.2819999999999999e-08,  3.7537000000000001e-08, \
                                    4.2839999999999998e-08,  4.8772000000000002e-08,  5.5414000000000002e-08, \
                                    6.2818000000000000e-08,  7.1077999999999996e-08,  8.0249000000000006e-08, \
                                    9.0446000000000001e-08,  1.0173000000000000e-07,  1.1423400000000000e-07, \
                                    1.2802799999999999e-07,  1.4326600000000001e-07,  1.6002500000000001e-07, \
                                    1.7848600000000000e-07,  1.9873000000000001e-07,  2.2096700000000000e-07, \
                                    2.4528999999999999e-07,  2.7193799999999998e-07,  3.0100499999999999e-07, \
                                    3.3277700000000002e-07,  3.6735200000000002e-07,  4.0504799999999999e-07, \
                                    4.4597800000000002e-07,  4.9050699999999999e-07,  5.3874500000000000e-07, \
                                    5.9111800000000001e-07,  6.4773199999999999e-07,  7.0907000000000004e-07, \
                                    7.7525199999999996e-07,  8.4681600000000000e-07,  9.2387500000000001e-07, \
                                    1.0070569999999999e-06,  1.0964640000000001e-06,  1.1927970000000000e-06, \
                                    1.2961640000000000e-06,  1.4073520000000000e-06,  1.5264530000000001e-06, \
                                    1.6543669999999999e-06,  1.7911610000000001e-06,  1.9378439999999998e-06, \
                                    2.0944819999999999e-06,  2.2621910000000001e-06,  2.4410020000000001e-06, \
                                    2.6321930000000000e-06,  2.8357569999999999e-06,  3.0531000000000000e-06, \
                                    3.2841980000000002e-06,  3.5306190000000000e-06,  3.7922820000000000e-06, \
                                    4.0709530000000003e-06,  4.3664759999999998e-06,  4.6808119999999996e-06, \
                                    5.0137720000000002e-06,  5.3675050000000002e-06,  5.7417329999999999e-06, \
                                    6.1388760000000000e-06,  6.5585540000000002e-06,  7.0034230000000002e-06, \
                                    7.4730240000000001e-06,  7.9702879999999994e-06,  8.4946339999999996e-06, \
                                    9.0493029999999998e-06,  9.6335640000000002e-06,  1.0250997000000001e-05, \
                                    1.0900751000000000e-05,  1.1586716000000001e-05,  1.2307868000000000e-05, \
                                    1.3068531000000000e-05,  1.3867464000000000e-05,  1.4709397000000000e-05, \
                                    1.5592885999999999e-05,  1.6523105000000001e-05,  1.7498393999999999e-05, \
                                    1.8524401000000001e-05,  1.9599170000000002e-05,  2.0728914999999998e-05, \
                                    2.1911396000000001e-05,  2.3153336999999999e-05,  2.4452198000000001e-05, \
                                    2.5815346999999999e-05,  2.7239838000000000e-05,  2.8733711999999998e-05, \
                                    3.0293618000000000e-05,  3.1928285000000003e-05,  3.3634009000000001e-05, \
                                    3.5420192000000002e-05,  3.7282603000000003e-05,  3.9231591999999997e-05, \
                                    4.1262364999999997e-05,  4.3386046000000000e-05,  4.5597362000000001e-05, \
                                    4.7908346999999999e-05,  5.0313077999999998e-05,  5.2824653999999997e-05, \
                                    5.5436399000000001e-05,  5.8162440000000000e-05,  6.0995551000000002e-05, \
                                    6.3950826999999998e-05,  6.7020177999999999e-05,  7.0220173999999998e-05, \
                                    7.3541706000000004e-05,  7.7002489000000003e-05,  8.0592770000000003e-05, \
                                    8.4331479999999996e-05,  8.8207824000000005e-05,  9.2242380999999998e-05, \
                                    9.6423043999999995e-05,  1.0077194900000000