/*###############################################################################
# Linux Management Providers (LMP), Boot provider package
# Copyright (C) 2009 Nodir Nazarov <nazarov.nodir@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_BOOTCONCRETEDEPENDENCYACCESS_H_
#define OPENDRIM_BOOTCONCRETEDEPENDENCYACCESS_H_

#include "Boot_Common.h"

#include "OpenDRIM_BootConcreteDependency.h"
#include "assocOpenDRIM_BootConcreteDependency.h"

int Boot_OpenDRIM_BootConcreteDependency_load(const CMPIBroker* broker, string& errorMessage);

int Boot_OpenDRIM_BootConcreteDependency_unload(string& errorMessage);

int Boot_OpenDRIM_BootConcreteDependency_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_BootConcreteDependency>& instances, const char** properties, string& errorMessage, const string& discriminant);

int Boot_OpenDRIM_BootConcreteDependency_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_BootConcreteDependency& instance, const char** properties, string& errorMessage);

int Boot_OpenDRIM_BootConcreteDependency_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BootConcreteDependency& newInstance, const OpenDRIM_BootConcreteDependency& oldInstance, const char** properties, string& errorMessage);

int Boot_OpenDRIM_BootConcreteDependency_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BootConcreteDependency& instance, string& errorMessage);

int Boot_OpenDRIM_BootConcreteDependency_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BootConcreteDependency& instance, string& errorMessage);

int Boot_OpenDRIM_BootConcreteDependency_associatorAntecedentToDependent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Antecedent_instance, const char** properties, vector<Instance>& Dependent_associatedInstances, string& errorMessage, const string& discriminant);

int Boot_OpenDRIM_BootConcreteDependency_associatorDependentToAntecedent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Dependent_instance, const char** properties, vector<Instance>& Antecedent_associatedInstances, string& errorMessage, const string& discriminant);

int Boot_OpenDRIM_BootConcreteDependency_referenceAntecedentToDependent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Antecedent_instance, const vector<Instance>& Dependent_instances, vector<OpenDRIM_BootConcreteDependency>& OpenDRIM_BootConcreteDependency_instances, const char** properties, string& errorMessage, const string& discriminant);

int Boot_OpenDRIM_BootConcreteDependency_referenceDependentToAntecedent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Dependent_instance, const vector<Instance>& Antecedent_instances, vector<OpenDRIM_BootConcreteDependency>& OpenDRIM_BootConcreteDependency_instances, const char** properties, string& errorMessage, const string& discriminant);

int Boot_OpenDRIM_BootConcreteDependency_populate(OpenDRIM_BootConcreteDependency& instance, string& errorMessage);

#endif /*OPENDRIM_BOOTCONCRETEDEPENDENCYACCESS_H_*/
