/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.mimetype.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class CharSetMap {
    public static final String DEFAULT_CHARSET = "ISO-8859-1";
    public static final String CHARSET_RESOURCE = "charset.properties";
    private static final int MAP_CACHE = 0;
    private static final int MAP_PROG = 1;
    private static final int MAP_HOME = 2;
    private static final int MAP_SYS = 3;
    private static final int MAP_JAR = 4;
    private static final int MAP_COM = 5;
    private static HashMap commonMapper = new HashMap();
    private Map[] mappers = new Map[6];
    private static /* synthetic */ Class class$Lorg$apache$turbine$services$mimetype$util$CharSetMap;

    protected static Map loadStream(InputStream input) throws IOException {
        Properties props = new Properties();
        props.load(input);
        return new HashMap<Object, Object>(props);
    }

    protected static Map loadFile(File file) throws IOException {
        return CharSetMap.loadStream(new FileInputStream(file));
    }

    protected static Map loadPath(String path) throws IOException {
        return CharSetMap.loadFile(new File(path));
    }

    protected static Map loadResource(String name) {
        InputStream input = (class$Lorg$apache$turbine$services$mimetype$util$CharSetMap != null ? class$Lorg$apache$turbine$services$mimetype$util$CharSetMap : (class$Lorg$apache$turbine$services$mimetype$util$CharSetMap = CharSetMap.class$("org.apache.turbine.services.mimetype.util.CharSetMap"))).getResourceAsStream(name);
        if (input != null) {
            try {
                return CharSetMap.loadStream(input);
            }
            catch (IOException x) {
                return null;
            }
        }
        return null;
    }

    public synchronized void setCharSet(String key, String charset) {
        HashMap<String, String> mapper = (HashMap<String, String>)this.mappers[1];
        mapper = mapper != null ? (HashMap)mapper.clone() : new HashMap<String, String>();
        mapper.put(key, charset);
        this.mappers[1] = mapper;
        this.mappers[0].clear();
    }

    public String getCharSet(Locale locale) {
        String key = locale.toString();
        if (key.length() == 0 && (key = "__" + locale.getVariant()).length() == 2) {
            return DEFAULT_CHARSET;
        }
        String charset = this.searchCharSet(key);
        if (charset.length() == 0) {
            String[] items = new String[3];
            items[2] = locale.getVariant();
            items[1] = locale.getCountry();
            items[0] = locale.getLanguage();
            charset = this.searchCharSet(items);
            if (charset.length() == 0) {
                charset = DEFAULT_CHARSET;
            }
            this.mappers[0].put(key, charset);
        }
        return charset;
    }

    public String getCharSet(Locale locale, String variant) {
        if (variant != null && variant.length() > 0) {
            String key = locale.toString();
            key = key.length() == 0 ? ((key = "__" + locale.getVariant()).length() > 2 ? key + "_" + variant : key + variant) : (locale.getCountry().length() == 0 ? key + "__" + variant : key + "_" + variant);
            String charset = this.searchCharSet(key);
            if (charset.length() == 0) {
                String[] items = new String[4];
                items[3] = variant;
                items[2] = locale.getVariant();
                items[1] = locale.getCountry();
                items[0] = locale.getLanguage();
                charset = this.searchCharSet(items);
                if (charset.length() == 0) {
                    charset = DEFAULT_CHARSET;
                }
                this.mappers[0].put(key, charset);
            }
            return charset;
        }
        return this.getCharSet(locale);
    }

    public String getCharSet(String key) {
        String charset = this.searchCharSet(key);
        return charset.length() > 0 ? charset : DEFAULT_CHARSET;
    }

    public String getCharSet(String key, String def) {
        String charset = this.searchCharSet(key);
        return charset.length() > 0 ? charset : def;
    }

    private String searchCharSet(String[] items) {
        StringBuffer sb = new StringBuffer();
        int i = items.length;
        while (i > 0) {
            String charset = this.searchCharSet(items, sb, i);
            if (charset.length() > 0) {
                return charset;
            }
            sb.setLength(0);
            --i;
        }
        return "";
    }

    private String searchCharSet(String[] items, StringBuffer base, int count) {
        if (--count >= 0 && items[count] != null && items[count].length() > 0) {
            base.insert(0, items[count]);
            int length = base.length();
            int i = count;
            while (i > 0) {
                String charset;
                if (i == count || i <= 1) {
                    base.insert(0, '_');
                    ++length;
                }
                if ((charset = this.searchCharSet(items, base, i)).length() > 0) {
                    return charset;
                }
                base.delete(0, base.length() - length);
                --i;
            }
            return this.searchCharSet(base.toString());
        }
        return "";
    }

    private String searchCharSet(String key) {
        if (key != null && key.length() > 0) {
            int i = 0;
            while (i < this.mappers.length) {
                String charset;
                Map mapper = this.mappers[i];
                if (mapper != null && (charset = (String)mapper.get(key)) != null) {
                    if (i > 0) {
                        this.mappers[0].put(key, charset);
                    }
                    return charset;
                }
                ++i;
            }
            this.mappers[0].put(key, "");
        }
        return "";
    }

    protected synchronized void setCommonCharSet(String key, String charset) {
        HashMap mapper = (HashMap)((HashMap)this.mappers[5]).clone();
        mapper.put(key, charset);
        this.mappers[5] = mapper;
        this.mappers[0].clear();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public CharSetMap() {
        String path;
        try {
            path = System.getProperty("user.home");
            if (path != null) {
                path = path + File.separator + CHARSET_RESOURCE;
                this.mappers[2] = CharSetMap.loadPath(path);
            }
        }
        catch (Exception x) {
            // empty catch block
        }
        try {
            path = System.getProperty("java.home") + File.separator + "lib" + File.separator + CHARSET_RESOURCE;
            this.mappers[3] = CharSetMap.loadPath(path);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mappers[4] = CharSetMap.loadResource("/META-INF/charset.properties");
        this.mappers[5] = commonMapper;
        this.mappers[0] = new Hashtable();
    }

    public CharSetMap(Properties props) {
        this();
        this.mappers[1] = new HashMap<Object, Object>(props);
    }

    public CharSetMap(InputStream input) throws IOException {
        this();
        this.mappers[1] = CharSetMap.loadStream(input);
    }

    public CharSetMap(File file) throws IOException {
        this();
        this.mappers[1] = CharSetMap.loadFile(file);
    }

    public CharSetMap(String path) throws IOException {
        this();
        this.mappers[1] = CharSetMap.loadPath(path);
    }

    static {
        commonMapper.put("ar", "ISO-8859-6");
        commonMapper.put("be", "ISO-8859-5");
        commonMapper.put("bg", "ISO-8859-5");
        commonMapper.put("ca", DEFAULT_CHARSET);
        commonMapper.put("cs", "ISO-8859-2");
        commonMapper.put("da", DEFAULT_CHARSET);
        commonMapper.put("de", DEFAULT_CHARSET);
        commonMapper.put("el", "ISO-8859-7");
        commonMapper.put("en", DEFAULT_CHARSET);
        commonMapper.put("es", DEFAULT_CHARSET);
        commonMapper.put("et", DEFAULT_CHARSET);
        commonMapper.put("fi", DEFAULT_CHARSET);
        commonMapper.put("fr", DEFAULT_CHARSET);
        commonMapper.put("hr", "ISO-8859-2");
        commonMapper.put("hu", "ISO-8859-2");
        commonMapper.put("is", DEFAULT_CHARSET);
        commonMapper.put("it", DEFAULT_CHARSET);
        commonMapper.put("iw", "ISO-8859-8");
        commonMapper.put("ja", "Shift_JIS");
        commonMapper.put("ko", "EUC-KR");
        commonMapper.put("lt", "ISO-8859-2");
        commonMapper.put("lv", "ISO-8859-2");
        commonMapper.put("mk", "ISO-8859-5");
        commonMapper.put("nl", DEFAULT_CHARSET);
        commonMapper.put("no", DEFAULT_CHARSET);
        commonMapper.put("pl", "ISO-8859-2");
        commonMapper.put("pt", DEFAULT_CHARSET);
        commonMapper.put("ro", "ISO-8859-2");
        commonMapper.put("ru", "ISO-8859-5");
        commonMapper.put("sh", "ISO-8859-5");
        commonMapper.put("sk", "ISO-8859-2");
        commonMapper.put("sl", "ISO-8859-2");
        commonMapper.put("sq", "ISO-8859-2");
        commonMapper.put("sr", "ISO-8859-5");
        commonMapper.put("sv", DEFAULT_CHARSET);
        commonMapper.put("tr", "ISO-8859-9");
        commonMapper.put("uk", "ISO-8859-5");
        commonMapper.put("zh", "GB2312");
        commonMapper.put("zh_TW", "Big5");
    }
}

