/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.dsm.util;

import com.sourceforge.knecs.dsm.util.DAVResource;
import com.sourceforge.knecs.dsm.util.DAVResourcePropertyVector;
import com.sourceforge.knecs.util.LoggerUtils;
import com.sourceforge.knecs.util.SimpleDateFormat;
import com.sourceforge.knecs.util.UrlUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Logger;

public class ResourceList
extends Vector {
    public static String NAME = "name";
    public static String CREATOR = "creator";
    public static String CREATION_DATE = "created";
    public static String LAST_MODIFIED_DATE = "lastmodified";
    public static String SIZE = "size";
    public static String PATH = "path";
    protected String mLastSort = NAME;
    protected DAVResource mParent;
    protected String mServer;
    protected TreeSet mSelectedFiles;
    protected String mHighlightedFile;
    protected static Logger mLogger = LoggerUtils.getLogger();

    public ResourceList() {
        this.mSelectedFiles = new TreeSet();
        this.mParent = null;
        this.mServer = null;
    }

    public ResourceList(Vector resources) {
        super(resources);
        this.sort();
        this.mSelectedFiles = new TreeSet();
        this.mParent = null;
        this.mServer = null;
    }

    public ResourceList(Vector resources, DAVResource parent) {
        this(resources);
        this.mParent = parent;
    }

    public String getServer() {
        return this.mServer;
    }

    public void setServer(String serverUrl) {
        this.mServer = serverUrl;
    }

    public DAVResource getParentDirectory() {
        return this.mParent;
    }

    public void setParentDirectory(DAVResource parent) {
        this.mParent = parent;
    }

    public Vector getResources() {
        return (Vector)this.clone();
    }

    public void sort() {
        this.sort(this.mLastSort);
    }

    public void sort(String sortby) {
        ResourceComparator comp = null;
        if (sortby == null || sortby.equals(NAME)) {
            comp = new NameComparator();
        } else if (sortby.equals(CREATOR)) {
            comp = new CreatorComparator();
        } else if (sortby.equals(CREATION_DATE)) {
            comp = new CreatedComparator();
        } else if (sortby.equals(LAST_MODIFIED_DATE)) {
            comp = new ModifiedComparator();
        } else if (sortby.equals(SIZE)) {
            comp = new SizeComparator();
        } else if (sortby.equals(PATH)) {
            comp = new PathComparator();
        } else {
            mLogger.severe("Cannot reconize ResourceList sort criteria: " + sortby);
        }
        if (comp != null) {
            try {
                Collections.sort(this, comp);
            }
            catch (Exception e) {
                mLogger.severe(LoggerUtils.getStackTrace(e));
            }
        }
    }

    public void reverseSort(String sortby) {
        ResourceComparator comp = null;
        if (sortby == null || sortby.equals(NAME)) {
            comp = new ReverseNameComparator();
        } else if (sortby.equals(CREATOR)) {
            comp = new ReverseCreatorComparator();
        } else if (sortby.equals(CREATION_DATE)) {
            comp = new ReverseCreatedComparator();
        } else if (sortby.equals(LAST_MODIFIED_DATE)) {
            comp = new ReverseModifiedComparator();
        } else if (sortby.equals(SIZE)) {
            comp = new ReverseSizeComparator();
        } else if (sortby.equals(PATH)) {
            comp = new ReversePathComparator();
        } else {
            mLogger.severe("Cannot reconize ResourceList sort criteria: " + sortby);
        }
        if (comp != null) {
            try {
                Collections.sort(this, comp);
            }
            catch (Exception e) {
                mLogger.severe(LoggerUtils.getStackTrace(e));
            }
        }
    }

    public void select(String url) {
        String fUrl = this.formatURL(url);
        this.mSelectedFiles.add(fUrl);
    }

    public void unselect(String url) {
        String fUrl = this.formatURL(url);
        this.mSelectedFiles.remove(fUrl);
    }

    public boolean isSelected(String url) {
        String fUrl = this.formatURL(url);
        boolean ret = false;
        if (this.mSelectedFiles.contains(fUrl)) {
            ret = true;
        }
        return ret;
    }

    public void selectAll() {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            DAVResource resource = (DAVResource)this.elementAt(i);
            String url = this.formatURL(resource.getURL());
            this.mSelectedFiles.add(url);
        }
    }

    public void unselectAll() {
        this.mSelectedFiles.clear();
    }

    public void highlight(String url) {
        String fUrl = url;
        if (url != null) {
            fUrl = this.formatURL(url);
        }
        this.mHighlightedFile = fUrl;
    }

    public boolean isHighlighted(String url) {
        String fUrl = this.formatURL(url);
        return fUrl.equals(this.mHighlightedFile);
    }

    public DAVResource getHighlightedFile() {
        DAVResource ret = null;
        if (this.mHighlightedFile != null) {
            ret = this.getResource(this.mHighlightedFile);
        }
        return ret;
    }

    public Vector getSelectedFiles() {
        int size = this.size();
        Vector<DAVResource> ret = new Vector<DAVResource>();
        for (int i = 0; i < size; ++i) {
            DAVResource resource = (DAVResource)this.elementAt(i);
            String url = this.formatURL(resource.getURL());
            if (!this.mSelectedFiles.contains(url)) continue;
            ret.add(resource);
        }
        return ret;
    }

    public Vector getSelectedFileUrls() {
        int size = this.size();
        Vector<String> ret = new Vector<String>();
        for (int i = 0; i < size; ++i) {
            DAVResource resource = (DAVResource)this.elementAt(i);
            String url = this.formatURL(resource.getURL());
            if (!this.mSelectedFiles.contains(url)) continue;
            ret.add(resource.getURL());
        }
        return ret;
    }

    public Vector getSelectedFilePaths() {
        int size = this.size();
        Vector<String> ret = new Vector<String>();
        for (int i = 0; i < size; ++i) {
            DAVResource resource = (DAVResource)this.elementAt(i);
            String url = this.formatURL(resource.getURL());
            if (!this.mSelectedFiles.contains(url)) continue;
            ret.add(resource.getPath());
        }
        return ret;
    }

    public Vector getCollections() {
        Vector<DAVResource> ret = new Vector<DAVResource>();
        for (int idx = 0; idx < this.size(); ++idx) {
            DAVResource dr = (DAVResource)this.get(idx);
            if (!dr.isCollection()) continue;
            ret.addElement(dr);
        }
        return ret;
    }

    public Vector getByType(String type, boolean includeCollections) {
        Vector<DAVResource> ret = new Vector<DAVResource>();
        for (int idx = 0; idx < this.size(); ++idx) {
            String drtype;
            DAVResource dr = (DAVResource)this.get(idx);
            if (includeCollections && dr.isCollection()) {
                ret.addElement(dr);
                continue;
            }
            DAVResourcePropertyVector vec = dr.getResourceType();
            if (vec == null || vec.size() <= 0 || !type.equals(drtype = (String)vec.elementAt(0))) continue;
            ret.addElement(dr);
        }
        return ret;
    }

    public Vector getByMatch(String regex, boolean includeCollections) {
        Vector<DAVResource> ret = new Vector<DAVResource>();
        for (int idx = 0; idx < this.size(); ++idx) {
            DAVResource dr = (DAVResource)this.get(idx);
            if (includeCollections && dr.isCollection()) {
                ret.addElement(dr);
                continue;
            }
            if (!dr.getURL().matches(regex)) continue;
            ret.addElement(dr);
        }
        return ret;
    }

    public DAVResource getResource(String url_) {
        String url = this.formatURL(url_);
        DAVResource ret = null;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            DAVResource resource = (DAVResource)this.elementAt(i);
            String resourceurl = this.formatURL(resource.getURL());
            if (!resourceurl.equals(url)) continue;
            ret = resource;
            break;
        }
        return ret;
    }

    public boolean exists(String name) {
        boolean ret = false;
        DAVResource resource = null;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            resource = (DAVResource)this.elementAt(i);
            String rname = resource.getFileName();
            if (!name.equals(name)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public DAVResource find(String name) {
        DAVResource ret = null;
        DAVResource resource = null;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            resource = (DAVResource)this.elementAt(i);
            String rname = resource.getFileName();
            if (!name.equals(name)) continue;
            ret = resource;
            break;
        }
        return ret;
    }

    public void updateResource(DAVResource newResource) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            DAVResource resource = (DAVResource)this.elementAt(i);
            if (!resource.getURL().equals(newResource.getURL())) continue;
            this.set(i, newResource);
            break;
        }
    }

    public String formatURL(String url) {
        return UrlUtils.formatURL(url, this.mServer);
    }

    protected class ReversePathComparator
    extends ResourceComparator {
        protected ReversePathComparator() {
        }

        public int internalCompare(DAVResource resource1, DAVResource resource2) {
            String dir2;
            Comparator stringComp = String.CASE_INSENSITIVE_ORDER;
            String dir1 = UrlUtils.getParentDir(resource2.getPath());
            int ret = stringComp.compare(dir1, dir2 = UrlUtils.getParentDir(resource1.getPath()));
            if (ret == 0) {
                ret = dir1.compareTo(dir2);
            }
            if (ret == 0) {
                ret = stringComp.compare(resource2.getFileName(), resource1.getFileName());
            }
            if (ret == 0) {
                ret = resource2.getFileName().compareTo(resource1.getFileName());
            }
            return ret;
        }
    }

    protected class PathComparator
    extends ResourceComparator {
        protected PathComparator() {
        }

        public int internalCompare(DAVResource resource1, DAVResource resource2) {
            String dir2;
            Comparator stringComp = String.CASE_INSENSITIVE_ORDER;
            String dir1 = UrlUtils.getParentDir(resource1.getPath());
            int ret = stringComp.compare(dir1, dir2 = UrlUtils.getParentDir(resource2.getPath()));
            if (ret == 0) {
                ret = dir1.compareTo(dir2);
            }
            if (ret == 0) {
                ret = stringComp.compare(resource1.getFileName(), resource2.getFileName());
            }
            if (ret == 0) {
                ret = resource1.getFileName().compareTo(resource2.getFileName());
            }
            return ret;
        }
    }

    protected class ReverseSizeComparator
    extends ResourceComparator {
        protected ReverseSizeComparator() {
        }

        public int internalCompare(DAVResource resource1, DAVResource resource2) {
            int int2;
            int int1 = Integer.valueOf(resource2.getContentLength().toString());
            if (int1 < (int2 = Integer.valueOf(resource1.getContentLength().toString()).intValue())) {
                return -1;
            }
            if (int1 == int2) {
                return 0;
            }
            return 1;
        }
    }

    protected class SizeComparator
    extends ResourceComparator {
        protected SizeComparator() {
        }

        public int internalCompare(DAVResource resource1, DAVResource resource2) {
            int int2;
            int int1 = Integer.valueOf(resource1.getContentLength().toString());
            if (int1 < (int2 = Integer.valueOf(resource2.getContentLength().toString()).intValue())) {
                return -1;
            }
            if (int1 == int2) {
                return 0;
            }
            return 1;
        }
    }

    protected class ReverseModifiedComparator
    extends ResourceComparator {
        protected ReverseModifiedComparator() {
        }

        public int internalCompare(DAVResource resource1, DAVResource resource2) {
            Date date1 = resource1.getLastModifiedDateAsDate();
            Date date2 = resource2.getLastModifiedDateAsDate();
            return date2.compareTo(date1);
        }
    }

    protected class ModifiedComparator
    extends ResourceComparator {
        protected ModifiedComparator() {
        }

        public int internalCompare(DAVResource resource1, DAVResource resource2) {
            Date date1 = resource1.getLastModifiedDateAsDate();
            Date date2 = resource2.getLastModifiedDateAsDate();
            return date1.compareTo(date2);
        }
    }

    protected class ReverseCreatedComparator
    extends ResourceComparator {
        protected ReverseCreatedComparator() {
        }

        public int internalCompare(DAVResource resource1, DAVResource resource2) {
            SimpleDateFormat df = new SimpleDateFormat();
            Date date2 = df.parseDateTime(resource2.getCreationDate().toString());
            Date date1 = df.parseDateTime(resource1.getCreationDate().toString());
            return date2.compareTo(date1);
        }
    }

    protected class CreatedComparator
    extends ResourceComparator {
        protected CreatedComparator() {
        }

        public int internalCompare(DAVResource resource1, DAVResource resource2) {
            SimpleDateFormat df = new SimpleDateFormat();
            Date date1 = df.parseDateTime(resource1.getCreationDate().toString());
            Date date2 = df.parseDateTime(resource2.getCreationDate().toString());
            return date1.compareTo(date2);
        }
    }

    protected class ReverseCreatorComparator
    extends ResourceComparator {
        protected ReverseCreatorComparator() {
        }

        public int internalCompare(DAVResource resource1, DAVResource resource2) {
            Comparator stringComp = String.CASE_INSENSITIVE_ORDER;
            return stringComp.compare(resource2.getCreator().toString(), resource1.getCreator().toString());
        }
    }

    protected class CreatorComparator
    extends ResourceComparator {
        protected CreatorComparator() {
        }

        public int internalCompare(DAVResource resource1, DAVResource resource2) {
            Comparator stringComp = String.CASE_INSENSITIVE_ORDER;
            return stringComp.compare(resource1.getCreator().toString(), resource2.getCreator().toString());
        }
    }

    protected class ReverseNameComparator
    extends ResourceComparator {
        protected ReverseNameComparator() {
        }

        public int internalCompare(DAVResource resource1, DAVResource resource2) {
            return resource2.compareTo(resource1);
        }
    }

    protected class NameComparator
    extends ResourceComparator {
        protected NameComparator() {
        }

        public int internalCompare(DAVResource resource1, DAVResource resource2) {
            return resource1.compareTo(resource2);
        }
    }

    protected abstract class ResourceComparator
    implements Comparator {
        protected ResourceComparator() {
        }

        public int compare(Object resource1, Object resource2) throws ClassCastException {
            if (resource1 == null && resource2 != null) {
                return -1;
            }
            if (resource1 != null && resource2 == null) {
                return 1;
            }
            if (resource1 == null & resource2 == null) {
                return 0;
            }
            if (!(resource1 instanceof DAVResource) || !(resource2 instanceof DAVResource)) {
                throw new ClassCastException();
            }
            return this.internalCompare((DAVResource)resource1, (DAVResource)resource2);
        }

        public abstract int internalCompare(DAVResource var1, DAVResource var2);

        public boolean equals(Object obj) {
            return obj != null && obj instanceof ResourceComparator;
        }
    }
}

