/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */

// @generated by gentest/gentest.rb from gentest/fixtures/YGAndroidNewsFeed.html

test("android_news_feed", () => {
  const config = Yoga.Config.create();
  let root;

  config.setExperimentalFeatureEnabled(Yoga.EXPERIMENTAL_FEATURE_ABSOLUTE_PERCENTAGE_AGAINST_PADDING_EDGE, true);
  config.setExperimentalFeatureEnabled(Yoga.EXPERIMENTAL_FEATURE_FIX_ABSOLUTE_TRAILING_COLUMN_MARGIN, true);

  try {
    root = Yoga.Node.create(config);
    root.setAlignContent(Yoga.ALIGN_STRETCH);
    root.setWidth(1080);

    const root_child0 = Yoga.Node.create(config);
    root.insertChild(root_child0, 0);

    const root_child0_child0 = Yoga.Node.create(config);
    root_child0_child0.setAlignContent(Yoga.ALIGN_STRETCH);
    root_child0.insertChild(root_child0_child0, 0);

    const root_child0_child0_child0 = Yoga.Node.create(config);
    root_child0_child0_child0.setAlignContent(Yoga.ALIGN_STRETCH);
    root_child0_child0.insertChild(root_child0_child0_child0, 0);

    const root_child0_child0_child0_child0 = Yoga.Node.create(config);
    root_child0_child0_child0_child0.setFlexDirection(Yoga.FLEX_DIRECTION_ROW);
    root_child0_child0_child0_child0.setAlignContent(Yoga.ALIGN_STRETCH);
    root_child0_child0_child0_child0.setAlignItems(Yoga.ALIGN_FLEX_START);
    root_child0_child0_child0_child0.setMargin(Yoga.EDGE_START, 36);
    root_child0_child0_child0_child0.setMargin(Yoga.EDGE_TOP, 24);
    root_child0_child0_child0.insertChild(root_child0_child0_child0_child0, 0);

    const root_child0_child0_child0_child0_child0 = Yoga.Node.create(config);
    root_child0_child0_child0_child0_child0.setFlexDirection(Yoga.FLEX_DIRECTION_ROW);
    root_child0_child0_child0_child0_child0.setAlignContent(Yoga.ALIGN_STRETCH);
    root_child0_child0_child0_child0.insertChild(root_child0_child0_child0_child0_child0, 0);

    const root_child0_child0_child0_child0_child0_child0 = Yoga.Node.create(config);
    root_child0_child0_child0_child0_child0_child0.setAlignContent(Yoga.ALIGN_STRETCH);
    root_child0_child0_child0_child0_child0_child0.setWidth(120);
    root_child0_child0_child0_child0_child0_child0.setHeight(120);
    root_child0_child0_child0_child0_child0.insertChild(root_child0_child0_child0_child0_child0_child0, 0);

    const root_child0_child0_child0_child0_child1 = Yoga.Node.create(config);
    root_child0_child0_child0_child0_child1.setAlignContent(Yoga.ALIGN_STRETCH);
    root_child0_child0_child0_child0_child1.setFlexShrink(1);
    root_child0_child0_child0_child0_child1.setMargin(Yoga.EDGE_RIGHT, 36);
    root_child0_child0_child0_child0_child1.setPadding(Yoga.EDGE_LEFT, 36);
    root_child0_child0_child0_child0_child1.setPadding(Yoga.EDGE_TOP, 21);
    root_child0_child0_child0_child0_child1.setPadding(Yoga.EDGE_RIGHT, 36);
    root_child0_child0_child0_child0_child1.setPadding(Yoga.EDGE_BOTTOM, 18);
    root_child0_child0_child0_child0.insertChild(root_child0_child0_child0_child0_child1, 1);

    const root_child0_child0_child0_child0_child1_child0 = Yoga.Node.create(config);
    root_child0_child0_child0_child0_child1_child0.setFlexDirection(Yoga.FLEX_DIRECTION_ROW);
    root_child0_child0_child0_child0_child1_child0.setAlignContent(Yoga.ALIGN_STRETCH);
    root_child0_child0_child0_child0_child1_child0.setFlexShrink(1);
    root_child0_child0_child0_child0_child1.insertChild(root_child0_child0_child0_child0_child1_child0, 0);

    const root_child0_child0_child0_child0_child1_child1 = Yoga.Node.create(config);
    root_child0_child0_child0_child0_child1_child1.setAlignContent(Yoga.ALIGN_STRETCH);
    root_child0_child0_child0_child0_child1_child1.setFlexShrink(1);
    root_child0_child0_child0_child0_child1.insertChild(root_child0_child0_child0_child0_child1_child1, 1);

    const root_child0_child0_child1 = Yoga.Node.create(config);
    root_child0_child0_child1.setAlignContent(Yoga.ALIGN_STRETCH);
    root_child0_child0.insertChild(root_child0_child0_child1, 1);

    const root_child0_child0_child1_child0 = Yoga.Node.create(config);
    root_child0_child0_child1_child0.setFlexDirection(Yoga.FLEX_DIRECTION_ROW);
    root_child0_child0_child1_child0.setAlignContent(Yoga.ALIGN_STRETCH);
    root_child0_child0_child1_child0.setAlignItems(Yoga.ALIGN_FLEX_START);
    root_child0_child0_child1_child0.setMargin(Yoga.EDGE_START, 174);
    root_child0_child0_child1_child0.setMargin(Yoga.EDGE_TOP, 24);
    root_child0_child0_child1.insertChild(root_child0_child0_child1_child0, 0);

    const root_child0_child0_child1_child0_child0 = Yoga.Node.create(config);
    root_child0_child0_child1_child0_child0.setFlexDirection(Yoga.FLEX_DIRECTION_ROW);
    root_child0_child0_child1_child0_child0.setAlignContent(Yoga.ALIGN_STRETCH);
    root_child0_child0_child1_child0.insertChild(root_child0_child0_child1_child0_child0, 0);

    const root_child0_child0_child1_child0_child0_child0 = Yoga.Node.create(config);
    root_child0_child0_child1_child0_child0_child0.setAlignContent(Yoga.ALIGN_STRETCH);
    root_child0_child0_child1_child0_child0_child0.setWidth(72);
    root_child0_child0_child1_child0_child0_child0.setHeight(72);
    root_child0_child0_child1_child0_child0.insertChild(root_child0_child0_child1_child0_child0_child0, 0);

    const root_child0_child0_child1_child0_child1 = Yoga.Node.create(config);
    root_child0_child0_child1_child0_child1.setAlignContent(Yoga.ALIGN_STRETCH);
    root_child0_child0_child1_child0_child1.setFlexShrink(1);
    root_child0_child0_child1_child0_child1.setMargin(Yoga.EDGE_RIGHT, 36);
    root_child0_child0_child1_child0_child1.setPadding(Yoga.EDGE_LEFT, 36);
    root_child0_child0_child1_child0_child1.setPadding(Yoga.EDGE_TOP, 21);
    root_child0_child0_child1_child0_child1.setPadding(Yoga.EDGE_RIGHT, 36);
    root_child0_child0_child1_child0_child1.setPadding(Yoga.EDGE_BOTTOM, 18);
    root_child0_child0_child1_child0.insertChild(root_child0_child0_child1_child0_child1, 1);

    const root_child0_child0_child1_child0_child1_child0 = Yoga.Node.create(config);
    root_child0_child0_child1_child0_child1_child0.setFlexDirection(Yoga.FLEX_DIRECTION_ROW);
    root_child0_child0_child1_child0_child1_child0.setAlignContent(Yoga.ALIGN_STRETCH);
    root_child0_child0_child1_child0_child1_child0.setFlexShrink(1);
    root_child0_child0_child1_child0_child1.insertChild(root_child0_child0_child1_child0_child1_child0, 0);

    const root_child0_child0_child1_child0_child1_child1 = Yoga.Node.create(config);
    root_child0_child0_child1_child0_child1_child1.setAlignContent(Yoga.ALIGN_STRETCH);
    root_child0_child0_child1_child0_child1_child1.setFlexShrink(1);
    root_child0_child0_child1_child0_child1.insertChild(root_child0_child0_child1_child0_child1_child1, 1);
    root.calculateLayout(Yoga.UNDEFINED, Yoga.UNDEFINED, Yoga.DIRECTION_LTR);

    expect(root.getComputedLeft()).toBe(0);
    expect(root.getComputedTop()).toBe(0);
    expect(root.getComputedWidth()).toBe(1080);
    expect(root.getComputedHeight()).toBe(240);

    expect(root_child0.getComputedLeft()).toBe(0);
    expect(root_child0.getComputedTop()).toBe(0);
    expect(root_child0.getComputedWidth()).toBe(1080);
    expect(root_child0.getComputedHeight()).toBe(240);

    expect(root_child0_child0.getComputedLeft()).toBe(0);
    expect(root_child0_child0.getComputedTop()).toBe(0);
    expect(root_child0_child0.getComputedWidth()).toBe(1080);
    expect(root_child0_child0.getComputedHeight()).toBe(240);

    expect(root_child0_child0_child0.getComputedLeft()).toBe(0);
    expect(root_child0_child0_child0.getComputedTop()).toBe(0);
    expect(root_child0_child0_child0.getComputedWidth()).toBe(1080);
    expect(root_child0_child0_child0.getComputedHeight()).toBe(144);

    expect(root_child0_child0_child0_child0.getComputedLeft()).toBe(36);
    expect(root_child0_child0_child0_child0.getComputedTop()).toBe(24);
    expect(root_child0_child0_child0_child0.getComputedWidth()).toBe(1044);
    expect(root_child0_child0_child0_child0.getComputedHeight()).toBe(120);

    expect(root_child0_child0_child0_child0_child0.getComputedLeft()).toBe(0);
    expect(root_child0_child0_child0_child0_child0.getComputedTop()).toBe(0);
    expect(root_child0_child0_child0_child0_child0.getComputedWidth()).toBe(120);
    expect(root_child0_child0_child0_child0_child0.getComputedHeight()).toBe(120);

    expect(root_child0_child0_child0_child0_child0_child0.getComputedLeft()).toBe(0);
    expect(root_child0_child0_child0_child0_child0_child0.getComputedTop()).toBe(0);
    expect(root_child0_child0_child0_child0_child0_child0.getComputedWidth()).toBe(120);
    expect(root_child0_child0_child0_child0_child0_child0.getComputedHeight()).toBe(120);

    expect(root_child0_child0_child0_child0_child1.getComputedLeft()).toBe(120);
    expect(root_child0_child0_child0_child0_child1.getComputedTop()).toBe(0);
    expect(root_child0_child0_child0_child0_child1.getComputedWidth()).toBe(72);
    expect(root_child0_child0_child0_child0_child1.getComputedHeight()).toBe(39);

    expect(root_child0_child0_child0_child0_child1_child0.getComputedLeft()).toBe(36);
    expect(root_child0_child0_child0_child0_child1_child0.getComputedTop()).toBe(21);
    expect(root_child0_child0_child0_child0_child1_child0.getComputedWidth()).toBe(0);
    expect(root_child0_child0_child0_child0_child1_child0.getComputedHeight()).toBe(0);

    expect(root_child0_child0_child0_child0_child1_child1.getComputedLeft()).toBe(36);
    expect(root_child0_child0_child0_child0_child1_child1.getComputedTop()).toBe(21);
    expect(root_child0_child0_child0_child0_child1_child1.getComputedWidth()).toBe(0);
    expect(root_child0_child0_child0_child0_child1_child1.getComputedHeight()).toBe(0);

    expect(root_child0_child0_child1.getComputedLeft()).toBe(0);
    expect(root_child0_child0_child1.getComputedTop()).toBe(144);
    expect(root_child0_child0_child1.getComputedWidth()).toBe(1080);
    expect(root_child0_child0_child1.getComputedHeight()).toBe(96);

    expect(root_child0_child0_child1_child0.getComputedLeft()).toBe(174);
    expect(root_child0_child0_child1_child0.getComputedTop()).toBe(24);
    expect(root_child0_child0_child1_child0.getComputedWidth()).toBe(906);
    expect(root_child0_child0_child1_child0.getComputedHeight()).toBe(72);

    expect(root_child0_child0_child1_child0_child0.getComputedLeft()).toBe(0);
    expect(root_child0_child0_child1_child0_child0.getComputedTop()).toBe(0);
    expect(root_child0_child0_child1_child0_child0.getComputedWidth()).toBe(72);
    expect(root_child0_child0_child1_child0_child0.getComputedHeight()).toBe(72);

    expect(root_child0_child0_child1_child0_child0_child0.getComputedLeft()).toBe(0);
    expect(root_child0_child0_child1_child0_child0_child0.getComputedTop()).toBe(0);
    expect(root_child0_child0_child1_child0_child0_child0.getComputedWidth()).toBe(72);
    expect(root_child0_child0_child1_child0_child0_child0.getComputedHeight()).toBe(72);

    expect(root_child0_child0_child1_child0_child1.getComputedLeft()).toBe(72);
    expect(root_child0_child0_child1_child0_child1.getComputedTop()).toBe(0);
    expect(root_child0_child0_child1_child0_child1.getComputedWidth()).toBe(72);
    expect(root_child0_child0_child1_child0_child1.getComputedHeight()).toBe(39);

    expect(root_child0_child0_child1_child0_child1_child0.getComputedLeft()).toBe(36);
    expect(root_child0_child0_child1_child0_child1_child0.getComputedTop()).toBe(21);
    expect(root_child0_child0_child1_child0_child1_child0.getComputedWidth()).toBe(0);
    expect(root_child0_child0_child1_child0_child1_child0.getComputedHeight()).toBe(0);

    expect(root_child0_child0_child1_child0_child1_child1.getComputedLeft()).toBe(36);
    expect(root_child0_child0_child1_child0_child1_child1.getComputedTop()).toBe(21);
    expect(root_child0_child0_child1_child0_child1_child1.getComputedWidth()).toBe(0);
    expect(root_child0_child0_child1_child0_child1_child1.getComputedHeight()).toBe(0);

    root.calculateLayout(Yoga.UNDEFINED, Yoga.UNDEFINED, Yoga.DIRECTION_RTL);

    expect(root.getComputedLeft()).toBe(0);
    expect(root.getComputedTop()).toBe(0);
    expect(root.getComputedWidth()).toBe(1080);
    expect(root.getComputedHeight()).toBe(240);

    expect(root_child0.getComputedLeft()).toBe(0);
    expect(root_child0.getComputedTop()).toBe(0);
    expect(root_child0.getComputedWidth()).toBe(1080);
    expect(root_child0.getComputedHeight()).toBe(240);

    expect(root_child0_child0.getComputedLeft()).toBe(0);
    expect(root_child0_child0.getComputedTop()).toBe(0);
    expect(root_child0_child0.getComputedWidth()).toBe(1080);
    expect(root_child0_child0.getComputedHeight()).toBe(240);

    expect(root_child0_child0_child0.getComputedLeft()).toBe(0);
    expect(root_child0_child0_child0.getComputedTop()).toBe(0);
    expect(root_child0_child0_child0.getComputedWidth()).toBe(1080);
    expect(root_child0_child0_child0.getComputedHeight()).toBe(144);

    expect(root_child0_child0_child0_child0.getComputedLeft()).toBe(0);
    expect(root_child0_child0_child0_child0.getComputedTop()).toBe(24);
    expect(root_child0_child0_child0_child0.getComputedWidth()).toBe(1044);
    expect(root_child0_child0_child0_child0.getComputedHeight()).toBe(120);

    expect(root_child0_child0_child0_child0_child0.getComputedLeft()).toBe(924);
    expect(root_child0_child0_child0_child0_child0.getComputedTop()).toBe(0);
    expect(root_child0_child0_child0_child0_child0.getComputedWidth()).toBe(120);
    expect(root_child0_child0_child0_child0_child0.getComputedHeight()).toBe(120);

    expect(root_child0_child0_child0_child0_child0_child0.getComputedLeft()).toBe(0);
    expect(root_child0_child0_child0_child0_child0_child0.getComputedTop()).toBe(0);
    expect(root_child0_child0_child0_child0_child0_child0.getComputedWidth()).toBe(120);
    expect(root_child0_child0_child0_child0_child0_child0.getComputedHeight()).toBe(120);

    expect(root_child0_child0_child0_child0_child1.getComputedLeft()).toBe(816);
    expect(root_child0_child0_child0_child0_child1.getComputedTop()).toBe(0);
    expect(root_child0_child0_child0_child0_child1.getComputedWidth()).toBe(72);
    expect(root_child0_child0_child0_child0_child1.getComputedHeight()).toBe(39);

    expect(root_child0_child0_child0_child0_child1_child0.getComputedLeft()).toBe(36);
    expect(root_child0_child0_child0_child0_child1_child0.getComputedTop()).toBe(21);
    expect(root_child0_child0_child0_child0_child1_child0.getComputedWidth()).toBe(0);
    expect(root_child0_child0_child0_child0_child1_child0.getComputedHeight()).toBe(0);

    expect(root_child0_child0_child0_child0_child1_child1.getComputedLeft()).toBe(36);
    expect(root_child0_child0_child0_child0_child1_child1.getComputedTop()).toBe(21);
    expect(root_child0_child0_child0_child0_child1_child1.getComputedWidth()).toBe(0);
    expect(root_child0_child0_child0_child0_child1_child1.getComputedHeight()).toBe(0);

    expect(root_child0_child0_child1.getComputedLeft()).toBe(0);
    expect(root_child0_child0_child1.getComputedTop()).toBe(144);
    expect(root_child0_child0_child1.getComputedWidth()).toBe(1080);
    expect(root_child0_child0_child1.getComputedHeight()).toBe(96);

    expect(root_child0_child0_child1_child0.getComputedLeft()).toBe(0);
    expect(root_child0_child0_child1_child0.getComputedTop()).toBe(24);
    expect(root_child0_child0_child1_child0.getComputedWidth()).toBe(906);
    expect(root_child0_child0_child1_child0.getComputedHeight()).toBe(72);

    expect(root_child0_child0_child1_child0_child0.getComputedLeft()).toBe(834);
    expect(root_child0_child0_child1_child0_child0.getComputedTop()).toBe(0);
    expect(root_child0_child0_child1_child0_child0.getComputedWidth()).toBe(72);
    expect(root_child0_child0_child1_child0_child0.getComputedHeight()).toBe(72);

    expect(root_child0_child0_child1_child0_child0_child0.getComputedLeft()).toBe(0);
    expect(root_child0_child0_child1_child0_child0_child0.getComputedTop()).toBe(0);
    expect(root_child0_child0_child1_child0_child0_child0.getComputedWidth()).toBe(72);
    expect(root_child0_child0_child1_child0_child0_child0.getComputedHeight()).toBe(72);

    expect(root_child0_child0_child1_child0_child1.getComputedLeft()).toBe(726);
    expect(root_child0_child0_child1_child0_child1.getComputedTop()).toBe(0);
    expect(root_child0_child0_child1_child0_child1.getComputedWidth()).toBe(72);
    expect(root_child0_child0_child1_child0_child1.getComputedHeight()).toBe(39);

    expect(root_child0_child0_child1_child0_child1_child0.getComputedLeft()).toBe(36);
    expect(root_child0_child0_child1_child0_child1_child0.getComputedTop()).toBe(21);
    expect(root_child0_child0_child1_child0_child1_child0.getComputedWidth()).toBe(0);
    expect(root_child0_child0_child1_child0_child1_child0.getComputedHeight()).toBe(0);

    expect(root_child0_child0_child1_child0_child1_child1.getComputedLeft()).toBe(36);
    expect(root_child0_child0_child1_child0_child1_child1.getComputedTop()).toBe(21);
    expect(root_child0_child0_child1_child0_child1_child1.getComputedWidth()).toBe(0);
    expect(root_child0_child0_child1_child0_child1_child1.getComputedHeight()).toBe(0);
  } finally {
    if (typeof root !== "undefined") {
      root.freeRecursive();
    }

    config.free();
  }
});
