<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[Home](./index.md) &gt; [puppeteer](./puppeteer.md) &gt; [Page](./puppeteer.page.md) &gt; [queryObjects](./puppeteer.page.queryobjects.md)

## Page.queryObjects() method

This method iterates the JavaScript heap and finds all objects with the given prototype.

<b>Signature:</b>

```typescript
queryObjects(prototypeHandle: JSHandle): Promise<JSHandle>;
```

## Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  prototypeHandle | [JSHandle](./puppeteer.jshandle.md) | a handle to the object prototype. |

<b>Returns:</b>

Promise&lt;[JSHandle](./puppeteer.jshandle.md)&gt;

Promise which resolves to a handle to an array of objects with this prototype.

## Remarks

Shortcut for [page.mainFrame().executionContext().queryObjects(prototypeHandle)](./puppeteer.executioncontext.queryobjects.md).

## Example


```js
// Create a Map object
await page.evaluate(() => window.map = new Map());
// Get a handle to the Map object prototype
const mapPrototype = await page.evaluateHandle(() => Map.prototype);
// Query all map instances into an array
const mapInstances = await page.queryObjects(mapPrototype);
// Count amount of map objects in heap
const count = await page.evaluate(maps => maps.length, mapInstances);
await mapInstances.dispose();
await mapPrototype.dispose();

```

