/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * Portions Copyrighted 2009 Sun Microsystems, Inc.
 */

package org.netbeans.modules.java.hints;
import java.util.prefs.Preferences;

/**
 * Options Customiser panel for {@link FieldForUnusedParam} hint
 * @author Sam Halliday
 */
public class FieldForUnusedParamCustomizer extends javax.swing.JPanel {

    private Preferences p;

    /** Creates new form LocalVariableFixCustomizer */
    public FieldForUnusedParamCustomizer(Preferences p) {
        initComponents();
        this.p = p;
        finalFields.setSelected(FieldForUnusedParam.isFinalFields());
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        finalFields = new javax.swing.JCheckBox();

        org.openide.awt.Mnemonics.setLocalizedText(finalFields, org.openide.util.NbBundle.getBundle(FieldForUnusedParamCustomizer.class).getString("FieldForUnusedParamCustomizer.finalFields.text")); // NOI18N
        finalFields.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                finalFieldsActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(finalFields, javax.swing.GroupLayout.DEFAULT_SIZE, 131, Short.MAX_VALUE)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(17, 17, 17)
                .addComponent(finalFields)
                .addContainerGap(21, Short.MAX_VALUE))
        );

        finalFields.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(FieldForUnusedParamCustomizer.class, "ACSD_Final_Fields")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents

    private void finalFieldsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_finalFieldsActionPerformed
        FieldForUnusedParam.setFinalFields(p, finalFields.isSelected());
}//GEN-LAST:event_finalFieldsActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox finalFields;
    // End of variables declaration//GEN-END:variables
}
