/*  $Id: product_rules.inc,v 1.4 2016/07/22 15:39:13 kachalos Exp $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  NCBI developers
 *
 * File Description:
 *   Built-in copy of product_rules.prt.
 *
 */

static const char* const s_Defaultproductrules[] = {
    "Suspect-rule-set ::= {",
    "  {",
    "    find",
    "      contains-plural NULL ,",
    "    rule-type putative-typo ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      three-numbers NULL ,",
    "    except",
    "      string-constraint {",
    "        match-text \"methyltransferas\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            word \"methyltransferas\" ,",
    "            synonyms {",
    "              \"F420\" ,",
    "              \"FK506\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word FALSE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    feat-constraint {",
    "      string {",
    "        match-text \"16S rRNA pseudouridine(516) synthase\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "      string {",
    "        match-text \" 23S rRNA pseudouridine(955/2504/2580) synthase\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "      string {",
    "        match-text \"23S rRNA pseudouridine(1911/1915/1917) synthase\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } } ,",
    "    rule-type database ,",
    "    description \"contains three or more numbers together that may be",
    " identifiers more appropriate in note\" ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      all-caps NULL ,",
    "    rule-type putative-typo ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      unbalanced-paren NULL ,",
    "    rule-type inappropriate-symbol ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      too-long 100 ,",
    "    feat-constraint {",
    "      string {",
    "        match-text \"multifunctional\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "      string {",
    "        match-text \"bifunctional\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "      string {",
    "        match-text \"acetylglucosamine\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } } ,",
    "    rule-type description ,",
    "    description \"Is longer than 100 characters. Remove descriptive phrases or",
    " synonyms from product names. Keep valid long product names, eg long enzyme",
    " names\" ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \" Anopheles\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \" citochrome\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"cytochrome\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \" cytochome\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"cytochrome\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \" cytochorme\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"cytochrome\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"#\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type inappropriate-symbol ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"%\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type inappropriate-symbol ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"&apos\" ,",
    "        match-location contains ,",
    "        case-sensitive TRUE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type database ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"'\" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type inappropriate-symbol ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"()\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type inappropriate-symbol ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"(TC \" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type database ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \",\" ,",
    "        match-location ends ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type inappropriate-symbol ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \",\" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type inappropriate-symbol ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"-\" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type inappropriate-symbol ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"-\" ,",
    "        match-location ends ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type inappropriate-symbol ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \".\" ,",
    "        match-location ends ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type inappropriate-symbol ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \".\" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type inappropriate-symbol ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \". \" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type inappropriate-symbol ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \".,\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type inappropriate-symbol ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"./\" ,",
    "        match-location contains ,",
    "        case-sensitive TRUE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type inappropriate-symbol ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"/\" ,",
    "        match-location ends ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type inappropriate-symbol ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"16S ribosomal RNA\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            word \"16S\" ,",
    "            synonyms {",
    "              \"18S\" ,",
    "              \"28S\" ,",
    "              \"5S\" ,",
    "              \"5.8S\" ,",
    "              \"23S\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    description \"equals ribosomal RNA\" ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"16S rRNA\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            word \"16S\" ,",
    "            synonyms {",
    "              \"18S\" ,",
    "              \"28S\" ,",
    "              \"5S\" ,",
    "              \"5.8S\" ,",
    "              \"23S\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    description \"equals rRNA\" ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \":\" ,",
    "        match-location ends ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type inappropriate-symbol ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \":\" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type inappropriate-symbol ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \";\" ,",
    "        match-location contains ,",
    "        case-sensitive TRUE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type description ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"=\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type inappropriate-symbol ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"?\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type inappropriate-symbol ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"@\" ,",
    "        match-location contains ,",
    "        case-sensitive TRUE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type inappropriate-symbol ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"a \" ,",
    "        match-location starts ,",
    "        case-sensitive TRUE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type description ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"ABC-type polysaccharide\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"accessroy\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"accessory\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"aceytltranferase\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"acetyltransferase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"adenine\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"adenylattransferase\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"adenylate transferase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"adenylytransferase\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"adenylyltransferase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"ADP\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Agrobacterium\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Alanine\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"alchohol\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"alcohol\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"alpha\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"alpha-1\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"alternate gene name\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type description ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"alternate name\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type description ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"alternate protein name\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"alternate protein name\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    feat-constraint {",
    "      string {",
    "        match-text \"alternative protein name\" ,",
    "        match-location equals ,",
    "        case-sensitive TRUE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } } ,",
    "    rule-type description ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"aluminium\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type british ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"aluminum\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"amino acid\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"aminomutaseaminotransferase\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"aminomutase aminotransferase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"aminotransferasee\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"aminotransferase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"aminotransferease\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"aminotransferase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"aminotransferease\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"aminotransferase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"analog\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type evolutionary-relationship ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"and related enzyme\" ,",
    "        match-location ends ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type description ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"and related enzymes\" ,",
    "        match-location ends ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type description ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"and related protein\" ,",
    "        match-location ends ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type description ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"and related proteins\" ,",
    "        match-location ends ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type description ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"animal\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"anion\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"aparaginase\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"asparaginase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Arabidopsis\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Archaeal\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"archael\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"archaeal\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"arginin \" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"arginine \" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Arginine\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"argininte\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"arginine\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Asparagine\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"asparate\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"aspartate\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Aspartic acid\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"aspartyl\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Aspergillus\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"assemby\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"assembly\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"assessory\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"accessory\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"ATP\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"ATPas\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"ATPase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"aureus\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"authentic point mutation\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type might-be-nonfunctional ,",
    "    fatal TRUE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"B.subtilis\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Bacilllus\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Bacillus\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Bacterioides\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"bacteriophage\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Bacteroides\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"barrel\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"believed\" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"bifuctional\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"bifunctional\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"bifunctional\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"bifunctionnal\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"bifunctional\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"bigenesis\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"biogenesis\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"binds\" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"bioin\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"biotin\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"biosyntesis\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"biosynthesis\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"biosythesis\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"biosynthesis\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"bis\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"bnding\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"binding\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Bombyx\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"bos taurus\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"c-terminal domain protein\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"C-terminus\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"calchone\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"chalcone\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Calcium\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Campylobacter\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Candida\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"candidate\" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    feat-constraint {",
    "      string {",
    "        match-text \"candidate protein\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"putative\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"carbon\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"carboxilic\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"carboxylic\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"catalize\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"catalyze\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"CBS domain pair\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"CDS\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type description ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"cell divisionFtsK/SpoIIIE\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"cell division FtsK/SpoIIIE\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"cerevisiae\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Changed start to match that seen in other orgs\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Changed start to match that seen in other orgs\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"characteris\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"characteriz\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"charateriz\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"characteriz\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"CHC2 zinc finger\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"CHC2 zinc finger protein\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative TRUE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"chelatin\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"chelating\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Chlamydial\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Chlamydomonas\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"chlorAMPhenicol\" ,",
    "        match-location contains ,",
    "        case-sensitive TRUE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"chloramphenicol \" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"chloroplastic\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"chroamtid\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"chromatid\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"citrate\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"claster\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"cluster\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"clustered with\" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"coantaining\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"containing\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"coenzye\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"coenzyme\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"COG\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    except",
    "      string-constraint {",
    "        match-text \"COG\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type database ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"COG\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"COGnitor\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type description ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"coli\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    feat-constraint {",
    "      string {",
    "        match-text \"adenomatous polyposis coli \" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"colour\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type british ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"color\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"complete\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type inappropriate-symbol ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"compnent\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"component\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"componenet\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"component\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"componnent\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"component\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"conser\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"conserv\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"conserved\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Conservd\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"conserved\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"conserve\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"conserved\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"conserved domain protein\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"conserved hypothetical\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"conserved hypothetical domain protein\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"conserved hypothetical family protein\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"conserved hypothetical protein\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"conserved predicted domain protein\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"conserved predicted protein\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"conserved protein\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"conserved protein of unknown function\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"conserved putative protein\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Conserved subname: full\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Conserved with\" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"consevered\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"conserved\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"contain\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"containing\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"containg\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"containing\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"containing\" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"containinging\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"containing\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"contains\" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"contig\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type inappropriate-symbol ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"converved\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"conserved\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"coserved\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"conserved\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"cotaining\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"containing\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Critica\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type inappropriate-symbol ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Crystal Structure\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type inappropriate-symbol ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"CTP\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Cysteine\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"cytosine\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"database\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    feat-constraint {",
    "      string {",
    "        match-text \"no significant database hits\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } } ,",
    "    rule-type database ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"degration\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"degradation\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"deletion\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type might-be-nonfunctional ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"dependant\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"dependent\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"deulfurase\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"desulfurase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"deydrogenase\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"dehydrogenase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"di\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"diacyglycerol\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"diacylglycerol\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"dimerisation\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type british ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"dimerization\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"dimerising\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type british ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"dimerizing\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"dioxyenase\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"dioxygenase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"dipeptide\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"disulphide\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"disulfide\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"divison\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"division\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"DNA\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"DNA for\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type inappropriate-symbol ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"domain\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"domain 1\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"domain domain\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"domain\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"domain family\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"domain of unknown function\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"domain of unknown function\" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    feat-constraint {",
    "      string {",
    "        match-text \"domain of unknown function\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "      string {",
    "        match-text \"domain of unknown function family protein\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "      string {",
    "        match-text \"domain of unknown function protein\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"protein of unknown function\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative TRUE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"domain of unknown function family protein\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"domain of unknown function family protein\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"domain of unknown function protein\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"domain protein\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"domain protein domain protein\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"domain protein\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"domain-containing protein\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"domainl\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"domain\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"domian\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"domain\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"doubtful\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type might-be-nonfunctional ,",
    "    fatal TRUE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"doubtful CDS found within S. typhi pathogenicity island\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Drosophila\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"DUF\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    except",
    "      string-constraint {",
    "        match-text \"DUF\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type database ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"DUF\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"dyhydrogenase\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"dihydrogenase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"dyhydrogenase\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"dehydrogenase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"E.coli\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"ECOLI\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"enentioselective\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"enantioselective\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"enterica\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"enzymye\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"enzyme\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"ErfKYbiSYcfSYnhG\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"ErfK/YbiS/YcfS/YnhG\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Escherichia\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"EST\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"EST\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    except",
    "      string-constraint {",
    "        match-text \"EST\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type database ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"et al\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct TRUE ,",
    "        ignore-words {",
    "          {",
    "            word \"et al\" ,",
    "            synonyms {",
    "              \"unpublished\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } ,",
    "          {",
    "            word \"et al\" ,",
    "            synonyms {",
    "              \"citation\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } ,",
    "          {",
    "            word \"et al\" ,",
    "            synonyms {",
    "              \"published\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    except",
    "      string-constraint {",
    "        match-text \"resuscitation\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type database ,",
    "    description \"may contain publication reference\" ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"evidenced by\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type description ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"exporte\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"exported\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"expressed\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"expressed protein\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"facotr\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"factor\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"factor\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"faecal\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type british ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"fecal\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"fagella\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"flagella\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"faimily\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"family\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"faimly\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"family\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"familie\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"family\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"familiy\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"family\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"family\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"family family\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"family\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"family protein\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"fibre\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type british ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"fiber\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"finger\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"flageller\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"flagellar\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"FOG\" ,",
    "        match-location contains ,",
    "        case-sensitive TRUE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type database ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"formly\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"formyl\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Fragment\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type might-be-nonfunctional ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"frame\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    feat-constraint {",
    "      string {",
    "        match-text \"frame shift\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } } ,",
    "    rule-type might-be-nonfunctional ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"frame shift\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type might-be-nonfunctional ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"frameshift\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    feat-constraint {",
    "      string {",
    "        match-text \"programmed frameshift\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } } ,",
    "    rule-type might-be-nonfunctional ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"from\" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"funciton\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"function\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"function\" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type description ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"fungi\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"g:t\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"galactose\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"gambiae\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"gene\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type gene ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"genes\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type gene ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"genome\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    feat-constraint {",
    "      string {",
    "        match-text \"genome instability\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "      string {",
    "        match-text \"genome maintenance\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } } ,",
    "    rule-type inappropriate-symbol ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"ggdef\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Giardia\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"gIycerol\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"glycerol\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"glcosyl\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"glycosyl\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Glimmer\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type inappropriate-symbol ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"glucosainyl\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"glucosaminyl\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"glutamate\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Glutamic acid\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Glutamine\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"glutaminne\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"glutamine\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"glycin\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"glycine\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Glycine\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"glycolsyltransferase\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"glycosyltransferase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"glycosy\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"glucosyl\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"GMP\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"gp\" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    feat-constraint {",
    "      string {",
    "        match-text \"gph\" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "      string {",
    "        match-text \"GPI\" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "      string {",
    "        match-text \"GPN\" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "      string {",
    "        match-text \"GPH\" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } } ,",
    "    rule-type putative-typo ,",
    "    description \"may contain systematic gene product identifiers from phage\" ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"GTP\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"guanine\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"haem\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    feat-constraint {",
    "      string {",
    "        match-text \"archaemetzincin\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } } ,",
    "    rule-type british ,",
    "    replace {",
    "      replace-func",
    "        haem-replace \"haem\" ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"halophilus\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"heam\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        haem-replace \"haem\" ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"heavychain\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"heavy chain\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Helicobacter\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Helicoverpa\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"helium\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"helix\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"helix-turn-helix\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"helix-turn-helix protein\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative TRUE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hemaggltinin\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hemagglutinin\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hemelysin\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hemolysin\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hemoglobine\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hemoglobin\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hexapaptide\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hexapeptide\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hexpeptide\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hexapeptide\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"highly conserved\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type description ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"highly similar\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type description ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"histadine\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"histidine\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"histide\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"histidine\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Histidine\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"homeserine\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"homoserine\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"homlog\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"homolog\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"homo\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"homo sapiens\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"homocystein\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"homocysteine\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Homolog\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type evolutionary-relationship ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Homologue\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type evolutionary-relationship ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"horikoshii\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hpothetical\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"human\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hy0\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hydolase\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hydrolase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hydrogen\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hydrolas\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hydrolase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hydrolases of the alpha/beta superfamily\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hydrolase of the alpha/beta superfamily\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hyopothetical\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hyopthetical\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hyothetical\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hyp domain protein\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hyperthetical\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hyphotetical\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hyphotheical\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hyphothetical\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hypo\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hypohetical\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hypot\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hypotehtical\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hypotethical\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hypotetical\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hypoth\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hypothe\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hypotheical\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hypotheitcal\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hypotherical\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hypothertical\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hypothet\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hypothetcial\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hypothethical\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hypotheti\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hypothetial\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hypothetic\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hypothetica\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hypothetical\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hypothetical\" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    feat-constraint {",
    "      string {",
    "        match-text \"hypothetical protein\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "      string {",
    "        match-text \"hypothetical domain protein\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "      string {",
    "        match-text \"hypothetical ORF\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "      string {",
    "        match-text \"hypothetical\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "      string {",
    "        match-text \"Hypothetical conserved protein\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "      string {",
    "        match-text \"hypothetical protein\" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "      string {",
    "        match-text \"UPF\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            word \"UPF\" ,",
    "            synonyms {",
    "              \"UCP\" ,",
    "              \"DUF\" ,",
    "              \"PUF\" ,",
    "              \"CHP\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word FALSE } } ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"putative\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hypothetical protein\" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    except",
    "      string-constraint {",
    "        match-text \"hypothetical protein\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type putative-typo ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Hypothetical protein gene\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space TRUE ,",
    "        ignore-punct TRUE ,",
    "        ignore-words {",
    "          {",
    "            word \"gene\" ,",
    "            synonyms {",
    "              \"sequence\" ,",
    "              \"partial sequence\" ,",
    "              \"complete sequence\" ,",
    "              \"partial\" ,",
    "              \"complete\" ,",
    "              \"gene sequence\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word FALSE } ,",
    "          {",
    "            word \"hypothetical\" ,",
    "            synonyms {",
    "              \"putative\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word FALSE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hypotheticala\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hypotheticalprotein\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hypotheticial\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hypotheticical\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hypotheticl\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hypotheticla\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hypothteical\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hypothtical\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hypoyhtetical\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hyppothetical\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hyprothetical\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hypthetical\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hyptohetical\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hyptothetcial\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hyptothetical\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hyputhetical\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"identity\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type description ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"immunoreactive\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"immunoreactive protein\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"inactivated derivative\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type description ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Includes:\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type description ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"incolved\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"involved\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"incomplete ORF\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    except",
    "      string-constraint {",
    "        match-text \"incomplete ORF domain protein\" ,",
    "        match-location equals ,",
    "        case-sensitive TRUE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type might-be-nonfunctional ,",
    "    fatal TRUE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"incomplete ORF domain protein\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"indepedent\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"independent\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"inductible\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"inducible\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"initation\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"initiation\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"inorganic phosphate\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"insertion sequence\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"insitol\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"inositol\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"intein C-terminal splicing region\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"intein N-terminal splicing region\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"interacts with\" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"internal repeat sequences detected\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"interrupt\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type might-be-nonfunctional ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Intiation\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"initiation\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"invertion\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"inversion\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"involved\" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"iron\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      prefix-and-numbers \"IS\" ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"IS ORF\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"IS protein\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative TRUE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"isation\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type british ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"ization\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Isoleucine\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"isomaerase\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"isomerase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"isomerse\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"isomerase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Jejuni\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"K potassium\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"potassium\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"K+ potassium\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"potassium\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"lacitehtopyh\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Leishmania\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Leucine\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"like\" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"likeity\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type description ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"likely\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type description ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"likely\" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"putative\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"liporotein\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"lipoprotein\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"listeria/Bacterioides\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"localisation\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type british ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"localization\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"localised\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type british ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"localized\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"localization of periplasmic protein complexes\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"located in\" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Low Quality Protein\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    feat-constraint {",
    "      string {",
    "        match-text \"LOW QUALITY PROTEIN:\" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } } ,",
    "    rule-type might-be-nonfunctional ,",
    "    fatal TRUE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Low Quality Protein: \" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Lysine\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"majour\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type british ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"major\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"malate\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Maltose\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"mambrane\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"membrane\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Marinococcus\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"meausure\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"measure\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"medated\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"mediated\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"mediates\" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"membrane\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"membrane protein of\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"membrane protein\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"membraneprotein\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"membrane protein\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"membranetransport\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"membrane transport\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"membranne\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"membrane\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"membtrane\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"membrane\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"memebrane\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"membrane\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Methionine\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"methlytransferase\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"methyltransferase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"metylase\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"methylase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"miscellaneous\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"miscellaneous\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    except",
    "      string-constraint {",
    "        match-text \"miscellaneous\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type description ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"mitchondrial\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"mitochondrial\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"mobilisation\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type british ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"mobilization\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"molibdenum\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"molybdenum\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"molybopterin\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"molybdopterin\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"molydopterin\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"molybdopterin\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"monooxigenase\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"monooxygenase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"monoxyde\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"monoxide\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"monoxygenase\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"monooxygenase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"mouse\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"mRNA\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"mulitdrug\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"multidrug\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"mulitfunction\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"multifunction\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"MULTISPECIES\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    feat-constraint {",
    "      string {",
    "        match-text \"MULTISPECIES:\" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } } ,",
    "    rule-type description ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"MULTISPECIES: \" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Mus musculus\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"mutatrotase\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"mutarotase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"mutlifunction\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"multifunction\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Mycobacterium\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"mycoplasma\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"mypothetical\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"mythylglyoxyl \" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"methylglyoxyl\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"n-terminal domain protein\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"N-terminus\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Na\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Na+\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"NAD\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"narrowly conserved\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type description ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"ncharacterized\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"uncharacterized\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"ncRNA\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"ndoribonuclease\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"endoribonuclease\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Neurospora\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Ni\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"nickle\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"nickel\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"niger\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"nitrogen\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Nmr solution\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type inappropriate-symbol ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"No definition line found\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type inappropriate-symbol ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"No definition line found\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"no function assigned\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"no likeity\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"no significant database hits\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"no significant database matches\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"no significant homology\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"no significant homology\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    except",
    "      string-constraint {",
    "        match-text \"no significant homology\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type description ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"novel\" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    feat-constraint {",
    "      string {",
    "        match-text \"novel protein\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"putative\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"novel\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    except",
    "      string-constraint {",
    "        match-text \"novel protein\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type description ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"ntegral \" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"integral \" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"nucear\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"nuclear\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"nucelar\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"nuclear\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"nucleotydyl\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"nucleotidyl\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"nucletide\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"nucleotide\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"nulcear\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"nuclear\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"nulceotide\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"nucleotide\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"null\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"o252\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"o252 protein\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"obalt\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"cobalt\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"observed by proteomics\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"odule\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"module\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"of\" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type inappropriate-symbol ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"open reading frame\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"open reading frame\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    feat-constraint {",
    "      string {",
    "        match-text \"open reading frame\" ,",
    "        match-location equals ,",
    "        case-sensitive TRUE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } } ,",
    "    rule-type might-be-nonfunctional ,",
    "    fatal TRUE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"ORF\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"orf, hyp\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"orf, hypothetical\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"organise\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type british ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"organize\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"orphan protein\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"orphan protein\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    feat-constraint {",
    "      string {",
    "        match-text \"orphan protein\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } } ,",
    "    rule-type might-be-nonfunctional ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"ortholog\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type evolutionary-relationship ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"orthologue\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type evolutionary-relationship ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Outative\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"putative\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"outers\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"outer\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Oxalate\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"oxidoreducatse\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"oxidoreductase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"oxidoreductase ()\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"oxidoreductase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"oxidoreductasee\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"oxidoreductase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"oxidoreductasse\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"oxidoreductase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"oxidoredutase\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"oxidoreductase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"oxidoreduxtase\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"oxidoreductase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"oxigenase\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"oxygenase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"oxydase\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"oxidase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"oxygen\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"p-loop\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"p-loop protein\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative TRUE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"paralog\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type evolutionary-relationship ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"paralogue\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type evolutionary-relationship ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"part\" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"partial\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type might-be-nonfunctional ,",
    "    fatal TRUE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"PASTA\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"PASTA protein\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative TRUE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"peptide\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"peptidodoglycan\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"peptidoglycan\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"peptidyl-prolyl cis-trans\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"periplamic\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"periplasmic\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"periplasmc\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"periplasmic\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"periplsmic\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"periplasmic\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Pestis\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"petidase\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"peptidase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"phage\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Phenylalanine\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"pheremone\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"pheromone\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"phophate\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"phosphate\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"phopho\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"phospho\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"phophoserine\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"phosphoserine\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"phoshate\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"phosphate\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"phospatase\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"phosphatase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"phosphateN\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"phosphate N\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"phosphatidyltransferse\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"phosphatidyltransferase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"phosphatransferase\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"phosphotransferase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"phosphopantethiene\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"phosphopantetheine\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"phosphotase\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"phosphatase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"plasmid\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"plasmid-like protein\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Plasmodium\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"polimerase\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"polymerase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"polymeris\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type british ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"polymeriz\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"pombe\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            word \"pombe\" ,",
    "            synonyms {",
    "              \"genitalium\" ,",
    "              \"leprae\" ,",
    "              \"crassa\" ,",
    "              \"ciliare\" ,",
    "              \"falciparum\" ,",
    "              \"fumigata\" ,",
    "              \"vinifera\" ,",
    "              \"lipolytica\" ,",
    "              \"ambisexualis\" ,",
    "              \"brasilense\" ,",
    "              \"carbonum\" ,",
    "              \"elegans\" ,",
    "              \"melanogaster\" ,",
    "              \"capricolum\" ,",
    "              \"pneumoniae\" ,",
    "              \"pseudotuberculosis\" ,",
    "              \"histolytica\" ,",
    "              \"influenzae\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word FALSE } } ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    description \"contains organism name\" ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"portein\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"protein\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Portein\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"protein\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"posible\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"possible\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"possible\" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    feat-constraint {",
    "      string {",
    "        match-text \"possible protein\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"putative\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"possibly\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type description ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"poteasome\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"proteasome\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"potein\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"protein\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"potential\" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    feat-constraint {",
    "      string {",
    "        match-text \"potential protein\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"putative\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"precurso\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"precursor\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"precursor\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"precusor\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"precursor\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"predicted\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"predicted\" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    feat-constraint {",
    "      string {",
    "        match-text \"predicted protein\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "      string {",
    "        match-text \"Predicted:\" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"putative\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Predicted:\" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"putative\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"predictedprotein\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"predicted protein\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"predictet\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"predicted\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"presursor\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"precursor\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"probabable\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"probable\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"probable\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"probable\" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    feat-constraint {",
    "      string {",
    "        match-text \"probable protein\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"putative\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"probable protein\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"probable putative\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"putative\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"probably\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type description ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"proein\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"protein\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Proline\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"proposed\" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    feat-constraint {",
    "      string {",
    "        match-text \"proposed protein\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"putative\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"proposed protein\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"proptein\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"protein\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"prortein\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"protein\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"protazoan\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"protozoan\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"protei\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"protein\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"protein\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    feat-constraint {",
    "      string {",
    "        match-text \"hypothetical protein\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "      string {",
    "        match-text \"uncharacterized protein\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"protein associated to\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type description ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"protein conserved in bacteria\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"protein containing\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"protein of\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"protein of unknown function\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"protein of unknown function, duf\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            word \"protein of unknown function, duf\" ,",
    "            synonyms {",
    "              \"protein of unknown function duf\" ,",
    "              \"domain of unknown function duf\" ,",
    "              \"domain of unknown function, duf\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"protein product\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"protein protein\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"protein\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Protein putative protein\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"protein, conserved\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"protein-containing\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"proteine\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"protein\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"proteinn\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"protein\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"proten\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"protein\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"protien\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"protein\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"protrein\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"protein\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"protwin\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"protein\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"prptein\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"protein\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"pseudo\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"pseudo\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type might-be-nonfunctional ,",
    "    fatal TRUE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"pseudogene\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"pseudogene\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type might-be-nonfunctional ,",
    "    fatal TRUE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"pseudomonas\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"ptotein\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"protein\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"PTS system\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"PTS system protein\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative TRUE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"puataive\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"putative\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"puatative\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"putative\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"puative\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"putative\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"purine\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"putaitive\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"putative\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"putaitve\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"putative\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"putaive\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"putative\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"putataive\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"putative\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"putatitve\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"putative\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"putativ\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"putative\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"putative\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"putative possible\" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    feat-constraint {",
    "      string {",
    "        match-text \"possible protein\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"putative\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"putative potential\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"putative\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"putative potential\" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    feat-constraint {",
    "      string {",
    "        match-text \"possible protein\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"putative\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"putative predicted\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"putative\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"putative probable\" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    feat-constraint {",
    "      string {",
    "        match-text \"possible protein\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"putative\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"putative probable\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"putative\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"putative putative\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"putative\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"putative uncharacterized\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"putative, putative\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"putative\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"putativie\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"putative\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"putatuive\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"putative\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"putatuve\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"putative\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"putatve\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"putative\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"putatvie\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"putative\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"putayive\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"putative\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"puter\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"outer\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"putitative\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"putative\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"putitive\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"putative\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"puttive\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"putative\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"pylori\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"pyradoxal\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"pyridoxal\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Pyrococcus\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"pyruvyltransferase\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"pyruvyl transferase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"qlcohol\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"alcohol\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"ranscriptional\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"transcriptional\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"rat\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"raw score\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    feat-constraint {",
    "      string {",
    "        match-text \"raw score\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } } ,",
    "    rule-type inappropriate-symbol ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"raw score\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"recognised\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"recognized\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"reductasee\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"reductase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"region\" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"regulates\" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type description ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"regulatot\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"regulator\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"reguratory\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"regulatory\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Related\" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"remnant\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type might-be-nonfunctional ,",
    "    fatal TRUE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"reolvase\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"resolvase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"repeat\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"repeatl\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"repeat\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"replicaiton\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"replication\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"reponse\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"response\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"resistence\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"resistance\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Rhodobacter\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"ribomal\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"ribosomal\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"ribonuleotide\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"ribonucleotide\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"ribosimal\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"ribosomal\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"ribosomal RNA\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"ribosoml\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"ribosomal\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"ribossomal\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"ribosomal\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"rickettsia\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"riobosyltransferase\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"ribosyltransferase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"RNA\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"RNA for\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type inappropriate-symbol ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"rRNA\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"rsponse\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"response\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Salmonella\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"sapiens\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"secreted\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Serine\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"serinr\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"serine\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"serovar\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"shotgun\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type inappropriate-symbol ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"shrot\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"short\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"shrot-chain\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"short-chain\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"shutting\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"shuttling\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"shuttlingfactor\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"shuttling factor\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"signal\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"signal peptide\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"signal peptide protein\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative TRUE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"signalling\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"signaling\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"similar\" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"similiar\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"similar\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"simmilar\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"similar\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"siphovirus\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"sodium\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"solution Nmr\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type inappropriate-symbol ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"solution structure\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type inappropriate-symbol ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"specfic\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"specific\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"specific\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"sphaeroides\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Spodoptera\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"spscific\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"specific\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"sreptomyces\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"stabilisation\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"stabilization\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Staphlococcal\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Staphlococcus\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"staphylococcal\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Staphylococcus\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"start codon\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type might-be-nonfunctional ,",
    "    fatal TRUE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"streptococcal\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Streptococcus\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"streptomyces\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"strongly conserved\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type description ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"strongly similar\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type description ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"structual\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"structural\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"structure of\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type inappropriate-symbol ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"subitilus\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"subnit\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"subunit\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"subsp\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Subtilis\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"subunit\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"sugar\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"suger\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"sugar\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"sulfer\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"sulfur\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"sulphate\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type british ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"sulfate\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"sulphide\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type british ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"sulfide\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"sulpho\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"sulfo\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"sulphur\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"sulfur\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"SWIM zinc finger\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"SWIM zinc finger protein\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative TRUE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"systhesis\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"synthesis\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"sythase\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"synthase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"tetracenpmycin\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"tetracenomycin\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"thaliana\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"thiamin/thiamin\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"thiamin/thiamine\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"thiamineS\" ,",
    "        match-location contains ,",
    "        case-sensitive TRUE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"thiamine S\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"thioderoxin\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"thioredoxin\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"thiredoxin\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"thioredoxin\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"threonin\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"threonine\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Threonine\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"thymine\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"TPA:\" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type database ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"TPA_inf\" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"trancription\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"transcription\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"trancsriptional\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"transcription\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"tranferase\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"transferase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"tranporter\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"transporter\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"transcirbed\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"transcribed\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"transcirption\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"transcription\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"transcripitonal\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"transcriptional\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"transcrIpt\" ,",
    "        match-location contains ,",
    "        case-sensitive TRUE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"transcript\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"transcriptionnal \" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"transcriptional\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"transcriptonal\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"transcriptional\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"transcritional\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"transcriptional\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"transebrane\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"transmembrane\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"transemembrane\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"transmembrane\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Transemembrane\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"transmembrane\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"transerfase\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"transferase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"transferasee\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"transferase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"transglycolase\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"transglycosylase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Transmebrane\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"transmembrane\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"transmebrane\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"transmembrane\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"transmemembrane\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"transmembrane\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"transorter\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"transporter\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"transpoase\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"transposase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"transport-associated\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"transport-associated protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"transportor\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"transporter\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"transposase and inactivated derivative\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"transposase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"transposase and inactivated derivatives\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"transposase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"transposase and inactive derivative\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"transposase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"transposase and inactive derivatives\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"transposase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"transposase of\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"transposase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative TRUE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"transposase transposase\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"transposase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"transposases and inactivated derivative\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"transposase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"transposases and inactivated derivatives\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"transposase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"transposases and inactive derivative\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"transposase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"transposases and inactive derivatives\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"transposase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"transposon\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"transproter\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"transporter\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"transulfuration\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"transsulfuration\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"trasnferase\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"transferase\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"trasporter\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"transporter\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"tRNA\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"trnasporter\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"transporter\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"truncat\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type might-be-nonfunctional ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"trunucated\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"truncated\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Tryptophan\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"ttg start\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"ttg start\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    feat-constraint {",
    "      string {",
    "        match-text \"ttg start codon\" ,",
    "        match-location equals ,",
    "        case-sensitive TRUE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } } ,",
    "    rule-type description ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Tuberculosis\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"tumefaciens\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"tumour\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type british ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"tumor\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Type II\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Typhimurium\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"typr\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"type\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Tyrosine\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"uknown\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"uncharacterizaed\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"uncharacterized\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"uncharacterized\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"uncharacterized\" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    feat-constraint {",
    "      string {",
    "        match-text \"uncharacterized protein\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "      string {",
    "        match-text \"uncharacterized protein conserved in bacteria\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "      string {",
    "        match-text \"uncharacterized conserved protein\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "      string {",
    "        match-text \"uncharacterized\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "      string {",
    "        match-text \"uncharacterized domain 1\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "      string {",
    "        match-text \"uncharacterized protein\" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "      string {",
    "        match-text \"UPF\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            word \"UPF\" ,",
    "            synonyms {",
    "              \"UCP\" ,",
    "              \"DUF\" ,",
    "              \"PUF\" ,",
    "              \"CHP\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word FALSE } } ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"putative\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"unclassified\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"undecapaprenyl\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"undecaprenyl\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"undefined product\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"undefined product\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    feat-constraint {",
    "      string {",
    "        match-text \"undefined product\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } } ,",
    "    rule-type database ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"unique\" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    feat-constraint {",
    "      string {",
    "        match-text \"unique protein\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"putative\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"unkn\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"unknow protein\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"unknown\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"unknown\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    feat-constraint {",
    "      field {",
    "        field",
    "          feature-field {",
    "            type cds ,",
    "            field",
    "              legal-qual product } ,",
    "        string-constraint {",
    "          match-text \"protein of unknown function\" ,",
    "          match-location contains ,",
    "          case-sensitive FALSE ,",
    "          ignore-space FALSE ,",
    "          ignore-punct FALSE ,",
    "          whole-word FALSE ,",
    "          not-present TRUE ,",
    "          is-all-caps FALSE ,",
    "          is-all-lower FALSE ,",
    "          is-all-punct FALSE ,",
    "          ignore-weasel FALSE ,",
    "          is-first-cap FALSE ,",
    "          is-first-each-cap FALSE } } ,",
    "      field {",
    "        field",
    "          feature-field {",
    "            type cds ,",
    "            field",
    "              legal-qual product } ,",
    "        string-constraint {",
    "          match-text \"domain of unknown function\" ,",
    "          match-location contains ,",
    "          case-sensitive FALSE ,",
    "          ignore-space FALSE ,",
    "          ignore-punct FALSE ,",
    "          whole-word FALSE ,",
    "          not-present TRUE ,",
    "          is-all-caps FALSE ,",
    "          is-all-lower FALSE ,",
    "          is-all-punct FALSE ,",
    "          ignore-weasel FALSE ,",
    "          is-first-cap FALSE ,",
    "          is-first-each-cap FALSE } } ,",
    "      string {",
    "        match-text \"unknown\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "      string {",
    "        match-text \"unknown protein\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } } ,",
    "    rule-type might-be-nonfunctional ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"unknown domain\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"unknown function\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"unknown protein\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"unkown\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"unknown\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"unnamed\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"unnamed\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    feat-constraint {",
    "      string {",
    "        match-text \"unnamed\" ,",
    "        match-location equals ,",
    "        case-sensitive TRUE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present TRUE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } } ,",
    "    rule-type description ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"unnamed protein product\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"unspecified product\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"unusual protein\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"UPF\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"UPF\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    except",
    "      string-constraint {",
    "        match-text \"UPF\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type database ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"uracil\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"utilisation\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type british ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"utilization\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"utilising\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type british ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"utilizing\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"UTP\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Valine\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"vigtamin\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"vitamin\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"weakly conserved\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type description ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"widely conserved\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type description ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"xanthine\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"xenopus\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"xray structure\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type inappropriate-symbol ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"yeast\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"YeeEYedE\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"YeeE/YedE\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"Yersinia\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type remove-organism-name ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"YjgPYjgQ\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"YjgP/YjgQ\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"ypothetical\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"ysine\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"lysine\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"ytochrome\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"cytochrome\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"yypothetical\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"zinc\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        ignore-words {",
    "          {",
    "            synonyms {",
    "              \"probable\" ,",
    "              \"putative\" ,",
    "              \"hypothetical\" } ,",
    "            case-sensitive FALSE ,",
    "            whole-word TRUE } } ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note TRUE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"zinc finger\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"zinc finger protein\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative TRUE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"\\\" ,",
    "        match-location ends ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type inappropriate-symbol ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"\\\\-PA\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type inappropriate-symbol ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"_\" ,",
    "        match-location ends ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type inappropriate-symbol ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      underscore NULL ,",
    "    rule-type database ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"|\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type inappropriate-symbol ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"familly\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"family\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hypotheitical\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hypopthetical\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"hypothetetical\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"no product string in file\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type none ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"distantly\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"protein distantly\" ,",
    "        match-location equals ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type hypothetical ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"hypothetical protein\" ,",
    "          whole-string TRUE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"ifunctional \" ,",
    "        match-location starts ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word FALSE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"bifunctional \" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"refseq\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct TRUE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel TRUE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type none ,",
    "    fatal TRUE } ,",
    "  {",
    "    find",
    "      string-constraint {",
    "        match-text \"casette\" ,",
    "        match-location contains ,",
    "        case-sensitive FALSE ,",
    "        ignore-space FALSE ,",
    "        ignore-punct FALSE ,",
    "        whole-word TRUE ,",
    "        not-present FALSE ,",
    "        is-all-caps FALSE ,",
    "        is-all-lower FALSE ,",
    "        is-all-punct FALSE ,",
    "        ignore-weasel FALSE ,",
    "        is-first-cap FALSE ,",
    "        is-first-each-cap FALSE } ,",
    "    rule-type typo ,",
    "    replace {",
    "      replace-func",
    "        simple-replace {",
    "          replace \"cassette\" ,",
    "          whole-string FALSE ,",
    "          weasel-to-putative FALSE } ,",
    "      move-to-note FALSE } ,",
    "    fatal FALSE } }"
};
