/*  $Id: accguide2.inc 684361 2024-06-20 19:31:00Z ivanov $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  Aaron Ucko
 *
 * File Description:
 *   Built-in copy of accguide2.txt.
 *
 */

/* time_t value corresponding to Wed Jun 12 13:27:59 EDT 2024; formally
 * expressed as unsigned long so output can stand fully on its own. */
static const unsigned long kBuiltInGuide_Timestamp = 1718213279UL;
static const char* const kBuiltInGuide[] = {
    "# $Id: accguide2.inc 684361 2024-06-20 19:31:00Z ivanov $",
    "version  2 # of file format",
    "",
    "# three-letter-prefix protein accessions (traditionally with five digits)",
    "3+5  AAE  gb_patent_prot",
    "3+5  ??_  unknown # Longer variants (6-9 digits as of June 2018) are RefSeq",
    "3+5  A??  gb_prot",
    "3+7  A??  gb_prot",
    "3+9  A??  gb_prot",
    "3+11 A??  gb_prot",
    "3+5  B??  ddbj_prot",
    "3+7  B??  ddbj_prot",
    "3+9  B??  ddbj_prot",
    "3+11 B??  ddbj_prot",
    "3+5  C??  embl_prot *",
    "3+7  C??  embl_prot *",
    "3+9  C??  embl_prot",
    "3+11 C??  embl_prot",
    "3+5  D??  gb_tpa_prot *",
    "3+7  D??  gb_tpa_prot",
    "3+9  D??  gb_tpa_prot",
    "3+11 D??  gb_tpa_prot",
    "3+5  E??  gb_wgs_prot",
    "3+7  E??  gb_wgsv_prot",
    "3+9  E??  gb_prot",
    "3+11 E??  gb_prot",
    "3+5  F??  ddbj_tpa_prot",
    "3+7  F??  ddbj_tpa_prot",
    "3+9  F??  ddbj_tpa_prot",
    "3+11 F??  ddbj_tpa_prot",
    "3+5  G??  ddbj_wgs_prot",
    "3+7  G??  ddbj_prot",
    "3+9  G??  ddbj_prot",
    "3+11 G??  ddbj_prot",
    "3+5  H??  gb_tpa_wgsv_prot",
    "3+7  H??  gb_tpa_wgsv_prot",
    "3+9  H??  gb_tpa_prot",
    "3+11 H??  gb_tpa_prot",
    "3+5  I??  ddbj_tpa_tsa_prot",
    "3+7  I??  ddbj_tpa_prot",
    "3+9  I??  ddbj_tpa_prot",
    "3+11 I??  ddbj_tpa_prot",
    "3+5  J??  gb_tsa_prot",
    "3+7  J??  gb_prot",
    "3+9  J??  gb_prot",
    "3+11 J??  gb_prot",
    "3+5  K??  gb_wgs_prot",
    "3+7  K??  gb_wgs_prot",
    "3+9  K??  gb_prot",
    "3+11 K??  gb_prot",
    "3+5  L??  ddbj_prot # mixed TSA and TLS",
    "3+7  L??  ddbj_prot",
    "3+9  L??  ddbj_prot",
    "3+11 L??  ddbj_prot",
    "3+5  M??  gb_wgsv_prot",
    "3+7  M??  gb_wgsv_prot",
    "3+9  M??  gb_prot",
    "3+11 M??  gb_prot",
    "3+5  N??  gb_wgsv_prot",
    "3+7  N??  gb_wgsv_prot",
    "3+9  N??  gb_prot",
    "3+11 N??  gb_prot",
    "3+5  O??  gb_wgs_prot",
    "3+7  O??  gb_prot",
    "3+9  O??  gb_prot",
    "3+11 O??  gb_prot",
    "3+5  P??  gb_wgs_prot",
    "3+7  P??  gb_prot",
    "3+9  P??  gb_prot",
    "3+11 P??  gb_prot",
    "3+5  Q??  gb_prot",
    "3+7  Q??  gb_prot",
    "3+9  Q??  gb_prot",
    "3+11 Q??  gb_prot",
    "3+5  R??  gb_wgs_prot",
    "3+7  R??  gb_prot",
    "3+9  R??  gb_prot",
    "3+11 R??  gb_prot",
    "3+5  S??  embl_prot *",
    "3+7  S??  embl_prot",
    "3+9  S??  embl_prot",
    "3+11 S??  embl_prot",
    "3+5  T??  gb_wgs_prot",
    "3+7  T??  gb_prot",
    "3+9  T??  gb_prot",
    "3+11 T??  gb_prot",
    "3+5  U??  gb_prot",
    "3+7  U??  gb_prot",
    "3+9  U??  gb_prot",
    "3+11 U??  gb_prot",
    "3+5  V??  embl_prot *",
    "3+7  V??  embl_prot",
    "3+9  V??  embl_prot",
    "3+11 V??  embl_prot",
    "3+5  W??  gb_prot",
    "3+7  W??  gb_prot",
    "3+9  W??  gb_prot",
    "3+11 W??  gb_prot",
    "3+5  X??  gb_prot",
    "3+7  X??  gb_prot",
    "3+9  X??  gb_prot",
    "3+11 X??  gb_prot",
    "3+5  ???  unreserved_prot",
    "3+7  ???  unreserved_prot",
    "3+9  ???  unreserved_prot",
    "3+11 ???  unreserved_prot",
    "",
    "# Genome pipeline accessions",
    "4+9  GPC_  gpipe_chromosome",
    "4+9  GPG_  gpipe_genomic",
    "4+9  GPM_  gpipe_mrna",
    "4+9  GPN_  gpipe_other_nuc",
    "4+9  GPP_  gpipe_prot",
    "4+9  GPR_  gpipe_ncrna",
    "4+9  GPS_  gpipe_scaffold",
    "4+9  ZPC_  gpipe_chromosome",
    "4+9  ZPG_  gpipe_genomic",
    "4+9  ZPM_  gpipe_mrna",
    "4+9  ZPN_  gpipe_other_nuc",
    "4+9  ZPP_  gpipe_prot",
    "4+9  ZPR_  gpipe_ncrna",
    "4+9  ZPS_  gpipe_scaffold",
    "4+9  GP?_  gpipe_unreserved",
    "4+9  ZP?_  gpipe_unreserved",
    "",
    "# whole genome shotgun accessions",
    "4+8   ???_    unknown",
    "4+9   ???_    unknown",
    "4+10  ???_    unknown",
    "4+8   A???    gb_wgs_nuc",
    "4+9   A???    gb_wgs_nuc",
    "4+10  A???    gb_wgs_nuc",
    "4+8   B???    ddbj_wgs_nuc",
    "4+9   B???    ddbj_wgs_nuc",
    "4+10  B???    ddbj_wgs_nuc",
    "4+8   C???    embl_wgs_nuc",
    "4+9   C???    embl_wgs_nuc",
    "4+10  C???    embl_wgs_nuc",
    "4+8   D???    gb_tpa_wgs_nuc",
    "4+9   D???    gb_tpa_wgs_nuc",
    "4+10  D???    gb_tpa_wgs_nuc",
    "4+8   E???    ddbj_tpa_wgs_nuc",
    "4+9   E???    ddbj_tpa_wgs_nuc",
    "4+10  E???    ddbj_tpa_wgs_nuc",
    "4+8   F???    embl_wgs_nuc",
    "4+9   F???    embl_wgs_nuc",
    "4+10  F???    embl_wgs_nuc",
    "4+8   G???    gb_tsa_nuc",
    "4+9   G???    gb_tsa_nuc",
    "4+10  G???    gb_tsa_nuc",
    "4+8   H???    embl_tsa_nuc *",
    "4+9   H???    embl_tsa_nuc",
    "4+10  H???    embl_tsa_nuc",
    "4+8   I???    ddbj_tsa_nuc",
    "4+9   I???    ddbj_tsa_nuc",
    "4+10  I???    ddbj_tsa_nuc",
    "4+8   J???    gb_wgs_nuc",
    "4+9   J???    gb_wgs_nuc",
    "4+10  J???    gb_wgs_nuc",
    "4+8   K???    gb_targeted_nuc",
    "4+9   K???    gb_targeted_nuc",
    "4+10  K???    gb_targeted_nuc",
    "4+8   L???    gb_wgs_nuc",
    "4+9   L???    gb_wgs_nuc",
    "4+10  L???    gb_wgs_nuc",
    "4+8   M???    gb_wgs_nuc # gb_tsa_nuc?",
    "4+9   M???    gb_wgs_nuc # gb_tsa_nuc?",
    "4+10  M???    gb_wgs_nuc # gb_tsa_nuc?",
    "4+8   N???    gb_wgs_nuc # gb_tsa_nuc?",
    "4+9   N???    gb_wgs_nuc # gb_tsa_nuc?",
    "4+10  N???    gb_wgs_nuc # gb_tsa_nuc?",
    "4+8   O???    embl_wgs_nuc",
    "4+9   O???    embl_wgs_nuc",
    "4+10  O???    embl_wgs_nuc",
    "4+8   P???    gb_wgs_nuc",
    "4+9   P???    gb_wgs_nuc",
    "4+10  P???    gb_wgs_nuc",
    "4+8   Q???    gb_wgs_nuc",
    "4+9   Q???    gb_wgs_nuc",
    "4+10  Q???    gb_wgs_nuc",
    "4+8   R???    gb_wgs_nuc",
    "4+9   R???    gb_wgs_nuc",
    "4+10  R???    gb_wgs_nuc",
    "4+8   S???    gb_wgs_nuc",
    "4+9   S???    gb_wgs_nuc",
    "4+10  S???    gb_wgs_nuc",
    "4+8   T???    ddbj_targeted_nuc",
    "4+9   T???    ddbj_targeted_nuc",
    "4+10  T???    ddbj_targeted_nuc",
    "4+8   U???    embl_wgs_nuc",
    "4+9   U???    embl_wgs_nuc",
    "4+10  U???    embl_wgs_nuc",
    "4+8   V???    gb_wgs_nuc",
    "4+9   V???    gb_wgs_nuc",
    "4+10  V???    gb_wgs_nuc",
    "4+8   W???    gb_wgs_nuc",
    "4+9   W???    gb_wgs_nuc",
    "4+10  W???    gb_wgs_nuc",
    "4+8   X???    gb_wgs_nuc",
    "4+9   X???    gb_wgs_nuc",
    "4+10  X???    gb_wgs_nuc",
    "4+8   Y???    ddbj_tpa_tsa_nuc",
    "4+9   Y???    ddbj_tpa_tsa_nuc",
    "4+10  Y???    ddbj_tpa_tsa_nuc",
    "4+8   Z???    ddbj_tpa_targeted_nuc",
    "4+9   Z???    ddbj_tpa_targeted_nuc",
    "4+10  Z???    ddbj_tpa_targeted_nuc",
    "4+8   ????    unreserved_nuc",
    "4+9   ????    unreserved_nuc",
    "4+10  ????    unreserved_nuc",
    "6+9   ?????_  unknown",
    "6+10  ?????_  unknown",
    "6+11  ?????_  unknown",
    "6+9   A?????  gb_wgs_nuc",
    "6+10  A?????  gb_wgs_nuc",
    "6+11  A?????  gb_wgs_nuc",
    "6+9   B?????  ddbj_wgs_nuc",
    "6+10  B?????  ddbj_wgs_nuc",
    "6+11  B?????  ddbj_wgs_nuc",
    "6+9   C?????  embl_wgs_nuc *",
    "6+10  C?????  embl_wgs_nuc",
    "6+11  C?????  embl_wgs_nuc",
    "6+9   D?????  gb_tpa_wgs_nuc",
    "6+10  D?????  gb_tpa_wgs_nuc",
    "6+11  D?????  gb_tpa_wgs_nuc",
    "6+9   J?????  gb_wgs_nuc",
    "6+10  J?????  gb_wgs_nuc",
    "6+11  J?????  gb_wgs_nuc",
    "6+9   ??????  unreserved_nuc",
    "6+10  ??????  unreserved_nuc",
    "6+11  ??????  unreserved_nuc",
    "",
    "# Mass sequence Genome for Annotation",
    "5+7   A???? ddbj_other_nuc",
    "5+7   A???? ddbj_mga",
    "",
    "# Named annotation track (new as of September 2008)",
    "3+9  AT_  named_annot_track",
    "",
    "# NCBI reference sequence accessions",
    "3+6  AC_      refseq_chromosome",
    "3+6  AP_      refseq_prot",
    "3+6  NC_      refseq_chromosome",
    "3+6  NG_      refseq_genomic",
    "3+6  NM_      refseq_mrna",
    "3+9  NM_      refseq_mrna",
    "3+6  NP_      refseq_prot",
    "3+9  NP_      refseq_prot",
    "3+6  NR_      refseq_ncrna",
    "3+6  NS_      refseq_genome",
    "3+6  NT_      refseq_contig",
    "3+6  NW_      refseq_wgs_intermed",
    "3+9  NW_      refseq_wgs_intermed",
    "4+5  NZ_?     refseq_contig",
    "5+6  NZ_??    refseq_contig",
    "7+8  NZ_????  refseq_wgs_nuc",
    "7+9  NZ_????  refseq_wgs_nuc",
    "7+10 NZ_????  refseq_wgs_nuc",
    "9+9  NZ_?????? refseq_wgs_nuc",
    "9+10 NZ_?????? refseq_wgs_nuc",
    "9+11 NZ_?????? refseq_wgs_nuc",
    "3+9  WC_      refseq_chromosome_ncbo",
    "3+9  WP_      refseq_unique_prot",
    "3+9  WT_      refseq_contig_ncbo",
    "3+6  XM_      refseq_mrna_predicted",
    "3+9  XM_      refseq_mrna_predicted",
    "3+6  XP_      refseq_prot_predicted",
    "3+9  XP_      refseq_prot_predicted",
    "3+6  XR_      refseq_ncrna_predicted",
    "3+9  XR_      refseq_ncrna_predicted",
    "3+6  YP_      refseq_prot_predicted",
    "3+9  YP_      refseq_prot_predicted",
    "3+8  ZP_      refseq_wgs_prot",
    "3+6  ??_      refseq_unreserved",
    "3+7  ??_      refseq_unreserved",
    "3+8  ??_      refseq_unreserved",
    "3+9  ??_      refseq_unreserved",
    "",
    "# Unusually structured GenBank accessions",
    "4+6  MAP_  gb_optical_map",
    "",
    "# 6-character accessions (mixed, but generally nucleotide)",
    "1+5  A  embl_patent",
    "1+5  B  gb_gss",
    "1+5  C  ddbj_est *",
    "1+5  D  ddbj_dirsub *",
    "1+5  E  ddbj_patent",
    "1+5  F  embl_est *",
    "1+5  G  gb_sts",
    "1+5  H  gb_est",
    "1+5  I  gb_patent",
    "1+5  J  gsdb_dirsub",
    "1+5  K  gsdb_dirsub",
    "1+5  L  gsdb_dirsub *",
    "1+5  M  gsdb_dirsub *",
    "1+5  N  unreserved_nuc *",
    "1+5  O  swissprot",
    "1+5  P  swissprot",
    "1+5  Q  swissprot",
    "1+5  R  gb_est",
    "1+5  S  gb_backbone",
    "1+5  T  gb_est *",
    "1+5  U  gb_dirsub *",
    "1+5  V  embl_dirsub",
    "1+5  W  gb_est",
    "1+5  X  embl_dirsub *",
    "1+5  Y  embl_dirsub *",
    "1+5  Z  embl_dirsub *",
    "1+5  ?  unreserved_nuc",
    "",
    "# two-letter-prefix nucleotide accessions (traditionally with six digits)",
    "2+6  AA  gb_est",
    "2+8  AA  gb_other_nuc",
    "2+10 AA  gb_other_nuc",
    "2+6  AB  ddbj_dirsub *",
    "2+8  AB  ddbj_other_nuc",
    "2+10 AB  ddbj_other_nuc",
    "2+6  AC  gb_htgs",
    "2+8  AC  gb_other_nuc",
    "2+10 AC  gb_other_nuc",
    "2+6  AD  gb_gsdb",
    "2+8  AD  gb_other_nuc",
    "2+10 AD  gb_other_nuc",
    "2+6  AE  gb_genome",
    "2+8  AE  gb_other_nuc",
    "2+10 AE  gb_other_nuc",
    "2+6  AF  gb_dirsub *",
    "2+8  AF  gb_other_nuc",
    "2+10 AF  gb_other_nuc",
    "2+6  AG  ddbj_gss *",
    "2+8  AG  ddbj_other_nuc",
    "2+10 AG  ddbj_other_nuc",
    "2+6  AH  gb_segset",
    "2+8  AH  gb_other_nuc",
    "2+10 AH  gb_other_nuc",
    "2+6  AI  gb_est",
    "2+8  AI  gb_other_nuc",
    "2+10 AI  gb_other_nuc",
    "2+6  AJ  embl_dirsub *",
    "2+8  AJ  embl_other_nuc",
    "2+10 AJ  embl_other_nuc",
    "2+6  AK  ddbj_mrna",
    "2+8  AK  ddbj_other_nuc",
    "2+10 AK  ddbj_other_nuc",
    "2+6  AL  embl_dirsub *",
    "2+8  AL  embl_other_nuc",
    "2+10 AL  embl_other_nuc",
    "2+6  AM  embl_dirsub *",
    "2+8  AM  embl_other_nuc",
    "2+10 AM  embl_other_nuc",
    "2+6  AN  embl_con",
    "2+8  AN  embl_other_nuc",
    "2+10 AN  embl_other_nuc",
    "2+6  AO  unreserved_nuc",
    "2+8  AO  unreserved_nuc",
    "2+10 AO  unreserved_nuc",
    "2+6  AP  ddbj_genome",
    "2+8  AP  ddbj_other_nuc",
    "2+10 AP  ddbj_other_nuc",
    "2+6  AQ  gb_gss",
    "2+8  AQ  gb_other_nuc",
    "2+10 AQ  gb_other_nuc",
    "2+6  AR  gb_patent",
    "2+8  AR  gb_other_nuc",
    "2+10 AR  gb_other_nuc",
    "2+6  AS  gb_other_nuc",
    "2+8  AS  gb_other_nuc",
    "2+10 AS  gb_other_nuc",
    "2+6  AT  ddbj_est",
    "2+8  AT  ddbj_other_nuc",
    "2+10 AT  ddbj_other_nuc",
    "2+6  AU  ddbj_est *",
    "2+8  AU  ddbj_other_nuc",
    "2+10 AU  ddbj_other_nuc",
    "2+6  AV  ddbj_est",
    "2+8  AV  ddbj_other_nuc",
    "2+10 AV  ddbj_other_nuc",
    "2+6  AW  gb_est",
    "2+8  AW  gb_other_nuc",
    "2+10 AW  gb_other_nuc",
    "2+6  AX  embl_patent *",
    "2+8  AX  embl_other_nuc",
    "2+10 AX  embl_other_nuc",
    "2+6  AY  gb_dirsub *",
    "2+8  AY  gb_other_nuc",
    "2+10 AY  gb_other_nuc",
    "2+6  AZ  gb_gss",
    "2+8  AZ  gb_other_nuc",
    "2+10 AZ  gb_other_nuc",
    "2+6  BA  ddbj_con",
    "2+8  BA  ddbj_other_nuc",
    "2+10 BA  ddbj_other_nuc",
    "2+6  BB  ddbj_est",
    "2+8  BB  ddbj_other_nuc",
    "2+10 BB  ddbj_other_nuc",
    "2+6  BC  gb_cdna",
    "2+8  BC  gb_other_nuc",
    "2+10 BC  gb_other_nuc",
    "2+6  BD  ddbj_patent",
    "2+8  BD  ddbj_other_nuc",
    "2+10 BD  ddbj_other_nuc",
    "2+6  BE  gb_est",
    "2+8  BE  gb_other_nuc",
    "2+10 BE  gb_other_nuc",
    "2+6  BF  gb_est",
    "2+8  BF  gb_other_nuc",
    "2+10 BF  gb_other_nuc",
    "2+6  BG  gb_est",
    "2+8  BG  gb_other_nuc",
    "2+10 BG  gb_other_nuc",
    "2+6  BH  gb_gss",
    "2+8  BH  gb_other_nuc",
    "2+10 BH  gb_other_nuc",
    "2+6  BI  gb_est",
    "2+8  BI  gb_other_nuc",
    "2+10 BI  gb_other_nuc",
    "2+6  BJ  ddbj_est",
    "2+8  BJ  ddbj_other_nuc",
    "2+10 BJ  ddbj_other_nuc",
    "2+6  BK  gb_tpa_nuc",
    "2+8  BK  gb_tpa_nuc",
    "2+10 BK  gb_tpa_nuc",
    "2+6  BL  gb_tpa_segset # Formally CON but not necessarily genomic",
    "2+8  BL  gb_tpa_nuc",
    "2+10 BL  gb_tpa_nuc",
    "2+6  BM  gb_est",
    "2+8  BM  gb_other_nuc",
    "2+10 BM  gb_other_nuc",
    "2+6  BN  embl_tpa_nuc",
    "2+8  BN  embl_tpa_nuc",
    "2+10 BN  embl_tpa_nuc",
    "2+6  BO  unreserved_nuc",
    "2+8  BO  unreserved_nuc",
    "2+10 BO  unreserved_nuc",
    "2+6  BP  ddbj_est",
    "2+8  BP  ddbj_other_nuc",
    "2+10 BP  ddbj_other_nuc",
    "2+6  BQ  gb_est",
    "2+8  BQ  gb_other_nuc",
    "2+10 BQ  gb_other_nuc",
    "2+6  BR  ddbj_tpa_nuc",
    "2+8  BR  ddbj_tpa_nuc",
    "2+10 BR  ddbj_tpa_nuc",
    "2+6  BS  ddbj_genome # chimp genomes, specifically",
    "2+8  BS  ddbj_other_nuc",
    "2+10 BS  ddbj_other_nuc",
    "2+6  BT  gb_cdna",
    "2+8  BT  gb_other_nuc",
    "2+10 BT  gb_other_nuc",
    "2+6  BU  gb_est",
    "2+8  BU  gb_other_nuc",
    "2+10 BU  gb_other_nuc",
    "2+6  BV  gb_sts",
    "2+8  BV  gb_other_nuc",
    "2+10 BV  gb_other_nuc",
    "2+6  BW  ddbj_est",
    "2+8  BW  ddbj_other_nuc",
    "2+10 BW  ddbj_other_nuc",
    "2+6  BX  embl_dirsub *",
    "2+8  BX  embl_other_nuc",
    "2+10 BX  embl_other_nuc",
    "2+6  BY  ddbj_est",
    "2+8  BY  ddbj_other_nuc",
    "2+10 BY  ddbj_other_nuc",
    "2+6  BZ  gb_gss",
    "2+8  BZ  gb_other_nuc",
    "2+10 BZ  gb_other_nuc",
    "2+6  CA  gb_est",
    "2+8  CA  gb_other_nuc",
    "2+10 CA  gb_other_nuc",
    "2+6  CB  gb_est",
    "2+8  CB  gb_other_nuc",
    "2+10 CB  gb_other_nuc",
    "2+6  CC  gb_gss",
    "2+8  CC  gb_other_nuc",
    "2+10 CC  gb_other_nuc",
    "2+6  CD  gb_est",
    "2+8  CD  gb_other_nuc",
    "2+10 CD  gb_other_nuc",
    "2+6  CE  gb_gss",
    "2+8  CE  gb_other_nuc",
    "2+10 CE  gb_other_nuc",
    "2+6  CF  gb_est",
    "2+8  CF  gb_other_nuc",
    "2+10 CF  gb_other_nuc",
    "2+6  CG  gb_gss",
    "2+8  CG  gb_other_nuc",
    "2+10 CG  gb_other_nuc",
    "2+6  CH  gb_con",
    "2+8  CH  gb_other_nuc",
    "2+10 CH  gb_other_nuc",
    "2+6  CI  ddbj_est",
    "2+8  CI  ddbj_other_nuc",
    "2+10 CI  ddbj_other_nuc",
    "2+6  CJ  ddbj_est",
    "2+8  CJ  ddbj_other_nuc",
    "2+10 CJ  ddbj_other_nuc",
    "2+6  CK  gb_est",
    "2+8  CK  gb_other_nuc",
    "2+10 CK  gb_other_nuc",
    "2+6  CL  gb_gss",
    "2+8  CL  gb_other_nuc",
    "2+10 CL  gb_other_nuc",
    "2+6  CM  gb_chromosome",
    "2+8  CM  gb_other_nuc",
    "2+10 CM  gb_other_nuc",
    "2+6  CN  gb_est",
    "2+8  CN  gb_other_nuc",
    "2+10 CN  gb_other_nuc",
    "2+6  CO  gb_est",
    "2+8  CO  gb_other_nuc",
    "2+10 CO  gb_other_nuc",
    "2+6  CP  gb_genome *",
    "2+8  CP  gb_other_nuc",
    "2+10 CP  gb_other_nuc",
    "2+6  CQ  embl_patent",
    "2+8  CQ  embl_other_nuc",
    "2+10 CQ  embl_other_nuc",
    "2+6  CR  embl_dirsub *",
    "2+8  CR  embl_other_nuc",
    "2+10 CR  embl_other_nuc",
    "2+6  CS  embl_patent",
    "2+8  CS  embl_other_nuc",
    "2+10 CS  embl_other_nuc",
    "2+6  CT  embl_dirsub *",
    "2+8  CT  embl_other_nuc",
    "2+10 CT  embl_other_nuc",
    "2+6  CU  embl_dirsub *",
    "2+8  CU  embl_other_nuc",
    "2+10 CU  embl_other_nuc",
    "2+6  CV  gb_est",
    "2+8  CV  gb_other_nuc",
    "2+10 CV  gb_other_nuc",
    "2+6  CW  gb_gss",
    "2+8  CW  gb_other_nuc",
    "2+10 CW  gb_other_nuc",
    "2+6  CX  gb_est",
    "2+8  CX  gb_other_nuc",
    "2+10 CX  gb_other_nuc",
    "2+6  CY  gb_genome",
    "2+8  CY  gb_other_nuc",
    "2+10 CY  gb_other_nuc",
    "2+6  CZ  gb_gss",
    "2+8  CZ  gb_other_nuc",
    "2+10 CZ  gb_other_nuc",
    "2+6  DA  ddbj_est",
    "2+8  DA  ddbj_other_nuc",
    "2+10 DA  ddbj_other_nuc",
    "2+6  DB  ddbj_est",
    "2+8  DB  ddbj_other_nuc",
    "2+10 DB  ddbj_other_nuc",
    "2+6  DC  ddbj_est",
    "2+8  DC  ddbj_other_nuc",
    "2+10 DC  ddbj_other_nuc",
    "2+6  DD  ddbj_patent",
    "2+8  DD  ddbj_other_nuc",
    "2+10 DD  ddbj_other_nuc",
    "2+6  DE  ddbj_gss *",
    "2+8  DE  ddbj_other_nuc",
    "2+10 DE  ddbj_other_nuc",
    "2+6  DF  ddbj_con",
    "2+8  DF  ddbj_other_nuc",
    "2+10 DF  ddbj_other_nuc",
    "2+6  DG  ddbj_con",
    "2+8  DG  ddbj_other_nuc",
    "2+10 DG  ddbj_other_nuc",
    "2+6  DH  ddbj_gss",
    "2+8  DH  ddbj_other_nuc",
    "2+10 DH  ddbj_other_nuc",
    "2+6  DI  ddbj_patent # from Korea",
    "2+8  DI  ddbj_other_nuc",
    "2+10 DI  ddbj_other_nuc",
    "2+6  DJ  ddbj_patent",
    "2+8  DJ  ddbj_other_nuc",
    "2+10 DJ  ddbj_other_nuc",
    "2+6  DK  ddbj_est",
    "2+8  DK  ddbj_other_nuc",
    "2+10 DK  ddbj_other_nuc",
    "2+6  DL  ddbj_patent",
    "2+8  DL  ddbj_other_nuc",
    "2+10 DL  ddbj_other_nuc",
    "2+6  DM  ddbj_patent",
    "2+8  DM  ddbj_other_nuc",
    "2+10 DM  ddbj_other_nuc",
    "2+6  DN  gb_est",
    "2+8  DN  gb_other_nuc",
    "2+10 DN  gb_other_nuc",
    "2+6  DO  unreserved_nuc",
    "2+8  DO  unreserved_nuc",
    "2+10 DO  unreserved_nuc",
    "2+6  DP  gb_htgs # HTG scaffolds; look like gb_con, but built on htgs parts",
    "2+8  DP  gb_other_nuc",
    "2+10 DP  gb_other_nuc",
    "2+6  DQ  gb_dirsub *",
    "2+8  DQ  gb_other_nuc",
    "2+10 DQ  gb_other_nuc",
    "2+6  DR  gb_est",
    "2+8  DR  gb_other_nuc",
    "2+10 DR  gb_other_nuc",
    "2+6  DS  gb_con *",
    "2+8  DS  gb_other_nuc",
    "2+10 DS  gb_other_nuc",
    "2+6  DT  gb_est",
    "2+8  DT  gb_other_nuc",
    "2+10 DT  gb_other_nuc",
    "2+6  DU  gb_gss",
    "2+8  DU  gb_other_nuc",
    "2+10 DU  gb_other_nuc",
    "2+6  DV  gb_est",
    "2+8  DV  gb_other_nuc",
    "2+10 DV  gb_other_nuc",
    "2+6  DW  gb_est",
    "2+8  DW  gb_other_nuc",
    "2+10 DW  gb_other_nuc",
    "2+6  DX  gb_gss",
    "2+8  DX  gb_other_nuc",
    "2+10 DX  gb_other_nuc",
    "2+6  DY  gb_est",
    "2+8  DY  gb_other_nuc",
    "2+10 DY  gb_other_nuc",
    "2+6  DZ  gb_patent",
    "2+8  DZ  gb_other_nuc",
    "2+10 DZ  gb_other_nuc",
    "2+6  EA  gb_patent",
    "2+8  EA  gb_other_nuc",
    "2+10 EA  gb_other_nuc",
    "2+6  EB  gb_est",
    "2+8  EB  gb_other_nuc",
    "2+10 EB  gb_other_nuc",
    "2+6  EC  gb_est",
    "2+8  EC  gb_other_nuc",
    "2+10 EC  gb_other_nuc",
    "2+6  ED  gb_gss",
    "2+8  ED  gb_other_nuc",
    "2+10 ED  gb_other_nuc",
    "2+6  EE  gb_est",
    "2+8  EE  gb_other_nuc",
    "2+10 EE  gb_other_nuc",
    "2+6  EF  gb_dirsub *",
    "2+8  EF  gb_other_nuc",
    "2+10 EF  gb_other_nuc",
    "2+6  EG  gb_est",
    "2+8  EG  gb_other_nuc",
    "2+10 EG  gb_other_nuc",
    "2+6  EH  gb_est",
    "2+8  EH  gb_other_nuc",
    "2+10 EH  gb_other_nuc",
    "2+6  EI  gb_gss",
    "2+8  EI  gb_other_nuc",
    "2+10 EI  gb_other_nuc",
    "2+6  EJ  gb_gss",
    "2+8  EJ  gb_other_nuc",
    "2+10 EJ  gb_other_nuc",
    "2+6  EK  gb_gss",
    "2+8  EK  gb_other_nuc",
    "2+10 EK  gb_other_nuc",
    "2+6  EL  gb_est",
    "2+8  EL  gb_other_nuc",
    "2+10 EL  gb_other_nuc",
    "2+6  EM  gb_con",
    "2+8  EM  gb_other_nuc",
    "2+10 EM  gb_other_nuc",
    "2+6  EN  gb_con",
    "2+8  EN  gb_other_nuc",
    "2+10 EN  gb_other_nuc",
    "2+6  EO  gb_other_nuc # allocated but left unused to avoid O/0 confusion",
    "2+8  EO  gb_other_nuc # allocated but left unused to avoid O/0 confusion",
    "2+10 EO  gb_other_nuc # allocated but left unused to avoid O/0 confusion",
    "2+6  EP  gb_con",
    "2+8  EP  gb_other_nuc",
    "2+10 EP  gb_other_nuc",
    "2+6  EQ  gb_con",
    "2+8  EQ  gb_other_nuc",
    "2+10 EQ  gb_other_nuc",
    "2+6  ER  gb_gss",
    "2+8  ER  gb_other_nuc",
    "2+10 ER  gb_other_nuc",
    "2+6  ES  gb_est",
    "2+8  ES  gb_other_nuc",
    "2+10 ES  gb_other_nuc",
    "2+6  ET  gb_gss",
    "2+8  ET  gb_other_nuc",
    "2+10 ET  gb_other_nuc",
    "2+6  EU  gb_dirsub *",
    "2+8  EU  gb_other_nuc",
    "2+10 EU  gb_other_nuc",
    "2+6  EV  gb_est",
    "2+8  EV  gb_other_nuc",
    "2+10 EV  gb_other_nuc",
    "2+6  EW  gb_est",
    "2+8  EW  gb_other_nuc",
    "2+10 EW  gb_other_nuc",
    "2+6  EX  gb_est",
    "2+8  EX  gb_other_nuc",
    "2+10 EX  gb_other_nuc",
    "2+6  EY  gb_est",
    "2+8  EY  gb_other_nuc",
    "2+10 EY  gb_other_nuc",
    "2+6  EZ  gb_tsa_nuc",
    "2+8  EZ  gb_other_nuc",
    "2+10 EZ  gb_other_nuc",
    "2+6  FA  gb_con",
    "2+8  FA  gb_other_nuc",
    "2+10 FA  gb_other_nuc",
    "2+6  FB  embl_patent",
    "2+8  FB  embl_other_nuc",
    "2+10 FB  embl_other_nuc",
    "2+6  FC  gb_est",
    "2+8  FC  gb_other_nuc",
    "2+10 FC  gb_other_nuc",
    "2+6  FD  gb_est",
    "2+8  FD  gb_other_nuc",
    "2+10 FD  gb_other_nuc",
    "2+6  FE  gb_est",
    "2+8  FE  gb_other_nuc",
    "2+10 FE  gb_other_nuc",
    "2+6  FF  gb_est",
    "2+8  FF  gb_other_nuc",
    "2+10 FF  gb_other_nuc",
    "2+6  FG  gb_est",
    "2+8  FG  gb_other_nuc",
    "2+10 FG  gb_other_nuc",
    "2+6  FH  gb_gss",
    "2+8  FH  gb_other_nuc",
    "2+10 FH  gb_other_nuc",
    "2+6  FI  gb_gss",
    "2+8  FI  gb_other_nuc",
    "2+10 FI  gb_other_nuc",
    "2+6  FJ  gb_dirsub *",
    "2+8  FJ  gb_other_nuc",
    "2+10 FJ  gb_other_nuc",
    "2+6  FK  gb_est",
    "2+8  FK  gb_other_nuc",
    "2+10 FK  gb_other_nuc",
    "2+6  FL  gb_est",
    "2+8  FL  gb_other_nuc",
    "2+10 FL  gb_other_nuc",
    "2+6  FM  embl_dirsub *",
    "2+8  FM  embl_other_nuc",
    "2+10 FM  embl_other_nuc",
    "2+6  FN  embl_dirsub *",
    "2+8  FN  embl_other_nuc",
    "2+10 FN  embl_other_nuc",
    "2+6  FO  embl_dirsub *",
    "2+8  FO  embl_other_nuc",
    "2+10 FO  embl_other_nuc",
    "2+6  FP  embl_dirsub *",
    "2+8  FP  embl_other_nuc",
    "2+10 FP  embl_other_nuc",
    "2+6  FQ  embl_dirsub *",
    "2+8  FQ  embl_other_nuc",
    "2+10 FQ  embl_other_nuc",
    "2+6  FR  embl_dirsub *",
    "2+8  FR  embl_other_nuc",
    "2+10 FR  embl_other_nuc",
    "2+6  FS  ddbj_est",
    "2+8  FS  ddbj_other_nuc",
    "2+10 FS  ddbj_other_nuc",
    "2+6  FT  ddbj_gss",
    "2+8  FT  ddbj_other_nuc",
    "2+10 FT  ddbj_other_nuc",
    "2+6  FU  ddbj_patent",
    "2+8  FU  ddbj_other_nuc",
    "2+10 FU  ddbj_other_nuc",
    "2+6  FV  ddbj_patent",
    "2+8  FV  ddbj_other_nuc",
    "2+10 FV  ddbj_other_nuc",
    "2+6  FW  ddbj_patent",
    "2+8  FW  ddbj_other_nuc",
    "2+10 FW  ddbj_other_nuc",
    "2+6  FX  ddbj_tsa_nuc",
    "2+8  FX  ddbj_other_nuc",
    "2+10 FX  ddbj_other_nuc",
    "2+6  FY  ddbj_est",
    "2+8  FY  ddbj_other_nuc",
    "2+10 FY  ddbj_other_nuc",
    "2+6  FZ  ddbj_patent",
    "2+8  FZ  ddbj_other_nuc",
    "2+10 FZ  ddbj_other_nuc",
    "2+6  GA  ddbj_gss",
    "2+8  GA  ddbj_other_nuc",
    "2+10 GA  ddbj_other_nuc",
    "2+6  GB  ddbj_patent",
    "2+8  GB  ddbj_other_nuc",
    "2+10 GB  ddbj_other_nuc",
    "2+6  GC  gb_patent",
    "2+8  GC  gb_other_nuc",
    "2+10 GC  gb_other_nuc",
    "2+6  GD  gb_est",
    "2+8  GD  gb_other_nuc",
    "2+10 GD  gb_other_nuc",
    "2+6  GE  gb_est",
    "2+8  GE  gb_other_nuc",
    "2+10 GE  gb_other_nuc",
    "2+6  GF  gb_sts",
    "2+8  GF  gb_other_nuc",
    "2+10 GF  gb_other_nuc",
    "2+6  GG  gb_con",
    "2+8  GG  gb_other_nuc",
    "2+10 GG  gb_other_nuc",
    "2+6  GH  gb_est",
    "2+8  GH  gb_other_nuc",
    "2+10 GH  gb_other_nuc",
    "2+6  GI  unreserved_nuc # deliberately skipped",
    "2+8  GI  unreserved_nuc # deliberately skipped",
    "2+10 GI  unreserved_nuc # deliberately skipped",
    "2+6  GJ  gb_tpa_con",
    "2+8  GJ  gb_tpa_nuc",
    "2+10 GJ  gb_tpa_nuc",
    "2+6  GK  gb_tpa_chromosome",
    "2+8  GK  gb_tpa_nuc",
    "2+10 GK  gb_tpa_nuc",
    "2+6  GL  gb_con",
    "2+8  GL  gb_other_nuc",
    "2+10 GL  gb_other_nuc",
    "2+6  GM  embl_patent",
    "2+8  GM  embl_other_nuc",
    "2+10 GM  embl_other_nuc",
    "2+6  GN  embl_patent",
    "2+8  GN  embl_other_nuc",
    "2+10 GN  embl_other_nuc",
    "2+6  GO  gb_est",
    "2+8  GO  gb_other_nuc",
    "2+10 GO  gb_other_nuc",
    "2+6  GP  gb_patent",
    "2+8  GP  gb_other_nuc",
    "2+10 GP  gb_other_nuc",
    "2+6  GQ  gb_dirsub *",
    "2+8  GQ  gb_other_nuc",
    "2+10 GQ  gb_other_nuc",
    "2+6  GR  gb_est",
    "2+8  GR  gb_other_nuc",
    "2+10 GR  gb_other_nuc",
    "2+6  GS  gb_gss",
    "2+8  GS  gb_other_nuc",
    "2+10 GS  gb_other_nuc",
    "2+6  GT  gb_est",
    "2+8  GT  gb_other_nuc",
    "2+10 GT  gb_other_nuc",
    "2+6  GU  gb_dirsub *",
    "2+8  GU  gb_other_nuc",
    "2+10 GU  gb_other_nuc",
    "2+6  GV  gb_patent",
    "2+8  GV  gb_other_nuc",
    "2+10 GV  gb_other_nuc",
    "2+6  GW  gb_est",
    "2+8  GW  gb_other_nuc",
    "2+10 GW  gb_other_nuc",
    "2+6  GX  gb_patent",
    "2+8  GX  gb_other_nuc",
    "2+10 GX  gb_other_nuc",
    "2+6  GY  gb_patent",
    "2+8  GY  gb_other_nuc",
    "2+10 GY  gb_other_nuc",
    "2+6  GZ  gb_patent",
    "2+8  GZ  gb_other_nuc",
    "2+10 GZ  gb_other_nuc",
    "2+6  HA  embl_patent",
    "2+8  HA  embl_other_nuc",
    "2+10 HA  embl_other_nuc",
    "2+6  HB  embl_patent",
    "2+8  HB  embl_other_nuc",
    "2+10 HB  embl_other_nuc",
    "2+6  HC  embl_patent",
    "2+8  HC  embl_other_nuc",
    "2+10 HC  embl_other_nuc",
    "2+6  HD  embl_patent",
    "2+8  HD  embl_other_nuc",
    "2+10 HD  embl_other_nuc",
    "2+6  HE  embl_dirsub *",
    "2+8  HE  embl_other_nuc",
    "2+10 HE  embl_other_nuc",
    "2+6  HF  embl_dirsub *",
    "2+8  HF  embl_other_nuc",
    "2+10 HF  embl_other_nuc",
    "2+6  HG  embl_dirsub *",
    "2+8  HG  embl_other_nuc",
    "2+10 HG  embl_other_nuc",
    "2+6  HH  embl_patent",
    "2+8  HH  embl_other_nuc",
    "2+10 HH  embl_other_nuc",
    "2+6  HI  embl_patent",
    "2+8  HI  embl_other_nuc",
    "2+10 HI  embl_other_nuc",
    "2+6  HJ  gb_patent",
    "2+8  HJ  gb_other_nuc",
    "2+10 HJ  gb_other_nuc",
    "2+6  HK  gb_patent",
    "2+8  HK  gb_other_nuc",
    "2+10 HK  gb_other_nuc",
    "2+6  HL  gb_patent",
    "2+8  HL  gb_other_nuc",
    "2+10 HL  gb_other_nuc",
    "2+6  HM  gb_dirsub *",
    "2+8  HM  gb_other_nuc",
    "2+10 HM  gb_other_nuc",
    "2+6  HN  gb_gss",
    "2+8  HN  gb_other_nuc",
    "2+10 HN  gb_other_nuc",
    "2+6  HO  gb_est",
    "2+8  HO  gb_other_nuc",
    "2+10 HO  gb_other_nuc",
    "2+6  HP  gb_tsa_nuc",
    "2+8  HP  gb_other_nuc",
    "2+10 HP  gb_other_nuc",
    "2+6  HQ  gb_dirsub *",
    "2+8  HQ  gb_other_nuc",
    "2+10 HQ  gb_other_nuc",
    "2+6  HR  gb_gss",
    "2+8  HR  gb_other_nuc",
    "2+10 HR  gb_other_nuc",
    "2+6  HS  gb_est",
    "2+8  HS  gb_other_nuc",
    "2+10 HS  gb_other_nuc",
    "2+6  HT  ddbj_tpa_con",
    "2+8  HT  ddbj_tpa_nuc",
    "2+10 HT  ddbj_tpa_nuc",
    "2+6  HU  ddbj_tpa_chromosome",
    "2+8  HU  ddbj_tpa_nuc",
    "2+10 HU  ddbj_tpa_nuc",
    "2+6  HV  ddbj_patent",
    "2+8  HV  ddbj_other_nuc",
    "2+10 HV  ddbj_other_nuc",
    "2+6  HW  ddbj_patent",
    "2+8  HW  ddbj_other_nuc",
    "2+10 HW  ddbj_other_nuc",
    "2+6  HX  ddbj_est",
    "2+8  HX  ddbj_other_nuc",
    "2+10 HX  ddbj_other_nuc",
    "2+6  HY  ddbj_est",
    "2+8  HY  ddbj_other_nuc",
    "2+10 HY  ddbj_other_nuc",
    "2+6  HZ  ddbj_patent",
    "2+8  HZ  ddbj_other_nuc",
    "2+10 HZ  ddbj_other_nuc",
    "2+6  JA  embl_patent",
    "2+8  JA  embl_other_nuc",
    "2+10 JA  embl_other_nuc",
    "2+6  JB  embl_patent",
    "2+8  JB  embl_other_nuc",
    "2+10 JB  embl_other_nuc",
    "2+6  JC  embl_patent",
    "2+8  JC  embl_other_nuc",
    "2+10 JC  embl_other_nuc",
    "2+6  JD  embl_patent",
    "2+8  JD  embl_other_nuc",
    "2+10 JD  embl_other_nuc",
    "2+6  JE  embl_patent",
    "2+8  JE  embl_other_nuc",
    "2+10 JE  embl_other_nuc",
    "2+6  JF  gb_dirsub",
    "2+8  JF  gb_other_nuc",
    "2+10 JF  gb_other_nuc",
    "2+6  JG  gb_est",
    "2+8  JG  gb_other_nuc",
    "2+10 JG  gb_other_nuc",
    "2+6  JH  gb_con",
    "2+8  JH  gb_other_nuc",
    "2+10 JH  gb_other_nuc",
    "2+6  JI  gb_tsa_nuc",
    "2+8  JI  gb_other_nuc",
    "2+10 JI  gb_other_nuc",
    "2+6  JJ  gb_gss",
    "2+8  JJ  gb_other_nuc",
    "2+10 JJ  gb_other_nuc",
    "2+6  JK  gb_est",
    "2+8  JK  gb_other_nuc",
    "2+10 JK  gb_other_nuc",
    "2+6  JL  gb_tsa_nuc",
    "2+8  JL  gb_other_nuc",
    "2+10 JL  gb_other_nuc",
    "2+6  JM  gb_gss",
    "2+8  JM  gb_other_nuc",
    "2+10 JM  gb_other_nuc",
    "2+6  JN  gb_dirsub *",
    "2+8  JN  gb_other_nuc",
    "2+10 JN  gb_other_nuc",
    "2+6  JO  gb_tsa_nuc",
    "2+8  JO  gb_other_nuc",
    "2+10 JO  gb_other_nuc",
    "2+6  JP  gb_tsa_nuc",
    "2+8  JP  gb_other_nuc",
    "2+10 JP  gb_other_nuc",
    "2+6  JQ  gb_dirsub",
    "2+8  JQ  gb_other_nuc",
    "2+10 JQ  gb_other_nuc",
    "2+6  JR  gb_tsa_nuc",
    "2+8  JR  gb_other_nuc",
    "2+10 JR  gb_other_nuc",
    "2+6  JS  gb_gss",
    "2+8  JS  gb_other_nuc",
    "2+10 JS  gb_other_nuc",
    "2+6  JT  gb_tsa_nuc",
    "2+8  JT  gb_other_nuc",
    "2+10 JT  gb_other_nuc",
    "2+6  JU  gb_tsa_nuc",
    "2+8  JU  gb_other_nuc",
    "2+10 JU  gb_other_nuc",
    "2+6  JV  gb_tsa_nuc",
    "2+8  JV  gb_other_nuc",
    "2+10 JV  gb_other_nuc",
    "2+6  JW  gb_tsa_nuc",
    "2+8  JW  gb_other_nuc",
    "2+10 JW  gb_other_nuc",
    "2+6  JX  gb_dirsub",
    "2+8  JX  gb_other_nuc",
    "2+10 JX  gb_other_nuc",
    "2+6  JY  gb_gss",
    "2+8  JY  gb_other_nuc",
    "2+10 JY  gb_other_nuc",
    "2+6  JZ  gb_est",
    "2+8  JZ  gb_other_nuc",
    "2+10 JZ  gb_other_nuc",
    "2+6  KA  gb_tsa_nuc",
    "2+8  KA  gb_other_nuc",
    "2+10 KA  gb_other_nuc",
    "2+6  KB  gb_con",
    "2+8  KB  gb_other_nuc",
    "2+10 KB  gb_other_nuc",
    "2+6  KC  gb_dirsub",
    "2+8  KC  gb_other_nuc",
    "2+10 KC  gb_other_nuc",
    "2+6  KD  gb_con",
    "2+8  KD  gb_other_nuc",
    "2+10 KD  gb_other_nuc",
    "2+6  KE  gb_con",
    "2+8  KE  gb_other_nuc",
    "2+10 KE  gb_other_nuc",
    "2+6  KF  gb_dirsub *",
    "2+8  KF  gb_other_nuc",
    "2+10 KF  gb_other_nuc",
    "2+6  KG  gb_gss",
    "2+8  KG  gb_other_nuc",
    "2+10 KG  gb_other_nuc",
    "2+6  KH  gb_patent",
    "2+8  KH  gb_other_nuc",
    "2+10 KH  gb_other_nuc",
    "2+6  KI  gb_con",
    "2+8  KI  gb_other_nuc",
    "2+10 KI  gb_other_nuc",
    "2+6  KJ  gb_dirsub *",
    "2+8  KJ  gb_other_nuc",
    "2+10 KJ  gb_other_nuc",
    "2+6  KK  gb_con",
    "2+8  KK  gb_other_nuc",
    "2+10 KK  gb_other_nuc",
    "2+6  KL  gb_con",
    "2+8  KL  gb_other_nuc",
    "2+10 KL  gb_other_nuc",
    "2+6  KM  gb_dirsub *",
    "2+8  KM  gb_other_nuc",
    "2+10 KM  gb_other_nuc",
    "2+6  KN  gb_con",
    "2+8  KN  gb_other_nuc",
    "2+10 KN  gb_other_nuc",
    "2+6  KO  gb_gss",
    "2+8  KO  gb_other_nuc",
    "2+10 KO  gb_other_nuc",
    "2+6  KP  gb_dirsub",
    "2+8  KP  gb_other_nuc",
    "2+10 KP  gb_other_nuc",
    "2+6  KQ  gb_con",
    "2+8  KQ  gb_other_nuc",
    "2+10 KQ  gb_other_nuc",
    "2+6  KR  gb_dirsub",
    "2+8  KR  gb_other_nuc",
    "2+10 KR  gb_other_nuc",
    "2+6  KS  gb_gss",
    "2+8  KS  gb_other_nuc",
    "2+10 KS  gb_other_nuc",
    "2+6  KT  gb_dirsub",
    "2+8  KT  gb_other_nuc",
    "2+10 KT  gb_other_nuc",
    "2+6  KU  gb_dirsub",
    "2+8  KU  gb_other_nuc",
    "2+10 KU  gb_other_nuc",
    "2+6  KV  gb_con",
    "2+8  KV  gb_other_nuc",
    "2+10 KV  gb_other_nuc",
    "2+6  KW  gb_other_nuc",
    "2+8  KW  gb_other_nuc",
    "2+10 KW  gb_other_nuc",
    "2+6  KX  gb_dirsub",
    "2+8  KX  gb_other_nuc",
    "2+10 KX  gb_other_nuc",
    "2+6  KY  gb_dirsub",
    "2+8  KY  gb_other_nuc",
    "2+10 KY  gb_other_nuc",
    "2+6  KZ  gb_con",
    "2+8  KZ  gb_other_nuc",
    "2+10 KZ  gb_other_nuc",
    "2+6  LA  ddbj_tsa_nuc",
    "2+8  LA  ddbj_other_nuc",
    "2+10 LA  ddbj_other_nuc",
    "2+6  LB  ddbj_gss",
    "2+8  LB  ddbj_other_nuc",
    "2+10 LB  ddbj_other_nuc",
    "2+6  LC  ddbj_dirsub",
    "2+8  LC  ddbj_other_nuc",
    "2+10 LC  ddbj_other_nuc",
    "2+6  LD  ddbj_con",
    "2+8  LD  ddbj_other_nuc",
    "2+10 LD  ddbj_other_nuc",
    "2+6  LE  ddbj_tsa_nuc",
    "2+8  LE  ddbj_other_nuc",
    "2+10 LE  ddbj_other_nuc",
    "2+6  LF  ddbj_patent",
    "2+8  LF  ddbj_other_nuc",
    "2+10 LF  ddbj_other_nuc",
    "2+6  LG  ddbj_patent # from Korea",
    "2+8  LG  ddbj_other_nuc",
    "2+10 LG  ddbj_other_nuc",
    "2+6  LH  ddbj_tsa_nuc",
    "2+8  LH  ddbj_other_nuc",
    "2+10 LH  ddbj_other_nuc",
    "2+6  LI  ddbj_tsa_nuc",
    "2+8  LI  ddbj_other_nuc",
    "2+10 LI  ddbj_other_nuc",
    "2+6  LJ  ddbj_tsa_nuc",
    "2+8  LJ  ddbj_other_nuc",
    "2+10 LJ  ddbj_other_nuc",
    "2+6  LK  embl_dirsub *",
    "2+8  LK  embl_other_nuc",
    "2+10 LK  embl_other_nuc",
    "2+6  LL  embl_dirsub",
    "2+8  LL  embl_other_nuc",
    "2+10 LL  embl_other_nuc",
    "2+6  LM  embl_dirsub *",
    "2+8  LM  embl_other_nuc",
    "2+10 LM  embl_other_nuc",
    "2+6  LN  embl_dirsub *",
    "2+8  LN  embl_other_nuc",
    "2+10 LN  embl_other_nuc",
    "2+6  LO  embl_dirsub *",
    "2+8  LO  embl_other_nuc",
    "2+10 LO  embl_other_nuc",
    "2+6  LP  embl_patent",
    "2+8  LP  embl_other_nuc",
    "2+10 LP  embl_other_nuc",
    "2+6  LQ  embl_patent",
    "2+8  LQ  embl_other_nuc",
    "2+10 LQ  embl_other_nuc",
    "2+6  LR  embl_dirsub * # embl_patent?",
    "2+8  LR  embl_other_nuc",
    "2+10 LR  embl_other_nuc",
    "2+6  LS  embl_dirsub # embl_patent?",
    "2+8  LS  embl_other_nuc",
    "2+10 LS  embl_other_nuc",
    "2+6  LT  embl_dirsub *",
    "2+8  LT  embl_other_nuc",
    "2+10 LT  embl_other_nuc",
    "2+6  LU  ddbj_est",
    "2+8  LU  ddbj_other_nuc",
    "2+10 LU  ddbj_other_nuc",
    "2+6  LV  ddbj_patent",
    "2+8  LV  ddbj_other_nuc",
    "2+10 LV  ddbj_other_nuc",
    "2+6  LW  ddbj_other_nuc",
    "2+8  LW  ddbj_other_nuc",
    "2+10 LW  ddbj_other_nuc",
    "2+6  LX  ddbj_patent",
    "2+8  LX  ddbj_other_nuc",
    "2+10 LX  ddbj_other_nuc",
    "2+6  LY  ddbj_patent # from Korea",
    "2+8  LY  ddbj_other_nuc",
    "2+10 LY  ddbj_other_nuc",
    "2+6  LZ  ddbj_patent",
    "2+8  LZ  ddbj_other_nuc",
    "2+10 LZ  ddbj_other_nuc",
    "2+6  MA  ddbj_patent",
    "2+8  MA  ddbj_other_nuc",
    "2+10 MA  ddbj_other_nuc",
    "2+6  MB  ddbj_patent",
    "2+8  MB  ddbj_other_nuc",
    "2+10 MB  ddbj_other_nuc",
    "2+6  MC  ddbj_patent",
    "2+8  MC  ddbj_other_nuc",
    "2+10 MC  ddbj_other_nuc",
    "2+6  MD  ddbj_patent",
    "2+8  MD  ddbj_other_nuc",
    "2+10 MD  ddbj_other_nuc",
    "2+6  ME  ddbj_patent",
    "2+8  ME  ddbj_other_nuc",
    "2+10 ME  ddbj_other_nuc",
    "2+6  MF  gb_dirsub",
    "2+8  MF  gb_other_nuc",
    "2+10 MF  gb_other_nuc",
    "2+6  MG  gb_dirsub",
    "2+8  MG  gb_other_nuc",
    "2+10 MG  gb_other_nuc",
    "2+6  MH  gb_dirsub",
    "2+8  MH  gb_other_nuc",
    "2+10 MH  gb_other_nuc",
    "2+6  MI  gb_patent",
    "2+8  MI  gb_other_nuc",
    "2+10 MI  gb_other_nuc",
    "2+6  MJ  gb_gss",
    "2+8  MJ  gb_other_nuc",
    "2+10 MJ  gb_other_nuc",
    "2+6  MK  gb_dirsub",
    "2+8  MK  gb_other_nuc",
    "2+10 MK  gb_other_nuc",
    "2+6  ML  gb_con",
    "2+8  ML  gb_other_nuc",
    "2+10 ML  gb_other_nuc",
    "2+6  MM  gb_patent",
    "2+8  MM  gb_other_nuc",
    "2+10 MM  gb_other_nuc",
    "2+6  MN  gb_dirsub",
    "2+8  MN  gb_other_nuc",
    "2+10 MN  gb_other_nuc",
    "2+6  MO  gb_patent",
    "2+8  MO  gb_other_nuc",
    "2+10 MO  gb_other_nuc",
    "2+6  MP  embl_patent",
    "2+8  MP  embl_other_nuc",
    "2+10 MP  embl_other_nuc",
    "2+6  MQ  embl_patent",
    "2+8  MQ  embl_other_nuc",
    "2+10 MQ  embl_other_nuc",
    "2+6  MR  embl_patent",
    "2+8  MR  embl_other_nuc",
    "2+10 MR  embl_other_nuc",
    "2+6  MS  embl_patent",
    "2+8  MS  embl_other_nuc",
    "2+10 MS  embl_other_nuc",
    "2+6  MT  gb_dirsub",
    "2+8  MT  gb_other_nuc",
    "2+10 MT  gb_other_nuc",
    "2+6  MU  gb_con",
    "2+8  MU  gb_other_nuc",
    "2+10 MU  gb_other_nuc",
    "2+6  MV  gb_patent",
    "2+8  MV  gb_other_nuc",
    "2+10 MV  gb_other_nuc",
    "2+6  MW  gb_dirsub",
    "2+8  MW  gb_other_nuc",
    "2+10 MW  gb_other_nuc",
    "2+6  MX  gb_patent",
    "2+8  MX  gb_other_nuc",
    "2+10 MX  gb_other_nuc",
    "2+6  MY  gb_patent",
    "2+8  MY  gb_other_nuc",
    "2+10 MY  gb_other_nuc",
    "2+6  MZ  gb_dirsub",
    "2+8  MZ  gb_other_nuc",
    "2+10 MZ  gb_other_nuc",
    "2+6  NC  unreserved_nuc # deliberately skipped",
    "2+8  NC  unreserved_nuc # deliberately skipped",
    "2+10 NC  unreserved_nuc # deliberately skipped",
    "2+6  NG  unreserved_nuc # deliberately skipped",
    "2+8  NG  unreserved_nuc # deliberately skipped",
    "2+10 NG  unreserved_nuc # deliberately skipped",
    "2+6  NM  unreserved_nuc # deliberately skipped",
    "2+8  NM  unreserved_nuc # deliberately skipped",
    "2+10 NM  unreserved_nuc # deliberately skipped",
    "2+6  NP  unreserved_nuc # deliberately skipped",
    "2+8  NP  unreserved_nuc # deliberately skipped",
    "2+10 NP  unreserved_nuc # deliberately skipped",
    "2+6  NR  unreserved_nuc # deliberately skipped",
    "2+8  NR  unreserved_nuc # deliberately skipped",
    "2+10 NR  unreserved_nuc # deliberately skipped",
    "2+6  NS  unreserved_nuc # deliberately skipped",
    "2+8  NS  unreserved_nuc # deliberately skipped",
    "2+10 NS  unreserved_nuc # deliberately skipped",
    "2+6  NT  unreserved_nuc # deliberately skipped",
    "2+8  NT  unreserved_nuc # deliberately skipped",
    "2+10 NT  unreserved_nuc # deliberately skipped",
    "2+6  NW  unreserved_nuc # deliberately skipped",
    "2+8  NW  unreserved_nuc # deliberately skipped",
    "2+10 NW  unreserved_nuc # deliberately skipped",
    "2+6  NZ  unreserved_nuc # deliberately skipped",
    "2+8  NZ  unreserved_nuc # deliberately skipped",
    "2+10 NZ  unreserved_nuc # deliberately skipped",
    "2+6  OA  embl_other_nuc",
    "2+8  OA  embl_other_nuc",
    "2+10 OA  embl_other_nuc",
    "2+6  OB  embl_other_nuc *",
    "2+8  OB  embl_other_nuc",
    "2+10 OB  embl_other_nuc",
    "2+6  OC  embl_other_nuc",
    "2+8  OC  embl_other_nuc",
    "2+10 OC  embl_other_nuc",
    "2+6  OD  embl_other_nuc",
    "2+8  OD  embl_other_nuc",
    "2+10 OD  embl_other_nuc",
    "2+6  OE  embl_other_nuc",
    "2+8  OE  embl_other_nuc",
    "2+10 OE  embl_other_nuc",
    "2+6  OF  ddbj_patent # from Korea",
    "2+8  OF  ddbj_other_nuc",
    "2+10 OF  ddbj_other_nuc",
    "2+6  OG  ddbj_patent",
    "2+8  OG  ddbj_other_nuc",
    "2+10 OG  ddbj_other_nuc",
    "2+6  OH  ddbj_est",
    "2+8  OH  ddbj_other_nuc",
    "2+10 OH  ddbj_other_nuc",
    "2+6  OI  ddbj_patent",
    "2+8  OI  ddbj_other_nuc",
    "2+10 OI  ddbj_other_nuc",
    "2+6  OJ  ddbj_patent",
    "2+8  OJ  ddbj_other_nuc",
    "2+10 OJ  ddbj_other_nuc",
    "2+6  OK  gb_dirsub",
    "2+8  OK  gb_other_nuc",
    "2+10 OK  gb_other_nuc",
    "2+6  OL  gb_dirsub",
    "2+8  OL  gb_other_nuc",
    "2+10 OL  gb_other_nuc",
    "2+6  OM  gb_dirsub",
    "2+8  OM  gb_other_nuc",
    "2+10 OM  gb_other_nuc",
    "2+6  ON  gb_dirsub",
    "2+8  ON  gb_other_nuc",
    "2+10 ON  gb_other_nuc",
    "2+6  OO  gb_patent",
    "2+8  OO  gb_other_nuc",
    "2+10 OO  gb_other_nuc",
    "2+6  OP  gb_dirsub",
    "2+8  OP  gb_other_nuc",
    "2+10 OP  gb_other_nuc",
    "2+6  OQ  gb_dirsub",
    "2+8  OQ  gb_other_nuc",
    "2+10 OQ  gb_other_nuc",
    "2+6  OR  gb_dirsub",
    "2+8  OR  gb_other_nuc",
    "2+10 OR  gb_other_nuc",
    "2+6  OS  gb_patent",
    "2+8  OS  gb_other_nuc",
    "2+10 OS  gb_other_nuc",
    "2+6  OT  gb_patent",
    "2+8  OT  gb_other_nuc",
    "2+10 OT  gb_other_nuc",
    "2+6  O?  embl_other_nuc",
    "2+8  O?  embl_other_nuc",
    "2+10 O?  embl_other_nuc",
    "2+6  PA  ddbj_patent",
    "2+8  PA  ddbj_other_nuc",
    "2+10 PA  ddbj_other_nuc",
    "2+6  PB  ddbj_patent",
    "2+8  PB  ddbj_other_nuc",
    "2+10 PB  ddbj_other_nuc",
    "2+6  PC  ddbj_patent",
    "2+8  PC  ddbj_other_nuc",
    "2+10 PC  ddbj_other_nuc",
    "2+6  PD  ddbj_patent",
    "2+8  PD  ddbj_other_nuc",
    "2+10 PD  ddbj_other_nuc",
    "2+6  PE  ddbj_patent # from Korea",
    "2+8  PE  ddbj_other_nuc",
    "2+10 PE  ddbj_other_nuc",
    "2+6  PF  ddbj_patent # from Korea",
    "2+8  PF  ddbj_other_nuc",
    "2+10 PF  ddbj_other_nuc",
    "2+6  PG  ddbj_patent",
    "2+8  PG  ddbj_other_nuc",
    "2+10 PG  ddbj_other_nuc",
    "2+6  PH  ddbj_patent",
    "2+8  PH  ddbj_other_nuc",
    "2+10 PH  ddbj_other_nuc",
    "2+6  PI  ddbj_patent",
    "2+8  PI  ddbj_other_nuc",
    "2+10 PI  ddbj_other_nuc",
    "2+6  PJ  ddbj_patent",
    "2+8  PJ  ddbj_other_nuc",
    "2+10 PJ  ddbj_other_nuc",
    "2+6  PK  ddbj_patent",
    "2+8  PK  ddbj_other_nuc",
    "2+10 PK  ddbj_other_nuc",
    "2+6  PL  ddbj_other_nuc",
    "2+8  PL  ddbj_other_nuc",
    "2+10 PL  ddbj_other_nuc",
    "2+6  PM  ddbj_other_nuc",
    "2+8  PM  ddbj_other_nuc",
    "2+10 PM  ddbj_other_nuc",
    "2+6  PN  ddbj_other_nuc",
    "2+8  PN  ddbj_other_nuc",
    "2+10 PN  ddbj_other_nuc",
    "2+6  PO  ddbj_other_nuc",
    "2+8  PO  ddbj_other_nuc",
    "2+10 PO  ddbj_other_nuc",
    "2+6  PP  gb_dirsub",
    "2+8  PP  gb_other_nuc",
    "2+10 PP  gb_other_nuc",
    "2+6  PQ  gb_dirsub",
    "2+8  PQ  gb_other_nuc",
    "2+10 PQ  gb_other_nuc",
    "2+6  PR  gb_patent",
    "2+8  PR  gb_other_nuc",
    "2+10 PR  gb_other_nuc",
    "2+6  PS  gb_con",
    "2+8  PS  gb_other_nuc",
    "2+10 PS  gb_other_nuc",
    "2+6  PT  gb_patent",
    "2+8  PT  gb_other_nuc",
    "2+10 PT  gb_other_nuc",
    "2+6  PW  unreserved_nuc # deliberately skipped",
    "2+8  PW  unreserved_nuc # deliberately skipped",
    "2+10 PW  unreserved_nuc # deliberately skipped",
    "2+6  P?  gb_other_nuc",
    "2+8  P?  gb_other_nuc",
    "2+10 P?  gb_other_nuc",
    "2+6  QA  gb_other_nuc",
    "2+8  QA  gb_other_nuc",
    "2+10 QA  gb_other_nuc",
    "2+6  QB  gb_other_nuc",
    "2+8  QB  gb_other_nuc",
    "2+10 QB  gb_other_nuc",
    "2+6  QC  gb_other_nuc",
    "2+8  QC  gb_other_nuc",
    "2+10 QC  gb_other_nuc",
    "2+6  QD  gb_other_nuc",
    "2+8  QD  gb_other_nuc",
    "2+10 QD  gb_other_nuc",
    "2+6  QE  gb_other_nuc",
    "2+8  QE  gb_other_nuc",
    "2+10 QE  gb_other_nuc",
    "2+6  QF  gb_other_nuc",
    "2+8  QF  gb_other_nuc",
    "2+10 QF  gb_other_nuc",
    "2+6  QG  gb_other_nuc",
    "2+8  QG  gb_other_nuc",
    "2+10 QG  gb_other_nuc",
    "2+6  QH  gb_other_nuc",
    "2+8  QH  gb_other_nuc",
    "2+10 QH  gb_other_nuc",
    "2+6  QI  gb_other_nuc",
    "2+8  QI  gb_other_nuc",
    "2+10 QI  gb_other_nuc",
    "2+6  QJ  gb_other_nuc",
    "2+8  QJ  gb_other_nuc",
    "2+10 QJ  gb_other_nuc",
    "2+6  QK  embl_patent",
    "2+8  QK  embl_other_nuc",
    "2+10 QK  embl_other_nuc",
    "2+6  QL  embl_patent",
    "2+8  QL  embl_other_nuc",
    "2+10 QL  embl_other_nuc",
    "2+6  QM  embl_patent",
    "2+8  QM  embl_other_nuc",
    "2+10 QM  embl_other_nuc",
    "2+6  QN  embl_patent",
    "2+8  QN  embl_other_nuc",
    "2+10 QN  embl_other_nuc",
    "2+6  QO  embl_patent",
    "2+8  QO  embl_other_nuc",
    "2+10 QO  embl_other_nuc",
    "2+6  TI  unreserved_nuc # deliberately skipped",
    "2+8  TI  unreserved_nuc # deliberately skipped",
    "2+10 TI  unreserved_nuc # deliberately skipped",
    "2+6  WP  unreserved_nuc # deliberately skipped",
    "2+8  WP  unreserved_nuc # deliberately skipped",
    "2+10 WP  unreserved_nuc # deliberately skipped",
    "2+6  XM  unreserved_nuc # deliberately skipped",
    "2+8  XM  unreserved_nuc # deliberately skipped",
    "2+10 XM  unreserved_nuc # deliberately skipped",
    "2+6  XP  unreserved_nuc # deliberately skipped",
    "2+8  XP  unreserved_nuc # deliberately skipped",
    "2+10 XP  unreserved_nuc # deliberately skipped",
    "2+6  XR  unreserved_nuc # deliberately skipped",
    "2+8  XR  unreserved_nuc # deliberately skipped",
    "2+10 XR  unreserved_nuc # deliberately skipped",
    "2+6  YP  unreserved_nuc # deliberately skipped",
    "2+8  YP  unreserved_nuc # deliberately skipped",
    "2+10 YP  unreserved_nuc # deliberately skipped",
    "2+6  ZP  unreserved_nuc # deliberately skipped",
    "2+8  ZP  unreserved_nuc # deliberately skipped",
    "2+10 ZP  unreserved_nuc # deliberately skipped",
    "2+6  ??  unreserved_nuc",
    "2+8  ??  unreserved_nuc",
    "2+10 ??  unreserved_nuc",
    "",
    "# Specially handled type-general Dbtag names; commented out for now in",
    "# favor of a hard-coded list.  (Uncommenting them will override it.)",
    "",
    "#gnl  SRA         general_nuc",
    "#gnl  ti          general_nuc",
    "#gnl  TR_ASSM_CH  general_nuc",
    "#gnl  TRACE_ASSM  general_nuc",
    "#gnl  TRACE_CHGR  general_nuc",
    "",
    "# SPECIAL CASES",
    "# Mostly in the same order as baseline assignments, but embl_tpa_prot",
    "# specials are at the very end because there are so many of them.  To",
    "# keep to a rough limit of 100 ranges per prefix, resort to *_other_nuc",
    "# for some heavily mixed ranges.",
    "",
    "# Some GenBank \"TPA\" 8-character protein accessions are really native.",
    "special2 DAA+5 gb_prot",
    ": 00001 2110-6 34794-5",
    "",
    "# Nominally ddbj_est.",
    "special2 C+5 ddbj_dirsub",
    ": 21595-827 2715-62 83-911 4689-767 75685-936 95573-642 9933-76",
    "",
    "# Nominally ddbj_dirsub.  Split out EST ranges, and give the benefit",
    "# of the doubt to sequences that look like ddbj_con, ddbj_genome,",
    "# ddbj_mrna, or ddbj_other_nuc.",
    "special2 D+5 ddbj_est",
    ": 00922 11487-2469 7812-21053",
    ": 6771-8109 70-83 5-96 8 200 3 5-6 8-15 7-24 7 9 32 4 81-8 90-310 2-8 20-6",
    ": 603-744 9018-624 993-30029 816-1599 2304-958 60-3769 71-4214 6-410 2-589",
    ": 640-5674 6-6684 42187-3617 60143-1376 420-685 708-2388",
    ": 90-3133 71-317 9-24 30 746-58 4179-5034 6-241 3-978 80-6873",
    ": 7099-8048 50-323 5-600 2-9603 5-70813 6447-7996",
    "# EST range counts: 62, 118, 101, 70, 1208, 45, and 91 respectively.",
    "special2 D+5 ddbj_other_nuc",
    ": 15075-7289 21355-6768 36686-42011 4612-9352 50936-60141 70900-6413 8209-89649",
    "",
    "special  F38006         embl_dirsub # Nominally embl_est.",
    "",
    "# Nominally gsdb_dirsub.  Split out EST, GSS, and STS ranges, and",
    "# give the benefit of the doubt to sequences that look like gb_cdna,",
    "# gb_con, gb_genome, gsdb_dirsub, or gb_other_nuc.",
    "special2 L+5 gb_est",
    ": 18857-8 9032-41 143-55 60 202-14 20451-61 5173-249 344-5 7 417-20 49-525",
    ": 6606-848 7444 30148 1968-2015 28-65 3494-675 4957-5007 773-843",
    ": 7453-515 607-59 974-8013 26-243 525-43 741 50-60 3 74 87 40420-4 3576-7 9-80",
    ": 4279-576 6401-582 914-7098 842-965 8818-73 9057-120 76101-31 81201-60",
    "special2 L+5 gb_sts",
    ": 00738-844 6-50 2-91 3-916 94-1014 996-2021 80-91 4198-215 7331-2 863",
    ": 17188-290 8193-255 23479-93 992 7 4693 826 5137 888 8178-418 20-2",
    ": 31430-7 40-89 4798-802 5580-1 6534 7208-88 9872-3 40034 40-1 351-2 1967",
    ": 7214-5 542 54-68 8016 76151 7669-70 4-83 5-6 9 878-83 993",
    "special  L48736-L48796  gb_gss",
    "special  L08881-L15794  gb_other_nuc # 6 EST ranges and 23 STS ranges",
    "",
    "# Nominally gsdb_dirsub.  Split out EST and STS ranges, and give the",
    "# benefit of the doubt to sequences that look like gb_cdna, gb_con,",
    "# gb_genome, gsdb_dirsub, or gb_other_nuc.",
    "special2 M+5 gb_est",
    ": 61953-2300",
    ": 75734-848 50-2 4-5 7 9-63 8-9 72 4 6-81 5 90 2-902 4-5 12 5 7-43 5-6 51 5",
    ": 64-5 88 6111-22 7851-9278 465-80184 5308-6179 8774-9469",
    ": 91216-22 387-403 80-511 2283-4 935 6605-21",
    "special2 M+5 gb_sts",
    ": 23606-10 80369-76 3631-9 4924-34 43 94585-622 35-43 55-62 5212-80 301-23",
    ": 8979-96",
    "",
    "# Early N accessions were assigned haphazardly, and sometimes ambiguously.",
    "# (These are all secondary accessions nowadays, though.)  \"*\" denotes what,",
    "# if anything, N????? (and usually also N?????.1) immediately resolves to.",
    "# Some unambiguous accessions don't resolve, and some ambiguous ones do.",
    "special  N00001  gb_embl        # (L29187+L00109+L00110 / AH005313.2) / X04516.1",
    "special  N00002  gb_embl_ddbj   # M31027.1 / X04469.1 = D00002",
    "special  N00003  gb_ddbj        # L29169.1 / D00003.1",
    "special  N00004  gb_ddbj        # *L29170.1 / D00004.1",
    "special  N00005  gb_embl_ddbj   # L29171.1 / V01385.1 / D00005.1",
    "special  N00006  gb_ddbj        # (M31028.1 / AH002572.2) / D00006.1",
    "special  N00007  gb_ddbj        # (M31029.1 / AH002572.2) / D00007.1",
    "special  N00008  gb_other_nuc   # *L29172.1",
    "special  N00009  gb_embl_ddbj   # M13655.1 / *X00532.1 / D00009.1 (= M13655.1)",
    "special  N00010  gb_embl_ddbj   # *L29174.1 / X04067.1 = D00010.1",
    "special  N00011  gb_embl        # *L29175.1 = V00749.1",
    "special  N00012  gb_embl_ddbj   # L29176.1 = V00751.1 / D00012.1",
    "special  N00013  gb_other_nuc   # L29177.1 / AH002712.2",
    "special  N00014  gb_ddbj        # (L29178.1 / AH005322.2) / D00014.1",
    "special  N00015  gb_ddbj        # (L29187.1 / AH005313.2) / D00015.1",
    "special  N00016  gb_ddbj        # (L29188.1 / AH005313.2) / D00016.1",
    "special  N00017  gb_ddbj        # *L29190.1 / (M14043 =) D00017.1",
    "special  N00018  gb_other_nuc   # *L29191.1 / AH002172.2; only unversioned",
    "special  N00019  gb_other_nuc   # *L29197.1",
    "special  N00020  gb_embl_ddbj   # (L29198.1 / AH002320.2) / X03632.1 = D00020.1",
    "special  N00021  gb_ddbj        # (L29199.1 / AH002320.2) / D00021.1",
    "special  N00022  gb_embl_ddbj   # L29390.1 / V01168.1 / D00022.1",
    "special  N00023  gb_ddbj        # (L29391.1 / AH000963.2) / D00023.1",
    "special  N00024  gb_ddbj        # *L29392.1 / (M13071.1 =) D00024.1",
    "special  N00025  gb_embl_ddbj   # L29393.1 / X00626.1 / D00025.1",
    "special  N00026  gb_ddbj        # L29394.1 (= *X00442.1) / D00026.1",
    "special  N00027  gb_other_nuc   # *L29395.1",
    "special  N00028  ddbj_other_nuc # D00028.1",
    "special  N00029  gb_ddbj        # *L29397.1 / D00029.1",
    "special  N00030  gb_ddbj        # M10126.1 / D00030.1",
    "special  N00031  gb_ddbj        # (*L29400.1 / AH002739.2) / D00031.1; unvers.",
    "special  N00032  gb_ddbj        # (L?????.1 / AH??????.2) / D00032.1",
    "special  N00033  gb_ddbj        # (L29401.1 / AH002776.2) / D00033.1",
    "special  N00034  gb_ddbj        # (L29424.1 / AH001823.2) / D00034.1",
    "special  N00035  ddbj_other_nuc # D00035.1",
    "special  N00036  gb_ddbj        # M31030.1 / D00036.1",
    "special  N00037  ddbj_other_nuc # D00037.1",
    "special  N00038  gb_ddbj        # M31031.1 / D00038.1",
    "special  N00039  gb_ddbj        # *L29427.1 / D00039.1",
    "special  N00040  gb_ddbj        # L29428.1 / D00040.1",
    "special  N00041  gb_other_nuc   # L29429.1 / *M13756.1 (= D00041)",
    "special  N00042  gb_ddbj        # (L29430.1 / AH002209.2) / (M13752 =) D00042.1",
    "special  N00043  gb_ddbj        # (L29431.1 / AH005585.2) / (M13753 =) D00043.1",
    "special  N00044  gb_ddbj        # L29432.1 / D00044.1",
    "special  N00045  gb_other_nuc   # (*L29433.1/AH002727.2); once also DDBJ?",
    "special  N00046  gb_other_nuc   # *L29434.1",
    "special  N00047  gb_ddbj        # (*L29435.1 / AH002481.2) / D00047.1",
    "special  N00048  gb_other_nuc   # *L29436.1",
    "special  N00049  gb_ddbj        # M31032.1 / D00049.1",
    "special  N00050  gb_ddbj        # (L29399.1 / AH002739.2) / D00050.1",
    "special  N00051  gb_ddbj        # (L?????.1 / AH??????.2) / D00051.1",
    "special  N00052  gb_other_nuc   # L29472.1 / *M14909.1 (= D00052.1)",
    "special  N00053  ddbj_other_nuc # D00053.1",
    "special  N00054  gb_other_nuc   # M31033.1",
    "special  N00055  gb_ddbj        # (L?????.1 / AH??????.2) / D00055.1",
    "special  N00056  gb_ddbj        # L39908.1 / D00056.1",
    "special  N00057  gb_embl        # M31034.1 / X05532.1",
    "special  N00058  gb_embl_ddbj   # M31035.1 (= X05163.1) / (X05537.1 =) D00058.1",
    "special  N00059  gb_ddbj        # M22232.1 / (X05538.1 =) D00059.1",
    "special  N00060  embl_other_nuc # X05541.1 (= D00060.1)",
    "special  N00061  ddbj_other_nuc # (X05531.1 =) D00061.1",
    "special  N00062  ddbj_other_nuc # (X05530.1 =) D00062.1",
    "special  N00063  ddbj_other_nuc # (X05529.1 =) D00063.1",
    "special  N00064  embl_other_nuc # X05528.1 (= D00064.1 = D10030.1)",
    "special  N00065  ddbj_other_nuc # (X05527.1 =) D00065.1 = D10031.1",
    "special  N00066  ddbj_other_nuc # D00066.1",
    "special  N00067  ddbj_other_nuc # (M20207.1 =) D00067.1",
    "special  N00068  ddbj_other_nuc # D00068.1",
    "special  N00069  ddbj_other_nuc # D00069.1",
    "special  N00070  embl_ddbj      # X04036.1 = D00070.1",
    "special  N00078  ddbj_other_nuc # D00078.1",
    "special  N00079  ddbj_other_nuc # D00079.1",
    "special  N00083  ddbj_other_nuc # D00083.1",
    "special  N00088  ddbj_other_nuc # (M16550.1 =) D00088.1 = D10032.1",
    "special  N00090  ddbj_other_nuc # (X05597.1 =) D00090.1",
    "special  N00091  ddbj_other_nuc # (M15807.1 =) D00091.1",
    "special  N00092  ddbj_other_nuc # D00092.1",
    "special  N00093  ddbj_other_nuc # (M34437.1 = X04797.1 =) D00093.1",
    "special  N00094  ddbj_other_nuc # (X05040.1 =) D00094.1",
    "special  N18624  gb_other_nuc   # *L29496.1 / M23263.1",
    "special  N20001-N97317  gb_est",
    "special  N97318-N97531  gb_gss",
    "special  N97532-N99999  gb_est",
    "",
    "# Nominally gb_est.",
    "special2 T+5 gb_gss",
    ": 02634-808 9496-993",
    "",
    "# Nominally gb_dirsub.",
    "special2 U+5 gb_est",
    ": 01537-51 921 13686 4111-4 71 5041-7 988 7154 513-64 82-4 905-9 76-7",
    ": 99-8008 10-7 9036 135-41 512-5 678-93 732 72 823 21073-81 3-5 457-70 33921",
    ": 4233-44 396-400 5429 6594-6 7151-64 229 31-4 913-35 7-8174 9396 407-8 588-607",
    ": 40055 140-3 53 589 629 1133-61 297 2490-1 570-9 751 3146",
    ": 4093-102 35-377 981-90 54592-607 706-33 5-9 79 5034 777 962-91 6653-60 7844",
    ": 8051-82 979 9417 9 755-6 60299-311 799 2909 3519 22-8 4597 679 965-6",
    ": 5082 383-9 438-9 740 917 6423 576-7 693-7 718",
    "special2 U+5 gb_gss",
    ": 19502-10 21493-545 37588 60606-38 1299-300 522-5 5903-5 6210-3 5 97486 8 90 3",
    "# Respective (EST, GSS, STS) range counts:",
    "# (21, 1, 0); (18, 1, 0); (30, 5, 0); (13, 5, 0); (103, 35, 1)",
    "special2 U+5 gb_other_nuc",
    ": 23049-6690 7989-31698 46160-53560 67850-70383 2041-95639",
    "",
    "# Nominally embl_dirsub.  Give the benefit of the doubt to sequences",
    "# that look like embl_con, embl_genome, or embl_other_nuc, but split",
    "# out EST ranges.",
    "special2 X+5 embl_est",
    ": 61801-99 2402 5268-75 374-93 71637-41 3-52 3542-8 704-804 6318 487 8018-28",
    ": 82204 3032-4 304-66 4313 711-21 5546-725 6144-6 218-20 7300-5 9987-96",
    ": 90532-45 1308-35 672-734 2440 790-803",
    ": 3012-4 79 227-300 413-60 811-67 915-9 88-9 4486-532 5581 686 6619-25",
    ": 7503-19 896-7 8134-40 98-204 425-8 548-54 9272",
    "",
    "# Nominally embl_dirsub.  Give the benefit of the doubt to sequences",
    "# that look like embl_genome or embl_other_nuc, but split out EST",
    "# ranges.",
    "special2 Y+5 embl_est",
    ": 07823 8464-83 705-14",
    ": 9139 316-20 59-64 75-7 459-64 519-23 43-5 726-32 875 981-6",
    ": 10008-10 37-42 56-60 217-20 671-2 1191 308 615 4396-402 6130-1 971-4 8366",
    "",
    "# Nominally embl_dirsub.  Give the benefit of the doubt to sequences",
    "# that look like embl_genome or embl_other_nuc, but split out EST",
    "# ranges.",
    "special2 Z+5 embl_est",
    ": 24464-546 760-6",
    ": 9-5279 83-392 400-17 86-508 10-8 46-86 8-733 76-94 9-801 5-8 25-6 32-50",
    ": 89-6039 45-132 84-235 7-8 43-4 323-30 42-480 95-517 25-79 658-752 4-64 72-823",
    ": 68-74 952-66 71-7066 95-104 240 9-303",
    ": 38136-46221 43-8 91-8 428-30 510-20 6-94 677-718 813-22 30-2 974-80",
    ": 7057-65 278-348 50-1 82-408 575-720 801-2 985",
    ": 8368-427 45-8 53-67 545-60 608-11 37 9229-32 744-5 54295-305 9-11",
    ": 69578-84 945-72 4-5 83-4 71789-924 2392-421 4621-61 8280-408 81149-290",
    ": 2016-7 913-35 3019-66 980-4196 92674-705 3025-38 725-63 4848-63",
    ": 7038-47 731-830 62-72 8057-138 443-527 764-819 21-45 9067-89 348-435",
    "# 69 and 84 EST ranges, respectively.",
    "special2 Z+5 embl_other_nuc",
    ": 12653-23155 8355-38124",
    "",
    "# Nominally ddbj_dirsub.",
    "special2 AB+6 ddbj_est",
    ": 158145 279-87 432 9214-7 736-9 63429 31 6724 327169 31173-92 734-46 927-49",
    ": 4239 53143 4879 61047-52 241-4 92-358 4678-9 71430-572 2866-75",
    ": 3997-4042 263-5 5019-60 433981 4937-50 7321-44 46243-391 7894-981 8953-9020",
    ": 50689-761 8260-300 688-789 61364-72 71888-91 4609-19 21-714 6-21 6-39 41-8",
    ": 80784-824 5714-5 64-70 960-92 92065-83 505865-73 9259 16772-956 7053-143 5",
    ": 29438-45 35102-4 7328-9 42429-50 52736-841 3313-5 68279-90 71597-602 2918-21",
    ": 3693-709 5970-8 6812-50 85974-96 94978-5127 602400-24 13266 7526 26803 40724",
    ": 6299-300 21-45 68572-7 9437-64 709967-10073 34662-75 8045-62 42236-51",
    ": 57677-705 811436 23195-214 7265-7 62603-877 3290-461 99003-14 922020-116",
    "# 197 and 80 EST ranges, respectively.",
    "special2 AB+6 ddbj_other_nuc",
    ": 001540-128048 78168-308274",
    "",
    "# Nominally gb_dirsub.",
    "special2 AF+6 gb_est",
    ": 390017 858 1795 801-4 6-7 6868 405213-30 8415-6 11092-9 20231 5300 36075",
    ": 9734 6 961-72 41178-82 4-7 8511-2 51165-81 3-9 3446 4762 6411 61771 8668-72",
    ": 9688-92 86818-9 7314-25 7-9 92356 503187-9 588 6703-6 7053 8 60 10188-90",
    ": 6758-66 20437-9 964 1978-2027 5702 7684-733 33598-600 8926-7",
    "special2 AF+6 gb_gss",
    ": 384864-5 7113-21 96672 7194 400792-848 1241-71 16103-38 35833-7 40734",
    ": 1725 60-9 7921 9707-12 55790-802 65471-4 72511 92012-4 272 4494-5 509571",
    ": 15664-5 21604 4047-260 2-826 5774-5 9172 34530-3 7199-202 42503",
    "special  AF000235-AF373213  gb_other_nuc # 585 EST ranges and 303 GSS ranges",
    "",
    "special  AG266800-AG266855  ddbj_dirsub # Nominally ddbj_gss.",
    "",
    "# Nominally embl_dirsub.  Give the benefit of the doubt to sequences",
    "# that look like embl_genome or embl_other_nuc, but split out EST and",
    "# GSS ranges.",
    "special2 AJ+6 embl_est",
    ": 131530-1 4 640 743 2447-53 743-4 6-7 68 70 3279-310 423 627-30 823-32 87-91",
    ": 344568-620 5961-6853 7704-8 8845-907 441341-56950 7094-5 215-787 97-801",
    ": 995-8180 9102-5 60001-86853 646897-97608 763-4 8954 9509-703791 4820 66-927",
    ": 5105-15323 6425-7291 9195-266 21139-44704 5200-660 6228-32 346 581-7913",
    ": 9659-68 50001-67053 69-80913 1008-24 3757 4436-774 5005-280 96-566 755",
    ": 6842-809161 10177-8 2737-21279 81-793 924-9440 31476-83 580-6 846-2104",
    ": 3020-569 920420-36931 7840-2 4-6 8-51 3-4 6 8183-64871 6338 532-70 7011-5",
    ": 8963-85 70155-60 2495-503 3481-591",
    "# Respective (EST, GSS) range counts:",
    "# (37, 0); (106, 0); (46, 0); (41, 0); (46, 0); (55, 0); (63, 2).",
    "special2 AJ+6 embl_other_nuc",
    ": 003249-13072 223808-52067 69829-320073 88667-441054 87042-519345 32915-83526",
    ": 601557-46868 843898-920257",
    "",
    "# Nominally embl_dirsub.  Give the benefit of the doubt to sequences",
    "# that look like embl_con, embl_genome, or embl_other_nuc, but split",
    "# out EST and GSS ranges.",
    "special2 AL+6 embl_est",
    ": 022607-715 30-3086 993-4449 59-60 33283-374 42366-3422 79357-851 3-77",
    ": 9-80030 2-55 110302-468 7695-8492 560-21566",
    ": 32634 45-7 95-706 81-90 802-17 29-37 910-42 3667-5743 7939-8463 519 57506-686",
    ": 62087-101",
    ": 3072-135 54 96 331-480 93-504 13-22 614-35 43 92-701 12-59 61-2 73-84 892-901",
    ": 352973-5 94-3006 958-85 4617-21 5193-214 755-64 890-912 4-5 7-8 60374-5136",
    ": 523-89869 91923-74 2063-7 441606-20 2-3 9467-917 50491-982 99630-500520",
    ": 42-12267 40321-1353 83964-9147 204-622 96479-603622",
    ": 63683-6314 6-416 8-705 7-821 3-7261 4-371 3-8474 6-875",
    ": 7-9016 8-138 40-810 2 90 994-7 91524-713628 805-37 4032-31499 899-2289 97-307",
    ": 49534-9 41-50301 3-1363 808211-23461 4717-31324 4580-7504 29-40622 45-932",
    ": 1430-4138 226-479 901610-28536 9474-90 609-35024 73-113",
    "special  AL160494-AL161251  embl_gss",
    "# Respective EST range counts:",
    "# 182, 72, 490, 393, 251, 3583, 1244, 3341, 5767, 638.",
    "special2 AL+6 embl_other_nuc",
    ": 034585-42364 3424-9170 513551-40319 1355-83950 93862-6018 627462-63681",
    ": 71927-83797 773605-805894 45558-901606 54873-73407",
    "",
    "# Nominally embl_dirsub.",
    "special2 AM+6 embl_est",
    ": 003907-39430 41272-897 9-928 2018-538 715-8613 9439-915 51087-9 366-5585",
    ": 6504-62638 766-3038 43-71350 401-5 8 10-1 520-2286 430-44 5249-607 83343-946",
    ": 5154-297 8777-109845 10258-692 1128-305 50-1 76-3422 870 5672-94 7760-79",
    ": 37442-56757 7797-8083 9647-60600 1052-90 647-2203 5128-7516 8256-69 526-76418",
    ": 7644-9408 80191-250 4308-228715 9723-30448 1596-607 751-2 2089-226",
    ": 3524 688-739 7575-81 631-802 8-28 59062-6 60753-90 1635-51 893-919",
    ": 3561-5360 78-89 633-7 7321-478 8883-94 79675 83547-4142 5455-649 6691",
    ": 7291-91980 2305 925-6 3570-88 624 5342-5 6550-384871 493773-867 5471-722",
    ": 6020-68 70-7466 8769-500636 8 2267-86 3942-52 4150-600638 95771-6203 311-688",
    ": 713476-43079 50062-65799 6003-73228 4151 9939-849033 823-50054 1127-82506",
    ": 950553-80446 1402-2512 822-3454 577-8621 91118-27 2040-7 256-457",
    "# 21, 23, and 183 EST ranges, respectively.",
    "special2 AM+6 embl_other_nuc",
    ": 384993-422606 743198-8699 894321-950290",
    "",
    "# Nominally ddbj_est.",
    "special2 AU+6 ddbj_dirsub",
    ": 024804-9241 46301-50022 808-15 62283-350",
    ": 6497-8 500 4 6 11-2 4-5 21-4 7-9 35 40-2 4 6 8-53 5 7-8 78429-598 90535",
    ": 279339 78",
    "special  AU036596-AU036726  ddbj_gss",
    "",
    "special  AX114121           embl_dirsub # Nominally embl_patent.",
    "",
    "# Nominally gb_dirsub.",
    "special2 AY+6 gb_est",
    ": 007260 30235-6 2615-6 902 79 3289 42532 8753 63513 93804-17 6240 120880",
    ": 5856-90 39011-23 60682 6588 8429-39 89691-2 5 96929-33 243511 5441 311391",
    ": 21461-2 5801-2 6073 45126 7477 56158-311 7293-5 77860-4 95905 449735-46",
    ": 57064-5 60108-11 5830-2 94600-4 517518 8259-64 47439-57 53914 60545-6 8-50",
    ": 77286-7 89693-4 700-1 4 8-10 651316 78444-9 9774-8 86735-47 8838-40 714068-71",
    ": 36327 40678 50901-4 88904 96341 803125-65 31429 79586-91 85220-1 922984-8",
    ": 8802-5 52968-70 66462-85 87852 94354-6",
    "special2 AY+6 gb_gss",
    ": 026952-7433 38985-7 9709-12 55854 79522-80585 123938 7080-557 56078-82",
    ": 60080-2 6650-1 74766-78 98434-201593 5-640 2-91 3-3610 44458 65801-4 70178-81",
    ": 82782-5 352272-3 66892-9 91730-44 489065-6 91396-8 580990-4 3837 648006-7",
    ": 65687 85649-61 758600-60022 98-631 40-1013 822675-7 31657-67 8273-7 57201",
    ": 66420-4 70328 2191-255 390-3704 98612 993980-4",
    "",
    "# Nominally embl_dirsub.",
    "special2 BX+6 embl_est",
    ": 000562-687 710-59 976-9 88730-119313 401-900 248593 783-982 6-9708 63-51408",
    ": 14-5275 9-804 79530-83066 8-4108 94120-1 98-232 5243-348 50-8 60-78 80-516 8",
    ": 318044-558 466087-922 7129-9883 70269-510298 1045-7 314-23 33-26833 5-30014",
    ": 48257-69683 601649-29297 361-40397 1173-7061 63509 77677-8768 77-9656",
    ": 76-81414 9-2226 40-527 59-952 6-769172 7-84021 33 44-278 81-385 834112-41509",
    ": 61004-521 3-681 3-2186 7358-914 72508-3028 9625-80165",
    ": 9494-90135 7-88 90-8 200-2 4-24 6-32 4-308 10-94 6-483 5-537 7754-9178",
    ": 82-901874 27416-8738 59-9267 50875-7214 366-7",
    "# Respective EST range counts:",
    "# 403, 815, 309, 42, 5821, 79, 573, 596, 51, 66, 76, 119, 343.",
    "special2 BX+6 embl_other_nuc",
    ": 072585-88684 255991-79521 96570-318042 560-21855 3813-465182 540327-980",
    ": 664722-77662 842705-61002 2188-7356 916-72506 3030-9623 80167-9492",
    ": 908815-27274",
    "",
    "# Nominally gb_genome.",
    "special2 CP+6 gb_dirsub",
    ": 000925 2027 6698 10455-6 3186 4940 92 6816",
    "",
    "# Nominally embl_dirsub.  Give the benefit of the doubt to sequences",
    "# that look like embl_genome, but split out EST ranges.",
    "special2 CR+6 embl_est",
    ": 278161-93495 407721-50243 7485-77643 502047 59947-89873 627501-8310 421-31118",
    ": 735161-49142 881-51205 41-527 621-2637 62-728 30-981",
    ": 3-3092 4-178 80-308 10-27 9-416 8-20 2-508 10-608 10-33 5-50 2-793 5-802 4-11",
    ": 907-9280 2-423 5-701 3-31 62499-4089 98-7811 22-9762 70518-4176 201-5849",
    ": 86583-8225 341-90347 90-2412 926157 498-878 80-6 8-910",
    ": 2-7049 51-214 6-367 9-455 7-78 80-552 4-31631 8765-40296 2245-70 5 825-4659",
    ": 74421 599-99998",
    "# 315, 307, 134, and 70 EST ranges, respectively.",
    "special2 CR+6 embl_other_nuc",
    ": 354614-94505 450855-7481 513801-59927 848861-57055",
    "",
    "# Nominally embl_dirsub.",
    "special2 CT+6 embl_est",
    ": 000001-5229 9777-10161 409-25 25916-7 485799-989 563249-71240 79-2707",
    ": 4594-83622 731-737118 258 62376-504 6185-353 73820-949 51-4143 912-5059",
    ": 7272-416 80757-877 1913-2070 2-90 2-100 2-10 2-24 6-50 2-83 5-7 9-321",
    ": 6112-237 92226-352 3397-519 4724-853",
    ": 842009-118 20-1 3-30 2-47 9-58 60-78 80-1 3-516 8-28 30-1 3-40 2-63709 15-33",
    ": 8744-928681 3-38375 43670-50687 62514-3069 97-104 71504-71",
    ": 8604 6-46 8-9 51-2 4 6-77 9 81 3 5-926 8-56 8-89251 8-90465 74-86 90-531",
    "# Respective EST range counts:",
    "# 1381, 153, 322, 37, 84, 137, 39, 147, 219, 36, 48, 2036, 367",
    "special2 CT+6 embl_other_nuc",
    ": 737431-62374 507-6183 355-73818 4146-910 5061-7270 418-80755 879-1911",
    ": 2323-6110 239-92224 354-3395 521-4722 855-823556 938377-40347",
    "",
    "# Nominally embl_dirsub.",
    "special2 CU+6 embl_est",
    ": 062670-842 4-6 8-74269 339-82 423-5311 931-6039 234182-94 302207 9-16 324",
    ": 6818-10069 76-1182 67886-8379 81-441 3-521 3-6 8-600 2-745 7-50",
    ": 2-9046 8-187 9-553 5-65 7-72896 931-92058 4257-405559 15883-24422 74 96-42700",
    ": 64-57374 87231-98825 9388-524144 6-85 7-607 9-47",
    ": 9-5008 10-305 7-17 9-433 5-727 9-806 8-920 2-30337 421-8870 9140-50647",
    ": 735-65320 96016-606845 7105-11033 62-8304 43-27974 8007-33156 7754-8663",
    ": 9489-40365 490-880 60014-72219 81473-818",
    ": 2012-338 67-456 8-575 7-600 2-3 5-21 3-39 41-61 3-763 5-6 8-76 8-9 81-810",
    ": 2-3823 8-64 4056-6587 93503-4195 5349-740080 862081-96531 700-905499",
    ": 513-14123 83906-4539 6307-93795 823-9999",
    "# Respective (EST, GSS) range counts: (81, 1); (43, 0); (231, 0); (41, 0).",
    "special2 CU+6 embl_other_nuc",
    ": 457503-87206 98835-9386 565322-96014 651679-60012",
    "",
    "# Nominally ddbj_gss.",
    "special2 DE+6 ddbj_dirsub",
    ": 990447-894 7363-8419",
    "",
    "# Nominally gb_dirsub.",
    "special2 DQ+6 gb_est",
    ": 000203-5 3271-4 5448-52 6915-21 8074-87 9493 10056 23561-96 54537 6320-36",
    ": 62432 8265-7 71657-67 9655-7 82731 90495-9 118389-93 9294 38061-9 59946-7",
    ": 72857-99 90447-9 205195-9 7956 11055-83 697 7772 25105-7 38007-10 56365-8",
    ": 86755-9 96475-80 301872-6 6698-705 41431-41 9205-6 51838-40 4361 94888-90",
    ": 672588 821447-72 2605-89 58157-64 73299-317 83824-4159 6384-9 999011-23",
    "special2 DQ+6 gb_gss",
    ": 072281-378 3526-30 92578-99 3275-84 103519-23 14785 5593-640 24861-7 31496",
    ": 7423-5 56350-63 60233-40 76001-2 8992-4 219385-92 323032-5 9527-9 34866",
    ": 51716-21 99337-8 530238 641039 866805 988883-928",
    "",
    "# Nominally gb_con.",
    "special2 DS+6 gb_dirsub",
    ": 483562 659",
    ": 4496-515 8-35 8-50 2-3 5-74 6-611 4-23 5-6 8-33 5-7 9 41-54 6-75 7-86 8-703",
    ": 6-7 9-10 2-6 8-42",
    ": 5148-67 9 72-4 6-8 81-2 4 6 9-90 2 4-5 8-201 3-5 8-9 11 5-6 8-21 3-30 3 5-6",
    ": 8-40 2-3 5-7 9-68 70-1 3 5 7-8 80-1 3-5 7-8 90-2 4 6-306 9-11 3-6 8-20 2-6",
    ": 8-31 3-43 5 9 51 3-4 6-65 8 70-1 4-6 8-9 81-90 2-3 5 7-401 3 7 9-11 5-6 8-30",
    ": 3-4 6-43 8 50-4 6-7 9-62 4-73 5-8 81-3 8 90-2 4-8 500-1 3-6 9 12 4-5 7-8 20-3",
    ": 5-45",
    "# 159, 80, and 95 dirsub ranges, respectively.",
    "special2 DS+6 gb_other_nuc",
    ": 483744-4493 745-5146 547-6008",
    "",
    "# Nominally gb_dirsub.",
    "special2 EF+6 gb_est",
    ": 063001 189906-16 377525-37 422869 73211-5 94771-3 552376",
    "special2 EF+6 gb_gss",
    ": 053039-49 95769 165098 82756-8 204530-3 8191 10438-53 578434-635 92824-944",
    "",
    "# Nominally gb_dirsub.",
    "special2 EU+6 gb_est",
    ": 152056-79 239816 364506-7 8044 9669 420034 597223-8",
    "special  EU306364-EU306386  gb_gss",
    "",
    "# Nominally gb_dirsub.",
    "special2 FJ+6 gb_est",
    ": 710154-5 842632-42",
    "",
    "# Nominally embl_dirsub.",
    "special2 FM+6 embl_est",
    ": 000001-160408 4769 940 5392 707-72746 8562-778 80579-96445 205236-493 777-831",
    ": 7878-900 8280-711 851 900 12937 5048-42054 6886-51871 3361 6-8 72 8 864313-44",
    ": 7-5295 8295-72275 9143-81767 2258-3162 5959-6821 7038-96881 7212-3",
    ": 377-945301 441-999 6183-54971 7013-79 8532-85957 92847-50 9776-87",
    "",
    "# Nominally embl_dirsub.  Give the benefit of the doubt to sequences",
    "# that look like embl_genome, but split out EST ranges.",
    "special2 FN+6 embl_est",
    ": 000001-177896 9489-82188 288-5725 6135-90445 7-252183 460-789 63376-92969",
    ": 377870-86264 93571-732 830-49 424437-8571 30839-1219 34-660",
    ": 2032-41 154-328 729-75 3834-7 5336-50 539079-43092 51261-733 2552-91 699-705",
    ": 5710-987 7216-23 61898-924 2175-396 4151-8 5576-6839 88437-94512 600697",
    ": 1407-10843 1035-40462 581-1653 925-3079 6764-7626 51825-6 2903-4 61971-2351",
    ": 4012-5290 9777-73545 9295-86775 91927 2044-706436 565-73062 104-70 96618-723",
    ": 987-806772 826-48 11794-851 944-2314 3225-6 467-9 4310-20203 2244-743 3242-54",
    ": 68597 902-29 9177-376 70962-907899 8254-302 85040 644-93914 7680-8838",
    ": 9023-906",
    "",
    "# Nominally embl_dirsub.",
    "special2 FO+6 embl_est",
    ": 000003-76577 82887-117570 633-81358 544-203352 528-393391 680693-1285",
    ": 704924-22023 981374-99999",
    "",
    "# Nominally embl_dirsub.",
    "special2 FP+6 embl_est",
    ": 000001-3579 602-9753 5-8 60-1 3-4 6-12228",
    ": 24615-57328 30-70 456-62 562-6 704-9",
    ": 8162-3 5 7 9 71-2 4 6-7 80 3-90 282 4 6 526-7 9 31-2 4 7 9 42-3 5 7-53 708-13",
    ": 9328 30-2 4 7 9 41 3 5 8-52 87-93 60212-7 1764-9 2315-21",
    ": 3036-40 449-53 804-12 900-4 5159-7333 453-74848 89705-949 90914-1223",
    ": 101920-50 4570-236120 870-43270 5546-312611 8637-25096 31359-9571",
    ": 630-40170 462-88 50355-60034 6-458874 6-75875 89021-539727 30-65142 937-78983",
    ": 9010-83343 56-628470 2-71119 40-80548 607-90338 50-700052 189-10243 58-91398",
    ": 400-884219 35-5524 45-822 927-93245 7-924936 7985-8978 90-5 9145-99998",
    "# Respective EST range counts: 33, 43, 39, 16, 141, 45, 33, 95, 44, 15, 248,",
    "# 14, 187, 22, 136, 104, 552, 234, 246, 39, 11, 166, 154, 35, 74, 208, 251.",
    "special2 FP+6 embl_other_nuc",
    ": 057373-454 65-560 8-656 64-702 11-8036 42-155 92-271 93-514 56-658 73-706",
    ": 15-9322 54-85 95-833 41-87 95-60210 9-469 77-1762 71-2313 24-896 906-99",
    ": 3008-34 43-447 55-802 14-98 906-4076 82-562 9-5157",
    "",
    "# Nominally embl_dirsub.",
    "special2 FQ+6 embl_est",
    ": 000001 5-14216 36-32656 836-73829 967-116746 8-209379 35350-42479",
    ": 312199-23093 164-61146 9-77486 8-516 98062-439981 3-40019 21-2 4 6 8 30-2",
    ": 4-56868 75-82045 8-71 660554-70147 790408-828345 8-57191 9091-175 87-65452",
    ": 7-908260 7-58209 13-76554 923-99999",
    "",
    "# Nominally embl_dirsub.  Give the benefit of the doubt to sequences",
    "# that look like embl_con or embl_genome, but split out EST and TPA(!)",
    "# ranges.",
    "special2 FR+6 embl_est",
    ": 595163-647444 60151-6602 8536 9245-6 86584 963-5 8150-9535 91564 7056-714330",
    ": 9326-692 26163-5 8240-1 9927-31105 4407-44448 6042-4 111-7822 8230-9648",
    ": 53167-4317 554-71822 3977 5966 819721-44 28827-31799 6483-7532 42-92",
    ": 9767-45655 6456-60 537-887 7124-45 228-840 88-943 8368-71 50135-57 1958",
    ": 2768 894-904 4398-6581 63689-4978 9720-95 73995-4005 7779-8008 32-40",
    "special2 FR+6 embl_tpa_nuc",
    ": 734011-74 49997 821738-54 2741 72817 7768-77",
    "",
    "special  GQ162211-GQ162212  gb_est # Nominally gb_dirsub.",
    "",
    "# Nominally gb_dirsub.",
    "special2 GU+6 gb_est",
    ": 357827-40 85812",
    "",
    "# Nominally embl_dirsub.",
    "special2 HE+6 embl_est",
    ": 575663-7 8177-80 289-716 80226-8 600073-122 2495-530 12182 7969-46283",
    ": 81861-82 775617-92769 5538-641 9315-645 802076-106 58615-9937 62417-958",
    ": 957083-61812 2539 7924-57 81808-3324 5332-93548",
    "special2 HE+6 embl_tpa_nuc",
    ": 580237-8 3424-588 613800 804769-72 963851-4756 7761",
    "",
    "# Nominally embl_dirsub.  Give the benefit of the doubt to sequences",
    "# that look like embl_genome, but split out EST, TPA(!), and WGS ranges.",
    "special2 HF+6 embl_est",
    ": 546137-200 978 66097-123 7775-843 952730-71 3988-4002",
    "special2 HF+6 embl_tpa_nuc",
    ": 564658-815 933207-30",
    "special  HF913790-HF920632  embl_wgs_nuc",
    "",
    "# Nominally embl_dirsub.  Give the benefit of the doubt to sequences",
    "# that look like embl_genome, but split out EST and TPA(!) ranges.",
    "special2 HG+6 embl_est",
    ": 000495-664 1312-9 314154-951 26529-98 421036-67 4982-5075 516089-8058",
    ": 792878-996 8530-3 964498-527 5112-28 70048-64",
    "special2 HG+6 embl_tpa_nuc",
    ": 313979-4002 22958-3812 8835-9089 425120-3 6065-183 91497-512884 8794-28968",
    ": 31973-2008 780872-92014 931734-849 75377-438 7712-83278 548-6399",
    "",
    "special  HM042681           gb_est # Nominally gb_dirsub.",
    "",
    "# Nominally gb_dirsub.",
    "special2 HQ+6 gb_est",
    ": 385980-98 436350 596498-504 603829-54 16895-912 34394-477",
    "",
    "special  JN376805-JN377341  gb_est # Nominally gb_dirsub.",
    "",
    "special  KF487514           gb_est # Nominally gb_dirsub.",
    "",
    "special  KJ472321-KJ472336  gb_est # Nominally gb_dirsub.",
    "",
    "special  KM673248-KM673271  gb_est # Nominally gb_dirsub.",
    "",
    "# Nominally embl_dirsub.",
    "special2 LK+6 embl_tpa_nuc",
    ": 000001-20668 937705-9125",
    "special  LK985528-LK995307  embl_est",
    "",
    "# Nominally embl_dirsub.",
    "special2 LM+6 embl_tpa_nuc",
    ": 378690-83429 608092-11902 44135-234",
    "special  LM994684-LM994695  embl_est",
    "",
    "# Nominally embl_dirsub.  Give the benefit of the doubt to sequences",
    "# that look like embl_con, but split out EST and TPA(!) ranges.",
    "special2 LN+6 embl_est",
    ": 624403-4 51082-92 553-78462 80257-71 879549-837 901386-412",
    "special2 LN+6 embl_tpa_nuc",
    ": 607841-8991 714474-514 94245-6 809256-883 46618-9 7449-8230 9001 71971-2940",
    ": 4312-522 85135-43 5-62 4-70 2-202 4-36 98187-98 901194-210",
    "",
    "# Nominally embl_dirsub.",
    "special2 LR+6 embl_tpa_nuc",
    ": 130242-508 594708-9 760818-1312",
    "",
    "# Nominally embl_dirsub.",
    "special2 LT+6 embl_est",
    ": 159851-65 556286-8089",
    "special2 LT+6 embl_tpa_nuc",
    ": 548096-244 71433-5 605004 31550-670 906301-58 62964-3174 90249-597",
    "",
    "# Nominally (conservatively) embl_other_nuc.",
    "special  OB000001-OB660024  embl_con",
    "",
    "# Some \"EMBL\" WGS nucleotide accessions are really third-party annotations.",
    "special2 CAADSF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAADSM000000000-CAAGJX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAAGKD000000000-CAAGKQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAAGKS000000000-CAAGRI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAAGRK000000000-CAAGSH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAAHDL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAAHDO000000000-CAAHFA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CABPVU000000000-CABUTS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CABUTU000000000-CABVEI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CABVEV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CABVEX000000000-CABVGH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CADEPO000000000-CADEVH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CADEVJ000000000-CADFGZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFHB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFHD000000000-CADFHE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFHJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFHO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFHU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFIH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFIK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFIN000000000-CADFIO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CADFIS000000000-CADFIT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFIW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFJB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFJH000000000-CADFJJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFJL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFJN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFJQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFJS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFJU000000000-CADFJW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFKB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFKF000000000-CADFKG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFKJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFKL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFKS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFKY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFLF000000000-CADFLG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFLT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFMD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFMI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFMR000000000-CADFMS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFMX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFNE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFNK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFNO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFNR000000000-CADFNS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CADFNW000000000-CADFNY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFOC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFOE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFOI000000000-CADFOJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFOM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFOT000000000-CADFOU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CADFOX000000000-CADFOY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFPB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFPF000000000-CADFPG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFPK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFPM000000000-CADFPN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFPQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFPX000000000-CADFPZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFQB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFQL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFQP000000000-CADFQR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFQU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFQY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFRA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFRE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFRG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFRJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFRR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFRV000000000-CADFRW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CADFRY000000000-CADFSB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFSD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFSL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFSS000000000-CADFST999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFSW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CADFSZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFTF000000000-CADFTG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CADFTJ000000000-CADFTL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFTS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFTU000000000-CADFTY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADFUB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CADFUE000000000-CADFUF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CADFUH000000000-CADFUK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CADFUM000000000-CADFUO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CADFUQ000000000-CADFUT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CADKUY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAJJIC000000000-CAJJID999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJJIG000000000-CAJJIK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAJJIM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAJJIQ000000000-CAJJJK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJJJM000000000-CAJMTE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJSFZ000000000-CAJSGD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJTIX000000000-CAJTJC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJTJE000000000-CAJTJH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAJTJJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAJTJS000000000-CAJTJT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAJTJV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAJTJY000000000-CAJTKB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAJTKE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAJTKG000000000-CAJTKL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAJTKS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAJTKU000000000-CAJTXH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJTXK000000000-CAJURP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAJURR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAJURT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAJURV000000000-CAJUSB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJUSD000000000-CAJUSU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAJUSW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAJUSZ000000000-CAJUTC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAJUTE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAJUTH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAJUTJ000000000-CAJUTM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAJUTQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAJUTS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAJUTV000000000-CAJUTW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJUTY000000000-CAJUUA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJVVG000000000-CAJVVN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJVVR000000000-CAJVVX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAJVVZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAJVWG000000000-CAJYBX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJYCH000000000-CAJYCJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAJYLB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAJZDA000000000-CAJZFS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJZFU000000000-CAJZHB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJZHD000000000-CAJZHK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAJZHP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAJZHR000000000-CAJZHT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJZHV000000000-CAJZHZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJZIB000000000-CAJZJZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJZKB000000000-CAJZLA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJZLC000000000-CAJZLH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAJZLJ000000000-CAJZLK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAJZLM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAJZLO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAJZLS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAKAEN000000000-CAKAIS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKAOQ000000000-CAKASD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAKMHU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAKMHW000000000-CAKMJE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKMKY000000000-CAKMLH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKMLJ000000000-CAKMLK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKMLM000000000-CAKMME999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKMMH000000000-CAKMMO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAKMMQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAKMMS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAKMMU000000000-CAKMMV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKMMX000000000-CAKMMZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKMNB000000000-CAKMNE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKMNH000000000-CAKMNP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKMNX000000000-CAKMRG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKMRL000000000-CAKMRN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKNFQ000000000-CAKNSC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKZFW000000000-CAKZJO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKZJV000000000-CAKZRW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAKZSJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAKZSL000000000-CAKZSM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAKZSP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAKZSR000000000-CAKZST999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKZSW000000000-CAKZTC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAKZTF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAKZTH000000000-CAKZTL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAKZTN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAKZTP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAKZTR000000000-CAKZTS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKZTU000000000-CAKZTX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAKZUA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAKZUC000000000-CAKZUD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKZUH000000000-CAKZUI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAKZUO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAKZUW000000000-CAKZUZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAKZVH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAKZVM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAKZVO000000000-CAKZVT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKZVV000000000-CAKZWE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKZWG000000000-CAKZWO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKZWR000000000-CAKZWZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKZXB000000000-CAKZYZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAKZZB000000000-CALAHR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALAHT000000000-CALAIE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALAIG000000000-CALAII999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALAIK000000000-CALAIN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALAIP000000000-CALAIV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALAJC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALAJE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALAJI000000000-CALAJJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALAJU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALAJW000000000-CALAJY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALAKA000000000-CALAKD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALAKF000000000-CALAKG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALAKI000000000-CALAKK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALAKN000000000-CALAKP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALAKS000000000-CALAKT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALAKV000000000-CALAKY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALALA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALALC000000000-CALAMG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALAMJ000000000-CALAMK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALAMP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALAMR000000000-CALAMW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALAMY000000000-CALAMZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALANB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALANE000000000-CALANI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALANK000000000-CALANX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALAOA000000000-CALAOB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALAOD000000000-CALAOE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALAOG000000000-CALAOZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALAPC000000000-CALBAC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALBAE000000000-CALBAI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALBAL000000000-CALBBG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALBBI000000000-CALBBP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALBBR000000000-CALBCM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALBCP000000000-CALBCW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALBDA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALBDC000000000-CALBDF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALBDH000000000-CALBDN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALBDP000000000-CALBDX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALBEH000000000-CALBEJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALBEM000000000-CALBUG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALBUJ000000000-CALBUP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALBUR000000000-CALBUZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALBVB000000000-CALBVH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALBVJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALBWE000000000-CALBWJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALBWL000000000-CALBWR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALBWT000000000-CALCDC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALCDE000000000-CALCIN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALCIP000000000-CALCJG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALCJJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALCJL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALCJQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALCJU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALCJW000000000-CALCKF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALCKH000000000-CALCKO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALCKS000000000-CALCKT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALCKV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALCKZ000000000-CALCLK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALCLM000000000-CALCLN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALCLQ000000000-CALCMD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALCMF000000000-CALCMH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALCML000000000-CALCMT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALCMW000000000-CALCRH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALCRJ000000000-CALCUV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALCUX000000000-CALDAU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALDAW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALDBA000000000-CALDBE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALDBG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALDBI000000000-CALDCB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDCD000000000-CALDCJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDCM000000000-CALDCN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDCP000000000-CALDCS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDCU000000000-CALDDG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDDJ000000000-CALDDL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDDS000000000-CALDDT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDDW000000000-CALDDX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDDZ000000000-CALDEA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDEC000000000-CALDEL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDEQ000000000-CALDEV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDEX000000000-CALDEY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALDFA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALDFC000000000-CALDFU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALDFX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALDGB000000000-CALDGE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDGG000000000-CALDGM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDGO000000000-CALDGP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDGR000000000-CALDHC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALDHE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALDHN000000000-CALDHY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDIA000000000-CALDKT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDKW000000000-CALDSN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDUU000000000-CALDUX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDUZ000000000-CALDVB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDVD000000000-CALDVO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDVQ000000000-CALDVV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDVX000000000-CALDVZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDWB000000000-CALDWF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDWH000000000-CALDWQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDWS000000000-CALDWV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDWX000000000-CALDWY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDXA000000000-CALDXI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDXK000000000-CALDXX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDXZ000000000-CALDYB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALDYD000000000-CALDYI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALDYK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALDZM000000000-CALDZN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALDZV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALEAA000000000-CALEAB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEAH000000000-CALEAP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEAR000000000-CALEAU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEAW000000000-CALEBJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEBL000000000-CALEBS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEBU000000000-CALECA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALECC000000000-CALECD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALECG000000000-CALECO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALECR000000000-CALECS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALECU000000000-CALECY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEDA000000000-CALEDG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALEDK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALEDM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALEDO000000000-CALEDQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEDX000000000-CALEEB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEED000000000-CALEPD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEPF000000000-CALEPJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEPL000000000-CALETK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALETM000000000-CALETT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALETV000000000-CALETW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALETY000000000-CALEUF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEUH000000000-CALEUN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALEUP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALEUR000000000-CALEUW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEUZ000000000-CALEVQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEVS000000000-CALEVY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEWA000000000-CALEWE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEWG000000000-CALEWI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEWK000000000-CALEWX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEWZ000000000-CALEXO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEXQ000000000-CALEXZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEYB000000000-CALEYC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEYE000000000-CALEYJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALEYL000000000-CALFAJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALFAL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALFAN000000000-CALFAU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALFAW000000000-CALFAX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALFAZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALFBY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALFCA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALFCC000000000-CALFCD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALFCH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALFCJ000000000-CALFCT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALFCW000000000-CALFCY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALFDB000000000-CALFDG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALFDJ000000000-CALFDM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALFDO000000000-CALFDT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALFDV000000000-CALFDX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALFEC000000000-CALFED999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALFEF000000000-CALFFD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALFFF000000000-CALFFI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALFFL000000000-CALFSF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALFSK000000000-CALFUG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALFUY000000000-CALFVC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALFXA000000000-CALGAS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGAX000000000-CALGJP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALGJY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALGKF000000000-CALGKG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALGKM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALGKO000000000-CALGKU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGKW000000000-CALGLD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGLF000000000-CALGLI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGLK000000000-CALGLQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGMG000000000-CALGMI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGMK000000000-CALGML999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALGMN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALGMP000000000-CALGMQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGMU000000000-CALGMZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGNB000000000-CALGNC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALGNF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALGNL000000000-CALGNM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGNQ000000000-CALGNR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALGNV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALGNY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALGOD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALGOH000000000-CALGPF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGPP000000000-CALGPZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALGQB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALGQD000000000-CALGQK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGQM000000000-CALGQT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALGQW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALGQY000000000-CALGVO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGVQ000000000-CALGVY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGWA000000000-CALGWG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGWI000000000-CALGWM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGWO000000000-CALGWU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALGWW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALGWZ000000000-CALGXA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGXC000000000-CALGXI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALGXK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALGXM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALGXO000000000-CALGXS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALGXU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALGXW000000000-CALGXY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGYC000000000-CALGYZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGZE000000000-CALGZN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALGZP000000000-CALHAA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHAC000000000-CALHAD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHBG000000000-CALHBI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHBK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHBM000000000-CALHBN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHBS000000000-CALHBT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHBV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHBX000000000-CALHCA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHCD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHCR000000000-CALHDF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHDH000000000-CALHDX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHDZ000000000-CALHED999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHEF000000000-CALHEJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHEL000000000-CALHEN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHEP000000000-CALHFF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHFH000000000-CALHFP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHFR000000000-CALHGD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHGF000000000-CALHGH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHGK000000000-CALHGN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHGP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHGR000000000-CALHGW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHGY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHHA000000000-CALHHB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHHD000000000-CALHHG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHHI000000000-CALHHN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHHP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHHR000000000-CALHHX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHHZ000000000-CALHIA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHIC000000000-CALHIK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHIM000000000-CALHIN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHIQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALHIS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHIY000000000-CALHJC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHJG000000000-CALHJJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHJL000000000-CALHJN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHJP000000000-CALHKI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHKL000000000-CALHKP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHKR000000000-CALHLA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHLG000000000-CALHLV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHLX000000000-CALHMB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHMD000000000-CALHMF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHMH000000000-CALHML999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHMN000000000-CALHMU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHMW000000000-CALHMZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHNB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHND000000000-CALHNH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHNJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHNL000000000-CALHNR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHNT000000000-CALHNW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHNY000000000-CALHOH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHOJ000000000-CALHOT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHOV000000000-CALHOW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHOY000000000-CALHPG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHPL000000000-CALHPT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHPV000000000-CALHQB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHQD000000000-CALHQV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHQX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHQZ000000000-CALHRA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHRE000000000-CALHRG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHRI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHRK000000000-CALHRP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHRR000000000-CALHRT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHRV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHRX000000000-CALHRY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHSC000000000-CALHSS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHSU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHSW000000000-CALHSX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHSZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHTC000000000-CALHTE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHTG000000000-CALHTQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHTS000000000-CALHTU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHTW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALHTZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHUB000000000-CALHUF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHUH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHUJ000000000-CALHUL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHUN000000000-CALHUY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHVA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALHVC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHVE000000000-CALHVG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHVI000000000-CALHVO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHVQ000000000-CALHVW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHVY000000000-CALHWJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHWL000000000-CALHWN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHWP000000000-CALHXA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHXD000000000-CALHXE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHXH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHXJ000000000-CALHXT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHXV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHXX000000000-CALHYD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHYF000000000-CALHYK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHYN000000000-CALHYW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALHYZ000000000-CALHZM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHZO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHZQ000000000-CALHZS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALHZU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALHZW000000000-CALIAE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIAH000000000-CALIAT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIAV000000000-CALIBH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALIBJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALIBM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALIBS000000000-CALICB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALICD000000000-CALICL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALICN000000000-CALIDH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIDJ000000000-CALIDK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIDM000000000-CALIDQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIDS000000000-CALIEA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIEC000000000-CALIED999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIEF000000000-CALIEH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIEJ000000000-CALIEM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIEO000000000-CALIEP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIES000000000-CALIFK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIFN000000000-CALIFX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIFZ000000000-CALIGH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIGJ000000000-CALIGO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALIGQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALIGS000000000-CALIHA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIHC000000000-CALIHE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIHG000000000-CALIHK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIHM000000000-CALIHT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALIHV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALIHX000000000-CALIHZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALIIB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALIID000000000-CALIIJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIIM000000000-CALIIO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIIQ000000000-CALIIV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALIIX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALIIZ000000000-CALIJB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALIJD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALIJF000000000-CALIJI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIJK000000000-CALIJL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIJN000000000-CALIJY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIKA000000000-CALIKI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIKY000000000-CALILA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALILC000000000-CALILO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALILQ000000000-CALIMA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALIMC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALIME+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALIMK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALIMM000000000-CALIMU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALIMW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALIMY000000000-CALINA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALINC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALING000000000-CALINI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALINK000000000-CALINL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALINN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALINR000000000-CALIOB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALIOD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALIOF000000000-CALIOK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIOM000000000-CALIOS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIOU000000000-CALIOW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIOY000000000-CALIPB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIPD000000000-CALIQD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIQF000000000-CALIQN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIQP000000000-CALIRB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIRE000000000-CALIRL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALIRN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALIRT000000000-CALISA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALISC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALISE000000000-CALISJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALISL000000000-CALISN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALISQ000000000-CALIST999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALISV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALISX000000000-CALITB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALITD000000000-CALITI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALITK000000000-CALITL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALITQ000000000-CALITU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALITW000000000-CALIUA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIUC000000000-CALIUF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALIUH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALIUN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALIUP000000000-CALIUW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIUZ000000000-CALIVD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIVF000000000-CALIVM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIVO000000000-CALIVS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIVU000000000-CALIWS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIWU000000000-CALIWZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIXB000000000-CALIXJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIXL000000000-CALIXM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIXO000000000-CALIXT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIXV000000000-CALIYZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIZC000000000-CALIZE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIZG000000000-CALIZH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALIZJ000000000-CALIZZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJAB000000000-CALJAD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJAF000000000-CALJAJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALJAO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALJAR000000000-CALJAY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJBA000000000-CALJBG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJBI000000000-CALJBM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJBO000000000-CALJBP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJBR000000000-CALJBS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJBU000000000-CALJBX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJCA000000000-CALJCE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJCG000000000-CALJCX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJCZ000000000-CALJDC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALJDE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALJDI000000000-CALJDJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJDL000000000-CALJDM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJDP000000000-CALJDS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJDV000000000-CALJED999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALJIC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALJIE000000000-CALJIG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJII000000000-CALJIM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJIO000000000-CALJIP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJIR000000000-CALJIT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJIV000000000-CALJIX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJJA000000000-CALJJB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJJD000000000-CALJJN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALJJP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALJJS000000000-CALJJT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALJJW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALJKA000000000-CALJMB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJME000000000-CALJMG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJMJ000000000-CALJMT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJMV000000000-CALJMX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALJMZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALJNF000000000-CALJNH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJNK000000000-CALJNQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJNS000000000-CALJNU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJNW000000000-CALJNZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALJOG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALJOI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALJOL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALJON000000000-CALJPE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALJPG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALJPI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALJPK000000000-CALJPN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALJPP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALJPR000000000-CALJPS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJPU000000000-CALJQF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALJQH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALJQL000000000-CALJQW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJQY000000000-CALJRV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJRX000000000-CALJSA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJSC000000000-CALJSP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJSR000000000-CALJSU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJSW000000000-CALJTM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALJTO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALJTQ000000000-CALJTR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALJTU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALJTW000000000-CALJVG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJWM000000000-CALJWN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJWP000000000-CALJWQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALJWS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALJWU000000000-CALJWX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALJXA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALJXC000000000-CALJXD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJXF000000000-CALJXN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJXP000000000-CALJXT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJXV000000000-CALJYB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJYD000000000-CALJYF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJYI000000000-CALJYQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJYS000000000-CALJYV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALJYX000000000-CALJZM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALJZO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALJZR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALJZT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALJZV000000000-CALKBH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKBJ000000000-CALKBT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKHJ000000000-CALKIW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKKC000000000-CALKKM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKKO000000000-CALKKU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKKW000000000-CALKLB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALKLE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALKLG000000000-CALKLN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKLQ000000000-CALKLR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKLT000000000-CALKLW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKLY000000000-CALKMB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKMD000000000-CALKME999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKMG000000000-CALKMN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALKMP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALKMR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALKPG000000000-CALKPL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKPN000000000-CALKPX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKPZ000000000-CALKQT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALKQV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALKQX000000000-CALKRJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKRL000000000-CALKRM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKRO000000000-CALKRT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKRV000000000-CALKRY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKSA000000000-CALKTG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKTI000000000-CALKTT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKTV000000000-CALKUT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALKUV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALKUX000000000-CALKUZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKVB000000000-CALKVL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKVQ000000000-CALKXB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKYE000000000-CALKZG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKZI000000000-CALKZM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALKZO000000000-CALKZQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALLAS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALLAX000000000-CALLAY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALLBF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALLBP000000000-CALLBQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLBS000000000-CALLBT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLBV000000000-CALLCC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLCI000000000-CALLCN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLCP000000000-CALLCY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLDB000000000-CALLDG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLDI000000000-CALLDK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLDM000000000-CALLDO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLDQ000000000-CALLDY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLEA000000000-CALLEH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLEJ000000000-CALLEM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLEO000000000-CALLEQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLES000000000-CALLEW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLEY000000000-CALLEZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLFB000000000-CALLFG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLFI000000000-CALLFL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLFN000000000-CALLFY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLGB000000000-CALLGC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLGE000000000-CALLGJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLGL000000000-CALLGO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLGQ000000000-CALLGR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLGT000000000-CALLHF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLHJ000000000-CALLHK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLHM000000000-CALLHS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLHV000000000-CALLIE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALLIH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALLIR000000000-CALLJB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLJV000000000-CALLKN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALLLT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALLMO000000000-CALLMU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLMW000000000-CALLND999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLNF000000000-CALLNS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLNU000000000-CALLNW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALLNZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALLOC000000000-CALLOQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLOT000000000-CALLPB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALLPD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALLPF000000000-CALLPH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALLPJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALLQD000000000-CALLQO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALLQQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALLQS000000000-CALLQX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLRA000000000-CALLRO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALLRQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALLRS000000000-CALLRT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLRV000000000-CALLTW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLTY000000000-CALLUA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLUC000000000-CALLUE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALLVH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALLVJ000000000-CALLVW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLVZ000000000-CALLWA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLWC000000000-CALLWL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLWP000000000-CALLWU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALLWW000000000-CALLXA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALLXG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALLXL000000000-CALLYE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALLYG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CALLYJ000000000-CALMEX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALMEZ000000000-CALMHN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALMHR000000000-CALMKP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALMKR000000000-CALMRF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALMRJ000000000-CALMVA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALMVE000000000-CALMWA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALMWD000000000-CALNCY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CALNEE000000000-CALNHU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CALNPA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CALNRV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMPDC000000000-CAMPDU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMPDW000000000-CAMPDY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMPFV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMPGF000000000-CAMPKX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMPLK000000000-CAMPOS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMPPG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMPTU000000000-CAMPTV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMPTY000000000-CAMPUA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMPUE000000000-CAMPUF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMPUH000000000-CAMPUN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMPUP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMPUW000000000-CAMPUX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMPVA000000000-CAMPVB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMPVD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAMPVF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAMPVK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAMPVM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMPVO000000000-CAMPVT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMPVV000000000-CAMPVW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMPVY000000000-CAMPWD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMPWI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAMPWK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMPWN000000000-CAMPWO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMPWQ000000000-CAMPWS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMPWU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAMPWW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMPWY000000000-CAMPXE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMPXG000000000-CAMPXI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMPXN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAMPXP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAMPXV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMPYB000000000-CAMPYD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMPYH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAMPYJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAMPYN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAMPYQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMPYS000000000-CAMPYT999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMPYV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMPYX000000000-CAMPYY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMPZA000000000-CAMPZB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMPZD000000000-CAMPZE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMQAB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMQAO000000000-CAMQAP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMQAR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMQAT000000000-CAMQAU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMQAW000000000-CAMQBA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMQBE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMQBG000000000-CAMQBI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMQBN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMQBP000000000-CAMQBW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMQBZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMQCD000000000-CAMQCF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMQCH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMQCK000000000-CAMQCO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMQCR000000000-CAMQCS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMQCZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMQDC000000000-CAMQDD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMQDG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAMQDS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMQEN000000000-CAMQEO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMQEQ000000000-CAMQET999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMQFA000000000-CAMQFC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMQFE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAMQFL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMQFR000000000-CAMQFT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMQGL000000000-CAMQPX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMQQL000000000-CAMQTP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMQTS000000000-CAMQTV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMQTX000000000-CAMQUC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMQUF000000000-CAMQUZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMQVB000000000-CAMQVC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMQVF000000000-CAMQVU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMQVW000000000-CAMQWJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMQWL000000000-CAMQWP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMQWR000000000-CAMQWS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMQWU000000000-CAMQWW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMQWZ000000000-CAMQZL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMQZN000000000-CAMQZY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMRAA000000000-CAMRAR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMRAT000000000-CAMRAX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMRBA000000000-CAMREN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMREP000000000-CAMRFE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMRGM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMRSF000000000-CAMRXA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMSBO000000000-CAMSEK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMSEM000000000-CAMSLM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMSLO000000000-CAMSTW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMSTY000000000-CAMTCG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMTDX000000000-CAMTSY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMTZD000000000-CAMUPJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMUPX000000000-CAMUSE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMUSG000000000-CAMUSQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMUSS000000000-CAMWBN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMWBP000000000-CAMWCS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMWCU000000000-CAMWEA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMWEC000000000-CAMXAO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMXAQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMXAS000000000-CAMXAV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMXAX000000000-CAMXAZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMXBB000000000-CAMXBF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMXBH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMXCV000000000-CAMXCZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMXHZ000000000-CAMXUF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMXVC000000000-CAMYGE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMYGH000000000-CAMYGQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMYGS000000000-CAMYHG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMYHI000000000-CAMYIA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMYOQ000000000-CAMYPB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAMYPD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAMYPF000000000-CAMYTO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMYTY000000000-CAMZJH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAMZXK000000000-CANACM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANACO000000000-CANAFE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANAFJ000000000-CANAHP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANAIF000000000-CANAKZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANAMA000000000-CANASN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANASP000000000-CANATP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANATR000000000-CANATX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANATZ000000000-CANAUJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANAUM000000000-CANAZH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANAZJ000000000-CANAZZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANBAB000000000-CANBAH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANBAL000000000-CANBCK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANBCM000000000-CANBKP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANBKY000000000-CANBMP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANCXK000000000-CANDNQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANDOE000000000-CANDWZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANDYS000000000-CANERT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANNOB000000000-CANNPS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANNVC000000000-CANNWK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANNYW000000000-CANNZP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANOAG000000000-CANOAN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANOBF000000000-CANOOP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANOOR000000000-CANOQF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANOQQ000000000-CANPDD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPDG000000000-CANPDL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPDN000000000-CANPDO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CANPDQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CANPDS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CANPDU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CANPDW000000000-CANPDY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPEA000000000-CANPEE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPEG000000000-CANPEH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPEK000000000-CANPEL999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CANPEO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CANPEQ000000000-CANPER999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPET000000000-CANPEU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPEW000000000-CANPFL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPFO000000000-CANPFP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CANPFR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CANPFT000000000-CANPFU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CANPFW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CANPFY000000000-CANPFZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPGB000000000-CANPGE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPGH000000000-CANPGI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPGK000000000-CANPGV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CANPGX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CANPGZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CANPHB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CANPHE000000000-CANPIV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPIX000000000-CANPJA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CANPJC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CANPJF000000000-CANPJI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPJK000000000-CANPJN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPJP000000000-CANPJQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPJS000000000-CANPJX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CANPJZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CANPKB000000000-CANPKC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CANPKE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CANPKH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CANPKJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CANPKL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CANPKT000000000-CANPKU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPKW000000000-CANPKX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CANPKZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CANPLB000000000-CANPLI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CANPLM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CANPLO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CANPMK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CANPMP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CANPMR000000000-CANPMT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPMV000000000-CANPMW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPMZ000000000-CANPNQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPNS000000000-CANPNX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CANPNZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CANPOC000000000-CANPOF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPOH000000000-CANPOM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CANPOO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CANPOS000000000-CANPOW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CANPOY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CANPPA000000000-CANPPC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPPE000000000-CANPPQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CANPPW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CANPQE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CANPQS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CANPQU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CANPQW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CANPRF000000000-CANPRG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CANPTD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CANPTH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CANPTM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CANPTO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CANPTS000000000-CANPTW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPUC000000000-CANPUE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANPUG000000000-CANPUI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANRQJ000000000-CANSGC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANSGE000000000-CANSNY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANSOA000000000-CANSTM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANSTO000000000-CANSXA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANSXC000000000-CANSXG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANSXI000000000-CANSZC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANSZE000000000-CANTAK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANTAM000000000-CANTDV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANTDX000000000-CANTFF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CANTFN000000000-CANTKU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOJBL000000000-CAOJBM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOJBO000000000-CAOJBP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOJBT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOJBX000000000-CAOJBZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOJCC000000000-CAOJCK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOJCT000000000-CAOJWF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOJWM000000000-CAOJZE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOJZG000000000-CAOKAE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOKAG000000000-CAOKEF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOKEH000000000-CAOKFE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOKFG000000000-CAOKNL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOKNN000000000-CAOKRJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOKRM000000000-CAOKRN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOKRP000000000-CAOKSS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOKSU000000000-CAOKTE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOKTU000000000-CAOKTV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOKTX000000000-CAOKXA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOKXC000000000-CAOKYD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOKYF000000000-CAOKYO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOKYT000000000-CAOKZK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOKZM000000000-CAOLAH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLAJ000000000-CAOLCB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLCD000000000-CAOLCS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLCU000000000-CAOLDP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLDR000000000-CAOLDX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLDZ000000000-CAOLEG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLEI000000000-CAOLEV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLEX000000000-CAOLEY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLFA000000000-CAOLHH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLHJ000000000-CAOLJL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLJN000000000-CAOLNA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLNC000000000-CAOLNW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLNY000000000-CAOLOL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLON000000000-CAOLOW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLOY000000000-CAOLPH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLPJ000000000-CAOLQW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLQY000000000-CAOLSJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLSL000000000-CAOLWR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLWT000000000-CAOLYJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOLYL000000000-CAOMBI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMBK000000000-CAOMBX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMBZ000000000-CAOMCY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMDA000000000-CAOMEF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMEH000000000-CAOMHN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMHP000000000-CAOMHU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMHW000000000-CAOMII999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMIK000000000-CAOMNS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMNU000000000-CAOMOB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMOD000000000-CAOMUT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMUV000000000-CAOMVR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMVT000000000-CAOMYQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOMYS000000000-CAONDD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONDF000000000-CAONNF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONNH000000000-CAONPB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONPD000000000-CAONPO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONPQ000000000-CAONRB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONRD000000000-CAONSW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONSY000000000-CAONUM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONUO000000000-CAONUW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONUY000000000-CAONXD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONXF000000000-CAONXQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONXS000000000-CAONXY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAONYA000000000-CAOOCB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOCD000000000-CAOOFA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOFC000000000-CAOOFV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOFX000000000-CAOOHB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOHD000000000-CAOOHX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOHZ000000000-CAOOJA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOJC000000000-CAOOOH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOOJ000000000-CAOOOV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOOX000000000-CAOOQA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOQC000000000-CAOOXZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOYB000000000-CAOOYT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOOYV000000000-CAOPDL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPDN000000000-CAOPEA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPEC000000000-CAOPFN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPFP000000000-CAOPJI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPJK000000000-CAOPMU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPMW000000000-CAOPQV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPQX000000000-CAOPSP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPSR000000000-CAOPYH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOPYJ000000000-CAOQEK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQEM000000000-CAOQGR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQGT000000000-CAOQHQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQHS000000000-CAOQMU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQMW000000000-CAOQNG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQNI000000000-CAOQQO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQQQ000000000-CAOQSE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQSG000000000-CAOQUA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQUC000000000-CAOQUJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQUL000000000-CAOQVC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQVE000000000-CAOQXE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOQXG000000000-CAORGS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORGU000000000-CAORGX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORGZ000000000-CAORHH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORHJ000000000-CAORKC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORKE000000000-CAORNQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORNS000000000-CAOROA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOROC000000000-CAOROK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOROM000000000-CAORUY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORVA000000000-CAORVJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORVL000000000-CAORYL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAORYN000000000-CAOSAC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSAE000000000-CAOSBH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSBJ000000000-CAOSBT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSBV000000000-CAOSEH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSEJ000000000-CAOSGA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSGC000000000-CAOSGD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSGF000000000-CAOSHC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSHE000000000-CAOSOQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSOS000000000-CAOSWZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSXB000000000-CAOSXN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSXP000000000-CAOSZC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSZE000000000-CAOSZJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOSZL000000000-CAOTAY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTBA000000000-CAOTCS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTCU000000000-CAOTEG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTEI000000000-CAOTFS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTFU000000000-CAOTGQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTGS000000000-CAOTGT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTGV000000000-CAOTIT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTIV000000000-CAOTQN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTQP000000000-CAOTRN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTRP000000000-CAOTVB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOTVD000000000-CAOUDQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUDS000000000-CAOUHD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUHF000000000-CAOUIE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUIG000000000-CAOULW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOULY000000000-CAOUMG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUMI000000000-CAOUPD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUPF000000000-CAOUYI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOUYK000000000-CAOVBG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVBI000000000-CAOVGB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVGD000000000-CAOVJX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVJZ000000000-CAOVKB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVKD000000000-CAOVLE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVLG000000000-CAOVSR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVST000000000-CAOVVZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVWB000000000-CAOVWE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVWG000000000-CAOVXV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVXX000000000-CAOVZH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOVZJ000000000-CAOWEI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWEK000000000-CAOWGY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWHA000000000-CAOWNF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWNH000000000-CAOWNS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWNU000000000-CAOWOH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWOJ000000000-CAOWPO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWPQ000000000-CAOWQI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWQK000000000-CAOWQN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWQP000000000-CAOWUT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWUV000000000-CAOWVD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWVF000000000-CAOWWE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWWG000000000-CAOWWO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWWQ000000000-CAOWXN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWXP000000000-CAOWZE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOWZG000000000-CAOXBA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXBC000000000-CAOXBL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXBN000000000-CAOXCI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXCK000000000-CAOXDE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXDG000000000-CAOXDL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXDN000000000-CAOXDQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXDS000000000-CAOXFD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXFF000000000-CAOXHP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXHR000000000-CAOXLI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXLK000000000-CAOXMP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXMR000000000-CAOXOX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXOZ000000000-CAOXPQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXPS000000000-CAOXSH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXSJ000000000-CAOXTX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXTZ000000000-CAOXXD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXXF000000000-CAOXYB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXYD000000000-CAOXYK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXYM000000000-CAOXYX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXYZ000000000-CAOXZI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOXZK000000000-CAOYBZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYCB000000000-CAOYGV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYGX000000000-CAOYHV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYHX000000000-CAOYPK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYPM000000000-CAOYQI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYQK000000000-CAOYSP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYSR000000000-CAOYTE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYTG000000000-CAOYTQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYTS000000000-CAOYVQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYVS000000000-CAOYZR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOYZT000000000-CAOZIW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZIY000000000-CAOZJK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZJM000000000-CAOZKY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZLA000000000-CAOZLR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZLT000000000-CAOZNY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZOA000000000-CAOZQX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAOZQZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAOZRB000000000-CAOZVN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZVP000000000-CAOZWV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZWX000000000-CAOZYX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZYZ000000000-CAOZZV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAOZZX000000000-CAPADY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPAEA000000000-CAPAEK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPAEM000000000-CAPAKH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPAKJ000000000-CAPALK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPALM000000000-CAPAMI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPAMK000000000-CAPAPJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPAPL000000000-CAPATS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPATU000000000-CAPAXV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPAXX000000000-CAPAYI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPAYK000000000-CAPAZD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPAZF000000000-CAPAZP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPAZR000000000-CAPBHA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBHC000000000-CAPBHE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBHG000000000-CAPBNZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBOB000000000-CAPBPZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBQB000000000-CAPBQI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBQK000000000-CAPBTQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBTS000000000-CAPBUI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBUK000000000-CAPBWY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBXA000000000-CAPBYY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPBZA000000000-CAPCAA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCAC000000000-CAPCAJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCAL000000000-CAPCCQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCCS000000000-CAPCEB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCED000000000-CAPCEK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCEM000000000-CAPCJJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCJL000000000-CAPCJO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCJQ000000000-CAPCLJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCLL000000000-CAPCMH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCMJ000000000-CAPCNL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCNN000000000-CAPCSF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCSH000000000-CAPCXJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPCXL000000000-CAPDEZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDFB000000000-CAPDKA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDKC000000000-CAPDKI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDKK000000000-CAPDNO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDNQ000000000-CAPDPK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDPM000000000-CAPDSL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDSN000000000-CAPDTV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDTX000000000-CAPDVI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDVK000000000-CAPDZU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPDZW000000000-CAPEDN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPEDP000000000-CAPEFS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPEFV000000000-CAPEHI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPEHK000000000-CAPEJX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPEJZ000000000-CAPEKQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPEKS000000000-CAPELB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPELD000000000-CAPENT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPENV000000000-CAPEPG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPEPI000000000-CAPEPR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPEPT000000000-CAPEQL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPEQN000000000-CAPEQO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPEQQ000000000-CAPEWR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPEWT000000000-CAPFAG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFAI000000000-CAPFAQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFAS000000000-CAPFBX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFBZ000000000-CAPFHY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFIA000000000-CAPFIU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFIW000000000-CAPFLA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFLC000000000-CAPFOH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFOJ000000000-CAPFPC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFPE000000000-CAPFQV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFQX000000000-CAPFVC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFVE000000000-CAPFVV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFVX000000000-CAPFYA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPFYC000000000-CAPGAG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGAI000000000-CAPGEJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGEL000000000-CAPGEP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGER000000000-CAPGGJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGGL000000000-CAPGHC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGHF000000000-CAPGIO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGIR000000000-CAPGKK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGKM000000000-CAPGMX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGMZ000000000-CAPGOA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGOC000000000-CAPGRW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGRY000000000-CAPGTW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGTY000000000-CAPGUH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGUJ000000000-CAPGXW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPGXY000000000-CAPHAN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHAP000000000-CAPHAW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHAY000000000-CAPHBD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHBF000000000-CAPHDZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHEB000000000-CAPHEN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHEP000000000-CAPHFZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHGB000000000-CAPHHN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHHP000000000-CAPHKF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHKH000000000-CAPHKZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHLB000000000-CAPHMI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPHMK000000000-CAPIAS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIAU000000000-CAPIDA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIDC000000000-CAPIDK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIDM000000000-CAPIEC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIEE000000000-CAPIKF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIKH000000000-CAPIKW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIKY000000000-CAPIMB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIMD000000000-CAPIMO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIMQ000000000-CAPINB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIND000000000-CAPIPR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIPT000000000-CAPIQD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIQF000000000-CAPISR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIST000000000-CAPITZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIUC000000000-CAPIVN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIVQ000000000-CAPIVT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPIVV000000000-CAPJAR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJAT000000000-CAPJEK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJEM000000000-CAPJEU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJEW000000000-CAPJIX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJIZ000000000-CAPJKE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJKG000000000-CAPJLE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJLG000000000-CAPJNK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJNM000000000-CAPJXB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJXD000000000-CAPJXZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPJYB000000000-CAPKAF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKAH000000000-CAPKBZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKCB000000000-CAPKGI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKGK000000000-CAPKGX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKGZ000000000-CAPKKT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKKV000000000-CAPKML999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKMN000000000-CAPKMO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKMQ000000000-CAPKRH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKRJ000000000-CAPKWT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKWV000000000-CAPKYJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPKYL000000000-CAPLCN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLCP000000000-CAPLCT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLCV000000000-CAPLJR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLJT000000000-CAPLKH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLKJ000000000-CAPLKW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLKY000000000-CAPLMF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLMH000000000-CAPLSN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLSP000000000-CAPLSR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLST000000000-CAPLUS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLUU000000000-CAPLVE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLVG000000000-CAPLXD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLXF000000000-CAPLZT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPLZV000000000-CAPMAI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMAK000000000-CAPMAN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMAP000000000-CAPMCA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMCC000000000-CAPMFL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMFN000000000-CAPMFQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMFS000000000-CAPMHX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMHZ000000000-CAPMQK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMQM000000000-CAPMSL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMSN000000000-CAPMUF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMUH000000000-CAPMVW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMVY000000000-CAPMWB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMWD000000000-CAPMWE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPMWG000000000-CAPNBP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNBR000000000-CAPNCA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNCC000000000-CAPNCX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNCZ000000000-CAPNHP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNHR000000000-CAPNJX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNJZ000000000-CAPNNL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNNN000000000-CAPNOA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNOC000000000-CAPNPS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNPU000000000-CAPNRW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNRY000000000-CAPNWK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNWM000000000-CAPNYD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPNYF000000000-CAPOBE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOBG000000000-CAPODU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPODW000000000-CAPOEG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOEI000000000-CAPOFM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOFO000000000-CAPOGN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOGP000000000-CAPOIY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOJA000000000-CAPOJU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOJW000000000-CAPOLL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOLN000000000-CAPOLU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOLW000000000-CAPOOG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOOI000000000-CAPOOO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOOQ000000000-CAPORM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPORO000000000-CAPORS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPORU000000000-CAPOSU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOSW000000000-CAPOUV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPOUX000000000-CAPPEF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPEH000000000-CAPPHO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPHQ000000000-CAPPJL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPJN000000000-CAPPUM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPUO000000000-CAPPWX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPWZ000000000-CAPPXH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPPXJ000000000-CAPQBP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQBR000000000-CAPQDI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQDK000000000-CAPQEK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQEM000000000-CAPQHI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQHK000000000-CAPQIK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPQIM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPQIO000000000-CAPQIT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQIV000000000-CAPQJQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQJS000000000-CAPQNB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQND000000000-CAPQNI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQNK000000000-CAPQPN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQPP000000000-CAPQWL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQWN000000000-CAPQZE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQZG000000000-CAPQZS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPQZU000000000-CAPRAE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRAG000000000-CAPRBN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRBP000000000-CAPRCD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRCF000000000-CAPRGI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRGK000000000-CAPRKY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRLA000000000-CAPRNX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRNZ000000000-CAPRRH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRRJ000000000-CAPRRN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRRP000000000-CAPRTL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPRTN000000000-CAPSBA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSBC000000000-CAPSBO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSBQ000000000-CAPSBX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSBZ000000000-CAPSJJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSJL000000000-CAPSNH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSNJ000000000-CAPSOJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSOL000000000-CAPSOP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSOR000000000-CAPSPE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSPG000000000-CAPSPM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSPO000000000-CAPSSG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSSI000000000-CAPSUQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSUS000000000-CAPSVM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSVO000000000-CAPSXX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPSXZ000000000-CAPTDU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTDW000000000-CAPTER999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTET000000000-CAPTFE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTFG000000000-CAPTNR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTNT000000000-CAPTPB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTPD000000000-CAPTSA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTSC000000000-CAPTTW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTTY000000000-CAPTTZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTUB000000000-CAPTXI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTXK000000000-CAPTXM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPTXO000000000-CAPUBD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUBF000000000-CAPUES999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUEU000000000-CAPUEY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUFA000000000-CAPUHH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUHJ000000000-CAPUIT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUIV000000000-CAPUJS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUJU000000000-CAPULH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPULJ000000000-CAPULP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPULR000000000-CAPUNS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUNU000000000-CAPUNV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUNX000000000-CAPUPA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUPC000000000-CAPUPK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUPM000000000-CAPURI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPURK000000000-CAPUSR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUST000000000-CAPUUV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPUUX000000000-CAPVAA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVAC000000000-CAPVBM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVBO000000000-CAPVBW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVBY000000000-CAPVEM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVEO000000000-CAPVFH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVFJ000000000-CAPVJB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVJD000000000-CAPVKH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVKJ000000000-CAPVMT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVMV000000000-CAPVOM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVOO000000000-CAPVPN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVPP000000000-CAPVUH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVUJ000000000-CAPVVY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVWA000000000-CAPVXX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVXZ000000000-CAPVZD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVZF000000000-CAPVZI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPVZK000000000-CAPWAB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWAD000000000-CAPWEH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWEJ000000000-CAPWHH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWHJ000000000-CAPWNE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWNG000000000-CAPWNI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWNK000000000-CAPWPT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWPV000000000-CAPWUV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWUX000000000-CAPWVK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWVM000000000-CAPWXJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWXL000000000-CAPWXO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWXQ000000000-CAPWYH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWYJ000000000-CAPWYU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWYW000000000-CAPWYY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPWZA000000000-CAPXAI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXAK000000000-CAPXAN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXAP000000000-CAPXFJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXFL000000000-CAPXIH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXIJ000000000-CAPXIZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXJB000000000-CAPXMY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXNA000000000-CAPXNX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXOA000000000-CAPXPR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXPT000000000-CAPXUQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXUS000000000-CAPXWQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXWS000000000-CAPXXS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXXU000000000-CAPXXY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPXYA000000000-CAPYDE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYDG000000000-CAPYFU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYFW000000000-CAPYHC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYHE000000000-CAPYMP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYMR000000000-CAPYNE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYNG000000000-CAPYNZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYOB000000000-CAPYRK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYRM000000000-CAPYVE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYVG000000000-CAPYVI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYVK000000000-CAPYZF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPYZH000000000-CAPZAJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAPZAL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAPZAN000000000-CAPZFG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZFI000000000-CAPZGL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZGN000000000-CAPZJN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZJP000000000-CAPZJR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZJT000000000-CAPZNK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZNM000000000-CAPZPI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZPK000000000-CAPZQD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZQF000000000-CAPZQQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZQS000000000-CAPZRC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZRE000000000-CAPZRR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZRT000000000-CAPZUK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZUM000000000-CAPZVI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZVK000000000-CAPZVN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZVP000000000-CAPZXW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAPZXY000000000-CAQACW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQACY000000000-CAQAGG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQAGI000000000-CAQAIC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQAIE000000000-CAQARH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQARJ000000000-CAQAYR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQAYT000000000-CAQAZG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQAZI000000000-CAQAZP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQAZR000000000-CAQBAT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBAV000000000-CAQBAZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBBB000000000-CAQBBX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBBZ000000000-CAQBDI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBDK000000000-CAQBFI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBFK000000000-CAQBIJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBIL000000000-CAQBKQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBKS000000000-CAQBLW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBLY000000000-CAQBMW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBMY000000000-CAQBRU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBRW000000000-CAQBTV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBTX000000000-CAQBZW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQBZY000000000-CAQCBI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCBK000000000-CAQCCQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCCS000000000-CAQCFR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCFT000000000-CAQCGC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCGE000000000-CAQCIT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCIV000000000-CAQCIW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCIY000000000-CAQCKL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCKN000000000-CAQCLE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCLG000000000-CAQCLM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCLO000000000-CAQCNH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCNJ000000000-CAQCNK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCNM000000000-CAQCNQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCNS000000000-CAQCPS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCPU000000000-CAQCSD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCSF000000000-CAQCUL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCUN000000000-CAQCUO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCUQ000000000-CAQCXK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCXM000000000-CAQCYY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQCZA000000000-CAQCZK999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQCZM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQCZO000000000-CAQDCD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDCF000000000-CAQDDQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDDS000000000-CAQDDT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDDV000000000-CAQDEX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDEZ000000000-CAQDFV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDFX000000000-CAQDJS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDJU000000000-CAQDJY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDKA000000000-CAQDMN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDMP000000000-CAQDNE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDNG000000000-CAQDNJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDNL000000000-CAQDNO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDNR000000000-CAQDOV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDOX000000000-CAQDTA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDTC000000000-CAQDTN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDTP000000000-CAQDUV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDUX000000000-CAQDXP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQDXR000000000-CAQEBC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEBE000000000-CAQEBM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEBO000000000-CAQEBU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEBW000000000-CAQEDI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEDK000000000-CAQEEE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEEG000000000-CAQEEJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEEL000000000-CAQEJD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEJF000000000-CAQEKA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQEKC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQEKE000000000-CAQEKG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEKI000000000-CAQELB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQELD000000000-CAQENK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQENM000000000-CAQEOU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEOW000000000-CAQERZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQESB000000000-CAQESX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQESZ000000000-CAQEUG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEUI000000000-CAQEWH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEWJ000000000-CAQEWW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEWY000000000-CAQEZE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQEZG000000000-CAQFAT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFAV000000000-CAQFCC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFCE000000000-CAQFFA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFFC000000000-CAQFGM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFGO000000000-CAQFGV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFGX000000000-CAQFHD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFHF000000000-CAQFIG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFII000000000-CAQFKE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFKG000000000-CAQFMX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFMZ000000000-CAQFPQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFPS000000000-CAQFSI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFSK000000000-CAQFTF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFTH000000000-CAQFTU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFTW000000000-CAQFVB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFVD000000000-CAQFWF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFWH000000000-CAQFWT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFWV000000000-CAQFWX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFWZ000000000-CAQFXX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFXZ000000000-CAQFZS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQFZU000000000-CAQGAS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGAU000000000-CAQGAV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGAX000000000-CAQGCD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGCF000000000-CAQGCH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGCJ000000000-CAQGFL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGFN000000000-CAQGGM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGGO000000000-CAQGHN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGHP000000000-CAQGIP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGIR000000000-CAQGKN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGKP000000000-CAQGMD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGMF000000000-CAQGNH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGNJ000000000-CAQGOA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGOC000000000-CAQGOX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGOZ000000000-CAQGQL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGQN000000000-CAQGVA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGVC000000000-CAQGWX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGWZ000000000-CAQGXX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQGXZ000000000-CAQHAF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHAH000000000-CAQHBT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHBV000000000-CAQHDW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHDY000000000-CAQHEY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHFA000000000-CAQHHQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHHS000000000-CAQHJZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHKB000000000-CAQHKV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHKX000000000-CAQHLN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHLP000000000-CAQHTC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHTE000000000-CAQHTV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHTX000000000-CAQHWB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHWD000000000-CAQHXC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHXE000000000-CAQHXU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHXW000000000-CAQHZQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQHZS000000000-CAQIAL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQIAN000000000-CAQIEP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQIER000000000-CAQIFZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQIGB000000000-CAQIHO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQIHQ000000000-CAQINF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQINH000000000-CAQIPM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQIPO000000000-CAQITU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQITW000000000-CAQIUJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQIUL000000000-CAQIXK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQIXM000000000-CAQJCE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJCG000000000-CAQJCU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJCW000000000-CAQJDQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJDS000000000-CAQJEA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJEC000000000-CAQJEL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJEN000000000-CAQJGK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJGM000000000-CAQJHI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJHK000000000-CAQJIO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJIQ000000000-CAQJJG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJJI000000000-CAQJJQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJJS000000000-CAQJKA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJKC000000000-CAQJNM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJNO000000000-CAQJRA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJRC000000000-CAQJRP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJRR000000000-CAQJSM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJSO000000000-CAQJUG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQJUI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQJUK000000000-CAQJVX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJVZ000000000-CAQJWN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJWP000000000-CAQJYM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJYO000000000-CAQJYZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQJZB000000000-CAQKBN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKBP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKBR000000000-CAQKDO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKDQ000000000-CAQKEW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKEY000000000-CAQKGM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKGO000000000-CAQKGV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKGX000000000-CAQKHC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKHE000000000-CAQKHF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQKHH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQKHJ000000000-CAQKJT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKJV000000000-CAQKLB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKLD000000000-CAQKMO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKMQ000000000-CAQKNQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKNS000000000-CAQKPO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKPQ000000000-CAQKPR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKPT000000000-CAQKQD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKQF000000000-CAQKSJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKSL000000000-CAQKWE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQKWG000000000-CAQLCF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLCH000000000-CAQLEE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLEG000000000-CAQLFF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLFH000000000-CAQLFK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLFM000000000-CAQLGM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLGO000000000-CAQLKS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLKU000000000-CAQLNX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLNZ000000000-CAQLOM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLOO000000000-CAQLOR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLOT000000000-CAQLQR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLQT000000000-CAQLRZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLSB000000000-CAQLUF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLUH000000000-CAQLVC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQLVE000000000-CAQMAA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMAC000000000-CAQMBV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMBX000000000-CAQMES999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMEU000000000-CAQMMP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMMR000000000-CAQMVL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQMVN000000000-CAQNAL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNAN000000000-CAQNID999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQNIF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQNIH000000000-CAQNJH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNJJ000000000-CAQNJZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNKB000000000-CAQNZB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQNZD000000000-CAQOFG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOFI000000000-CAQOHU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOHW000000000-CAQOQN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOQP000000000-CAQOSD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOSF000000000-CAQOSN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOSP000000000-CAQOSY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOTA000000000-CAQOTN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOTP000000000-CAQOUG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOUI000000000-CAQOXZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOYB000000000-CAQOYH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQOYJ000000000-CAQPAE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPAG000000000-CAQPBM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPBO000000000-CAQPDC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPDE000000000-CAQPGX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPGZ000000000-CAQPIM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPIO000000000-CAQPKI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPKK000000000-CAQPLM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPLO000000000-CAQPPE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPPG000000000-CAQPQE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPQG000000000-CAQPQM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPQO000000000-CAQPQT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPQV000000000-CAQPSM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPSO000000000-CAQPSX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQPSZ000000000-CAQQAV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQAX000000000-CAQQDC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQDE000000000-CAQQJW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQJY000000000-CAQQOE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQOG000000000-CAQQOS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQOU000000000-CAQQQJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQQL000000000-CAQQSQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQSS000000000-CAQQTX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQTZ000000000-CAQQVS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQQVU000000000-CAQRBT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRBV000000000-CAQRCP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRCR000000000-CAQRHJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRHL000000000-CAQROJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQROL000000000-CAQRQF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRQH000000000-CAQRRG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRRI000000000-CAQRWE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRWG000000000-CAQRWT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRWV000000000-CAQRZO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQRZQ000000000-CAQSAD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSAF000000000-CAQSCF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSCH000000000-CAQSJY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSKA000000000-CAQSMJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSML000000000-CAQSQJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSQL000000000-CAQSRG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSRI000000000-CAQSRO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSRQ000000000-CAQSVS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQSVU000000000-CAQTDW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTDY000000000-CAQTFC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTFE000000000-CAQTGJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTGL000000000-CAQTII999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTIK000000000-CAQTJL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTJN000000000-CAQTKV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTKX000000000-CAQTTK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTTM000000000-CAQTWC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTWE000000000-CAQTWW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQTWY000000000-CAQUBK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUBM000000000-CAQUCB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUCD000000000-CAQUEB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUED000000000-CAQUGU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUGW000000000-CAQUJA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUJC000000000-CAQUXH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQUXJ000000000-CAQVAM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVAO000000000-CAQVFC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVFE000000000-CAQVGP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVGR000000000-CAQVHB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVHD000000000-CAQVHN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAQVHP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAQVHR000000000-CAQVJA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVJC000000000-CAQVJZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVKB000000000-CAQVQJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVQL000000000-CAQVTI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVTK000000000-CAQVVY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVWA000000000-CAQVWS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVWU000000000-CAQVYM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQVYO000000000-CAQWBW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWBY000000000-CAQWFG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWFI000000000-CAQWJU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWJW000000000-CAQWKN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWKP000000000-CAQWMU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWMW000000000-CAQWNG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWNJ000000000-CAQWPA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWPC000000000-CAQWUF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWUH000000000-CAQWXR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWXT000000000-CAQWYS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQWYU000000000-CAQXAB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXAD000000000-CAQXAF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXAH000000000-CAQXEL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXEN000000000-CAQXFQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXFS000000000-CAQXID999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXIF000000000-CAQXJF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXJH000000000-CAQXMO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXMQ000000000-CAQXSP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQXSR000000000-CAQYAC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYAE000000000-CAQYCK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYCM000000000-CAQYCZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYDB000000000-CAQYFD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYFF000000000-CAQYGF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYGH000000000-CAQYHG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYHI000000000-CAQYIX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYIZ000000000-CAQYKC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYKE000000000-CAQYOK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYOM000000000-CAQYPW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYPY000000000-CAQYXX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQYXZ000000000-CAQZAX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZAZ000000000-CAQZDA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZDD000000000-CAQZDK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZDM000000000-CAQZJN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZJP000000000-CAQZUS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAQZUU000000000-CARABB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARABD000000000-CARADM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARADO000000000-CARADX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARADZ000000000-CARAMV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARAMX000000000-CARANA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARANC000000000-CARANF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARANH000000000-CARAPD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARAPF000000000-CARAQN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARAQP000000000-CARAUK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARAUM000000000-CARAVT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARAVV000000000-CARAWH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARAWJ000000000-CARBFR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBFT000000000-CARBLM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBLO000000000-CARBPJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBPL000000000-CARBQV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBQX000000000-CARBRS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBRU000000000-CARBUB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARBUD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARBUF000000000-CARBUZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBVB000000000-CARBYD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBYF000000000-CARBZS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARBZU000000000-CARCBW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCBY000000000-CARCDQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCDS000000000-CARCGN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCGP000000000-CARCOC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCOE000000000-CARCOI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCOK000000000-CARCQZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCRB000000000-CARCUZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCVB000000000-CARCXW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCXY000000000-CARCZI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARCZK000000000-CARDAA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDAC000000000-CARDBZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDCB000000000-CARDIT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDIV000000000-CARDJM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDJO000000000-CARDQK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDQM000000000-CARDYK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARDYM000000000-CAREBT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREBV000000000-CAREGX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREGZ000000000-CAREHH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREHJ000000000-CAREHY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREIA000000000-CAREKD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREKF000000000-CARELB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARELD000000000-CARELG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARELI000000000-CAREQB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAREQD000000000-CARERM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARERO000000000-CARESY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARETA000000000-CARFGK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFGM000000000-CARFKC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFKE000000000-CARFPU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFPW000000000-CARFUA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFUC000000000-CARFWZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFXB000000000-CARFXP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFXR000000000-CARFXT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARFXV000000000-CARGFU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARGFW000000000-CARGLB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARGLD000000000-CARGRC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARGRE000000000-CARGSP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARGSR000000000-CARGWZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARGXB000000000-CARGYK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARGYM000000000-CARHIT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARHIV000000000-CARHKF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARHKH000000000-CARHKP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARHKR000000000-CARHSP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARHSR000000000-CARHUC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARHUF000000000-CARHWW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARHWY000000000-CARIAM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARIAO000000000-CARIDB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARIDD000000000-CARIDI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARIDK000000000-CARIKS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARIKU000000000-CARIPD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARIPF000000000-CARIPL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARIPN000000000-CARIXF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARIXH000000000-CARIZW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARIZY000000000-CARJBQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARJBS000000000-CARJCZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARJDB000000000-CARJEE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARJEG000000000-CARJFJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARJFL000000000-CARJHO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARJHQ000000000-CARJIO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARJIQ000000000-CARJLH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARJLJ000000000-CARJMX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARJMZ000000000-CARJUX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARJUZ000000000-CARJYK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARJYM000000000-CARJYW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARJYY000000000-CARKCV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARKCX000000000-CARKDV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARKDX000000000-CARKDY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARKEA000000000-CARKEN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARKEP000000000-CARKEY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARKFA000000000-CARKIX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARKIZ000000000-CARKMN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARKMP000000000-CARKPZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARKQB000000000-CARKUT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARKUV000000000-CARKWF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARKWH000000000-CARKWZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARKXB000000000-CARKYR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARKYT000000000-CARKZB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARKZD000000000-CARLAT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARLAV000000000-CARLBM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARLBO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARLBQ000000000-CARLFA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARLFC000000000-CARLHD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARLHF000000000-CARLHQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARLHS000000000-CARLKM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARLKO000000000-CARLNE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARLNG000000000-CARLOC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARLOE000000000-CARLRB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARLRD000000000-CARLRX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARLRZ000000000-CARLSL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARLSN000000000-CARLTB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARLTD000000000-CARLWD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARLWF000000000-CARLZF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARLZH000000000-CARMBB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARMBD000000000-CARMBK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARMBM000000000-CARMDH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARMDJ000000000-CARMDK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARMDM000000000-CARMFL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARMFN000000000-CARMGX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARMGZ000000000-CARMHA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARMHC000000000-CARMOL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARMON000000000-CARMTS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARMTU000000000-CARMVJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARMVL000000000-CARNAN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARNAP000000000-CARNBQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARNBS000000000-CARNBX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARNBZ000000000-CARNCL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARNCN000000000-CARNGO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARNGQ000000000-CARNNQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARNNS000000000-CARNNZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARNOB000000000-CARNPZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARNQB000000000-CARNTT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARNTV000000000-CARNUU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARNUW000000000-CARNWM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARNWO000000000-CARNZQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARNZS000000000-CAROBZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAROCB000000000-CAROEQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAROES000000000-CAROFA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAROFC000000000-CAROFV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAROFX000000000-CAROIB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAROID+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAROIF000000000-CAROJB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAROJD000000000-CAROJR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAROJT000000000-CAROJW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAROJY000000000-CAROMZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARONC000000000-CAROPU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAROPW000000000-CAROQJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAROQL000000000-CAROTF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAROTH000000000-CAROTR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAROTT000000000-CAROWS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAROWU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAROWW000000000-CAROXU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAROXW000000000-CAROZB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAROZD000000000-CARPFE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARPFG000000000-CARPHY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARPIA000000000-CARPJJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARPJL000000000-CARPLB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARPLD000000000-CARPLZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARPMB000000000-CARPOI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARPOK000000000-CARPWN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARPWP000000000-CARPXP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARPXR000000000-CARPXV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARPXX000000000-CARQAA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARQAC000000000-CARQAI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARQAK000000000-CARQBH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARQBJ000000000-CARQCR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARQCT000000000-CARQKG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARQKI000000000-CARQND999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARQNF000000000-CARQPS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARQPU000000000-CARQTS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARQTU000000000-CARQWR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARQWT000000000-CARQWY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARQXA000000000-CARQZS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARQZU000000000-CARQZW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARQZY000000000-CARREF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARREH000000000-CARRFI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARRFK000000000-CARRFY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARRGA000000000-CARRHK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARRHM000000000-CARRHZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARRIB000000000-CARRID999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARRIG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARRII000000000-CARRIK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARRIM000000000-CARRIQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARRIS000000000-CARRJW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARRJY000000000-CARRKB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARRKD000000000-CARRKI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARRKK000000000-CARRLP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARRLR000000000-CARRML999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARRMO000000000-CARRSG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARRSI000000000-CARRSN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARRSP000000000-CARRTL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARRTO000000000-CARRUU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARRUW000000000-CARRYI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARRYK000000000-CARSAK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARSAM000000000-CARSBP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARSBR000000000-CARSCA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARSCC000000000-CARSCS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARSCU000000000-CARSCZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARSDB000000000-CARSDZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARSFA000000000-CARSFZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARSGB000000000-CARSIE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARSIG000000000-CARSIR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARSIT000000000-CARSKW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARSKZ000000000-CARSLH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARSLJ000000000-CARSMA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARSMD000000000-CARSQK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARSQM000000000-CARSQV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARSQX000000000-CARSRI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARSRK000000000-CARSSB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARSSD000000000-CARSSU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARSSW000000000-CARSTF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARSTH000000000-CARSVC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARSVE000000000-CARSXW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARSXY000000000-CARSYA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARSYC000000000-CARSYF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARSYH000000000-CARSYM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARSYO000000000-CARTAE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARTAG000000000-CARTAI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARTAK000000000-CARTBE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARTBG000000000-CARTBH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARTBJ000000000-CARTCV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARTCX000000000-CARTCZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARTDB000000000-CARTDF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARTDH000000000-CARTDM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARTDO000000000-CARTFH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARTFJ000000000-CARTGQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARTGS000000000-CARTHD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARTHF000000000-CARTKF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARTKH000000000-CARTNB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARTNE000000000-CARTNG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARTNI000000000-CARTNO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARTNQ000000000-CARTPC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARTPE000000000-CARTPU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARTPX000000000-CARTQA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARTQC000000000-CARTQJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARTQL000000000-CARTQR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARTQT000000000-CARTRF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARTRH000000000-CARTRI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARTRK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARTRM000000000-CARTRU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARTRW000000000-CARTSO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARTSQ000000000-CARTUG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARTUI000000000-CARTWC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARTWE000000000-CARTWJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARTWL000000000-CARTYA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARTYC000000000-CARTYI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARTYK000000000-CARTYX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARTYZ000000000-CARTZT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARTZW000000000-CARTZY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARUAA000000000-CARUAC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARUAE000000000-CARUAG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARUAI000000000-CARUAJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARUAL000000000-CARUAN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARUAP000000000-CARUAR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARUAT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUAW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARUAY000000000-CARUBC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARUBF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARUBH000000000-CARUBM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARUBO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARUBT000000000-CARUBV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARUBX000000000-CARUCG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARUCI000000000-CARUCK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARUCM000000000-CARUCO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARUCQ000000000-CARUDB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARUDD000000000-CARUDL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARUDN000000000-CARUDO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARUDQ000000000-CARUDR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARUDT000000000-CARUDZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARUEB000000000-CARUFD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARUFF000000000-CARUFX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARUFZ000000000-CARUGQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARUGT000000000-CARUHG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARUHK000000000-CARUIO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARUIQ000000000-CARUIV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARUIX000000000-CARUJQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARUJS000000000-CARUKB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARUKD000000000-CARUKG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARUKI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARUKL000000000-CARULB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARULE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARULG000000000-CARULN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARULP000000000-CARULR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARULT000000000-CARUME999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARUMG000000000-CARUMO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARUMQ000000000-CARUMR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARUMT000000000-CARUNI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARUNK000000000-CARUOJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARUOL000000000-CARUPO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARUPQ000000000-CARUPV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARUPX000000000-CARUQR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARUQT000000000-CARUQU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARUQW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARUQY000000000-CARUQZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARURC000000000-CARURD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARURF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARURO000000000-CARURP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARURT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARURZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARUSB000000000-CARUSC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARUSH000000000-CARUSI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARUSK000000000-CARUSS999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARUSU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUSX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARUSZ000000000-CARUTE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARUTG000000000-CARUTK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARUTM000000000-CARUUH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARUUJ000000000-CARUUU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARUUW000000000-CARUUX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARUUZ000000000-CARUWB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARUWD000000000-CARUWE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARUWI000000000-CARUWL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARUWO000000000-CARUWV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARUWX000000000-CARUXA999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARUXD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CARUXJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARUXL000000000-CARUXN999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARUXT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARUXX000000000-CARVBR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARVBT000000000-CARVDV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARVDX000000000-CARVKH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARVKJ000000000-CARVKN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARVKP000000000-CARVPD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARVPF000000000-CARVTP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARVTR000000000-CARVWT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARVWV000000000-CARVXZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARVYB000000000-CARWBV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARWBX000000000-CARWEY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARWFA000000000-CARWGU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CARWGW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CARWGY000000000-CARWKL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARWKN000000000-CARWKQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARWKS000000000-CARWLJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARWLL000000000-CARWOV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARWOX000000000-CARWRL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARWRN000000000-CARWTS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARWTU000000000-CARWTX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARWTZ000000000-CARWVL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARWVN000000000-CARWWF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARWWH000000000-CARWXI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARWXK000000000-CARWZQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARWZS000000000-CARXCM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARXCO000000000-CARXGY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARXHA000000000-CARXJZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARXKC000000000-CARXLP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARXLR000000000-CARXOG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARXOI000000000-CARXPC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARXPE000000000-CARXQG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARXQI000000000-CARXRE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARXRG000000000-CARXXJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARXXL000000000-CARYAM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CARYAO000000000-CASBCP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CASBCS000000000-CASBIE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CATKWV000000000-CATKZC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CATKZE000000000-CATKZN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CATKZP000000000-CATLJF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CATLKS000000000-CATLOD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CATLOF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CATLQM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CATLQT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CATLQV000000000-CATLQW999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CATLQY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CATLRD000000000-CATLRE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CATLRM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CATLRP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CATLRS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CATLRY+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CATLSA000000000-CATLSB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CATLSE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CATLSG000000000-CATLSH999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CATLSP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CATLSR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CATLSV000000000-CATLSX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CATLTH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CATLTL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CATLTN+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CATLTX000000000-CATLTY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CATLUB000000000-CATLUC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CATLUE000000000-CATLUF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CATLUH000000000-CATLUI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CATLUO000000000-CATLUP999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CATLWF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CATLWJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CATLWQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CATLYM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CATLZE+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CATLZH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CATLZR+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CATLZW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CATMAO000000000-CATMAV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CATMAY000000000-CATMAZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CATMBB000000000-CATMBD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CATMBG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CATMBI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CATMBK000000000-CATMBQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CATMBS000000000-CATMBU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CATMBX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CATMBZ000000000-CATMCA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CATMCD000000000-CATMCF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CATMCH000000000-CATMCM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CATMCQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CATMCV+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CATMCX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CATMDC000000000-CATMDE999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CATMEG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CATMEJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CATMEP+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CATMER+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CATMMU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CATMNC+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CATMOT+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CATMPD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CATMPF+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CATMPH000000000-CATMPI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CATMPR000000000-CATMPS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CATMUY000000000-CATMVC999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CATMVG+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CATMVI000000000-CATMVN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CATMVP000000000-CATMVQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CATMVS000000000-CATMZQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CATMZS000000000-CATNCO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CATNCQ000000000-CATNDE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CATNDG000000000-CATNDJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CATNDL000000000-CATNEF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CATNEJ000000000-CATNEL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CATNEO000000000-CATNEU999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CATNUW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CATNVF000000000-CATNVZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CATOAL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CATOHR000000000-CATOPO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CATVPU000000000-CATVWV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CATVWX000000000-CATVXD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CATVXF000000000-CATVYY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CATVZA000000000-CATVZS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CATVZU000000000-CATWAE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CATWAG000000000-CATWAQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CATWAS000000000-CATWDN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CATWDP000000000-CATWDQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CATWDS000000000-CATWEG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CATWEI000000000-CATWFS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CATWFU000000000-CATWGA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CATWGC000000000-CATWGF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CATWGH000000000-CATWHB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CATWHD000000000-CATWHH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CATWHJ000000000-CATXER999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CATXFC000000000-CATXGK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CATXGM000000000-CATXOD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CATXOU+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CATXOW000000000-CATXOY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CATXPD+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CATXRH000000000-CATYKS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CATYKU000000000-CATYSV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CATYSX000000000-CATYWN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CATYWP000000000-CATYYN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CATYYP000000000-CATYYZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CATYZB000000000-CATZAQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CATZAS+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CATZAU000000000-CATZAY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CATZBA000000000-CATZBT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CATZBV000000000-CATZCD999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CATZCI+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CATZCL000000000-CATZCO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CATZCR000000000-CATZKT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CATZKV000000000-CATZLJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CATZLM000000000-CATZVN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CATZVP000000000-CAUACO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUACQ000000000-CAUAJN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUAJP000000000-CAUAJR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUAJV000000000-CAUAKB999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAUART+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAUARW+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAUASA000000000-CAUASF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUASH000000000-CAUATU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUAVB000000000-CAUAVD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUAVF000000000-CAUAVL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUAVN000000000-CAUAVW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUAVY000000000-CAUBOM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUBOO000000000-CAUBUH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUBUJ000000000-CAUBUT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUBUV000000000-CAUDIX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAUDLZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAUDMB000000000-CAUDMF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUDMH000000000-CAUDNQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUDNS000000000-CAUEEO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAUEER+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAUEET000000000-CAUEGG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUEII000000000-CAUFVH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUFVS000000000-CAUGLX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUGLZ000000000-CAUHTP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUJND000000000-CAUJNO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUOKV000000000-CAUOPQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAUOQQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAUOQX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAUOQZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAUORB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAUORD000000000-CAUOSA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUOSC000000000-CAUOSG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUOSI000000000-CAUOSR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUOST000000000-CAUOTB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUOTD000000000-CAUOTK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUOTM000000000-CAUOUA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUOUC000000000-CAUOUD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUOUF000000000-CAUOUG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUOUI000000000-CAUOVY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUOWA000000000-CAUOWJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAUOWL+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAUOWN000000000-CAUOXB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUOXD000000000-CAUOXK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUOXM000000000-CAUOXQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUOXS000000000-CAUOYO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUOYQ000000000-CAUOYT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUOYV000000000-CAUOYY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUOZA000000000-CAUOZD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUOZF000000000-CAUOZO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUOZR000000000-CAUOZU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUOZW000000000-CAUPAE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUPAG000000000-CAUPAR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUPAT000000000-CAUPAV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUPAY000000000-CAUPBI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUPBK000000000-CAUPBZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUPCB000000000-CAUPCO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUPCQ000000000-CAUPCV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUPCX000000000-CAUPDP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUPDR000000000-CAUPEG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAUPEK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAUPEN000000000-CAUPEQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUPES000000000-CAUPEU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUPEW000000000-CAUPGO999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAUPGQ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAUPGS000000000-CAUPHK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUPHN000000000-CAUPHP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUPHR000000000-CAUPHS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUPHU000000000-CAUPHW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUPHZ000000000-CAUPJB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUPJD000000000-CAUPJR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUPJT000000000-CAUPJU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUPJW000000000-CAUPJY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAUPKB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAUPKE000000000-CAUPKM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAUPKO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAUPKQ000000000-CAUPKV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUPKX000000000-CAUPLG999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAUPLJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAUPLL000000000-CAUPLQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUPLS000000000-CAUPLV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUPLX000000000-CAUPMC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUPME000000000-CAUPMF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUPMH000000000-CAUPMI999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAUPMK+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAUPMM+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAUPMO000000000-CAUPMP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUPMS000000000-CAUPMX999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAUPMZ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAUPNB000000000-CAUPNF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAUPNH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAUPNJ000000000-CAUPNK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUPNN000000000-CAUPNZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAUPOB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAUPOD000000000-CAUPOM999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAUPOO+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAUPOQ000000000-CAUPOT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUPOX000000000-CAUPOY999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAUPPA+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAUPPD000000000-CAUPPF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUPPI000000000-CAUPPY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUPQA000000000-CAUPQF999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAUPQH+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special2 CAUPQJ+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAUPQM000000000-CAUPQN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUPQP000000000-CAUPQR999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAUPRB+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAUPSY000000000-CAUTMV999999999  embl_tpa_wgs_nuc # 6+9",
    "special2 CAUTMX+9 embl_tpa_wgs_nuc",
    ": 000000000-999999999",
    "special  CAUTNA000000000-CAUTOK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAUTOM000000000-CAUVWA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAWVRH000000000-CAWWDE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAWZYP000000000-CAWZYZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXAAG000000000-CAXACN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXAFD000000000-CAXAJU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXASQ000000000-CAXAUW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXAUY000000000-CAXAXI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXAXL000000000-CAXAYR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXAYT000000000-CAXBOQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXBOS000000000-CAXBSW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXBUO000000000-CAXCFA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXCFC000000000-CAXCFE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXDIY000000000-CAXDKL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXDKN000000000-CAXDLL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXDLN000000000-CAXDMO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXDMQ000000000-CAXDMR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXDMV000000000-CAXDNN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXDNQ000000000-CAXDOD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXDOI000000000-CAXDOJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXDOL000000000-CAXDOO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXDOT000000000-CAXDPF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXDPH000000000-CAXDPJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXDPL000000000-CAXDPM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXDPR000000000-CAXDPU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXDPW000000000-CAXDPX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXDPZ000000000-CAXDPZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXDQB000000000-CAXDQE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXDQG000000000-CAXDQG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXDQJ000000000-CAXDQT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXDQW000000000-CAXDQY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXDRB000000000-CAXDRB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXDRE000000000-CAXDRE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXDRG000000000-CAXDRG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXDRI000000000-CAXDRU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXDRW000000000-CAXDRX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXDRZ000000000-CAXDSE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXDSG000000000-CAXDSK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXDSM000000000-CAXDTH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXDTJ000000000-CAXDTM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXDTO000000000-CAXDTO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXDTW000000000-CAXDTW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXEFG000000000-CAXEFJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXEGS000000000-CAXEKY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXELA000000000-CAXEMQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXEMS000000000-CAXENB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXEND000000000-CAXENO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXENQ000000000-CAXEOK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXEOM000000000-CAXEOS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXEOU000000000-CAXEQM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXEQO000000000-CAXEQW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXEQY000000000-CAXERD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXERF000000000-CAXERI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXERK000000000-CAXERM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXERO000000000-CAXERS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXERU000000000-CAXERW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXERY000000000-CAXESF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXESH000000000-CAXESR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXEST000000000-CAXETH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXETJ000000000-CAXETW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXETY000000000-CAXEUB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXEUD000000000-CAXEUI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXEUK000000000-CAXEUM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXEUP000000000-CAXEVZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXEWB000000000-CAXEWG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXEWI000000000-CAXEWO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXEWQ000000000-CAXEWR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXEWT000000000-CAXEYF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXEYH000000000-CAXEYH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXEYJ000000000-CAXEYL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXEYN000000000-CAXEYQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXEYS000000000-CAXEYS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXEYU000000000-CAXEYX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXEYZ000000000-CAXEYZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXEZB000000000-CAXEZC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXEZE000000000-CAXEZM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXEZO000000000-CAXEZW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXEZY000000000-CAXEZY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFAA000000000-CAXFAB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFAD000000000-CAXFAF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFAH000000000-CAXFAM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFAO000000000-CAXFAV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFAX000000000-CAXFAX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFBA000000000-CAXFBA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFBD000000000-CAXFBD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFBF000000000-CAXFBG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFBJ000000000-CAXFBS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFBU000000000-CAXFBW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFBZ000000000-CAXFCX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFCZ000000000-CAXFDS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFDU000000000-CAXFDX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFDZ000000000-CAXFEA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFEO000000000-CAXFEO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFER000000000-CAXFER999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFEW000000000-CAXFEW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFEY000000000-CAXFEY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFFB000000000-CAXFFB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFFD000000000-CAXFFF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFFL000000000-CAXFFL999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFFS000000000-CAXFFS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFFU000000000-CAXFFZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFGC000000000-CAXFGE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFGG000000000-CAXFGG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFGI000000000-CAXFGK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFGM000000000-CAXFGM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFGO000000000-CAXFGT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFGX000000000-CAXFGY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFHB000000000-CAXFHC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFHF000000000-CAXFHF999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFIC000000000-CAXFIC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFIF000000000-CAXFIH999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFIJ000000000-CAXFIK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFIQ000000000-CAXFIU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFIY000000000-CAXFJG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFJI000000000-CAXFJI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFJL000000000-CAXFJP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFJR000000000-CAXFJR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFJT000000000-CAXFJW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFJY000000000-CAXFJZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFKB000000000-CAXFKB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFKD000000000-CAXFKE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFKJ000000000-CAXFKJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFKM000000000-CAXFKN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFKT000000000-CAXFKT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFKV000000000-CAXFKV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFKX000000000-CAXFKZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFLB000000000-CAXFLC999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFLE000000000-CAXFLI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFLK000000000-CAXFLK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFLM000000000-CAXFLM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFLO000000000-CAXFLQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFLS000000000-CAXFLT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFLV000000000-CAXFLV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFLY000000000-CAXFLY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFMB000000000-CAXFMB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFMD000000000-CAXFMD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFMI000000000-CAXFMI999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFMN000000000-CAXFMN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFMP000000000-CAXFMP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFMS000000000-CAXFMW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFMY000000000-CAXFNA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFNC000000000-CAXFND999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFNF000000000-CAXFNM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFNO000000000-CAXFNO999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFNQ000000000-CAXFNR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFNT000000000-CAXFNT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFNW000000000-CAXFNZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFOB000000000-CAXFOX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFOZ000000000-CAXFPB999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFPD000000000-CAXFPD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFPF000000000-CAXFPG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFPI000000000-CAXFPM999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFPO000000000-CAXFPW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFPY000000000-CAXFPY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFQA000000000-CAXFQA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFQC000000000-CAXFQE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFQG000000000-CAXFQN999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFQP000000000-CAXFQP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFQR000000000-CAXFQR999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFQT000000000-CAXFQT999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFQV000000000-CAXFQV999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFQY000000000-CAXFQY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFRA000000000-CAXFRA999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFRE000000000-CAXFRG999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFRJ000000000-CAXFRK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFRQ000000000-CAXFRQ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFRS000000000-CAXFRS999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFRX000000000-CAXFRY999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFSC000000000-CAXFSD999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFSJ000000000-CAXFSJ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFSR000000000-CAXFSW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFSY000000000-CAXFTK999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFTM000000000-CAXFTW999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXFZX000000000-CAXFZZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXGAB000000000-CAXGCZ999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXGHC000000000-CAXGYU999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXGZH000000000-CAXHBE999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXHBG000000000-CAXHHX999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXHYR000000000-CAXIDP999999999  embl_tpa_wgs_nuc # 6+9",
    "special  CAXIEU000000000-CAXIEV999999999  embl_tpa_wgs_nuc # 6+9",
    "",
    "# Some \"EMBL\" TPA nucleotide accessions are really third-party annotations.",
    "special2 HBHG+8 embl_tpa_tsa_nuc",
    ": 00000000-99999999",
    "special2 HBHS+8 embl_tpa_tsa_nuc",
    ": 00000000-99999999",
    "special2 HBRC+8 embl_tpa_tsa_nuc",
    ": 00000000-99999999",
    "special2 HBRG+8 embl_tpa_tsa_nuc",
    ": 00000000-99999999",
    "special  HBRM00000000-HBRN99999999  embl_tpa_tsa_nuc # 4+8",
    "special  HBRR00000000-HBRS99999999  embl_tpa_tsa_nuc # 4+8",
    "special  HBRU00000000-HBRV99999999  embl_tpa_tsa_nuc # 4+8",
    "special2 HBRZ+8 embl_tpa_tsa_nuc",
    ": 00000000-99999999",
    "special  HBSB00000000-HBSP99999999  embl_tpa_tsa_nuc # 4+8",
    "special2 HBSZ+8 embl_tpa_tsa_nuc",
    ": 00000000-99999999",
    "special2 HBTB+8 embl_tpa_tsa_nuc",
    ": 00000000-99999999",
    "special  HBXM00000000-HBXN99999999  embl_tpa_tsa_nuc # 4+8",
    "special  HBXP00000000-HBXU99999999  embl_tpa_tsa_nuc # 4+8",
    "special  HBXW00000000-HBYC99999999  embl_tpa_tsa_nuc # 4+8",
    "special  HBYF00000000-HBYO99999999  embl_tpa_tsa_nuc # 4+8",
    "special2 HBYQ+8 embl_tpa_tsa_nuc",
    ": 00000000-99999999",
    "special2 HBYS+8 embl_tpa_tsa_nuc",
    ": 00000000-99999999",
    "special2 HBYU+8 embl_tpa_tsa_nuc",
    ": 00000000-99999999",
    "special  HBYX00000000-HBYY99999999  embl_tpa_tsa_nuc # 4+8",
    "special2 HBZI+8 embl_tpa_tsa_nuc",
    ": 00000000-99999999",
    "special2 HBZK+8 embl_tpa_tsa_nuc",
    ": 00000000-99999999",
    "special  HBZM00000000-HBZN99999999  embl_tpa_tsa_nuc # 4+8",
    "special2 HBZQ+8 embl_tpa_tsa_nuc",
    ": 00000000-99999999",
    "special2 HBZS+8 embl_tpa_tsa_nuc",
    ": 00000000-99999999",
    "",
    "# Some \"EMBL\" 8- and 10-character protein accessions are really third-party",
    "# annotations.",
    "special2 CAD+5 embl_tpa_prot",
    ": 29848-50 6 8-68 71-9 43606 4269 55807 6854 9554 973-5 62250 384-5 5874-5",
    ": 6056-7 176 451-3 657 7552-3 75-9 82 92-3 5 963-4 85 8170-1 71139 9639 708",
    ": 80155-7 67 9 243 8272-3 9265-8 361 763 874-5 91637 909-11 2036 8145",
    "special2 CAE+5 embl_tpa_prot",
    ": 00378-414 502 12270-6 8110 30337 62 475-6 90-502 45343 7417 8362-3 73-93 5-6",
    ": 51393-417 851 5-6 95-916 2317-20 4311-52 495 75602-31 743 82298-9",
    "special2 CAF+5 embl_tpa_prot",
    ": 06526-30 18402 21736-9 32458",
    "special2 CAG+5 embl_tpa_prot",
    ": 23871 6661-4 750 9023-30 113 30664 3760 4288-96",
    "special2 CAH+5 embl_tpa_prot",
    ": 03726-7 17840-1 60-2 8893 925-6 56764 9193-4 69244-380 74220 5 89261-3",
    "special2 CAI+5 embl_tpa_prot",
    ": 56319-35 9572 61342-7 77244-5 7 8909 84981-5013 94882-3 931-4 6518-9 37",
    ": 9155-6 8-63 872",
    "special2 CAJ+5 embl_tpa_prot",
    ": 00225-52 9703 13823-5 27980-1 9275 301-2 30479 81-4 1324 3891 8407-8 99 40614",
    ": 3796-809 920-1 4080 121 286-7 438-9 41 51090 5345 730-3 45-7 83-4 824-5",
    ": 7445-6 644-6 70647-9 5788-9 91-6 7879-86 80803 4770 5665-75 7-711 3-40 97442",
    "special2 CAK+5 embl_tpa_prot",
    ": 26553 777-86 32514 639",
    "special2 CAL+5 embl_tpa_prot",
    ": 07997 8000-5 10024 36192 432-3 41938-42 8250 381-3 59562-77 63903-4 4054-8",
    ": 9034-6 54 6-118 90972-3",
    "special2 CAM+5 embl_tpa_prot",
    ": 06633 12311 31706-8 891-6 2419 3450-7 512-20 91227",
    "special  CAN88845-CAN88848  embl_tpa_prot",
    "special  CAO03085-CAO03089  embl_tpa_prot",
    "special2 CAP+5 embl_tpa_prot",
    ": 39936-7 45848 9313-8 21-7 64321 3-34",
    "special2 CAQ+5 embl_tpa_prot",
    ": 34914-30 76705-12 8",
    "special2 CAR+5 embl_tpa_prot",
    ": 63508-9 82065-7 176-86 94693-710 5342-61 7787",
    "special  CAU95867-CAU95879  embl_tpa_prot",
    "special  CAV13457           embl_tpa_prot",
    "special2 CAX+5 embl_tpa_prot",
    ": 62810-3 3316 67",
    "special2 CBF+5 embl_tpa_prot",
    ": 69357 9-60 2 4 6 8-9 71 3 5 7 9 81 3 5 7-8 90 2 4 6-7 9 401 3 5 7-8 10 2 4 6",
    ": 8-9 21 3 5 7 9 31-2 4 6 8 40-1 3 5 7 9 51 3-4 6 8-9 61 3 5 7-8 70 2-3 5 7",
    ": 9-80 2 4-5 7 9-90 2 4 6-7 9-500 2 4 6-7 9 11 3 5 7-8 20 2 4-5 7 9 31 3-4 6 8",
    ": 40 2 4 6 8 50 2 4-5 7-8 60 2 4-5 7 9 71 3 5-6 8 80 2-3 5 7 9 91-2 4 6 8 600 2",
    ": 4-5 7 9 11 3 5 7 9 21 3 5 7 9 31 3 5 7 9-40 2 4 6 8-9 52-3 5 7 9 61 3 5 7 9",
    ": 71-2 4 6 8 80 2 4 6 8-9 91 3 5 7 9 701 3 5 7 9 11 3 5 7 9-20 2 4 6 8 30 2 4 6",
    ": 8 40 2 4 6 8 50 2 4 6 8-9 61 3 5 7 9 71 3 5 7-8 80 2 4 6 8 90-1 3 5 7 9 801 3",
    ": 5 7 9 11 3 5 7 9 21 3 5 7 9 31-2 4 6 8 40 2 4 6 8 50 2 4 6-7 9 61 3 5 7 9 71",
    ": 3 5 7 9 81 3-4 7 9-90 2 4 6 8 900 2 4 6 8 10-1 3 5 7 9 21 3 5-6 8 30 2 4 6 8",
    ": 40 2 4-5 7 9 51 3 5 7 9 61 3 5 7 9 71 3 5 7 9 81 3 5 7 9 91-2 4 6 8",
    ": 70000 2 4 6 8 10 2 4 6 8-9 21 3 5 7 9 31 3 5 7 9 41 3 5 7 9 51 3 5 7 9 61-2 4",
    ": 6 8 70 2 4 6 8 80 2 4-5 7 9 91 3-4 6 8 100-1 3 5 7-8 10 2 4 6 8 20 2 4 6 8 30",
    ": 2 4 6 8-9 43 5 7 9 51 3 5 7 9 61-2 4 6 8 70 2-3 5 7 9-81 3 5 7 9-90 2 4 6 8",
    ": 200 2 4 6 8-9 11 3 5 7 9 21 3-4 6 8 30 2 4 6-7 9 41 3 5 7 9 51 3 5 7 9 61 3 5",
    ": 7 9 71 3 5 7 9-80 2 4 6 8 90 2 4 6 8 300-1 3 5 7 9 11 3 5 7 9-20 2 4 6 8 30 2",
    ": 4 6 8 40 2 4 6 8 50 2 4 6 8 60 2 4 6 8 70 2 4-5 7 9 81 3 5 7 9 91 3 5 7 9 401",
    ": 3 5 7 9-10 2 4 6 8 20 2 4 6 8 30 2 4-5 7 9 41 3 5 7 9 51 3 5 7 9 61-2 4 6 8",
    ": 70 2 5-6 8 80 2 4 6 8 90-1 3 5 7 9 501 3-4 6 8 10 2 4 6 8 20 2 4 6 8-9 31 3 5",
    ": 7 9-40 2 4 6 8 50 2 4 6-7 9 61 3 5 7 9 71 3 5 7 9 81 3-4 6 8 90 2 4 6-7 9 601",
    ": 3 5 7 9 11-2 4 6 8 20 2 4 6 8-9 31 3 5 7 9-40 2 4 6-7 9-50 2 4 6-7 9 61 3 5-6",
    ": 8 70 2 4-5 7 9 81 3-4 6 8 90 2 4 6 8 700-1 3 5 7 9 11-2 4 6 8 20 2 4 6 8 30",
    ": 2-3 5 7 9 41 3 5 7 9 51 3 5-6 8 60 2 4 6 70 2 4 6-7 9 81 3 5 7 9 91 3 5 7-8",
    ": 800 2 4 6 8 10 2 4-5 7 9 21 3 5 7 9 31 3 5 7 9 41 3 5-6 8 50 2 4 6 8-9 61 3 5",
    ": 7 9-70 2 4 6 8 80 2 4 6-7 9 91 3 5 7 9 901 3 5 7-8 10 2 4 6 8 20-1 3 5 7 9 31",
    ": 3 5 7 9 41 3 5-6 8 50 2 4 6 8 60 2 4 6 8 70 2 4 6-7 9 81 3 5 7 9 91 3-4 6 8",
    ": 1000 2 4 6-7 9 11 3 5 7 9 21 3 5 7 9 31-2 4 6 8 40-1 3 5 7 9 51 3 5 7-8 60 2",
    ": 4 6 8 70-1 3 5 7 9 81 3 5 7 9-90 2 4 6 8 100 2 4 6 8 10 2 4 6-7 9 21 3 5 7 9",
    ": 31 3 5 7-8 40 2 4 6 8 50 2 4 6-7 9 61 3 5 7 9 71-2 4 6 8 80 2 4 6 8 90 2 4 6",
    ": 8 200-1 3 5 7 9 11 3 5 7-8 20 2 4 6 8 30 2 4 6-7 9 41 3 5 7 9 51 3-4 7-8 60 2",
    ": 4 6 8 70-1 3 5 7 9 81 3 5 7 9 91 3 5-6 8 300 2 4 6 8 10 2-3 5 7 9 21 3 5 7 9",
    ": 31 3 5 7 9 41 3-4 6 8 50 2 4 6-7 9 61 3 5 7 9 71 3-4 6 8 80 2 4 6 8 90 2-3 5",
    ": 7 9 401 3 5 7 9 11 3 5-6 8 20 2 4 6 8 30 2 4 6 8 40 2 4-5 7 9 51 3 5 7 9 61 3",
    ": 5 7 9-70 2 4 6 8 80 2 4 6-7 9 91 3 5 7 9 501 3 5 7 9 11 3 6-7 9 21 3 5 7 9 31",
    ": 3 5 7 9 41 3 5 7 9 51-2 4 6 8 60 2 4 6 8 70 2 4 6 8 80 2 4-5 7 9 91 3 5 7 9",
    ": 601 3 5 7 9 11 3 5 7 9-20 2 4 6 8 30 2 4 6 8 40 2 4 6 8 50-1 3 5 7 9 61 3 5-6",
    ": 8 70-1 3 5 7 9 81 3 5 7-8 90 2 4 6 8 700 2-3 6 8 10 2 4 6 8 20 2 4 7 9 31 3 5",
    ": 7 9 41 3 5 7 9-50 2 4 6 8 60 2 4 6 8 70 2-3 5 7 9 81 3 5 7-8 90 2-3 5 7 9 801",
    ": 3 5 7 9 11 3 5 7 9 21 3 5 7 9-30 2 4 6-7 9 41 3-4 6 8 50 2 4 6 8 60 2-3",
    ": 3380 2 4 6 8 90 2 4 6-7 9 401 3 5 7 9 11 3 5 7 9 21 3-4 6 8 30-1 3 5-6 8 40-1",
    ": 4 6-7 9 51 3 5 7 9 61 3 5 7 9 71 3 5 7 9-80 2 4 6 8 90 2 4-5 7 9 501 3 5 7 9",
    ": 11 3-4 6 8 20 2 4 6 8 30 2 4-5 7 41 3 5 7 9 51 3 5-6 8 60 2 4 6 8 70 2 4 6-7",
    ": 9 81 3-4 6 8 90 2 4 6-7 9 601 3 5 7 9 11-2 4 6 8 20-1 3 5 7 9 31 3 5 7 9 41",
    ": 3-4 6 8 50 2 4 6 8 60 2-3 5 7 9 71-2 4 6 8 80 2 4 6 8 90 2 4 6-7 9 701 3 5 7",
    ": 9 11 3 5 7 9-20 2 4 6 8 30-1 3 5 7 9 41 3 5 7 9 51-2 4 6 8 60 2 4-5 7 9 71 3",
    ": 5 7-8 80 2 4 6 8 90 2-3 5 7 9 801 3 5-6 8-9 11 3 5 7-8 20 2 4 6 8 30 2-3 5",
    ": 8-9 41 3 5 7-8 50 2 4 6 8 60 2 4 6 8 70-1 3 5-6 8 80 2 4-5 7-8 90-1 3 5 7-8",
    ": 900 2 4 6 8 10-1 3 5 7 9 21 3-4 6 8 30 2-3 5 7-8 40 2 4-5 7 9 51-2 4-5 7 9 61",
    ": 3 5 7 9 71-2 4 6 8-9 81-2 4 6 8-9 91 3 5 7",
    ": 9-4000 2 4 6 8-9 11 3 5 7 9 21 3 5 7-8 30 2 4-5 7 9 41 3 5-6 8 50 2 4 6 8 60",
    ": 2 4 6 8-9 71 3-4 6 8-9 81 3 5 7 9 91 3 5 7-8 100 2 4 6 8 10 2 4 6 8 20-1 3 5",
    ": 7 9 31 3 5-6 8 40 2 4 6 8-9 51 3 5-6 8 60 2-3 5 7 9 71 3 5 7-8 80 2 4 6-7 9",
    ": 91 3 5 7 9 201-2 4 6 8 10 2-3 5 7 9 21 3-4 6 8 30 2 4-5 7 9 41-2 4 6 8 50 2 4",
    ": 6 8 60-1 3 5 7 9 71-2 4 6 8-9 81 3 5 7 9 91 3 5-6 8 300 2 4 6 8 10-1 3 5 7 9",
    ": 21 3 5-6 8 30 2 4 6 8 40-1 3 5 7 9 51 3 5-6 8 60 2 4-5 7 9 71 3 5-6 8 80 2 4",
    ": 6-7 9 91 3 5-6 8 401-2 4 6 8 10 2-3 5 7 9 21 3-4 6 8 30 2 4 6-8 40 2 4 6 8 50",
    ": 2-3 5-6 8 60-1 3 5 7 9 71 3 5-6 8 80 2 4-5 7 9 91 3 5-6 8 500 2-3 5 7 9 11-2",
    ": 4 6 8 20-1 3 5 7 9 31 3-4 6 8 40 2-3 5 7-8 50 2-3 5-6 8 60 2 4 6-7 9 71-2 4 6",
    ": 8 80 2 4 6 8 90-1 3 5 7 9 601 3 5-6 8-10 2 4 7-8 20 2 4 6 8 30 2 4 6-7 9 41 3",
    ": 5 7-8 50 2 4 6 8 60-1 3 5 7 9 71 3 5 7 9 81 3 5 7 9 91-2 4 6 8 700 2 4 6 8",
    ": 10-1 3 5 7 9 21-2 4 6 8 30 2 4 6 8 40 2-3 5 7 9 51 3-5 7 9 61 3 5 7 9 71 3 5",
    ": 7 9 81 3 5 7 9 91 3 5 7 9 801 3 5 7 9 11 3 5 7 9 21 3 5 7 9 31 3 5 7 9 41 3 5",
    ": 7 9 51 3-4 6 8 60 2 4 6 8 70-1 3 5 7 80 2 4 6 8 90 2-3 5 7 9 901 3 5 7-8 10 2",
    ": 4 6 8 20 2 4 6 8 30 2 4 6 8 40 2 4 6 8 50 2 4 6 8 60 2 4 6 8-9 71 3 5 7 9 81",
    ": 3 5 7 9 91 3-4 6 8",
    ": 5000 2 4 6 8 11-2 4 6 8 20 2 4 6 8 30 2 4 6 8 40 2 4 6 8 50 2 4 6 8 60 2 4 6",
    ": 8 70 2 4 6 8 80 2 4 6 8 90 2 4 6 8 100 2-3 5 7 9 11 3 5 7 9 21 3 5 7 9 31-2 4",
    ": 6 8 40 2 4 6 8 50 2 4 6 8 60 2-3 5 7 9 71 3-4 6 8 80 2 4 6 8-9 91 3 5 7 9 201",
    ": 3 5 7 9 11 3 5 7-8 20 2-3 5 8 30 2 4 6 8 40 2 4 6 8 50 2 4 6 8 60-1 3 5 7 9",
    ": 71 3 5 7 9 81 3 5 7 9 91 3-4 6 8 300 2 4-5 7-8 10 2 4 6 8 20 2 4 6 8 30 2 4 6",
    ": 8 40 2 4 6 8 50 2 4 6 8 60 2 4 6 8 70 2 4 6 8 80 2 4 6 8 90 2 4 6 8 400 2-3 5",
    ": 7 9 11 3 5 7 9 21 3 5 7 9-30 2 4 6 8 40 2 4 6 8 50 2 4 6 8 60 2 4 6 8 70 2 4",
    ": 6 8 80 2 4 6 8 90-1 3 5 7 9 501 3 6 8 10 2 4 6 8 20 2 4-5 7 9 31 3 5 7 9 41 3",
    ": 5 7 9 51 3 5-6 8 60 2 4 6 8 70 2 4 6 8 80 2 4 7 9 91 3-4 6 8 600 2 4-6 8 10-1",
    ": 3 5 7 9 21 3 5 7 9-30 2 4 6 8 40 2 4 6 8-9 51 3 5 7 9 61 3 5 7 9 71 3 5 7 9",
    ": 81 3 5 7 9 91 3 5 7 9 701 3-4 6 8 10 2 4 6 8 20 2-3 5 7 9 31 3 5 7 9 41 3 5",
    ": 7-8 50 2 4 6 8 60 2 4 6 8 70 2 4 6 8-9 81 3 5 7 9-90 2 4 6 8 800 2 4 6 8-9 11",
    ": 3 5 7 9 21 3 5 7 9 31 3 5 7 9 41 3 5 7 9 51 3 5 7-8 60 2 4 6 8 70 2 4 6 8 80",
    ": 2 4 6 8 90 2 4 6 8 900 2 4 6 8 10 2 4 6 8 20 2 4-5 8 30 2 4 6 8 40 2 4 6 8 50",
    ": 2 4 6 8 60 2 4 6 8 70 2 4 6 8 80 2 4 6 8 90 2 4 6 8",
    ": 6000 2 4 6 8 10 2 4 6 8 20 2 4 6 8 30 2 4 6 8 40 2 4 6 8 50 2 4 6 8 60 2 4 6",
    ": 8 70 2 4-5 8-9 81 3 5 93 5 7 101 3 5 7 9 11 3 5 7 9 21 3 5 7 9 31 3 5 7 9 41",
    ": 3 5 7 9 51 3 5 7 9 61 3 5 7 9 71 3 5 7 9 81 3 5 7 9 91 3 5 7 9 201 3 5 7 9 11",
    ": 3 5 7 9 21 3 5 7 9 31 3 5 7 9 41 3 5 7 9 51 3 5 7 9 61 3 5 7 9 71 3 5 7 9 81",
    ": 3 5 7 9 91-2 4 6 8 300 2 4 6 8 10 2 4 6 8 20 2 4 6 8 30 2 4 6 8 40 2 4 6 8 50",
    ": 2 4 6 8 60 2 4 6 8 70 2 4 6 8 80 2 4 6 8 90 2 4 6 8 400 2 4 6 8 10 2 4 6-7 9",
    ": 21 3 5 7 9 31 3 5 7 9 41 3 5 7 9 51 3 5 7 9-60 2 4 6 8 70 2 4 6 8 80 2 4 6 8",
    ": 90 2 4 6 8 500 2 4 6 8-9 11 3 5 7 9 21 3 5 7 9-30 2 4 6 8 40 2 4 6 8-9 51 3 5",
    ": 7 9 61 3 5 7 9 71 3 5 7 9 81 3 5 7 9 91 3 5 7 9 601 3 5 7 9 11 3 5 7 9 21 3 5",
    ": 7 9 31 3 5 7-8 40 2 4 6 8 50 2 4 6 8 60 2 4 6 8 70 2 4 6 8 80 2 4 6 8 90 2 4",
    ": 6-7 9 701 3 5 7 9 11 3 5 7 9 21 3 5 7 9 31 3 5 7 9 41 3 5 7 9 51 3 5 7 9 61 3",
    ": 5 7 9 71-2 4 6 8 80 2 4 6 8 90 2 4 6 8 800 2 4 6 8 10 2 4 6 8 20 2 4 6 8 30",
    ": 2-3 5 7 9 42 4 6 8 50 2 4 6 8 60 2 4 6 8 70 2 4 6 8 80 2 4-5 7 9 91 3 5 7 9",
    ": 901 3-4 6 8 10 2 4 6 8 20 2 4 6 8 30 2 4 6 8 40 2 4-5 7 9 51 3 5 7 9 61 3 5 7",
    ": 9 71 3 5 7 9 81 3 5 7-8 90 2 4 6 8",
    ": 7000 2 4 6 8 10 2 4 6 8 20 2 4 6-7 9 31 3 5 7 9-40 2 4 6-7 9 51 3 6 8 60 2-3",
    ": 5 7 9 71 3 5 7 9 81 3 5 7-8 90 2 4 6 8 100 2 4 6 8 10 2 4 6 8 20 2 4-5 7 9 31",
    ": 3 5 7 9 41 3-4 6 8 50 2 4 6 8 60 2 4-5 7 9 71 3 5 7 9 81 3 5 7 9 91 3 5 7 9",
    ": 201 3 5 7 9 11 3 5 7 9-20 2 4 6 8 30 2 4 6 8 40 2 4 6 8 50 2 4 6 8 60 2-3 5 7",
    ": 9 71 3 5 7 9 81 3 5-6 8 90 2 4 6 8 300 2 4 6 8 10 2 4 6 8 20 2 4 6 8 30-1 3 5",
    ": 7 9 41 3 5 7 9 51 3-4 6 8 60 2 4 6-7 9 71 3 5-6 8-9 81 3 5-6 8 90 2 4 6 8 400",
    ": 2 4 6 8 10 2 4 6 8 20 2 4 6 8 30 2 4 6 8 40 2 4 6 8 50 2-3 5 7 9 61 3 5 7 9",
    ": 71 3 5 7 9 81 3 5 8 90 2 4 6 8 500 2 4 6 8 10 2 4 6 8 20 2 4 6 8 30 2 4 6 8",
    ": 40 2-3 5 7 9 51 3 5 7 9 61 3 5 7 9 71 3-4 6 8 80 2 4 6 8 90 2 4 6 8 600 2 4 6",
    ": 8 10 2 4 6 8 20 2 4 6-7 9 31 3 5 7 9 41 3 5 7 9 51 3 5 7 9 61-2 4 6 8 70 2 4",
    ": 6 8 80 2 4 6 8 90 2 4 6 8-9 701 3 5 7 9 11 3 5-6 8 20 2 4 6 8 30 2 4 6 8-9 41",
    ": 3 5 7 9 51 3-4 6 8 60 2 4 6 8 70 2-3 5 7 9 81 3 5-6 8 90 2 4 6 8 800 2-3 5 7",
    ": 9 11 3 5 7 9 21-2 4 7 9 31 3 5-6 8 40 2 4 6-7 9 51 3 5 7 9 61 3 5 7 9-70 2 4",
    ": 6 8 80 3 5-6 8 90 2 4 6 8 900 2 4 6-7 9 11 3 5 7 9 21 3 5-6 8 30 2 4 6 8 40-1",
    ": 3 5 7 9 51 3 5-6 8 60 2 4 6 8-9 71 3 5 7 9 81 3 5 7-8 90 2 4 6 8-9",
    ": 8001 3 5 7 9 11 3-4 6 8 20 2 4 6-7 9 31 3 5 7 9 41 3 5-6 8 50 2 4 6 8 60-1 3",
    ": 5 7 9 71-2 4 6 8 80-1 3 5 7-8 90 2 4 6 8 100 2-3 5 7 10 2 4 6 8 20 2-3 5 7 9",
    ": 31 3 5-6 8 40 2 4 6 8 50 2-3 5 7 9 61 3 5 7 9-70 2 4 6 8 80 2-3 5 7 9 91 3 5",
    ": 7 9-200 2 4 6 8 10 2-3 5 7 9 21 3-4 6 8 30 2 4 6 8 40 2 4-5 7 9 51 3 6 8 60-1",
    ": 3 5 7 9 71 3 5 7 9-80 2 4 6 8 90 2 4 6 8-9 301 3 5 7 9 11-2 4 6 8 20 2 4 6",
    ": 8-9 31 3 5 7 9 41 3-4 6 8 50 2 4 6 8 60-1 3 5 7 9 71 3 5 7 9 81-2 4 6 8 90",
    ": 2-3 5 7 9 401 3 9 11-2 4-5 7 9-21 3 5 7 9 31 3 5 7 9 41 3 5 7 9 51 3 5 7 9 61",
    ": 3 5 7 9-70 2 4 6 8 80 2 4 6 8 90 2-3 5 7 9 501 3 5 7 9 11 3 5 7 9 21 3 5 7-8",
    ": 30 2 4 6 8 40 2 4 6 8 50 2 4 6 8-9 61 3 5-6 8 70 2 4 6-7 9 81 3-5 7 9 91 3-5",
    ": 7 9 601 3 5-6 8 10 2 4 6 8 20-1 3 5 7 9 31-2 4 6 8 40 2 4 6 8 50 2 4 6 8 60",
    ": 2-3 5 7 9 71 3 5-6 8 80 2 4 6 8 90-1 3 5 7 9 701 3 5-6 8 10 2 4 6-7 9 21 3",
    ": 5-6 8 30 2 4 6-7 9 41 3 5 7 9-50 2 4 6 8 60-1 3 5 7-8 70 2 4-5 7-8 80 2 4 6 8",
    ": 90-1 3 5 7 9 801 3 5-7 9 11 3 5-6 8 20 2 4 6-7 9 31 3 5 7-8 40 2 4 6-7 9 51 3",
    ": 5 7 9 61 3-4 6 8 70-1 3 5 7 9 81-2 4 6-7 9 91 3 5 7-8 900 2 4 6 8-9 11 3 5 7",
    ": 9 21 3-4 6 8 30 2-3 5 7-8 40 2 4 6 8-9 51 3 5 7 9 61 3 5-6 8 70 2 4-5 7 9 81",
    ": 3 5-6 8-9 91 3 5 7-8",
    ": 9000 2 4 6-7 9 11 3-4 6 8 20 2 4 6 8 30-1 3 5 7 9-40 2 4 6 8 50 2-3 5 7 9 61",
    ": 3 5 7 9-70 2 4 6 8 80-1 3 5-6 8 90 2-3 5 7 9 101 3 5-6 8 10 2-3 5 7 9 21-2 4",
    ": 6 8 30 2 4 6 8-9 41 3 5 7 9-50 2 4 6 8 60 2 4 6-7 9 71 3 5-6 8 80 2 4 6-7",
    ": 9-91 3 5 7 9-200 2 4 6 8-9 11 3 5 7 9-20 2 4 6-7 9 31 3 5 7-8 40 2 4 6 8 50-1",
    ": 3 5 7-8 60 2 4-5 7 9 71 3 5 7 9 81 3-4 6 8 90 2 4 6-7 9 301 3 5-6 8 10 2-3 5",
    ": 7 9 21 3 5 7 9-30 2 4 6 8 40 2 4-5 7 9 51 3-4 6 8 60 2 4-5 7 9 71 3 5-6 8 80",
    ": 2 4 6-7 9 91 3 5 7-8 400 2 4 6 8 10-2 4 6-7 9 21 3 5 7-8 30 2 4 6 8 40 2-3 5",
    ": 7 9-50 2 4 6 8-9 61 3 5 7-8 70 2 4 6 8 80 2-3 5 7 9 91-2 4 6-7 9 501 3 5 7-8",
    ": 10 2 4 6 8 20 2-3 5 7 9 31-2 4 6 8 40 2 4 6 8-9 51 3 5 7 9 61 3 5-6 8 70 2",
    ": 4-5 7 9 81 3 5 7 9-90 2 4 6 8 600-1 3 5 7 9-10 2-3 5 7 9 21-2 4-5 7-8 30 2 4",
    ": 6 8-41 3 5-6 8 50 2 4 6 8 60-1 3 5 7-8 70 2 4 6-7 9 81 3-4 6 8 90 2 5-6 8 700",
    ": 2 4-5 7 9 11 3 5 7-8 20 2 4 6 8 30 2 4-5 7 9 41 3-4 6-7 9 51 3 5 7-8 60 2 4 6",
    ": 8 70 2-4 6-7 9 81 3 5 7 9 91 3 5-6 8 800 2 4-5 8-9 11 3 5 7 9 21 3-4 6 8 30 2",
    ": 4-5 7 9 41 3 5 7 9 51 3-4 6 8 60-1 3 5 7 9-70 2 4 6-7 9 81 3 5 7 9 91-2 4 6 8",
    ": 900 2 4 6 8-9 11 3-4 6-7 9 21 3 5 7 9 31-2 4-5 7 9 41 3 5 7 9-50 2 4 6 8-9 61",
    ": 3-4 6 8 70 2-3 5-6 8-9 81 3-4 6 8 90 2 4 6-7",
    ": 80000 2 4-5 7 9 11 3 5 7 9 21 3 5-6 8 30 2 4-5 7 9-40 2 4 6 8 50 2 4 6 8 60-1",
    ": 3 5 7 9 71 3-4 6 8 80 2 4 6 8-9 91 3 5 7 9 101 3-4 6 8 10 2 4-5 7 9 21 3 5 7",
    ": 9 31 3-4 6 8 40 2 4 6-7 9 51 3-4 6 8 60 2 4-5 7 9 71 3-4 6 8 80 2 4 6-7 9 91",
    ": 3-4 6 8 200-1 3 5 7 9 11-2 4 6 8-9 21 3 5-6 8 30 2 4 6-7 9 41 8 50 2-3 5 7 9",
    ": 61-2 4 6 8 70 2 4-5 7 9 81 3 5 7-8 90 2 4 6 8-9 301 3 5 7 9-10 2 4 6 8 20 2-3",
    ": 5 7 9 31 3 5-6 8 40 2 4 6 8 50 2 4-5 7 9 61 3 5 7-8 70 2 4 6 8 80-1 3 5 7 9",
    ": 91-2 4 6 8 400 2-3 5 7-8 10-1 3 5-6 8-9 21-2 4 6 8 30 2 4 6-7 9 41 3 5 7-8 50",
    ": 2 4 6 8 60-1 3 5 7 9 71-2 4 6-7 9 81 3 5 7 9 91 3 5 7 9-500 2 4 6 8 10 2 4 6",
    ": 8 20 2 4 6-7 9 31 3 5 7 9 41 3 5-6 8 50 2 4 6 8 60 2 4-5 7 9 71 3 5 7 9-80 2",
    ": 4 6 8-9 91 3 5 7 9 601-2 4 6 8 10 2 4-5 7 9 21-2 4 6 8 30 2-3 5 7 9 41 3 5",
    ": 7-8 50 2 4 6 8 60 2-3 5 7 9 71 3 5 7-8 80 2 4 6 8 90 2 4-5 7 9 701 3 5 7 9",
    ": 11-2 4 6 8 20 2 4-5 7 9 31 3 5 7-8 40 2 4 6 8 50 2-3 5 7 9 61 3 5-6 8 70 2 4",
    ": 6-7 9 81 3 5 7 9 91-2 4 6 8 800 2 4-5 7 9 11 3 5 7-8 20 2 4 6 8 30 2 4 6 8-9",
    ": 43 5 7 9 51 3 5-6 8 60 2 4 6 8-9 71 3 5 7 9 81 3 5-6 8 90 2 4 6 8 900-1 3 5 7",
    ": 9-10 2 4 6 8 20 2 4-5 7 9 31 3 5 7-8 40 2 4 6-7 9 51 3 5 7 9-60 2 4 6 8 70",
    ": 2-3 5 7 9 81 3-4 6 8 90 2 4 6 8",
    ": 1000 2-3 5 7-8 10-1 3 5 7 9 21-2 4 6 8-9 31 3 5 7 9 41 3 5-6 8 50 2 4 6-7 9",
    ": 61 3 5 7 9-70 2 4 6-7 9 81 3 5 7 9 91-2 4 6 8 100-1 3 5 7-8 10 2 4 6 8 20 2",
    ": 4-5 7 9 31 3 5 7-8 40 2 4 6 8 50-1 3 5 7 9 61 3-4 6 8 70 2 4 6 8-9 81 3 5 7 9",
    ": 91 3-4 6 8 200 2 4-5 7 9 11 3 5 7 9 21-2 4 6 8 30 2 4 6-7 9 41 3-4 6 8 50 2 4",
    ": 6 8-9 61 3 5 7-8 70 2 4 6 8-9 81 3 5 7-8 90 2 4 6 8-9 301 3 5 7 9 11 3-4 6 8",
    ": 20 2 4 6 8 30 2-3 5 7 9 41 3 5 7-8 50 2 4 6 8-9 61 3 5 7 9-70 2 4 6 8 80-1 3",
    ": 5 7 9 91 3 5 7-8 400 2 4-5 7 9-10 2 4 6 8-9 21 3 5 7 9 31 3 5 7 9-40 2 4 6",
    ": 8-9 51 3 5 7 9-60 2 4 6 8-9 71 3 5 7 9 81 3-4 6 8 90 2-3 5 7 9 501 3-4 6 8 10",
    ": 2 4 6 8-9 21 3 5 7 9 31 3-4 6 8 40-1 3 5 7 9 51 3 5 7-8 60 2 4 6-7 9 72 4 6",
    ": 8-9 81 3 5-6 8 90 2 4 6-7 9 601 3 5-6 8 10 2 4 6-7 9 21 3 5 7 9-30 2 4 6 8",
    ": 40-1 3 5 7 9 51-2 4 6 8 60 2-3 5 7 9-70 2 4 6 8-9 81 3 5 7 9 91 3 5-6 8 700 2",
    ": 4 6 8 10 2 4-5 7 9 21-2 4 6 8-9 31 3-4 6 8-9 41 3 5-6 8 50 2 4-5 7 9 61 3 5-6",
    ": 8 70 2 4 6 8-9 81 3 5 7 9 91 3 5-6 8 800 2 4 6 8-9 11 3 5 7 9-20 2 4 6 8 30-1",
    ": 3 7 9 41 3-4 6 8 50 2-3 5 7 9-60 2 4 6 8 70 2 4 6 8 80 2-3 5 7 9-90 2 4-5 7 9",
    ": 901-2 4-5 7 9 11-3 5-6 8-9 21 3-5 7 9-31 3-4 6 8-9 41-2 4 6-8 50 2-3 5 7-9 61",
    ": 3-6 8 70-1 3 5-7 9 81-2 4 6-8 90 2-3 5 7-8",
    ": 2000 2 4-6 8-9 11-2 4 6 8 20 2-3 5 7-9 31 3-4 6 8-9 41-3 5 7-8 50 2-3 5-6 8-9",
    ": 61 3-5 7 9-70 2-3 5-6 8 80-1 3 5 7-8 90 2-3 5-7 9 101-2 4-5 7 9 11-2 4-5 7-8",
    ": 20 2 4-5 7 9-30 2-3 5-6 8 40 2-3 5 7 9-50 2-3 5-6 8-9 61 3-4 6-7 9 71 3 5-6 8",
    ": 80-1 3 5-6 8 90 2-3 5 7-8 200 2-3 5-6 8-9 11 3 5-6 8 20-2 4 6 8 30 2-3 5 7-8",
    ": 40 2 4 6 8-9 51 61 3 5 7 9-70 2 4-5 7 9 81 3-4 6 8 90 2-3 5 7 9 301-2 4 6 8-9",
    ": 11 3 5 7 9-20 2 4 6 8-9 31 3 5 7 9-40 2 4 6 8 50 2 4 6 8 60-1 3 5 7 9-70 2 4",
    ": 6-7 9 81-2 4 6-7 9 91 3-4 6 8 400-1 3 5 7-8 10 2 4 6 8 20-1 3 5 7 9 31 3 5-6",
    ": 8 40 2 4 6-7 9 51 3 5-6 8 60 2 4 6-7 9 71 3 5 7 9 81-2 4 6 8 90 2-3 5 7 9 501",
    ": 3-4 6 8 10 2-3 5 7 9 21 3 5 7-8 30 2 4 6 8-9 41 3 5 7 9-50 2 4 6 8 60 2 4-5 7",
    ": 9 71-2 4 6 8 80 2 4-5 7 9 91 3 5-6 8 600 2 4-5 7 9 11 3 5-6 8 20 2 4-5 7 9 31",
    ": 3 5 7-8 40 2 4 6 8-9 51 3 5 7 9-60 2 4 6 8 70 2 4-5 7 9 81 3 5 7-8 90 2 4 6 8",
    ": 700-1 3 5 7 9 11-2 4 6 8 20 2-3 5 7 9 31 3-4 6 8 40 2-3 5 7 9 51 4 6 8 60 2 4",
    ": 6 8 70-1 3 5 7 9-80 2 4 6-7 9 91 3 5 7 9-800 2 4 6 8 10 2 4-5 7 9 21-2 4 6-7",
    ": 9 31 3 5-6 8 40 2 4 6-7 9 51 3 5 7 9-60 2 4 6 8 70 2-3 5 7 9 81 3 5 7-8 90 2",
    ": 4 6 8 900-1 3 5 7 9 11 3-4 6 8 20 2 4-5 7 9 31 3-4 6 8 40 2-3 5 7 9 51 3-4 6",
    ": 8 60 2-3 5 7 9 71 3-4 6 8 80 2-3 5 7 9 91 3 5-6 8",
    ": 3000 2 4-5 7 9 11 3-4 6 8 20 2-3 5 7 9 31 3 5-6 8 40 2 4 6 8-9 51 3 5 7-8 60",
    ": 2 4 8 70 2 4 6 8-9 81 3-4 6-7 9 91 3-4 6 8-9 101 3 5 7-8 10 2 4 6 8 20 2 4 6",
    ": 8 30 2 4 6 8-9 41 3 5 7 9 51 3 5 7-8 60 2 4 6 8-9 71 3 5 7-8 80 2 4 6 8 90 2",
    ": 4-5 7 9 201 3 6-7 9 11 3 5 7 9 21 3-4 6 8 30 2 4 6 8 40 2 4-5 7 9 51 3 5 7 9",
    ": 61-2 4 6 8 70-1 3 5 7-8 80 2 4 6 8-9 91 3 5 7 9 301 3-4 6 8 10 2 4-5 7 9 21 3",
    ": 5 7 9 31 3 5-6 8 40 2-3 5 7 9-50 2 4 6 8-9 61 3 5 7 9 71-2 4 6 8 80-1 3 5-6 8",
    ": 90 2 4-5 7 9-400 2 4-5 7-8 10 2 4 6-7 9 21 3 5-6 8 30-1 3 5 7-8 40 2 4 6 8",
    ": 50-1 3 5 7-8 60 2 4-5 7 9 71 3 5 7-8 80 2 4-5 7 9 91 3 5-6 8 500 2-3 5 7 9-10",
    ": 2 4 6-7 9 21 3 5-6 8 30 2-3 5 7 9 41-2 4 6 8 50 2-3 5 7 9-60 2 4 6 8-9 71 3 5",
    ": 7-8 80 2 4-5 7 9 91 3 5 7-8 600 2 4-5 7 9 11-2 4 6-7 9 21 3-4 6 8 30 2-3 5 7",
    ": 9 41-2 4 6 8-9 51 3 5 7-8 60 2 4-5 7 9 71-2 4 6 8 80 2 4-5 7 9 91 3 5-7 9 701",
    ": 3-4 6 8 10-1 3 5-6 8 20 2-3 5 7-8 30 2 4 6 8-9 41 3 5 8-9 51 3 5-6 8 60 2 4-5",
    ": 7 9 71-2 4 6 8 80-1 3 5 7 9-90 2 4 6-7 9 801 3 5-6 8 10 2-3 5 7 9-20 2 4 6-7",
    ": 9 31 3 5 7-8 40 2 4-5 7 9 51 3-4 6 8 60 2-3 5 7 9-70 2 4-5 7 9 81 3-4 6 8 90",
    ": 2-3 5 7 9 901-2 4 6 8-9 11 3 5 7-8 20 2 4 6-7 9 31 3 5 7-8 40 2-3 5 7-8 50 2",
    ": 4-5 7 9 61 3 5 7-8 70 2-3 5 7 9-80 2 4 6 8 90 2-3 5 7",
    ": 9-4000 2 4 6 8 10-1 3 5 7-8 20 2 4-5 7 9-30 2 4 6-7 9 41 3 5-6 8 50-1 3 5 7",
    ": 9-60 2 4 6-7 9-70 2 4 6 8-9 81 3 5-6 8 90 2 4 6 8 100-1 3 5 7-8 10 2 4 6-7 9",
    ": 21 3-4 6 8 30-1 3 5 7 9 41-2 4 6 8-9 51 3 5 7-8 60 2-3 5 7 9-70 2 4 6 8 80-1",
    ": 3 5 7 9-91 3-4 6 8 200 2-3 5 7 9-10 2-3 5 7 9 22 4-5 7 9 31 3-4 6 8 40-1 3 5",
    ": 7 9 51-2 4 6 8-9 61 3 5 7 9-70 3-4 6 8 80 2 4-5 7 9 91-2 4 6 8 300 2 4 6-7 9",
    ": 11 3 5-6 8 20 2 4 6 8-9 31 3 5-6 8 40 2 4 6-7 9 51 3 5 7 9 61 72-3 5 7 9 81",
    ": 3-4 6 8 90-1 3 5-6 8 400 2 4 6 8 10 2 4 6-7 9 21 3 5 7-8 30 2 4 6 8-9 41 3 5",
    ": 7 9-50 2 4 6 8 60-1 3 5 7 9 71 3 5-6 8 80 2 4 6 8-9 91 3 5 7 9-500 2 4 6 8 10",
    ": 2 4-5 7 9 21 3-4 6 8-9 31 3 5 7 9 41-2 4 6 8 50 2 4-5 7 9 61 3 5 7 9 71-2 4 6",
    ": 8 80-1 3 5 7 9 91-2 4 6 8 600 2 4 6 8-9 11 3 5 7 9 21 3-4 6 8 30 2 4 6 8 40 2",
    ": 4-5 7 9 51 3 5-6 8 60 2 4 6 8 70 2 4-5 7 9 81 3 5-6 8-9 91 3 5 7 9 701-2 4 6",
    ": 8 10-1 3 5 7 9 21 3-4 6 9 31 3 5 8-9 41 3 5 7 9 51 3-4 6 8 60 2 4-5 7 9 71 3",
    ": 5 7 9-80 2 4 6 8-9 91 3 5 7 9 801-2 4 6 8 10 2-3 5 7 9 21 3 5 7-8 30 2 4 6 8",
    ": 40 2-3 5 7 9 51 3 5 7-8 60 2 4 7-8 70-1 3 5 7 9-80 2 4 6 8 90-1 3 5 7 9 901 3",
    ": 5-6 8 10 2-3 5 7 9 21 3-4 6 8 30 2 4 6-7 9 41 3 5 7 9-50 2 4 6 8 60 2 4-5 7-8",
    ": 70-1 3-4 6 8 80 2 4 6-7 9 91 3 5-6 8",
    ": 5000 2 4 6-7 9 11 3 5 7 9-20 2 4 6 8 30-1 3 5 7 9-40 2 4 6 8 50 2 4 6 8 60 2",
    ": 4-5 7 9 71 3 5-6 8 80 2 4-5 7 9 91 3 5 7-8 100 2 4-5 7 9 11 3 5 7-8 20 2 4-5",
    ": 7 9-30 2 4 6 8 40 2 4 6 8-9 51 3 5 7 9 61-2 4 6 8 70-1 3 5 7 9 81-2 4 6 8 90",
    ": 2-3 5 7 9 201-2 4 6 8 10 2-3 5 7 20-1 3 5-6 8 30 2 4 6-7 9 41 3 5 7 9 51-2 4",
    ": 6 8 60 2 4-5 7 9 71 3 5 7 9 81 3-4 6 8 90 2 4-5 7 9 301 3 5-6 8 10 2 4 6 8-9",
    ": 21 3 5 7 9 31-2 4 6 8 40-1 3 5 7 9 51 3-4 6 8 60 2 4-5 7 9 71-2 4 6 8 80 2",
    ": 4-5 7 9 91-2 4 6 8 400 2 4-5 7 9 11 3-4 6 8 20 2 4-5 7 9 31 3 5-6 8 40 2 4",
    ": 6-7 9 51 3 5-6 8 60 2 4 6-7 9 71 3 5 7 9-80 2 4 6-7 9 92 4 6 8-9 501 3 5 7 9",
    ": 11-2 4 6 8 20-1 3 5 7 9-30 2 4 6 8-9 41 3 5-6 8 50-1 3 5 7 9-60 2 4 6 8-9 71",
    ": 3 5 7 9-80 2 4 6 8-9 91 3 5-6 8 600 2 4 6-7 9 11 3 5-6 8 20 2 4 6 8-9 31 3 5",
    ": 7 9-40 2 4 6 8 50 2-3 5 7 9 61-2 4 6 8 70 2-3 5 7 9 81 3 5-6 8 90 2 4-5 7 9",
    ": 701 3 5-6 8 10 2 4-5 7 9 21 3 5 7 9-30 2-3 5 7 9 41-2 4 6 8-9 51 3 5 7 9 61 3",
    ": 5 7 9-70 2 4 6-7 9 81 3-4 6 8 90 2 4-5 7 9 801 3 5-6 8 10 2 4-5 7 9 21 3-4 6",
    ": 8 30 2 4-5 7 9-40 2 4 6 8 50-1 3 5 7-8 60-1 3 5 7-8 70 2 4 6-7 9 81 3 5-6 8",
    ": 90 2 4 6 8-9 901 3 5 7-8 10 2 4 6 8 20-1 3 5 7 9 31 3 5-6 8 40-1 3 5 7 9 51",
    ": 3-4 6 8 60 2 4 6 8 70-1 3 5 7 9 81 3 5-6 8 90 2 4-5 7 9",
    ": 6001 3-4 6 8 10 2-3 5 7 9 21 3 5-6 8 30 2 4-5 7 9 41 3 5-6 8 50 2 4 6-7 9 61",
    ": 3 5-6 8 70-1 3 5 7 9-80 2 4 6-7 9 91 3 5 7-8 100 2 4 6 8-9 11 3 5 7 9-20 2 4",
    ": 6 8 30 2-3 5 7 9-40 2 4 6 8 50-1 3 5 7 9 61-2 4 6 8 70 2-3 5-6 8 80 2 4-5 7 9",
    ": 91-2 4 6 8 200-1 3 5-6 8 10 2-3 5-6 8 20-1 3-5 7 9-30 2 4 6-7 9 41 3-4 6 8 50",
    ": 2-3 5 7 9-60 2-3 5-6 8 70-1 3 5-6 8-9 82 4-5 7 9 91-2 4 6-7 9 301 3 5-6 8",
    ": 10-1 3-4 6-7 9 21-2 4-5 7 9 31-2 4 6 8-9 41 3 5-6 8-9 51 3 5-7 9 61 3-4 6 70",
    ": 2 4-5 7 9 81 3-4 6 8 90-1 3 5 7-8 400 2 4 6-7 9 11 3 5-6 8 20 2 4-6 8 30 2",
    ": 4-5 7-40 2-4 6-7 9 51-2 4-5 7-8 60 2 4-5 7 9 71-2 4 6 8 80 2 4 6-7 9 91 3-4 6",
    ": 8 500-1 3 5 7 9 11 3 5-6 8 20 2-3 5 7 9 31 3 5 7 9-40 2 4 6 8-9 51 3 5 7 9-60",
    ": 2 4 6 8 70-1 3 5 7 9 81 3-4 6 8 90 2-3 5 7 9 601 3-4 6 8 10 2 4-5 7 9-20 2 4",
    ": 6 8 30 2 4-5 7 9 41 3 5-6 8 50 2 4 6 8 60-1 3 5 7 9 71 3-4 6 8 80 2 4 6-7 9",
    ": 91 3 5-6 8 700 2 4 6-7 9 11 3 5-6 8 20 2 4 7-8 30 2 4 6 8-9 41 3 5 7 9 51 3",
    ": 5-6 8 60 2 4 6 8 70-1 3 5 7 9 81 3 5 7 9 91-2 4 6 8 800 2 4-5 7 9 11 3 5-6 8",
    ": 20 2 4 6-7 9 31 3 5 7 9 41 3 5 7-8 50 2 4 6 8 60-1 3 5 7 9 71 3-4 6 8 80 2-3",
    ": 5 7-8 90 2 4-5 7 9 901 3-4 6-7 9 11-2 4 6-7 9 21-2 4-5 7-8 30 2-3 5-6 8 40-1",
    ": 3-4 6 8-9 51 3 5 7-8 60-1 3-5 7-8 70 2 4 6-7 9 81-2 4 6 8-9 91 3 5 7-8",
    ": 7000 2-3 5 7-8 10 2 4 6-8 20-1 3 5 7-8 30 2 4 6-7 9 41 3 5-6 8 50 2 4 6 8-9",
    ": 61 3 5 7 9 71-2 4 6 8 80 2 4 6-7 9 91-2 4 6-7 9-100 2 4-5 7 9 11 3-4 6 8 20",
    ": 2-3 5 7 9-30 2-3 5 7 9-40 2 4-5 7 9 51 3 5-6 8-9 61 3 5 7 9-70 2 4-5 7 9 81 3",
    ": 5 7-8 90 2 4 6-7 9 201 3-4 6 21 3-4 6 8 30-1 3 5-6 8 40-1 3 5 7 9 51 3-4 6 8",
    ": 60 2-3 5 7 9-70 2 4-5 7 9 81-2 4-5 7 9-90 2 4-5 7 9 301-2 4 6 8-9 11-2 4 6",
    ": 8-9 21 3 5-6 30 2 4 6-7 9 41 3 5-6 8 50-1 3 5 7 9-60 2 4 6 8-9 71 3 5-6 8 80",
    ": 2 4-5 7 9 91 3-4 6 8 400-2 4 6-7 9 11-2 4-5 7-8 20 2-3 5-6 8 30-1 3 5-6 8-9",
    ": 41-2 4 6-7 9-50 2-3 5-6 8 60-1 3 5-6 8 70 2 4 6 8-9 81-5 7 9 91 3 5-6 8 500 2",
    ": 4 6 8-9 11 3 5-6 8 20 2 4-6 8-9 31 3 5 7-8 40 2 4-5 7 9 51 3-4 6 8-9 61 3 5",
    ": 7-8 70 2 4 6 8-9 81 3-5 7 9-90 2 4 6-8 600 2 4 6-7 9-10 2-3 5 7 9 21-2 4-5 7",
    ": 9-30 2 4 6-7 9-40 2 4 6-7 9-50 2 4 6-7 9 61-2 4 6-7 9 71 3-4 6 8 80-1 3 5 7-8",
    ": 90 2 4-5 7 9 701 3 5-6 8 10 2-3 5 7-8 20 2 4 6-7 9-30 2 4 6-7 9 41 3 5-6 8",
    ": 50-1 3 5 7-9 61-2 4 6-7 9 71 3-5 7-8 80-1 3 5-6 8 90-1 3-4 6 8 800-1 3 5 7-8",
    ": 10-1 3-4 6-7 9 21-2 4 6-7 9-30 2-3 5-6 8-9 41 3-4 6 8-9 51 3 5-6 8 60-1 3 5 7",
    ": 9-70 2 4 6 8-9 81 3 5-6 8 90 2 4-5 7 9-900 2 4 6 8-9 11 3 5-6 8 20 2 4 6 8 30",
    ": 2 4 6-7 9 41 3 5-6 8 50 2 4-5 7 9 61 3 5 7 9-70 2 4-5 7 9 81 3 5 7 9 91-2 4 6",
    ": 8-9",
    ": 8001 3 5 7 9 11 3 5 7 9-20 2 4 6 8-9 31-2 4 6 8 40 2 4 6 8 50-1 3 5-6 8 60 2",
    ": 4 6-7 9 71-2 4 6 8 80-1 3 5 7 9-90 2 5-6 8 100 2 4 6-7 9 11 3 5 7 9-20 2 4 6",
    ": 8 30-1 3 5 7-8 40 2 4-5 7 9 51 3 5 7 9 61 3-4 6 8 70 2 4-5 7 9-80 2 4 6 8 90",
    ": 2 4 6-7 9 201 3 5 7 9 11 3 5 8-9 21 3 5 7 9-30 2 4 6 8-9 41 3 5 7 9-50 2 4",
    ": 6-7 9 61 3 5 7 9 71-2 4 6 8 80-1 3 5 7 9 91 3 5 7-8 300 2 4 6 8 10 2 4 6 8",
    ": 20-1 3 5 7-8 30 2 4 6-7 9 41 3 5 7 9-50 2 4 6 8 60 2 4-5 7 9 71 3 5 7-8 80 2",
    ": 4-5 7 9 91 3 5 7-8 400 2 4 6 8-9 11 3 5 7 9-20 2 4 6 8 30 2-3 5 7 9-40 2 4 6",
    ": 8 50 2 4 6-7 9 61 3 5 7 9-70 2 4-5 7 9 81 3 5 7 9 91 3 5-6 8 500 2 4 6 8-9 11",
    ": 3 5 7 9 21 3 5 7-8 30 2 4 6-7 9 41 3 5-6 8 50 2 4 6 8 60 2 4 6-7 9 71 3 5 7",
    ": 9-80 2 4 6 8 90 2 4 6 8-9 602-3 5 7 9 11 3 5 7 9 21 3 5 7-8 30 2 4 6 8 40-1",
    ": 4-5 7 9 51 3 5 7 9 61-2 4 6 8 70 2 4 6 8-9 81 3-4 6 8 90 2 4-5 7 9 701 3 5-6",
    ": 8 10 2 4 6 8 20-1 3 5 7-8 30 2 4 6 8-9 41 3 5 7-8 50 2 4 6 8-9 61 3 5 7-8 70",
    ": 2 4 6 8 80 2-3 5 7 9 91-2 4 6 8 800 2 4 6 8-9 11 3 5 7 9-20 2 4 6 8 30 2 4-5",
    ": 7 9 41 3 5 7-8 50 2 4 6 8 61-2 4 6 8 70-1 3 5 7 9 82-3 5 7 9-90 2 4 6 8 900",
    ": 2-3 5 7 9 11-2 4 6 8 20-1 3 5 7 9 31 3 5-6 8 40 2 4 6 8 50-1 3 5 7-8 60 2-3 5",
    ": 7-8 70 2-3 5 7 9 81 3-4 6 8 90-1 3 5 7-8",
    ": 9000 2 4 6-7 9 11-2 4 6 8 20 2-3 5 7 9 31 3-4 6 8 40 2 4-5 7 9 51 3 5 7-8 60",
    ": 2-3 5 7 9 71 3 5 7 9 81 3 5 7-8 90 2 4 6-7 9 101 3 5-6 8 10 2 5 7 9-20 2 4",
    ": 6-7 9 31 3 5 7 9-40 2 4-5 7 9 51 3 5 7-8 60 2 4 6 8-9 71 3 5 7 9 81 3-4 6 8",
    ": 90 2 4 6-7 9 201 3 5-6 8 10 2 4 6-7 9 21 3-4 6 8 30 2 4 6-7 9 41 3 5 7-8 50 2",
    ": 4 6 8 60 2-3 5 7 9-70 2 4 6 8-9 81 3 5-6 8 90 2-3 5 7 9 301 3 5 7 9 11-2 4 6",
    ": 8 20 2-3 5 7 9 31 3-4 6 8-9 41 3 5-6 8 50 2-3 5 7 9 61 3 5-6 8-9 71 3 5 7",
    ": 9-80 2 4 6 8 90 2 4 6-7 9 401 3 5-6 8 10 2 4 6 8 20 2-3 5 7 9-30 2-3 5 7-9 41",
    ": 3-4 6 8-9 51 3 5 7 9 61 3 5 7-8 70 2 4 6 8 80 2-3 5 7 9 91 3 5-6 8 500 2 4 6",
    ": 8-9 11 3-4 6 8 20 2-3 5 7 9 32-3 5 7 9-40 2 4 6 8 50 2-3 5 7 9 61 3 5-6 8 70",
    ": 2 4 6-7 9 81 3 5 7 9 91-2 4 6 8 600 2 4 6 8 10 2 4 6-7 9 21 3 5-6 8 30 2 4 6",
    ": 8-9 41 3 5-6 8 50 2 4-5 7 9 61 3 5-6 8 70 2 4 6 8 80 2-3 5 7 9 91 3-4 6 8 700",
    ": 2 4-5 7 9-10 2 4 6 8-9 21 3 5-6 8 30-1 3 5 7 9-40 2 4 6-7 9 51 3 5 7 9-60 2 4",
    ": 6-7 9 71 3 5 7 9-80 2 4 6 8 90-1 3 5 7 9 801-2 4 6 8 10 2-3 5 7-8 20 2 4 6 8",
    ": 30-1 3 5 7 9 41 3 5 7-8 50 2 4-5 7 9 61-2 4-5 7 9 71 3-4 6 8 80 2 4-5 7 9 91",
    ": 3 5 7 9-900 3-4 6 8 10 2-3 5 7 9 21 3 5 7 9-30 2-3 5 7 9 41 3 5-6 8 50 2 4 6",
    ": 8-9 61 3 5-6 8 70 2 4 6 8 80 2 4-5 7 9 91 3-4 6 8",
    ": 90000 2 4-5 7 9 11 3 5 7-8 20 2 4-5 7 9 31-2 4 6 8-9 41 3 5 7 9-50 2 4 6 8-9",
    ": 61 3 5-6 8 70 2 4-5 7 9 81 3 5 7-8 90 2 4-5 7 9 101 3 5 7 9 11-2 4 6 8-9 21 3",
    ": 5 7 9-30 2 4-5 7 9 41 3 5 7-8 50 2 4 6-7 9 61 3 5 7 9 71-2 4-5 7 9 81 3 5-6 8",
    ": 90 2 4 6-7 9 201 3 5-6 8 10 2 4 6 8 20 2-3 5 7 9 31-2 4 6 8 40-1 3 5 7-8 50 2",
    ": 4 6 8 60 2 4 6-7 9 71 3 5 7 9 81-2 4 6 8 90 2 4 6 8-9 301 3 5-6 8 10-1 3 5 7",
    ": 9-20 2 4 6 8-9 31 3 5 7 9 41-2 4 6 8 50 2 4 6 8-9 61 3 5-6 70 2 4 6 8 80 4-5",
    ": 91 6-7 9 401 4",
    "special  CBK25604           embl_tpa_prot",
    "special2 CBL+5 embl_tpa_prot",
    ": 43266-309 11-52 4-94 51956 79138 80808-9",
    "special  CBM43246           embl_tpa_prot",
    "special2 CBN+5 embl_tpa_prot",
    ": 66325 9342 9",
    "special  CBV36767-CBV36776  embl_tpa_prot",
    "special2 CBX+5 embl_tpa_prot",
    ": 19677-9 727-8 24371-3",
    "special2 CBY+5 embl_tpa_prot",
    ": 65974-6037 83944",
    "special2 CBZ+5 embl_tpa_prot",
    ": 41152-6 9-60 2 5 8 768",
    "special  CCB84813           embl_tpa_prot",
    "special  CCC21095-CCC21104  embl_tpa_prot",
    "special  CCD22089-CCD22162  embl_tpa_prot",
    "special  CCE69367-CCE71257  embl_tpa_prot",
    "special  CCH35981-CCH35984  embl_tpa_prot",
    "special  CCP37863-CCP38020  embl_tpa_prot",
    "special  CCQ18550           embl_tpa_prot",
    "special2 CDG+5 embl_tpa_prot",
    ": 31911-2165 58552 80630-2 6183-301",
    "special2 CDI+5 embl_tpa_prot",
    ": 30255-40096 70255-87 965-7",
    "special2 CDK+5 embl_tpa_prot",
    ": 02602-8087 9-12444",
    "special  CDM98735-CDM98850  embl_tpa_prot",
    "special  CDW51382-CDW51481  embl_tpa_prot",
    "special2 CEL+5 embl_tpa_prot",
    ": 64082-71605 7-3228 30-66 8-4800 2-5130 2-550 2-6203 5-766 8-7188",
    ": 90-8176 8-353 5-878",
    "special  CEO43666-CEO43667  embl_tpa_prot",
    "special  CRI06393-CRI06404  embl_tpa_prot",
    "special  CRK77046           embl_tpa_prot",
    "special  CTQ86077-CTQ86287  embl_tpa_prot",
    "special2 CUQ+5 embl_tpa_prot",
    ": 99285-92 4-311 3-9 21-50 2-86",
    "special2 CUS+5 embl_tpa_prot",
    ": 27851-62 58523-613",
    "",
    "special2 SAI+5 embl_tpa_prot",
    ": 82130-8 41 4-5 7-9 51-65 8-80 2-6 8-98 201-10 2-22 4-5 7-35 7-42 4-55 7-82",
    ": 4-5 7 9 92 4-6 8-303",
    "special2 SAQ+5 embl_tpa_prot",
    ": 69746-66 71209",
    "special  SCC98881-SCC98885  embl_tpa_prot",
    "special  SFW93197-SFW93317  embl_tpa_prot",
    "special  SNU76807-SNU78093  embl_tpa_prot",
    "special  SOR70182-SOR70392  embl_tpa_prot",
    "",
    "special  VDK10822-VDK11088  embl_tpa_prot",
    "special  VDM91303-VDM91304  embl_tpa_prot",
    "special2 VZP+5 embl_tpa_prot",
    ": 20049-110 2-320",
    "special2 VZQ+5 embl_tpa_prot",
    ": 70899-905 7 10-3 5-7 9-23 5 7-9 31-6 8-9 41 3 6-9 51-5 7 9-61 4-5 7 9-89 93",
    ": 6-9",
    "",
    "special2 CAA+7 embl_tpa_prot",
    ": 9999660 77-8 83 7-8 93 5-7 706 8 12-3 8 22-3 5 36-8 41-2 7-9 54-5 63 82 5 93",
    ": 5 9 804-5 8-9 14 7-8 21 3-4 8 33-4 42 8 51-2 8 70 5 7 9 94 906-8 10 5 21-2 7",
    ": 31 7-9 42 4-6 9 51 4 8 63-5 70-1 6 8-9 82 90-3 8-9",
    "special2 CAB+7 embl_tpa_prot",
    ": 0000001 5 10 3-4 20-1 5 31-4 6-7 42 5-6 8-9 52 6-8 60 4 9 73-5 7-8 80 2-8 90",
    ": 2-6 8-9 101-7 9-13 5 7 9-21 4-30 2 4 7 9-44 6-9 51 3-4 7-9 61 3-77 9-81 3-7 9",
    ": 91-2 4-6 8 200-3 5-6 8 10-1 3-5 7-30 2-5 7-49 51-4 7-60 3-4 6-71 3-7 9-80 2",
    ": 4-5 7-8 90-3 5-6 300-1 3-5 7-9 11-6 8 20-2 5-44 7-51 3-4 6-60 2-4 7 71 3-4",
    ": 6-8 80-4 6 8-91 4 7-9 401 3-6 8-15 7-8 21 4 6-8 30-2 4-8 40-2 4-6 9 51-6 9",
    ": 62-3 5-7 9-71 3-82 5-7 9-91 5-9 501-2 5 7-8 10-1 3-7 9-21 3-4 7-9 31-5 7-8",
    ": 40-5 7-8 50 2-3 5-61 3-5 7-9 71-6 8-80",
    "special2 CAD+7 embl_tpa_tsa_prot",
    ": 9653957 60-2 5-6 8-9 71-5 82 4-7 90-2 5-9",
    ": 4001-11 5 9-26 8-40 2-3 5-6 8-9 51-3 7-60 2-7 75-8 80 2-5 7 90-3 5 9-102 4-9",
    ": 11 7-8 21 5 7-31 4-6 8 42-7 50-4 7-8 60-1 6 70-7 81-7 95 7 9-200 6 9 13 5 7",
    ": 23 5 9 40-2 56 8 60 3-4 70 4 80 2 4 90 4 6-7 301 4-5 15 24-6 32 4-5 9 45 8 54",
    ": 7 60-1 3 5 9 76 8-9 82 93 401 7-8",
    ": 863139 53 96 207 10 2 6 27 34 9 46 9 51 3 7 60 5 8 70 5 9 89 92 4 6 300 3 6",
    ": 8-9 11 27 9 46 8 54-6 9 68 73 9 84 7 9 93 7 400 2 7 9 11 6 8 21 3-4 38 40 3 6",
    ": 9 52 6 63 76 84 92 505 7 12 7 9 21 4 8 30 4 44 6 54 8 61 3 5 7 9 74-5 7 80 2",
    ": 5 7 91 5 600 8 14-5 7 21 7 9 34 7 40 2 4-5 7 50 60 5 70 2 7 85 7 90 4 7 700",
    ": 24 6 8 30 2 6 9 42-3 8 51 3 5 7 9 61 3 9-70 2 4 7 80-1 5 92-3 5 9 802 6 14 6",
    ": 21-2 31 5 7 43 5 51 4-5 8 61 3 5 7-8 73-5 9 81 4 6-7 96 903 5-6 8-9 12 4 8 22",
    ": 31-2 6 40 5 9 51 9 62 6 80 90 5 8",
    ": 4000 6 17 9-20 3 7 9 35 7 40 2 4 6 9 51 7 9 63 77 9 81-2 5 8 90 9 113 5 8",
    ": 20-1 4 9 31 4 8 40 2 4 6 8-51 4-5 7 9 61 3 5 7 74-5 8 82 91 3 5 9 204 6 24-5",
    ": 33 5 8 40 2 5 9 55 8 61 5 7 75 8 81 3 5 7 92 9 313-4 6 8 24 6 8-9 31 3 5 7 43",
    ": 8 50 2 4 62-3 8 71 3 6 8 80 3 7 97 9 401 3 9-10 4 6 8 20 2 4 6 8 30 2 4 41 3",
    ": 5 9 51 3 7 9 61 3 5-9 77 83 90 3 9 506 9 17 23 5 7 9 32 7 46 8 51 60 5 71 5-6",
    ": 8 80 3 5 90 2-3 6 8-9 602-3 5 7 9-11 4 7-8 20 6 32 4-5 8 40 2 6 8 50 2 4 7-8",
    ": 60 4 6 8 72 5 7 81 9 94 6 701 5 8 13 9 24 33 7 44 6 55-6 61 4 6 9 73 5 7 80 2",
    ": 6 96 9 801 11 7-21 6 46 56 8 61 5 7 70-1 3 5 7-8 80 8 91 3 5 7 902 4 7 9-10",
    ": 22 31 3-6 9 41 4 9 51 3 5 7 9-60 3 5-6 9 75 81 7 9 91 3 5 7 9",
    ": 5001 4 11 3 5 8 21 4 30 2 40 9 52-3 9 62 4 6 9 71 6 8 80 2-3 5 7 9 93 5 8 119",
    ": 27 31 5 7 42 9 51 4-6 61 8 73 5 7 82 4 93-4 9 201 3 11 5 7 20 2 6 8 30 40 4 6",
    ": 50 2-3 7 62-3 7-71 5-6 88 90 5 7 9 303-4 14 25 30 2-3 6 8 40 3 5-6 9 53 61-2",
    ": 6 8 71 3-4 6 8 83 6 8 91 6 9 401 10 3 8 20 2 5 30-1 9 41 3 6 50-1 3 6 63 6 9",
    ": 76 8 83 5 501 3 7 9 11 3 8 20 6 9 31-2 4 6 8 40 3-4 6 8 56 61-2 4-5 7 70 7 80",
    ": 2 4 91 7 600 3 7 11 4 6 9 21-2 4 8 30 2 42 5 51-2 4 8 60 2 4 81-2 4 8 91 5 7",
    ": 707 9 12-3 7 9 22 6-7 30 4 7 42 8-9 51 4 6 8 60 2 8 71-2 4 81 4 6 9 96 8 801",
    ": 3 9 11 5 21 3 6 8 30 3-4 6-7 9 41 5 53 5 8 60 2 74 7 80 9 92 6 900 2 4-5 7 9",
    ": 12-3 5 7 9 21 3 5 8 32 4 7 42 5 7 53-4 8 60 2-3 6 71-2 5 7 81 6 8 90 2 4 6-7",
    ": 9-6000 4 9 11 5 9 24 7 37 9 41 5 7 9 55 7 9 64 7 9 72 5 83-4 6 8 91 3 7 9 102",
    ": 4 6 8 13 21 7 9 31 3 5 7-9 41 3-5 7 9-50 2 4 61 3-4 72 4 8 82 7 92 201 5 8 10",
    ": 2 5 7-8 20 2 4 7 30-1 3-4 40 6 9 51 4-5 8 62 8 70 7 9 88-9 92 4 6-7 9 301 3-4",
    ": 13 5 7-8 20-2 6 9 31 3-4 8 40 2 5 7 51 3 7 9 62 4 6 9 74 83 5-6 8 92 4 6 400",
    ": 4-5 11 3 5 7 22 5 8 31 4 42 7 50 2 4 6 62 4-5 7 9 86 9 91 4 6 500 3 6 18 25",
    ": 30 2 4 6 8-40 4 6 8 54 6 60 2 4 6 8 71 3 6 83 97 9 604 7 9 11 4 6 8 20 2 9",
    ": 31-2 6 41-2 4-5 9 61 3 7 9 71-2 4 9-80 5 7 9 93 5 7 9 701 6 8 13 5 8 20 2-3 7",
    ": 30 2 6 9 41 3 7 9 51 3 8 60 4 6 71 3 6 80 3-4 6-8 90 3 6 9 802-3 5 7-8 10 2 4",
    ": 6 9 22 31 3 6 8 40 2 4 50 2 4 6 9 63 5 8 70 3 5 7 9 83 7 9 91 3 7 9 902 4-6 8",
    ": 12 7 20 30 3 7 40 2-3 6 8-9 51 4 6 60 3 5 7 9-70 2-3 7 81 4 8 94",
    ": 7003 5 7 11-2 4 6-7 21 3 5 7 30 3 5 42 5 7 51 60 2 4 70 6 8 80 4 6 90 2 4 8",
    ": 100 6 10 4 6 24 7 30 2 8 40-1 3 6 8 52 5 7-8 63-4 8 70-1 3 5-6 81 3 7 9 96 9",
    ": 201 3 6 8 13 5 20 2 4 7 9 33 5 7 9-40 3 8 50 2 6 60 2 4 70 2 4 6 9 82 6 90",
    ": 2-3 6-7 9 301 6 8-10 7 20 2 6 9 35 7 40 2 8 52 5-7 61-2 4-5 7 9 71-2 6 8 80 4",
    ": 8 91 4 6 9 406 8-9 13-4 21 7 31 4 8 46 8 50 5 9 63 5 8 72-3 5 7 80-1 3 5 7 92",
    ": 7-8 513 5 7 9 21 3 5 8 31 3-4 7 44 8 50 3 7 9 62-3 5 8-9 73 5 7 9-80 4 6 92-6",
    ": 8-9 603 9 11-2 4 9 21 3 5 7 32 9-40 2 4 50 2 8 60 6 8 71 4 7 91 4 8 700 2 4 6",
    ": 8 11 5-7 23 6 8 31 3 8 40 2-3 5 8 54 6 9 61 3 7 70 5-6 8 84 6 92-3 8 800 2 4",
    ": 7 9 11 3-4 8 20 6-7 9 31 7 9 42 4-5 8-9 52-3 6 9-60 3 5 9 71 3 9 82 4 6 9-90",
    ": 5 7 903 13-4 8 21 3 8-9 32 7 41 7 9 51 3 5 7 66 8 72 7 80 3 5 7 91 3-4 6 8",
    ": 8000 3 8 12 4-5 8 24-5 8 31 4 6 8 42 4 7 52 4-5 8 63 5 7 9-70 2 5 7 86 9 94",
    ": 7-8 100 6 8-9 11 4 9-20 3-5 7 30-2 4 8 40 2-3 5 50 2 8 60 4 6 8-9 74 7 9 82 7",
    ": 9 91 3 5 7 9 202 4 6 9 14 8 20 3 5 8 30 2 5 8 41 3 9 51 3 60 4 70 6 82 5 91 3",
    ": 5 300 2 4 6 15 21 7 36 8 40 51 9 64 6 9 71 5 8 85 9 91 8-9 401 4-5 7 14 6 8",
    ": 21 5 38 42 4 6 8 50 2-4 8 60-1 3 5 7 71 4 8 85-6 8-9 92-3 5 7 500 3 5 7 9-10",
    ": 2 21 3 30 4 6 8 42 9 51 3 6 8 60 2 7 70 2 4-5 82 4 6 90 5 7-8 600 4 13 7 9 21",
    ": 3 5 7 9-30 2 4 6 9 41 4 6 53 5 9 61 3 8 70 4 8 80 8 97 9 703 5 7-8 10-1 3-4 6",
    ": 9 28 30 2 4 6 8-9 41 6 53-4 61-2 6 70 2 4 9 81 3 5 7 96 801 5 10-1 3 8 20-1 4",
    ": 6 8-9 35-8 44 6 50 2-3 5 7 9 61 5-6 71 3 5 7 85 93 7 903 5 8 10 3-4 6 8 20 2",
    ": 4 8-34 9 41 6 8 52 4 6 9 67-8 70 2 4 6 8 81-2 5 91 3 5 7",
    ": 9000 4 8 10-3 5 8 25 7 33 5 7 9 44 9-50 2 4-5 7-8 64 6 8 72 5 9 82 6 92 6 101",
    ": 3 5 12 8 21 8 33 6-8 41 3 5 8 50 4 6 60 2 5 7 71-2 6 8 80 3 7-8 92 204 16 9",
    ": 21 3 5 7-8 30 3 5 7 9 43 7 52 4 62 4 7 72-3 8 81 7 9 94 6 301-2 5 12 4-5 7 20",
    ": 3 5 7 9 34 8 41 3-4 7 50 2 4 7 61 3 5 8 74 8 82 6 8 92 4 6 9 402-4 7 9-13 6",
    ": 24 9 31 3 7-8 43 5 7 9 52 4 7-8 60 70 8 81 6 90 7 501 3 6 13-4 8 20 33 5 44",
    ": 52 61 5-6 71 3 5 83 6 92 6 601 4 6 14 20-1 6 8 32 4 8 41 5 9 51 4 6 8 61 6 8",
    ": 71 3 5 8 81 3 5 7 9 91 5 7 9 701 3 5 9 11 4-5 7 20 7 30 7 9 41 3 7 9 53 5-7 9",
    ": 61 6 72 8-9 86 91 3 5-6 8 801 3 5 7 10 4 9 22 4 6-7 9 31 3 7-8 41 6 8-9 51-2",
    ": 4 8 60 2 4 6 8 70 4 9 81 6 8 94 6 8 902 7 10 2 5 9 21 4 32-3 6 44 6 8 50 3 8",
    ": 61 5 7 70 2 4 6 8 80 2 4 7 91 3 5 7",
    ": 70001 5 7 10-1 3 5 23 9-30 2 4 41 5 9 51 4 6 8 63 6 9 71 5 7 9 81 3-4 6 9 94",
    ": 120 2 5 7 38 40 2 4 51-2 5 8 60 2-3 7 9 72 4 6 8 81-3 5 7-8 91 3 8 201 6 8 10",
    ": 2 6 8 20 3 6 9 35-8 40 2 6-7 52 4 9 61 3 8 70 2 4 6 8 82 4 6 9 91 3 6 8 304 6",
    ": 8 11 3 7 9 21 3 6 8-9 32 7 9-40 2 4 6 50 2 4 69 71 6 81 7 9 91 5-8 402 6 8 10",
    ": 7-8 20 2 4 6 9-30 2 4 6 40 3 50 2 4-6 66 8 72 4 6 9-80 3 7 91-2 4 503 9 12",
    ": 5-8 20 4 9 31 3 5 9 42-3 6-8 52 4 7 9 62 72 4-5 7 9 81 6 8 93 5-6 8 602 10 7",
    ": 21 3 32 4-9 43 7 54 7 9 61 4 6 9-70 2 7 9 81 6 8 90-2 4 6 8 705 8 10-1 7 24 7",
    ": 9 35 7 40 2 9 52 4 6 8 60 6 9 71 6-7 80 4 91 3 5 8 800 3 5-6 11 3 5 22 9 33 6",
    ": 41 3 5-7 9-50 3 8 61 3 9 71 3 84 6 90 2 4 6 900 4 6 9 11 20 2 4 7 9 31 5 8 48",
    ": 50 3 6 8 61 7 9 73 5 8-9 84 7 97 9",
    ": 1001 3 10-2 4 7-8 20 6 30 2 4 6 8 40 2-3 51-2 5 7 9 61 4 6 8 70 2-3 5 7 9 82",
    ": 4 6 8 94-6 9 104 8 11-2 6-7 20 2 6 8 32 4 6 8 40 2-3 6 8 51-2 4 60 2-3 5 7-8",
    ": 74 6 80 4 6 90 2-3 206 8 11 4 7 9 21 4 8 31 4 7 48 50 9 66-7 72 4 7 81 6 8 93",
    ": 5 9-300 7 9 12-3 6 21 3 5 7 9 31 4 6-7 9 43 5 7 9 51 4 6-7 64 73 5 85 7 91 3",
    ": 9 401 6 8 13 5 7-8 24 6 34 7 40 2 4-5 8 50 3 6 8 62 6 70 5 7 81 3 5 7 9 91 3",
    ": 5 7 500 2-3 8 11 4 6 8 20 4 6 9 31 4-5 7 9 41-2 4 6-7 9 52 4-5 63 9 72 7 85 8",
    ": 98 600 6-7 14 21 3 5 7 30 2 7 9 49 52 4 7-8 61 9 74 6 8 80-1 3 6 90 3 5 8 702",
    ": 4-5 8 10 2 5-7 21 4-5 8 35 8 44 6 9 51 3 6 9-61 3 5 7 9 71-3 5 8 81 3 5-6 9",
    ": 802-3 6 9 11 6-7 20 2 9 31-2 8 42 8-9 52-3 5 9 67 9 77-8 80-1 3 7 94 8 900",
    ": 2-3 7 9-10 6-7 20-1 3-4 7-8 30 2 6 42 4 53 61 3 77 83 6 90 2 4 6 8",
    ": 2000 2 7-10 2 7-8 20 5 7 33 5 9-40 2-3 7 53 9 63 5 7 70 88 90 4 6 9 101 13 8",
    ": 22-3 5-7 9-30 5 7 9 41 51 3 5 7 60 5-6 70 4 6 82 5 7 9 91 204 7-8 10 3 5 7 9",
    ": 21 4 8-30 2 6 40-1 4 6 56 61 7 76 82 8 92 8 301 3 5 7-8 10-1 5 9 21 38 41 3",
    ": 51 3-4 6 60 2 4 9-70 4 6 8 80 5 8 90 3 5 8 401 4 8 11 4 6 8 20-1 4 7 30 3-5 9",
    ": 41-2 6 9 51 3 5 8 66 9 72 4-5 9 84 6 8 90 2 6 9 502 4-5 10 9 21 8 31 6-7 9",
    ": 41-3 5 7 52-3 5 7 67 72 7 9 81 4 6 8 94 9-600 2-5 8 10 2 4 7 24 6 32 5 41 7 9",
    ": 53 5 8 60 5 74 6 8 82 4 7 9 93 700 7 9 11 7 22 9 31 5-8 40 2 4 54 69 71 3 5 7",
    ": 9 81 3 5 8 90 3 5 7 802 7 15 8-9 21 3 5 8 30 5-6 46 50 4 6 9 73 5 7 85 92 4-5",
    ": 7 9 906 8 10 2-3 5 20 4 8 31 8 46 8 51 7 9 61 3 6-7 9 82 5 90 4 6 9",
    ": 3001 9 11 33 6 8 45 50 2 4 6 8 62 72 7-8 80 2 4 91 4 8 102 4-5 10 4 20-2 7 31",
    ": 3 5 7 53 8 60 4 70 2 4 6 9 81 6 8 90 3 202 9 11 3 26-7 9 31 3 42-3 9 55 8 76",
    ": 81 4 300 2-3 5 15 20 2-3 5 7 9-30 2 4 7 9 46 50-1 6 60 2 4 9 73 8 80 3 5 91 5",
    ": 7 408 13 6-7 9 21 3 5 9 35 7 9 41 5-6 50 5 68 72 9 81 7 90 8 505 7 9 16 8 27",
    ": 9 35 8 41 3 6-7 9 63 7 73 5 80 5 7 9 91 7 9 601 10 9 21 3 6 9 32 4 9 43 5 9",
    ": 51-4 7 60 2 5 71 3 5 9 81 3 5 7 94 7 700 2 5 8 14 7 20 3 6 9 31 3 44 6 9-50 2",
    ": 5-6 8-9 64 70 2 4 6 9-80 3 6-7 98-800 2 4-5 9 11 3 5 7-8 22 4 8-9 31-2 5 7 40",
    ": 2 4 7 52 4 6 8 61 6 9 71 3 5-6 8-9 82 4 6 91 3 9 901 3-4 6 12 5 9 21 3 5 33",
    ": 46-7 9 51 3 5 9 62 8 70 6 81 4 9 93 5 7 9",
    ": 4001 6-7 9 11 6 20 3 5 30 5 7 40-1 3 5 7 9-50 3 5 7 9 61 3 5 7 9 76-7 9-80 2",
    ": 4 7 92 113 6 20 6 32 4 6 8 40 2 4 6 8 53 5 7 63 74 6 9 85 90 2 4 6 202-3 13",
    ": 5-6 8 24 6 9 31 3 7 9 42 5 50 2 4 9 63 70 2 4 6 80 4 9 95 7 9 303 15 8 22 4",
    ": 33 6 8 45 59-60 3 6 72 4 8 80 5 90 2 7 402-3 5 8 12-4 6 9 25 7 33 8 40 2 6 50",
    ": 2 61 3 70 5 9 81 3 6 92-3 5 7 9 504 11 3 5 9 21 7 9-30 3 5-6 8-9 43 6 9 51-2",
    ": 8-9 62 5 7 9 75 81 3 5 90 4 6 8 620 7 31 4 6 46 8 51-2 4-5 7 9 64 6 8 70-1 7",
    ": 9 81 6-7 9 94 7 709 11 3 5 9 21 4 6-7 9-30 3 7 9 44 6 9-50 2 4 8 61 3 5 70",
    ": 2-3 6-80 3 6 90 5 7 9 801 4 6 10-1 4 20 4 6 9 33 5 9 41 6 50 4-5 8 60-1 5 7",
    ": 70-1 3 5 8-9 81 9 92 7 901-2 4 12 4 8 20 2 7 34 41 50 2 4 7 9 62 6 70 2 4 7 9",
    ": 85 8 90 2 4 9",
    ": 5001 3 6-7 9 17 9 22 4 6-7 9 31 3 5 44 7 50-1 6 8-60 2 7 73 5 82-3 5 8 97 101",
    ": 4 6 8 10 2 6 8 20 3-4 8-9 33 9 42 4 6 51-2 4 62-5 75 9 81 3 91 3 6 8 203-4 6",
    ": 10 3 6 20 2 30 6 9 42 4 7 9 55-6 60 3 5 7 9 77 81 3 5-6 9 94 6-7 9 303 5 7-8",
    ": 12 20 3 5 31 3 5 41-2 4 6 9 54 8 61 4 8 70 3 5 7 9 82 9 92 8 404 9 12 21 3 8",
    ": 33 5 40 2 9-50 2-3 6 60 5 7 73 7 85 92 500 2 4 8 12 6 9 25 30 3 5 7 43 9 51 3",
    ": 5 60 3 7 9-70 81 9 91 4 6-7 9 601 7 17 9-20 2 4 6 8 30 3 5 7-8 41 5 7 9 52 4",
    ": 6 61-2 80 90 2 711-2 6-7 20-1 3 6-8 31-3 7-40 2-3 5-9 51-3 5-8 60 2-4 6 8-70",
    ": 2-8 80 3-4 6-8 90 2-5 7-8 800-2 4 6 8-11 4-5 8 22-4 6-33 5 7-41 5-7 9-53 8 60",
    ": 2-5 7 70 2-6 8-81 5-8 92-3 5-7 900-1 3-5 7-13 6-9 23-8 31 5-49 51-2 4-8 60",
    ": 2-4 6-7 9-70 2-3 5-85 9-94 6 8",
    ": 6000-1 7 11-3 5-6 8-21 4-6 8 30-4 7 40-1 4-8 52 9-60 2-3 6 8-72 4 6 8-83 5-7",
    ": 9 91-4 6 8-102 5-9 11-4 6-7 9-20 2 4 7-41 5-6 8-9 51-3 8-62 4-6 8-72 5-6 8 82",
    ": 4 7-8 91 4-6 8-9 201-4 6-10 2-3 5-6 21-2 5 7 9-31 3-4 6 8 43 5 7-53 6-7 60-2",
    ": 4-5 8 70-2 4 6-7 80-2 6 8-94 9-301 4-9 11 3-24 8-31 4 7-8 40-1 3-8 50 2 4-60",
    ": 3-4 6 8-79 81 5-8 90-6 8 400-4 7-10 2-4 6 8-9 21-4 6-31 3-6 9 41-2 4-5 7-51",
    ": 3-9 62-3 5-8 71-6 8-80 4-6 8 90-1 4 6 8 501 3-4 6-7 9-11 3-5 7-22 4-7 9 31-3",
    ": 5-7 9-40 3-8 50-9 62-4 6 8-9 71-3 7-80 2-3 5-9 91-3 6 8-9 601 4 7 9-10 2-3",
    ": 6-22 4-6 8-9 32-3 5-7 9-44 6-7 9-62 4-6 70-81 4-91 3 5 7 701-5 7 11-3 5 8-9",
    ": 22 4-5 7-9 31 3-9 43-6 50-9 62-3 6-7 9-72 5 7-8 80-7 9-98 801-3 5 7-8 10-6",
    ": 8-20 2-3 5-6 8-9 31-2 4 6 8-41 3-9 52-3 5 8-9 62-5 7-8 71 6-7 9 81 4 7-92 6-9",
    ": 901 4-7 10-1 3 7 9-21 3 6-8 31-5 7-8 40-4 6-8 50 3-5 8-60 3-9 71-4 7-8 80 2-5",
    ": 7-9 91 3 7",
    ": 9-7002 5-6 8 10-9 22-3 6-32 5 7 40 2-5 8-52 4-9 61-2 5-8 71-3 5-82 4 7-8 90-2",
    ": 4 6 8-9 101-4 7-12 4-7 9 21-6 8-31 3 5 7-41 5-9 51-3 7 9-62 4-6 8-71 3 6 80",
    ": 4-7 9 91 3-4 6-203 5-17 21-4 6-8 30 3-9 41 5 8-9 52 4 6-7 9-65 7 9 72 4 6-7",
    ": 9-80 2-3 6-8 92 4-9 301 3-4 7-10 2-8 21-3 6 8 30 2-4 7-40 2-57 63-4 6-70 5 7",
    ": 9 81-3 5-90 2-408 10-6 8-9 22-4 6-7 9-36 8-54 63 6-7 9-78 81-2 5-6 91-4 6",
    ": 8-500 2-3 5-12 6-8 20 2-6 8-35 7 9-42 4-7 9-50 4-62 4-8 70-3 5-7 9-81 3-90",
    ": 2-7 9-612 5-8 20-9 31-3 5-6 8-40 2 4 6-50 2-9 61-4 7 9 71-3 6-8 81 4 6 90 4-5",
    ": 7 9 701 4 7 10-1 3-5 7-21 3-6 8-32 4-6 9-47 9-52 5-6 8-9 61-2 4-5 7 9 71-2 5",
    ": 7-8 80-4 9-91 3-6 9-801 4 6-13 5-9 21-3 6-7 30-2 4-5 8-9 41-9 51-5 7-8 60 2-8",
    ": 70 2 4 7 80 2 4 6 8 90 2-3 5 7 9-900 2 4 6 8 13 7 9 21 3 5 7 30 3 5 7 9 41 51",
    ": 3 5 60 2 4-5 9 71 9 82-3 5 9 91 3-4 7-8",
    ": 8001 4 8 10-1 21 4 6 9 32 4 40 2-3 6 8 50 7 60 2-3 7 9 71 8 80-1 6 8-90 2-3 5",
    ": 7-8 102-3 8 10 7 20 5 7 30 7 43-4 6 8 53 5 60-1 4-5 7-8 70 2-3 7 9-81 4 93-4",
    ": 6 8-9 201 4 9 11 3-4 24 9 32 4 9 50 3-4 7 9 64 6-7 70 3 6 8 82 6 91 4 7 9 301",
    ": 11 23 8 30 5 8 45 8 50 5 62 4 7 9 73 9 82 5 9 91 3 401 9 11 3 21 5 9 32 4 9",
    ": 44 8-9 51 3 70 2 7 9 82 8 90 2 5 9 501 11 6 20 2 7 9 31-2 7 44-5 9-50 4 9 61",
    ": 4 7 76 8 80 3 9 97 9 602 5 11-2 6 8-9 24 6 32-3 5 7 9 45 8 51 3 5 7-8 60 2 4",
    ": 7-8 73 83 5 7 91 3 5-6 700-1 4 6-8 13 22 5-6 32 4 42 4 7 9 53 5 8 61-3 5 70-1",
    ": 3-5 8 80 5-6 8 91 3 7 800-1 8 10 22 6 8 30 4 40-1 3 5 62 74 6 9 81 5 9 93 5",
    ": 905 10 9 28 31 3 5 8 43 5 51 4 7 61 8-9 72 8 81 5 91 9",
    ": 9006 8 11 8 25 7 34 6-7 43 7 52 9 61 4 77 84 7 96 100 2 6-7 9 12 5 8 23 31 6",
    ": 40-1 6 8 51 3 7-8 60 2 5-6 9-70 3 5 8 82 7 90-1 201 8 11 7 9 23 5 9 38-9 42-3",
    ": 5 7 51 6-7 66 9 71 4 8 80 2 4 8 94 6 9-300 5 11 25 32 9 41 6 51 5 8 63 5 70 3",
    ": 7 81 5 93 5 402 5 13 7 20 2 5 7 32 5-6 9 47 52 8 68 71 3 8 80 5 7 9 91 5 7",
    ": 504 11 4 7 9 22 4 7 30 2 4 7 44 7 50-1 3 5 9 64 6 9 76 8 82 6 8 91 9 601 5",
    ": 7-8 11 25 31 42 8 53 5 8 60 3 7 9 80 5 7 90 5 8 702 5 7 10 3 5 7 23 33 6 40 2",
    ": 9 68 70 3 81 4-5 9 95 8 803 6 11 3 6 9 22 5 7 30 4-6 9 52-3 6 63 5 75 88 93 7",
    ": 9 903 9 13 6 24 7 31 4 7 42 6 9-50 64 6 8 71 3 86 8 90 3-4 7-8",
    ": 80005-6 13-4 6 20 2 4-5 7 9 31 5 7 9-40 4 7 9 54 8 63 5 7 76 83 8 93 5 102 4",
    ": 8 14 6 21-2 5 9 37 44 6 51 3 5 8 60 5 7 72 5 8 80 2 5 8 91 7 9 203 5 7 9 21 3",
    ": 5 8 30 4 9 43 9 58 60 3 6 8 74 81 4 6 9 92 8 301 6 11 9 21 7 31 4 6 9 47 9 53",
    ": 9 62 6 74 7 80 90 2 6 403 12 5 8 21 4 7 33 6 9 42 9 51 3 5 7 64 6 9 71-2 9 81",
    ": 91 5 8 500 2 8 16 9 21 4 7 9 36 8 41 9 53 7 68 70 2 4 6 8 80 2 4 8 97 600 16",
    ": 8 21 3 9 37 41 3 6 53 5 63 8 70 2 5 8 80 4 8 92 5 7 701 5 7 11 4 6 8-9 21 3",
    ": 33 6 8 48 53 5 65 8 75 96 805 22 4 8 31 3 6 9 48 51 3 6 9 61 5 7 72 5 7 84 6",
    ": 9 94 907 12 7 23 6 9 36-7 43 5 9 52 4 71 5 7 80 3-4 6 9 95 8",
    ": 1001 3 9 13 7 21 8 32 4 6 9 41 4 6 9 51 4 61 9 73 6 84 7 96 8 101 4 7 14 6 24",
    ": 32 40 2 4 9 52 4 8 61 4 74 8 86 8 91 4 7 9 202 8 10 2 4 7 9 25 8 33 6 43 7 50",
    ": 3 62 5 76 83 6-7 91 6 302 4 9 13 9 22 7 9 31 7 44 52 5 8 61 3 6 9 72-3 5 7 80",
    ": 3 7 9 91 4 6 400 3 5 9 12 6 8 21 6 30 2-3 6 9 44 6 8 51-2 4 69 73-4 7 9 83 5",
    ": 8 90 3 5 8 501 3 6 17 20 3 6 8 32 5 46 52 7 60 4 6 74 83 7 90 605 8 10 4 6 9",
    ": 22 4 8 31 6 9 41 4 6 8 53 5 7 60 2 6 8 72 4 81-2 4 92-3 5 8 700 7-9 13 20 2 4",
    ": 6 9 33 8 40 3 9 52 6 8 60 2 5-6 73 5 81-2 4 6 8 91 3 7 9 802 4-5 9 11 6 24 7",
    ": 9 41 4 7-8 52-3 6 62 4 6 8 70 4 6 86 9 97 901 3 11 6 25 34 9 48 51 4 7 60 4 7",
    ": 71 4 82 4 8 91 4",
    ": 2002 5 8 13-4 20 6 9 37 9-40 3 54 8 61 4 74 80 3 107 9 12 4 21 4 6 30 7 9 45",
    ": 7 54 6 61 4 6 8 72 5 8 91 6 9 205-7 12 5 21 31 4 7 44 8 66 8 71 5 8 81 6 92 7",
    ": 301 4 6-7 10 3 8 21 3 7 33 8 45 8 56 9 62-3 6 9 74 7 9 82 8 91 3 5 8 401 4 7",
    ": 15 7 22 4 30 6 41 4 8 51 6 9 61 4 8 73 6 80 2 5 91 4 7 500 3 8 10 3 6 21 4 32",
    ": 9 41 6 54 60 5 7 76 8 80 3 90 3 5 7 603-4 7 10-2 4-5 7 20-2 5 7 33 7-8 40 2-3",
    ": 5-7 9 57 9 61 3 5 70 2 5 8 80 3 6 8 90 3 5 7 700 4 7 9 14 7 9 24 6 8 34 40 2",
    ": 7 50 4 7 9 67-8 75 7 84 6 8 91 3 5 7 9 802 4 15 8 21 3 5 7 9 33 8 40 9 51 4 6",
    ": 8 61 71 3 87 90 2 4 9 902 6 9 17 9 22 4 8 30 6 40 2 7 9 52 5 8 62 5 7 9 72 5",
    ": 8 83 91 3 8-9",
    ": 3001 4-5 12 4 6 8 21 31 8-9 46 9 52 9 61 4 6 70 5 82 4 6 9 92 6 8 100 8 13 5",
    ": 7 23 5 31 3 5 7 9-40 5 7 9 51 4 6 9 65 7 72 85 8 91 3 5 7 200 5 7 9 12 4 6 9",
    ": 21 4 6 36 9 42 5 7 52 5 7 60 3 5 9 74 7 86 8 90 5 7 300 4 9 18 24 32 5-7 41 3",
    ": 5 9 51 4 60 72 4 81 3 6 8 91 3 9 405-6 9 11 4 7 29 31 4 40 3 52 8 68 71 4 6",
    ": 80 2 4 6 97 9 501 6 9 12-3 8 22 6 8 30 3 5 8-9 42-3 5 7 9 53-4 7 60 5 8 70 3",
    ": 8 83 5 8 90 3 6 605 8 12 7-8 22-3 7 9-30 4 8 43 5 9 55 7 60 2 6 8 74 6 9 81 6",
    ": 8 91 4 6 9 702 7 9 11 5 24 8 31 3 8 41 7 56 61 3-4 9 72 5 8-82 7 92 4 800 8",
    ": 11 9 22 34 41 5 7 50 2 4 8-9 69 74 7 81 4 8 93 5 900 2 4 16 22 4 6 8 30 2 4",
    ": 40 2 5 7 50 2 64 8 71 5 8 80 3 9 93 5 7",
    ": 4001 8 13 8 21 5 7 9 32 5 8 40 50 2 6 8-9 61 9 75 9 83 91 7 9 101 3 7 12 6 20",
    ": 8 31 3 5 44 51 9 61 4 6 8 70 5-6 8 80 4-7 90 2 8 203 5 7 10 3 7 20 3 6 8 32 5",
    ": 8 41 5 52 5 7 61 3 6-7 70 5 81 9 93 6 8 302 5-7 9 11 3 8 20 2-4 8-9 32 4 9 44",
    ": 6 8 50 2 4 6 64 9 72 8 81 3 6 9 91 3 9 404 6 8 11 3 5 7 9 23 5 7 33 7 43 5 7",
    ": 9 55 7-64 6 9 71 4 9 81 3 9 92 8 501 4 6 9 11 4 7 9 21 4 6 8 31 3 5 9 42 5 8",
    ": 50 8 61-2 7 9 72 7 9 86-7 91 5 7 600 2 11-2 9 22-4 7 9 32 9 46 8 51 5 9 62 70",
    ": 2 7 86 8 91 6 8 702 5 12 5 7 20 3 5 30 2 5 7 9 55 63 5 9 72 4 6 9 82 4 92 4",
    ": 802 5 7 14 7 20 7 31 9 41 3 6 50 5 7 69 71 4 7 9 82-3 9 92 4 7 9 908 11 6 9",
    ": 24 6 8 36 8 40 3 9 55 65 7 70 2 8 83 5 8 90 6 8",
    ": 5000 2-3 6-7 9 12 7 20 2 4 6 31-2 4 7-8 48-9 51 5-6 8 61-2 6 9-70 3 5 80 2 9",
    ": 91 5 8 105 7 12 5 7 20 2 5 7 30 3 6 9 41 8 50 4 60 4 7 9 72 5 7 82 7 90 2 6",
    ": 203 5 9 12 4 20 2 5 30 43 5 7 53 6 9 61 7 9 72 5 7 80 5 8 91 5 302 6 9 12 21",
    ": 3 5 8 31 7 9 41 4 52 5 8 60 3 6 8 72 5 7 9 81 3 8 91 3 5 7 9 405 7 12 5 8 21",
    ": 6 30-1 3 8 46 9 51 3 6 60 2 5 7 72 7 80 3 93 9 503 11 5 8 22 8 30 3 7 40 2 50",
    ": 2 4 9 64-5 8 71 6 86 9 94 7 600 3 8 11 3 8 25 8 31 4 8 41 4 6 9 51-2 5 9 64 8",
    ": 74 7 80 9 92 4 9 703 5 7 9 12 21 4 7 32 4 6 8 40 8 50 3 5 61 5 9 71 80 2 5 8",
    ": 90 4 9 802 5 7 9 13 9 22 5 46 8 53 5 8 60 3 5 9 71 8 80 6 90 2 5 8 900-1 3 11",
    ": 3-4 6 9-20 4 8 34-5 42 6 51 3 7 9 61 4 7 73 5 83 91 4",
    ": 6001 4 10 2 5 7-8 20 7 34 7 41 6 59 67 72 80 2 8 91 3 6 8 101 6 11 3 6 8 21-2",
    ": 7 30 5 9 48 54 8 62 6 73 6 9 81 3 6 9 91 3 200 3 8 10 5 23 30 4 9 41 3 7 9 52",
    ": 5 65 8 71 81 3 6 8 91 4 303 8 15 8 22 5 30 5 7 44 6 8 53 6 66 9 71 4 85 96 8",
    ": 401 5 8 15 8 21 5 8 30 43 8 51 8 60 3 6 9 71 3 6 9 82 90 5 8 505 12 5 20 2 30",
    ": 3 9 42 50 3 9 68 71-2 4 7 87 90 9 601 3 6 8 10 3-4 8 20 3 5 8 31 3 9 42 6 8",
    ": 51 3 6 8 68 70 2 4 7 80 5 7 9 91 4 702 5 8 12 4 7 9 25 8 30 3 40 3 6 54 6 9",
    ": 61 5 7 70 4 7 82 5 90 2 4-5 9 801 9 13 8 20 2 6 31 5 40 3 8 52 62 9 71 8 80 7",
    ": 90 2 6 908 10 2 4 7 23 6 33 5 8 42 5 51 62 5 8 73 6 81 4 7 9 97",
    ": 7001 6 9 16 22 7 31 3 6 9 48 62 8 71 5 7 81 4 97 101 4 7 9 17 23 5 39 41 6 59",
    ": 61 4 70 8 81 3 5-8 90-1 3 205 9 11 4 8 22 5 7 31 40 2 8 51 6 9 62 4 7 9 71 7",
    ": 9 81 3 9 92 5 306-7 9 11 3 6 8 20 4 6 8 34 6 8 41 5 8 52-3 9-60 6-7 72 7 81 6",
    ": 9 91 3 5 401-2 5 7 9 11 4 6 9 21 3 5 8 30 2 4 6 8 41 4 7 71 4 6 8 81 3 5 8 96",
    ": 8 501 5 11 5 7 9 23 8 30 3 5 8 41 3 7-8 54 7 64 9 76 8 80 2 5 90 7 600 6 9 12",
    ": 8 21 8 31 5 8 41 3 5 50 3 60 4 7 80 706 10 2-3 5-6 22 8 31 42 7 50 2 9 64 6",
    ": 74 83 8 90 8 802 5 7 23 6 8 32 8 45 9 55 8 61 3 8 70 2 4 8 80 2 5 7 95 904",
    ": 9-10 3-4 7 9 21 3 9 37 40 2 4 6 50 6 8 62 4 6-7 9 73 5 7 9 81 6-8 90 2-3",
    ": 8002 8 11 7 20 6 34 6 41-2 6-7 50 5 61 3 5 7 71 3 5 8-80 2 90 3 5 7 100 8",
    ": 11-2 4 7 9 27 30 9 41 3 6 9 54 60 73 80 4 7 90 3 6 202 6 9 14 6 25 8 31 6 46",
    ": 8 51 4 6 8 65 7 84 6 301 5 7 14 6 28 30 2 4 7 44 7 9 56 65 8 71 4 7 85 7 9 93",
    ": 5 8 400 4 13 7 9 22 6 8 36 8 42 4 6 51 4 6 8 61 4 7 70 3 8 80 3 8 92 5 9 502",
    ": 8 14 6 25 8 31 6 9 51 8-9 65 9 79 82 4 6 9 92-3 5 8 601 3 6 11 23 5 32 5 8",
    ": 43-4 9 53 6 9 63 85-6 9 92 7 703 8 11 5 7 23 7 36 8 48 51 6 64 7 73 6 83 5 7",
    ": 9 92 7 803 5 7 10 3 6 20-1 39 41 4 8 52 5-6 60 7 9 74 7 9 82 4 94 7 904 6 14",
    ": 6 9 24 7 9 32 4 6 8 40 5 8 53 6 8 60 4 7 70 2 5 7 82 4 7 90 2 6 9",
    ": 9005 8 10 3 7 25 7 9 32 4 8 40 3 5 53 7 9 64 71 5 84 6 90 3 9 102 4 6 9 12 6",
    ": 8 21 8 30 3 5 8 40 6 50 2 8 60 2 73 8 88 97 9 204 7 14 7 9 24 7 36 43-4 54 7",
    ": 9 64 7 72 5 9 81 3 6 8 90 5 8 300 2 4 13 5 21 4 9 31 3 40 3 6 9 52 4 60 5 8",
    ": 71 3 6 9-80 5 8 92 5 7 9 419-21 3 6-7 32 6 8 51 6 8 61 7-8 73 5 80 3 6 8 92 5",
    ": 501 4 11 3 7 9 26 8 31 3-4 6 8-9 41 5 7 56 8 60 6 9 71 3 80 6 9 91 4 7 603 6",
    ": 8 14 8 23 6 9 33 5 40 3 5 7 52 4 7 66 70 3 6 80 3 8 90 3 5 8 701 6 9 11 4 6 9",
    ": 22 34 7 41 9 51 4 63 9 74 91 4 6 9 815 28 35 42 50 2 7 65 7 84 91 7-8 908 11",
    ": 3 22 4 9 31 5 8 41 4 8 51 3 5 9 62 5 7 9 74 9 81 4 6 94 7",
    ": 90005-6 8 10 5 25 42 50 2 5 8 62 5 7 70 5 7 80 9 91 3 101 4 8 10 3 6 9 21 3 7",
    ": 34 7 44 6 9 51 3 60 4 6 75 7 81 8 90 4-6 8 203 5 8 10 25 7 36 8 46-7 54 9 69",
    ": 71 6 9-80 95 8 305-7 9 11 4 23-4 6 30 7 40 4 50 2 9 62 4 72 8 82 90 9 401 6 9",
    ": 11 4 6-7 9-20 6-7 33 6 8-40 2-4 8 50 3 6 61 3 5 8 70 6 8 82 4 7 9 91 3-4 6 9",
    ": 502 4 8 12 4-5 7 9 22 4 6 30 3 7 9 43 7 54 7 9 62 5 7 9 71 3 6 8 81 6-7 90 2",
    ": 4 7 601 3 10 8 22 5 8 30 2 8 46 9 53 70 4 7 9 83 94 704 6 8 14 9 24 32 5 9 41",
    ": 4 7 51 3 9 61-2 4 9 74 86 9 805 16 8 21 3 30 3 5 9 53 6 9 62-3 5 7-8 70 2 4-6",
    ": 81 3 5 7 92 8 903 5 8 13-5 7 21 3-4 8 30 2-3 6-8 40 2-3 6 8-50 4-5 7 9-60 5",
    ": 70 2 4 7 81 7 92 5 8",
    ": 1004 6 8 10 27 30 2 5 42 5 7 50 7 60 4 71 4 7 9 82 4 6-7 9 92 5 100 3 5 8-9",
    ": 12 5 8 21 3 7 31 3 6 62 9 72 7 84 90 8-201 3 5 12-3 6 8 22 30 9 41 3 8 50 60",
    ": 3 79 82 5 91 3-4 6 9-300 4 7 10 5 33-4 7 43 57 71 81 7 97 405 8 10 3 5 7 20 2",
    ": 4 6 35 9 41 3 5 51 4 8 67 72 81 91 3 6 500 3 7 12 5 9 21 3-4 33 46 9 58 61 4",
    ": 6 70 3 6 83 5 8 91 4 7 600 2 8 13 20-1 7 30 3 9 57 62 70 2 5 87 93 7 700 3 7",
    ": 11 8 24 30 5 8 40 3 5 8 58 65 9 75 9 81 5 8 90 3 9 802 5 9 12 8 20 3 6 35 45",
    ": 8 50 5 60-1 8 77 82-3 6 9 96 901 4 12 20 35 8 47 9 57 63 5 8 74 88 90 3 7",
    ": 2000 3 23 30 45-6 54 7 60 2 72 5 7 81-2 90 4 6 9 105 10 2 30 7 40 3 5 9 55 65",
    ": 70 4 8 82 93 6 201 3 6 8 11 20 34 9 49 51 3 8 66 70 2 5 8 83 8 91 3 309 14 27",
    ": 46 53 8 61 3 8 71 4 7 9 90 6 9 404 7 10 5 7 9 22 32 5 42 4 51 7 66 8 70 3 6 8",
    ": 83 7 97 512 22 8 32-3 5 8 59 61 4 9 72 5 7 9 83 5 91 4 6 8 601 6 8 13 5 7 9",
    ": 21 3 5 33 6 42 5-6 50-1 7 60 2 4 6 9 71 3 8 82 90 6 700 5 11 4 7 25 9 31 3 6",
    ": 8 40 2 4 7 52 6 8 63-4 9-70 3 5 8 80 2 7 91 5 8 800 3 6 12 8 20 3 8-9 32 7 40",
    ": 2 8 53 9 62 6 70 9 82 91 5 915 7 25 7 31 8 46 9 51 3 6 61 5 70 2 4 82 98",
    ": 3009 15 26 8 31 5 8 41 4 7 59 64 6 71 86 8 92 4 7 100 8 13 9 21 5 8 31 4 8 41",
    ": 6 9 51 4 6 60 3 5 9 78 80 6 91 6 8 206 12 4 23 9 35 8 44 7 50 3 6 8 60 6 70 3",
    ": 6 82 90 5 7 300 5 8 15 7 24 7 31 4 43 7 9 51 4 6 9 68 71 6 8 80 3 5 94 8 404",
    ": 7 24 9 32 4 6 8 50 4 7 61 3 71 5 7 80 8-9 97 511 7 9 24 9 32 8 42 4 7 9 53 8",
    ": 69 78 81 4 7-8 95 9 602 5 7 10 2 9 23 5 8 30 3 6 46 8 51 3 5 65 7 71 3 9 87",
    ": 91-2 4-5 7 9 705 15 7 9 25-7 31-2 4-5 41-2 4 7-8 50 6 61 4 8 71 3 6 82 4 91",
    ": 800 9-10 3-4 6-8 20 6 30 3 5 9 42-3 5 8 50 65 8 70 8 82 4 6 9 93 5 9 901 6 13",
    ": 6 22 30 5 8 40 3 8 52 4 6 62 75 7 80 3 8 91 5 7",
    ": 4002 5 8 10 6 8 21 7 30 5 7 9 41 5 7 60 70 2 8 83 8 93 6 9 112 5 7 9 38 51 3",
    ": 6 63 6 8 77 9 81 4 6 8 90 5 8 200 3 12 4 6 8 20 2 9 39 43 6 8 50-1 3 6 8 60-1",
    ": 3 6 72 5 83 5-7 9 91 3 302 4 10 2 20 2 4-5 8 31-2 4 6 8 41 53 6 9 67 70 5 7 9",
    ": 84 7 90 3 402 8 14 7 22 4 6 9-30 7 42 5 8 54 7 9 71 4 80 4 9 97 500 6 9 24 95",
    ": 637 44 6 57 60 6 8 72 7 80 5 9-90 4 6-7 701 4 11 5 21 3 8 30 2 8 41 3 6-7 51",
    ": 3 5 7 60 2 4 9 72 6 9 81 4 7 9 94 7 808 10 2 5 20 3 7 32 5 7 40 3 5 7 50 2 7",
    ": 9 62 5 73 5 8 81 3 9-90 3 6 901 4 7 9 13-4 6 9 24 6 8 30 2 41 3 5 50 8 61 5 7",
    ": 9 72-3 7 82 95 8",
    ": 5001 4 7 12 6 9 22 4 35 7 9 45 8 51 6 9 61 3 5 8 70 3 80 3 6 8 92 5 9-100 3 5",
    ": 9 11 4 7 22 4-5 8 31 5 7 9 43 5 9 53 6 67 70 5 8 81 4 8 202 5 7 12 5 8 20 3 9",
    ": 32 7 9 41 8 50 6 62 6 9 72 5 7 80 2 5 92 7 300 6 9 12 4 21 3 5 8 30 2 4 41 51",
    ": 6 8 65 71 3 81 9 92 400 3 15 25 8 32 4 46 51 3 7 61 4 7 70 7 9 82 5 7 90 5 9",
    ": 505 7 11 3 5 8 24 7 32 6 8 40 2 8 51 7 9 64 6 71-2 7 81 3 6 9 91 5 600 2 7 11",
    ": 6 23 7 9 33 8 40 50 3 5 61 4 8 71 3 8 80 3 9 97 9 702 8 10 3 7 9 22 4 6 30",
    ": 2-4 8-9 41 3 50 9 64 9 72 4 83 6 93 6 8 801 3 6 13 5 8 21 6 37 9 46 8 51 3 6",
    ": 61 6 70 8 81 4 95 9 905 8 10 2 7 20 30 8 59 61 4 72 7 84 90 3 9",
    ": 6007 12 4 9 24 30 6 48 54 61 6 70 3 8 81 4 7 9 91 3 7 102 11 3 26 8 36 41 3",
    ": 71 4 6 84 6 8 91 4 200 4 8 11 3 6 8 20 4 9 32 5 9 41 4 7 9 58 60 3 73 8 88-9",
    ": 93 9-300 9-10 4 6 22 31 5 7 9 41 3 5 9 52 5 8 60 5 70 3 5 7 80 90 3 6-7 401 3",
    ": 8 11 3 20 4 9 32 8 44-5 9 52 8 66 8 70 3 5 82 5 7 92 503 7 10 6 22 31 6 9 44",
    ": 50 3 62 5 72 5 87 96 602 7 12 8 20 3 6 37 40 8 56 61 9 72 4 6 80 3 703 11 3 5",
    ": 7 20 3 9 32 9 52 4 61 4 6 9 71 3 6 82 4 6 98 803-4 7 14 6 22 4-5 31 3 8 40 3",
    ": 7 61 3 5 8 72-3 5 8 82 5 92 5 7 901 3-5 10 2 5 7-8 26 30 2 4 6 9 43 5 9 51-2",
    ": 4 9 64 6 75 8 85 8 92 5 7",
    ": 7000 3 8 10 5 21 3 45 7 54 6 8 61 3 6 72 8 89 96 9 106 8 14 6 8 22 9 40 7 51",
    ": 9 65 7 72 5 80 3 6 8 91 3 7 9 202 4-5 8 11 4 9 21 4 36 9-40 4 6 8 51 4 6 61",
    ": 8-9 71 4 8 81 3 5 92 302 5 11 4 6 27 35 7 9 47 57 420 60 98 501 3 16 9 21 6 9",
    ": 32 7 9 46 8 50 3 9-60 3 6 71 6 9 82 5 7 90 7-8 601 11 7 20 7 33 41 5 8 50 2 6",
    ": 9 64 6 9 72 4 80 2 5 8 90 3 5 7 9 706 10 2 8 23 6 35 43 5 50 3 62 5 72 82 6",
    ": 92 800 15 7 22 4 7 9 46 51 4 8 71 4 6 82 5 96 9 903 9 14 20 2 7 31 4 7 9 41 8",
    ": 50 5 9 64 7 9 71 3 5 8-9 81 98",
    ": 8000 9 11 4 26 42 7 51 66 8 71 3 5 87 90 3 5 7 9 101 4 12 5 7 20 6 31 43 6 54",
    ": 6 69 72-3 6 80 3 90 208 13 6 8 20 6 31 3 9 46 61 5 8 72 5 81 3 8 90 3 5 7 9",
    ": 302 5 7 10 2 4 9 28 40 6 8 53 6 69 72 6 9 86 8-9 92 401 4 6 9 13 22 31 4 9 42",
    ": 5 9 52 7 62 7 83 7 9 96 500 6 17 25 8 30 3 43 6 8-9 51 3 6 8-9 66 8 70 4 82 5",
    ": 93 603 18 21-2 5 8 34 7 43 51 4 6 9 62 4 6 8 71 3 6 9 83 5 94 7 706 15 27 30",
    ": 6 9 41 4 6 8 50 4 6 67 9 72 8 80 803 7 13 6 8 39 61 3 71 9 84 95 900 3 7 13 6",
    ": 24 7 32 42 50 2 4 7 60 4 6 76 9 82 7 90 2",
    ": 9000 12 7 21 4 9 32 7 44 8 50 6 8 61 4 6 9-70 2 5 82-3 93 5 8 101 5 7 11 4 6",
    ": 8 22 4 8 30 2 7 57 60 2 5 71 3-4 7 9 81 96 8 200 4 9 11 4 6 8 21 7 9 37 9 49",
    ": 56 71 9 81 6 9 91 6 8 305 14 8-9 22 5 7 30 2 5 46 53 7 69 74 81 94 7 405-6 15",
    ": 7 20 2 5 7-30 2 7 53 7 65 8-9 71-2 4-5 9 84 7 91 8 500 7-8 14 6 20 3 5 31 60",
    ": 2 4 7-8 72 4 7 80 90 5 8 605 8 12 8 20 8 34 8 41-2 4 50 3 8 75 7 80 5 93-4",
    ": 701 3 12 4 7 20 2 5 8-30 3 69 76 88 91 3 6 8 800 3 7 12 5 7 9 32 9 41 3 8-9",
    ": 52-3 6 62 70 3 5 7 85 9 92 8 908-9 11 26 8 31 3 6 8 40 3 7 55 60 6 75 8 80 4",
    ": 8 90 6",
    ": 900007 9 12 4 7 29 31 3 6 8 41 4 50 2 62 6 76 80 3 6-7 9 100 2 29 32 4 50 2 6",
    ": 78-9 81 3 6 90 5 7 201 5 8 10 2 4 6 9 24 30 3 8 41 3 6 50 3 5 8 61 6 8 71 3 6",
    ": 8 92 4 301 7 10 2 5 8 20 5 32 7-8 52 4 6 65 70 2 4 7 9 82 5 8 93 5 8 400-1 6",
    ": 9 14 6 22 7 30 3 7 47 52 6 8 60 8 72 80 91 5 501 4 6 10 2 5 8-9 21 34 43 62 4",
    ": 8 71 4 6 80 4 6 97 600 3 5 8 10 7 20 2 5 30 2 5 7 45 7 50 2 6 9 64 9 71 83 5",
    ": 92 7 700 3 7 10 5 20 5 8 41 4 9-50 3 5 8 61 5 70 4 6 80 5 8 94 9 801 3 10 2 7",
    ": 21 31 3 6 9 45 51 60 3 5 8 70 6 8 81 92 4 900 3 15 23 7 9 31 4 40 2 8 56 63 9",
    ": 74 8 81 4 8 90 9",
    ": 1001-2 7 10 2 8 20 3 6 8 31 4 9 44 8 51 3 5 60 2 74-5 9 94 6 102 5 7 12 7 21",
    ": 6 33 5 40 9 54 9 61 3-4 6 8 70 3 5 80 2 4 7 91 8 200-2 14 7 20 5 35 7 42 7 52",
    ": 65-6 9 74 81 3 6-7 9 97 9 301 4 7 9 12-3 6 9 21 4 31 3 6 9 41 4 7 50 3 5 8 60",
    ": 5 7 9 73 80-1 3 6 9 97 402 6 9 12 4 7 21 3 30 2 7 9 41 7 9 51-2 5 9 61 8 70 2",
    ": 5 83 7 93 500 3 13 27 34 8 43 9 52 4-5 60 7 9 71 7 80-1 7 99 601 9 12 6 8 25",
    ": 30 2 5 7 9 44 9 51 5 63 6 9 73 9 83-4 6-9 92 5-6 8 701-2 8 10 4 8 24-5 9 34",
    ": 40 3 5 8 52 7 68 74 7 81 4 6 8 90 2-3 6 821 4 9 33 6 9 42 6 53 8 64 76 8 87",
    ": 90 3 5 8 903 9 13 22 6 8 38 43 50 3 5 7 9 61 73 84 6 8 91 6",
    ": 2003 5 11 25 35 41 6 9 51 4 8 60 3 6 72 5-6 80 4 8 98 101 3 11 8 20 5-6 8 30",
    ": 43 52 8 70 5 93 6 203 6 9 12 4 6 8 23 30 7 42 6 52 4 7 60 3 8 70 3 5 7 82 4 6",
    ": 92 7 305 7 10-1 3 21 8 30 3 8 41 3 6 9 51 4 8 64 6 78 80 4 7 94 400 2 5 8 10",
    ": 7 24 6 30 2 9 45 9 51 4 7 60 3 5 76 81 4 6 90-1 3 5 8 507 10 2 7 20 5 30 5 9",
    ": 42 7 51 3 5 65 7 70 2 8 81 4 7 9 92 7 9-600 3 5 7 12 4 7 9 24 6 9 31 3 9 41 8",
    ": 51 3 7 60 2 5 7 72 8 80 3 5 9 94 6 701 8 14-5 8 22 5 7 31 5 8 41 3 6 55 60 7",
    ": 70 5 86 96 800 3 6 9 12 6 30 3 6 41 7 54 9 63 8 78 83 7 96 9 901 5 11 3 9 21",
    ": 6 39 41 3 5 8 50 6 61 4 6-8 70 3-4 6 8-9 84 6 8 90-1 5 7",
    ": 3005 8 10 2 4 7 20 2 9 31 5 9 45 7 51 4 6 8 62-3 6 72 4 6 80 5 8 93 5 107 9",
    ": 12 8 20 6-7 9 31 3 6 8 40 2 6 9 52 6 9 61 3 5 70 7 9 81 5-6 9 91 3 6 8 200 3",
    ": 5 10-1 8 20 3 7 30 2 7-8 41 6 8 53 5 8 61 4-5 7 72-3 81 3 90 3-4 8 301 4 9 12",
    ": 21 3 8 34 7 40 3 6 9 52 5 7 60 6 73 5 8-9 82 7 91 6 8 416 9 23 31 4 6 9 54 8",
    ": 60 4 8 70 2 4 7 80 4 90 2 4 7 500 5 14 7 9 23 5 7 9 32 4 6 9 45 7 51 9 66 9",
    ": 71 4 9 81 5 7 9 92 6 601 3 5 7 12 7 28 31 4 7 49 52 62 5 8 77 9 85 8 90 8-700",
    ": 2 7 12-3 6 9 23-6 36 40 4 7 50 9 61 4 9 72 9 88 91 4 8-9 805-6 8 15 7 9 25 7",
    ": 35 7 43 6 9 56 9 75 81 5 8 92-3 6 8 900 2 8 12 7 23 6 8-9 31 7 40 3 8 50 2 7",
    ": 61 70",
    ": 4003 9 11 8 20 34 9 41 5 8 65-6 9 71 3 5 81 90 102 4 7 10 3 6 28 30 4 6 8 41",
    ": 6 51 4 6 62 70 2 81 6 8 91 3 7 212 5 20 2 8 30 3 5 8 41 3 9 59 61 7 70 3 5 83",
    ": 5 9 91 4 7 300 2 5 7-8 10 3 7 20 4 9 35 51 3 64 6 75 7 82 92 5 8 400 2 6 23 6",
    ": 8 31 46 9 52-3 6 61 7 9 72 7 80 4 8 93 5 503 15 8 26 9-30 3 7-8 42 6 9 51 4 7",
    ": 9 61 70 2 5 8 81 3 6 92 5 7 9 601 14 7 20 2 4 44 52 6 8 61 9 71 4 9 82 8 96",
    ": 709 13 5 8 21 4 6 9 33 6 41 4 6 8 50 6 62 72 4 9 86 93 805 9 11 4 22 6 31 4",
    ": 42 4 51 5 8 60 2 4 6 72 4-5 7 98 900 10 6 8 21 7 32 44 50 2 4 9 61 8 79-80 2",
    ": 5 94 8",
    ": 5001-2 10 9 26 31 3 8 41 3 5 7 54 7 69 71 83 5 9 96 102 5 8 10 2 7-8 23 7 37",
    ": 9 46 61 3 5 79 81 9 94 210 3 20 4 6 8 31 8 41 3 7 54 60 5 8 79 87 9 93 6 8",
    ": 302 5 8 12 20 6 9 36 9 42 5 55-6 61 5 8 70 3 5 81 4 9 91 404 8 12 4 9 27 30 7",
    ": 9 46 9 54 8 61 3 6 71 7 83 5 7 500 4 9 11 3 5 7 20 3 6 31 4 6 8 48 59 68 70 9",
    ": 86 91 3-4 8 602 4 12 4 6 8 21 3 7 9 36 8 41 4 6-8 51-2 5-6 60 2 4 7 71-2 4",
    ": 6-7 80 2 5 7 9-91 7 701 5 9 11 3 8 26-7 34 7 40 3 5-6 9 55 63 9 76 84 7 93 5",
    ": 800 4 18 27 30 2 7 41 3 6 8 50 3 5 7 63 5 71 4 6 83 5 7 97 9 903 7 21 3-4 6",
    ": 34 43 55 7 61 4 6 70 4 6 82 4 9 92",
    ": 6000 23 5 34 7 45 7-8 55 8 65 8-9 74 6-7 9 92-3 6 8 100 3 5 9 13 7 9 25 9 31",
    ": 3 6 40 5 8 51 3 6 9 64 9 71 4 6 9 82 4 7 93 7 200 4 7 9 19-20 3 9 34 7-8 40 2",
    ": 5 8 56 8 61-2 4 6-7 9 71 6 86 9 92-3 5 7 303 12 4 8 20 2 5 31 5 7 9 41 3 5 8",
    ": 57 63 5 8 71 5 7 9 81 4 7 90 2 6 9 401 5 10 7 23 31 3 7 9 43 8 51 3 63 5 7 70",
    ": 6 86 93 501 29 36 41 57 60 3 71 80 7-8 90 3 6 600 4 10 3 5 7 25 9 33 5 9 42",
    ": 58 71 4 80 3 5 91 3 6 704 17 9 22 32 7 42 7 54 60 7 73 9 91 4-5 801 8-10 2 5",
    ": 7 9 23 32 4 6 40 4 7 9 56 61 3 5 8 71 4 6 8 81 4 7 9-90 907 12 5 23 31 4 47",
    ": 50 3 6 9 61 6 8 73 6 9 81 7 9 96",
    ": 7000 3 6 8 12 5 21 4 6 8 30 2 4 40 7 52 60-1 3 8 70 2 4 9 81 3 5 9 99 102 4 7",
    ": 10 2-3 5 8 24 7 9-31 5 9 42 50-1 4-5 9 62 7 9 74 7 84-5 7 90 3 7 201 4 11 7",
    ": 21 4 7-31 6 8 46 9 52-4 7 61-2 6 9 73 6-7 83-4 91 4 7 300 4 14 6 21-2 32 7 9",
    ": 41-2 4-6 9 51 8 61 3 5 70 3 5-7 82 4 9 406 8 11 3 21 5 9 37 42 7 55 7 9 63 5",
    ": 9 74 7 9 82 5 7 93 502 5-6 25 7 30 2 4 40 6 55 7 9 62 4 6 8 70 2 4-5 8 81 3 7",
    ": 92 5 603 6 9 13 7-8 20 4 31 3 5 7 9 45 53 8 60 4 9 75-6 8 82 5 8 93-4 8 702 4",
    ": 7 10 2-3 5 21 3 6 8 35 8 40 8 51 3 8 61 4 7 71-2 4-7 84 9-90 4 7 800 2 4 8 11",
    ": 3 8 22 7 9 34 6 9 49-50 6 61 8-70 2 4 6 80 3 8 91 3 5 8 900 4 10 8 21 4 8",
    ": 31-2 5 40 6 50 6 9 62 5 8 73 6 8 81 3 6 93",
    ": 8002 9 11 4-5 7 9 23 5 7 9 32 4 7 40 3 5 7 50 2 5 60 4 8 73-4 6 9 81 3 7 9 97",
    ": 103 6 9 11 5 25 8 37 40 3 8 50 2 65 8 70 2 4 6 9 82 4 6 8 91 5 8 204 6 9 11 4",
    ": 9 23 5-6 8 30 5 41 4 6 9 51 6 61 4 6 70 6 9 81 4 91-2 4 6 9 301 3 6 9 11 6 8",
    ": 28 30 3 8 42 4 6 52 5 7-8 60 5 9 74 6-7 80 5 91 3 9 405 8 10 2 21 4 8 35 7 40",
    ": 2 4 6 51 4 62 5 82 5 95 8-9 516 24 31 4 6 8 43 8 55 7 68 79 82 4 6 607 9 12",
    ": 20-1 4 30 41 4 52 7 66 9 74 88 91 6 8 701 9 11 7 9 23 5 7 47 50 4 61 5 7 9 72",
    ": 5 9 83 9 91 4 6 9 806 8 10 3 7 9 22 7 9 31 9 41 3 5 7 52 6 8 63 6 9 76 81 4",
    ": 91 7 900 2 4 8 11 3 8 20 2 8 30 2 9 41 50 2 4 6 62 5 8 71 3 5 7 81 3 6 91 3 5",
    ": 7",
    ": 9001 4 8 10 2 5 8 21 3 6 37 9 41 4 56 62 4 70 3 7 83 5 7 90 107 11 3 6 9 21 5",
    ": 7 37 41 3 5 8 50 3 7 60 3 5 70 4 7 9 82 90 5 8 204 11 5 7 9 25 40 4 56 8 61 5",
    ": 74 7 82 9 92 7 302-3 6 8 12 4 29 31 7-8 42 7 9 54 7 9 61 5 8 70 8 94 8 400 2",
    ": 5 10 20 2 5 32 4 8 44 6 51 63 7 71 5 82 5 9 93 6 9 503 5 7 10 2 5 8 20 3 7 30",
    ": 5 40 5 9 51 8 61 3 5 9 79 83 6 9 94 7 602 4 8 13 20 3 9 32 40 2 6 8 51 4 7-8",
    ": 60 3 6 8 74-5 80-1 8 95 700 2 4 7 12 4 7 9 22 9 36 8 41 4 6-8 51 3 5 7 9 64 6",
    ": 72 7 82 5 7 91 7 802 4 7 10 7 20 9 31 6 9 42 8 54 7 9 61 3 7 70 2 5 7 87 92 8",
    ": 900 5 7 9 12 21 3 8 34 7 40 2 4 7 9 51 4 7 60-1 3-5 8-9 74-5 83-4 7 90 4 6 8",
    ": 10001 3 6 13 5 8 20 3 5 35 7 40 6 9 51 7 61 3 70 5 8 80 91 4 8 101 3 10-1 8-9",
    ": 24 9 31 3-4 8 40 2-3 5 9-50 2 5 7 62 4 73 7 82 6 8 93 5 200 2 5 7-8 10 2 4 6",
    ": 9 22 6 9 31 3 40 2 5 8 51 9 63 82 4 6 92 7 9 302 5 9 13 5 7 22 4 32 5 42 6 8",
    ": 53-4 6 9-60 2 4 6 9-70 4 81 3 8 97 400 3 8-9 11 4 8 21 3 9 31 4 7 40 2 4-8",
    ": 50-1 5-7 9-60 2-3 9 75 7-81 3-91 4-9 501 3-4 6-8 10 4 6-7 9 21 7-9 32 4 6 8",
    ": 40 3 6 8 50 6 8 60 4 74 8 84 7 92 4 6 8 602 4 7 9 11 22 4-5 30 3 5 8 40 3 53",
    ": 6 8 66 8 70 2 5 86 94 7-8 701 4 9 11 4 7 30 5 9 41 3 5 7 53 6 8 63 6 74 8 81",
    ": 3 90 2 6 803 8 12 5 20 5 9 31 4 6 8 40 5 52 5 7 65 7 71 5 8 80 5 7 9 95 901 4",
    ": 7 12 4 7 22 5 30 4 9 42 5 7 9 51 6 9 61 4 7-8 70 2 8 87 90 7 9",
    ": 1002 11 4 7 21 4 32 4 8 40 5 8 51 5 8 61 4 7 71 7 9 81 7 9 92 7 9 103 5 12 5",
    ": 20 2 5 8 32 5 7 40 3 51 5 8 60 2 6 73 85 8 91 5 8 200 6 9 14 7 26 8 31 3 9 42",
    ": 6 52 6 9 63 5 9 72 4 80 2 6 9 95 308 12 5 7 24 9 36 42 4-5 52 5 7 60-1 3 5 8",
    ": 72 4 9-80 3 6-7 90 3 6 405 7-8 15 8 21 8-9 32 6 8 44 52 5 8 61 7 70 6 8 88 93",
    ": 6 9 504 7 12 5 8 21 35 9 42 5 8 50 4 9 62 7 72 4 9 81 4 8 90 2 5 9 601 6-7 14",
    ": 6 9 21 4 9 31 6 42 4 8 50 2 4 6 60 2 7 9 76 8 81 6 9 91 9 702 5 7 9-10 2 5 7",
    ": 20-1 5 30 5 40 2-3 6 52-3 5 8 62 4 70 3 5 84 7 92 4 804 7 9 26 9 33 6 9 43 8",
    ": 51 5 64 6 72 6 85 7 9 92 8 905 9 16 8 27 30 3 8 42 9 51 9 66 8 71 6 9 82 93",
    ": 5-7",
    ": 2002 8 12 5 7 21 5 7 9 32-3 6 41 5 50 2 6 60 4 6 9 79 82 90 4 7 106 9 21 30 6",
    ": 8 45 53 5 60 9 73 82 4 6 8 98 205 8 16 9 22 4 7 30 3 6 40 3 9 58 66 70 6 9 82",
    ": 4 6 90 300 6 18 20 5 7 30 2 4 7 41 3 6 52 4 6 8 61 7 75 7 80 3 5 7 91 406 11",
    ": 4 6 21 6 8 31 4 40 3 6 9 52 5 7-8 63 7 70 3 81 3 6 9 95 7 504 6 14 8 26 30 2",
    ": 5 9 50 3 7 9 64 7 9 75 8 80 2 7 92 6 9 601 4 9-10 3 6 9 24 30 8 40 4 8 53 7",
    ": 60 3 6 9 71 5 8 80 3 9 99 701 4 6 8 11 4 7 20 3 8 30 3 6-7 49 52 4 60 2-3 5",
    ": 7-8 74 80 3 5 8 90-1 3-7 803-4 8-10 2-3 6 8 26 9 31 4 6-7 45 8 51-2 9 61 3 5",
    ": 7 70-1 5 7 80 2 94-5 8 901 4-5 7 9 13 6 20 2 4 8 34 6 8 40 5 7 50 2 5 8 60 5",
    ": 8 74 6-7 80 3 5 8 96 8",
    ": 3002 6 8 14 6-7 9 29 32 4 9 41-2 4-5 50 3 5 62 4 6 70 8 80-1 8-9 92 5 7 9 101",
    ": 4 6 11 5 8-9 24 6 8 31 3-4 6 41 4 7 9 52 4-5 62 4 70 2 9 81 5 7 91 3 200 5 9",
    ": 12 5 8 21-2 4 36 45 7 51 3 6 62 6 70 3 5 8 80 5 96 303 6 9 13 5 25 9 32 7 48",
    ": 50 3 5 8 60 3 6 73 5 7 80 2 4 6 92 5 7 9 401 3 9 12 8 25 30 3 5 8 41 4 8-9 52",
    ": 4 61 3 7 70 2 8 80 3 6 8 91 3 500-1 4-5 7 11 4 9 21 3 6 31-4 6 40 3 6 8 51 3",
    ": 6 8 60 70 3-4 6 82 4 6 92 4 9 604 7 9-10 3 25 7 33 7 42 5 7 50 5 7 60 2 5 8",
    ": 73 5 8 81 4 6 9 96 9 703-4 6 9 13 6 8 21 3 6 9-30 6 40 5 8 51 3 6 69 72 6 8",
    ": 83 6 90 3 800 2 5 8 12 5 20 2 5 9 33 6 8 40 2 5 7 50 6 9 62 5 7 72 5 8 80 2",
    ": 4-5 9-90 3 6-8 900 3 7 13 7 20 2 7 9 32 6 43 5 50 5 7 9 61 4 7 9 71 4 7 81 3",
    ": 90 3 6 8",
    ": 4003 13 5 7 24 7 34 8 43 5 7 9 51 61 4 77 9 82 6 9 95 9 104 12 4 6 21 9 32 8",
    ": 40 2 5 7 50 3 5 7 61 4 9 71 5 7 80 2 5 90 6 201 4 7 14 6 8 22 4 6 9 34 7-8",
    ": 40-1 3 6 51 3 8 61 4 6 72 4 7 9 81 3 6 8 90 5 7 9 301 4 6 8 12 9 21 3 9 33 6",
    ": 46 54 6 8 63 70 2-3 5 7 83 6 90 2 5 7 401 11 3 5 7 25 31 4 42 5 7 9 52 6-7 62",
    ": 9 72 5 9 84 8 90 3 9 501 4 10 20-1 9 32 5 46 52 4 7 62 7 75 92-3 5 7 605 8 10",
    ": 3 6 9 24 34 7 43 5 8 53 5 7 9-60 4 70 81 91 4 8 702 4 7 10-1 4 20 2 6 8 33 8",
    ": 43 53 6 8 60 5 7 71 3 7 80 5 94-5 9 802-3 13 5 8 21 6 9 31 3 6 43 6 51 8 61 4",
    ": 8 70 5 83 6 95 7 903 6-7 9 12 4 7 23 6 31 4 9 43 5 51 63 5 73 5 7 81 3 9 91 4",
    ": 6 8",
    ": 5000 4 10 8 32 6 40 5 7 9 51 4 63 78 81 6 9 91 5 9 102 5 14 6-7 9 21 3 7 31 7",
    ": 40 2 8 51 4 6 65 8 70 2 6 83 6 9 91 3 202 4 8 10 3 5 34 6 41 4 6 9 51 6 62 4",
    ": 8 71 4 7 9 82 6 9 91 3 5 301 3 5 13 7 9 21 5 31 4 44 7 50 2-3 6 9 64 7 70 2",
    ": 96 9 401 4 8 11 4-5 8 20 2 6 34 7 42 5-6 51 67 70 2 5 81 4 9 92 7 9 507 11 5",
    ": 7 9 22 5 8 33 5 8-9 41 3-4 7 9 53 7 9 62 9 73 7 83 90 2 5 600 3-4 7 10 3 21 4",
    ": 30 6 43 50 9 62 5 70 2 5 7 9-80 6 9 92 7 701 6 11 4-5 8 21 4 8 31 5 7 40 2 4",
    ": 6 55 62-3 5 71 5 9 84 7 97 805-6 10 5 8 27 30 3 6 8 43 6 9 52 4 7 65 7 9 72 6",
    ": 80 9 92 7 900 5 7 11 3 5 22-3 34 9 47 9 57 60 7 71 3 6 9 89 92 5",
    ": 6000 3 10-1 3 5 8 21 7-8 31 47 9 52 4 7 62 5 8 71 4 6 9 83 5 8 91 3 6 100 2 7",
    ": 9 14-5 24 7 32 8 40 2 6 52 7 62 6 74 7 9 81 6 8 91 3 8 200 4 7 9 13-4 21 6 34",
    ": 40 6 52 60 2 7 74 6 8 81 5 7 90 7 302 19 21 4 31 9 42 52 4 8 60 4 6 9 73 80 4",
    ": 6 92 5 403 5 12 6-7 24 6 9 32 5 7 43 5 50 2 61 4 6 71 4 6 8 86 94 6 504 11 5",
    ": 7 22 31 5 7 46 56 60 3 9 71 4 7 83 5 8 91 5 605 7 10 5 7 24 7 9 31-2 5 7 41 9",
    ": 54-5 67 70 6 81 4 7 93 6 8 701 4 11 4 28 31 5 40 3 6 51 4 7 9 63 6 9 72 5 83",
    ": 5 92 4 8 807 10 2 5 7 20 4 7 9 33 9-40 2 6 8 51-2 60 3 6 71 5 9 83 91 901 3 6",
    ": 10 3 9 27 38 41 3 9 54 8 61 4 7 9 74 9 82 8 91 6 9",
    ": 7002 4 7 9 13 6 22 7 30 4 7 48 52 4 7 9 62 4 7 70 3 6 9 82 4 94 9 102 5-6",
    ": 9-10 3 6 8 20 8 39 50 2 6 64 9 71 3 7 82 8 90 2 8 203 9 13 23 6 32-3 9 45 55",
    ": 7 60 5 75 7 9 81 6-7 9 92 6 300 8 13 6-7 22 5 7 9-30 2 5 7 40 4 7 51 5 8 61 3",
    ": 9 72 4 83 8 93 402 11 7 26 9 32 4 42 4 6 8 50 6 61 4 9 71 4 6-8 81 5 7 92 5",
    ": 501 3 9 11 5 20 5 7 9 32 4 6 9-40 5 7 50 6 60 5 75 8 80 3 6 8 90 2 5 8 603 8",
    ": 16 8 24 6 8 31 4 6 9 41 3 50 60 70 7 80 2 6 9 92 4 6 9 703 6 10 22 4 35 9 45",
    ": 8 57 69 75 86 9-90 3 6 804 6 9 13 5 8 24 7 31 3 8 41-2 55 9 63 8 75 7-8 80 2",
    ": 5 7 9 91 3-4 8 905 8 10 2 6 8 21 3 5 7 9 33 5 7-8 42-3 6 8 55 8 60 71 3 5 8",
    ": 84 7 90 2 9",
    ": 8002 11 5 7 9 22 5 8 36 9 42 7 51 3 5-6 9 63 6 8 71 5 81 7 9 93 7 102 4 8 11",
    ": 3 6 20 3 5 7 9-30 3 45 7 9 52 4 6 8 60 3 5 71 3 5 8 80 6 8 90 3 7 202 12 4 7",
    ": 9 21 4 7-8 31 4 6 9 41 4 6 50 2 5 8 62 4 70 2 5 8 82 4 7 90-1 4 305 9 12 5 7",
    ": 20 3 30 2 5 7 46 9 51 5 7 60 5 76 8 80 2 5 8 400 5 15 7 20 6 36 8 40 2 52 7 9",
    ": 61 4 6 71 3 6 8 81 6 8 97 505 10 2 4 8 20 3 7 30 3 6 41 4 7 52 5-7 62 5 7 9",
    ": 74 6 8 89 93 600 5 7 10-1 4 6 33 7 9 48 51 4 6 9 63 5 70 9 82 90 2 7 702-3 8",
    ": 11 8 21 4 32 6 9 41 8 56 8 61 70 3 8 80 8 93 7 802 5 7 9 12 6 8 21 4 6 9 33",
    ": 43 5 53 5 7 9 62 4 9 71 3 5 7 80 4 94-5 904-5 12 21 4 8 37 9 42 6 8 52 6 8 61",
    ": 9 71 4 7 81 3 92 5 7",
    ": 9000 4 8 10 3 6 9 24 6 34 7 9 41 4 7 9 58 67 70 3 5 9 81 3 90 2-3 9 104 12 5",
    ": 7 21 3 9 31 3 41 6 54 7 63 5 8 71-2 7 9 82 4 7 9 91 5 8 204 7 9 11 5 21 6 31",
    ": 41 3 7-8 54 61 4 7 9 71 4 7 80 2 4 6-8 92 4 9 303 8 10 3 5 21 3 6 33 6 46 52",
    ": 68 74 6 8 93 7 408 12 4 7 9 21 7 32 4 6 8 44 50-1 7 9 62-3 5 70 2 4 6 8 80-1",
    ": 5-6 95 8 501 8 13 8 38 51 4 7 62 5 7 70 5 81 5 8 91 4 7 600 8 13 7 23 34 6 9",
    ": 41 3 6 56 8 81 5 8 94 701 3 6 9 15 8 28 34 8 40 3 6 51 3 5 9 63 7 70 2 5 80 5",
    ": 8 92 4 7 9 802 4 7 10 2 5 7 20 4 7 32 8 43 6 50 5 70 7 81 4 911 5 9 21 6 9 32",
    ": 4 40 9 52 4 6 60 3 8 80 95 8",
    ": 20000 5 7 11 4 9 25 7 9 36 40 59 76 80 8 90 3 5 8 110 26 8-9 32 4 7 40 2 7 51",
    ": 68 72 5 8 80 3 5 9 97 203 6 9 12 25 8 30 40 6 9 53 6 9 65 74 7 85 8 91 3 5",
    ": 306 8 10 3 6 8 20 9 37 9 48 51 4 7 64 8 72 81 4 8 98 401 3 9 11 5 7 9 23 5 32",
    ": 4 43 5 7 60 2 5 72 4 85 8 96 9 502 4-5 8 11 5 22 4 31 7 43 9 57 9 62 4 6 8 71",
    ": 3 5 9 82 5 8 91 9-600 2 4-5 7 14 9 21-2 5-6 30 3 5 8 40 3 8 51 4 6 70-2 4 8",
    ": 83 6-7 90 2 4 700 4 6 13-4 6 8 25 7-8 31 6 8 41 6 69 71 6 9 85 92 9 808 11 8",
    ": 22 5-6 9 32 5-6 8 41 4 6 52 7 68 78 80 91 5 7-8 900 2 6 9 19 22 4 7 30 5 42 5",
    ": 8 50 2 4 7 65 7 75 7 9 86 8 90 3 5",
    ": 1000 3 5 8 11 5 9 22 5 7 30 5 8 41 4 6 50 2 4 6 8 62 4 71 3 5 80 3 5 8 90 4 7",
    ": 100 5 7 13 6 9 27 32 6 40 2 7 51 3 6 8 60 2 6 75 7 9 85 8 92 5-6 9 204 11 6",
    ": 25 7 41 4 6 9 54 7 9 65 7 71 3 9-80 2 4 9 94 301 3 6 8 12 5 8 24 9 32 8 40 3",
    ": 5 9 52 4 7 63 6 9 72 7 9 84 93 5 8 400 7 20 4 6 8 32 40 2 50 4 7 66 72 5 85 7",
    ": 9 92 6 9 504 6 10 2 5 7 20 2 8 30 5 7 40 2-3 6 50 5 9 62 5 8 75 7 80 2 5 7 94",
    ": 7 602 5 11 4 21 30 5 42 4 6 9 51 3 5 7 60 8-9 71 3 5 9 81 5 7 92-3 6 9-700 3",
    ": 9 11 3 5 9 22 4-5 30 3 8 40 3 5 8 50 2 5 60 2 70 3 5 7-8 83 5 91 4 7 9 801 5",
    ": 7 9 12 6 8 21 5 8-9 32 5 8 40 4 50 9 63 7 71 9 81 8-9 91 900-1 4 6 15 8 22 7",
    ": 38 40 2 6 9 54 6 60 4 71 9 81 90 7",
    ": 2000 3 5 9 12 21 6 31 44 62 9 79 82 4 6 9 92 4 6 8 104 11 3 26 8 33 6 8 42 50",
    ": 3 6 9 62 7 9 71 7 86 9 91-2 200 2 6 10 20 6 32 41 6 8 54 8 65 8 73 6 85 7 9",
    ": 96 9 301 4 7 10 5 21 3 7 33 5 42 5 8-9 52 60 6 71 3 7 80 2 5 8 92 8-9 401 5 8",
    ": 11 5 22 7 9 32 4 6 43 7 9 55 8 60 5 9 72 4 7 80 91 4 6 8 500 6 8 11-2 7 9 23",
    ": 6-7 9 31 3 9 41 3 5 7 9 53 5 8 61 3 9 71 7 9 81 95 7 606 9 12 5 27 9 32 4 6",
    ": 40 2 4 50 2 4 64 7 9 76 8 81 3 94 7 9 702 4 7 11 5 20 3 7 9 31 6 45 8 54 68",
    ": 75 81 9 93 5 7 800 5 13 8 20 3 7 34 7 9 51 6 8 65 8 72 4 83 6 8 93 5 7 902 5",
    ": 8 10 3 5 7 9 21 4 7 41 4 6 9 52 5-6 62 7 9 74-5 7 80 2 7 91 3 6 9",
    ": 3004-5 20 3 30 8 42 4 6 9-50 2 7 60 3 73 6 9 84 6 9 93 6 8 103 8 10 4 7 32 4",
    ": 42 4 9-50 60 7 9 77-8 82 4 8 91 3-4 6 8 203 5 7 9 14 6 9 21 3 8-30 2 5 44 6",
    ": 50 3 6 8 60 3 6 71 5 80 7 9 91 4 6 306 8 18 20 4 8-9 40 3-4 9 54 8-9 61-2 6 8",
    ": 70 2 4 84 6 9 93 5 9-400 3 8 10 6 21 4 39-40 7 50 2 4 8 60 6 72 4 9 82-3 7 9",
    ": 94 8 503 10 6 8 20 3 6 31-2 4 42 6 9 53 9 62 5 8 70 2 7 9 81 3 5-6 8 90 4 7 9",
    ": 601-2 6-7 12 4 6 9 29-30 2 8 40 2 4 64 7-8 73 5 7 80 5 91 8 701 3 7 10 2 6-7",
    ": 20 2 5-6 9 31 4 7 9-40 3 6 9 51 3 6 62-3 71 6 8 83-4 8 94-5 801-2 15 7 20-3 9",
    ": 33 9 46 9 54 6 8 64 74 7 80 2 6 8 92 8 901 4 7 9 11 4 9 21 4 6 9 34 44 6 8 50",
    ": 3 6 9 61 7 9 80 3 91 4 6",
    ": 4001 4-5 7 10 4 7 9 22 4 35 40-1 7 9 53 7 61 3 6 71 8 82 5 9 93 106 20 4 8",
    ": 32-5 7-44 6-8 50-6 8-9 63-4 6-7 9-71 3-4 6-82 4-5 7 9-90 2-3 6-7 9-202 4 6",
    ": 8-16 8-9 22-8 31 3-6 9 41-5 8-52 4 6 9-61 4-8 70-1 3-5 9 82-5 7 9 91 3 5-8",
    ": 301-3 5-6 10 2-7 21-3 5-30 3 5 7-8 40 4 6-52 5 8-62 5-8 74-80 3-91 3 5 8-9",
    ": 401-10 2-7 9-25 7-8 31-2 4-7 40 2 4-6 9-53 5-6 8-9 61 4-5 7-8 70 4-82 4 6-7",
    ": 90 2 4-5 500 2-6 8 11 4 7-20 3-4 7-32 4 6 40-5 7-50 5 7-8 62-5 7-72 4-8 80",
    ": 2-3 5-8 90-2 5 7-9 601 4 7-10 4-21 3 5 7-8 30-7 40-2 5-6 51-4 6 8-62 4-9 71-6",
    ": 8-80 9 91-3 5-9 701-2 4 6 8 10 2-4 6-7 9-20 2-35 7-46 8 50 2-3 5-7 60 5 9-71",
    ": 5 9-84 6 92-4 6-804 6-7 9-11 4 7 9-20 3-4 6-33 5-9 41 3-51 4-64 8 70-3 6-8 80",
    ": 2-4 8-91 3-6 8 901-3 5-8 10-5 8-20 3 5-6 9 31 3-4 6-9 41 4-51 4-7 9-60 5-7",
    ": 9-71 3 7 9-86 9-94 6-8",
    ": 5000 2-5 7-11 3 5 7-25 9-30 2-3 8 40-2 4-50 3-69 71-7 81 3 5-91 4-6 8-100 3-4",
    ": 6 8-10 2-3 7-9 21-6 8-30 3-44 7-8 51 5-6 8 60-3 5 70-5 7 9-81 3-4 6-8 90-2 5",
    ": 8-9 201 3-4 6-7 9-12 6-20 2 4-5 37 9-41 3 5-50 2 4-7 60 2-9 72 80 3-6 8 91 3",
    ": 5-7 9-300 2-11 9 21 6-9 34 6-7 9 45 7-50 3 6 8-9 62-7 9 72 5-6 9 82-91 4",
    ": 8-401 3-6 9-14 8 20 3 5-6 8-33 8-41 3-4 6-7 9-51 3-4 6-60 3 7-70 2-3 6 8-82",
    ": 5-95 7 9 502-7 11-4 8-21 3-5 8-30 2-9 41-57 61 4-5 70 2-3 5 7-80 2 5-93 9 601",
    ": 3-4 6-7 9 12-5 7-8 25-6 8-9 32-4 6 8 40-2 4 6 8 53-4 8 61-4 8-75 7 9-80 2-6 8",
    ": 90-2 5-8 701 4 7-9 11 3-5 7 20-4 7 9-30 2 6-48 51-3 5 9-63 5 7-9 75 82-7 9-90",
    ": 2-4 8-9 802-6 10-20 2 4-6 8-9 31 3-40 3-5 9 51 4 6 8 60-2 5-7 9 72 5 8-80 3-6",
    ": 91 4 6-7 906-7 11-6 8-21 3-6 8-9 31-2 4-7 40-3 5-51 4-7 60-71 4-5 81 5-6 8-90",
    ": 2-3 5",
    ": 6000 3-8 11 3-4 6-25 7 33 6-7 9 41 4 6-51 7 60-8 73 5 7-80 3-9 91-5 7-100 2-3",
    ": 6 8-10 2 4 6-22 4-5 9-35 7-8 40-3 5-7 52-5 7 60 2 7 9-70 2-9 81-6 9 95-6",
    ": 9-203 6-11 3 5-7 9-20 2-6 9 31-4 7 40 2-9 51-5 8-60 2-5 7 9-72 5 7-8 80-1 5 7",
    ": 9 91-6 8-9 305-6 12 4-29 31-3 5-8 40 2-3 5 8-9 51-4 7-60 2 4 8-9 75 8-81 3-5",
    ": 7 9 92-5 7 9-407 9-11 3-4 6-8 20-1 3-4 6-8 30 2-3 5 7 9-46 8 50-5 7-67 9 71-4",
    ": 6-8 87-91 3-4 6-500 2 4 7 10 3 5 8-33 6-9 41 3-5 9-54 6-66 9-70 2 5 7-81 3 5",
    ": 7-95 7-603 5 7-17 9-23 5-30 2-44 7-8 50-7 61-5 8-9 72-7 80 2-5 7 90-2 5-702 4",
    ": 6-7 9-22 4-8 30-1 3-6 40-2 5-7 9 53-4 8 61-2 6 8-72 4 7-80 3-4 6 8-91 3-4",
    ": 9-802 4-5 7-9 11-6 8-9 21-4 6-8 31-5 7 9 41-2 4 6-57 60-2 4 7 9-75 7 9 81-4",
    ": 6-8 90-3 6 8 900-1 3-13 5-21 3-30 2-6 40 2-4 7-8 51 3-8 61-9 72 5 7-81 3-6 8",
    ": 91-7",
    ": 7000-3 5-11 3-23 5-9 31-4 7-8 40-7 9-55 7 9-60 2-6 8-72 4-81 3-92 4-100 4 7-9",
    ": 11 3-21 3 6 8-9 31 3 5-6 8 40-3 5-57 9-73 6-82 6-7 9-93 5-7 9-213 7 9-24 6-30",
    ": 4-8 41-53 6-9 61-4 6-7 71 3 5-8 80-2 4 6 90 4 6 9-302 5-8 10 2 5-6 8-9 21-4",
    ": 6-7 32 5 7-9 41-3 7-9 51-3 5 7-65 9-72 8-9 82-3 6 9 91-5 9 401-4 6-9 11-9 22",
    ": 4 6-31 3-8 41 5-9 51-2 4-5 7 9 61 5-6 8 70-2 4 7 9-81 3-6 8-9 92-3 6-8 500-4",
    ": 6-12 5-7 9-26 9-31 3-8 40-1 3-7 9-52 4-5 7-8 61 3-5 7-8 70 2-81 3-5 9 92 4",
    ": 6-7 9-603 5 7-11 3-4 6-24 6-32 4-7 9 42-6 8-53 6-7 9 61 3 6-70 2-3 5-95 7-703",
    ": 5-12 5 7-21 5 8-30 3-5 8-40 2-6 53-8 60 3-7 9-70 2-8 80-3 8-91 5-6 8 802-3 6",
    ": 8 10-1 3 9-20 4 6-8 31-3 5 9-44 6 8 50-1 3-7 9 64-5 70 6-9 81 3-6 9 91 3-5 7",
    ": 9 902-6 9-11 3-5 7-9 21 4-7 9-30 3 5 7 41 4-7 50-61 6 8-9 73-4 6-80 3 6 9-90",
    ": 2-3 5-8",
    ": 8000-1 3-11 4-6 8-9 23 8-32 6-40 3-6 8 51-3 5 8-66 8-72 4-8 81 3-5 8-9 91 3",
    ": 5-101 3-5 7 10-1 3-5 7-22 4 6-8 30-2 4-9 42 4-5 7-9 52 5-7 9-67 9-71 3-7 9-82",
    ": 7 90 2-4 6-7 9-200 2 5-6 8 10-3 6-9 21 3 36-7 41-3 5 7-8 50-1 3-4 6 8 60 5",
    ": 8-9 71-5 7-80 2 4-90 2-7 9-300 4-6 12-6 8 22-3 5 30-2 4 6-7 9-42 6 8-50 2-4 7",
    ": 9-65 8 70-4 6-7 81-4 7-8 90 2-5 7-402 4-8 10-4 6 20-2 4 6 30-1 5-9 42-4 8-9",
    ": 51-6 8-62 9 71-2 4 6-80 2-94 7-9 502 4 7-13 5-23 6-32 4-7 40 2-4 8-51 4 6-63",
    ": 7-8 70-1 4 6-80 2-5 8 94-7 9-600 3 5-6 8-14 6-9 21-9 32-3 7-45 7-50 2 4-7 61",
    ": 3-4 7 9-72 7 9-82 4-91 4-6 700-1 3-4 7-8 11-2 5 7 9-22 4 7 9-30 3 5-6 9-42",
    ": 5-8 50-2 4 8-60 4-74 6 80-92 4-6 9 801-9 14-5 7 9-21 3-4 7-30 3-6 8 40 2-3",
    ": 7-9 53-61 3-5 70-1 4-5 7-8 82-4 6-8 91-2 5-7 9-901 3-5 7-8 10-2 5 7-8 20 2",
    ": 4-7 9-34 6-8 40-1 3-6 9-50 2 4-5 7 9-60 2-75 8 82-6 8-95 7-8",
    ": 9000-4 6 8-18 20-4 7-9 33-4 40-2 4-5 50-6 8-9 63 5-7 9-77 9-81 4-6 9 91-6 8",
    ": 100-2 5-7 9 14-8 20 2-4 9-32 4-45 7-52 4-6 60 2-6 9 71 3-4 80-1 3 5-7 90 2",
    ": 4-6 8-200 5-6 11-2 4-5 7-22 4 7-31 4-9 41-52 4 6-62 4-5 9 72-5 7-87 9 91-6",
    ": 8-301 3-5 7-14 6 8-24 7-32 4-8 42 4-51 4 6-8 60 2-5 7-9 72-7 80 2 5-6 9-90",
    ": 2-3 5 7-8 402-3 6 8-10 2-3 6 8-20 2-7 9-33 5-9 41-2 5 7-51 4-5 7 9-62 4 6-7 9",
    ": 71-82 5-9 94 6-7 500-4 6-8 10-4 6-21 3-4 7-8 30-4 6 8-9 42-3 6 8-54 6-7 9 61",
    ": 3-6 8-9 72 4-6 8-9 81-94 7-9 603-4 7-10 4-20 3-36 41-2 5-51 3-9 61-4 6 8-70 2",
    ": 5-80 2-6 90-2 4 701-4 8-13 6-20 2-3 7-9 31-3 5-7 9 42-3 6-53 60 2 4 6-9 71",
    ": 3-81 3-6 8-94 6-7 9-802 4-8 11-3 5-24 6-37 9 41-2 5-8 50-2 5-8 60-1 3 5-6 8-9",
    ": 71-3 5 9-80 3-4 6 9 91-5 7-900 3-5 7-12 4-8 20 2 5-6 8-9 31-2 4 6-8 41 3-6",
    ": 8-9 51-8 60-4 6-8 70-5 7 9-80 3-4 7-93 5-6",
    ": 8-30003 6-7 10-5 20-4 6-8 30 2 7-9 41-3 6 8-50 2-7 9 62 7-70 4-7 9-83 5-9",
    ": 91-4 6-7 100 3-4 6-9 11 3 5-6 9-21 4-9 31 3 5-6 8-41 4-5 7-8 50-6 8-63 5-8",
    ": 70-4 6-83 7-9 92-7 9-202 4-5 7 9 11-5 7-8 20 2-35 7-43 5-52 5 8-9 62-3 5 70",
    ": 2-7 9-81 3-6 8 90-3 5 9-302 4-6 10 2 6-7 20 2 4 7-9 31 4 6 8-42 4 6-8 50 3-7",
    ": 61-4 7 70-4 6-8 80-1 4-9 91 3-4 6 8-400 2-5 8 10 2 4 6-7 9-21 3 6 8 30 2-3",
    ": 5-6 8 41-9 51-4 6-62 4-6 8-70 2-8 80-2 6-90 3-4 6-503 7 9-10 4 6-9 21-3 6-31",
    ": 3-5 7-9 43-4 6 8-52 7 9-61 4-5 7 9-74 7-80 3-4 7-90 4-6 8-600 2 4-6 9-14 6-25",
    ": 7-33 7 40-2 6-8 50-1 3-7 61-4 6 8-9 71-3 5-84 6-8 91-2 5 7-701 3-5 8-9 11-5 7",
    ": 9 21-4 8 30-3 5-7 40-2 5 50 3 5-6 8-61 3-7 9 71-6 8-9 81 4 6 9-91 3-800 2-7",
    ": 10-7 9-22 4-7 9-37 9-45 8-59",
    "special2 CAF+7 embl_tpa_tsa_prot",
    ": 6566846-7 50 2 5-6 8 60 3 5-9 72-8 81-3 5 7 9 91-2 8-9 902-6 9 14-9 22-3 5-6",
    ": 8-32 5-40 2 4-6 8-50 5 7 9-61 3 5 7-74 6-80 2-5 7-90 3-4 6",
    ": 8-7003 8 10 2-7 9-20 2-3 6-8 31-2 4-40 3-9 51-3 5-6 8-61 3 7 9 71 4-9 81-2",
    ": 5-6 8-9 92-5 7-8 100-4 8-16 8 24 6-7 9 34 6-7 40-6 51-3 5-8 61-2 5 7-8 70-3 5",
    ": 8 80 2 4-7 90-1 4 6-7 200 2 7-9 11-4 7 20 2 6-8 30 2-3 5-8 40-1 3-4 53-5 7-8",
    ": 61-4 6 8 74 9-82 4-5 7-9 91 6 9 301 3 5-7 13 5-6 21-3 8-31 7-44 6-7 52-6 8-63",
    ": 5 74-5 81 4-7 9-91 3-7 9-404 8-9 11-4 8-9 23 5-8 31-3 5-8 42-6 9-50 2 5-60",
    ": 2-3 5 7-8 70-1 3-5 80-1 3-8 90-2 4-6 8-500",
    ": 770526-7 30-2 4 6-7 9-40 2-4 7-8 50-2 5-6 9 61-3 5-8 72-5 7-8 80-3 6-8 90-3 7",
    ": 9-603 5 8-10 3-5 7 22 4-7 9 31-4 6-8 41 3-5 54 65 7-71 4-7 9 82-3 7-8 91 3-6",
    ": 9-700 6 8-10 3-7 21-2 4-6 8 30-6 9 41-3 5 8-52 4-5 7-61 3-4 6-9 71-4 8-80 2",
    ": 4-8 92 4-6 8-802 4-9 11 6-8 22-6 8-30 2 6-8 40-56 8-60 2-6 9-70 2 4-82 5-6",
    ": 90-1 3 5-6 8 901-4 6-10 2-3 5-9 22 4-8 30-1 6-40 2-5 7-9 51 4-5 8 60 3-4 8-9",
    ": 71-4 6-82 4-8 91-5 7 9",
    ": 1001 3-5 9 13 5-6 8 21-3 5-6 33 5 9 41-8 50 3 5-9 62-3 5-8 70-1 5-7 81 4-5",
    ": 7-92 4 7-9 101 3-4 6 9-12 4-5 7 9-21 5-7 9-32 4-9 43-8 50-1 3-7 9-61 3-5 8-9",
    ": 71-2 4-6 8 80-3 5-8 90 3-4 7-8 201 3-4 7-9 11 5 7 9-20 6 9 31 5-6 8 40-2 5-8",
    ": 50-1 3 6 8 62 5-8 70-2 4-7 82-4 6-9 91 6 8 302 4 6-8 10-2 4-8 21-3 8-30 2-4 6",
    ": 8-41 3-6 9 52 4 6-7 9 61 3-7 70 2-5 8-85 7-8 90 2-4 7-403 6-9 11-2 4 6-8 22",
    ": 6-7 9-31 5-7 9-42 5 7-8 51 3-4 7 9-60 2-5 7-8 73-6 80-4 8 90-1 3-506 8-9 11-3",
    ": 6-7 9-20 2 6-31 3-8 40 2-4 6 50-8 63 5-70 3-6 8-86 8 92 4 7 9-600 3 5-7 10-2",
    ": 5 7-22 4-7 9-33 5 7-8 40-2 4-7 51-2 4 9-62 4-9 72-3 5-7 9-83 6-7 9-90 2 4-5 7",
    ": 700-1 3-8 11 3-5 7-8 21-34 7-8 40-2 4-5 7-51 3-6 9 61-2 5-9 73 6-83 6-8 90-1",
    ": 5 8 804 6-8 10 2-5 7-9 21-3 7 30-2 4 8-41 3-5 7-53 5-64 6-7 9 73-83 9-92 6-7",
    ": 9-903 6-8 11-7 9 21-4 6-30 2 6-7 9-40 2-3 5-9 51 3-4 7-63 8-9 71 3 6-7 83-7",
    ": 92 4 7",
    ": 9-2001 6 9-16 21 5-8 30-5 9 41-4 6-7 9-58 61-2 4-5 7 73 5 7-89 91-6 8-100 4-8",
    ": 10-6 8 23-4 6-7 9-32 4-8 40-2 5 7-53 5-61 3 5-7 70-1 3 6-8 84-5 7 9 91-2 4 7",
    ": 9-205 7-9 11-4 7 20-8 30-3 5-6 8 40 3-4 6-7 50 3-4 6 8-60 2-6 70 3-5 9-83 6-7",
    ": 9-95 301-2 4 8-14 7 9 21-3 5-7 30 2 5-6 8 40 3-8 50-1 3 6-7 60-3 5-9 72 6-80",
    ": 2-3 5-6 9 93 5-8 402 7 9-13 5-8 20-1 3 6 8 30-1 6-43 6 50-1 3-6 8 60 2-3 5-7",
    ": 70 2-3 7 80 2 5-6 8-90 5-6 8-9 501 3-6 8-9 11-4 7 9-22 4 7 9-32 4 41 4-7 9 52",
    ": 5-7 9 63-5 7-8 70 2-4 6-7 80 3-5 7-8 91-5 8 600-1 3 5-6 8 10-5 7-8 20-4 7",
    ": 9-31 3 5 7 40-1 4 6-54 7 60 2 4-8 72-6 9-82 4 8-92 6-9 701 5 7-17 9-22 5 7",
    ": 9-38 40-1 3-7 9-53 5 7-8 62-4 7-71 4 6-81 3 5 90-1 5-801 3-4 6 8-11 5 7 9-20",
    ": 2 6-7 9 31-3 6-8 40-2 7 50-5 8-61 5 7-8 70-4 8 80-4 6-91 3 5-8 900-3 5-6 10-5",
    ": 7-8 24-6 30-2 4-7 9-42 4-6 8-51 3-4 6-7 60-1 3-7 70-1 4 6-8 81 7 90-1 3-4 6-8",
    ": 3000 2-3 7-8 13 7-8 20 2 9 31 3-4 6-7 40-1 3-5 7 51-4 8-62 4-6 8-70 3-80 2-4",
    ": 7-90 2-3 6-9 104-8 10-2 5-7 20-6 9-32 4-6 8 42 6-7 9 52 5-60 4-8 70-1 3-5 7-9",
    ": 85 8 90 3-4 7 200 3-4 8-9 12 4 6-7 9 21-2 4-6 8 30 2-4 7-41 5-50 6 61 3 5 7 9",
    ": 71 6-7 9 81-2 4-6 8-90 2-5 7-9 303-7 9-11 5 7-8 20 2-3 5 8 31 3 5-7 9-43 5",
    ": 7-50 2 4-5 7-64 7 9-70 3-5 9 81-3 5 7-9 91-3 5-7 9-400 4-5 13-4 6 8 21-2 4 6",
    ": 8-34 6-7 40-1 3 5 7-54 7-62 5-7 72-83 5 7-91 4-6 501-12 4 6 8-9 21-4 7 9-30 2",
    ": 4 6-8 41-3 7-8 52-8 61-6 70-4 6-8 81-4 7 91-6 601-2 4-7 9-11 3-20 2-6 8-32",
    ": 4-6 8-40 3-5 8 50 2-61 3-9 72 4-5 7 80-2 5-6 8 90-2 5 8-9 701-4 8-9 12-7 20-3",
    ": 6-30 2-3 5-7 9-42 4-5 7 50-7 9-60 3-8 73-6 8-81 4-7 9-93 5 7 9 801-3 5-6 8-10",
    ": 2-3 5-7 9-24 9-37 9-40 3 5-7 50-7 9-60 2-5 7-8 70-2 4-9 82-6 8-9 93-5 7-901",
    ": 3-7 11 3-7 9-20 2 4-5 7-30 2-3 9-40 2-5 7-8 50-3 6-62 7-71 4-5 7-8 80-2 6-8",
    ": 90-3 5-7 9",
    ": 4001-5 7-12 4 6-8 20-3 5 9 32 4-5 7-42 5-7 50 2 5 7-60 3 5-6 8-72 4 7-8 84-6",
    ": 9-90 2-5 8-100 3-5 8-10 3-5 8-22 4 7 9-31 3-6 8-43 5-6 8-9 53-6 8-62 6-76",
    ": 9-81 3-5 7-8 91-5 7-9 201-7 9-16 9-22 6 8-32 4-7 9-40 2-4 9-50 2 6 8 60 2-3 5",
    ": 70 2 5-80 4 6-90 2 6-300 6 8-10 4-5 7-9 21 5-30 4-6 8-40 2 4-5 8-50 3-5 7",
    ": 9-60 2 4-5 7 9 73-7 80-3 5-8 90-1 4-5 7-402 4-5 7 12-3 6 8-20 2-3 5-9 31-9",
    ": 41-2 5-8 52-3 5-7 9-61 4-5 70 2 4-5 8-83 5 7 9-91 3-8 502-3 5 7 9-11 4-6 8 24",
    ": 6-30 2-7 9-40 6-7 9 54-5 9-72 4-80 5 7 91 4-5 9 601 3-7 9 11 5 7 9 21-5 7-8",
    ": 30-7 9-42 5-6 50-1 3-5 7 9-61 3-4 7-9 77 9 81-2 6-8 90-1 3 5 7 9-702 4-6 8-10",
    ": 3-6 8-9 21 3-7 9-30 2-5 8-9 42-3 5-9 52-3 5-60 2 5 8 70 2 4 6 8-9 81-6 8-9",
    ": 91-7 802-5 7-10 2-3 5-8 22-8 30 4-5 7-42 5-6 8-52 4-5 7 9-62 6-7 9-73 5-7",
    ": 80-2 4-5 7 90 2-6 900-3 6-10 5 8-25 7-8 31 4-6 8-9 41-2 4 7-53 5-8 63 5 7",
    ": 9-71 3 5 7-9 81 4-6 8-93",
    ": 5-5000 3-14 7-21 4-5 7-9 34 8-9 42-5 9-53 60-1 3-8 70-5 8 80-4 8 90-102 5 7-9",
    ": 16-7 20-1 7-9 32-3 7-9 41-2 4-56 9-68 70-2 6-8 80-2 5-7 91-2 5-6 203 5-8 10-1",
    ": 3-5 7 9 21 4-5 7-31 3-7 9 41-2 4 6 8-55 7-9 63 5 70 2-5 7 9-80 5 7-91 3 5-6",
    ": 8-9 301-2 4-6 8-9 15-7 21-6 9-31 3-4 6-8 40 2 4-5 7 9-51 3-5 7 9 61-72 4 6-7",
    ": 9-81 3 6-7 90 2-6 400-1 3-5 8-9 12-3 5-7 9-22 4 6-8 30-4 8 41-2 4-5 7 53-5 7",
    ": 9-60 2-4 6-71 3 5-7 81-3 5 8-92 4 9-502 4 6 8 10 4-6 9-24 6 8-35 8 40-50 2 5",
    ": 7-60 2-3 7-9 71-5 9-84 8-90 2 5-6 9-600 2-5 9 15 7 9 21 5-6 9-30 2-6 8 40-1",
    ": 3-4 6-8 50 3 6-7 9 62-3 5 7-8 74 6-7 9 81-5 7-9 92-3 5 7-700 2-4 6 10-6 9",
    ": 21-2 4-8 31 4-5 7 41 3 6 8 51-6 9 61 3 7 9-71 6-7 9-81 4-8 90-2 4-5 8-804 6",
    ": 9-11 4-5 8 20-5 9 31-3 6 8-9 43-5 7-8 50-1 3-5 7-9 61-4 6-7 72-6 82 4 6-7",
    ": 90-1 3 5-6 9-901 5-11 4-20 2-4 6 9-30 7 42 5-8 55 7-61 6 8 72-3 5-6 8-9 81-3",
    ": 5-8 90 2-3 7-9",
    ": 6001 3-4 6 9 12-3 5-7 9 22 4 6 8 30-3 6 8 40 2 4 6-9 52-5 7-9 62-3 5-7 9 71-2",
    ": 4-6 80-1 3-4 7 90-2 4-100 2 4-7 9-11 3 5-6 9 21-4 8-30 2 4-5 8-40 3-5 7 9-50",
    ": 2-3 5 7-8 60-1 3-4 6 72-5 7 80-1 3-4 6-9 92 4-5 201-2 4-5 8-10 2-3 7-9 22-3 7",
    ": 30-6 8-40 2-5 50-5 7 9-64 6 8-71 4 8 80 7-91 4 6-9 302-5 8-13 5 8-20 2-6 30",
    ": 40-1 4-5 7 50-2 4-6 8-63 5-7 70-4 6-8 81-3 6 8-91 3-6 9-400 2 4-5 7 9 11-5 7",
    ": 9-21 4-5 7-9 32-3 6-41 6-8 50-2 4-6 8-64 6 8-70 2-4 6-8 81 3 6-9 91 3 5 7-505",
    ": 8 10 4-6 9 22-5 7-35 8-9 41-7 9-51 3 7 60-71 3 7-9 81 3-4 6-91 3 5 8 600-1",
    ": 5-10 3-5 7 21-2 4-5 7-8 31-3 5 7 9-41 3-5 7-8 50-3 8-65 8 70-3 9-88 93 8-9",
    ": 701-2 6 8-9 11 4-8 21 3-4 7-8 31-3 6-7 9 42-3 5 7 50-2 5-7 9-61 3-4 7-8 71",
    ": 3-5 7-9 83-9 91 3-5 7-9 801 4 7-11 3-5 7-9 21-4 6 30-1 3-7 9-42 4-8 50-2 7-8",
    ": 60-1 3 5-6 8-9 72 6 8 80-1 7-90 3 5 8 900-1 3 6-7 9-17 9-22 5 7 9-33 5 7-8",
    ": 41-6 9-50 2 4 6 8 60-4 6-70 3 6-9 81-3 5-7 9-90 3 6",
    ": 7000 3-5 7-15 7 21-5 7-9 32 4-6 8-40 3 5-9 51-5 7-61 3 5 8-9 71-2 5-6 80-1 3",
    ": 5 7 9 91 4-6 102 4-14 6-8 23 5 7 9 32-3 5 7-8 40-1 4 8 51-2 4-5 7 60 2-9 71-8",
    ": 80-1 4 7 9-90 5-201 4 8-10 2 4-8 20 2-8 31-3 5-7 9-41 4 6 8-9 51 3-6 8-60 3",
    ": 6-72 6 8-9 81 3-4 6 8 90-2 4-6 8 300-5 7 9-10 2 4 6-7 20-3 5 8 31-4 8-9 41",
    ": 3-6 8-9 51 3-4 6-8 62-4 6-7 9 71-3 6-9 81 5 9 91 3 5 9-402 4-5 8-9 11 4 6-7",
    ": 21-4 6-7 9 31-3 5-9 41-4 6-50 3-8 60-5 9 72-83 5 9-91 3-4 8-503 5-6 8-19 22",
    ": 5-9 31-4 7-9 41-2 4-7 9 51-3 5 7-8 60-2 6-7 9-71 3-5 9-80 2 6-7 90-3 8-600",
    ": 2-5 7-13 6-7 9 22 5-7 30 2 4-9 41-2 5-8 52-7 9 61 3 5-6 70 3 5-7 80-1 4 6-7",
    ": 9-96 9-701 8-9 14-5 7-8 20-4 6-7 30-2 5 9 41-2 5 7-55 7-60 3 5 7 9 74 6-9 82",
    ": 4-5 7-9 91 3 6 803-6 8-11 3-6 9-24 6-8 30-2 4-9 41-4 6-8 51-2 4-6 61-4 6 8-9",
    ": 71-4 9-80 2 4 6-7 9 92-3 8-900 2-3 5 12-5 9-21 3-5 7-33 5-7 9 41 3-4 6 8-50",
    ": 4-6 60 2-6 8-70 4-5 7-83 5-8 90-1 3-7",
    ": 8002-8 10-1 3-7 9-22 4 6 9-31 4-40 3-6 9-59 61-3 6 8-9 73-5 7 9-82 4-5 7 91",
    ": 3-4 6-8 101 4 7 13-6 8 21 3 5-7 30-5 7-9 42-56 8 60 5 7-8 71 3 5-84 6-8 92 4",
    ": 6-7 202-4 7-8 10 2-4 6-8 20-1 3-8 36-40 2-6 8 50 2-4 6-8 60-2 4 6 8-71 5-8 81",
    ": 4 6-9 94 6 8 300 2-4 6 8-9 11-2 4-7 20 2-6 8-9 32 4 8-40 5 8-50 6 9 62-4 6",
    ": 8-9 72 4-5 8 80 3 5 90-4 6-7 9 401-2 4 9-14 6-8 20-1 4-7 9-30 3-5 7 9 42-3",
    ": 5-7 50-3 6-7 9-67 70-5 7-9 83-5 7 91-500 3 5-10 2-6 8-9 21-6 30-2 4-5 7-41 3",
    ": 7-56 61-7 9-73 5-6 9 83-7 9-93 8-9 602-8 11 5-9 21-2 6 8-9 31 3 5-7 9-41 3-6",
    ": 50-1 3 5-7 60-1 4 6-7 70 2-3 5-81 4-6 8-90 2-5 7-700 2 4-6 9-12 8-22 4 6 8-35",
    ": 7-9 41-2 5-6 50-2 4 6 9-62 5-8 72-5 7-81 3 5-8 90-4 6-7 800 2-3 5-7 9-12 7-22",
    ": 4 6 8-30 2-3 5 8 41 3 6 8-50 3 5 7-64 7-70 2 4 6 8-80 4 7-8 90-4 6-8 901-7 10",
    ": 3 5 7-21 4 7-8 30-2 4-6 8 41-2 4-7 9 52-3 5-60 3-7 70 4 6-7 9-80 3 5 7-9 92 5",
    ": 8-9003 6-7 9-10 2 4 6 8 21 4-6 8-9 33-9 41-8 50-3 6-64 6-9 71-4 6 8-80 2 4",
    ": 6-92 7-104 8-14 6-20 3-6 30 2-41 3-6 8 50-2 4-5 8-9 61-4 7-72 4-6 9 82-3 6 90",
    ": 2 4 8-200 3-4 6 9-13 5 7 9-26 8-9 33 5 7 9-44 6 8 50-2 5-9 61-2 4-5 7 9-70 4",
    ": 6 80-1 3 5-6 91-2 4 6 8 300 2-8 10 3 5 7 9-20 2-8 30-1 5-9 43 5-9 51 4 7-63",
    ": 7-9 71-2 5-6 8-9 82-4 7-9 91-4 400 3-4 6-7 10-1 3-5 8 20-3 6 9-32 4-6 8-40",
    ": 3-4 6-8 50 2 4-5 8-67 9-71 4-6 8 82-4 6 8 91-4 8-9 501-8 10-1 4 7-9 21 5-6 9",
    ": 31-5 8-50 2-3 6-7 9-63 6-8 70-6 8-87 9 93 5 7 600-2 5 7 9-10 2 5 7-8 21 5-34",
    ": 7 9-40 4-5 7-8 50 2-61 4-5 7-9 71 3-8 82-3 5 7 9-97 700-2 4-5 9-15 7-9 24 6",
    ": 9-33 5-9 43-5 8-9 52 5 7 9-62 4-70 3-5 7-8 81 5-6 8-94 6-9 802 5-13 5-8 20",
    ": 2-5 7-8 30-2 4-5 7-8 40-7 53-9 61-4 6-7 9 71 3-4 7 80-1 3-4 6 90-4 6 9-903 6",
    ": 9-11 5 8-20 4 6 8 31-2 4-7 44-50 4 6 8-9 61-5 8 71 4-5 7 9 81-3 5 8-9 91-2 4",
    ": 6-80000 3-7 10-1 3-5 7-9 21 4 6-7 9-33 5-8 40-5 7 9-52 4-5 8-61 7-75 7 9-80",
    ": 2-4 6-95 7-9 101-4 6 8-14 6 21 3-8 31 3-4 6-8 42-4 51-3 5-7 61-2 4-5 7 71-8",
    ": 81 3-7 91-3 5 7-8 200-14 8 20-4 8 30-6 41 3-4 6-8 50-2 5-60 2 5-74 6-80 3 5",
    ": 7-94 9 302 6-7 9-11 3 6 8 21-3 5-6 8-30 2-5 8 40 3-4 6-50 3-4 7-61 4-7 74-5",
    ": 7-8 80-1 6-9 91-2 6 8-401 4-14 6-9 22-4 6-8 30-1 3-7 41 5 7 9-50 2-3 5 7-60",
    ": 2-3 6-8 70-1 4-5 7-82 4-90 2-3 5 7 9-503 6 8-9 12-4 6-20 3 5 9 32-6 8-9 41",
    ": 3-7 50-3 6-8 60-1 3-7 9-72 4-7 9 82-4 6-9 93-601 3-12 4 7-9 22-3 7-30 2-3 6-8",
    ": 40 2-5 8-54 7 9-60 2 9-71 5 7 80-1 5-7 9-93 5-6 9-700 2 4-5 7 10 2 7 9 21 3",
    ": 5-41 6-7 9-51 3 5 7-60 4-5 7-8 70-8 80-6 9-90 2 4-9 802 4-5 11 3-5 7 20-2 7-8",
    ": 30-2 6 41 3-6 50 2-8 60 2-9 71-5 7-80 4-7 9-92 6-7 901 3-4 6-9 11-3 5 7-8",
    ": 20-1 5 7-8 33-4 6-9 42-3 50-2 4-5 8-61 4-7 9-70 3-5 7-9 83-5 8-91 3-4 7-8",
    ": 1001-11 3-7 20 4-5 9-30 2-5 8-9 41-2 8-50 3-5 7-8 60 2-3 6-7 71 4-80 2 4-5",
    ": 7-96 8 100-2 5-7 9 11-3 5-7 21-3 5-7 9-30 2-8 41-3 5-7 9 54-5 9-60 2 8-70 3 5",
    ": 7-80 2 4-5 91 3-5 7 200-4 9 13-5 9-20 2-3 5 7-9 32 4 6-8 40-1 5-7 53-4 7 9-66",
    ": 9 71-2 8-81 3 5 7 9 91 3 6-7 9-304 7-12 6 8 20 2-4 6-7 9-31 3-4 6 9-41 4 6-9",
    ": 51-2 6 9 62-4 7 70 3-6 9 81-3 7-93 6-9 402 9-12 4 7-8 20-2 4-5 9-30 2-4 6-7",
    ": 9-41 3-4 6 50-5 8-61 3-4 7-9 72-3 6 8-9 85-7 92-5 7-501 3 5-6 8-9 14 6 9 23-4",
    ": 7-30 6-9 41-2 4-7 9-50 2-3 5-7 60-1 3-4 6 8 70-4 7 9-81 3-7 9 91-2 5-6 8-601",
    ": 3-5 7-9 12-22 4 9-32 5-6 8-45 7 55-7 9-62 4-5 7-73 6 8-80 5-6 8 90 2-4 6-702",
    ": 4-6 9-10 2 4-9 21-4 6-9 31 3-5 8 41-6 50-1 3-4 6-61 3-4 6 8-9 71-7 82 5 8 91",
    ": 5 800-1 4 8-9 13 5-7 9 21-5 8-30 3-5 7-40 2-3 5-7 50-1 3 6-60 4-5 7-9 71-2 4",
    ": 7-82 4 6 8-93 5 8-9 902-3 5-11 3-5 8-20 2-30 2-8 40-1 6 51-3 7 60-5 7-8 70-4",
    ": 7-8 81-3 5 7-9 92-3 5-9",
    ": 2004-6 9-11 3-4 6-7 9-28 31-4 7 9-43 5-7 9 52-7 9-61 4-6 8-71 5-6 8 82-90 2-7",
    ": 9 103-6 8-10 2-7 9-22 5 9-33 5-40 2-4 6 50-3 5-9 64 6 9-70 2-3 5-9 81-4 6-7",
    ": 90-1 4 7-8 202 4 7-10 3-7 9 21-3 5-9 31-2 4-5 7-9 41-6 9-51 4-6 8-9 61-4 8-73",
    ": 5-6 8-80 4 6-8 90-1 3 6 300-4 6-7 10-7 9-24 7 9 31 8-9 42 4 6-7 9 51 3 6 8-9",
    ": 61-2 7-8 70-1 3 5 7-8 80-1 6-90 2-3 5 8-9 401-4 8-9 12-5 7-21 3-5 7-8 30 2-6",
    ": 40-5 8-50 3 8 60-5 7 71-8 80 3 6-8 90 2-3 5-500 2 4-18 21-2 7 9 31 4 6-9 41-3",
    ": 5-6 9 51-3 7-9 63-4 6 9-76 9-81 3-5 7 9-90 2-3 5-6 600-1 3-8 12-7 24-9 32 4-9",
    ": 41-51 3-7 60 2 4-8 70-6 8-82 4-5 7-92 4-701 3-4 8-13 5-9 21-2 4 6 8-35 8 41-5",
    ": 7 9-50 3 5 7-9 62 4-6 8-71 4-80 2-8 92-801 3-8 10-6 22-3 6-7 9 32-8 40-5 9-50",
    ": 3-7 60-1 6-8 73 5 8-9 81-3 6-7 91 3 5-6 8-9 902 5 7-14 6 8-9 21-5 7-30 2-4",
    ": 7-8 41-2 5 7-56 8-9 62 5 7 9 72 4 80-5 7 9-90 2 4-8",
    ": 3001-2 5-15 8 21-2 4-38 41-2 5 7-8 53-4 7 9 63-5 7-8 71 3-4 6-81 8-90 2-5",
    ": 7-105 10-1 5 7 9-20 3-9 31-2 7-8 40 2-8 51-2 6-62 4-5 8 70-5 7 9-84 6-91 3-7",
    ": 200-3 5-9 11-4 6-7 9 22 5-9 31-3 5-43 7-8 50-1 4 6-9 62-5 7-9 71-3 8-81 3-6",
    ": 8-9 91 4-7 9-300 2-5 11 5-20 2 4-7 31-9 43 5-50 3 9 62-5 9-73 7 83 5-7 9-90",
    ": 4-7 9 402-12 4 7-24 6-7 9 33-5 7-40 3-5 9-64 7-9 73-5 7-8 81 3-4 7-91 5-8",
    ": 500-7 9-12 4-5 7-8 20-2 6 9-30 2 4-5 7 40 2 5 8-50 2 4-63 5-8 70 2-3 7-80 3-4",
    ": 6 8-97 9 601-2 8-14 6 8 20 2-3 6-9 31-2 6-41 3-8 50-8 60 2 4-71 4 6-80 4 7",
    ": 9-98 700-2 4-7 9-10 3 5 7-23 5-34 41 3 7-9 52-3 5-8 60 3-4 7-8 71-2 6-8 81",
    ": 4-9 91-4 6 8 800-3 5-8 10 3 7-8 20-1 5-8 30 2 6-7 40-1 3 6-9 54-9 66-75 9-83",
    ": 5-6 8 90-1 3-4 6-7 900-1 3-5 7-10 2-6 8 22-7 9-31 3-8 40-1 6 50-5 8-61 3-4 6",
    ": 8-9 71-4 6-82 4 6-93 5-6",
    ": 4000 2-7 12-6 9 21 3-4 6 8-31 4-5 7-8 40-4 6 8-54 9-61 3 7-8 70-1 3-6 9-80 2",
    ": 5-6 8-9 91 3 5-8 101 5 7 12-6 8-26 8-32 8-41 4-5 7 9-51 4-6 9-62 5-6 9-80 2",
    ": 6-9 91-206 8 10 3-4 6-7 21 3-6 30 2-41 6 9-50 2-6 8-9 62 4 70-3 6-81 3-6 8-91",
    ": 5 7-8 301 3 6-11 4-5 8-23 5 8-30 2-4 6-8 41-3 5-7 9-51 5-7 9-60 2 6-8 70 2-4",
    ": 6-9 81 3-6 8-93 5-6 8-400 2 4-6 8-9 11-8 20 4-8 31 3-4 6-8 41 3 5-6 8 50-4",
    ": 6-60 2-4 7 9-70 3 6-7 9 81-2 4-6 8 90 2-4 7-9 502-5 8-10 4-6 9-20 2-3 5-6 9",
    ": 31-2 4-5 7-40 4 6 9-52 4-6 8-61 3-4 7-9 71-8 82-6 8-99 602-6 8 10-1 4-8 21",
    ": 3-6 9 31-4 6-8 40 2 4 7-53 5-7 60-1 4 7-70 2 4 7-8 80-2 4-9 91-6 8-9 704 6-9",
    ": 11-2 6-9 21 4 8 32-5 8 42-3 5-9 52 4-5 7 9-62 4 6 8 70 3 6-9 81-3 5 7-9 91 3",
    ": 5-7 9-800 5-7 10-1 4-7 9-20 6-8 32 4-8 40-2 4-6 8 50 2-3 5 60-1 3 5-7 9-72 4",
    ": 7-9 82-5 7 90-1 3-4 6-9 901-6 8 10 2-4 6-8 20 4 6 9-35 7-8 41 3 5-7 9-50 2-6",
    ": 60-2 4 6 8 70 2 4 7 81-3 8 93-4",
    ": 6-5000 5-6 8-9 12-5 8 20-2 4-5 7-30 3 6-9 42 4-7 9 51-5 7-8 60-1 3 7-8 72 4",
    ": 6-83 5-8 92-3 5 9-101 4-6 8 11-2 5-9 22-3 6-8 30-2 4 7 9 41-51 4-5 7 9 61-3",
    ": 5-9 74 7 80 3-6 8-93 6 8-202 4 6-7 9-10 20-1 4-6 9-30 2 4 7-9 41 3-4 6 8-9",
    ": 51-4 6-9 61-2 4 6-8 70-3 5 7-8 80-3 5-9 91 5 8 303 5-6 9-12 5-6 9-24 6-7 30-1",
    ": 3-7 40 6 8-50 2 4-9 61-2 6 9-74 6 9 81-4 7 9-93 7 9-400 2-7 9-19 21-3 6 9 32",
    ": 4-6 8-40 2 4 7-51 3 6-7 9-62 4-5 7-8 70-2 4 6-8 80-3 6-9 91-5 7-501 3 5-7 10",
    ": 2 5 8-20 2-6 31-3 6-8 40-6 8-51 4 8 62-4 6-70 2-4 8 80 2-4 8-9 92 4-5 8-9 602",
    ": 5 7-9 11-2 4-6 9-24 8-38 40-1 3-5 7-51 4 6-7 61 4 6 9 71-5 7-83 5 7 9-90 2-5",
    ": 7-8 700-3 7-8 10 5 21-3 5 9 31-2 4-7 40-1 4-8 51 3-4 6-7 9 65-6 8-70 4-5 82 4",
    ": 7-91 3-7 9 802-9 11 3-8 20-3 5-8 30-3 6-7 9 43-5 7 54-6 60-3 5-6 8-70 5-6 81",
    ": 3 5-7 90-1 3 5 8 900-9 11-2 4 6 8-9 21 3-6 8 30-2 4-6 8 41-5 7-52 4-8 60-1",
    ": 3-5 7 9 71-5 7 80 3-6 8 90-2 4 7",
    ": 6000 2-5 8-9 12-9 21 3-5 30 2-6 8-40 2-5 7-9 59 61-4 8 72-3 5-6 8 80-7 9-90",
    ": 2-8 101-6 8-10 2-3 7-8 20-2 7-8 31-6 8-9 42-8 51-2 4-6 8-60 2 5-8 70 2-3 6 81",
    ": 3-5 8-9 92-3 5 8-9 202-4 6-9 16-20 2-33 5 7-8 43-5 7-8 50 2-5 8 60-1 4-9 71-2",
    ": 5 8-80 2 4-91 4-8 301-2 4-6 10-2 4-5 7-8 22-3 5 7 9-33 7 9-40 3-4 7-52 4-5",
    ": 60-1 3-72 4-5 7-8 80-1 5-6 8-9 91 3 5-9 402-3 6-7 9-10 3-7 9 21 3-5 7 33-6",
    ": 8-9 42-4 6-8 50-3 5-9 61-2 4 7-72 4 6-9 83-5 7 9 91-3 502-3 5-7 9-10 3 6 8-20",
    ": 2-32 4-5 7 9-41 4 6-9 51-2 4 6 9 64-6 8-9 71 3 6-7 81-4 8-9 91-5 7-9 601-2",
    ": 4-8 12-3 5-6 8-20 3 5-7 9-31 4 7-8 40 2-8 55-8 60 3 7 9 77-9 81-2 6-8 90-1",
    ": 3-5 7-8 700-1 4-5 9 15 20-4 8 30-1 3 7-8 40 5 7 9-52 4 7-9 61 4-6 8-9 71 3",
    ": 5-81 3 5-9 91 4-9 801-3 8-10 2-4 6-7 20-2 9-33 5 8 42 5-6 9-50 2-6 8-62 4",
    ": 8-72 5-6 80 2 5-7 91 4-5 7-9 901 3-4 6-7 9-10 5 7 21-2 7-30 3 6-7 9 41 3 5",
    ": 8-51 4-9 61-3 5-6 8-9 72 4-6 80 2-4 6 8-9 92",
    ": 6-7001 3-7 10 2-4 6-7 20-2 7-8 30-1 3 7-40 3-6 8 51 3-7 9 62-3 5 9-72 7-80 4",
    ": 6 8 93-5 9-101 4-8 11 5-8 21-6 8-9 32-3 6-41 4-6 8 50 3-4 7-65 8-9 71-2 4 6 8",
    ": 82 4-5 8-9 91 3 5-7 9-204 8-11 3-4 7 9 21-2 4 7 9-32 5-6 8-44 6-7 9-53 6-60",
    ": 2-7 70 2 4-6 8 81 3-5 7-9 91-2 6-304 6 8 10-1 4 8 22-8 30-1 3-7 40-1 3 5 7-51",
    ": 4-6 8 61-7 9-70 4 6-8 80 2-3 6-7 9-91 3-5 7 400-3 7-9 11-3 6-8 20 2 4-7 9",
    ": 31-2 4-5 7-8 41-2 4-5 7 9-62 4-9 71 3-8 82 4-5 7 9 93-4 6-7 502 4 7-12 4-6",
    ": 8-20 2 5-6 8 32 5 8 41-3 5 7 50-4 6 61 3-6 9-71 3-4 8-9 81 9 91-7 600-6 10-5",
    ": 8-24 7-8 30-2 5-7 40 2-3 7-8 51 3 5-7 9-60 3-4 6-8 70-1 4 7-8 81-2 4-7 9 91-8",
    ": 700-2 4-6 10-2 7-9 23 6-30 2-3 5 7-40 2 6 9-55 8-9 62-4 6-8 71-5 7-80 2-6",
    ": 8-90 2-3 5-9 804-8 10-5 7 21-2 4 7-33 5 43-7 9 51-2 4-5 7-8 61 4-6 9-71 4 7-9",
    ": 81 3 5 7-8 90-2 4-901 3 6-9 14-5 9-20 2 4-7 30-2 4-9 41 6 9-50 2-6 8 62 5-7",
    ": 71-4 7-8 80-3 7 9 92-5 7",
    ": 9-8006 9-10 2 4-5 9-21 4-5 7-9 32 5 7-41 4-5 7 9 51 4-6 8-9 63-7 70-1 5-7 9",
    ": 81-4 7-92 4-6 8 100-1 11-3 6-9 21 4-31 4-5 8 40 2-5 7-9 51-4 6 8 62-3 7 9",
    ": 72-3 8 80 2-6 90-4 7 9 201-2 4-7 9 12-4 7-23 5-32 4-6 40-3 7 9 51-3 5-7 60-7",
    ": 9-70 4-9 81 3 6-9 91 3 5 7-8 300-1 3-5 7-10 3-5 8-25 7-30 3 5 8 40 2-3 6-51",
    ": 3-6 9-61 3-5 7-8 70-3 5-7 80-1 3-5 8-91 4 8-400 2 6-12 5-8 21-2 4 7-9 32 7-41",
    ": 3-8 55-8 63-4 6-74 6-82 4 8 94 6 8-500 2-6 9 11 7-20 2 5 7 9-31 3-4 7 9-40 3",
    ": 5-52 4 6 8-60 2-3 6-7 73 5-7 9-80 3-7 9-92 5-7 9-600 3-4 6 8-10 7 20-1 5-6",
    ": 30-5 7-8 40-1 3 5 7 51-5 7-61 5-71 4-6 8 80-2 6-9 91-6 8-700 2 4-8 10-3 5",
    ": 9-22 5-7 9 31-5 7 40-1 3-6 9-52 4 7-9 61-2 5-6 8-73 5 7-80 2 4-5 7 9-91 3",
    ": 7-801 3 6 8 10 3-4 7-8 20-1 4 6 8-9 32-44 6 9-53 5-6 9-60 2-4 6-8 71-2 4-5",
    ": 8-9 81-2 4-7 9 91-2 5-7 900-8 10-6 8-9 22-3 5 8 30-1 4-6 40-1 5-9 52-5 7-61",
    ": 6-9 71 3 5 8-82 4-6 8 90 2-3 6-8",
    ": 9001-3 5 7-10 3 7-8 22 4-5 7-8 30-3 7-8 40-1 5 8-50 3 5 8 60 2-3 5-6 70 5-6 8",
    ": 81 4-5 8 90-3 5-9 101 4-7 9 11 3-4 6-8 23-4 6 8 31 3-5 9-43 7-9 52 4-9 61-2",
    ": 4-5 9-70 2 5-7 82 4 6-9 96 8 200-4 6 9-10 2 4-6 8-9 21-2 5-8 30 3-4 6-42 4-6",
    ": 8 50-3 5-8 61 4 6 8-9 71-3 6-8 81-6 8 90-6 8-9 301 3-6 8 11-3 5-20 3-9 31 3-6",
    ": 8 40-4 8 50 2 5-7 9-62 6-71 3-4 6-9 81-3 5-7 93-5 9-403 5-6 8-10 2 5-7 9-22",
    ": 5-7 9-31 3-6 8-41 3-4 6-50 2-3 8-60 3-5 7 9-75 7-81 5-8 91-2 5 7-9 501-2 4-5",
    ": 7-12 4 6 9 22-3 5 7-8 32 4 7 9 43 5 7-51 3 7 62-7 71-3 5 7-9 81-2 4-5 8-9",
    ": 92-7 9 603 5 7-11 3-6 8-24 7-8 30 2-3 5 7-42 6-9 53-4 7 60-2 5-6 9-71 3-4 8-9",
    ": 81-6 9-91 3 5 7-700 2-5 7-10 3-4 6-8 21-3 6-32 4-6 9-43 5 8-9 51 3-60 2 4 6-7",
    ": 9-71 3-80 2 7-8 92-6 9-800 4-6 8-14 7-9 21-3 8-33 5-6 9 42-3 5-8 50 2-6 8-60",
    ": 2 4 6 70-1 3-6 8 80-2 4-5 7 9 95-6 9 901-3 5-8 11-7 25 7 30-1 3 5-8 40-2 4",
    ": 6-7 51-4 6-7 60-1 3 5-70 2-3 5-6 80 2 5-91 4-7 9",
    ": 90001-5 7-10 2-3 5 7-8 21 3-4 9-30 2 4 8-42 4-8 50 2 4 7-60 2 4 6-71 3-4 6-7",
    ": 9 84-6 9-90 2-3 6 8-102 4 6 11-5 9 25-7 30 2-5 8-9 43-6 8 50-3 5 7-8 60-1 3 5",
    ": 7 9-70 2-3 5 7-82 4-6 8 90-1 4-6 200 2-3 8-15 7 20 2-5 7-30 2-4 6 41-3 6-9 51",
    ": 3 5-6 8 60-1 3-8 70-2 4 6-7 80-3 8 90-7 9 301-2 5 9-12 4-5 7-8 20 3-4 6-8",
    ": 30-1 3-40 6-51 3 5-62 5-8 70-6 80-1 3 5-7 9 91-2 4 6-9 401 3-6 8 10-1 4-7",
    ": 22-6 8-30 2-4 6 41 4-6 8-51 3-5 7-9 61 4-70 2 4-6 8-9 82-4 6-7 9 91-3 5 7-500",
    ": 2-3 5-6 8-12 4 8 20-1 4-5 7 30 3-7 40-2 5-7 50 2-4 9 61-72 4-7 80-1 4 6 91",
    ": 7-9 601-4 8-9 11-2 5-6 8-9 24-5 32 4 6-9 41-4 7-8 50 2-3 5-7 62-3 6 8 70-3",
    ": 5-6 8-9 81-2 5 8-97 701-2 4 6-7 12-3 5-8 24 6 8-9 31 3 7 9-40 4-51 3-6 8-61",
    ": 4-72 4-8 80-2 4 6 8-95 8 800-1 5-11 3 6-7 9-25 7 9 32-3 6-40 2 5 7 9-50 2 5",
    ": 8-61 3-7 70 2 4-80 3 5 7 90 2 4-6 8 906-11 3 5-7 20-1 3 6-7 9-36 9 41-7 9 51",
    ": 3-5 7-8 60-1 3-4 7-9 71-3 5 8-9 82 4 90",
    ": 4-1006 9 13-7 9-22 5-7 30 3-40 2-6 8-51 7-9 61 4-70 2-3 5 7-8 80 3 5-6 8-93 5",
    ": 7-100 2 4-5 8-9 13 7 9-20 3-7 9 31 3 5-8 40 3-6 51 3-4 6-8 60-2 4-5 7-73 7 9",
    ": 84-5 9 91-2 4-5 8 201-2 5-6 8 12 5-6 8-23 5-30 3 5-9 41 5 8 50 2-4 6 8-61 5-7",
    ": 9 72 4-5 7 80-1 4-90 2 5-301 3-4 6 12 4-6 9-21 3-5 7-9 31 4 7-41 3-8 50 4",
    ": 6-61 4 6 8 70-2 6 9 81 3-5 8 90 2-8 400 2 5-9 11-5 7 21-3 6-7 9-30 2-3 5 40",
    ": 3-4 7-9 51-2 4-63 8 70-1 3-7 81-3 5-91 5-6 8 501-2 5-6 8-14 7-9 22-4 6 8 31 3",
    ": 6-9 41-2 5-8 50-1 5-7 60-1 5 7-8 70 2-4 7-8 80-1 4-5 8-90 2 4-6 9 601 3-6",
    ": 8-10 3-7 9 22-4 6-7 30 4-5 8-40 2-3 5-6 9 51 4 6-7 60-6 8-9 74 7 9-85 8-92 4",
    ": 7-8 700 2 5 7-9 12-3 5-6 20-2 6-9 31-4 6-46 8 50-3 5-7 9-61 3-4 6 8 70-1 3-7",
    ": 80-2 4-9 91 4-8 800-5 7 10-2 4 6-7 9-20 2-4 7-30 2-3 5-8 40 4-5 7 9-51 3-4",
    ": 6-8 61-2 4 6-7 70-4 6 9 81-3 5 8-90 2 4-5 900 3 5-8 11 3-4 9 21-3 7 30 3 5-6",
    ": 9-43 5-51 3-4 6-9 63-9 71-3 5 7-84 7-8 91-2 4 6 9",
    ": 2002-3 5-13 5-7 9-26 8-30 3-5 7 9-44 6 8-50 2-5 60-4 6-72 4 8-80 2-4 6 8-9",
    ": 91-2 4-5 7-9 101-3 6-10 2-8 21 3 6-8 30 2-8 40-1 3-7 51 3-7 60 2-6 9-73 5 9",
    ": 82-6 9-90 2 5-6 9-200 2-5 7 10 5-22 4 7-32 5-6 9-40 3-4 8-9 51-2 5-6 8 60-1",
    ": 3-5 7 9-70 2 5 8-80 2-7 90-4 6-7 9-300 3-5 8-10 3-4 21-6 8 30-1 3 5 8 40 5 7",
    ": 9 51-4 6 60-2 4-7 9 73-83 5-90 3-400 2-4 9-14 8 21-3 5-7 30-1 3 5 8-42 6-7",
    ": 9-55 9-60 2 4-71 4 8-80 2-94 8 500-4 7 9 11-4 6-8 22 4-7 30-5 9 41 3 6 8 52",
    ": 7-62 4-5 7 70 3-6 8 80 3 6-7 90 2-4 6-9 601-3 5 8-10 2-3 6 8-9 21-2 4 6-8 31",
    ": 3-6 8 40-1 3-4 6 8-9 51-5 8-9 61 4 7 70 2 5-7 80-1 3-4 6 90-1 3 7-8 700-3",
    ": 5-11 3-4 6 20-6 8 30 2-7 40-5 7 9 51-64 8-9 71-9 81-7 9-90 2 4-6 8-801 3 6 8",
    ": 13-4 6 9 21-2 4-7 9-31 3 5 7-8 40 5-8 50 2 5-63 5-7 71 3-8 83 5-91 3-7 9-901",
    ": 3 5-9 11 3-8 20-2 4 6-8 30-5 8 40-2 4-6 8-53 5-9 62-71 4-83 5 9-92 8",
    ": 3002-5 7-15 7 9-21 3-4 6-7 30-1 5-6 8 43-4 7-8 51 3-61 3 5 7-9 71 3-84 6-8",
    ": 91-3 6-100 2-11 4-5 7-8 20-1 3 7-33 5-6 41 4 7-55 60-5 7 70-3 6 8-80 3-4 6-8",
    ": 91-5 7 200 2 5 9-13 5 7-21 3-7 9 31-46 8 51 3-4 6 63 7-9 71 4 7 9-88 91 6-302",
    ": 4 6-11 3 7 22-3 5 9-32 4-7 9-45 7-9 51 3 62-8 70 2 5-6 9-81 5-91 3-5 7-9",
    ": 402-7 12-5 7 9-20 3-6 8-9 31-7 9-42 4-6 50-1 4-6 8-60 2 6-7 9 74 6-7 9-84",
    ": 6-90 2-4 6 9-500 4-7 9-17 9-21 3 5-6 9 32-3 6-9 41 3-4 6 50 2-7 9 62 4-5 8-78",
    ": 80 3-5 7-91 5-8 602-14 8 21 3-7 30-3 5-6 9-41 3-4 6 8-50 2-5 9-63 5 8-72 5 80",
    ": 3 5 7-92 4 6-9 704-6 9-10 2-3 6 8-9 22 6 8-9 31 5 7-41 3-4 8-52 4 7 9 61-2",
    ": 4-5 7 9-75 7 82-7 9 91-7 9 803-5 9-10 2-5 7-20 2-3 5-7 9-35 8 41-3 5-6 50-2",
    ": 5-6 8-60 2 4-8 71-2 5-6 8-85 7-93 7-9 901-3 6-7 10 7-9 21-2 4-7 9-35 7-9 41-2",
    ": 5-6 8-50 2-3 5-6 8 61-8 70-1 4-6 8-82 5 7-8 90-5",
    ": 8-4000 3-4 7-10 2-5 9 22-7 31-3 7-9 41-3 5 7 9 52-3 5-6 60-8 73 5-8 83-5 7-8",
    ": 90-8 100-5 7 9-11 3-7 9-20 2-3 5-9 31-3 6-8 43-4 7-51 5-7 60-1 3-6 8 73-5",
    ": 7-81 3-8 90-8 201-6 8-10 3 5-9 22 4-30 3-6 8 40-1 3-5 8-9 51-5 60-5 9-70 2-80",
    ": 4-5 7-8 90 3-5 7-300 2 5 7-8 10-4 6 8-20 2-5 8 30 2 6 8-41 3-4 7-9 51-2 4",
    ": 9-63 5 7-70 4 7 9-82 5-7 9-92 4-5 7 9-402 4-5 7 10 5-6 20-5 7-34 6-8 41 5-6",
    ": 8-9 56 9-60 2-6 8 71-2 4 7-8 81 3 5 7-90 3 5 9 503-10 6-9 21 3-4 6-7 9 31-7",
    ": 9-41 3-5 7-54 9-63 5-8 70-1 3-5 7-8 82 4-5 7-96 8-600 2-5 7 9-10 2-3 5-6 8-9",
    ": 21-2 6 30-2 4-6 8-9 43-54 6-7 60-2 5 7-9 72-3 6-81 4-5 9 91 4-9 702 6-7 9-13",
    ": 5-8 20-4 7-35 7 9-41 3 6-8 50 2 4 6-7 61-2 7-9 72-6 8 82 4-8 90 2-6 8 800-3 5",
    ": 11-3 6-20 4-5 7-8 30-6 8-43 5 7-9 51 3-7 9-60 2 5-71 3-7 85 7-8 90-1 3-902",
    ": 6-9 13-4 6 8-9 22-4 6-7 30-3 5-42 5-54 6-62 5 7-8 70 2-5 7-80 2-7 9-90 2 4 6",
    ": 8",
    ": 5000-2 6 8-15 7-9 21 3 5 8-9 31 3-8 40-1 3-5 7 9 53-4 6 9-60 3-70 2-5 7 9-82",
    ": 7 90-2 4 6-100 2-4 6-10 4-5 7 9-25 9 31-3 5-6 8 40 3-6 8-9 51 3 5-60 2 4-6",
    ": 8-70 2-3 8-9 81-3 5-90 2 8-201 3 5-10 3 5-8 22 4 6-9 32 4-5 8-9 41 3-4 6 52-6",
    ": 9-63 5 7 9-71 3-4 9-80 3-8 91-4 6 301-2 4 6-8 10-5 7-20 2-30 2-3 6-7 9-44",
    ": 7-51 4-5 7-9 62-8 72 5-6 9-82 4-7 9-95 7 9-401 3-6 11-2 5 8 20 4-5 9 31-2 4-5",
    ": 7 9-40 3-5 8-9 52 4-5 7-60 2-3 6-8 70-3 6-8 81-2 7-8 91-3 5-6 8-500 2 5 7-11",
    ": 4-7 9 21 5-31 3-43 6-50 3-8 62-4 6-7 70-1 4-7 81 3 6 8-90 2 8 600-1 3-5 7",
    ": 10-1 3-6 21 3-4 30-2 6-7 9 41 3 5-6 9-51 5-7 9 62 5-7 70 2 5-8 80-1 4-91 3",
    ": 5-8 700 2-5 7 11-3 6-22 4 7-31 4-5 9 41 3-5 50-3 7-8 60-1 3 5-8 70-3 5 9 83",
    ": 5-7 9 95-801 3 5-10 2-4 6-8 20 2 5-7 9 31 3 6 8 40 2-3 5-6 8-50 3-7 9-61 3-5",
    ": 8-9 71-3 5-7 82-3 5-9 93-9 901-5 7-9 11-6 9-22 4 6 8 32 5-6 8-41 3-4 6-7 9-53",
    ": 6-8 60-1 3-6 9-70 3-5 8-9 83-7 91-2",
    ": 6-6000 2-3 6 8 15-20 2-6 30 4-7 9-40 2 4-53 5-7 62-4 7 9-72 6-7 9-81 3-5 7-9",
    ": 91-2 4 6-8 102 4-6 8-10 2-4 6 8 20-5 7-33 7-42 4 7-8 50-3 5-9 62-6 8-73 6-82",
    ": 7-93 5-6 8-9 203-9 12-4 6 8-21 3-9 31 3 6 40-3 5 7-52 4 7-62 4-5 7 9-71 4-7",
    ": 81-7 90-1 3-5 7-312 7-20 2-6 9 31 3-5 41-4 7-8 50-1 4-6 64 7 70 2-3 5 7-8 86",
    ": 8 92 5-9 402-16 8-9 21 4 7-8 33-8 40-1 3-5 9 52-4 7-61 3 6 9-72 4-5 7-8 81-2",
    ": 4 6-7 91-6 8-500 2 5-6 8-9 13-20 3-4 7 9 32-3 5-9 41 4-8 51-9 61 3-6 9-71 3",
    ": 6-81 5-92 4-5 9-603 5-6 8-9 12 6 8-9 21-2 5-30 3-4 9-67 9 72 4-8 80 2-3 5-9",
    ": 92 4-6 8-9 701-3 6 8-11 3 5 7 9-20 2 8-30 3 5-6 8-43 6-8 51-3 6-60 3 5-7 71-3",
    ": 6-7 80 4-90 2-3 6-808 10 2-4 6-8 20 3-4 7-8 30-1 3-4 6 40 2-3 6 9 51-2 4 6 8",
    ": 60 2-3 5 7-74 6-7 9 81 3 9-91 3 6 8 900-3 5-7 9 11 3 5 7-8 20 3 6-8 32-6 8",
    ": 40-6 8-51 3-4 9 64 6 8-9 72-3 5-6 8-80 2-4 6-9 91-2 4-5 8",
    ": 7000-1 4 6-9 12-6 8-21 3-6 8 30-2 5-7 9-42 5-9 51 3-5 7-9 61-5 70-1 6-80 2-4",
    ": 6-9 91-2 5 7-8 102 4-6 10-2 4-5 20 2 4 9-30 2 5-42 7-9 51-5 7-61 4-5 7-71 4",
    ": 6-84 7-94 6 8 204 6-13 5-7 9-25 7-30 2-6 8-45 51-3 7-9 62-3 5-7 70-3 5-6 8",
    ": 82-3 5 7 9-94 6-300 2 4 6-9 13 5 7-9 21-3 5-6 8-30 2-7 40 5-50 3-7 9-61 3-72",
    ": 4-5 8-83 6-7 9-91 3 5-6 9-400 2 6 8 10 3 5-6 9 21-2 6 8-34 42-5 7-8 50-2 7 9",
    ": 61 3-5 8-70 2 4-8 80-3 5 7-94 7 500-3 5-6 8 14-6 8-9 21-5 7-9 31-2 4 6-40",
    ": 6-50 3 6 61 4-5 7-9 71-4 7-8 80-3 5 7-90 2-7 9-600 2-3 7-8 13-5 7-9 21-5 33-6",
    ": 42 4 6-50 2 61-3 5-6 9-72 8 80-3 5 91 3-6 9-701 3-6 8-11 3-20 4-6 8 30 2-3",
    ": 5-9 43 6-54 8-61 3-5 8 70-2 4-5 7-82 4-6 8-9 91 3-6 8-800 4-5 7 9 11-4 8-21 4",
    ": 9 32 5 7-8 41 3-4 7-9 51-5 7-62 4 6-9 71-7 80 2 6-91 3-6 8-9 901-4 6-9 11 3",
    ": 5-7 9-22 4-5 8-33 6-7 42-3 5-6 8 50-4 6-64 7 9 71-3 5 7-8 83 5 8-90 2 4-5",
    ": 9-8009 12 4 6-7 9-21 4-6 30-7 9-43 5 9-52 5 7 9-60 3 5 8-71 3-4 7-80 2-7 92-3",
    ": 101 4-5 8-10 2-4 6-7 9-20 2-9 31-7 9 42 4-7 9-53 6-60 5-8 70-1 4 7 9 82 4-5",
    ": 7-90 4-5 7-9 201-4 7-10 4-5 7-9 22 5-8 31-2 4-6 8-41 3-7 9-50 2-5 8 60-6 9",
    ": 72-6 8-81 3 6 8 90-1 3-9 302-3 5 9-11 5 8 20-2 5-9 32-5 7-43 5-6 8-54 6 8",
    ": 60-2 4-75 7 9-82 4 7 9-95 8-401 3-10 2-6 21-4 6-7 31-2 4-5 9-48 50 2-4 7 9-64",
    ": 7-8 70-2 4-6 9-84 8-91 3 7 500-6 8-16 9-20 2 7-8 30-5 8-9 41-2 4-9 53 6 8",
    ": 60-7 9 71 3-4 6-7 80-2 8-9 93-5 8 602 5-11 3-8 21 3-4 6-7 9 32-3 5 8 40-4 7-9",
    ": 52 6-62 6 8-75 7-82 4 7 90 2 4-5 8 704-8 11 3 7-9 21 3-7 31-6 9-40 3-5 8 50-6",
    ": 8-61 4-9 72-5 7 9-80 3 6-7 9 91-3 6 8 801-4 6-9 11-5 7 9-25 7 30 2-3 5 7-9 41",
    ": 3 5 9 51-2 5-7 60 5 7 70-2 4-7 9-85 7-9 92 4 6-7 900-1 4-6 9 11-4 8-20 3-5",
    ": 7-8 31-6 8-40 5-52 5 8 60 2-3 6 71-2 4-6 81-2 4-6 9 91-8",
    ": 9002 4 6-10 2 5-9 24-8 30-3 5 7-43 6-54 7-61 3-70 2-5 8-80 3-5 7-9 93-4 6 8",
    ": 100-3 8 11-3 7 9-20 2 4-6 9-35 7 40-2 4-5 7-9 51-7 9-65 9 72-3 5 7-8 81-7",
    ": 9-90 2-5 201-4 10 2-4 6 9-26 9 31-3 6-8 40-2 4 7-8 50-3 6-9 61 3 5 7-8 71",
    ": 4-80 2-91 3-6 8-9 302-3 5-11 3 5-7 20 2 5 9-32 5-9 41-2 4-5 8-9 51-2 5-7 9-60",
    ": 3 5 7-9 71-3 6 9-80 2-91 3-4 6-8 400-2 4-7 11 6-7 9 23-6 8-9 31-2 7 9 41-5 7",
    ": 9 54 6-7 9-60 3 5 7-73 5-82 5-91 3 5-9 501 3-4 6 8-12 4-5 7-25 7-30 3-6 8-40",
    ": 3-6 8 51 3 5-7 61-2 4-5 8-9 71 3-5 7-81 4 7-9 91 3-5 7 600-3 5-8 10 2 4 6-8",
    ": 21-2 5-6 8-31 3-8 40-2 4-5 7 9-53 6-7 60-1 4-5 7 9-75 8-9 81-2 4-6 8-9 92-3 5",
    ": 8-701 4-11 3-5 7-8 20-3 5-7 9-30 2 4 6-40 2-6 8-55 7-8 61-2 4-5 8-70 2 4-6",
    ": 9-82 4-95 801-4 6 9-10 2-3 6-8 21 3 5-7 30-2 4 6 8-40 3-8 51-2 5-62 4-7 71-4",
    ": 7-9 81-4 7-8 90-1 3 5-6 8-902 4 9 11 3 5-6 20-2 5 9 31 3-6 8 41-2 5-50 2-3",
    ": 5-6 9-62 4-5 8-71 3 6-85 8-90 2-6 8-9",
    ": 800001 4-5 7-23 5-7 9-31 3-5 9-40 3 5-9 54 6 8-60 2-5 7 71-3 6 8-81 4-7 9-92",
    ": 5-6 8 101-5 7 9-11 3 6-8 20 2-7 34-6 8 40-4 6 8-9 51-2 4 6-64 7 70-2 5-7 80-7",
    ": 9 91-3 5-8 200-3 5-6 9-10 2-4 6 8-21 3-4 7-8 30 2-3 5-7 40-8 50-2 4 6 8-9",
    ": 61-3 5 9 72-3 5-80 3 5-9 92 4-6 8 300-1 3-5 9 11 3-4 7-20 7-9 33-4 6-7 9 42-3",
    ": 5 7-8 51-4 6 9-64 6 8 72-4 6-7 9 81 5-7 9 91 3 6 400 2 4 6 8 10 5-6 9-20 2-35",
    ": 8-42 5-52 4 6-60 2-4 7-8 70-2 5-6 8-9 82-5 7 90-4 8-501 4-5 8-9 11 3 5-6 8-26",
    ": 8-31 3 5 7-9 41 3 9-53 6 8 63-5 9 71-5 7-80 5-91 3-4 6-8 602 5 7-11 4 6 20 2",
    ": 5 7-9 32 4-5 7 41-2 4 8-50 2-4 6 8-62 5-7 9-70 3-4 7-8 80-8 90-2 5-8 700-1",
    ": 3-8 10-1 4-5 7-25 8-9 31-2 5-6 8 40 2 4 8 53-4 8-9 62 4 7-72 4-6 8-80 2-3 6",
    ": 8-9 92 4-7 9-801 3 5 8-10 2-5 7-24 6 8-9 31 3-4 6-9 41-3 6-8 50 3-5 7-9 61-8",
    ": 70-2 5-6 9-80 2-8 90 2 901-5 10-1 4-5 7 20-1 3-4 6 8 31-2 5-6 8 40-3 5-6 8-50",
    ": 3-5 7 60-3 5-9 71 3-5 7-8 81 5-6 92-4 6",
    ": 8-1001 7-8 11-5 7-20 3-30 2-4 6 8-9 41-4 6-7 9-55 7-63 5 75-6 8 82 4 7 90 3-8",
    ": 100 5-13 5-6 8-21 3-4 6-30 3-7 9-41 6-54 6-9 61-2 4-5 8-74 7-8 80-6 8-94 6",
    ": 8-203 5 7-14 6-7 9-23 5-6 8 30 2-4 6-7 9 41-9 53-60 2-8 70 6-7 80 2-3 5-6",
    ": 8-90 2-3 5 7-302 6-11 4 7-29 35-41 6-9 56 8-9 65-70 2-9 81 3 6-90 3-6 8 400-5",
    ": 7-8 11-7 9-20 2-6 8-38 41 4 6-8 53-68 72-81 5 8 90-2 4-7 9-503 7 12-5 8 21-6",
    ": 8-9 31-5 8-40 3-4 6-55 60-1 3-4 6-7 71-5 7 80-4 8 90-2 4 7-600 2 4-5 7-12 5 8",
    ": 20-3 7-9 31-6 8-9 43-4 6-8 50-5 7 9 62-3 5-7 9 71-3 5-8 80-1 3 5-6 8-9 91-2 4",
    ": 6-8 700 2-4 8-11 4-7 9-20 2-9 32-4 6 8-9 41-6 8-54 7-8 60 3-5 73-7 80-1 5-8",
    ": 90-1 3-6 8 801 4-6 9-10 3-5 7 9-22 4-5 7-9 32-6 9-41 4-6 8-54 6 8-60 2-5 8-9",
    ": 72-4 6-7 9-81 5-92 4-7 9 902-10 2 4 6-7 9-22 4-6 9-32 4-6 8 40-1 3-5 7-50 2-4",
    ": 6 8-9 62-3 5-70 2 7-83 6-8 92 4-7",
    ": 9-2000 2 4-6 9-16 9 21-2 4 6-30 6-41 3-4 7 9-52 4-6 9-60 2-3 5-70 3 6 81 3-7",
    ": 9-91 5-9 101 3-5 7 10-1 21-3 5-6 30 5-7 9-43 5-7 51-3 5-9 61 3-5 7-70 3-4",
    ": 9-83 5-6 8-96 8-201 3-5 7-9 12 8 21-4 6 9-43 5 8 50 2-5 8 61-4 6 70-8 80-3",
    ": 5-7 90-2 5 8-300 3-6 8-10 2-5 7 9 25-32 4-41 4-7 9-52 5 8-60 2-3 7 9-71 3 5",
    ": 7-80 3-6 9-93 5 7-9 401 6-9 11 3-5 7-9 22 4-6 8-9 32 6-7 40 2-9 53 6-8 60-3 5",
    ": 9-70 2-3 5 8-82 6 9-90 3 5 7-501 4-10 3 6-7 9-20 2-5 9-30 4 6 9 41 3 6 52-4",
    ": 6-62 5 7-8 70 2-8 80 2-3 8-9 94 7 9-602 4 7-8 12 4-5 8 20-2 4-8 30-1 5-6 8-43",
    ": 8-9 51 7 9-60 2-4 7 9 71-7 9-80 2-3 5 7-91 5 7 9-700 2 4 7-13 5 7-20 2 5-6 9",
    ": 32-43 5-6 9-51 3-6 8-64 6 71 3-6 9-80 3-4 7-9 91 3-7 9-800 3 5 7-8 10-1 3",
    ": 6-27 30 2 4 6 8-40 2-4 6-8 50-6 60-3 6-8 70-3 80-4 7 90-1 3-4 6-7 903-4 6 10",
    ": 2-4 6-7 9 21-9 39 41-2 6 8 51-2 4-5 7 60 2-6 8 70-1 3 6-7 9-87 90-8",
    ": 3000-1 4-16 8-9 23-6 9 31 3-6 9-43 5 51 6 8-60 3-73 8-80 2-4 8-96 8 101-2 4-8",
    ": 10 2 5-7 9-21 3 5-6 30-8 41-53 5-8 60-5 8 70-1 3 6-7 9 81 3-5 7-95 8-202 4-7",
    ": 9 12-3 8 20-2 6 8-32 4-5 8-9 41-2 5-8 51-5 7-64 6-9 71 3-7 9-81 3-4 6-92 4-7",
    ": 9 302-3 6-16 8 20-3 6-7 9-36 8-40 2-8 50-7 9-60 3 5 7 9-73 6 80-2 4-6 8 90",
    ": 7-8 400 2-7 14 7-9 21 3-8 30-3 7-42 4-6 8-52 4-8 62 4-7 70 2 4-7 81-3 5-8",
    ": 92-4 6-8 504-7 10-1 3-5 8-9 21-2 4-31 5-6 9 41-7 9-54 7-8 60-70 2-4 7-80 2-3",
    ": 7-8 91 3-601 3-4 6-9 11-6 9-21 3-5 8 30-7 9-40 2-5 7 51-4 6-7 9-61 3 6 8 71-2",
    ": 7 80 2-3 5-6 8 90-4 6 8 701-2 5-6 8-10 2-3 6-7 20-6 9-31 3-7 9 42-7 9-52 4 6",
    ": 9 61-70 2-4 8-82 4-7 9-99 801-2 4-6 8 11 6 8 20 2 5-6 8-30 2-7 40-6 8-9 52-3",
    ": 5 7 61-5 8-70 2-4 6 81-3 5 7 9 91 4-7 9 901-2 4-5 7 9 11-2 4-7 9-20 2-3 5-7 9",
    ": 31 5-41 3-6 50 3 5 8-9 61-2 5 8-9 71-7 81 3 7-9 91-2 7-8",
    ": 4000-1 3 5-6 9-10 5-6 9-25 7-31 3-4 6 42 4-5 7-8 52-5 8-9 65-6 8 71-5 7 9-81",
    ": 7 9 91 3 5 9-101 5-8 10 2 5 8-24 6-30 5 7-8 40-5 50-5 7-8 61-3 6 8-73 5-83",
    ": 6-7 9 91-2 4-6 8-9 202-3 7-10 2 6 8 20-1 4-5 7-31 3-4 7-9 42 4 6-50 3-8 62-4",
    ": 6-8 70 2-4 7-9 81-2 6 8 91 4-8 300-4 7-8 10 3-4 6-7 9-20 3 6-8 30-3 5-41 3",
    ": 5-6 8-51 4-5 7 60 2-3 6-7 9 71-4 6-83 5-9 93-4 7-400 2-5 7-9 11-2 4 7 20-3",
    ": 5-33 6 8 40 4-6 9-51 3-7 9 61-3 5 7-8 70-3 5-9 83-6 9-93 6-8 500 2-3 5-8 10-9",
    ": 22-8 33 5-9 41-8 50 4 8 60-1 3-4 6-8 70-5 8-80 2-4 6 93-4 6-7 9-609 11-2 8-9",
    ": 22-3 8-32 4 6-41 4-5 9-54 6-63 5-9 73-4 6-9 85 7 90 2-3 8-9 702-6 8 10-3 5-21",
    ": 4-7 9 32-3 8-9 42-4 6 8-50 3-4 6-8 60-2 5-6 8-70 2 4-82 5 8 94 6-9 801 3-6",
    ": 10-2 6 8-20 3-6 8 30-4 6 9-40 3-4 7-53 5-9 61 4 7 9 71-2 5 7-8 81-4 6-90 2-3",
    ": 5 903-7 9-10 2 4-9 21-2 4-7 9-31 3-7 9 43-6 8-60 6-8 70-4 6 8 80-1 4-5 7-93 5",
    ": 9",
    ": 5002-7 9 12-3 5-6 9 22 4 6 9-37 40-1 3 5-8 50-5 7-9 63 6 8-71 4-5 7 80 3 5-6",
    ": 8-9 91-3 8-100 4-9 11-3 5-7 20-1 3-4 6-34 8-9 41 3 5-9 51-3 7 9-60 2 6 8-71",
    ": 3-80 2-9 92-3 5-6 8 200-3 5 7-8 10 2-5 7 9-20 2 4-5 7-8 30-1 7 40-1 3 5 7-9",
    ": 51 7-8 60 2-3 5 7-9 71-6 9-86 8-96 8-9 301-3 6-8 10-4 6-7 9-20 2-5 7 9-35",
    ": 8-40 2 5 7-9 52 4 6 9-60 2-3 5 7-8 70 4-6 8-83 5-7 9-90 3 5-6 9-400 2-7 9-14",
    ": 7 9-21 3-4 7-9 32-7 9-42 4-6 50 2 4 6 62-3 5-6 8 72-3 5-9 81 3-4 7-90 3 6-7",
    ": 500-6 8-9 11 4-6 8 20-5 7 31-3 6 9 41-8 51-5 7-60 2-4 6-9 74 6-7 9-85 7 9-94",
    ": 8 600-6 9-21 3-4 6-8 30-5 7-9 41-4 6 8-9 52-3 5-61 3-7 71 3 5-8 80-1 3-8 90-3",
    ": 6 8 701-3 5 8-9 12-3 5-7 20 2-7 9-34 9-40 2 5-8 50-1 4-6 9 61-3 5 7-73 6-80",
    ": 3-4 6-7 9 93-4 8 800-3 5-6 8-9 12 9-20 3-6 30-4 6-8 40-1 3-4 8-54 6-9 61-2",
    ": 6-9 71-2 4-6 9 81 3-4 6-93 5 7-900 2-7 9-10 2-7 20-1 3-6 8 30-6 8-43 5-6 8 50",
    ": 3-7 9-60 3-6 8 70-3 5-7 9-85 8 91-2 4 9",
    ": 6002 4-5 9-13 6 8-22 4 6-8 31 3-5 9-40 3 7-9 51 4-5 7-8 61-5 7-9 71-2 4 8-9",
    ": 81 3 8-90 2-5 101-4 7 9 11-3 5-9 22-3 7 30-8 40-3 5-8 50 2 4-5 7-9 62-4 6-9",
    ": 72 4 6-8 80-8 90 2 6-7 9 201-2 4-5 8-16 8-21 3-4 6 8 30 5 7-45 7 9-52 4 8-63",
    ": 5-9 71-2 5 7 9-80 3 5-8 90 3-7 300 2-6 8 13 5-20 2 5-7 9-33 5-6 9-42 4-5 9 52",
    ": 6 8-60 2-3 7-8 70 2 4-8 80 2 7-9 91-6 8 400-1 3 5 7-12 4 6-7 9-20 2-4 6 8-30",
    ": 2 7 40-3 5-7 51-2 4 6 8-61 3 6-70 4 6-7 80-4 6 8-91 3-5 7-9 501 6 8-17 9-20 2",
    ": 4-5 9-36 8-40 2-4 6-8 50 2-6 60 2-3 7-9 71-4 6-9 82 5-6 8-90 3 8-9 601-3 6",
    ": 9-16 8-20 2-3 6 8-9 32-6 8-41 3-6 9-51 4-63 9-71 3 5 8 81-2 5-6 8-9 91-4 6",
    ": 8-701 3-5 7 10 2 4-6 8-28 30-1 4-6 9-40 3 5-8 50-6 9-61 4 6-7 70-2 4-5 8-80",
    ": 2-90 2-3 7 9-800 4 7-10 2 4 6-8 21-2 5 35 7 41-2 4-7 52-3 6 60 2-5 7 70-1 3-4",
    ": 6 9 81 3 5-92 4 7 9-901 4-6 8 11-2 4 9-23 6-7 32 5-6 9-43 5-6 8 50-3 5-9 62",
    ": 7-8 70-1 3 5-7 9-81 7-92 4-6",
    ": 8-7002 5 7-9 11-3 5-7 9-20 3-5 7 9 32-3 9-41 3-8 50-4 7-67 70-2 4-85 7-8 91-4",
    ": 9 101 4-7 10 3-4 9 23 7 31-4 7 9-40 2-3 6-50 4 6-61 3-4 6-8 70-1 3 5-7 9 84-5",
    ": 8 90-4 6 8 202-6 8-11 5 8-9 24-6 32 5-7 41 3-9 52-6 9-64 6-8 71 5 7 80 3 5-6",
    ": 8 91 3-4 7 301-3 7 9-11 3-4 7 20-9 33 7-8 40-4 6 9 51 6-8 60 2-3 5-7 70-1 4-6",
    ": 8 81-2 5-90 2-4 7-8 402-6 10-1 3-22 4-5 31-5 7-40 2-3 5 7-8 50 2-3 5 7 9-62 6",
    ": 8 71-4 7 9-80 5-7 9-90 3-4 8 500-2 7-10 2 4-8 20-3 7 9 31-3 5-6 8-41 4-7 50-2",
    ": 4-6 9-63 5-6 8-9 71 5 8 80-1 3-5 7 9-90 3-4 7-9 601 3-6 8-10 2-4 6-22 4 6-31",
    ": 3-4 6 8-43 5 51-4 6 8-65 7-8 71-90 2 4-700 2-3 5-10 4 6-7 21-2 5-6 8 30-2 7",
    ": 9-40 2-3 5 51-5 7-64 6 9-72 4-6 80 2-5 7-8 90 2-3 5 7-8 800 2-6 9 11-2 7 9",
    ": 21-3 5-9 32-3 5 7-9 42 4-7 50 2-3 7-9 62 6 9 71-2 6-8 80 2-3 9 91 4-901 3-5",
    ": 7-10 2-7 21-6 9 31-4 8-40 3-4 6-9 54 60 2 4 6-8 70-3 6 9-80 3 5-7 90-1 4 6 8",
    ": 8000-4 7 9-10 2-3 7-8 20 3-7 9-31 3-7 9-40 4 6-8 50-1 5-7 9-64 6-9 74-6 80-3",
    ": 5-8 90 2-6 9-103 7 9-10 2 4 6 9 22 4-33 7-40 4-7 9 52-7 9-63 7-70 2 5-8 80-1",
    ": 5-6 9 94-5 8-9 202-3 6-12 7-8 24-7 30-4 6-41 4-7 9-51 4-5 8-65 7-71 3-4 7-83",
    ": 5-91 3-4 8-300 2-3 5-9 11-2 4-6 20-4 6-7 9-30 3-6 8 40-5 8 50-1 4-5 61-70 3-9",
    ": 81-4 6-8 90-2 6-7 9 401-7 9-11 5-20 2-6 30-9 43 6 50 4-6 8 61 3-5 7-75 9-82 4",
    ": 7 9-90 2-3 5 9-505 8 13 6 9-23 7-9 32-3 5-9 42-4 6-52 4-6 8-63 5-7 70 3 5-7",
    ": 80-1 3-6 90-2 5-7 9-601 3-5 8-9 11 5-7 9-20 2 4-7 9 32-3 6-7 40 2-5 7-9 51-2",
    ": 5-6 9-63 7-70 4-5 8-9 81 3-4 6-7 9-90 2-700 3-4 6-10 2 5-6 8 20-3 5-9 32-3 6",
    ": 41 4-50 2 4 6 8-60 2-3 5-70 6 8-9 82 5-6 8 92-3 6-807 10 2 6-7 9 21-8 32-40 2",
    ": 4-8 51 3-5 7 9-60 2-6 9-71 3 6-83 6 8-93 6-8 901 4 6-8 14-8 21 3-6 9 31 3 5-8",
    ": 40 4 7-8 51 3 6-7 9 61 3-4 6 8-70 2-3 8-80 2-4 7-8 91 4-5 7-9",
    ": 9001 3 6-7 12 4-7 21 5 7-8 30-1 5-8 40 3 5-7 50 2-3 5-8 61-7 9 72 5 7 9-81 3",
    ": 5-104 6-7 10 3 5-6 8-20 2-9 31-6 40-1 4 8-9 53-5 8-61 5 7 9 75 8 81-6 9-90 2",
    ": 4-7 9 201-3 6 8 10 2-4 7 20-3 5-6 8 31 3 5-6 9 44-5 9-55 7 9-61 3-4 7 70 3",
    ": 9-81 3-6 8-95 7 9 301 3-4 6-7 10 3 5 7 9-20 2 4 6 30-2 4-7 41-3 5 8 50-2 5-8",
    ": 60-1 3 5-6 8-9 73-4 6-7 80-3 6 8 90-3 7 9-400 3-5 9 11 4-6 8 20-1 6-8 30 3 7",
    ": 9-43 5-7 9 51-2 4-5 7-9 61-2 4 7 70 2 5-8 80-2 8 90 3 6 8-9 501 3 6-7 10 2",
    ": 4-5 20-1 3-8 31-2 4-7 9-40 2 4-6 9 51-3 5-7 61-2 6-9 74 6 8-80 4-9 91-5 7-600",
    ": 3 7-12 5 7 9 21 5 8-9 32 4 6 8-40 5-6 50 5-6 8 61 5-6 71-2 5-9 84-5 8-91 3 7",
    ": 9-704 6-9 11 3 7 9 22-3 5 8-9 32-7 9-41 5-6 8-9 52 4-7 60 5-6 8 70-2 4-7 80 3",
    ": 5-7 93 6 8-9 802 4-5 8-12 5-7 9-22 4 7-32 4 6-7 9-42 4-5 7 52 4 8-9 62-5 7",
    ": 9-73 5-7 80-3 5-9 91 3 6-8 900-1 4-6 8 12-3 5-6 8 20 2 5 8 31 4 6-9 42-3 5",
    ": 7-9 51 3-6 8-61 5 8-70 2 4-5 7 82-4 8 90 3-5 8-9",
    ": 10003-4 6 11 4 6 20-2 4-8 32 4-5 9-40 3 5 7 50 2 4-5 7-8 61-2 4-7 71-4 6-8",
    ": 80-2 4-5 8-9 91-2 6-7 101-4 6 9-10 2 4 6-20 2 4-31 3 5-7 9-40 2-6 8-9 51 3-5",
    ": 7-8 61 3-4 6-70 2-4 6 8-9 81-2 5 7-8 90-3 5-7 200-1 3-5 7-9 13-4 8-20 2-4 6",
    ": 30-2 4-6 9-41 3 5-8 52-7 9-61 4-5 8-73 6 80-3 90-2 4-6 8-9 301-2 5-11 3 5-6 8",
    ": 21 3-6 31-3 6-7 40-7 9 52 5 7 9-60 4-7 9 71-2 4-6 9-81 3-4 7-8 90-1 4 6 404-5",
    ": 7 9-17 9-21 3-30 2-5 8-45 7-52 5-7 62 4-7 9 71-3 5 7-9 84-6 8 90-1 3-6 9-500",
    ": 2-4 6-8 11 4 6 8 24-5 9-32 4-6 40 3 9 53-5 8-61 3 6-7 9-70 2-3 5 9 82 6 8 90",
    ": 2 4 602 4-5 8 10 2 5 8-21 4 9 32 4 6-7 9 41 3-4 7 9-53 6-62 4 6-8 71-5 7 9",
    ": 81-3 9-95 7 700 3-11 3 6-9 21-3 7 31-2 4-5 9-43 7 9 51-2 4-8 61-8 70-1 3 5-6",
    ": 8-9 81-4 6-7 9 91-3 5 7-9 801 3-7 9-13 5-6 9 21 3 5 8-33 8 40-2 4-5 7-50 2",
    ": 4-8 62 6-7 9-71 5-80 2-3 5 7-8 90-2 4 6-902 7 11-3 6 9-21 3-7 31-3 5-7 9 41-6",
    ": 9-50 3 6 60-2 4-5 7-8 70-1 4 8 81 3 5 7 9 92 4-7 9",
    ": 1002 4-5 8-9 11 4-5 8-20 2-7 9-33 8-40 7-52 4-5 8-61 3-5 7-9 71-3 5-90 4-6",
    ": 8-102 5-6 11-5 9-20 3-5 7-9 33-4 6 8 40-1 4-6 8 50-61 3 6-7 9 71-2 4 8-9 81 5",
    ": 7-8 91-4 6-7 9-200 2-8 11-2 5 7-9 23-4 7-8 30 2-5 8-9 41 3-4 6-7 9-53 5 7-8",
    ": 60 2 4-5 7-8 70 2 7 9-82 5 7 9-92 4-6 8 300 2 4-9 11 3 5-6 20 2-4 7-8 30 2-4",
    ": 7 9-40 2-4 6 8 50 3-7 9-61 3 8-9 71-3 5-81 3 5-7 9-91 5-8 401-6 8-10 2 4-5 9",
    ": 21-2 8 32 4-5 40 2-3 7 9 51-2 4-8 60 2 6-9 71-2 5 8 82-4 7-8 90-1 3-4 6 8",
    ": 500-3 5-10 2 4 6-8 20 2-4 7-9 33 5 8-9 43-4 7-9 52 4-5 8 60 4 7-8 70-2 4 8-9",
    ": 81-3 5-8 92-606 13-6 8-9 22 4-7 37 40 2 5-51 5 9-60 3-6 9 75 7-9 81-2 7 90 2",
    ": 4 7-701 3-8 10 2-4 6 8 22-5 7 9-30 4 6 41-2 4-6 50 4-5 7-70 2-3 5-7 9-82 6-8",
    ": 91 4 6 8 800 2-4 7 9 12-4 8-20 3 7-9 31-3 6-7 9-40 2-4 6 8-9 51-2 7-8 61 3-7",
    ": 70 2-4 8-80 2-3 7-8 90 2-8 900 4-17 21 4-5 8 33 5-7 40-4 6-9 51 4 6 8 60-1",
    ": 3-5 8 70 2 4 6-9 82 4-5 9-91 3-5 8",
    ": 2000-2 4-5 7-10 3 9-20 2-4 6-8 30-1 3 5-7 9 42-6 50-1 3-8 60-1 4 6-7 71 5",
    ": 9-80 2 5-6 8-91 3-4 6 8-100 6-7 11-6 20 8 31-3 5-6 8 40 5-6 8-50 2-5 9-63 5-6",
    ": 8 71-3 5-80 2 4-5 7 90-1 3 5-6 8-204 6 10-1 3 5 7 9-21 5-6 33-4 6 8-9 43-4",
    ": 7-50 2-3 7-8 61 3-4 6 8-71 3-7 80-3 5-7 9 91-3 5-7 9-300 2-4 6-7 9-10 2-4",
    ": 8-24 6-31 5-7 41-3 5 7-8 50-3 5-9 61 3 5-8 70 4 6-80 4 6-7 9-91 3-4 6-8 400-1",
    ": 4-7 9 11-2 4 6-7 9 23-4 7-8 31 3 6 40 2 7 9 53-7 60-2 6 9 71-2 6 8-81 3 6-8",
    ": 90 2 8 500 4-8 10-5 7 22 4 6-30 3-4 7-8 43-4 6-8 51-2 6-8 60-3 7-73 5-9 83",
    ": 5-7 90-3 7-600 4 7 9-11 7-8 20-3 6 8-9 36-9 44-5 52-3 7-9 61 3 7-70 2 4 9",
    ": 81-2 5-92 6-7 703 6-8 10-2 4 6 8 20-4 6-46 50-2 4 8 60-3 5-7 9-71 3 5-6 8-81",
    ": 4 7-91 3-5 9-800 2-8 10 3-5 7-8 21-4 6 8-33 6-7 9-43 5 7-8 53 6-8 60-2 4 9 71",
    ": 3 5-7 82-4 9 92-3 5-6 8 900-1 6 9-10 5 9-20 2 4-5 7-8 30 8-40 4 7-8 50 2-3 6",
    ": 9 61-2 4-6 73-80 2-3 5-7 9 91 3-5 7-8",
    ": 3000-2 6-11 3-4 6-20 2 7 9-31 3-4 7-8 41 3 5-6 9-51 3 8-9 61-4 8-72 4-6 8-80",
    ": 2-3 7-8 92-5 7-8 100 2-3 6 8 11-5 9-20 3-5 7-8 30 5-6 8-42 5 7 53-4 6 61 5-6",
    ": 8 70-3 7-86 8-96 8-9 201-2 4-7 9-16 20-1 3 5 7-8 30 3 5-7 9 42-3 5 7-8 50 2",
    ": 5-8 60-1 4 7 70-1 4-6 8 86-8 92 5 7 9 301 3-4 6-9 12 5-6 8-21 3-6 8-9 32-5 7",
    ": 9 42 6 8 50-5 60 2-5 7 70-1 4 6-7 9-88 91-3 7-402 5-9 11 3-5 7-9 21 4-6 8-9",
    ": 32-8 40-1 3-5 8-51 3 5 7 9-62 4-5 7-70 3 7 81-4 6 8 90-1 4 6 9-500 2 4 8 11",
    ": 4-5 7 20 2 5 7-8 30 2 4-43 6 50 4-6 8-61 4 6-8 71-4 6-8 80-2 4 6-92 4-7 9-608",
    ": 10 2-3 6 8-9 21 3-4 6 8-32 4-6 9 41-2 6 8-50 2-4 6 9-60 2-4 6-7 9 72 4 6 8",
    ": 82-4 6-7 9 91-3 7-704 6-8 10-6 9-21 3 5-7 9-30 2 4 6 9-42 4 6-8 50-1 5-6 9-60",
    ": 2-4 6 8 70-4 6-8 82 4 6 8-92 4-9 802-3 5 8-13 5-6 8-22 5-8 32 6-7 9 41-2 4-6",
    ": 8-9 52-5 7-8 62-5 8 70-3 6-7 80-2 6-7 9 91-8 903-7 9 11 3-5 7-8 20-2 4 6-7 30",
    ": 2-3 7-8 40-6 50-1 4-5 7 9-61 4-6 70 2-3 5 7-88 94-8",
    ": 4000-2 5-6 8-14 8 20 2-7 9 31-2 5-43 7-9 51-2 6-60 2-4 6-7 9-70 2-6 80-3 5 7",
    ": 9-90 2 5-6 8-9 101 4 8-12 5-6 8 20-3 5-30 2-3 5-8 41 4-5 7 9-51 3 5-6 8-64 6",
    ": 9-73 5-6 8-80 3 6 90 2 5-7 9-203 5-8 10 2-4 8-22 4-32 4-5 7 9-40 4 6-7 50-6",
    ": 8-60 2-7 9 71-2 4-7 9-84 6-7 91-3 7 9 301 4-5 7-10 2-3 5-9 22-3 8-35 7-8 40-2",
    ": 4-6 8-51 6-8 62-3 5 7-8 71-3 5-6 8-81 5 7 92-4 9-401 3-4 6 8 10 3 5 7-26 9-38",
    ": 41-3 5-8 50-1 4-6 8 62 5-6 9 73-4 6-7 9-80 2-3 6 8-96 9-503 6 8 10-1 4-6 9 21",
    ": 4-6 9 32-6 9 43-5 7-51 3 5-60 3-4 6 8-72 5-6 9 81-2 4-5 7 9-90 2 4-9 601 4-7",
    ": 10-7 9 21-3 5-7 9-32 5 7-8 40 2-4 6-51 3-4 9-62 4 8 70-1 5 7 9 81 3-4 8-9",
    ": 91-2 4 9 701-3 5-6 8-13 5-8 20-1 4-8 30-1 4 8 40 2-3 8-50 2-3 5-9 62-4 70 6 8",
    ": 80-2 4-5 7-92 4 8-9 801-2 5-8 10 6 8 20-3 5-9 31-2 4-5 7-47 9-52 6-9 61 3-6",
    ": 8-9 71-2 5-9 83 6 9 91 5-900 2-4 6 8-11 4-20 2-4 6-8 30-3 5 7 9-44 6-7 50-2 4",
    ": 8 60 4-9 72-4 6 80-3 5-8 90 2-4 6-8",
    ": 5000 3 7 9-11 4-5 9-24 7-31 3 5-7 40-1 6-8 53-8 60-1 4-6 73 5 7 9-85 7-90 5-7",
    ": 100 2-4 7 9 11 4-5 8-22 8 30 2-4 7-8 42-4 6 8-51 3-6 8-61 4-7 9 71 3-4 6-8 80",
    ": 2-3 5-6 8 90-5 8 200 2-4 6-8 10-1 3-6 9 21 3-8 30-1 3-7 9 43-4 6 50 2 7-60",
    ": 2-7 9-70 2-8 80 2-8 90-1 3 5-7 301-2 5 8 10 2 4-5 7-20 2 4-5 8 31-2 4-8 42-5",
    ": 7-55 9 62 5-6 8-9 71 3 6-8 81-2 5-91 4-5 8-401 3-4 6-8 10 2 4-7 20 2-5 8-30",
    ": 3-9 41-2 4-6 8 53-4 9-61 3 5 7-9 71-2 4-8 80-5 7 9 91 3 6-500 2-5 7-10 2 5-6",
    ": 9-20 2-7 9-30 2-5 7 9-42 4-5 7-50 3-6 8-62 4 7-8 70-3 5-81 4-6 9-90 2-9 602",
    ": 4-7 9-12 4 6 8-21 5 7-31 3-6 9-44 9 51 3-5 7-9 61-3 7 70 2-3 7-84 6-90 3 5",
    ": 7-9 701 3 6 11 3-6 8-20 3-4 6-9 31-7 41-5 7-9 52-4 6-7 9-61 3 5-6 71-3 5-6 8",
    ": 80-1 3 5 7-90 2-8 800-1 3 5-7 11 4-5 7 9 23-4 7 30 2-43 6-7 9-51 3 5-6 8-9",
    ": 64-5 71-4 6 80-2 6-93 6 8-902 4 6 8 10-4 6-8 20 2-5 7-34 6-7 9-43 5-7 9-51",
    ": 3-6 9-62 6-8 70 4 6 8 80 2 4-7 91-2 5-9",
    ": 6002-7 9 11-22 4-5 7 9-31 3 5 7-40 2-3 5-6 8-52 4-6 8 60-2 5 8 72-5 8-83 5-90",
    ": 2-6 8-9 101-2 5 7-9 12 5 8-20 2-3 6 30-4 6-7 9 41-3 5-8 52 5-6 8-60 2 5 70-3",
    ": 5-9 82-3 6-9 91-7 9 201-4 6-8 10-4 7-20 2 4 6-7 9-30 2 6-8 42-4 6-52 4 6-8 60",
    ": 2-3 5-7 70-2 4-5 7 80-6 8 90-3 5-6 8 302-3 7-9 13-8 21-5 7 9 31 9 42 4-5 7-9",
    ": 51-6 8-9 61 3-5 7-9 71-4 6-9 81-7 92 5-8 401-2 4-6 8 11 3 6-7 9-21 3 5-32 4",
    ": 6-40 3 5-8 51-5 8 61 3 6-9 71-4 7 9-81 3-4 6 8-90 2 5-9 501-3 5 7 9-10 2 4",
    ": 6-7 20-3 5 7-8 31-2 5-7 9-45 7 9 53-4 7 9-63 6-70 2-4 6-80 2 4 6 8 92-4 6 600",
    ": 4-9 11-2 4 6-8 20-2 4 6 8 31-7 9 41 4-5 7-8 51-2 4-62 5 8-9 72-3 5-6 8-84 6-7",
    ": 9 91-2 4 6 9-702 4 6 8 12-4 6 8-9 21-2 4-6 32-3 5-9 42 5 7-8 52 4-5 8-9 61-5",
    ": 8-9 71 3-6 8 80-2 4 6-90 2-3 5-6 800 2-3 5-6 8-12 4-5 7 20 3-31 3-5 7 9-42",
    ": 6-7 9-50 6-60 3 7 70-4 8-9 81 3 6-93 5-7 9 902-3 7 10-4 7-9 21 3-4 31-3 5 7",
    ": 9-47 50-1 3 5 7 9 62 6 72-81 3 5-9 91-3 5",
    ": 7000-2 4-6 9-12 4 7 9 21-3 5 30-2 5 40 2-3 5 7-9 51 3-5 8-9 63 5 8 70 3 6-7",
    ": 80-2 4-8 92-3 5-6 101-2 4 6 8-9 11-3 8 23 6 30-4 6 8 41 4 6-8 52-5 7 9 61-4",
    ": 8-9 71-5 8-80 3 5 7 91-3 5-200 4 9-15 9-20 2-3 6 9-31 3-4 8 40-2 4 6 50-4 6-7",
    ": 9-60 2 4-73 5-6 8-9 82-4 6 8-92 4-301 5 7 10-1 3-6 8-20 4 8-32 5-9 42-9 52-4",
    ": 6-9 63-5 7-9 72-3 5 7-86 9 91-6 8-400 2-5 7 9-10 2 4-9 21 3-9 31 4 7-9 41-3",
    ": 6-8 52-8 61-2 4 8 70 4 6-7 9 81-2 4-5 7-9 91 4-8 501-3 5-6 8 13-6 20-5 9-31",
    ": 4-43 5-6 8 52-9 63 6-7 70-2 4-6 8 82-6 8-91 4-7 9 601 3-6 9 12 4 7 9-23 7-9",
    ": 31-2 4-40 3-51 3-60 2-3 5-6 9 72-5 7-9 83-4 8-90 4-706 9-10 3-6 9-25 8 31-3",
    ": 7-9 41 3-4 6-7 9-50 3-7 60-2 4-6 8 70-1 3-4 6 8-81 5 8-91 4 6 9 802 5-6 8 10",
    ": 2-5 7-23 7-30 2 4 7-8 41-2 4-5 8 50-1 3-8 61 3-4 6 74-5 7-9 81 6-9 91-2 5-6 8",
    ": 900 3-4 7-9 12-4 6-7 9 21 3-5 7 31-3 8-40 2-6 9-51 5 7 9-63 5-73 5-7 9-81 5-8",
    ": 91-4 6-8",
    ": 8000 3-4 11-2 4-6 8-21 3-7 30-2 4 6-8 40-3 6 9-51 4-5 7 60-1 4 7 70-2 6-8",
    ": 81-2 4-5 7 94-5 103-6 8 10-7 9-21 3 5-7 9-30 2-3 5 7-41 3 5-50 2 8 61-2 5 7-9",
    ": 71-5 7-80 2-5 8-91 3-4 7 9-200 2 8-9 11-8 20-2 5-8 30-2 4 6 8 43-4 6-9 51-4",
    ": 7-9 61-71 4-6 8-83 5-6 8-90 2-9 302-3 6 8-11 3-6 8-22 4 6-7 9-31 4-40 3-4",
    ": 6-53 5-7 64-5 7-9 72-4 6 8-80 2-3 5-8 91-2 4 6 400 2-3 5-8 11-4 6 9-21 4-33",
    ": 6-7 9-41 4-7 50-2 4-8 60 3-6 8-70 2-4 6 8-9 81-2 4 7 9-503 8 10 3 7-22 4 6-31",
    ": 3-4 6-7 9-50 2-3 7 9-61 4 9-72 4-6 8 80-2 7-8 90-2 4-5 8-600 3-9 16 9 21 3-36",
    ": 8 40-1 6-50 2-4 6-7 60-5 7-8 70-8 80 2 8-91 4 6-701 3-6 8 10 2-4 6-8 20-5 7-8",
    ": 30-4 9 41 3-7 50-3 5 7-60 3-4 6 8 71-4 6 9-84 9-91 3 7 9-803 5-8 10-3 5-6",
    ": 8-23 5-8 30 2 5 8-41 7-9 52 4 61 4-7 9-70 2-5 7 81-2 5 7-90 2 4-6 8-902 4",
    ": 9-13 5-7 9 22-3 5 7-8 32-8 40-1 3-5 7-9 51 3-6 8 62-3 5 8 71 3 6-8 80-1 3-8",
    ": 90 2 4 6-8",
    ": 9001 6 8-9 12-3 5 7-20 2-6 8 31-2 4-5 7-9 42-3 5-6 9-52 4-5 7-8 60-6 8 70-6 9",
    ": 81 5-6 92-4 6 8-9 102 4 7 9 12 6-7 9 21-37 9 41-2 4-5 7-8 50 2 4 8-62 4-7 9",
    ": 71-7 9-80 2-7 91 4-5 7 9-201 4 6-7 11 4-20 3 8 30-2 4 7 41-2 4-6 9-52 4-6 8-9",
    ": 61 3-79 81-4 9 91 300 3 6-17 9-22 4 6-30 3-5 7 9-40 2-5 7-50 3-6 9 61-5 7-8",
    ": 71-81 4-6 8-9 91-2 4-6 8-404 7-8 10-3 6 8-9 21-3 6-9 31 3-7 9-40 2 5-9 51-2 4",
    ": 6-7 9 61-2 4 6-8 70-5 8-81 3-4 7 9 91-5 7-8 500-8 12-3 5-21 4-8 30-6 8-42",
    ": 4-50 2-4 7 62 9-71 3-5 7-8 80-1 5 9-91 4-6 8 600-1 4-8 11 3 5 7 9-21 3-8 31-4",
    ": 7-8 41-6 50 2-4 6 9-61 3 8-71 3-8 80 2 4 6-7 9 91 3 7-9 702-3 5 7-10 2-3 5-20",
    ": 2 4-5 8-31 3-4 6-7 9-41 3-4 7-51 3-6 8 62-3 5 8-9 74 83 5-7 90 2-5 7-800 2-4",
    ": 6 8 10-3 20 2-7 30-1 3-4 8 40 3 7-8 53-5 7-9 61-4 6-9 71 3 7-82 4-6 9 93-4",
    ": 6-7 900 2-3 5-6 8-10 2 4 7 9 21-4 7 9-32 4 6 8 40-2 5-8 51 3-6 8-61 3-6 8-71",
    ": 4-81 3-4 6-7 90 3",
    ": 5-20000 4-5 7-9 11 3-25 8 30 3-4 7-9 42-3 5 7 9 52-3 6-7 9 61-2 4-5 7-72 4-8",
    ": 80-2 5-6 8-9 92 6 9-106 8-9 11-7 21-2 5 7-9 35-6 8-41 3-6 50-1 3-5 7-8 61 3 5",
    ": 7 9 71-4 8 80-1 4-5 7 90 2 4-8 200-2 7-8 10-1 4-5 7 22-7 9-32 5 8-9 41 5-9",
    ": 52-5 8 60-2 4-5 8 71 6 9-80 3-4 6-93 5 7-8 300 3-7 9 11 5 9-22 5 30-3 5-6 9",
    ": 41-5 7-9 52-7 60-2 4-5 8-71 3 6-80 2-6 8-90 5-6 9-400 2-4 6-9 11-2 4-7 9-22",
    ": 4-5 7 9-31 4 6 8 40-3 6 8-50 3-4 9 61-2 5-6 71-3 5 7 83-5 7 92-3 5 7 500-10",
    ": 2-4 6 8-25 7 9-30 2 4 6 8-9 41-2 4 6-9 51 3 5-60 3 5-6 9 72 5 7 9-81 3-5 7-92",
    ": 4 7-8 601 4 6 8 10-20 3 7 30-2 4-8 40-2 6-50 2-3 5 7-63 5-72 5-8 81 3 5 9 92",
    ": 4-5 7-701 3 6-12 4-20 2-4 6-8 31-3 5 8 41-6 8 51-4 7-8 61 4 7-71 3 5-8 80-4 8",
    ": 90-1 3-4 6-8 800 2-7 9-15 9-20 2 4-5 7-8 31-2 4-5 9 41-4 6 50-1 3-4 6-61 3-4",
    ": 6-9 71-3 7-9 81-3 5-7 9 91 4-7 9-901 3-7 9 12-20 2-3 5-8 30-4 7-40 3 5-7 9 54",
    ": 6-9 61-2 4-8 71 3 7-8 80-4 6 8-91 3-5 7",
    ": 9-1000 2 4-5 7-12 4-9 21 3-7 9 32-9 42 5 9-51 3-5 8-60 2 4 6-7 70 2 5-81 3 6",
    ": 8-9 91-3 5-6 8-102 5-6 8 10 2 4 7 9-22 5-7 9-30 4 6-7 9 44-7 9-50 5 8-61 3-72",
    ": 4-6 8-80 2-3 7 90-1 9-206 8-9 11 3-4 6-21 3-4 6-31 3-4 7-9 44 6-8 50-3 6-8 60",
    ": 2 4 6-8 72-4 6 8 80 2-4 8 90-1 4-6 8-307 9 12 4 6 9-21 5 8 32-3 5-7 9-40 3 5",
    ": 7-9 55-8 61 3-4 8 71-2 5-6 8-9 82-5 7 91-3 5-402 5 7 9-12 4-8 20-1 3-4 6-34",
    ": 7-9 41-4 6 9 51-4 7-62 4 6-70 2-3 6-7 9 82-4 7-93 6 8-500 3-6 10 2-3 5-21 5-7",
    ": 30 2-5 7 9-43 5-6 8-51 3-5 7 9 61 3-6 8-70 2-3 5-6 9-82 5-6 8-92 4-5 7-8",
    ": 600-3 5-7 9 13-5 7-9 21 3-5 7-9 31-2 4-6 8 40-4 6-9 56-7 9 63-9 72 5-7 9-80",
    ": 3-8 90 2-3 6 9-700 2 7 9 11-4 8-25 7-32 5-7 9 41-3 5-52 4-5 9 62 4-6 8 70-3 5",
    ": 7 81 3 5-6 8-92 6-7 800-1 3 8-9 11-9 21-3 5-7 9-31 4-5 7-9 41 3-6 8 50 3 5 8",
    ": 60 4-5 8-9 71-2 4-5 7-80 2-5 7-8 91 3-7 9-902 4 6-7 9-14 7 9 21-2 4-5 7-46 8",
    ": 50-1 3-9 62-4 7 70-1 5 7-8 80-3 5-7 90-2 4-5 8",
    ": 2000 2 4-6 8 11 4-6 21-2 4 6-8 32-4 6 8-9 41 4-5 8 50-2 5 7 9-60 2 4-9 72",
    ": 4-83 6-9 91-3 6-8 102-9 12-3 6-7 9-24 7-9 31-3 5-6 8-47 50-3 7-64 7-76 9-83 5",
    ": 9-93 6-8 201-8 10-3 5-6 8 21 3 5-7 9-30 3 5 7-41 3-4 51 4-6 8-9 61 4-8 70-2",
    ": 4-5 80-1 3-5 7-8 91-6 9 301 3 5 7-11 5-7 9 22 4 6 8 30-1 4 6 9 41 5-7 9-52",
    ": 4-5 7 9-62 5-9 71-3 5 7 80 2-4 6 8-403 11-3 8 21-4 7 30-2 5 8 40-5 9-52 4 6-7",
    ": 61 6 9 72-4 8-80 5-96 8 501-5 7-15 8 23 6-8 30 3-4 7 9 41 3-5 7-51 3-6 9-61",
    ": 4-7 9-71 3 5 7-81 3 5-90 6-604 8 10 2 4-20 2-4 6-7 30-4 6-41 3 6-7 9-51 3 5 8",
    ": 60 2-5 8-70 2-9 81 3-4 7-9 91-3 6-9 701-2 4-6 8 10-2 5-6 9 25-7 9-30 2-40 2",
    ": 6-7 50-2 4-5 7-8 60-2 5-7 9-74 6-8 80-1 3-7 9-90 2 6-801 4-6 8 10 5-8 21 3-4",
    ": 8-31 5-6 8-9 41-7 54-5 62 7-9 71-2 5-6 8-81 3-7 9-90 6 8 900-2 4 6-8 11 3-4",
    ": 6-21 3 5 7-31 3 5 7-9 42-7 9 53-6 9 62-7 9-70 2-4 7-8 80-3 5 7-8 90-3 5-7",
    ": 9-3001 7-10 2-3 6 8 21-2 6-33 5-7 9-44 6-7 9-51 3-4 6-60 2-5 9-70 2-4 7-85",
    ": 8-93 5 7-9 102-3 5 10-1 3-5 7-8 20-7 9-35 8-9 41 4-54 6 8-61 3-4 8 70-5 82-4",
    ": 6-99 204-13 5-7 9 21 3-4 7 9-30 2-3 5 7-8 40 3-50 5 7-60 2 4-5 8-70 2 4 7-8",
    ": 80-1 3-5 7-90 2 5-7 302-6 9-10 3-4 6-27 9-31 3-4 7 9-43 5-6 50 2-3 5 7-8 61-3",
    ": 8-9 71-4 6-81 4-5 7-8 90-2 7-401 4-9 13-7 20-1 3-4 6-8 30 3-4 7-43 5-55 8",
    ": 60-1 6 9 71 3-4 7-9 81 4 6 8 92-3 5-7 500-5 9 12 4-6 8 20-2 4 6-7 9-31 3 5",
    ": 7-41 5 7-8 50 3 5 7 9 61-4 6-8 71-4 6 80-2 6-7 90 3 6-7 600 3 5-7 9 11-5 7 23",
    ": 5 7-8 30-2 4-6 8-40 2-6 9-54 6 9-61 3-4 6-7 9-73 5 7-8 80 3-4 6-8 92-3 6-7",
    ": 701 3-7 11 4 6-20 3-6 8 33-9 41-8 50-4 7-60 2-4 7-8 71 3 5-6 8 81-4 6-7 9",
    ": 92-3 5 7-8 800 2-5 8 10-1 4-8 23 5 7 9-30 2-5 7-8 40-2 4 6-7 9 51 3-5 7 9-63",
    ": 5-6 9-70 3 5-6 8 80-5 8-90 2-4 7-8 901-2 5 8-10 3-6 8 20-4 6-35 9-43 5-7 50",
    ": 2-3 5-9 62 6-9 71-2 5-7 80-1 5-6 92-3 5-6 8",
    ": 4001-10 4-7 20-2 4 6-7 30 3-4 6 8 40 2-3 5 7-8 50 2-5 9-60 2-6 8-73 5-6 82-4",
    ": 6-7 91-2 4-8 100-4 6-7 9-11 4-7 9 22 5 7-9 31-3 6-41 3-6 8-51 3-7 9-62 5 9",
    ": 71-3 5 7-8 82-7 9 93-4 6-8 200-4 7 9-10 3-5 9 21 3 5 7-9 32-3 5-7 42-5 9 51-2",
    ": 5-9 61-71 3-81 3 5-9 92-8 300-6 8 12-3 7 9-23 6-33 5 7-44 7-52 4-5 60 3-5 8",
    ": 73 5 7-9 81-3 5-90 2-7 400-1 3-5 8-21 3-5 7-30 4-5 9-41 4-6 9 51-9 62 4-5",
    ": 9-70 2-8 80-1 5 7-8 90 4-8 501 6 8-10 2 5 8-22 4-6 8-9 33-4 8 40 3 5-7 52 5-6",
    ": 8-9 61-2 4-5 9 71-4 6-7 9-80 3-4 6-9 91-2 6 9-600 6-9 13-6 8-9 21-3 5-7 9",
    ": 32-6 8 40-3 6-9 54-5 8-9 61 3-7 70-3 5 7-8 80 3 6 8 91-4 6 8-9 702-3 5 7 9-10",
    ": 2-4 6-7 9-22 4 6-7 9 32-9 41-2 4 6-7 50 2-3 5 7 9-60 5-9 71-3 6-7 9-80 2-3",
    ": 5-6 9-91 3 5 8-800 2 5 9-12 4-5 7-8 20-1 4 7-9 31-3 5 8-42 4 6-9 54 6 9 61-2",
    ": 4-70 2-3 6-8 80 6 8-90 2 4 6 8-9 903 5 7 9-12 7 9 25 9-30 3-4 6 8-41 3-4 6",
    ": 50-5 7-62 4 6-9 71-5 7 80-1 3-4 6-7 90-2 4-5",
    ": 5001-2 4-5 7 10 5 8 20-6 9-32 4 6 9 41 3-5 7 50-1 3-5 7-60 2-3 5 7 9-74 6-8",
    ": 80-3 6-7 90-2 5-6 8 100 2 6-8 11 3-6 9-20 4 6-7 31 3-6 9-42 4-5 7-9 52-3 5-8",
    ": 60-2 5-6 8 76-8 80-5 7-93 5 7 200-4 6-12 4-5 9-20 2 9 33-4 6-7 9-40 2-5 8",
    ": 50-5 7-8 60-3 5 7-9 71 4-5 9 81-2 4-7 9 96 8 300 2 5-7 11 3 5-6 8-9 22-5 7-30",
    ": 2-7 41-3 5-7 50-2 4 7 9-60 2-3 5-7 72-3 6-9 81-2 4-6 8-90 2-7 400-2 5-9 11-7",
    ": 20-1 3 5-7 9-31 3-4 6-7 9 41 3-7 9-50 5-7 9 61-4 8-9 71-84 7 9-92 4-5 7-500",
    ": 2-4 7-9 11-3 7 20-1 5-6 8 31-3 7-41 6 8 50-5 8-9 61 5-6 8-70 4-6 8-81 3 6-9",
    ": 91-5 8-602 8-9 12-4 8-9 21 4-5 7-35 8 40-1 3 5 7 50-1 4-6 9-60 2-3 5-9 71 5",
    ": 8-9 81-3 5 9-95 9-702 4-9 11-5 7-8 22 4-6 8-31 3 5-7 40-2 4 8-50 3 5-60 3",
    ": 7-71 3-6 8 82 4 6-7 9-90 5 7-8 800-1 8-12 9-20 4-5 8-32 5 7 41-8 50-4 6 9-62",
    ": 4-7 9-74 8-80 2 7-9 91-2 4-8 901 3-4 7-10 4 6-7 21-3 5-6 8 30-3 5-8 40-1 4-5",
    ": 9-51 3 5-8 60 2-3 5-8 70 2-3 5-7 9-81 4 7 9-91 3 5-9",
    ": 6002 5-8 11-3 5 8-9 21 3 5-6 30-1 3-6 8 43 5-9 51-4 7-64 7-8 70 2 5-8 80-3 5",
    ": 8-91 3-6 8 101 4 6-7 9 13-7 9-22 4-9 33 5-40 3-8 51 3 5-6 8 60 2 4 7-71 3 5",
    ": 8-9 81 4 7-91 3-4 6 8-9 202 4 10-1 3-20 2-4 6-8 30-2 4 7-9 41-6 8-51 4-6 9-60",
    ": 2-3 6-7 73 5-7 9-80 5 7-9 95-300 4-5 7 12 4 6-8 21-6 8-9 31-5 40-3 5 7-56 8",
    ": 63-75 8-80 4 7-93 5-400 3-5 8-12 6 8-9 22-5 32-6 8-40 2-5 7 9-50 2-8 60-1 3 7",
    ": 71 3-4 80-1 3 6-8 90-1 5-8 501-5 7-10 2 5-21 3 6-7 9-31 4-6 9-42 4-5 9-53 5",
    ": 9-67 9-72 4-5 7-8 80 2-5 7-97 600 2-3 6-7 11-2 5 22 4 6-9 32-41 3 5-52 4 6-8",
    ": 60-1 3-4 7 9-76 8 82 5 7 92-3 5-8 700-4 6-9 11-3 5-9 21-3 6-8 30 2 5 7 41-2 5",
    ": 7-52 5 7-8 60 2 4-72 4-81 3-4 6-8 90-1 5 7 800 2-3 5-12 5-23 5-7 9-31 3-5 7",
    ": 9-41 3-4 9 54-8 61-2 4-5 7 70 3-6 8-9 83 7-93 5 7 904-8 11-3 6-7 9 21-2 5 7-9",
    ": 32-5 7-40 2-4 6 8-9 51 5-6 8-9 63 6-7 70 2-80 2 4-5 7-92 4 6-7",
    ": 9-7001 3 6 8 10 4-9 21 5-6 9-30 2 4-5 7-9 41 3-4 8-51 3 5 60-1 3-71 3-9 81-2",
    ": 5 9 91 3 5 7 9-100 2-7 9 11-5 20 4-5 7 31-4 8-41 6 9 51-4 6-7 60-4 8-9 72-4",
    ": 6-7 9 82-3 6-7 9-91 3 6-200 2-3 5-11 3 5-6 8-20 3-5 7-8 30-2 4-5 7 40 2-6",
    ": 9-51 3 5 8 60-1 3 6-8 70 2 5-6 9-84 6 90 3-5 7-9 301-5 7-8 11 3-4 6 9-21 6 8",
    ": 31-2 4-5 9 41-2 4-6 8-51 3 6-8 61-2 4 6 8-9 71-3 7-9 81-4 7-91 3 5-7 9 401-2",
    ": 4 6 8 10 3-4 6 8 20-2 8 30-5 8-43 8 50-1 3-7 63-4 6-70 2 4 7 9 82 5-91 3-4",
    ": 7-8 501-3 6-7 9-15 9 22 5-6 9 31-2 4-5 8-40 2 4-6 8-52 4 6-8 60 2 4-7 70 2-4",
    ": 7-81 3-5 7 9-93 5-602 4-5 8 10-1 3-5 7-8 20-2 4 6-8 30-2 4-7 9-40 2-5 7 9",
    ": 51-9 61 3 7-80 3-4 8 94-8 700-1 3-4 7-9 11-3 5 7-20 2 4 6 30-1 3 5-8 40-3 9",
    ": 51 3-7 60 2-6 8 71 5-9 81-2 6-9 92 4-5 7 800-3 6 8-9 11 4-5 8-9 23 5-7 9-30",
    ": 3-4 40-1 4-7 51-3 5-7 9 61-3 5 7-9 71 4 6-9 81 3-4 9-90 2 6-9 901-3 5-11 3 5",
    ": 7-8 20-4 7 30 4-7 9-40 2-5 7-8 50-1 3 6-9 61 3-5 8-71 3-4 6-7 9-81 3-6 8-92",
    ": 6-8",
    ": 8001-5 7-11 4-6 8 22-9 31-2 4-5 7 40-1 3-4 6-8 51-2 4-8 60 2-9 73-4 6-80 3-8",
    ": 90-2 5-9 102-3 5 8-11 3-4 7-20 2 6 8-9 34-7 42 4-5 9-52 4 8-60 2-3 5-7 70-5 7",
    ": 9-85 9-90 2 4 6 8-9 204-8 10-8 20-2 4-6 32-3 5-40 2-5 8 52 4 7-61 3-9 71-4 6",
    ": 9-80 2-6 8-91 3-5 7-8 300 2 4-5 7-10 3 5-7 9-21 6-7 9-30 3 6-40 2 5-7 50-6 8",
    ": 60 2 5-8 72-5 8-9 81-2 4-8 90-5 7 402 5-6 8 11-3 5-6 8-9 21-6 8-9 33-4 7-8",
    ": 42-51 4 7-9 61 3-70 3-6 81 5-6 8-90 2-3 5-7 9-504 6-7 10 2-5 7-26 8 30 3 6 8",
    ": 40-1 3 5-8 51-6 8-9 61-4 6-71 3-4 6 8 80-1 3-6 8 90 2-4 7 9-604 6 11-4 6-22",
    ": 4-6 8 30-1 3 40-2 5 7 9-53 7-60 2-4 7-70 2-7 80 2-4 7-91 5-6 9 701 3-9 11-5 8",
    ": 21-32 6 8 44 7-50 2-6 8 60-1 3-6 8-9 71-2 4-6 8 84-8 90 4 6 8 802 4-7 9-10",
    ": 4-5 7-9 21 3 7-32 4 6-40 3-9 51 3 6 60-2 4-6 8 70-1 4-6 9-83 5-90 2-3 5 7-8",
    ": 900 3 5-8 10 3-5 8 21 4-7 30-1 3 5-9 41-2 4-8 51 5 9 61-2 8-71 3-4 6-9 81-3",
    ": 5-7 9-92 6-9",
    ": 9002-3 5-12 4-9 25 7 30-9 42-4 50-2 4-7 9 62-3 5-6 8 70-6 80 2-3 6-7 9-91 3-7",
    ": 9 101-2 6-7 10 2 5-6 8-20 2-4 6-30 2 4 6-8 40-4 6-7 9 51-2 4-5 7 63-71 3 7-8",
    ": 81-2 5-6 91 6-9 201-3 5 7 9-18 22 4-8 30-1 3 5 8 40-1 3-4 6-7 50-5 7-61 3 6-9",
    ": 72-9 81 3-8 90-1 4 7-300 2-3 5-7 11-3 5-6 22 5-6 32-4 6-9 41-2 6 53 5 7-8 60",
    ": 3-4 6 8 71-4 7-80 2 7 9-90 4 6 9-400 2 4 6-11 3-7 20-5 7-8 31-3 7-8 42-5 7-8",
    ": 51 3 5-7 9 61-3 5 7-72 5-7 9-80 2 4 7-90 2-3 5-6 8-9 501-2 6-7 9-13 6-8 23-6",
    ": 30-5 7 40 3 5-6 9 51 3-5 7-9 61-2 5-6 71-2 7-80 2-3 5-8 90 2 5-6 8 600-1 3-4",
    ": 6-7 9-11 3 5 8 21 3-6 9-30 3-43 5 9 52 4 7-61 3 6-8 72-4 6 8 80-3 6-91 3 5-8",
    ": 700-4 6 8-9 11-7 20-3 5-32 4-9 41-4 6-7 9 51 3-5 7-9 61-4 6-7 9 72-6 8 80 2-4",
    ": 6-7 90 5-8 800-2 4 6-9 12-4 6 9 22-3 5 8 30 2-42 4 6 8 52-4 6 8 60 2 4-5 7-8",
    ": 72 4-9 81-2 5 91-3 6-901 3-5 8-10 4-7 9-25 7-9 31-3 5-7 40-3 5-8 51-4 6-61",
    ": 4-8 70 2-5 7 9-81 4-5 7-91 3-4 8",
    ": 30000-1 3-8 10 2 4-9 22 4 6-9 31-4 6-41 4-8 50-3 6-8 60-1 3 5-8 72 4-7 9 81-8",
    ": 90 7 103-4 6 10-4 6-8 22 7-9 32 4-7 40-5 8 51-5 9-62 7-70 2-3 5 7-8 80-1 3-8",
    ": 90 2-4 7-200 2-3 6 8 10-4 6-7 9-23 5-7 30-1 3-5 8-9 41 4-5 7 50 2-4 6-61 3",
    ": 5-6 8-71 5-8 80-2 5-90 3 5-6 8 300-1 3 5 7-8 12-4 7-8 20-2 4 7-8 30 2-4 6-8",
    ": 40-2 4-5 8 50 2-3 7-60 2-76 8 80-6 8-9 93-4 6-400 2-3 5 7-8 10-1 4-5 8 20-3",
    ": 6-8 30-3 8 40-2 4-5 8-9 52-4 8 62-3 5 7 9 73 5 7-9 81-5 7 9-90 3-4 6-7 501",
    ": 3-4 6-7 9-14 7 9-20 2-4 6-31 3-5 7-8 40 3-4 6-56 8 63 7 72-3 5 7-8 80-3 6",
    ": 8-98 600-2 5-6 9-11 3-7 9-20 4 6-7 30 3-4 6-41 3-6 8-51 4-5 7 9-60 2-9 71-2 5",
    ": 8-80 3-93 5-6 8-700 2 4-6 12 5-6 21-2 5-6 8 31 6 8 40-1 3 5 9-51 4-7 60-2 4-5",
    ": 7-9 72-4 7-80 2 4-91 3-5 7 9-800 2-3 5 10-2 4-5 7-22 4-6 8 32-3 6 40 2-4 6-7",
    ": 9-50 2-3 5-6 9-60 2-70 4 8-9 82 4-6 8-90 2 9 901-2 4-6 11-3 6 20-6 9 31 3-5 8",
    ": 40 2-3 5-7 9 53 6-7 9-60 2-4 6-8 70-4 6 8 81 4-5 7-90 2-6",
    ": 9-1001 3-4 6 9-12 4 6 9-20 3 5-8 30 2-5 9 41 3-4 6-8 52 4 6-7 60-6 8 70-2 5 7",
    ": 9-80 2 4-6 9-92 9-100 3-4 6-7 9 11-6 8 21-3 5-7 32 5 7-8 41 3-4 6 8-9 51-3",
    ": 5-7 61 3-4 9 71 3 80-1 3-6 9 92 4 6-9 201 3 5-6 8-9 11 3 6-7 9 22 5 8-30 3-5",
    ": 8-41 3 5 7-8 52 4 6-66 9-70 3 6 9-80 3 5 8-92 4-5 7 301-4 6-7 9-13 6 9 21-4",
    ": 6-30 2 4-5 7 9 41-5 7 9-51 3-4 9-60 2-5 7 9 71-2 6 8-84 6-8 90-1 3-4 6-402 7",
    ": 11 3 5-6 9-20 2-8 30 2 4-5 7 41-2 4-7 9 52-4 6-7 9-74 6 80 2-3 6-8 92-4 6-9",
    ": 501-6 9-12 5-7 22 6-7 30-1 3-5 8 40 2-3 5-7 51-2 61-2 4-7 71-2 9 81 3 5-6 8-9",
    ": 93 7-8 601-2 8-9 14 9 21 4 6 8 31 3 9-42 5-7 51 3-5 8-9 63 7 9 75-7 9-82 4-5",
    ": 9 92-4 6 8 701-2 7 9-12 6-7 23-4 7 31-2 4 6-7 42 4-5 8 50 3-4 7 9 62-3 5 9",
    ": 74-6 8 83 5 8 90 2 5 7 9-800 7-8 12 4-6 9 21 3 5-8 30-1 4 7-8 41-5 7-8 50 4",
    ": 6-8 62-3 5-6 9-70 4 6-7 9-85 7 9-91 3 5 7-8 901 3 5 7-8 10-4 7 9-20 4 6-7",
    ": 30-1 4 6 8 41 3-4 8 53-4 7 9-60 2-3 6 8 72 4 8 81-2 4 6 9 92 6-7",
    ": 9-2000 2-3 5 10 3 5 7-9 22 5 7 9 36 8-43 6 8-9 51 6-60 2 6 8 70 3-4 6-9 82-4",
    ": 6-8 91-2 4 7-8 101-3 6 8 10-2 4 6 8-9 25-9 34 7-8 40 3-4 6-7 54-5 60 4 9-71 3",
    ": 6 9 81 6 9 92 4 6-8 200 6 9-11 9 23-4 30 3-4 8-9 41-3 50 2-3 8 61-2 5-7 9 72",
    ": 4-5 8-9 81-4 6 8 90-2 4-5 7 301-2 6 9 12-4 7-9 21 7 39-42 5-7 9-51 5 9-60 3-5",
    ": 8 70 3 5-6 8 81 5 7 91 3-6 8-9 402 5-8 10-2 4-7 9-21 3-4 6-8 30 2 4 6 45 8",
    ": 52-3 8-60 2-3 70-1 5 8-81 4 6 8 96-7 502 4 6 8 13-4 8 22 4 6 8-31 3-4 6 9 44",
    ": 6 9 51 3-4 6-7 60 4 8 70 7-8 80 3 6 95-6 9 602 7 11 6 8 22-4 6 8-31 5-6 43",
    ": 6-7 9 51-2 4 8-9 61 3-5 72-3 5-6 8 80 3 6 9-90 2-3 7 701 4-5 9-10 6 8 20 2 5",
    ": 9-32 5-6 42-3 6 52 4-5 7 9 62 5-6 72 4 6-7 80 2 4 9 91-2 4 6 8 800-1 3-4 6 8",
    ": 10-2 5 9 21-2 4 7 30-2 4 6 9 43 6 9-50 2-3 6 8 61 3 6-7 70-2 9 81-2 9 91 4-5",
    ": 8 900-1 4 8-9 11 3-7 20-1 3-4 7 30 2-3 6-41 3 9-51 3-5 8-9 61-2 5-6 9 72-3",
    ": 6-8 81-2 6 8-9 91-3 7 9",
    ": 3002 4-6 8-9 11 3-9 21 3 5 7 30-3 5-6 8-9 41-3 5-7 51 6 66-8 74-5 7-9 81 3-4",
    ": 90-2 9 101-2 4-7 10 2 5 7 9 21 3-5 8 30 2-4 6 9 41-2 4 9-50 5-6 60 5 9 71 5-6",
    ": 8-80 3-4 8 93-4 6 200-1 3 6 16-21 7 9 33-4 7-9 41-4 7 9-50 3 5 8-9 61-2 5 7",
    ": 70-3 5-80 5-7 92 6 304 6-7 9 11 7-8 21-5 7 9-30 3-5 43 6 8-9 51 3-4 60-1 4-5",
    ": 8 70-1 3-4 6 9-81 3 5 91-3 6 406 8 13 5 7 27 9 32 6 9 41-2 5-6 8-51 3-4 7 9",
    ": 61-4 6-7 9 72 84-5 7 9-90 6 8 504 6-7 10-2 4 7 20-1 6 8 32-4 6-7 40 2 4-7 51",
    ": 3-4 7 9 62 5-6 9 71-2 4 7-81 3-9 95-600 2-3 5 8-9 11 4-5 7-8 20-3 5 9-30 4",
    ": 6-7 41 4-5 7 9 52 9-62 4 6-8 70 2 4 8-9 82 4-90 2 5 7 9 701-5 9 11 3 5-6 8",
    ": 20-1 4-5 8-9 31 3 5 7 9 41 4 6-7 53 5 8 60 2-3 5-6 8 70 5-6 8 80-2 7 90-2 9",
    ": 801 3 5 7-9 12 5-6 9 21 4 7-9 34 7-8 42 7-8 50 2 4-5 7 9 61-2 4 6 8 72 4 6-7",
    ": 81 3 6 8-91 5 8 901-2 7-8 10 2 5-7 21-4 6-8 34-8 41 4 6 8-9 52 4-6 9 61-2 5",
    ": 9-70 2 5 83 5-6 8-9 92-4 6 9",
    ": 4003-4 6 8-9 11 3-4 8 24-5 7-8 30 3 7-8 40 2 5 7-8 50-3 6-7 9-60 2 5 7 9-70 6",
    ": 8 80-2 5 8 93 5 7 9-102 7-9 11 6-8 21-2 5-6 8-30 4 6 42-3 5-6 9-50 2-5 9-60 2",
    ": 7 9 71-2 5 7 9-81 3 6-7 9 92-3 202-5 9-11 3 7-8 20 2 4 6-8 30-1 3-4 6 42-3 5",
    ": 9 52 5 7 60 2-3 5-7 70 4 6 8 80-1 3 5 8-9 93-6 8-9 301 3-5 11 3-4 9-22 5 7",
    ": 30-2 4-5 7-9 41 8 50 2 4 60-2 6-7 9-74 7 80-1 3-5 7 91-2 8-400 3 8 10 2-3 7-8",
    ": 23-4 7-9 34-8 41 3-4 6 8-9 51-2 6 8-61 3 8 70-1 3-4 7 80 2 4-5 7 9 97 501-2 4",
    ": 7-8 10-1 3 6-21 3-5 7 9-30 3 5 7 9 41 3-8 50 3-4 7-8 60 2-4 7 71-2 6 8 82-5 8",
    ": 92 601 10 3-5 8-21 4 6 8 31-2 4-8 40 4 50-5 9 62-5 71 3 5 7 81 5-9 91-2 8",
    ": 700-2 4 7-9 13-4 6 20-2 7 30-1 5 7 42 7-50 2-3 7-60 3 5-7 9 76 8-9 81-4 8-93",
    ": 5 9-800 3-4 7-8 12-4 7 21-3 5 8 30 4-6 9-40 2 4-9 51 3-4 9 61-2 6 8 70 3 5",
    ": 8-80 3-4 7-9 92-3 7 901 3-7 10 2-3 5-6 21 4-6 8 30 5-6 9 41-2 5 8-9 51 3-4",
    ": 7-61 3 71 4 6 8-9 81-5 8 92 6 8",
    ": 5000 2 4 7 14-7 9 21 4 6-7 9 36 42 4 8 50 2-4 6-8 62 5-7 9-71 3 5-6 8 80-1",
    ": 3-4 7-8 91 3-4 6 100 5 9 11 4-7 9 24 6 8 30 2 4 6-7 9 43 50 2 6-9 63 8-70 2-3",
    ": 7-8 80 4 9 91 4 8 201-3 5 8 11-2 4 6-7 9-21 3 5 7 30-1 4-40 2-4 7-8 50-2 5-6",
    ": 8 60 2 4-72 9-80 3-5 8-9 91-4 8-9 302 4 6 8 11-2 4-6 22 31 40 2 5 9 52-4 6-8",
    ": 61 9 72-5 9 81-3 5-7 9 91-3 401 6 12-3 5 7 20 3-5 9-31 3 7 40 2-3 5 8 50-1",
    ": 4-5 60 2-3 6-7 9-70 9 81-4 9 97 500 5-6 8-9 11 3 5 8 20-1 5 8 30-1 3 7-8 43-4",
    ": 6 8-9 51 62 4 6-7 9-70 2-3 7-8 84 6 8-90 2 4-5 600 3-7 9-11 3 5-6 22 4-6 8 30",
    ": 4 7-8 40-1 4-8 50 2 4-5 9-60 2-4 9-70 2-3 6 8 81-2 4-6 9 92 4-5 7 701-5 9 14",
    ": 6-7 21-2 5-6 30-1 3 6 8 41 3-6 8 51-5 7 60-1 70-1 4-5 7-80 2 4-5 9-93 6-8",
    ": 802-6 9 12-3 5-6 8-22 5 31-5 7-8 40 2-3 6-7 50-4 7-63 6-8 70 3 5 7 81 4-6 9",
    ": 92-4 6 8-900 3 5-7 9 11-2 5 7-8 21-2 5-33 6 8-40 2 4 7 9 52-4 6-7 9-60 2-4 9",
    ": 71-4 6-8 82-6 8-90 6",
    ": 9-6000 2 4 9 12-3 7-22 4-5 9-33 6-8 42 4-5 7-51 5-7 62-3 9-70 5 8 82 5 7 9 92",
    ": 6-7 9-101 3 5 7-11 5 8 20-1 5-6 31-2 4 6-8 41 3 5-6 8 50 2-3 5 9 61 4-5 9-70",
    ": 2 7-8 80 3 5 8-90 2-3 6-200 2 4 8-9 11 4-5 8-9 23 9 31 8 40 3-5 53-4 6-9 65",
    ": 7-9 75 8 80 3 8-91 4 6 8-301 11 4 6-7 9 21 3 5-6 8 32 4 6 9 44 6 8-9 52-5 8",
    ": 60 3 5 7-8 72 4-6 8-9 83-5 9-90 3 5 8 400-1 3-4 6 8-9 11 3-4 8 21-2 4 6-7",
    ": 30-1 4-5 7-40 3-4 6 50 4-7 9 61 3 6-7 74-6 8-9 87-8 91-3 5 7-8 500-1 3-5 7 16",
    ": 8 21 3-4 6 8 30 2 4 6-40 4 7 9 52 5 8 60-1 3 5 7-8 70 2-4 6-7 9 81 3 5-6 8-9",
    ": 93-4 6-601 3 5 8 12 4-6 8 22-3 6 31-2 4 6 42-4 6 51-4 8 61 8 73-4 6 9-87 92",
    ": 4-5 7 9 702-5 7 9-11 3 6-8 20 2-4 6-9 31-2 4 6-9 44-5 7 9 52-3 6-7 60 2-3 6-8",
    ": 73 9-80 2 4-5 9 93-5 8 800 2 5 7 9 11-2 4 20-2 6-8 30 6 8-9 41-3 7-9 53-4 8",
    ": 60 2-4 6-7 9-70 5 7 9 81-2 4 8 90 2 4-5 8 901 3-4 6 10 4 6 9 28-9 32-3 7-8 40",
    ": 3 5 7 9 51-2 4-5 60-1 6 8 71-3 5-7 9 83 5-6 8-9 92 4-5",
    ": 7-7000 3-5 7 9 11-2 5 7 20 2 31 4 7 9-40 2-4 7 9 52 5-6 60-1 5 8 72-3 5-6 8-9",
    ": 81-3 5 7-90 2 4 6 9-100 2 12-4 6-22 5 9-30 2-4 7 9-41 4 6 8-50 2 5-8 61 4 7-8",
    ": 72-4 6-8 80 3 5 7-8 97-9 201-2 4 8-10 2-3 6 8 20 3 6-7 9 31-2 4 8 40-1 3 9-51",
    ": 5-7 60-1 3 8-9 71 3 5 7-8 82 4 6-8 90-1 4-5 8-9 302-3 5-6 10 4-8 21 3-5 7-9",
    ": 31-2 4 7 40 3 5 7 50-1 5 7 9-61 3-5 75-6 8-80 2-6 8-9 92-4 6-7 9-401 3-4 7-8",
    ": 11 3 6 8-21 3 5 30-3 8 41-4 6 8-9 51 4-5 9 61 3 7 70 2 8 82-3 8-90 2-3 5 7",
    ": 9-502 7-8 13-4 6 9 21-2 6-9 35-8 43-4 9 51-2 4 6 8-61 3 5-7 9 72 4 6-8 81 3",
    ": 5-91 4 6-7 600 2-3 5 8-11 4 6-8 20 2-9 43 5 7 51-2 5 9-62 5-8 75 7-8 81-3 5",
    ": 8-9 93 7 9 702-5 7 9 11-2 4 8 21 5-6 8 30-1 3 5-7 9-41 3-6 56 60 5 9-72 8",
    ": 80-1 4-5 9 93 9 801 4 9-10 2 4 8 22-4 7 9 31-3 6 8 41-6 8-50 2-3 5 8-9 61-3 6",
    ": 9-71 5-6 82-3 7-9 94 6 906 10 2-3 9-20 3-4 6-7 9 32-3 7 40 6 8 50-1 4-5 8",
    ": 61-4 7 9 71-2 7 81 3 5-9 91 4-5 7-9",
    ": 8003 5 7 10-1 4 6-7 9 22 4 8-30 3 6 41 5-6 52-3 5-6 60 2 4-6 9 71-4 7 9 82 4",
    ": 9 92 4 6 8 102-3 8 10 2-3 5-7 23 5-7 30-3 7 40-1 3-4 6-8 50 2 4-6 9 63-4 6-7",
    ": 71 6 8-9 81 7 92-4 6-7 9-200 2-5 10-1 3 21-2 4 6 8 35-6 9 41 7 51 7-8 61-2 4",
    ": 8 70-1 3 6 9 81 3-4 7-8 90 2 5 7 301-3 5-7 9 13 6-22 4 9-32 5-6 8-9 41-2 4-5",
    ": 8-52 6-8 60-1 3 9 72-3 5 7 80-3 8 90 3 5-6 8-9 401 3-4 6-7 9 11 3 5 7-8 21-2",
    ": 4 7-8 31 3 41 3 5 7-9 51 3 6 9-60 2 6-9 73 6 80 4-6 8 91-4 6 8 503-7 11 4-6",
    ": 21 4-5 7-8 34-7 9-40 2 5 7 9 51-4 8 60-5 70-1 6 8-9 81-2 4 8 91 5 7 600 4 6-7",
    ": 10 4 6 8-20 2 5-6 9 32-5 8 43-4 6-8 52-3 6 9 63 8-70 3 7 9-81 5 7-9 91-2 5",
    ": 700 2 4-5 7-9 11-3 6 8 22-3 9 31 3 6 9 46 52 5-6 9 63-5 7 9 72 5 9-80 2 4 6",
    ": 9-91 4 9 803-7 9 11 6 21 3 6-7 30-2 4 7-8 40-3 5-6 51 4 6 63-6 8 72-3 6-7 9",
    ": 82-3 93 9 902-4 6 11-3 6-8 24-6 9 31-2 4 6 9 47 9 51-2 6-7 62 4-7 73 6-7 9-81",
    ": 3 5 8 91 5 7-8",
    ": 9003 6-10 5 8 20-1 3-4 8-9 31-4 8 41 3 5 7 9-51 60 2 5 8 71-4 7 9-81 3 5-6",
    ": 8-9 91 3 6-7 104-6 9 12 4-5 8 20-1 3-4 6 8 37-8 41 4-5 7 51-3 9 61-2 4 6-7 70",
    ": 2 5-6 8 81 3-4 6 8 92 4 6 9 202-4 9 13 7 9-20 2 5 7-8 31 3 9-40 3-4 6 8 61 3",
    ": 70 3 7 81 3-6 8-9 92-3 5-6 9 302 4 7-8 10-2 5-7 22-5 7 9 36-7 9 46-7 50 7-8",
    ": 62 7 70-2 4 81 3 90 2 4 7 9 405 7 9 12-3 5 7 20 8 32 8 42 6-9 52 4-5 7 9 61 3",
    ": 5 71-3 6 9 82 5 7 90-1 3 5-6 8 501 10-1 3 8 20 2 4 8 31 4 44 54 6 61 7 9 71",
    ": 80-1 3 5 7 91-2 5 9 608-9 12 9 22 4-5 9 33 6 8-9 41 3-4 8-9 51 5 8 62 74-5",
    ": 8-81 5-7 9-90 4 7 9 704 9 19-22 5-7 34 40-3 5-7 9 53-5 9 61 4 9-70 2 4-5 81-2",
    ": 6 8-91 3-5 9 801 5 7 15 8 20-6 8 30 3 5 7 47-8 50-2 5 7-8 60-1 4-9 71 4 9-83",
    ": 8-9 92-4 8 901 4-5 7-8 12 6 20-1 3 9-30 2-3 5-7 41 3 9-52 4-6 8-9 62 4-5 8",
    ": 70-1 3 5-6 82-4 8 90-3 6 8-9",
    ": 40002 6 9-10 2-4 8-20 3 8-9 31-2 5-7 9-40 4-6 51 61-5 70 3 5 7 81-2 6-8 90-2",
    ": 6 110 3 5 20-2 4 7-32 4-6 41-5 8 50 4-5 7 9 61 8 70-1 3 5-80 8 90 2-3 6-7",
    ": 9-200 3 5 9-11 3 9 21 5 7 9-30 3 5-7 9 43 5-6 50 3 5 63-6 73 6 8-9 81-3 7",
    ": 9-92 4-9 301 5 8 11 5-7 9 25 9-32 5 7-8 41 4-5 7 9-50 3-5 7-9 61-2 5 8-71 3 5",
    ": 7 9 81 3 6-7 9 91-2 6 400-1 3-4 9-10 2 5 7 28 30-1 3-4 9 42-3 5 9-51 7-8 60 2",
    ": 5-6 8 70-3 5-6 8 80 3 7 9-90 2 4-5 9 501-4 6 9-10 2-3 7 9 23 5 34 6 8-40 3-7",
    ": 53-4 6 9 62-3 5-6 9 72 5 7-8 80 2-6 8-9 94-5 7-8 600 3-4 8 12 5 7-9 25-7 9",
    ": 32-3 5 7-42 4 6 52 4 62 5-7 9 71-3 5-6 80 2 5-6 8 90-2 8-700 4 9-10 2 4-5 26",
    ": 8 35 45-6 51-2 6-8 62 4 8-71 3-4 80 3 5-7 9 91-3 802-8 10-1 5-6 8 20-2 4-6 9",
    ": 31-2 4-5 41-6 8-9 52-3 62-8 70 2-3 6 8 80 7 9-90 904-5 8 10 2 4-6 8-24 8 30-2",
    ": 4 6-7 41 4 7-8 50-3 6-9 64-5 8 74 6-9 81-3 7-8 92 4 9",
    ": 1003-4 6 8 13-5 7-9 21 3 7-30 4 7-8 40-2 4 9-52 4-5 7 9-60 3-6 8-9 71 4-7 82",
    ": 4-5 7-93 5-6 8 101-2 4-6 9-10 2-4 7-9 22-4 7 9-30 5 8 41-2 4-6 8-9 51-2 6-7",
    ": 9-60 4-5 73 5-6 8 83 5-6 8 91 3 5 7-9 201 3 6-7 9 11 4 7-9 25-6 8 31 9 41 5 7",
    ": 9 51 8-9 61 3 6-7 70 4 7-80 3 96 302-3 5-6 10-1 3 5-6 8 20-1 4-5 7-8 32-8 40",
    ": 4 8-9 51 6 60 4 7-8 70 5 7-8 86 91 3-4 6 400-3 5 8 10 2 7 23-4 6-7 9 32 4 7",
    ": 41 5 9-50 2 5-6 8 60 3 6-8 70 4 6-7 9 81-2 4 8 90 6 9 502 4 6-9 13 8 21 5-6",
    ": 30-1 6-8 42-3 9 51 5-6 8 61 3 6 8-9 75 80 2 5 7 9 93 5 7 601 4 6-7 9-11 3 5",
    ": 24-5 7 30 7 40-1 3-4 6 8 53 60 3-4 6 71 4 6-7 80-1 3 5 7-8 94 6 8 702-3 6 8-9",
    ": 12 5 7 9 21-2 4 7 33-5 9-40 3-4 6 50 4-5 7-8 60 2-3 5 8 71-3 5-7 9 81 3-4 6-8",
    ": 92-3 5 7 801-2 6 8-13 5 20 2 4-5 8 34 42 4-5 7-9 55 7 60 3 5 7-8 73-4 6-7",
    ": 9-82 4 8-9 91 3 7-9 901-2 6-8 11 3 7 9 21-2 4 9 31-2 5-8 40-1 3-4 7 9-52 7",
    ": 9-61 3-4 7 73 6 8-9 81 4 6-8 90-4 6 8-9",
    ": 2001-2 4 6-7 12 4 7 9-20 3 7-8 30-3 7 9 42 4 6 8 50-1 4-5 7-8 61 4 6 8-9 71",
    ": 3-4 7 80-1 3-4 6 9 92-3 6 101-4 9-14 6 9-23 5 7-9 31 5-8 40 6 8 51-2 4-5 7 61",
    ": 3 6 9 71-3 8 80 2 4-6 91 5-6 8-9 201-2 4-6 8 10 2-4 7-8 20-1 4 6-7 30 6 40",
    ": 2-3 6-7 9 52-6 9-62 6 8 74 7 80-1 4 6-7 9 91 3-4 8 304-5 7 9-10 2 5-8 21-5 8",
    ": 30 2-6 40-2 5 8-9 55-7 9 63-4 6-8 71-2 5 9-81 3 6-7 9-93 6 9 406 9 11 3-5 7",
    ": 9-20 2-4 6 9-30 2-3 8 40-1 4-5 7 9-50 2-3 6 60-2 4-7 9 71-2 4 8 82 5-7 91 9",
    ": 501-2 4 7-11 3 5 7 9-20 2 7 9 31 3 7-8 40 3-5 7 50 2-4 8-9 61 5-8 70-1 3 5",
    ": 82-3 6-7 9 91 5 8 602 4-8 11-2 4-5 8 20 8 31 3 5 8 41 3 5-6 8-50 4-6 8 60 2-3",
    ": 6-7 70 2-3 5-6 9 83-5 7 9-90 4 9 702 5 7-9 11 7 24-5 7-30 4-5 9-40 2 5-6 9",
    ": 51-2 4-5 7 9 61 3 6-70 2-3 6-7 9-81 4 6-8 90 3 5 7 9 801 3 5-7 12 6 8 20 3",
    ": 6-7 9 31 3-4 6 8-40 3-4 7 51 3 5 65-6 8 70 6 8 84 6 9 92 5 9-900 3 5 7-8 12-3",
    ": 5-6 8-20 2-3 7-8 31 4 9 41 5 9 52-3 7 61-2 5 8-71 3-5 8-81 3 5 7 9-94 6 8",
    ": 3001 3 7 12-4 6 9 21-2 4 6-7 31 3 5 7 44 7 51 3-4 6-7 9 61-3 6-7 9 71 4 7 9",
    ": 82-3 5 8 90 2-3 5-6 9 104 8-9 12-4 6 20-1 6 31-2 6-7 9 42-3 6 8 50-2 4-5 7 60",
    ": 2-5 8 70 2 4-5 7 9 82-3 6 8 91 3-4 6 8-200 4 10 2 4-5 8 20-4 6-7 31 4 7 9-40",
    ": 3 5 7-52 4 7 61 3-4 6 8-9 71-3 5-6 8-84 91 5 8-9 303 7-8 11 5-20 2-5 9-31 3 6",
    ": 40 5 9 52 4-5 7-8 60 7 9-71 4 6 9 81-3 7 9-90 3 5-9 401-9 13 6-7 9-20 2-3 5 7",
    ": 30 5-7 40-1 6 54 6 8 62 4 6-7 9 71 3 5 7 9-80 2-3 5 7 90 3-4 6 8-500 4-5 8",
    ": 10-1 3 5 20-2 4 7-8 30 2 6-8 40 3-6 51-2 4 6 8 60 2 6-7 9-70 5-6 9-80 2-3 5",
    ": 7-9 91-2 4 7 600-2 4-5 7 9 11-2 6-8 20-1 5-6 8 30 2-4 6 8 40 3-5 7-8 51 7-8",
    ": 60 3-4 6-7 9-70 4 6-7 9 84-6 8 90 2-3 6 8 700 2-3 5-6 8-9 13 7 9 21-2 4-31 3",
    ": 6 8 40-2 4 6-8 52-4 6 61 3 6 9-70 4 7 9-80 2-3 6-7 9 93 9 801 7 9 13 5 9 21-4",
    ": 7 31 3-4 7-41 9 51-3 5 60 2 5-7 9 72-4 6-9 81-3 5 7 90-1 4 901 5-6 8 14-5 7",
    ": 21 3-5 8 31 3 5 40-1 4 7-52 4 6-7 9-60 3 5 8-70 5-8 81 3-4 7 93 5 9",
    ": 4002-10 2-3 7 21-2 7-8 31-2 4 41-4 8-9 52-3 5-6 9-60 4-6 72-3 5 8-84 6 8-92",
    ": 6-7 9 102 4 6 11 4 6-20 2-4 7-30 3 8-40 3 5-7 53 5-7 9 65-8 70 4-5 7 9 81-7",
    ": 91 4 200-1 4 6-7 10-2 22 4 8 30 3 6 8 46 50 6-9 65-6 8 71 6 8-81 4 6-7 92-4",
    ": 7-8 300-1 3-4 6 8-9 11 3-6 8 20 2-3 5 7 9-31 4 8 43-5 50 3-5 9-61 5-8 72-4 6",
    ": 80-2 5-6 9 95-9 402-5 7-10 2 5 9 21 6-9 31 3-4 6-7 9 42-3 5 7-50 3 7 61 4 9",
    ": 71 5-6 80-2 4 7-8 90-1 6-7 502 5-8 10-1 3 9 21 5 34-5 7-8 40 2 4 7 9-50 2 4",
    ": 6-7 9 61-2 8 72 5 83 5 91-2 4-5 601 6 10-1 3 8-9 22 4-5 8-30 4 7 9-40 3-4 7-8",
    ": 50 2-3 5-8 60-1 4 6 9-70 4 6 9-83 6-7 9 91-3 5-7 9 703 5 7 11-3 6 20-3 8 32 6",
    ": 40-1 4-5 8 53 5 61 4-6 70 3 6 80 5 92 4 6-7 800 2-4 7-9 12-3 5-8 21 6 9-30 2",
    ": 4 6 40-1 3 51-2 6 8 61-2 4-5 7 9-70 2-3 6 8 80-1 5-7 91-2 6 902 4 10-2 4-6",
    ": 8-9 21 3-4 6 8-9 31 3 5 8 46-7 55 8-61 3 6 9 71 3 7 81 6-7 9-91 3 7-9",
    ": 5001-2 6-7 18 21-2 5-6 8-9 31-3 5 7-8 40 5-7 51-3 6-7 9 61-2 5 7-8 71-2 84-5",
    ": 8-9 91 5 8-9 102 4 10 2 7 29-31 3 8-9 44 6-7 50 2-5 7 9 61 4 8 73 5-7 9 85 7",
    ": 9 91 3-5 7-9 201-2 5-6 8-9 13 6 8-9 22-3 6 32 4 7 9 43 5 8-9 52-3 6 8-9 61 4",
    ": 6 8-9 71-3 5-6 80-1 4 6 8 92 6 9-300 2 5-6 9 11-2 9-20 2 4-5 8 34 6 8 40 4-7",
    ": 9 53 5-6 9-60 3-5 8 70 5-6 8 80-5 7 9 94 8 402-3 5-6 8 10 2-5 20 2 6-7 30 3-8",
    ": 41 3 5-9 53 7 60-1 3 7 9 71-3 7-8 80-2 4-6 9 92-4 6 8 501 5 7 10-1 5-7 9-20",
    ": 2-6 8-9 33-6 8-44 6-9 51-3 6-8 60 2 5 9-70 2 4 7 80 3-5 8 91 3-5 602-3 6 8-9",
    ": 11 4 7 21 3 7-30 2-3 5 7 45-7 9 51-2 4 7 9 62 4-6 8-70 3-5 7 9 81 5 7 9 91-2",
    ": 4-5 8 701-3 6 10 9-20 3 5-6 8 31 3 5-7 9 41 4-5 9 53-5 7-8 61 3 5 70 5 7 80 2",
    ": 6-7 90-1 3-5 8 800-4 8-9 11-4 6-8 20 2 5 8-9 32 4-5 8 40-1 3 8-52 4-5 7 64-5",
    ": 7 76-8 80-6 9 91-3 7-8 902 4-5 7-9 11-2 20-3 5 30-2 4 7 9-41 3 5 8-9 51 4 7",
    ": 9-60 6 8-9 71-2 5 7-9 81 4-5 8 90 2-6 8",
    ": 6001 3-6 10-2 4 6 9-21 33 5-6 40 7-9 53 5 64 8 70 2-5 7-9 81 4 90-2 5-6 9 101",
    ": 3 7-8 11-2 4-5 7-8 20-1 6-7 9 31-2 4 8 41 3-4 6 9 54-5 9 61 7 9-70 4 8 80-2",
    ": 4-6 8 90 5 8 200 2 4 6-7 11 3-6 20 5 7-8 31-2 5 8-9 42 4 6-7 9-51 4-6 8 60",
    ": 6-8 70 3 5-6 8-81 3 6-7 90-1 3 5-6 300 3 5 7 9-12 4-5 7 9 21 4 30-1 3 5 8-40",
    ": 2-3 6 9-52 5 7-9 62 4-5 7-8 73 5-6 8 80 7-9 91 3 5-6 8 400 2-3 6 10-1 3 7-20",
    ": 2-3 5 8-31 4 6 8-9 41 9 51 3-4 7-60 2-3 8-74 6-81 3-5 8 90 6-7 500 4 6-9 12 6",
    ": 8-20 3-5 8-9 33-5 7 43-5 52 60-3 8 71 3-5 8 80 4-7 9 91 7-9 602 4-5 8 10-5 23",
    ": 5 8-9 31-3 5 8 40 3 5 9-52 6 9 61 7 9-72 4 7 80-4 6 8 90 2 4 6 8-700 5 10 2",
    ": 5-6 9-20 6 9-30 2 4 7 9-42 4 6-7 9 51 7 60-1 4-7 70-1 3 5-9 84 9 92 4 6 801 5",
    ": 9 13-4 6 8 22 4 6-7 9 31 8 42-3 5 50 2-6 8 60 2 4-5 70-1 4 80 3-4 7 90 7 900",
    ": 2-4 6 11-2 4 74471 518 34 667 81 749 92 807 49 75 88 924 67",
    ": 5010 45 72 84 160 285 350 65 419 35 49 86 513 50 3 65 71 4 8 97 639 83 704 22",
    ": 78 91 803 17 36 53 71 84 931 80 96",
    ": 6017 65 120 46 65 98 312 35 47 62 83 470 99 549 65 78 622 42 87 96 718 33 47",
    ": 57 97 857 75 913 62 90",
    ": 7000 27 53 63 80 112 57 211 27 84 323 37 51 65 85 447 57 94 517 30 614 23 34",
    ": 75 88 760 803 17 28 75 90 907 25 87",
    ": 8002 19 112 33 50 64 79 91 244 83 339 67 82 92 415 36 45 57 71 513 26 35 47",
    ": 59 83 7 602 23 72 86 703 17 45 55 64 78 91 808 28 40 54 71 84 900 15 31 45 58",
    ": 95",
    ": 9025 36 79 107 30 42 50 71 9 240 51 61 92 358 69 82 94 428 43 52 78 95 508 20",
    ": 38 60 75 89 620 66 82 95 704 19 43 70 99 833 54 81 916 44 59",
    ": 80014 36 46 70 81 91 111 34 46 70 81 97 221 47 61 78 321 63 99 432 49 99 518",
    ": 35 86 665 76 85 714 68 75 824 47 904 15 76 89",
    ": 1005 19 58 80 127 70 83 99 237 56 87 99 310 34 50 89 418 27 37 46 56 69 509",
    ": 30 42 56 68 85 98 608 19 32 40 61 704 62 74 91 824 40 52 72 85 98 912 30 47",
    ": 77",
    ": 2006 28 38 48 80 128 39 51 70 9 267 79 91 308 59 406 18 66 686 702 11 96 823",
    ": 78 951 62",
    ": 3018 27 37 63 73 91 103 205 55 68 83 307 32 43 64 408 21 33 53 72 533 67 77",
    ": 89 639 56 68 83 740 66 85 825 43 52 915 67 79 89",
    ": 4018 23 45 67 88 100 17 32 77 209 45 58 90 313 58 92 415 52 514 26 40 602 40",
    ": 96 708 20 47 61 74 845 59 70 85",
    ": 5008 115 65 82 215 45 57 73 87 303 23 44 427 39 63 76 96 559 68 83 94 605 16",
    ": 31 49 62 72 82 91 701 15 27 45 86 802 39 52 96 963 92",
    ": 6017 31 43 53 90 105 16 30 55 73 98 213 309 45 56 432 41 59 77 520 76 90 649",
    ": 68 707 19 54 834 62 8 72 7 84 9 95 903 18 37 43 53 61 92 9",
    ": 7005 21 47 51 65 96 105 12 24 8 45 9 61 7 72 80 5 92 202 8 25 32 8 51 79 303",
    ": 26 36 60 8 77 85 94 402 12 70 81 552 60 77 615 715 55 77 849 59 76 920 32 47",
    ": 76",
    ": 8005 26 52 74 84 115 33 53 67 88 276 307 22 37 63 80 95 420 53 64 533 50 87",
    ": 610 27 45 704 76 824 41 92 904 49 68 87",
    ": 9002 16 32 46 58 94 110 26 55 79 92 209 41 71 307 20 36 75 403 577 623 35 52",
    ": 700 41 86 811 48 64 79 900 10 50 82",
    ": 90007 73 90 140 69 214 37 53 69 360 77 92 407 32 50 65 516 28 77 613 704 22",
    ": 36 52 810 34 67 910 66 84",
    ": 1002 19 33 51 98 117 45 77 91 240 56 98 314 82 97 414 32 59 77 89 571 652 97",
    ": 741 63 945 2089 104 63 223 52 76 339 412 27 43 59 96 664 75 995",
    ": 3042 58 73 115 78 261 83 96 324 437 531 60 70 95 607 42 57 747 65 79 866 82",
    ": 929 46 61 77 99",
    ": 4029 78 84 116 30 64 83 99 217 73 318 29 55 485 552 69 606 28 49 83 98 762",
    ": 853 76 88 926 44 81",
    ": 5053 69 116 31 59 221 43 60 306 62 419 38 51 68 84 533 49 621 53 70 707 33 71",
    ": 99 811 27 41 55 934 51 67 85 96",
    ": 6015 28 68 92 139 53 66 208 59 302 22 35 59 412 26 65 80 93 501 22 34 61 83",
    ": 98 625 42 76 716 27 47 60 74 90 809 24 56 85 913 29 67",
    ": 7002 15 39 71 85 153 66 218 45 60 75 300 31 46 64 81 95 415 38 512 29 660 752",
    ": 68 98 834 60 76 99 936 50 89",
    ": 8020 39 62 86 116 56 209 27 56 318 47 414 67 86 504 62 78 93 605 29 61 85 717",
    ": 41 69 79 94 812 41 58 90 936 74",
    ": 9100 17 308 40 508 64 87 730 837 71 84 942 70 83",
    ": 900012 26 41 58 69 157 206 21 61 301 48 99 436 92 539 631 73 707 20 34 50 65",
    ": 831 56 77 925 52",
    ": 1057 80 94 163 87 286 302 70 85 99 447 532 46 90 618 74 704 23 36 57 72 92",
    ": 825 40 64 85 911 45",
    ": 2070 101 326 42 52 68 83 461 509 28 57 76 645 92 706 26 802 34 48 63 82 958",
    ": 79",
    ": 3008 27 41 54 66 78 138 78 222 311 458 507 19 49 84 97 623 35 89 717 817 72",
    ": 97 910 42 54 71",
    ": 4001 46 60 95 197 221 301 15 26 78 92 419 35 62 91 507 31 60 72 86 625 42 63",
    ": 75 842 69 938 58 82 96",
    ": 5059 77 96 130 272 365 97 474 506 34 46 73 86 610 24 39 64 748 803 56 69",
    ": 6105 18 33 44 8 62 221 97 383 95 427 97 569 639 55 80 703 14 27 56 81 96 863",
    ": 78 93 910 26 46 98",
    ": 7073 89 114 205 28 36 51 67 90 307 22 39 55 459 74 508 32 46 99 619 725 813",
    ": 74 922 37 74 90",
    ": 8006 30 46 131 218 356 73 417 32 80 95 508 54 89 678 762 95 813 27 63 83 906",
    ": 16",
    ": 9002 40 86 102 19 44 58 203 97 342 82 435 54 89 523 83 627 66 700 19 61 810",
    ": 60 938 61 77",
    ": 10022 38 123 39 286 301 87 401 526 40 54 67 614 32 61 744 829 71 99 917 98",
    ": 1054 85 102 17 33 52 68 86 204 94 471 582 94 702 16 831 47 61 77 91 938 52 65",
    ": 82 99",
    ": 2037 49 69 91 107 28 44 66 81 236 300 16 32 50 71 405 38 54 98 511 31 53 69",
    ": 682 96 737 57 99 809 68 944 60 86",
    ": 3002 41 66 78 119 48 99 226 50 64 300 20 41 55 94 433 57 525 634 62 700 14 67",
    ": 81 820 36 82 938 49",
    ": 4026 39 51 62 87 103 82 98 214 26 39 67 321 35 54 67 448 71 512 26 64 757 73",
    ": 815 30 54 86 935",
    ": 5026 39 76 92 118 67 227 54 305 90 401 15 41 82 525 40 56 71 88 621 708 52 85",
    ": 826 936 66 82",
    ": 6001 14 54 69 116 64 79 95 328 53 84 99 508 23 681 712 41 65 836 49 64 78 94",
    ": 983",
    ": 7031 81 109 31 221 37 54 73 83 312 41 468 501 25 37 51 80 94 607 20 30 60 90",
    ": 702 61 74 819 70 92 902 15 58 73 95",
    ": 8009 25 38 84 183 259 75 94 302 73 99 422 55 69 532 70 636 53 79 767 86 847",
    ": 67 920 49 99",
    ": 9022 40 55 68 79 100 20 55 87 210 27 39 56 65 88 96 313 85 412 23 35 77 92",
    ": 506 19 48 63 655 91 800 16 37 53 69 89 911 57",
    ": 20072 163 81 97 215 38 61 92 343 60 78 403 30 72 90 513 97 621 724 834 49 66",
    ": 95 981",
    ": 1008 25 119 35 47 69 217 46 309 43 58 76 404 28 99 515 81 97 630 48 77 94 707",
    ": 31 9 54 69 87 805 22 40 927 50",
    ": 2005 129 67 219 306 26 516 31 44 94 635 50 758 825 43 95 910 31 61 94",
    ": 3023 50 144 58 76 84 202 17 32 61 71 87 327 85 442 57 512 29 62 76 90 608 43",
    ": 52 73 85 99 760 829 54 87 901 36 97",
    ": 4011 21 33 91 103 93 206 17 56 68 86 304 23 74 96 428 41 50 78 88 534 42 51",
    ": 73 634 52 715 29 57 67 79 823 32 42 51 82 92 918 85",
    ": 5018 32 60 88 106 18 28 42 55 63 216 53 63 73 329 52 67 77 87 401 21 30 9 47",
    ": 84 501 63 79 660 94 6 704 12 6 9 22 35 45 70 84 95 810 31 98 922 91",
    ": 6048 93 104 17 73 276 310 90 401 17 25 44 58 90 590 637 61 71 746 57 69 90",
    ": 830 69 905 19 54 98",
    ": 7013 33 51 123 33 84 99 219 60 85 91 354 63 400 11 22 33 5 64 76 95 538 57 83",
    ": 96 657 70 81 93 752 91 850 65 73 900 14 45 70",
    ": 8001 37 84 93 126 222 33 63 85 98 331 437 46 62 73 510 28 58 68 84 600 33 69",
    ": 709 28 90 810 34 44 903 15 51 92",
    ": 9010 35 48 59 70 82 95 131 56 72 86 215 27 37 52 67 80 317 74 91 404 26 89",
    ": 501 45 96 616 72 709 28 68 80 806 40 9 70 9 940 56",
    ": 30051 9 75 84 96 108 22 39 67 210 31 60 96 305 18 28 42 56 83 401 12 22 8 40",
    ": 7 57 62 75 84 504 22 42 56 67 75 613 52 68 84 707 25 34 51 8 66 72 9 96 802 9",
    ": 22 41 50 8 80 98 909 50 66 76 91",
    ": 1005 27 37 46 71 87 95 105 17 36 69 81 94 206 13 24 34 45 77 88 325 30 40 53",
    ": 83 414 24 38 59 70 81 93 518 26 33 64 75 621 38 47 58 69 75 85 96 704 23 34",
    ": 67 76 93 821 41 51 62 94 914 21 36 46",
    ": 2005 19 62 73 97 115 30 7 46 58 66 203 35 47 55 73 84 96 309 28 69 91 421 44",
    ": 61 80 9 504 70 631 49 85 97 708 19 48 76 822 36 45 61 71 91 902 14 24 48 71",
    ": 90",
    ": 3034 53 109 29 41 60 70 92 212 23 31 44 94 305 14 26 40 9 58 98 433 66 73 500",
    ": 9 45 55 78 637 67 722 51 83 91 9 817 32 41 65 76 95 902 24 35 55 70",
    ": 4021 49 114 26 43 69 81 99 210 7 34 42 59 67 301 19 25 31 60 83 426 39 59 71",
    ": 82 93 512 74 94 608 19 73 97 714 27 38 55 69 95 809 19 48 56 71 85 900 69 80",
    ": 92",
    ": 5005 17 37 50 62 116 24 49 76 248 60 84 94 361 92 400 12 42 94 505 13 22 34",
    ": 91 635 62 94 702 56 804 16 26 43 54 999",
    ": 6020 41 72 104 41 50 9 97 247 62 80 94 331 41 50 75 428 51 67 78 500 12 22 31",
    ": 50 69 86 613 29 39 48 65 74 83 98 715 32 8 68 87 802 11 21 72 87 98 913 24 68",
    ": 75 96",
    ": 7007 17 27 38 55 74 88 145 54 65 83 93 204 28 40 53 60 307 20 40 50 70 7 440",
    ": 51 67 75 81 501 28 36 46 56 64 86 96 608 15 52 60 90 721 8 44 50 6 60 70 7 88",
    ": 816 52 89 901 22 36 47 70 81 94",
    ": 8005 24 36 47 57 109 29 39 63 73 88 98 229 57 69 83 92 302 13 38 49 78 90 403",
    ": 24 96 539 74 91 3 609 20 40 57 71 97 714 31 86 97 837 48 59 89 920 44 63 86",
    ": 95",
    ": 9048 61 77 94 104 43 65 94 250 66 307 16 27 42 70 89 99 410 21 42 53 64 75 97",
    ": 533 56 69 80 96 608 21 33 95 709 20 36 46 70 837 55 915 25 31 9 66 87 98",
    ": 40059 68 77 106 17 51 80 9 203 31 322 32 55 65 84 401 31 70 92 503 12 22 35",
    ": 52 74 612 22 49 78 726 35 54 63 96 814 24 31 48 63 70 907 16 30 47 57 72",
    ": 1008 23 37 48 70 84 209 77 87 355 65 93 411 518 49 61 73 86 605 23 76 86 704",
    ": 15 21 60 85 809 20 38 88 929 45 92",
    ": 2006 29 43 64 89 112 24 35 54 64 84 99 230 44 58 79 98 308 26 41 86 414 65 77",
    ": 95 508 21 88 652 61 86 728 49 59 76 805 39 48 78 89 99 973 84 94",
    ": 3015 24 33 45 55 68 119 76 204 28 41 51 9 67 79 90 321 64 83 403 23 45 53 68",
    ": 82 92 502 11 31 43 84 94 625 38 49 70 83 95 707 28 37 53 72 96 810 36 58 83",
    ": 914 29 53 89 98",
    ": 4008 48 86 99 108 29 84 206 33 48 70 8 314 21 6 55 79 98 410 21 36 57 67 78",
    ": 517 69 607 710 21 31 45 54 802 13 22 9 57 67 77 914 95",
    ": 5021 8 52 66 81 143 6 62 76 99 222 35 42 53 63 83 93 319 35 55 99 408 25 42",
    ": 57 69 80 539 51 61 634 60 80 97 736 46 80 91 871 95 906 15 36 63 87",
    ": 6016 24 34 59 127 39 54 70 225 37 44 68 77 86 320 63 74 93 441 57 72 502 12",
    ": 23 43 53 75 624 46 56 67 94 738 59 70 91 853 915 48",
    ": 7002 14 25 87 103 69 95 214 34 77 329 45 53 63 409 45 83 502 29 42 53 69 98",
    ": 621 69 88 742 56 807 23 47 58 69-71 3-5 7-81 4 7 9-93 6-902 4-11 3-21 4-5",
    ": 9-31 3-4 6 8-42 6-8 50 3-5 7-8 61 7-8 71-2 4-9 81-9 91 3 6-9",
    ": 8001-5 7 11-8 21-30 2-3 5-8 43 8-50 2-3 5-6 8-62 4-5 7 70-1 4-7 80-2 4-90 2-5",
    ": 7-8 100 2-3 7-9 11-7 9 22 4-6 8 31-2 6 8-42 6-8 52-5 8-9 61 3-5 7 71-2 4-82",
    ": 4-6 9 91 3 7-8 200-1 4-6 11 3 6 8 20-1 3-6 32 4-6 9-40 2-5 7-8 50-1 3-7 60-4",
    ": 6 9 71-3 5 9 82-7 9 91-2 4 6-8 301-4 6 9 11-3 5 7-20 2-6 8-30 2-7 9-40 3-55 8",
    ": 60-3 6 70-4 6-9 82-6 8 90-7 9 403-5 7 11 3-9 21-36 8-41 4 6-52 4-6 60-1 3-4",
    ": 6-70 2-3 6 8-81 4 6 8-9 91-3 5-8 501-2 4-5 7-9 11 6 8-22 4-5 7-31 3-6 40 2-4",
    ": 6-51 4-61 4-6 8-70 2-3 5 7-9 81-3 5 7 9 92 4 7 9-605 8-15 7 9-22 5-31 3 5-41",
    ": 3-4 7-51 3-7 9-61 4 7 9-71 3 5-7 9-81 4-6 8 90-1 4-5 7-8 700-2 5-9 11 3-5",
    ": 7-24 6-31 3-4 6-7 40-2 4-6 9-50 4 6-9 61-72 4 8 80-1 3-4 6-95 7 803-6 8-9",
    ": 11-9 24-5 7-8 30 2-3 5-40 2 4-5 7-8 50-1 3 5-7 61-6 8-9 71 4-8 80-3 5 8 90",
    ": 4-5 7-901 3 5-6 9 12 6 8-9 22 5-7 30 3-5 9-40 6-59 61-5 9-71 5-7 9 81-5 8-9",
    ": 91-2 7-8",
    ": 9001-7 9-11 5 7-8 21-2 6-33 6-7 9-41 4-51 3-67 9 73-4 9 81-3 5-7 91-5 7-104",
    ": 6-7 11-2 4-20 6 30 50 85 204 26 34 74 9 98 320 8 78 97 408 17 45 72 81 8 511",
    ": 22 51 8 89 603 12 22 53 62 71 82 707 17 39 68 800 11 26 41 51 70 80 96 904 12",
    ": 9 30 60 71 88",
    ": 50003 13 31 47 88 108 48 200 6 28 47 57 76 95 323 39 53 76 93 410 45 74 85",
    ": 506 20 31 42 51 62 72 83 603 16 33 46 59 703 40 62 810 21 32 98 913 25 57 80",
    ": 1012 24 34 45 57 69 77 87 114 40 71 202 45 56 64 72 96 329 39 66 81 408 42 9",
    ": 78 529 86 602 57 67 84 704 18 34 60 79 801 30 50 77 87 97 917 35 44 54 81 8",
    ": 97",
    ": 2008 26 43 98 107 31 41 50 77 98 233 40 55 77 88 96 308 28 64 406 13 23 63 74",
    ": 89 95 504 21 35 60 70 80 639 61 76 97 709 54 62 79 840 51 73 90 902 85",
    ": 3031 51 64 74 82 91 101 14 22 38 80 241 51 73 88 302 36 62 78 419 29 527 51",
    ": 67 81 611 41 50 77 95 705 12 41 61 79 803 41 52 85 902 46 57 81",
    ": 4006 18 37 47 87 123 34 203 10 22 44 54 80 91 317 25 41 67 78 84 93 402 11 22",
    ": 60 89 533 49 602 12 66 94 711 22 38 49 63 8 806 25 35 59 77 91 922 82",
    ": 5016 50 61 73 91 109 19 29 41 50 68 78 205 20 64 86 323 56 67 76 86 403 12 33",
    ": 41 51 518 31 67 80 605 35 53 69 81 702 12 20 33 40 54 85 801 13 59 81 98 907",
    ": 17 24 32 51 64 89",
    ": 6036 46 66 105 27 52 62 99 247 59 67 78 88 314 24 71 400 20 48 58 72 91 512",
    ": 25 58 70 82 92 603 24 54 69 83 95 709 52 66 92 815 30 40 85 911 28 40",
    ": 7024 75 97 120 33 48 66 79 88 200 53 74 87 317 38 93 405 23 36 47 96 585 643",
    ": 77 709 44 84 96 822 33 8 51 61 80 902 24 40 68 86",
    ": 8034 52 70 116 83 238 74 95 305 23 34 47 435 65 77 91 501 12 24 40 53 65 75",
    ": 621 53 70 717 54 82 806 35 46 62 74 922 66 91",
    ": 9046 55 87 139 86 97 207 27 37 302 13 36 70 88 408 17 39 51 75 545 63 77 600",
    ": 30 79 89 714 24 36 45 80 820 8 74 90 8 914 46 77 85",
    ": 60014 29 56 78 135 63 73 203 16 58 69 80 303 13 57 79 94 410 22 41 51 61 500",
    ": 30 42 52 63 73 85 97 609 21 38 51 80 92 715 39 49 58 70 8 89 808 51 66 77 91",
    ": 904 33 46 70 92",
    ": 1006 16 38 69 104 28 38 58 76 84 93 204 31 40 56 67 86 316 31 42 57 76 89 400",
    ": 13 24 34 43 51 78 89 512 22 34 60 72 82 98 607 35 64 75 84 96 720 31 71 810",
    ": 25 37 57 67 83 909 28 38 49 60 8 87 96",
    ": 2006 19 50 66 73 90 111 36 48 81 207 52 87 320 44 54 67 91 441 58 98 508 41",
    ": 58 90 613 26 51 77 90 704 16 39 53 64 75 91 818 30 42 920 54 80 97",
    ": 3023 46 67 83 117 55 90 219 28 40 67 77 98 327 57 98 435 50 8 73 513 87 606",
    ": 15 30 61 77 96 728 58 805 64 85 96 939 51 62 99",
    ": 4013 25 44 58 83 118 44 64 86 213 37 317 39 53 64 425 43 65 86 505 32 62 608",
    ": 19 37 72 94 715 26 63 77 90 827 40 57 92 930",
    ": 5036 77 102 15 33 53 66 205 62 336 45 61 427 43 59 85 510 23 59 69 609 24 40",
    ": 73 95 780 818 38 52 900 14 27 77",
    ": 6000 27 55 75 95 107 29 91 219 34 47 63 75 90 300 9 28 57 71 85 465 92 520 37",
    ": 64 78 655 70 81 710 30 80 94 814 25 40 68 91 906 18 47",
    ": 7001 101 46 75 206 30 50 69 94 316 73 88 438 82 99 520 54 66 93 614 28 71 92",
    ": 714 25 35 45 805 18 50 64 76 94 907 23 64 80 94",
    ": 8027 57 71 98 109 23 74 223 372 95 502 16 32 44 64 79 92 606 56 89 703 18 52",
    ": 87 863 92 902 14 60",
    ": 9029 43 54 67 108 20 32 45 57 69 221 84 312 25 41 56 70 422 35 49 84 507 35",
    ": 59 729 59 802 950 88",
    ": 70037 55 97 212 24 55 68 92 335 79 427 62 72 515 46 76 95 624 36 62 75 85 714",
    ": 25 43 55 90 811 22 33 60 86 904 20 41 61 91",
    ": 1043 93 110 42 57 69 205 97 311 23 40 70 82 406 41 60 78 503 18 64 84 607 50",
    ": 99 721 67 78 822 33 44 56 937 48 68",
    ": 2009 24 116 66 86 233 45 57 77 320 69 400 14 47 81 95 508 19 99 610 22 35 49",
    ": 67 82 775 88 813 27 58 92 924 35 93",
    ": 3029 50 9 73 82 96 134 47 67 90 219 34 57 72 93 347 72 88 406 42 54 70 537 80",
    ": 613 723 35 54 870 84 910 25 38 72 96",
    ": 4036 60 71 86 128 49 79 94 243 79 91 329 56 401 36 83 95 511 20 68 79 90 613",
    ": 54 75 700 17 51 807 42 56 67 900 70 84",
    ": 5016 56 115 25 43 81 206 20 9 37 49 59 71 322 80 93 427 40 64 75 502 14 57 71",
    ": 84 99 625 39 57 69 80 712 26 71 88 802 908 61 76 89",
    ": 6013 46 56 69 97 113 25 52 89 216 47 60 72 85 314 95 408 37 49 69 502 27 40",
    ": 602 11 35 57 69 709 41 72 94 817 37 50 61 901 44 69 86",
    ": 7000 37 52 129 70 99 225 44 84 300 10 52 67 95 421 38 51 75 88 502 15 37 52",
    ": 66 81 601 14 29 70 81 734 47 57 78 812 25 39 81 96 922 32 56 96",
    ": 8025 34 48 63 86 108 62 75 201 53 66 81 318 46 79 91 404 46 506 33 83 625 38",
    ": 72 724 94 804 92 912 32 88",
    ": 9001 15 37 56 82 102 23 55 68 88 206 18 43 73 97 312 26 55 78 90 409 22 49 58",
    ": 73 85 98 518 603 17 31 85 704 26 87 833 58 72 85 900 11 29 42 65 78",
    ": 80021 35 58 79 92 107 19 48 222 43 97 310 26 43 61 439 81 91 518 33 54 638 65",
    ": 730 68 81 96 818 41 78 969 93",
    ": 1021 86 96 125 43 61 71 226 34 57 77 302 86 461 527 601 14 35 94 718 30 44 56",
    ": 72 85 805 18 903 15 32 92",
    ": 2006 88 103 17 30 42 229 63 79 93 305 19 93 408 50 536 61 76 605 88 703 79 96",
    ": 816 70 915 50 74",
    ": 3003 14 38 51 141 54 78 230 311 37 53 78 420 42 82 98 531 69 85 97 608 29 43",
    ": 55 78 90 707 26 43 73 870 928 59 76",
    ": 4040 59 80 9 103 15 26 39 69 83 241 70 82 314 73 99 417 57 505 23 38 61 89",
    ": 605 23 59 70 85 706 49 839 54 84 96 919 51 63",
    ": 5004 14 49 121 78 92 202 16 58 301 13 42 60 99 435 60 77 90 572 90 605 18 53",
    ": 66 79 711 33 84 95 811 21 44 62 83 905 67 82",
    ": 6009 134 47 77 219 45 69 87 302 32 405 62 76 519 48 68 602 30 64 705 821 61",
    ": 911 31 97",
    ": 7016 30 44 95 115 40 53 82 200 12 27 60 308 48 62 72 89 478 86 501 15 63 82 9",
    ": 614 24 48 70 88 704 38 53 800 39 82 94 914 49 72 86",
    ": 8024 55 64 73 166 226 99 340 9 65 84 98 484 95 508 27 89 627 91 704 15 29 61",
    ": 74 85 819 36 48 61 83 938 52 64 74 92",
    ": 9047 60 7 83 91 116 45 239 50 95 352 69 83 95 421 36 78 98 514 30 41 613 33",
    ": 63 88 99 726 45 815 28 68 919 64 87",
    ": 90016 57 81 134 61 231 63 86 307 21 32 83 454 65 80 511 47 71 614 30 42 77",
    ": 703 12 39 56 95 808 51 64 910 23 36 63 98",
    ": 1056 150 64 96 211 25 86 312 44 86 415 72 96 517 31 46 81 603 17 32 749 77 93",
    ": 838 50 66 88 920 34 47 83 97",
    ": 2012 39 81 97 135 89 201 14 44 326 42 56 74 90 412 60 71 514 40 75 89 611 37",
    ": 76 702 31 46 71 85 807 18 32 53 68 80 918 46 67 83",
    ": 3032 57 73 102 24 47 62 75 211 28 93 300 45 76 91 414 37 50 545 89 618 30 64",
    ": 97 714 71 804 31 61 97 955 96",
    ": 4045 60 143 57 83 200 17 36 64 78 300 15 31 46 60 402 18 29 43 59 83 98 564",
    ": 675 795 859 73 87 98 929 53 71",
    ": 5014 37 66 82 102 18 47 68 315 31 459 73 87 98 520 71 89 605 41 59 75 702 27",
    ": 57 82 95 837 83 92 963 72",
    ": 6036 57 69 82 123 84 203 20 307 34 48 62 80 401 14 25 53 69 79 507 51 86 713",
    ": 29 45 85 96 832 80 92 940 67 81 92",
    ": 7010 26 54 69 84 122 44 54 76 200 60 97 387 502 86 601 13 31 54 96 753 67 80",
    ": 885 94 908 24 51 65 87",
    ": 8001 37 53 69 85 102 35 49 65 79 93 224 40 90 302 15 31 46 64 89 401 42 517",
    ": 49 66 90 633 50 84 727 46 95 839 50 62 89 946 73 87",
    ": 9008 22 39 64 95 164 84 274 89 305 22 41 58 411 41 53 68 90 9 512 55 72 612",
    ": 26 48 63 79 799 814 41 60 95 917 33 45 69",
    ": 7000015 27 51 72 97 117 75 245 61 315 32 97 418 33 90 552 70 86 608 28 45 86",
    ": 711 28 53 858 909 83",
    ": 1007 80 94 109 33 57 79 205 73 305 53 70 95 427 49 84 503 29 69 82 99 613 30",
    ": 50 706 46 61 804 19 34 901 22 32 76",
    ": 2012 27 41 70 163 79 244 76 313 35 54 69 437 50 81 523 46 603 23 55 67 79 99",
    ": 745 814 28 42 64 921 99",
    ": 3013 29 45 59 71 129 48 200 14 40 86 99 318 33 43 63 76 91 405 18 28 42 65 78",
    ": 501 13 42 8 59 93 616 24 33 63 84 707 34 54 62 90 877 909 18 26 35 43 78 84",
    ": 4002 9 30 7 43 59 65 73 98 108 12 23 36 40 79 89 219 33 40 52 60 70 303 12 9",
    ": 36 62 74 9 90 413 7 38 49 69 77 592 634 68 746 60 70 80 822 32 43 65 84 915",
    ": 24 85",
    ": 5018 40 82 103 12 24 33 8 58 95 204 14 47 312 25 64 77 85 96 410 25 37 53 66",
    ": 75 522 48 57 65 634 61 75 722 805 84 98 919 46 61",
    ": 6009 72 274 86 301 49 86 97 423 56 517 622 55 92 723 33 44 804 35 77 86 905",
    ": 16 26 42 83",
    ": 7000 9 40 180 92 201 24 75 338 52 66 80 98 408 19 30 501 25 96 622 64 80 763",
    ": 76 825 38 73 84 917 60 71 81",
    ": 8016 50 88 116 34 55 76 96 250 65 83 94 311 28 45 55 68 84 402 28 38 52 9 74",
    ": 88 95 9 505 12 40 52 96 610 69 82 726 75 84 99 889 902 23 60",
    ": 9153 97 201 21 32 55 67 74 312 64 82 436 80 90 8 525 39 86 99 634 50 729 45",
    ": 94 817 42 53 62 902 8 32 57 67 73 83",
    ": 10000 13 27 37 106 20 48 60 72 85 209 21 51 65 303 8 75 90 405 19 34 48 87 99",
    ": 593 646 67 84 99 714 24 50 70 93 806 41 53 8 93 908 21 95",
    ": 1108 53 68 82 211 59 71 84 96 324 50 64 411 26 81 93 515 36 78 618 26 38 68",
    ": 82 97 709 22 35 97 915 40 53 74 89",
    ": 2001 12 21 31 43 54 68 83 95 113 34 64 98 209 35 326 36 46 78 445 62 97 515",
    ": 40 67 85 99 645 79 93 738 90 802 33 60 80 901 97",
    ": 3047 110 37 46 84 276 91 303 73 83 9 94 415 26 41 51 68 94 8 502 15 35 44 61",
    ": 86 9 93 7 609 24 30 4 40 8 57 72 80 8 94 705 9 16 23 48 62 85 9 99 804 12 27",
    ": 32 41 8 63 79 84 98 903 9 13 9 24 51 60 86 94 8",
    ": 4013 25 41 100 7 15 20 7 33 40 75 85 201 9 19 66 74 344 60 424 36 53 85 511",
    ": 34 53 64 9 644 80 755 77 85 820 48 60 928 37 46 80 9",
    ": 5009 18 107 90 208 48 77 325 36 48 63 81 434 545 623 51 66 81 97 709 24 42 61",
    ": 91 828 67 95",
    ": 6030 58 71 85 161 89 227 42 59 96 310 22 51 414 28 50 91 529 55 73 94 639 54",
    ": 68 88 755 851 71 94 923 30 6 44 64 74 87",
    ": 7063 90 105 34 205 44 67 85 361 81 400 55 69 95 522 95 710 27 876 989",
    ": 8021 77 109 454 77 509 24 47 62 84 600 17 43 60 72 90 711 27 87 811 48 900",
    ": 9086 107 19 37 56 74 92 235 49 65 337 413 63 98 607 30 44 89 857 947 63 75",
    ": 20020 33 48 65 81 110 35 50 226 50 91 307 23 52 65 421 90 532 51 627 48 77",
    ": 730 76 94 856 76 941 57 70",
    ": 1022 38 56 68 83 97 112 35 68 220 54 86 320 443 72 96 513 95 665 92 717 35 54",
    ": 802 19 31 48 66 949 64 81",
    ": 2069 125 39 50 65 78 92 302 6 9 14 20 9 46 71 413 56 91 506 29 42 73 612 701",
    ": 92 810 27 43 67 938",
    ": 3008 49 81 146 91 340 54 65 87 413 39 79 96 522 89 635 74 90 785 808 25 40 65",
    ": 77 900 22 4069 139 57 92 241 75 319 85 430 44 578 611 31 772 830 906 32 48",
    ": 5031 55 80 93 110 35 64 81 92 417 31 522 39 66 79 618 57 87 757 840 86",
    ": 6037 62 88 137 236 573 88 661 85 725 75 801 10 29 38 62 72 90 9 913 55 73",
    ": 7014 31 177 208 49 66 81 95 312 29 68 83 410 537 648 84 776 801 16 31 41 71",
    ": 88 905 34 52 87",
    ": 8004 140 61 76 250 87 305 22 83 97 413 50 544 89 631 47 65 81 702 17 35 84 94",
    ": 814 49",
    ": 9000 19 71 89 119 34 62 78 214 27 36 50 9 66 95 326 67 415 88 682 705 25 834",
    ": 68 83 911 56 67 99",
    ": 30041 61 76 99 122 38 67 85 97 269 345 62 429 43 75 543 81 661 95 711 36 74",
    ": 806 57 945 73 98",
    ": 1161 213 54 77 309 53 402 19 81 509 81 611 53 725 31 40 6 82 98 821 919 31 47",
    ": 89",
    ": 2004 94 250 72 93 316 40 58 81 402 58 83 542 66 642 66 700 47 74 822 55 87",
    ": 921 40 65 89",
    ": 3014 40 59 83 115 35 57 98 224 48 71 348 75 443 572 604 64 85 825 914 60 97",
    ": 4040 64 166 238 361 95 420 58 79 96 522 42 715 33 72 808 34 46 69 87 98 935",
    ": 58 70 81",
    ": 5005 17 27 43 68 137 212 39 90 315 483 545 603 26 69 705 24 42 73 94 831 73",
    ": 931 57 78",
    ": 6023 54 74 93 114 38 59 86 326 62 410 32 78 501 40 612 53 81 720 41 61 827 74",
    ": 7006 131 47 62 87 214 52 69 92 311 437 46 87 508 20 37 57 79 621 34 43 76 87",
    ": 97 718 34 57 77 821 41 77 919 40 53 66 95",
    ": 8031 43 78 120 58 207 29 59 70 313 43 62 87 406 27 48 61 76 92 523 42 605 24",
    ": 45 71 704 18 85 869 85 902 18 32 71",
    ": 9001 21 37 66 82 112 33 59 85 288 314 62 451 71 90 534 72 91 647 85 704 82",
    ": 825 35 52 98 939 78",
    ": 40013 33 52 71 9 113 25 35 49 215 30 68 310 33 45 65 90 450 78 503 31 85 647",
    ": 73 87 714 28 75 98 903 65 82",
    ": 1013 29 82 100 18 34 54 222 77 95 310 27 42 57 76 412 72 90 562 612 89 705 25",
    ": 52 69 822 36 52 82 927 73",
    ": 2022 98 132 58 92 205 46 72 317 39 57 404 26 87 603 20 51 70 711 31 51 68 844",
    ": 60 903 41 50 3006 74 83 132 53 91 201 9 27 302 22 511 33 642 64 94 786 805",
    ": 4037 168 90 448 72 93 608 79 760 79 92 804 95 929 48 60 74",
    ": 5002 14 38 66 211 29 51 73 96 407 536 54 86 607 722 905 86",
    ": 6008 52 409 541 62 80 624 46 68 83 711 73 804 902 25 57 85",
    ": 7052 123 41 213 47 365 492 588 610 59 82 800 971",
    ": 8101 237 93 397 422 41 89 582 666 84 747 80 847 95 997",
    ": 9063 82 125 40 91 219 81 98 379 402 16 78 92 516 39 52 72 84 609 23 34 51 67",
    ": 82 707 827 56 71 952 90",
    ": 50077 99 125 231 300 21 59 84 411 594 689 765 91 815 90 918",
    ": 1114 38 228 54 75 305 31 84 409 45 85 561 611 54 724 59 97 825 76 941 64",
    ": 2040 66 103 74 336 60 78 99 423 51 89 564 675 97 719 58 848 933",
    ": 3055 161 205 27 93 315 35 58 75 409 32 53 84 514 49 693",
    ": 4026 48 106 60 392 417 40 573 94 648 74 726 52 802 30 909 32 59",
    ": 5010 149 71 256 90 455 605 44 704 56 935 76",
    ": 6002 26 347 435 64 504 27 42 64 615 44 758 847 66 83 902 24 79",
    ": 7299 414 96 530 47 698 733 54 89 807 65 87 902 22",
    ": 8016 126 264 82 97 415 43 59 95 544 638 61 719 46 816 85 910 28 51",
    ": 9068 111 47 89 209 65 91 413 82 536 94 621 44 82 791 832 62 89",
    ": 60078 101 24 252 73 314 461 679 711 27 49 73 965 91",
    ": 1079 103 39 63 278 304 517 41 600 50 710 84 823 993",
    ": 2061 90 114 38 242 66 319 55 83 406 97 520 42 66 89 624 47 86 753 929",
    ": 3009 29 154 90 217 35 54 81 309 31 73 436 91 507 18 616 55 715 87 866 930",
    ": 4065 98 121 87 250 458 500 16 37 61 652 76 99 736 62 82 802 51 932 56 96",
    ": 5055 101 62 84 374 98 428 68 86 98 516 39 64 87 611 39 54 701 26 63 834 58 78",
    ": 6021 113 84 207 25 44 65 82 336 58 98 496 544 74 856",
    ": 7072 279 455 95 604 48 855 92 939 8035 358 499 532 714 63 812 87",
    ": 9141 74 208 53 419 61 514 63 632 744 69 834 91 918 72",
    ": 70020 109 74 242 69 95 316 70 97 440 66 94 572 669 95 795 814 78 904 61 86",
    ": 1046 107 381 404 41 66 520 41 59 79 603 28 817 928 61 81",
    ": 2007 85 112 53 93 215 52 99 322 589 710 938",
    ": 3000 131 320 84 554 664 721 58 910",
    ": 4079 120 43 258 345 68 411 63 82 605 24 926 47 67",
    ": 5020 56 81 194 247 90 357 407 83 561 85 605 54 775 892 930 60",
    ": 6009 152 78 280 345 99 425 528 68 90 757 936 63 90",
    ": 7040 67 96 168 93 227 89 315 70 448 551 825 98 937 58 84",
    ": 8048 68 86 110 62 242 68 404 27 48 530 55 97 622 41 59 720 42 813 95 951",
    ": 9039 70 92 149 75 200 36 90 313 36 56 419 90 516 52 75 98 621 60 91 746",
    ": 80014 40 245 91 318 400 23 49 518 68 729 931",
    ": 1008 95 157 222 439 548 673 765 848 997",
    ": 2035 57 78 112 63 235 402 18 506 35 602 32 732 915 74",
    ": 3005 36 117 37 60 221 50 316 74 94 413 546 99 643 61 795 824 44 69 902 49 71",
    ": 4068 209 81 315 469 99 517 41 64 620 72 720 46 71 814 33 63 934 96",
    ": 5031 52 83 125 45 61 269 91 329 43 64 86 406 29 586 607 24 78 705 43 823 64",
    ": 95 926 53",
    ": 6003 27 46 65 240 318 46 429 51 74 96 522 63 85 747 69 811 46 65 89 916 40 79",
    ": 7083 108 49 77 205 53 92 319 42 427 62 556 70 84 96 610 26 41 72 82 99 747 81",
    ": 807 40 90 937",
    ": 8019 32 49 67 105 19 58 89 236 332 60 73 423 44 538 56 75 94 609 29 734 52 95",
    ": 824 68 91",
    ": 9004 68 82 116 42 63 89 201 15 56 310 29 43 60 414 62 80 524 58 74 99 725 82",
    ": 823 63 91 976",
    ": 90063 79 95 110 26 83 209 27 68 85 400 64 527 49 617 34 53 87 762 96 814 28",
    ": 74 90 908 25 76",
    ": 1030 55 145 82 95 210 51 84 302 19 34 53 66 82 96 409 36 42 76 527 45 59 85",
    ": 601 31 56 83 98 711 51 70 88 800 942 62",
    ": 2015 41 50 64 208 329 81 508 56 75 627 54 722 873 912",
    ": 3010 35 52 85 162 76 301 412 44 78 511 30 62 617 53 70 715 72 84 826 44 84",
    ": 902",
    ": 4016 43 107 20 69 204 23 58 77 90 309 433 60 78 551 88 682 99 733 807 33 73",
    ": 89 904 40 72",
    ": 5007 24 68 92 128 46 210 67 95 318 30 56 71 414 29 56 95 508 44 70 630 57 84",
    ": 701 37 59 83 807 18 53 68 82 939 87",
    ": 6001 19 35 53 106 41 54 263 336 51 74 412 24 41 549 61 78 603 46 78 707 48 60",
    ": 79 91 821 34 81 937 51 77",
    ": 7018 37 64 83 146 62 74 208 22 41 57 94 339 77 89 405 30 69 84 528 73 97 634",
    ": 711 38 58 88 809 30 44 76 90 903 35 68",
    ": 8009 40 54 79 92 108 33 81 92 215 24 51 65 86 332 68 405 19 35 55 519 47 64",
    ": 93 610 23 38 51 60 71 83 704 18 64 829 36 43 58 80 93 959 69",
    ": 9003 17 32 121 40 66 88 212 25 38 52 63 304 20 72 404 29 42 504 19 63 92 622",
    ": 63 79 708 47 77 812 23 40 68 917 62 79",
    ": 100014 27 66 88 182 91 224 381 402 10 34 62 76 515 55 621 46 57 706 17 76 91",
    ": 818 46 58 98 908 22 33 46 67 99",
    ": 1048 69 93 105 13 7 34 79 280 332 46 64 80 97 407 64 505 16 30 9 66 606 36 52",
    ": 64 81 99 725 45 57 72 839 92 908 28 39 85",
    ": 2065 78 92 132 97 222 34 49 55 69 85 306 26 74 99 431 9 51 70 502 601 9 20 8",
    ": 45 52 69 77 85 95 747 812 22 39 51 61 80 917 41 51 62 74 84 96",
    ": 3005 15 53 64 97 126 39 51 63 205 19 50 73 318 32 46 76 96 410 38 56 66 90",
    ": 503 45 99 606 24 44 716 27 43 56 64 94 806 18 45 56 68 94 905 15 27 46 56 76",
    ": 93",
    ": 4005 34 58 159 201 54 78 88 99 325 71 85 418 61 86 95 505 36 50 668 84 718 29",
    ": 50 62 79 813 24 33 46 58 71 85 902 12 50 9 75 85 96",
    ": 5007 18 45 58 68 94 108 43 54 68 93 228 39 53 61 89 308 18 28 39 50 63 72 85",
    ": 92 419 30 42 60 73 86 98 512 22 37 61 87 95 608 51 9 70 81 94 704 10 31 49 70",
    ": 8 88 825 32 45 69 74 93 901 21 41 78",
    ": 6007 15 33 47 59 83 95 125 36 55 92 213 34 49 58 84 98 305 23 37 46 65 89 456",
    ": 74 538 46 86 610 39 90 710 55 821 44 54 84 949 89",
    ": 7043 53 82 112 28 44 56 203 83 97 311 36 436 71 87 99 510 25 35 62 81 95 609",
    ": 28 71 94 716 30 58 74 824 49 64 905 14 76 85 96",
    ": 8004 16 26 40 96 119 58 73 83 92 200 48 67 77 87 317 41 68 455 72 94 562 77",
    ": 639 48 61 72 86 94 707 34 44 61 73 95 830 58 903 46 68",
    ": 9026 49 83 108 24 69 80 256 88 337 52 82 406 21 33 68 513 23 50 68 81 99 631",
    ": 43 78 99 711 22 62 94 807 34 58 926 41 9 57 66 95",
    ": 10008 33 79 115 27 35 48 63 208 27 40 51 70 80 97 310 46 57 70 84 94 417 43",
    ": 54 78 513 23 36 55 66 77 84 96 606 36 47 82 94 703 79 92 826 54 69 94 905 18",
    ": 32 42 56 88",
    ": 1008 44 96 107 31 93 212 23 42 85 301 26 62 99 411 66 76 511 41 9 68 79 604",
    ": 33 64 91 733 77 805 33 74 906 47 61 89",
    ": 2039 54 68 91 102 33 45 54 74 208 43 67 87 361 7 79 405 19 34 569 98 607 30 9",
    ": 59 73 85 718 35 57 82 803 30 42 56 77 88 97 932 47 67 95",
    ": 3026 36 55 63 95 122 39 51 245 57 69 90 316 41 55 66 90 426 42 62 9 87 518 58",
    ": 66 680 868 938 83",
    ": 4021 39 172 250 61 79 94 323 43 55 99 422 32 43 72 539 55 606 20 6 53 701 16",
    ": 39 50 82 807 43 55 908 23 36 90",
    ": 5023 51 81 91 155 93 228 50 62 92 325 38 75 85 407 19 32 98 513 26 54 91 611",
    ": 46 73 700 25 49 98 810 75 901 18 27 38 56 75 90",
    ": 6003 20 34 57 69 91 113 28 37 51 64 80 202 24 50 60 71 305 28 38 55 66 91 400",
    ": 47 88 500 66 92 645 52 60 714 805 17 38 81 924 35 49 59 80",
    ": 7054 8 64 9 115 28 43 54 75 87 99 261 81 311 38 408 36 57 70 500 10 23 65 78",
    ": 635 47 56 70 89 707 21 33 48 810 20 37 46 55 90 902 12 30 43",
    ": 8009 41 64 75 104 17 30 55 72 219 85 308 24 43 56 89 400 13 25 39 76 514 8 32",
    ": 43 58 81 601 21 68 86 703 12 21 39 48 68 86 96 808 25 43 54 902 24 62",
    ": 9030 42 51 67 84 92 128 60 70 98 223 34 44 56 84 331 9 431 45 70 88 503 26 38",
    ": 46 61 78 617 65 78 93 705 19 51 64 90 804 16 44 56 64 82 912 39 53 71 80 98",
    ": 20036 55 104 19 37 92 217 30 54 62 6 81 99 319 38 47 59 72 88 417 36 47 63 83",
    ": 536 61 75 84 92 603 18 38 45 54 64 72 94 701 40 52 72 806 18 46 77 94 916 62",
    ": 73 83",
    ": 1014 25 32 59 81 118 27 37 325 43 57 402 14 48 87 510 50 7 64 78 609 22 60 89",
    ": 742 55 800 28 80 920 49 55 67",
    ": 2011 36 46 109 274 80 4 92 330 47 87 98 411 43 76 510 30 60 635 61 713 24 39",
    ": 66 88 824 62 74 929 54",
    ": 3004 19 37 49 101 15 37 68 94 206 30 76 86 309 50 70 84 95 407 44 69 82 96",
    ": 512 28 51 65 78 614 39 54 63 92 723 42 80 91 806 25 37 51 67 79 91 906 13 41",
    ": 53 91",
    ": 4016 57 68 97 103 16 23 30 48 72 9 93 212 26 35 46 59 81 91 303 15 51 70 95",
    ": 401 11 22 35 42 50 61 72 88 513 27 31 60 70 85 98 610 67 84 98 720 9 46 73",
    ": 820 48 72 82 931 44 93",
    ": 5019 31 63 76 148 61 78 94 237 52 91 306 24 62 79 404 17 49 78 92 502 64 74",
    ": 96 617 32 89 703 44 75 843 931 43 55 71 83 96",
    ": 6006 40 55 77 132 59 73 202 18 99 320 34 59 75 87 401 8 35 520 33 43 58 76 99",
    ": 613 40 54 66 82 97 716 32 58 90 805 20 93 908 20 41 55 67 79 94",
    ": 7013 78 129 53 66 90 293 315 23 50 60 79 91 448 61 86 96 505 49 74 605 711 44",
    ": 58 94 804 21 50 62 9 93 902 14 22 33 52 91",
    ": 8002 12 23 45 55 75 85 94 103 11 46 80 91 212 31 65 79 99 308 27 37 64 92 412",
    ": 25 56 78 97 515 41 51 67 91 602 32 47 61 776 808 22 35 50 913 77",
    ": 9029 80 102 14 61 74 88 226 72 306 49 407 43 67 509 26 96 637 51 65 710 37 48",
    ": 826 42 64 74 910 49 70",
    ": 30005 42 101 18 58 89 209 58 75 310 414 28 75 88 505 31 603 21 74 721 39 74",
    ": 812 26 48 904 25 45",
    ": 1001 31 63 78 94 171 94 223 65 353 77 88 412 91 503 32 65 721 46 71 832 87",
    ": 904 52 71 99",
    ": 2028 67 96 151 73 207 26 300 39 413 42 56 92 559 619 37 52 74 766 92 837 59",
    ": 911 31 47 67 83",
    ": 3004 24 52 68 109 36 55 71 86 206 29 54 358 89 440 52 71 89 508 32 50 615 29",
    ": 56 703 33 50 66 99 821 38 69 90 907 22 60 95",
    ": 4030 55 71 90 107 57 86 206 64 83 362 408 25 513 32 50 96 651 78 91 708 79",
    ": 849 76 970",
    ": 5072 86 137 231 66 79 362 80 94 414 49 512 53 69 97 627 47 74 713 87 841 89",
    ": 921 67",
    ": 6017 113 48 68 97 229 46 68 95 313 32 47 92 404 32 525 57 601 20 38 60 744 83",
    ": 873 86 902 17 31 77",
    ": 7029 47 171 89 212 28 65 303 22 40 69 88 406 59 77 96 517 87 643 91 722 39 61",
    ": 77 809 28 67 901 33 80 99",
    ": 8034 86 139 96 237 52 77 96 311 38 413 29 43 96 520 37 70 87 633 726 54 70 96",
    ": 813 36 63 906 18 32 64 74",
    ": 9004 83 98 153 74 94 209 22 37 50 307 21 39 56 400 25 47 72 99 536 53 98 614",
    ": 32 58 77 746 66 98 862 99 929 68",
    ": 40012 67 99 119 91 237 70 88 305 50 417 572 97 622 41 63 88 707 41 99 815 26",
    ": 39 910 26 68 83 98",
    ": 1016 60 100 30 53 71 90 224 89 306 35 52 67 81 427 45 615 35 79 727 39 63 802",
    ": 52 81 922 45 59",
    ": 2042 108 24 36 50 75 247 74 95 315 27 469 86 513 72 657 75 723 75 812 29 47",
    ": 99 916 44 59 77 93",
    ": 3041 79 97 143 76 236 49 72 306 77 408 34 52 67 504 23 49 80 601 34 50 69 86",
    ": 705 29 54 73 874 91 977 96",
    ": 4069 114 32 50 205 51 70 89 309 49 91 409 55 501 72 600 38 725 42 74 812 37",
    ": 89 906 52 82",
    ": 5059 79 144 95 220 36 60 77 95 320 41 62 80 98 413 41 67 84 507 59 77 94 663",
    ": 79 99 723 37 91 810 22 55 95 919 63 80",
    ": 6038 67 83 96 108 83 220 58 88 314 40 68 455 72 502 73 92 608 79 94 781 97",
    ": 808 27 918",
    ": 7036 51 85 123 42 59 217 361 82 418 63 78 85 500 53 665 734 809 36 51 77 93",
    ": 914 30 73 90",
    ": 8006 21 39 70 87 106 31 3-4 44 9 60 6 92 225 55 338 92 430 95 514 46 61 78",
    ": 608 24 62 81 97 712 40 59 85 804 33 97 963 80",
    ": 9007 42 60 92 134 44 205 33 52 391 407 21 42 56 72 512 41 57 618 60 78 86 708",
    ": 27 54 71 831 48 72 90 925 43 55 71",
    ": 50004 49 65 81 100 40 52 67 243 78 374 426 63 90 508 23 99 634 91 708 24 72",
    ": 800 55 71 89 948",
    ": 1008 26 45 138 71 200 45 61 306 51 63 86 414 30 56 76 96 515 35 47 77 94 618",
    ": 728 63 83 825 58 95 931",
    ": 2008 26 40 61 155 75 215 75 90 335 96 460 82 504 57 603 30 79 97 719 35 73",
    ": 809 57 80 955 71 86",
    ": 3093 130 41 59 254 66 307 88 468 81 99 514 62 600 33 73 750 65 86 823 55 71",
    ": 921 55",
    ": 4010 23 50 68 106 54 61 351 413 29 46 63 81 590 634 81 741 57 887 916 77",
    ": 5017 74 130 66 200 17 35 52 75 319 63 404 15 43 55 83 96 545 633 54 66 84 727",
    ": 43 94 813 24 32 44 83 910 42 76",
    ": 6021 52 72 117 26 44 58 70 93 281 339 44 407 17 62 84 95 520 34 52 60 612 23",
    ": 32 40 704 41 51 95 810 33 42 55 71 906 13 35 44",
    ": 7038 70 82 100 15 35 58 80 210 63 75 305 33 60 417 27 70 8 525 33 76 92 602",
    ": 39 75 702 26 39 49 63 78 805 12 8 62 78 900 31 47 53 78 94",
    ": 8021 41 53 68 80 100 9 19 28 64 72 82 91 201 15 24 30 73 89 357 73 96 406 49",
    ": 63 9 77 89 99 508 17 36 9 53 62 8 80 8 98 614 57 68 84 94 718 33 45 69 76 89",
    ": 826 40 76 92 901 26 39 48 51 92",
    ": 9026 48 64 74 83 105 13 8 24 37 59 72 80 95 202 11 20 55 79 441 50 73 518 29",
    ": 35 59 69 82 94 609 67 711 9 59 66 83 832 50 63 90 5 908 19 22 34 45 58 71 7",
    ": 98",
    ": 60010 9 40 54 60 86 96 116 46 61 71 82 92 200 16 28 37 328 36 42 9 71 416 27",
    ": 37 52 73 92 501 21 9 42 91 605 77 715 42 818 31 8 70 91 902 11 23 74 82",
    ": 1001 12 24 57 87 101 23 70 82 9 219 87 99 345 53 9 69 87 405 17 28 43 576 98",
    ": 616 23 34 46 58 69 85 712 20 30 40 87 833 45 54 63 9 81 9 900 17 28 45",
    ": 2050 6 81 91 116 46 61 207 20 68 93 319 38 82 93 403 13 9 46 66 78 506 41 56",
    ": 65 75 86 96 608 20 42 57 66 78 91 703 14 33 40 7 61 70 811 20 33 68 83 925 36",
    ": 3002 13 29 60 72 87 101 9 19 77 222 43 56 307 89 98 418 26 59 69 81 92 501 15",
    ": 31 41 50 68 86 99 613 27 43 54 78 731 50 60 71 87 96 804 15 25 37 69 901 12",
    ": 43 56 68 79",
    ": 4028 36 59 116 38 48 74 221 64 70 301 13 38 67 76 411 23 39 63 76 520 622 31",
    ": 69 702 814 29 45 61 85 909 23 37 71 83",
    ": 5000 22 58 70 82 93 117 62 74 89 239 89 301 45 80 92 406 17 44 85 99 542 610",
    ": 29 48 63 91 719 32 45 66 84 807 52 81 94 914 71 90",
    ": 6014 36 49 60 73 99 114 32 54 78 93 210 24 39 66 82 301 13 69-70 4-7 9 81-6",
    ": 9-90 4-9 401-3 5 7-12 4-20 3 5-8 33-4 7 9 43-4 6 9-50 2-3 6-9 62-8 70-5 7-83",
    ": 5-91 3-6 8-503 5 9-11 3-8 21 5 9-33 5-9 41-50 2-5 8-60 2-71 3-7 9-80 2-90 2-4",
    ": 6-7 9-601 3-5 7 9-11 4-7 9 23 5 7-35 8-9 44-8 50-1 4-61 3-4 6-76 9-89 91-2",
    ": 4-6 8-702 4-13 6 9 22 4-6 9 33-4 7-8 40-1 3-4 7-9 51-5 7-61 3 8 70-2 4-9 81",
    ": 4-5 7 90-4 6 9-800 3 5-6 8 12-6 9 21-4 8 30-3 5-7 9 41 3-5 7-50 2 4-60 2 4",
    ": 6-71 4-5 8-82 4-5 7-8 90-3 7-8 900 3-5 7 9-14 6-8 20-2 4 7 9-32 4-7 40-1 3 5",
    ": 7-8 51 3-4 6 60-3 5-7 70 3-9 81-3 5 90 2 4-5",
    ": 7-7000 2-6 9-10 2 5-9 21-3 7-34 6-7 9-40 3-5 7-9 51-2 4-7 60 3-4 6-71 4-6 8-9",
    ": 81-4 6-96 8 100-7 10-2 4 9 21-4 7-9 32-3 9 41 6-9 52-5 8 63-5 8-9 71-2 4-5",
    ": 7-9 81-5 7 9-203 6-14 6-23 5-7 9 33-7 9-44 8-50 4-9 61-2 4-7 9-70 3-4 6-82",
    ": 4-7 9-91 3-6 8-303 5-6 8-9 12 4-5 7-20 3 5-7 9-38 41 5-53 5-61 3 6-70 2-82",
    ": 4-5 7-90 2-5 7-9 401-6 9-10 2 4-7 20-1 3-4 7-31 3-5 7 40-7 9-55 7-62 5-8 70-4",
    ": 80-2 6 8-91 3-502 4 7-8 10 4-7 9-20 2-3 5-33 6-7 9 41 5-6 8-51 3 5 8-63 6 8-9",
    ": 71 4 6-81 3-5 7-601 4-12 4-5 7-8 20-31 5-40 3-7 9-50 2 4 6-8 60-1 3 5-8 70-1",
    ": 3-6 8-82 4-9 91-4 6 8-705 7-22 4-6 8 30 2-8 41-2 4-9 51-61 3-6 9-72 4-7 80",
    ": 2-6 9 91-801 3-4 6-9 11 3-21 4-6 8-9 31 3-41 5 7-50 2-5 8 61-4 6-74 6-9 81 3",
    ": 5 9 91-7 900-2 4-5 9-10 2-25 7 33 5 8 42-4 6-9 51-2 6 8-63 6-7 9-73 6 9-83",
    ": 6-9",
    ": 91-8006 8-12 4-9 23-4 6-30 2 5 7 9-40 2-3 5 7-53 5 7-60 2 4 6 8-70 4 6-8 80",
    ": 2-4 6-7 9-96 8-102 4 6 9 11 3-5 7-8 21-2 7 9 31 4-44 6-9 53 5-62 6-7 9-71 3-5",
    ": 7-8 80-3 5-6 9-90 2-7 200-1 3-4 6 8-13 5-20 2-3 7 9-33 5-40 5-7 9 51-3 5-8 61",
    ": 3 5 7 70 2-5 7-8 80-1 4 7-91 3 5-300 2 6-10 3-6 8 20-2 4-9 32 4-5 7-8 41 3 5",
    ": 7-50 3 6-60 3 6 8-77 80-2 5-6 8-91 3-400 2 4-6 8 10-1 3-5 9-20 3 5-7 9-32 4-5",
    ": 7 9-45 50-1 3-4 7-9 61-5 70-4 6-83 5-6 9-93 6 8-504 6-8 10-1 4-26 8 30-8 41-2",
    ": 4 8-58 60-4 6-71 4-5 7-9 81-95 7-9 602 4-14 7 9-27 9 31-5 8 40-8 51 4-7 9-71",
    ": 3-6 8 80-5 8-91 3 6 703-11 4 6 8 22-4 6 8-34 7-8 40 5-8 51 3-61 3 7-9 76-8",
    ": 80-2 4-5 9-94 6 9 802-8 10 8 20-6 8-30 2-4 6-45 8 51-2 7-61 4 6-7 9-70 2-5 7",
    ": 9 81-5 8-90 902 4-10 2 4-5 7-24 6 8 30 2 6 42-6 8-54 6-7 60-5 8-73 6-83 5-93",
    ": 6 8",
    ": 9001 3-5 7-9 11-2 4-6 8-20 3-7 32 5 7-43 6-52 7-8 60-5 7-73 9 81-3 7-8 91-4",
    ": 105-6 9-12 4 7-8 20-30 5 7-8 40 2 4 6-52 6-62 5-6 8-71 3-80 5-6 9 92 4-9 201",
    ": 4-5 7 13-5 7 9 21-2 5-6 8-32 4 6-40 4-5 7 50-5 8-63 5-9 72-4 6-7 9-80 2 4-6 9",
    ": 92-3 6-302 4-7 9 11 3 5 20-4 6-7 9-30 2-4 6 9-40 4-5 7-9 51-4 6 60 2-5 8-9",
    ": 73-4 7 80-4 6-90 5-8 402-4 6-8 11-5 7-23 6-32 4 6-9 41 4-5 8-51 5 8-9 61-5 7",
    ": 71-4 8-80 3-7 90-2 8 500-1 3-5 13 6 8-20 2-4 7-31 4-6 8-9 42-4 6-7 9-50 3-5 8",
    ": 65-70 2-3 5-8 80-3 5 7-92 4-6 8-600 2 4 11-5 22-9 33-4 7 9 42 6-52 5 9-63",
    ": 6-73 6-88 90-2 6 8 702-7 10 3-5 7-8 20-2 4-5 7 9-33 8 40 4-6 8 50-3 5-6 64",
    ": 6-73 5 81 3-7 9-93 800-3 5-8 10 2-3 6-25 7-32 4-6 8 41-3 5-6 8-9 58-60 3 6",
    ": 8-76 8-80 2-7 90-1 3 5-8 900 2-3 5 8-13 6 9-21 3-4 6-7 9-30 2-5 7-42 4-52 4",
    ": 6-7 60-6 9-72 4-84 6 90 2-7",
    ": 9-70000 3-4 6 8 10-4 6-9 21-2 4-7 9-32 6-43 5-7 9-51 4-6 8-9 61-2 4-5 7-70",
    ": 4-8 81-2 4 90-6 105 9 16-20 2-3 6 8-9 31-2 4-40 2-4 6-7 9-53 5 7 9-60 5-8",
    ": 70-3 5-7 9 81 8-9 91-8 201 7-14 7 21 3-4 30 5 9-41 4-7 52-9 61-2 4-70 2-4 6-7",
    ": 9-81 3-5 7-8 90-3 6 8-9 301 3 5-14 6-7 9-26 8 33-7 9-42 4-7 9-51 3-7 9 62 5-8",
    ": 72-6 8-82 4-90 3 8-401 3-4 7-8 11-4 6-8 383978-82 5 7-9 93 6-9",
    ": 4001 3-5 7-9 11 4-23 6-7 32-4 6-7 9 41-4 6 50-3 5 9 61 5 9-73 7-9 81-2 5-6",
    ": 9-90 2-3 6 9-103 5-9 11 3 5 9 21-2 4-5 7-32 4-5 7 9-40 2-6 9-51 4-60 3-8 71-7",
    ": 9-81 3 6-7 9-91 4-9 201-2 4-5 7 10 2 6 8-9 23-6 33-4 6 8 41-4 6 8-51 3-5 7-60",
    ": 3-9 71-3 8 83-4 6-7 9-93 5-9 302-8 10 5-6 9-25 7 30 6 9-40 2-3 5 7 51 3 6-7",
    ": 60-2 5-6 8-70 2-3 5-80 2-4 6-9 91-3 5 7-9 403-4 8-9 12 20-4 6-9 31 4-6 8-43",
    ": 6-7 9 53-4 6-9 61-6 9-71 3-4 6-7 81-9 91 3-5 7-8 501-2 4-12 4 6-21 4-9 31 3-5",
    ": 7 9-40 2 4 7-9 51 4-8 60 2-7 72-3 5 7 80-6 9-91 4-7 9-604 6 9 11-20 3 6 8-9",
    ": 32 7-40 2-8 50-2 5-8 61 3 8 70 4-8 80-2 4-91 3-700 3 5-10 3-5 23 5-8 31-3 5-6",
    ": 9-40 2-3 5-6 9-50 2-8 61-3 7 9-72 9-80 4-93 801-2 4-5 7-10 3-21 3-5 7-42 4-5",
    ": 8-50 3 5-6 8-9 62 5 9 73 5 8-9 84 6-9 92-3 6-8 901-9 11-5 8-21 4-7 34-5 40-8",
    ": 51-5 9-60 2 4 8 70-1 3-7 9-80 2-9 91-2 4",
    ": 6-5000 5-10 2-5 7 9 23 5 7-8 30-2 4-42 4-7 9-50 2 4 6-63 5 7-9 73-4 7 9-80",
    ": 2-4 6-7 9 92-4 7-8 101 5-18 21-7 9-31 3 40 2-3 5-8 50 3-7 9-60 3-70 2 4 6",
    ": 8-86 91 5-8 200-5 7-8 10 2-3 5-8 21-2 5-7 31-2 5-6 40 3-4 6 8 51-2 4-5 7-60 3",
    ": 5-7 70-8 80 3 7 9 92-5 8 300 5-12 7-21 3-9 31 3-7 40-1 3-4 8 51-8 60 5-7 9-73",
    ": 5-6 80 6 9-90 3 5 7-8 402-7 10-5 7 21-3 5 8 31 3 5-7 9-40 2-5 52-6 8-9 62-4 6",
    ": 8 72-80 2-3 5 8-9 91-4 500-3 5 13 7-20 2-3 5 8-31 3-6 8-9 43 5 7 50 2-6 9",
    ": 61-2 5 8 70 2-3 5-8 86-90 4 7-9 602-6 8 13-4 6-9 22 4-30 2-4 6-40 2-3 6 50-61",
    ": 3-8 70-1 3-7 9-81 3-90 3-7 9-701 4-11 4-20 3-4 6 9-31 3 5-6 41 3-5 7 51-3 6-8",
    ": 60-2 4-9 72-8 80-4 7-9 91-2 7-9 802 5 9-16 24-6 8-9 33-7 9-42 5-9 52 4 8-61 3",
    ": 5 9-71 3-6 8-81 5 8-9 97-902 5-7 9-14 6 8-20 3-5 7 9-30 2-5 7 9-54 9-61 4-5 8",
    ": 70-1 3-4 7-9 81-2 4 6-7 90-1 4 6",
    ": 9-6003 5-6 8 10-1 3 5 7-8 21 5-30 2-41 3-5 7 50-1 3-4 7 60-1 3-5 8-9 71 3-5 8",
    ": 81-6 8 90 3 6-9 101 3-5 8 10 2-8 20-5 30 4-5 7-8 40-5 7-8 52-3 7-8 61-5 7-9",
    ": 71-81 4-5 7-8 92 5-7 201-3 5-6 8 11-2 5-23 5-6 8-33 6-43 5-9 52 4-61 3-8 72-3",
    ": 5-8 80 2-6 8-91 4 7 300-2 4-5 10 4 6-7 21-5 31 4-42 4-8 52-3 7 9 63-6 8-9",
    ": 71-3 5 7-8 80-1 4-5 7-91 3-6 400-1 3-4 6-7 10-3 5-6 9-22 4 6-35 7-40 2 4 6",
    ": 8-50 2-3 5-7 9 61-2 5-6 8 71 3-6 8 84 6 8 90-2 4-501 4-5 8-9 11 5-9 21-3 6-8",
    ": 38 42-3 7 9-59 63-4 7 9-72 4-7 80-1 4-8 90 6-7 9-600 2-7 13-5 20-1 3 6-7 9-31",
    ": 3-9 45-6 9-50 2-3 7 60-2 4 7-74 6 9-82 4-5 94 6 700-5 7-8 12-7 9 21-6 8-32",
    ": 6-7 9 42-4 7 9-50 2-5 9-67 9-74 6-81 3-4 8-9 92-4 6-8 800-3 5 10-5 7 20-5 7",
    ": 9-30 2-41 3 5 50 2 4-9 63-4 6-9 71-8 80 2-5 9 91-3 5 7 901-7 9-19 22-4 6-7",
    ": 9-35 7-40 2 4-7 50 2-4 6-7 9-60 2-6 8-9 73-4 7-80 3-6 9 91 6-7 9",
    ": 7001 3 5-8 11-3 7-22 4-6 30-2 4-5 7 9-40 5 8-54 6-7 9-61 3-4 6-70 2-6 8-84",
    ": 6-8 90-2 4 6 9-103 6-10 3-4 6-9 22-4 6 8-9 33-45 8-51 5 7-8 60 5-8 71 3 6-7",
    ": 80-1 3 5-8 91 5 7-9 201-2 4-9 11 3-4 6 20-1 3-8 30-43 5-8 52 4-6 8-63 7-9",
    ": 71-2 4-5 7 9-81 3-93 5 7-301 3-5 7-8 10-1 4 6-22 5-7 30 3-8 41-2 4-8 50 3-4 6",
    ": 8-61 5-7 9-74 6 9-81 3-5 7 9 91-3 5-400 6-11 3-20 2-3 5 7 31-3 7-8 40 3-8 50",
    ": 2-3 6 9-60 5-6 8-9 71-2 5-7 9-81 4-5 7-90 2-7 9-502 6 10 2-22 4 6 9-32 5-6 8",
    ": 40-4 6-7 9 53-8 60-8 71 4 6-7 81-2 4 7-91 3-7 9 601 4 7-9 11 4 6-7 20-35 8-40",
    ": 2-9 51-2 4-9 62-70 2-6 9-80 2-3 5-94 6-707 9-11 4 7-8 20-4 6-8 30-3 5 7-8 40",
    ": 4 6-7 52 5 7-9 63-4 6-72 4 7-82 5-8 90-800 4-5 7 9-10 3-5 7 9-24 7-8 31-2 4-6",
    ": 9-42 4-7 9-50 3-4 7-62 4-5 7-73 5 8 81-7 90 2 4-5 7 9-901 5-10 2-5 7-20 2-3",
    ": 5-6 8-9 31-2 4 6-41 3-4 7-9 52-63 5-6 9-73 6-7 9-81 4 9-91 4-5 7",
    ": 9-8000 2 7-10 2-7 20-1 3 5-6 8 30-2 4-6 8 43-6 8-52 4-5 7-8 60-1 3-7 72-3",
    ": 7-81 3-5 9 91-3 5-7 9 101-3 5 7-12 5-6 8-9 22 6-7 9-30 2-5 7 40-1 3-9 51-2",
    ": 7-9 62-5 7-70 3 7 9-80 2-4 6-91 3 5-6 8-9 201 3-7 9 13-6 9-21 4-5 7 9 31-41",
    ": 3-4 7-50 2 60-1 4-6 8-70 3-4 6 8-82 4-5 8-9 93 5-7 304-5 7 9 11-4 7-21 3-5",
    ": 7-8 30 2-40 4-51 4-5 7-60 3-8 73-83 6-8 90 3 5 7-400 3-4 9 11 4-5 7-8 20-3",
    ": 7-9 31-8 40 3-5 8-51 64 7 70 2-3 7 9-87 9 92-3 6-9 501-8 10-3 5-7 9-24 6-9",
    ": 37-8 42 4-6 50-4 6-61 3-6 73 7 9-84 6-9 91-6 9-600 2-4 6-14 6-9 22 4-5 9-42",
    ": 4-5 8-9 52 5-61 3 6 74 9-81 4-91 3-700 2-5 10 3 5-8 22-8 31-3 6-8 41-2 4-6",
    ": 50-8 60-4 6-7 70-1 5-80 2 4-8 90 2-8 802-3 5-7 10 2-3 5-20 2-5 7-8 30-4 8",
    ": 40-2 6-7 9 52-5 7 9-65 7-71 5 80-4 7 9-91 3-8 900 2 5-9 12-4 6-7 25 9-31 5",
    ": 7-40 2-4 7-8 54-6 8 60-1 3 5 8-70 4 80 2-95 7",
    ": 9000 3-4 6 8-9 13-4 6-7 21-5 7-9 31-2 6-7 9-41 4-7 9-56 9-60 2 4 6-7 71 3 5",
    ": 7-8 80 2 5-90 3 7-104 6-8 10 2 5 7-22 4-8 30-3 5-6 42-3 5-8 54-6 63 6 8 70 2",
    ": 6-7 82-3 5-6 8-9 92-5 7 9-200 3 5 7 9-12 4-5 7 9 24-5 7-8 30 4 6 8-44 6 9-51",
    ": 3-4 6-62 4 6-8 71-5 8 80-2 4-8 91-2 4 300-5 10 3 6-9 23-4 6-31 3-8 44-5 9-50",
    ": 2 4-7 60-1 3-4 71-2 4-81 5-6 9-91 4-403 6 8-12 4 6-9 22-6 30-1 3 5-8 40-1 6-8",
    ": 53-5 8-62 5-6 8 73 6 81-2 4-5 7-9 91-2 7 9-505 10-5 8-21 5-6 32-6 8 40-3 6",
    ": 8-50 2-4 6-7 9-62 4 9-72 4-5 7 9-86 9-95 9-600 5-6 8-9 13-6 8-9 23-4 7-9 31-3",
    ": 5-6 8-9 41-3 5-7 9-66 8-77 9 82 5-7 9 92-700 3 5-8 10-1 6-8 20-2 4 6-30 2-6",
    ": 8-40 3 5 8-53 5 7-69 72 4 7-82 4-5 7-90 2-3 7 9-805 7-12 4 6-8 23-7 30-1 3 5",
    ": 7-44 6-8 50-3 6-7 9-62 7-9 71 3-7 9-88 90 2 7-900 2 4-5 7-8 10-5 8-20 2-6",
    ": 8-30 2 4-6 8-44 7-51 3 5-7 61 3 8-70 3-7 9-80 3-6 8-93 5-7",
    ": 9-90008 10-2 4 7-27 30-2 4-6 8-9 41-2 5-6 8 50-3 5-6 9 61-4 6 9 72-4 6 9 81-4",
    ": 6-8 90-3 5-101 4-20 3-4 7 9 31-4 6 8-41 3 6-53 6-9 61 4-5 9-71 3-4 7-81 6 8-9",
    ": 91-3 5-202 7-10 2-3 5-9 22-5 7 32-7 9 43-5 8-9 51-2 4 6 8-9 61 3-5 70-1 3-8",
    ": 80 2-4 6 8-9 93-300 3-8 10-3 5 7 24-5 7-30 3-5 9 41-4 7 9-52 6 8-9 61-3 5 8",
    ": 70-3 8-80 2 4-9 93-6 8-400 3-4 6-7 9-19 21 4-6 8-38 41-3 6-8 50-8 61-4 6 8 70",
    ": 2-5 80-2 4-95 7-500 4-10 2 4-21 4-7 30-8 42-3 6 9-52 4-60 3-5 7-71 3-9 81 4",
    ": 6-7 9 91 5-9 604 6-7 11-5 8 22-3 7 9 31-8 40-2 5-6 8-50 2 4-5 9 64-5 7 72-85",
    ": 9-91 4-5 8 700-2 4 7 9-10 3-6 8-20 2 4 7-8 30 3-5 8-43 6 8 52 4-6 8 60-1 3-9",
    ": 71 3 5-7 81-2 4-90 2-3 5-9 808-11 3 5-20 2-3 6-9 32-7 41-4 7-8 50-60 2-3 5-8",
    ": 70 3-7 9-80 3-5 7 9-905 8 12-5 7-8 20-5 7-8 30-4 6-40 8-50 6-7 60 2-5 8-9",
    ": 74-7 9-85 9-97 9",
    ": 1001 6-11 5-6 8-21 3-4 6 9-30 2-7 9 41 6-9 51-2 5-6 9-60 4 72-4 9 82-5 8-9",
    ": 91-2 9 101 3 6-8 11-2 5 9 21-4 6-8 31-3 5 7 9-41 3-51 8 60-1 6 8 71-3 5-6",
    ": 8-80 3-5 7 90-201 4-6 8-9 12-8 20-1 4-7 31 5-40 2 4 9-57 9-65 7-73 5-9 83 6-7",
    ": 9-90 3-9 302 4-11 4 6 21-3 6 8-30 3 9 41 3 8-9 52 4-5 7-61 3-5 7 9-70 5-6",
    ": 8-80 2-4 6-9 91 4-7 400-3 6 8-10 2-3 6-8 20-2 4-31 4-50 4-5 9-60 2-4 7-8 71",
    ": 3-4 81 5-6 9-98 500-1 3-6 8 10-20 2 4-7 31-4 40-1 4-6 8-9 52-4 8-60 2-6 8-9",
    ": 74 81 3-5 7-9 91-2 6-7 601-4 8-12 7-8 20 2 4 6 8-9 37 41 5-7 9 51 6-61 4 6",
    ": 8-75 9-80 3-5 7-97 700-5 7-10 3 5 8 20-3 7-9 32-3 6 9-40 4-5 8 50 2-4 6 9",
    ": 64-7 9-70 6 8-84 7-90 2-7 9 801 3-8 10-9 25-7 9-30 3-4 6-41 3-7 50 4-5 7-8 60",
    ": 2 4 6 70-1 3-4 7-82 5-6 8-92 4-5 8-906 8-9 11-2 4-9 21-2 5 7-9 31-4 6-8 40-2",
    ": 4-53 5-7 9-65 7-70 2-3 5-7 9-80 2-3 5 9 91-6",
    ": 9-2003 5-9 11-5 8 20-1 4-5 7 30 2 4-8 40 4-5 7 50 3-4 6 8 60-4 7-71 3-5 7-8",
    ": 80-1 5-8 92 5-6 8 101 5 7 9-10 2 5-6 8-9 22 5 7-36 8-42 4-7 9-50 2-60 2 4-9",
    ": 71-2 4 6-9 83-5 8-94 8-200 2-3 5 7-9 11-2 8 21-2 4 8 31 3-4 9 41-2 5 7-51 3",
    ": 5-8 60-1 4-9 71-5 8-81 3-4 6 9-91 4 7-8 300-6 8-11 5-8 24 6 8 31-3 7-8 41-7",
    ": 9-50 6-8 60 2-5 8 70-6 9 85-7 91-4 8 400-1 3-4 7 9-11 4-7 9 24-36 8-9 42 4-6",
    ": 8-50 2-3 6 8-60 6 70-1 4-5 81 5-6 8-9 91-3 5-7 9-500 2 5 9 12-7 9-20 2-3 5-6",
    ": 8-9 31-3 7 9 42 51 7-8 62-4 7-9 71-3 5 80 3-8 90 2 4-5 7-600 3-4 6 10 4-5 7",
    ": 20-2 4-7 32-5 7 42 4-5 7-50 2-4 6-61 6 8-70 2-83 5-702 4 7 9 11-3 7-8 21-2",
    ": 4-5 9 32-5 9 43 50 2 4 9 61-9 76 8-82 5-91 3-8 801 7 13-6 28-31 3 5 9-44 7-8",
    ": 50-2 4-8 60-8 70-83 7-8 90-7 9 902 5-6 8 11-5 7 9-27 9-30 6-7 9 41 3-51 3-5 7",
    ": 9-60 3-4 6 9-74 6-7 9 81-4 9 91-6",
    ": 8-3000 5-6 8-16 8-20 5-8 31 3-6 9-43 8-9 52 4-5 7 9-60 5-73 5-7 80 2-6 8-9",
    ": 94-8 100-1 3-6 9-12 4-5 7 20-1 3-6 30-2 6 8 43-6 51-6 60 3-4 7-9 77 80 2 6-8",
    ": 92-7 203-8 10-20 4 30-1 40-3 5 8-50 6 8-9 61-70 2-4 7-8 80-2 5-7 94-5 300-6",
    ": 8-9 15 8 20 2-4 6 8-9 32-6 8-44 6-51 3-8 62-6 70-2 7-82 5-92 4 7-8 400-1 6-7",
    ": 9 11-6 23 5-8 33-4 7 42-6 8 50-2 4-8 61-2 6 9-74 6 9-86 9-90 3 5-9 501 3-5",
    ": 7-17 9-22 4-8 30-41 3 6-9 51-3 5 8 61 4-5 8-73 5-6 8-9 81 5 7-96 8-600 2 4",
    ": 8-10 2-4 6 8-9 21-2 4-7 9-30 2 6 9-49 51-9 61 3 5 7 9-73 5-7 9-82 4 6-8 91-3",
    ": 5-6 9 702 4-6 8-15 7-8 22-5 7 9-33 5-7 9-40 2-5 7-9 51-2 5 7 60 2-4 6 8-71",
    ": 3-4 7 9-80 5-93 5 8 801 4-8 10-5 8-22 4-34 6-8 40 2 5-7 9-51 4-5 7 9-60 2 4",
    ": 7-8 70-1 8 84-6 9 91-3 6 9-901 4 6-7 11-2 7-9 21-8 31-5 42-4 6-7 9 51-6 8-66",
    ": 8-75 7 9 82 4-5 7-9 92 5 7 9",
    ": 4001-3 5 7-8 11-2 4-8 20-2 4-5 7 9-30 2-4 7 9-44 8-50 2-9 62-6 9-70 4 6-8",
    ": 80-7 9 91 3-7 9-102 4 6 8-14 9-21 3-4 6-7 9-33 7-8 40 3 5-6 8-9 51-7 9 62-6",
    ": 70-85 7 9-90 4 8-9 201-4 6 8-14 6-8 20-6 8-30 2-3 5 9-40 2-5 7-56 9-64 8 70-2",
    ": 4 6-80 2-3 7-91 3 5-307 9 11-3 7-8 20-4 6 32 5 8 40-2 6-7 9 52-3 60 4-8 75",
    ": 7-9 81-2 6-9 91-5 7 400-1 3 5-6 11-4 7 22-3 6 8 32-5 8-9 41-5 7-9 51 3-6 60",
    ": 2-5 8-70 2 7-8 80-2 4 6 90-3 5-6 8 500-6 11 6-20 5-8 30-2 6 8-41 3-4 7 52-3",
    ": 8-61 3 5-72 4-5 8-9 81-2 6-7 9-91 3 5-6 8 601-2 6-7 10 2-4 7-28 31-3 6-7 9-42",
    ": 6-51 3 5-6 8-9 62 4-70 2 8-85 7-8 92 4-9 703 6-8 10-2 5 8-24 6 8-9 31-5 7-40",
    ": 2 6 9-50 2-3 6-8 60-6 8-9 71-3 6-8 80-5 7-8 90-2 4-6 800-8 10-1 4 6 20-2 5-8",
    ": 31 6-8 40-6 8-9 51 4-5 7-8 61-3 5 7-70 2 5-6 80-4 6-8 93-4 6 8-900 4 6-8 10-2",
    ": 4 6-8 21 3-5 7 9-37 9-44 7 9-54 6-9 62-4 6 9 71 4 6-7 9 83 7-91 3-4 6 8-9",
    ": 5002-3 7 10-3 5-9 21 4-6 9 31 3-4 9-41 3 5-9 51-3 5-8 62 7-72 4-86 9 91-5 7-9",
    ": 101 3-4 6-9 11-3 5-8 20-1 3-6 8-31 4-9 42-3 5-52 5-6 8-60 5-73 5-7 9-90 2-3",
    ": 5-6 8-9 201-5 7-8 10 3 6-21 6-7 9-30 2 4-7 9-40 2-3 5-7 50-3 5 7-60 2 5-7 9",
    ": 71-4 7-8 82-91 5-6 8 300-1 3 6-7 9 14-5 7-20 2-6 8-30 2-4 6-7 41-2 4 6-8 50-6",
    ": 9 62-3 6-70 2-4 7-8 81-3 5-7 90 3-4 7-401 3-4 6-8 10-1 3-8 21 4-6 8 31-2 4-7",
    ": 9 41 3-7 50-2 4-60 2-3 5-72 4 6 8-9 82-7 9 91-4 6-8 500-1 3-5 9-13 5-6 8 20-3",
    ": 5-6 8-9 31 3 5-9 41-2 4-8 50 2-8 60-4 7 70-1 3-6 8 81 3 6-92 4-8 601 3-7 10-2",
    ": 5 7-24 6-7 9-30 2-3 7-41 3 5-8 54 6-8 60 2 4 6-9 71 3 6-9 82-6 93-8 702 7-14",
    ": 7 23-7 9 31-4 6 9-42 4-6 9 52-3 6-7 9 61 3 5 7-72 4 6-9 82-9 91-3 5-6 9-813 5",
    ": 7-22 4-7 9 32 4-5 8-40 2-3 5-8 50-2 5 8-63 5-75 7-9 82-3 5-7 9 91-4 7-901 6 8",
    ": 12-4 6-21 4-6 8-34 6-7 9-44 6-7 9 52 8-61 4-5 8-72 4 6-9 83-90 2 4-8",
    ": 6002-3 5-6 8-10 5-8 22-5 7-8 33 5-9 42 4-7 53 9-61 3-6 72 5-6 89 93 5-9 105-7",
    ": 9 12-4 6 8-9 21-2 4 6 30 2 6-8 42-3 6-7 50 3 5-6 8-69 71-4 8-87 9-94 6 8",
    ": 203-6 8-10 5-24 9-30 2-3 7-40 6-8 50-2 4 6-7 60-9 71-3 7-9 81-3 5-8 91-302 4",
    ": 6-11 5 7-9 25-6 8-34 6-7 9-43 7-8 50 3-5 9-60 2-74 6 8-84 6-7 91 3 5-6 8-400",
    ": 2 4-7 10-5 7-27 30-3 6-44 6-8 51-2 4-61 3 7-9 72-4 6-84 6-7 92-500 2-3 5 8",
    ": 10-1 4 8-20 3-6 9 31-2 7-40 2 5-9 51 5 8 60 4 6-8 70 2-4 6 8-9 81-2 92-3 6",
    ": 600-1 7-9 11-3 5-20 2-5 7 9-30 2 4 6 40-2 4-8 51-4 6 8 60 3-6 9 76-9 81-2 4-9",
    ": 91-8 700 2 6 8-10 3-5 21-3 5 7 30 3-9 41-3 5-6 50-1 5 8 61-2 6-7 9-70 2 5 7",
    ": 9-83 5-92 4 6-811 5-7 20 2-3 5 9-30 2-4 6 8-9 41 5-57 60-70 3-82 4 7-93 6-7 9",
    ": 902 4-5 9-10 3-5 7-21 3-6 8 31 3-4 6 8 40 3-5 8 50-8 60-3 9 71-5 7 9-82 7",
    ": 91-6",
    ": 9-7000 2-8 14-8 21 3-34 7-41 3-6 8-53 5 7 60-1 4-5 7 9-76 9 81 6-7 9 91-2 4-8",
    ": 102-6 11-6 8-21 3 5-38 40-1 4-5 8-9 58-9 62-3 5 7 9-78 81-5 7-9 91-3 7-9 201",
    ": 3-4 6-8 11-2 4-21 3-5 7-8 30 5-7 9-47 9 51-61 3-6 8 70-3 7 80-2 5-93 5 8-300",
    ": 2 4-6 8-13 6 20 4-5 8 31-4 6-9 42-3 6-7 9-60 5 8-82 4 6-8 90-1 3 5-411 5-8",
    ": 22-3 5 7-9 31-4 6-8 40-7 9 51-2 5-7 60-4 6-7 9-70 2-5 7-9 81 4-5 7-8 90-4 7",
    ": 502-3 5-7 9-11 3 6-7 20-2 5 9-30 3 5-7 9-40 2-3 5 8-52 61 3-4 6-70 2-4 8-9",
    ": 81-9 91 4-6 601-2 5-6 8 11-4 6 8-9 23-4 9 33 7-41 3-6 52-6 8-66 70 2 7-8 83-7",
    ": 9-90 2 4-6 8 701 4-6 8-9 12 4-6 9-20 3-4 6-30 40-1 4-6 8 50-2 4-9 61-7 9 71 4",
    ": 7-8 82 5-6 90-1 3-4 6-7 9-803 7 9-17 20 2 9-30 3-7 9-43 5-6 9-53 5 8-63 6",
    ": 8-73 6-81 3-5 9-90 2-3 5 9-904 6-7 10 2-3 5-21 4-8 30-2 4 7-41 3-5 7-55 61 3",
    ": 6-70 2-9 83 5-6 8-90 2-4 6-8",
    ": 8001-3 6 11-2 7 9-20 2-3 5-33 5-9 41-2 7-8 50-2 4-8 61-3 5-8 70-1 4-5 7-8",
    ": 81-2 4-7 9-93 5 100-1 6 8 12 5 7-8 20-5 7-31 3 8 40-1 3-6 8-50 3 5-6 8-9 61-3",
    ": 5-6 8-9 72 6-7 9 82 4 8-90 2-3 6 9-202 5 8 10-4 7-8 20 2-5 7 30 2-5 8 41-5 8",
    ": 50 2-6 8 60-2 4 6 8-72 4-6 8-90 2-6 300-1 3-4 8-9 12-5 7-23 6-32 5 7-45 7",
    ": 9-51 3-9 61 3-5 8-75 8-86 8-92 4-6 8 400-6 9-14 6-8 20-5 8-35 40-1 5-50 7-8",
    ": 61 4 8-71 6-8 81 5-6 90-2 5 8-505 7 14 6 9 21-4 7-9 31-2 4-5 9-41 3-6 50-8 62",
    ": 4-70 4 9-80 2-4 6-9 92 4 8-603 5-9 13-8 26 9 31-4 6-9 43-4 6-7 50-1 3 5-6",
    ": 9-61 3-5 7-78 81 3-5 7 90-1 5 7-8 700-4 6 11-3 5-6 8-9 23-4 6 9-30 3 6-7 41-4",
    ": 8-9 51 4-5 7-8 60 2 4 7 70-1 3 6 82 6 93-4 6-9 802-5 7-28 30 3-4 8-42 4-6",
    ": 9-52 4-7 9 61 5 70-6 8 80 3-6 8 90 2 5 7-8 901-4 8 11-7 20 4 6-32 4-5 40 2",
    ": 4-5 7-53 5-60 2-5 8 70 2-3 9 82-6 9-91 3-5",
    ": 8-9000 3-4 7-8 12-3 5-6 8-9 21-5 8-9 31-4 7 40-6 50-7 9 61 9 72-5 8 82 5 8-98",
    ": 101-5 9-12 5 8-9 21-5 7 9-36 8-42 6 8-9 53 6-61 4-5 8-9 71 3-4 80-5 9-90 3 5",
    ": 7-8 200-4 6-7 9 11-3 5-21 4 6-8 30 2-4 7-40 2 4-5 50-1 4-6 60 2 6-8 71-3 5-7",
    ": 9 82-4 6 92-4 6-302 4-6 8 11-8 22 4-8 30 2-4 6-45 7-52 4-6 8-9 61 4-70 2-3 5",
    ": 7-8 80-1 5 7-9 91 3-4 7 403-4 6-7 9-11 3 5-7 9-22 5-6 8-9 32-6 8-41 3-6 9-51",
    ": 4 6-60 5-8 70-1 4-7 80-3 5-7 9-91 3-6 8 502-5 10 2-3 6 9-21 3-5 7-8 31 3-4",
    ": 7-9 41-3 7-8 52-3 5 7-8 60-3 5-6 8-70 2 4-82 4-8 90-3 6-7 601-3 9-10 7-8",
    ": 20-30 3 5 7-9 41 5 7 50-8 62-6 8 70 2-4 9 83 6-91 3-6 8-702 5 8-9 11 3-4 6-8",
    ": 21-2 4-7 9-32 5-7 40-1 4 9 51-6 8-9 62-3 5-6 9 78 83-6 8-9 91-2 4 6-800 2 5",
    ": 10 3 5-7 9-24 7-9 32-3 6 9-41 3-5 7 51 3 5-9 62-4 7 9-72 5-9 81-3 5-7 9-91",
    ": 4-6 9-900 2 6-7 9-12 4-5 7-8 20-6 8 31 4-7 9-40 2-5 8-9 54-5 8-9 61-9 72 4-82",
    ": 4-6 8-93 6-8",
    ": 400000 2 7 9 13-4 8-20 2-5 9 33 6-7 9-48 50-2 4-6 60 3-6 9-73 5-80 2-3 5 7 9",
    ": 91 3 5-7 9-102 5-6 8-13 8-21 4-7 31 3 7-41 3-51 3-5 8 60 4-70 2-3 6 80-7 9-94",
    ": 7-201 3-6 9-10 2-3 5-8 20-3 8-9 31-5 8-41 4 6-8 50-60 2-4 6-8 70 2 5-82 5",
    ": 7-90 5-6 8-308 10-2 4-7 9-23 5-6 8-31 4-43 6-7 9-50 3 5 7 60-2 7-70 2-81 3",
    ": 9-90 3-6 9 402-6 8-15 7 9-20 2-8 31-3 7 40-2 5 7-9 51 6-63 5-77 80-2 5-8 93-8",
    ": 502-4 7-8 11-2 4 7-21 3-8 30-4 40 2-4 6-9 52-5 7-61 71-2 4 8-9 81 3-4 7 9",
    ": 92-8 601-7 9 14-21 3-4 6 9-30 2-4 7-9 41 3-50 2-3 6-7 9 61 3-4 7-8 70-6 9-81",
    ": 5-92 6-8 700 4-6 9-10 4 6 9-32 4-8 41-4 7 9-50 2-4 7-64 6-9 71-3 5-7 9 82-5",
    ": 8-9 92-7 9 801-2 4 6-7 9-17 20-1 3-7 30-1 4 6-9 42-5 9-50 3-9 61 3-4 6-76",
    ": 9-80 3-4 6 8 92-4 6 8-901 3-5 9 11-23 6-35 7 9-40 2 5 7-50 2-3 5-63 8 70-3",
    ": 5-6 9 83-91 4",
    ": 1000-10 2-7 9-23 6-31 3-4 6 9-44 6 8-9 51-9 63-5 8-75 7-81 5-6 9-92 4-5 7",
    ": 100-5 8 10-1 4 6-23 5-7 30-2 4 6-45 8-51 3 5-6 9-64 71 6 8 80-1 4 6-7 9-91",
    ": 6-7 9-201 3-8 12-6 8-9 21 5-8 30-5 7 9-40 3-9 51 3-8 60-3 5-73 5 7-8 82-3 5-6",
    ": 90 2-4 6-300 6-8 10-1 3 5 7-8 20-3 5 7-31 4 7-41 4 51-60 2-4 8-71 3-5 8-9",
    ": 83-6 9 91-2 4 6 8 403 8-14 6-8 24-5 7-8 31-7 9-43 5-6 51-4 6 9-61 3-5 8 70-1",
    ": 5 8 80 2-5 91-2 7-500 2 5 7-9 12-7 9 21 4 6-34 6-9 41-2 7-8 50-2 5-7 9-64 6-7",
    ": 9 71-7 9-86 8-9 91-3 6 8-602 5-12 5 8-25 7 9-31 4 7 9-43 6-8 50-6 9-61 3 5 7",
    ": 9-73 7-86 9-94 8-701 5-6 8-10 5-6 8-25 8 33-9 41-3 5-7 9-55 7-8 61 3-5 7 71 4",
    ": 6-7 9-82 5-92 5 7-8 800 2-4 7-11 3-4 6-9 21-6 9 35 7-9 42 4 7 50-1 3-5 7-8 60",
    ": 2 6-70 2-3 82 5 8 92-3 8-906 10 3-5 8-22 5-7 9 31-4 6-8 40 6 9 53 5-8 64-5",
    ": 8-70 3-4 6-80 2-3 5-6 90-1 3-4 6-7",
    ": 9-2003 6 12-4 7 21 5 7 9 31-2 4-5 7 9-40 2-5 7-59 63-5 9 77-82 4 6 9 93 9-102",
    ": 6 8 10-1 5 9-23 5-6 8 30 2-9 41 3 5 7-50 2-3 5-7 9-61 3 9-72 5-7 81-3 5 7-93",
    ": 5 9-207 9-24 8 30 2-3 5-40 2-4 7-8 50 2-4 6-8 60-1 4-72 5-7 9-81 4-7 9 91-4 6",
    ": 8 300-4 6-7 9-12 5 7-27 31-3 5 9 41-3 6-7 9-54 6-63 5 7 9-73 5 7-9 81-2 4 7-9",
    ": 92 5-9 402-9 11-6 8-21 3-5 7 9-41 5 7-9 52-3 5-8 62 4 6-9 76 8-9 82 4 9 91",
    ": 3-4 6-9 502-3 6-8 10-3 5-8 20 2-3 5-6 8-30 3-9 41-2 4-7 50 2-3 5-6 8-9 61-70",
    ": 2-4 9-81 3-4 7-8 90 2 7-603 5-7 9-14 6-8 21-4 6-9 35 7-8 40-1 3 50-2 4-5 8",
    ": 60-1 3-8 70 2-4 7-8 81-2 4-6 9-93 5-6 8-9 702-11 3-5 8 21-5 9 31-7 9-40 2 4-5",
    ": 9 52 4 9-63 6-8 70-7 9-80 2-6 8-91 5 7-9 802 4 7 9-12 4-6 8 22 4-5",
    ": 596896 9-900 2 4 6-10 5 8-9 22 7-8 30 2 5-8 40-3 5-6 8 50-5 7 9-60 2-4 7-75",
    ": 7-8 80 2-8 91 4 6 8",
    ": 7001-2 7 9-14 6-7 20-2 4-6 30-2 4-40 7 9-56 8-65 7-9 71-4 6-80 2-5 8-90 2 6 8",
    ": 101-3 5 9 12-5 8-22 4-8 32 4-6 9 43-5 7 52-5 8-9 62 4 8-71 4 6-7 81 4-91 3",
    ": 5-9 202-5 7-9 11-2 4-5 8 20-1 3-4 7-35 8 40 3 5-6 50-2 4-5 7-60 3-6 8-74 6 8",
    ": 82 5-6 8-90 3-5 7-302 5-6 8 11 3-8 20-1 4-7 9-33 5 41-2 7-50 2-7 60-5 7-70 3",
    ": 9 83 5 7-90 3 8-402 5-9 13-4 6 22-6 8-31 5-6 8-9 41 3 6-7 9-50 4 7-8 60-3 7-9",
    ": 71-2 8 81 3-6 91 3 7-8 501 6-11 3 5 21-2 4-8 31-3 5 7 40-1 9-52 5-6 9-60 2",
    ": 4-73 5 7-9 81-2 5 7-94 6-8 600 2 5-7 9 11-5 7 9 21 3-4 6 8 30-1 3-5 8-9 41 3",
    ": 5 7-8 50 2-7 60-2 7 9 71 3 5 9-80 4 6 92 4 6-9 701-2 4-5 7-13 6 9-22 4 6 8-9",
    ": 31 3-5 7 9-41 3-4 52-6 62 9-74 6 8-80 4 7 9 91-4 6-9 801-2 5-6 8 10-3 6 20-8",
    ": 31 3-4 6-7 42-4 6-51 3-7 9-61 3-4 6-7 9-71 3-5 8-82 4-5 7 91 3 6-9 905-7 9",
    ": 11-2 5-20 5-30 2 5 8-9 41-4 7-8 51 4 7-60 6 8-74 6-8 81 3-7 90 4-5 7",
    ": 9-8000 2-22 4-6 8 30 3-4 6-7 9 43 5 7 9 52-3 6-7 9 61 4-5 7-8 70-1 3 7-9 81-3",
    ": 7 90-2 5-100 2 4 6-7 9-10 2 4 6 21-4 6-7 30 3-4 7 40 5 8-51 3 5-6 60-5 7-70",
    ": 4-7 9-80 6-7 90-1 4-5 7 9-200 3 14-20 3-4 7-9 31 4-5 7 9 41 3 5-51 5 8-60 4-5",
    ": 7-70 5-83 5 7 9-91 3 5 9 302-3 10 4 6-7 22-4 36-8 40-4 7-9 51-6 8-62 5 7 70 4",
    ": 6-7 9-85 7-9 91-2 4 9-404 8-9 12-4 6-9 23 6-8 32-5 8-40 2-6 8 50 2 5 7 9-67",
    ": 9-75 7-9 81-2 5-8 91 6-7 9 504-9 11-5 9 23 9-30 2-4 6 8-40 2-5 7-8 51 5 7-64",
    ": 6-70 3 6-8 80-2 7-91 3-603 6-11 4-8 20-3 5-8 31-2 7-9 42-4 8 50 4-6 8-60 3 7",
    ": 71 4 6-8 81-2 7-8 93-8 701-2 4-5 10-1 5 7 23-5 32-4 7-8 42-6 8 50-1 4 7 60-1",
    ": 3 5 8-80 2 6-9 92-4 7 801 4 6-8 13-5 7-8 20-1 3-4 8-9 37 9 41 4-5 7-9 51-8 60",
    ": 3 7-8 70 2 4 6-7 80-1 9 91-2 4-5 7-903 5 11-2 5-8 20-3 5 7-9 32 4-5 7-41 3-4",
    ": 7-51 4-9 61 5-7 9-72 6 8-9 82 6-8 90 2-6 8-9",
    ": 9001-2 4 7 9 12-9 27-31 3-4 7-8 42-3 7-9 54-6 8-9 62-3 5 7-8 71-3 5 8-9 82",
    ": 4-5 8-96 8-9 102-3 9-10 2 6-9 22-4 7-30 2-4 6 9 41 6 8 51-2 9-63 5 70-8 80",
    ": 3-5 9-91 7 9 203-9 13 5-7 21-4 7-30 2 4-6 8-43 5 8 50 3 6-7 61-2 4-70 2-4 7-9",
    ": 82-3 5 7-8 90 2-5 7-8 300 3-5 7-10 2-3 5-6 20-1 3-7 9 31-6 8 41-2 4-8 50-5",
    ": 8-63 7-8 71 3-9 81 5-7 91-7 405-7 9-12 5 20 6-9 31-3 5 7 9-40 3 6 8-50 2-3",
    ": 5-6 8 60-3 6 8-72 4-6 8 81 3-4 6-97 500-1 4-6 9-11 3-4 7 20-3 5 8-9 31-7 41",
    ": 3-7 9 51 3 6 8 60-2 5-6 9-71 7 9-87 9-97 9-601 3-4 7-9 11-2 5-7 20-5 7 9-31",
    ": 41 3 6-7 9 51-4 9-63 6 8-9 71-4 6 80 3-6 8 90-2 7-8 700 2-3 5-6 8 10 2-3 7 9",
    ": 23-4 7-31 4-6 41-3 5-8 50-1 5 9-62 4-72 4 6 80-2 4 6 8-90 3-6 8 800-3 7 9-10",
    ": 3-6 8-9 21-3 5-7 30 5-9 42 4 7 9 51-8 60-2 5-6 8-70 4-5 8 82 5-6 9-92 4-7 900",
    ": 5-7 9-15 8-20 3-30 4 6-9 41 8 52-64 6-71 3 5-7 80-2 5-6 8 90-2 4-9",
    ": 600001-2 4-5 9-10 2 4 6-21 3-32 4-5 8-43 5 7-52 5 7-61 3 5 7-9 71-2 5 8 82-5",
    ": 7-90 3-5 9-104 6-7 10-1 4-6 8-25 7 30-1 3-4 6-8 42 5 7-51 3-8 60-73 81-5 7-90",
    ": 2 5 8-9 202-9 12 4 7-20 2-3 5-9 31 4-5 7-8 40 2-4 6-52 5 7-8 60-7 9 73 5 8-80",
    ": 3-92 5 7-8 301 3 5 7-10 5 8-20 2-4 6 9 31-7 9 41 3 8-9 53-4 6-62 5-6 9-72 4-5",
    ": 7 9 83 5-6 9-93 5 7 400-1 3-4 6-8 10 2 4-5 8 20-5 7 34 6 8 40 2-53 8-63 5-9",
    ": 71 3-4 7-8 80 2-5 90 2-3 5-7 501-2 5 8 11-6 8-22 4-5 7-8 30-3 6-8 40-3 5-7 9",
    ": 52 5-6 9-62 6 9-77 81 3 5-90 2-4 6 8 600-4 6-7 10-1 3-4 6 8-20 2-3 5 9 32-5",
    ": 7-42 4-7 9-52 9-62 8 71-5 7-80 3-4 6 8-91 3 6 9 701 3-6 8-14 6-9 23 5-6 8-34",
    ": 6-40 3-8 50-2 4 6-63 5 9-72 5-7 81 7 9-91 3-4 6 8 800-4 9 11 5-6 8-20 2-3 6-9",
    ": 33 5-6 9-40 2-4 6 8 51 3 6 9-61 3-8 78 81-2 4 7 90-2 5 8-902 7-8 10-1 3 6 8-9",
    ": 22-3 5-6 9-30 2-8 41-2 4-5 7 50 3-5 9-60 2-78 81-2 4 6-92 4-6",
    ": 1000-1 3-4 7-10 2 4-6 20-4 6-8 30-5 7 40 2 4 7 9-50 2 5-9 62-7 71-2 4-80 2-3",
    ": 9 91-3 6-9 101-5 9-11 4-7 9 21 5-7 9-30 4-46 9-51 5-8 62 5 9-70 2 4 6 80-1 5",
    ": 7 9-91 3-5 7 9 201-2 7 9-10 2-3 5-7 20 3-4 7 31-2 5-6 9 44 8-51 3-4 8-61 3-7",
    ": 9 72 4-6 80-2 5-6 8 91-6 8 300-8 11-4 6-7 9-23 5-30 2-3 5 8-9 43 6 8 51 4",
    ": 6-62 5-6 8 71 3-81 4-8 90 2-4 6 9-406 10-5 9-20 3 5-7 31-4 6-7 9 41-5 7-50",
    ": 2-3 6 60-6 8-81 3 5-95 7-8 500-3 7-11 6-7 9 26-7 30-1 4 40-4 7 51-4 6-61 4 71",
    ": 4-9 82-3 7 93 6 8 603-4 6-7 10 3-5 9-25 9-33 5 9-43 5 8 52 5-6 60 2-4 6 9 71",
    ": 3-4 6-8 81-4 9-93 5 7 703-5 7-13 6-7 21-9 33-5 7 40-6 8 50-2 4 9 61-2 5-6 8",
    ": 71 5 7-81 3 6 9-91 3 7-8 803-5 8-11 4 6-7 21-2 4-7 33-5 9-40 2-3 5 9-54 6 8",
    ": 60 8 71 3 9 81 4-5 7 9 91-4 8 903 6 9 13 5 8-9 22 4 6-30 3 5 7 40 2-9 51 3-5",
    ": 9 62 4-5 8 70-5 8-80 2-3 5 8-9 92-6 8",
    ": 2001 3 6 9-17 20 2 5 9 32-5 41-2 4-54 6-7 61-5 7 9 71-4 6 80-5 7-90 4-5 8-103",
    ": 6-22 4 6-8 31-2 5 7 9-40 2-3 6 50-5 7-63 5-73 6-81 3-93 5 7-9 201 5-6 8 10-2",
    ": 5-7 9-20 2 7 9-37 40-1 3-52 4 6-60 2 6-7 70-3 6-8 80-2 4-5 9 91 4-5 7-9 301-4",
    ": 6-12 4-6 8 21 3 9-30 2-3 5 7 41-5 7-53 6 8 60-2 9-70 4-9 81-2 4-5 7-9 91 3-4",
    ": 7-400 5-10 4-6 8 20-1 3 5-32 5-42 4-6 8-53 6 8-60 4 6 9-72 4 6 84-7 9-95 7-8",
    ": 500 2 4-8 10 2-3 5-6 21 3 5-6 8-31 4-6 8-41 3-5 9 51-5 8-60 2-4 6-73 5-6 81-5",
    ": 9-93 5-603 5 8-11 3 7-8 20 2-3 5-6 9 33 6-7 9 41-3 5-6 8-9 52-4 6-61 3-4 6-9",
    ": 72-3 6-9 83-5 8-91 3 5-701 3-6 8-9 12-6 8 20-2 4-8 30-2 4-6 8-9 41-4 6 8-9 51",
    ": 5 8 60-1 4 8-70 3 5 7 81-2 5 7 9-93 5 800 6 8 10-2 4-5 7-8 20 6-7 33 5-7 40-8",
    ": 50 2-4 6 8-9 62 4-5 7 9-71 3 5-6 9-80 3 6-8 90-3 5-8 903-4 6-10 2-7 9-23 7 9",
    ": 32-8 40-1 4-5 8-52 5 63 5 7-8 71-4 7-8 80-2 5 7 9 91 3",
    ": 8-3000 3 6-7 9 11-2 7 9 21-7 9 33-7 9 41 5-6 8-9 51-2 4-60 4 6 9-70 4 8-81",
    ": 3-6 8 90 2-8 100-1 3-4 6 9-10 2-6 21-2 4-6 8-9 31-8 43-4 8-51 3-5 62 4 6 8",
    ": 70-1 4-5 7-8 81-4 7-8 91 3-8 200-2 6-7 9-16 20 2-3 5 30-1 3-4 8-40 2-7 50 2",
    ": 4-6 8-63 7 9 71-2 4-5 8-9 84 6 8 90 4 8-300 5-6 12-3 5-6 9-22 6 8-34 7-9 44-7",
    ": 50-5 7 9 61-4 8 71-2 5 85-90 2-5 7-8 407-8 12 4-6 9-20 5-7 9-32 4-6 8 40-1",
    ": 4-6 50-2 4-6 8-61 4-5 7-70 2-6 9 81-5 7-8 94 6-9 501-6 8 11-2 4-5 8 20 2 4-9",
    ": 31-2 4-6 9 43-6 9 51-3 5-7 9-61 4 7-8 71 3-4 7-8 80-2 6-8 90 2 4 6 8-9 601-3",
    ": 5-7 12 4-6 8-26 8-9 31-2 4-5 7-46 9 52-3 6-8 60 4-7 9 73-5 7 9-82 4-92 4-9",
    ": 702 4-5 7 9 11-2 7-8 20-5 8-30 2-4 7-40 2 4 6-7 9 51 6-7 9-61 3-7 70-3 5 7-8",
    ": 80-1 6 8-93 7-8 800-2 5 9 11-2 4 24-8 36 8-9 41 3 54-6 8-62 5-7 9-71 3 6 9",
    ": 84-6 9-90 2-6 9 902-3 5-7 10-4 9 21-7 30-1 3-4 6 8-40 3 8-50 2 5-61 4 6-7",
    ": 9-73 5 7-9 81-2 5-96",
    ": 9-4006 9 11 3 5-9 23 5 7-8 30 4-6 40-3 5-9 53-5 8 60 3-4 7-9 71-7 9 81 3 6-8",
    ": 92-5 7 100-1 4-6 10 3 5-7 9 23-30 2 4-8 40 2 4-6 8 50-2 5 7 9-61 6 9-70 2 4-6",
    ": 9 82-4 9-90 2 4 7-200 2 4 6 9-11 3 5-7 9 23 5-7 30-2 4-6 40-3 7-8 52 5 7 9-60",
    ": 6-8 70-1 6-7 9-80 3-9 98-308 14 6-22 6-9 31 4-42 4-8 51 3 5-6 8-60 4 8-72 4 6",
    ": 8-82 4-7 9 91-7 9-401 3-6 8-9 12-3 7-8 20-3 5-9 34 6 9-42 4 7 9-52 5-7 9-60",
    ": 2-4 7 9-73 5-7 9-80 4 7 90 2 5 7-502 4-6 8 10 2 4-6 8-21 3-5 7-9 31-4 9 41-5",
    ": 7-8 50-1 3 5-9 62 4-7 9 74-8 80-4 6-9 91 3-4 6-8 601-5 7-11 4-6 9 30-1 4-5",
    ": 7-43 6-54 9-60 4 72-5 8 80 2 4-5 7 90-1 5-7 9 702-3 5-7 9-11 3-5 7-23 7-31 3",
    ": 40-2 4-6 9-50 5 7-8 62-7 9-70 7-80 2-5 7-8 91 3 5-803 5 7 9-12 5 7-20 4 30 3",
    ": 5-6 8-40 6-9 52-4 6-9 62-8 72-3 7-9 81 5-6 90 5 9 901-2 5 8 11-3 6-7 20 3 5",
    ": 8-9 31-4 8-40 3 5 7-9 51-4 6-8 60-1 3-4 6 70-1 3 6-8 81-2 7-93 5-7",
    ": 5000-9 14-5 7-9 26 8 30-1 5-8 42-5 7 50-1 5 7-9 61-4 6-8 71 4-5 7 9-80 4-6",
    ": 92-4 6 8 101 3-9 12-3 5 7-21 4-6 30-1 3 5-6 40-1 3-4 7-9 53-8 60-1 3-6 8-9",
    ": 74-7 9 85 7-9 94-5 7 200-1 3 5-6 9-12 5-20 2 6 9 31 5-7 41-51 4 6 8-9 61 8-70",
    ": 6-8 81-3 5-6 8-9 91-2 4 6 8-301 6 10-1 3 9-20 4 7 9-31 3-7 9 43-4 6-8 51 5-6",
    ": 8-9 63-4 72 4 9 81-3 5-6 8-9 91-6 401 3 5 7 10-1 6-20 2 4-7 9-41 3-5 7-50 6 8",
    ": 61-2 70-4 6 9 81-2 4-6 9 91-3 5 8-9 501-10 2-4 7 20 2-4 6-9 31 5-6 8-9 42 5",
    ": 8-9 51 6-61 3-4 6 9-70 2 4-5 8-9 83-5 7-91 7 9 606-7 9-14 20-1 5 7-30 5-6",
    ": 41-2 4 6-7 9 52-8 60 3-5 7 9-70 2 4-6 8-9 82-4 6 8-9 92-3 5-7 700-8 10 2 6 9",
    ": 21-7 30 3 7-42 5 7-9 55 7 9-60 6 9 71-2 7-80 3-90 5-9 801 4 7 9-13 5-6 8-9 25",
    ": 7 9-34 8 40 3-6 51 3-60 6 8-72 4-9 81 5-8 91-3 5 7 9 901 3 6-7 9 11 5 7-22",
    ": 4-8 31 3-4 6-7 9-41 4-5 8 51 3-4 6 9 63 6 70-2 5 82-6 8-91 4-6",
    ": 6001-3 5-10 2-3 5 8-9 22 5-7 9 32-5 7-8 41 4 7 9-53 7 61-3 5-7 9 72-3 5-6 8",
    ": 81 4-8 92-3 8 100-1 4-6 9-12 5-6 8-9 21-9 31-3 7 41 3-4 9 51 5-8 61 6-9 71",
    ": 4-5 8-82 5 7-8 90 3 8-9 201-4 7 9-10 2-4 8 21-3 5-8 31 3-6 9-40 2-5 53-5 7-62",
    ": 5-6 8 70-2 6 8 80-9 91-2 4 301-2 7-11 3-6 8-9 21 5-7 9-30 2-6 8 41 3-51 4-8",
    ": 60-3 7-9 71-2 4 6 82 8 90-2 6-400 3-5 7-8 10 2-6 8-27 35 8-43 5 8-52 4 6 8-61",
    ": 3 6 8-72 4-81 4-5 9 91-2 4-8 501 5 11 5-6 8 21-30 3-6 8 41-8 51-7 9 61 3 6-7",
    ": 9-71 3-4 6-7 9-81 5 8 92-6 8-600 4-5 7-15 8-9 21-6 32 5-6 41 4-6 9-59 61-2 4",
    ": 8-75 8-80 9-95 7-9 701 3 5-6 8-10 2 5 8 20-5 7-30 2-7 41 4-54 7 9 61 4 8 70-2",
    ": 7-82 7-8 90-2 4-8 800 2-5 10-2 4-8 20-2 4 7-9 31 3-4 6-8 41-2 5-9 52-4 6-9",
    ": 61-3 5 7-70 2-7 80 3-94 900-9 11 3-21 3-6 8 32-5 7 9 43-6 8 50-2 6-7 9-60 2",
    ": 5-7 9 72-3 5-7 9-84 7 9 91-2 4-5",
    ": 8-7003 5 10 3-20 3 7-8 30-1 3-5 8 40 3 7 52-5 7 9-60 2-3 6 8-72 5-7 9-80 3-4",
    ": 6-8 91 3-8 100 2-8 10-2 5-6 8-9 23 7-38 41 8 50-3 5-6 61-2 5-8 70-1 5-8 80-3",
    ": 7 92-3 204-5 8-9 12 5 7-8 20 2-3 6 8 30-1 4 6-40 2 9-50 7-8 60 2-3 5-6 9 73-5",
    ": 9-80 3 7 9-92 4-5 8-300 2-3 5 8 12-3 5-6 8-9 21 4-5 8-30 6-8 40 2-3 5-6 9-51",
    ": 4-7 9 61 4-5 8 73 8-9 81-2 5-9 96-9 401-8 11-6 8-22 4 7 9 31 3 5-41 3 5 8-9",
    ": 55 8-61 4-72 4-6 9 83-5 9-92 4-5 7 500-2 5 7-8 10-1 4 7 9-21 3 5 30 3-4 7",
    ": 40-3 6-7 50 2-5 9 61-3 5 8-9 72 5-6 80 2 8 92-4 9 601 6 8-9 11 5 7 9-21 5-6 9",
    ": 31 3-4 6-7 9 42-5 7-9 51-2 5 8 61-2 4 6-7 70-2 4 6 8 81 7 9-92 4 9 703 5-6 8",
    ": 11-2 6 8 23-6 8-30 2 4-5 8 44 7 9 51-4 6-7 9-64 6 8-9 71-3 7-82 4-5 8-91",
    ": 4-801 3-7 9-12 5 7-9 22 4-7 9-32 6 8-40 3-8 51-2 4-7 60-1 3-5 7-9 75-7 81",
    ": 3-900 4 6 8-11 4-8 22-3 7-30 3-5 8 40-1 3 6-8 50 3 5-6 9 61-2 5 8-9 75-7 9-80",
    ": 2-8 91-2 5 9",
    ": 8001 3 5 10 2-5 8-9 22-7 9 32 4-5 7 9 43-7 9-50 2-4 6-7 9-60 4-6 8 73 5-6 8",
    ": 81-3 5-6 9-91 5-8 100-1 4 6 8 11 3 6-23 6 9-37 9-40 2-5 7-8 50 4-9 61 4-70 2",
    ": 4-5 80 2-4 8 90 4 6 201 3-10 2-3 5-6 9 23 9-31 3-4 7-9 41 4 6-8 50-2 4-5 9-60",
    ": 2 5-8 72-4 7-83 6-7 9 91-5 7-8 304-8 13 5-6 8-9 21 3 5 7-8 31 6 8-43 5 7-50 2",
    ": 4-6 8-9 61-2 6-8 71 3 6 8 82 4-90 5-7 401 3 8 10-7 9-22 5 30 4-6 9-42 4-5 7",
    ": 9-56 9-63 7 70 2-4 9-80 3-4 6-90 4-5 7-8 500-3 5-6 9 11 3 5 7-8 21-2 4 30 2-6",
    ": 8-41 3-9 51-4 8-9 62-3 5-7 9-71 4-9 81 4 6-91 3-600 4-6 9 11-3 5 7 9-20 7",
    ": 9-32 5 7 40 2-4 7-50 3-6 60-3 6 9-70 2-8 80-2 4-91 3-4 6 8-9 704 9-13 5-7 9",
    ": 25-6 8-33 5 9-43 6 8-52 4-6 8 60-2 4-5 8 71 6-85 90-3 5-6 8-800 4 8-11 3 9-20",
    ": 2-31 4-6 8 41-2 4-6 8-51 3 5-63 5-74 7-8 80-4 6-7 9 91-3 6 900-1 3-4 9-13 5-6",
    ": 8-21 4 6-8 31-4 8-9 42-4 7-8 50-2 5-8 60-3 5-7 9-80 2 6-90 2 4-6 8",
    ": 9001-2 5-6 8-9 11-4 8-9 21-2 4-7 9-30 2 5-41 3-5 7-52 5-7 9-63 6-9 71-2 5 7-9",
    ": 83-5 9-96 9 101-8 12-5 8-20 2-5 7 30-5 8 41-7 9 51 3 6-62 5-7 9 73 5-7 9 83",
    ": 5-8 90 2-4 9 203-6 8-9 12-4 6 21 3-4 6-34 7 41 3-4 7-9 52 6-7 9-63 5-6 9-73 5",
    ": 7 80-2 4-5 7-90 3-4 7-306 8-14 7-20 2-8 30-1 3-6 8-9 41 4-5 8-52 6 9 61 3-6",
    ": 9-70 2-3 7 9 81 3-4 7 9 96-8 400-1 5 8 10-1 3-9 21-2 5 7-30 2-3 5 7 41 4-5",
    ": 7-9 51 3 8-70 2 4 6 9 81-3 92-3 5-504 6-7 10-1 3-8 24 6-7 9-31 3-40 2 5 7-57",
    ": 9-60 3 6-7 9 71 3-4 7-80 3-4 7 9-90 3 6 8-600 6-7 12 5-6 9 22-4 6-30 2 4-5",
    ": 8-40 2-9 52 7-61 3-4 7 9-70 3 5-6 8-80 2 4-5 7-90 2-4 8-9 703 6 9-10 4-6 8 21",
    ": 6 8-9 33-4 9-41 5-7 9 52 5-6 8-9 62-6 9-70 2-6 8-9 81-3 5 7 90 2-3 5-8 805-10",
    ": 5-7 9-22 4-5 7-8 30 3-6 42 4 6-7 51 4-5 9-62 4-8 70-1 3-5 8 80 2-4 6-90 2 4 8",
    ": 900 2-9 11 3-6 8 21 3 5 30-2 5-9 41-2 7 9 53-4 7-60 2 8-70 2-3 5-6 80-4 8",
    ": 91-2 7-8",
    ": 10002 4 7-10 3-7 9-21 3-4 6-9 32-4 7 9-43 5-7 9-56 8-60 3-5 71-6 9-82 4 7 90",
    ": 2 7 9-102 5 8-12 5-6 20-5 7-30 2-4 7-8 40-1 5-7 54 6 8 60-2 5-6 71 4-6 80 2",
    ": 4-8 90-3 7 9-202 4 6-10 3-4 7 22-33 5-8 40-2 4 6 8-52 4-8 60-1 6 9 71 3-6",
    ": 8-80 4-7 90 2 7-8 300-3 5 8-10 2-3 7-20 3-8 31 3 5 7 43 5-7 9-50 2-3 5-61 3",
    ": 5-9 75-6 8 81-3 5-8 90-2 5-400 2 4-12 4-5 9-21 3-4 6 8-35 7-9 42-6 8 53-5 7",
    ": 60 3-5 9-73 7-84 9 92-3 5 8-9 501-2 6-9 13 5-8 21-3 5-7 9 36-9 41 4 6-7 9-52",
    ": 7-67 9-70 2-3 5 7-9 81 8-90 2-8 601-2 4-5 7-19 21-34 6-7 42 6 9 53 9-60 2-5 9",
    ": 75 80 3-4 6 8 91 3 6-8 701-5 7 9-11 4-5 7-21 3-4 6-7 9-32 40 3 5-6 9 51 5 8",
    ": 60-2 4-7 71 804 15 37-9 46-9 51 3 7-9 61 4 6-72 4-5 7-9 82 4 6-9 92-3 5-6 9",
    ": 902-4 11-3 7 9-21 6-7 9-30 2 4-6 9 47 56 64 74 83 91-2 4-8",
    ": 1000-2 4-6 10 2-7 9-21 3 5-7 33-4 7 42-7 9 55-6 61 3-6 8-9 71-2 4 6-9 82-5",
    ": 8-9 92-5 7-126 8-31 4-5 40-1 3 5 50 2-4 61 3-7 70-3 80 2-5 7 9 91 3-4 6-7 9",
    ": 203-4 6-11 3-7 24-9 33-6 8 40-3 6-52 4 7-8 60-3 6 8 73-4 6-9 82-3 5-6 8-90",
    ": 2-4 7 301 5-11 4 20-9 32-3 5-6 40-4 6-53 5 7-8 62-3 6-7 9-70 3-9 82-7 91-4",
    ": 7-9 401-3 6 8-11 3-5 7-21 3-32 4 48-52 5 7-8 61-3 5-6 8-70 2 6-8 82-5 7-8 92",
    ": 5-6 501-3 5-9 12-4 6-7 21 3 5-7 31-42 4-5 7-9 51-4 6-7 9-61 5-6 70 5 7 81-90",
    ": 2-4 6-7 600-2 4-6 8-10 3 6 9 22-4 6 8-9 32-4 8-9 42 4 7-9 51 5-6 8-61 4 70 2",
    ": 9-81 3-8 710 5-9 22-7 9 32-8 40 3 5-6 8 51 4-6 65 9-72 4 6-80 2-3 92 7 9",
    ": 801-3 5-7 9-17 9-29 31-3 5 40-1 3 6-54 7-60 3-4 6 70 7-85 7-91 3 5-6 8 902-8",
    ": 11-6 9-20 2-4 8-30 5-8 41 3-4 9-51 9 66 9-70 3-5 9 81 3 6-93 6-7",
    ": 2000-1 3 6-10 2 5-6 8-21 4-6 8-9 35-9 45 8 54-5 7-63 6-71 5-7 9-80 2-3 5-90",
    ": 6-105 7 10-3 5 7-8 20-2 4-8 31-2 6-7 41-2 4 6-54 7-9 61-2 4-72 4 6-8 83-91",
    ": 3-4 6-200 2 5 8-11 4 6-8 20-2 4-31 7-40 2 4-5 7-55 7-8 60 2-3 5 8-70 2-5 8-80",
    ": 5-7 92 4 7-303 5 7-8 11 3 6-7 9 21 4-5 8-30 2 6-8 41-3 6 9-51 7 9-60 2-3 6-72",
    ": 5-7 81-2 4 6-7 90-2 5 7-8 400-3 5 7 9-11 3-4 7-21 3-4 8-34 6-7 9-43 6-7 50 2",
    ": 5 8-64 6 8 70 4-9 81-4 9 91-3 5-9 501 4 6-7 9-11 3-5 8 21-31 3-8 40 3-4 6-9",
    ": 52-3 5 8-9 61-2 4-5 9 73 5-80 3-6 8-90 2-3 5-6 8 601-2 7 9-16 9-20 2 6-7 30",
    ": 2-5 7 40 2-3 7-51 5 60-3 5-6 8-75 80-1 4 7-92 5-6 8-702 4-9 14-5 8 20-6 31 3",
    ": 6 44-6 8 50 4-5 7-8 60 3 5-9 71-84 7-91 3-5 8-801 3-4 8-16 8 20-1 6-32 9-40",
    ": 3-5 8 50-3 5-9 62 7-70 5-8 80-5 7-9 92-3 7-903 5-8 12-4 6-7 20-2 6-9 31 4-7",
    ": 9-40 2 4 6-8 50-3 8 62-3 6-7 9-70 3-8 82-4 9 92 4-5 7",
    ": 9-3002 6-9 11 3-4 7 9-20 2 4 6 8-9 32-3 5-6 40 2-3 5-7 9 52-5 7 61-4 8 70-1",
    ": 9-82 7 90 5-6 8-9 102 4 8-10 6-8 22-3 7 9-31 3 5 8-9 41 3 6-7 50-2 4 9 61-3 5",
    ": 9-70 2-6 8-80 4 7 90 2-4 7-8 201-2 5-6 12-3 5-8 20-1 3-8 36 8-40 3 5-6 8-53",
    ": 5-7 9 61-3 8 71-5 7-9 83-90 3 5-6 301 4-9 12-3 5 7 9-20 2-3 5-7 32-6 8 40 2-3",
    ": 8-55 61-2 4-9 71-81 5-6 8-90 7-8 407-9 11-2 4-7 9 21-4 6-33 7-9 41 5-50 4-5",
    ": 7-61 3 5-6 81-2 7-93 7-9 502 6-9 11-4 6 8-9 22 4-7 30 2-3 7-8 40-7 51-4 7-8",
    ": 60-2 4 6 8-9 72 6 82-5 7-8 90 2-605 7-12 5 7-8 20 2-3 6-31 5-9 42 4 6-8 50 3",
    ": 5-6 8-61 4-9 71-2 4-6 8 81-6 8 90-1 3-5 8 701 5-7 10-2 5 8-23 5-6 9-31 3-7",
    ": 9-43 7-50 6-60 2 8-74 8-9 82 5-93 5-8 800-1 3-6 8 11-3 5 7-21 3-4 7-8 30-3",
    ": 7-8 41-51 3-5 7-9 62-3 6 73 6-8 80 2-3 5-93 8-900 2-3 6 8 11-4 8 22-4 8-9 32",
    ": 6-8 40-4 6 59-60 2-3 5-6 72-4 6 8-87 9 97-8",
    ": 4002-4 6 11 3-4 7 9 24-9 31-4 6-8 40-3 50 6-7 9-62 4 6-8 70 4-5 80-2 6 8 90 2",
    ": 5-6 8 100 2-4 8-11 3 8-20 4 7 30 2 5-7 9-40 2 8-50 2-5 8 60-1 3-4 6-8 71-4",
    ": 6-7 80-6 9-90 6-8 200-2 4-5 7-10 2-21 4-8 32 5 7 9-42 7 9-51 3-6 8-61 3 6 8-9",
    ": 71-4 6-7 82 4-7 9-91 4-8 300-5 7 14-7 9 21 3 5-6 9-32 6-42 4 6-7 9 53 6 8-63",
    ": 5 8-9 76-83 5 7-90 2 4-6 402-3 5-7 10-1 3-9 21-4 6 9 31-2 5-6 9 41-2 7-8 50-4",
    ": 6 63-8 70-2 4 7-8 80-6 9-90 3-4 6-501 3 5-12 6 9-21 3-5 9-31 3-5 9-40 2-4",
    ": 8-56 64 74 80 6-90 3-6 8-9 601 4-6 8-9 13 6 9-20 2-3 7 9 32-3 5 40 2-5 7-9 51",
    ": 3 8-60 4-7 77-82 5-7 91 3-5 7-8 702 4 6-7 10 2-4 6-8 21-3 6-8 30-1 5 7 9-43",
    ": 7-8 52 4-6 9-63 5-7 70 2-3 5-7 9-81 4-5 7-98 800 4-5 9-15 7 22 7-9 32-4 7-41",
    ": 5 8-9 51-2 4 6-60 2 4-5 7-9 71-4 6 8-80 9-91 7-8 900 2-4 6-7 9 12-3 5-6 21-4",
    ": 6 8 35-7 42-6 8-53 5-7 9 61-3 5-8 70-2 7-8 81 6",
    ": 8-5006 8-16 8 20-5 9-35 7 9 41 3-6 8-52 5-6 8-60 2-6 8-9 71-2 4 6-7 81-4 6 8",
    ": 91-2 5 7-8 100-3 5-6 8-15 7-9 21-2 4 9 31 5-6 8-40 6 50-1 3-4 6-8 61 3-4 6-7",
    ": 70 2-7 9-80 2-3 5 7-8 91 3 7-9 202-6 9 13-4 6 9 21-3 7-8 30 2-3 5-44 6-7 9-50",
    ": 4-6 9-60 2-3 6-7 71-3 5 7-9 83-4 6 8-9 91-2 4-6 300-3 5-9 11 3 6-7 9 23-5 7",
    ": 31-4 6-7 9 42-3 5 7-50 2-6 8-60 3 8-76 8-84 7 9-91 3 5-402 4-9 12-3 5-20 3-4",
    ": 7-9 31 3-4 7-9 41-2 4-5 50 3-6 8-61 5-7 71 6-7 84 7-93 6 500 3-5 7 9-12 5-7",
    ": 9-21 4 30-5 7-9 42-4 52 6-8 62 5 71 5 7 82-3 7-8 90-3 5-6 602 5 7-9 12-4 6 9",
    ": 21 3-7 9 31 5-8 40-2 4 6 53-4 6 62-4 6-7 9 73-4 9-84 6-91 4 6-7 9 701-6 8",
    ": 10-1 3-4 8 20-1 4 6 9-31 3 5-6 8 41-5 8-9 51 5 60-2 4-70 3 8-9 84 6-7 92-5",
    ": 7-8 800-8 11-6 21-9 32-3 8-9 41-5 8-9 51-6 8-62 4 6 9-71 3 5-6 8 81 3-4 6-7",
    ": 92-5 7-8 904-8 11-3 6 9 21 3-4 7-8 30 2-41 6-8 53 5-64 6 8-70 2-3 8-81 4-5",
    ": 7-8 90-2",
    ": 4-6000 2-4 7-12 4-5 7-8 21 3-5 8-9 32 4-5 8-40 3-5 8-51 3 6-60 2-4 6-70 4 7 9",
    ": 82 5-7 9 91 7-101 3 7 9 11-7 20 3-6 9 31 3-4 6 8 41 3 5-6 8 53 5-63 8 70 5-7",
    ": 9-81 4 9-91 5-6 201 3-6 9 11 5-21 4 6 8-35 7-8 43-4 6 8 51 3-4 6 9-64 6 9-70",
    ": 4-7 9 83-5 8-9 92-4 6-7 301-2 6-8 12 4 6-20 3-5 31-2 4 40 3 5 51-2 4-6 8 60 3",
    ": 8 74-6 8-81 4-5 8-90 4-8 400-3 5-14 7-20 2 5-6 9-34 6-7 9-42 5 8 50 3-4 6-8",
    ": 61 3 5-7 9-70 2 5-7 9-84 7 9-90 2 5 7 502-5 7-9 11-3 5-6 8-20 4 6 9-37 41-2",
    ": 6-8 50-2 4-6 8-64 6 70 2-7 9-87 94-5 600 3 5 9 14-5 7 9 21-2 6 8 31-5 7-41",
    ": 3-7 51 4 6 8-60 2-5 7-75 7 80 2 4-5 8 90-4 6 700-2 4-5 10-4 6 8-21 3-7 9 31-3",
    ": 5 7 40-1 5-6 8 52 4 8-61 4-5 7 9 71 5-90 2-9 801 3-4 6 8-10 3 7 9-20 3 5-30",
    ": 2-3 6 8-9 41-4 6 8-50 7 61 5 8 72-3 5 7-9 81 3 7-8 90-6 8 900-5 10-1 9 22-4",
    ": 9-32 7-43 5 8 50 3 7-8 60 2-3 6-7 70-1 3-8 80-7 90 3 5-7",
    ": 7000 2 4 6-7 9 11 3-4 7 9 21-4 7-8 30 3-7 40-1 4-5 7-8 52-3 5 8 61-5 9 71-2",
    ": 4-6 8-9 81-3 5 7 90 4-5 8-108 10-3 6-7 9 22 4-5 7-31 3-6 42 6-7 9-56 60-3 5-8",
    ": 71-2 4 6-82 4-5 8-9 93-8 204-5 7-14 6 8-9 21-4 6-8 31-5 7-41 3 5 7 50 3 7 60",
    ": 5-6 75-80 3-7 90-1 3 7-8 301 5-8 11-2 5-7 9-20 2-3 7 9 31 3 5-6 8 40-1 4 9",
    ": 51-2 5-7 60-1 4-5 7-9 73-4 8 82-3 7-94 6-410 3-4 6 8-21 3 5 7-9 31-8 41-3 5-6",
    ": 9 51-3 5-7 62 4-5 8-71 3-5 7-80 3-8 90 4-503 12-3 5-23 6-8 31 3-4 7-8 40 2",
    ": 7-53 60-1 3 7-8 70 4-5 7 9-83 6 91-2 4 6 8 600-1 3-15 7-20 3-5 8-9 32-6 9-43",
    ": 5-7 9 52-3 5-7 60 5-6 8-70 5-88 91-7 700-4 7-15 7 20-5 8 30 2-6 9 42 4-7 51 3",
    ": 6 8-9 65 70 2-3 7 80-4 7 90 2-4 8 800-1 3 6 9 11-2 4 9 23 5 7-8 30-5 7 9 45-8",
    ": 51 4 8-62 4-6 8-71 3-8 80 2-8 93 7 900-1 9-10 2 5 8-9 23-8 30 2-6 9 42 4-5 7",
    ": 9-50 3-5 7-8 61 4-7 9-72 4 6 80-1 3-8 93 5-8",
    ": 8000-5 7-9 11-3 7 9-23 5 7-9 33 5-42 4 6-7 9 51-2 4-9 61 5 7-8 71 3 7-8 80",
    ": 2-3 5-6 8 91-6 8 100-2 4-6 9-11 3-5 8-9 21-2 5 8-9 33 5-6 41 3-5 50-9 61 3-9",
    ": 72-5 7 80 2-3 7-98 201-2 4 6 10 3-5 8-9 21-5 9 33 7-46 8-9 52-3 5-8 63-8 72 5",
    ": 7-81 3-90 2-4 9 304-7 9-11 20-1 3-7 9 31 3 6 9 41 6-7 52-3 7-60 5-6 8 70 3",
    ": 7-8 82-3 5-6 8 90-1 4 7 401-4 6 8-12 4 7 9-22 7 30 4-5 8 43-5 51-3 5-6 8-64 6",
    ": 8 71-2 4 7-8 80-2 4-5 7-8 91 4 9-501 4-7 9-10 5-6 8-9 23-5 7-8 31-6 8-41 3-4",
    ": 6-7 9-53 7 9-64 6-7 9-71 4 6-9 81 3-8 91 4-9 601-6 8-12 5-22 8 30 7-44 6-7 9",
    ": 51 3-4 6-7 9-68 76 8-84 6-95 7-702 4 6-7 9 14-20 5 7-8 31-2 4-40 3-4 6-51 3",
    ": 9-60 2-3 6 9-71 3 6 8 81 5-6 9-94 8-800 4-8 11 3-4 6-7 20-6 8-32 6 9-42 4",
    ": 9-51 5-6 9-60 2 4-5 8 70 2-4 6 81-4 91-5 8 900-6 8-9 12-7 9 21-6 8 31-4 7-40",
    ": 2-3 5-9 52 8-9 62-7 9-72 4-6 8 80 3 6-7 9-92",
    ": 4-9003 5-6 8-18 20-2 4-5 7-31 3 5-8 42-4 9 51 4-6 8 60-1 5 73 6-7 9-86 9-90",
    ": 2-3 6-7 9 101 3-4 6 8 10-2 4-8 20-1 4 7 35 7-9 43 8 51 4-5 7-9 62 4-5 7-8",
    ": 70-2 4-7 9-80 5-8 91-4 8 201-3 8-12 5 7 22 4-6 9 32-6 8 40-4 6 54-5 8-60 2-4",
    ": 6-7 9 71 3-4 6-8 80-1 4-8 92-6 9-301 3-4 6 9 11-25 7-9 36-8 40-2 5-51 3-4 6",
    ": 8-61 4-7 9 73-4 7 80 2 7 9-90 4 8-9 403-6 8-9 11 4 6-9 22-3 7-9 32 5-6 40-2 4",
    ": 7 51 3-5 7-60 2-3 5 70-1 5 7-8 83-5 8 90-4 8 500-1 3-5 7-10 2 4 6 9-20 3 5",
    ": 8-9 31-3 5-7 40 2-4 6 8 55-9 61-2 6 8-9 73-5 8 80-2 4-90 5-7 9 602 4 7-8 10-1",
    ": 4-5 25 7 30 2-8 40-1 7 50 2-3 5-7 9-61 3-6 8-9 72-3 5 7 9-83 6-8 90 2-4 6-7 9",
    ": 710 7 9-24 31-3 9-41 4-9 51-8 62-3 5 9 71 3 6 9-80 3 5 7 90 5-7 800 3 5-9",
    ": 12-4 21-2 4-6 30-6 8-42 4 50 2 5 7-62 4 7-70 2 6-9 81-3 5 8-9 92-6 8 900 2-3",
    ": 5 8-9 11-2 5-20 3-4 6 30-5 7-8 41-4 8-50 5-7 9-62 5-6 8-70 2-7 9-85 7-9 91-7",
    ": 9-20001 3 9-10 4 7-9 21 3 5-6 9-32 4 6 9 41-5 7-8 50-5 8 60-2 5-6 8-70 3 5",
    ": 8-89 97 101-2 4 7-8 12 5-9 21-2 5 7-30 4 6-8 40-3 5 7-8 50-2 4 7-8 64 6-71",
    ": 4-5 8-81 3-4 6-7 9-92 4-5 7 9-200 2-9 14-6 20-4 6-9 34 6 8 40 3-4 6-51 3-8",
    ": 63-5 7-74 6-8 80-5 8-9 91 6-301 3-9 11-7 24-6 8-30 2 4 6-8 42-5 7 9-50 4-7 9",
    ": 61-3 6-8 70 2 6-9 81-5 7-9 91-4 6-7 402 4-5 10-3 9-20 3-4 6 30-6 8 40-2",
    ": 63573 93 601 3 9 22 4 6 8 35 8 42 4-5 7 50 4 7 9 62-3 6 73 6 80 3 5 7 9 91 5",
    ": 700 3 6 11 7 9 22 4 37 41 3 6 8 51 3 5 7 68-9 76 84 6 92 803 5 7 15-6 22 5 33",
    ": 9 41 3 6-7 51 60 2 4 6 9-70 2 4 6 8 80 2 4 7 9 903 13 7 24-5 7 9 31 3 5 7-8",
    ": 41-2 8 53 5 9 62 4 70-1 8 80 4 6 8 90 4 6 8-9",
    ": 4001 6 10 2-3 20-1 36 8 41 3 5 7 51 60 3 78 80 3 8-9 93 6-7 100 2 8 10 2 4 9",
    ": 21 4 8 30 5 9 43 5 9-50 4 60 2 4 6-7 9 74 6 81 6 91 6 8 200 5 7 9 20 2 6-7 9",
    ": 42 6 8 50 2 4 7 9 63 5 7 9 71 4 80-1 4 6-7 9 93-4 6 9 302 5 7 13 5-6 8 20 2 4",
    ": 32 8 40-1 4 6 8 50 2 5 9 61 72 8 80 5 7 487 9 92 6 507 9 11 7 9-21 3 5 30 3-4",
    ": 6 9 41 8 55 7 61 9-70 6 82 8 90 2 7 9 602 4 6 8 10-1 8 27-8 30 3 5 9 45 7 9",
    ": 53 5 60 2 8 70 80 4 6-7 9 95 708-9 11-2 4 6 23 5 8 32 40 4 6 54 60-1 5 9 72 4",
    ": 6 9 86 8 90 4 6-7 814 20 2 4 37 41 3-4 6 8 51 62 5-6 73 5 80 2 4 8 97 903 5",
    ": 11 3 5 7 9 23 7 31 3 5 9 41 3 5 50 4 9 61 7 9 72 4-5 9 81 3 6 90 9",
    ": 5001 3 10 3 8 25 8 38 42 7 9 55 8 60 5 8 73 5 8 82 7 9 91 100 4-5 10 2 7 9-21",
    ": 3 5-6 9 31 5 41 3 5 51 6 9 61 3 5 9 72 82 4 93 203 5 29 31 7 46 50 8 64 6 76",
    ": 82 6 8 99 302 9 12-3 5 7 9 22 5-6 31 3 5-6 40-1 4 8 50 2 4 61 5 80 9 93 5 400",
    ": 2 4 11 5 7 24 7 9 31 3 9 42 5 7 9 53 5 66 8-9 72 4 7 84 6 90 9 501 3 9 11 3",
    ": 5-6 8 20 2 4 9 33 6 8 40 5 7 62 5 71-2 4 6 85 90 6 603 9 20-1 3 5 9 31 3 5 7",
    ": 40 5 9 51 6 8 60 2 4 6 73 5 7 9 87 90 2 5 7 9 701 3 5 9 12 21 6 31 9 42 5 8",
    ": 54 6 9 61 4 72 4 6-7 87 90 2-3 9 801 3 5 12 7 21 3 9 33 7 9 41 3 5 55 7 9 61",
    ": 3 5 8 70 91 902 6 8 12 4 8 20 4 39 41-2 6 8-9 57 63 5 9 71 6 80 2 8 91 9",
    ": 6001 5 7 9 17 9 22 4 6 8 39 49 56 63 5 9 73 6 8 85 90 2 4 7 9 101 3 5 7-8 12",
    ": 4-5 7 20 2 4 7 9 33 6 8-9 47-8 55 7 74 8 80-1 3 5 7 96 8 201 3 9 11 4 20 3 5",
    ": 7 9 31-2 9 41-2 5-6 52 4 65 76 9 81 3 6 8 92 4 6 8 314 9 22 8 30 2 8 40 2-3 5",
    ": 7 52 4 6 8 63 7-8 73 7 401 3 6 8 10-1 6 9 33 7 40 9 54 6 63 6 8 72 4 7 81 6",
    ": 96 9 501 5 7 11 3 6 8 20 5 7-8 30 2 9 41 3 5 8 50 2 6 61 3 5-7 77 83 6-7 91 9",
    ": 601 8 12 25 31 4 7 9 41 3 8 52 60 7 74 6-7 9 81 92 7 705 10 4 21 3 35 8 40 2",
    ": 7 59-60 3 7 75 82 6 92 4 8 800 2 6 8 10 3 9 24 6 8 31-2 4 7 9 44 51 3 5 7 9",
    ": 61 5 9 71 5-7 86 8 90 4-5 7 9 904 7 11 3 5 7 9 24 8 30 6 42-3 5 8 50 5 7-8 61",
    ": 6 8 70 3 84 6 8 96 8",
    ": 7001-2 4 21 3 30 2 4 41 5 7 51 61 3 8 73 82-3 7 9 92 6 100 2 4 6 17 9 28 30",
    ": 42-3 5-6 9 51 3 5 7 68 73 5 9 81 3 6 92-3 5 7 9 201 3 6 8 11-2 6 20 2-3 5 8",
    ": 30 3 6 8 41 6 50-1 64 8 75 9 86 8 90 8-9 301 3 9 11-2 4 6-7 9 21 7 33 5 40 3",
    ": 7 9 53 8 61 3 6 8 70 80 2 8 90 7 9 401-2 5 11 3 5 7-8 20 2-3 5 32 4 6 8-9 42",
    ": 5 7 9 53 5 7 9 61 6 8-9 71 4-5 7 9-80 3 5 7-8 97 501 3 7 9 11 5 7 20 4-5 8-9",
    ": 31 3-4 7 46 54 7 60-1 3-4 6 9 71 3 8 80 2 4-5 7 9 91 3 5 7 601 3-4 6 8 10 3",
    ": 24 6 8 30 50 4 7 63 5 7 9 71-2 4 6 83 701 3 12 8 24 7 9 31 3-5 7-8 42 6 52-3",
    ": 7 9-61 3-4 6 8 70 8 83 5 8 98 800 2 19-20 4 32 42 4 6 8-9 51 3 5 8 63 5 72-3",
    ": 9 84 7 9 92 4-5 7-8 900 2 5 11-2 7 25 30 4 7 41 4 6 8 53 9 62-3 6 70 4 7 82 5",
    ": 7 93 5 8",
    ": 8001 6-7 19 21 6 32 4 6 8 44 9 51-2 4 8 60 4-5 7 70 4 6 81 3 90 2 104 7 11 3",
    ": 6 20 3 5 32 4 7 41 3 7 9 51 61 5 71 4 81 7-8 90 4 7 9 202 4 21 7 31 3 5 7 9",
    ": 45 9 51 3 7 67 9 72 4 6 80 7 9 91 3 5 7-8 300 4 10 3 20 3 32 4-5 7 9 41 6 8",
    ": 50 2 5 8 61-2 6 70 2 4 88 90 4 6 8 400 3 5 7 13-4 8 20-1 3 6 30 3 43 7 52 6",
    ": 9-60 8 70 2 4 7 9-80 6 8 90 2 507 9 17 9 21 3 5-6 30 2 8 40 2-3 5 51 61 4 7",
    ": 74 7 9 83 5 7 9 91 3 5 7 601-2 4-5 9 12 5 9 21 3 6 34-5 40-1 3 6 8-9 51 3 5 7",
    ": 9 68 70-1 9 81 3 7 9 95 7 9 703 5 9-10 3 6 9-20 2 6 8 34 6-7 9 41 4 51 3-4 61",
    ": 78 83 5-6 8 90 2 4 8 800 4 11 3 5 7-8 20 5 7 9 31 40 3 7 9 70 2 4 88 93 908",
    ": 11 7 21 4-5 7 9 31 3 6 40 4 7 9-50 2 4 6 9 63 8 70 9 85 7 90 5 8",
    ": 9003 5 9 11 5 7 9 21 3 5 7 9 31 7 9 41 4-5 50 6 66 8 70-1 3 5-6 8 83 5 8 90",
    ": 4-5 8 102 4 6 8 12 9 21 3 5 30 2-3 5 7-8 41 3 5 52 5 7 61 7 9 72 4-5 83 90 2",
    ": 6 8 200 2 4 9 12 5 25 35 8 42 7-50 60 2 4-6 8 70 5 81 6 8-9 93 6-7 301 7 9 16",
    ": 22-3 5 7 30 2 4 7 9 41 3 50 2-3 6 8 60 2 5 71 4 80 2 91-2 5 402 4 10 2 4 6 22",
    ": 6 9 38 40 2 5 57-8 62 4-5 7 75 8 86 9 91 4 9-500 2 5 7 9 11 7 9 21 3 5 9 31 3",
    ": 5 7 43 7 9 52 4 6 8 68 73 5 8 80 5 7 9 93 5 603 5 7 9-10 5 9 22 4 9-30 2 4 6",
    ": 8 40 2 6 8 50 2 7 9 61 3 6 70 5 7 82 6 91 7 701 3 7 10 4 6 20 2 6-7 31 3 6 42",
    ": 50 5 7 9 62 5 7 71 4 6 8 83 5 8 93 5 7 809 17 9 21 4 6 8 31 3 42 8 50 2 5-6",
    ": 60 2 7 71 4 7 9 81 6 92 901-2 4 6 8 12 4 9 21 3 5 7-8 34 6 8 45 7 52 6 9 61 3",
    ": 6 70 2 4 80-1 4 6 90 2",
    ": 70000 2 10 2 23 6-7 31 4 6 8 40 2 5 50 7 65 79 86 94 100 6 9 15 7 23-4 6 8 30",
    ": 4 6 41 7 9 51 5 7 9 72 83 6 90 2 5 7 9 201 3 8 10 2 4 20 3-4 6 30 5 7-8 41 3",
    ": 5 7 52 9 68 72 4-5 81-2 4 92 300 9 11 3 9 21 9 31 5 42 4 6 8 52 5 7 9 61 3 6",
    ": 8 70 3 5 7 9 84 6 8 90-1 4 8 407 9 11 3 6 8 22 6 8 40 2 5 51 3-4 8 60 4 6 8",
    ": 70 2 4 7 86 8 90 2 4 6 8 504 6 9 11 3 6 20 4 8 30 2 4 6-7 9-40 2 4 6 8 50 4 6",
    ": 8 65 7 9 72 4 6 8 80 2 4 6 90 2 4-5 600-1 7 11 3 20 6 9 34 6 9 50 3-4 7 61-2",
    ": 6 8 70 5-6 9 81 6 8 92 701 5 7 9 17-8 22 4 8 36 8 40 3 6 9 53 5 7 9 72 6 8 80",
    ": 92 808 12 4 6 8 20-1 6 41 3 5 7 9 57-8 71 3 5 8 80 4 90 2 5 7 9-900 3 7 10 3",
    ": 5 9 25 32 45 51 3 5 7 62 5 7-8 70 7-8 80 3-6 9 95 7 9",
    ": 1001 6 11 3 5 7 21 3 7 9 43 5 7 54 8-9 66 70 82 5 7 97 102 5 7 19 22 5 8 30 6",
    ": 8 41 3 7 9 52 6 8 61-2 5 7 9-70 4-5 7 9 81 3 5 93 6-7 201 3 5 12 6 21 3 5 8",
    ": 32 4 41 3 5 8 52 62 4 77-8 80 2 4 6 8 90 2 4 6-7 9 301 3 5 9 12-3 20 5 8 34",
    ": 42 8 60 2 6 8-9 72-3 83 91 3 5 7 406-7 9 11 3 5 7 9 21 7 30 4-7 50-1 3 7 9 61",
    ": 4 72 4 8 88 93 6 8-9 501-2 5 9 11 6 8 22 31 5 7 9 41 3-4 6 9 51 3-4 69-70 2-3",
    ": 5 7 80 2 8 600 2 6 8-9 14 6 20 2 4 6 8 31 3 6 42 5 51 3 7 65-6 8 70 2 6 84",
    ": 6-7 9 91 3-4 700 3 5 7-8 20 2-3 5 7 34 7 40 4 6 56 8 61 3 5-6 8 72-3 5 7 9 93",
    ": 7 9-800 2 5-6 14-20 5 9-30 6-8 40-8 54 7-62 4 6-8 71 6-7 83 5 7 9 93-4 6-7 9",
    ": 901 4 14 6 8 20 2 4 6 8 30 2-3 5 7 9 41 3 52 5 7 9 61 5 8 70 3 7 83 5 90 2 4",
    ": 6",
    ": 2002 4 8 17 9-20 30 2 4 8 40 2 4 6 50 7 9 62-3 8 75 7 80 4 8 94 6 102 4 6 8",
    ": 10 2 4 6 22 5 9 31 6 8 40 3 51 3 5 9 61 3 5 7 71 3 6-7 9 85 93-4 6 8 200 2 4",
    ": 6-7 13 5 23 8 32 40 4 6 8 50 3 5 7 9 62-3 6-7 9-70 2 5 7 9 81-2 4 8 90 2 4",
    ": 309 12 4 6 9 21 3-4 34 41 7-8 51 3 5 64 78 80 2 90-1 3-4 6 8-9 401 3-4 7 9 11",
    ": 5 7 20 2 5 9 41 3 9 51 3 9 61 3 7 73 83 5 93 5-6 8 500 2 4 13 5 9 21 9 31 4",
    ": 41 3 5 7 9 51 6 9 64 6 70 2 4 9 83 90 2 7 605 13-4 6 20 2 4 6 8 33 5 7 9 42 4",
    ": 51 3 7 9 61 7 73 6 8 80 2 4 6 8 90 2 4 700 7 9 11-2 20 2 4 6 8 31 6 40 51 6 8",
    ": 60 8 71-2 6 8 81 6 8 90 5 9 801 6 10 3 5 7 25 33 9 42 6 50 63 9 71 4 81 3 5 8",
    ": 91 3 6 902 4 6 9 11 3-4 6 20 9-30 2 5 7 41 51 67 9-71 3 5 7 83 8 96 8",
    ": 3000 4 6 16 8-9 25 8 30-1 3 42 4-5 7-8 50 2 4 7 67 75 7 9-80 2 8 95 7 101-2 4",
    ": 18 22 5 7 32-3 5-6 41 7-8 52 6 9 61 3-4 9 71 3 7 9-80 2 7 95 7 201 3-4 6 8-9",
    ": 11 3 5 22 6 9 33 5-6 40 2 4 6 8 53 8 60 2 77 9 81 5-6 92 5 8 306 13-4 6 8 20",
    ": 2 4 6 8 30 40 55 7 63 8 74-5 9 82 6 97 9 401 3 13 5-6 22 8 32 4 6 8 47 9 59",
    ": 61 4 6 71 4 6 8 80 2-3 5 7 9 92 8 515 7 21 9 31 3 5 42 9 53 5 62 4 8 70-1 3 7",
    ": 9 81 3 91 4 603 6 8 14 8 20 5 7 32 7 40 4-5 53 5 7 61 3 9-70 3 5 8-9 81 4 9",
    ": 98 709-10 6 9 21 34 9-40 2-3 5 7 9 51-2 4 6 70 2 6 8 80 2 5 8 95 8 800 4 6 8",
    ": 10 4-5 8 24 6 8 30 2 4 7 40 51 3 60-1 3 7 9 71 3 5 84 8 96 8 906 8 12 5 7 9",
    ": 21 3 5 30 4 6 8-9 42 4 6 8 50 2 6 8 61 8 71 4 6 82 4 6 8-9 92 8",
    ": 4000 2 4 6 10 2 6 21 5 7 9 31 4 6 42-3 6 8-9 51 6 9 61 4 6 8 70 3 5 7-8 91",
    ": 100 8 10 2 9 21 3 7-8 32 4 6-7 41 3 5 8-9 56 60-1 3 8 71-2 4 80 2 205 10 8 23",
    ": 5 7 9-30 6 8 40 2 4 7 53 7 9 61 3 5 7 9 72 7 81 3 7 91 3 5 7 9 302-3 8 10 2 7",
    ": 20 5 7 31-2 4 9 44 6 52 5 9 61 5 7 71 3 5 7 9 81 4 8 90 2 4 8 409 14 7 20 2 7",
    ": 9 34 7 9 45 54 63 6 9 78 80 2 4 91 9 506 8 14 6-7 24 6 40 2 8 50 2 4-5 8 61 5",
    ": 71 81 7 9 91 3 6 604 8 14 7 21 30 3 5 8-9 43 6 54 8-9 64 6-7 71 8 85 7 9 91 7",
    ": 700 5 7 9 11 3 27 30 4 48 51 5 7 60 5-6 8 70 7 85 99-800 11 4 7 25-6 30 6 8",
    ": 45 8 51 3 5 9-60 4 6 70 3 5-6 9 81 5 7 9 91 4-5 7 9 901-2 9 13 5 22-3 31 45",
    ": 53 7 61 5 7 76 82 4 8 90 4 7 9",
    ": 5001-2 4 11 7 9 21 8-9 33 5 8 40 2 6 8 50 3 5 8 60 2 4-5 8 70-1 6 8 81 6 90 9",
    ": 102 4 7-8 11 24 30 3-4 8-9 41 6-7 51 6 62 4 6 72-3 5 8 80 7-8 91 3 7 201 3",
    ": 5-6 14 6 22-3 6 33 42 4 8 50 3 6 63 8 75 7 9 81 3 5 7 9 93 8 302 4 7 11 3 5",
    ": 20 4 9 33 7 41 3 9 51 5 61 3 78 89 91-2 5 8 402 4 10 2 8 20 30 9 43 5 52 4 7",
    ": 9 62 4 7 72 6-7 9 85 90 4 500 8 13 5 8 20 9-30 2-3 5-8 46-7 51 5 64 71 8 80-1",
    ": 4 90 2 4-5 8 603 5-6 8 10-1 3 6 23 5 8 33 5 7 9 41 7 9 53 5 8 64 72 5 9 81 3",
    ": 5 7 9-90 2 4 7 9-700 3 6 8 12 4 7-8 20 2 8 35 41 4 50 2 69 75 8 83 7 99 804",
    ": 12 6 8 20 2 4 7 39 45 9 51 5 7 63 5 8 75-6 8 81 5 7 9 91 3 6 8-9 902-3 6-7 9",
    ": 11 3 5 9 23 5-6 9 31 3 5 7 9 42 4 8 55 8 63 77-8 86 91 3 6 8",
    ": 6002 4 6 11 8 23-4 6 8 30-1 40-1 3 6 50 2-3 61-2 8 70 2 4 6 8-9 81 5 7 91 6-7",
    ": 9 101 6 11 3 5 9 23 5 7 9 31 3 7 9 43 5 62 4 7-8 70 5-6 8 81 5 90 4 200 6-7",
    ": 13 24 8 31 9 46 50 2 7 60 4 6 70 2 84 7 92 4 8 300 2 4 6-7 13 23 6 35 7 9 41",
    ": 3 5 7 53 6 8 60 2 4-5 73 7 82 5 7 91 3-4 6 9 401 7 11 4 8 20 2 5 7 31 3 5 8",
    ": 42 7 9 53 9 66 8 73 6 88 90 2-3 5 503 6 8 14 22 5-6 8 31 7 9 43-4 9 51 3-4 7",
    ": 69-70 2 6-7 9 81-2 4 9 95 7 9 601 3 5-6 8 10 2 5 7 20 6 30 2 8 42 55 7-8 61 3",
    ": 5 8 80 2 5 91 3 7 705 9 11 3 5 7 31 3 6 9 41 3 5 7 9 51 3 69-70 5 9 82 4 90 3",
    ": 9-800 2 9-10 2-3 6 20 6 8 36 8 42 5 8 51 5 8-9 61-2 4-6 81 8 90 3 5 7 9 912 4",
    ": 6 8 23 5 7 9 32 4-5 8 42 4 6-7 50 3 5 7 68 79 83 91 4 8",
    ": 7004 10 9 21 4 7 38 45 57 61-2 4-6 8 72 4 8 80 4 6 92 110 7-8 29 32 7 40 2 7",
    ": 54 7 62 4 72 82 7 90 2 6 204 6 8-9 12 4 6 8 20 4 6 8-9 31 3 5 7 9 45-6 8-9 53",
    ": 7 9 63-4 7 82 7-8 90 3 9 301 5 7 11 3 27-8 30 6 8 40 4 6 55 7 61 3 5 71 3 5",
    ": 80 8-9 93 9 402 4 6 8-9 11 3 6 8-9 21-3 5 7 34 7 43 9-50 7-8 60-1 8 75 7 9 83",
    ": 5 7 9 97 9 501 5 12 5 7 24 8 33 5 7 9 41 4 6 50 4 6 8-9 61 5 7 9 74 7 80-1 4",
    ": 6-7 96 9 601 3 5 7 17 21-2 5 7 9 31 4-5 7 40 52 4 7 65 70 2 7 85 7-8 90 4 8",
    ": 700 2 5 7 9 14 31 3-4 6 8 42-3 6 8 50 2 65 7 70 6 9 81 4 6 8 90 2 5 7 9 801 4",
    ": 6-7 9 14 6 8 20-1 4 31 40 2 5 51 3 5 7 64 6 72 4 80 4 6-7 97 9 901 4 6 10 2 4",
    ": 7 9-20 3-4 6 8 31-2 6 8 41 3 5 58 60 2 4 7-8 72 8 81 5-6 8-90 2-3 5 9",
    ": 8007 9 11 3 20 3 32 4-5 7 9 41 3 5 53 60 7 9 73 7 9 84 91 3 102 6 8 12 5 9 22",
    ": 7 9 31 3 42 6-7 58 60 3 9 71 6 80 93 5 7 9-200 2 4 6 8 14 20-1 33-4 41 5 7 9",
    ": 51-2 4 6 61 72-3 6 81 3 5 9 94-5 8 305 8 16 8 23-4 7 9 32-3 9 41 5 9 51 3 6 9",
    ": 61 3-4 71 4 6 8 80 3 6 9 91 4 6 402 4 12 4 21 3 5-6 8 30 2 7 40-1 3 8 56 9 61",
    ": 3 5 7 73-4 6 8 83 5 7 9 93 7 9 502 5 9 11 3 8 22-3 36 8 41 4 6 8-9 52 4-5 9",
    ": 61 3 5 7 74-5 8-9 83-4 7 92 600-1 3 5 7 10 4 6-7 20 2 4 6 38 40 3 5 7 51 6 8",
    ": 60 2 4 6-8 70 80 2 4 6 93 7 9 701 3 5 7 9 14 8 20-1 3 30 3-4 9 45 7 9 52 4 6",
    ": 8 63 5 7 9 71 3 81-2 7 9 91 3 8 806 9 11 4 7 21 3 5 32-3 5 7 9 43 9 54 8 60 5",
    ": 7 9 73 5 8 80 3 7 9 91 3 6 8 905 17 9 21 8 30-1 40 2 6 50 61-2 4 6 73 80 2",
    ": 4-5 9 91 3",
    ": 9003 8-9 11 5 7 9 21 3 8 32 6 43 5-6 51 3 6 8 62 4 6 78 85-6 94 6 101 6 8 10",
    ": 2 4 21 4 7 9 36 8 44-5 51 5 8 63 5 9 73 8 80 2-3 6 8 90 5 202 9 11 20-2 5 8-9",
    ": 32 4 6 8 40 2 4 6-7 55 9 63 5 7 9 71 4 9 81 3 6 90 4 7 9-300 4 9 11 7 20 4 6",
    ": 32 6 8 42 52 6 8 63 5 7 9 71 3 80 2 92 4 8 400 2 5 8 11 22 5-6 34 6 42 7 9",
    ": 52-3 5 63 5 74 7 9 81 5 9 94 7-8 501 3 6 8 10 4 7 22 4-5 7 9 31 3 9 45 51 5 7",
    ": 9 61 4 6 8 73 5 80 5 7 92 6 8 601 3 5 9 11 3 9 21 4 6 8 30 3 5 7 9 56 60 70 3",
    ": 83 5 9-90 5 8 700 2 4 6 8 10-1 3-4 6 9 24-5 9 31 3 5 40 4 8-9 51 3 5 7 68 72",
    ": 83 7 91 6 804 10 2 6 8 36 40 4 53 5 7 9 63 5 8 70 4 8-9 83 91 5 900 2 12 21 5",
    ": 8 34-6 9 41 5 9-50 2 4 68-9 75 85 7-9 91 3 5 7 9",
    ": 80001 3 5 7 23-4 6 8-9 31 5 7-8 40 2 9 57 65 9 71 6 8 80 2 4 8 91-2 4 104 7",
    ": 10-1 3 6 8 24 7 31 4 41 6 8 52 4 6 8 60 8 70 3 7 83 7 9 91-2 4 6 8 202 6 9 13",
    ": 7 9 27 9 33 5 7 9 41 3 7 9 51-2 4 6 8 65 8 74 8 82 4 7 91 3 7 9-300 2 4 6 8",
    ": 12 4-5 7 9 21 6 8 32-5 7 9 41 5 51 3 5 61 73 6 404 9 11 21 3 5 7 9 31 5-6 8",
    ": 41-2 4 6 8 54 6 8 60 3 5 7 79 84 91 3-4 6 8-9 501 4 6 10 2 9 22 4 33 5 7 9 41",
    ": 3 5 8 57 61 3 5 7 87 9-90 5 9 602 4 15 7 9 21 6 8 31 3-4 6 8 46-7 9 53 5 7 9",
    ": 65 7 74 83 5 9 91-2 4 6 8 700 2 9 11 4 6 20 2 6 8-9 34 8 54 6 64 6 8 74 6",
    ": 93-6 9 802 8 11 3 5 7 9 21 3 5 7 9 31 4 40 2 4 6 9-50 2 9 70-1 3 83 8 90 2-5",
    ": 7 9 901 9 16 22 5-6 8 30 4 43 7 9 51 3 5 7 63 6 8 70 2 7 88 90 4",
    ": 1007 9 11 5 30 5 43 5-6 8 50 2 4 6 9 69 78 80 90 2-3 100 3 5 7 9 15 7 22 4 6",
    ": 8 30 4 6 9 41-2 4 55 9 61 3 5-6 8 73-4 7 82-3 5 7 9 91 9-200 2 6-7 10-1 5 21",
    ": 9 33 6 46 8 51 60 3 5 7 9 71 3 84 6 8 90 4 6 304-5 10 5 21 3 7 30 2 7 9 46",
    ": 8-9 52 4 7 60 4-5 9 76 8 81 5-6 90 4 403 7 21 9-30 2-3 5 40 2 6 50 2 8 60 2 9",
    ": 71 3 5-6 80-1 3 5 7 91 3 6 500 10-1 3 7 39 44 6 8-9 51 5 64 6 8 72-3 5 7 9 83",
    ": 92 4 9-600 2 5-6 11 3 7 9 21 9-30 2 4 6 8 44 6 9 56 8 60 2 4 7 9 73 5 7 81 5",
    ": 7 9 94 8 702 4 6 10 2 5 7 24 6-7 9 32-3 5 47 50 2 7 63-4 9-71 3 6 9-80 5 91",
    ": 804 39 89 95 9 901 4 8-9 13 6-7 30 4 40 2-3 8 53 8 60 5 70 2 4 6 80 3 5-6 92",
    ": 4 6 8",
    ": 2001 9 11 3-4 22 4 7 9 31 41 3 5-6 8 51-2 6 62-3 73-4 80 2 4-6 8 99 101 14 6",
    ": 9-20 2 5 42 4 9 56 9 62 6-7 9-70 4 6 8 80 3 6 94-5 200 2-3 5 10 3 6 8 21-2 5",
    ": 42 4 6 9 52 6 64 6 70 2 8-9 84 6 9-90 2-3 300 6 8 10-1 3 5-6 8 20 2 4 6 35 45",
    ": 54 7 9 61 8-9 74 7 84 6 8 91 3 5-7 400 8 10 4 8 24 34-5 7 40 3 6 58-9 62 4",
    ": 6-7 9 76 8 81 3 8 92 5 8 509 12 5 8 20 3 9 31 3 5-6 40 8 50 6 62 4 6 9 71 3 7",
    ": 9 83 5 8 90 602 4 6 8 10 4 6 8-9 21-2 5 7 9 33 9 41 5 9 53 5 9 61-2 8 72 4 6",
    ": 81 3 91 7 701 4 10 4 6 21 3 6 35 44 6 8-9 51 5 62-3 5 7 75 7 81 3 5 7 9 93-4",
    ": 6 8 800-1 10 7 27 30 2 4 8 42-3 5 7 50 2 5 8 62 4 7 70 2 4 6 8 80 3 7 91 3 5",
    ": 7 9 901 6-7 15 20 2 4 30 7 48 50 3 7 9 61 5 70 3 6 8 80-1 3 5 9 95",
    ": 3001 3 5 7-8 13 6 20-1 4 6 8 32 5 7 9-40 4 50 4 6 64 6 8 70 6 81 3 5 9 91 5",
    ": 7-8 104 12 6-7 20 7 9 33 5 7 40 2 8 51 3 61 6 70 2 8-9 81 5 90 7 9 201 4 7 11",
    ": 3 22 4 6 31 6 8 45 7 9 53 5 7 62 8 71 5 8-9 81 7 9 92 6 8-9 303 15 7 21 3 9",
    ": 31 3-4 6 8 42-3 5 9 51 3 8 69 71 5-6 8 82 6 90 9 401 4-5 12 4 6 8 25 7 9 32",
    ": 4-5 42 8 59 64 6 72 8 80 3 6 8 95 7 502 11-4 6 26 32 4 41 3 7 9 52 4 62 4 8",
    ": 72 5 8 80 2-3 5 9 91 3 8 600-1 11 8 21 5 9 33 5 7 41 3 5 52 4 60 2 6 78 83-4",
    ": 6 94 8 700 3-4 6 17 24 30 5 41-2 5 7 9 51-2 4 7 9 61 5 7 9 71-2 4 6 8-9 81 3",
    ": 6 8 90-1 3-4 802 4 6-7 9 15 7 20 2 7 9 38 40 2 4 6 52 8 70 6 8 85 7 9 91-2 4",
    ": 7 9 902 4 7 9 11 4 6 24 8 30 6-7 9 42-3 5 7 9 51 5-6 62 6 8 71-2 5 8 88 92 4",
    ": 8",
    ": 4000 3 5 7 9 13 21-3 5 9 35 7 40 2 4 6 9 51-2 7 60-1 9 74-5 7 9 81 5 7 91-2",
    ": 103 7 9 11 5 24 8-31 4 6 42 5 54 62 6 71 3 80-1 3 91 3 9 204 8 10 3 5 20 7 33",
    ": 7 9-40 2 4 9 51 3 5 7 65 9 77 80 4 6 92 5 7 9 301 3-4 9 13 27 9 33 6 43 7-8",
    ": 50 9 71-2 4 6 80 90 2 4 402 11 3 7 22-3 8 30 3 8 42 5 8 53 7 61 9 71 3 6 86",
    ": 97 500 6 8 10 2 4 6 21 3 9 33 7-8 42 4 51 3 5 61 3 5 8 71 3 5 7 9-81 3 5 9",
    ": 602 10 2 4 6 8 20 2 4 6-7 9 34 7 9 41 3 51 3 5-6 9 61 9 71 3 81 4 6 8 90 5 9",
    ": 703 5 8 12 20 2 4 6 8 36 40 3 5 7 53-4 6 9 63 5 77 9-80 4 95 7 9 801 3 8 15-6",
    ": 24 35-6 8 40 4 8 52 5 65 7 9 73 5 7 9 81-2 7 91 3-4 6 900 2 4 6 9 15 9 21 3 5",
    ": 8 37 46 8 52-4 8 60-2 8 70 2 4 6 8 81-2 4 6 90 3 5-6 9",
    ": 5001 3 12 8-9 22 6 34 41 55 7-8 62 4 6 70-1 5 9 81 3 5 7 97-8 105 7 9 11 7 9",
    ": 22 4 6 8 30 2 5 9 42-3 5-6 52 4 9 61 3 5 7 72-3 5 7-8 81-2 4 6 91-2 4 201 3 5",
    ": 7 12 33 52 4 9 62 4 6 72 5 9 81-2 4 92 5 9 302 4 6 9-10 2 4 6 8-9 27 9 31 7",
    ": 42 4 6 9 51 5 63 73 5-6 84 6 8-9 95 7 9 401 3 8 11 3-4 7-8 20 3 9 31 6 8 40 2",
    ": 4 7 57 9 61 73 5 8 81 3 90 2 4 6 8 504 6 9 11 9-20 2 4 7 9 32 4 6-7 9 41 6-7",
    ": 50 7 60 6 72 6 83 5 7 95 7 9 602 5 9 19 28 33 8 40 2 5 7 9 55 8 62 5 9 71 5 7",
    ": 9 81 4 6 8 90 2 6 8 700 2 8 10 20 2 9 31 4 6 40 5 7 58 64 8 70 2 8 83 7 95 7",
    ": 801 3 6 12 4 20 35 7 50 3 9 61 3 5 71 8 82 5 7 9 91 3 5 7 900 5 8 10 2 7-8 20",
    ": 3 9 31 3 5 7 44 7 9 55 7 9 61-2 4 6 8 70 2 5 7 9 86 8 91 4 6 8",
    ": 6000 4 6 13 5 7 34 6 40 2-3 5 8 50 4-5 7 61 8 74 6 83 7 9 91 3 5 7 100-1 3",
    ": 10-1 4 7 9 26 8 37-8 41 5 8 50 4 6 8 62 6 72 4 9 82 9 91-2 8-9 201-2 4 6 10-1",
    ": 4 7 9 23 5 33 5 7 46 50 5 62 5 70 5 81 4 8 92-4 6 305 8 10 4 24 6 8 30-1 42 4",
    ": 6 50 2 4 6 9 61 8 72-3 5 9 84 7 9 91 3 5 401 5-6 16 22 5 7 9-30 2 8 40 2 4 50",
    ": 2 4-5 67 9 71 82 92 4 6 512 4 6 9 21 5 7 33 6 8 40 8 50 2 65 71 4 7 9 81 7",
    ": 9-90 3-4 600 2 4 6 8 10 4 9 25 7 9 32 4 42 50 3 5 69 72 4 7 81 7 9-90 4 6 8",
    ": 701 3 7 9-10 4 8 24 38-9 41 52 4 6 8-9 64 6 8 74 8 80 6 90 2 4 6 800 3 7 17 9",
    ": 26 8 30-1 4 6-7 41 3-4 7 9-50 5 62 6 70 2 6 9 83 5 7 9-90 7 9 905 7 11 6 22 8",
    ": 30 3 5 9 41 7-8 62 8 70 2 4 6 82 7 92 6 8",
    ": 7004 7 12 8 24 30 5 40 4-5 8 53 6 69 83 9 92 4 7 9 102 6 8 17-8 21 5 7 31 3",
    ": 5-6 41 5 8 50 5 60 8 73 6 8 80 2 5-6 92 4 6 203-4 6-8 13 20 3 5 7 31 5 45 7 9",
    ": 51 3 61 3 5-6 9 71-2 4 8-9 83 5-6 9 92 4 6 9 303 7 9 12 22 4 7 9 33 41 8 51 5",
    ": 63 5 7-8 70 2 80 3 5 9 91 7 400 3-4 7 9 11 3 7-8 20-1 3 5 7-8 30 4 6 8 44 6",
    ": 50 5 7 9-60 2 4-5 7 70 3 9 83-4 93 7-8 500 2 5-6 14 9 23 7 31 4-5 7 9 43 5",
    ": 7-8 52 4 6 60 3 6 8-9 71 3 80 2 90 2 4 6 8 600 3-4 7 17 9 26 30-1 3 8 44 6 8",
    ": 51-2 8 61 9-70 3 7 9 81 3 5 8 92 5 7 703 5 7-8 12 4 20 2 5-6 32 4 6 8 42 4-5",
    ": 7 53 6-7 61 3 9 71 5 80 2 4 6-7 9 93 7 9 802 4-5 7 9-10 7 22 7 30 41 6 50 5",
    ": 9-60 2 4 6 9 72 4 6 8 81 3 8 92 7 9 901 5 9 11 3 5 7 25 9 33 5 7 48 50 4 6 8",
    ": 60 71 3 5 81 6 9 91 7",
    ": 9-8000 2 10 2 26 32 4-5 7 9 46 59 61 3 7 73 5 7-9 81 8 90 5 7 9 101-2 4 10 2",
    ": 5 26 31 7 9 49 51 3 6 8 64 70-1 83 96-7 9 201 3 7 11 4-5 20 32-3 6 9 41 3-4 6",
    ": 8 51 3 5 7-8 60 4 9 72-3 8 82 4 92 4 6 8 300 7 11 3 5 7 9 21 3 9 37 45 7 9 53",
    ": 7-8 60 3 7-8 70 3 6 8 80 3 6 99 402-3 8 10 2 4 9 21 6 30 3 5 7 41 3 5 9 51 7",
    ": 65-6 73 5 83 5 503 5 7-8 12 6 8 20 2 5 9 31 4 6-7 49-51 7 9-60 2 9 71 3 7 9",
    ": 82 5 92 4-5 8-9 609 11 4 6 22 6 8-9 34 6 8 41 55 7 9 61 4 6 8 74 6 8 80 2 4",
    ": 700 3 5 11 5-6 31 5 42 5 9 54 6 8 69 73 6 8 81 90-1 4 6 8 800 3 5 7 9 18 28",
    ": 32 4 8 40 3 5 9 52 4 6 63 6-7 9 71-2 4-6 9-80 3 94-5 7 9 901 3 5 12 4 6 27 9",
    ": 35 7 40 3 55-6 8 62 72 7 87 90",
    ": 9002-3 5 10-1 20 6 9 38 46 55-6 8 65 70 4 7-8 80 5-6 90 2 8 100 10 5 26 34 40",
    ": 2 4 6 8 50 9 61-2 70 9 84 6 8 90 9 201 9 11 5 7 9-20 7 31 3 46 8 50 2 5 7 66",
    ": 8 73 8 80 2 4 6 90 2 4 7-8 300 2 4 8 10 2 21 3 7 32 6 42 4 8 50 4 6 60 3 5 7",
    ": 71-2 8 83 7-8 92 4 8 400 2 10 3 5 7 9 21 6 36 42 5 7 51 7 9 61 5 7 71 4 9 83",
    ": 6 8 94 6 8 500 5 7 12 4-5 7 9 21 3-4 6 37 9-40 2 4 7 9 51 5 8 60 3 6 8 71 7 9",
    ": 83 5 8 90 6 9 609 16-8 22 5-6 8 32 6 8 40 51 3 9 61-2 9 81 5 9 91 7 9 701 12",
    ": 4 6 20 2 30-1 5 7 43 60 6 8 70 8 82 4 7 9 91 5-6 804 6-7 9 11 6 8 21 5 8-9 31",
    ": 3 5 7-8 40 3-4 8 51 3 5-6 8 60 3 5 7-8 70 2 5 9 81 3-4 6 9 95 9-900 2 5 7 9",
    ": 21 3 6 9 33 47 50 2 5 72 5 8 80 3 6 8-9 91-2 4 6",
    ": 90000 2 13 5 7 9 21 32 9 41 3-4 6 8 53 7 9 66 72 83-4 9 93-4 7-8 104 7-8 10",
    ": 2-3 5 29 31 42 4 9 51 9 61 3 5 7 9 71 3 80-1 4 6 8 90 7 200 2 5 7 10 2 4 7 21",
    ": 3 5 7 31 3 5 7 9 41 53 8 60 8 72 4 6 80-1 92 9 303 7 9-10 2 20 7 9 31 3-4 6",
    ": 42 7 52 4 8 60 3 5-6 8 76 83 5 7 90 3 7 9 403 7 9 11 3 5 8 23 6 32 6 8 44 6-7",
    ": 50-1 6-7 9 61 74-5 8 80-1 4 6 90 5 7 504 8 10 5 7 9 21-2 4 6-7 9-30 2 4 6 40",
    ": 4 9 56 75 80 4 6-7 9 91 3 6 8-9 603 8 10 2 7 9 21 3 5 9-30 40 7 54 60 2 70 3",
    ": 5 7 81 4 6 92 4 6 8 713 5 8 20 2 5 9 31 3-4 8 41 3 5 7 9-50 4 61-2 74 81-2 7",
    ": 93 8 802 7 11 3 23 30 6 43 5 52 8 63 6 8 71-2 8 81 3 5 9 91 3 904 6 9-10 2 4",
    ": 6 26 8 35 7 43 7 9 51 4-5 9 61 3 6 70 6 81 7 91 3 8",
    ": 1003 5 7 9 11 8 20 2 4-5 9 31 3 49 53 5 7 62 4 7 9 78 80 5 7-8 105 8 10 3 27",
    ": 31 4 6 43 5 51 3 5 9 63 9 71 5 81 3 6 8 92 4 6 9 204 7 11 5-6 9 21 3 5-6 32-3",
    ": 5 7 9 42 7 9 51 8 62 4 6 78 80 7 9 91-2 301 8 12 4 20 2 7 31 3 9 43 5 7 50 2",
    ": 65 9 75 9 87 9 91 3 6 400 2 5 7 11 4 6 8 23 5 9 32 5 7 41 4 53 5-6 8 62 5 7",
    ": 70 2-3 80-1 7 93 5 8-500 2 4-5 7 9 12 4 6 8 20 3-4 6 30 5 7 51 5-6 64 6 8 75",
    ": 8-9 81-2 4-5 7 603 5 7 9 12 9 25 8 30 4 43 5 8 56 62 4 6 71 3 6 9 83 5 9 97",
    ": 9-700 2-3 7-8 10 6 20 2 6 8 31 3 5 7 9 41 5-6 50 3-4 6 8 60-1 3 5 8 78 80 6",
    ": 95 7 804 6 8 10-1 4 6 8 20 2 4 8 30 2 4 43 6 9 57 60 4 6 70 5-6 8 86 91 3 5 7",
    ": 9 901 13 5 7 9 21 3-4 33 5 9 42 6 8 50 2 4 6 60 5 7 9 75 7 9 82 9 91 5",
    ": 2002 4 6-7 9 11 5 7 9 21 5 9 31 5-6 9 45 7 9 51 61 9 71 3 5 7 9-80 2 4 8 90 2",
    ": 4 8 100 2 6 9 11 6 8-9 24 6 8 30 4 8 40 2 54 6 8 60 3 6 9 75 7 84 6 93 7 9",
    ": 201 6 10 4 6 8 21 3 7 9 32 5 40 5 54 6 8 60 2 70 2 7 83 5 7 91 4 7 9 301 3-4",
    ": 6 8 10 4 6 35 43 5-6 8 51-2 4 6 8-9 61 3 70 2 6 8 85 8 91 5 401 3 6 8 10 2 5",
    ": 7-8 24 30 4 42 4 55 9 61-2 4 6 8-9 73 5-6 83-4 7 93 8 502 4 7 11 4 6 8 20-1 3",
    ": 6 8 31 3 5 9 41 4-5 7-8 50 9 61 6-7 71 5 81 3 7 9 91 3 7 603 8 10 2 7 9 22 7",
    ": 33 6-7 45 7 50 4-5 8 60 8 73 5 8 80 2 4 7 91 3 7 702 4 7 13 5 9 21 5 30 5 9",
    ": 43 9 53 5 7 9 61 4 76 80 2 4 7 91 4 6 9-800 2-3 5 15 21-2 4 7 9 34-5 7 40 2 4",
    ": 50 2 4 6 8 62 4 6-7 70 2 4 6 9 89 94 9 905 7 14 25-6 8 32 4 42 9 59 61 3 6 70",
    ": 2 4 6 8 84 8 90-1 3 5 7 9",
    ": 3001 3 8 20 4 6-7 32 4 6 8 50 4 6 8 60 2 4 7 71 3 5-6 8 81 3 8 101 3-4 6 8 10",
    ": 2 4 6 23 8 30 2 4 6 42 4 52 4 6 8 60 2 4 6 71 3 7 85 94 6-7 9 201 5 11 4 6 8",
    ": 27 9 45 7 9 52 5 8 60 4 8 71 3 6 83 5 7 91 3 304 6 15 8 20 2 4 8 31 5 47 56",
    ": 8-9 61 70 3 5 8 84-5 9 91 5 9 402 4 8 10 7 9 22 34 6-7 9 41 3 51 5 8 60 2 5 7",
    ": 75 7 89 93-4 6 500-1 3 5 10 2-3 23-4 6 8 30 4 6 41 4 6-8 50 2 4-5 7-8 61 3",
    ": 8-9 71 4-6 8 84 6 9 92 4 6 8 617-8 22 7 9 33 8 44 8 50 3 5 7 9 61 3 5 7 9 73",
    ": 81-2 7-8 90 8-9 701 4 6 8 10 2 4 6 8 20-1 3 5 7 9 33 5 7 9-40 2 4 6-7 9 53 5",
    ": 60 3 71 3 80 3 5 92 6 8 804 6 10-1 5-6 21 9 39 44 8 50 2 4 6 8 62 6 8 71 7 81",
    ": 5 9 99 904 6 10-1 28 30 3-4 7 9 42 6 8 50 6 8-60 6 73 80 3 92 4 7",
    ": 4008 10 2 4 6 8 20 3 7 31 4 6 8 40 2 4 6 9 55 7 61 72 9 81 4 6 93 6 104-5 9",
    ": 16 25 7 9-30 2 9 45 53 5 9 61 3 5-6 70 3 5 7 9 82 4 6 94 7 201 5 11 3 5 24 6",
    ": 8-9 31 3 5 7 41 3 6 53 6 63 5 7 81 4 9 91 7 9 304 7 12 20 4 30 5-6 8 40 5 8-9",
    ": 51 3 5 62-3 5-6 8 72 6 8-9 81 3 5 91 3 7 406 12 4 7 9 23 31 3 5 8 40 3 6-7 50",
    ": 6 60 2 4-5 7 71 5 7 9 81 4 7-8 90 6-7 501 4 8 12 8 20 2 5 7-8 32 4 6 47 52 60",
    ": 6 8 76 82 7 91 3 7 9-600 2 6 12 4 6 20 2 4 6 8 32-3 5 7 9 42 53 6 8 60 5 7-8",
    ": 70 4 6 80 7 9 94 6 700 2 4 7 20 2 4 6 8 31-3 5 7 41 3 5 7-8 50 2 4 6 8 60 2 4",
    ": 6 73 6 85 9 91 4 7 803 6 10 2 6 8 20 4 6 8 39 48 50-1 5-6 64 6 77 9 85 905 7",
    ": 14 7 9 21 3 5 7 9 33 5 46 8 63 9-70 2 4-5 9 81 90 7",
    ": 5002 6 8-9 11 3 5-6 32 7 9-40 2 4 6 51 65 7 9 71 3 7 9 81 3 5 9 93 5-6 8 100",
    ": 11 4 20-1 30 40-1 3 5-6 8-9 56 8-9 61 3 5 8 72 4 6 8 80 2 4 6 8 90 2 4 7 9",
    ": 202 4 10 2 5 7 25 7 9 36 42 5 7 9-50 2 4 6-8 60-2 74 99 303 7-8 13 6 8 20-1 6",
    ": 30 2 7 9 42 6 9 51 8 67 9 71 3 5 7 83 9 93-4 8 400-1 4 10-2 40 505 67 74 8 84",
    ": 91 3 5 7 601 3 5 7 11 3 8 20 2 6 34 6 43 6 8 50-1 60 2-3 5 7-8 70 7-8 80 5 9",
    ": 93 7 701 3 7 9 15 23 31 3 7 45 7 53 5-6 62 6 9 74 6 9 84-5 7 9 91-2 4 6 8 809",
    ": 11 7 9 21 3 30 2-3 8 42 8 50 63 5 7 71 5 7 9 86 8 90-1 6 8 903 5 8 10 2 6 23",
    ": 5 30 3 6 9 43 6 8 54 8 62 4 7 74-5 9 81 3 7 91 4-5 8",
    ": 6000-1 4 6-7 11 3 5 7 20 2 4 6 34 6 8 40 4 6 9 51 7 60 2 72-5 7 9 81 5 8 93 8",
    ": 100 4 8 17 9 21 5 7 9 31 8 40 3 5 7 51 3 62 5 9 71 3 6 82-3 5 8 93 6 206 10",
    ": 20 2 4 7 9 32 6 41 4 7 51 5 7 9 61 4-5 8 71 7 82 4 7 9-90 2 303 5-6 12 5 7 9",
    ": 21 3 6 8 32 4 41 53 7 63 5 75 9 83 5-6 90-1 3 8 400 9 11-3 5 8 25 31 3 5 7 40",
    ": 2 4 6 8 58 60 70 2-3 5 80 2 5 9 97 500 3 5 9 11 3 5-6 8 29-30 8 41 3 8 52 7 9",
    ": 64 8 70 3 7-8 80 4 90 2 4 603 5 10 2 6 9 25 7 32 9 41 7 51 6 8 61 5 7 70 2 4",
    ": 6 8 83 5 90 2-3 5 7 9 701 3 7 9-10 2-3 20 5 7 9 31 3 5 7-8 42 5 54 7 62-3 8",
    ": 70 7 9 82 4 6 9 91 3-4 806 8 10 2-3 6 22 30 2 4 8 40 2 4 9-50 2 5 7 61 3-4 9",
    ": 72 4 8 80 2 4 6-7 91 3 5 908 10 2 5-6 8 21 3 5-6 39 49 54-5 65-6 8 73 5 81 4",
    ": 6 97",
    ": 7000 2 5 7 9 11 6 8 20 3 5 7 9 31 3 5 44 6 8-9 51 6 8 64 6 8 70 4 9 81 5 91 3",
    ": 101 3 9 11 3 8 20 3 8 34 8 48 59 61 7 9 71 8 80 2 5 7 9 97 214 6 9 21 3 8 30",
    ": 2-3 5 7 43 5 7 9 51 7 61 3 5-6 8 70 2 7 87 90 2-3 9 301 4-5 7 9 16 8 26 32 4",
    ": 48 50 62 4 6 70 2 4 7-8 80-1 4 6 94 403 5 7-8 10 4 9 21 3 5-6 8 34 6 40 3 5 7",
    ": 51 7 9 61 3 5 72 4 7 9 85 98 500 2 4 7 13 5 9 27 38 40 2 4",
    ": 728298-304 6 8-15 7-9 21 4 9 32-5 7-8 41-4 7-52 4-5 7-60 2-3 5-6 8-9 71-3 6-9",
    ": 81-5 7 9-91 3-4 7 9-401 3-5 8-11 3 5-21 4-5 7 9-35 41-2 5 8-50 2-4 6-63 6-9",
    ": 72 5-8 80-5 7 9-95 7-9 501-7 9-11 3 5-7 9-22 4 6-7 9-34 6 8-43 7-9 53-8 60-1",
    ": 4-7 9-81 4-8 90-4 6 601-4 6 9 12-4 8-20 2 4 7-9 33 6-8 41-6 8-54 7-9 61-7 70",
    ": 5 7 9 81-7 9-90 2-3 5-7 701 4-5 8 13-20 2-30 3-6 8 41-4 6-8 51-5 7 9-62 6-8",
    ": 71-6 8-82 4-7 90-1 3 6 9-800 2-3 5-8 13 6-7 9 21-6 9 33-4 6 8-48 52 5 7 60",
    ": 2-4 6 8 71 5 7-85 8-9 91-4 6-903 5 8-11 3-5 8-20 3 5 8-39 41-3 6 8 50-1 4",
    ": 6-61 3-6 8-76 9 82-3 5-7 9-92 4-8",
    ": 9003 5 7 13 6-8 21-4 9-33 7 42-3 6-52 5-9 62-5 7 9-71 6-80 2 5 90 2-3 7-8",
    ": 100-4 6-8 10-6 8-24 6-7 9 33-4 6 8-9 41-4 6 8-50 3 5-65 7-9 71-9 81-6 8-90 6",
    ": 8-9 201-3 7 9-12 4-5 21-3 5 30 2-4 8 42-3 5-6 8-9 51 4-61 4 7 9-71 3-8 80",
    ": 4-90 3 7 9 303 7-11 4 6 8-9 21-3 7-8 33-7 41-3 5-6 9 51 3-7 9-60 2 5-6 9-70 2",
    ": 81 4-6 8 92-4 8 401-3 5-6 8-10 4-5 8-9 21-2 5-6 30 3-4 6 8-42 6-7 50 3-5 7",
    ": 9-61 3-5 9 72-5 80-6 8-9 93 6-8 502 4-6 8-13 5 8-22 4-6 8-30 2-3 5-7 9-44",
    ": 7-50 2 4-7 9 62-72 4-99 603 5 7-15 7-9 21 4 6-7 9-42 4-6 8 50-1 4 6-7 61 3-4",
    ": 6-71 4-5 8-9 82-3 6-8 90 3-6 8-702 4-5 7 9-11 3 5-6 9-20 2-3 7-30 2-5 8-42",
    ": 4-7 9-54 6 8-61 3-71 3-5 7-80 2-4 6-7 90-3 5 7-803 6-9 11-2 5 7 20 2-30 3-4",
    ": 42-6 8-60 2 5-7 70-1 3-5 8-9 84-7 9 92-906 10-1 3 6-20 2-3 5-34 8-41 3 6-8",
    ": 50-1 3-61 3-6 8-71 4-6 8-9 81-3 5-6 8-93 5",
    ": 30001-3 5-6 8-9 12 5 7-25 8-9 33 6-40 5-6 8 52-4 6 62-72 4-7 9 83-5 7-95",
    ": 9-101 4-15 7-20 3-5 7-34 6 9-40 2 4-50 3-7 61-2 4-70 3-5 8 82 4-5 8-90 3-4 7",
    ": 200-7 9-18 21 4 7 9-32 5-8 40-5 7-8 51-5 8 63 5-9 74-6 8-88 91-3 5-7 300 2-6",
    ": 8 10 2 4-5 7 20-1 3-6 8-30 5-46 9-51 3 5-6 8 61 4 6-8 70 5-6 8-9 82-3 5 7-92",
    ": 6-7 9-400 5-8 10-3 5-7 9 22-3 5 7-8 30-3 7-9 42-4 8 50 4 6-66 9-71 3-4 6-81",
    ": 3-6 8 90 2-5 7 500 2 6 8-10 3-5 7 21 3-4 30-1 3 9-40 3-5 8-9 51-3 5 8-63 5-8",
    ": 73-7 9-80 2 4-9 91 4-8 600-1 3-4 9-13 8 20 2-3 5 8-9 32 4-7 9-41 4-8 53-4 6 8",
    ": 61 6-77 9-81 3-7 9-91 4-5 7-9 702-3 6-7 9-15 7 20-2 4-5 7 33 5 7-43 5 7-51",
    ": 3-7 9-61 3-4 7-70 2-4 6-7 80 4 6-7 91-800 3 5 7-9 11 7 9 24-5 9-32 41 4 6-8",
    ": 50 2-3 7 60 2 4-5 8-70 2-6 8-80 2 4-5 90 4-911 3 5-8 21-6 8-31 3-4 6 9 41 3-7",
    ": 51-4 6 8-9 61 3-7 9-72 4-7 80-8 90 4",
    ": 6-1005 8-12 4-5 7 9 22-4 6-7 9-30 4 6-8 40-3 6 9-51 4-7 60-1 3-4 6 9-71 4",
    ": 7-81 3 90 2-4 6 8 103 6-7 10-2 4-6 8-9 21-2 4-7 30-7 40-2 6-52 7-64 6 8 72",
    ": 8-83 6-7 90-1 4 8-204 9-10 2-5 8 21-4 6-8 31-7 9-42 7-53 6-8 62-6 9-70 3-4",
    ": 9-83 5-8 90-1 3-4 6-300 2 8 11 3-5 7-22 4-5 8 30-6 40-1 3 5-52 6 61-2 4-7",
    ": 71-2 4-8 81 4-5 7-90 2-7 9 401-5 8-16 9-21 3 5-7 30 4-7 43-4 6 8 51 4-62 4",
    ": 6-7 9-70 2 5-9 83-5 7 91 3-4 7-500 3-6 10-5 7-21 3-6 8-32 4-43 50-2 4 6 8",
    ": 61-9 71 3-4 9-85 7 90 2-6 8 600 2 9-15 7 9 23-4 6-7 9 31-3 5-40 2-5 50-6 9-63",
    ": 5-9 72 5-7 9-82 4 6 8-92 5-6 9-702 4-6 8-9 12 4-7 9-20 3-30 2-3 5-7 9-41 3-6",
    ": 8-51 5 9-61 6-8 70-1 3-4 6-80 3-7 91 3 5-6 8-9 801-2 4 6-11 3-4 7-9 22 4-6",
    ": 9-32 5-6 9 41 3 5-8 50-7 9 61-2 5 7-8 71-4 6-8 80-1 3-91 3 5-6 8-903 5-8 10-3",
    ": 5-6 8 20-1 3-4 6-9 32-4 6 9-41 4 6-53 5 8-62 4-81 3-90 2 4-7",
    ": 2001-6 8-9 11 6-21 3-5 7-9 31-2 5-43 5-6 53-9 62-3 5 8-70 5-6 8-85 8-90 4",
    ": 6-104 6-7 11-2 4 6-20 2 5-6 8 30-8 40-1 3-5 9-52 5-6 60 2-4 6-7 9-71 3-4 6-7",
    ": 81-93 7 200-6 8 10-1 5-22 4-5 8-33 5-8 43-4 8 50-2 4-6 9-64 6-70 2-3 7-8 80-3",
    ": 6-7 90 2-6 300-1 3-9 11 4-6 9-20 2-9 35 7-40 2-50 2-3 5 7-8 61 6 8-70 3 5-86",
    ": 8-92 5 400-1 3-4 7-10 4 6-20 3-4 8 30-3 6-7 9-40 3-56 60 2-5 8-9 71-2 4-7",
    ": 9-80 2-6 8-9 91-3 6 9 503-6 8-9 12-5 7 20-3 31-6 8-9 44-50 2-4 7-8 60-5 7-9",
    ": 72-6 8-81 3 7 9 91-601 6-7 9-10 3 5-6 8-20 2 5 30-5 7-41 4-9 52-4 6-7 60 5",
    ": 7-9 71-2 6-8 82-7 90 3 6-8 700-8 11-21 3-5 7 9-31 3-7 9-41 4 6-9 52-7 9-62 4",
    ": 6-70 5 80-3 6 8 93-6 801 4-6 8-11 4 6-7 9 21-3 5 30-3 6-41 3-4 7-9 51-3 8 60",
    ": 3-4 6 8-70 3-87 91 5-6 8-904 6 8-9 11-4 6-23 5-7 30 2-3 6 9-40 2-4 6 8-61 4 6",
    ": 8-74 6-7 9 81 4-6 9 91-5",
    ": 7-3000 5 11 6-25 7 34-42 5-6 8 50 4 7-8 60-1 3-4 7-70 4-7 80-1 9-92 4 101 4",
    ": 7-9 12 4 7-8 23-4 8-9 32 4-7 40 2-3 5-7 9-52 5 7 61 3-5 7-71 4 81 4-5 7-90",
    ": 3-7 202 5-6 10-2 4 7 20-5 7-31 4-41 4-5 9 52 4-6 8 60-3 5-73 5 7-80 2-3 6-93",
    ": 5-301 9-11 3-5 7 21-3 5 7 30-1 3 9-41 3-4 7 9-53 5-6 8 62-74 6-7 9 81-3 5 9",
    ": 92-4 7-408 10-2 5-20 3 6 8-38 40-3 5 8-9 51-3 6-60 2 5 7-70 3 6-7 82-4 7-91",
    ": 3-6 501 4 7-9 13 7 23-4 6-8 31-2 6-42 4 6 9-52 5-7 60-7 9-80 3-93 5 8 602-4 6",
    ": 8-13 6-8 21-2 6 8-32 4-6 8 41 3-51 3-4 6-9 64-7 9 73-4 6-7 9-87 9-91 4-5 8",
    ": 701-3 6-9 11-2 5-6 20 2 4 7-9 31 4 8 40 3-5 7-8 50 2 5-7 62-4 6-8 70-1 4-7 80",
    ": 2-5 8-90 3-7 803-4 7-13 5 7 21-2 6-9 31-3 5-41 3 6-54 7-61 5 7 9-70 2 6-8",
    ": 83-9 93 5-8 901-2 4-5 8 13-6 8 20-2 9-30 2 5-6 8 40-2 4 6-56 8-62 8 70 5 8-80",
    ": 3 6 8-9",
    ": 91-4002 5-6 8-11 5-9 21 4 6 8-32 4-7 9-42 5 8-52 4 6 61-4 8 71-2 4-9 81 3-91",
    ": 3-4 6-7 9-101 3 7-10 2 4-5 7-20 3-4 9 33-9 42-4 6-9 51-2 4-5 60-9 72-7 9 83-9",
    ": 91 4-6 200 3-6 9-10 3 6-7 9 22-6 9-30 2-3 7-49 51-4 6 60-2 5-7 9-70 2-5 7-8",
    ": 80-2 8-92 4-6 9 303-7 10 2 9 22-3 5-6 8-9 33-5 7 43-4 7-8 52-5 7-60 6 9-70",
    ": 3-6 8-9 82-3 5 8-96 9-402 4-5 7 9-10 2 4-6 8-9 23-4 6-9 33-4 6-43 5-6 51-3 7",
    ": 60-1 6 9 73-4 6-7 81-3 8-91 4-6 8-9 501-4 6-10 4 8 22 4-5 8 32-7 40-4 6 8 50",
    ": 2 6 60-3 7-71 3-8 80-3 7-93 600-3 6 8 10 2-4 6-9 21 5-7 9 31-7 9-45 9 52 4",
    ": 6-62 4-5 7-8 70 2-3 6 8-81 3 5-92 4-7 9-701 3 5-7 9-17 9 22-4 7-8 30-6 8-9",
    ": 41-7 50-1 4-7 60-3 6-7 9-75 7 9-80 2-3 5-7 90-4 7 9-804 7-10 2-4 6 8 24 7-9",
    ": 36-7 9-44 6-7 9-50 2 4-8 61-2 4 7 9-70 2-5 9-84 6 9-93 6-9 901-3 5 10 2-3",
    ": 9-20 3-4 8-9 36-8 41-2 4-7 9-50 5-6 8-60 2-8 73-5 7-9 81-4 6 90 2-4 6-9",
    ": 5001 5-6 8-10 2-5 7-21 4 6-30 2 8-40 2-5 7 9 54-5 60 2-7 9-75 7-8 81-4 8-91 3",
    ": 5-8 100 2 4-5 7-8 10-1 7 9-20 3 5-7 9-31 3 5 7-40 2-5 7-51 3 7-9 61-8 70-1 5",
    ": 7-8 80 2 5 7-8 93 5-6 8 200 3-7 12-3 5-20 2-6 9 31-9 41-2 5-8 50-63 5-8 71-4",
    ": 7 9 81-2 4-5 8-9 91-3 300 5-15 9-21 3-4 6-30 3-6 9-40 2-3 5-6 50-2 4-8 64-7",
    ": 70-5 7-81 3-4 6 8-93 5 7-9 401-4 8 11-23 9-33 5-6 8-41 4-5 8 53-5 7 60-2 4-8",
    ": 70 3-5 8 80 4 6-7 9-90 3 5 7-502 4-11 3-5 7-20 2-3 5-7 9-30 3-7 9-41 6-9 51",
    ": 4-5 7-8 61-2 4-5 8 70 2-8 81 3-7 90 2 4-8 600-5 7 9-10 2 5 7-9 22 4-7 30 2-3",
    ": 5 7 9-41 4 6 50 2 8 60-1 3-7 70 3-6 80 2 5 7 90-1 3-6 8-701 3-4 8 10 2-8 22 5",
    ": 8-9 32-4 7 9-41 3 5-52 4-5 7-60 3-4 7-9 72-4 7-9 82-3 5 7-9 91-5 801 3-13",
    ": 7-20 2 5-8 30 2 4-41 5-6 8-53 5 7 60 4-73 5 8-81 3-8 90-2 7-8 900 3-4 6-10",
    ": 3-7 9-20 2-4 6 8-30 2-3 5-6 40-3 7 9-50 2-3 8 60-2 4-71 3-7 9-80 2-90 2-7 9",
    ": 6001 4 6 9-11 7 20-4 6-8 30-1 3 7-41 3-5 7-53 5-9 62 8-9 72-5 8-80 2-5 7-91 3",
    ": 5-8 100-1 3 5-6 12-3 5 7-21 4 6 8-41 3-4 7 9-50 3-7 60-5 7 70-1 3-7 9 81-2 4",
    ": 6-9 91 3-5 7-202 5-7 10-5 7-20 5-7 30-1 3-40 2-3 6-50 3-7 60-1 3 5 7-72 5",
    ": 8-85 9-90 3 6-301 3 5-6 8 11-2 7-9 22 4-43 6-9 52-3 5 7-64 7-8 70 3 5-7 80",
    ": 2-3 5-9 93-5 7-9 401-5 8 10-1 3 5 9-20 3-7 9-31 3 5 7 41 3 7-52 4 6-7 9 61-2",
    ": 4-5 8-9 72-4 9-83 6 8-91 6-9 502 4-8 12 5 7 20-1 3-9 35-6 9-43 5 7-9 52-4 6-7",
    ": 62-3 5-9 73 5-9 81-4 7-94 7-8 601-2 4-7 9 17 21-2 4-5 7 9-30 2 6 8-9 41 3-51",
    ": 7-61 7-8 70 2-81 3-4 9-91 4 7-8 703-5 7-9 14-7 20-3 7 9-30 3-41 7 9-51 3 5-61",
    ": 7-71 3 5-6 9-80 2-3 6-8 91-5 7 800-1 4-5 7-8 10-23 6-30 5 7-40 3 9 51-62 6-8",
    ": 74 8-82 5 8-90 2-3 5-8 900 2-5 8-9 11-4 6 8-22 4-8 33-4 6 8-45 7-8 52 5 7-61",
    ": 4-8 71 3 5-7 80-1 4-6 8-94",
    ": 7-7006 8-14 7-9 22 4 9-30 4-5 9 41 5 7-50 4-5 8-66 9-74 7 9 82-101 3-7 11 3",
    ": 6-8 20-1 7-36 40-1 3-7 9-50 2-4 8 60-3 6-7 70 2 5-6 9-80 4-90 2 4-8 200-2 5",
    ": 7-8 10 4 6-20 3-4 6-34 6-7 9-41 5-7 9-51 4-7 63-71 4-9 81-4 91-2 6 9-300 3",
    ": 5-8 12 4-8 20 3 6-8 32 4-7 42-5 8-50 2-3 5 7-8 60 6 8-71 3-5 8-80 3-6 8-91 3",
    ": 400-2 4-7 10 4-7 20 2-7 9 32-3 5-40 2 6-7 50-1 4-8 60-1 3-7 9 71-5 7 9-84 6-9",
    ": 91-4 7-9 502-4 6 8 12-8 20-4 6-9 31-4 6 8-40 4 6 8 52 4-5 8-9 61-2 6 70-5 8-9",
    ": 81 3 5-6 90-9 601 4-7 11 4-5 7-9 23-5 30-5 42-5 7 9-50 2 6-9 63-5 7-73 5-8",
    ": 80-8 90-1 4 6 8-9 702-10 3 5-9 21-5 7-8 30-1 3 5 7-8 40 5-9 53 5-6 60-6 9-73",
    ": 5-6 8-91 4-5 7-9 801 3 9-12 6-23 5-8 30-1 3 5-41 4 6-7 50 2-3 5 7 9 62 5-6 8",
    ": 71 3-4 8 81-4 6-8 91 3-5 7-900 2-3 6 8-9 16 8-22 6 8-38 40 2-5 7-50 3-6 60-5",
    ": 7-8 70-5 8 80-4 7-91 3-4 6",
    ": 9-8001 7-10 3-6 8-24 7-8 30-1 3 6 8-44 7-51 3 5 8-60 2 4-8 70-1 3-9 81-2 6-7",
    ": 90-5 7-100 3-13 5 7 9 21-4 8-9 31-8 40-2 6 8-9 51-4 6-7 9-60 2-7 9-70 5 7",
    ": 9-80 2-7 92 4 9 201 8 13-6 8 20-1 3 5-32 4-5 8-43 5-8 50 2-3 6-62 6-7 9 71-2",
    ": 6 83 5-90 3-5 7-9 301-3 5-10 2-3 6-8 20 5-7 9 31 4 7-42 4-5 7-9 52-7 60 2-4",
    ": 6-71 3-5 81-90 2 5-401 3-14 6-9 22-5 8 30-1 8-9 42-6 9-56 60 3 5-6 71-3 6",
    ": 80-3 5-7 9-91 4-5 7 501-4 8-14 6 20-4 6 9-31 3 6 8-41 3-9 51-3 5-8 60-1 3-4 6",
    ": 9-71 4-88 90 4 9-601 3-4 6-8 10 2 5-8 21-3 5-7 30-4 6-40 2-4 7-55 7-62 6-70 3",
    ": 6-7 9-83 8-9 91-3 6 8-707 10-2 4-9 21-2 6 9-32 8 40-1 6 51-3 7-74 8 83 5-6 8",
    ": 90-6 8-805 7-10 3-5 7-21 3-5 8-31 3 5 8 40-1 3 6-7 9 51-6 8-63 5 72-5 9 81-3",
    ": 5-9 91 3-7 9 901-5 7-9 11 3-7 9-21 7-9 32-3 6-41 3-58 60-1 4-8 71 8 80 2-3",
    ": 6-8 94-5 7-9",
    ": 9001 3-4 6-7 9-10 4 6-7 21-2 7 30 3 5 7-8 42 5-8 50-1 3 9-60 3 5-7 9 72 4 7-9",
    ": 82 5 9 91-9 102-7 9-11 3-7 9 23 5-8 30-3 5-8 40 2 5-6 8-52 4-5 7-9 61-5 7",
    ": 71-3 6 9-80 2-5 7-90 3 5 7 200-2 4-5 7 10 3 5 7-24 6 8-31 4 6 8-44 7 9-51 3-5",
    ": 8 63 5 8-74 6 80-2 4-7 9 92 4-5 300-3 7-13 5-7 21-6 8 30-2 4-6 8-40 2-7 9-50",
    ": 4 8-60 3 5-7 70-1 4 7-80 4-96 9-401 5-8 10-5 7-20 4-7 9-30 5 7 9-44 6-50 2-6",
    ": 9 64-71 3-4 6-8 83-5 8-9 92 4-6 8-500 2 5-11 3-5 7-8 20-9 32-4 6-7 9-42 4 6-7",
    ": 52-4 6 62-4 6-8 70 2-5 7-83 5 7-91 4-7 601 6-8 14 6-21 3 7 30 3-6 42 4-52 4-5",
    ": 9-60 2 5-7 70-3 5 8-85 90 2 5 702-4 6-8 10 4-9 21 3-6 8-9 32 5-9 41-5 7 50",
    ": 4-9 62-74 6 8-84 8 90-5 7-8 800 2-3 6 8-10 2-5 7 9-22 7-8 30-2 4-6 9-43 7",
    ": 9-54 7-63 5-7 9 73-4 8 80-2 9 92 5 901-4 6-8 10-3 5-23 30-9 41-3 5-6 8-53",
    ": 7-60 2-3 5-72 4-5 8 82-3 6-8 92-4 6-8",
    ": 40000-6 15-6 9 21-4 6-7 30-1 5-6 8-9 41-8 50-3 6-7 60-9 71-4 8-92 4-9 101-3",
    ": 13 6 20-3 5-6 30-1 5-48 51-2 4-66 73-4 6-81 4 8-9 91-4 6-7 200 3 5-9 11-2 4-5",
    ": 7-9 21 3-7 31-5 8 43-52 7-60 3-5 9 71-3 5-6 9-83 5-90 4-7 9-303 6-8 14-9 22-4",
    ": 6-9 32 6-7 40-2 5-6 9 51 3 5-8 61-2 6-7 71-5 8-9 81-8 92 5 7-8 401-7 11-3 6-7",
    ": 9 21-5 9-31 4 6-8 40 2-7 53-5 9 61-4 6 9-73 5 8 80-1 3-7 9-93 5 7 500 8-12",
    ": 4-7 20-5 8-9 32 6 8 42-50 5-60 3-5 8 71-3 9-84 7-9 91 3 5-601 4-6 8 12-22 4-8",
    ": 30 2 5-6 8-9 43-8 50 3-5 7-8 60-1 6-75 7-8 80-5 7-9 91-8 700-4 6-7 10 2-20 2",
    ": 6 9-30 2 4-6 8-41 3 6-8 50-1 4 6-9 63-5 7-8 70-2 6 8-81 3 6-7 90-1 3 5-8",
    ": 801-2 4-5 7-9 14-20 2-6 8-31 5-6 9-44 7-8 52-6 61-9 73-9 81 3-5 7-9 92 4-6",
    ": 8-900 4-7 10-2 5-8 21 3 7 30 7 40 2-5 8-9 52 4-5 7-70 3-4 6-83 6 8 90-1 4-6 9",
    ": 1001 3 5 7 9-10 2-3 5-7 9-20 2 4 30 6 40 2-6 9 51-3 9 61-5 7 9 73 7-9 81-3",
    ": 5-91 3-4 6 8-9 102-4 8 14-6 9 22 4 6-31 3 5 8 42 4-51 3-63 5 7 9-70 3-5 7-8",
    ": 80-2 5-7 9-90 2 5-7 9 204-5 7 11 5 8 21-2 4-8 30-3 6-9 41-5 8 51-2 5-6 8-60",
    ": 3-4 7 70-6 8-9 82-3 6 9-91 5-7 9-300 3-4 8-11 3-5 8-21 3 5 7-9 31-4 6 8-40",
    ": 5-9 51-4 8-64 70-1 5-7 81-3 5 9-90 2 4-6 8-403 5-6 12-20 3-5 7-33 6-7 44 6-53",
    ": 5-61 5 7-9 71 5 7-80 3-4 8-9 91 3-4 6-7 9-503 6-9 12-7 22-5 7-30 4 45-6 53-4",
    ": 7-60 2 5-7 9-70 5 7 80-1 3-6 8-91 3 8-608 10-5 8-21 3 5-6 9 31-2 4 6-7 9 41-6",
    ": 50-1 4-5 7-62 4-5 7 70-2 4-7 9-80 2-3 6-90 2 6-7 9 701 9-11 5-7 9-23 6-33 5-8",
    ": 40-7 51-2 6-9 63-6 8-9 71-2 4-5 8-82 5-6 9-90 3-4 7-9 802 4-9 12-7 9-20 2 5-9",
    ": 31-5 7-8 41-2 4 8 51-2 6-7 9-60 3-6 70-2 5 7-8 82 5-7 90-2 4-5 8-9 903-5 7-8",
    ": 10-3 6 8 20-2 4 6 8-33 6 9 41 3-5 7-9 51-5 7 60-7 9 74-6 81 3-5 9-91 5-7",
    ": 9-2000 5-7 9 11 3-25",
    ": 8041274 8-80 3 5 7 9-91 3-8 300-3 5 7-8 11-6 20 3-6 9 32-44 6-8 50 2-6 9 61-2",
    ": 4-6 8-77 81-3 6-7 9 93-5 401-4 6 10 4-25 7-8 31 4-5 41-2 6-8 50-8 60-1 3-71",
    ": 3-5 8-82 4-9 91-4 6 8 500 2-3 5-10 2-4 9 21-2 4-9 31-2 5 7-40 2 5 7-50 2-3",
    ": 64-6 9-78 80-4 6-7 90-5 9-605 7-11 3 5-20 5-8 30 3 5-41 4-7 53-4 7-60 2 6",
    ": 70-3 5 7-81 3-4 6-8 90 2-3 7 9-704 6-9 11-2 5 7-20 3 6-30 2-4 7-41 4-7 9 51-2",
    ": 4-60 4-5 9-72 6-8 80 3 8 90 2-4 6-7 800 2-4 6-7 9-16 8-21 3-4 6-9 31-2 4-5 7",
    ": 41-3 5-7 9-52 5 8 64-5 9-70 5 7 9 81-4 6-90 3-7 9-902 4-6 8 10-2 4-5 7 9-20 3",
    ": 7 32-5 7 42-6 8-9 51-2 4-8 60-2 4-9 71 4-6 8-81 5-6 91 3 6-7",
    ": 9-2000 8 10 4-21 4 6-8 31-2 4 6 9 41-6 8-55 8 60-1 3-8 70 2-4 6 8 80 2-3 5-7",
    ": 90 4 6-8 100-6 8-10 2 4-5 9 22-4 8 30 2 5-6 8 40-2 5-6 9-51 3-5 7-8 60-1 3-74",
    ": 9-80 2 4-6 90-1 4-6 8-207 9 11-3 6 20 2-8 33-6 8-40 2-6 9-57 9-61 3 8-9 71-6",
    ": 80-3 6-7 9 92-7 9-301 3 7 9 12-6 9-21 5 39-40 3-5 7-8 51-2 4-5 8-9 61-2 4-5 9",
    ": 72-3 9-80 2-5 7 91 7-401 3-7 9-10 2-7 9 21-2 7 9-39 41 4 6 8 52 4-7 9 61-2 4",
    ": 6 8-9 71-3 5-7 9-81 3 5 8-98 500-1 8-9 11-3 5-6 8-9 21 3 5-7 31-2 5-7 40 2-3",
    ": 5-8 50-3 5-7 9 62 73 6-7 9-82 7-9 93-7 600-2 5-10 4-6 8 21-3 5-32 4-40 2-4",
    ": 6-9 51-3 7-68 70-4 6-80 3-5 7-9 92 4-9 704 10-1 3 5 7-8 22-5 7-31 3 5-6 9-41",
    ": 4 6-65 8 70-1 4-6 8-81 3 5 7-90 2-5 7-8 800-2 5-7 9-12 20-2 4-5 7 9-42 7 50-1",
    ": 3 5 7 9 62-3 5-6 8-9 71 4 6-7 81-3 6 8 91 3-7 9-900 2-8 12-9 23-7 30-5 7 9-46",
    ": 8-9 52 5-7 9 61-6 8-70 2-4 6 8-9 82-3 5-6 8-90 2 4",
    ": 6-3002 4 6 10 2-3 5 7 9 21-3 5-33 5-7 40-1 3-5 9-52 8-60 2 4 6-7 9 71-4 6 8",
    ": 85-6 8-9 91-3 8-9 101-10 3 5-6 8 20-9 31-4 6 8-41 3-5 7-9 51-2 4 6-62 4 7",
    ": 72-3 6-8 80 2-4 6-9 95-202 4-5 9-13 7 20-1 3 5-6 30-9 43-8 50 2-3 5 7-8 60-2",
    ": 4-6 8-74 6-80 2-3 5-6 8-91 3 5-6 8 302-6 10 2-3 5-6 9-22 5-6 9-31 4-6 8 41 3",
    ": 5-6 8-9 52-3 5 7-62 4-5 8-9 71 5-8 81-4 6-90 2-4 7-9 401-8 11-5 20-2 5-7 9-46",
    ": 9-50 2 4 8 60 2-5 7-8 72-3 5-9 82-5 7-9 91-2 4-8 500-2 5-10 3-5 7-8 20-3 5-7",
    ": 9-34 6 8 43 5 7 51-4 7-8 60 2 4 6 8-70 2-3 6-7 80 3 5-8 91-3 6-8 601 5-9 14-6",
    ": 9-23 5 7-9 32 4-6 8 40 2-3 5-6 8-53 5-7 61-7 9-73 7-8 80-7 9 91 3-5 7-700 2-4",
    ": 6 9-14 7-9 21 4-8 30-2 4 6-8 41 3-6 8-9 52-4 6 8-62 4 6-8 70-5 7-82 4-7 91",
    ": 3-5 7-800 3-4 6 11 4-5 7 20 2-5 7-30 2 4-5 44 6 8-9 52-3 6-7 60-1 3-8 71-4",
    ": 80-1 4 6-90 2-5 8-9 902-18 21-4 6 8-31 3-6 8 40 2-4 7-8 50-60 2 4-6 8-9 72-7",
    ": 9-86 9",
    ": 91-4000 2 4-8 12 5 7-21 4-5 7-30 2-5 7 9-40 2-53 5-7 9-60 3 5 7-8 70-2 4 6",
    ": 8-81 3-8 92 4 8-100 2 4-6 8-10 3-4 6-20 5 9-31 3 6 8 40-1 3-4 6 9-51 3-5 7",
    ": 9-63 5-6 8 70-6 80 3 6 8-91 3 5-7 9-202 4 6-7 9 11-3 6 8 21-4 9 39 47-8 50-1",
    ": 4-6 9 61 3 5 7 9 73-9 81 3 6 8 93 7-8 302-4 7-12 4 6 8 20 3-5 7 30 2 4 40 3",
    ": 5-52 4 6-8 60-7 9-70 2-3 5-6 8 80 4-5 7-8 90 3 5-6 9 402 4-6 9-15 7-9 21-2",
    ": 5-7 9 33-6 8-9 42-3 5-51 5-8 60-1 4 6-8 71-2 4-6 8 80-3 5-7 9-90 3-7 9 501",
    ": 3-5 8 10 4-21 4-7 31 3-5 8-9 41 3-5 50 2-3 5 7 66-7 9-73 5-9 82-8 93-6 8",
    ": 602-5 7 11-23 5-6 8-31 7-8 40-9 51-3 7 9-60 3-5 8-9 71 6-7 9-82 4-9 95-6",
    ": 700-4 6-13 5-6 8 20-3 5-8 30-42 4-9 52-61 6-73 6-8 81-3 6 8-91 4-801 3 5 7-8",
    ": 10-1 4 6 9-22 4-32 5-7 40 4-5 8-9 51-2 4-8 61-5 7-9 71-2 4-5 7-8 80 3-5 7-9",
    ": 93-4 6-7 903-5 7-8 10-3 5 8-29 31 3 5-9 41 3-4 7-50 2 6-70 2 4-5 7-8 82-5",
    ": 7-90",
    ": 2-5000 3 5-6 8-12 4 9-21 3-5 8-32 4-5 8 40-2 4-5 8 50 3-4 6 8-60 2 4-70 2-4",
    ": 7-8 80-1 3-9 92 4-7 9-101 3-5 7-10 2 4-5 7 9 26-30 3-8 40-2 5-7 9-50 2-62 5-6",
    ": 8-74 6-7 9-80 2-7 9 91 4 6-201 3-6 11-3 5 7-8 20-36 41-2 4 6-7 50 2-7 60-6 70",
    ": 3 5-81 3-4 6 8-92 4-5 7-9 301-3 5-7 9-16 8-9 21-5 7-36 9-41 3 5-9 51 3 5-7 60",
    ": 4 7 70-84 6-90 3-403 5-7 9-11 3-4 20-4 6-7 30-4 6-46 8 50-1 4-6 8-9 61-3 5-71",
    ": 3-8 80 2 5-9 91-2 5-501 3-6 8-12 4-6 9-20 2 5-9 32 4 6-46 51 4-6 60 2-4 9-77",
    ": 82-3 5-7 9 93 6-7 9-600 3 6-8 11-4 7 9 24-30 4-9 43-7 9-52 4-5 7-60 2-4 6",
    ": 8-74 6-7 9 82-6 8-9 92 4-8 701-3 7 10-21 6-7 30 2-5 7 9-40 3-4 6-52 4 9 61-5",
    ": 7-72 5-7 9-80 3 6 8-9 91-2 7-9 801-7 9-13 5-7 22-4 6-9 32 4-7 40 2-4 6 8-51",
    ": 3-6 9 61-5 7-8 71 3 5 7-84 6 9 91-2 5-902 4-5 7-11 4-5 9 22-5 8-30 2 4-43",
    ": 5-51 3-7 60-1 8-70 2-6 8 80-1 3-6 8 90 5-6 8",
    ": 6001-3 5 9 13-8 20-3 5-6 8 30-4 6-42 4-9 51 4-5 8 60 2 4 7 9-70 2 80 2 8 90 5",
    ": 8-9 101 7-8 10 4 7 21 4 6 9 31 3 6 8 40-1 4 8 50-1 5 7 60 9 72 4 6 8 82 6",
    ": 8-90 3 7 9 201 3 7-8 11 4 6 9 21 3 6-7 30 2-3 5 7 43 7 9-50 3-5 8 60-1 3 5 7",
    ": 71 6-7 9 82 4 91 3 5 7 9 302 4 6 8-9 11 3 5 7 23 7 30-1 3 6 40 6 8 53 61 8",
    ": 76-7 9 91-2 6 8 401 3 5 9 12 4 7 9-20 3 5 9-30 2-3 7-8 41 7 51-2 8 61 3 5 7 9",
    ": 71 7 9-80 3 5 7 9-90 2 8-9 501 3 5 11 3 5 8-9 22-4 7 33 45 7 9 53-4 6 8 60-1",
    ": 9 75 9-81 3-4 6-9 603 9-10 3 20 6 8 31 3 5-6 8 43 5 54 6 8 60 4 8 70 2 4 9-80",
    ": 4 6 9 96 8 700 11 7 9-20 6-7 30 2 6 41 3 5-6 8 50-1 3 6 8 65-6 72 4 6-7 83 5",
    ": 8-9 96 9 801-2 4 9-11 3-4 20-1 5 8 30 2 4-5 7 9 41 3 5-7 9-51 3-5 9 61 3-7",
    ": 9-72 4-5 7 9-81 3 7-9 91 7-8 900 3 10 3 5 7 9 21-2 6 9 33 8 42 4 6 8 50 5 7",
    ": 61 3 5 7 71 3 5 7-8 80 2 7-8 92-4 7",
    ": 7001 6-7 9 11 3 7-8 22 4 8 30-2 4 6-7 43 6 8-9 51 3 69 71 3 7 84 6 9 93 8 100",
    ": 5 7-8 10 2-3 21 3 5 34 7-8 40-1 7 9-51 3-4 65 8-9 71 3 5 84-5 92 5 7 9 201 3",
    ": 9 12 4-5 20-1 6 8 30 2 6 8 44 6 8-9 52 4 6 8 67 9 77 9 84-5 7 300 3 5-6 8 10",
    ": 2 4 6 8-9 21 3 9 31 4 6 8 40 4 8 51 8 60-1 3 6-7 9-70 2-3 5 82 7 91 3 5 7",
    ": 401-2 4 7 9 11 5 7 9 24 6 9-30 2 4-5 43-4 6 8 50 3 6 8-9 61 3 7 71 3 8 82 6",
    ": 92 4 9 501 3 5 7 11-5 7-8 21 32 6-7 40 2-3 5 7 9 57-8 67 9-70 2 6 80 2 4 7 92",
    ": 8 600-1 4 7 16 22 9-30 3-4 6 8 43 5 7 51 8 63 8 70 2 4-5 7 83-4 9 91 3 6 702",
    ": 8 10 2 6 9 21 4 9 31 4 7 41-2 4 8 50-1 3-4 6 8 61 4-5 9 72 4-5 7 9 81-2 5 7 9",
    ": 93 8 800 6-7 10 2 6-7 9 21 9 32-3 5 9 42 8 52 7 9-60 2 4 6-7 9-71 3 6 8 80 2",
    ": 4 7-8 90 3 5 7 9 901 3 5-6 9-10 2 4 6 20 2 4 6 8 32-3 5 42 4 6 8 52-4 6 9",
    ": 61-2 5 8 70 3 5-6 8-9 81 3 5 9 91 4 8",
    ": 8000-1 4 6 8 10 3 5 8 20 2 5 7 9 35-7 9 41-2 4 6 50-1 3 8 60 4-6 71 3 81 3 5",
    ": 7-8 90 2 7 106-7 12 9 21 3-4 6 32 4 43 7 9 51 3 5-6 9 61 4 7-8 70 3-4 6-7 9",
    ": 81 3 5-6 8 90 2-4 200 2 4 12 4 6 8-20 2 5 30 3-4 44-5 51 5 7 61 71 3 5 7 9 81",
    ": 3 7 90 2 4 6 8 300-1 4 8 10 2 7 20 4 30 2 5 46 56 8 62 4 6 9 72 4-5 7 9 82 5",
    ": 7-8 91-2 6 8 400 3 5 15 7 9 23 7 30 4-5 7 41 5 51 3 5-6 8 60 3 7 9 83 5 9 94",
    ": 7 9 502 5-6 9 11 3-4 7-8 20-1 6-8 30 2 6-7 9 41 3 5 7 9 52 4 9 61 3 5 73 5 80",
    ": 3 5 8 92 5 8 603-4 9 13 5 8-9 23 8 30 2-3 5 7 41 3-5 7 9 51-2 5-6 60 4 8 71-2",
    ": 4 6 8-9 81 91 3-4 6 8 701 3 5 9 11 3 7 22 4-5 30 7 43 6 50-1 3 6 8 62 4 9 72",
    ": 4 6 81 3-4 7 9-90 2 5 8 801-2 4-5 7 10 4 6 20-1 7 9-30 2 4 6 9 52-4 6 8 60-1",
    ": 4 7 9 71 4 6 8 80 3 5 7-8 90 6 9 915 8-20 2-3 5 7-8 30 2 8 40 2 6 50 2 4 6-7",
    ": 63 6 8 70 80 5 92 6-7",
    ": 9002 11 4 6 23 5 7 30-1 3 5 40-2 4 6 9 51 3-4 6 62 6-7 9 71 3 5 80 3 5 7 9",
    ": 91-2 5 7 9 101 6 9 11 7 21 3 5 7 31 3-4 6-7 9 41 3 5-6 8 50 2 6 8 60 2 4-5 71",
    ": 3-4 7 80 4-5 90-3 5 8 200 2 6 10 2 5 7-20 30 8 40 3 5 7 9 51 8 60 3 8-9 71-2",
    ": 5 81-2 4 6 90 2 5 7 9 306 8 16 20 6 8 30 2 4 6 8 40 5 9 51 3 7 9-60 2 5-6 8",
    ": 74 9 83 5 8 90-1 8 406 8 10 6 8 21 3 8 30 3 6 8 40-1 3 50-1 3 6 8 69 73 5 7",
    ": 80 2 5 94 6-7 502 6-7 9-10 22 6 9 34 8 40 2 4-5 7-8 50 3 7-9 61 3-4 6 81 3 5",
    ": 9 92-4 6 8 600 3-4 9 11 5 7 20 2 6 9 32 4 6 9 44 7 9 51 8 60 7 9 73 9-80 2 4",
    ": 6 8 94 8-9 701 5 11 4-5 9-20 2 6 8 31-2 4 41 3 5-6 51 5 9-60 3 5 8 70-2 4 6",
    ": 80-1 4 6 8 91 4 9 801-2 4 6 8-9 11 3 5 7 9 21-2 4 6 8 32 4 7-8 40 5 7-8 50 2",
    ": 4 6 8 60 2 4-5 7-8 73 82 4-5 7 93 5 7 902 4 6 11 4 8 20 5 8-9 32 4 9 41 3 5",
    ": 7-8 51 3 5 8 60 4 6 9 71 3 5 9 85 7 91 5 7 9",
    ": 50001 3-4 6 9 11 4 6 8 22 5 7 9 31 4 40 3-4 51 9-60 6 8 71 4 6 8 80 4 6-7 9",
    ": 93 100 6 8 15 9 23 5 9 36 8 42 4 9 53 8 60 2 6 70 2 4 81-2 4 6 9 91-2 6 9 202",
    ": 4 11 3 5-6 8 20 2 4 30 2 4 8 40-1 3 5 7 9 53-4 9-60 6 9 71 3 5-6 9 83 5 7 9",
    ": 95 304-5 12 5 23 33-4 7 9 43 5 7 53 9 64 73 5 8 82 4 9 91 3 5 9 401 10 2 21 5",
    ": 7 33-4 6 8 40 3 5-6 50 3 5 7 60 2 4 6 8 70 2-4 6 9 81-2 4 6 8 92 7 9 501 3-4",
    ": 7 10-1 3-4 22 5 7 9 31-2 4 6-7 9-40 3 5 7 9 53-4 6 9-60 4-5 7 9 76 8 80 2 6-7",
    ": 9 91-2 8 604 6 12 4-5 7 9 22 4 9 32 5 7-8 42 4 6-7 55 7 63 5 7 9 71 3 7 9",
    ": 83-4 6 90 3 5 8 700 2 4-5 9-10 2 6-8 25 30 4 8 40 2 7 9 53 5 7 63 7 9 71 6 80",
    ": 6 8-9 93 7 802 4 7-9 11 3-6 8-21 5 7 36 8 40 2 4 6 8 50 3 5 7 63 5 7 71 3 6",
    ": 80 2 6 9 91 7 9 901 13 5 24 7 9 32 41 5 7 50 3 5 7 9 63-4 71 4-5 9 85 90 2",
    ": 6-7",
    ": 1001 3 5 8 10 2-3 22 6 8 30-1 4 44 50 4 8 64 6 8-9 73 5 7 9 84 6 90-1 4 6 8",
    ": 100 2 4 7 9 11-2 4 6-7 9 21 3 5 7 30 5 9 44 6 8 50 2 4 6 8 60 2 4 7-8 70-1 3",
    ": 6-7 80-1 3 5 7 93 9 204 6 8-9 11 3 21 30 5 7 50 2 4 6 62 4 8 72 6-7 9 81-2 6",
    ": 9 92 304 6 8 17 23-4 6 8-9 35 40 4 6-7 54 6 8-9 63-4 9 75 7 82 5 90 2 4 6-7 9",
    ": 401-2 4 8 10 2 4 8 20 2 4-5 7 34 8 40 2 4 6-7 9 51 4 7 9 62 6-7 9 71-2 4 6 81",
    ": 7 9 92 4 8 500 2 6 13 5 7 9 21 3 9 31 5 40 2 4 6 8-9 54 9 61 3 70 2 4 6 8 83",
    ": 5 8-9 91-2 7 9 601 3 5 9 11 3 9-20 4 6 30 2 42-3 5-6 8-9 60 2 4 6 8 76 8 80 2",
    ": 90 2 4 700 4 8 10 2 25 7 9 33 40 4-5 50 5 7 65 9 71 5 9 84-5 7 96 8 802 9 13",
    ": 21 3 5 9 38 41 3 6-7 50-4 7 9 61-2 4 8 74 8 80 2 5-7 94 6 901 3 7 9 13 5 7 9",
    ": 21 6 8 32 9-42 4-5 9 55 7 9-61 8 70 2 4 6 8 80 3 6 90-1 6 8-9",
    ": 2001-2 8 12 6-7 20-2 4-5 7 9 31 3 5 8 46 50 5 7 9 61 5 9 75 7 85 7 9 91 3 7 9",
    ": 104 6 8 10 2-4 6 20 3 5 8 32-3 41 58 75 8 81 3 6 8 99 203 5 7 9 18 20 2 31 3",
    ": 6 8 40 4 6 8 56 62-3 6 8 73 8 80 5 7-8 90-1 3 5 7 9 305 7 10 8 20 2 4 6 8 30",
    ": 5 7 9 41 3 7 9 52 4 60 2 4 6 8-9 71 3 5 7 9 84 9 91 5 7 403 10 2 5 7 9 23-5",
    ": 30 4 7 9 41-2 4 8 50 2-3 5-6 8 60 3 5 70 2 6-7 9 81 3-4 6 9-90 2 4 7-8 500",
    ": 2-3 5 11 21-2 4 6-7 34 7 48 52 6 8 61 70 7 9 83 7 9 91-2 5 7-8 605 9 16 23 7",
    ": 9 31 3 5 7-8 40 2 6 8 50 6-7 9 61 3 5 7 9-70 2 4 7 83-4 6 8 90-1 3 5 8 700 3",
    ": 5 11-2 9 21 6-7 32 4 6-7 45-6 8 51 3 7 61 3 5 7 9 73-4 6 8 80 2 4 8 90 6 801",
    ": 3 8 10-1 3 5 8-9 21 4 6-7 32 44-5 7 9 51 3 62 7 74 6 82 90 2-3 7-8 902 4 7 11",
    ": 3 5 8 28-9 31 6 48-9 53-4 6 9 61-2 4 9 71 3 5 7 9 81 95 8-9",
    ": 3002 6 13-4 6 9 21 3 9 32 4 6 42 4 6 50 2 4 8 60-1 3 5 70 5 9 83 9 93-4 7 9",
    ": 101 7 11 3 5 7 9 21 3 9 31 8 42 4 9 52 4 6 8 60 2-3 5 7 70 2 4 6 9 81-2 6-7",
    ": 96 8 200 2 4 6 8-9 11 4 7 9-20 2 30 3 8 40 5 7 9 51 3 5 7 60 2 4 6 8 70 2 4",
    ": 6-7 83 5 93-4 6 8 302 6 8 10 4 20 2 36 8 42 7 51 3 6 8 61 3 6 8 70 2 86 93 5",
    ": 7 9-400 2 4 6 8-9 12 5 8 23 5 9 31-2 4 6 8 42-3 5 7 51 4 6 60 4-5 71-2 8 83 5",
    ": 9 91 506 9 18-9 23 5 30-1 3 7 9 43 5 7 9 51 9 61 3 7 71 7 83 7 91-2 4 6-7 609",
    ": 20 4 7 31 3 5 7 46 8 50 3 5 7 66 71 3 81 90 5 701-2 4 6 12 4 6 8 20 6 9 33 6",
    ": 9 41-3 6-7 9 55-6 8 60 2 6 8 71 3 6 9 83 5 7 9 91-2 4 8 810 2-3 8 20 6 8 31 9",
    ": 41 3 5-6 8 50 3-4 6 60-2 4 8 70 2 5 9 81-2 4 8 90 2 4 900 2 8 10 2 4 6-7 20-1",
    ": 4 8 30-1 5 41-2 4-7 52 6 61 5 7 9 71 3-4 6 8 82 4-5 7-8 90 2 6 8",
    ": 4000 2-3 5 7 9 11 5 21 3 5 8 30 2-3 7-8 42 4 6 50 4 6-7 9-60 3 6 72-3 5 81 3",
    ": 7-8 90 2 4 8 100 5 7 12-3 5 8 24 6-7 32 4 6-7 41 3-4 6 52 4 8 61 9 74 6 8 80",
    ": 2 4 90 3 200 7 9 11 3 8 22 31 3 9 42-3 5 7-8 50 5 7 64 9 73 7 87 95 7 9 301 4",
    ": 6 10 3 5 20 4 8 30 2 4 6 8 42 4 8 53 60-1 6 73 5 86 91 3 5 7 9-400 2 4 10 6",
    ": 8-9 22 4 6 8-30 2 4 7 9 41 4-5 9 51 8 60 5 7 74 80 2 4 7 9 93-4 6 8 500 2-3 6",
    ": 10 2 4 9 21 3 5 7 9 31 3-4 40 4 50 5 63 5 7 9-70 2 4 81 3 5 7 9 91 6 8 602 20",
    ": 2 4 30 4-5 7 9 41 3 5 7-8 50 2 4 61 4 6 8 70 2 6 8 84 6 8 92 7 9 701 5 9 15",
    ": 20 2 4 6 8 30 2 7 41 6 8 50 2 5 8-9 61 3 9 74 8 80 2 5 7 9 92 5 9 802-5 7",
    ": 9-10 2 4 6 8 20 4 7 9 33 40 2 6 9-50 6 8 61 3 7 9 72 83 90 2 6 8 900-1 3-4 7",
    ": 9 13 5 9 23-4 6-7 9 31 7 9 41 4 8 50 63 6 9 75 7 9 81 3 5 9 92 6 8-9",
    ": 5001 3 6 8 11 3 5 7 9 21 4 6 31-2 4 9 41 3 5 7 9-50 2 61 3-4 6 73 9-80 2 4 6",
    ": 8 90 2 6 9 103 5 7 9-10 3 5 7 9-20 2 6 9-30 2-3 5-6 9 41-2 6 50 2 4 6-7 64-6",
    ": 8 70-1 7 81 7 91 3 202-3 5 7 9 11 3 7 21 3 31 5 7 9 42 4 8 50 2 4 6 8 60 2 7",
    ": 73 8 80 2-3 8-9 91 3 6 8 300 2 8 11 4-5 7 20 3-4 6 8 32-3 5 7 9-40 51-2 6 8",
    ": 60 3 5 7-72 4-6 81 91 5 7 9 406 8 10 2 4 6 20-1 5 9 31 5 42 6 8 52 8 60-1 3 5",
    ": 73 7 82 6 8 90 2 4 6 8 500 2-3 5 7 13 7-8 20 2 5 7 9-30 2-3 7-8 40 4 6 51-2 4",
    ": 6 8 63 7 9 71 4-5 8 80 2-4 7-8 92 4 7 9 603 6 8 10 2-3 5 7 20 2-3 5 7 9 32 7",
    ": 9 43 50 6 8-9 61-2 4 6 8 72-3 5-6 9 94 6 8-9 703 5 7-9 12-3 5 20 2 6 8-9 33 7",
    ": 40 2 4 6-7 9 52 4 6 9 61 4 70 2 8 82 5 91 3 8 800 2 6-7 12-3 6 8-9 21 3 7 35",
    ": 7 41 5 59 61 3 7-8 70 5 9 81 3 5 7 9-90 2 4 7 9 902 4 13 6 20 4-5 7 33 5 8 40",
    ": 2 4-5 8-9 58 60 2 4 7 73 5-6 8 87 9 93-4 6 8",
    ": 6000 5 7 14 6 25 7 30 2 6 8 42-3 5 7 56 61 70 2 4 7 81 3 7 90 2-3 5 7 9 103 5",
    ": 7 19 21 8-9 31 43 55 9 61 5 71 3 5 8 84 7 9 92 4 202 5 7 11 3 6 8 20 6 8 30 2",
    ": 4 8 46 8 50 2 5-6 8 60 9 71 3-4 7 9 83 5 9 91 3-4 7-8 300 2 6 8 10-1 6 8-9 21",
    ": 3 6 8 30 2 4 6 8 40 2 5 8 50 2 4 6 60-2 4 7 71 7 9 83-4 6-9 98-9 401 3 7 11",
    ": 4-8 20 2 8 32 6 8 42 4 6 8 52 5 9 61 3 5 8 70-1 5 81 3 6 8 90 6 8 500 2 4 6",
    ": 10 2 4 6 20 2-3 5 8-9 31 3 43 7 51-2 5 7 61-2 4-5 7 9 71 5 9 82 4-5 7 9 91 9",
    ": 601 3-4 10 5 7 9 22 4 6 31 3 7 9 45 8 52 6 64 9 72 6-7 9 81 3 8 91 3 6 8",
    ": 700-1 5 7 9 11 4 6 8-9 23 6 9 35 7 9 45 7-8 50 2 4 8 60 4 6 9 71-2 82 5 7-8",
    ": 93 5 7-8 802 4 6 12 4 20 31-3 44 8-9 60-1 4 8-9 72 4-5 7 9 81-2 4 91 6 8",
    ": 900-1 5 7 10 4 21 3-4 6-8 33 5 7 9 41 6-7 9 53 5 9 61 5 7 9 71 3 5 7 9 85 7",
    ": 93 6 8 7002 4 6 13 5 7-8 22 5 31 3 5 7-9 42 4-5 7 9 51",
    ": 99684 93 710 5 27 9 32 7 41 4 50 8 60 4 9 82 5-6 8 91 3 9 802-3 5 14 6 8 21 5",
    ": 7 9 34 6 8 40 3 7 55 7 9 61 3 6 70 3 5 7 87 90 4 7 901 3 6 15 7 9 31 45 7 51",
    ": 60 2 4 6 70 2 4 7 9 88 90 5 7",
    ": 100001 3 7 10-1 6 20 2 7 9 33 6 9 43 5 9 63 5 8 72 6 8 81 3 93 8 100 19 22 4",
    ": 7-8 34 6 8 42 4 8 50 2 8 60 2 4-5 7 9 71 3 5 7 81 9 91 3 5 200 7 10-1 4 6 9",
    ": 21 8-9 31 3 41 7 56 8 61 3 5 7 75 7 84 6 8 90 2 6 8 301 8 10 3 5 7 22 5 33 5",
    ": 8 40 6 9 51 62 4 70 2 7-8 82 7 92 4 6 8 404 8 10 2 4 7 9 24 6 8 30 5 7 9 46",
    ": 52 4-5 7 9-60 7-8 71-2 4 7 9 81 3 5 7-8 97 502 4 6 8 10 2 9 21 3 7 31 3 5 7",
    ": 42 8 50 2 8 60 2 9 71 3 5 8 80 3 90 3-4 6 600 5 7 12-3 5 7 9 24-5 7 36 8 40",
    ": 50 2 9-60 2 4 6 9 71 5 7 83 8 90-1 3 5 7 9 701 3 5 7 9 14 6 8-9 21 4-5 7 31 5",
    ": 8 40 5 52 7 62 8-9 71 5 9-80 2 91 3 5 7 9 804 9-10 2 4 6 8 20 2 4 8 30 2 8 40",
    ": 7 51 5-6 63 6 74 6 8 80 2 4 6 8 91 3-4 8 900 2 4 7 9 14 6 8 25 7 9 31 3 5 7 9",
    ": 41 3 7 9 59 61 3 6-7 70 80 5 8 90",
    ": 1004 17 22 9 34 6 40 4 6 8-9 51-2 5 7 9 72 5 7-8 88-9 97 104 6 8 12 5 9 23 8",
    ": 30-1 5 7 9 41 8 50 60-1 6 8 81 3 97-8 202-3 7 9 15 9 22 4-5 7-8 36 41 7 9",
    ": 56-7 75 80 2 9 91 3 5 9 313 8 20 8 30 4 9 45-6 50 7 9 62 4 7 70 2 4-5 7 9 81",
    ": 5 7 9 95 7-9 401 3 5 7 9 11 5-6 23-4 6 8 38 49 53 5 9 66 70 2 4 83 5 7 9 91-2",
    ": 4 6-7 9 501 5 8 11 3 5 7 9 21 4 7 9 31 3 5 9 41 3-4 6 50 2 4 7 9 61 3 5 72 4",
    ": 6 9 81 5 7 9 91 5 7 9 602 4 19 35-6 9 41 3 5 7 52 4 8 61 5 7-8 70 2 7 83-4 6",
    ": 90 4 6 703 5 8 10 6 8 20 4 6 32 5 7 9 41 6 8 50 6 60 2 7 71 3 6 83 7 90 4 6-7",
    ": 800 2 4-5 7 9 13 7 9 21 3 6 9 31 3-4 6 9 43 5-6 8 50 3 7 9 62 4 6 70 2 4 6 8",
    ": 83-4 7 9 92 4-5 9 901 3 5 7 11 4 21 5 9 31 5 8 44 8 50 3 62 7 78 82 4 6 8 91",
    ": 4 7 9",
    ": 2004 6 20 2-3 5-6 8 30 3 40 2 4 6-7 52 69 71 5 7 9 81 3 6 93 5-6 8 103 5 7 9",
    ": 11 6 8 20 2 4 8 30 5 41 5 9 51 3 74 6 80 2 4 6 8-9 92 4 6 8-9 201 3 13 5 22 7",
    ": 31 5 9 43 7 9 53 62 4 6 9 77 9 81 5-6 8 300 6 8 10 2 22 4 6 8 30-1 3 5 7 41 4",
    ": 6-7 57 9 63 5 7 9 71-2 6 85 7 9 92 7 400 5 11 9 21 5 8 30 9 45 7 9 53-4 7 61",
    ": 3 5 7 9 71 6 80 2 4 6 90 5 501 12 4 23 7 9 31 5 41 5 52 4 7 9 61 6-7 74 86 8",
    ": 90 5 7 601 3 9-10 6 25 7-8 30 2 6 8 40 2 4 6 8 52 4 8 61 3 5 7 9 71-2 4 6 8",
    ": 80-1 90 2 9 701 3 5 7 11 3-4 7 9 30 4 40 2 4 6 8 53-4 8 61-2 4 6 8 73 8 80-1",
    ": 9 94 811 8 20 6 8 30 2 4 9 41 3 5 8 54 7 9 61 6 8 76 83 9-90 900 5 7 9 13 24",
    ": 33 7 41 3 5 56 61-2 5 72 6 8 84 91 3 5 9",
    ": 3002 4 6 13 5 7 9 22-3 32 4 8 40 2 4 6 61 72 81 3 5 7 9 92 4 6 8 100 3 8 10 2",
    ": 5 7 9 21 5 9 32-3 6 8 40 6 55-6 60 3 5 7 82 7 93 7-8 207 11 3-4 6 8 21 3 5 7",
    ": 31 3 5 7-8 41 3 5 7 54 6 62 70-1 3 5 80 3 5 90 2 9 307 9 11 3 5 7-8 20 2-3 7",
    ": 9 35 9 41 5 7 9 58 67 71 3 7 80 98 409 11 3-4 8 20 2 4-5 7 9 31 7-8 40 2 5 53",
    ": 5 60 4 7 9 71 3 5 7 81 3-4 6 9 91 3 5 7 501 3 5-6 8-9 15-6 9 25 31 8 41 3 5 7",
    ": 9-50 4 60 2 9 78 81-2 8 90 2 4 6 8 600 3-4 6 8 21 30-1 3 5 7 9-41 3-5 9-50 2",
    ": 4-5 7 9 61 3 5 7-8 70 2 4 6-7 9 81 3 5 7-8 90 2 4 6 9-700 2 4 6 12 4 9 23-4 6",
    ": 8 30 2-3 7 9 43-4 58 62 4 7 71 5 7 9 81 3 5 94 6-7 9 804 7 13 5 21 6 30 2 4-5",
    ": 46-8 50-1 6 64 6-7 9 71 5 81-2 5 8 90 2 4 6 8 902 4 8 14 9 21 3 9 31 3 9 42-3",
    ": 5 7 9 51 7 9 61 3 5 7 9 72 4 82 4 7 9 95 9",
    ": 4001 5 7 9-10 6 24-5 7 9-30 4 6-7 42 4 6 8 50 2 4-5 7 9 61-2 8 70 2 4 6 82 4",
    ": 9 91 4 6 8 100 2 4 9 14-5 7-8 21-2 4 6 8 30 2 4 6 8 40 2-3 5 7 52 4 8 60 2 6",
    ": 70 2 4 6 8 80 2 6 94 200 9 11-2 20 4 6 8 30 2 5 7 43 5 7 9 52 7 9 63 5 9 71 3",
    ": 5 83 96 307 11 3 5 7 9 24 6 8 30 4-5 7 9 41-2 7 9 51 5 7 9 61 5 75 8 80 3 6",
    ": 93 7-8 400 4 6 10 2 4 6 8 20 4 8 31-2 7 45 8 50 4 7 9 63 5 70 5 7 9 84 9 91",
    ": 3-4 6 8-9 502 5 7 11 3 5 8 20 2-3 5 33 5 7 42 4 7 9 53 5 7-8 60 2 4 6 72 4 6",
    ": 8 80 3-5 9 92-3 9 601 3 5 7 13 9 24 34 6 40 4 6 50-1 3-4 6 8-60 4-5 8-72 5 7",
    ": 9 83 5 7 91 7 9-700 3-4 6 8-9 14 6-7 9 21 3 5-6 31 8 40 2 4 6 8 50 2 4 6 8 60",
    ": 2 6 70 2 4 7 85 7 9 92 4 6 8 800 3 5 7 11 6 8 20 2 7 9 31 8 44-5 7 9 51 3 5 7",
    ": 9 61 3 7 71 4 6 9 84 6 8 90 2 4 6 900 2 4 14 6 8 24 8 30 6 42 4 8 52 4 60 2 7",
    ": 71 3-4 6 8 80 2 4 6 94 6 8",
    ": 5000-1 3 6 9 11 5 7 21 7 31 3 7 9 41 3 5-6 50 4 6 8 61 9 71 7 9 83 5 7 9 94 6",
    ": 101 3 7 14 26 8 30 2-3 5 8-9 49 52 9 61-2 5 7 71 84 8 90 3 5 7 9 201 3 5 10 6",
    ": 8 20 2 5 8 32 4 7 9-40 2 9-50 2 4 9 61 3 6 8 71 6 86 8 93-4 301 3 6-7 10 2 21",
    ": 9 35 7 41 51 3 5 8-60 2 4 6 9 71 3 5 9-80 4 6 91 3 5 8 401 5 9 11 22 4-5 7 32",
    ": 4 6-7 9 44 8 50 2 4 6 8 60-1 3 6 9 72-3 5 7 9 81 5 7 92 6 8 501 3 6-7 11 5 22",
    ": 4 7 9 34-5 9 41 9 51 3 5 9 61-2 7 9 72-3 5 85 8 91 3 5 7 601 3 5 7 11 3 5-6",
    ": 22 4 6 8-9 36 40-3 5-6 8 50 3 5 7 9 65 9 73 7 83 8 90 2 9 701 5 7 13 7 9 21",
    ": 3-4 6 8 30 2 9 43 7 9 51 9 63 5 7 9 71 7 9 81 7 9 96 8-9 803 7 9 11 3 7 22 8",
    ": 32 4 6 9 43 5 7 50 2-3 5 61 3 9 71 3 5 9 82 5 7 91 5-6 9 903 5 9 11 3 5 7 20",
    ": 4-5 7 9 31 3 6 8 40-1 4 8 50 2 4 7 9 61 72-3 8 82 6 8 90 2 4-5 9",
    ": 6002 6 8 11 4 8 20 5 7 31-2 8 42 5 8 56 62 4 72 6 80 2 4 8 90 2 4 6 101 5 12",
    ": 4 7 21 4 6 8 30 2 40 2 6 8 50 4 6 61 3 5-6 8 72 4 6 87 93 5 7 201-2 6 8 10 2",
    ": 22 4 6 8 35 7 42 4 6 8 52 4 6 9 63 5 72 8 81 3 5 8 92 4-5 304 9 12 4 6 22 5 7",
    ": 9 31 5-6 45 9 51 4 9 61 3 6 8 71 5 7-8 82 7-8 92-3 9 401-2 8 10 2 5 9 22 4-5",
    ": 7 31 3 5 44 6 8 51 3 7 61 3 6 74 6 8 81 4 6 8 90 2 5 7 9 501 4 6 12 6 8 25 33",
    ": 5 9 43 5 8 50 2 8 64 75 9 84 8 92 4 602 11 3 5 9 23 5 9 32 6 8 40 2 4 8 50 4",
    ": 6 8 62 4 7 70 2 4 6-7 9 81 4 7 91 7 9 702 4 6 8 15 7 22 4-5 7 9 33 5 7 43-4 6",
    ": 8 50 2 4 64 6 77 81 3 5 7 9 91 5 7 806 10 4-5 21 3 7 9 39 41 7 9 62 4 6 8 70",
    ": 2-3 6 80-1 3 7 9 95 7 9 903 5 7 9 11 3 7 9 21 3 5 7 9 34 6 8 42 4 6 8 53 5 9",
    ": 61 7 9 71 8 80 2 4 6 8 91",
    ": 7003 6 8 10 2 4 6 22 30 4 6 42 4-5 8 50 2 4 8 68-9 77 9 81-2 4-5 8 92 100 6 9",
    ": 11 8 22 4 8 30 2 43 8 50 2 4 6 60 4 8 70 83 91 7 9 203 6 13 5 7 21 3 5 30 4 6",
    ": 8 45 7 9 55 63-4 6 8 70 3 5 8 83 6 8 92 6 301 5 9 13 20 3 5-6 32 4 7 9 47 9",
    ": 51 6 63 6 9 72 4 81 3 7 95 7 401 3 5 12 5 7 9 23 5 7 34 6 8 40 2 6 50 2 8 60",
    ": 2 4 70 2 7 9 81 3 5 8 90 2 4 504 12 4 6 9 21 31 3 5 8 40 2 4 6-7 51-2 4 7",
    ": 62-3 6 8 70 2 5 83 5 7 92 4 600 2 4 6 8 12 4 6 8 23-4 7 31 3 42 4 6-7 50 2 4",
    ": 6 8 62 4 73 6 8 81 3 6 8 92 4 8-9 705 7 9 11 3 6 8 20-1 3 8 34 8-9 46 8 50 4",
    ": 8 62 6 8 70 2 4 9 81 5-6 8 92 4 8 800 2 4 6 8 10 3 24 6-7 9 33-4 9 42 55 8 61",
    ": 6 8 72 4 6 8-9 82 5 7 9-90 2-4 902 4 7 9 11 21 6 8 30-1 4 6 8 40 4 8 52 4 64",
    ": 6 8 70 7 9 81 3 5 8 91 5 7",
    ": 8002 4 6 8 10 2 4 8-9 24 6 31 3 5-6 8 40 4 8 50 3 7 9 61 3 8 72 4-5 7 9 81 3",
    ": 5-6 9 97 9 106-7 9 11 3 6 22 4 6 8 30 3 41 3 5 8 50 3 9 61 3 73 5 7 82 4 6",
    ": 90-1 3 5 9-200 3 5 7 9 11 3 7 22-3 5 7 30 2-3 5 7 9 42 4-5 52 4 9-60 2-3 5 7",
    ": 9 75 7 84 6 8-9 91 300 4 6 8 10-2 6 8 20 2 4 6 8 30 6-7 40 2 4 8 54 6 8 60 4",
    ": 6 8-9 71 3 7 9 85 9 91 3 400 2 4 6 8 10-1 26 33-4 40 3 5 7 9 56 9 61 5 9 71",
    ": 84 6 8 90 503 5 13-6 20 2 8 30 2 4 7 9 41 3 6 8 50 2 6 8 60 2 4 8 71 5 7 9 81",
    ": 8 603 9 13 6 20 2 4 6 8 30 7 9 41-2 5 9 52 60 6 8 71 3 5 7-9 83 7 9 94 6 703",
    ": 5-13 6 9 21 3-4 9-30 2-4 7 9 41 6 8 51 3 7-61 5 72 4 6 80 2 4 6 9 91 3 805 7",
    ": 9 11 3 23 5 7 9 31 5 40 4 7 9 51 3 8 62 6 8-9 71 5 7 9 85 7 9 91 5 7 9 904 6",
    ": 12 6 8 25 7 30 2 41 5 8 50 6 8 60 2 6 8 70 2 6 9-80 2 4 93 7 9",
    ": 9001 3-4 6-7 9 12 4 8 25 8 30 2 7 40 2-3 50 6 8 60 2 6 9 71 4 6 8 80-1 3 5 7",
    ": 9 91 8 108 10 5 7 9 21-2 4 31 3 5 7 40 2 6 50 2 4 8 60 2 4-5 7 9 71 9 81 3 90",
    ": 6-7 201 3 11 5 8 20 2 4 6 31 3 8 40-1 9 51 5 7 9 61 3 5 9-70 8 80 2 7 9 91 6",
    ": 8 300 4-5 7 9 12-3 5 8 20 2 4 7 9 35 7 41 6 50 2 4-5 63 7 73 5 7 9 81 5 9 91",
    ": 3 8 400 4 6 8 10 2 4 7 21 4 6 30 44-5 7 9 51 3 7 60 3 5 8 70 2 4 6 8 80 6 8",
    ": 90 2 4 502 6 8 10 2 7 22 4 9 31 3 5 44 6 8 50-2 4-6 66 70 3 7 9 83 5 7 93 6",
    ": 604 8 13 7 20 2 6 8 40 2 4 6 50 2 4 7 9 61 3 5 9-70 2 4 6 81 4 9 91 3 701 3-5",
    ": 9 12 20 2 7-8 30 2-3 5-6 8 40 50 3-4 6 8 60 2 4 6 8 70 3 5 7 9 81 3 5 7 9-90",
    ": 2-4 8 800 2 4 7 14 8 27 36-7 9 41 3 9 52 63 8 70 2 4 8 80 2 4 8 98 901 5-6 11",
    ": 9 22 4 6 36 8-9 41-2 4-5 9 51 3 6 8 60 5 73 8 81 9 91-3 6",
    ": 10001 3 8-9 12 4 6 8 20 6 34-5 7 9-40 2 5 7 51 3 7 9 61-2 7 9-70 2 7 9 81-2 4",
    ": 8 95 105 7 9 12 6 20 2 5 7 9 38 40 51 3-4 6 8 60 3 6 8 74 6 8 83 92 4 9 202 4",
    ": 13-6 21 38 40 2 4 52 66 70-1 5 80 2 4-6 8 90 4 6 8 301 7 9-10 2 23 32 4 45 8",
    ": 55 9 61 3 5 73 81 6 8 90 4 6 8 400 2 6 10 3 5 7 9 21 3-4 6 8 35 7 9 41 3 8",
    ": 56-7 9 61 8 70 2 4 6 8-9 84 9 91 3 5 508-9 11 3 5 9 21 6-7 32 4 8 40 4 50 2 4",
    ": 61 3 7 9 71 3 5 8 80 2-3 5 7 9 91 3 5 8 602 7 11 3 8 20 6 9 35 9 47 9 51 8 60",
    ": 2 4 6 8 72 4-5 7 9 81 4-6 8-90 2-3 5 7 9 701-2 4 6 13 5 9 21 6-7 9 33 5 7 42",
    ": 4 8 52 64 77 83-4 809 11 3 5-6 24 6 8 36 8 40 4 6 8 50 2 4 6 9 61 3 5 9 71-2",
    ": 6 8 80-1 4 96-7 907 9 13 5 8 20 2-3 5 7 9 31 41 3 5-6 8 51 4 7 61 3 6 8 72 86",
    ": 9 91-2 4 9",
    ": 1001 3 5 7 11-2 4 22 6 35 7 9 41 4 9 51 4-5 9 61-2 7 9 73-4 6 8-9 81 3 5 7 90",
    ": 102 4 9 12 5 7 9 21 3 5 7 9 31 6-7 40-2 6 54 6 62 4 76 82 4 7 9 91 4 6 8 202",
    ": 6 10 3 5-6 9 22 4-5 8 34 6-7 9 47 9 51 3 8 60 72-3 5 80 7-8 90 2 6 304 9 11 3",
    ": 21 5-6 8 34 6 8 42 4 6 8 50 2-3 5 8 60 2 4 6 8 70-1 5 7 81 3 5-6 8 92 4-5 7 9",
    ": 401 3 6 9 20 2-3 5 7 33 6-7 41 4 6 8 50 4 6 8 60 3 6 8 70 4 6 8 80 2 4 6-7 9",
    ": 93 6-7 500 2 4 7 15 9 22 5 9 32 8 42 4 6 9 51 3 9 61 3 5 7-8 70 3 8 81 3 6 9",
    ": 92 4 9 601 3 5 7 9 13 24-5 8 31 5-6 8 43 7 9 56 8-9 61-2 74 6 8 84 7 90 4-5",
    ": 701 9 11 3 5-9 21 3 5-6 8-9 31 5 7 9 49 51 7 61 3 5 8 70 4 6 8 81 3 90-1 6 8",
    ": 800 2 4 8 11 4 9 22 6 8 30 3 5 7-8 40 3 5 52-3 5 7 63 5 7 9 71 5-6 8 85 9 93",
    ": 5 7 9 910 3 5 7 9 21 7 9 31 3 5 8 50 5 8-9 65 7 9 71 3 5 7 9 81 3 5 9 91",
    ": 2003-5 7 10 2 5 8 22 7 34 6 8-40 3 5-6 8 50 8 60 2 5 7 71 3-4 6 80 5 7 90 2 4",
    ": 6 101 3 7 9 21 4 7 9 36 42 5 7 53 5-6 8 60 8 70 4 80 2 6 90 2 4 6-7 201-3 8",
    ": 11 20 7 9 33 5 7 9 41-2 6 8 50 2 4 61-2 5 7-8 71 3 5 9 86 8 91 3 5 302 4 6",
    ": 8-9 11 3 6 21 5 34 6 8 40 2-3 7 9 59 61 3 8 70 2-3 5 80-1 3-4 9 91 9 401 6",
    ": 15-6 8 24 6-7 9 31 3 8 40 4 7-8 50 2 60 2 6 8 70 2 8 80 2 5 9 91 3 6 8 501 3",
    ": 5 7 11 3 5 7 20-1 30 2 8 44 6 8 51-2 6 8 60 2 4-5 72 4 9 81 3 7 9 91 4 6 8",
    ": 602 8 12 4 9 21 3 7 9 31 7 44 6 50 2 9 62 4 6 8 70 6 8 80 2 6 98 700 2 5 7 9",
    ": 11 3 21 3 5 7 9 31 4 6 8 40 2-3 5 7 9 51 8-9 61 3 75 7 9 83 7 9 91 7 803 5 8",
    ": 11 3-4 6-7 9 25 8 30 2-4 6 57 9 61 73 6 8 80 4 7 9 91 7 9 901 6 8 11 3 22 4 6",
    ": 30 4 6 8-9 41 3 5 7 9 52 4 7 65 74 6 83 5 7-8 90 5",
    ": 3003 7 12 4 6 9 25 33 41 54 6 8 62 8 70-1 7 85 7 9 91 5 110-1 3 5 7-8 20 2 4",
    ": 6 8-9 33 7 41 7 9 51 3 61 4 7 9 71 3-4 8 80 4 7 90 2 7 9 201-2 4 10 8 20 2 4",
    ": 6-7 9 31 3 6 8 40-1 6-7 9-50 2 6-9 63 5 9 71 5 9 81-2 4 6 8 90 2 4 8 300 2 6",
    ": 11 3 5 7 22 4 8 32 4 7-8 40 2 4 8 50 2 4 8-9 63 5-6 8 70 5 7-8 86 9 95 7 9",
    ": 405 7 10 4 8 22-3 7 9 31-2 4 6 40-1 3 5 7 9 51 3 5 7-8 60 2-3 7 9 72 4 81 3 7",
    ": 9 93 501 3 5 7 9 13 5-6 8 22-3 5 7 9 31 3 6 8 40 2 4 8 51 3 7 61 4 8 72 4 6",
    ": 80 6 8 90-1 6-7 600 2 4 6-7 9-11 3 22 8 30 50 4-5 60 2-3 5 7 9 71 3 7-8 80",
    ": 8-9 94 704 8 10 4 7 9 24 8 35 42 51 3 6 8 60 2-3 5 7 73-4 9 82 5 7 9 800 2 4",
    ": 7 11 3 6 23 5 31 6-7 41 7 9 51 4 60 7 9 71 3 5 82 7 9 91 4 6 8 900 6 8 11 4",
    ": 6-7 9 26 30-1 3 5 42 8 50 2-4 6 8 60 2-3 5 7 9 72 4 8 84 6 9 94 6 8-9",
    ": 4003 5 9 15 21 31 3 5 7 9 41 50 2 4 6 8 62 71 3 8 81 3 5 9 91 3 5 7-8 100 2 6",
    ": 8 10 3 5 7 9 21 3 33 9 41 3-4 6 8 52 4 6 63 5 7 72 5-6 8 80 4 90 2-3 5-6 8",
    ": 202 4 6 8 12 4 8 20 5 7 9 31 7 44 6 8 50 2 4 6 60 4-6 8 70 7 80 2 4 6 90 2 4",
    ": 7 9 301 3 5 7-8 10 4 20 2 8 37 9 45 54 68 75 7 9 81 8-9 91 3 5-6 8 404 6 8",
    ": 10-1 3 5 7 20 2 5-7 31 3 5 7 40-1 4 50 4 7 68 81 5 7 95 8 501 3 7 9 11 3 6 8",
    ": 33 5 8 44 6 66 8-9 72 4 6 8 80 2 90 2 600 2 4 10 5 7 21 4-5 31 3 8 40 2 4 6 8",
    ": 54 6 8 62 70 7 9 82 7 9 91 3 9 701 3 5 8 11 3 5 20 2-3 5 30 2 4 6 8 40 5 7-8",
    ": 51 3 5 60 2 4 6 74 6 80 4 6 8 90 2 5-7 9 804 6 8 11 9 21 3 6 8 30 2 6 9 46 8",
    ": 50-1 5 7 9 61 3 9-70 2 5 81 5 7 9 91 8 900 2 4 6 11 3 5 7 41-2 6 8 50 2 4 6 8",
    ": 62 5 7 9 71 4 9-80 2 4 8 97",
    ": 5005 11 3 5 9 23 9 31 3 5 7 9 43 7 9 51 3 8 60 4 7 9 71 80 4-6 8 90 3 5 9 101",
    ": 8-9 11 3 9 23 5 7 32 44 50 3-4 6 8 60 2 4 6 8 70 2 82 5 7 9 91-2 8 200 3 5 7",
    ": 13 5 7 9 21 3 5 8 30 2 4 6 43 5 7 9 51 3 5 62 4 77 9 81 3-4 6 8 90 2 6 8 302",
    ": 4 6 9 11 3 5 8 24 8 30 2-3 5 9 42-3 5 7 55 7 9 63 5-6 8 70 80 5 93 7 403 5 7",
    ": 11 8 21 3 9 35 8 44 8 50 3 5 9-60 2 4 6 76 80 6 8 90 3 501 4 6 8-9 13 9-20 2",
    ": 4 9 31 3 9 43 9-50 2 4 9 64 6 72 7-9 90 6 8 600 8 10 2 4 6 8 25 7 9 31-2 6 44",
    ": 8 50 2 4 6 60 2 4 6 8 71 3 81 3 7-8 91 3 5 7 9 701 3 5 7 9 13 5-6 8-9 24 8 30",
    ": 2 4 6-7 9 41 6 9 59 61 3-4 6-7 9 71 3 5 7 9 81 4-5 7 90 2-3 5 7 9 803-4 8 10",
    ": 2 4 6 8 20 2-3 5 7 9 31 3 5 7-8 52 4 69 77 9 84 6 92 4 6 8 900 3 5 7 9 13 5 8",
    ": 24-5 7 35 7 45 7-8 50 6 9 61 6 9 71-2 4 6 8 80 2 4 92",
    ": 6000 2 4-5 8 10 2 5 8 22 7 31-2 4 8 40 7 9 51 3-4 6 8 61 3 5 9 71 8 80 3 90 2",
    ": 102 4 6 15 28 30 4 6 8 40 2 4 6 8 50 2 4 8 60 3-4 6 8 70 2 5 7 9 81 3 5 7 91",
    ": 209 13 20 2 5 9 33 9 41 3 5 7 9 51 61 7 9 73 5 7 9-80 2 4 6 93 5 9 301 3 5 7",
    ": 9 11 6 8 20 2 4 34 7 9 43 5 9 58 61-2 7 70 2 4-5 7 80-1 3-5 7 9 92 4 6-7",
    ": 9-400 2 4 7 12 5 23 7 31 3 7 40 3 5 51 67-8 70 3 9 81 9 501 9 11-2 7 9 21 3",
    ": 30 2 7 43 5 7 9 51 3 8 60-1 3-4 6 8 70 2 4 6 8-9 81-2 4 6 8 90 2 5 7 600 4 6",
    ": 8 10 2 4 6 8 20 2 4 6 8 33 8 42 5 7-8 56 60 4 8 71 4 8-9 81 3 5 7 9 91 3 701",
    ": 4 6 20 4 9 31 5 41 56 8 60 2 4 6 8-9 78 80 92 4 6 9 805-6 8 10 2-3 5 7 9 21 3",
    ": 5 7 9 31 3 5 9 41 7 60 2 7 9-72 4 6 8-9 81 7 9 91 3 5 7 901 3-4 6-7 9 11 5 7",
    ": 9 21 3 6 9 34 40 2 6 8 52 4 6 8 60 8 70 7 9 81 5 93",
    ": 7000 2 7 9 11 6 8 20 5 34 40 4 8 50 4 6 8 60 2 4 8 70 2 6 8 88 90 5 7 102 4-5",
    ": 7 9 13 5 7 9 21 3 6-7 9 31-2 4-5 7 46 8 62 4 9-70 2 7 80 2 4 6 92-3 5 7 9 201",
    ": 3 5 7 9 19-20 2 4 6 8 30 2 4 6 8-9 41 4 6 54 6 8 60 2 4 6 8 75 7 80 2 90-1",
    ": 8-9 302 4 6 8 10 2 4 20 2 4 6 32 6 8 40 2-3 5 7 9 51 3 5 9 61 6 71 4 6 86 8",
    ": 90 2 8 400 2 4-5 7 9 11 3 5-7 20 2 4 7 37-8 40 2-3 9-50 2-3 5-6 62 4-5 8 70 7",
    ": 84 8-9 92 4 6 8 500 2 4 7 9 11 3 7-8 20 4 6 8 30 2 4 6 8 45-6 8 52 4 6 8-9 61",
    ": 3 8 73 5 7 9-80 2 8 99 601 3 5 7 9 11 3-4 6 21 8 30 3 5 8 42 4 50 3 5 8 60 2",
    ": 4 6-7 70 2 81 3 5 8 90 2 5 712 4 24 6 8 30 49-50 2 6 8 60 2 4 7 9 73 5 7-8 80",
    ": 2 5 7 9 91-2 6-7 9 803 5 7 9 11 4 6 8 25 7 9 31 3-4 6 9 41 3 5 8 50 2 4 6 8",
    ": 60 2 6 8-9 81 3 5 7 9 94 8-9 901 4 6 9 11 5 9 21 3 5-6 8 30 4-6 40 2 4 6-7 9",
    ": 52 5 7-8 64 7 72 4 6 9 82 4 6 97 9",
    ": 8001 5 7-8 12 5 7 22 4 7 38-9 41 3-5 7 9 51 3 5-6 8 60 72 6 80 2 5 91 4 6 100",
    ": 4-5 7 9 11 3-4 6 8 22 4-5 8 34 6 8 42 4 8-9 51 3 5 7 60 8 75 7 85 9 93 7 200",
    ": 2 12 4 6 8 20 30 2 4-5 9 41 4 6-7 9-50 4-5 7 9 62 4-5 7 9 71 3-4 80 3 6 92 4",
    ": 6 8 300 4 6-7 11 5 7 21 4 6-30 2 6 8 42 5 7 50 60 2 8 70 6 8 86 8 91 7 405-6",
    ": 9 14 6 8 21 3 5 7 30-2 4 8 40 4 6 8 51 3 7 9 67 9-70 2-4 80 2 5 7 95 7 501-2",
    ": 4 8 10 6 20 34 42 4 6 8-9 52 7 9 61 3 7 9 71 3 9-80 5-6 8-90 4 6 9 601 5 9 11",
    ": 4 6 8 20-1 3 5 9 31 3 5 9 42 4 6 8 50 61 9 71 7 9 82 4 6 9 91-2 4 703 6 8 10",
    ": 2 5 24-5 7 9 32 6 8 40 2 9 51 3 7 9 63 75 9 82 8 90 2 7 9 802 8 11 3 5 9 21 7",
    ": 44 6 9 51 3 60 2 6 9-70 4 6 83 5 7 90 2 4 6 900 4-5 8 12 4-5 7 9 24-5 7 9",
    ": 31-2 5 7 41 6 59 61 3 5-9 72 5 9 81 3 5-6 9 91 4 6",
    ": 9000 2 8 10 2 4 6 20 5 32 4 7 9 41 3 5-6 8 50 2 4 6 60-1 3 8 70-1 3 5 7-80",
    ": 2-4 6 90 2 6 8 109 11 7 9 21 3 37 9 41 3 5 7 51 3 62 71 3-4 7 9 81 3 7 9 91 5",
    ": 7-8 201 3 5 7 9 11 3 9 21 6 30 2 4 6 8 44 6 58 60 2 6 8 70 3 7 9 81 3 5 90 2",
    ": 4 302 8 10 4 6 8 20 6 8 31 46 8 50 3 7 61 9 72 4 6-7 80 2-3 91 3 5 8 400 2 4",
    ": 7 11 3 7 20 2-3 6 9 34 41 4 50 2 5 9 61 4 8 72 4 9 81 3 5 7 91 4 6 8 501 3-4",
    ": 7 9 11 20 4 6 9 31-2 5 8 40 2 4 51 3-5 7-8 66 8 70 2 4 6 80 2 9 94 9 607 10 3",
    ": 5 7 22 5 7 33 6 8 42 4-5 53 7 61 3 9 73 6 8-9 82 91 3 9 705 7 10 2 4 6 9 22 4",
    ": 30 2 6 8-9 45 7 52 4 6 8 62 6 8-9 71 3 8 80 2 5 7 9 93 7 9 804 9 15 20 2 4 6",
    ": 8 30 2 5 8 42 4 6 8 50 2 4 8 63 7 9 73 5 9 81 3 5 7 90 2 4 6 8 900 2 4 6 8 12",
    ": 6 8-9 21 3 8 30 2 9 48 52 8 61 3 7 74 7 83-4 7 9 91 3 5 7",
    ": 20001 3 5 7-8 10 21 3 5 7 9 33 5 8 40 2 5 7 51 5 61 4 6 70 2 4 8 81 3 90 2 7",
    ": 9 102 4 6 10 2 6 8-9 21 4 6 8 32 4 6 45 53 7 61 3 5 7-8 70 4 9 83 6 8 90 2 7",
    ": 9 202 5 12 20 2 4 8 30 4 7 9-40 2 56 8 65 73 5 7 83 5-6 8 94 6 300 3 5 7 11 3",
    ": 5 7 9 21 5 7 9 31 7 41 5 9-50 4 6 8 60 2 5 73 7 9 81 3 5 91 400 2 4 7 9 11",
    ": 3-4 7 25 9 31 3 7 9 41 4-5 7-8 62 4 8 76 8 81 3 5 7 9 91 3 7 500 2 5 7 10 2 4",
    ": 6 8 20 3 5 9 31 3 5 7 9 41 3 57 9 61-2 4 6 8 70 2-3 5 7 9 81 3 8-9 91-2 5 7",
    ": 603 5 7 9 11 3 5 7 23 5 9 31 3 5 7 9 41 3-4 6 51 3 7 9-60 3 70 2 4 6 80 2 4-5",
    ": 7 9 91-2 4 6 8 700 2-3 5 8-10 2 4 6-7 9 21 4 6 8 30 2 4 8 48 51 3 7 67 9 71 3",
    ": 5 83 6 8 90 8-9 801 3 6 10 6 8 20 2 4 30-1 5 7 9 43 5 7 53 62 6 8 70 2 4 6 8",
    ": 80 3-4 6 9 91 3 5 9 903-4 6 13 9 21 4 8 30 4 9 42 4 8 55 7 9 61 5 8 72-3 5-6",
    ": 8-9 83 5 7-8 90 3 5 7 9",
    ": 1003-4 7 9 11 3 7 9 21 9 31 3 6 42 6 50 2 5 7 62 8 70 2 4 6 84 6 91 3 7 101 3",
    ": 5 7 17 9 22 6 8 31 3 5 7 40 2 4 53 7 62 4 70 4 85 7 9 91 3 6 8 202 4 6 12 6 8",
    ": 23 7 31 3 8 40 4 6-7 9 51 3 9 61 3 5 7 73 6 8 80 3 5 7 91 4 6 9 301 3-5 12 4",
    ": 8 20 2-3 6 34 6 8 40 4 6-7 9 52 7 61 3 6 72 6 8 93 5 9 409 19 22 4-5 9 31 3",
    ": 47 53 9 63 71 3 6 80 2 4 6 92 6 500 2 4 9 11-3 5 23 6 9 31 5 44 6 50-1 3 7 60",
    ": 2 4 7 74 6 81 4 7 9 91 4 6-7 9 601 3 6 10 3 20 4-5 30 2 5 7 9 41 3 5 9 51 7",
    ": 61 4 7 9 74 6 8 80 2 4 6 8 90 8 700 2 6 8 14 8 22 4 6 9 31 9 41 3 5 8 50 2 9",
    ": 61 4 6 8 70 2 4 6 8 80 2 4 6 90 2 4 804 6 10 3 5 7 9 23 5 7 9 31 3 7 42 8 62",
    ": 8 72 8 82 6 90 4 6 8 901 11 3 5 7 21 3 5 9 34 7-9 41-2 4-5 50 4 60-1 3 7 71-2",
    ": 4 6 8-82 4 6 8 92 7",
    ": 2000 2 4 7 9 11 3 5 21 3-4 7 32 8 42 4 7 9 51 3 5 7 9 61 3 7 9 71 3 5 8 80 2",
    ": 4 97 9 101 3 5-6 8 14 6 8 21 3 6 8 30 3 5-6 42 5 56 8 60 2 4 70 2 4 81 5 8 90",
    ": 4 8 203 5 8 10 28 32 6 8 45 51-2 4 63 5 7 71 3 5 7 9 85 7 9 95 7 301 3 10 3 7",
    ": 9 22 4 8 30 4 45-9 51-2 4 6 70 2 8 83-5 91 3 7 9 401 4 9 14 20 2 4 6 8 31 3-4",
    ": 6 8 42 5 7-8 50 5 7 9 61 4 6 73 8 81 5 7 9 505 7-8 10-1 4 7 9 21 4 6-7 9 32 6",
    ": 9 41 6 50 5 7 61 8 70 2 4 6 80 3 7 9 96 9 604 6 8 13-4 7 9 25 8 30 4 42 4 6 9",
    ": 51 3 5 7 65 75 7 9 81 3 7 9 91 3-8 706-7 9 11 7 9 24 7 31 3 5-6 8 40 2 4 51 6",
    ": 9 61 8 70-1 7-8 80 2 4 6 9 92 6 8 804 6 8 12 4 7 21 4 6 33 8 40 2 6 52 4 6 61",
    ": 6 70-1 5 82 8 92 5 7 901 3 10 2 7 9 25 7 9 35-6 8 42 5 7-8 51 3 5 9-60 3 5 7",
    ": 9 72 4 6 80 8 90 2 4",
    ": 3000 4 6 10 2 6 8-20 2-3 5 33 8 44 6 9 51 8-9 62 4 6 8 81 5 7-8 90 8 102 4 7",
    ": 16 8 22 4 9-30 3 5 8 43 7 9 51 3 5 9 61 9 71 3 7 9 83-4 6 92 6 200 8 10 3-5 7",
    ": 9 25 9 33-4 8 40 2 4-5 8 50 60 2 4 6 8 70 2-3 82 5 7 9 91 5 301-2 6 8 10 5-6",
    ": 20 2 5 7 9 36 8 43 7 51 3-4 6 60 4 9 71 5 7 82 6 8 91 3 5 9 401 6 8 10 2 6 8",
    ": 20-1 3 9 32 6 40 2 51 3 5 7 9 61-2 8 71 3 7 9 81 3-4 6 8 90 2-4 6 9 501 3-4 6",
    ": 8 10 3 7-8 20 4 6-7 9 31 4 7 9 41 3 7 9 52 4 6 8 65 7 9 72 7 9 81 7 9 91 3 5",
    ": 603 6 9 11 21 35 7 9 44 7 9 51 3 5 7 9 61 3 7 76 81 3 7 93 5 7 9 702 4 6 8 16",
    ": 22 5 7 36 8 44 6 8 50 2 4 8 60 4 73 5 7 9 87 9 92 4 9 801 3 9 11 7 23 30 2",
    ": 6-7 9 43 5 8 50 6 62 7 71 9 81 7 91 3 5 7 901 8 14 6 20 2 4 6 8 31 3 5 7 9 43",
    ": 5 7 58 60 6 72 6 8 83 5 90 3 5 7",
    ": 4003 5 16 20-1 3 7-8 30 2 4 6 9 43 7 50 2 7 9 63 5 7 71-3 9 83 6 92 4 6-7 101",
    ": 3-4 7 9-10 4 8 20 2 4 6-7 31 5-7 41 3 51 61-2 8 76-7 9-81 3 5 7 9 94 8 200 6",
    ": 10 4 8 21 3 5 8 30 2 4 6 8 40 69 71 4 8 80 4-5 8 90 2 4 300-1 4-5 7-9 12 4 8",
    ": 20 4 8 30 2 4 6 9 41 4 9 51 3 9 61 3 71 3 5 7 9 81 3 5 9 91 3 7 401 3 7 10 4",
    ": 8 20 2 35 7 41 3 7 9 51 3 5 8-9 61 4-6 76 8 81 5 9 91 6 8 501 3 13 24 37 9",
    ": 45-7 9 57 9 61 71 90 7 9 601 3 13 20 2 5 31 3 5 8 40 2 4 50 3-4 7 9 61 3 5 7",
    ": 9 71-2 4 6 8 80 3 90 2 4-5 700 6 14 20 6 9 31 4 6 44-5 7 52 4-5 7 9 61-2 4 6",
    ": 9 71 5 87 91 9 801 5 7 10 6 8 20 2 4 8 30 6 8 41 3 5 7 55 8 62-3 6 8 70 2 4",
    ": 88-9 91 4 6-7 904 7 14 6 8 27 34 6 43 5 8 58 60 4 70 5 85 9 98",
    ": 5000 2 4 6 9 13 5 9 21 3 5 7 31 5 7 9 42-6 52 4 6 8 60 6 8 70 4 6 9 81 5 9 91",
    ": 107 9 20 2 4 30 2 44 7 9 51 9 61-2 73 5 8 80 4 8 90 4 205 15 7 20 5 7 9 32 4",
    ": 46 8 52-3 5 9 61 3 5 7 9-70 2 4 6 80 2 4 92 4 6 8 309-11 3-4 21 3 5 7 9 31 42",
    ": 6 8 50 2 4 6-7 64 70 6 8 82-3 5 93 5 7 401 8 15-6 20 2 6 30 2 4 6 8 40 6 8 52",
    ": 4 6 8 60 2-3 5-6 8 72 5-7 9 81 3 5 91 3 502 4 6 8 10 2 8 21 6-7 30 3 8 42-3 6",
    ": 50 4 6-7 9 61 3 5-7 9 75 7 9 85 7 91 4 8 600 4 6 8 10 2 6 8 23 9 31 3 5 43-4",
    ": 6 8 53 5 7 9 61-2 4 6 8 75-6 8-9 81 4 6 92 4 6 8 702 4 11 4 8 20 3 5-6 32 4 6",
    ": 40 2 9 53 5-6 8 62 9 71 81 3 5 93-4 6 8 800 2-3 5 7 13 5 7 9 24 6 31 3 5-6 9",
    ": 41 3 5-6 9 53 5 7 61 5 7 9 71 80-2 92 6 9 901 6 8 12 9 21 3 35 7 41 3 5 7 9",
    ": 51 7 9 66-7 9 72 4 8 81-2 9-90 2 4 6 8",
    ": 6000 2 4 6 13 5 8 24 6-7 9-30 6 42 6 8 50 4 6 63 75 7 80 2 9 91 5 103 5-6 8",
    ": 12 4 6 20 6-7 31 3 7 9 43 50 2 6 68-9 74 9-80 2 5 7 91 3 7 9 203 5 7 9 12 8",
    ": 20 2 32 6 8 40 2 4 6 8 50 4 6 61 5 76 82 4 6 90 6 9 301 3 7 11 7-8 20 2 5",
    ": 9-30 2 4 8 40 2 6 50 2 4 8 62-3 5 9 73 7 9 81 3 5 93 5 401 4 6-7 9-10 3-4 9",
    ": 21 3 7 9 31 4-5 7 41 9 51 7 9 63 7 71 3 7 9 81 3 6 8-9 91 6 500 2 4 6 10 2 6",
    ": 20 2 8 32 4 6 40 2 5 9 51 3 6 8 60 2 6 9 71 3 5-6 82 4 90-1 3 5 7 9 603 6 8",
    ": 10 2 4 8 20 2 5 7 9-30 6 8 40 5 52 60 2 5 7 9 71 3 5 9 84-5 7 91 3 5 7 700 2",
    ": 6 8 10 4 6 8 20 2-3 35 7 40 4 6 8 50 2 4 8 60 72-3 5 9 81 5 9 91-2 4 6 803",
    ": 7-8 10 2 8 20 2 4 6-7 9 38 40 2 6 53 5 7 9 61 4 6 70-1 3 9 81 6-7 9 93 5 7 9",
    ": 903 7 9 11 3 20 4-5 8 31 6 44 6 53 5 8-9 63 7 9 73 5 7 9 87 9 91 4 6 9",
    ": 7003-4 6 8-9 12-3 5-9 34 42 4 8 50-1 5 7 9 65 70 2 6 82 6 8-9 91 6 102 6 12 6",
    ": 8-9 23 8 34-6 9 41 3-4 8 50 4 7 9 61 9 74 6 80 4 6 8 90 3 6 8 206 8 10-1 3 5",
    ": 8 20 2 6 31 3 5 7 40 2 6 8 50 5 7 61 4 7 9 71 3 5 8 82-3 5 8 90 3 5 301 3 7 9",
    ": 14 25 7 31 4 6 8 40 4 7 9 53-5 62 4 6-7 83 7 93 5 7 405 7 9 18 20 4 7 31 3 5",
    ": 40-1 5 7 9 51 5 61 3 7 9 71 3 5 7 81 3 5 9-90 2 5 9 503 8-9 13 5 7 9 21 8 32",
    ": 4 6 8 43 5 9 52 4 60-1 5-9 72-3 5 9 81 3-4 91 3 5 7 603 5 7 9 12 4 6 8 22 5 7",
    ": 9 31 5 7 40 4 6 53 5 7 9 61 5 7 9-70 2 6-7 80 2 91 3 6 702 4 8 10 8 22 4 8 30",
    ": 7 9-40 55 61 3 9 77 9 84 6 90 2 4 6 8 802 4 8-9 12 4 8 21 4 9 31 3 5 49 51 3",
    ": 5 7-8 61-2 4 8 70 2 9 81 3-4 6 8 91 9 901 3 12-3 5 7 22 6-7 9 31 3 5 7 56 8",
    ": 63 7 70 2-3 6 8 80 2 4 6 8 90 4 6 8",
    ": 8002 4 6 10 2 5 7 9 21 9 40-1 5 7 50 2 6 60 2 4 6 70 2 4 6 8 80 2 4 6 8-9 97",
    ": 9 101 5 7 9 15 9 23 5 30-1 3 40 7 9 52 5 7 9 62 4 6 8 70 2 4-5 81 4 6 8 93 8",
    ": 200 2 4-7 9 13 5-6 21 3 5 7 35 43 5 7 53 5-6 61 5-6 8 70-2 8 81 3-4 6 8 93",
    ": 301 4 11 7 9 21 3 9 31 7 9 41-2 4 6 52 6 8 60 2-3 6 70 5 7 9 81 92 5 9 401 8",
    ": 10 2-3 5 7 20 2 4 6 8 30 2-3 6 8 40 2 5 7 9 51 3 5 7 63 5 9 73 5 81-2 4 6 93",
    ": 9 501 3 5 8-9 11-2 4 21 3 5 30 2 4 6-7 46 8 50 2 8 60 2 70 2 7 81 7 9 91 5 8",
    ": 600 6-9 11 3 20 2 4 6 8 30 4 6 44 7 51 5 9 63 7 9 73 5 7 85 7 93 702 9-10 9",
    ": 21-2 4 6 30 7 41 3-4 52 4 8 60 2 71 4 6 8 80 2 91 802 4 6 9 11 4 6 22 4 6 8",
    ": 30 5 7 9 41 3 5 7 50 2 4 6 8 60-3 5 7-8 70-1 3 5 8 83 5 7-8 90-3 5 7 9 907 9",
    ": 11-2 4 6 8 20 2 4 31 8 40 6 8 50 2 8 60 2 4 6-7 71 7 9 88 90 2 4 6 8",
    ": 9006 10 4 8 21 3 31 3 5 7 49 53 5 8 61 3 5 8-9 78 82 5 7 93 5 7 101 4 8 13 6",
    ": 22 4 6 8 32 4 8 46 50 2 7 9-60 6-8 70 7 82 4 6 90 2 4 6 200 2 4 10 2 4 6 9-20",
    ": 2 8-9 37 9-40 2 6 8 50 7 60 9 71 4 7 9 81 3 8 94 9 305 8 10 5 20 6 8 31 3 9",
    ": 41 3 6 61 4 6 8 71 7 81 3 7 9 95 7 9 401 5 10 2 6 8 26 8 30 2 42 4 50 5 7 9",
    ": 61 3 5 7 9 71 3 5 7 9 81 4 6 90 2 4 6 501 4 6 9 11 5 7 9 26 8 32 4 6 41 5 7 9",
    ": 51 5 60 2 4 6 70 3-4 6-7 80 2 5 9 91 3 5-7 9 606 8 10-1 3 6 8 20 2 7 32 7 9",
    ": 47 9 54 6 8 60 3 8 70 83-4 6 91 4 702 4 11 3 9 23 30 3 5 9 41 5 7 9-50 2 63",
    ": 5-7 9 71-2 6 8 81-2 4 6 8-9 91 8 807 9 11 6 8 21 3 6 8 30 5 9 41 3 7 9 51 3 5",
    ": 7 64 71 6 8 80 2 4 7 9 91 3 7 9 901 3 7 9 15-6 8 36 40 2 4 6 8 50 2 4 6 60 2",
    ": 6 8 70 2 4 9 81 3 5 91 4 8",
    ": 30000 2 4 8 10 2 4 7 22 4 6 30 4 6 40 6 8 50 2 4 61 3 6 8 72 7 9 81 3-4 6 8",
    ": 90-1 103 9 11 6 8 22-4 7 9 32 5 7 40 4 8 51 3 5 7 60 2 4 6 9 71 8-9 81 3 5 7",
    ": 91 4 6 9 201 4 8 10 4-5 9 28 30 2 4 7 47 9-50 9 61 3 5 71 5 81 91 6 300 2 4-5",
    ": 7 9 16 8-9 24 6 31-2 4-6 8-41 3 5 7 9 51 3 5 9 63-4 7 9 71 3 6 8 83-4 9 91 3",
    ": 5 400 4 8 11 3 5 20 2 6-8 30 2-4 47-8 51 3 5 61 3 7 9 71 5 9 81 9 93 5 7",
    ": 9-500 4 6 10 27 9 31 5 9 41 3 5-6 50 2 6 8 62 4-5 8 70 2 6 8 80 2 7 91-2 4-5",
    ": 7 9 607 9 11 4 6 8 20 5 7 9 33 5 41 6 9 52 4 6 62-3 5 70-3 83 6 8 90 2 7 9",
    ": 701-2 4 10 2 4-6 24 9 31-2 7 40 3-4 8 52 4 6-7 9-60 2 72 4 9 81 9 94 8-9 802",
    ": 4 7 10 2 4 6-7 9 21 4 7 35-6 8 49 51 3 5 7 9 61 3 6 8 70 2 4 6-7 81 91 3 5 7",
    ": 9 908 10 2 6 9 21 3 5 7 9 31 3 5 7 9-40 2 6 8 50 2 4 60 3 5 75 7 81 3 8 95 7",
    ": 9-1000 2-3 5-6 9 11 3 5 7 20 2 8 30 2 9 41 5 50 9 62 4-5 9 71 6 81 3 7 9 91 3",
    ": 5 7 9 103 6-7 9 13 5-6 9 25 7 9 31 3 5 40 3 5 7 9 51 3 5 7 9 61 3 5 73-4 6-7",
    ": 9 81 3 5 7-8 90 2 4 6 8 200 2 4 11 6 21 3 5 9 31 3 5 7-8 42 4 8 56 64 6 8 75",
    ": 86 8 90 4 6 8 306 8 13 6 8 26 8 31 41 3 5 7 9 53 9 63 5 7 72 4 84 6 8 90 2 4",
    ": 7 400 2-3 5 9-10 4 25 7 9 31 3 5 7 9 43 6 9 55 8 60 2 6-7 9 78 80 4 93 6 8-9",
    ": 508-9 11 3 22 4 30 2 4 6 42 6 59 61-3 5 72 4 9 83 5 7-9 91 3 5 9 602 10 5 7 9",
    ": 22 4-5 7 9 31 3 5 47 9 57 9 61 7 9 73 5 7 9 85-6 93 7 9 701 3 7 11 3 6 29 31",
    ": 44 6 51 5 7 9 61 4 70 2 4 6 8 80 5 7 9-90 2 4 6 800 4 7 10 2 4 8 23 7 9 31 4",
    ": 6 8-9 43 5 9-50 61-3 7 71 3 5 9 81 6 9 913 5 22 8 30 2 4 6-7 43 53 7-8 60 3 5",
    ": 71 3 81 3 7 9-90 4 6-7",
    ": 2000 4 6 8 12 4 6-7 9 21 4 30 4 8 40 2 4 6 8 50 2 4 8 62 4 7 72 6 82 6 8 90 2",
    ": 4-5 7 9 101 7 9 11 6 8 20 2 8 30 2 4 7 9-40 2 4 6 50 60 2 4 71 3 8 81 3 5 7-8",
    ": 90 2 6 9 201-2 6-7 9-11 20 6 8 33 5-6 45 7 9 53 5 9 61 5 71-2 6 89 92 8 300 2",
    ": 4 12 4 6 8-9 25 7 9 31 8 40 5 7 9 51-2 4 6 64-5 8-9 71-2 4-6 8 80 2 4 6 8 92",
    ": 4 401 7-8 11-2 4 23 5 7 9 31 8 40 2 4 6 50 2 4 61 8-9 71 3 5 7 9 81 3 90-1",
    ": 509 11 3 5 24 6 8-9 31 7 44 7 54 6 8 70 2 4 6 8 82 6 98-9 609 11-2 4 6 8 20 2",
    ": 4 6 8 36 42 4 8 50 4 9 62 7 9 77 81 6 9-90 4 6 8-9 701 4 8 10 2 5 7 30 2 4 7",
    ": 9 41 3 50 6 8-60 2 4 72 4 6 8-9 82-4 6 90 2 4 6 8 800 2 4 7 11 3 5 7 23 5 7 9",
    ": 34 6 8 40 2 4 58 60 70-1 5 7 82 8 90 4 7 900 6 8 14 20 2-3 42 5 7-8 54 8 62 4",
    ": 6 9 71 3 5 7 9 81 3 7 9 91-2 8",
    ": 3000 4 8 10 3 5 7 9 21 5 7-8 31 4 6 42 8 50 2 4 8 60 2 6-7 74-5 7-8 80 4 6 94",
    ": 9 104 6 8 12 6 8 20 4 6 8 30 9 50 4 8-9 61 3 5 70 3 5 9 81 5 7 90 2 6-7 9-200",
    ": 2 4 6 8-9 12 9 23 7 9 31 3 5 40 2 4 8 50 2 61 4-5 7 9 76 87 90 2 4 6 8 300 2",
    ": 8 10 2 5 8 20 2 6 8 30 2 4 8 41 3 8 50-1 60 8 72 4 6-7 9 87 91 3 5 8 401 9 12",
    ": 4 8 20 2 4 7 9 36 8 40 2 5 62 7 9 77 9 97 9 501 3 5 7 9 11 3 5 7 9 23 6 8 32",
    ": 4-5 8 40 2 8 51 5 7-8 60 2 6-7 70 2 4 6 80 2 4 6 8 90 2-3 6-7 602 4 6-7 9 14",
    ": 6 8 20 2 4 6 36 8 42 7 9 53 5 63 72 8 80 3 5 93 5 9 701 3 5 8 21 5 7 30 2 6",
    ": 40 4 9 52 4 6 8 66 8 71 5 7 81-2 4 6 9 92 4 6 8 802 6 8 10 6 24 31 4-6 9 42",
    ": 4-5 7 9 51 3 5 7 9 65 71 3 82 4 8-9 96 8 900 6 8 10 4 8-9 21 7 9 31 6 8 40 4",
    ": 58 64 6 73 5 7 82 4 6 8 90 2 6 8",
    ": 4000-1 3 5 14 6-7 23 9-30 4 6 42 4 8 50 60 4 6 8 70 2 4 6 9 81 6 8 91 5 9-100",
    ": 4 8 12 5 7 20 2-3 6-7 9 32 4 7 9 43 5 7-8 50 9 61 7 78 80 4 6 8 95 200 2 4 6",
    ": 13 8-21 3-4 8 36 8 40 3 5 7 9 51 3 5-6 8 61 3 5 7-8 70 9 81 5 93 5 7 9 302 7",
    ": 12 7 9-20 3 9 31 9 41 6 8 51 6-7 9 65 9 74 6 9 81 3 9 97 9 401 3-4 6 10 3-4 6",
    ": 27 9 32 5 9 45 7 51 3 5 8 60 4 6 8 70 2 4 6 8 83 5 9 99 501 3 5 7 9-10 2 6",
    ": 24-5 8 33 5-7 9-40 2 6 9 51 4 8 60 3-4 8 70 2 5 7 9-80 2 6 8 90 2 4 6 8 600 2",
    ": 6 8 12 4 6 20 4 6 8 31 6 8-9 41 3-4 6 8-9 53 6-7 9 67 9 71 3 7 9 81 3 7 9 92",
    ": 4 6 9 703-4 7 10-1 6 8 25 7 9 38 40 5 7 9 51 3 5 7 61 5 73 5 7 9-81 3 5 7 91",
    ": 3-4 6 8 800-1 10 3 20 2 4 8 31 3 9 41 3 6 8 50 3 5 9 62 4 6 8 70 2 4 80 2 90",
    ": 4 6 900 6-8 13-4 6 21 3 5 30 2 4 6 8 40 2 4 6 8 51 4 6 9 61 7 70 3 9 85 91 3",
    ": 5 8",
    ": 5000 2 4 8 10 2 5 7 28 30 2-3 7-8 41 3 6-7 9-50 6 8-9 61-2 4 6 8 70 8 85 9 92",
    ": 4 6 8 101 3 5 7 11 3 5 20 2 4 9 31 3 5 9 43 6 8 50 2 4 6 8 60 5 7 9 72 4 9 81",
    ": 5 9 91 6 8 200 3 12 6 8 22-3 5 7 9 31 3 5 9-40 2 51 5-8 61-2 4 8 70 2 4-5",
    ": 9-80 2 7 90 2 300 4 6 8 22 7 9 31 9 41 3 5-6 8-9 51 3-4 7 9-61 5 7 77 9 83",
    ": 6-7 9 93 7 9 401 3 5 7 9 20 6 42 50 4 6 60 2 4 6 70 2 6 8-9 81 3 5 7-8 97 9",
    ": 501 8 12 6 8 22 30 3 5 7-8 40 2 6 8 50 2 5 7 9 61 4 6 70 2 4 6 81 3 6 8 90 2",
    ": 4 9 605 9 13 5 7-8 20 2 4 32 7 9 44 6 8 50 3 9 61 3 5-6 71 3 5 7 80 2 4 6-7 9",
    ": 95 7 9 701 3 5 7-8 16 22 4-5 34 6 8 42 6 8 54-5 62 4 6 8 70 2 4 6 8 80-1 3 5",
    ": 7 9 95-6 8-9 801 3 5 7 10 3 7 9 27 31 4 6 8 41 51 5 7 68 71 3 5 7 9 81 3 5",
    ": 7-8 90 2 4 6 907 9 14 9 25 7 9 34 6 8 40 2 7 9 52 5 8 60 4 6 8 70 2 4 6 80 4",
    ": 91 7 9",
    ": 6002 8 12 28-30 2 6 8 40 2 4 6-7 9 51 5 7 60-1 3 6 72 5 7 9 81 4 6 8 90 2 5 7",
    ": 9 101-2 6 8 10 3 5 7 20 36-7 40-1 7 9 62-3 71 3 5 80 2 90 4 6 8-9 201 7 9 11",
    ": 3 21 3 9 31-2 5-6 9 45 9 51 3 8 60 6 8-71 3 5 9 81-6 8 91 3 8 302 4-6 8 11 3",
    ": 6 8 20 2 4 8 30 2 6 8 40 2 4 6 58 60 2 71-2 6 82 4 6 8 90 3 8 401 12 6 8-9 21",
    ": 5 9-30 2 6 8 46 52 4 9 61 3 9 73 5 80 2 8 90 2-3 5 7 507 9 13 6 8 21 3 5 7-8",
    ": 33 5-7 40 2-3 6 8 50 9 61 70 2 6 8 80 4 6 92 4 7-8 600 6 8 10 2 4 6 8 23 7 9",
    ": 33 5 8 41 5 7 9 51 3 61 3 6 72-3 5-6 8 83 6 8 91 3 6 706 10 4-5 7 9 27 9 32-3",
    ": 7 41 50 2 4 6 60 3 5 7 9-70 2-3 5 8 80 2 4 6 90 4 6 800 2 4 7 9 11 3 22-3 31",
    ": 5 7 9 41 3-4 8 50 2 4 6 8 60-1 3 5-6 9-70 2 4 7 9-80 2 95-6 8-9 901 3 9 11 4",
    ": 6 8 20 5 9 31 4 43 6 8 50 2 8 60 4 6 70 2 6 8 80 2 9 91 5 7 9",
    ": 7005 7 11 4 24 6 8-30 3 9 42 4 6 8 52 4-5 9-61 3 5 8 70 2 4 8 83 5-6 90 2 4",
    ": 102 4 8 12 5 7 9 25 36 8 40 2 4 50 2 4 7 61 4 71 4 6 8-9 87 9-90 4 6 8 203 5",
    ": 7 11 3-4 8 22 5 8 32 5 7 9 43 5 7 9 51 3 6-7 64 6 9 71 3-4 8 80 2 8 92 5 7 9",
    ": 301 15 8-9 22 4 7 9 31 3-4 7 40 50 4 66-8 70-1 8 83-4 91 7 405 7 9 11 3 9 21",
    ": 4 6 36 8 42 6 9 54 6 60 2 70 2 4 6 82 90 6 500 7 9 12-3 6 8 25-6 8 30-1 5 43",
    ": 7 9 59 61 3 6 71 80 2-3 5 8 93 7 9 601 3 5 7 11 3 5 8 20 4 7 31 3 5 7-8 40",
    ": 2-3 5 7 9 51 3 9 61 5 7 73 5 8 80 2 4 6 8 90 2 5 9 701 3 9 14 28 30 4 9 41 6",
    ": 8 51 3 5 7 9-60 2 8-9 72 4 6 81 6 8 90 4-5 800 4 6 8-11 3 7 20 2 7 33 7-8 44",
    ": 6-7 51 3 5 7 9 63 5 70 2 6 8 87-8 90 2-3 5 7 9 901-2 13 5 7 21 4 7-8 34 40 3",
    ": 7 53 5 7 9-60 2 4-5 7 73 5 7 9 81 5-6 9 96 8",
    ": 8004 6 10 2 4 6 8-9 26 30 2 8 44 8 50 2-3 7 63 8 70 3 6 8 80 2 4 90 2-3 5 7",
    ": 100 2 4 17-8 24 6-7 9 31 3 5 7 9 41 3 5 8 51 3 5 8 60 4 8 71 5 9 81 4 90-1 3",
    ": 5 7 9 203 5 7 9 15 7 9 21 9 31 3 41 3 7 9 51 3 5 8 60 4 7 71 4 6 82 4 6 8 90",
    ": 4-8 306 8 10 2 4 7 9 21 31 5 7 9 41 3 6 50 2 4 7-8 62 4 6-7 9 72 6 8 87 90 2",
    ": 8 400 4 6 8 13 21 5 9 31 3 6 42 4 6 50 2-3 9 61 3-4 7 9 74 6-7 80 4 6 90-1",
    ": 502 6 14 6 8 21-2 4 6 30 2 4 40 6 9 54 6 9 63 7-8 74 6 80 2 4-5 7 9 93 5 7",
    ": 9-600 2 4 8 11 4-5 9 26-7 9-30 3 5 42 5-6 50-1 3 6 8 60 2-3 6 70 2-3 5 7-8 80",
    ": 4 91 3 8 707 10 2 4 6 23 5 35-7 44 6 50 2 7 9 62 6 8 70 3-4 8 82 4 6 91 3 803",
    ": 5 7 12 4 8 21 5 8 33 5 7 9 41 3 5 7 9 53 5 61 3-4 79 81 4 95 902 4 6 8 10-1 5",
    ": 7-8 20-1 4 6-7 9-31 6 8 40 5 7 9 53 5 7 9 65 7 9 71-2 5 7 9 81 3 5 7 9 91 3",
    ": 9004 9-10 2 6 8 22 4-5 7 9 31 3 5 7 9 41 4 51-2 5 7 60-1 8 70 2 4 7 9 83 5 91",
    ": 4 6 100 2 4-5 11 5 9 32 5 7 9 43 7-8 50 2-3 5 9 61 3 5 7 71 3 9 81 7 9 92 4",
    ": 202 4 6 8 10 2 7 21 3 9 32 4 6 8 40 2 4 6 8 51-2 4 8 60 2 4 6 70 4 6 80 4 7",
    ": 91 3 8 301 3-4 7 11 5 7 9-20 2 4 6 33 8 41 3 50 4 6 8 60 4 6 72 4 6 8-9 81-2",
    ": 6 93 9-400 2 27 9-30 2 6 9 45-6 8 55 61 9 74 9 84 6 8-9 93 5 7 9 503 5 8 10 2",
    ": 4 6 22 4 6 8 30 2-3 6 8 42 9 51 5-6 8 60 6 72 6 85 8 92 6-7 601 4 8 12 4 6 8",
    ": 20 2 5 9 36 40 2 50 2 4 6 8 60 5 76 8 81 3 5 8 90 2 4 6 8 700 2 5 7 11 4 6-7",
    ": 20-2 5 9 32 9-41 3 51 5 61 3 6 70 2 7 83 6 95-6 8 800 4 8 10 2 6 8 22 4 6",
    ": 34-5 7 9-40 2 4 6 8 50 4 6 8 61 5 7 70 2 4 80 4 8 93 6 8 900 2 4 9-10 2-3 5 9",
    ": 21 3 5 7 36-7 9 41 3 5 52 60 2 6 8 70 2 4 6 81 3 6 8 92 6 8",
    ": 40000 2 6 8-9 25 7 32 4-5 7 9 42 4 6 50-1 3 6 8 60 2 4 6 8 72 82 4 6 8 90 6 8",
    ": 100 6 8 10 2-3 5 7 23 6 32 4 8 40 4 6 8 55 9 63 5 7 9 71 3 5 81 3 5 8 90 2 4",
    ": 6 8 202 4 6 9 11 3 7 21 3 5 9-30 2 4 6 40 2-3",
    ": 3652 64 73 5 81 5 9 703 22 4 7-8 30 5 8 48 61 3 5 7 89 93 7 9 801 10 2 8 20 3",
    ": 6 8 30 2 6 41 9 53 62 5 8 75 9 86 97 900 3 9 11 5 8 21 4 7-8 31 4 8 40 2 4 9",
    ": 51 4 7 62 7 71 7 80 9 91 8",
    ": 4001 4 6 9 14 6 20 5-6 8-9 31 3 7 9 41-2 4 7 9 59 65 8 73 5 7 81 6 8 92 4 6",
    ": 100 4 6 14 20 2 4 6 8 30 2 4 8 40 2 5 7 54 6 8 61 70-1 3 5 9 81 3 8 92 201 4",
    ": 7 9 12 9 22 6 8 30 2 4 6 42 6 8 50 6 9 61-2 6 73 5 7 81 7 9 92 7 9 303 6 16",
    ": 21 3 5 8 31 6-7 9 49 53 5 8 60 4 7 72 9 81 3 5 9 94 8 402 4 7 10 6 9 24 6 8",
    ": 30-1 3 5 7 43 6 8-9 51 3 7 63 7 74 80 2 4 8 90 2 4 9 502 5 9 11 4 7 21 8 32 4",
    ": 8 44 50 2 60 6 8 72 4 6 80 4 8-90 2 5 600 2 4-5 8 12 6 20 2 8 30 2 4 41 4-5",
    ": 7-8 52 5 8 60 6 8 70 2 8 80 6 94 702-3 5-6 9 14 6 9 21 3 5 31 3-4 8 43 51 9",
    ": 61 3 7 72 83 5 92 6 801 6 13 5 24 33 8 40 2-3 5 7-8 53 5 61 4-5 9 71 3-4 6",
    ": 81-2 4 92 5 7 905 9 14 20 4 6 30 4 6-44 6-8 53 7 66 71 3 6 87-8 93",
    ": 5001 5 7 9 13 6 20 4 31 4 8 42 5 8 50 5 7 9 65 7 74 6 80 4 90 2 5 100 2 8 10",
    ": 2 4 6 8 22 4 6 8 33 8 53 6 67 72 6 81 4 6 90 2 200 6 8-9 12-3 5-7 20-1 8 31 3",
    ": 7 9 44 8 50 4 67 70 2 5 80 3 5 8 90 2 4 300 5 8 10-1 3 5 7 23 5 30 2 43 5 7 9",
    ": 53 5 7 9 61 3 79 81 8 91 3 6 400 3 5 11 8 21 3 5 7 33 5 7 9 41 5 8 51 3 5 8",
    ": 60 2 8 70 2 6 80 97 507 9 14 6 21 7 31 3 6 8 41 6-7 54 7 9 62 4 8 72 8 88 92",
    ": 5 600 4 14 6 24 31 4 7 41 4 6 8 51 3 5 61 3 6 8 70 3 5 80 2 4 7-8 90 4 6 8",
    ": 700 5 7 12-20 2 32-4 6-7 9 42 8 52-3 7 63-5 7 9 71 3 6 93 5 7 9 808 10 2 4 31",
    ": 3 5 7-8 45 52 4 6 60 6 9 71-2 4 86 92 4 6-7 9 901 3 8 10 4 6 23 8 32 4 41 4 7",
    ": 9 56 8-9 68 70 2 5 83 5 8 90 6 8",
    ": 6000 2 5 7 11 3 21 5 7 30 2 4 7 9 47 9 51 4 8 60 4 6 71 3 7 9 81 8 90 2 6 107",
    ": 21 3 5 7 31 3 5 7 40 6 50 4-5 7 9 62 5 9 71 3 7 9 84 92 5 208 12 4-5 7-8 20-2",
    ": 5 33 47 51 3 6 64 70 8 80 2-3 5 92 4 6 9 301 3 13 5 7 23 5 7 9 31 6 41 56 8",
    ": 61 6 8 70 2 4 83 5 95 7 9 401 3 9 21 8 30 2 4 42 4 51 61 6 9 71 5 7 9 83 9 91",
    ": 4 6 500 3 5 7 10 7 20 2 5 7 30-1 8 40 50 4 7 61 4 78-9 81 4 92 600 2 4 10 2 5",
    ": 7 9 24 9 32 4 6-7 41 3 55 9 62 5 8 70 2-3 5 9 81-2 91 5 7 703 18 35 7 9 46 50",
    ": 3 7 60 2 4 8 71 5 7 9 81 4 6 8 90 5 7 9 806 8 10 2 8 20 9 33 5 43 5 8 50 3 5",
    ": 63-5 74 6 81 3 5-6 95 900 3 5 7 9 20 2 6 9 31 3-4 8 41 3 8 50 2 5-6 61 3 5 8",
    ": 70 2 8 80 3 8 92 6",
    ": 7000 5-7 11 5 20 2 8 30 5 7 9 41 6 8 50 2 61-2 4-7 83 5 90-1 3-6 101 3 5 15",
    ": 21 6 8-9 32 43 67 71 3 6 8 80-1 5 90 2-3 5 7-8 200 3 5 7 9 12 5 25 7 30 4 6",
    ": 9-40 2 6 9 55-6 9 63 6 8 70 2 6 8 82 6 99 302 6 9 15 7 9-20 2 6-7 34 8 40 6 8",
    ": 52 9 61 6 8 70 2 4 9 81 3 9 93 5 7 400 4 6 8 14 9 22 6 34 6 8 46 8-9 55 7 68",
    ": 73 83 5 9 93 5 7 9 501 4 14-5 9 21 7 31 9 41 3 5 7 9 51 5 7 9-60 2 7 9 77 9",
    ": 81 9-90 2 4 7-8 600-1 3 5 7 12 4 6 8 21 34 6 8 40 50 2 4 6 8 61 3 5 8 70 2 5",
    ": 7 81 7 9 91 4 702-3 5 8 12-3 5-6 8 21-2 6 30 2 41 5 8 50 2 6 62 72 4 6-8 80 2",
    ": 4 6 90 5 8 801 3 8 17 9 22 6 30 3 5 7 43 6-7 9 51 3 7 61 7 71 3 5 7 84 90 3 7",
    ": 9 901 3 5 11 3 5 7 20 2 6 9 31 3 5 7 47 9 53 6 8 60 2 4-8 75 81-2 7 9 93 5 7",
    ": 8002 8 10 6 20-1 7 30 4 8 40 6 50 3-4 6 8-60 2 8 81 5 7 9 93 102-3 7 9 14",
    ": 24-5 8-9 32 4 8 40 4 6 55 7-9 61 7 70 4 6 8 90-1 8 200 3 5 10 2 6 8 20 3 5 7",
    ": 40 2 4 8 50 3 6 8 67 74 8 81 3 90 9 301 11-2 4 9 21 4 6 8 33 5 42-3 5-6 8",
    ": 51-2 8 60 2 5-6 75 8 90 2 4 6 401 3 7-8 20 3 7 32 6 40 3 7 9 51 3 8-9 66 77",
    ": 80 2 9 97 9 502 4 7 10 5 21 4 6 9 31-2 4-5 7-8 40-2 7 54 6 62 72 6 9 84 6 8",
    ": 90 4 604 7 11 3 5 7 9 21 3-4 6 8 33 7 9 41-2 4 6 51 3-4 6 8-9 63-4 6 9 71 7",
    ": 80 2 4 6 8 90 2 6 8-9 701 3 8 10-1 3 5 24-5 7-8 31-2 4 6 8 40 3 5 52 7 61 3 9",
    ": 71 81 5 9 92 4 801 15 7 23 5 9 41 4 50 5 7 9 61 7 73 5 8 80 2 4-5 7 92 4 901",
    ": 8 11 3 5 7 20 4 6 8 35 9 41 5 7 9 51 5-6 62 4 6 8 70 2 4 7 80 3 92 6",
    ": 9002 7 9-12 6-7 20 2 4-5 9 31 3 5 7-8 43 7 9 51 9 65 9 73 5 7 81 3-4 94 8 107",
    ": 9 11 5 21 3 5 7 9 31 8 50 2 4 6 60 3 5 75 7 9 84 98 200 2 7 9 21 5 7 9 34 6 8",
    ": 43 5 7 53 60 2 4 7 9 71 3 6 80 3 7 93 7 301 4 8 10 20 3 5 8 30 2 8 40 7 9 52",
    ": 7 9 61 3 70-1 3 5 7 9 83 7 9 91 4 8 401 4-5 8 11-2 4-5 7 21 4 7 35 7 9 41 7",
    ": 51 5 7 64 6 9 71 3 5 8 80-1 5-6 90 2 9 504 6 8 11 3 7 20-1 3 5 8-9 33 5 9 41",
    ": 5 50 7 62 4 78 80 4 6 98-9 604 7 9 11 3 6 9 34 8 42 6 8 51 3 5 63 76 8 80 2 4",
    ": 9 91 3 7 9 704 10 4 9 21 3 5 9-31 5-6 40 4-5 9 56 8 60 4 8 70 4 82 6 8 90 5",
    ": 7-8 800 4 6 8 10 2 4 7 9 25 7 9 32 8 41 3 6 50 2 64 6 8 73 7 9 81 3 97 9 901",
    ": 3 8 14 7 9 32 5 7 9 43 5 7 51 8 60 2 70 2 4 6 8 80 4 6 90 5 9",
    ": 50004-5 7 14 7-8 21 3 5 7 37 9 41 3 5 7 9 58 60 9 71 9 84 7 9-90 3 8 103-4",
    ": 13-4 6 8 20 8 32 5 7 9 41 6 50-3 6 8 62 4 9-70 6 82 4 7 9 97 9 205 8 10-1 3 9",
    ": 22 4 7 9 33 6 41 3 6 8 51-2 4 6 65 7 71 3 6 80 2 5 7 9 91 5 8 308 10 2 4 6-7",
    ": 21 3 5 7 31 5 45 7 51 9 64 72-3 8-9 82 6 9 95 7 400 2 9 11 3 6 8-9 21 3 6 36",
    ": 9 41-2 4 7 9 51 5 7 9 62-3 5 7 72 6 80 2 5 9 91 6 504 6 8 10 6 8 20 2 9 36 8",
    ": 41 3 5-6 9 51 3 5 7 66-7 70 2 5-6 85 7 90 3-4 6 9 601 3 5 7 9 15 20 9 34 6 8",
    ": 42 6 50 2 4 7 9 62 6 70 2 4 82 92 4 700-1 6 11 24 8 31 4 7 9 43 5 9-50 63 5-6",
    ": 8 70 80 2 4 8-9 91 5-6 800-1 4 6 10 9 21-2 6 8 30 6 9 45 9 56 8 60 3 5 7 84 6",
    ": 9 96 8 901 3 15 24 6 9 31-2 4 6 8 40 4-5 51 3 5-6 9 62 4 6 71 5 81 92 6",
    ": 1001 6 8 11 4 21 3-4 9 33 7 54 7 60 71 3 5 8-9 82 6 8 92 4 9-100 4 6-7 17 9",
    ": 21 34-5 43 5-6 8-9 51 3 6 8 61-2 6 8 70 5 82 9 91 7 201 3 7 9 12 6 8-9 27 30",
    ": 4 6 42 50 60 6 8 70 4 6 8 85 94-6 8 303 6 8 10-1 3-8 22-3 5 8 30 2 4 6 9 45 7",
    ": 51 6 8 60 4 7 9-70 2 4 6 8 83-4 6 8-9 91 5 406 8 12 4 21 5 7 30 4 7 9 41 7 9",
    ": 53 62 4 7 9-70 2 4 8 80 94 6 501-2 6 8 10 7 21-2 4 6-7 40 2 4 6 8 50 2 7 9 63",
    ": 9 72 4 6 81 3 5 7 93 603 5 9 11 3 6 9 21 8 30 3 6 9 41-2 7 9 57 9 61 7 71 3 5",
    ": 8-9 83-4 6 8 90 9 714 6 23 5 9 37 9 41 3 5 7 50 4 8 60 4 6 8 70 2 4 7 81 90 3",
    ": 8-9 802 5 10 5 8 23 7 9-30 2-3 5 8-9 41 7-8 57 66 8 73 7 9 85 9 91 3 7 9 903",
    ": 5 7 10 3 6 20 4 6 32 4 6 8 42 8 50 8 60 3 75 8 80 7 9 92-4 6",
    ": 2005 12 8 22 4 6 8 30 4 6 44 7 9 54 7 9 64-5 70 2 5 9 81 4 6 91 3 6 9 101 6",
    ": 11 7 20 2 7 34 8 40 2 5 7 55 7 9 63 5 76 8 200 2 4 7 12 4 21 4 8 30 6 9 41",
    ": 3-4 6 8 50-3 5 7 9 61-2 4 6 9 78-9 85 7-8 91 3 5 8 301 5 10 7 9 23 5 7 31 5 7",
    ": 41 3 7 9 51 5 7-8 63 5 71 3 5 7 82 5-6 91 3 8 400 10 2 5 7 24-5 7 30 2 5 7 52",
    ": 4 7 9-60 2 5 7 9 77 9 82 4 7 9 92 5 502-3 6-7 9 17 20 3 7 9 31 5 9 41 4 6 8",
    ": 52 6 8 66 70 2-3 9 81 3 91 3-4 6-7 600 3 6 16 8 24 6-7 9 31 7 40 2 6-7 55 7 9",
    ": 69-70 2 4 6 80 2 4 95 706 16 21 3 41 3 5 7 53 5 74 6 8 80 9 802 4 6 8 10 2 4",
    ": 7 30 3 40 7 52 5 62 6 71-2 4 8 80 4 9 95 901 4 6 8 10 4 6 8 20 2 4 32 4 41 3",
    ": 5-6 52 4 7 61 3 5 7 82 5 8 90 3 5-6 8",
    ": 3000-2 4 6 18 21 3 5 7 9 31 3 7 41 3 5 7 53 9 61 3 5 7 71 3 7 9 84 7 97 9 101",
    ": 3 5 7 9 11-2 4 6 9 22-3 6 31 51-3 5-9 61-4 7 9 71 3 7 9 81 3 5 7 93 5 7 204 6",
    ": 10 2 26 8 34 8 40 2 7 61 9 71 3 5-6 9 86-7 9-90 4 7 301 8 11 3 5 22 4 8 32 4",
    ": 6-7 9 47 9 69 75 9 81 3 6 9 91 3 5 400 8 15 7-8 24 8 32 4 6-7 40 2 7 53 5 65",
    ": 7 9-70 2 4 6 8 85 7 91 3 8 500 2 15 26 9 33 5 7 40 2 6 52 8 60 2 73 6 86 9 91",
    ": 3 600 2 8 11 3 5 9 24 7 9 31 3 7 9 48-9 51 3 5 7 9 71 3 5 7 81 4 6 8 90 3 5",
    ": 703 5 11 4 6 8 21 3 5 9-31 7 44 7-8 50-1 6 8 60 2 5 7-8 72 4 6 8 84-5 7 91-2",
    ": 4-6 802 4 7 9 13 5 8 23 31 3 5 7 9 42 5 7 9 51 60 7 9 71 3 7 9 86 8 90 2 4",
    ": 6-7 9 901 7 9 13 6 22 4 32 4 44 51 3 5 8 60 2 4 6 70 2 4 6 9-81 3 92 4 9",
    ": 4002 11 4 27 9 38-9 43 53-4 6 8 60-1 3 5 7 70 2 4 6 8-80 2 4 94 6 8 100 2 8",
    ": 12 6 26 8 30 2 4 6 9-40 2-3 5 7-8 50 4 8 60 2 4 6 9 71 5 9 85 92 4 7-8 200 2",
    ": 4-5 7 9-10 4 6 8 20 7 31 3 5 7 9 41 9 51 4 6-7 9 64-5 70 82 90 2 5 7 9 306 18",
    ": 22 4 6 30 4 6 40 2 6 8 52 4 6 8 63-4 9 71 9 82 8 92 4 402 5-6 8-9 13 5 20-1 6",
    ": 8-9 31 3 5-6 42-3 6 8 50 5 7 9 61 3 5 7 9 79 81 4 90 4 6 502 4 6 10 2 4 6 8",
    ": 20 2 7 9 31 4 41 5 9 51-3 6-7 71 82 4 9 93 5 7 9 607 9 11 6 8 21 3 5 7-9 32",
    ": 41 3 53 7 9 65 7 9 75 84 6 93 8 702 4 6 12 4 7 9 29 34 40 4 54 8 62 72 6 9 85",
    ": 9 92 6 800 5 7 10 7 9 21 7 30 2 4 6 40-1 3-6 50 3 5 7 63 5 7 70 6 8 80 6 90 4",
    ": 6 9 902 4 6 10 2 5 22 5 8 30 2 4 42 4 7 9 54 8 60-1 3 5 9 72 4-5 8 80 4 8 96",
    ": 8",
    ": 5003 5 9 12 4 20 4 6 30 42 4 6 8-9 52 5 8 62-3 5 73 6-7 9 81 7 100 3 5 7 14 7",
    ": 9 25 7 9 33 5 7 42 6 9 51 3 5 62 6 74 6 80-1 3 5 7 92-6 9-200 2-3 5-6 8 12",
    ": 8-9 22 5 7 37 49 51 7 62 7 70 5 7 83 5 7 91 308 12 7 9 21 3 6 9 31 3 5 7 40 3",
    ": 5 8 50 3 61 3-4 7 72 4 86 8 95 8 400 3 7 12 4 24 6 31 3 5 7 40 5 9 56 8-9 63",
    ": 5 7 9 71 5-6 8 80 2-3 7 90 2 4 6 503 5 7 9 13 5 24 7 9 39 41 6-7 50 2 5 7-8",
    ": 60-1 4 70-1 3 7 9 81-2 4 7 9-90 5-6 8 600 3 5-6 9 11 5 9 25 7 35 7 41 3 7 51",
    ": 4-5 9 61-2 6-7 76 8 80 3 96 9 702 4 6 10 2 4 20 6 9 34 7 40 6 50 2 4 9 61 70",
    ": 2 7 81 4 6 94 8 808 12 4 23 9-30 3 9 41 3 8 52 4 6 8 63 5-7 73 9 88 90 2 4 8",
    ": 900 2 4 6 8 13 23 5 9 37 9 43 5 7 52 5 7 60 2 4 6 70 3 5 9 81-2 6 8 91-2 4 7",
    ": 9",
    ": 6001 3 5 7 10 4 20 5 8 30 2 4 8 40 3 51 3 65 9 71 6 8 80 2 4 6 8 91 5 8 106 9",
    ": 11 3 7 9 21 3 7 31 4 7 9 46 8 57 67 9 72 8 84 6 201 8 10 2 5 8 20 2 4 6 34 9",
    ": 41 3 5 50 3 7 60 2 5 7-8 78 80 2 4 9 91 4 8 301 3 6 8 10-1 6-7 9 22 30 3 40 3",
    ": 5 7 9 51-3 5 9-60 7 9 71 9 88 90 2 6 400 7 9 13 6 9 21-2 5 7 9 31 7 9 41 3 7",
    ": 50 2 8 60 4 7 9 74 81 96-7 500 6 8 10 2 5 8 20 4 6 8 33 9 41 4 53 5 8 61 3 5",
    ": 8 71-2 4 7-8 81 9 93 5 7 601 7 9 11 3 6 8 21-2 4 8 33 5 42 4 6 51 6 62 4 6 8",
    ": 73 7 9 83-4 8 90-2 4 6 8 702 10 2 4 6 8 22 4 6 8 30 3 5 9 43 5 9 51 3 5 7 63",
    ": 6-7 9 71 3 6 80 7 9 91-2 4 6 801 3 5 7 9 11 3 20 37 44 8-9 51 9 62 4 6 73-8",
    ": 80 3 5 7 95 9 905 10 2 6 8 22 35 7 45 9 51 3 5 7 62 4 6 8-9 71 3 7 81 3 6 8",
    ": 92 4-5 7 9",
    ": 7006-7 9 14 6 8 20 4 8 36 8 40 5 8 50 6 60 4 71 3 7 81 6 91 3 5 7 9 101 3 8",
    ": 10 2 22 4 7 45 7 9 54 6 8 60 2 4 7 9 72 6 8 80 4 6 8 90 2 4 6 8 202 4 10 2 8",
    ": 21 3 5 8 36 8 42 5 7 9 52 4 6 9-60 3 5 7 74-5 83 5 9 91 3 304 6 12 4 7 20 3 5",
    ": 7 44 6 53 6 61 5 7 71 7 9 82 6 8 93 6 8 406 8 14 6 8 21 3 8 37-40 2 50 2 4 8",
    ": 61 3 70 4 6 80 2 4 8 90 2 5 7 9 507-8 12 4 8 23 5 8 30 9 49 51 3 6 8 63-4 6 8",
    ": 70 3 5 7 80 4 7 91 3 600 2 5-6 8 10 2 5 9 21 5 7 38 40 2 4 7 9 53 5 7 64 7 70",
    ": 2 5 7 92 7-703 5 7 9 12 4 6 9 21 3 5 7 31 3 7 40 2 4 6 8 50 2 4 6 9 67 9 75 7",
    ": 9 81 4 6 8 90 5 807 11 4 6 20 31 3 5 8 40 2 4 8 50 2 4 61 4 6 8 74 6 85 9 91",
    ": 5 902 5 7 9 11 3 5 7 9 25 7 30 2 5 7 9 46 9 51 3 6 8-9 61 6 9 71-2 4 6 8 80 7",
    ": 9 91 3 5 7",
    ": 8005 8 11 7 9 27 9 31 3-4 9 45 56 8 60 8 70 2 8 87 9-93 5-9 105 13 5 8 22 7",
    ": 33 7 41 4 8 61 3 71 4 6 8 84 6 8 91 4 6 202 5 7 9 12 5 7 23 6 30 5 43-4 8 51",
    ": 3 8 62-3 5-8 70 2 4 6 8 80 2 7 90 3 5 300 2-3 7 9 11-2 25 7 31 6 8-9 41 54",
    ": 8-9 61 7 73 8 81 3 5 7 93 400 2 4 7 9 11 3 5 7 9 22 4 6 8 36 8 40 5 7 9 51 3",
    ": 5 61-2 8 70 4 6 8 82 8 91 3 500 5 7 9 13 23 7 32 6 40 2 4 6-7 9 52 6 8-9 62 6",
    ": 71 81 8 96 8 600 4 10 6 8 21 4 6 8 33 8 42 4 6 8 50 2 4 6 60 2 5 7 70 2 4 6 9",
    ": 86 91 3 5 7-9 701 6 9 16 9 22 4 9 31 43 5 8 53 5 7 9 64 6 8 70 2 5 81 7 9",
    ": 92-3 5 7 9 801 4 6 8 11 8 20-1 3 5 7 31 5 7 9 41 3 5 7 58-9 61 3 5 7 9 72 6 8",
    ": 82 4 91 3 8-9 901 3 6 11 6 8 20-1 3 5 30 2 4 6 41 3 6 8 50 5 7 9 61 6 9 73 9",
    ": 90 2 5 7",
    ": 9000 2 4 6 12 4 6-8 21 3 7 48 61 4 6 73 9 86 8 94 6-7 9 105 8 14 6 9 21 5 7 9",
    ": 35 7 9 41-2 51 4 6 9 61 6 8-9 71 3-4 7 80 5 7 9 91 4 201 5 7 14 6 25 7 9 31 3",
    ": 5 9-40 2 7 9 52 4 8 60 4 8 71 3-5 7 80 6 8 91 7 9 301 3 7 9 11 3 6-7 24 8",
    ": 33-4 6 45 8 50 2 9 61 3 5 9 71 6 81 3 7-8 90-1 8 400 2 4 6 12 4 22 8 34 6 8",
    ": 42 54 6 8 61 4 8 71 3 6 8 80 2 4 6 90 2 501 6 8 13 7-8 20 2 4 7-8 33 5 7 42 4",
    ": 7 9 51 4 9-60 2 9 72 4 6 80 2 4 7 90 3 5 9 601 3 15 9 21 4 6 8 33 5 8 41 8 50",
    ": 4 8 60 2 5-6 8 76 8 81 4 92 704-5 7 11 5 7-8 23 9 32 4 6 8 40 3 8 52 6 62 4-5",
    ": 75 7 9 82 5 98-9 801 4 6 13 5 8 20 3 6 8 30-1 3-4 7 9 41 4 8 51 3 6 60 2 4",
    ": 6-7 9 73 5-6 80 2 6 8 92 901-3 7-8 13 5 21 3 5 7 30-1 3 6 8 42 4 8 51 3 7 62",
    ": 4 7 71 80 3 5 7 90-1 3 5-6 8",
    ": 60000 3 7 10 2 5 23 5 8 33-6 9 43 55 7 60 2 78 80 2 5 91 3 7 9 104-5 7-8 10 7",
    ": 9 32 5 40 51 6 60 71 8 81 94 9 202-4 8 10 21 3 5 7 9 33 5 7 43 5 7 52 5 9 62",
    ": 4 8 74 9 81 4 94 6 9-300 2 4 6 8 10 9 25 7 9 31 3 5 7 9 41 3 6 54 6 60 6 9 73",
    ": 8 80 2 4 90 2 4 6 8 400 12-3 6 8 27 9 33 6 9 42 6 8 51 3 5 7 9 61-2 4 8 73 80",
    ": 6 8 90 4 6 505 7 10 2 4-5 9-21 3 5 7 9 31 4 8 42 4-5 9 51-2 6-8 60 5 8-9 71 3",
    ": 8 80 5-6 90 2 4 7 602 4 6 8 10 2 23 5 7 37 42 5 7 51 5 9 61-2 5 7-8 70 3-4 6",
    ": 8 82 5 8 92 700 4-5 24 7 9 45 8 50 2 61 8 70 8-9 81 3 5 7 9 91 4 8 801 4 6 8",
    ": 11 3-4 8-9 21-2 4 6 9 32-3 5 7 41 8 50 2 4 6 8 60-1 3 5-6 8 72 5 7 9 81 90 2",
    ": 4 9 905 7 11 4 22 7 9 36 8 40-2 5-6 9 51 5 69 73 6 80 90 2 5 7",
    ": 1002 6-7 11 3-6 20-2 7 33 8 41 6 8 50 3 9 62 72 4 87 94 100 6 11 3 5-7 9-20 2",
    ": 4 6 8 31-2 4 9-41 3-4 6 8 51 3-4 8 61 8 74 6 8 81 4 6 92 5 201 10 2 4 6 8",
    ": 21-2 4 6 8 39 43 7 52 4 8 64-5 7 9 76 8 80 3 93 6 9 305 9 15 7-8 21 33 5 8 40",
    ": 6 8 50 4 62 5 7-8 73 5 7 9 81 8 98 401 3 8 11 3 20 3 5 33 5 50 2 4 7 9 63 5 7",
    ": 72 4 7 9 87 91 4 7 9 501 11 6 8 21-2 6 30 41 9 51 4 8-9 66 8 70 3 5 7-9 81 7",
    ": 9 92 4 6 9-600 8-10 6 8 20 2 4 6 8 30 4-6 9 42-3 5 50 4-6 8 63 6-9 73 5 9 85",
    ": 90 2 5 7 9 703 5-6 8 15 7 22 4-5 7 9 32 4 6 41 3 5 7 50-1 3 7 9 61 4 6 71 6 8",
    ": 80 6 90 2 4 6 808 19 24 7 9 35 41 3 7 9 51 3-4 6 9 61 5 9 71 3 6-8 81 6 95",
    ": 900 4 6 14 8 25 8 31 3 7 40-1 3 5 7 9 51 3 5 7 60 3 72 4 81 4 91",
    ": 2000 2 4 6 8 13 8 24 6 36 46 51 6 64 74 6 9 83 5 7 96-7 9 101 4 14 6 8-20 4 6",
    ": 31 6 8 40 2 4 7 51 4 61 3 5-6 8 70 4 6 8 85 90 200 4-6 10 2 7 21 3 9 31 3 5",
    ": 42 4-5 8 58 60 4 7 9 71 3 5 8 80 3 5 90 2 4 6 8 300 2 7 9 15-6 22 4 6-7 9 31",
    ": 3 6 41 5 7 50 2 5 7 9 62 4 7 70 2 81 3 5 9 91 3 5-6 8 400 2 4 12 4 6 8 24 30",
    ": 3 7 42-3 5 7 52 5 7 60 9 75 84 6 8 90 2 6 8 500 2 7 9-10 3 5 7-8 26 34 9 42 4",
    ": 6 51 7 67 73 5 7 9 82 4 6 8-9 95 9 607 12 4 9 23 6 30 2 4 40 2 6 54 6 8-9 61",
    ": 3 5 7 9 71 3 5 7 9 81-2 4 6-7 9 93 7 9 701 7 14 6 22 6 8 30 2 4 40 3-4 8 50 4",
    ": 6 64 71 3-4 6 8 84 7 9 91 9 804 6 8-9 11 3 22 4 7 30 2 4 6 8 43 5 9 52 68-9",
    ": 80 2 7 91 4 7 900 2 4 7 9 11 4 6 9 21 5 30 2 4 6 8 41 3 9 52 4 7 68 70 2 4 7",
    ": 9 87 92 4",
    ": 3005 21 4 9 31 3 8-9 42 4 55 7 9 62 5-6 70 2 5 7 85 8 90 6 100 2 14 6 21 3",
    ": 5-6 31 3 9 42 4 55 9 61 4 6 70 4 7-8 81 3 5 9 91 3-4 8 200 4 9 12 7 20 2-3 5",
    ": 7 30 2 4 6 42 7 52 8 60 70 2 7 9 87 9-90 3-4 6-7 9 301-2 5 10-1 5 7-8 22 4 7",
    ": 9 31 7 9 42 4-5 7 55 7 66 8 71 9 85 7 92 4 6 403 9 11 7 27 9 31 5 8 40 2 6 8",
    ": 50 2 7 62-3 77 9 81 3 8-9 93 5 7 9 501 3 5 9 11-2 7 23 5 7 9 32 4 6 9 42 9 51",
    ": 5 61 4-5 7-9 72 4-5 9 81-2 7 9 92 5 7 9-600 3 6 8-9 11 3 5 7 25 7 31 6 40 2 4",
    ": 6-7 50 2 5-6 61 3 5 7 70 4 8 80 4 91 5 8 704 8 10 4 6-7 22 31 6 8 41 3 6 54 6",
    ": 9 61 3 5 7 73 9 81-3 7 90 2 4 6 802 4 11 3 6 8 20 6 8 32 5 9-40 2 7 52 4 6 62",
    ": 7-8 70 2 84 6 9 91 5 7 912 22 5 7 32 6-7 9 41 3 6-7 9-50 3 5 7-8 64 9 78 83 5",
    ": 94",
    ": 4004 6 8 10 5 7 9 22 4 7 31 5 7 41 3 7 9 52 4 8 61 4 73 8 80 4 91 4 106 8 10",
    ": 2 4 6 8 21 4-5 8 33 44-5 55 8 61 6 73 5 7 9 85 90 6 9 201 3 10 4 20 2 31 3 44",
    ": 6 9 62 70 5 8 81 5 95 7 9 303 8 10 5 20 2 5 8 32 7 42 5 8 50 3 6 62 4 7 9 72",
    ": 4 6 8 80 5-8 93-4 402 9 11 3 8 20 7 9 31 4-5 7-8 40-1 5 7 9 58 65 74 6 8 81 3",
    ": 6 8 90 6 8 500 4 7 9-10 3 5 7 23 5 34 44 8 50 3 6 60 3 5 9 71 6 8 81-2 5 7 91",
    ": 7 9 603 7 10 2 4 9 21 5 7 33 5 42 5 9 55 7 9 64 9 71 6 80 2 5 8 90 2 4 707 9",
    ": 21 3 5 9 42 51 4 9 63 5 73 5 7 9 89 91 4 7 9 804 6 8 10 2 4 8 29 31 3 5 7 40",
    ": 2 5 51 3-4 7 64 7 73 5 7 9 82 8 96 8 901 3 5 8 10 2 4 6 25 8 30 8 41-2 6 8 50",
    ": 2 7 60 7 70 2 4 6 8 83 6-7 90 4",
    ": 5000 2 5 7 10 2 4 9 21 3-4 9 31 4-5 7 40 4 6 55 8 60 2 4 7 9 77 9 81 3 5 7 9",
    ": 91 3 7 9 106 8 12 6 9 21 4 6 32 6 8 41 50 6 60 3 5 7 9 74 6 80 2 4 6 8 90 2 6",
    ": 200 5 10 2 4 6 8 20 4 7 9 36 40 3-4 6 9 63 5 70 4 6 8 80 2 8 90 2 4 6 8 303-4",
    ": 7 9-10 3 5-6 24 6 31 3 5 7 40 4 6 50 2 6 9 61 3 6 8 72-3 5 9 81 5-6 93 6-7",
    ": 401 3 6 8 10 3 5-6 8 22 4 31 3 5 7 47 50-1 3 5 7 9 73 5 7 80 5 94 9 504 6 8",
    ": 10 5 7 24 36 8 40 2 4 7 53 66 71 3 5 7-8 87-8 90 4 6 604 6 11 3 5 9 25 7 31 3",
    ": 5-6 40 3 5 7 9 58 60 2 5-7 73 5 80 2 8 90 2 4 8 700 2-3 5 10 2 4 20 3 7 30 2",
    ": 40-1 3 9 53 5 8 61 4 6 74 6 8-9 83 9 91 3 5 800 2 7 13-5 8-21 4 6-8 30 2 6 43",
    ": 7 9 51 6 63 5 7 71 3 5 9 81 3 5 90 4 9 902 4 6 13 7-9 29 32 5 41 5 7 51 3 8",
    ": 60 2 4 9 73 5 9 81 3 5 7 97",
    ": 6000-2 4 6 8-9 13 7 21 9 31 3 8 40-1 3 7 51 7 9 61 3 6 70 3 82 4 6 9 93 6 102",
    ": 5 8 15 21 6 31 5 8 43 6 9 54 6 65 9-70 2 4 8 80 2-3 5-6 9-91 3 7 9 203 8-9 11",
    ": 4 6 8 20 2-3 6 8 30 2 5 48 55 7 9 61 6-9 75 7 80 91-2 4 303 5 8 10 3 5 7 9 21",
    ": 5-6 8-9 31 3 40 5 8 51 3 5-8 61-2 4-5 8 74 6 80 7 90 2 4 6 8 405 7 9 18 23",
    ": 7-8 42 4 6 8 53 7 9 66 8 72 4 6 8 81 8 91 4 9 501 4 6-8 10-3 8 23 5 32 7 40",
    ": 50 3 5 8 63 70 2 4-5 7 80-1 4 91 9-600 7 9 11-2 6 25 34 7 9 44 53 6 64 9 72 6",
    ": 80 2 4 7 9 91 3 7 700 2 5 7 11 6 24 6 8 30 2 4 6-8 40 2 6-7 9 53 63 5 8 70-1",
    ": 8 80 4 6 8 91 4 6 800 2 5 7 9 13 9 21 30 4 6 44 7 9 53 5-6 62 9 74-5 7 9 82 4",
    ": 6 90-1 3-5 7 9 901 3 5 7 9 12-3 5 20 2 4 6 9 35 8 40 2 6 9 51 3 8 60 5-6 70-1",
    ": 7 9 81 3 5 92 4 9",
    ": 7001 9 11 4 8 20 2 4 7 39 41 3 5 7 51 3 6 8 60 4 6 8 71 4-5 8-80 2 4 7 9 92 7",
    ": 9-100 2-5 7 9 11-2 4 6 8 22 4 6-7 31 3 8 42 6 8-52 4 8 60 3 6 9 72 5 8 80 8",
    ": 90 2 5 202 6 8 10 3 7 21 5 9 33 5 47 50 2 6 8 62 4 70 5-6 80 3 5 7 9 92 4 6",
    ": 304 6 12-3 5 8-9 22-4 6-7 9 31 3 5 7 9-40 2-3 6 51-4 6 65 7 9 71 5 7 9 82 5 7",
    ": 9 93 7 403 6 8 10 2 7 9 21 3 6 32 5 7 40 3-8 50 2 7 9 62 4 6 8 78 80 2 5 93 7",
    ": 502 11 3 5 8 21 3 5 7 31 3 5-6 8 40 3 5 56 8 60 71 6 8 81 4 9 98 600 2 11 8",
    ": 24 30 7 40 5 7 9 51 3 7 9 61 3 7 73 7 9-81 3-4 6 8-9 91-2 5-701 3 5-6 9 11-2",
    ": 8-9 23 6 35 40 2 4 6 8-9 51 3 9-60 4 6 9-70 8 80 3 5 9 92 4 7 9 813 5 7 20 3",
    ": 36 42 6 8-9 53 5 8 60 3 71 3 6 8 83 5 9-90 2 4 900 5 10 9 34 7 9 44 53 66-7",
    ": 70 2 5 7 83 7 92 4 9",
    ": 8004 6 8 10 8 21 3 30 42 4 8 50 2 4 9 63 5 9 73 5 9 83 5 7 90 2 8 100 2 6 8",
    ": 10-1 5 7 9 21 3 30 6 40-1 3 8 51 3 5 7 9 61 5 9 71 5 81 4 6 91 3 5 9 205 7 9",
    ": 11 24 6-7 9 32 4 40 6 52 4 8 65 73 8 83 7 9 92 6 9-300 10 3 8 22 4 8 30 2 5",
    ": 40 4 6 9 51 3 6 63 6 70 7 80 3 7 92 5 7 400 3 5 8-9 11 6 8 20 3 5 8 35 7 50 2",
    ": 6 67 9 77 81 94 6 8 500 4 8 10 28 30 2 4-5 7 9 42 9 54 61 5-6 8-9 71 3 7 9",
    ": 85-6 92 5-7 606 9-11 3 6 21 3 6 8 30 2-3 5 42 50 4 7-8 64 6-7 9 71-2 4 7 9 81",
    ": 3-4 6-7 9-90 2 4 8-701 3-6 8 12 4 9 21 3-5 9 31 4-5 7 41 7 50 3 5 63 5-6 70",
    ": 3-5 7 9 81 7 9 91 5 9 801 3 5 7 9 12 4 8 20 3 5 32 4 40-2 4 50 2 4 6 61 3 70",
    ": 2-3 5 9 81 6 8 90 2 4 6 9 904 8 13 5 9 21 3 5 7 33 7 40 9 51 60 6 9 77-9 83 5",
    ": 7 9 92 4 6 9",
    ": 9001 3 5 7 9 11 3 5 20 2 4 30 4 6 41 3-5 7-50 6 8-9 61 3 5 73 5-6 8 80 2 5 7",
    ": 9 92 4 6 102 6-7 9 11 4 9 21 3 5 30 2 4 9 41 5 9 54 7 9 64 6 8 70 6 84 7 9 91",
    ": 3 6 8 200 2 5 7 9 12 4-5 7 22 4 6 8 34 8 40 5 51 4 6-7 63 5 9 72 4 82 6 90 2",
    ": 300 4 8 10 2 4 20 4-5 7 9 33 5-6 9-41 3 6 54 7 9 61 6 8 70 4 7 9 81 5 7 91 3",
    ": 5 7 401 3 9 15 7-8 23 5 7 31 6 46 9 51 6-7 62 4 71-2 8 81 3 9 92 7 500 2-3 7",
    ": 10 3 20 2-3 5 33 9 46 8 50 3 61 6-7 71-4 6 8 80 5 92 5-6 8 600-1 3 11 4 6 8-9",
    ": 21 4 6 32 4 6 8 40 3-4 7 9 52 4 9 61 4 79 81 5 9 93 5 8 700 2 5-6 12 4 7 22-3",
    ": 5 9-30 3 7-8 43 7 52 4 6 63 71 4 6 80 2 4 95 800 4 10 2 4 6 8 23 8 34 9 45 8",
    ": 50 8 60-1 6 8 70 92 4 900 2 4 7 9 14-5 9 26 9 35 8 43 6-7 9 52 5 9 61 5 7 73",
    ": 5 9 83 6 8 91 3 9",
    ": 70006 8 11 3 7 22 4 6 30 4 8 40 4 6 9-50 2 5 7 60 2 4 6 8 72 9-80 3 6-7 91-5",
    ": 7-8 105 9 12 7 9 25 9 34 40 4 6 50 2 7 9 61 3-4 6 8 76 9 81 6 8 90 9 203 8 10",
    ": 2 4 6 25 7 9 31 7 45 7 9 51 6 9 63 71 4 7 82 93 8 300 2 5-6 10-1 6 21 8 30 2",
    ": 4 6 8 47 9 51 3 9 61 4 6 8 70 2 6 82-3 7 90 2 406 8-9 17 21 5 7 30 2 9 41 3 5",
    ": 8 50 3 5 60 2 4 9 71 5 7 81 4 6 92 4-5 7 501 4 6 8 11 21 31 3 6 42 4 7 9 54 9",
    ": 63 5 7 9 73 5 7 80 2 94 8 600-1 3-4 6-7 9-10 2-5 7 9 22-3 5 9 31 9 47 52 5 7",
    ": 9 61 3 5 8 71 80 2 5 9 95 9 707 9 12 6 8 23 6 8 31 3 5 8 41 3 5-6 8 54 6 8 61",
    ": 3 6-7 9 72 4 6 80 9 97 9 808 10 3 7 9 23 5 7 34 6 8 40 4 6 9-50 5 9 63 7 9 74",
    ": 8 82 4 9 92 6 8 900 13 5 22 30 2 4 6 41 7 51 5 7 9 61 4 70 5 7 9-80 3 5 7 90",
    ": 3",
    ": 1005 7 11 3 5 25 31 3 5-6 40 2 4 7 9 51 3 62 4-7 70-2 5 9 83 6 8 91 5 7-9 102",
    ": 8 11 3 5 9 22 4 6 30 2 7 45 7 54 6 60-1 3 71 3 7 82 4 7-8 90-1 5 7 200 4 8 10",
    ": 3 5 7 23 34-6 9 41 3 5 54 7 9 61 4 6 8 75 7 82 5 92 5-6 300-5 12 5 7 9 22-3 5",
    ": 30 2 4 45 7 9 52 4 63 8-9 79 81 3-4 92 7 9 402 11 4 7 24 30 2-3 7 9 43 5 59",
    ": 62 5 7 70 2 9 81 3 7 9 91 6 8 502 4 6 8 13 5 7 9 21 3 31 3 6 8 40-1 9 51 3 8",
    ": 62 70 3 5 7 81-3 6-7 9 91 3 5 9 603 13 5 7 24 8 30 2-3 9 44-5 9 52 6 60 2 4 6",
    ": 8 73 5 7 9 82-3 5 93 6 701 3 9 11 3 5 9 22 4-6 30 2 4 6-7 9 46 8 52 7 64 7 75",
    ": 84 6-7 94 800 3 5 15 9 22 4 7 9 33 5 8 40 2 6 8 63 71 4-6 9 81 3 5 8 90 2 5",
    ": 905 7 11 3-5 7 21 3-5 7-30 3 5 7 40 3 5 7 60 4-5 7-8 71 4 6-7 9 87 9",
    ": 2005 8 18-9 25 30 2 5 41 3 9 59 61 3 5 8-9 72 4 6 8 81 6 90-1 4 9 101-2 4 6-7",
    ": 9-11 33 5-6 40 6 8 51 3 6-7 60 77 80 3-5 7 99 203 5 8 15 8 24-6 8 30 3 5 42 6",
    ": 8 52 4 62 5 79 81 4 6 8 90 2 7 9 302 5 9-10 4 6 8 20 4 6 9-32 8 42 4 6 9 51 4",
    ": 61 3 8 70 3-8 80 2 7 90 4 6 8 403-4 6 8 18 26 38 42 4 7 9 51 3 5 66 8 73 5 7",
    ": 83 7 9 98 500 2 8 10 4 6 20 2 5-7 9-30 2-5 40 6-7 9-50 6-7 60 4 6 8 73 6 80 4",
    ": 8 96 8-9 601-2 4 11 5 9-20 2 4 6 30 5-6 8 46 8 55-6 8 65 7 71 7 9 85 9-90 5 7",
    ": 702 10 3 7 9 24 30 2-3 5-6 8 40-1 4 7 54 6 60 4 6 8 70-1 8 82 4 90 9 801 11 6",
    ": 8 22 6 8-9 31 3 6 8-40 2 4 8 50 2 6 63 5 7 9 71 4 6 8 80 2 90 3 5-6 8 903 7 9",
    ": 12 9 25 38 40 3 51 3 6 60 3 5 7 70 2 8 80 2 4-5 8 92 7",
    ": 9-3000 2 6 10 2 6 8 20 2 4 34 44 6 8 50 8 68 75 83-6 90 2-3 5 7 9 102 4 10-1",
    ": 7 20 2 6 9-30 2-3 5 40 2 4 9 52 5 7 60 2 4 6 8 77 80 9 91-2 4 201 3 5 7 9 19",
    ": 21 6 8-9 31 6 8 41 52 8 61 8 71 3 81 9-90 2 5-6 8 303 9-10 4 8 20 2 7",
    ": 91222-5 8 30 4 6-7 9-40 2-3 5-6 9 52 4 6-65 7 9-72 4 7-82 5 9-92 4-5 8-300 7",
    ": 9 17-8 20-2 4-7 30 2 5-7 42-3 6 53-6 8-60 3-4 6-8 71 3-5 7-9 84 6 8 91 3",
    ": 8-400 2 6 9-13 5-6 8 20 2-3 6 8 30-1 4-6 8-9 42 4-5 9 53-4 6 8 61 3 5 9-70",
    ": 2-4 8 80-3 5-6 9 92-4 9 501 3-5 8 10-1 4-6 8-21 3 6-31 3-4 7-40 2 4-7 9 51 5",
    ": 7 62-6 9-73 7-81 8-9 91-3 6-7 602 5-7 11-5 7 9 24 8-30 4 7-8 40-1 3-7 9 52 4",
    ": 8 60 3 6-7 70-5 7 9-80 3-5 8-9 91 6-700 3 6 8 10 7 9-21 31-2 8-43 5-51 4-6",
    ": 9-60 4-5 8-9 71-3 5 7 81 3-6 8-93 6-7 801 3 5 7-23 5 7-30 6-54 6 9 68-75",
    ": 7-901 6 9 12-5 7-9 22-4 6 8 31-44 6 8-52 4 6-8 62 4 6-8 70-4 6-9 82-6 8 91-3",
    ": 5-6",
    ": 9-2001 4-6 8-10 3 7 9-20 2-3 5-7 9-31 4-5 40 2 4-53 6-61 4 6 70-1 3 8-9 81 3",
    ": 5-92 4-5 8-103 5 10-2 5-8 23 5 7-32 4-5 8-40 2-6 8 50-4 6-60 3-4 8 71-2 4",
    ": 6-80 2-4 8 90 2-3 6-8 200-2 4 6-8 12-23 5-34 6-7 9 41 3-6 9 51-2 5-9 63-9",
    ": 71-4 7-8 81-3 5 9-90 3 7 9-300 2-3 5-7 9-12 4-7 9-22 6-7 32-3 5-6 8-42 4-6 9",
    ": 51-2 4 6-9 61-4 6 8 70 5 7 9-80 2 8 92-9 401-2 5-6 8-10 2 4 6-20 2-4 6-9 31",
    ": 3-5 7-9 41-2 6-8 50-1 4-5 7-60 2-6 8-70 3 5-81 4-9 91-4 6-7 9-503 5 7-8 10-8",
    ": 20-37 9 41 4-7 50-1 3 5-6 8-60 2-5 7-71 3-4 8-80 3-7 9-90 3-4 6-603 5-6 8-13",
    ": 5-21 6-7 31-44 7 53-63 5-9 72-3 5-7 80-3 5-93 9 702-4 6-9 12-3 5-7 20-30 2-41",
    ": 3-4 6-7 9-54 7-9 62-3 5-6 8 75 8 80 2-6 9-90 2-7 800 2 4-10 2-3 6-20 3 6-42 4",
    ": 9-55 7-62 4 7-71 3-94 6-901 4-5 9-11 3-8 21-4 6-7 9-30 2-5 7 40-2 4-50 2-3",
    ": 5-62 4 6-7 71-4 6-7 82-8 90-1 3-6 9",
    ": 3001-3 6-7 9-11 4-8 20-1 3-4 6-7 9-30 3 5-42 4 6-8 51-8 60-2 4-5 8 70 2-7 80",
    ": 2 4 6 92-9 101-8 10-3 6-9 21-3 5-33 5-6 9 41-9 56 8 60-3 5-9 71-4 6-8 80 3-4",
    ": 6-91 4-7 9-200 2-8 10-1 4-7 23-4 6-8 30-6 40-2 4-7 9 51-2 4-63 5 8 72-5 7-80",
    ": 2-5 7-90 2-6 8-9 302-5 7-9 11-2 4-6 20 2-31 4-8 41-3 5-7 9 54-63 5-7 9 71-8",
    ": 80-5 7-94 6-400 2 5-8 10 3-6 8-9 22-7 30-4 6 8 40-2 4-5 7 9-55 7 9-64 6-9 72",
    ": 6-9 83-5 9 91 3-502 4-5 7-17 9-21 3-5 8-30 2-40 2 6-7 9-53 8-67 70-2 4-80 2-3",
    ": 5 7 9-92 4-5 9 602-8 10-5 7-9 21-4 9-31 3 6-41 3-9 51-2 6-7 9-68 70 4-8 80-3",
    ": 5 7-8 90-9 701-3 5 7 9-17 9-22 5 9-33 5 7-8 40 2 5-6 8-53 6-64 6-7 70-4 7 9",
    ": 81 3-5 7-90 3 5-7 9 803-5 7 10-1 3-7 9-21 3-7 9-33 5 9-45 7 9-51 5-7 9-63 6-9",
    ": 71-4 6-80 2 5-8 90 2-4 6 8 901 3-8 12 6 8-21 3 5-35 7 9-46 9-51 4 6 9 62-4",
    ": 6-7 9-73 5-85 7-97 9",
    ": 4001-3 5-14 6 20-3 8-9 31-6 8 40 2-4 6 9-51 3-7 9-64 6-7 9 71-81 3-5 7-92 4 6",
    ": 9 101 3-8 10-2 4 6-20 2-5 7 9 31 4 6 8-9 41-6 51-5 7-8 60-1 7 70-4 6-80 2-7",
    ": 9-91 3 5-204 9 11 3 6-8 20-2 4-35 7 9 41-6 9-50 2-3 5-6 8-65 7-78 80-2 4-91",
    ": 3-4 6-7 9-308 11 3 5 7 9-20 3-9 31-6 8-9 41 5 7-8 50-1 3-4 6 8 60-2 4-6 70-2",
    ": 4 9-91 4-7 401 3-4 6 8-9 11-2 6-21 3-30 4-6 8 41-8 55-9 62-3 6-8 70-1 3 5-8",
    ": 80-6 8-90 2-3 5-503 6 8-14 7-22 4-5 7-8 30 2-4 6-8 40 5-8 51 5-7 9-60 4 6-9",
    ": 72-3 5-6 8 80 2-4 7 90 2-4 6-8 600-2 4 9-21 5 8-31 3-44 6-8 50-2 4 7-62 4-5",
    ": 9-72 5-6 9 82-3 6-9 91-4 6-8 700-5 7-8 10-3 5-6 8-20 2-4 9-33 5 9 42-3 7-8 50",
    ": 2 4-6 8-68 72 4-7 80 2-4 8-90 2 4-5 7-8 800-1 3-4 6 8-9 11-4 6-7 9-20 4-5",
    ": 7-31 4 6 8-40 3 6 8-59 62-4 6-77 9-80 2-4 7-8 90 2 4 7-902 4-8 10-6 8-22 4-48",
    ": 51 3-7 60 3-7 70 2-3 6-9 81 3-4 7 9-95 7-9",
    ": 5001 3-4 6-10 2 4-20 2-3 7 30 2 4-5 7-8 40-3 6-8 50 2-5 7 60 2-9 71-2 5 7-80",
    ": 6-91 5-7 9 101 4-5 7-8 10-6 8-24 7-8 30 3-8 41 5 7-54 9-60 3-5 7-8 71-90 2-3",
    ": 5 7-207 9-14 7 20 2-8 30-2 6-9 41 3-6 8-51 3-9 62-3 5-6 8 70-1 3 7-82 4-7",
    ": 9-94 6 8-307 9-10 2-4 7-23 5-33 6-7 9-46 8-50 2 4-6 60 2-4 6-7 9-70 2 4 6-81",
    ": 3 6 8 90 2 4-403 5-7 9 11-7 9-20 2-34 6-48 52-5 7-63 6-7 9-70 2-9 81-4 6 9-91",
    ": 3 5-9 501-7 9-10 5-9 21 5-30 4-5 7-9 42-6 9 52-5 7 60-2 5-70 5 9 81-2 5-6 90",
    ": 5-6 9 602-3 6 8-9 11 3-8 20-2 4-5 7 9-30 2 4 7-8 40 2 4-53 5 7-8 60-3 5-6",
    ": 8-71 3-6 8-81 3 5-6 90-2 4-7 9 702 5-9 11-2 4-5 7-21 6-9 33-4 7-41 5-6 8-9 51",
    ": 4-60 2-5 8-70 2-3 5-6 8 80-6 8-92 5-803 5-7 9 11 3-5 7-8 21-3 5-6 8-9 31-4",
    ": 6-41 3-4 7 9 51-3 7-8 60-6 8-9 71 3-5 8 80-2 4 6-90 3-900 2-3 5-6 9 11-21 3-5",
    ": 7 31-5 7-8 40-2 6-7 9-52 5 7-8 60-1 3-6 9-71 3-5 7-8 80 2 4-7 9-97 9",
    ": 6001-4 6-7 9-13 5-23 5-34 8-43 5-6 8-68 70-2 5 7-9 81-5 7-8 90 2-6 8-102 4-6",
    ": 9-10 2-3 5 7-25 7-9 31-9 41-4 8-9 51-3 5-7 9-60 2-5 7-72 5-9 82-4 7-9 91-3",
    ": 5-201 3-4 6-7 9-10 2-4 6-22 5-32 4 7-42 4-5 7-55 7 9-64 6-70 2 8 80-1 6-7",
    ": 9-90 2-7 9 301-4 7-8 10 5-30 4-6 8-40 3-8 50-61 3 5-82 5-7 9-94 6-406 9-10",
    ": 6-7 9-23 5-9 32-3 5 7-40 2-3 5 8 50 2-3 5-6 9 61-3 5-9 71-3 5 9-87 9-91 3-7",
    ": 9-500 3 5-7 10-1 3-7 9 22-5 7-34 6 9-40 2 4-5 7 50 2 6-9 61-4 6 9-70 3 7-8",
    ": 80-1 3-4 91-2 4-7 600-4 6 8 10-2 5-7 9 22 4-5 7-33 5-6 8-40 2-5 7-8 50-5 8",
    ": 61-7 70 3-4 7 9 81-4 6-8 90-3 5 7-703 6-7 9-13 5-6 8-9 21-3 6 8 30 3 5-55 7-9",
    ": 63-6 9-71 4-9 81-7 9-801 3-5 8-13 6-7 9-33 6-40 2 6 9-56 9 61-73 5-6 8-85",
    ": 8-90 3-5 900-8 10 3 5-9 22-3 6-8 31-5 7-40 2-8 51-3 5-61 5 70-3 5-7 9 82-6",
    ": 8-92 4 7-8",
    ": 7000 2-4 7-9 11-8 20 3-4 7-9 32-9 41-2 4-5 7 52-3 5-62 4-70 3 5 7 80-3 6-9",
    ": 92-5 9-103 5-7 9-11 3-6 20-37 9-40 2-8 50-1 4-6 8 60-2 4-5 9 72-3 8-80 2-91 4",
    ": 6 8-9 204-13 5-7 9 21-8 30-1 3-43 5 7-9 51-8 60-1 3-4 6-73 6-81 3-5 7-9 91-4",
    ": 6-8 300-1 3 5-8 10-1 3-4 6-7 9 21 3-8 30-1 3-6 9 41 4-61 4-6 9-71 3-6 8-80 2",
    ": 4-8 90-5 7 9-400 3-8 10 2-4 6-20 3-6 8 30 3-5 7-41 3-5 7-55 7-8 60 3 5 7-8",
    ": 70-1 4-6 8-9 81-6 8-90 2-506 8-20 2-4 6-8 30 3-5 7-9 42-3 6-9 51-2 4-6 9 61-2",
    ": 6-8 70-1 3-9 81-3 7-90 2-5 8-603 6-16 8 21-3 5 7 9-32 5-6 8 40 2 5 7-8 50-6",
    ": 8-60 3-5 7-73 6-7 9-81 5-93 6-7 9-700 2-3 5 7-9 13-5 7 9-21 3 5 7-9 31-40 3-4",
    ": 7 9-60 2-5 8 71-2 4 6-83 5-6 8-90 2-6 8-800 2 4 7-9 11-2 4-6 22 5 8 31-3 5",
    ": 7-40 2-7 50 3-4 8 65-76 9 81-3 9-91 4 6 8-9 901-4 6-16 8 20-1 3-5 7 31-7 9",
    ": 41-5 7 9 51-4 7-60 2-4 6-9 72-3 6 8-81 3-5 9-91 3-5",
    ": 8000-1 3-4 6-7 12-4 6-24 6-7 31-2 4-42 4-5 8 50 2-4 7-61 3-5 8-9 71-7 9-81",
    ": 3-5 7-93 6-7 9-114 6-7 9-23 5-8 30-1 3-6 8 40-1 3 5-52 4-60 2-9 71-9 82-4 6 8",
    ": 90-1 5 9 201-7 13 5 7 20-30 3-5 7 9 41-3 8 50-1 3 5-64 6-7 9-75 7 9-82 5 7",
    ": 9-93 5-306 8-9 12-8 20-2 4 6-9 34-6 8-40 2-4 6-8 52-3 6 8-63 6-75 7 9-80 2-3",
    ": 6-9 92-5 8-401 4-5 8 13-6 9-25 7 9 31-3 5-8 41 4-5 7-61 3-73 5-6 80-1 3 5-91",
    ": 3-4 6-7 9 501-3 5-10 2-3 5-6 9-20 3-34 7 40-2 4-8 50-2 4-5 7-63 5-6 71-3 6-83",
    ": 5 7 9-91 4-9 602-5 7-10 2 4 6-20 2-3 8-9 31-3 6-46 9 51-8 60-1 3-72 6 8 81-5",
    ": 8-9 92 4 6-7 703-10 3-4 6 8-28 31-2 4-44 6-8 51-2 5 60-3 5 7-74 6 9-86 9 91",
    ": 3-7 9-803 5-10 2-22 4-5 7-32 5-40 4 6 9-50 5-8 60-1 3-4 6-70 2 4-88 90-4 6",
    ": 8-902 4-5 7-13 5-7 20-1 3-5 7 30-2 4 6-41 3-50 2-5 7-64 8 72-3 5-6 9-84 6-93",
    ": 5-7",
    ": 9-9001 3-11 3-5 21-3 5-8 30-4 6 8-41 3-4 7 50-3 6-61 3-4 8-9 71 5-82 4 7-8",
    ": 91-3 5 9 102-14 6-8 20-3 5-30 2-8 40 2-4 7-9 51 5-62 4-5 7-9 71-3 6-7 9-82",
    ": 4-5 8-9 91 5-7 9-200 3-5 8-10 3-6 9-20 3-4 6-8 31-4 8-43 5-53 7-60 3-5 9-75",
    ": 8-90 5-6 8 301 3-5 8-10 3-7 9-22 5-31 4-5 7-42 5-6 8-51 3-7 9-63 5-70 3-5 7",
    ": 9-80 3-6 8-92 5-402 4-10 4 6-8 20-1 3-6 8-9 31-3 7 41-50 3-60 2-4 7-8 71-3",
    ": 7-82 4-7 92-500 2-3 5-13 5 7-8 21 3 5 8-36 8-40 3-50 2 4-61 3-4 6-74 7-83 5",
    ": 8-9 91-2 4-5 7-8 600 2-3 5-6 9-16 9 21 3-4 7-32 4 6-7 9-52 4-5 9-60 4 7-8",
    ": 70-90 4-7 9 701-7 9 12-3 5-6 21-3 6 8-34 6-7 40-1 4-5 7-52 5-69 71-2 4-5 7-83",
    ": 5-96 8 801-7 10-3 7-24 6 8 30-1 3-6 8-40 3 5-9 51-9 61-2 4-70 3 6 81 4-5 7-8",
    ": 90-1 3-4 6 8-905 10-1 3-7 21-7 30-1 3-4 6-7 9-53 5-60 8-71 3-8 80-3 5-7",
    ": 90-200001 5 7-8 11-3 6-26 8-9 31-9 41 3-4 6 8 51 4-9 62-7 9 71-2 4-5 8-81 4",
    ": 6-9 94-6 9-100 4-5 7 9-14 6-9 21 3-7 9-32 5-40 2-56 8-61 8-70 2-8 82-3 6-8",
    ": 91-3 5-200 3-5 7-13 5-6 8-21 3-4 6-7 9-33 5-8 41-6 8-9 52-7 60-2 6-7 9 73 6 8",
    ": 80 4 9 91 3 6-301 4-6 9-11 3-5 7 9-21 6 8 30-9 44-5 7-50 3-4 7-60 2-4 6-8 70",
    ": 2-3 6 82 4-6 90-6 8-9 401 3-10 2-7 9-24 6-7 9-31 3 5-7 40-5 7-50 2 5-62 4-6",
    ": 9-78 80-91 3-6 9 501-4 6-7 9 11 3 5 7 9 21-36 8-41 3-5 7 9-50 2 4-6 8 61-3",
    ": 6-7 9-76 9-81 3-8 90-3 5 7-603 5-7 10-7 23-6 9-33 46-8 52-3 7 9 61-7 9-72 5-9",
    ": 82 4-92 4-7 700-1 4-7 11-3 6-9 22 5-7 9 32-6 8-42 5-7 9-57 9-60 3 5 7-9 71-2",
    ": 5-9 81-6 9-90 3-9 802-7 10-3 5-6 8-9 23-6 8-9 31-9 41-2 5 8-53 6-9 62-3 6-72",
    ": 4-5 7-9 81 4-9 91-2 4-5 7 9-904 6 8-9 11-3 5-9 24-6 8-30 2-3 5-6 8-41 3-6 8",
    ": 50-2 4-5 7-65 9-75 7-9 81-5 9-90 2-4 6 8",
    ": 1001-2 4-10 3 5 7-20 2 4-7 9 31 3-7 9 42-5 8-50 2-3 5 7 9-63 5-70 3-5 7-83 5",
    ": 7-92 4-6 9 101-3 6-8 11-3 5-8 20-2 4-5 8-33 5-9 42-9 51-2 4-5 7-9 62-6 9-73",
    ": 5-80 2-6 8-94 6-7 201-3 6 9-10 3-9 21-2 4-5 8-37 9 43-4 6 8 50-1 3 5 7-61 7-8",
    ": 70-3 7 9-80 2 4-5 8 96-7 300-7 9-13 5-21 3-8 30-8 40-3 5 8-9 51 3 9-62 4-7",
    ": 9-71 3-4 9-80 3-4 6-7 9-91 3-4 8-400 3-4 8-20 3-5 7-8 30-3 5-7 40-5 7-9 53-9",
    ": 62 4-5 7-8 71-5 7-83 5-8 91 3 5-8 502 7-8 10-5 7 20-4 6-30 2-4 8-40 2-5 7-54",
    ": 6 9-65 8 70 3-4 6 80 2-4 6-8 91 3-5 8-604 6-9 11-4 6 9 22 4 6-8 30 2-3 6-9 41",
    ": 3 6-51 3 6-8 60-2 4-5 8 71 3-8 80-3 5-93 9 702-3 6 8 10-3 5 8 20 3-6 9-31 3-4",
    ": 8-40 5 7-52 4-5 7-60 2-9 72 4-8 80 4-6 8-9 91 4-7 801-5 9 12-4 6 8-9 21-2 4-5",
    ": 7-9 32 4-40 2-7 9 53-5 7 9 62-8 71 6 8-80 2-6 8-90 2 5-8 901-7 9 11-4 6-20",
    ": 2-4 7-30 2-3 5-40 2-50 2 4-8 60-2 4-6 8 71-2 5-83 6 9 91-6 8",
    ": 2001-2 5 10-6 8-9 21 4-6 8 30-1 3-4 6-7 40-5 8-9 51-5 7-62 4-70 2 4-8 80-1",
    ": 4-93 5-7 100-3 5-7 9-10 2 4-6 9-20 2-5 7-30 4-41 4-5 7-53 7-62 5 7-9 71-2 5-9",
    ": 81 3-4 6 8-9 91-2 5-8 200-1 4-11 3-5 7-8 20-2 4 6 8 31 3-4 6-7 9 41 4-50 2",
    ": 4-60 3-6 8-70 2-3 6-82 5-6 90-2 4-305 8-9 11-3 5-7 20 3-4 6 8-35 7-9 41 4-50",
    ": 2-7 60-2 8-76 9-81 4-5 7-96 8-400 2-4 6-10 2-5 7-8 20-2 4-5 8-9 35 41 3 6-54",
    ": 6-8 61-9 72 4-5 7-8 80 2-8 91-5 7-506 8 10 2 5-8 21-2 8-9 31-7 9-43 6-7 9-55",
    ": 7-8 62-3 5-7 9-72 4-6 9-80 2-5 7 9-90 2-5 9 602 5-12 4-5 20-6 8-31 3-5 8-45 8",
    ": 51 4-6 60-3 6-71 3-4 8 80 3-9 94-5 7 701 3-7 12-6 8-28 30-8 40 5-8 51 3-6",
    ": 8-60 2-5 7-8 71 3-6 8-9 81-3 9-91 3-8 802-4 6-28 30 3 5 7 9-42 4-5 7-53 5-6 8",
    ": 61 6 8-76 8-87 90-1 4 8-905 8-13 5-8 20 2-3 6-32 4-7 9 41-4 6-7 50-2 4-5 7-9",
    ": 64-6 8-70 4-80 2-6 8 90-6",
    ": 9-3001 3-5 7-11 3 6 8-23 6-7 31-8 40 2-3 8-9 52-9 61-2 5-72 4-5 7-8 81-3 7-93",
    ": 5-8 100-16 20-1 6-30 2-3 5-7 9-41 3 5-6 51 3 5 8-62 4 7 70-3 5-6 8 81-97 9",
    ": 203-5 8 13-5 7 21-7 9-32 5-6 9-44 6-54 6 8-9 61 3-5 7 9-70 2-7 81-2 4-5 7-8",
    ": 90-1 5-6 301-4 6-7 9-16 9-20 2 4-5 7-8 30-5 7-40 2-4 7 50 4-5 8-9 61-5 70-1",
    ": 3-7 9-81 3-93 5 7-9 403-7 9-12 4-5 7-8 20-3 6-31 3-6 40-6 8-9 51 4 6-67 70",
    ": 2-3 5-8 80-4 6 90-1 4 7-500 3 5 8-17 9-27 31 3 5-7 9 41-2 8 50-1 5 7 9 61 3",
    ": 5-82 5-7 9-90 6-600 2 4-8 10 4 6 8 20-5 8-9 33 6 8 40 2 4 7-8 50-4 6 8-62 5",
    ": 7-8 70 2 5-6 8-84 7-8 90-8 700-1 3-6 10 2 4-33 5-6 41-5 7-8 51-3 6-61 4-5 7-8",
    ": 72-8 81 5-9 93-4 6-800 2-4 6-8 10-5 7-8 21 3-4 6-9 33-5 7-9 41-53 5-8 61 3-6",
    ": 9-71 4-6 8-84 6 8-9 91-7 9 901-8 13-4 7-20 2-3 6-31 4-46 9-53 5-6 60 2-4 6",
    ": 9-71 3-4 6-80 3-5 7 9-93 5-6",
    ": 8-4003 5-7 10-1 3-7 9-21 3-4 6 8 31-2 5 8 40-3 5-6 8-55 7-8 60-4 7 9-72 4-5 7",
    ": 9-84 6-90 2-5 9-100 3 5 7-13 6-21 4 7-9 32-3 5 7 9-42 4-5 7-8 51-9 62-6 8",
    ": 70-2 4-5 7-8 81-3 5-95 8-9 201-6 8 14-7 9 22-4 6-7 9-30 2 4 6-7 9 41 5 8-51",
    ": 3-7 60-2 8-71 3-83 5-7 91-2 4-8 300-2 4-12 4-5 8-22 4-8 30-1 3-43 5-7 50-2",
    ": 4-9 62 4-7 71-2 6-82 6-8 90-9 401 4-6 9-11 3 5-9 21 4 6 8-35 8-9 41-5 8 51-5",
    ": 8-9 61 3-5 9-74 7-80 2-6 9-90 2-5 7 500-6 8-9 13-6 8-22 4 6-7 9-33 5 7 9-40",
    ": 2-3 5 7-8 50-5 61-3 5 7-9 71-7 9-80 4 7-9 92-9 603-4 6-11 4-24 9-31 3 5 40-5",
    ": 7-9 53-6 8-63 5-6 8 70-4 6-84 6-8 90-2 4 701-2 4 6-8 10-20 3-7 9-30 2-6 8-9",
    ": 41-3 5 50 3-4 6-8 60-1 3-5 8-9 71 3 7-9 81-5 7 90 2-7 800 2-4 7-10 2-3 6 9",
    ": 22-4 8 30 2 4-5 7-40 2-3 6-8 50-2 5-9 62 4-7 9-77 9-80 3-5 7-91 3-4 6 8-901",
    ": 6-9 11 3 5-8 20 2-5 30 2-5 7-9 42 4-5 7-61 5 7 9-77 9 81-4 7-8 90 2-4 6-9",
    ": 5002 6 8 10-2 5-22 4-6 9-32 5 8 40-1 4-6 8-52 4-60 2 5-6 8-9 71-7 9-80 3-9",
    ": 93-102 7 12-6 8-20 2 6-9 31 3-5 7-8 40-1 3-52 4-61 4-75 7-8 80-2 4-90 2-9 201",
    ": 3 5-7 9 11-4 6-22 5-6 8 30 2 4-46 8 50-2 5-62 5-7 9-72 7-86 9-91 3-7 9-300",
    ": 2-9 11-2 4-5 8-21 4-7 30 3 5-6 8 40 2 4-59 61-3 6-7 70-82 5-401 3-6 8 10-6 8",
    ": 20-6 8-34 6-8 41-5 7-9 51-5 7 9-61 3 8-81 7-91 3-4 8-9 502-4 6 8-9 11 3-23 5",
    ": 7-43 5-50 2 5-60 4 6-7 70-7 80-1 3-93 5 8-9 601-7 12-3 5-7 20-5 8-31 3-5 7-44",
    ": 7-8 50-2 4-5 7-73 5-85 7 9-93 5 7 700 2-4 6-7 9-10 2-4 6 9-20 2-3 5 7-34 6-7",
    ": 9 41 3-4 7-8 51-8 62-4 6-7 70-81 3-95 7-807 10-4 6-8 20 2 5-7 30 2-6 41-50 3",
    ": 5-6 8 60-6 8-73 6-83 6-90 2 5-905 7-11 3-22 5-7 9-32 6-7 40 2 4-5 7-8 50 2",
    ": 5-61 4-7 9-73 5-7 9 81-90 3-7",
    ": 9-6000 2 4-10 2 5-6 9 21-3 8-32 5-7 9-54 6-7 60-1 7 9-70 2 4-6 8-86 8-9 92-3",
    ": 5-8 100-1 3-10 2-6 8-9 21 3 5-6 8 30-5 7-45 7-50 2-4 6-9 61-74 7 9 82-9 91-3",
    ": 7-8 200-5 11-2 5-9 21-6 30-2 5-9 41-3 8-9 53-62 5-6 8-9 71 3-82 4-6 90-1 3-8",
    ": 300-1 5 7 12-5 7-9 22-38 40-1 3-5 7 51-3 6 8-60 3 5-6 9-73 6-80 3-7 9-91 3-8",
    ": 400-8 10-5 7 9-23 9-33 6-40 2 4-6 8 50-2 5-8 60-4 6-8 71-81 3-8 91-2 4-510",
    ": 3-28 30-3 5 7-40 2 6-52 4-8 62 4 7-9 71-4 7 9-83 5-6 8-91 3 5-8 601-2 5-6 8",
    ": 11-9 21-2 4-6 8 30-9 41-3 5-6 8-52 4-9 61 4-72 5 82-6 9-92 4-5 7-8 701-8 11-6",
    ": 8-22 5-6 8 30-6 8-52 5-8 60-3 8 70-9 81 4 6-7 9 91 3 5-9 805-7 9-15 7-9 23",
    ": 5-6 8 30 2-3 5 7-9 41-7 9-50 2-4 6-60 2-6 8-9 71-2 4-6 8-82 4-5 7-8 90-5",
    ": 8-902 4-5 8 12 4-22 4-31 3-42 5 7-52 4-6 8-9 64-6 9 71-5 7 9-86 90-1 3-8",
    ": 7000-3 5 8-12 4-5 8-21 3-8 30-7 40 2-5 7 9-59 61-5 8 72-4 6 8-80 4 6-93 5-6",
    ": 100-1 3-5 7-15 9-20 4 6-7 30-4 6-7 43 6 8 50-3 5-60 2 4-6 8 72-4 7-9 81-2 7 9",
    ": 95 9-200 2 5 7 11-4 6-20 3 5-30 2-4 6-9 41-3 9 55 7-62 4 6 8 70 2-9 81-3 5-93",
    ": 6-300 3-10 2-4 8-20 2 4 6-7 9-30 2-7 9-48 50-7 9-60 2-4 7 9 71-2 4-9 81-6 8-9",
    ": 91 3-401 4 6 9-10 2-29 31-3 5-40 3-53 5 7 9-61 3-7 9-71 4 9-83 5-7 9 91-6",
    ": 8-500 5-9 11-8 20-2 4-35 7-9 41-2 7-8 50-1 3-7 9 62 4-9 71-86 90-4 9-603 6-13",
    ": 5 7-20 5-7 31-2 4-5 7-40 2 4-5 7-8 50-7 9-62 4 7-70 2 4-5 8-9 81 3-4 6-9 91 4",
    ": 6 8-9 702 5-8 10-2 4 6-9 21 3 5 7-9 33-5 7-40 2 5 7 9-51 5-9 62 4-6 8-72 4-81",
    ": 3 5-6 8-9 91-2 5 7-814 6-8 22-4 6-8 30-2 5-8 40-2 5 7-57 9-61 3 5 7-9 73-7",
    ": 80-1 3 6-7 9-92 4-5 7-9 902 4-7 12-4 6-40 3 5-54 6 9 61 3 5 8 70-8 80 3 8-94",
    ": 8001-8 10-3 6-20 2-3 5 9 31 3-4 8 40 3-4 7-57 9-61 3 5-7 9 71 3-4 9-80 2 4-7",
    ": 9-91 4-6 8-9 101-13 5-6 8 20-3 7-30 2-4 6-7 9 42-8 51-5 8-60 3-4 6 8-9 74-6 8",
    ": 80-1 3-4 6 90-5 7 9-206 8-14 8 21-33 9 41 4-6 9-54 6-8 60-8 70-7 80 2-5 7",
    ": 90-2 6-9 301-5 7 10-4 6 8-25 7 9-35 7-8 41-3 5-6 8-50 3-5 7-8 61-3 6 8-71 3",
    ": 6-8 80 3 7 9-96 8-405 8 10-1 7-8 24 6-35 7-9 41 3 5 9-51 3-7 9-65 7-72 4-5",
    ": 9-83 5-9 93-7 502 4-5 8-21 4 6-8 30 2-7 41-5 7-53 6-8 64 6 9-75 7-80 2-5 8",
    ": 91-3 6-7 600-5 7-12 4 8 20-4 6 8-9 32 4-5 7-9 41 3-5 7-53 7 63-9 74-5 8-80",
    ": 2-5 7 9 91 3-701 3-5 8-11 3-7 9-24 6-30 3-4 6-40 4-53 6-8 60-3 5-7 9-70 2-4",
    ": 7-81 3-7 90 2-7 801-9 13-9 22-6 8-9 32-7 9-40 2-8 51-3 7-8 60-2 6 8 70-1 3-6",
    ": 8-80 3-91 6-8 901-2 7 9-12 4-6 20 3-5 8 31-6 8 40-4 6-8 50-3 6 61 4-5 7-72",
    ": 4-8 80 2-5 7 90-1 4-5",
    ": 8-9000 2-5 8-17 9 21-4 6-8 30-1 3-7 9-43 5-7 9-51 3 7-62 5-7 70-3 5-83 7-8 93",
    ": 6-102 5 8 14 6 9-24 6 8-9 31-7 9 41-6 50-1 3-7 9 64-5 7-9 71-4 80-2 5-6 91-5",
    ": 7 200-17 21-5 8 30-1 4 6-41 3-6 8 50 2-68 72-6 8 80-1 3-90 2 4-5 7-301 4-6",
    ": 10-3 5 21 3-4 8 30-2 4 6-7 43 5-9 51-3 6-7 60-4 8-9 74 7-81 4 8-9 91-8 400-8",
    ": 11-2 6-8 20 2-8 30-3 5-7 9-44 6-7 9-50 2-3 5-8 61-9 71-2 4 7-8 81-95 7 9-500",
    ": 4 6 8-10 2 5 8-23 5 31-5 7 9-42 4 7-51 3-4 6 8-61 3-4 6-70 5-82 8-91 4-6",
    ": 9-600 3-4 6-9 11-4 7-20 2-3 8-30 2-41 3 5-8 50-4 8-63 6 9-72 5-6 8 81 3-4",
    ": 7-91 3-701 4-5 7 10-3 5-6 8 20 2-6 9 31-3 5-7 41-5 8-50 2 4-7 60-4 8-72 4-5",
    ": 7-8 80-2 5-9 92-4 6 8-802 4-7 9-21 5-30 2 4-6 8-40 2-3 5-6 9 51-8 60-8 71-2",
    ": 5-6 8 80 2-5 8-97 9-901 4-9 11-2 5-8 21-5 8-34 7 40 2-3 6-8 53-7 9-63 5-71 4",
    ": 6-7 9 81 4-5 7 9-90 2-8",
    ": 10001 3-4 6-7 9-10 2-24 7-30 2 4-5 7-8 40-5 7-55 7-9 62-4 6-71 3 5 8-9 81-3 5",
    ": 90-2 5-9 102-4 6 9 13 5 7-20 2-7 30-1 3-7 9-46 8-57 9-60 2 6-8 70-3 5-82 5-8",
    ": 90 3 5-200 2 4-11 3-21 3-31 7-46 8-9 53-5 7-60 3-5 7-70 3 5-9 82-7 9-97 9-304",
    ": 6-7 9 11 3-4 6-24 6-38 40-4 6-9 51-7 9-62 4 6-9 71-2 6-8 80 2-8 90 2 4-7",
    ": 400-1 4-6 8-14 6-24 6 30-5 7-41 3-52 4 6 8-67 70 2-5 8-83 7-99 501-2 4-6 8-10",
    ": 3-4 6 8-22 5-8 30-3 6-7 9-40 3 5-8 51-5 7 60 2 4 8-9 72 4-80 2-6 90 5-604",
    ": 6-16 8-21 4-33 5-7 9-42 4-5 9 52-3 5 7 66 8-70 2-5 7-9 82-4 6-7 9-95 8-9",
    ": 702-6 8 12-6 9-21 4-5 7 9-31 3-45 7-8 51-3 6-7 9 61-3 5-72 4 6-7 9-80 2-7",
    ": 9-93 6-805 8-9 11-3 5 7-24 6-8 30-4 6-44 6 8-53 6-7 9-67 9-70 2-5 7-80 3 5",
    ": 7-95 7 9 903-13 5-6 8-22 8-31 3-4 6-7 9 41-4 7-8 50-1 4-5 7-9 61-2 4-5 7-73",
    ": 5-8 80-5 7-9 91-7",
    ": 9-1000 2 4 7-8 10-3 6 8-21 4 6 8-34 6-7 9 41-3 5-6 8-9 52 4-5 7-8 60-2 4-6",
    ": 8-9 72 5-85 8-9 91 3-9 101-5 7-11 3-7 9-25 7-8 31-4 8-56 60-2 5 7 71-4 6-80 2",
    ": 4-8 90-3 6-8 203-5 7-9 12-21 3-5 7-31 3 8-44 6-8 50-4 6-62 6-73 5-82 5-8 90",
    ": 3-8 300-13 5-7 9-23 5-7 9-31 3-6 8 40-8 51-4 6-61 4-6 9-71 3 6-9 82-9 92-8",
    ": 400-1 4-8 11-6 9-20 2-9 31-4 7-8 41-2 4-56 8-60 2 4-6 8-70 3 5-8 81-3 5-7",
    ": 9-92 4-501 4 7-13 5 9 21-2 4-6 30-3 5-9 41-3 6 8-56 8-68 74-85 7-8 91-4 6 8",
    ": 602 5-6 9-14 6 8-23 5 7-31 4 6-40 2 4-5 7-51 4-6 9-60 2-4 6 8 70-1 3-8 80 2 4",
    ": 7-93 5-6 9-702 4-5 7 9-16 8-21 4-7 9-38 40-4 6-9 51 3-61 3-4 6-82 8 93-4 6-7",
    ": 9-805 11 3-7 20 2 5-8 30 2-5 7-8 40-2 4-7 50 2 5-60 4 6-9 72 5-6 8-80 3-4 7-8",
    ": 90 2-9 901-6 8-10 2-8 22-3 5-32 4 8-41 3-51 3-6 62 4-5 7-78 80-1 3-6 8 91-2 4",
    ": 6-2002 4-5 7-8 10 5-7 9-23 6-8 31 3-5 7 9-41 3-5 7 9-52 4-7 9-64 6-73 5-8",
    ": 80-2 4-5 7-8 90-1 3-6 8 101-6 9-15 8-21 3 6-7 30-2 5 7-40 4-7 51 7 9-60 2-74",
    ": 9-81 3-4 6-92 6-8 202 5-6 8-10 2 4 7 21-7 9-40 4 6-55 7-61 3-7 71-4 6-7 9",
    ": 81-94 6-7 9 303-7 11 4-9 22-6 8-32 4-8 41-2 4-8 51-8 61-4 6-70 3-7 80-1 5-92",
    ": 4 7-404 9 14-5 7-9 21-35 7 9 43-51 3-9 61 3-9 72 4-5 7 9-82 5-9 91 5 7-511",
    ": 3-7 9-22 4 6 8-31 3-41 4-7 50-6 9-66 8 70-2 4-5 8 80 2-9 91-7 601-4 7-11 4-7",
    ": 20 3-7 30 3 5-6 8-9 41 4-6 8-50 2-7 9-64 6 8-71 3-4 6-80 2-3 5-9 91 4-7 9",
    ": 701-4 6-8 11-3 5-7 9 21-5 7-30 2-40 2-5 8-50 3 5-62 5 7 9-77 80-6 9-95 9-805",
    ": 7 9-12 4-6 8-25 7-34 6 40-1 3-9 53 6-8 60-1 3-4 7 9 72 4-5 7-86 8-90 2-3 5-6",
    ": 900-3 5 7 9-18 21-3 7-36 9-40 2 4-7 9-50 3-9 62-6 9-72 6-7 81-6 8-91 4-8",
    ": 3000 2 4 7-8 10 2-5 7 9-33 6-8 40 2 4-5 7 9 52-7 60-1 3",
    ": 57391-2 5-8 400 2-4 7-9 12 4 6 8-20 2 4-5 7 30 2 4 6-9 43-50 3-5 8-61 5-6",
    ": 8-74 80-9 95-8 500 2-6 15-9 21-2 6-7 30-40 3-50 2 4 7 62-3 5-8 75-80 4 6-7 93",
    ": 5-602 4-7 9-15 7-24 7-9 32-3 7 47-8 50-3 5 9 65-7 71-2 9 81-3 6-7 95-714 7",
    ": 9-20 2 7-9 32 7-9 44-5 7-9 52 4-7 61 4-6 8 72-5 7 80-5 7 91-6 8-800 4 6 9-10",
    ": 4-8 21 8 31-4 7 9-44 7 53-7 62 4 72-6 85-8 91-2 903 11 4-25 30-5 8 41-5 50",
    ": 61-2 4-7 71-3 6-8 82-4 7-92 5 8",
    ": 8001-2 4 7 13-6 8-24 37-8 41-4 6-8 50-3 5 8-61 4-5 8-73 6 81-2 4-9 109 11 3-4",
    ": 8-21 6-31 3-6 8-9 42-3 6-55 7 9-61 4-7 71-7 9-85 90-6 201-12 4 20-6 8-9 31 9",
    ": 42-3 7 9 52-6 60-1 3 5 8 72-3 5-80 2-9 93-4 7-8 300-1 4-9 11 5 7 9-22 4 8",
    ": 32-5 9-42 4-5 7 9-51 5-60 2-8 70-6 80 3-94 7-406 8-11 3-4 7-27 30-2 4-6 8 40",
    ": 2 8 50 3-6 8 61 3-4 7-71 3 8 80-1 4-90 2 5-7 500-3 5 8 10-7 25-30 2 9 45-54",
    ": 8-61 5 70-3 5-7 9-81 3-93 5-6 9-621 4-5 7-40 3-8 56 64-5 7 9 71-3 5-8 81 3",
    ": 5-92 6-8 704 7-13 5-6 20-33 5 7 9-41 7-8 51-3 5-8 61-6 70 4-84 6 96-800 2-3 8",
    ": 11-7 21-2 6-35 7 41-2 4 50 2-6 60-71 3 6-83 7 9-91 6-8 901 3 6-7 12-28 31 5-8",
    ": 42-75 85-95 8-9",
    ": 9005-15 8-23 5-7 41-3 5 7 9 51-9 61 5-70 5 8-9 81-6 8 90-1 100-1 7-8 11-4",
    ": 6-27 9 33-5 8-48 51-2 5-66 8-77 84-7 9-98 208 12-3 8 20-4 7 30-40 4 6-7 54 6",
    ": 69-70 3 5-6 80-5 7-90 4-5 9-300 2-5 7-8 11 3 5 23 6 30-2 6-9 41-2 4-55 7 60",
    ": 5-9 72 4-80 2-5 8-90 6 8-400 2 4-21 3-9 34 44 7 9-60 2 6-72 5-8 80-5 90 2-4 9",
    ": 502-5 7-10 6 26-7 30 6 42 7-8 57 9 61 4-5 8-76 9 81 3-9 601-2 4-8 11-2 4-8",
    ": 24-6 30 2-40 2-63 5-70 3-7 83 5 92-3 5 703 7-13 6-21 3-30 5-7 9-43 5-6 8-52",
    ": 6-8 60-4 70-3 8 81 4-5 7-8 90-800 2-4 7-11 3-25 7-9 32-7 40 4 7-9 52-62 4-8",
    ": 72-3 5 81-2 5-6 8 90-1 5-9 902-14 9-20 4 31-7 40-53 6 8 60-1 5-71 6-80 5 91",
    ": 4-7",
    ": 60002-5 8-9 16 8-20 2-31 6-40 2-3 5 9-55 60-2 74-6 80-92 5-6 9 103 5 9-12 4",
    ": 6-7 20-35 7-50 3 5-6 9-64 6 8-71 3-6 85 92-3 5-9 202-3 5-10 4 8-20 2-6 41",
    ": 5-52 4-67 70-3 7 9-80 2 7-91 3 6-301 3-4 6-7 10-1 4 6-8 21-9 31 3 7-41 8 53-4",
    ": 8 60 2 4 8-9 71-2 4-5 8-80 2 9 93-7 9 403-4 6-11 3 6-7 20-4 7 32 6 40-7 9-51",
    ": 5-8 60-4 6-71 3-6 8-82 4-9 94 502-5 7-9 11 3-6 23-4 7-31 4-7 9 41-2 4-54 9-60",
    ": 4 6-8 70 4 7 80 2-3 5 7 91-600 2 7-13 5-6 20 3-5 8-9 33-6 41 4-52 4-6 9-61",
    ": 71-5 8-85 8-90 712-5 9-20 4 6-34 9-40 5-6 8-52 4-7 9-63 9-70 3-85 93-5 809-11",
    ": 3 5-7 23-7 30-1 5-7 9-41 3 5-7 54 8-64 6-70 3-5 7-8 80-3 5-90 2 4-7 9 902-6",
    ": 8-10 4-7 9-20 2-31 3-4 40-1 8 56-60 3 5 71 3-6 82 4-6 8 91-5",
    ": 7-1001 4 6-11 4 6 29 31 3-4 9-40 3-5 7-51 3-62 7-75 83-4 6 8-98 101-3 5 7 10",
    ": 2-8 20-1 3-35 7-8 40-59 62-74 6-83 6-9 93 6-200 3-17 9-20 3-4 6 30-7 43-6",
    ": 8-51 3-4 6-7 61 4-73 8 81 3-4 6-91 7-335 7 9-40 2 7-55 8 60-3 7 9-70 6 9-80",
    ": 3-6 90-1 5 409-10 5 7-29 31-40 2 5-6 9 51-2 62 5-7 9 74-7 9-82 9-92 8-508 15",
    ": 21 3-6 30 5 8 42-7 51-7 9-65 73-5 7 9 81-4 6 94-5 614 6-22 4-5 7-31 6-7 9-41",
    ": 3-7 50 2 6 62 70 7-8 83-8 91-9 702-4 13 8 21 9 35-6 8-51 4-5 60-6 8-75 83-6",
    ": 9-96 800-1 4-5 7 16-9 22-3 5-30 4-5 40-8 50-1 5-8 63 70-1 4 7-81 4-97 9 901-2",
    ": 8 13-7 9-22 7 35-6 8 41-4 9-50 2 4-6 9 62 6-7 70-1 3-4 8-80 3 6-8 95 7-8",
    ": 2007-8 10 2 4 6-9 27-30 5-6 8-46 8-50 3-7 9-60 5-9 71-2 5 81-6 90-7 9-105",
    ": 8-14 6-9 22-3 5 8-9 34-8 40-1 4-9 53-61 6 8-75 80-1 6-92 4-5 202 5 8-13 28-30",
    ": 3-6 8-9 41 6-50 4-5 8 63 7-8 72 4-7 9 82 4-96 304-6 8 11 3-5 9-22 4 7 9-30 2",
    ": 4-5 7-8 42 6 9-51 4 6 9-61 4-8 70-1 4-5 7 80-2 7-9 93-8 400-2 4-6 9-10 2-3 5",
    ": 24-5 30 2 5-8 44-5 7-8 50 4 6 9-63 6-9 72-3 5-82 90-1 5-6 502-3 6-11 3-5 7-8",
    ": 21 5-9 31-8 40 2-3 8-54 6-7 62-3 5-6 70-3 7-8 80-3 5-6 8 91-2 4 6 8 600 2 8-9",
    ": 11 3-9 21-7 9-31 5 42-4 7 9-51 7-61 3-4 8-71 3-4 6-7 80-2 4-5 8-9 91 3-7 700",
    ": 8-10 5-27 38 46-7 9-50 2-4 60-7 71-8 80 3 8-91 3-5 802 5-6 9 11 3-8 20-6 31-2",
    ": 6 9-45 51 5-6 61-2 6-9 73-6 8-9 82 7 9 91-2 5 8-9 901-4 8 10 3-4 9-20 2-3 5",
    ": 7-52 6 9-68 71-2 5-84 92-5",
    ": 3001 12 4-24 6-37 45-8 50-1 4-6 9-61 3 70-2 6-7 9 83-4 90-1 5-9 101-4 8 10",
    ": 9-21 3-9 31-3 5 7-8 40-1 4-7 9-56 9-60 2 4-5 7-9 71-2 5-6 80 2 4-6 91-3 5",
    ": 204-9 13 6-7 9-27 9 32-3 8 41-57 9 61-70 2-6 8-87 9 97-300 2 4-11 3-4 6-7",
    ": 20-2 4-30 9 41 5-51 5 7-9 68-73 5-9 81-5 8-9 96-7 9 401-9 14-5 9-25 31 3-4",
    ": 8-41 4-5 8-9 51-9 61-72 6-80 2-7 91-4 6 506-9 15-9 23 5-8 38-40 2-8 52-66 8-9",
    ": 72-81 6-9 92-3 7-8 600-2 5 7-8 14-20 3-39 42-9 54-60 2-3 6-75 80-6 8-91 3-6",
    ": 9-705 7-8 10-4 6-9 21-8 30-1 6 8 45-6 8-54 60 3-6 9-71 3 5-9 83-5 8 90 3 9",
    ": 801-6 10 3-8 21-3 5-7 30 7-9 41-9 55-6 62-9 78-9 82-3 5-7 9-94 8-905 8 11-2 4",
    ": 9-20 4 7 9-31 4-5 7-8 40 50-3 8-64 6-70 4 6-7 9-82 4 91-2 7-9",
    ": 4001-5 12-8 21 5-36 9-40 6 54-7 9 64-9 72-3 7-9 87-8 90-1 4-100 2 4-8 11-4",
    ": 7-23 6-31 5-47 9-50 3 5-8 60-2 8-70 7-81 4-5 8 90 6-204 10-1 4 6-8 22 4 31-2",
    ": 5 7 42-8 50 3 9 62 5-6 72-5 7 80 4-93 5-300 4-17 21-5 30 9 41-8 50-1 4-7 9-66",
    ": 8-9 71-2 6-81 4-93 5 9-403 8-18 20 4-7 30-1 3 7-8 42 53 5 8-9 62 8-9 75-7 84",
    ": 6 90 5 501-2 6 9 12-5 7-9 23 5 7-9 34 8-45 7-9 53-4 8 60-4 6-75 7-9 81 3 5-93",
    ": 5-8 605-10 2-7 23-4 9-32 5-8 40-4 51 7-63 8-71 3-7 82-96 702-6 8-10 4-8 25",
    ": 9-31 3-7 40-4 8-51 3-4 66-8 70-3 6 84-92 4 6-808 12-5 21-6 8-9 36-41 4-5 8-9",
    ": 52-5 8-69 71-2 81-2 6-9 92 7 904-6 8-16 21-8 30 2-4 40-4 6-7 51-5 60-2 5 9-71",
    ": 5 80 3-4 8-91 4",
    ": 8-5004 7 10 3-9 22-3 7-31 3 5-7 43-5 8 51 68-70 2-5 7-8 86-7 90-6 102-16 21-5",
    ": 35-46 50-3 63-5 7-70 2-5 8-80 5-6 90 2-200 4-5 7-9 11-3 6-9 23-8 31-3 5-6 41",
    ": 3 8 51-8 65 7 74-5 85-6 90-2 5-300 3 6-8 11-3 6-23 30-5 40-5 52-3 8-63 6 8",
    ": 72-9 81-7 93-6 9-402 7-8 11-4 21-5 8 31-2 9-40 3 5-9 51-5 7 64 8-9 72-6 8-81",
    ": 5 7-8 92-3 5-7 9-500 3-7 9-10 7-23 8-32 4-9 41-2 5-51 67-72 4-7 9 81-90 2 4",
    ": 8-603 8-11 3-6 21-5 7-8 33-4 6-40 2 4 6-51 3-4 7-8 61-6 9 71-6 8-80 2-90 3-5",
    ": 7 700 2 5 8-12 5-7 20-2 4-5 7-9 34 8-40 7-9 51-3 6-8 61 4 6-70 3 6-9 81-2 4 6",
    ": 90-3 5 7-8 800-7 10-3 8-9 22-5 30-5 7-8 43-5 9-53 6 8-64 9-76 81-3 6 8-90 4 8",
    ": 900-1 5-8 10-5 8-21 6-9 31 3-4 41-5 9-52 4-8 60-4 6-8 74-9 85-91 3-5",
    ": 6004-7 15-24 6-33 8-9 43 8 50 5-6 62 4-7 9-78 80 90 2 6-102 7 10-2 7-8 20 4-7",
    ": 30 3-5 7 9-45 8-59 62 5-70 2-4 6-80 6 92-6 8-204 14-7 21-4 6 8 36-7 40-1 4",
    ": 8-51 8-60 3-8 79-82 6 8-96 306-7 11 3-7 26-8 30-6 42-4 6-56 61-5 71 8 82-3",
    ": 7-9 94-8 403-4 6 9-17 20-2 9-35 7-40 2-4 7 51-3 5-6 9-60 2 4-6 70-1 3-92 7",
    ": 9-508 13-4 7 23-6 8-31 3-4 6 9-41 3 5 7-59 61 3-6 74-7 81-90 3 5-9 602-4 7",
    ": 9-12 5-6 26-9 31-9 41-5 9-52 5-6 8-9 61-2 8 70-1 6 8-82 7-94 7-703 10-23 32",
    ": 4-6 9 41-4 6-7 9-50 67 76-7 9 83 5 7-8 90 2-3 5 7-800 2-6 10-9 22-3 6 8-9",
    ": 34-9 42-3 7-52 5-6 9-60 3-5 8 70-2 6-82 5-90 3 5-6 9 901-2 4-10 3-4 21-4 7-9",
    ": 39 44 6-7 51 3 9-61 5-6 75-80 4-7 92 6-7",
    ": 7000-18 22 5 7-30 5-49 54-67 9-70 5-8 83-4 7-90 7 9-114 20-6 9 31-3 5 9 41-2",
    ": 4-8 50-6 8-61 4-5 8-9 72 8-9 82-90 2-7 9-200 2-3 5 10-2 8 20 3-4 9-30 3-4 8-9",
    ": 41 6 8 50-3 5-8 61-2 71 5-6 80 3-4 92-6 300 4-5 12 4 6-7 26-33 5 54-60 2-6 8",
    ": 71-9 87 93 6-7 9-405 9-13 20-1 7-30 2 43-4 54 61 3-78 82 4-9 92 4-505 7-15",
    ": 7-23 5 30-1 9-42 4-52 5 60-3 5 75 7 84-7 9 91-9 602-7 11-5 20-5 7-33 5-43 5 9",
    ": 51 8-60 2 4-5 9-74 83-701 3 7-8 10-1 4 7-21 4-9 36-7 41-8 53 6-60 3-5 8-74",
    ": 81-3 6-7 95-7 9 802-5 7-12 6-9 26-7 31 3 5 40 2-54 8-60 3-5 9 72-8 80-4 7-90",
    ": 3 5-901 5-15 20 2-6 8-9 36-53 6 9-62 4-70 3-4 6 8 82-9",
    ": 91-8000 2 7-10 2 4-5 21-2 8-32 4-42 4-50 3 9-60 3 5 9-70 5-6 9-87 95-6 9 101",
    ": 9-18 21-34 7-40 2-5 51-7 61-6 8 72-80 2-90 3 9-202 6-7 11 3 6-7 20 2-3 8-32 6",
    ": 40 5-7 9-56 62 4-5 7-71 81 4-5 8-91 303 8-17 22 5-30 2 40-4 52-62 6-82 5-7",
    ": 96-7 400-1 4-5 7-9 19-21 6 8-32 4 7-43 8-53 8-68 73-6 80 7-96 8-9 501 9-10",
    ": 3-4 9-20 2-5 30-4 41-2 9-51 4-5 7-8 60-2 72-83 6-7 9-90 2 5-6 614 6-8 21-3 7",
    ": 31-3 6-42 5 9-55 7 61 3 5-8 74-5 83-708 14-7 20-33 6 8-41 3 9 51-3 60-5 7-9",
    ": 71 4-6 81-5 90 2 4-7 802 4 6-20 4-7 9-30 4-5 8 42-3 54 6-65 7 72 4-5 7-8 80-1",
    ": 3-92 4 6-7 900-9 13 5 8 20-1 4-5 7-8 30 4 9 41-8 50 7-60 2 5-6 9 73-4 7 88 90",
    ": 2 4 6 9",
    ": 9002-3 5-8 10-7 9 21 3 30 2 4 6-7 40 2-5 7 50 3 5-6 8-9 62-6 8 71-3 5-8 80-1",
    ": 3 8 99-102 4 6 9-13 5-6 8 20-3 8 30 3 6-8 40 3-6 8-52 4 60 2-3 5 7 9 73-4 8",
    ": 81-5 90 3-4 6 9-207 9-14 7 21-30 3-5 41 3 5 7-8 50 2-3 5-6 61 4 8-70 2 4 6 9",
    ": 81 3-9 91 6 312 4 6 20 2 4-6 30 2 4 6 8 42 4 6 54 7-64 6 8-70 2 4 6-7 9-89 91",
    ": 3 5 7 9 402 4-6 8-9 11-3 7-9 21 4-36 8-9 41-2 4 51-60 2-6 8 70-1 4-7 9-83 5-6",
    ": 8-90 5 501-4 6-9 12-3 5 8 21 4 6 8 30-3 5 7-40 2 4 6 50 2-3 5 7 9 61 6 8-9",
    ": 72-3 5-7 9-82 4 7-91 3-4 6-603 5 7-10 2 4 6-9 22-3 5 8-30 2-3 5-7 44 7 50 4 6",
    ": 9-61 3-73 5 7-84 6-8 90 3-9 701-5 7-13 5-25 7 9-30 5-6 8 40 2-3 5-7 52 60 2 4",
    ": 6 71 3 5-8 82-6 8-9 96 800 3-4 6-9 11-3 5 8-9 22 4 7-33 5 41-51 3 5 7-9 61",
    ": 3-4 6-9 72-5 7 9 90 3 5-6 8 900 2 8-12 5 7 20 2 4-6 8 33-4 6 9 41-2 5 7 50 62",
    ": 4 8-9 71-4 6 8-81 4 90-1 3-4 6-8",
    ": 70003 5-6 10 3-5 7 9-21 5-7 9 33 5 7-40 2-5 9-50 2-4 6 8 64 6-9 71-4 6 8-9 83",
    ": 5-7 90-3 5 9 101-4 7 22 5-7 31-3 5 8 40 3 9 55 7-9 63 7-8 70 2 4-5 8-9 81 5",
    ": 8-9 92 8 203-4 7-8 11-21 3 5 9-33 5-43 5 9-51 3-4 6 61 4 6 9 71-2 4-7 80-1",
    ": 4-6 92 7 9-301 3-4 6 8 10 2 6 8 20-3 5-7 9-30 6-41 3 52-4 6-65 8 70 2 5 7-87",
    ": 9-90 2-7 9-402 4 9-14 6 8-20 2-5 7-30 2 5 8-40 2-4 6-7 51 4 6-62 4 6 8 70-4",
    ": 6-9 82 5-7 9-90 3-500 2 4-5 7 9-11 3 21-4 7 9-30 2 4 6 8-40 3 5-6 8 50-1 4 7",
    ": 9-60 2-70 2-4 6-81 3 5-9 91-4 8 600-4 7-9 11 3 5-23 5-34 8 40-4 6-50 6 8 60 2",
    ": 4-5 7 9 72 4-5 7-86 9-94 6 700-5 7-8 10 2 5 7-8 20-4 6 8-32 4 6 8-43 5 9 51",
    ": 3-5 7-8 60 3 5 7 9-70 2-6 9 81 3-5 8-9 91 5 8 800-1 3 7-12 6 8 22-3 8 33-5 7",
    ": 40 3 5-8 52 4-8 61-4 6-7 70-3 82 4 6-9 91 5-7 902-6 8-9 11-2 6-22 4-6 9-32",
    ": 4-6 8-46 8 50 4-9 63-4 8-72 4-5 7 9-84 7 90 4-5 8",
    ": 1000-3 7-8 13 6-22 5-8 32-3 41-3 5-7 9 53 5-6 8 62 6 70-1 3 7-8 81 3 6 90 8",
    ": 100 8 10-1 3-4 8 20 2-3 30 2 4 6 43-4 7-51 3 5 7 62-5 7-71 3-4 7 9-81 3-5 8",
    ": 93 6-8 201 3-5 7-8 10 4 6 20 2-5 9 34 6-9 41-52 4-5 7-9 62 8 72 4-6 8 80 2-3",
    ": 6 8-9 92 7 301 4 6 15 7 9-20 4-7 30-1 3 42 5 54 60 3 7 71 4-6 8 80-2 90 2-4",
    ": 400-1 5 7-10 2 4-5 7-23 7-9 31 4-6 8-9 41 3-5 9-57 60 2 5 9 74 6 8 80-2 4-5 8",
    ": 90 2 4 6-8 501-2 4 6 9 11-8 20-1 3-7 30-2 4-42 5 7 9-62 4 6 9 72 4 88 90 2",
    ": 4-7 9-602 4-9 11-6 22-3 8 30-3 5-6 8-9 42-51 3 5 60-1 4-6 77-8 80 3-8 90 3",
    ": 703 8-11 4 6-8 20-3 5 7-8 30-6 8 42 4-6 8-50 6 9-60 2 4-6 8 71 4-80 4-5 8",
    ": 91-7 9 802 4 7 11-2 6 20-4 7-8 30-2 4 6 8-9 41 3 6 8-50 2 5 60-1 4 7-9 71 4-5",
    ": 7-82 8 90 3-6 8 902-4 6 9 11 5 8 23-4 7-38 43 5 7 51 3 7-62 4-6 8 70-5 81-3",
    ": 5-97",
    ": 2000 8 10 2 4 9-23 5 7 9-37 9-40 50 2 7-8 60-1 6 71 3 5 8 81-2 4-8 93-100 2-3",
    ": 5-7 9-13 5 7-9 21 3 30 2-9 41-3 5 7 9 51-2 64 6 9 71-81 3 5 7-91 3 5 8-203 5",
    ": 9 12 7 9 24-7 9 35 9 41 3 7 9-51 3-5 8-9 61 3 6-7 9 71 3 5-7 9-81 3-5 7 9 92",
    ": 5 7-300 2 5 7-11 4 6-8 20 5 7 33-6 8 40-2 4 6 50 5 9-64 7-8 70-4 6 8 80-1 3-5",
    ": 7 90-1 3 402-3 5-10 2-5 7-9 22-4 6 8 30-6 8 40-4 6-52 4 6-7 9-60 2-3 5 7-70 6",
    ": 8 80-2 5 7 9-91 3-7 9 501-5 9-11 3 6 9-22 4-8 30-2 4-7 9-44 6 9 51 5 8-60 2-5",
    ": 7-9 71-2 4-80 2 4-6 8 90-7 9 602 5 9-10 2-3 7-24 6-9 31-7 41 6-7 9 52-3 8 61",
    ": 3 5-9 72-9 81-2 6 8 90-4 6 8-9 705 7 9 16 20 2-7 31 3-46 8 50 2 4-9 61 3 6-7",
    ": 70 7-8 80 2 5 8 92-3 6 8 800 2-3 5 7 9-17 9-24 7-32 4-6 8-40 4 8-9 51-2 6 9",
    ": 63-5 7-8 70 2-4 6 9-82 9 91 4-7 9 901 3 5-18 20-4 6 8 31-3 6 40-1 5-6 8 50",
    ": 2-3 60-2 4 6 9-73 5-80 2 4 8 90 4",
    ": 6-3001 5-11 3 5-7 9 22-5 8-30 3-4 6-42 5 7-8 50 4-5 7 63-7 9 76-80 4 7-8 90-3",
    ": 7-8 100-1 3 5 7 11-2 5-7 9-27 9 31-7 9-41 5-7 50-4 6-60 2-6 9 73-9 81-6 8-90",
    ": 2-4 201 4-7 9 13-8 20-1 3 6-7 9-32 4 8-40 3 5 7-50 2 5 7 9-61 3 5 7-8 71-2 5",
    ": 7-9 81-6 8-90 2-4 6-306 8 10-2 4-6 8-9 23 5 9-30 2 4-41 3-8 50 3 8-9 61-2 7-8",
    ": 71-3 5-8 83-9 91-3 5 7 9 402 6-7 10 3-4 7 9 21 3-5 7 9 31-2 5-6 9 41-3 5 7-8",
    ": 50 2 4-8 60 2-3 70-80 2-3 7 93 5-500 3 5-7 11-3 7 26-9 31 3-4 6 9 41 3-4 6 8",
    ": 50 2 5 7-9 61 3-5 7-9 71-5 8-80 2-3 6-7 9-90 3-6 8-9 601 3 5 8-9 13-6 9-21",
    ": 3-8 30-9 43 5 7 50 3 5 7-60 3-71 3-4 7-82 7 9 98 701-2 4 7-10 2 5-23 5 7-32 7",
    ": 9 41 3 7 9 51-2 9 61 3 6 8 70-1 3 9-80 2 4-5 8-9 91-5 7 9 801 5-6 8-9 14-6",
    ": 8-22 4-6 8-30 2-5 7-41 3-5 7 50 2-5 7-9 61 5-6 8-9 72-5 7 9-80 2-3 7-902 4",
    ": 6-9 11 3-5 7-8 20-5 7-31 6 8 40 2-5 7 9 51-2 4-5 7-65 7 70 5 7-8 80 2-3 5-6",
    ": 8-91 3",
    ": 5-4000 3 7-10 2 5 7-21 3-8 30 2 8 40 4-6 8-50 2 6 60-2 4 6-70 2-82 4-6 8 90",
    ": 2-3 7-9 101 5 7 9-15 7-8 20 2 5-6 9-32 4-6 40-4 6-9 52 5-7 9 61 3 5 8 74-5",
    ": 7-8 80-3 5-92 4-6 8 200 2-3 5 7-9 18 20 2 6 30-1 3-6 8-42 4-5 7-59 61 4 7",
    ": 9-70 2-3 6-7 9-82 4-7 9 91-4 6-7 9-300 2-4 6 8-10 2-4 7 9-21 6-7 9-30 2-5 7",
    ": 48-51 3 5 7 9-61 4-6 8 70-1 6-7 9-80 2-3 8 95-6 401-8 10-1 6 8 20 2 4-6 8-35",
    ": 8-40 5 9 51-5 7 9 61-8 70-1 3 5-6 9 82-4 6-7 92-3 500-1 3-5 7 9 11-2 4 6 8-9",
    ": 21 3 7 9-35 8 42 5 7 53-5 60 3-9 71-2 4-5 7-9 84 7 9 91-8 600-5 7 9 13 5-6 9",
    ": 21-4 6-9 31-4 6-7 40 2 5-9 51-3 6 9 61 4-73 5-6 80-2 5 7-8 90-1 3-6 9 701 4-7",
    ": 9 11-3 5 8-21 4-8 30 2-3 5 40-1 3-5 7-53 5-7 62-3 6-70 2 7-8 81 6-9 91 4 800",
    ": 2-3 5 7-13 5-22 8 35 8 40-5 7 50-4 6-7 9-62 7 9-70 3-4 7-9 81 6-7 9 92 5 8",
    ": 901 4-6 8-10 4-5 7 20 5-6 8 30-3 8-40 2-9 51-2 5-7 9-61 3 5-8 70 2 4-6 9-80",
    ": 2-3 5-92 4 6-8",
    ": 5000 3 6-9 11-2 4 6-8 21-32 4-6 8 40 2 4-7 9 51-5 7-9 63-6 8 70 5 7 9-81 3 5",
    ": 7-8 90 5-6 9 101-2 5-7 14-6 8 20 5-7 30 6-7 9 41-2 5-6 50 2-4 6-7 60-5 7-8 71",
    ": 6 8-9 82-3 5 7-8 96-7 9 201 3 5-11 3-8 20-1 3 6-31 3-5 8 40 2 6-7 50 3 5-8",
    ": 60-1 8 70-1 3 8-9 82 4 6-8 94-8 300 2 4-9 11 3-4 6-7 20 2-3 5-7 9-41 3-50 6",
    ": 8-64 7-8 70 5 8-80 2-5 7-91 3-7 400-1 4 7 9 11 4 7 21 4 7-34 6-46 8-9 51 3",
    ": 5-6 8-9 61 3 5 70-1 3 5 7-80 2 4 7 91-2 4 6-7 9 501 4 9-10 4-6 8-9 21 5-30 5",
    ": 8-41 3 5 7 50 2 6 9-63 5-7 70-1 5 9 81 3-4 7 90-6 8-600 2-3 5-6 8-9 11 6-7 20",
    ": 2 4 6-8 30-1 7 9-40 2 4-7 53-8 65-7 74-6 83-5 7 90 2-3 7-9 701 3-8 10 2-6",
    ": 8-21 4 9 31-3 6-9 41 5 8-50 2-7 9-68 70 2 4-6 8 80-1 3-91 3-800 2-3 7 11-2",
    ": 5-8 20-1 3-4 6 8-9 34-6 9 42 5-9 51-2 4-8 60-3 5-9 71 3-8 80 2 6-93 6-900 2",
    ": 4-5 10-2 9 22-3 5 7 30 2 8-9 42-3 5 9-50 4 6-9 61 3-4 6 8 70 2-3 5-6 8-80 2-4",
    ": 6-9 91-2 4-6",
    ": 9-6000 2-4 6-8 11 4-5 8 20-5 7-31 4-41 4 6-7 51-3 7-8 60-5 71 3-4 7-8 80-1 3",
    ": 5-6 8 90 2 4-100 2-4 6-15 8 20 2-3 5 9 32 4 42-6 8-65 9 73 5-6 9-85 7 9 91-3",
    ": 6 8-201 3 5 9-10 2-25 7-30 2 5 40-7 9-50 2 4-6 8-9 61 5-7 9 71-5 7 81-2 5",
    ": 9-92 4-5 300 6-9 11 7-8 20-1 3-7 9 31-2 4 6 8 40-1 3-6 8-9 51 4-61 3 5-7 9",
    ": 71-2 4-84 8 90 2 4 6-9 407 9 11 7-30 2 4-6 8-40 4-5 7-8 51 4 6 8 62-3 5-6",
    ": 8-71 4 6-8 84 9-91 3 5 7 9 503 5 10 4 6-7 9-21 3-6 8-31 3 6 42 4-5 52-4 6-8",
    ": 60-2 4 6-8 71 83 5-9 92 7 9-600 2-3 7 9-13 6 9 21-2 4 6 9-32 5 7 9 46 9-50",
    ": 3-7 9 65 7 9-70 4 7 81 3-4 6 9 91 5-703 5-18 21-4 7-32 4 7 9 41 5-6 52-8 60",
    ": 3-7 9 71 4-5 7-81 3-4 6-7 9 93-9 802-6 9 11 7 20 2-3 5 7-31 3-9 41 3 7-50 2-3",
    ": 5-9 61 3-7 9-70 2-3 5-81 3-7 91-2 6-900 2 5-6 8-11 4 6 21 3-5 7 9 32 4 6 9",
    ": 41-2 4 7 9-51 3 8-60 4-5 7-8 73-5 8 82 4 6-7 92-3 7",
    ": 7000 5 8-9 11 3 5 7-8 21-3 5-9 31-3 5 7-8 41 3-8 51-4 9-61 3 5-8 70 2 5-80 4",
    ": 7-91 6 9-101 3-10 2 7-8 20 4 6-32 4 6-7 9 41 3 5 8-56 60 3 8-70 3 5-6 9 81",
    ": 3-9 91 3-4 7-207 11 7-22 4-5 8-32 5 9 42 5 9-55 60-3 6-71 3 5-85 8-91 6-9",
    ": 301-2 5-6 8 10 2-6 20 2-4 6-7 31 3 5-7 9-40 2-6 9-50 4 8-9 61 3-7 9-74 6 8",
    ": 80-2 4-5 7-8 90-1 3 5 7-400 2-4 6 9-18 20 4-7 9-30 2-7 40 2-4 6 8-9 57-9 61-6",
    ": 9-77 9 81-8 90-2 4-503 5 7-8 10-1 3 5-22 4-32 5-7 40 3-56 8 60-1 70 2 4-6 8",
    ": 81-2 4 9 91-3 6-8 600 2-4 6 10-4 6-25 8 30-7 41-2 4 6-8 51 4 6-60 2-6 8 70-1",
    ": 3-4 6-9 82 4-9 93-4 6 8 700-1 3-7 9 12-4 7-21 3-30 2-9 41-2 4-6 8-51 3-5 7-61",
    ": 3 5 7-9 75 7 81-3 5 7 9-92 4-5 7 9 801-3 6 8 10 3-8 20 3 5-6 8 30-7 9-40 2",
    ": 6-8 50-4 6-61 4-8 70-1 3-82 4 8 90 2-3 5-9 902 4 9 17 9-34 6 8-9 42-3 50-1 3",
    ": 5-8 60 5 7-82 4 6 8 90 2-4 6",
    ": 8-8001 3 5-15 8 20-4 8 30-5 7-41 4 6 8 50 2 5-8 60-5 7 9 71 3-4 6 8-81 3 90-2",
    ": 4 6 8-100 2-6 8 10-1 8 22 6 8 34-43 6-50 2 4-8 60-7 9-70 5-83 5 7 9-95 7",
    ": 9-201 3-4 10 2-3 9-20 2 4 35-6 40-4 7 51 7-8 60-70 2-4 6-8 81 4-9 91-2 5-7 9",
    ": 303-4 8-15 8-9 21 5-37 9-45 8-9 51-7 9-73 9 90 2 4 6-8 400-3 5-6 9-10 2 6 9",
    ": 21 3-5 7 34 6-7 42 5 7 9 51 3 5 8-61 3-9 71 3 8-82 4 93-5 7-502 4 8 14-5 7 23",
    ": 5-32 4 40-4 6-7 9-55 7-8 62-4 8 70 2-3 5 7-8 81-2 9-90 2-603 5-17 20 4-7 9-31",
    ": 3 5-64 7-8 70 2-4 6-7 9 82 6 8 90-2 6 8-9 701-5 7-11 6-25 7 31-8 40-4 6 8-50",
    ": 2 4 6-7 9 61-4 6 70 2 5 7 81 8 90-1 3 5-6 8 801-6 8 11 3 6-9 23 5 7-32 4-6",
    ": 8-40 3 5 8 50-6 8 60-4 6-8 70 2-3 6-9 81-5 90 3-4 6 8-900 2 4 6-10 2-3 5-8 20",
    ": 2-4 6 8 30-4 6 8-43 6 8-9 52 4-5 7-60 2 4-72 4-9 81-8 91-3 5-8",
    ": 9003 8-10 2 4 6-8 21 8-30 2 4 6 8-41 3 5 7 9 53-4 8 62-6 8-9 71 5 9-83 5 7-8",
    ": 91 3 7 9 102 5 7 9-13 5-7 25-8 32-7 9-48 51-6 8 61 3-6 9 71 3 5-82 4 6 8-90",
    ": 2-6 8-201 3-5 7-8 10-2 5 9-27 30-1 6 8 40 2-9 51-7 9-60 2 4 7-8 72 4 8-9 81-3",
    ": 5 7-91 3-7 9-300 3-4 7-12 4 6 9-20 3 5-6 8 30-2 5-6 8-42 4 6 50-8 61 3-5 7 70",
    ": 3 7 84-99 402 4 8 10-9 24 6-30 2-7 9 41-5 52 4 8-9 61-3 6 9-71 3 5 7 81-2 90",
    ": 9 501-7 10-5 7-9 21 3 5 7-9 32-4 7-8 40 3-8 50-4 7-9 62 6 8-73 5 9 82-8 601-3",
    ": 5 7 10-4 6-8 20-3 6 30-1 4 40-1 3 6-7 50 6-65 7 9-72 6-7 85 7 90 2 5 7 9 704",
    ": 6 8-15 7-23 5-9 31 3 5 7 40-5 7-8 53-62 4 6-9 72-7 80-3 5-8 91 3 5 7-8 804",
    ": 10-1 3-4 6-22 5-9 31 3 5-7 42-3 5-52 4 6-7 60-3 5 7 9 71-8 80 3 5 7 9-95 9",
    ": 902 4-7 9-15 9 21-5 7 33-4 6 40-3 5-6 53-5 7-8 60-1 3 6 71 3-5 7-8 80-4 6-9",
    ": 92-6",
    ": 9-80004 8-10 3 5-22 5 8-9 31-4 6 40-2 4-5 7-50 2-3 8 61-2 4 6-9 71-5 7-8 80-2",
    ": 5 9-93 5-7 9 101 3 5 7 9-10 2-4 6-20 2 4-7 9-32 4-40 2 4-9 51-4 6-8 60 2-3 5",
    ": 7-70 2 4 6 9 82-3 5-6 9 92-4 6 8 200 2-4 6-7 9-13 24 6-7 32-4 9 43 5 7 9-50",
    ": 2-6 8 60 2-70 4 6 81-2 6-9 91 3-4 6-7 9-302 4 10-8 20-1 3 5 9-31 3-4 7-40 2-3",
    ": 5-6 9-50 2 5 7-60 2 5 8-73 7 9 81-2 4 6 90-1 3 6 8-9 402-7 11-3 8-9 21-3 6-8",
    ": 30-2 5-7 9 41-2 5 7-50 2 4 8-9 61 4-5 7-70 4-6 8-9 82 4-7 9 91 4 6 8 500-3 5",
    ": 7 9-10 2-8 20-2 7 30 2-41 3 5 8-9 53-4 6-60 4-7 9-70 2-4 8-9 81 3-7 90-2 4",
    ": 6-601 3 5-6 8-10 2-6 8-25 30-6 40-3 5-6 8-50 2 4 8 60-1 3-8 70-2 4-5 9 81 6-8",
    ": 90 7-8 700 2-7 10-3 6-23 5-6 8 30-40 2-9 51-3 6 60 2 4-6 8-72 4-7 9 81 4 6 91",
    ": 4 6-800 2-7 9-12 5 7 21 4 8-31 8 44-6 8 50 2 4-5 7-62 4-6 8-9 71 4 8 80-3 5",
    ": 8-9 91-2 7 9 901-6 8 14-6 9 21-30 5-8 41 3-5 7 9 51 4 6 9-62 4 8 71 4 6-9",
    ": 86-8 93-5 7",
    ": 1000-1 3 5-7 9 12-4 6-25 7-9 31 3 5-40 2-3 5-6 8 51-7 9-62 4 6 8 75-6 9-80 2",
    ": 4-9 93-4 100 4 8 15-7 9-21 3-5 33 5 7-8 42 5 9-54 6-76 83-5 7-91 3-5 8 201-2",
    ": 4 6-8 10-1 3 5 7 9 21 3-32 4-5 7 9 47 51-6 8-71 3-7 9-80 2 5 7-8 93-4 9 301-2",
    ": 4-6 8-9 12 5-8 20 2 5-30 2-3 5 7-8 40-2 4 6 8-51 3-61 4 6-8 76-8 80 2 4-5 7-8",
    ": 90 2 5-403 6-7 11 3 5-8 20 2 4 9-30 2-4 6-9 46-52 6-60 2 4-5 73 5 9 81-8 91-5",
    ": 8 500 2 4 6-13 6 8-22 4 6 8 34 6 8-42 4-6 9 53-4 6-7 9-62 5 7 73-6 8-80 2-4 7",
    ": 91 6-7 600 2-3 8-9 12-4 6-7 9 24 7-31 4 7-8 40-2 4-8 50-5 7 61-2 4-6 8-9 73 5",
    ": 7-8 81 3-8 90-1 4 8 700-2 6 10 5-6 8 20 2-3 7 9-33 5 7 9 43-4 6-51 3-5 7 61 3",
    ": 5 7 9-74 6-8 81 4-9 91 3 6-802 4-6 8 10-1 3 20 6-7 30 6 8-42 4 6-8 51 8-60 2",
    ": 4-7 9 71-2 4-81 3-5 7 9-92 5 9 903 5-8 10-2 4 6-23 5 7 9 31-2 4-6 8-41 5 50 3",
    ": 5 9-61 4-6 8-9 71 5 7-8 83-5 7-91 4 6-8",
    ": 2000-3 6 9 11 4-5 7-8 20-2 4-5 7 9-30 2-3 5-6 41-63 5-6 71 3 5-6 8-81 3 5-93",
    ": 5-9 101-12 4-5 7-8 20-6 8-31 3-6 40-5 9 51-4 8 60 2 4 6-7 9 71-9 81 3-4 6 8-9",
    ": 92 5-7 9 201 3-4 12 4 7 9-20 3-4 6 8-31 4-5 7-8 41 3 6-8 50-2 7-63 6 9 71 3-4",
    ": 8-80 2 4-5 7-91 3-5 7 305-6 8 10-1 5-6 8 20 3 5-7 9-31 3-5 8-9 41-2 4-51 3",
    ": 6-8 60 2-3 5 7-8 70 8-9 85 7-9 91-4 6-8 400-2 4-12 9-22 4-36 8-9 41-3 5-55 7",
    ": 9-72 4 6 8-80 2-5 7 9 91 3-5 7-8 500-1 3-5 7-13 5 9-20 2-6 8 30 4-7 40-5 7-52",
    ": 4 7-8 63 5 7 9 73 5 8-85 8 91-2 8-606 9-10 3-8 22 8-30 6 8-46 8 50 2 4 6-65 7",
    ": 9 71 4-5 7-80 3-6 8-90 2 4 8-700 2-3 6 9-16 8 20 4-5 7 9 34 6-7 9 43 51 3-4",
    ": 6-62 4 6-7 9 71-2 5-6 8-9 81 3-6 91 3-5 8 800 2 4 6 8-10 2 4-6 8-21 3 5 30 3",
    ": 5 8-9 43 52 5 7-8 60-1 3 5-7 71-3 6-82 4-7 90-1 6 9 902 4-5 7 10-4 6-7 21 5",
    ": 8-30 3 5 7 43 7 54 6-7 63-7 9 71-6 8 81-7 9 92",
    ": 6-3002 5-6 8 11-2 5-9 27 9-32 4 6 9-44 6-9 53-62 4-7 9 71 3-6 8 80 2-3 5 7 9",
    ": 93-4 6 9 101 3 6 8 10 2 4 6 8 21 5-9 31-2 5 7 40-1 3 5-52 4-9 65-6 70 2 5-9",
    ": 81-2 5-6 8 90 2 4-7 201-11 3 5 7 9-20 2-4 7-30 2 4-8 40-4 6 8 51 5-6 9 61 3-6",
    ": 70 2-9 81-2 4-5 9-90 2 4-5 7-9 301 3-6 8-9 11 7 9 21 5-7 30 2-7 9 42-4 6-7 9",
    ": 52 4 7-64 9-73 5-6 9 83 5-8 90-2 7 400 2-4 8-9 11-2 8 22 4 30 4 6-42 4 6 8 50",
    ": 4-5 7-8 63-6 71-3 5 7 9-84 9-90 2-5 8 500 6 9 12 5-6 9-20 2 5 8-32 4 6-42 6",
    ": 50 3-6 60-4 6-8 71-2 6 8 80 2 6 8-95 7 9-600 3 5 11-5 7 20 3 5-8 31-2 4 6-40",
    ": 2 4 7-8 50 3-5 8-9 61 3-4 6 8 72 4-5 8 80 2 4-5 7 9 91 3 5-8 700-3 5 9-10 2-3",
    ": 5-26 9 31-3 5-8 40-4 6 8 50 2 4-6 8 60 2-3 6-7 9 75-6 8-80 4 6 92 4 7 801-2 6",
    ": 18-25 7-9 31 4-40 2-7 9-53 6 8 60-5 8 70-1 4-5 7-8 80 3 7 90-1 4-7 900-1 3 5",
    ": 7-11 4 6-7 20 2 4 8-33 5-7 9-41 3-4 6-54 6 8 60-2 4-72 7-9 82 6-8 94-7",
    ": 4000 2-4 8 11 3 7-8 20-3 5-7 9-36 9-42 5-8 50-1 9 62 4-5 9 71 3-7 9 81-4 6 90",
    ": 2-3 5 7-9 101-2 4 7 9 11-4 6 8 21-9 31 5-7 41-4 6-8 51 61-4 71-2 6 8-85 7 9",
    ": 91-2 4-6 9 201 4-6 14-5 8 20-1 3 9 31-42 6 8-9 53-5 7 9-60 3 5 72-6 8-9 81",
    ": 8-92 5 7 9 301 3-4 7-8 10 3 7 22-5 8-36 40 2 5 7 9-51 3-7 60 4-7 9 71-85 7",
    ": 9-94 6 8-409 11-6 8-9 21-2 4-9 31-6 8 40 2 4 6-8 52 5 8-63 8 70-80 2-3 5-7",
    ": 9-92 4-6 8-9 502-7 9-13 5-9 21-7 9-30 3 5 7-8 42 4 8 50-1 6 8-9 61 4 7 9-70 3",
    ": 6-7 9 81-2 4 9-90 2 4-7 600 6-7 11-3 6 21 3 7-8 30 3-4 7-9 41-4 6-7 52 4-7",
    ": 64-5 7-70 2 4-81 5-8 91-5 9-702 4 6-7 11 4-5 9 22-3 5 8-9 32 4 6-7 9-40 2-4 7",
    ": 9-51 4-6 8 60 2-3 5-7 9 74 7-8 80 4-5 90-2 4 7 9-800 3-4 9-11 4-5 7-8 20 4-7",
    ": 30-1 3 5 7 40 2-50 5-6 8-63 5 9 71 3 6-82 4-9 92-4 9-900 3 5 7-12 4-7 20 2-3",
    ": 5-6 33-4 6 8 41-3 7 9-51 4 6 8 60 2 5-6 8 70-4 7 81-2 5-7 9-90 2-4 6-9",
    ": 5002-4 7-9 11-3 5 20 3-5 7-31 3 5-8 41-2 4-5 7-50 2 4-7 60-2 9-73 5-7 80-2 5",
    ": 7 90-1 4 6 9-101 3-6 8 11 3-8 20-1 3-4 6 30-2 5-46 54-6 8-60 2-4 6-7 9 71 3",
    ": 5-6 8 81-4 6-8 91-4 6-8 200-1 3 7 12 4 6 8 20 2-5 7 9 33 7-8 40 2 9 51-3 5-63",
    ": 6 70-3 7-9 81 6 8 91-2 7 9-303 6 10-3 6 20 2-9 31-7 40 4-55 7 9 63-4 7 9 71-2",
    ": 4 9 81 9-90 3 5-8 400-1 3 6-12 4 6-8 27 33-4 6-40 5 7 50 2 5-60 4 7-70 2 4-5",
    ": 8-9 81-6 8-91 3 5-9 501-7 9-16 8-9 23 5-6 8 30 2-6 8-44 6 8 50-2 4 9 65 7",
    ": 9-70 2 4-6 9 82 4 6-7 91-4 6-601 3 5 9-10 2-3 5 8 22 5-8 30-4 7 9 41-2 8-9 51",
    ": 6 8-60 6 9-70 2-3 6 8 81-3 5-6 8 90-2 4 6 8 701-3 5 7 9-13 5-6 9-20 2-7 33-8",
    ": 41-2 5-67 75-7 9 81-2 6-9 95 7 9-804 8 11-8 20-1 4-8 30-1 3 5-7 9 44 6-8 50-6",
    ": 8 64-70 2-80 2 4 6-7 90 2 4-6 8-904 6-9 11-3 6 9 25-6 8 30-1 3 5-41 3-4 6",
    ": 9-53 5 7-8 60 2-7 72-5 7-9 81 3-6 9 91 3 5 7",
    ": 9-6000 3-6 8-11 3 5 7 9 21 3-7 32 5-9 42-4 6 8 51 3 7 60 2-72 4-9 82-5 8 93",
    ": 5-8 100 3-5 7 9-10 2-6 8-21 4 31-3 5 7 40 3 7-9 52-5 8-63 5-7 70 6 8 80 2-3",
    ": 5-7 9 94 6-7 201 3-4 6 8 10 2 9 21 7 9 31-2 4 6-40 4-50 2-8 60-1 5-75 87 9-90",
    ": 3 5-300 2 4-10 3 5 7 20 3-4 6-7 9 31 3-4 6-44 51-2 6 9 61 3 5 7 9-70 2-5 7-8",
    ": 80-7 92 5-400 2 8-9 11 6-9 23 5-7 32 4 6-9 43 5-50 2 4-6 8 60 2-5 7 70 2 4",
    ": 6-7 9 83 5 7-8 90-4 6-7 503-8 10-4 7 9 21-6 8 37 9 43-8 51-6 8 60-5 7-8 70-1",
    ": 4-9 81-2 4 6-7 90 2-4 6-8 601 4-6 8 10 2-4 6 8-22 6 8-9 31-2 4-6 8 40-3 6-8",
    ": 51 3-4 9 61-3 5 7-8 70-5 80 2 5 7 9 91 3 5 709 11-2 4-7 26 8 30 2-6 41 3-6 9",
    ": 51 4-5 7-60 2 4 6 8-70 2 7 9-81 3-8 90 3 5 7 9 802-5 7 9-15 7-8 21 3 7 31 3-6",
    ": 9-42 4-51 5-6 8-9 61 3 8-70 3-8 80 7-9 93 8 900-2 4-7 9-10 3 6-22 4-6 8-30 2",
    ": 4-6 40-1 3 5-9 51-3 5-6 8-60 2 5-7 9-80 2 5 8 91-3 5 7",
    ": 7000-4 8-9 12-4 7 20-3 8 32-3 5 8-40 4-50 2 4-9 61 3-4 6 9 71 4 6 81 3 5 8-9",
    ": 92 5 7 100 3-5 7-11 3 5 9-20 2-3 6 9-30 3-6 8-43 5 50-1 3-8 60 2 4-8 70 3-9",
    ": 81-2 5 7-8 90-5 7 9 202-3 5 8 11 3-5 7 21 7 30 2 4-6 8-9 41 3 5-50 6 9-62",
    ": 6-72 4 7 9-80 2-4 8 92 9-303 5-10 3 7 24 6-9 31-42 4 6-50 2 5-8 60-4 6-9 73 5",
    ": 9-81 3 5-9 91 7 9 404-6 9 11 3 6 8 20-1 4 6-7 36 8-9 43 51 3-6 8 61-4 6-75",
    ": 7-9 81-90 2-7 9 502 4-10 20-1 3 5 7 30 2-4 6 8-42 4-55 7 9-66 8-9 71-2 5-7 9",
    ": 81-2 4 6-92 5 8-601 3 6 8 10 2 6-7 22 6 8 30 2-41 3 5 8 50-2 4-5 7-63 5 7 9",
    ": 72-6 8-9 83-6 8-94 7 9 701-3 15-22 4 7 31-4 6 8-9 41-6 50 5-6 8 60-7 9 71 3 6",
    ": 81-92 4-6 800-1 3 7-10 2 4 6 8-20 2-3 7 31 4 42 5 7 9 51-7 9 62 4-7 9 71-2 4",
    ": 6-7 9 91 6 902 6 10 3-5 8 20 2 4-8 33 5 7-8 40 2-3 5-8 50-4 6 8 60 2 5-7 9",
    ": 71-2 4 6-80 3-7 9-90 2 4-5",
    ": 8000-2 5-7 10 3-4 6-7 9-20 2 4-5 8 30-1 3 5 7 40 4 6-7 9-55 7-8 60 6-8 70-2 7",
    ": 9-81 3-5 90-2 5 7 9 102-4 8-22 5 7 37 9-41 3-6 8 50 2 4 8-62 6 8 70-1 3 5",
    ": 8-80 2-4 7 9-90 2 4-6 8-200 4 7-12 4-6 8 20 2 4 9-33 6 8-9 41-3 5 51-3 61 7-9",
    ": 71 3-7 9-82 4 6 8-91 3-4 300-3 5 7-9 14 6-20 3-5 7-8 30-4 40-1 3 6 9 51-5 7-8",
    ": 60-1 4-8 70 3 5 80-1 6 8 90 5-8 400-4 8-9 14 6 21 8 33 5-9 49-52 4 9-64 6-70",
    ": 2 4-5 9 81-3 5 93 7-502 5 7-11 3-5 7 22-3 5-7 34-5 8 41 3-4 9-54 7-8 60-6 8",
    ": 70-2 4 7-85 7 9-96 9 603 5 9-10 2-6 8-21 4-5 7 9 31 3-4 7 9 41-3 5-6 8-9 51",
    ": 6-65 7 70 4-7 80-2 6-90 2-3 5-703 6-9 11 3-25 9-32 4 6 8-9 41-6 8-50 2-7 9-63",
    ": 8 70 2-3 6-7 81-90 2-4 6 9 805-11 4 7 20-1 3 5 7-8 33-5 9-40 2-3 6-8 50 2-7",
    ": 60 2-7 9 73-6 9 81 5-6 90-4 901-5 7 11-7 9-21 3 9 31-2 4-6 9-46 9 53-4 6-8 60",
    ": 2 4-7 9-73 7 9-80 3-6 8 92-3",
    ": 5-9001 3-5 8-9 11-7 9-20 2-4 6 8 30-1 3-4 6-7 40-1 5-6 8 51-2 4-5 7-60 2 4 6",
    ": 8-9 71 6-9 81-5 7-8 90 3 5-6 9 101-6 8 13 5 7-23 5 7-30 2 4-9 41-4 6-7 50 2",
    ": 4-61 4-9 72 4-8 80 4 6 9-93 5-6 8-200 2-5 8-19 21 5-6 8-9 31-2 6-9 43-4 7",
    ": 50-1 3 5 7-62 4-6 9-77 9-81 3-6 9 91-3 5 7 9-300 2 4-7 9-14 6-7 9-23 5 30 2 6",
    ": 9-40 2 4 6-9 52 7 9-63 6 70 2-4 80-7 9-94 6 8-401 3 5-6 10 2-5 9 21-2 6-7",
    ": 9-31 4 6 42-3 5-51 3-6 8-9 61-2 4-5 9 71 3 5 7-8 80 2-95 7 500-7 9 11 4 9 23",
    ": 5-32 4 8 40-1 3 6-7 9-54 6-60 2 4 7-9 75 9-80 3 5 8-93 5 601-2 4-10 5-7 9",
    ": 21-3 6-7 30-6 40 2-6 9 54 8 61 4 6-8 70 5 7 83-6 8-9 91 4-7 9 703 5 7 9-12",
    ": 4-5 7 9-21 3 5-8 30 3-5 8 40-1 3 5 7 53 7 9 61 3-5 70 2 4 6-83 6-8 90-1 3-4 7",
    ": 9-802 11-2 4 6-7 21 3-4 7-8 30 2 6 8 44-5 8-9 52 5-7 62-5 8-9 71-2 4-9 81 3",
    ": 6-9 91-5 7-900 2-6 9-10 3 6 8-20 2-3 5-6 31 3-5 7-46 51-70 2-3 5 7-82 4 7-93",
    ": 5-8",
    ": 90002 4 6 10 3 7 9 21-2 4-38 41-2 4 50-1 5 7 9-63 5-71 4-5 7-8 80-2 90 2-6",
    ": 8-104 6-7 9 11 3-4 6-21 3 6-8 30-4 6-8 41-4 7 51 3-4 6 8-60 4 6 72 80-1 3 6-7",
    ": 9-91 7 200 2 4-7 13-6 8-24 6-30 3-5 9-40 2 4-9 57 9-64 6 72 4 7 81-3 5 7 9 93",
    ": 5-9 301 4 6-7 9-12 4-7 9-22 4-6 8 30-3 8 40 2 4-56 9 61-3 8-73 5-6 8-9 83 5",
    ": 8-90 2 4 6 9-400 2 7 9-21 3-4 6 9 32-5 7 9 41 4-8 53-7 9 62 5-7 9-73 5-8 81-8",
    ": 90-4 6-7 9 501 4 6 8-10 2 4 6-7 9-23 5-7 30 3-5 8 40 2-3 5-6 8 50-1 3-9 61-4",
    ": 7 9 72 4 6 8 83-5 8 91 3-5 8 602-3 6-10 3-4 6 9-20 3-5 7-31 3 5-6 8-9 41 3 5",
    ": 8-9 52 4-5 7 9 61-8 70-6 8-95 8-9 701 3-5 7-13 7 9 21 3-4 6-7 9 32-3 5-6 9",
    ": 41-2 4 9-50 2-3 9-60 2-73 6 8-81 91-3 8-801 3 6 9-15 9 23 6-7 9-30 2-3 5 8 41",
    ": 3-4 8-9 51 5-8 60-2 4 7-9 71-2 4 7 83 7 91-2 5-6 902-5 7-9 12-4 6-7 20 2 5-6",
    ": 8 30-2 6-7 9-41 4 6-8 51 3-6 61-2 8-9 71-2 4-81 3 5 8 90 2-6 8",
    ": 1002 5-12 4-20 4 6 8 30-44 6-8 50-2 7 60-3 5-74 7-8 83 7 9 91 7-8 100 2-4 6-7",
    ": 9 11 3-5 7 9 22-3 5-7 30-3 9 41 3-5 8 54 6-8 62 5 7-9 71-2 4-7 9 85-7 91-2",
    ": 4-6 201-4 7-8 10 2-3 7-20 2-5 7 30-1 3 5-6 40-2 4-54 6 60-2 4-6 8 70-3 5 7-82",
    ": 6-90 3 5 9-302 4 7 9 11-2 4 6 9 21 4-32 4-5 7-44 7-9 51 3-4 61 4-8 70 2 6-7",
    ": 83-90 3-5 7 400-4 6-8 10 3-5 7 9-31 3 5 7-8 40 2-8 50-1 3 5 7-9 61-2 7-70 2",
    ": 7-8 80 2 90 7 500-3 5-9 12 4 7-8 21 3-6 8-32 5 7 42 7-50 2 4 61-4 6-71 80-1 4",
    ": 6-9 91 5 7 603 6 9 11 3 6-21 3-5 7-30 2 4-6 8 40-5 7-52 4-63 7 70-1 3 5-6 8",
    ": 84 6-90 3-5 7-8 700-5 7 9-14 6 9-20 2-5 8-9 31 5-43 5 7 50 6-8 60-4 6-8 70 2",
    ": 4 6 8 80-1 3 5 7 9 91 4 6 9-800 2-5 8-9 11-2 5 8 20 2 5-7 9-30 3 5-7 9-40 2-3",
    ": 5-52 4-5 7 61 3 5 8 70-1 3 6 8-84 6-90 2-5 7 900-2 11-8 21-2 7 9 31-4 6 8-40",
    ": 4 50-2 4 6 8 60 2 4-5 7-8 70-3 6-8 80-5 7-8 93 5",
    ": 8-2001 3-4 6 8 11 8 20 2 4 7-8 30 2 7 9 42-3 51-4 6-9 64 8 70 2-4 6-7 9-85 7",
    ": 90 2-7 9 107-10 20-1 4 9-31 3-4 8-40 2-3 6 50 2 62-5 70-6 9-83 8 91 6 9-200 3",
    ": 8-10 3-4 6 22-5 7-9 31 3-5 8 41-6 8 50 2-8 61 4 6 72-3 6 8 81-2 4 6-90 3 5-7",
    ": 9 301-2 7-11 3-6 9 21-2 4-31 3 5 9-41 6-7 50-2 7 60-2 4-6 8 71 5 82 5 7-93",
    ": 5-401 6 8-10 2-4 7 9 22-5 7 30-2 4-7 9 41 3-8 52-5 8-60 2-3 71-6 8 80-3 9-90",
    ": 3 6 8-502 4-9 11-4 6 8-24 6 30-1 3 5-43 7-50 2-3 6 8 62 4 8 70 2 8 80-91 4 7",
    ": 9 603-4 6 8-12 5 7-20 2-5 8 30 2 4 6-7 9 44 9 51-2 5 7-63 5 7 71 3 81-2 4",
    ": 6-91 3 6 9-700 2-4 9 11-2 4 7 9 21-2 6 8 30 4 6 8 40-1 6 8 50-2 4 8 61 3 5",
    ": 7-75 7-9 81-3 5 8-90 2-9 801 3 11-2 4-7 9 22-3 5-30 2-4 8-41 3-5 7 9 52-6 62",
    ": 4-8 72-9 81 3-8 91 4 900-1 3 5 8-16 21-8 36-7 9 41 3-4 7-8 50 3-6 8-61 3 5 7",
    ": 72 5-6 8 82 8-90 5",
    ": 8-3000 2-3 6-7 9-22 7-9 39-42 9 51-4 9 62-7 74 6-80 2 5-9 92-4 8-107 9 11-3",
    ": 5-6 23-4 6 9-30 2 4-5 7 9 42 4-50 2 4-7 9-60 7 72 6-7 9-80 2-90 3-6 8-200 2",
    ": 4-6 10-7 20 2-31 3 5-6 8-41 3 7 9-50 2-7 60 3 5 8-9 71-3 5-80 2-4 6 9-90 2-3",
    ": 5 9 301 5 7 9-10 2 4 6 8 22-3 5 7-9 31 3-7 9 41-3 5-6 8-51 3-4 6-60 2 4 6-7",
    ": 9-70 2 5-84 6 9-91 3 6-404 6-8 15 8-22 4-8 32 5 9-42 5 9 51 7-60 2 4-8 75-6",
    ": 8-80 2-3 9 93 5 7-502 4-10 2-4 6-7 9-20 3 5-8 32-40 2-6 51-3 7 62 4 73 5-6",
    ": 8-83 5-9 93-6 8 601-2 4-7 10 2-6 22-6 8-35 7-40 2-4 6-50 2 5-6 9-60 3 6-70 3",
    ": 5 7-84 6-7 90-701 4-6 8 10-8 20 2-3 5 7-8 30-3 5-6 8 40-4 7-50 3-7 9 61 3",
    ": 6-77 9-81 3-6 8 90-4 6 8 800 2-3 5-6 9-10 3-6 22-3 7-8 30 2 6-7 9 41 4-5 59",
    ": 67 9-75 8-86 90 2 4 6-8 900 2 4 6 8-14 6 9-20 2 31 5-7 9-40 2 4 6 53-9 66 8-9",
    ": 71 3 5 9 81 8-93 5",
    ": 7-4000 2 4-8 10-2 7 9-20 5 7 30 3 9-42 5 7-8 50 2 4 8-60 3 6-70 2-7 9 81 5-8",
    ": 97-8 100-1 6 8 18-20 3-4 7-8 30 2-4 7 9-40 4 6-7 54-75 9-81 3-6 8-93 5-9 201",
    ": 3-12 8-20 2 7 31-4 8-9 42-8 55 7-61 3 5-72 4-9 84 7-90 3-4 6-300 2-3 5-7 10",
    ": 3-4 6-22 5 36-41 3-7 53-5 7-9 64-5 7 70 2-7 80-2 6-7 91-6 8 400-5 8 10-1 8-22",
    ": 30 3 5-7 40-1 57-9 61 3-4 9-71 6 80 2-6 9-90 2 7-9 501-6 8-13 6 20 3-5 32-5",
    ": 7-40 3-4 9-51 3-4 6 8 64-8 73-5 80-2 5-7 90-2 9 601-8 10 6-20 2-30 2-41 7-8",
    ": 57-60 3 5-6 8-9 71-4 86-7 9-90 2-3 5-8 700 7-14 20 4 6-32 4 7-43 5-7 9-52 4-8",
    ": 60 3-6 71 3-6 8 81-6 90 2-9 801-2 4-10 2-3 21-2 6-36 8 41-8 53 60 79-85 92",
    ": 4-7 902-5 8-9 11 7-25 30-42 6-9 54-6 9-61 3-76 8 81-90 5",
    ": 7-5002 6 9-12 6 20 5 8-30 40-3 5 7-8 53 9-64 7-72 5-8 80-2 5-7 91 8-9 101 5-7",
    ": 14-6 8 29 31-3 5 8 40-4 6-53 5 7-60 2-3 5 9 71-4 6 8 80 2 4-5 8-9 91 3 8",
    ": 201-2 6 11 4-5 8-24 6-31 3-5 7-40 3-4 6 8-50 2-3 5-7 9-63 6-8 70 3-5 7-84 6 8",
    ": 92 5-304 6-7 9 11-3 5-9 22-5 8-31 6-9 43 7-50 3-6 8 60 2-4 6-7 71-2 4-6 8-9",
    ": 81-2 4-5 7 9-95 402-3 5-11 5-8 23-4 6-31 3-4 7-41 6 51 5 9-62 5-9 81-4 9-90",
    ": 7-8 501-3 9-12 21-35 7 42-5 8 51-3 60-2 4-70 2-4 8-81 3 95 8-601 4-6 9 13-7",
    ": 9-23 34-5 7 9-42 4-5 57 9-60 3 73 5 82-94 702-5 7-8 12-4 9-22 9-33 9 46-9",
    ": 51-3 7-60 3-4 6-8 72-3 5 8-9 82-5 7 95-7 800 2 4-9 14-9 27-8 30 7-8 49-56",
    ": 9-62 5-6 8-71 6 80-9 93-909 12-4 6-29 31-6 41-7 51-4 9-72 5-91",
    ": 6002-5 10-1 9-20 32 6-9 42-50 8-63 5 8 70 5-7 9-81 3-6 9-95 9-100 2 8 13 6",
    ": 8-9 21-35 7-8 41-6 8-50 2-5 7-8 61-5 70 2-3 5-6 8-80 3 5-6 8-94 206-8 11-4",
    ": 6-24 6-7 38-9 42-3 8 50 2 6 60-1 6 8-9 72 9 81-4 6 9-92 4-9 304-8 12 4-20 8-9",
    ": 36 8-42 5-51 4 7 9-71 4-80 2-3 5 7-91 8 401 6-8 10-1 3-21 3-8 30 3-6 42-3 5",
    ": 8-51 6 8-74 6-83 5-93 5-503 8-9 11-6 20 4-7 9-32 5 42-56 8-9 64-70 85-9",
    ": 91-604 6-9 12-24 6-7 33-6 44-5 8-9 70 2-81 3-8 91-3 6-9 706-14 7-21 6 9-30 8",
    ": 40-1 6 9-52 7 9 62-3 5 8-75 8-83 90-1 3-6 803-9 11 4 7-22 6 8 30 2 6-44 7-54",
    ": 6-60 2-7 70-7 80-7 9-94 6-7 9-904 6-9 12-3 5-9 22-32 4 6-40 2 4 7 9-51 4-5",
    ": 60-1 4-7 71-4 9 85-6 8-90 4-9",
    ": 7002 5 8-19 23-6 8-43 6 8-9 51 5-7 60-5 9 72-8 80 2-4 7 9 91 3 6 100-2 5 7-8",
    ": 10-1 22 4-5 8-31 40-59 62 4 7 70-2 4-5 84 7 90-1 5 7 9 211-2 7-29 34-45 51-60",
    ": 4-5 73-6 9-82 6 92-8 304-5 9-21 4-8 33-40 6-52 4-8 60 3-9 71 5-7 85-7 9-91 7",
    ": 405 7-8 13-5 31 4-5 43 6-8 50-1 3 9 64-5 8 72-7 80-6 90-507 10-23 32-6 8 42-5",
    ": 8-51 5 7-64 6-82 6-9 92 5 7 601 4-14 7-9 23-8 30 2-6 40 2-6 8-52 6 9-68 71-2",
    ": 5-90 2-8 700-6 8-12 6 8-24 30-6 8 47-9 51 4-8 65-8 71-4 8-80 6-99 801 4-9 19",
    ": 34-7 40 3-4 6-7 51 3-5 7 64 8-79 82-3 8-900 3 5-6 9 12-20 2-7 30-4 9-44 6-7",
    ": 9-51 4-9 63-6 8-77 86 8-95",
    ": 7-8001 5-7 10-2 5-6 8-9 22-4 6-30 9-40 2-3 5-6 9-51 6 9-61 4-6 9-76 8-83 5-92",
    ": 4 7-105 8 12-8 32-3 42 4 7-9 57 9-73 9 83-4 6 8-96 8-200 3 6 8-15 7 9-21 3-4",
    ": 7-9 31-3 5-7 9-41 3 5 7-8 50-2 4-6 9 62-70 2-3 5-6 82-4 7-90 5 9-302 4-17 9",
    ": 21-2 4 7 9-33 7 44-6 8-9 53-6 61 3-5 72 4-5 7-9 86 8 93 6-7 411 3-28 32 5 7-8",
    ": 42 4-7 55 7-60 4-6 8-80 5-7 9 92-3 6 8-9 501-8 11-22 5 9 32-8 44 6-7 9-60",
    ": 2-86 91-600 2-5 9 11-23 7 30-2 4-42 4 6-7 50-1 3-68 70-4 8-9 81-6 8 91 4-6 9",
    ": 701-4 6 11-7 24-7 30-1 6 8-9 57 61-8 78-9 84-5 7 95-6 9-812 4-20 3 7-32 5-40",
    ": 2-3 6-9 53-7 9-68 71-3 7-80 2-4 6-90 5-911 5 9 21 3 7-39 47-8 50 5-6 8 60-3 7",
    ": 70-9 82-3 7 9-91",
    ": 6-9005 8-12 7 20 3-4 7-9 35-44 6-7 50 2-3 6 67-70 6-86 92-113 5 21 3-5 30-4",
    ": 6-45 7-53 5-6 61-3 75-6 80-6 9 91-2 9-202 4-6 8-9 16 24-32 4-5 7 40-1 3-6 8-9",
    ": 51 5-6 8-9 62-4 6-7 71-4 6-82 5-90 3 8 302-9 17-21 4-30 3 6-7 9-51 61-7 9 80",
    ": 3-6 9-90 4-400 2-4 8-10 4-6 20-1 3-8 30-2 4-41 5-6 51-2 5-7 71 7-8 82-94",
    ": 9-508 10 2-3 6 20-38 40-8 51-2 4 6-8 60-2 4-71 3 7-92 5 8-605 10-3 9-20 3-6",
    ": 31-2 4-5 9-42 4 6-50 3-6 61-5 9-93 8 700-1 5-11 3 5-6 8 25-8 30 5-40 6-7",
    ": 54-63 5 74-9 83-5 8-91 3-5 800-1 3-4 6 8-12 8 21 5-7 31-5 8-9 42-6 8-51 3-62",
    ": 4-5 8-73 81 3 6-98 900 4-5 7-36 9 45-6 50-60 4 8-74 9 82 4-5 8",
    ": 91-300005 7 11 4 9 21-2 4-6 8-9 31 4-9 41 8-50 2-3 6-8 60-2 5-7 9-70 3-5 7-9",
    ": 81-6 8-90 3 5-6 8 100 3 5 8 15-7 20-5 7-8 30-3 7-42 6 50 3-8 67 75 7-201 4-6",
    ": 9-11 3 7-9 22 9 33-6 8-9 42-4 6-8 54 7 60-5 74-6 8-9 83-4 8-315 21-4 8-32",
    ": 5-42 5-6 8-9 53-60 2-5 7-8 70-1 3-4 81-92 4-405 7-11 4 8-9 22-4 7-32 4-42 4",
    ": 58-60 3 5-6 74-5 8 80-7 9 94-5 9-502 5-7 10-5 8-31 3-4 9-47 52-3 8-71 6 80-5",
    ": 8-600 3-7 11-5 9 21-8 30-43 7-58 60-3 9 71-6 8-87 9-92 5 7-706 9-10 2-4 8-21",
    ": 5 32-4 6-41 5-57 61-5 8-9 76 80-95 7-803 7-15 8 21-2 6 8 30-8 40 2-4 6-51",
    ": 6-62 4-6 9-72 4-7 81 7 9-91 3-4 7-8 900-1 6-8 10-3 5 8-23 6 8 30-1 5 7 40 2",
    ": 5-50 3 5-6 9 67-70 2-5 80 3-5 7 90 3-6 8",
    ": 1001 4-7 11 4-9 21-6 8-36 8 46 8 53-5 7-8 60-76 8-82 5-98 100 8 14-7 20-6",
    ": 9-30 2-6 41-4 8-56 9-72 6 8-81 3-4 7-9 91 6-201 5 8 15-6 22 5-6 8 30-2 6-43 5",
    ": 8-56 61-4 6-71 3-6 84-7 91-7 303-5 11-9 22 4 6 33-7 40-6 8 54-70 3 5-9 82-5",
    ": 7-9 92-9 401 6-7 9 11 4 8 20-3 6-8 30-3 5-6 41-4 9 58-61 3-7 70-1 3-6 9 81",
    ": 4-8 90-1 3-9 502 8 11-4 8 20-1 5-6 8 30-1 4-5 7 40-2 4-5 7 50 4-8 65-70 3-9",
    ": 84 7 90-1 4-8 606-9 21-2 4-6 35 7 9 42-5 8-9 56-7 9 61-2 4 6-8 74 6 83 5",
    ": 90-703 7-10 7 22-6 9 32-3 5-8 41 5 7-50 3 8-9 63-5 7-8 70 3-4 9-82 8 90-1 6 8",
    ": 808 10-6 8-9 21-6 9 31-5 8-42 5-8 59-64 6-8 70-81 7-9 98 903-6 14 25 8 31 3 5",
    ": 8 40 2 4-5 9 51 64-85 9 96",
    ": 9-2000 11-3 26-9 33-6 41 3 6-51 3-8 60-2 5 71 3 5-7 80 4-5 91-4 6-105 8-15",
    ": 8-24 6-34 6-41 4-8 50-9 61-3 8-70 3-7 81 4-7 90-4 9-201 3-10 2-3 5-9 24-5 32",
    ": 40 7 57 61-3 70-4 80-8 91-3 6-8 300 2-5 9-20 2 4-6 9 34-5 7-9 41-52 5-61 4-6",
    ": 9-73 5-88 94 6-402 6-8 14 7 9-29 32-3 41-7 50-1 63-4 9 73-9 81-4 90-1 3-4",
    ": 7-518 20 4-6 8-33 6 8-41 7 9-50 5-8 60-5 8-75 8-90 2-611 4 8-20 4 8-30 2-41",
    ": 3-4 6 8-52 4 6-60 2 4-5 7-71 5-81 3-4 6 9-90 2-3 5-7 9-702 4-7 10-1 3 23-4 6",
    ": 8 30 3-4 40 2-3 7 52 5-61 5-73 6-7 82-4 6-7 90-4 7 9-803 16-7 23 5-40 4-5",
    ": 9-50 3-8 60 2 8-76 8 81-2 7 90-9 902-4 6 8-12 5-32 5 7 40-2 9-51 9 66-70 5-8",
    ": 81-2 6-90 3-5",
    ": 9-3000 2-6 11-9 21-2 7-9 32 9-40 3-4 50-1 4-5 60 74-6 81-3 5-9 92-3 8 101-3",
    ": 15-24 6 8 32-7 9-42 4 6-7 52 5 9-60 2 5-7 71-2 5-8 80-1 6 93-7 212-3 20-1 3",
    ": 5-36 8 40-54 61-3 8 71-3 5 7 83-94 8-300 2-3 5 7-8 12-8 20-3 5 8 31 3 5 7-9",
    ": 41-3 5 7 9-50 4-8 64 7 70 4-8 80-1 5 7 9-91 3 5-6 8-9 402-3 6-8 10 8-24 6-31",
    ": 41-9 51-2 60-3 70-3 82 4-8 96-501 4-11 4-9 21-2 5-8 35 7-9 45 7 53-4 7-69",
    ": 71-2 4 6-7 80-2 4 9-91 4-8 613 5 8-29 31-2 5-6 9 41-56 9-65 70-1 4-9 82-6 90",
    ": 5-7 706-8 11 3-4 8-25 8 32 4 6-46 51 4-6 8 61-3 7-8 73-4 6-91 8-803 6-9 14 9",
    ": 21 7-8 32-8 40-50 2 4-63 6 8-9 74 8-82 4-5 90-901 3-12 8-9 21 4-8 36-41 3",
    ": 5-55 8-66 8-81 3-92 6-8",
    ": 4000-2 6 11-5 8 20 2-5 7-30 3-46 64 8 70 7-8 95-101 3-5 8-12 5 9-28 30 2 4",
    ": 6-7 9 54-5 8-66 9-82 4 91-202 5-11 3-5 7-8 26-7 32-42 6-7 51-2 5-67 9 73-301",
    ": 6-8 11-20 3-5 8-42 4 6-57 62-4 6-8 70-83 6 8 91 3-403 7-17 22-6 31-4 9-42 5-6",
    ": 9-56 9-62 7-73 6-9 82 5 92-501 5 7-9 11-2 6 20-3 31-40 4 6 52-78 80-4 6 91",
    ": 5-6 600 3-5 7-12 7-27 32-6 9-45 8-9 51 3-5 7-61 4 7-72 6 8-81 6 9-95 8 700-5",
    ": 11 5-7 31-2 5 45 7-8 60-3 5 8-73 7-82 6 8-9 95-7 803-5 11-2 4-20 3 8-35 9-41",
    ": 3-7 51 3-7 60 3-6 74-5 7-87 90 3-909 12-3 6-7 20 5-6 32-41 5-57 9-60 2 5-7",
    ": 70-1 6-86 9 96 9",
    ": 5002 6 12-26 9-30 5 40 5-7 50-1 3 5-70 2-3 81-4 8-90 4-5 8-105 10 3-7 9 22-30",
    ": 7-9 41 4-52 5-7 61 71-3 5-6 8-85 90-1 3-9 202-6 11-8 20 4 7-8 35-6 8 41 3-4",
    ": 6-7 53-4 8-61 5-91 4 6 8-302 8-15 9-22 5 31 9-47 50-3 7 61 4 7-70 2-3 6 9-81",
    ": 7-94 6-404 7-15 7-8 23-35 7-48 50 4-8 62-6 8-70 3-81 5-6 9-91 3 7 9 503-15",
    ": 9-29 31-5 8-9 41-50 8-66 9-70 80-6 602-5 7-9 16-24 33-7 42-3 5 8 50-1 6 62-71",
    ": 4 82-4 6 9-91 3-4 700 3-7 9-10 2-20 4-5 9 31 4 6-7 9 43 8-9 54-62 7-78 80-2",
    ": 92-808 17-24 9-30 3 44 51-63 9-70 2 5-8 80-5 7-9 92-9 905-9 12-25 30-6 8 40-2",
    ": 4-5 8-50 2-7 61-6 8-81 3-9 93 6 8-9",
    ": 6001-5 9-10 2-4 6-9 21 3 5 7-30 2-5 9-41 3-6 51-2 5-7 60 2-3 6-7 70 2 5-6",
    ": 9-80 2-7 9-90 3-4 6-7 9-100 2-3 5 7-9 12-3 5 7-32 5-41 5-52 4-5 8-9 63-4 7-72",
    ": 4-8 84-91 5-9 210-1 8 20-2 5-8 40-4 51-9 64 7 73-80 3-4 94-8 300-4 7-10 5 7",
    ": 20-3 31-46 54-66 9-71 4-87 91-2 9 401-2 7-8 11-21 3-31 5 7 43-4 7-9 51-6 65",
    ": 7-76 8-90 2-3 5-6 8-504 6 8 10 2 4-5 20-1 3 31-6 43-5 9-52 9 61-73 8 82-5",
    ": 9-93 600-3 6 8-10 2-4 6-20 3-33 5-9 61-2 5 8-82 93-713 6 8 23-8 32-4 41-5 7-8",
    ": 50-4 6-9 62-3 8-71 3-81 7 90-2 4-6 800-11 3 5 9-20 6 31-3 5-6 41-3 5-8 57-68",
    ": 75-6 80-1 4-7 94-902 10 5-21 4-9 32-6 42 5-50 3-6 60-1 4 9-72 4 81-2 7-8 91",
    ": 4-7000 4-5 14 6-8 20 30 2-40 6 9-52 4-60 75-9 83 5-6 91 4 9 105 7-12 8-24",
    ": 30-40 2-7 54 7-68 71-3 8-80 2 5-207 9-15 7 20-4 8-9 31-3 7-43 5-9 52 5-6 8 68",
    ": 73-7 9-85 90-1 4-6 9 307-21 4-8 36-42 5 8-54 6-60 4 7 79-80 5-91 3 8 402 11-2",
    ": 5-23 6-8 31 4 42-5 8-51 4-6 60-2 5-6 73-6 80-2 4-6 91 3 5 7-9 501-2 5-6 9 11",
    ": 4 7-9 21-2 8-35 7-8 40-3 8 52-3 6 8-65 7-8 71 3-81 3-91 3 5 7-8 600-5 10-5",
    ": 8-9 23 6 32 4 6 8-41 3 5-8 51-2 4 9-62 4-72 5-7 81 4-5 8-95 7-704 7-13 5-8",
    ": 20-9 38 44 7-9 51 3-64 6-9 72 4-8 82-6 8 90 3-5 8-804 7-9 11-6 8-24 30 9-51 7",
    ": 9 64-5 8 75-6 8 82 4-94 6-903 6 12-7 23 31 4-6 41-5 51-5 7-9 61-6 8 70 2 6 9",
    ": 82-3 5-6 8-91 3 5",
    ": 8000 4 6-10 2 4-5 7 9-31 5 8-42 5-54 8-9 61 3 5-6 71-3 5-9 84-7 97-8 104 9",
    ": 12-3 6 20-1 3-5 9 33-6 9-40 5-7 9-54 8-66 8-75 7-80 3-6 8-96 9-200 9 16 8 21",
    ": 3 6 31-6 8-41 5-9 53-5 7-64 6 70-1 6-7 80-1 3-6 92 7 300-10 4 20-3 5-31 3 9",
    ": 45 8-54 6-7 60 8-70 2 4-8 81-2 8-9 92-3 8-9 402-3 6-10 2-6 8-25 9-30 3 6 8-9",
    ": 41-8 51-2 4-7 60-2 4 75-91 3 6 500 3 8-13 20-1 5 8 32-3 9-54 7-65 9 73 5 7-84",
    ": 9-98 602-5 7-15 23-37 9-46 9 58-9 61-7 75 9-82 5 90 4 700-10 5-8 23-6 9-42",
    ": 50-7 62 74-9 84-5 804 7 9-11 6-7 9 22-6 8 31-2 7 41-3 5-6 59 63-4 8 70 2-3 5",
    ": 8-80 9-92 5-8 902-4 11-3 21-4 32-4 42-6 50 9-67 9 71 7-80 8-90",
    ": 8-9002 6-8 10-4 6-35 50-60 4 71 7-82 4-5 8-91 6-7 100 4-6 14-8 22-4 6 30 2-7",
    ": 40 4 6-52 6-7 62-3 5-7 71-4 7-89 91-205 14 7-20 3-7 32-4 6-7 9-44 6-51 4-5 9",
    ": 63-6 8-71 3 7-81 4 6-8 91-2 6-301 6-11 3-22 7-9 31-3 7-9 42 4-6 8-50 2-8 60-9",
    ": 72-5 7 80 2-3 6 8-406 10-1 3-4 7 22 7 32-3 6-41 5-55 7-8 60-1 5-9 80-3 92-511",
    ": 3-7 20 2-5 8 31 4 8-9 41-3 6 8-53 5-73 6-8 80-3 5-9 92-3 8 600-3 5-8 13 5 23",
    ": 6-9 31-4 9-45 8-56 8-74 8-80 3 7-9 91-5 702-3 6 9-10 2-6 23 40-2 4-58 62 4-71",
    ": 4-6 82-8 803-4 7-8 10-8 20-8 30-7 9 43-4 51-3 6 8 77 9-82 5-7 96-7 9-905 10-1",
    ": 4 6-20 4 6-31 3 6-7 42-7 50 3 5-60 4 8-72 80-1 6-90 6 9",
    ": 10004 11-4 6 8-21 5 7-9 31 3 5-57 9 64-6 77 83 5 7 9-93 7 105-13 6 20-7 30-8",
    ": 41-2 4-5 7-8 51 6 9-67 9-73 80-5 90-3 8-206 9-13 6-8 20-7 30-6 8-9 41-3 9 51",
    ": 3-5 63 6 8 71 3 5-85 95 7-8 310-1 3-5 7-8 20-3 7-8 31-6 9-44 7-8 51 5-70 9-82",
    ": 7 97-402 5 12-5 24-33 5-43 52-6 62 4-7 9-70 3-4 80-1 4 6-7 91-7 501 4 6-13",
    ": 5-7 9-20 3-7 9-32 5 7-8 41-4 6-8 51-3 61-2 5 7 73-4 6 8 81 3-6 92-609 13 5-20",
    ": 3-5 32-3 7-9 44-6 8-50 3-5 9-65 8-70 6-80 5-90 2 701-5 7-9 11 6-8 21-6 8-30 3",
    ": 7-44 6-9 51-5 60-7 73-80 2-3 93 6 8-802 5 7 9-15 9-20 5-8 32-40 4-8 50-4 8",
    ": 60-1 3-72 8 81 3-4 90-4 9-904 7 9 12-3 5-6 8-9 22-5 8-34 9-47 9-50 2 6-7 9-61",
    ": 3-7 73-80 2-7 9-96 8",
    ": 1002-5 7-8 14 7 9 21-2 4 6-7 9-32 40 2-3 6-8 50 5-60 2-71 3-80 2-4 6-9 91-3 5",
    ": 101-2 7-11 4 8-25 9-31 3-6 9-52 5-6 9 61 4 7-83 8-9 91-7 9-207 10-2 23-33 6 9",
    ": 43-6 8-50 4 6-60 2-4 71-6 8-80 2 6 8 90 9 301 3 6-11 7 9-26 32 8-9 43-52 4",
    ": 7-9 81 4 95-7 406-14 23 5-8 31 3 6-9 43 5-6 8-9 51 3-4 6-9 62-4 7-8 70-2 5-8",
    ": 80-1 3 5-7 9 93-500 2-3 5-8 16 8-9 21 7-32 6-9 44-7 54-5 7-8 62 8 70 3-4 6-9",
    ": 81-6 91 7-608 10-1 3-7 22-8 30-8 40-4 6 50 6-7 9-61 78-9 84-5 99-700 3-4 7",
    ": 9-10 8-23 7-31 4-5 8-43 6 50-5 60-70 7 81 4-5 95 9-803 6-15 7 21-3 9-32 4",
    ": 40-2 4-6 8 50 2-5 7 9 61-2 4-5 7-8 70 4 6-80 2 5-7 9 92 5-8 900-6 9-11 3 5-8",
    ": 20-1 4-5 8 32-7 9 41 3-4 6 8 55 62 6 70-4 8-9 82-4 6-7 91-2 6",
    ": 8-2003 8-9 12-4 8-23 9-33 5-6 42-4 50-2 7-73 6 81-2 6-8 91 3-9 108-12 20 2",
    ": 5-7 9-31 3 8 40-3 7-51 4-9 61-7 74-80 4 9-91 6-7 200-4 6-15 8-28 30 4-42 9 51",
    ": 3 5-66 8 70 3 7-80 2 4 6 93 301-4 10 2-4 8-21 5-6 8-41 4-9 54 6-7 61 6-8 70-4",
    ": 81 8-9 91-5 8-403 7-8 10-6 20-8 34 6 8-45 7-56 8-61 4 70-4 6-84 7-93 5-6 9",
    ": 501-2 5-11 3 5-7 9 22-6 8-9 31-3 9-40 2-50 2-3 61 3-9 71 3-7 81-90 2-3 5-6",
    ": 9-600 7-10 5-7 21 7 32-5 40-4 7 53-7 9-66 8 71 8 82 6 8-92 4 8-705 7 9-11 3-4",
    ": 6-23 5-6 9-33 6-40 3-7 9 51 3 5-6 8 60-6 70-3 5 7 9 83-4 6-8 90-3 5-801 5-9",
    ": 13-7 21-2 7-30 2 5-8 40-6 9-50 6-9 66-7 70 2-3 6-81 5-6 90-2 4-8 900-1 4-5",
    ": 8-9 11-4 7-8 21 3-4 6-8 30 3-5 8 40-7 54-5 7-9 62 4-7 70-2 4-5 7-9 87 9 91 4",
    ": 6",
    ": 3000-3 7-8 10-1 3-7 20 2-3 5 7 9-37 9 41-6 9-59 63-5 8-71 8 80-1 4-5 7 90 2-3",
    ": 9-100 2-3 5-6 9-16 20 3 5-32 4 8-9 41-3 5-6 8-9 52 5-7 9 62-5 7-71 3 6-8 80-1",
    ": 6-99 201-6 11 21-6 8 33-5 42-3 5-9 52 6-61 3-74 9-82 6-93 6-306 9-12 4-22 4-5",
    ": 31 41-4 6 9-50 3-4 8 61 3-4 6-7 9-76 8 86-9 94-7 400 6-9 11-3 8 20 3 5 8-9",
    ": 32-3 5 8-46 64-6 71-6 85-6 92-6 503-9 11-8 23-4 7 9-30 5-6 44 8 51 4-5 60-8",
    ": 71-5 7-81 4-7 92-4 6-8 601-9 12 4-5 7-8 22-5 30 2-5 8-9 42-4 6-7 53-5 7 9 62",
    ": 4 75-8 80 2 7-8 90-703 5 9 11 3-6 21 3-5 8-33 8 43-5 8-52 5-8 60-8 70-1 5-7",
    ": 84-92 6-7 800 2-5 10-36 42-3 6-8 50-60 2-9 72-4 6-9 83-4 8 92 6-902 4-8 12-9",
    ": 24-7 34-9 43-4 6-7 51-2 5-63 71-6 8 83-6 91-2 4",
    ": 7-4004 6-9 11 4 9-22 8 32-3 9-47 9-55 7-9 62-7 75-8 84 90-1 4-7 9 101-8 13-6",
    ": 20-3 5-8 31 3-4 7-42 4 6-50 4 8-69 71 3-5 7 80-5 8-90 2 4-5 8-201 4-6 8 11-4",
    ": 21 4 6-30 2 4-6 8 41 4-6 9-51 3 7-62 4 7-8 70-2 5-6 8 83-4 7 9-92 5 7 300-1",
    ": 4-5 10-3 5-21 3-6 8-9 31-2 6 9-40 3-6 9 52 4-6 8 60 3-5 7-70 2-4 82-3 92-9",
    ": 401 15-6 20-56 65-6 9 74-5 8-9 82-3 5-6 92-3 6-504 7 9-10 2-3 6 23-30 3-9",
    ": 41-2 4-7 9-56 8 61 3 5-73 84-5 8-9 92-3 5 7 600-5 11 4-6 9-21 31-4 6 8-9 41-2",
    ": 5-7 50-66 8-72 83 6-9 92-704 10 2-9 21-5 8 31-3 7-45 7-53 5 8-62 9 75-6 8",
    ": 81-3 6-7 9 94-800 5-6 8 10-1 3-6 8 20-2 4 6-37 9-47 54-7 9-61 3 5 8-73 5-8",
    ": 82-96 903-10 2 21-2 5 8-32 4 8-55 7-9 61-2 4-6 8-9 82 6-7 9-90 4",
    ": 5000 6-8 11 6-9 23-4 8-30 4-7 43-9 51-3 6 9 61-4 7 9-72 5 7-84 7 93-4 6 8-100",
    ": 8-17 22-3 6 9-32 6 8 40-4 7-8 50-2 6-9 64-71 4-8 87 9-99 201 6 18-20 2-3 6 9",
    ": 31-2 4-5 8-9 41 3-5 8 51 3 5-7 60-2 5 8 70-8 81-3 5-8 92 5-6 300 10-21 4-7 30",
    ": 9 43-4 6 51-4 6-64 7 9 78-88 90-7 9 401-2 8 11 5-6 8 22-4 6-8 30-4 8 46 9-55",
    ": 7-61 5-9 72-84 6-9 94 500-1 3 5 9 16 9 27-9 31 3-5 8-43 9-56 60 2-5 9-71 3",
    ": 5-92 6 602-3 7-10 2 9-20 4-7 31-2 40-5 51 3 5 60 3 6-8 70-1 5-80 3-4 90-4 7 9",
    ": 701 5 11-24 6-31 3 5-9 45-54 6-64 8-70 4-86 9-90 2-9 801-15 7-8 20-1 3 5 7",
    ": 32-6 40-7 54 6-62 6-70 2-9 82-5 7 9-92 6-8 900 2-8 10 2 4-9 21-35 8-41 5 7-8",
    ": 51-4 6-63 8-74 80 2-4 6 9-90 5",
    ": 9-6001 5-8 10 6-7 20-5 8-9 36-40 3 7-8 51 3 6 9 62-4 9-73 5-9 81 3 5-92 5",
    ": 100-4 6-12 5-20 2-7 9 33 7 9-42 4-6 52 5 8-63 5-7 71-2 4-5 8-84 7-90 2 6-7",
    ": 9-201 5-6 8 10 3 5-9 21-2 4-7 32-5 8 42-6 9-50 3 7-9 66-7 70 5-9 81-4 7 94",
    ": 6-7 301-2 6 8 12-4 6-9 22-4 9-31 5 7-40 2-8 53-4 6-7 60-1 3 5-8 70-1 3-6 8-80",
    ": 3-4 6-8 93-7 9-400 4-7 14 20 3-4 6-8 30-1 3-6 8-41 3-7 9 53-6 8 61-4 6 70 4-6",
    ": 8-9 84 6-8 90-2 6 8 502-3 6-7 9-11 5-6 8 20-1 5-6 30-3 6 8-40 2-5 50 3-62",
    ": 7-74 6-9 81-3 5-91 3 5-7 601 3-6 8-9 14-6 8-24 7-8 30 3-8 40-5 7-9 51-2 6",
    ": 8-60 2-3 6-8 70-2 4-7 9-82 4 6-94 6-703 5 7-8 11-8 20 3-6 8-33 5 8-9 42-3 5-8",
    ": 51 5 7-63 7-8 70 2-3 7-8 81-3 7 92-4 7 9 802-3 6-7 9-13 5-20 2-3 5-6 31 4-5",
    ": 7-42 6-9 51-3 5 8-61 3-71 3 5-8 80-1 3-5 7 9-92 4-7 9-916 8-9 22 4 6-30 2-5",
    ": 8-9 41 4 6-7 51 3-7 9 62-7 9 71-2 4-83 7-96",
    ": 8-7004 6-8 10-1 3-4 6-21 4-8 31-4 6-42 4-5 7-58 65-8 70 2-5 8-80 2 5 9 91-5 7",
    ": 100-1 7-16 9 22-8 30-40 2-4 6 8 52 5 9-63 7-70 3-4 80 3-4 7-91 7 201-3 7 9-11",
    ": 3-4 7 20 2-9 34 6 9-41 3 5-9 51-9 62-3 5 7-8 71-2 4 8-84 9-94 6 9-303 7-11",
    ": 4-5 7 9 21-5 8-31 4-41 3 5-7 50 2 4-5 7-60 2 4-5 7-74 6 9-86 8-91 4-400 3-4",
    ": 6-8 10-1 4-5 7-8 21-2 4-8 30-7 9 42-6 8-54 6 9-62 6 9-70 2-8 80-90 2 4-6",
    ": 500-1 3-4 8 11-3 8-9 21-30 3-8 41 4 6-8 50 2-4 6 9 61-2 7 70 4-6 8-9 81 3-4",
    ": 7-9 91 3-4 6 8-601 3 5-6 8-12 4 6 9 21-2 6-7 9-38 40-3 5-6 8-9 51-2 4 9-60",
    ": 2-3 5-71 3-4 6-8 80 2-5 7 90 3 5-6 8 700 2-3 5 11-2 4 7 9-25 7-8 30-1 3-6 8",
    ": 40-2 7 9-54 8-61 3 8-9 71-7 80-1 3 6-9 92-4 8 800-3 7 10-1 5 9-23 5-31 4-8",
    ": 40-2 5-7 9 51-6 8-61 3-8 72-4 8 80 5 7-90 2-8 901-3 5-13 5 7-20 2-3 5-8 30-2",
    ": 4 8-9 41 3-7 50-2 6-9 62-5 7-72 5 7-80 2-5 8-9 91-4 6-9",
    ": 8001-6 8 11 3-4 6-9 21-4 7-39 41-6 9-50 3 5-8 61-5 7 9-70 3 7-81 4-5 9-91 100",
    ": 5-11 3-7 9 23-7 9-37 9 41-7 9-60 2 4-5 72 4 6-9 81-6 8 90-2 6 202-8 10-4 9-24",
    ": 6 9-36 8 40-4 6 8-9 51-2 4-5 7-8 60-1 4-6 73 7-83 5-9 91-8 300-3 5 8 10-1 4-6",
    ": 8-20 3 9-30 4-5 7-42 4 7 9 54-9 63-9 72 5-89 91 4-400 2 7-11 4 6-9 21-4 6-7",
    ": 30-2 6 8-40 5-6 8 51-3 6 9 63-4 7-72 5-81 4 6 90-1 5-7 501-3 5-10 5 7-21 3",
    ": 6-8 30-4 7 40-2 6-9 51 4-5 7-9 61-2 4-6 8-9 72 5-8 80-1 5 7-9 91-3 5-6 8-9",
    ": 601 3-12 5-6 20 2-3 5-8 30 2-3 5-6 8-40 3-5 7-56 8-60 2-3 6-8 70 3-5 7 80-1 3",
    ": 5 7 9 91-4 6 8-700 3-9 13-6 20-5 7-8 30-3 6 40-4 7-56 60 2-6 8-70 3-4 7-8 80",
    ": 3-6 8-9 91 4-6 8-804 6-7 10 5-7 9-21 7-8 30 2-3 5-6 8 40-2 5-9 52 5-7 9 61",
    ": 3-5 7-72 4-5 7-80 2-3 5-91 3 5 7-8 900-5 7-8 10-6 9-21 4 7-8 30-4 7-8 40-3 7",
    ": 51-3 7-8 60-2 4-5 7-73 5-9 82 6-94 6-8",
    ": 9000 2-3 5-7 11-4 6-7 9 21-2 4-5 7 9-30 3-7 41-6 8-9 51 3 5 7-60 2-7 70-1 3-4",
    ": 7-9 81-9 91-3 5 7-100 2-7 11 6-7 9 22-3 5-7 9 32-7 42-6 8 50 2-5 9-60 5-72 4",
    ": 6-8 80-3 6 9-92 4-6 9-200 2-10 5-8 22 5 30-4 7-40 6 8-51 4 6-8 60-1 3-4 6-7",
    ": 9-71 4 6-7 80 2 4-6 90 2 4-5 7-8 300-4 6-7 9 11 3-4 22 5 9-33 6 40-5 7-53 5-7",
    ": 9 62 5-6 8 70-5 7-8 80 2 4-5 8-9 91-2 5-6 8-9 402-3 6-10 3 5 20-5 8-36 9 42",
    ": 6-50 2 4-7 9-61 5 7-9 71 4 6-7 9 81-2 4 7-97 9 503 8-11 3-5 8-20 5-6 31 3 5-6",
    ": 8-9 41-2 4-9 51-7 64-5 7-73 5-6 9-80 2 5-8 90-2 6 8 602-3 11 3-6 21-3 7-9",
    ": 31-6 8-42 4-5 9 51-2 4-9 63-7 9-72 4-9 81-2 4-92 6-704 7-8 10-3 5-25 9-34",
    ": 6-41 4 6-7 50-4 7-9 63-8 70 2-3 5-8 80-2 4-5 8-90 2-4 6 8-806 8-9 12 5-24 6",
    ": 8-9 32-3 5 7-45 7-53 5 7-60 2-7 9 72-3 5-81 3 5-90 2-5 8-900 2 6-14 7-24 6-33",
    ": 6-8 40-2 4-6 9 51-3 7-62 5-6 8-71 3-5 7 81-2 6 9-97",
    ": 9-20000 2-3 6-10 5-6 8 23 7 30-2 4-41 3 7-8 51-6 8-61 6 9-71 3-4 6-9 81 3 5-8",
    ": 90-1 4-100 2 4-15 7 22 7-9 31-2 5 7 9 41-4 6-7 9 52 4-60 3-4 6 8-9 71-2 4",
    ": 7-82 5-6 90-2 5-8 200-1 4-5 9-10 2 4-6 8 20-1 3 5-8 30 2 4 6 8-42 4-9 52-5 7",
    ": 60-1 4-7 71-80 2-3 6 8-9 92 4 7-9 302 4-9 11 4 6-22 5-7 9 31-7 9-43 6-50 5-6",
    ": 62 4-6 73-5 7-9 83-93 5-9 403-5 7-17 9-20 4 6-9 31-4 6-7 9-41 3-5 7-50 2-3 5",
    ": 8-9 61-2 4-8 70-4 8-9 81 5-6 90-5 7-9 501 5 7-13 5 7-22 4-8 30-2 4-8 42-3 5-7",
    ": 9-54 6-61 5-8 78-9 81 3-6 90-4 6-7 9 603-4 6 12-3 5-6 25-7 32-3 5-40 51-4 6-9",
    ": 62-9 71-6 8-80 2-90 3-8 700-1 4-6 9-11 3-4 8 20 2-3 5-6 8-34 6-41 4-53 5 7",
    ": 60-5 7-8 72 4-5 7-83 5-97 803-6 9-15 24-31 5-6 9-41 3-4 6 8-9 51-2 4-5 7-9 63",
    ": 5-6 70-6 83 8-9 93-9 901-3 6 10-20 2 5-30 2-3 5-7 40 3-4 6-50 6-9 63 6-7 9-71",
    ": 4 7 9 82-8 91-2 5-7 9",
    ": 1002 4-5 8 11 3-7 9 23-30 2-4 7-42 50-2 5-60 5-9 72-5 8 80-1 4-8 92 4-9 102-5",
    ": 7-15 8-22 7-9 31-3 5 7 9-41 4-6 51-3 5 8 60-1 3-8 70 2-3 5-6 8-80 4 9 91",
    ": 3-202 4-6 9-11 3-6 21-3 6-7 9-30 4 9-41 4-8 51 3 5 7-9 62-3 8-9 72 7-8 80-1",
    ": 6-8 93 5 9-302 4 6 8-12 6 9-22 4-8 31-5 40-1 4 6 8-54 6-8 64-9 71-3 5-80 3-8",
    ": 90-4 6 8-403 7 9-17 21-2 30 2 5-9 43-5 7-50 3-5 7-8 61 3-6 8 72-3 8-9 84-90",
    ": 4-8 500-1 3 11-9 21-2 4-5 8 30-9 43-4 6 52-5 7-8 60-1 3-6 8-9 72-5 7 80 2-3 5",
    ": 7 9-90 5-7 9-605 9-10 2-3 7-9 27-8 30-4 6-40 3-6 8-9 51-3 6-8 60-1 4-8 71-81",
    ": 3 7-92 4-5 8-9 701-6 9-11 5-6 8-23 5 31-2 4-7 9-41 3-9 52-9 61 3-6 70 2-7",
    ": 80-3 5-7 9-94 7-800 2-3 5-9 12-7 9 21-3 5-7 9-31 3-8 42-4 7-54 9-60 2-7 70-1",
    ": 3-8 80-91 3 5-6 9-903 5-6 10-8 20 2-4 6 30-4 7-9 41-7 50 3-5 7 9 61 3-9 72-82",
    ": 4-8 92-3 6-9",
    ": 2002-5 7 9 11-3 7-8 21-5 8-9 31-3 6-7 40-2 4-8 50 2-3 5-60 2-9 71-84 6-90 2-5",
    ": 7-9 101-3 7 14-7 20-9 32 4-5 8 41 3-4 6-7 50-1 5-6 62-6 72-9 86-7 9-92 4 6 8",
    ": 200 3-5 7-8 10-2 4 6-20 2 6-8 31-3 6-8 40-4 7-9 54-61 3 5 8-70 2 4-81 3 6-8",
    ": 90-2 7 300 2 4-9 11-2 5-7 21 5-9 31 3 5-42 5 8 50-8 60-5 7-8 70-3 5 8-9 81-2",
    ": 4-5 8 91 4 7-8 400 3-4 6-11 3-4 7 20-8 33-5 8-43 5-7 50-3 6-8 61-2 4-71 3-5",
    ": 7-8 81-6 8-90 2 4 7-504 7-10 3-5 7 9-21 3 8-31 4 6-42 4 6-7 9-53 9-62 4-8 70",
    ": 3 5 80-4 6-90 3 5-600 2 4 7-18 20-3 6-36 9-42 4-8 50 4-6 8-9 61-6 9 71 9-82 4",
    ": 6-91 4 8-9 702 4-8 10-4 7-21 3-6 8-31 3 5 44-8 52-7 66-8 75-8 80 2-3 8-90 2",
    ": 5-7 801-2 5-6 8-9 12-5 9 21-33 41 4-7 9-54 6-61 3-4 6-70 2-5 7-83 6 8 90-4",
    ": 8-9 901-2 5-6 9 14-9 21-2 4-6 30-2 9-40 2 5-7 9-51 3-4 6-9 61 4-5 8-9 71 4-5",
    ": 8-82 4-5 7-91 3-7",
    ": 3002 4-6 9-14 7 9-21 5 7 30-1 4-6 40-1 4-6 8-50 2-8 60 3-4 6-7 70-4 80-4 6-93",
    ": 6-111 3-23 5-7 30 3 8-42 4 6-8 50 3-5 7-9 61-4 6-9 72-3 5-8 80 8 92-6 8-9 203",
    ": 5-9 15-7 9-21 3-6 9 36-9 42 4-5 7 9-54 6 9 64-5 7-9 71-3 5 7 81-2 4 6 8-9 93",
    ": 7-8 300-4 7-8 11 3 6-7 9 21 4-6 8-34 6 8-41 3-4 7-59 63-5 7-74 9-84 6-9 92-7",
    ": 9 402-4 6 8 10 2-3 5 9 26 8 30-2 7 41 3 6-51 60-4 6-8 71-6 8-9 81 3-5 8-9",
    ": 91-500 2-6 8-10 2-3 7-22 4 6 30-2 8 45-55 9-63 8-81 3 6-90 2-6 8 600 2-7 11-9",
    ": 21-3 7-34 7-8 40-5 7 9 51-2 5-60 4 7 9-70 3 5-8 83-90 9-703 6-21 3 5 30 4-6",
    ": 9-40 2 4 8-9 51-5 7-8 62 4-5 7 70 3 6-85 7-8 92-3 7 9 801 3 5-6 9 13-4 6 8",
    ": 20-3 6-30 3-4 8-41 4 7 9 53-8 60-2 8-71 4-80 3-4 6-91 4-9 901-11 4-5 7-8 21-3",
    ": 7-32 8 40-2 4-8 50-1 8-60 4-6 9 71 4 8 80-3 5-7 9-90 2-4",
    ": 7-4000 3 6-7 10-8 22-5 9-36 8-44 7-9 51-7 9-61 3 6-7 72-3 6-7 83-4 6 93 8 100",
    ": 2-6 10-1 4-6 9-21 3-6 9-30 2-41 3-4 6 8 50-1 3 5 7-60 4-5 8 71 3 5 9-85 7-9",
    ": 92-8 200 2 4-6 8 10 2-7 9-23 5-31 4-7 40-1 3 6-7 51-4 7 9-62 5-6 70-1 4-8",
    ": 86-9 91-301 3-9 11-2 4-26 8-35 7-44 6-8 51-5 7 9-62 4-6 9 71-4 7 9 81-3 5-9",
    ": 91-4 6-8 400 2-12 4-7 20-30 2 5 7 9-40 2 4 6-7 9-51 3-5 7 9-65 7-74 7-8 81-2",
    ": 4 6 8 90-1 8 500-2 5-11 6 8-9 21 3-7 9-31 4 6-42 5-51 3 5-9 61 3-4 9 73-4",
    ": 6-84 6-7 9 92-7 600-2 4-7 9-17 21-6 8-9 31-2 4-7 9-45 7 9 51-7 9 66-8 73-4",
    ": 6-81 3-90 2 4-9 701 3 5-7 9 13 8 21-2 4-5 7 9-32 4-7 9-40 2-3 5-54 6-64 6-7",
    ": 70-2 4-5 7-8 80 2-6 8-90 2-8 801-3 5 7-9 11-6 8 20 4-5 9 31-3 7 9 42 4-5 7-9",
    ": 51 3-6 8-9 62 6-70 2-4 6-82 5-6 90 6-908 10-3 7-9 22-6 8-30 4-5 8-9 41-2 4-5",
    ": 7-51 3 5-7 9-62 5-6 8-9 72 6 9-81 7-91 3 5-7",
    ": 5001-2 4 7-8 13-4 6-7 9-20 3-4 7-30 2-3 7-9 41-8 50-3 5 61 3-5 7 70 2-7 9-82",
    ": 4-5 8 92-4 100 2 4-7 9 11-5 9-24 6-7 9-30 2-3 6 40-3 5-6 50-1 5-8 60-1 3-73 5",
    ": 7-82 7-95 8-200 2-3 5-6 8 11-3 5-6 8-22 4-5 7-31 3-6 9-43 5 8 50 3 6-60 2-5",
    ": 7-76 8-81 3 5 9-93 5 7 9 302 5-7 11-2 5 7-8 20 4 6-9 31-4 6-8 40-1 3-5 7-8",
    ": 50-4 6-62 4-8 70 2-3 6-7 9-80 4 6 8-9 92 4-9 403-5 8 13 5 7-9 21-5 7 9-33 5-6",
    ": 8-41 3 5-7 9-50 2-3 5-62 5-6 8 74 6 8 83-4 7-92 4-503 6-7 9-10 4-5 8-32 4-5 9",
    ": 41-3 5 8-51 4-6 9-62 7-71 4-80 2 4 8 91-2 4-5 8 600 5 7-8 10-2 4 8 20-2 6",
    ": 8-30 2-3 5-8 40-1 3-5 52-4 9 63-7 70-1 3 6 9 82-3 5 7-93 8-9 701 3 6-7 9-11",
    ": 3-7 9-21 3-4 6 8 30-3 6 8-9 42 5-7 9 51 3-4 6-9 61-3 5 7 9-71 4 6-80 2-3 6",
    ": 8-92 4-7 9 801-7 10 2 4-7 20-5 8 30-1 3-4 6 8 40-3 5 7-8 51 3-4 7 61-3 6-7",
    ": 70-1 3-5 7-9 81-3 5-6 8-91 4-5 7-8 900-3 5 8-12 4-20 2 4 6 30 2-3 5 7-8 41-4",
    ": 7 9-50 2-60 2-4 7-70 2-3 6-7 9-82 4 7 91-3 5",
    ": 6001 3 5 7-10 2 4-6 8 24-6 9-30 4-8 43-8 55-7 9-62 4 6-7 9 71 3-9 81-3 5-7 90",
    ": 2 4-101 3 5-11 4-6 9-24 6-7 30-3 6 9 41-2 6-50 2-3 60-2 4 6 8-70 2-7 80 3-8",
    ": 90-1 3-5 7-9 202-6 8-9 14-6 8-20 2 4-8 31-4 6-9 41-5 7-8 50-7 9-61 3 5-7 70-3",
    ": 5 8-85 90-4 7-8 302 4-14 6-7 9 23 6-30 3-9 41-2 7 9-65 8-9 71-4 6 8-80 4-6",
    ": 8-95 8 401-3 5-6 12-3 7-9 21 3-4 6-7 9-34 6 9-42 4 7-51 3-61 5 7-74 6 8-9",
    ": 81-3 5-8 91-2 5 7 9-501 4-8 10-1 3-9 22 6-30 2-3 6 8 40-4 6-7 51-8 60-2 4-9",
    ": 72-5 8 80-8 91-8 600-1 3-12 7-8 21 4-7 9-31 4 6-51 3 5-64 7-75 8-84 7 92-8",
    ": 700 2-5 7-9 14-5 7-36 8-41 3-4 6-7 54-6 8-65 7 9-70 2-5 9 81-2 8-9 91 3-9 801",
    ": 5 7-11 5 7-8 20-6 9-30 2-5 8-44 7-9 55-9 63 6-75 7 80 3-7 9-90 3-4 7-900 4",
    ": 6-7 9-15 9-20 3-8 34-5 9-40 3 6-8 50-1 5 8 62 7 9-74 6-7 86-8 91 4-7",
    ": 9-7002 5 7-9 11-21 3-4 6-7 31 3-4 6-7 9 41-50 2 4-9 63-4 7 9-72 4-6 8 81 4-5",
    ": 7 9 92-101 3-4 6-8 10-2 4-24 6-8 30-1 3-9 41 3-7 51 5-6 8 60-1 3 5-8 70-3 5 8",
    ": 81-2 4 6-7 9-92 4 7-8 200-4 6 8-11 5-8 21-3 6-30 2-5 8-42 4 6 50-1 4-7 9-60",
    ": 2-76 9-82 5-7 9-91 4 6 8 300-4 6-10 3-5 8 20-1 3 6 30 2-3 5-6 42 4 6-51 6 8",
    ": 60 2-5 9-80 2-4 7-91 4 6-8 400-10 2-4 6-8 20-7 30-2 4 6 9 43 5 7-50 2-3 5-6",
    ": 9-64 8-9 71-2 5-82 5-96 8-500 3 8-12 5-6 9 21-2 4-5 9-30 2-4 6 8 40-3 7-50 2",
    ": 4-5 8-67 9 72-7 84 8-9 93 7-8 601-5 7-12 5-8 20 2-4 7-9 31-6 8 43 8-9 51 6-9",
    ": 66-8 72-4 7-9 82-5 7-93 5-7 9-701 5-12 6-21 3-5 7-31 3-5 9-40 3-9 52-4 8 62-4",
    ": 8 71 3-5 9 81 5-6 9 91 3 5 8-802 5-6 8-12 5-7 9-22 4-6 9-32 4 7-8 41-3 9 51-8",
    ": 61-7 9-70 2-8 81-2 4-5 8-9 91-2 6-7 904-5 8 11-7 9-20 4-30 9-43 5 8-55 7-64",
    ": 6-70 2-4 7-83 5-8 92-4 6-8",
    ": 8000 3 5 9-16 8 20 4-34 6 8-41 4-5 7 9-52 4 7 9-62 6-70 2-8 80 4-96 8 100-1 4",
    ": 6-11 3-6 8-31 3-4 6 8-42 4-5 7-58 63-5 71-4 6 8-9 81 3-90 2-4 8 202-3 9 11-4",
    ": 7-20 2-4 6-9 32-7 40-6 50 2-3 8-64 7-73 5 7-9 81-3 6-7 9 92 4-6 8-301 4-5 8",
    ": 10-3 5-9 22 5 9-32 4 6-40 2 4-6 9 52-4 6-9 61-5 7-8 72-4 6 9 82-3 5 7 90 2 4",
    ": 6-7 401-4 7 9 11-2 7-8 21-4 6 8 30-3 5 8-9 42-9 53-4 9 62-73 5-8 80-9 91-5",
    ": 8-503 5-8 12-6 9-26 30-1 3-4 6-9 41-2 4 6-52 4-6 8-64 6 70-2 5-9 81 3-6 8-9",
    ": 91-4 6 8 601-2 4-7 13-9 21-3 5-7 9-32 4-5 7-42 4-5 7-8 50-5 7-63 5-6 8-71 3-6",
    ": 8-82 4 6-8 90 2-9 702-5 9 12 5 7-20 3 5 8 30-1 6 41 3-51 3-5 8 60 3 5-8 70-1",
    ": 9-81 5-98 800-1 3-4 6-7 9-11 4-6 8-9 22-7 9-31 4-6 9-41 3 5-7 9-55 7-8 64-6",
    ": 9-72 7-8 80-6 90-2 4-9 902 4-8 12 4-23 6-7 34-41 3-4 6-52 7-61 3-4 6-9 73-8",
    ": 81-3 7 9-94",
    ": 7-9001 3 5 7-8 10-2 4-6 8 21-5 7-32 4-6 9 43-5 7-54 9-63 72-85 7-91 4-102 8-9",
    ": 11 6 20 2-6 8-32 5-7 9 42-3 6 50-1 6-7 9-60 2 5-72 6-8 80-6 8-9 91 3 5-205",
    ": 7-17 9-21 3-4 9-39 41 3 5-6 51-5 9-61 3-6 8-9 73-5 8-9 81 5-8 91-2 5-7 300-1",
    ": 3-5 7-13 5-21 3-30 5-6 40-4 6-7 9-53 5-6 9-63 5-70 5 7-8 80 3-4 6 90-1 3-7",
    ": 9-401 3 5-8 10-2 4-7 21-4 6 8-34 6 9 41-4 8-65 8-9 71-3 5-81 4-6 8-98 500 2-8",
    ": 10 3-5 7-8 20-6 9 31-4 6-42 4-8 50-7 9-65 8-71 3-5 8 80-3 6-8 90 4-601 3-4",
    ": 6-7 12-3 5 7-21 3-4 6-7 31-6 8-40 5-9 51 4 7 9 61 3-5 7-70 2 5-6 8-81 3-6 8-9",
    ": 92-5 7-703 6 8-10 3 6 21 3-30 2 4-6 8 42 5-51 3 5-6 8-61 5-7 9-72 4-7 80 2-4",
    ": 6-91 3 5-8 800-2 6-14 6-22 4 6 8-9 32-4 6 8 40-1 3 5 7-51 5-6 8-9 62 4-73 5 7",
    ": 9 84-6 91-3 5-7 9-900 3-6 8-9 11 3 5-7 22 4-6 8 31 3-5 7-42 4-52 4-9 61-7",
    ": 9-73 5 80 2 6-90 3-5",
    ": 30001 4 6-11 4-23 5-8 30-3 5 9 42-3 5-6 8-9 52-4 6-7 60-1 3-6 8-74 7-80 2 4-5",
    ": 7-96 9 102-3 5-6 9-11 3-5 9-20 2-40 4-5 52 4 6 8 60 2-4 6 70 6 9-81 5-9 94-5",
    ": 200-3 6-26 8-9 31-4 9-40 4-53 5-60 3-7 70 2 4-7 80 2 4-5 9-95 8-306 8 10-1",
    ": 3-4 8-9 21-5 30-1 4 6 8 40 2 6 8 52-4 6-61 4 6-9 71 7 9-82 4-5 8 90-6 8-401 5",
    ": 7-10 2-3 5-9 22-4 6 9 31-5 7-43 6-7 9-53 5 7-9 61-2 4 7-70 2 4 6 80-2 5-7",
    ": 9-91 3-4 6-8 501-2 4-9 11-4 20-2 4-5 7-8 30-1 3-5 7 9-41 3-6 9-64 8 70 2-8 80",
    ": 4-7 91-3 5-9 601-2 4-7 9-13 5-7 9 22 6-8 30 2-5 8 40-4 6-9 55-8 61-8 70-2 7-8",
    ": 80 2-5 9-94 6-7 700-1 3 8 10-1 3 5-7 20-3 5 8-30 2-7 42-6 9 52-9 61-2 4-5 7",
    ": 70-1 4 6-8 80-6 8-91 3-5 7 9-802 5-8 14-5 8 21-7 9-30 2-6 9-44 6-51 4 7 60-2",
    ": 4 6-9 71-9 83-5 7-9 92-3 9-900 2-3 6-7 10 4-20 3 5-6 9-31 4 8-9 41-3 5-6 8-54",
    ": 6 9 62-3 8-9 71-5 7-88 90-3 5-7 9",
    ": 1001 3 5-10 2-3 6-20 2-3 5-30 2 4 6-48 51-3 5-6 8-60 2-5 7 9-71 5-6 8-9 82-3",
    ": 5 7 9-90 2 4-6 8 100 4-18 21-3 5 8-32 6-7 9 41 3-7 50-2 4-6 60-2 6-73 5-83",
    ": 5-6 90 5-201 4 6-7 11 3-4 7-9 21-2 7-31 5 7-8 42-6 8-51 3-4 8 60 3-5 8-9 71 4",
    ": 7-9 81 5-90 2 5-7 9-300 2-3 5 7 10-3 5 8-9 21-3 5 7-30 4-6 8-40 4-50 2 4 7 61",
    ": 3-6 8-80 2 4-7 9-91 3 5 7-400 4 6 12-3 7-21 5 7-32 4-5 8 40-3 6-8 52-6 61",
    ": 5-71 6-81 3 8 90-508 10 4 7-21 3-4 8-30 3 5-44 6-52 4-5 8 60-3 5-6 8-73 5 7-8",
    ": 83-4 6-92 4-5 7 9-600 2-7 9-11 3-9 21-5 9-31 6 9 41 3-8 51 3-65 70-1 3-6 8-82",
    ": 5-7 91-7 9-702 5 7-8 10-1 3-28 33 7 9 42-4 7-9 52 4-7 9 61-73 6-7 80-1 5-6",
    ": 8-90 2 6-7 9-802 4-7 9 13-4 6 8-21 3-5 7 30 2 4-8 41 5 7-8 54 6 8-67 9-71",
    ": 3-82 4-8 90 2 6 8-9 901-7 9-10 2-5 9 21-4 6 8 31 4-5 8-9 43-4 6 8-9 51-4 6 9",
    ": 62-5 7 9-70 2 4-8 82 5 8-91 4 9",
    ": 2002-3 6-9 11-6 8-20 2-4 6-8 30-40 2-3 6-7 9-50 3-62 4-5 7-78 80-2 7-9 92-9",
    ": 101-2 4-7 9-12 4-7 9 21-6 30-3 8-44 6 9 52 4-9 61-7 70-1 4 6-7 9-82 5-7 90-3",
    ": 5-7 200 3-6 9-10 2-6 8-20 2-8 31 3 5-8 40-3 7 9-50 2 4-61 4-5 7 9-74 7-8 80-3",
    ": 5-7 91 7-8 300-4 10-4 6 8-23 8-9 31 3 7-40 8 52-3 7 9-62 4 6 8-71 3 5-6 8-87",
    ": 90-2 4-408 10 2-3 8-20 3-8 30-2 4-5 8-41 3-5 7-52 5-60 5-6 8 73-4 80-1 5-6 9",
    ": 91-6 9 501-9 14 7-21 3-5 7 31-2 4-6 9-42 4-8 50-1 3-8 62 4-6 8-71 4 8 80 2-4",
    ": 6-8 90 3 5-7 9-600 2-3 7 10-5 7 20-2 5-8 30 2 4-9 41 4-5 7 55-60 2 4-8 70 2-3",
    ": 5-7 81-2 5-7 90 2-3 9-704 6-8 11-24 7-8 30 2-3 5-51 4 6-7 9-67 9-75 7-8 80",
    ": 2-4 6-8 91 3-5 7-800 3 6 8-10 4-5 7-9 22-5 7-8 30-6 8 41-3 5-6 9-50 2-4 6-61",
    ": 5 7-72 4-7 81-4 6-9 92-4 6 8-9 903 5 7-9 11-6 8 20-1 3-4 6-7 30 2-3 5 8 40",
    ": 3-4 6-51 3-5 7-9 62-3 6-7 9-73 5-7 9-81 3-9 91 4-9",
    ": 3005-13 5-23 5-33 7-8 41-4 6 8 50-9 65 7 9-70 2-4 7 9-81 3-9 92-5 7 100-3 5-7",
    ": 9-10 2-3 6 8-9 21-3 5 8 32-4 6 40-2 4-5 7-50 2-5 7 9 62-5 8-9 72-4 8 80 2 4-6",
    ": 9-91 6 8 200-2 4-5 8-10 2-5 7-9 22-6 9 33-5 7-41 3 5-9 51 5-6 8-61 3 5-6 9-73",
    ": 7-8 80 4-94 6-9 301 3-4 8-11 4-6 8-9 23 6-31 3 9 45 50-6 9-63 5-7 70-2 4-5",
    ": 7-84 8-9 91 3 5 7 9 401 3-5 7-11 5 7 9-20 2-3 5-6 9-35 7 41 3-52 5 8-65 8",
    ": 70-4 6-9 81-4 6 8 91-5 8-506 8-13 5-21 4-5 7-9 31-4 6-41 4-51 3-5 9-66 73 6",
    ": 9-83 5-7 9-91 3 6-600 3 7-13 6-8 20 3-4 6 8-32 6-50 2-3 5-6 8 60 4-5 7 75-8",
    ": 80-9 91 3 5 7-8 701-3 5-7 11-5 7-8 20 4 6 30-1 3-40 4-6 8 51-7 62-8 73 5 7-9",
    ": 81-7 9-93 5-9 802-9 12 4-6 8 20-34 6-8 40 2-7 50 2-4 6 9-60 2-4 7-9 71 3 5-80",
    ": 2 7 93 5-901 7-15 21-2 6-8 31-2 6-8 41-3 5-8 58 60-7 9-70 2-3 5-80 4-7 9-92",
    ": 4-5",
    ": 8-4001 3 5-6 9-35 40-2 4 6-8 50 3-5 9-62 4-6 8 72-80 5-6 8-94 8-9 102 4-5 7-8",
    ": 11-9 22-4 6-8 30-1 3 7-45 50-1 3-4 6 61-2 6-70 4-6 80-1 3 6-7 9-91 3 6-8",
    ": 205-6 9-10 2-5 7 9 23 5 7 9 31 3-7 40-1 3-4 6-50 2-6 8 60-1 4-82 4 7 90 2 5",
    ": 7-309 12-5 7-26 8-30 2-7 9-48 50-2 5-6 8-9 62 5-73 5-7 82-3 7 92-4 7-9 403-5",
    ": 7-8 10 2 5-7 20 2 9-30 2 4-6 8 40-1 3 6-8 51-61 3-7 9-70 2-3 6-9 85-8 92-4",
    ": 9-501 5-7 9 11-3 5-20 2-3 7 35-7 9-44 7 9-50 2-3 5-8 60 3-7 9-72 4 6 9-80 3-7",
    ": 90-602 4-6 8-10 2-3 6-9 22-4 6-7 9 35-6 9-41 3 5 7-8 50-8 61-3 7-9 72-3 6-84",
    ": 9-93 5-700 2-8 10-2 4-20 4 6-32 4 6-7 9-41 3-4 6-58 60 2-4 6 8 70-8 81 4-5 8",
    ": 90-4 7-8 800-2 5-6 8-12 4-7 9 21 4 7-31 40-1 3 6-50 3-62 6 9-82 4-8 90-1 4-7",
    ": 901-3 6-13 5 7-28 30-3 5-7 40 2-3 6 8 50 2 5 9 62-5 7-75 8 81-6 8-90 2-4 6-7",
    ": 5000-2 4-5 7-9 11 3 5-7 9 21-2 4 7-32 4 6-9 41 3-4 6-8 50 2-3 5-64 6-7 71-2",
    ": 4-5 7-80 5-6 8-95 7 100 3 5-9 12-3 5 7-22 6 8 35-9 41-50 3-6 8-61 3-4 8-9",
    ": 71-4 6-8 80-3 5-90 4 8-9 204-6 8-11 4-6 8 20 2 4 7-32 5 8-42 4 6 8 50-4 6 9",
    ": 61-2 5-6 8-70 2-83 5-6 8-90 2 5 7-301 3-5 7 9 11 4-5 8-25 8 30-1 3 5-7 9-40",
    ": 2-6 8-53 9 63 5 7-8 71-2 4 6 8 80-7 9 91-7 9-400 2 4-12 4 7-20 2-7 9-33 5-9",
    ": 43-4 6 9 54 6-7 9-65 7-71 3-4 6 81 6-94 8 500-1 3 6-8 10-8 20-5 7-9 31-4 6-7",
    ": 9 42-5 50-3 5-9 61 4-8 70 2 7-81 4-6 8-90 3-4 6-602 5-6 8-16 9 21-5 7 9 32-8",
    ": 40-2 6 8-50 3-5 7-9 61-2 4 6-8 70-2 4-84 7 9-90 3-9 702 4-5 10-9 21-7 9 33-43",
    ": 6-51 3-5 7-8 62-3 5-6 8-9 72-3 5-6 80-3 6-90 4 6-7 9-800 2-7 9-11 4-7 9-21",
    ": 4-5 8-41 3 6-9 51 4-5 7 9 61 3 9 71-2 4 6-84 6-90 2 5-6 8-901 4-6 9-12 5-7",
    ": 9-22 5-6 8-9 32-4 6-7 9-42 4-5 7-50 2 4 7-62 5 7-8 70-3 6 8-9 83-5 7-92 5-6 8",
    ": 6001-3 5-6 9-10 2 4-23 5 7 30-6 9-43 7 9-50 2 7-62 4-5 70 2-6 8-9 82-4 6-7 9",
    ": 91-2 4-7 9 101 3-5 9 16-9 21-4 6-8 30-1 3-7 42-6 50-1 3-4 6-60 2 4-8 72-5 7",
    ": 80-2 4 6-7 9 92 4-5 7 9-202 5-8 13-4 8 22-8 34 6-8 40-1 4-5 8-9 51-9 64-6",
    ": 8-71 3 9 81-5 8-97 9 301-2 5-6 14 6-26 8-39 41-2 4-8 52 4-7 60-6 8-71 4-5",
    ": 7-86 8 91 3-5 401-6 8-11 4-6 20 2-3 5 9 32-4 6 8 40 2 4-5 7-8 51-4 8-60 2-4",
    ": 70-4 7-84 6-90 3-6 9-500 4-32 4-5 8-43 6-8 52-5 9-64 7-70 2-4 6-7 80 2-98",
    ": 601-5 7 9-10 3-6 9-20 3-31 5-46 51 3-67 70-7 82-4 6-704 9 11-2 6 26-9 32-6 9",
    ": 42-3 7-52 4-6 8-65 8-9 71-3 6 8-82 5-6 8 90-4 6 8-800 3 6-7 9-10 3 9 24-5",
    ": 7-36 8 40 3 5 50-61 5-6 72 4 84-5 7-94 6 8 900-6 12-4 8-20 2 5-31 3-4 6 8-9",
    ": 43 5 8-67 9 71-6 8-9 82-3 5 7-8 92 4-8",
    ": 7000 5-6 8-16 8 20 3-35 8-9 42-9 51 3-4 6 8-9 61-2 4-5 70 2 4-5 8-88 94-5",
    ": 8-102 4-5 7-13 5-9 22-4 6 8-36 41-6 8-9 51 4-6 9-62 5 7-9 73 5-6 80-3 6-90",
    ": 2-5 7-200 11-2 5-20 2-33 5 7-8 41-2 4 6-51 3-6 8-9 63 5 7-8 70-1 3-4 8-9 90-2",
    ": 5 7-300 3-4 7-12 4 6-7 24-5 9-30 2-4 6-8 42-54 6-62 4-6 8-9 71 3-4 80 5-6 8-9",
    ": 91-3 7-406 8-13 6-20 3-31 6 40 2-7 50-5 7-60 4-9 71-6 82 4-8 91 3-4 7-9 501",
    ": 3-5 8 10 2-4 6 22-8 30-3 5-7 44 50-61 3-4 6-71 3 6-84 8-9 93-4 7-608 12-5 7-8",
    ": 21 3 5 8-48 51-6 8 60 2 4-70 4-7 9-92 4-6 8-707 9-10 2-20 2-5 7-8 30-1 5-7 9",
    ": 41-4 6 8 51-4 6-62 4-7 9-71 3 5-9 81 3-4 6 90-3 5-7 9-802 4-9 11 3 5-6 8-9",
    ": 21-7 9-35 7-8 41-3 5-51 4-7 9-61 4 6-8 71-81 3-6 8-91 3 6-7 9-900 2-3 6-14",
    ": 6-7 21-4 6-7 9-30 4-6 8-9 41-4 8-9 52 4-68 70-4 6 8-81 3-5 7-8 92-5 7-8",
    ": 8000-2 4-8 10 2-6 8 21-5 7-9 31 4-5 8-40 4-70 2-5 7-8 80 2-6 8-90 2 4-6 8-9",
    ": 101 6 8-12 5 7 9 21 4-5 7-32 5-9 41-6 8-52 6 60-72 4-9 81 6 9-90 2-3 8 200-1",
    ": 5-11 3 6-21 3 6 8 31 4-5 7-45 8-50 2-3 5 9-62 6-7 9-71 3-5 7-8 84 6 8-97 302",
    ": 4 6-10 2 4-7 9-24 6-8 30 2-3 5-42 4-9 53-5 7-70 2-5 80-4 7-90 2-3 9-402 4-8",
    ": 12 5-8 21 3-5 8 30-6 9-41 3-8 52-4 6-7 61 3-6 8-71 4-80 2 4-91 3 5 8 500-7",
    ": 9-10 3 5 20-1 3-4 7-8 30-3 7-44 7-8 50-6 9-62 4-6 8 70-2 5 7-81 4-8 90 4-5",
    ": 7-8 601-4 6-7 9 13-6 8-20 2-6 8-9 31 3-4 6-48 51 6-64 9-74 7-9 81 3-5 7-91 4",
    ": 6-8 700-2 4 6-9 12 5-28 31-4 6-41 4 6-8 51-2 4 7 60-1 3-5 7-71 4-80 2-3 5 7",
    ": 9-90 2-802 4-5 7 12-20 3-6 9 33 5-6 8-41 3-5 8-52 4-5 60-2 4-70 3 5-6 8-81",
    ": 4-8 93-8 900-3 5-10 2 4-21 3-33 6-8 40 3 6-50 3 8-60 2 5-7 9-74 7 81 3-6 8-9",
    ": 91-2 4 8",
    ": 9000-10 7-8 20-2 4-8 30-1 3-5 7 9 41-2 5 8-50 4 8-9 61 3 6-9 72-4 7 9 82-5",
    ": 7-90 3-4 7-9 101-2 5 7-12 4-6 20-1 3 5-9 32 4-40 3-6 8-50 2-5 7 9-66 8-9 72-4",
    ": 8-9 81 3 5-7 91 3-5 7 9-201 5 9-14 6 21-2 6 8 30 4-6 9 41-5 7 9-51 5-8 60-1",
    ": 3-5 70-4 7-8 80 3 5-93 5-9 302-3 5 7 11-7 9-24 6-9 34 6-9 41 3 5-7 9-51 3-5",
    ": 61 5-8 70-3 5-6 81-2 4-5 8-94 6-404 6-11 5-8 21-8 30-2 4-6 8-42 5-8 51-2 4",
    ": 7-8 60-3 5-8 72-5 9-81 5 8 91-2 4 7-9 501 8-15 9-21 3-6 9-30 2 4-7 41 4-5 7-8",
    ": 50-2 5 7 60-3 5-7 9-71 3 5-6 9-84 6-7 9 91-3 6-600 2-5 7 9 14 6 20-7 9-30 2",
    ": 4-5 9-46 8-51 4 6-61 4-70 2-5 7 9-80 2-5 7 9-90 3 5-8 700-4 7-9 11 3-4 20-2",
    ": 4-9 34 6-44 7 9-53 5 8 60-1 4-8 72-6 8-9 81 6 8 90-1 3 5-6 8 800-12 4-28 30-4",
    ": 6 8 41 3 5-8 51-3 5-7 61-72 4-8 80-1 5-9 92-4 9 901-2 4 6-9 11-25 7 30 4 8-43",
    ": 7-8 50 2-5 8-65 7-72 5-85 9 94 6",
    ": 8-40001 3 6-7 9-10 8-23 8-31 4-44 6 9 51 3 5 7 61-5 8 71 6-7 9-80 3-4 6 8-9",
    ": 91 3 8 102 4-8 10-3 5-6 8 21-3 5-6 8-31 3-6 9-41 3 6 9-50 2-5 8 60 3-4 6-7",
    ": 70-1 3-4 6-82 4-9 91 3-7 200-7 9 11-2 5-7 20 2-4 31-2 4-5 9-42 4-8 50-3 6-60",
    ": 2-3 5 9-70 4-5 8 82-3 8-91 4 7 300 2-3 6-10 2-3 8 20-4 6-7 9-35 7-8 40-2 4-5",
    ": 7-50 2 4-9 62-6 9 71-2 5 9 83-9 92 4 6 9-405 10-1 3 6-7 20-2 7-34 7-40 2 4 9",
    ": 51-7 61 3-6 8-70 2 8-86 8 92-5 7-8 504-7 10 3-4 6-7 9-20 6 8-37 40 2-3 5-50 7",
    ": 9-64 6-8 70-5 8 81 4-5 8-90 3-9 601 3-6 8 10 2 4-9 21 3-7 32-5 9 43-4 50-1 4",
    ": 7-9 61 4-6 8 73-6 8-85 7-9 91-2 8-700 2-4 8 10-3 5 8 22 4-8 30-2 5-9 42-4 9",
    ": 51-9 61 5-6 8-71 4-81 6-8 90-1 4-9 803-6 8-9 11 5 8-43 5-6 51-2 5-6 60 4-5",
    ": 7-8 70-9 81 5-6 8 92-7 900-3 5-9 12 4-9 21-2 5-8 30-2 6 8 40-1 4 6-7 51-3",
    ": 5-60 4-8 70-2 4-5 7-8 80-1 3-4 8 91",
    ": 4-1000 2-3 5 8-12 5-8 20-3 5 7-8 30-1 4-42 4-6 50 2-4 7 61 3-4 7-8 70 5-6",
    ": 8-80 2-3 5 7-8 90 2-3 5-6 8-101 3-4 6-9 11 3-22 4-6 8-37 41 4-5 9-51 3-4 6-7",
    ": 61 3 6-9 73 5-9 81 3 5-7 9-91 3 7-8 202 8-9 11-2 4-5 8-9 22-4 7 9-37 41-3 6-7",
    ": 50-4 7 61-2 4 7-8 70 3 6-7 9-81 3 5-6 8 91-6 8-301 7-12 7-8 20 2-3 7-31 3-4",
    ": 6-7 41-7 50-6 8 60-1 5-6 9-75 7 9-84 7-8 90 2-402 4 6-10 2-3 6 8-9 21 3-9",
    ": 32-7 9-45 7-9 51-6 8-60 3-4 6-7 70 2 4 7 80-4 6 9 93-4 6 8 501-3 5-6 8-9 11-6",
    ": 9 21-3 6-9 32 6-41 7-9 52 4-5 7-66 8 70 2-3 6-8 80-6 8 91-4 6-7 600 3-8 11-3",
    ": 5 7-8 20-7 9 31 3-9 41-4 6 9-50 5-9 61-4 6-73 6-7 9 84 6-8 90 3-5 7 9-701 3-7",
    ": 9 11-7 9-23 5 7 9-32 5-8 40-1 3 8-50 2-4 6-9 64 7 9-76 8 81-2 5 7 9-90 2 4-5",
    ": 8-803 6-22 4-7 9-31 3 6-9 41-5 7 52 5-6 9-61 3-8 70-3 6 8 81 5-6 9-93 5-6",
    ": 8-900 2-8 10-1 4 7-8 22-3 5 8-30 5 7-48 51-2 5-7 9 61-2 5-9 72-5 8-81 4-5 7",
    ": 90 2 4 7",
    ": 2000 2-4 6 8 10 5 7-21 3 5 30-1 4-5 8 41-2 4-5 7-9 52-4 6-7 9-65 7-9 71-5 7-8",
    ": 80 2-7 90 2-6 100 3-5 8-9 14-6 8 22-9 32 4-8 41-2 5 7-52 5 9-63 5-6 8-9 71-2",
    ": 4-8 82-3 5 9-93 6-8 200-8 10-1 4-5 7-9 21-3 5-6 8-36 8-9 41 3-5 50-2 6 8-9",
    ": 63-6 8-72 5 7 9 81 3-4 7-9 93 9-300 4 8-9 11-3 5 7-28 30-2 4 8-40 3-5 7 9-50",
    ": 3-61 3-7 70 2-3 5 7-8 80-6 8-93 5-6 8 401 3 6-9 11-2 6-20 2-6 8 31 3 5-8 41-7",
    ": 51-5 7 9-74 6-9 86-8 90-1 4-7 9 501 6-10 3 7 9-20 2-5 8-30 3 5-40 2-3 5-9 51",
    ": 3 5-6 8-72 5 80-1 3 6-90 2 4 6 9-602 6 8-15 8 21-2 4 6-9 32-3 5 7-9 41-3 5",
    ": 7-9 53-5 7-8 60 2-6 9 71 4 6 9 81-5 8 90-2 6-8 700-5 9-15 7-28 30 2-3 5-6",
    ": 9-46 9-52 6-65 7-9 71-4 7-8 80-7 90-7 9-808 10-2 7-20 2-9 34-5 7 9-40 3 5-9",
    ": 53-4 7 9 61-2 4 7-8 71-4 6 8-80 2 5-8 90-1 3-5 7-8 900-3 5-7 12 5 7 9 21-5 7",
    ": 32-3 5-8 40-1 5-7 50-6 8-9 64 6 9-79 81-2 5 9-90",
    ": 3-3000 3-6 8-10 3-8 20-2 4-5 7 30 2 4-6 40-7 9-51 4-5 61-4 8-71 3-4 6-81 5",
    ": 7-9 91 9-103 5-6 8-9 11-4 7-9 22-3 6-35 9 42-3 5 7-51 3-4 6 8-64 7-9 71 3-5",
    ": 8-82 4-6 8 90-8 201 4 6 8 10 2-4 8-20 2-5 7 9 34-7 9-42 5-6 8-9 51-4 6 9-61",
    ": 3-6 71-3 8-80 4 7 91-5 7-305 9-12 4-5 8-20 2 4 7-8 31-2 4-8 40-6 8-54 6 8 60",
    ": 2-4 7-8 70-2 4 6-8 80-1 4-90 2-3 5-9 401-2 4-5 7 10-1 5-7 21-3 5-7 30-4 6-9",
    ": 41 4-6 8-50 2-3 5-9 62 5 9-74 6 8 81-5 9-91 3-5 7-503 5-6 9 11-2 8-20 3 5-8",
    ": 30 2-8 40-1 3 6-7 9-51 3-5 8 60 2-8 76 8-85 7-9 94-7 601-5 7-19 23-4 7-34",
    ": 6-40 4 6-7 9-50 3-6 8 62-3 5-8 70 2-4 7-82 5 7-9 92 4-6 8 700-7 9-10 2 6 8-22",
    ": 8-9 32-3 5 7-40 2-3 5 8-55 8 60-3 5 8 70 2 6-8 81 3-6 8 90-1 4-7 800-6 8-10",
    ": 2-4 7 20-2 4-7 9-31 3-5 8 41-5 7 50-6 9-62 6 70 3 5-6 8-88 92-3 6-904 8-12 6",
    ": 9-23 8-9 31-3 5-6 8-40 2-3 5 7-52 6-8 60-1 3-8 70-1 4 7-8 80-92 4-6",
    ": 8-4002 5-6 8-11 7-9 23 5 7-32 4-6 8-43 5-7 51 8-9 64-5 70-2 5 7 80-4 6-8 90",
    ": 2-5 9 101 4-7 9 11 3 5-6 8 23-5 7-8 30-3 5 8-40 4-6 8-54 9-60 2 4-5 8-71 4",
    ": 6-9 82-4 6-99 201-2 6-10 4 6-23 6-35 8-44 6-7 9-54 7 60 3-6 8 70-2 4 6 9-84 6",
    ": 90-1 3-9 303-4 6-7 9-13 5-7 22-35 7-40 3-8 51-7 9-62 70 2-6 9 81-2 4 7 9-90 2",
    ": 4-403 5 8-11 3 5-8 20-1 3-4 7-9 31 4-8 41-2 6-7 9-55 8 60-2 4-5 7 9-70 4-7",
    ": 80-6 8 90 2 4 8 501-7 12 6 9-20 2-9 31-3 5 7-40 3 5-7 9 52-60 2 5 7-8 71-4",
    ": 6-7 9-81 3 6 8-90 2-602 4-6 10 2-5 7-8 20-4 6 8-30 3-45 7-8 51-5 60-9 71-7",
    ": 9-83 5-702 4 6-8 10 2-3 5 7 9 23 5 7-8 30-1 4-40 2 4-5 7-9 51-3 5-7 9 62-3",
    ": 5-70 3 6-7 80-5 7 9 91-3 5 7-8 800 2-5 8 11 4 7 9-21 4-5 8-9 33 8 40-4 6-7",
    ": 9-51 3-7 60-5 8 71-3 8-83 9 94-909 11-8 20-2 5 36 40-2 4-9 52-4 7-9 61 5-6 70",
    ": 3-5 7-8 80-1 3-4 8-9 91 3-4 6",
    ": 9-5002 4-6 9 12-6 20-1 3-36 40 2-3 5-7 50-7 9-60 2-9 71 6-80 2-4 90 2-3 6-7",
    ": 9-101 3-5 9-10 2 4-6 8 21-3 7-8 30-2 5-42 4-7 50 2-4 7 9 61 4-5 7 70 2 4 7-8",
    ": 80-1 3 9 92 4-7 9-203 5 7 11-6 9 21-9 32-5 8-41 4 50 2 4 6 9-60 2 4-8 71-4",
    ": 6-81 4 6-8 90-7 9-300 2 4-9 11-3 5-7 9-25 8-34 7-9 45-9 52-6 8-64 6-70 2-5 7",
    ": 9-83 7-90 2-5 7-403 5 7 9-11 3-5 7-22 8-30 3-4 8-40 3 5-7 9-56 8-60 3 6-8 70",
    ": 2 4-5 7-80 2-4 6 8 91 3-501 3 6-7 9-11 4-8 22-5 7-8 30 2-5 7 9-42 5-51 4-6 8",
    ": 61 3 5-7 9 72 4-86 8 91-2 4 6-7 9-603 5 7 10-2 5-7 20 2-3 6-7 9 32-3 7-9 41",
    ": 4-52 4-73 6 8-81 3-4 6-99 702-4 6 8-11 4-7 9-25 8-32 4-7 40 3 6-60 2-5 8-9 71",
    ": 3-5 7-8 85-9 91-3 5-6 8-9 802-5 8-9 13-4 7-21 5-9 33-4 7-42 4 6-7 9-50 2-3 5",
    ": 7 9 62-4 6-71 4 6-84 6-8 90 3-5 7 9-900 2-11 3-4 7 9-25 8 30-1 6 40 8 50-2",
    ": 4-5 7 9 61-6 8-72 4-7 80-4 7 91 3-5",
    ": 6000-5 8 10-1 5-9 22-4 6-8 30 3-4 6-8 40-7 54 6-8 61-5 7-8 70-1 4 8 80-4 8-91",
    ": 6 8-100 2 4-5 9 11 5-20 2-4 7-8 30-40 2-4 7-8 50 2-8 60 2 5-6 8-71 4-5 7 9",
    ": 81-3 5 9-95 200 2-3 5-7 9-10 2-6 23-6 8-36 8-42 4 6-7 9 52 4-5 7 60 3-4 7-75",
    ": 7-8 80 2-8 90 2-4 6-9 302-4 6 9-10 3 5-20 4 6-30 2 4-6 8 42-6 8-50 4-62 4-5",
    ": 7-76 8-80 2-5 7-9 91-2 6-7 9 401-3 6-10 3-5 8-9 21-3 5-30 2-3 5-8 40-5 7 9-50",
    ": 2-9 62-5 7-70 2-80 2-7 9-93 5-7 9 502 5-6 8-9 11 3-6 8-9 23-9 31-7 42-3 5-52",
    ": 4-5 7-9 61-3 5-6 8-71 3-83 6-8 90-2 4-5 7-602 4-5 7-9 11 3-7 21-9 31-2 4-43 5",
    ": 7-8 50 2-7 9 63-5 7 70-3 5-7 80 2-3 91-4 6-8 701-2 6 11-5 8 20-3 6 8 30-1 3-7",
    ": 9-40 2-4 8-50 2-5 60-1 3-4 6-9 73 5-6 8-80 2-3 7-800 3-6 10 2-7 20-3 6-8 30-1",
    ": 3-5 7 40-1 3 5 7 9 51-7 9 61 3-73 5 7 9-86 8-91 3-4 9-901 3-7 9-13 5 8-20 2-4",
    ": 6-7 9 33 6-44 50-4 8-9 61 3-5 7 70-2 4-5 7-9 81-5 7-8 90-5 8",
    ": 7001-2 6-9 11-5 7-8 20-6 8-30 2-7 40 2-3 6-7 9-71 4-5 80-1 4-6 8 90 3-7 100-5",
    ": 7 10-1 3 7-8 21-7 30 3-8 41-2 4-7 51 4-8 60 3-9 72-4 6 8-9 81-90 3-203 5-8",
    ": 11-6 8 25 7-9 31-6 8-9 41 4-6 8-9 51 4-6 8 60-73 6-8 80-2 4-6 90 2-5 8-303",
    ": 5-7 9-17 9-21 3-7 9-30 2-3 5 8 41-4 7 9-50 3 5-8 60 2-6 9-71 3-4 6-7 80 3-4 7",
    ": 90-1 4-7 9-403 5 8 10-2 4-21 4-6 9-33 6-8 41 3-50 3-5 7-60 2 4-8 70-82 4-6",
    ": 8-92 4-503 5 7-10 3 5-6 20-1 3-6 9-36 8-42 4-7 9-50 2-3 5-62 4-7 9 71-5 7",
    ": 9-81 8 92 5-6 8 600-2 6-12 5-6 8 20 3-4 6-8 30-1 3-9 42-4 6-7 9-51 3-5 7 9-64",
    ": 7 9 72-4 7-80 2 5 9 91-2 4 6-7 700 2 5-8 12-3 7-8 25-6 8-39 41-2 5-8 50-1 3",
    ": 5-7 9-62 4-9 71-7 9-80 4 6-7 90-2 5 8 800-1 5-6 9-11 4-7 20-1 3 5-30 2-4 6-7",
    ": 9 42-4 7-9 51-5 7-9 61-3 6-8 70 3-6 80 4-5 7-8 91-7 9-903 6-7 10-1 3-22 4-31",
    ": 4-5 7-43 5-9 51-6 8 61-4 70-6 9 82 4-7 9 92-4 7-9",
    ": 8001-2 7-12 4-5 9-21 5 7-31 3-6 41-9 52-4 6-62 5-71 3-7 86-99 102 5-7 9-11",
    ": 5-6 8 20-3 30 2-3 6-40 3-51 4-6 9-60 5-7 9-71 3-81 3-4 9 91-200 2-4 9-12 8 20",
    ": 2-4 6-31 3-4 6-8 44 6-8 50-62 4-5 8-71 3-6 8-83 5-6 8 91-4 6-300 3-7 10 2-3",
    ": 5-8 21-3 5 7-8 30 3-4 7-41 3-4 6-51 3 5-6 9-60 3 5 8-73 5-6 8-9 81 5-99 403",
    ": 7-8 11-2 5-6 8-9 23 6-30 3-40 4-5 8-55 7-62 4-5 8-70 2-6 8-9 82 4 7-94 6",
    ": 502-5 7-13 5-7 9-28 30-4 6-9 44 53-8 60 2-4 6 8-73 5 7 80 2-4 6-9 92-3 5",
    ": 8-603 5-7 9-10 2 5 7-9 24-30 2-6 9 41-4 7 50-6 8-61 5-6 72-4 7-80 2-7 9-90 2",
    ": 4-700 2-3 5 10-6 8-9 24-7 30 2-3 7-40 2-3 5-8 51 4 6-9 61-3 8-70 3 6 8-81",
    ": 4-92 5-6 8 800 3-4 6-13 5 8-20 2-5 7 9-31 3 5-6 8-9 42-5 7-8 50-2 4-5 7 9 61",
    ": 3 5-6 8-9 71-2 7 80 2-4 6-96 8-9 903-5 8-9 11-6 21-5 9-31 3-40 3-5 7-8 51 4-6",
    ": 9-67 70-5 7-8 80-2 5-7 9-95",
    ": 9-9000 5-13 8 20-1 3-5 30 2-6 8 40 2 5 7-8 51-6 8-61 3-9 73-9 81-3 6-92 4-5 9",
    ": 102 4-7 9-11 3-20 3-5 33-8 42-5 7-55 8-9 61-6 8-9 71-5 7-9 81 3 6-8 90-2 4-5",
    ": 7 9 202 4-6 9 11-3 5 7-9 21-3 7 9-32 4 8-44 6-9 51-2 4 7-63 5-73 5-80 2-3",
    ": 6-91 3-6 9 302-6 8 10 3 6-7 22 4-6 8-31 5-6 8 40-5 8 50 2 4 6-8 64-7 9-75 9",
    ": 81-7 92 4 6 8-401 4-6 8 15-7 20 3-4 8 30-1 3 5 7-41 3-4 6-51 3-7 9-64 6-8 71",
    ": 3-5 8 80-4 7-9 92-3 5-6 8 500-4 6-10 2-4 7-9 22-7 31 3-55 8-60 2-78 81 3-6",
    ": 8-93 5-6 8-9 602-4 6-15 7-20 2-3 5-9 31-4 6-7 9-42 4-7 9-51 4 8 60-4 7-9 71-2",
    ": 5-84 7-8 92 5-702 4-5 7-8 10-1 4-27 9 31-3 5-9 41 3 5-53 6-60 2 4-8 70-2 5-7",
    ": 9 83-7 90 2 5-800 2-7 9-14 6-9 23-34 7-42 4-56 8 60-78 80-4 8 91 3 5 9-902",
    ": 5-15 7-9 21-30 2-7 40-1 3-5 7 53-4 7-9 63 7-70 2-3 5-8 82-6 9-92 4-5",
    ": 9-50003 6 10 3-5 7 9 21 3-7 30-1 3-6 40-50 2-5 7-9 61-4 7 72-4 6-7 80-2 4 6",
    ": 8-9 91-2 4 7 9-102 4-6 8-16 9 23-4 6-31 4-5 7 9-41 3-7 9-58 60 3 5-8 70-2 4-5",
    ": 82 4-9 91-200 2 6 8-9 12 4-20 4-6 9-30 3-5 8-41 3-8 53-6 60 3-9 73 5 80 2 4-9",
    ": 92-303 6 10-1 4 6-21 3 6-36 8 40-5 50 3 5-7 61-2 4 6-77 9-81 4-7 9-90 3-6",
    ": 9-400 2-3 5-6 8-10 4 7-24 6-8 31-2 5 7 9-40 2-8 51 5-63 5 7 9 71-6 9-81 4",
    ": 7-97 500-2 5-6 9 12-3 6 8-23 5-6 8 32-3 5-6 8-42 6 8-51 5-6 8-60 2 5-7 9 72-4",
    ": 6-7 9-81 3-92 4-5 7-603 6 10-4 7-20 2 4 7 30 2 4-6 8-40 2 4 6-9 51-5 7-67 9",
    ": 71 4 6-8 80-7 9-95 7-9 702-3 5 7 9 11 3-4 6-7 9 23-31 4-7 9-40 2-9 51 4-62 4",
    ": 7-9 71 3-5 7 9-80 2-3 7-90 3-9 801-3 5 7-10 2 4 6-21 4 7-9 33 6-9 42-3 5-7",
    ": 53-4 9-65 70 2-4 6-83 5-9 91-3 6-7 9-900 2 4 8-10 2-6 21 5-7 9-35 7-9 41-2 4",
    ": 7-9 51-2 4 6-61 3 5-7 9 71-2 4-5 7 81-2 4 6 9-91 3-4 6-8",
    ": 1001-2 4-6 8-9 11-5 8-25 7-32 5 7-42 6 8-9 51 5-7 61-3 5-78 80-1 3 5 7-95",
    ": 8-106 9-11 3-7 9-25 8 30-1 3 5 7-40 2-8 50-3 5-7 9-62 4 6-71 4-9 83 5-91 4",
    ": 6-7 200-3 8-10 2-4 8-9 22-3 5-7 31-2 4-41 5-6 9 53-4 9-60 2-3 7-76 8-82 4 6",
    ": 8-98 300-3 5-8 10-3 5-6 21-2 4-9 31-2 4-43 6-52 4-8 60 2-7 9 71 4 7-80 2-3",
    ": 6-90 3-401 3-11 3 6-8 20-2 4-6 8-9 32 4 7-42 5-9 53 6-8 61-2 6-70 2-3 5 7 81",
    ": 3-6 8 92-3 5-8 504-12 4-7 20-3 5 31-2 4-7 9 41 3 5 7-9 52-8 61 5 8 70-4 6-7",
    ": 80 2-8 90-3 6 8-600 2-7 9-14 6 8-23 6 8 30-2 4-6 8 40 2-5 8 51-6 8-69 71-81",
    ": 4-8 90-2 4-8 700-1 3-6 9 15 7-26 8 30-4 7-8 40-5 9-56 8-9 61 3 8-71 3-6 80-2",
    ": 8-90 3-8 801 3-7 9-11 3-4 6-7 9-24 6-37 42-6 50 2 4-5 9 64-7 9 71-6 8-82 4",
    ": 7-9 94 6-8 902-3 6-8 10-3 6-9 22 4-36 8-47 9-56 9 61-2 6-72 4 6 9-80 2-91 4",
    ": 6-7",
    ": 9-2005 7-9 13-4 8-31 3-6 8-41 5-8 50 2 5-65 7-8 70-1 3-4 6 9-80 2-7 90-2 4-8",
    ": 100 2 4-5 7 9-13 5 8-24 6-7 9-31 3 5 8-9 41 4-53 5 7-61 6-71 5-8 82-3 5-90",
    ": 2-3 5-6 9 203-4 8 10-1 4-5 7-8 25-6 8-31 3-7 9 43-4 6-9 51 3 6-9 62-6 8 70-1",
    ": 4-7 9 84-6 8-95 7 9 304-6 9 11 3 7-9 21-2 4-30 3 5 8 40-2 4-6 9 51-5 7 9 62-3",
    ": 6 8 71-2 4-7 83-4 6-7 9-91 6 8 400 2 7-13 5-9 22 4-8 34 6-7 9-43 8 50 5-6",
    ": 63-4 7-9 71 4 6-7 9-82 7 9 91-2 5 8-501 5-9 14 7 9 22 6 32-3 6-8 40-2 4-50",
    ": 2-5 9 61 3 5-6 73-6 8 80-6 9-95 8-600 3 5 7-10 2-4 6-20 2-5 7-30 2-42 4 6-7",
    ": 9-50 2 4-5 7-69 75 7-8 82-4 6 8-9 91-3 5 7-700 3-8 12 4-21 3-30 2 5-7 43-4",
    ": 8-51 3-9 66-75 7-80 2 4-7 90 3-4 8-800 2-5 7-12 5 7-8 22-7 9-31 3-4 6-7 9",
    ": 42-5 7 50-2 4 8-9 62-70 3-4 6-7 81 3-7 9 91-2 5-7 9 901-10 2-5 7-8 20-1 3-31",
    ": 3-4 6-42 5-6 8-9 51-3 6-8 61-2 4-70 3-5 7-80 2-4 91 3 8",
    ": 3000-1 3-6 10 4 6-20 4 7 30 2-4 7 40 4 6-7 50-5 8 61 6 71 3 5 8-9 81-2 4 6-90",
    ": 2 4-8 103 6-10 3 5-9 22-5 7 9-32 4-8 40-4 8 50 4-5 7 9 62-7 70-2 4 7-81 3",
    ": 6-92 5-8 200-1 3 5-7 9 11 3 6 23-7 9-32 6 42 8-9 51-3 5 7-9 61 3-4 6-73 5",
    ": 7-80 3-5 7-93 5-301 3-4 7-13 6 8 22-3 6 30-1 4-9 42 6-8 55 7-8 60-1 3-5 7-70",
    ": 2-4 6 8 81-2 4-8 90 2-6 8-401 3-6 8-11 3-5 7 9 22-3 5-34 6-8 42-50 2-4 6-9",
    ": 61-4 6-70 4-5 7-80 2-3 5 7-8 91-8 500-9 11 6-7 20 2-3 6-9 32-6 8 40 4-7 9-50",
    ": 2 5 7-9 61-2 4-7 9 75 7-81 3 5 7 90-5 7 9-600 5-6 8-9 11-9 22 4-8 30-1 4 6-7",
    ": 40 5-6 8 50-2 4-7 9-60 2 5-8 70 2 4 6-9 81-4 6-91 3 5 8-709 12-5 7 9-20 2-3 6",
    ": 31 3-9 41 3-6 8-9 54 6 8 60-2 4 7-8 70 2 5 7-83 5-7 91-9 801 3 5-9 13-4 6",
    ": 9-20 2 5-6 8-9 31 4 6-8 40 2-7 9 51-2 4 6-7 9-61 4-6 8 70-2 5-6 8-9 82-4 8-9",
    ": 92-3 5 7 9-904 6-11 3-4 6-7 9 23 5-8 31 7 9-42 5-8 50 2-4 7-8 62 6-8 71-2",
    ": 6-80 2 4-5 7-8 90-1 3 5",
    ": 7-4007 9 11 3-9 21 3 6-7 30 3-4 8-40 2-5 7 50-4 6 60-1 3 7 70-2 4 7-8 80-1",
    ": 5-7 9-93 5-7 101 3-12 5 7-24 6 8-33 6-41 4 6 8-56 8 61 3 5-7 9 73 5-7 80-3",
    ": 7-97 9 202-4 7-9 11-3 5 7-24 6 8-30 2-42 5 8 50-1 5-6 8-9 61 3-5 8-71 3-4 6",
    ": 9-85 7-8 91-2 4-300 4 6 8-11 3 7 9-24 6-8 30 2-5 41-6 8-51 3-8 60 3 6 8-70",
    ": 2-6 8 80-1 4 7-90 2-5 7 9 402 4-8 13 5-20 3-5 9-30 2 5-6 8-9 41-6 50-4 6-63 5",
    ": 70-1 3-4 7-80 2 5 8-93 6 8-500 2 5 7-9 11 5-8 20 2-5 30-2 4-6 9-48 50 2-3 6",
    ": 8-60 3-4 8-71 3-81 6 9 91-2 4 7 9 601-4 7-9 11-3 5-6 24-5 9-30 2-3 6-7 9-43 5",
    ": 7-52 4-5 7 9-60 4-6 9-72 4 9 81-2 4-5 7 9 92-3 5 7-708 12-7 9-20 2 6 30-3",
    ": 5-42 4 6 8-50 2-3 6-62 4-6 8-9 72-4 7-8 80-8 90-7 9-804 6 8-10 2-4 7-20 2-3",
    ": 5-8 30 2-5 8-40 2-8 50-1 3-8 60-3 5 7-9 71-2 5-7 9-80 2 6 8-90 4 6-8 900-6",
    ": 9-11 5-9 22-3 5-6 30-2 4-6 8-9 42-9 55-6 9 61-4 6-72 5 7 80-3 90 3 5 8-9",
    ": 5001 3-8 12 4-8 20 2-31 3-6 8 41-2 7-51 4-8 60-6 8-9 71-2 4-7 9-80 3-4 6-8 92",
    ": 4-6 8-102 4-5 8 13-6 9-20 2-4 7-9 31-40 2-3 8 50-1 3 5 7-61 4-70 2 6 8 81-2",
    ": 4-91 3 6-8 200 2-3 7 10 3 5-8 20-2 5-32 6-7 40 3-5 7 9 52 4 8 60-1 4-5 7 9-70",
    ": 2 7 9-80 2-3 6-9 91-4 7 302-3 7-13 5-9 21 3 5-7 32 4-6 8 40-2 5 7-9 51 3-4",
    ": 6-63 5 7-70 2 4-80 4-9 91-5 9 402 4-6 9-14 7 9-24 6 9 32-3 5-6 8-41 3 5 7 9",
    ": 53-5 7-64 8-70 3-4 6-7 80-1 7-9 91-2 5 9-503 5-8 10 2-4 8-20 2-9 31 3-6 9-44",
    ": 7 9 55-6 9-60 2-4 6-71 3 6-80 2-3 5 94 6-603 7 9 11-2 4 6-7 9-22 5 9 33-7 40",
    ": 3-51 3-6 8-63 5-7 9-70 2 4-6 9 82 4 90-1 3-7 9-700 4-5 7-9 13-6 9-21 3-7 9-30",
    ": 2-4 6 8 42 5 7-8 51-4 8-60 2-3 5-7 9-70 4-80 2-3 6-90 2 4 7 9 801-2 5 7-11",
    ": 7-8 24-33 7 40 2-3 5-7 9 52-5 7-61 4-8 71-4 6-7 9 81-4 90 2-5 7-9 901 3 7",
    ": 10-1 4-9 22 5 8-9 31-2 4 6-8 40-1 5-6 8-55 63-7 9 72-5 7-80 3 6-7 92",
    ": 6000-1 3 7 9-10 3 5 9-21 4 7 9-36 9-45 8-52 4 6-8 63-6 70 2 4-5 7-8 81-2 4",
    ": 6-90 2-4 6-100 3-8 10 3-22 4-6 9-38 40-2 7-8 53-4 7-60 2-5 7-71 3 5 7-9 81-2",
    ": 5-7 9 94-8 207 9 15 7-20 2 5-32 4 7 40 3-8 50-1 5 8 60 2-6 8-70 2 4-7 80 4-91",
    ": 8 300 2-5 8-10 2-6 9-20 2 4-5 7-30 2 4 7-9 41-3 5-7 50 5 8-62 4-9 73-6 9-82 4",
    ": 6 8-9 91-6 8-400 3 6-7 9-10 2-3 5 9 22-4 8-9 31-42 4 6-53 6-7 9-60 3-4 7-9",
    ": 72-7 9-87 9-91 4-6 501 3 5-6 8 12 4-7 9-26 30-4 6 8-9 41-7 52 4-7 9-64 6-9",
    ": 72-3 5-6 83-4 6-7 9-91 9-600 2 5-8 10-2 5-7 9-22 4-33 5 8-9 44-6 8-52 7-9",
    ": 61-3 6-74 6-7 9-80 2 4 6-9 92-5 8-9 701-5 7-10 4 9 21-9 31-3 5-7 40 2-4 6-8",
    ": 51-5 7-8 60-3 6-7 9 75-7 80-5 7-8 90-1 6-7 9-804 7-8 10-3 5-8 20-1 3-6 8-30",
    ": 2-3 6-7 9-42 6 8 50 2 7-8 60 3-6 70-2 4 6 9-80 2 4-5 7-9 91 3 5 7 9 901-2 4-5",
    ": 7-8 10-1 4 21-4 7-33 6 8-42 4-5 50-2 5-7 9-61 3 5-9 71-5 8-81 6-90 2-7",
    ": 7000-7 12-3 5-6 8-20 2-30 2 4-8 40-4 6-52 5 7-60 2-6 9-72 4-5 7-8 80 2 5 7-91",
    ": 3-101 4-6 8 10-3 7 20-1 3-8 30-3 5-8 43-5 7-8 51-2 4-9 61 4-7 9-72 6-8 80-3 6",
    ": 8-90 5 7 9-203 5-11 3-7 9-20 3 7 30-2 5 9-42 5-6 8-53 5 8-9 63-5 7 70-82 6 8",
    ": 90-2 4-7 303-4 6-8 10 5-6 9-20 2-3 5-32 4-5 7 9-44 9-51 3-4 6-60 2-5 8-74 6-8",
    ": 83-4 7-9 92 4 8 400-2 4-6 9-10 3-4 6 8 20 2-3 5 7-9 31-2 4-7 9-43 5-6 9 51-2",
    ": 4-62 4-5 7-8 70 2-3 5-81 5 7 90-3 6 9-502 5-6 9 11-4 7-8 20 5-6 31 3-5 7-9",
    ": 41-2 5 7 9-50 2 4 6-7 9 62 6-8 71 3-8 80 3 5-7 9 91-6 8 600 2-3 6-8 10-1 5 8",
    ": 22 6-9 31 3-5 7 42-5 7-8 51-2 5 7-8 60-1 3-6 8-9 73-81 5 8-94 6 8-701 3-6",
    ": 9-11 3-9 21-4 31 5-6 8-9 41-2 4 6 51-6 8-61 4-6 9-88 90-3 5-9 801-3 5 8-9",
    ": 11-6 8 21-2 4-32 5-6 9-43 5-6 50-2 4-5 8-9 62 5-7 9 71 3-4 80 2-4 7-92 4 7-8",
    ": 900-4 6-10 2-21 3-4 6-7 9 31 3 5 9-42 6 8 51 3 5 7-9 62-70 2-7 81-3 5-6 8-90",
    ": 2-3 5-7",
    ": 8000-7 9-18 22 4 6 8-30 2-4 9-40 2 5-8 50 2-3 7 9-63 5 8-9 71 3-6 8 81 6 8-9",
    ": 91-7 101-3 5 11-2 5 8 20-1 5-6 9 31 3-5 8 40-1 5 7-8 50-3 7-9 61-5 8 71 3-5 8",
    ": 80-3 6-7 93-7 201-8 10 2-4 8-9 22 6-7 9-33 5 8 40 4-6 8 51-4 8-60 3 5-6 8-73",
    ": 5 7 80-2 4-9 92-303 9 12-6 8-20 2 4-7 32-5 8-40 6-9 51 3 62-4 6-7 9-72 4 7-84",
    ": 6-9 93 5-7 9 401-6 8-10 2 4 6 8-9 21 6-9 31-3 5-9 41 4-5 52-5 7-9 62-5 8-75",
    ": 7-84 6-7 9 92 7-500 3-6 8 10 2-3 7 23-4 8-30 2 4-5 40-3 8 52 5 7 9 61-4 6-8",
    ": 73 6 8-80 4-90 2 5 7 600 5-7 10 2-4 7-9 23-4 6-7 30-6 8-40 2 6 8 51-3 5-6 60",
    ": 2-4 6-9 72-4 7-8 80-4 7-90 4 6-7 700 2-3 7-11 4-7 29-30 3 5-6 8-40 3 5 50 2 9",
    ": 61-4 6 8-71 4-6 8 80-2 4 6 90 2-3 5-6 9-804 7-9 11-3 5 8-20 2-8 30-3 6-41 3 5",
    ": 50-6 60-4 70-2 6-7 80 6-7 9-93 5 7 9 901-2 4-5 7-8 11-4 20-2 5-7 9 32 6 40-3",
    ": 5 7 9 51-2 4 60-2 4-7 9 71-5 8 81-5 7 9-95",
    ": 7-9002 10-8 21-33 5-6 41-2 7-9 53-8 61-2 4 6-7 70-1 3 9 81-5 7-8 92-5 7-9 102",
    ": 4-5 9-10 3 5 9-21 3-31 5 7-40 2-51 7-60 6-70 3 5 84-5 7 91-2 4-7 9-201 3-4 7",
    ": 11-4 6 8 20-2 4-9 32-3 5-6 8-44 6-50 2-8 62-5 7 9-70 2-5 7-8 80-2 4 7 9-90",
    ": 4-300 3-4 6-7 11-3 5-6 8 20-1 4-30 2-3 6 43-8 51 3-4 6 8-60 2-5 7-70 2 5-6",
    ": 9-80 2-4 7-96 9-400 3-5 8 10-1 3 5 7-9 22 4 6-7 30 2-7 40 2 4-5 7-50 3-6 62-4",
    ": 71-6 8-82 5-7 90 3-6 8-502 5 7-9 11-2 5 8-23 5-30 2 4 6-9 41-6 9-50 2 4-6 8-9",
    ": 61 4-7 71-2 4-5 7-9 81-3 7 9-92 4-5 8 603-4 6-7 9 11-3 5-8 20-5 9-31 4 6-7",
    ": 9-40 2-5 8 50 5-7 60 2 5-71 3-6 8-80 2 8-9 92 6 8-700 2-5 7-10 3 5-6 9-20 2 4",
    ": 7 9 31-6 9-42 7 50 2-3 6 8-60 3 6 72 5-81 3-5 7-8 91-3 5 7-8 801 3 5-9 12-3 5",
    ": 7-8 20-5 7-9 34 8-9 41 5-8 50-2 4-5 7-8 60-1 3 5 8 70 2-3 7 9-81 3-5 8-93",
    ": 6-901 4-5 8 11-4 6-7 9-20 3 6 9 31 3 5-7 41 3-5 7 53-4 6-65 7 70-2 4-5 8-9",
    ": 83-7 9 92-7",
    ": 60000 3-5 7-8 10 3-5 7-9 21 4-5 7-9 31-6 9-41 3-4 6-55 7 9-65 7 9 75-6 8-80",
    ": 2-5 93-6 9 103-6 8-9 11 4-5 7 9 21-5 31 3 6 9-53 5 8 61-5 7 9-70 3 8 80-1 3",
    ": 5-7 90-1 4-8 200-2 4-11 4 8-21 3-4 7-8 35-7 9-40 3-6 8 50 2 4-9 63-8 72-9",
    ": 81-2 4-5 8-9 91 5-7 300-1 4-8 10-1 5 7-8 20 7-9 32 8-9 41 3 8-9 52-8 62 7-9",
    ": 71 3 7 9-82 7 9-92 5 7 400-4 8 13-5 9 21-2 7-30 2 5 7-8 40 3-4 6-50 3-62 6-9",
    ": 71-4 6 8 80-2 4-5 7-9 92-3 5 8-503 5-7 10 3-4 6-7 9-20 6 30 2-3 5-40 2-3 5-6",
    ": 9-57 9-63 9-70 4 6-8 80 2-3 5-90 2 4-5 8 600-3 5-6 8-12 4 6-7 20 2-3 5 7-32 4",
    ": 7 9-40 2-56 9 63-4 6 8-77 9 83-6 90-2 4-5 9-700 2 4-5 7-9 13-4 6-7 9-21 3-5 7",
    ": 9 31 3 5-8 40 2 4-52 4 6-61 3 5-6 8-70 3 5 7-9 83 5 7-8 91-2 4-7 9 802-4 10-1",
    ": 4-6 9-21 4 6 9 31-3 6-41 5-7 9-50 2-3 7 9 61-4 7-72 4 6-7 9-80 2-5 7 9-90 5-6",
    ": 900 2-3 5 8-9 11-3 6 8-20 4-6 8-30 3-5 7 9-40 2-5 7-8 50 2-4 6-7 9-61 4 6-8",
    ": 74-9 81-2 9-92",
    ": 4-1001 4 9 11 3-4 9 21 4-6 9 31 3-8 40-3 5-6 9-50 4-5 8-9 62-4 7-8 70 2-3 9",
    ": 81-2 4 7 9-93 5 8-100 2-6 8 11 3 5 22 6-30 2-4 45-50 3-8 63 6-7 9-71 4 6-7 9",
    ": 82 5-8 90-1 3-6 9-203 5 7-10 2-4 6-8 20 3 5-30 2-7 9-40 2 4 7 9-51 3-4 6-65 8",
    ": 72-5 7-9 81-5 9-90 2-3 5-9 301 3-6 9-18 20-1 4-7 31-6 8-41 3-5 7 9-53 6-8",
    ": 60-1 9-73 5 7-80 4-91 6 8-9 401-5 10 4-22 4-6 8-30 2-3 6-9 42 5-55 60-5 7-70",
    ": 4 6-82 4 6-7 9 92-502 4-10 2 5 8 20 2 6-30 3-52 4 8-9 63 5-6 8 70-81 4 8-9",
    ": 92-9 606-9 11-4 9-21 3-6 9 32-4 7 9 41-2 6 52-4 6-7 60-1 70 2-3 6-81 4 7-90 5",
    ": 8-9 701-2 4 6-9 11 3-7 26 40-2 4-5 7-9 52-3 7-8 60 5-7 9-73 7 9-80 2-6 8-9 94",
    ": 6 8-9 802 4-6 9-10 2 4 9 22-4 6-31 6-7 42 4 8-51 4-5 7 61-2 4-8 70-1 3 5-7",
    ": 9-81 3 6-8 91 4 6 903 7-8 10 3-5 7 9-21 7 31-5 7-44 7 50 4-6 8 61-3 6-70 2",
    ": 4-6 81 3-7 9 91-2",
    ": 5-2000 2-3 5-10 2-3 6 9-20 2-4 7-30 2-3 6 40-1 7 51-2 5 8 62 5-71 3 6-7 9 82",
    ": 4-9 93-6 8-9 101-2 7-8 13 6-9 21 3-4 6-7 30-1 5-9 41 4 54-8 60-5 8-70 2-6",
    ": 80-1 5-7 9-90 3-4 6-201 5 7 10-2 7-9 23-6 9-37 41-5 9-50 4 6 62 5 7 9-70 2 4",
    ": 7-8 80-4 6-7 90-1 3 303 5-18 20-2 4-6 9-31 4-40 2-6 9-50 5-6 60 3-4 6-7 75",
    ": 7-8 80-1 4-5 7 9-91 3-6 404 8 10 4-21 4-6 8-30 4-6 9-40 3-4 6-9 53-6 8-61 3 5",
    ": 8-70 3-7 81 4-8 90 2-4 503 5-7 9-23 5-6 9-31 5 7-41 3-7 51 3-6 8 60 8 70-1",
    ": 3-5 80-7 9 94-5 8-9 602-4 7-11 5-6 9 21-3 5-7 30-1 3-4 7 9 41-2 6-8 52-5 7",
    ": 9-61 3-7 71-5 7-8 81-5 8 90-2 5-703 5 11 3 6-7 9-20 4-9 31 3-40 2-4 6-8 52-5",
    ": 9-60 3-7 9 71-9 81-2 5-8 90-4 6-7 9-801 3-8 11 5-6 8-26 8-9 31-6 9-41 4 6",
    ": 8-50 3 6-65 7 9 71-3 5 8-84 8-9 92 4-6 8 900-4 6-9 11 7 9 21-2 4-8 30-1 3-4",
    ": 7-8 42-3 5 7 50-3 7-63 5 7-71 5-6 84-6 9 93",
    ": 6-3003 6-8 11-2 4 6-9 21-4 7-33 5-7 40 3-4 8-51 4-6 8-9 62 4-6 8-70 2-4 6-83",
    ": 6-7 90-1 3 7 9-105 10-1 4-5 8-9 21-2 4 6-31 3 5 7-8 40-6 8 51-60 2-3 5 7 70",
    ": 2-3 6-7 9-80 2-4 6-9 94 9-207 9-11 3-4 6 8-20 2-4 6-8 30-2 4 7-8 40-2 4-7",
    ": 50-3 5-6 60-3 5-72 5 9 82-4 6 8-9 94-5 7 9-301 3-7 9 12-21 3-4 7 9 32 4 6-42",
    ": 4 7-8 53 6 61-2 5-7 9-70 3-6 8 81-7 9-90 2-4 6-402 4-6 9 12-8 20-1 3 5 9 31 3",
    ": 5-7 9 43-4 9-51 3 7-62 4-70 2-4 6 8-80 2-6 8 90 2-9 502-4 6-7 9 12 4 6-7 9",
    ": 22-7 30 4-5 8 40-2 5-6 9-50 3 5-9 61-5 9-73 5-80 2 5-92 4-6 9-601 4-5 7-9",
    ": 13-4 6-8 20 2 4-30 3-7 41 4 7 50-2 4-7 9-65 7 9-71 3-7 9 81-6 8-9 91-3 5",
    ": 9-706 9 11-2 4 6 8 24 6-7 30-1 8 40-3 5 8-53 6 60 2-4 6 8 70-5 7 80-4 6 9-92",
    ": 5-7 800-1 4-6 9 13 6-9 23-4 6-9 32-3 5-6 8 40 3-4 7 9-51 3-4 6-62 4 7 70 4-8",
    ": 80-7 90 2-5 8 900-1 3 5 9 11-5 7-20 3 6 9-30 2 6-7 9-43 5-54 6 8-9 62-4 7-70",
    ": 2-3 9-82 4-8 90-8",
    ": 4000-2 5-10 3-6 8-25 7-30 2-3 5-8 40-4 6 8 51-4 8 60 2 5 7-70 2 5 80-1 3-5",
    ": 9-91 3-6 8-103 6 8-12 4 7 9-21 3-4 6-8 30 3-40 2-3 5-8 50-1 3-4 6-8 60-2 4-73",
    ": 7-8 80-4 6-95 200 2-5 8-9 12-4 7-9 23-6 8-9 31 3 5-7 9-52 4 6 62 9-70 2 4 6-9",
    ": 81-3 6-90 2 4 6-304 6 8-10 2-4 6-9 22 4-5 8-9 31 3-7 40-6 8-51 4-7 9-60 2",
    ": 6-70 3-4 6-86 9 93-6 8-9 401-6 8-12 4 6-9 21 3 5 7 9 34-5 7 9-44 6-56 8-62 4",
    ": 6-9 71-3 5-82 6-7 9 91-3 7-504 6 8 10-9 21-5 7-34 7-41 3-6 9 52-4 6-9 62 4 6",
    ": 9-73 5 7 9-84 6-94 6-9 601-8 12-4 6 8-9 21-3 5 7-8 30-3 6-8 40-1 3-4 6-9 51-2",
    ": 4-9 61-3 5-7 9-72 4 6-9 82-3 5 7 90 2 5 8-700 2-4 6-9 11 3-8 20 2 5-7 9-30",
    ": 3-6 8 40 2-3 5-51 3-4 6-7 61-2 4 6-7 9 72-4 6-8 80-96 800-2 4-7 9-10 2-4 6",
    ": 8-20 2-3 6-8 30 2 4-6 8-41 4 6-8 50-2 4 6-7 9-61 4 6-7 9-73 5-6 80-5 9-96 8-9",
    ": 901-8 10-6 8-26 8-9 33-4 6-7 9 42 4 6-8 50 2-4 6-7 9-63 5-6 9-72 4 6-9 81-2 4",
    ": 6-9 91-8",
    ": 5000-1 4-5 7 10-2 4 6 8-27 9-35 8 41-3 5 7 9 51 3-4 8-9 61 4-6 8-75 7 9-80",
    ": 3-6 8-90 2-5 8 101-2 5 8-11 3 8 20-7 9 33-4 8-9 43-4 7 50-1 3-63 7-70 2-6 9",
    ": 81 3-4 98-9 204 10-1 3 5-6 8-9 21 3-4 8-33 8-44 8-50 6 62-3 5 7 9 71-7 81 4-8",
    ": 90 2-4 7 9-301 3-6 11 3 8-21 5-31 3-47 9-52 8 62-3 5-6 8-71 3-4 6 8-81 4-6 8",
    ": 90-3 9-401 3-15 7-20 2 4-6 8-35 7-41 3 5-6 9 51 3 5-6 9 62-3 8-73 5-6 8 81-4",
    ": 8-9 91-3 6-9 501-6 8 11-2 5-23 6 9-32 4-7 9 42-3 5-6 9-52 4-7 9-60 7-70 2 4-5",
    ": 7 9-81 3 5-6 8-91 4 6 8-604 6-11 4 21 4-5 7 9 32-5 8-41 4 6-7 9-50 3-4 6-9 61",
    ": 9-74 6-8 81-2 4 6 95 7-8 700-4 6-8 12 4 6 8-22 4-5 8-30 2-4 6-7 9 41 3-8 52-6",
    ": 61 4-73 5 7 9-82 4 8-91 4 6-7 803 5-8 10 2 6-9 24-37 40-5 8-63 6-7 9-70 2-6 9",
    ": 81-2 7-8 90-2 4-6 8 900-1 3 5-6 8-10 2 4 7 23-4 6-32 41-2 4-5 7-8 50-3 5-9",
    ": 61-2 6-7 70-1 3 6 8 80-2 5-7 9 91-6 8",
    ": 6002-4 7 14 7 9-24 7-8 33-6 9-42 5-8 50-1 3 5-9 61 3-6 8 70-5 7-89 93-6 8-100",
    ": 3-4 7 9 12 4-21 3-4 7 9 31-3 6 9-40 2-4 9-54 8 60-9 71-2 4-6 9-80 2 4 6-7",
    ": 91-6 8-201 3-17 20 2-4 6 8-9 31-8 40-2 4 6 8-9 52-4 7-9 61-3 6-8 72-3 5-6",
    ": 8-83 6-9 91-3 5 7-301 4-5 7 13 6 8 22-3 5-7 9 34-5 7-42 4-6 8 50-5 60-1 4 6-8",
    ": 73 6-81 3 6 8-90 3-400 2-3 6-16 8 21-2 4 6 8-33 6-7 43 8-9 51-8 60-3 5-7 71 3",
    ": 6 8-9 82-6 9-91 4 6-8 500-1 3-6 8-10 3-5 7-21 4-6 8-31 5-7 9-40 4-6 8-9 52-9",
    ": 61-4 6-9 71-6 8 80-9 91 3-8 601-2 4-7 10-1 5-6 8 20 3-7 9 32 4-8 41-3 5-52",
    ": 4-5 7-60 3-4 6-7 70-1 3 5-6 80-4 6 8 92 7-9 701-2 4 7 12-3 7-8 20-2 4-6 8",
    ": 34-8 40-1 4-5 7-53 6-7 9-62 4-6 9-73 6-84 8-93 5 7-804 7-10 4-7 9-20 2 5-7 9",
    ": 32-3 6-8 40-1 3 5-6 8-53 6-7 9-60 2 4-6 9 73-4 6-80 2 5 7 9-91 3-4 6-7 9-901",
    ": 5-10 2-4 6 22-6 8 30-6 40-2 4-5 7 9-51 3 5-6 8 60-3 5-6 9-70 2-3 6-7 9-81 4-6",
    ": 8-92 5-6 8-9",
    ": 7001-6 8-9 11 4-8 20-6 8-9 32 5-9 41 3-9 52 4 7 61-2 4-6 9 75 82-6 9 92 6-7 9",
    ": 101-2 5 7 11-2 4-6 8-20 2 6-31 3-6 8-9 41-5 8-9 52-3 5 7 9-63 5 8-70 3 8-9",
    ": 81-3 5-95 7-8 200-1 3-4 8-11 4 7-21 4-32 5-7 9 41-2 5-9 51 3-5 8-9 62-6 70",
    ": 4-7 9-82 4-5 9 95-9 302-4 7-8 10 2 5 7-8 20-2 4-5 7-9 32 4 6-7 9 41-6 8-50 4",
    ": 6 8 61-4 6-9 71-5 7-81 3 5-7 90-1 4-6 9-406 9 14-5 9-24 6-7 30-2 4 7-40 4-5",
    ": 7-52 4-5 7 9-60 4 6-7 9 71 3-7 9-87 90 2-4 6-7 9 502 4-8 12-6 20 3-5 8-32 5-7",
    ": 40 3 5-8 50 3-6 8-60 2 4 6-8 72 4-5 7 80 2-6 9-91 4 7-9 602-6 9-12 4-20 2-6",
    ": 8-9 32-3 7 41-7 51-3 6 61-9 71-2 4-9 81-3 6-7 92-5 8-700 7 9-15 7 21-2 6-30",
    ": 2-5 7-8 40-7 9-50 3-7 9-64 7 9-70 4-7 80 2-3 5-6 8 91 3-4 6 806-10 5 7-20 4-6",
    ": 8-32 4 8-9 41 3 5-8 50-1 4-6 8 60-6 8-70 3 5 9-81 4-97 901-3 6 9-11 4 6-7",
    ": 20-1 3 5-8 30 4 6-41 5-7 50 2-3 5-8 60-3 7 9 71-7 9 82-3 5 7 9 91-4 7",
    ": 8000 2-6 10 3 6-7 9 21-2 4-31 4-8 40-1 3 5-6 8-54 6-63 5 8-70 2-3 5 7-86 8-90",
    ": 3-8 102-5 7-21 4 6 8 30-9 42-7 9-50 3-6 8-62 4-7 9-71 3 5-81 5 7-93 5 200 3-5",
    ": 7-23 5-6 8-32 4-6 8-40 2-4 6-8 51 3-5 7 9-63 5 7 71-3 5-8 83-4 7-90 2 5-8",
    ": 303-7 10-2 4 7-9 21 3 7-32 7 40-3 6-9 51-3 6 8-9 61 3-4 8-70 2-8 80-5 7-90 2",
    ": 4-6 9 401-4 6-8 12 4 6-21 3-7 9 31 3 5-7 9-43 5-50 2 5 7-62 4-9 71 3-7 9-84 6",
    ": 8 90 6-8 502 4-6 8-9 11-4 6-7 9 21-2 4 6-33 5-8 40-3 6-51 3-5 7-9 62-5 7-71",
    ": 3-6 8-9 81-5 8 95-6 8 601-2 4-5 7-8 10-4 8-9 21-4 6-31 3-40 2 4 7-51 4-7 9-61",
    ": 3-70 3-5 7 80 2-6 8-93 5-7 700 2-3 6-10 3-8 23 5-8 33 8 41-3 6-9 51 4-7 9",
    ": 61-5 7-8 70 4-6 8-80 3-4 7 90 3-4 9-805 7 9-13 5-7 21 3-5 7 9-33 5-9 43-4 6-7",
    ": 9-50 3 5 7 9 63-5 7 70-2 4 6-81 3-4 6-9 91 3-7 9-901 3-4 6-10 2-5 7-8 21 8-9",
    ": 31-3 5 9 42 4-7 50-2 4-9 62 7 9-70 7 9 81-2 4-7 9-90",
    ": 8-9000 2 5 7 9 11-22 8 31-2 4-6 8 40-1 3-6 8-52 4-60 2-3 5-73 5-82 5 7-90 2-4",
    ": 6-7 100 4 6 9 12 5 7-9 21-6 8-9 31-2 8 40-3 5-7 50-6 9-63 5 7 9-72 6-7 9 84",
    ": 6-9 91 4-5 7 201-2 4 6-7 9-12 4-5 9-21 4-31 3 6-40 2 5-6 8 50-60 2-72 4-6 9",
    ": 81-3 90 2 4-9 302-3 6-7 9 11-5 7 23-4 7-8 31 3-40 2 4-5 7-53 5-6 8-9 61 3-4",
    ": 6-8 70 3-81 5-6 8 91-2 5-400 2 4-5 7-8 10-1 3-4 6-9 21 4-8 30-3 5 7-45 7 50",
    ": 6-60 2-3 5-73 6-7 81 3-4 6-7 9-90 3-4 6-7 9-501 4 8 14-6 20 3 5-6 8-32 4-5",
    ": 7-8 40 4-5 7-9 52 4 6 8-9 63 5-7 70 2 4 6 9-80 2-5 8-9 91-3 5 7-606 8-10 3-7",
    ": 9-22 4-9 34-5 8-9 43-4 7-51 3-4 7 9-61 3 5 7 71-2 4 6-7 9-80 3-5 7 9 92 4-6 8",
    ": 700 3-5 7 9 11-4 6-7 23-4 6 8-31 8-42 4-7 52 8 60-1 3-7 70-2 4 6 8 80-1 3-5",
    ": 7-9 92 4-6 8-9 801-3 7 10-3 5-6 22-6 8-30 4-5 8-40 3-4 9 51-6 8-62 4-5 7-8 70",
    ": 2 4 6-9 82 4-5 8-91 6 9-910 2-6 9-20 2-7 31-3 5-6 9 42 4-7 9 51-3 5 7 9 61-8",
    ": 72 5 9-81 3 5 7-9 94 7-8",
    ": 70000-9 11-5 8-23 6-8 31-2 4-5 8 40-2 4 7-8 50-1 3-6 8-62 6-8 70-1 3 6-7 9-81",
    ": 5-9 93-8 101-8 10 5 7-20 2-4 6 8-9 35-9 41-6 8-50 2-6 8-62 4 6 8 71 3-4 7-8",
    ": 80-1 6-7 9-93 6-200 2 6 8 10 2-4 6-7 9 24-5 7-9 31-2 4 6-43 6-50 3-5 7-60 5 7",
    ": 72-4 6 9-80 3-5 8-91 4-301 3 6-13 5-20 8-32 4-6 8 40-6 8-50 2-3 6-8 62-5 8-9",
    ": 71-6 8-9 82 4-95 8 400 2-4 6-9 11-3 8 24-7 30 3-6 8 40-4 8-55 7-9 62-4 7-9",
    ": 71-3 5-6 8-82 7-8 90-1 3-500 2-4 6-19 21-2 4-7 30-4 6-7 9 41-4 6 9-70 2-6 8",
    ": 86 8-93 5-6 8 600 2-4 6 8-20 2-3 5-7 31 3-9 41-3 7 9 51 3-6 9-61 3-8 70 2-4",
    ": 6-8 80 3 6 8 90-2 4-6 700-10 2-7 9 24 6-8 30-5 8-40 3-4 8 51-2 6 8-9 64-7",
    ": 70-3 5-6 9 81-2 4-95 8-801 4 6-11 3 5 8-22 5-32 4 7-41 3 5-6 9 51-5 7 9-60 5",
    ": 8 71-7 9-82 90 2 4 6-9 903-4 6 9 12-5 20 2-6 9 31 3-4 6-48 50 6-9 61 3 6 8 72",
    ": 7-9 81 4 7-8 90 4",
    ": 6-1000 2-4 7-12 4-6 8-9 21-5 7-30 3-5 9-41 3-9 52 4-5 7 9-60 3-8 71-3 6-7",
    ": 9-80 4-5 7-90 2-3 5-7 9-112 4-7 20-1 3-6 8-31 3 5-7 9-41 3-4 6-50 2-5 8 61",
    ": 3-6 8 71 4-5 7-80 2-3 5-6 8-90 2 5 8-203 5-6 8-10 2-5 7-23 31-3 5-40 3-5 51-2",
    ": 5-63 6 72 4-7 9 81-5 7-90 2 6 9-305 8 12-3 5-9 21 3 5-6 8-30 2-7 9-42 5-7",
    ": 9-51 3-64 6 8-71 3-4 6-8 80-2 4-7 9-90 2 4-5 8-9 401-7 12 5 7 21-7 9 31-3",
    ": 5-44 6 52-61 3 5 7 9 71-2 4-5 8 84-6 8 92-8 500 3 5-9 19 21 3-4 7 9-31 3 9-40",
    ": 2 4-6 8-9 51 3 5 7-8 62 4-5 7-71 4-6 8-9 84-6 91-3 5-601 3-4 7 10-3 5-20 4",
    ": 6-8 30 3 5 7-44 8-52 5-6 8 61 3-73 5-6 9-80 5-9 91-4 6-7 700-10 2 5 7-8 20 2",
    ": 6-33 5-6 8-40 2-3 5 7-8 50 2 6-7 9-64 70 2-7 82-6 9 91 3 5-7 9 801-2 6-10",
    ": 2-26 8-31 3-41 3-5 7 9 51 3-4 6-60 2 4-7 9 71-5 7-84 6-7 9-91 3-6 8-9 901-2",
    ": 4-5 8 13 5-6 8 21 5 7 30-3 5-41 3-4 7-60 7-8 70-3 5-6 8 80-90 3 5-7 9",
    ": 2001-3 5-6 12 4-5 7 9 21-2 5-6 8-33 5 9-40 2 4-55 8-61 3 5 8 72-3 7-85 7 9",
    ": 91-4 7 9-102 6-7 9-10 2 4 6-7 9 21 3 5 7-9 31-3 5-7 9 41-5 7-8 50-1 3-4 6-8",
    ": 64-5 9-74 6-80 2-3 5-93 7-201 4-5 7-13 6-7 9-21 5-6 8 32 4 9 41 3 5-8 51 3-64",
    ": 8 70 2-3 5 7 9 81-6 8-91 5 7-8 301-3 5-7 9-10 2 5-20 3 5 9-44 6 8 50-3 6 8-9",
    ": 62-5 9-70 6-7 80-1 4-6 9-90 2-7 9 402-3 5-9 11-3 6 9-21 3-6 8-34 6 8 40-2 6 8",
    ": 50-4 6 9 61 5-8 71 3 5 8 81 5 9-90 3-5 7 502-3 5-24 6-9 33-7 9 41-51 6-8 61-3",
    ": 6-71 4-5 8 81-94 6-7 601-2 4-5 7-9 11-2 5-22 5 8 30-3 5-6 40-2 4-6 8 50-6",
    ": 61-7 9 71 4 6-82 5-6 9 92 4 701-4 6 10 2 5 21 4-9 31 3-5 7 9-40 2-3 5-7 51",
    ": 4-6 9-61 3-4 6 8 70-1 4-6 83-9 93 5 7-8 800-1 4 7-8 10-1 4-5 7-8 20 3 6-32",
    ": 4-8 41-2 4 7-9 52-3 5-7 9 62 4 6 8 70 5-7 80 2-6 9 91-4 6 8-901 4-6 8 13-4",
    ": 6-22 4 30-2 5 7-42 4 6 8 52-61 5 7 9-72 4-8 81-5 8-90 5-9",
    ": 3002-3 5-8 10-1 3 5 8-30 4 6 8-9 42 7 9-58 61 4-7 70-3 5 8 80 5-6 8 90 2-7",
    ": 9-102 4-5 7 9-11 4-6 8 20-4 6-7 9 31-2 5-8 40 2 6-52 5-63 5-7 70-2 4-5 7 9",
    ": 82-3 5-7 91-5 8-201 4-8 10 5 7-8 20-1 3-9 34-5 40-1 5-8 50-5 7 9 61 4-6 9-74",
    ": 6-7 9-83 6-90 2-7 9-302 4-5 7 10 2-7 9 21-2 5 8 30 5 7-41 4-7 50-5 8-9 63-6",
    ": 9-71 3-4 6-80 2-5 8-94 6 8-9 401 3 6-9 12-5 7-8 21-3 5 9-30 2-4 6-8 41 3-5",
    ": 8-51 3-5 7-60 3-4 6 9-70 2-3 6 8 80 3-9 91-5 7-504 7-8 12-6 8-21 3 5 7-32 6-8",
    ": 41 3-8 50-1 3-7 60 2 4-6 8 71 3-4 6-81 3 6 8-91 7 9 601-5 8-10 3 5-7 9 21 4-5",
    ": 8-30 2-5 8 40-1 3-7 9-51 3-7 9 61-4 6 8-9 72-6 8-9 83-4 7 90-5 8-9 701 5 7 12",
    ": 4-9 21-3 5-7 9 31 3-4 6-45 8-52 5 9-65 7-8 72-4 7-9 81-9 93-5 9-808 11-2 6-8",
    ": 20-4 7-30 2 5 7 9-40 2-3 5-6 8-9 51-2 7 9 61 5 7-72 4-82 4 6-8 90-4 7-8 900-2",
    ": 4 7-8 11 3-4 7 9-20 2-6 8-32 4-7 9 41-7 51-6 8-65 7-70 2-5 8-82 4-90 2-4 6-7",
    ": 9-4003 5-7 9 11-9 24-5 7-9 32-6 8 40-1 4-52 5-6 8-9 61 3-6 8 70-80 4-6 8 90",
    ": 3-5 7-109 11-6 9-21 3-5 7-34 8 46-7 9-56 8 61 3 5-8 71 3-7 9-80 2 4 6-92 5",
    ": 7-200 2 4 7-8 10-20 2-6 8-31 3 5 7 41-4 6-9 51-2 4 7-9 61 5 7-8 70 2-4 6-8",
    ": 80-4 90-9 301 3 5-9 11 3 6-8 20 2-7 9 31 3 5-8 40 2-4 9-55 8 60 2-8 70 3-8 80",
    ": 3-4 6-7 9-94 6-7 9 402-3 5-8 10-20 2-6 8-30 2-4 40 3 6-8 51-8 61-5 7 9 71 3-4",
    ": 8 81 3 5-6 8-90 2 6-500 2-5 7-9 11-2 4-7 9-20 2-3 6 30-5 7-8 40 4-9 51-4 6",
    ": 8-62 5-7 9-71 5 9-82 4-6 8-9 91-2 7-8 600 2-3 5-7 11-2 4-5 7 9-25 7-8 30-2 4",
    ": 7-8 40-9 51-3 7-9 61-4 7 70-3 6-8 80 2-3 7-90 2-9 701-5 7 10 2-3 5 7-8 20",
    ": 6-33 6 9-45 7-8 50-2 4-6 8-9 62 4-8 70-8 80 3-6 8-9 93-801 3-7 9 11-2 5-22 4",
    ": 6-8 30-4 6 9-42 5-7 50-1 3-5 8-9 64 7-8 70-6 9-81 4-6 8-9 91-3 5-6 8 900 2-3",
    ": 5 8 10 2 5-20 3 5 7-9 32-3 5-6 8-41 4 6-9 54-5 8-60 3 7-70 2-3 6-9 81 3-5 7-8",
    ": 91-5",
    ": 7-5000 3-4 6 8 10-1 4 6-24 6-9 32 4 6-8 40-1 4-5 7-9 51 3 5-6 9 61-2 5-73 5-6",
    ": 8 80 3-7 90 4 7-103 5-7 10-9 21-2 4-8 30-2 4 7 9-40 3 5-56 60-1 8 71-4 6-7",
    ": 9-89 91-2 5-200 2-3 5-6 8 11-2 4-9 22-5 7 30 2-4 6-7 9-42 4-5 50-3 5-7 9-65",
    ": 70-2 7 9-82 4-91 3-5 7-9 301 3-4 7 9 11 3 5 8 21 3 5-7 9 31-2 4 6 8 40-4 7",
    ": 51-2 4-63 6-8 70-1 3 5 7-8 86-7 90-5 7-401 3-16 20-1 5 7-9 33-9 42-3 5 7 9 55",
    ": 7-8 61-3 5-72 4 6-9 81-4 6-95 7-506 8-9 11 3-4 6-21 3-8 32-3 5-40 2-6 8-51",
    ": 3-4 6 8-64 7-70 3-4 6 8 81 3-4 8-90 2-5 8 600 3-5 7-9 11-4 7-21 3-5 7-8 30-3",
    ": 6 8-9 41-2 4 6-7 51-4 6-60 2 4-7 70 2 5-89 93-9 702-4 8-10 2-3 5 7-8 20-5",
    ": 7-32 6-7 9-44 6 9-52 4 6 9-60 2 5 7-9 71-4 6-82 5-6 9 91-3 5-6 802-7 10 3-4",
    ": 7-8 22 4 6-32 4 40-2 4 7-8 50 4 7-8 60-1 3 5-9 72-4 6-81 3 9 91-4 6 9-902 4-6",
    ": 8-15 21-6 8 31 3 5-44 6 8-9 51 5 60-1 3 5-7 9-77 9-85 9 91-4 7",
    ": 6000-2 4 6-8 10 2-3 6-8 20 2-6 8-30 2-3 6-42 4 7-8 50 2 6 60-75 9-81 3 5-8",
    ": 90-5 7 9-101 5-11 4-20 2-4 6-7 9 31-4 7 9-41 3 5 7-54 6-7 9 62-3 7-8 70-3",
    ": 80-6 9-99 202-5 7 9-15 7 9 21-8 30 2-3 5-6 8 41 3 5-8 50 2-4 6-61 3 5-6 71 3",
    ": 5-6 8-82 4-8 94 6 9-301 3-9 11 3-5 8 21 4-7 9 31-2 4-6 42 4-8 51 3 5-7 9-61",
    ": 3-4 6 8-76 85-8 92-3 5-6 9-401 3 7-12 8-9 21-6 8-9 32-3 5 7-40 3 5-6 51-3 6-8",
    ": 61-2 4-5 7-9 76-8 82 4 6-9 91-4 6-7 501 3 5 7 9-12 4 8-9 21-3 7 30-1 5 7-42 4",
    ": 6-52 7-9 61-74 8 80 3 6-8 91 3 5 7-8 600-3 5-7 9 17-8 20-2 4-30 3 5-6 8 41 3",
    ": 5 7-8 50-3 6-8 60-3 5-8 70-1 3 5-6 8 80-2 4 6 8 90 2-3 5-702 5-6 8-12 5-7",
    ": 9-20 2-31 6-7 40 3 5 50-3 5 7 9 62-9 71 3 5-7 9-84 6 8-95 7-800 2-3 5 7-10",
    ": 2-3 6 8-20 2-8 31-5 7-8 40-3 6-52 4 6 9-60 2 4-70 2 4 6-7 80 4-6 8-90 3-8 901",
    ": 3 5 8-9 11-3 7 20-5 7-9 31-3 5-7 9-40 2-4 7 9-51 3-4 7 62-3 6-7 9-73 7 9-80 2",
    ": 6 9 94 8",
    ": 7001-3 5 7-10 2-4 6-20 2 5-8 32 4 6-7 9 41 4 6 8-53 6-7 9-60 2-3 5-7 9-70 2-3",
    ": 5-9 81-2 5-94 6-105 7 11 3 5-21 6-30 2-4 6 8-41 3 9-53 7-60 2 4-6 9 71-6 8-80",
    ": 2 4-5 7 9-95 7-8 200-1 3-5 9 11-3 5 7-23 5 7 31-2 5-6 9-40 3 6 8-54 6-62 4-9",
    ": 71 3 5-82 8-90 4-6 301 4-8 10-1 3-9 21-2 4 7 9 31 3 5-6 8 40-2 4 6-7 9 52 4-5",
    ": 7-8 60 2 4-9 71-3 8-9 81 3 5 7-94 6-400 2-5 9 12 5-7 9 21 7-8 30 2-3 5-7 40",
    ": 4-7 53 7-8 65-6 8-71 4-6 8 80 2-3 5 7-8 90-2 6-500 2-3 6 8-11 6-7 23-4 6 8",
    ": 30-3 6-8 41 5 7-50 5-9 61 3-4 6-8 71-2 4 6-7 80 2-3 6 8-97 600-1 3-4 6 8 10-2",
    ": 4-7 22 4-35 7 9-40 2 6-50 6-63 5-71 3-7 9-81 5 8-96 8-705 7 9-16 9 21 5-6 8",
    ": 33-4 6 8 41 3-55 8-61 4-5 7 9 73-4 7 9-84 6-7 9 92-4 8-9 803-5 12-22 4-6 8 30",
    ": 5-7 40-2 4-8 50 5-8 60-1 3 5 7-9 71 3 5 7-9 82-7 90-2 5 8 900 2-4 6 8-9 11 3",
    ": 5-7 21-37 9-40 2-3 5-52 4-5 7-60 2 4-5 8-76 8-85 7-91 4-6",
    ": 9-8008 15 7-20 2-3 5 7-31 3-4 6-9 43 5-6 8 50 2 5 8 61-4 6 8-70 2-81 3-5 9-91",
    ": 4-7 9-103 5 7-11 5-8 20 2-4 6 9-32 4-5 7-41 3-50 2-7 60-1 3 6-8 71-2 4 6-7 9",
    ": 82 7-8 90 2-5 200 4-6 8-11 4 6-7 9 21-8 31-2 4-7 9 44 6-7 51 3-4 6-60 2 5-6",
    ": 70 3-80 2-5 7 9-90 2 5-8 301 3-4 6-8 10-1 4-21 3 6-8 30-1 3-9 41-2 5 7 9-52",
    ": 6-7 9-61 3 6-8 72 5 8 80-1 3-8 90-6 8-9 401 5-8 10 3 5 7-21 3 7-30 3 7-40 5-8",
    ": 50 2-7 9-61 3 5 7-70 5-80 5-90 3 5 7-501 4 9-15 7-20 2-3 6 8-32 4 6-8 40-51 4",
    ": 6 8-66 8-73 7 9-81 3 6 8-9 91-2 4 7-600 3-7 9-10 3 7-21 3-7 30 2-9 41-3 5-6",
    ": 8-9 51-6 8-9 63-5 70-3 6-8 80-1 3-4 6-94 6 9-702 4-11 3-5 7-22 4-5 7-9 31 3-5",
    ": 7 9 41 4-50 3 6-60 3-5 7-9 72 4-5 7 9 81-4 8 90 2-6 8-804 11 4 6-21 3-7 33-7",
    ": 9-44 6-8 53 5-8 60-8 71-7 9-85 8-91 4-5 7 9-900 2-6 8-9 11-2 5 7-8 20 2 4-6",
    ": 9-31 3 6-9 42-3 5-50 3 5-7 9-60 3-4 6-7 70 2-4 6 8-81 4-7 9-91 5-8",
    ": 9002-7 9-10 3 6-8 22-3 5 7-8 30 2-5 7 9-42 4 8 50-3 5 7-61 3 5-73 5-80 2 4-5",
    ": 90-2 4-106 8-10 2 4-5 7 9 21 3-32 4-6 8 40 3 5-50 2-5 7-9 61-3 6-8 70-80 4",
    ": 6-9 91-3 5 9-205 9 11-9 22-4 6-8 30-2 4-5 7-43 5-6 50 2-4 6-7 9 63 6-9 71 3-4",
    ": 6-80 2-3 5-6 8-9 91-8 300-1 5-9 11-4 6 8-20 2 4-7 9 34-6 8 41-2 5-6 8-9 52-4",
    ": 6-9 62-4 8-71 3-7 9 81-3 7-9 92-3 5 400-6 11 3-7 20 2 4-7 9-30 2 4 7-40 4-51",
    ": 3 5 7-8 60 2 5-8 73 5-6 8 80 2 4-5 7 9-90 2 5-6 501 3-7 10-4 7-22 5-6 8 30-8",
    ": 44-5 9-50 2 5-6 60 3-6 8-74 6 8-9 81-3 5-6 8-94 6-8 600-4 6 8 10-2 6 8-9 21-3",
    ": 6 9 31 3-4 6-7 41-3 5-7 9 51-5 9-63 9-70 2 4-6 8-9 82-7 9-94 7-8 701-5 7-21 6",
    ": 8-41 3-53 5-6 8 60-2 7-8 72-8 80 2 4-5 7-9 91 7-8 800-3 5-7 9 11-8 20-4 6-7 9",
    ": 32-8 40 2 4 6-7 50 3-5 7 9 62 4-5 7-70 2 6-7 9-86 91-3 7 9 902-3 5-10 3 7-8",
    ": 20 2 6-8 31 3-6 8-9 41 3-4 6 9 51 3-8 60-3 5-71 3 5-80 2 4 6-8 90 2-5 7",
    ": 9-80000 2 6-7 9 12-20 6-30 2 5-6 9 41-3 5-6 50-2 4 62 5-72 6-7 9-80 2-3 5-90",
    ": 2 4-6 8-101 4-8 11 3-5 7-20 3 8 30-6 8 40-2 4-6 8-53 6 8 60 2 4-5 7 9-72 4",
    ": 8-9 82-7 92 4-5 8 201 4-11 4 8-24 6-9 31-3 5-6 8 40-5 7-9 51-4 6-8 61 3 5",
    ": 9-72 4 7 9-80 2-7 9-90 5-6 8-300 3-4 6-10 2-3 8 20-3 6-9 31-4 6-7 40 2-51 3-5",
    ": 7-61 3-6 8-74 6 9 81-2 6-92 5-6 8-403 5-9 11-2 4-6 8-9 21-6 8 30-6 9 41-4 6 9",
    ": 51-6 8-61 3-4 6 8-72 4-5 7-8 80 2-91 3-7 500-9 12-22 4 6-7 9-30 2-40 2-4 6-56",
    ": 8-62 5-8 70-3 7 9-80 2 4-6 9-98 601-9 11 3 6-8 20-1 3-9 31-4 6-8 41 3 5-7",
    ": 9-50 2-3 6-7 9-61 3 5-7 9-76 9 84-5 7-9 91-2 4-701 4 6-7 10-1 3 6-8 20-2 5-7",
    ": 9 31-4 6-42 4 8 50 2-6 8-60 2-5 7-70 4-8 80-1 3-4 6 8-9 91-9 801-9 11-6 21-8",
    ": 30 2-4 6-49 51-65 7-8 71-4 8-80 2 5-8 90-1 3-7 9-901 3-5 7-16 9-20 2-3 5 7 9",
    ": 31 4 8-42 4-5 52-4 7-61 3-4 9-71 3-5 7-8 81 3-5 7 9-90 2 4-6 8-9",
    ": 1001 4 6 14 6-7 20-4 30-1 3 7-9 42 5-55 7 9 61-7 70 2 4-7 9-81 3-9 92-4 6-101",
    ": 3 5-9 12 4-22 5-30 2-4 7-8 40-1 3 5 50-1 4-8 60-1 5-75 7-86 8-98 200-1 4-5",
    ": 8-15 7-21 6-9 31-42 4 6-7 9 51-2 4-5 7-60 3-70 2-3 6-7 9-82 4-6 9 91-5 7 9",
    ": 304-5 8-9 11-2 4 7-8 20-3 5 7-30 2-4 7-45 8 51-2 4-9 62-5 7 9-73 5-7 9 81-6",
    ": 8-93 5-6 400-5 11 4-7 9-25 8-9 34-8 40-2 4-56 61-5 8 70 2-8 80-3 5 8 90-1 3-5",
    ": 7-8 501-5 9 11-29 31 3-5 7-9 41-6 8-9 54-65 7-8 70 3-4 6-7 81-90 2 4-6 8-605",
    ": 7 9 11 3-8 20 2-4 6 8-38 40-1 3 5 7 50 3-5 7-9 62-8 70 3-4 7-80 2 4 7-90 2-7",
    ": 9-702 4 8-17 21-5 9-30 4 7-43 5-9 51 3-4 6-7 60-1 7-9 71-5 8 82 5-90 6 8-9",
    ": 802-4 6-10 2 4 7-21 3-5 7-30 2-4 6 8-47 51-2 5-8 61-3 5-8 71 4-5 7-80 4-5",
    ": 8-92 5-6 8-906 9 11 6-7 9-22 4 6-9 32 6-44 7-58 61 3-4 6-7 71-3 5-9 81-4 6-7",
    ": 9-94",
    ": 7-2001 5-8 10-3 5-20 2-5 7 9-32 4-5 7-52 7-62 4 6-7 9 71 3 6-85 7 9 91-2 5-9",
    ": 101-2 4-14 7-9 22 4-9 31-41 3-56 8-9 61-2 4-5 7-8 70 2-8 80-1 4-6 91-5 9-200",
    ": 4-5 7-10 2 4-7 9-20 2-3 6 8-39 41 3 6 50-2 4 6-61 3-4 6 8 70 3 5 7 81-3 5-90",
    ": 2 4-5 7-300 3-5 7 10-1 5 7-8 20-3 5-7 9 31-2 4 42-4 6-7 9 51-6 8-65 7 9-70 2",
    ": 5-6 9-82 4 6-95 7-9 401-15 7 9-23 5-32 5 7 9-45 7-9 53-4 7-60 3-75 80-93 7-8",
    ": 500 2 4-8 11 3-4 6-9 21-3 6-9 32-4 6 8-46 8-51 4-8 61 3-9 71-9 81-2 4-6 8-91",
    ": 3 7 9-600 2-5 7-14 9-22 4-6 8-30 2-3 7-41 3 6-52 4 6-62 4-6 8-71 3 5-82 5-92",
    ": 4-708 11 3-20 2-30 3-4 7-8 41-5 7-54 7-61 4-5 7-8 70 3 7-82 5 7-9 92-6 9-806",
    ": 8 10-3 6 8-9 21 3-5 7 30-1 3-6 8-53 5-6 8-62 5 7-8 70-2 6 9-81 3-4 6-90 4-6",
    ": 901-5 7-12 5-7 9-22 5-8 31-2 4-45 7-55 8-61 5 8-73 6-88 90-2 4-7",
    ": 9-3000 2-13 8-23 6-9 31-3 6-45 8-59 61-6 8-75 7-8 80-2 6 8-9 91-2 4-5 9-102",
    ": 4-5 8-9 12 5-8 21 3 5 7-8 30-2 4-8 40-2 4-9 51-5 7-62 4-9 71 3-9 81-5 7-90",
    ": 3-8 204-5 9-13 7-21 4 7-32 5-49 54-6 9-62 4-7 71 5-6 8-80 3 5 90-8 300-2 4-5",
    ": 7 9 12-20 2-4 7-30 4 9-44 6-64 6-77 9 81-2 7-90 3-5 9 401-3 6-7 10-7 20-8",
    ": 30-3 5-43 6-54 6 9-64 7-8 72-3 7 9 81-2 4-90 3-6 8 500 2-4 6-7 9-12 4-31 3",
    ": 5-42 4-8 52-3 5-62 4-9 71-2 5-7 81-92 4-9 601-5 7 9-10 5-24 6 8-32 6-41 3-4 6",
    ": 8-9 51 4-5 8-69 71-80 2 4 6-8 90-3 5 9-700 4 7-9 11-20 6-7 30-1 4-8 40-2 4-6",
    ": 9-50 3 5 7-9 62-3 7 9 71-5 8 80-1 3-9 91-2 4 6-8 800-8 10 2-20 2-3 5 7-9 31-9",
    ": 41 3 6-9 51 3 5-7 9-60 2-6 8-75 7-83 5-90 5 7-900 2 4-8 11-2 4-5 7-8 21-2 4-7",
    ": 30-2 4-8 42 5 8 50-2 5-6 8-62 6-71 7-9 81-3 5 8 95-9",
    ": 4006-7 10-6 8-26 9-31 3-49 52 4-8 61-71 4-9 81-2 4 6-9 92-5 7 9-107 10-5 7",
    ": 9-24 7 30 6-9 41-9 54-6 8-64 6-9 72 4-5 80-1 4 7-95 7-201 6 8 12-3 6-25 7-34",
    ": 6 41-4 9-50 3-4 6-7 60 4-9 72-81 4 8 91 3-4 6-7 9-300 2-6 9-15 7-21 3-6 8-9",
    ": 34 40 2-3 7 9-54 6-67 70-3 6-80 5 7-94 6 8-9 401-6 8-14 6-7 20 2 4 7-33 5-8",
    ": 41 3-50 4-8 60 2 4-5 7-70 2-8 80 3 6-92 4-6 502-4 8-10 4-9 23 9-30 2-6 40-6",
    ": 9-50 2-3 6-9 61 3 5 8-71 3-4 6-8 82 4-97 9-601 3-12 4-7 21-2 4 6-7 9-30 2-5",
    ": 40-5 9-65 7 9-71 3 5-7 80-2 5-93 8-702 5-7 10-1 3 5 7 20-1 5-30 2-40 2-4 6-7",
    ": 9-52 4 6-7 62-5 7-9 73 5-8 80-1 3-4 7-94 7-801 3-4 7-10 2 5 7-9 21-3 6 9-32 5",
    ": 7 9 41 4-5 9-56 8-63 5-8 70-9 81-4 8 91 4-6 8-9 901 3-4 6-7 9 12-3 6-8 20 2-6",
    ": 8-30 2-9 42-3 5 8-68 70-6 80-2 4-5 7-93 5",
    ": 7-5009 11-4 6-8 21-3 6-32 5 8-9 41-9 52-8 60 2 5-6 8-71 4-8 80-90 2-4 6-102 8",
    ": 12-8 20-1 3-8 30-1 3 9-41 3-9 51-2 4 6-9 62-6 8-9 71 4-5 7-80 3 6-9 91-2 4-5",
    ": 202-7 9-16 9-23 5-7 34-5 9-46 9-51 4-6 9-62 4 6-70 5-6 8 80-4 8 90 2 4-6",
    ": 8-300 2-4 6-9 11 4-5 7-24 6 8-30 3 6-44 6-50 2-61 3 5 73-5 7-8 80 2-3 6-8",
    ": 90-1 3-6 401 4-6 9-11 3-8 20-4 6-30 2 5-6 8 40 2-4 6-7 50-3 5-60 3-6 8-9 71",
    ": 4-9 81 3-4 6-91 3 5-6 9-501 4-5 7-8 10-20 4-6 8-31 3-6 8-40 2-4 7-50 3 5-66",
    ": 8-73 6-80 2-8 92-601 3-6 8-9 12-3 6-8 21-2 5-9 31-3 5-7 9-41 4-5 8-63 5-8 70",
    ": 2-4 7-80 4-8 90-2 4-6 8-700 2-6 8-17 21 3-4 6-7 9-32 8-47 50 4-70 2-4 6-82",
    ": 5-8 90-1 3-4 6-8 800-8 10-1 3-25 8-31 3-4 7-9 41 3 7-51 3-8 60 4 6 8-9 72-3",
    ": 5-8 80 3 5 7-8 90-902 4-6 9 11 3-6 8 20-35 8 40 2 6-56 60-3 5 7 72 5 7 9 81-3",
    ": 7-90 3-4 7-8",
    ": 6000 2-3 12-4 6-8 22-4 7 9-31 3-4 6-8 40-3 5-6 9-50 2-8 61-6 8-81 7-8 91-5",
    ": 100 4 7-8 10-1 3 6 20 4 7-30 2 7-46 8 51-61 5-7 70-2 4-81 4-5 7 9-90 2-3 5-9",
    ": 201-3 5-9 12-3 5 7 9 21-2 5-31 3-4 6-7 42-4 8-50 2-3 6-8 62 4 8-9 75-7 9 82-8",
    ": 91-3 6-7 9 301-2 4-5 8 10 4-6 8-9 27-9 31-2 7-42 4-7 9 51-6 9 61-3 5 70-5 9",
    ": 82-3 8 90 3-6 8 401-3 5 9 11-5 9-21 3 5-6 8 30 2 4-6 8-41 3-6 50-2 4-8 64-5",
    ": 7-70 2-4 7-8 80-1 5 7-8 90-1 5 7-9 501-3 5-16 8-21 3 5-7 30 2-4 9-41 6-8 50-2",
    ": 6-61 3-4 6-71 4 6-7 80-2 6-7 92 4-5 8-601 4-7 9 11-2 6 8-28 30-1 5-7 9 43-5",
    ": 50-5 7 60-4 7-8 70-3 8 80-9 91-4 6-8 702 4-5 7-11 6 8-21 3-7 9 33-9 42-4 9",
    ": 51-2 6 8-9 63-6 9-80 3-4 6-8 92-3 5 8-801 3 7-8 10-6 9-22 6-9 32-5 8-9 43 6 8",
    ": 50-1 3-6 60-1 3 5-70 2-5 7-8 80 2-3 9-94 6-9 902 5-6 8-9 11-5 7 9-21 3-7 9",
    ": 31-4 7-41 3-4 6-9 51-5 7-61 3-75 7-82 5-7 9-97",
    ": 9-7001 5-10 3 9-22 4-5 7-32 4-7 9-43 8-50 2-5 8 60-1 3-7 70-1 4-7 9 86-9 91-4",
    ": 8 100-1 3-6 12-3 5 8 21-2 4-7 31-2 4 40 2 4-7 9-51 5-8 60-2 5-7 9-77 9 84-5",
    ": 7-97 200-2 4 10-1 3-29 35 40-2 4-6 8 51 4 6-8 62 4 8-70 2 6 8-9 82 5 7-93 6",
    ": 8-9 301 3-4 7-9 12 7-9 22-3 5-9 31-9 44-7 52 5-6 8-61 6-7 9-71 4 6-9 81 4 6 8",
    ": 93 5-8 403-7 9 11-5 9 26 9 31 5-7 40 2 4-5 7-9 51-2 4 6-7 9-65 7-70 4 7 9-94",
    ": 6-506 8-9 11-3 6-21 3-30 2 4-5 8-48 50-5 60-1 3 7-8 73-5 9 93-4 6-7 9-603",
    ": 5-10 2-3 5 7-22 6-8 32 4-7 40-1 8-9 51 5 7 9-60 5-8 70 2-4 9-80 2-3 8-9 92-7",
    ": 9-701 5 9-12 8 20-3 9-34 6-8 41-51 3 5-7 61-9 72 4-6 8-9 84 8-98 800-1 4-7",
    ": 10-3 5 7 21-4 6-32 4 6-9 41-2 4 9 53 5-8 61 5-70 3-83 6 8 90 4 6 8-900 3-10",
    ": 5-6 9-22 8-31 4-6 8 41 7-51 7-8 62 5-9 75-8 80-1 4-8 90-6",
    ": 8-8002 4-7 11-6 8-22 4 8-9 32-6 40 3 54-62 4-71 3 5 9 81 3-6 8 92-3 5 8 100-4",
    ": 6 15-7 23 6 30-1 3 5 7-40 2 9-55 7-65 8-9 71 4-80 4 8-9 91 3-7 202 4-5 7 10-4",
    ": 7 9-21 3-7 30-2 4-5 7 41-4 6-7 50 2-60 3-5 9 71-3 80 5-6 8-9 92 4 7-8 300-3",
    ": 8-10 3-8 20 2-9 32-3 7-8 40-3 6-7 50 3 5-6 61 3-5 7 9-70 6-82 6-8 92-3 5-401",
    ": 4-5 9 15 7-8 21-4 7-36 9-46 9-51 3-6 8-9 66-9 71 3 5 7-81 5 7-8 91-6 8-9",
    ": 501-2 7 11 3-5 8 20 2-5 9 31-5 7 43-5 8-9 56-9 61 6-70 2-3 6-81 3-4 6 9-91",
    ": 3-5 8-601 4 10-2 4 6 8-9 21 3-4 6-34 6-8 40-3 6-9 52 4 6-7 60 2-6 8-76 80-7 9",
    ": 93-6 8-711 3 5-6 9 21-2 4 6-8 30-1 3-8 40-1 3-4 6-7 9-51 4-6 8-63 5-7 70-1 3",
    ": 5-7 9-84 6 8 90-1 4-6 8 803 6-14 7-21 3 5-7 31-2 4-9 41-4 6 8 51-4 6-9 63-72",
    ": 4 7-80 2 4-6 8 91 4 6-7 9-901 3-5 7-10 3 6-9 21-7 9-32 5 7-9 41 5-7 9-50 3-5",
    ": 7 9-60 2-4 7 70 2 4-5 7-9 81-4 6-8 90-1",
    ": 8-9007 9-10 2-4 6 8 21-6 8 30-1 4 7-43 5-8 55-61 3-5 70-1 4-81 4-8 92 7-8",
    ": 100-1 5 7-8 10-1 5 7 20-2 6 9 31-2 4-6 40-1 4 6-62 4 7-9 71-4 6-7 9-80 2-4 7",
    ": 9-91 3 5-8 201-6 8-9 11 3-7 20-2 4 6-8 30 2-4 7-8 40 5-6 8-9 52-3 6-7 9-62",
    ": 4-7 9-73 5-6 81-2 4 7-9 93 6-9 301 3-6 8-10 2-5 8 20 2 4-6 8-9 31-2 40-1 4 7",
    ": 9-50 4-7 9-62 4-7 70-3 5-80 5 7 90-1 3 8-9 401-9 11 3-6 20-1 3-4 8-9 31-2 4-6",
    ": 8-40 2-3 5 7-8 51 6 9-64 9 72 5-7 9-81 5-6 8 90 2 5 9 501-2 4-7 9-14 7-20 2",
    ": 4-6 32-4 6-7 9 41 3-4 7-8 50-7 9 61 3-4 7 74-6 8 80-2 4-5 9-91 3 7-600 5 7 9",
    ": 11-2 4 6-8 20 2-33 5-7 40 4-53 5-8 62-7 71-5 7-9 83 5-6 9-98 700-1 3 5-6 8",
    ": 11-2 4 6-21 5 7 9-31 3-40 3-4 6 8-51 5-64 8-70 3-4 6 8 82-3 5-6 8-9 94-6 9",
    ": 802-21 3-4 6-38 41 6 8-51 6 64-5 7-8 70-1 3 5-9 81 3-5 7-8 90-3 6-8 900 4-5",
    ": 7-11 4-6 8 21 4-7 31-3 6 8 40-2 4 6-7 51-2 5-7 9 61-2 5-7 70-4 9 84-5 7-9",
    ": 95-90003 6-8 11-5 7 9-20 3-6 8-37 40 2-3 5-8 51-8 60 3 5-7 70 2 4-8 85-6 8-90",
    ": 2-4 6-7 9 101-5 7-10 2-20 2 5-7 31 3 8 43 5-6 8-50 2-4 6 8 60 2-6 8-70 3-4",
    ": 6-9 81-6 8-92 8-202 6-7 11 5 8-9 21 4 6 30-2 5-7 42 4-6 8 51-3 6-7 60-2 5-6 8",
    ": 71-8 82 4 6-7 9-91 3-5 7-9 301-2 6 10 3 5-7 9-20 2-3 6-33 5-9 41 3-4 6 8-52",
    ": 6-61 4 6 8 71-3 8-90 3-9 402 4-5 7 9 12 6-20 2 4 7 30-2 4-6 40-4 6-50 2-4",
    ": 8-60 3-5 7 9-70 2 4-5 8-9 81 8-93 5-8 500-5 7 10-1 3-6 9 24-6 8-9 32-5 9-40 2",
    ": 5-50 4-5 63-4 6 70-6 9 81-4 8-90 2 4-7 9 601 4-5 8-14 8-23 5 9-30 3-5 7-42 5",
    ": 7 50 2-3 7-8 60 2-3 5-7 9 71-3 5-7 9 84-94 6-702 4-12 4-5 7-23 5 7-8 30-1",
    ": 3-41 3-4 6-7 51-5 9-61 5-6 8-9 74-81 3 6 9 91 3-5 7 801-2 6 8-10 2-4 9 21 4-5",
    ": 8-9 31 4-6 8-42 4 8-9 52 4 6 8-9 61-2 4-6 8-9 72-5 7 80-1 4-6 8-9 91-4 6-7",
    ": 902-6 8-9 12-8 22-7 9-30 2-3 5-41 3-5 7-50 3-4 6 9 61 3-4 6 8-9 72-3 5 7 9-80",
    ": 2 6-7 91-4 6",
    ": 8-1003 5-6 8-14 8 22-3 7 9 33-5 7 40-2 5-55 9-61 3-6 8 70-5 7-81 4-93 5-6 8-9",
    ": 101-3 5 7-8 12-20 2-6 8 30-3 6 40-2 5-7 9-50 5-7 9 61-2 4-6 70-80 2-3 5 7 9",
    ": 91-7 9-200 3 5-6 9-14 7-9 24-30 2-4 6-8 40-4 6-52 4-5 8-64 7 70 2-6 8 81-4 6",
    ": 9 92-3 5-7 9 301 3-13 6-7 20-1 3 7-34 7-41 3-4 6-7 50-3 6-61 4-72 4 6-9 83-5",
    ": 8 92-4 7 401 3 5-8 11-2 4-6 8-9 21 4-6 8-31 3 5 7-9 43 5 7-50 2-3 5-6 9-66",
    ": 8-9 71-2 4 6-85 7-8 91 4-8 500 4 6 9-11 3-5 20 2 4 6-8 30-1 5-7 9 44-6 8 51-4",
    ": 6-8 60-1 3-4 9-70 2 4-9 81-2 4 6-602 4 6-7 10 4 6-8 21-5 7-8 30 3 7 9 41-51",
    ": 3-5 7-9 62-4 6 72-3 5 80-1 3 5-6 8 91-4 7 702-7 13 5-8 20-5 7 9 31-5 7-8 42-4",
    ": 6-9 52-65 7-8 70-3 6 80 2 4 6 90-3 5-7 802 4 6-7 10-4 6-26 9 34-7 40 2 5 7",
    ": 50-1 3-5 7-8 60-2 4 8 72-7 9 81 3-5 8-96 8 900 2-3 5-6 8 11-4 7-9 21 3-5 8-30",
    ": 3-5 7-8 40-2 4-51 3-4 6 9 61-3 5-9 71-8 80-1 3 5-6 9-96 8-9",
    ": 2001-2 4 8 10 2-3 5-6 8-24 6-32 4-6 8-45 7-53 5-73 5-6 9-80 3 6-7 92 9-100",
    ": 6-11 4-5 7-21 3-5 8-9 33-8 40 2 9-52 4 8-61 4-5 7-8 70-4 7-80 3-4 6-9 91 3-4",
    ": 7-8 202 4 6 8 10-1 3 7-21 4-5 7-8 30 2-3 5 8 41-3 7-54 8-61 3-4 7-71 3-6 8",
    ": 80-5 7-8 90-3 5-9 302 5 7-9 11 3-4 6-21 4-8 30-4 7-41 5 7-54 6-9 61-70 2-3 5",
    ": 7 9-81 4-6 8 90-2 4-5 7 9 401-5 9 11-4 6 9 23-9 31 7 9-43 5 7-55 8-9 63 5-6 8",
    ": 70 3-4 8-9 81-2 4 6 8 90 4-5 501-3 5-6 11-2 4-5 7-8 20-2 4-5 9-32 4 8 40-4 6",
    ": 50-1 4 6 9 61-3 8-9 72-3 6 8 80-3 5 8-90 2-5 7-8 600 2 4-5 9-10 3 5 8 20 2 4",
    ": 8 31 3 5-9 41 4-6 9-52 4-7 9-60 2-3 5-70 2-8 80 2-91 5 9-702 4 6-8 12-4 6-7",
    ": 20 3-30 2 5-6 9-42 4-5 7 9 53-4 6 8-9 62-5 7-71 3-5 7-81 4-8 91 4 8-809 11-8",
    ": 21-2 4-9 33-4 7-9 42-51 3 6-7 9-66 71-5 7-80 3-4 6-8 90-4 6-8 900 2 4-5 7-8",
    ": 10-1 4-5 7 9-25 7 9-30 2-6 8-9 41 4-9 51 3 5 7 62-5 8 72 4-5 8-9 81-2 4-5 7",
    ": 90 3-4 9",
    ": 3001-6 8 11-3 5 7-21 3-4 6 8-9 31-3 7-40 4 7-56 61 5-6 8 71-5 8-80 2-3 5-6",
    ": 8-91 3-9 101-7 9 11-4 6-7 20-3 5-6 8-30 3-7 9-44 6-9 51-4 6-8 60 2-70 3-9",
    ": 81-2 4 6 8-90 2-6 8-9 201 3-4 6-7 9-18 20 2-3 8 30-4 7-8 40-1 3 5 8-9 51-2 4",
    ": 8-61 3-4 6 70-1 3 5-6 9 83-4 6-8 91 3 5 7 300-9 11 3-7 20-2 4-6 8-33 40-4 6",
    ": 8-52 6-7 9-60 2 4-8 70-6 8-9 83-8 91-9 401-2 5 8-9 11-2 4-5 7 9 21 3-5 8 32",
    ": 4-5 7-48 50 3 5 7 9-63 5-6 75-6 8 80-5 7-8 90-1 4-500 2-3 6 8-13 5 7-20 9-32",
    ": 9-42 4-6 8-9 52-8 61 3-5 8-71 3-6 8-9 81-5 7-8 90-3 5-6 8-9 602-4 6-8 12-4",
    ": 6-7 21-5 30-2 4 6-40 2 4-6 9 51-3 6 8 60-6 9-81 3-7 9-90 3-6 9-703 5 7 11-3 5",
    ": 7-20 2-7 9-31 5-7 9-41 3-9 52-60 2 4-71 4 6-80 2-4 6-7 9 91-5 8-800 2 4-9 12",
    ": 4 9-21 3-6 8-32 5 7-42 4-9 51 3 5-7 9-61 3 5-7 9-75 7-8 82-5 7-9 91-2 4 6-904",
    ": 6 8-9 13 5-6 9-21 5 7 31 4-5 7 40-2 4-6 8-50 3 5-60 2-3 6 9-70 3-7 9-82 4 6 8",
    ": 90 2-5 8",
    ": 4001-4 6-10 3 5-7 21 4 6-35 40-1 3 6-8 50-1 5-7 9-61 4-7 9-74 9-80 2-6 8-90",
    ": 3-4 6-8 102 4-6 8-14 6-7 9 24-6 9 31-2 4 7 40-2 4-5 7 9 54-8 60-9 73-6 8-82",
    ": 4-5 7-92 4 6-201 3 6-8 13 5 7-8 21 3-4 6 8 30-7 9-43 6-7 9-52 7-8 60 2-3 5-9",
    ": 71-2 5 8-83 7-8 90-7 9-300 2-3 6-13 6 8-21 3 5-7 9-35 7 9 41-2 4 6-50 2 4 9",
    ": 61-3 5-6 8 71 3 5-6 8 80 3 7 90-6 9-403 6 8 11-2 5 9-23 5-6 9 31-5 8-41 3-4 6",
    ": 8 51 4-6 8-65 7-9 73-7 9-82 4-5 7-94 6 8-501 3 5-7 12 7-9 22-9 31-4 6-9 42 4",
    ": 7 50-1 4 6 8-60 2-3 5 7 70-81 3-8 90 2-5 8-600 3 8-11 9-28 30-1 3 5-8 40-1",
    ": 6-50 2-3 5 7-9 62-7 9 71-2 4 6 8-81 3 5-91 3-5 7-8 700-1 3-7 11 3 6-23 5 30 2",
    ": 6 9-40 2 4 6 8 50 3 5 9-66 8-70 2-5 7-80 2 6 8-9 92-4 7-800 2 4-5 7-8 10-1 3",
    ": 5 8-22 4-7 30 2 5-8 40-1 3-6 50-1 3 5 9-60 2-5 9-70 2-80 2-5 90-2 4-6 9 901",
    ": 3-6 8-11 4 6-9 21-2 4 6-9 32-6 9 41-2 4 6 8-55 7 9 61-3 5 8-70 5-6 8-83 5-7",
    ": 9-90 5-6",
    ": 9-5001 4 7 9 11-8 20-2 5-7 9 31-3 6-7 40-1 3 5-7 9-50 2-4 6-8 60-4 8 70 2-3",
    ": 5-6 8-82 5-95 7 101 3-6 10-7 9-20 2-4 6 9-32 4 7-8 41-3 7-8 50-3 5 7-60 2 8",
    ": 72-4 6 8-81 3 5-7 92-3 5 7-201 3-11 5-9 22 4-5 7-8 30-1 4 6 8-42 5-7 9 51-3",
    ": 5-7 60-3 6-73 5 8 80-6 9-91 3-4 6-7 305 8-20 2-3 5 7-9 31 3-4 8-41 3-4 7-8 52",
    ": 5-63 5 7 70 3-5 7-81 4 7-9 91-5 7-8 400-1 4 6-8 11-2 4-7 24-8 30-2 5-6 8 40-6",
    ": 50-5 7 9-61 3 5-7 9 71-2 4-5 7-9 82-91 4-6 8-501 4-6 8 11-3 5-9 23 5 7 9 31",
    ": 3-4 6-8 41 3 7-8 50-1 5-7 60 2 4 6-8 72 8-9 81 3-4 6-8 90 2-3 6-9 601-5 7",
    ": 12-9 22-3 5-8 32-5 8-9 41 3-7 9-60 2-9 73 6-9 82-6 8-93 5-701 3 5-7 10 2-3",
    ": 5-24 7-36 9 43-7 9-50 2 4-5 7 60-5 8-9 71-9 81 3-5 7-90 2-3 5 8 800 2-5 8 11",
    ": 3-4 7-8 20 2-4 7-30 2-5 7-8 40-1 4 53-4 8-9 62-3 5-7 70 2-4 6 8 80-3 6 8-95",
    ": 7-8 900-1 3-4 7-10 3-4 20 2 4 6-9 31-6 8-9 43-6 8-50 3 5 7-63 5 7 70-4 6 9",
    ": 81-8 91 4-9",
    ": 6002-5 7 11-2 6-25 7 9-30 4-6 8 40-2 4-5 7 50-2 4-7 60 2-3 6-70 5-6 8 82 6-90",
    ": 2 4 6-9 104 7-8 10-3 5 9-20 6-7 30 2-5 7-41 3-8 50-2 4-5 7 9-64 6-8 70-5 7 9",
    ": 81 3 6-7 91 4-200 2-5 7-11 4-8 24-5 7-8 30-1 3-7 9-40 3 5 8-51 3-9 61 4-7 70",
    ": 4-5 8-81 4-5 7 9-95 8-307 9 12-4 6-22 4 6-31 3 5-44 6 8 50-1 3-4 8 60-3 5",
    ": 7-71 3 5-6 8-80 2 4-7 90-1 5-6 8-9 402-3 5-6 8-13 5 7-22 5 7-8 30-5 7 9-41",
    ": 3-5 7 9-50 4-9 61-4 7-70 3-4 6-86 8-91 4 7-8 502 4-5 7-12 4 7-22 7 32-5 9-41",
    ": 3-6 9-52 4-7 9 61-2 5-70 2-4 6-8 80-3 5 8-90 2 4 6 8 600-11 3 5 8-22 4-6 9-31",
    ": 3-44 6-7 9-50 3-6 8-61 3-6 8-75 7-81 4-5 7-91 3 5 8 700 2-4 8-11 5 7 21-2 4-6",
    ": 9-30 2-7 40-6 8-51 3-4 6-8 62 5 8-70 3-9 81-3 5-8 90-4 7-805 7 9 13 5 20-3 5",
    ": 7-8 30 3-5 8-42 4-7 9-50 2 4-7 60-1 3-4 7-71 3-5 7-8 80-1 3 5-6 8-91 3-7 9",
    ": 901 4-5 7-9 13 5-6 8-9 21-8 30-1 3 5 7-9 41 6-9 51 5-7 60-3 8 70 2-5 7 9-81 3",
    ": 5-7 90-1 4-6",
    ": 9-7001 4 6-11 4-24 7-30 2-44 6-7 9-54 6 9-68 70 2-3 5-8 80-5 7-9 91-5 7-9 102",
    ": 4-6 8-13 6-20 2-33 5-6 41 3 5-6 8-9 52-3 5 8-67 9-76 9-83 5-9 91 4-6 8-205 7",
    ": 16 8-20 3-7 31 5-40 2-3 5-7 53 5 7 61-3 5-8 70-2 4 6-81 3-6 8-92 4-6 300-2 4",
    ": 6 8 11-2 4-7 9 21 3-4 6-8 30-4 6-7 9-44 7 9-56 8-9 61 3-7 9-70 3-7 9-83 5 8",
    ": 90 2 7 9-404 6-7 9 11-2 4-7 9 21-2 4-8 30-3 6-8 41 3 6 9-51 3-6 8 63-7 9-70 2",
    ": 8 81-4 6-8 90-2 5-7 9-502 4 6-7 9-11 3-4 7-9 21-2 4-33 5-7 9-46 8-50 3-4 8",
    ": 60-3 5 7-70 7 9-91 3 5-606 8-13 5 7-9 21 6-8 30-3 5 7 9-40 3-7 9 51-2 4-5",
    ": 7-64 6 8 72-3 6 8 82 5 7 9-90 2-3 5 7-8 700-2 5-14 6-8 20 2 4 6-9 32 4-40 2",
    ": 4-7 50 4-5 7 60-6 8-9 73-4 6 80-2 4-5 7 9-91 3-6 8 802-5 9-12 4 6 8-23 5 7-32",
    ": 7-44 6-7 50-2 4 7 60-2 5-6 8-9 71-80 3-4 7-9 92 5 8-908 10 2-4 6-9 21 3-33 5",
    ": 7-42 4-5 7 9-50 3 5 7-60 3-5 7 9-70 2-4 9-81 5 8-90 3-4 6-7",
    ": 9-8001 3 6-7 9-10 2-3 7-8 20 2-5 8-32 4-7 9-44 6 8-50 3-5 8 60-3 6 8-70 4-5",
    ": 7-81 3 5-7 9-101 3 6 8-11 3-4 7-21 3 5-6 8-9 31 3 5-7 9 41 4 7-55 7-9 62-3 5",
    ": 7-9 73 5-6 8 80-1 3-7 90-1 3-5 7-8 200-3 8 10-1 3 5 8 20 4 6 8-30 2-3 5-7 9",
    ": 42-3 5 8-9 51 3-4 6-61 3-6 9-72 4-8 80-3 5-6 9-91 4 6 8-303 6-9 11-3 5-9 21-4",
    ": 6-7 9 34-9 41-4 7 53 6-61 3 5-6 8 70-2 5-8 82-3 7-91 3-7 9-401 3 5 7 11 3-4 6",
    ": 8-23 5-6 30 2-4 6-40 4 6 8-54 6 8-9 61-7 70-1 3-5 9 81 6-90 2-4 7 500-1 4-7 9",
    ": 14-9 21-3 6 31 3 6-8 40 2-5 7-8 51-4 7 9-62 4 6-7 9-72 4 7-8 81-2 5 9-602 4",
    ": 7-8 10-1 3 5 7-9 21 3-35 7-9 42-3 6-54 6-8 60-6 8-71 3 5 7-8 82 4 6-7 9-91",
    ": 3-4 6-704 6-9 11 3-21 5 7-8 30 2-6 8 41-2 4 6-7 9-53 6-8 60-3 5-8 71 5-7 9",
    ": 82-3 5-9 91 3-9 801-7 9-17 21 4-8 30-2 6-8 41 3-9 51-9 61-5 7-74 7 9-83 5-8",
    ": 90-1 3-900 2 4 6 8-11 3-20 2-30 2 4-7 41 5 7-9 51-2 4 6 9 62 6 9 71 3-4 8-9",
    ": 81 3 5 8-90",
    ": 2-9002 8-9 13-6 8 20-2 4 8 30 4-7 41 3-8 50 4 7 9-60 2 4 7-9 71-2 4-7 81 4",
    ": 7-8 90 3-5 7 101-2 4 6-7 9-10 2-21 4-8 32-3 6 8-9 41-5 7-9 52 4 6 8 60-3 5-7",
    ": 9-70 2-4 7-80 2-4 6-9 99-204 6-10 3-7 21 3-4 6 8-35 8-41 3-4 6 51-3 5 8-9",
    ": 61-4 6 9-72 7-9 81 4 6-7 9-93 5-6 8-300 2 6 8 10-6 9-21 4-7 31-5 7 9-40 2-4",
    ": 6-8 50-7 60 2 4-5 8 70-1 5-6 80-1 3-4 6 8-90 2 4-6 8-9 401 4-7 9-19 21-3 9-30",
    ": 2-4 7-9 41-2 4-6 8 50-2 4 6-9 62-8 70 4-83 5 7-9 91-5 7-9 501-8 11 3-7 9 21-3",
    ": 5 7-33 5 7-8 40 4-5 7-55 7-9 62 4-8 70-1 5-6 8-80 2-4 6 8-9 92-6 600-3 5-6",
    ": 8-9 12-3 5-6 8 20-4 6-7 32-3 7-8 40-3 5-53 5 7-8 62 4 7-9 71 4-9 82-3 7-93",
    ": 5-6 8 700 3-6 8-11 3-4 6-8 21-4 8-30 2 4-8 42 4 6-7 52-7 60 2-6 8-9 71 3-5 7",
    ": 80 2-4 6 8-95 7-800 2-3 6-10 2 5 7 9 22-3 5 7-33 6-40 2 5-50 2-5 7-8 60 3-4",
    ": 7-8 71 4-5 7 82-3 6-9 91-7 9-901 3 5-7 10-3 5-8 20-2 4 6-7 30-5 7-40 2 5 7-8",
    ": 50 3-60 2 6-8 70-1 3-5 7-82 4 6-8 90-4 9",
    ": 400001-4 6-10 2 5-8 22-4 6 9 31-6 9-48 54 8 61-5 7 71 3-7 80 2 8 90 2-5 7 100",
    ": 2-7 9-11 5-9 22-4 6-9 31 3-6 9 41-2 5 50 2-7 60 2-5 70-1 3-8 83-8 91-7 200-7",
    ": 10-3 5-6 8 20-1 4-8 31-2 4-5 8-42 5-6 50-1 3-9 61 8 71-3 5-81 3-6 8 90-3 6-7",
    ": 9 302 4-5 8-13 6 20-1 3-8 30-2 5-6 8 40-1 3-53 5-7 9-60 3 5-6 71 4-9 82-3 5-6",
    ": 8 90-1 4 6-7 9 401-3 7-8 10-5 7-25 8 35-7 9 42 4-6 8-50 4-6 8-9 63-5 8-9 71-5",
    ": 7-80 3-7 9-90 2-5 7-9 501 4-7 9 11-3 5-6 8-9 21 4-7 30-3 5 9-42 4-6 8-55 7",
    ": 61-3 5-72 4-7 9 81-2 4 90-603 5-8 10 2-3 6-7 9-20 4-9 32-3 7-42 4-6 8 50-2",
    ": 4-5 7-63 5 7-9 71-2 5-6 9-80 2 6 8-9 94-5 7-9 701 4-9 12 7 9-20 2-4 6-34 7-8",
    ": 41-6 8-54 7-60 4 6 8-9 72-80 2-9 91 3 5-6 8-9 801-3 7-10 2-5 7 20-3 8-9 31",
    ": 3-8 40-3 5-7 52-3 5-65 7-8 71-4 6 8-82 5-6 8 90-1 5-7 9-907 10-5 7-8 20-6 8",
    ": 30-4 8-42 4-9 51-2 4-9 62-4 6-9 72-8 80-1 3 5-8 90 3 5-6",
    ": 8-1001 3 5 7 9-11 4-6 9 24-6 30-1 3 6 40-3 9-50 3-4 6-7 60-8 70 2-5 8-80 2-91",
    ": 3 5-7 9-103 6 9-10 3 6-9 23-5 7 9-30 3-43 5-58 61 4-6 8-71 5 7-85 7-94 7",
    ": 9-202 6-7 9-13 6-7 9-20 2-5 30-3 5-45 7-58 60 2-3 5 7-9 71-3 5-8 83 5-6 8-9",
    ": 92-300 2 4-13 5-8 21-3 6-7 9-33 6-9 41-2 4-6 50 2-3 6-64 6 8-70 5-8 80 5 7-9",
    ": 91-2 4-5 9-400 2-13 5 7-8 20-3 6-7 9-30 3 5-6 8-40 3-5 7-9 51 3-7 60 4-7 9-81",
    ": 3-5 7 9-92 4-6 8 502-3 5-6 8-9 13 6-7 9 22-30 2-5 7-9 41-2 4-7 9-50 2-5 7",
    ": 9-61 3-9 71-2 5-7 81-2 5-6 8 90-3 5-7 600-1 4-14 7-8 21-4 9-31 4 6-7 9-40 2-4",
    ": 6 9-54 6-70 2-3 5-80 2-6 8-9 91-3 6-703 5-6 9-12 4-5 7-8 20-1 3 5-30 2 4 6-7",
    ": 41 3 7 9 51-2 6-8 60-2 5-9 71-2 4-9 81-2 4 6-90 2-6 9-800 2-6 8-9 11-2 4-5",
    ": 7-9 22-4 7 9-33 5-6 9 41-2 5-6 50 3-62 5-8 70 3-4 6-9 81 5-96 900 2-7 10-2",
    ": 4-5 8 20-1 5-9 31 3-45 8 50 2-6 9-64 6 9 72-4 7-82 4-6 8-93",
    ": 6-2000 2 4-5 9-10 3-5 7-21 3-4 8 31-6 40-3 5-7 9-50 2 6-60 2 4-5 7-8 77-9 81",
    ": 7-90 4 6 8-101 4 6-8 12 4 6-20 7 9 32 4 7 42 6-8 50 5-6 9-61 3-5 7-73 5-6 8-9",
    ": 81-6 8-9 91 4-7 202 4-6 9 12-5 7 20-6 8-33 5-6 41-4 6-7 51-3 5-60 2 4-6 8",
    ": 70-3 7 9 81-90 2-7 301-5 9-10 2-4 6-20 3-7 9-39 41-4 6-8 52 4 6-9 61-5 8-70",
    ": 3-83 5-8 90-2 4-9 402 4-5 8-9 11-6 8 20-2 4-5 30 2-3 5 7 40-4 6-7 9-55 61 3-9",
    ": 73 5 9-82 5-6 8-91 5 9-504 6-8 11-2 5-7 21-2 7 32-4 7 42-6 9-58 64-71 3-83",
    ": 5-9 91-7 9-604 7 9 13 5-7 9-22 4-9 31 3-6 8-51 3 5-6 8 60-6 70 4 6-8 81 4-94",
    ": 6-8 702-5 8-10 4 6-7 9-20 4 7-31 3-6 8-40 2-6 9-58 60 2 71-3 6 8 82 4-6 8-91",
    ": 3-802 6-10 2 8 22 7 9 31 3 7 40 3-4 7 9-53 6-60 3-4 6-70 2 6 8-84 6 91-5 7-8",
    ": 900 3-4 6-7 12-4 6-7 9-21 3-31 4-6 8-43 5-7 9-50 2 5-62 4-5 7 9-71 3-5 7 9 82",
    ": 4-5 7-9 91-2 5-9",
    ": 3002 5-6 11-4 6-7 9-20 5-7 9-34 6 40 2-5 9-53 6-62 4 6 8 70-3 7-83 8-93 5-100",
    ": 2 4-9 11-3 5 7-25 8-9 35 8-40 2-3 5 7-50 4 6-9 62-6 8 70 3-4 8 80-6 8 90-2",
    ": 5-200 4-6 11-4 6-9 23 5 7 9-30 2 5 7-8 42-8 50 2-6 60 2 5-8 74 6-8 80-2 4-91",
    ": 4-301 3-4 6-7 9 11-2 4 6 9-22 5-7 9 31-2 4-40 2-4 8-50 2 4-6 9 63-6 9-75 7",
    ": 9-85 9-91 4 6-8 401-2 4-5 7-12 4-5 7 20-8 30 3-4 6-7 40-3 5-6 9-56 9-64 6-9",
    ": 71-4 6 82-3 7 90-1 5-6 8-502 5-8 10 2-5 7-8 20 2 4-6 8 30-2 5-6 9-41 5 7 9-52",
    ": 4-5 8 62 5-6 8-9 71 6-8 80-6 8-91 4-5 7 600-29 31 3-44 7-8 50-3 6-9 61-5 8-72",
    ": 4 7-80 4 6-9 91-8 700 2 7-13 5-8 23 6 8 31 3 45-7 9-50 2-4 6-7 60-1 4-8 71-2",
    ": 9-82 6-9 91-801 3 7 10-5 25-6 8 32-5 7 9 46-53 6-65 8 72-3 84 8 91-9 901-2 4",
    ": 7 9-10 2 5-9 22-5 7-35 9-41 4 7 51-5 7-65 8-70 2-5 7-82 4-5 7-9",
    ": 91-4000 2 4 6-13 6-21 3 6-9 31-3 5-7 9-40 4-5 7-8 50-4 6-8 60 2 6-8 70-2 6-8",
    ": 80 2-5 7-8 90-3 5-7 100 2-6 8 13 5-6 27-35 8-43 8-50 2-5 8-9 65-8 70-1 4-90",
    ": 2-8 201-2 4-10 3-6 8 20-9 34-41 3 5 8-51 5 7-61 3 5-8 71-2 4-8 80-90 3 301-3",
    ": 5-6 9 11 3-4 6 8-9 21-2 5 7-30 2-5 7 9-40 3-4 6 8-59 61-6 8-72 4-6 80-1 3-5",
    ": 7-8 90-2 4 6-9 401 3-8 11 3-8 21-3 5-8 30 2-9 41 3 5-7 9-52 4-5 9-60 2-5 7-8",
    ": 70 3-6 9-81 6-91 5 7 9 502 4-6 9 11 5-8 20-1 3-4 6 8-31 3-42 4 8-57 61 3 7",
    ": 71-6 8-9 82-7 92 4 7-8 600-2 4 6 8 11-31 5 7 41-2 4 8 50-3 7 65 7 70-2 4 7",
    ": 80-2 4-5 7-8 96 8-700 2 4 9-14 6 8 20-3 6-30 2-40 2-8 50-4 6 8-60 4 6-75 7-9",
    ": 81-3 5-7 9-90 2 4 6-9 801 4-5 7-9 11 3-5 7 9-30 2-3 5-8 40-7 9-53 5-7 9-60",
    ": 3-4 6-9 71 3-9 82-4 7 9-91 4-6 8-9 901-3 5-9 12 4 6-7 22 5-8 30-3 5-6 8-40",
    ": 2-3 6-7 9-52 4-9 64-7 9 71-3 5-7 81 5-9 91 3-4",
    ": 8-5000 2-6 8-11 3-4 7-26 30-40 2-6 50-3 6-7 60 4-5 7-70 5-8 81 6 9-91 3-4 6-8",
    ": 100-8 11-21 3-7 9-35 7-43 6 8-53 6 8-9 61-3 71 3-5 8-80 2-7 9 91 3-4 6 203-9",
    ": 11-3 7-8 20-2 4 7 9-33 7-41 3 5-9 52-7 9-60 5-6 72-4 6-97 9-305 7-15 8 26-33",
    ": 5-7 9-41 3-5 7-51 3-4 6 8-9 61-8 70-1 4-5 7 9-82 4-5 7 9-93 5 8-404 6-7 9 11",
    ": 3-9 22-5 7 9-37 9 42-5 8-50 7-62 4 7 70-5 7-80 2 4-6 9-93 5 8-9 502-8 12-3",
    ": 8-20 2 4-5 7 30-8 40-2 4-6 8 51-7 62-6 8-9 73-8 81-3 6-7 9-95 7-8 600-2 4-7",
    ": 9-12 4 7 20-1 3-35 7 9-47 9-51 4 6 9-60 4-5 7 70-2 5-7 9-80 2-4 6 8-91 4-5 7",
    ": 9 701-8 10 2-9 22-6 8 31 4-7 9-41 3-6 8 51-3 5-61 4-8 71 3 5 7-90 2-3 5 8",
    ": 800-1 3 5-9 11-3 5-25 7-32 7-8 40 2-4 7-8 53-66 70-3 5-7 9-82 5-7 9-90 3-6",
    ": 8-901 7 9 11-4 6 20-2 4-6 30-6 8-9 41-3 5-57 9 62-70 2-7 9-81 4-5 9 91-3",
    ": 8-6001 6-7 11-2 8-21 3 5-7 30-1 3-4 41 3-51 3 5-6 8-64 72-81 3-5 90-4 6-7",
    ": 9-100 2-3 6-7 10 2 5-8 20-1 3 6 8-30 4-9 45-8 50 2-60 4-73 6-8 81-2 4-7 9-96",
    ": 8-9 201 3-6 8 11-3 5 8-9 21-2 8-31 3-4 9-40 2-5 8-9 51-2 4-5 8-64 6-7 9 71-4",
    ": 6 8 80-4 6-92 4-5 7-305 8 10-1 4-8 21-8 31-2 5-9 41-4 6-8 53-4 6-61 3-5 7-8",
    ": 70 3-4 80 2-6 9 93-4 6 400-1 4 8-10 2 7-8 21 4 7-9 33-40 2-4 8-54 7 9-71 3-4",
    ": 8 82 4 8-9 91-2 5-7 9-504 6-7 9 11-5 9-21 5-8 31-2 4-5 7-45 7-56 9-61 4-5",
    ": 72-3 7-81 3-6 8-94 6 8-606 10-4 6-7 9-22 4 8 30 4 7 40 2 4-6 8-53 5-7 9 61-2",
    ": 5-6 8 72-6 8-81 3-5 7-93 6-7 9 701-4 6-9 11-3 5 7-22 5 9-30 2-9 41 4 6-8 50-1",
    ": 5-6 9-61 4-8 72-5 81-5 7 90 2-3 5-7 803 6 8-11 3-6 9-21 4-9 31-2 4 7 40 2 6",
    ": 8-50 2 4 9 61-2 4-73 5 7-8 80-5 8 90 4-7 900-3 5-8 10 3-5 20-7 30 2-6 8-42",
    ": 7-8 51-3 6-7 62-7 9-71 4-5 7-8 84-9 92-8",
    ": 7000-3 5-7 10-3 6-9 21-4 8 32-4 8-40 2-4 8-9 52-3 5-64 6-72 4-7 9-80 3-7 92-4",
    ": 7 9-103 6 8 10 2 5-21 5-35 7-42 7-50 2-3 5-6 8-9 61 4-5 7-8 70-1 3-6 9-80 3-5",
    ": 7-92 5-7 9 202-6 8 10-3 5-21 3-7 9 31-2 4-9 42-6 9-53 5-60 2-4 8 75-9 81-6",
    ": 9-90 3-5 7-300 2 7 9-14 6-21 3 7-9 32 4-9 42-4 7-9 52-3 8-9 63-4 7-70 2-7",
    ": 9-80 2-3 7-90 3-5 7-402 8-9 11-7 9-21 3-6 30 2-4 6-7 9-40 2 4-6 8-51 3-7 60-5",
    ": 70-3 6-83 5 7-90 2-3 5 7-501 4-6 8-12 4-6 8-9 21-2 4 8-9 34-5 7-8 41-4 6 8-50",
    ": 2-3 5 7-8 61-4 9-70 3-5 8-84 6 9-91 3-6 8-613 8-9 21-2 4 6 8 30-3 5-6 8-40",
    ": 3-6 8 51-6 8-60 2-6 70 4 6-7 9-80 2-4 6 8 90-2 5 701-4 6 9 11-2 5-6 8-20 4-6",
    ": 8 30 3-4 6-9 41 3-9 51-2 4 6 9-60 2 5 70-6 8 80-91 3-5 7-800 3 7-11 3 5-6 8",
    ": 20 3-5 7 9-30 2-3 6-8 41-5 8-50 3 6 8-61 3-6 9-70 2-3 5 8-9 81 4-6 8-90 2 4-5",
    ": 900 4 7-8 10 3-5 7 9-20 2 4 6-8 30 2 4 6-7 9-42 4 7-50 2-3 5-8 60 2-7 9-72 4",
    ": 81-3 7 9-90 2-3 5-6 8-9",
    ": 8001-3 5 7 9-11 3-5 7-8 21-3 7-30 2 5 7-40 2 4-55 7 9-61 4-5 7-9 71-4 6-81",
    ": 3-4 6-9 91 4-5 7-9 102 5-8 10-1 3 5 7 21 5 7-32 4-8 40-1 3 5-8 50-2 4-8 61-5",
    ": 7-70 4-7 80-3 8-9 91-3 5 8-9 202 6 8-9 12-3 5 8-20 2-3 6-7 9 31-3 5 8-40 3",
    ": 7-8 50-1 4-7 9-61 3 5 8 71-7 80-6 8-9 92-3 5 8-300 6-7 10 2-6 9 22 4 6 8 31 3",
    ": 6-8 40-1 3-5 7 9-55 7-60 6 71-6 8 81-5 7 90-2 6-403 6-8 10-1 4 7 20-3 5 7-9",
    ": 33-4 9-42 4-6 9-54 9-64 6-8 70-2 4-7 9-82 4-93 5-7 9-501 3-17 20 4-9 33-4",
    ": 9-44 6-7 50 4-6 8-9 63 6 8-72 4-7 9 81 3-5 7-9 91-3 5 7-604 6-14 6-22 5 8-31",
    ": 3-5 7-9 45-51 5-8 62-6 8-9 72 4-5 9-83 5-9 91-2 6-7 9 702 4 7 10-1 4-6 8-20 2",
    ": 4 6-7 9 31-42 6-9 52-3 6-7 9-65 7-77 80 2-4 6 8-93 5-9 802-3 5 7-9 11-3 5-6 8",
    ": 20-7 9-30 2 7 9-40 2-9 52-6 8-9 61-5 7 9-72 4-80 2 5-8 90-3 5 7-9 901-2 4",
    ": 8-15 7-20 2-4 6-7 30-8 40 2-51 3-5 7 63-4 6-8 70-2 4 6-80 4 8 90-4 6-7",
    ": 9000-2 4-6 8-16 8 23-4 6 9-32 4 7-9 41-4 6-53 5-6 8 61 6 8-72 4-8 80 3-5 9",
    ": 91-4 6 9-107 9-11 3-26 9 31-3 5-40 2-5 7-8 51 3-4 6 8-60 2 4-9 71-6 8-86 8-9",
    ": 92-4 7-201 3-8 10-2 4 6 8-23 6-7 9-31 7 41-8 50 3-6 8-9 61 3-8 72-9 82-4 6",
    ": 8-94 6 8-303 6-8 10 2-3 5-20 3-7 9-32 5-8 42 4-8 50 2-5 7 9-60 2-4 6 9-76",
    ": 8-83 5 7-8 91 400-1 3-11 6-9 23-4 7-36 8-9 42-5 7-58 60-7 9-75 7-82 6-7 9-90",
    ": 4 7-8 502 4-8 11 3-5 7-9 22-9 31-41 3-4 51-2 4-7 9 61-4 70 2 5 7 9-80 2-7",
    ": 9-90 2 7-602 4-16 20-2 6-31 3-4 6-9 41-2 4-5 8-52 4-5 8 60-3 5-6 8-71 5-6 8-9",
    ": 81-8 90-4 6-9 701-5 9-15 7-20 2 5-6 8-30 2-4 6-41 4 6 8-51 4 6-7 9-61 5 7",
    ": 9-79 84-5 7-8 90-2 4 6-7 9-800 4-7 11-3 5 7 21 4-5 7-8 32-5 8 40-1 4 6-8 50-1",
    ": 6 8 60-72 4-6 9-85 7-9 93 5-9 901-2 5-16 8-25 7-33 5 7 41-2 5-51 4 6-7 9-60 2",
    ": 6-7 9-82 5-7 90-2 4-7 9",
    ": 10001-4 6 12 4-7 9-26 8-30 2-3 5-6 8-40 2 6-7 9-50 2-6 8-60 3-6 70-1 4 6-7",
    ": 9-80 2 4-91 4-5 7-100 2 4 8 10-3 20-3 5 7-9 31-6 9-48 52 4 8-66 71-82 6 8",
    ": 90-2 4-7 200-1 3-5 10-3 5 9-20 3-4 6 31-2 5-9 41 4 6-51 3 5-6 62-5 7-8 70 2",
    ": 6-9 85-90 4 9-300 2-4 6-9 13-4 8-9 22 5-6 8-30 3-6 8-9 42-50 3-9 61-71 3-6",
    ": 8-85 7-90 2 5 9-402 6-7 12 5 7-9 21-3 6-7 9-30 3-5 7 9 43-6 8 50-1 3-4 6-8 61",
    ": 4-5 7 70-1 6 9-80 3 5-90 2-6 9-500 2-10 4 6-7 21 5 8 31-2 4 6-7 9 43-6 9-51",
    ": 3-8 60-1 3 6-70 3 8 80 4-92 4-6 8-601 6-7 10-6 8 20 2-3 5-8 31-2 8-43 5-6",
    ": 8-50 2 4-5 8-62 4-7 9-71 3-7 9 82-3 6-91 3-6 9-703 5-6 8-14 7-21 4-8 30-1",
    ": 4-42 4-6 50 2 4-5 9-60 5-77 9-83 5-6 9-91 4-7 9-800 2-9 12 5 7-23 6-9 32-3",
    ": 7-44 7 51 4 7-9 63 5-6 8-81 3 5-7 9-95 8 900 2-5 7-14 6-30 2-5 8-46 9-54 7-8",
    ": 60-2 4-78 82-5 91-4 6-8",
    ": 1002-9 11-4 7-8 20-2 5-6 9-31 3 5-7 9-41 3-6 8 51-3 5-6 8-64 7-79 81-9 91-3",
    ": 5-110 2-22 4-6 8 30-7 43-5 50-8 60-4 6 9-71 3-8 82 4-7 90-3 6-7 9 201-3 5-6",
    ": 9-15 7-24 6 8-9 31-3 9 42 4 7 9-52 5-61 3 7-72 4 7 9-83 5 8 90-2 4-6 8-303",
    ": 6-14 7-8 21-4 6-31 3-4 8-40 2-5 7 9 53-6 9-64 6 8-74 8 80 2-3 91-2 6 8-400",
    ": 2-3 5 7 9-12 5-6 20-1 3 6-31 5-7 40-1 3-9 51 3 5 7-62 6-7 70-1 3 6 8 80-5 7",
    ": 9-91 5-500 2-3 5-11 4 7-9 22-5 7-8 31-3 5-41 8 50-8 60-4 6-7 72-6 8-81 4-5 91",
    ": 3-6 8-603 9-16 8-21 4-6 30-8 40 2-7 54-6 8-64 6-8 70 2-3 5-7 9 82-9 92-6 8",
    ": 700-7 9 11-3 5 9-22 4 7 30 3 7-47 9-50 2 6-64 7-8 70-1 4 8-9 82-4 7-801 3-5",
    ": 7-14 8-22 5 7-32 5-7 9 41 4-5 7-8 50-66 8-72 4 6-82 4 8 90 2-6 8 900-2 7-10",
    ": 3-4 6-24 6 31-4 7-8 40-3 5-7 9-58 61-3 5-9 71-4 6-7 9-85 8-9 91-6",
    ": 8-2000 2-4 9 12-7 20-5 7-8 30-4 7-47 50-5 7-8 60 2-3 5-6 70-2 4 6 9-87 90-4 6",
    ": 8-100 2-16 9-21 3-8 33-6 8-46 8-55 7-66 8-74 8-83 6-91 3-4 202-3 5-6 9 11 3-4",
    ": 6-9 21-2 7-31 3-5 8 40 2-5 7-8 50-1 3-8 60 2-70 3-9 84 6-8 90-2 4 7-301 3-5",
    ": 7-8 10-2 4-5 7-9 22 5-33 8 42-4 7 9-51 3 5-6 8-63 5-70 2-6 8 83-5 7-9 92 5",
    ": 400-1 4-7 11 3-7 9 21-8 30 2-5 8-43 5-7 9-53 5 8 60-2 4-7 70-4 6-7 9-83 6 8-9",
    ": 92-4 6-8 500-4 6 8-9 11-4 8 20-2 4-5 7-8 30 2 4 6-7 9-41 3-6 9-51 4 6-8 60",
    ": 2-3 5 7-73 6-8 81-5 8 90 3-5 7 9 601-6 8 11-3 8-20 3-7 9 32 6-7 9-40 3-52 4",
    ": 6-7 9 61 5-79 81-4 6-7 9-91 4-704 6-7 10-1 4-20 2-5 7 9 33-5 7-40 3-5 7 9 52",
    ": 4-64 6-70 5 7 9 82-7 9-93 5 7 9-802 7-8 10-4 6-8 21-6 9-30 3-4 6-45 9-51 3 6",
    ": 60-2 4-8 70-1 3 5 8 80-3 5-93 5-8 900-6 11-3 5 8 20 2-5 8-9 32-40 3 5-50 2-6",
    ": 9-65 7-9 71-2 4 6 8-80 2 5 7-8 90 3 5-7",
    ": 9-3002 4-5 8-12 6-9 21-2 5 7-34 6-9 41-5 8 52 5-63 5-6 8-9 72-3 5 7-8 80 2",
    ": 6-91 4-8 100-2 5 7-17 9 21-5 7 30-4 6-40 3-4 6-7 9-52 4-8 61-4 6 8-70 3 5-6",
    ": 81-2 4 6-9 92 4 6-8 200 4 6 11-4 6 8-9 21-2 5-30 2-4 8-40 3 5-6 8 53-7 9-65",
    ": 8-71 3-7 9 81-2 5-7 9-90 2-3 5-7 302-3 5 7 10 2 4-24 6-8 33-6 9-40 2-5 7 50",
    ": 2-65 7-70 2-3 6-8 81 4-8 90-3 5 8-9 402-8 12-4 6-7 9-22 7-30 2-6 9 42 5-50",
    ": 2-4 9-64 7-8 70-2 5-83 5-7 9-97 9-504 6-12 4 6-7 9 22 4 7-9 32-3 6-8 40 4-6",
    ": 9-53 6 8-9 63-6 8 70-2 5 7 9 83-92 4-6 8 600-3 5-14 6 8 20 2 4-6 9 32-3 5 8",
    ": 41-4 7 9 51-3 8 61 3 5-9 71 4-8 80-2 4 6-7 90 2 4-5 7 703-5 8-10 4 8-25 8",
    ": 32-4 40-1 4 6-7 9-51 5-63 5-8 70-4 9-84 7 9 92-3 5 7-800 2-6 8-9 12-22 5-7",
    ": 9-35 7-45 7 9 53-4 8-65 7-8 71-6 8 80-2 4-6 8-94 6 8 902-10 2-5 8-9 21-2 4-5",
    ": 9-31 3 5-50 2 4-9 62-5 70-1 4 6-9 81-2 4 6 8 92-3",
    ": 7-4007 11-6 8-23 5-8 30 3 6-44 6-7 9 51-6 8-61 3 5-72 4-5 8-80 2-5 7 9-96 8-9",
    ": 101-2 4-8 10-1 3-6 9-22 4 8-30 4 6-46 9-52 4-61 4-6 8-74 6-8 81-4 7 92-4 6-7",
    ": 9-200 2-3 6-8 11-3 5-25 7 9-30 2-7 9-42 6 8-50 3-6 8-9 63 5-7 9 72-3 7-8 85-6",
    ": 8-93 8 301-4 6 8-9 17-9 21-3 5-6 9-32 6-7 40-3 6 8-50 2-3 5 7 9-63 5 8-9 71 3",
    ": 7-84 6-90 3 5-7 401-2 4 8 13-5 7 9-21 4-5 7-9 31 4-7 40 2-5 7-8 51 3-7 60 2",
    ": 4-6 8-70 2-8 80-2 4-6 9 91-5 7 9 501 5-11 6 9-20 2-6 9-30 2 4-45 8 50 6 9",
    ": 61-3 5-6 70-8 80-1 3-8 90 4-8 600 2-3 6 8 10-2 4-6 8-22 4-5 7-31 3 6-43 5-6 9",
    ": 51-2 4 6-9 61 6 8-74 6 8 86 9 91-5 7 701-10 2-7 22 4-9 31 3-4 6 40-1 3-4 8 50",
    ": 3-7 60 3-4 6-8 71-6 9-81 3-5 9 91-5 8-800 2-4 6-8 10-1 3 5 7-27 9-33 8-9 41-4",
    ": 7-8 50-1 5-6 8-65 7 9-83 5 7-91 3-7 9-904 6-7 9-15 9-21 3-6 8 30-4 6-8 40-5 7",
    ": 9-51 3 5 7-8 62-3 6-7 9-75 7-8 80-1 3-8 90-2 5",
    ": 8-5002 6-12 9 21-2 4 6 8-30 2-3 5-7 40-2 4-9 51-7 60-4 7-70 2-80 2-5 8 91 4-6",
    ": 8-9 101-6 10-1 4 6-23 5 8-32 5-6 8-44 8-50 3-7 61-2 9 72-5 9-81 3-5 7 9 97-8",
    ": 204-5 7-11 3-7 9 26 8 30 2-5 7-44 7-50 4-7 60-1 3-8 70-4 6-7 80 4 6-7 90",
    ": 3-300 4 6-8 10 3 5-24 9-30 2 4-5 7-8 40-4 6-57 9 61 3 6-71 3-4 6 8-9 81-2 4-6",
    ": 92-406 10 3 6-7 20-2 4-8 30 2-5 7-40 3 5 8-55 7 9 62 4 6 8 70-1 3-4 6-8 81-6",
    ": 8-92 4-9 502 6-7 10-1 3-4 7 9 22 4 7 30-42 4 6-8 50-3 5 7-8 61 3-71 3 5 8-81",
    ": 6-91 4-7 600-2 5 7-14 8-9 21-2 4-6 8-9 31 3-4 40 2-3 5 9-50 2-7 9-60 2 4-82 5",
    ": 9-90 2 4-9 702-8 11-2 8-21 3-6 8 30 2 4-9 41-3 6-50 3 7-67 72-4 8 83-6 9-90",
    ": 3-7 9 802-3 5 7-13 5 8-22 9-30 2-3 6 9 43-4 6-8 50 3-5 9-69 71-4 6 8-81 3-5 9",
    ": 91-8 901-11 5-20 4 6-8 30 3 5 8-40 2-9 52 5-60 2-4 6 9-70 4-6 8-82 5 7-8 90-1",
    ": 4-5",
    ": 7-6000 2 4-5 7-11 4 8-22 4-8 33-8 40-2 5 9-56 8-63 5 8-9 71 3 6-7 9-83 5-7 90",
    ": 2-5 7 101-2 8-9 11-2 4-9 21-2 5-6 8 31-5 7 9-46 9 51-3 6-69 71-6 9-84 6-200",
    ": 2-4 8-9 11 3-5 7-21 3 5-33 7 9-40 3 5 8-51 5-8 60 2 5 7-84 6-8 92 4 7-306",
    ": 8-11 3-5 7 20-1 3-7 32-6 8 41 3-8 50-1 4-7 61-9 71-4 6-81 6-8 90 2 4-8 401-2",
    ": 10-5 7 9-22 4-5 7-31 6 9-42 5 7 9-50 2-9 62-4 6-7 9-73 5-7 80 2 4-90 4 6-504",
    ": 6 8 10-4 20-1 3-30 2 4-5 7-44 6 8-54 6-60 3 5 8-75 7-8 80-4 9-91 3-5 8-602 4",
    ": 6-9 14-8 21 4 6-35 8-9 43-50 2-8 60 7-8 72-3 5-81 3-6 9-704 6 8 10-5 7-8 20-1",
    ": 6-7 31-2 4-5 7 9-41 3-4 7-8 56-8 60-8 71 4 7 80-2 4-7 9 91-804 6-10 3-7 9-24",
    ": 7 9-30 3-5 7-45 7-50 2-62 4 6-74 6-8 80-2 4-6 8-9 94-8 901-7 9-11 3-7 9-20",
    ": 3-7 31-4 6 8 40-2 5-6 8-9 51-2 4 6-7 60-2 4-8 71 4-5 7-9 81-90 4 6-7 9",
    ": 7002 4-5 8-11 3-4 6-27 9-31 3-7 41-4 8 54-8 60 5 7 70-1 3-5 7-9 81 3-8 90-7",
    ": 9-101 3-9 11-4 6-44 6-7 9-56 8-63 7-72 5 7-80 2-90 2-3 7-201 3-5 8-11 3-6 8",
    ": 24-30 3-4 7-8 40-1 3 5-6 8 50 2 4-8 60-73 6 8-82 8-97 9-301 4 6 11-5 8-23",
    ": 6-32 4-40 2-3 5-8 50-1 5 7 64-5 8-73 6 8-9 83 7-8 90 2-9 401-2 4 8 10 3-7 21",
    ": 3 7-8 30 2-5 9 41-2 4-6 8-9 51-2 4-6 8-65 7-9 71-5 7-80 2 5-7 90-1 5 500 2",
    ": 4-6 8-9 11-8 22-6 9 31 3 5-8 40 4 6 8 53 5-6 9-64 7-71 5-6 8-9 82-3 6-8 91-3",
    ": 5-7 9 601-3 6 8-9 12-5 7-21 3-6 8 31 5-6 8 41-2 4 50-4 6-60 2-7 9-72 4-80 2-4",
    ": 6-91 3-9 701 4-5 9-12 5-9 23-5 30-4 6-8 40-2 7-9 52-6 8 64 6-9 71-7 9-81 3 6",
    ": 8 90-2 4-6 9-807 9-10 5 7-20 32-5 7-9 41-9 52 4-65 9-70 2 5-81 3-4 6 8-91 3-5",
    ": 7 9-908 12-6 9-20 2-6 8 31-4 6-7 9 43-6 8-50 2-3 5-6 60-1 3-4 6-7 9-76 9-82",
    ": 5-6",
    ": 8-8005 8 11-2 7-8 21 4-6 8-34 6-7 9-42 4-6 50 2 4 6-8 60-80 5 7 90 2-5 7",
    ": 9-100 2-4 6-7 9-15 9-22 4 6 8-30 2-5 7-8 43-5 7 50-3 5 7-62 5-70 2 5 8-80 3-5",
    ": 8 90-7 201-4 7-12 4-8 27-8 31-3 8-41 3 9-70 2-5 81 4 6-9 93-4 6-306 8-9 12-20",
    ": 2-6 8-31 4 6-8 40-2 4-6 9-53 5 8-60 5 9 71-4 8 80 2 4-95 7 400 2-5 7-15 7-21",
    ": 3-8 30-5 7-40 2 6-9 53-62 4-5 72 4 6-80 2-3 6 9-94 6-7 502 4-6 9-12 5-8 20-1",
    ": 8-9 32-4 6-49 53 5 9-63 5 9-72 4-5 8-9 83 5 7-8 90 2-4 7-9 602-4 6-8 10-1 5 9",
    ": 24-5 8-30 4-6 8-9 43-4 7-9 51-2 4 6-9 61-2 5-6 9 71-2 5 7 83-5 7 9 93-4 8-700",
    ": 4-10 5-23 7-33 5-6 8-45 7-9 51-9 62-8 71-2 6-7 9-82 4 6-7 90 2-6 8 800 3 5-10",
    ": 2-3 7 9-20 2-8 31-41 3 5 7-50 3 5-6 8-62 4-78 80-1 3 7 91-3 5 7 9 901 3-9",
    ": 11-3 5 7-21 3 5 7-9 31-5 8 41-4 6 8-58 61-2 5 9-70 3 5-6 8 80 3-4 8-92 4-5",
    ": 7-9",
    ": 9001 4-5 7-11 3-4 6-20 2-30 3-41 4-6 8-52 4 6-60 4 6-7 70 2-4 7-81 3 5 7 9-91",
    ": 4-7 9-102 5 7 9-18 20-5 7-31 3-9 41-5 7-8 50-2 4 6 8-9 61 4-5 7 9 71-2 5 7-84",
    ": 6 8-92 4-8 200 2-4 7-10 6-26 8-34 6-40 3-5 7 51-2 4-7 9 61 4-5 7 9-70 3 6",
    ": 8-86 8-9 91-3 6-9 301-5 8-11 3 6 9 22-33 5 7-9 41-4 6 8-9 53-5 8-9 62 4-9 71",
    ": 3 5-80 4 6-90 2-3 5-6 400-3 5-8 10-1 4-7 9 22 4 6-9 31-4 9-42 4-7 50-5 7-61 7",
    ": 70-6 8 83-4 7-9 92 4-512 5-9 21-3 8-32 5 7-40 2-4 9-50 2-3 5-8 60 2-7 9 71",
    ": 3-5 80-6 8-96 8 600-4 6 8 11-3 5 20-1 3 5-30 2-3 5-6 8-40 2 4 6 9 53-9 63-7",
    ": 74 6-7 9-80 3-4 7-98 700 2 5-6 8-10 2 4 6-33 8-42 5 7-9 51 3 5-9 61-2 7 9-70",
    ": 3-4 7-8 80-3 7-8 92-3 5-7 801-2 4-14 6 8-23 6-8 36 8-9 41 3-4 7-52 4 7-9 61-4",
    ": 6 8 70-4 6-82 7 94 901-4 7 9-10 3 6-24 6 8-31 4 6 40-6 9 53-5 7-64 6 8-72 5",
    ": 7-9 83-5 7-93",
    ": 5-20001 3-4 6 8-14 6 8-20 4 9-38 41-2 5 7 9 52-5 7 9-60 2-5 7-70 2 4 7-9 82-5",
    ": 7-8 91-2 4-9 101-2 5 9 11-7 9-30 3 7-41 4-52 4 7-60 3-9 71-3 6-82 4-6 9 91",
    ": 3-6 8-201 5 8-9 12-3 7 20-2 4-7 9 33-4 40-2 4 6 8-52 4 6-7 9 61 3-5 8-70 4-84",
    ": 7 90-1 4-300 8-9 11 4 8 21-4 6 8-30 2 5 7-8 40 2 5-6 8-9 51 3-4 7-8 65-81 3-9",
    ": 91 3-8 400-1 4 7-8 13 21-5 7-9 31 4-5 7 9-40 5-9 52 4 8-61 3 8-71 3 9 95-7 9",
    ": 501-2 7-8 10-2 4-6 8-21 6 8-32 5 7-8 42-5 9-57 9-64 6-7 9-73 8-82 5-6 8-9 95",
    ": 9-603 5 8-12 4 6-9 21 4-6 8-9 36-8 40 2-51 4-5 63 5-7 74-6 8 80 3-7 9 92-4",
    ": 7-700 2 4-5 8 10 2-5 8-24 6-8 31-2 4-40 3 6 8 51 5 9-60 2 4-5 7 9 71-2 4 6-82",
    ": 4-6 8 90-1 4 6-800 2-3 5 10-3 5-7 9-22 5 8-9 31 3-4 6-7 42-3 5 7-52 4-60 2-6",
    ": 73 5-6 9-80 2-5 7-9 91 904-11 3-20 2-9 31 3-7 9-53 6 8-9 61-71 3-8 80-1 4",
    ": 6-92",
    ": 4-1000 3 5-7 10 2-6 20-4 9-30 4 9 43-4 6 8-9 55-6 8 60-2 4 6 8-9 72 4-5 7-82",
    ": 90 7-100 6-9 13-7 9 22 4 8-36 8-9 42 5-9 51-4 7-60 2 8-73 5-80 3-4 6-8 90-1 3",
    ": 5 7-202 4-6 11-4 6-7 9-35 7-9 41 6-8 50-5 8-62 5-7 9-78 87-8 90 2-8 300-2 4",
    ": 6-9 11 3 6-22 4-5 8-9 32 5-6 9-40 7-9 52 4-9 62-5 7 9 71-4 8-83 5-90 2-3 5-6",
    ": 8-9 402 5-7 9-10 3-8 24 6-7 9 31 7 9-43 6-7 9-52 4 6-9 64-73 6 9 82 5-8 91-2",
    ": 4-6 9-500 2-3 5 12 6 21 3-31 3-4 7 9 42-58 60-1 4 6-8 70-5 7 80 4 6 8 90 3 5",
    ": 9-604 6-7 10 2 4-5 8-21 3 5 7 9-30 2-3 8-9 42-50 5-8 60-1 3 6-9 77-80 2 4-92",
    ": 7-9 704 9-11 5 7-9 21 3 6-7 30 3-6 8-43 7-9 53-4 7 9-61 3-9 71-3 5-6 80-1 4",
    ": 7-90 6-9 802 6-9 11-5 7-20 2-3 6-7 31 3 8-42 4 50 2 5-7 9-61 3 5-6 8-70 2 5-6",
    ": 8 82-3 5 8-9 91-6 8 900 2-3 7-8 11-2 6 8-20 2-3 6-32 4-41 3 6-52 4-8 61-2 5-7",
    ": 9-72 7-9 81-2 5-9",
    ": 91-2005 7-10 2-7 9-20 2 4-5 7-9 33-6 9-40 2-3 5-8 53-7 9-66 8 70 3 6 9 81 4",
    ": 6-92 4-5 9 104-14 6-8 20-1 6-30 2-3 5-8 41-2 4-6 8 50 3 5-8 63-4 6 8-78 80-1",
    ": 3 8-9 91 4-200 2-4 6-7 9-11 5 9-21 3-8 32 4 6-9 43 5-53 6 60-72 4-5 7 9-80 3",
    ": 7-95 7-8 301 3-6 9-12 4-5 7-8 23 6-33 5-46 8-9 51 3-5 7 9-63 5-7 9-71 3-5 7-9",
    ": 81-3 6 9-93 5-7 9-402 4-5 7-14 8-20 2-4 9-36 8 43 5 7-9 51-3 5-7 61-3 5-6",
    ": 8-76 8 80 4-5 7-9 91 4-5 9 501-4 6-7 9-13 5-21 3-4 6-9 34-5 7 9 41 3-6 8-9",
    ": 51-3 6 8-63 5-7 9 74-81 5-7 9-91 4-5 7-8 601-6 8-10 3-4 6-7 20 2 4 6 8-30 2-3",
    ": 6-8 40-1 3-4 6-8 52 4-5 7-9 62-4 6 70 3-81 4 6 8-90 5-700 2-3 5-6 8-15 7 20",
    ": 4-6 9-31 3-9 43-4 6-9 52-7 9-60 5-6 8-70 2-3 6 80 2-3 5-6 8 94-8 800 3-6 10 3",
    ": 6-20 2-3 5-7 9-31 3 7-8 40-7 9 54-8 61-5 7-8 73 5-8 80 2-4 8 91 3-6 9 902-3 9",
    ": 11 3-6 9 22 4-5 7-9 31-2 4-5 9-40 2 5-52 4-61 4-5 7 9-81 3 5 8-90 2-3 5 9",
    ": 3001-5 7-24 6 8-9 33 41-3 5-9 51-2 4-7 9-60 2-7 71 3 6-8 80-1 6 9-92 4 101-2",
    ": 4 6-7 9 11 8-9 22-3 5-9 31 3-4 8-40 2-7 50 2-4 9-63 5-71 3 5 8 81 3-8 91 3-5",
    ": 9-200 2-8 10 2-5 8 20-3 6 8 30-1 3 5-8 40 2 4-6 9-50 3-4 6 8-60 3-7 71 4-83",
    ": 5-8 90-1 5-7 9-303 5 7-8 10-1 3-7 9-20 4-45 9-50 7 9 61 3-6 8 71-3 5 7 9 81-7",
    ": 90-2 4-406 8-19 22-4 7-30 2-6 8-9 43-53 5 7-60 3-5 7-9 71-83 6-7 91-4 6 8",
    ": 500-7 10-3 5 7-21 3 5 8-9 32 4-45 7-51 3-6 9-63 5-9 71-2 6-87 9 91 3-5 7-602",
    ": 4-8 10 3 6 9-20 2-4 6 32 4 6 8-40 2 4-5 9-54 7-9 61 3 5-9 71-5 7-8 80-3 6-91",
    ": 3 5 9-701 5-9 11-2 4-6 8-9 21 3 5-30 2 5-6 8 42-6 50-2 4 6 8 60-2 4 6 8 70-4",
    ": 6-8 81-2 6-7 9 91-6 802-11 3-4 8 20-1 3 8 31 3 5 7-42 4-52 4-7 62-3 6-7 9",
    ": 73-9 81-7 9-91 3-8 901-2 6-7 9 11-20 2 4-5 8-30 2 4 6 40-3 5-7 9-50 2 4 6-7",
    ": 61-2 4-71 3-9 82-92 6 8",
    ": 4000-3 5 8-9 11 4 6-9 25 7-9 34-7 46 8 50 3-4 7-65 7 70 2-3 5-9 82 4 7-93 6-7",
    ": 9 103-6 8-9 13 6-7 21 4 6-30 2-4 6 8-9 44 8 50-6 8-60 2 5 9-71 3 5-6 9-81 3-7",
    ": 9 92-5 7-8 200-4 6-7 9-20 4-7 30-3 5-6 40 2 5 8 50-1 3-6 8-60 3-8 70-2 4-7",
    ": 9-80 2-4 6 8-92 4 7-304 6-11 4-7 9-27 31-8 40-1 8-9 51-2 4 8-61 3 5-7 9 71-2",
    ": 5 7 9 81 4 7 90 3-4 6-402 4-5 8-9 11-5 7-20 2-5 8 30 4-44 6-51 4 6-7 62-76",
    ": 8-81 3-9 93 5-9 502-6 8 10-1 3-7 9-24 6 9-31 3-5 7-41 3 5-9 51 4-7 62-3 5-8",
    ": 70 2 4-5 7-80 2-5 7 95-8 600 2-8 10-3 5 7-8 20-1 6 8-32 4 8-40 2-3 5-7 9 53-8",
    ": 61-2 5-9 71-2 4-5 7-84 6-7 9-92 4-5 7-8 700 3 6-14 20-2 5-6 9 33-41 3-6 51 6",
    ": 8-9 61 3 6-7 70-3 5-6 80 2 4 6-7 9-91 3-806 8-10 6 20-3 9-32 4 6 40-5 7 9-65",
    ": 7-71 4-7 9-82 4 6-90 2-3 5-900 2-7 12 4-5 7-24 6 8 30-1 3-4 41-2 4 8 50-1 4-5",
    ": 8-61 3-9 73-4 6-82 5 7-91 5",
    ": 8-5005 7-8 10 2 4-7 9-24 6 8-32 4-44 6-9 51 4-6 8-9 61 3-5 8 70-3 6 9 81-4",
    ": 7-90 2-7 100-2 5-6 9-10 2-8 20 2-7 9-32 4-6 8-40 3 6-7 9-50 2 4-5 7-9 67 70-4",
    ": 6 9-84 9-91 3-4 6 8-202 4-5 7 9 13-6 20-5 9 32 5 9 42 4-51 3-4 6-60 2-3 5-8",
    ": 70-2 9-81 4-6 8-90 2 4-8 301 3-6 8-10 2 4-5 8-22 4-5 7-9 34 6 9 41-8 50-3 7-9",
    ": 63-74 6 9 82-3 5 9-91 3-400 2-10 2 5 7 20-1 3-7 9-31 4 6 9-42 6-7 50-1 3-4",
    ": 8-76 8 81-2 4 6-90 2-3 5-9 501-3 5 7 11-2 4 6 8-9 21-3 8-34 7-41 4-5 9 52 5 8",
    ": 60 3-4 7-74 6-85 8 90-4 6 9-604 6-12 6-20 2-4 6-30 2 5-7 40-4 8 50-3 5-6 8-60",
    ": 6 9 71 3-4 8 83 5-91 3-7 9-701 3 5-6 8-9 11-21 5-6 33-4 6 9-43 7-9 53-4 6 8-9",
    ": 61 3-7 9-70 3-82 5-6 8 90-7 9-805 10-1 3-4 6-8 20-1 3 5-8 30 3-4 40-2 4-8 50",
    ": 2 4-9 63-4 7-9 71-3 5-6 8 82 5 8-90 4-5 7 901-2 4 6 8 10 4 6-7 9-22 4 7 9-30",
    ": 4-5 9-44 6-56 8-60 2-4 8-70 2-3 5-8 80 2 4-6 8 92-5",
    ": 8-6000 2 4-5 7 14-5 7-8 22-3 5-7 9 31 3-8 40-2 4 6-9 51 5 8-62 4-6 9-70 3 6-7",
    ": 81 3-8 91-3 5-6 8 100-2 4 6 8-16 8-23 5-7 30 2-8 40-1 3 7 9-50 3 8-9 61 4 6",
    ": 73-5 82-4 6 8-93 5-8 200 2 4-5 7-8 10 7-9 22-4 6-7 9-30 2-5 8 43 6 8 50-3 5-7",
    ": 9-62 5-7 9-71 4-5 7 80-1 5-7 9-93 5-6 9-300 2 4-6 9-10 2-7 21-4 6 30 3 6 8-41",
    ": 3-4 6-9 51-2 4-5 7-62 4 6 8-70 2-4 8-84 6 8 90 4-6 8-9 402-3 8-10 4 6-9 21-2",
    ": 5-8 32 6-8 40-3 5-9 51 3 5-7 9-61 3 5-6 8 70-2 4-8 80 2-3 6 8-95 7-9 501-2",
    ": 4-8 10-4 6 8 20-3 5-30 2 5-7 9-40 5-7 9-50 2-4 6-8 60-1 3-73 6-7 9-85 7 9-90",
    ": 2 5 9 601-2 5-6 8 10 2 4-5 7-9 21-2 4 6-7 9-34 9-40 3 5-54 6-8 60-1 4 6-9 73",
    ": 5 8-9 82 6-8 91 704 8-11 3-6 9 21-6 8 32 5-7 41-2 5 7 50-3 5-6 60-4 7-8 70 4",
    ": 7-9 83 6 8-91 3-7 9-800 2-3 6-8 10-4 6-7 21-3 6 8-9 35-7 41-6 8 50 2 4 6 8-9",
    ": 61-6 71 3-5 7-9 82-5 7-9 91-2 4 6 8 900 2 4 6 10-2 4-9 22-8 30-1 3-4 6-9 41",
    ": 3-5 7-53 5-8 60-1 3 5 7-70 2-4 7-9 86-9 91-2",
    ": 6-7001 3-5 7-9 11-3 6 9 22-5 7-9 31 3-45 7-53 6-60 2 4-5 7 70 3-4 8 80 3-7 9",
    ": 92-6 100-1 3-4 6-9 12 5 7-28 31 3-6 9 42 4 6 55-6 8-64 7 9 72-6 9-81 3 5 8-9",
    ": 91 3 7 200-1 3-5 8 12-4 6-7 9 21-3 5-8 30-1 3 6-45 7-8 50 3-4 6 9-60 2-5 7-8",
    ": 71-2 4-7 80-1 7-8 90 3-4 9 301 3-7 9 11-3 20-5 7-8 30-40 3-4 8-9 51 3-7 9-61",
    ": 3-72 6 9-87 9 95-8 400 2-11 3-6 8 20-6 8-33 5 7 9-40 3-7 9-54 6-7 65 7 70 2-3",
    ": 6 8-83 5-91 3-5 7 9-500 2-4 6-8 10-3 6-20 2 5 8-33 5-7 9-45 7-51 3 6 8 60-1 3",
    ": 5-74 6-7 9-81 3-6 8 90 4 6 8-603 6 8-11 7 9-21 3 5-7 9 32 4 6-7 9-41 3-5 7",
    ": 9-50 2-3 5 7-8 60 2-3 5-8 70-1 4-7 9 81-90 2 4 6-8 701-5 7-9 11-2 4-6 8 20-2",
    ": 4-5 7 9-39 41 4 8-9 51 3-4 6-9 62-5 7-70 2-5 7-80 4-5 7-8 90-2 6 8-801 3 5-7",
    ": 9-15 7 9-24 7-30 3 5 7 9 41-2 4-6 8 50-2 4 7 65-71 3 6 8-82 4-6 90-1 3-5 7",
    ": 9-905 7 10-3 5-8 20 4-32 4-6 8 40 4-5 7 9 51 3-8 60-6 8-9 71-81 3-4 6-9 92-3",
    ": 5-7",
    ": 9-8000 3-5 8-12 4-20 2-4 6-35 8 40-2 5-50 2 5-6 8 60-9 72-3 5-81 3 5-9 91",
    ": 3-111 4-5 7-9 21-3 9 32 7 40-3 8-9 51 4 6-9 63-71 4 6 8 80 2 5-8 90 2-5 7-201",
    ": 4-7 10-1 3 5-7 9-20 2-5 7-31 3-8 40-59 61-4 6-75 7-9 81-91 3-7 9-301 4 6-14",
    ": 6-26 30 2-3 6 8-41 3-8 50-5 8 60-4 6 8 70 2-5 7-80 2-4 6-7 9-90 2-4 6-9 401-4",
    ": 6 8 12 4-5 7-9 21 3-5 8 31 3-4 6-8 40-2 9-52 5-8 61-5 8 72-4 6 80-3 5-9 91-5",
    ": 7 9-502 6 8 10-2 5-8 20 2-9 31-3 5 8 40-3 5-7 9 53 5 8-64 6 9 71 3-5 7-81",
    ": 3-91 3-4 6 8-9 602 4-9 11 3 6-8 20-3 5-6 8 30 2-4 6-47 9-53 6-61 3-4 7 72-80",
    ": 2-3 5-90 2 4 6-9 701-2 6-7 10-1 3-4 7 21-3 5 30 2-3 5-6 8 41-2 5 7-52 4 6 8",
    ": 61 3 6 8-9 71-3 6-86 8 91 3 5-7 9 801-3 5-8 10-4 6-8 20 2-4 6-8 30-1 4 7-9",
    ": 41-2 4-5 7 53-4 6-9 61-3 6-7 71 4 6 9-84 6-8 90-5 901 3 6-10 4 6-7 9 25-7",
    ": 9-33 8 40-3 6 9-50 2 4 6-8 60 3 5 7 70-9 83 5 7 9-92 5-6",
    ": 9000-6 10 2-5 7-8 20 2 5-6 8 32-5 7 9-42 4 6 9 52-3 6-7 9 62-5 7-71 3 5-6",
    ": 80-3 5-7 90-3 6-109 11 6 8-23 8 32 4-7 9-40 2-4 6-8 50-1 3 5-64 6-9 73-4 8",
    ": 82-96 9-200 3 5-6 8-20 2 4 6 30-2 4-5 8-42 4-5 7 51-3 5-6 60 3-6 9-72 4-81",
    ": 4-5 90-3 7 301 3 5 7-10 3-4 6 8-9 22-5 8-34 6-41 3-4 6-51 3-9 61-3 5-72 4-7",
    ": 80-1 7 9-91 7-401 4 6-7 9-17 20-6 8-30 2 4 6 40-1 3 7 9-51 3-60 2-5 7 9-70",
    ": 2-7 9-81 4-5 7-9 92-3 5-7 9-500 2 4 7-8 12-3 6-9 22 5-7 9-36 8 42-6 9-53 5",
    ": 7-8 61-3 5-7 9-71 3 5-8 80-6 8-91 4-5 7-9 602 7-8 10 5 7 9-20 2-5 8-9 31-2",
    ": 5-6 40-5 50 3-4 8 60-1 3 6-7 70-8 81-2 4 90 2 4 9-701 3 5 7-9 13-5 7-21 3",
    ": 5-30 2 5 41 4-8 50 2 4 6 8-64 6 8-71 3 5 7 82 4-5 7-90 5-7 800-2 4 6 8 10-1 3",
    ": 5-6 8-20 4 7-32 4-5 9-40 2 4-5 7-50 2 4-6 60-1 3-4 6-8 70-3 5-7 9-92 4-6",
    ": 9-900 3-16 8-9 22 4-5 7-9 31 3-7 9-40 2-9 51-2 4 6-7 62 7 9-70 2-81 4 6-7 91",
    ": 4-9",
    ": 30001-3 5-8 10 2-4 7 9-22 4-6 8 31-2 4-41 4 6-51 3-7 9 61 9-71 3 8-80 2 4 6-9",
    ": 93 8-100 4 6 8-9 11-3 9-24 6-7 9 31 3-44 6-8 50 4 6-60 2-5 7-9 71 3 5 8-9 81",
    ": 4 6 9-91 4 6-202 5 7-11 3-4 8 21-2 4-6 8-30 2-3 8-41 4 6 8 53-4 9-65 7-70 3",
    ": 5-8 80 6 8-92 4-302 5 10-1 4-5 9 22 4 6-8 30-5 7 9 41 3 5-50 2 4 6-7 9-64 6",
    ": 8-71 3-5 7-8 81 6-9 92-6 8-9 404-9 11 5 7-8 20 2-3 5-9 31 3 5 8-44 9 52-6",
    ": 8-62 4-7 9-74 6-7 9-80 2-4 6-90 5-6 8-506 8-9 11 4-5 7-8 23-6 8-31 3-5 7 9-41",
    ": 3-8 52 4-9 62 4-7 9-70 2-5 8-81 3-4 8-92 4-7 9 601-8 10-1 3-22 4-5 7 9 31-3",
    ": 7-9 42-4 6-7 51 3-7 9-67 9-72 4 6-80 4-6 90-1 3-5 7-700 4-12 5-20 2-3 6-9",
    ": 31-6 40 2-4 8-54 6 8-60 2 6 8-72 4 7-9 81-4 6-7 94-7 9 801-3 5-6 9-10 2-5 8",
    ": 20-3 5-8 32-7 40 2-4 6 9-51 4-8 60 2 5 8-9 71-2 4-6 81 3 5-90 2-902 5-7 9 11",
    ": 3-6 8 21 4 6-7 30 3-40 3 5-6 8-9 52-8 60-5 9-70 2-3 5-6 8-81 3 5 7 91-2 4",
    ": 6-1000 2-4 6 9 19-21 5-7 9-30 3 7-8 41 3-6 8-56 8 60-1 5-7 9-71 4 6-8 80 3-9",
    ": 91-3 5-6 8-105 8 10 3-5 7-20 3-5 7-8 30 2 4-9 41-3 5-6 8-9 51-2 4-66 8 70-4",
    ": 81-2 4 6-8 92 5-6 8 200-1 3 5-6 9-12 4-5 8 20-3 5-8 33-4 6 8-9 41 3-7 9 51-7",
    ": 61-2 4-7 70 3 5-6 8-9 81-3 5-7 9 91 3-305 7 9-11 3 5-6 8 20-2 7 34-9 42-50",
    ": 3-4 8-61 3 5 8 73-9 81-3 5-9 91 3-402 4 7-9 12 4-5 7-20 2-5 7-32 5 7 9 41-2",
    ": 4-5 7 9-51 5-6 9 61 5-6 9 71 3 5-83 5 7-8 90 2-4 6 9 501-3 5-8 11 5 7 20 3-8",
    ": 30-2 4 6-42 4-5 7-54 8-60 3-4 7 9 71-5 8-80 2-6 8-91 4 6 8 600 2-3 5-7 9-10 4",
    ": 6-8 22 4 6-7 9 32 4 6-7 40-3 5-6 8-51 3 6 9-60 5 7-72 5-8 81 3-6 93-4 7-8",
    ": 701-3 5 7-9 11-3 5-9 21 3-5 7 9-35 8 40-1 3-5 7-8 50-1 5-7 9 61-2 6-7 9 71-2",
    ": 5-81 3 7-93 5-9 801-3 6-8 10-1 3-7 23 6 9 31 3 8-9 41-4 7 54-5 7-9 61-3 5-73",
    ": 5-80 2 4-91 3-4 6 8 900-4 6 8-12 4 7-8 21-2 4-7 30-1 5 8-40 4 6 8-50 3 6 8-63",
    ": 6-7 9-77 81 5-7 9-90 2-6",
    ": 8-2000 3-5 7 10 3-5 22-3 5-30 2 4-5 7-8 40 2-3 5-9 53 5 8-60 2-3 5 7-9 74 7",
    ": 82 4-5 7 90 2 4 6 8-101 3 5-6 9 11-2 5-6 8 20 3-6 8-38 41 3-4 7-52 6 8-63",
    ": 5-70 7 9-83 7-9 91 4-5 7 9 202 5 7-10 2-8 21 3 31-3 7 9 41 3 6-7 9 52 4-63",
    ": 6-71 3 8 83-8 90 2 5-9 302-7 10-3 5-8 20 2-7 9 33-5 8-40 4 6-7 9 51-3 5-8",
    ": 60-1 3 6-74 8-84 6-90 2-5 7-401 4-5 8-9 11-3 5 7 9 21-2 7-8 31-3 6-7 40-5 7-9",
    ": 51-7 61-7 71-4 6-80 2 6-91 4-9 501-8 11 4 6-21 3-6 9 31-4 6-8 43 5-6 9 51-2",
    ": 4-6 9 64 6-8 70 3-5 7-80 2-8 90-3 6 9-601 3-7 9 11 4 6-8 20-2 4-5 7 9-30 2-3",
    ": 5-6 40-3 5 7-50 2-3 7-60 2-3 9-73 5 7-9 81-2 5-7 90 2 6-9 701-5 7-10 2 6-9 22",
    ": 5-8 30 4 7-40 3-7 9-51 4-6 8-60 2 5-70 6 8 81-2 5-6 8-92 4 7-9 804-5 7-8 10-2",
    ": 5 7 21-5 7 9-30 2-9 42-5 9-50 2-5 8 61-5 8-74 6 8-85 8-90 2 5-8 900 2 4 7-8",
    ": 10-2 4 6-23 5-7 9 31-2 4-5 7-42 4-6 8 52 4 8-60 2-4 7 9 71-4 6-7 9-80 7 93",
    ": 5-8",
    ": 3000-15 8-21 5-8 32 5-6 8-9 41-4 6-8 51-5 7 60 2-70 2-8 81 6 8-90 3-5 7-9 101",
    ": 3-13 5-6 8-9 21-2 4-7 9 31-41 3-50 2-63 6-8 70-1 3-5 7 9-80 3-8 92-202 4-5",
    ": 7-8 10-7 20-5 7 30 2-3 5 7 9-40 2 4 6 9-55 7-8 61 3 5-70 4-6 8-81 3 5-7 90-2",
    ": 5 7-9 306-8 10-6 8-23 5-8 30-2 5 7 9-40 2 4-6 8 50-1 3-60 2-9 72-6 8 80-90",
    ": 2-4 6 8-401 3 5 9-13 5 7 9 22 5-6 8-34 6-7 9-55 7 60-3 5-7 9-76 8-84 7-92 5 8",
    ": 500-2 6-11 3-6 20-2 4 6 8-30 5 7-8 40 2 4 6-50 2 4 6-9 61-2 4-7 9 71-2 83 6-8",
    ": 91 3 7 602 4 6 9 12-3 5 9-26 8-30 2-40 4-7 50 2-6 8 62-4 6 8 71 3-6 8 80-1",
    ": 3-4 7-96 700 3 5-7 9-10 2 5 8-21 5-6 8 30 3 5-6 8 41-3 5-50 2 4-7 9-60 3-5",
    ": 7-74 6-9 81 4 6-7 9-91 3 5 801 4-5 7 9 11-5 7 22-7 30-1 5-6 8-40 4-8 50-1 3",
    ": 6-8 62-5 7-8 70-2 7-8 81 4-8 90 2 5-901 4-5 7-8 11-2 5-7 22-4 7-32 4 6-42 5-7",
    ": 9 51-3 5-6 8 61-2 4-5 7 9-71 3-8 80-90",
    ": 3-4006 9-10 2 4-8 20-1 3-8 31-3 5-42 4 6-8 52-6 60-1 3-4 6-70 4 6-7 9 81-2 5",
    ": 7 90-3 5-101 4 9-10 3-5 8-20 2 4-6 8 32 4 6 8-40 2-4 6-8 50-3 5-7 62-3 5-7",
    ": 9-70 2-3 5 7 83 5 7-8 91 3-8 200-1 3 5 8 11-5 7-22 4-30 4 6 8-40 2-3 6 8-50",
    ": 4-7 63-4 6-7 9 75 7-80 2 4-5 7-8 90 2-4 8 300 4-6 9-20 2-3 6-7 9 31-7 42-3",
    ": 5-7 9-59 63 5 7-70 7 9-80 3 5-91 3 5-7 9 402-9 11-8 20-1 3-4 6-8 31-2 4-5",
    ": 8-48 52-6 8 64-8 70-3 5 8-80 5-6 9-95 8-9 503 5-7 9-10 4 6-28 30 2-5 7 40-7",
    ": 9-52 5-9 61-2 4-5 7-8 71 3-6 8 80-6 9-91 3 5-6 9 601-4 6-7 9-11 3-25 7 9-31 5",
    ": 7-9 41 3-7 9-50 2-4 6 60 2-72 4-82 4-8 91 4-8 700 6-7 9-20 5-6 8 32-5 7 40",
    ": 2-52 5 7-60 2-6 8 70-3 7-85 7 9 91-3 5 7 9-802 4-5 7 9-12 4-32 4 6 8 40 2-5",
    ": 51 3 5 8-9 61 3-4 9 71 4-5 81-3 6-9 92-4 6 8-9 903-5 7 9 11-5 7-22 6 9 32 5-7",
    ": 9 41-2 4 7-56 8-63 7-78 81 3-4 6-96",
    ": 9-5002 4-7 9-15 7 20-3 5 7-8 31 3-6 8 42-5 8 50-1 4-7 9-60 2-6 70-1 3-4 9 81",
    ": 4 6-93 5-100 2-7 9 11-6 8-20 2-4 8 30-3 6-8 40 2 4 7-8 50-2 7 61-6 70-5 8-83",
    ": 9 92 5 9-200 3-4 6-9 11-21 3-5 7-33 6-7 42-57 60-1 3 5-7 9 71-4 8-80 2-7 9-91",
    ": 3-300 2-3 5-11 4-5 7-8 21 5 7-31 3-4 7 9-40 2 4-6 9-51 3 7-8 61 3-8 70-3 5",
    ": 7-8 80-6 8-93 5 7-8 400 3-5 8-10 2-3 7-8 21 4-6 8-9 31-40 2-9 51 3 7 9 61-2 4",
    ": 6 9 71-2 4-6 8-80 8 90 4 7-515 7 9 21 4 6-31 3 5-42 4-5 7 9-53 5-60 4 70-6 8",
    ": 80-1 3 6-9 91-2 6-8 600-6 9 11-3 5-6 8-21 3 5-9 31-2 4-5 7-9 41-6 8 50-1 3-5",
    ": 7-60 3 5-76 9-87 92 6-7 9-700 2 4-5 7 13 7-8 20 2 4-7 9 32-3 5-7 43 5 7 50",
    ": 3-65 7-8 70 4-5 7-81 7 9 92-4 6 8-800 2-6 8 10-1 3-5 7 9-21 3-9 31-43 8 50",
    ": 5-7 60-2 6-8 70-1 3 5 8-84 6-8 90-3 5-6 9-903 5 11-4 6 9-24 6 30 3-6 9-41 5-8",
    ": 50-3 6 8 60-1 3-73 5-8 80-92 5-7 9",
    ": 6001 3-5 11 3 5 7-8 20-33 5-8 40 2-4 6 8-52 4 6 8 60-80 2 4-8 90-1 3-7 100-1",
    ": 3-8 10-1 3-7 9-24 6 8 30 3 5 7-44 53 6-62 4-76 8-86 8-91 3-6 8 200-2 5 8-10 3",
    ": 6 8 22-3 6-7 32-4 6-40 2-3 5-7 9 52-9 61-3 6-9 71 3-4 7-9 84-92 5 7-301 3",
    ": 6-13 5 8-21 5-8 30-4 8-40 4-7 51-2 6-7 9 61-2 4 6-71 5 7 9-81 3-5 7-9 91 3-4",
    ": 6 8-9 401-3 5-9 11-5 7-8 20-4 6 9-34 6 8-41 3 5 7 9 51-4 6-64 6-71 3-5 7-9",
    ": 81-2 6-98 500 4-12 4 6-7 20 2-7 9-30 2-8 40-1 4 6-7 54-8 60-2 4-7 70-7 80 3",
    ": 5-6 9 92-4 7 9 601-3 6-7 9-12 5 8-9 21 4 7-8 30-1 4-6 8-43 8-50 3-4 7-8 60 4",
    ": 7-8 70 3-6 8-82 4-6 8-9 92 4-5 7-9 701-2 4 7-8 10-5 7-8 21-7 9 32 4 7-9 41-2",
    ": 4 6-7 9-51 4-7 9 62-3 6-9 71 3 5 7-82 8-96 8-9 803-5 9-13 5-23 6-31 3 7-42 5",
    ": 7 9 52-3 6-8 60-7 70 2-3 5-80 3-8 90-7 9 901 3-5 7-8 11-5 9-21 6 8 31-2 4",
    ": 9-40 3 5-6 8-53 7-9 61-6 70-2 4-8 83 5 90 2-5",
    ": 7000-2 4 6-8 11-2 5-20 2-6 8 30-1 3-6 8 40 2 5-7 9-51 3 5-60 2-71 4-6 9-81",
    ": 3-7 90-3 101 3 5-6 8-12 4-9 21-4 8-31 3-5 7-8 40-3 5 7-9 51 3-6 8-61 4-6 8-76",
    ": 8 81 5 7 9-201 3-6 8 10-1 3-21 3 5-33 5-6 9-42 5-6 9-52 6-7 9-60 5-76 82 4-6",
    ": 9-91 3-5 7-9 301-5 7-8 12 6 9-20 2-3 5 8-9 31-3 5-40 2-3 5-9 51-4 6-7 61-5",
    ": 7-74 6 82-9 91-5 7-401 4-7 9-19 21-4 6-7 9-30 2-4 6 8-42 4 8 50-2 4-5 9 61-2",
    ": 4 7 9-73 5-7 9-82 4-5 7-9 91-2 6 503-4 6-9 11-2 4 6-7 9-25 7-33 5-40 2-5 7-50",
    ": 2-8 60 2-4 6-7 73 5-6 80 2-92 4 6-9 602 4 6-8 10-5 7-8 20-1 3 5-41 3-7 9-50 2",
    ": 5-8 60 2-7 9-70 5 7 9 81 3 6 9-90 2-3 5-700 3-4 6-8 10-2 5-9 24-8 31-4 8-9",
    ": 41-3 5 7-61 4-7 9 72-7 9-82 5-7 9-92 5-7 9 801-4 6 8 10-5 7-8 20 2-7 9-36 8",
    ": 40-2 4-7 9-52 5 7-8 60 2 5-6 8-71 3-4 7 82 4-5 8-92 4 7-8 901 4-6 10 4-8 20-1",
    ": 3 6-8 30 2-42 4-6 8 50-3 6 60 2-5 9-71 3-7 9-80 3-6 8 90-1 3-8",
    ": 8000-1 6-9 11-3 8-25 7-8 31 3 5-9 41 3 5-52 4-9 62 4 8-73 6-80 2-4 6-91 3 8",
    ": 100 2-6 10 4 6 9 22 4 6 8-9 31-3 6-7 41 3-4 7-56 8-61 3 6 8 71-3 5-6 8-9 84 6",
    ": 8 91-5 7 9 202 5-7 9 17-24 6-30 2-4 6-42 4-7 9 52 4-5 60-2 4 7-70 2 4-80 2",
    ": 5-92 4 6-8 300-1 3 5 7-8 10 2-7 9-22 6 8-33 8-40 3 6-8 51-2 4 6-60 2-3 5-6 8",
    ": 73 8 80 3 8 92-4 6-7 9-406 8-10 2 5 8-24 7-8 30-1 7 40 3-6 8 50 7 9-60 2-7",
    ": 9-73 5 8-80 2 4-6 90-4 6-501 4-6 9-12 4 6-9 22-3 6-8 32-3 7-8 40-3 5-6 8-9",
    ": 51-61 4 8 71-2 8-81 4-5 9-90 2-4 6 8-9 602-5 7-15 7 9-23 5-32 6-7 40-1 4 6-8",
    ": 50-1 3-6 8-9 61-3 7 9-70 2-4 7-8 80-4 7-8 91 5-7 9 701 4 6-11 3 6 21 4-7 9 31",
    ": 3-8 42-5 51-2 4-8 61-8 70-1 4-83 5-91 3 5-7 9-800 4 6 8-10 2-3 5 8-22 4-5 7 9",
    ": 31 3-6 8-40 4 7-53 5-8 61 3-8 70 2-3 5-7 80 2 4-5 7-92 4-5 7-903 6-7 9 11-8",
    ": 21 4 7-9 32-6 8 40-1 3-4 6 8-9 51-5 7-9 61-3 5-9 71-3 6-9 82 4-90 2-3 5-6 8-9",
    ": 9001-5 7-10 3-9 21 3 5 8-9 31-4 6 8-41 3 5-6 9 51-2 5-7 9-64 70 2 6 8-83 5",
    ": 8-9 92-3 5-6 100-2 4 6-9 12-4 7-20 2 4-5 7 9-30 3 6-8 40-6 51 3 5-7 9 62-6",
    ": 8-71 3 6 8-82 5-6 9-93 7 9-203 6 8-9 12 4-27 30 3-4 6-40 2 4-8 51-2 4 6 9-62",
    ": 4 6-7 9-73 5-6 8-80 3 7 90-3 7 9 301-3 5 9-11 3 6 21-2 6-9 31-6 8 40-2 4-5 7",
    ": 50 2-6 8 60-2 4 6-7 9-70 2-4 7-80 2 4-8 90-5 7-402 4-9 11 3-6 8 21-37 41-4 6",
    ": 8 52-3 6-69 71-2 5 7 9-80 2 5 7 9-90 2 4 500 2-4 8 12 4 6 8-21 3-5 7 9-30 2",
    ": 5-6 8-43 5 8-9 51 3 6 8-9 61 3 5-9 71-3 5-82 5-8 91-4 6 9-601 4 8 10 2-3 6-9",
    ": 21-2 4 6-30 4-44 7-50 2 4-8 60 3 5-7 9-70 2-8 80-6 9 91 3 5-6 8-9 701-8 11-35",
    ": 7-8 40 5 7-50 5 7-61 3 6-7 70 2-8 80-1 3-7 9 91 4-5 7-9 801 3 5-7 9-23 6-30",
    ": 2-3 9 41 3-7 9-53 5-8 60-70 2-80 2-4 7-9 91 3 5-7 9-900 2 10-3 5-20 4 7 9-30",
    ": 4 8-44 7 50-9 61 4 6 8 70 2-9 84-92 4-5 7",
    ": 9-40002 4-8 11-2 6-7 9 21-7 9-30 2-3 6-7 9 41 3-5 7-8 50-2 4-62 4-5 7 9-72",
    ": 4-6 81-5 8-92 5 7 9 101 9-15 7-20 2-9 31 3 5-40 2 4-5 7 9 51-63 5 7 9-70 3-4",
    ": 6-81 3-5 7 9-94 6 8 200 2-10 2-3 5-6 8 20-2 4-5 7-8 30 2 4-5 7-8 40 4 6-50 2",
    ": 4 6-60 3-4 6 8 71-5 7-83 5-6 8 91 3 6 8-300 2-4 6 8-9 11-4 7 9 21-2 5-9 31-2",
    ": 4-5 7-40 3-4 6-7 51-3 9-60 2-5 8-72 4 9-80 2-3 5-93 8-400 4 6 9 11-5 7-8 23",
    ": 5-30 2-3 6-9 43-5 8-9 51-2 4-63 5 7-9 74 7 80-1 3 5 7-94 6-7 9-500 3-4 6-9 12",
    ": 5-6 8-21 3 5-8 30 3-5 8 40-2 4 7 9-54 6 9-67 9-78 82 4-6 8 90 3-4 6-7 9-600 2",
    ": 4-5 7 9-10 6-8 25 7 30-9 41-8 50 3-4 7 9-65 7-8 70 2-7 80-1 5-7 9-90 2-5 9",
    ": 701-6 8 10-3 5-24 6-7 9-30 3 7-9 41-3 6 52-4 6-8 60 3-74 6-91 4-803 10-2 4",
    ": 6-24 6-8 30-1 5 7 41-3 5-7 50-1 4-9 61-5 9-72 4 6-80 2-90 4 6 8 900 2 4 6-7 9",
    ": 11-5 9-20 2-3 5 8 30-2 5-8 40 2-7 9-59 61-9 71-7 80-3 5-9 92-5 7-8",
    ": 1000-2 4-7 9-12 5-8 22 6 8-30 2 5 8-40 3 6-8 51-68 70-2 4 6-8 80-1 3-4 9-93 5",
    ": 7-100 2-3 6-10 2-3 6-9 22-6 31 4-43 6-7 50-5 8-9 61 4-6 8 70-2 4-6 9-83 90",
    ": 2-8 200-3 6 8 10-1 3 7 9 21 7 30-1 4-41 3 5-8 50-8 60 2-5 7-76 9-83 5-90 2-4",
    ": 6-8 300 6-7 9 11 3-5 8-9 21-7 9 31-2 4-5 8 40-4 6-9 52-4 6-8 62 4 6-71 7-9",
    ": 84-6 94-7 9 402-6 8-10 2-3 5 7 20 3-4 7 34-7 9 42 4-6 8-58 60-70 3-9 81-7 9",
    ": 91 5 501 3 5 7-8 10-3 7-21 4 6 8-34 6-9 42-4 6 8 53-6 8 62 4-7 9-72 4 6 9-82",
    ": 4-9 92 5 7-8 600-2 4 6-8 10-4 6-20 5-6 30 2 6 9 41 3-7 9-51 3 6 60-2 4 6-71",
    ": 3-83 5-6 8 91 4-5 9 701-2 4 6-7 9 11-6 8-9 24 6-9 31-2 4 6 9-40 2-7 9 52 4-8",
    ": 60 2 7 74-5 7-8 80 2 4 6 9-99 802-9 11-2 4 6 9 21 3 7-8 30 2 4-5 40-2 4-5",
    ": 9-51 3 5-63 5 7-8 72-3 5-7 9 81 3 6 8-90 3-900 2-6 9 11 5 7-8 20-3 5 7-8 30",
    ": 2-8 40-2 5-6 8-9 51-2 6-7 60 3 5-6 8 72 4-80 3 5 7 9 91 3-5",
    ": 2000-4 6-7 10-1 3-4 6 8 22 4 6 8 30 3 6-8 40 2-4 8 51 3-5 7-9 61-2 7-73 6-81",
    ": 7 9 91 3 5 7-103 5-11 4-6 20 2-5 7-9 31-2 4 6-7 41-4 6-8 55-6 8 61-2 4-6 8-9",
    ": 71 4-6 8 82-3 5-9 93-4 6 8-200 2 7 9-11 5-8 20 2 4 8 30-1 3-5 7-44 6-8 51-2",
    ": 5-6 8-9 61-2 4-9 71-3 5-7 9 86-7 9-90 4-301 3 5-6 8-10 2-6 9 21-4 6 9-33 5",
    ": 7-8 41-50 3 6-62 4-7 9 71 3-7 81-3 5 9-93 5-6 8-410 2 5 7-21 3-4 6-7 9-37",
    ": 9-40 2-5 7 9 52-4 6-9 61-5 9-71 4-6 80 2 4-9 91-6 501-2 4-11 3-8 20-3 6-7 31",
    ": 3-4 7 9-44 6-50 2-5 8-61 3-4 6-9 72-5 7-84 6-9 91-4 7 601-3 5-9 12-5 8 25",
    ": 7-30 2 5-7 9 42-7 9-52 5-6 8-65 7-73 6-9 81 4-7 90 2-3 5-9 701-2 4-5 7 10 2",
    ": 4-5 7 9-21 3 6 8 30-41 3-50 2 4-6 8 60-2 4-5 70-5 7-82 4-6 8 91 4-6 8 800 2-4",
    ": 6-8 10 3 8-22 4 6-8 34 7 9-43 5 9 51 3-4 6-7 9 62 4 6-73 5 7-8 81-2 7-9 92",
    ": 6-7 9 903 6-16 8 21 3 5 9-30 2 4 7 40 2 4-5 8-50 3 60-1 3-5 9 71-3 5-81 3-4 6",
    ": 8-9 92",
    ": 4-3004 6 8 10-21 4-7 9-30 2 5 7-40 2-5 7 51 4-5 62-3 5 7-9 71-2 6-83 8-90 2 4",
    ": 6-102 4-10 2-4 6 8 20-9 31 3-5 7-8 40 4-7 9-57 61-6 9 72-5 8-9 82 4-90 2 5",
    ": 7-9 201-2 5-11 3-4 6-8 20-2 4 6-9 32-3 5-40 2 5-8 52-4 6-64 7-70 2-81 3-7 9",
    ": 91-2 4 6-7 9-300 3 5-7 9 11-6 8 20 2-6 8-9 31-2 5 7-9 42 4-5 7 9 52 4 6-7 9",
    ": 63 5 9 71-3 5-6 82-5 8-9 92-7 9-402 4 10-1 4 7-8 20-3 5 7-9 31-2 4 8 40-4",
    ": 8-52 4-60 2 4-6 8 70-6 8-80 2 5-8 90 3-6 9 502-4 6 9-11 3-4 8-9 22-7 30-4 7-8",
    ": 40-4 6-56 9 61-72 5-6 9 81-3 5-8 94-7 601 4 6 10-26 8 30-1 4-7 9-40 2-3 5",
    ": 9-51 8-65 7-71 3-5 7-83 5-7 9-93 5-9 701 3-7 9 12-4 7-9 24-5 7-30 3 5 7-44",
    ": 6-8 50-2 4-6 62-3 6-70 3-7 9 81-4 7-90 2-3 6 802 4-5 8-9 11-2 4-20 2-4 6-7 30",
    ": 3-4 6-9 41-2 4-7 9-50 2 4-6 8-61 3 5-71 5 9-80 3 9-90 2 5 7-909 11-2 7-8 23-4",
    ": 8-9 31 3-40 3 6-8 53-4 6 8-9 61-4 6 8-9 71 3-4 6-87 9-92",
    ": 4-4002 7-9 14 6 9-22 9 32 5-7 9-43 5 7-50 4-9 61-7 9-71 3-5 7-8 82 5 8 90-4",
    ": 7-9 106-7 11-3 5-22 4 9-30 3-8 43-8 50-2 4 7-9 61-3 6 8 71-2 4-6 81 3-8 90 3",
    ": 202-5 7 9-11 4 22-6 8-30 2 4-6 9-45 7 9-57 9 62-4 6 8-70 2-5 7-9 81 3 5-90",
    ": 2-300 2-5 7-9 11-2 6-8 20-2 5 7-34 6-40 5 7-50 2-4 6 8 61-7 71-6 81-5 7-9",
    ": 91-2 4-6 404-5 8-9 11-2 4-8 20-1 3-5 7-8 30 3 5-8 40 3-52 4-7 60 2-5 7-9 72",
    ": 5-6 8-88 90-2 4-6 8 500 4 6 8-10 7-8 20 2-5 7-8 30 2 4 6-40 2-3 6 8-50 2-4 6",
    ": 9 66 8-9 71-5 7-9 81-3 6 8-91 3-6 9-601 3 5-8 11-6 8-9 21-7 9-32 4 7-9 41 3 6",
    ": 8-9 51-2 8-60 3-5 7 9-70 2-3 5 7 9-80 3-4 8-9 94-6 8-707 13 5 7-29 31-4 6-9",
    ": 42-6 8 50 3 5 7-61 3-5 70 2-3 80-3 5-6 8 90-4 7 800 2 4 6-7 9-10 2-5 8-22",
    ": 4-33 7-48 50-1 3-7 60 2-4 6-71 4-81 3-4 6 8-90 2-8 900 2-9 11 3-4 8 21-2 4-7",
    ": 31-3 6-8 40-1 3-5 9-53 6-7 9 61 3 8 70-2 4 6 80-90 2 5-8",
    ": 5001-2 4-5 7-9 11-2 4-20 2 4-5 7 32-4 6 8 40-5 7 50-3 6-62 5 7-73 5-81 3 5-7",
    ": 9-91 3 5-7 9 101 8-13 5-6 9-20 2 4 7 9 31-2 4 6-9 41 3-4 8-9 51-4 6-7 9-60 2",
    ": 4-5 8-70 2-5 9 82-9 91-7 9-200 3-5 7 9-12 4-5 7 21-5 7 9 31-2 6-8 40-3 6 51-2",
    ": 5 7-8 61-8 70 2-3 5-80 2 4-7 9-92 5-7 9 301-5 7-8 13 5 8 20 2-33 5-6 42 4-5 8",
    ": 51 6-9 64-6 8-72 4 7-84 7-8 91-2 4-5 7-8 400-5 8 10-3 5-7 21-2 5-8 30-4 8-44",
    ": 8-9 51-6 61-70 2-3 6 81 4 90-5 7 501-4 8-9 12-8 20-1 3 5 7 9-30 2-4 8-40 2-4",
    ": 7-9 52 4 6 8-9 62-9 73-8 81-97 9-600 4-7 9 11 3-8 20-2 6 9-30 2-8 42-4 6 52-3",
    ": 7 9-60 3-5 7-73 5 7 9-83 5-8 90-1 4-706 8-14 8-20 9-31 3-4 6-7 9 41-9 51-2",
    ": 5-8 61-6 9-70 2 4 8-81 3 6-90 2-5 804-8 10 2-5 7-21 4-5 7 31-2 4-5 8-9 42",
    ": 5-50 2-3 5-61 3-5 7 9 71 3-5 8 80-3 7-90 2-4 6-900 2-5 7-8 12 4-7 9 21-9 31-4",
    ": 7-9 41-2 4 8-52 8 61 3 5 70-4 9 81 3-6 9 91 3 5-8",
    ": 6000 2-6 9-10 2-3 8-21 3-4 6 8-9 31 3-43 5-9 51 4 8-61 3 8-71 4 7-9 83-93",
    ": 5-100 4-6 8 11-3 6-8 22-6 8 30-1 3-9 42 4 6-7 9-51 3-60 2 4 7-71 3-4 8-9 81-2",
    ": 5-95 7 200 3-6 8-10 2 5 7-9 21-6 8 30-1 3-7 9-40 2 5-52 4 9-62 4-6 9-74 6-8",
    ": 80 2 5-7 9 94 6-9 301 3-6 8-10 4-6 9 23 6-36 8-42 4-52 4-8 60-1 71-5 7 80 2",
    ": 4-5 7 9 91 8-400 2-4 6-7 9 11 3-4 8-22 5-7 9 31-2 5 8 40-6 50-8 60-70 3 6-82",
    ": 4 6-92 4-6 9-500 2 4 6 8 12-7 9 21 4-8 30 3 5 8-9 41 3-4 6 8-9 51-4 6-62 4-5",
    ": 7 70-1 3-6 8-80 2-3 5-7 9-92 4-602 4-5 7 10 3 5 20 3-5 7-8 31-4 6 8 41 3 5 7",
    ": 51 3 5-6 8-60 2-4 8 70-4 7-9 81 3-5 7 90-4 7 9-700 2-8 11-5 7 9-20 2 4-8 33-5",
    ": 7 9-41 3 7-50 2 4 6-8 61-2 4-7 9-70 3-5 7 9 81-3 5-8 90-3 5-6 8 802-4 6 8-11",
    ": 4-7 20 6-9 31-4 6-42 4-5 7 9-52 4-60 2-8 70-1 6-8 81-4 8 90-8 900-2 5-6 9-11",
    ": 4-9 21-3 6 8 32-6 8 40-1 3 5 7-56 60 2-8 72 6 8-82 4 7 92 4 8",
    ": 7000 4 6-7 10-3 5-6 20-3 5-7 9-31 3-5 7-41 3 5-7 9-50 3 5 7-9 61 5 7-8 71-4",
    ": 6-7 9 82-4 6 90 4 6-9 102-8 10-2 6-8 26 8-34 6-8 41 5-51 5-6 9-60 2-5 7 9",
    ": 72-3 5-6 8 81-5 8-90 2 4 7-204 6 8-15 7-8 20-5 30 5-6 8-44 51-4 9 62 4 8 72-3",
    ": 5 8 80-8 91 3-9 301 4 6 9 11-5 7-9 21 4 7-30 2-4 7-42 4-5 7-8 50 2-3 6-9 61-4",
    ": 6 8-72 4 6-8 80 4-9 92-9 402-8 10-1 4-5 7 21 3-5 8-9 31-2 7-8 41-3 5-8 50 2-3",
    ": 9-63 5 8 71-6 8-81 4 6 8-9 91-7 9-505 8-11 3 5-6 8 23-4 6 9-32 5 7 9-44 6",
    ": 8-50 5 7-8 60-6 8 70-1 3 6-9 81-2 5 7 9-92 7 9-600 3-6 8-10 2-4 6-8 21-2 4-5",
    ": 7 9 33 6-7 9-40 2 4-6 9 51-4 6-8 60-1 3 5-8 71 3-80 2 4-6 8-95 7-700 2-3 9-10",
    ": 3 5 7-8 20 3-5 8-9 31-3 7-8 40-2 5 7 9 51-3 5-6 9-63 5-6 8-9 71-2 4 6 8-82",
    ": 4-8 90-9 801 3 5-10 5-8 20-1 3 6 8 32-40 2-52 7 9-63 5 7 70-1 80 5 8 91 8 900",
    ": 2-4 7 9-12 7-8 21 3 6-7 9 31-3 6 8-42 5-55 9-60 2 4-5 7 9-72 4 6-7 9-80 2-4 6",
    ": 91-4 6-8",
    ": 8000 3-6 8-10 3-7 20-3 5-39 41 3 7 9 51 4-5 7-63 5 8-9 73-5 7 81 3-5 8-90 2 5",
    ": 7 102-3 6-18 20-2 4-7 9-44 6-9 52-4 8-60 2-3 5 70 3-4 6-86 8-90 2 5-6 8-9",
    ": 203-4 9-12 7 9-20 3-5 7 9 31-3 5 7-41 3 51-4 7-60 2-4 7 9 72 5 7 82-3 5 7-8",
    ": 90-1 3 5-307 10 3 9 21-3 5-32 6-8 40-4 6-7 9-51 3-4 8-9 61-4 7 9 71-2 4-6",
    ": 82-4 6-7 90-2 4-5 7-8 402-4 8 10-1 3 5-30 2 4 6-7 9-43 7-53 5-9 61 4-73 5-8",
    ": 82 4-6 9-94 6-501 3-6 8-9 11-5 7-21 3-32 4 6-8 40-2 4-5 8 50 2-6 8-63 6 70-82",
    ": 4-6 8-97 9-607 9-11 3 5 7-8 20 2 4-7 31-9 48-55 9-60 2-3 8-71 3-5 8 80-8 91 3",
    ": 5 7 9 703-4 6-8 10 4-5 9 21-5 7-31 5-7 41 3-4 50 2 4-6 8-72 5-6 9-82 5-9 91-9",
    ": 801 3 5-7 9-21 3 5-8 30 2 4-45 7 9 52 6 8-62 7-8 70-1 3 5-83 5 7-93 5 901 3",
    ": 6-9 11 3 7 9-21 4-6 8-34 6 8 40 2-5 8-50 4 7-9 61-73 5 8 80 3-4 6-7 9-94 6-9",
    ": 9001 3-8 11 3 6 9 21-30 2-3 5-9 41-2 4 6-51 3-4 7 60-8 70-1 3 5 8-80 2 5 8-9",
    ": 91-7 100-3 5-8 11-2 5-7 22 5-9 31-4 9-40 2-8 50-3 7 9 61-3 5-8 70-1 4-6 8 82",
    ": 4 6 92-4 7 9 208-12 7-25 7 30 2-3 5-8 40-5 7 9-51 4-5 9-61 3-4 8-74 6-82 4-5",
    ": 7-96 8 301-3 5 7-8 10 3 5-7 21 4 7-33 5-7 42 4-7 9-51 3-61 3-4 6-8 70 2-4 6-9",
    ": 81-4 7-400 2 6-18 21-7 9-31 3-4 6 8 40 2 4 6 9 53-8 60-2 4-73 5 7-80 3-5 7-9",
    ": 91-3 5-502 7-9 11 4-7 9-25 7 9 31-3 6 8 42 4 6-7 9-51 5 7-8 61 4 6 71-2 5-81",
    ": 3-5 7-9 91-3 5-6 8-603 9-10 2 4-5 7-8 20 3-7 9 31-3 5-9 42 6-9 52 4-8 60 2 5",
    ": 7-9 71-80 2 4-5 7-8 91-5 7-700 6 8-11 3-5 7 9 23 5 7 32 4 7-8 40-2 4-5 7-51",
    ": 3-4 6 8-63 5-8 70-6 9 81-3 6 8 90 3 5 7-8 800 2-3 5 12-3 5 9-20 3-7 9-33 5-6",
    ": 8-9 42-3 5 8-9 51 3-6 8 60-1 3 5 7 9 71-2 4-7 9 82-5 7-8 90-1 6 8-904 6-11 5",
    ": 7 9-21 3 7-8 30-5 8-9 41-2 5-50 2 4-5 7-9 63 6-7 9-71 3 7 9-81 8",
    ": 94-50004 6 9-10 6-9 21-2 5 7 30 4 6-8 40-2 4-5 8-9 52-3 5-70 2 4-6 8-83 5-9",
    ": 91-3 5-6 9-103 9-12 4 6-7 20 2-3 5-9 32-3 5 8-41 4 6-7 9-52 7-8 60 2 5 7-73",
    ": 7-81 3-4 7-97 9-201 3 5 7-12 4-6 8 22 4-6 8-30 2 5-44 6 8-9 54-6 9-62 5-6",
    ": 8-72 5 8-80 2-3 5 7-8 91-7 300-1 3-4 10-2 4-5 7 9-23 5-9 31 4-9 41 3-53 7-63",
    ": 5-74 7-8 80 3 5-6 9 91 3 5 8-403 5-8 13 9 21-2 4 6-7 9-31 3-8 40-4 6-51 8-61",
    ": 3-4 7-8 71-82 4 8 90-1 4-502 7 9 12 4-9 23-4 6-7 9 33 6-8 40 2-3 5-7 9 51 3 5",
    ": 8-60 3 71 5-9 82 4-5 7-8 90-2 6 601 3-5 7-10 2 4-7 9 21 3 5-6 8-31 5-7 9 41",
    ": 4-9 51-2 5-6 8 61-2 4-5 7-8 70-2 4 6 8-81 3 5-7 90 3 5-6 9-701 5-11 3 5-9",
    ": 21-3 7 30 2-5 7-42 4-58 60-1 4-6 9 74 6 8-82 4 6-7 9-92 4-7 9-804 7 9 11-6",
    ": 8-22 4-32 7-9 41-2 6-8 50 5 8 60-3 6-7 9-83 6-8 90-1 3-4 7-8 900-1 3-6 8-10",
    ": 2-5 7 9-20 2-4 6-30 2-4 7-8 41 3 5 7-51 3 7 9 61 3-6 8-9 71-6 82-5 7-9 91 3-4",
    ": 6-9",
    ": 1001 3-5 8 12 5-8 20-1 3 5-6 9-31 3-4 7-8 40 2-5 50-1 3 9 62-6 8 70 4-7 9-90",
    ": 2-8 103 5 9-13 5 7-8 21-2 4-5 30-1 4-8 41 3-4 8-9 52 5-9 61-2 5-7 9-78 83-4",
    ": 7-9 91-2 4-5 7-208 11 4-5 8 20-4 6-7 9 32-4 7-8 40 2-4 6-7 50-1 3-5 9-63 6-8",
    ": 70 2-8 81-4 6 8-99 302-5 7-9 11-2 4-6 8 21-2 4-5 7-33 9 41 3-4 9 51-2 7 61 3",
    ": 6-7 70-3 5 7-8 80-7 90-1 4-8 400-1 3-4 6-7 10 2-4 8 20 2 4 6-8 30-1 3-4 7",
    ": 9-40 3 7 9 51-5 7 9-60 3-5 7-8 70 2-84 6-92 4 6 8-513 6-20 2 4-6 31-40 2 4-56",
    ": 62 4 8 70 2-3 5 7 81 3-4 6-7 9 91-6 9-602 4 6-7 9-11 3-6 8 24-8 31-6 8-40 4-6",
    ": 8-9 54 9 61 7 70-5 7-8 81-3 6-9 92-3 5-7 701-2 4 6 8-17 9-22 4-6 8 30 2 4",
    ": 6-42 4 6-7 9-51 3 7 9 61-8 70-2 7 9 81 3-8 90-1 3-5 7-8 800 2-3 5-9 11 7-20 2",
    ": 4 6 30 2 4-5 7-44 6-7 9 52-61 3-6 9 72 5-6 81-2 4 7 90 2-9 901-6 8-17 9 26",
    ": 9-35 7 40-3 5-8 51-3 8-64 7-71 3-5 9 81 3 5-6 90 2 5-6 8-9",
    ": 2001-3 5-7 9-11 4-5 7 20-4 6-7 33-4 7 9-40 5 57 61 3-8 71-6 9-95 7-103 5 7-10",
    ": 2-7 9-20 2 6-7 31 3-5 8 40 3-4 7 9 51-4 61 3-9 73-5 8-84 6-8 90 2-7 9 201 3",
    ": 5-9 11-2 4-7 20 2 4 7-8 30 2-7 9-40 3-7 50-3 5-61 5-7 9 77 83 5 7-9 93 6-7",
    ": 9-300 2-15 7 9-20 2-5 7 9-30 4-5 8 43 5 7-8 50-4 8 62-5 7 71 3 80-1 3-7 9",
    ": 91-400 2 4-5 8-9 12-3 5 9-24 6-32 4-8 40-5 7-51 4-66 75-80 2-3 5-6 9-90 3-4",
    ": 6-8 500-1 3-5 7-9 11 4 6-9 21 3-8 30-3 6-49 51-6 9 61-3 8 72-4 8-83 5-7 91 5",
    ": 8-603 5 7 9-13 5-6 8-24 8-30 2-3 5-7 9 41-5 50 6 65 7-8 70 3-6 87 93 5 7-8",
    ": 701-2 4 8-21 4 6 9-33 5 8-40 5-9 52-3 5-7 60 2-3 5-71 3-5 84 8 90-1 3-6 9-806",
    ": 8-18 20-2 4-5 7 9 32-4 6-8 41 9 53-7 61 3-8 70-1 3-4 6-7 9-83 5 7-97 9-900",
    ": 2-3 6-11 6 8 21 4-6 9-38 40-2 4-51 3-4 7-64 9-71 3 5 8-82 5-9 91-6",
    ": 8-3000 4 6-11 4 6-9 23 5-6 31-5 7 40-7 51-2 60-1 71 3-8 80-1 3 5-9 91 3-5 7-9",
    ": 101-3 5-8 11-3 6-7 20 4-5 7 9-30 2 5-41 3-6 8-50 2-6 9-60 2-4 6 8 70-6 8 81-4",
    ": 7 9 92-8 201-4 11 4 6-9 21-2 6-32 4-6 8 40-3 6-7 50-4 6-7 9-63 5-9 72 4-8",
    ": 80-2 4 7-9 91-6 8-302 5 7-11 3 5-6 20 2-4 8 30-1 3-5 8-40 2-50 2 4 7-62 6-7 9",
    ": 71 5-7 9-82 4 7-8 90 4 6 8-401 3-6 8-15 7-20 2 4 6-7 32 4-8 40-1 4-5 7 9-51 6",
    ": 62 4 8-71 6 8-80 3-5 7-91 3-5 7-9 503 5 8-9 11-4 6-23 7-8 30 4-9 41-8 50 3-6",
    ": 8 60-3 5 70-7 81 3 8 91 4 7-603 5 7-10 2-5 8-22 7-8 31-2 5-8 41 7-8 53-6 9-61",
    ": 4-5 9-75 7-82 4-6 8-93 5-6 700 3-6 9-11 3-4 7 9 25-34 6-40 4-5 7 9 52-7 60",
    ": 3-6 73-4 6-7 9 81 3 7-8 90-2 4 6 8-805 7 9-11 5-8 20 4 8-31 3-7 9 41-52 4-5 7",
    ": 9-60 2-5 7-70 2-7 9-93 6-901 3-5 7-9 11-8 20 2-8 30-7 9-41 4-6 9 53-5 61 4-5",
    ": 7 9-85 7-91 3 8",
    ": 4000-3 5-6 8-10 3 5 7 20-1 3-5 8 31-4 6 8-40 2-5 7 9-50 3-4 6-8 60-4 6 8-73",
    ": 5-7 9-83 5 7-8 90-1 3-9 102-12 4-5 7-9 22 4-31 5-6 8-40 2 4-5 7-55 9 61-5",
    ": 7-80 2-90 4 6-8 200-3 5-6 8 10-3 5-20 3-37 40 3-57 9-63 6-70 2-4 9 81-2 4-6 8",
    ": 91-2 4 6-300 2-3 8-16 20-3 5-6 8 32-4 7 9-40 2-5 7-53 5-6 9 61-4 6 9-72 4-5",
    ": 7-8 82 4-9 94-6 8-9 402-3 5 7 12-3 5-9 22 8 31-2 4-6 8-42 4 6-51 3-4 7-60 2",
    ": 5-8 70-1 4-7 9 81 3-5 7-8 91-2 5 8-500 2-4 6-8 10 3-7 9-24 32 5 7 9-40 2 5",
    ": 9-57 9-64 7-72 5-81 4 6 8-9 92-3 5 7-600 3-8 11 7-8 22-3 6 9 32-9 41 3 5-8 50",
    ": 3 5-6 62 4 8-71 3-5 8-85 7-98 700-1 3-11 3-8 20-3 6-7 30 2 4 6-8 40-3 6-7",
    ": 50-1 3-4 8-9 64-6 9-70 2-6 82 4-92 4-9 804 9 12-8 20-31 3-7 9-40 3 5-6 52-5 7",
    ": 9 65-76 9 84-5 7 9-91 3-8 900-3 5-9 13 5 7-9 21 4-5 8-34 6-40 2 4-7 9-59 62-3",
    ": 7-8 70-1 5-9 81-4 8 90-2 4 6",
    ": 5000-1 3 5 8-15 8 21-2 4-33 5-9 41-5 7-51 5-6 60-8 70-2 4-5 8-9 82 4-6 8 90-2",
    ": 4-7 9-110 2 4-9 21-6 8-33 6-8 40-2 5-6 9-55 7-8 60-4 9 73-7 81-3 7-8 90-203 7",
    ": 9-12 4-5 8-21 4 6-7 36-8 40-1 5-6 8 50 2-6 62-9 74-82 4 6-8 90-4 6 9-305 7",
    ": 9-10 2-6 8-25 7-30 4 6-9 41-3 5 7 9-50 2 5 7-64 6-74 6-7 80-3 5-90 2-6 8-400",
    ": 3-6 8 10-25 7 9 31 4-8 40-2 5-6 8-60 5-6 71-9 81-9 91-5 8-502 5 7-9 11 4 9-21",
    ": 4-5 9-32 6-8 42-6 8-9 51 3-6 60-3 6 9-72 5 8-81 3-5 8-91 3 6-603 5-8 10-8",
    ": 20-7 30-2 6-9 42 4-8 50 2 4-9 62 7-72 5-6 8-80 2 4-6 9-91 5 7 9 704-10 4-20",
    ": 3-4 7 30-2 5-40 2-3 5-8 51 4-7 63 7 70 4-83 6-95 800-3 5 7-10 4-5 7-8 20-30",
    ": 2-4 7-43 6-8 50-1 3-60 2 4-5 7-70 2-4 9-83 5-90 3-6 901-7 10-5 8-20 2-3 5-9",
    ": 31 3 5 7-44 7 9 51-2 4 7-9 61-2 4-7 9-70 3-4 6-7 80-93",
    ": 5-6003 8-11 3-8 22 4 7-8 30 3 5-6 8 40 2-6 9-51 3-60 2-8 71 3-5 7 80-2 6-95",
    ": 8-104 8 10-1 5 8-9 21 3 5-36 9 41-52 4-5 7 9-67 9 72-6 9-89 92-3 5-6 8-201",
    ": 3-4 6-13 5-7 20-4 6-31 3 5-7 42 5-6 51-3 6 60-3 5-6 8-9 72-3 5-85 8 90-3 6",
    ": 9-300 2-4 9-10 2-7 20 2-3 5-6 8 30 2-3 5-6 8-41 3 5 8 51-3 5-8 62-7 9 71-2",
    ": 4-7 9-80 2-92 6-402 4 6-16 8-21 3 5-30 2-4 7 40 4 7-51 4-8 60-3 6-71 3-4 6",
    ": 8-82 7 90-1 3-4 6-7 9-501 3-9 11-2 4-7 22-6 8-9 31 3-6 9-43 5 8 50-2 4 6-8",
    ": 60-4 6-7 9 71-4 7-80 2-6 8 91-5 7-9 601-3 6-7 9-10 2-4 8-20 2 5-32 9-42 5",
    ": 9-55 7-64 6 8 74 6-8 80-2 4-8 92-6 8 700-2 4-5 7-11 3 5 7-8 20-1 6-7 9-30 2-4",
    ": 6 42-5 7-53 6 9 71-6 8-82 4-5 8-98 801-7 9-12 4-5 7-21 3 6-7 9-30 3-6 8 40-6",
    ": 8-9 52 5-6 8-63 5-9 73-81 4-8 90-1 3-8 905 7 9 11-6 8-22 5 8-32 4 8 41-54",
    ": 6-61 3 5-7 9-73 5-7 9 85-6 9 91-5 7-9",
    ": 7002-5 11-3 20-4 8-9 32 5-6 8 40-3 6 9-52 4-6 8-61 3-7 9 72 4-80 4-7 90-1",
    ": 3-101 4 6 9-13 21-2 30-6 8-40 3-4 7-9 54 6 9-62 5 8 71 4 6 9-87 91-3 5-201",
    ": 3-9 11 4 6-7 9 21-2 4-5 8-31 3 5-6 41-2 5-7 51-5 7 9-60 2-3 5 8-71 3-5 7-82 4",
    ": 7-95 9-300 2-3 5 7 9-10 3 8-21 3 5-9 31-4 6 8-52 5 8 61-2 4-74 6-8 80-91 3",
    ": 6-8 401-4 6-8 10-3 5-7 20 2 4-5 8 30-5 8 40-2 5-9 51-8 60-1 3-5 8-9 71 5 7-82",
    ": 5-6 8-93 5-7 504-7 9-12 5-7 21-4 7 30-6 8 40 2-3 5-6 8-9 51-6 9-61 6-8 71 3-6",
    ": 8-82 7-92 4 7 600 2-5 7 9-14 6-20 2-4 9-34 8 40-1 3-4 7-51 3-4 7-9 61 3-4",
    ": 8-70 4-5 7-82 4-6 9 91-2 5-9 701-8 10-2 4-5 8 21-30 3 5 7-9 42 4 7-53 5-62 4",
    ": 7-70 2-6 8 80-3 7-95 7-8 800 2-8 10-1 3 5 9-20 2-5 9-31 3 5-6 8 41-6 8-56",
    ": 9-60 2-7 70-1 3-4 6-81 3 7-9 91-3 6 9-901 3-7 9-11 5-8 21-2 5 7 9 31 3-4 6-9",
    ": 43-51 3-9 61-4 6-7 9-73 5-8 80 3-5 8 90 2 8-9",
    ": 8003-6 8-14 6-9 22 6 9-33 5-40 3-8 50 4-7 62-4 6-9 72-5 7 81-6 94-6 101-4 8",
    ": 16-8 22-31 3-4 7 9-41 3-5 8-9 52-65 7 9 73-4 6-8 80 3-6 90-4 7-9 201-2 4-6",
    ": 9-11 3 6-9 21 4-6 9 31-3 6 8 41-4 6-7 51-8 64-6 9-70 3-7 9-80 2 5-7 9 91 3",
    ": 5-7 300 2-15 8 20-3 7-33 5 9 41 3-52 7 9-61 4-5 7-70 5-9 82 4-90 3-6 401-5 7",
    ": 10-2 5-6 20-6 8 31-6 8-41 6-51 4-7 9 61-2 4-5 7 73 7-80 5-7 9 93 5-6 500-14",
    ": 7-29 31-3 6-7 40-1 4-5 7-8 51-2 4 6-65 8-9 72-7 9 81-2 4-6 8 94-6 9 603-4",
    ": 11-2 4-27 9 31-3 41-5 8 50 3 6 60-1 3-72 4 6-84 6-9 93 5-9 701-5 8 10-2 5-6 9",
    ": 24 7 9 31 7-9 41 3 7-57 60-2 5-70 2-9 81-2 6 8-96 8-9 801-2 4-6 10-2 5-7 21-2",
    ": 4 7-8 30 8 40-1 5 7 9 51 3 8-9 62-3 5-9 71-9 83-9 91-3 5-7 9-901 3-10 3-5",
    ": 8-21 3 6 9-32 4-6 8-40 3-4 7-58 60-2 8 70 3-86 8 90 2-3 5 8-9",
    ": 9003-6 8 11-4 7 20-3 5-36 40-2 5-6 8 50-4 6-7 9-63 6-9 72-4 6-8 80-6 9-90 2 4",
    ": 7-9 101-4 6-7 11 4-6 8 20 3 5-6 9-31 4-41 3-5 7-50 3-9 61-3 5-6 9-78 83 5-9",
    ": 91-4 6-7 202-4 6-9 11 3-4 20 2-33 5-41 4-50 2-5 7-9 61-5 7-8 72 4-5 7 80-1",
    ": 3-4 6 8 91-309 11-6 20-3 5 7-8 34 8 41-2 5 7-8 51-7 9-62 4-7 70-4 6-80 4-9",
    ": 91-2 4-5 7-9 401 3-6 10 2 6-7 9-25 7 9 31-4 6 40-3 5-8 51-2 6-60 4 6-7 9",
    ": 73-81 5 92 4-502 4 6-8 10-1 3-5 7-8 20-4 9-36 42-5 8-9 53-4 8 61-70 3-6 8-9",
    ": 81-3 6-92 6-8 600 2 5-6 9-12 5 7-27 9-30 3 7-40 2 5-8 52 4 6 60-2 5-6 8-71 4",
    ": 6-83 5-6 8 90-2 4 6 8-700 2-4 6 8-13 5 8 23 5-6 31-3 6-40 3 5 7 9 51 5-62 6-8",
    ": 70-1 4 9-95 8-803 6 8-14 7-8 22 4-31 4 6 8-40 4-9 54-5 8-66 8-71 3 81-3 5 7-9",
    ": 91-3 5 8-904 6-7 9-10 2 4-6 20 3-4 6 9 31-2 4-5 8-41 3-6 9-51 3-8 60 7 9-74",
    ": 6-7 81-2 6-8 90-2 6-7 9",
    ": 60002-5 8-9 11 5 7 20-3 6-9 31-2 4 6-7 9-43 5-6 9-50 4-7 60 2-5 7-73 6 81 3-4",
    ": 6-8 90-1 5 100-2 4-20 2-4 6-9 31-40 4-7 50-3 5-9 61 4-7 9-71 3-8 82-3 7-8",
    ": 90-3 5-6 8 200-3 5-6 8-11 4-7 20-1 3 5 8 31-2 4 6-8 41-2 5-6 8-52 6-66 9-71",
    ": 5-93 300 3 7-11 3-4 7-8 21 4-6 30 3 6-7 9 41 3-6 8 50-60 2 5-72 5-8 84 7 9-91",
    ": 3-5 7-9 402 4 7 9-20 4-5 7-30 2-4 6-7 40 3-7 9 51-4 7 9 61 3 8-71 3-8 80-6 8",
    ": 91 3-4 6-500 2-3 5-6 8-12 5 9 22-6 8-9 33 5 8-9 41-8 50-1 3-60 2-5 7 9-70",
    ": 5-80 2-4 6-8 91 3-602 4-7 10-9 21-3 5-30 2-3 5-40 2-3 5-52 4 6-60 2-3 7-70 3",
    ": 5 7 80-4 6 8 90-2 4-705 8-11 3-5 22-4 7-8 31 5-8 46 50-1 3-63 6 8 71-2 4-5 7",
    ": 9 81 4-6 90-6 8-803 5-9 15-23 7-40 2 7-58 60 2 6-8 71-3 5-7 81 3-4 6-7 9-91 3",
    ": 5-9 901-5 8-12 4-20 3-8 30-40 2-5 8-54 6-63 5 7 9-70 2-4 6 8-89",
    ": 91-1006 9-10 2-20 2 6 9-34 7-9 41-52 7-9 61-4 71 4-6 9-82 5-96 8-9 102 4-6",
    ": 8-10 2-9 21 3 5-8 30 2 4-40 2-7 9-51 6-7 9-60 2-4 7-71 3-81 3-4 6-8 91-4",
    ": 7-202 4 7-12 4-6 8-9 21 3 5-30 2-3 6-7 42 6 8-51 5-8 60-2 5-71 4-6 8-81 3-6",
    ": 9-97 301-3 5-8 10-1 3-5 20-1 5-30 2-7 9-41 3-5 7-8 53-4 8 60 2-74 7-80 2 6-9",
    ": 92-7 401-2 5-6 8 11-6 21 3-7 9-37 9 41-2 4-54 6-63 5-6 8 71-3 6-7 81-2 4 6-9",
    ": 91 3 5-6 8-9 501-6 8 10-8 23-5 8 33-9 41-6 8 51 3-8 63-71 3-7 9-83 5-6 8-95",
    ": 7-8 600 4 6-8 10 2-6 8 21 4-5 8 30-2 4-7 9-47 9-56 8-62 7-71 3-6 9-80 2-5",
    ": 9-90 2 4 6-701 3-7 10-2 4-6 8-9 21 3 5-32 4-43 5 7-51 3 5-6 9-60 2-4 8-73 6",
    ": 8-9 83-4 6-7 90 2 4-5 7-8 800-3 7 12-5 7-8 22-3 5-6 8-35 8-9 45 7 9-50 3 8 60",
    ": 5-70 3-6 8 80-3 6-9 91 3-4 6-908 10 3-6 8-9 21 3-5 7 9-33 5-8 40-1 3-6 9-50 2",
    ": 5-8 61-6 9 72-3 7-8 80-6 8-9",
    ": 92-2014 20-31 4 8 43-4 6 8-9 54-8 60 2-4 7 71-3 5 8-81 3 7-90 4 6-102 5 7-8",
    ": 10-6 9-20 2-3 5-6 9 31-41 3-7 9 56-61 4-9 71 3-5 8 81-2 6-95 7-206 8 11 7 23",
    ": 5-31 3-6 41-3 5 8-51 4 8-9 61 3 5-8 71 3-9 82-5 8 91-300 3 8-12 5 7-9 21-7 9",
    ": 32-45 7 9-56 9 62-5 7 9-71 3-80 2-3 5 7-96 8-401 3-4 6 9-12 4 6 8-23 5 7-30 3",
    ": 5-6 8 41-2 4-7 9 51-4 6 61 3-9 71-6 8 80 2-3 5 7 9-501 5 8-11 5 8-20 2-36 8",
    ": 40-1 6-52 4 8-62 4-70 2-4 8-86 8-91 5-8 600 2 4-5 7 9 11-5 7 9-20 3-5 8-9",
    ": 32-6 9-41 4 7 9-52 4-9 61 3 6-8 70 3-4 7-8 80-2 5 8-9 92 4-5 7 9 701 6 11-3 5",
    ": 7-24 9-31 3-4 6 8-41 5-6 8-50 2-5 7-8 60 2-3 5-7 71-6 8-84 6-9 93-804 6 8 12",
    ": 4-6 8 22 4 9 31-6 9-40 3-8 50-3 6 9 61 4-5 7 70 2-81 5 7-9 92 5-7 9 903-4 6",
    ": 11-3 5-7 20-1 3 5 8-32 4-5 7-40 2-5 8-51 3-63 6 9-71 4-9 81-3 5 7-9 92-3",
    ": 5-3004 6-8 10-8 21-4 7 9 31-4 7-9 42-9 53-5 8-9 61-2 4-70 2-5 8 81-3 5 7-8 91",
    ": 3 5-6 8 100-2 4 6-9 12 5-6 8-21 5-8 31-3 5-8 40 2 4-5 7-50 2 5-7 9 64-6 8-9",
    ": 74-6 80 2-6 9-92 4 6-9 204 8 11-4 9 22 8 30 2-5 7 9 41-7 9-50 3 6-63 5 7-8",
    ": 71-3 5 7-8 80-4 6-90 2-3 301-3 6-7 9-11 4-5 7 20-7 31-3 6-42 4-50 2-3 6 8 60",
    ": 2-72 5-82 4-90 2 6-8 400-4 7 9-13 5-8 20-2 4 6-7 9-30 2-4 6 8-40 2-5 9-50 2-7",
    ": 9-68 71-4 6-7 9 82 4-5 8-93 5 7 501-3 5 10 2-5 8-22 4 6-8 30-3 6-7 41-3 7",
    ": 50-2 5-62 5-8 71-3 5-6 9-80 2-3 7-9 93-6 600-7 9-14 8-9 26 8 30-6 8-42 4-7",
    ": 9-53 5-6 8-60 3 6-8 70-1 3-4 8-80 2-3 6-7 9-93 5-6 8-9 701 3-5 8-10 2-6 9-22",
    ": 5 9-31 4-7 40-5 8 50-2 4 6 8 60-1 3-5 7-9 72 4-5 8 81 3-7 90 2-3 9 803-4 6-16",
    ": 22-7 9-30 3 5-8 40-5 7 9-54 6 9 62-5 8-70 2-7 81-5 7-8 91-908 12-4 7-9 21-4",
    ": 6-9 31-2 5 7-9 41-2 4-7 51-3 5 7-60 2-3 5 8-71 6-81 3 5-90 2-5",
    ": 7-4002 5-10 4-5 9-20 2 4 6 8-9 31 4-6 8-48 50-2 5-6 8 62-5 7-8 71 5 7-81 4-6",
    ": 9-92 6 9-100 2 4 10-2 5 7-20 3-6 8-31 3-8 42 5 7-50 4 6 8-62 5-6 8 70-4 6 8",
    ": 80-1 4-6 9 91-2 4 8-203 5-6 8-10 3 5-6 20-3 5-7 30-2 4-44 6 8-9 51-4 8 66-9",
    ": 71-3 6-80 3 5 7-92 4 300-1 3-4 6-13 9-33 8-44 6-8 50-2 7-61 3-4 6 8-9 74-9",
    ": 81-8 90 2-5 8 400-4 7-10 2-3 6-8 20-6 8-9 31-43 7 9 55 9 61-9 71 6-84 7-8",
    ": 90-1 6 8-9 503-4 8-9 12-3 7 22-3 8-9 32-4 7 40-3 5-7 9-50 6-60 3 7-9 72-3",
    ": 8-86 9-96 9-600 2-6 8-11 3 9-20 4 7-8 35-8 40-1 3-51 3 60-70 4-7 84-5 8-92",
    ": 7-9 702-4 6-9 13 5-6 9 23 5 7-34 6 40-1 4 6-7 9-52 4-8 63 5-71 8-86 9 91-4",
    ": 7-801 5-10 2-4 6-8 20-9 32-3 5-7 41-3 5-7 9-56 9-62 5-6 8 70-6 8-9 84-5 7",
    ": 9-91 4-7 9-900 4-6 9-13 7 20-1 3-6 8-9 33-9 42-6 8-51 3-4 7-62 4-5 7 70 4-5 9",
    ": 82-7 9-91 4-5",
    ": 9-5002 5-9 14 6-7 21-4 6-30 2-3 5 8-9 41-6 8 50-1 3-7 9-61 4-9 72-6 9-80 2",
    ": 5-6 8 90-1 3 6 9-103 6-7 9-14 9 22-7 30-2 6 8-40 2-5 7-52 5-7 9-62 4 6 70-9",
    ": 81 3-4 6-93 5-8 200 2 4-11 3-4 7-9 21 3-32 4-5 7-8 41-4 6-9 51-2 5-60 2 4-7",
    ": 70-7 82-3 5-90 3-4 7 9-302 4-16 8-20 3-9 34-6 9 41 3-4 8 50 5-7 9-67 70 3-7",
    ": 80-5 7-91 3-7 401-4 8-12 4-5 7 9-25 8-32 4-9 41-2 5-6 8 50 3-5 7-63 5 7-70 2",
    ": 5-8 81-91 3 7-502 4-6 9-13 5-7 20-2 4-37 40-7 9 51 3-4 6-9 63 5-70 3-81 3-5",
    ": 9-91 3-602 5-10 2-3 5-7 9-20 4-8 31-5 8-9 44 7-9 52-5 7-61 3-9 71 3-5 8-83",
    ": 5-6 8-90 3-6 8-701 4-6 8-12 5 7 9-24 7 9-30 3-5 8-41 4 6-53 5 7-66 8-77 80 2",
    ": 4-5 7-9 91-807 11-5 7-22 4 6-9 31-6 9-50 2-4 6-60 3-7 9 73-4 8-86 9-92 4-7",
    ": 901-5 8-9 12-3 5-26 8-9 31-5 8-9 42-3 6-54 6-69 71-81 3 5 7 9 91-3 5-8",
    ": 6000 3-4 7-10 4 7 9-31 3 5 41-51 3-8 60-2 4-5 8-74 6 8-82 6-90 2-4 7 9-100 2",
    ": 4 8-23 6-30 2-3 6-8 41-51 4-5 7 60-2 7-72 5 7-8 80-3 5-8 92 4 7 9-203 12 6 8",
    ": 20-2 8-9 33-8 40 2-51 3 5 9-60 2-5 8 72-7 9 82-3 5 7-8 91-4 6-7 9 301-3 10-1",
    ": 3-5 7 20-6 8-30 2 4 6-45 53-4 6-7 9 61 3 5-74 6-9 81-2 5-404 6-9 12-4 6-20",
    ": 3-37 41-51 3-5 7 62-4 70 3 5 9 81 4-5 90-1 5-502 5-7 10 3-21 3 6-7 9 31-4 7",
    ": 9-48 51-3 5-6 8 61-5 77-8 80-3 6-7 9-91 3-4 6-8 601-3 7-19 21 3 5-30 5-40 2 6",
    ": 9-52 5 7 61-5 7-8 72-3 7-80 2-4 6-90 2-8 700-1 3-5 7-12 4-6 22-6 8-9 31-8 41",
    ": 3-5 7 50-1 3 5-8 61 3-4 6-8 72 7-91 5 8-804 6 8 10 2-3 6 8 22-33 5-6 8-40 2",
    ": 4-7 50 2-9 63-4 6-8 70-3 6-81 3-6 92-3 5 9-901 9-14 6-7 9-30 2-3 5 8 40 2 5",
    ": 8-50 2-5 7-8 60-71 80 2-3 6-92",
    ": 5-7004 6-18 24-32 4-7 44-5 7-51 3-4 8 61-7 72-81 3-90 2-5 8 100 2 7-21 3-5 8",
    ": 34-6 9-45 8-50 3 6-64 7 9 71 3-7 80 2 7 90-6 8 201-5 7-9 11-4 7 9-28 30 2 4-5",
    ": 7 40 2-3 5-6 8-51 3-4 7 61-8 71 3-4 6-8 80-2 4-91 3 5 7-304 6 9-11 3 8 20-2 6",
    ": 8-37 40 2 4-50 4 8-9 61-9 74-6 8 80 2-4 7 9-91 8-402 5-15 8 20-1 4-9 31-4",
    ": 7-41 3-4 51-3 6-62 5 8-79 84-5 9-93 5-505 10-6 8-26 34-7 9 43 5 8-53 5-8 60",
    ": 2-5 70-4 6-7 81-2 5-96 9-605 8-9 11-2 4-5 8-20 2-3 5 30-2 6 8-40 2-5 7-50",
    ": 4-64 6 9-70 5 8 81-8 92-702 4-5 7-8 10 4 7-24 8-30 3 5-6 8-42 6-9 52-71 3 5",
    ": 7-8 80 2-4 6 9-91 3-5 9-809 11-3 6-21 3-5 8-9 31-2 8-40 2-4 6-8 50-2 5-8 61-4",
    ": 7 72-9 81 3-91 3-4 6-7 901-2 4 6 8-15 8-9 22-3 5-6 31-2 4 6-7 40-53 6-61 4-8",
    ": 74-5 7-80 2-3 5-92 4",
    ": 7-8000 2-7 10 3-6 9-25 9-32 6-8 41 6-58 60 3-7 71-6 8-9 82 6-90 5-6 8-101",
    ": 3-12 7-20 4-8 31-5 7-40 2-6 50 4 6 8-9 61-4 7 9-73 6 80-3 5-9 92-3 7-205 9",
    ": 12-3 5-6 21-3 5 8-9 31-6 8-40 2-7 9 51 3-5 8-9 61-2 4-6 72-3 5-8 80-2 5 7-91",
    ": 3-4 6 8 300-3 5-17 9 22-3 5-6 9-33 5-9 41 3-6 50-3 5-6 8-65 7-70 4-7 9 81 4-5",
    ": 7-90 2 5-7 400-3 5-8 10-5 7-22 4 7-9 31-2 7-8 40-2 4 6 9 51-5 7-60 7 9 71-2",
    ": 6-9 81 3-4 6-90 2-5 7-510 8-20 2-5 8 30-7 40-7 9-51 3 6 8 60-1 5-6 8-70 3-4",
    ": 83 6-91 600-1 4-6 8-11 3-6 8-9 21 5 7-8 31 3-8 41 4-5 7-8 52-5 7-60 2 5-6 8",
    ": 70-1 4 6 9 82-5 90 4-5 8 700-8 11-2 7-9 21-2 4-8 31-4 7-8 40-6 8-60 2-8 70-7",
    ": 80 2 6-8 93 5-803 6-7 11-2 5-28 33-4 6 9-42 5-8 50 3-7 60-2 5 8-9 73-7 9 81 4",
    ": 6-7 90-2 7-9 902-3 5-7 9-14 7-20 2-3 5-31 3 5 7 9 41-3 7-9 51-3 5 8 60-4 6-72",
    ": 5-8 80 2-4 6-9",
    ": 91-9002 5 7-9 11-6 8-9 22 4 6-31 4-6 8-41 5 8 50 6-9 61 5-6 8-72 5 7 9 81 4",
    ": 6-90 2-4 9 101 3-4 6-7 9 11-4 6-7 20 3 6-8 31-3 6-9 41-5 50-1 4-6 8 60-2 6-8",
    ": 70-2 4 6-7 9-81 4-8 90-4 6-7 9 201-2 4-5 9-11 3-4 6 9-21 3-4 6 31-2 4 9-43",
    ": 7-50 4-5 7-9 61-2 4-70 3-81 3-4 6 9 92 5-301 4-5 8-17 20-7 9-30 2-43 6 9-53",
    ": 5-60 2-6 8-73 5 81-8 90-1 3-5 7 9-400 2 4-7 9-25 9-34 6-41 6 8 50 2-6 60-1 3",
    ": 5 7-8 71-6 9 83-4 6 8 91-2 4-502 4 6-9 11-5 7-22 6-8 30 6 8-9 41-3 6-8 50-1 3",
    ": 5-8 61-3 5-6 8-76 8-9 81-8 91-2 4-6 8-603 7 10-2 4-5 7 9-24 6-7 30-1 5-7 9",
    ": 42-8 52 4 7 9-62 6-7 70-4 6-9 82-7 9 91-2 4-9 701-2 4-13 6 9 22-3 5 7-9 32-40",
    ": 2-4 6-7 50 2-3 8-60 3-9 77-9 81 3-4 6 9-91 4 6-801 3-7 11-5 7-23 5-40 2 4-8",
    ": 52-3 5 8 60 2 4 6-8 70-5 8-86 8-91 5-6 8 900 2-3 5-9 11 4 6-27 31-2 4-6 8-42",
    ": 4-8 50-5 60-2 4-5 9 71 3 5 7 9-80 2-4 7 9 91 5-70000 2-3 6 8 10-1 3-7",
    "special2 CAG+7 embl_tpa_tsa_prot",
    ": 1114604-6 9-11 3-6 8 22-8 30-44 6 8-50 3-5 7-62 4-74 6 9-82 4 8 90-3 7-703 6",
    ": 9-10 4-6 9-20 3-4 7 9-34 7-41 3-7 9-55 8 60 2-7 71-4 9-83 5 7-8 91 5-6 9-800",
    ": 3-4 6-11 6-8 22-3 5-34 8 41-3 5-6 8 52 4 6-8 60 2-5 7-73 5-6 9-82 4-5 7 9-90",
    ": 2-4 6-8 904-5 7 12-7 9-23 5 7-9 31-8 40-2 8 51-5 7 9 62 4-6 9-70 2 4-5 8 82-4",
    ": 8-90 2 4 6-7",
    ": 9-5001 3-4 7-9 11 3-20 2 6-8 33 5-45 9 51-4 8 60-75 8-81 3 5-6 90 2-100 3 5-6",
    ": 9 11-5 7-9 21-2 6-9 31-3 6 8-40 2-3 7 9 51 3-6 8 60-2 4-73 5-7 80-1 3 5-6",
    ": 93-9 201-3 5-9 11-4 6 9 23 5-6 8-9 32 4-5 8-9 42 6-8 51-8 60-5 8-9 71-5 8",
    ": 80-4 7 9-93 5-9 302-10 2-3 5 23-32 4-41 3-4 6 8-54 6 8-9 63-4 6-7 9-71 3-4",
    ": 6-9 81 4-5 7-8 90 2 4-5 7 9-402 4-7 9 15 7-9 21-4 6 8-9 31 3-4 6-40 4-6 8-52",
    ": 5-8 61 3 7 73 5 8-81 3-8 99-500 3 9 13-7 23-32 5-7 9-40 3-8 53-4 9-60 3 8-75",
    ": 7-85 7-91 3 6-607 10-2 6 8-23 6 8-45 9-52 8-9 61-7 72-4 6 8 82-4 7 90-7 700",
    ": 3-14 6 9-20 2-8 30-5 7 9-46 9-53 6 8-60 3-4 7 74 80-94 804 6-10 2 4-6 9 22",
    ": 6-33 6 9-53 5-60 4-78 81-90 2 4-5 7-9 901 4-5 7-9 11-2 4-7 9 22-3 5-6 8-31",
    ": 5-6 8-40 2-5 7 52-60 2 5-7 9-72 4 6 8 80 3 5-6 8-94 7 9",
    ": 6001 4 9-11 3 7-8 20 2 4 9-32 4-6 8-9 41-3 7-50 2 6-61 3-7 9-72 7 82-90 2 5-8",
    ": 100-2 4-5 7 10-1 3 5-6 8-22 4 6-7 9-30 2 4-7 9-40 4-6 8-51 3-60 2 7-9 74 7-8",
    ": 80-2 4-5 8-90 5 7 201-2 4-9 11 3 5-7 9 21-2 4-6 8-30 2-5 9 41-2 5-51 8-62 5",
    ": 7-70 3 5 7-81 4 6 90-1 3-6 8-301 3-4 6-8 14 7 9 22-3 7 9 32 4 6-8 40-1 3 7-8",
    ": 50 3-6 61 3-5 71 4-7 9 81 6 8-90 4 6-402 6 8-16 9-28 30-3 5-40 2-7 9-54 7 60",
    ": 2 5-6 9-73 6-9 81-5 7 91-5 500-2 6 8-9 12-3 5-8 21 3 6-7 30-3 6 40-1 8-51 5-8",
    ": 60 2-3 5-7 70-83 7-9 95-6 8-600 2-3 7 9 11 3-5 9 21 6-8 33 9 41-2 4 6 50 2",
    ": 4-7 60-1 4 6 8-71 3-6 8 84 6 8-90 2 5-7 700-2 4 6-9 14-5 7 9-21 4 7-30 4 6-7",
    ": 9 41 3-4 6-7 50-1 4-5 8 63-4 6-7 71 3-7 84-6 8-92 4-5 7 800-1 3-6 9-10 4-5",
    ": 20-2 7-8 30-1 3 6 40-1 3 5 7-8 50-5 9 61-4 6-8 70-4 6-80 3-4 6 9 94 6-8 901-2",
    ": 4 10 4 6 9 21-2 4-7 30-7 41 4 6-8 50-7 9-60 2-5 7-9 74-7 9-80 2 4 6 9-90 2-5",
    ": 8-9",
    ": 7001-8 10 2-4 8 20 5-8 31 4-8 40-1 5 9-53 5-6 8-60 2-4 6-70 2-80 3 5-6 8-9",
    ": 92-3 5-101 4-7 9 11-5 8-26 30-1 4-43 7 9-50 2-5 8-60 2-71 4 6-8 80-2 4-7 9-91",
    ": 3-5 7 9-200 2-4 6-14 7 9-22 5 7 31-2 4-40 3 5-7 9 52-4 9 61-2 4-6 8-9 73-9",
    ": 81-3 6 8-91 3 6-8 301-4 8-12 4-5 9-20 3-4 6-7 30-2 5 7-8 41 4-59 61-8 71 3-5",
    ": 8-87 9-90 2-5 401-7 9-14 6 8 20-3 6-8 30 2-3 6-8 40-1 4 6-7 51 3-6 8 60-4",
    ": 7-72 4 6 8 81-4 7-8 91 4-5 7 500 2-3 6 8 11-3 6-9 21 3 5-7 32 6-8 41 3-4 6-8",
    ": 50 2 5-9 61-6 9-72 4 6-7 81-2 5-7 9-92 4-601 3-5 7-11 3 7-8 27-8 30 2-6 9-40",
    ": 3 7-9 52-4 6-9 61 3-4 7-70 2 5 7-9 81-2 4 6-7 9-90 2 4-704 6 8 10-2 5 21-9",
    ": 33-4 8-9 41-2 5-6 9-50 2-3 7-9 61-3 5-6 70-1 3-80 3-90 4-5 8-9 801-15 7-9",
    ": 23-6 8-9 31-2 4-8 42-6 8-54 6 8-61 4-7 9 71-2 4-5 7 9-83 5-7 90 4-901 5 7 9",
    ": 11-3 5-7 9 21 4-5 8-31 3 8-41 3-6 51 3-5 7 9-60 4 7 9 73 6 8-81 3-9 93-9",
    ": 8001 3-4 6 8-10 2-3 5-6 8-21 3-7 9-30 3 5-6 8-9 41-2 4-5 9-53 5 8-62 7-9 71-3",
    ": 6 81-4 6-7 92 4-5 8-102 7 11 3 5-8 21-4 7-8 31 3 5-9 42 4 6 8 52-3 5 7 9 62-3",
    ": 6 9 72 5 7-8 80 2-6 90-1 4-8 203 8-9 11-6 21 8-30 3-5 8 44-7 9-51 3-4 6-63 5",
    ": 8-77 81 4-6 8-9 91 3 5-7 302-4 6-9 11-6 9-29 31 4-7 40-6 8-9 53 5-61 4-7 9-77",
    ": 81-7 9 95-6 400-1 3-4 6-7 9 11-3 5-8 20-1 4-6 30 3-7 40-3 6 8-52 5 7 60-1 3 5",
    ": 9 71 3-4 6 8-80 3 7 9-93 5-6 8 500 3-4 7 9-11 4-6 20 4 7-30 2 7-40 2-4 6-53 6",
    ": 8 60-1 3 6-7 9-70 2-4 9-81 3-4 6-92 5 8-600 2 6-8 10-4 6-9 21-2 4 6-30 2-40",
    ": 3-50 2-62 4 7-9 71 4-9 81-7 9-91 3 7 9 701-12 5 7 9-26 8 30-5 8-40 2 4 7-8",
    ": 51-6 8-64 6 9-70 2 4-6 8-88 97-800 3 6-7 9-10 2-5 7-24 7-30 2-7 9 41 4 8-9",
    ": 52-66 8-9 71-8 80 4 7-92 4-9 901 4 10 2 4 8 21 3-30 2-5 7 40-6 8-9 51-2 6-66",
    ": 9-70 2-4 8-80 5-7 9-90 3-8",
    ": 9001 7-10 2 4-27 31-40 2 6-50 2 4-63 5 7-8 72-5 7 9-83 5-6 90-2 5 8 100 4-7",
    ": 9-13 5 8-9 24-5 8 33 5-7 42-3 5-53 5-63 5-6 8 72-5 8-95 9-205 7-14 7-8 20 2-4",
    ": 8 33-4 8-42 4-52 4-5 7-61 6-72 4-88 90-6 8-9 301-3 8-12 4-21 33-5 8-9 41-2",
    ": 4-5 8 50-5 7 9-61 3-70 3 9 81-2 4-8 90 5 7-9 402-7 9-15 8-9 22-4 6-7 9-36",
    ": 8-42 5 8-9 60-2 6-8 71-2 9 81 3-90 3-6 9-505 7-9 12-5 7-8 20 7-30 2-3 7 43-53",
    ": 6-62 4-6 9-71 3-5 8-81 3 8 90-4 6 8-601 3-6 8 10-1 4-5 8-22 4-6 9-31 3 8-9 42",
    ": 4 7-8 52 4-8 60 4-7 9-73 5-9 83-4 7-90 2-8 700 2 5-6 9-10 2 4 6 9 21-3 6-7 30",
    ": 2-3 5 40 6 8 50-1 6 8 62 4-5 7 70 9 82 4 7 9 95 7 803 5 7 9 12-3 5 21 7 9 31",
    ": 4-6 9 41 3-4 6 8 53 5 8 60 5 7 72 4-5 7 82 5 7 91-2 4 6 901 3 6 8 10 4-5 7 9",
    ": 21 3 5 8-9 35 8 40-1 3 52 4-5 7-8 67 71-2 7 81 7 9 93",
    ": 20000 2-3 9 13 7 23-4 6 8-9 31 40 2 4 6-8 52-3 5 62 7 71 7-8 89 94 6 100 2 4",
    ": 11 3 8 21 3 31-2 7 40 4 6 51-2 64 6 74 6-7 80 3 6 8 91 5 203 5-6 8 11 21 8",
    ": 30-1 7 40 2 4-5 52 4 9 66 9 75 7 9 82 5 96 300 7 10-1 9 21 4 6 31 3 8 44 50 2",
    ": 5 7 60 3-4 8 76 80 3 6 91 401 16 20 8 30 4-5 7 42 4 54 62 7-9 71 4 6 80 2 7",
    ": 91-2 7 501 3 6 20 3 7 32 6 8 41 9 51 4 6-7 60 73 9 87 618 21 4 7 34 6 9 42",
    ": 8-9 55 7 64 7-8 73 8 80 2 7 91 3 7 9 701-2 4 7 10 3 6 8 20 2 5 38 40 2 6 61",
    ": 70 2 5 8 80 6 8 90 801 5 7 15 8 21 4 8 31 3 6 40 2 4 6 52 6-7 60 3 5 72 4 7-9",
    ": 81 5 9 92-3 6 8 900 2 8 10 2 6-7 22 5-6 30 6 8 40 6 8 50 6 8 60-1 3-4 9-70 8",
    ": 84 8 90 2 4 6",
    ": 1000 2 7 10 9 22 5 9 33 5 7 9 41 3-4 6 8 51-2 7 61 3 6 72-4 7 9 84 8 95 114 8",
    ": 24 30 3 9 42 4 8 50 3 6 8 69 72 85 90 2 5 202 5 18 26-7 32 4-5 46 8 55 70 4",
    ": 83 94 6 301 3 6-7 10 2 4 7 25 8 37 41 50 8 62 6 9-70 9 82 4 8-90 5 7 412 5 8",
    ": 20-1 7 36 8 44 6 8 51 7 66 71 3 9 82 95 7 508 13 7 22 43 5 50 5-6 8 60 71 6",
    ": 83 6 94 8 601 7 9-10 4-5 8 23 5 7 9-30 7 9 42 6 8 61 9 76 9-81 9 95 7 700-1 6",
    ": 8 12 4 9 21 4 43 6 66 75 87 94 8 808 14 34 42 5 8 63 9 86 94 916 28 38 43 52",
    ": 66 81 3",
    ": 2010 21 32 62 95 103 8 10 50 8 90 6 202 38 43 52 6 62 5 72 81 8 93 312 5 9-20",
    ": 3 7 39 48 52 5 63 9 79 90 6 404 14 9 25 8 33 45 55 7 63-4 8 82 8 98 502 4 15",
    ": 35 51 3 63 8 77 84 7 98 602-3 5 14 20 3 41 9 52 7 60 2 7 70 2-3 8 84 6 96 700",
    ": 5 19 21 5 8 32 40 4-5 7 50 7 62 7-8 70 9 85 8 92 7 800 11 5 24 33 9 42 8 68",
    ": 79 85 91 905 9 12 35 8 42 7 52 7 60 89 93",
    ": 3001 21 6 31 74 82 107 24 9 51 5 7 61 73 5 9 83 92 4 200 10 4 21 3 30 2 4 49",
    ": 59 64 75 8 81 7 92 305 10 3 29 38 49 52 63 6 9 74 7 80 90 402 6 35 41 5 9 52",
    ": 7 64 77 90 4-5 535 56-7 9 82 9 91 6 616 20 4 7 39 43 53 65 75 9 84 8 702 14",
    ": 30 3 9 43 71 5 80 4 8 93 808 11 5 7 20 3 9 37-8 40 4 6 70 5 8 95 900 17 39 42",
    ": 7 51 5 61 7 74 84 9 92 7",
    ": 4005 9 12 4 26 52 69 72 9 90 103 11 53 8 62 80 3 6-7 91 3 238 57 62 7 85 303",
    ": 10 7 21 37 40 8 59 68 72 7 85 8 405 10 2 8 22 7 35 41 4 51 3-4 7 62 5 7 71 93",
    ": 7 500 3 7 10 2 28 39 43 57 60 74 7 83 606 30 40 58 85 96 704 20 5 30 4 7 40 6",
    ": 53-4 7 60 79 85 90 3 7 821 5 44 57 63 80 7 906 11 20 5 55 64 92 5 8",
    ": 5001 9 13 21 33 6 40 67 84 99 108 19 35 57 87 209 15 47 72 98 302 7 14 8 22",
    ": 31 7 45 8 50 72 5 81 91 5 400-1 12 21 4 9 36 41 55 67 74 80 95 9 502 15 9 30",
    ": 7 53 65 75 82 94 604 28 35 9 42 55 61 83 702 5 9 14 9 21 6 50 5 66 9 81 92",
    ": 805 11 3 7 22 44 65 7 77 80 4 90 7 9 902 5-6 21 3 40 3 8 55 7 9 64 6 70 4 83",
    ": 99",
    ": 6006 13 24 41 68 73 6 83 103 9 20 52 65 76 81 3 207 18 26 50 63 7 70 90 3 8",
    ": 301 3 5 8 29 33 6 46 54 7-8 67 400 7 12 34 55 64 7 77 86 90 9 511 3 8 27 53",
    ": 66 92 8 604 11 6 22 34 7 54 7 72 6 82 6 8 95 703 19-20 32 6 8 40 2 51 68 91 5",
    ": 806 12 28 31 7 75 86 90 5 904 23 32 53 62 73 6 83 7 9 93 5 8",
    ": 7003 7 14 27 9 31 5 48 59 66 71 91 5 8 101 4 6 9 15 9 38 41 4 50 8 69 71 9 82",
    ": 5-6 206 14 22 4 8-9 33 6 42-3 51 4 62 8 72 5 9 83 6 96 313 6 20 2 4 34 7 40 4",
    ": 54 62 4 6 73 6 9 82 4 6 93 402 9 14 22 5 35 9 61 3 71 86 514 28 30 47 51 9 66",
    ": 71 9 84 7 93 6 604 8 16 20 3 7 31 47 65 73 82 5 93 7 700 9 17 26 35 42 7 55 8",
    ": 73 5 9 89 809 14 31 44 7 64 70 8 93 6 910 4 7 32 7 47 9 52 7 74 96",
    ": 8002 20 32 7 41 6 53 6 63 9 87 9 120 34 79 82 91 7 202 6 12 21 4 34 41 4 78",
    ": 305 22 55 7 72 6 84 8 97 406 12 26 63 77 87 91 504 11 7 9 36 94 602 55 64 72",
    ": 83 98 717-8 22 36 8 77 81 5 96 800 7 50 8 74 9 89 93 903 30 44 59 70 9 93 6",
    ": 9002 4 11 4 21 6 37 88 92 6 110 2 26 31 3 8 42 8 64 71 6 8 82 7 92 5 9 204 7",
    ": 10 23 39 43 9 64 70-1 80 333 49 88 439 47 57 63 6 9-70 4 6 82 4 7 90 8 501 4",
    ": 10 3 9 25 9 46 52 66 72 92 603-5 8 12 5 8 20-3 5 7 9-30 2 4 9 41 5 7 55 8 63",
    ": 6 79 93 701 3 15-6 8 20 5 34 6 8 43 6-7 50 3 6 61 4 82 5 92 4 6-7 9 807 11 4",
    ": 20 5 7 30 3 45 9 51 61 76 80 4 90 6 9-900 3-4 14 33 5-6 8 40 3 5 8-9 52 5 7",
    ": 60 4 83 7 90 6 8",
    ": 30000 3 5 8 11 5 9 23 31 3-4 8 40 4 54 60 4 9 72 4 84 8 90 5 8 107 11 4 7 25",
    ": 7 35 50-1 4 8 68 77 87 95 8 205 12 4 8 21 4 7 41-2 5 58 71 5 7 80 5 95 8 303",
    ": 5 8 16 22 8 32 41 5 8 50 4 8 62 4 9 75 7 80 2 5 7-8 91 4 7-8 401 7 12 7 21 3",
    ": 6 32 5 48 57 9 62 5 9 72 4 87 91 4 7 9 509 14 24 7 35 40 2 5 51 5 63 8 71",
    ": 86-7 97 606 23 6 32 7 40 58 62 8 71 80 6 8 95 701 9 13 5 20 9 36-7 9 41 52 7",
    ": 66 75 7 81 90 7 9 822-3 7 32 5 44 8 59 70 3 84 902 6 14 26 36 49 53 5 64 9 72",
    ": 92 4 6",
    ": 1001 10 7 23 6 37 9 46 51 5 9 61 4 8 78 85 7 90 6-7 109 18 21 3 6 35 49 61 3",
    ": 6 75 80 5 98 203 7 9 11 23 31-2 5 40 5 53 61 4 71 5 7 9 85 90 2 306 9 15 24",
    ": 35 7 42 8 55 60 3 9 71 3 5 9 84 6 8 90 400 2 7 9 14 32 6 40 4 7 9 53 6 60 3",
    ": 70 5 8 96 9 515 7 22-3 7 9 33 6 42 5 50 4 6 64 73 8 81 4 7 96 603 7 13 21 9",
    ": 36 9 41 3 50 2 4-5 61 73 7 9 83 93 8 701 10 7 20 2 7 37 43 6 8 54 7 61 5 70 5",
    ": 82 8 92 5-6 9 804 11 7-8 20 7 33 8 42 4 51 4 6 62 8 75 9 82 6 93 902 6 14 21",
    ": 5 9 32 4 48-9 53 7 9 61-2 7 74 8 80 93",
    ": 2001 3 8 11 3 8 21 37 44 9 54 67 81 4 9 102 7 13 20-2 4 6 36 41 55 8 78 88-90",
    ": 4 8 213 5 7 20 34 8 43 5 56 61 71 82 312 28 64 76 85 407 15 9 23 9 31 4 6 52",
    ": 62 70 4 80 8 500 13 9 27 33 9 54 7 63 72 7-8 85 90 2 5 8 605 8 11 26 39 49 70",
    ": 3 706 34 57 77 96 800 88 902 6 10 34 42 50 65 74 7 83 90",
    ": 3002 6 16 23 37 47 50 4 9 70 3 80 146 54 93 311 5 9 26 37 48 68 73 85 90 6 9",
    ": 411 5 30 65 78 500 3 6 8 22 4 66 89 96 605 14 6 34 52 7 60 3 5 70 3 7 718 22",
    ": 5 41 6 9 77 806 12 51 4 84 94 6 9 908 15 25 50 71 6 84 8",
    ": 4000-1 6 9 14 8 27 34 45 51 69 74 8 90 100 8 14 47 50 71 84 7 93 7 212 21 4",
    ": 61 84 96 301 32 47 59 83 95 408 12 20 6 54 7 66 70 4 89 93 8 505 19 27 34 42",
    ": 7 9 51 6 64 7 80 7 92 615 20 5 39 43 5 52 8 62 7 71 5 95 7 701 4 13 24 50 8",
    ": 65 73 86 9 95 812 40 50 3 60 8 70 81 7 91 902 6 10 4 7 25 46 69 72 4 80 3 6",
    ": 93 6",
    ": 5009 11 6 28 31 3 42 8 53 5 60 70 9 81 4 93 8 106 14 7 34 41 4 7 59 62 4 8 72",
    ": 7 80 3 6 93 6 9 202 12 7 23 6 32 4 6-7 9 54 9 61 71 3 84 8 98 303 11 21 7 30",
    ": 4 8 43 58 84 8 91 3 6 406-7 9-10 6 23 6 40 6 9 66 74 83 6 95 509 13 21 4 9 31",
    ": 8 44 87 99 604 16 28 35 63 9 71 709 13 8 28 30 6 43 57 69 71 4 7 9 82 8 93 5",
    ": 811 5 8 24 41 52 8 69 77 96 901 9 12 5 24 36 42 55 63 81 97",
    ": 6003 10 24 8 43 52 8 62 78 93 6 8 102 55 8 86 90-1 5 211 20 30 302 12 22 35-6",
    ": 48 52 6 66 81 96 401 15 21 30 8 57 64 84 500 14 32 6-7 9 45 68 72 7 81 6 90",
    ": 603 17 25 8 39 57 60 93 9-700 10 3 6 22 4 7 39 64 75 95 809 13 22 33 48 50 3",
    ": 8 68 71 8 84 99 903 6 11 5 20 47 54 7 67 90",
    ": 7005 8 17 26 9 36 67 74 84 8 95 106 10 30 7 42 51 68 74 208 62 72 95 303 16",
    ": 47 53 73 81 6 92 400 3 13 20 30 5 8 54 73 7 95 500 5 7 9 13 5 34 40 6 50 3 8",
    ": 63 5 83 7 93 6 600 8 22 41 8 53 6 9 62-3 6 8 71 81 5 7 93 717 27 36 47 50 5",
    ": 75 9 82 7 807 9 14 8 21 30 3 6 53 7 65 98 930 5 8 40 65 71 92",
    ": 8024 58 66 8 84 91 101 7 14 56 61 3 6 70 81 7 91 3 7 9 211 7 24 32 42 9 54 88",
    ": 307 10 9 25 38 44 54 63 7 70 4 91 9 407 13 26 31 67 70 8 82 5 506 40 2 53 9",
    ": 64 77 80 8 95 600 5 13 25 8 32 6 55 60 77 89 93 706 12 36 43 55 8 70 5 82 815",
    ": 28 34 45 50 3 6 60 4 73 85 92 914 23 32 4 42 4 7 9 56 65 8 74 6 82 94 7",
    ": 9001 5 20 3 38 66 9 92 5 100 3 5 9 18 21 7 36 40 52 62 4 8 70 5 82 4 98 206",
    ": 18 51 9 352 63 74 7-8 84 6 8 92 5 9 404 8 11-2 4 35 8 40 4 50 7 63 9 74-5 7",
    ": 87 504 24 33 6 9 47 61 9 76 87 94 602 6 9 16 23-4 7 37 40 3 8 53 5-6 9 61 5 7",
    ": 9-70 6 86 90 3 700 6 12 22 8 35 44 55 8 63 5 91 4 807 13 22 4 35 8 56 75 8 81",
    ": 91 4 9 916 23 34 7 46 54 60 7-8 75 84 9 95",
    ": 40000 2 7 31 44-5 55 8 65 70 2 7 92 101 3 6 17 9 28 32 41 8 60-1 8 75 8 84 7",
    ": 9 94 6 204 16 28 38 41 57 62 6 78 82 309 15 8 26 8-9 32 9 55 66 73 8 80 3 5 7",
    ": 91 4 6 8-9 408 16 25 32 45-6 52 9 70 85 91 8 500 3 12 9 25 31 4 7 73 8 81-2 7",
    ": 92 6 604 25 8 33 5 7 44 54 9 83 6 9 91 5 702-3 7 9 16 20 2-4 46 67 71 7 9 87",
    ": 9 821 42 6 61 4 9 76 80 5 8 92 4-5 8-9 901 6 13 6 8 21 4 37 9-41 3 6 8 50 7",
    ": 62 4 7 9 77",
    ": 1007 13 6 9 34-5 52 9 64 6 9 73 8 89 91 4 8 102 7 10 3-4 24 7 9 35 9 42 55 7",
    ": 61 71 6 8 88 206 9 15 29 34 51 67 86 97 300 8 14 30 49 52 6 75 82 6 95 9 401",
    ": 4 13 21 36 43 6 52 5 62 5 72 7 9 92 9 504 11 7 29 33 42 52 61 3 70 4-5 82 8",
    ": 603 10 7 21 33 8 41 3 55 9 63 5 74 82 94 700 2 6 13 29 33 48 57 60 7 70 84 90",
    ": 4 8 804 11-2 5 7 25 9-30 5 8 41 7 9 51 60 3 70 4 84 92 902 5 7 10 20 4 36 40",
    ": 7 50 7 61 6 8 71 4 8 82 4 8 98",
    ": 2010 21 32 41 5 58 60 6 71 3 6 84 6 8 92 4 7 106-7 11 3 6 8-9 22 8 31 3 7 43",
    ": 6-7 50 2 9 67 74 7 80 4 7 91 5 7 210 21 42 7 53 6 9 61 5 7 71 7 81 3 98 301 7",
    ": 33 6 40 9 55 65 70 81 5 7 403 13 6 25 32 5 8 43 9 51 62 5 71 3 6 9-80 3-4 91",
    ": 3-4 502 6 10 4 6 9 24 9 37 43 9 68 71 8 82 6 91 600 2 12 24 34 9 43 6 52 8 62",
    ": 4 75 87 91 3 713 22 4-5 33 7 56 70 4-5 81 3 6 98 801 3 12 6 20 2 4 7 38 40 3",
    ": 5 7 9 55 83-4 97 907-8 24 7 31 5 44 8 54 6 60 5 73 6 8 81 96 9",
    ": 3006 13 6 23 34 7 41 9 59 78 85-6 8-9 93 8-9 101 12 4 21 3 6 31 9-40 3 8 50",
    ": 65 9 76 82 6 90 204 8 11 23 8 30 7 46 51 3 5 61 6 8 81 4 6-7 90 302 6 9 16 8",
    ": 22-3 6 30 7 44 50 6 9 61 5 73 6 82 9 92 408 20 5 31 3 49 57 9 66 9 74 80 4 6",
    ": 9 94 507-8 19 22-3 31 4 6 41 4 6 8 51 5 9 71 4 81 3 6 90 2 4 600 2 5 7 9 11-2",
    ": 4 20 3 6-7 34 42 5 7 9 53 69 99 702 6 9 34 9 60 77 805 11 3 7 34 9 61 5 73 88",
    ": 91 5 7 912 20 2 7 45 54 61 4 75 83 92",
    ": 4001 3 17 24 30 3 8 44 51 7 62 88 91 3 104 12 21 6 43 6 54 8 61 4 7 70 4 81 3",
    ": 6 94-5 200 12 29 32 7 42-3 7 50-1 4 60 4 71 83 8 92 8 303 21 8 34 7 42 51 4",
    ": 61 3 9 71 80 2 8 403-5 8 11 6 28-9 31 6 40 5 56 9 62 8 73 6 9 83 90 2 500-1 7",
    ": 11 5 34 66 81 600 4 18 22 6 40 5 77 81 9 99 710 7 23 5 7-8 36 45 7 57 64 6 73",
    ": 6 80 2 99 804 18 21-3 5 30 3 7 40 2 7 52 9 62 5 83 7 93 7 906 8 11 22 6 30 3",
    ": 40 8 52 5 9 65 9 85 92 5",
    ": 5001 5 9 22 7 39 47 65 71 82 6 98 102 10 3 5 26 38 48 56 8 61 5 9 72 5-6 80",
    ": 94 208 11 9 22 6 37 45-6 63 6 74 92 4 6 300 3-4 7 9 13 5 9 69 71 80 3 9 92 8",
    ": 407 9 15 8 25 30 6 9-41 4 8 51 7 9 63 8 74 85 90 503 40 8 75 7 82 9 614 6 9",
    ": 21 3 9 33 6 45 60 87 91 701 4 6 13-4 7 21 7 36 57 69 73 5 85 93 5 9 801 4 10",
    ": 6 21 35 7-8 40 6 9 53 5 7-8 63 5 71 3 7 9 81-2 6 93 6 923 7 30 2 40 2 6 8 52",
    ": 4 6 8 60 2 5 7 9 71 3-4 7 82 9 92 5 8",
    ": 6002 15 23 6 33 7 40 4 52 65 7 71 3 7 83-4 90 8 100 2 5 19 36 8 48 58 60 4",
    ": 77-8 84 90 9 204 11 26-7 34 42 51 8 70 4 9 85 8 91 5-6 9-300 3 5 18 23 7 32 7",
    ": 47 54-6 8 61 3 5 9 73 7 9 82 5 7 9 92 401 4 8 12 7 27 32 8 45 84 97 500 5 16",
    ": 9 22 5 7 51 90 4 7 9 602 7 9 19 21 4 7 9 37 41 6-7 9 52 4 6 8-9 62 86 9 99",
    ": 714 25 38 43 54 60 74 7 9 92 5 9 808 12 6 23 5 31 4 7 9 41 8 54 7 61 3 7 70 2",
    ": 80 2 6 9 92 6 8 903 5 9 30 4 6 45-6 9 51 5 9 61 5 7 71 84 99",
    ": 7004 7 9 17 21 33 8 45 9 52 5 67 85 90 4 7 106 19 24-5 8 31 3 40 59 67 78 81",
    ": 4 8 90-1 4 7 203 8 13 23 9 32 6 43 56 8 66 9 76 81 90 5 7 306 11 9 23 7 31 4",
    ": 41 4 7 9-50 5 8 61 3 7 71-2 81 92 4 8-9 402 7 13-4 6 9 21 3 30 5 9 44 7-8 50",
    ": 3 7 66 72 4 8 82 6 9 96 9 502-3 6 9 11 9 25 8 40 7 53 5 7 60 4 71 7 87 98 601",
    ": 7 10 3 7 20 2 5 8 31 7 42 69 75 89 92 7 9 702 5 8 14 6 8-9 21 5 8 31 40 2 5 7",
    ": 55 8 67 74 81 96 9 803 5 8 10 2 5 20 3 7 30 3 5 7 51 66 9 81 94 927 59 61 7 9",
    ": 77 80 9 93 8",
    ": 8001 4 7 11 3 8 21 6 8 39 53 7 9 64-5 71 9 81 6 95 7 103 6 9 12 5 21 8 31 3",
    ": 48 54 65 72 7 99 201-2 4-5 8 10 2 7 9 22 5 9 31 4 6 8 40-1 3 6 50 4 7 63 5 7",
    ": 86 90 5 8 300 2 4 8 12 6 20 7 30 4 6 9 44 51 64 6 9 82 7 99 401 5 7 9 12 7-8",
    ": 23 7 9 36 47 52 6 62 6 8 70 2 6 81 3 5-6 8 90 4 7 502 6 13 5 25 8 37-8 46",
    ": 52-3 5 72 7 9 82 95 7 9 608 19 23 30 3 43 5-6 54 71 80 90 8 701 3 7 13 6 24",
    ": 30 8 40 4 7 56 62 7 9 71 83 93 804 13 9 27 37 44 58 65 70 2 6 85 7 98 906 13",
    ": 7 9 22 7 31 8 43 51 5 66 78 85 96",
    ": 9003 6 9-10 3 9 22 5 37 43 8 50 62 5 7 76 8 81 3 6 93 5 104 10 5-6 8 24 7 31",
    ": 3 8 43 6 8 67 73 80 2 4 90 5 207 15 7 24 8 34 9 47 53 5 61 6 9 74 90 3 9 310",
    ": 22 34 7 9 45 8 54 7 60 2 7 9 75 8 81 92 5 7 404 24 7 31 5 9 45 7 61-2 4 6 70",
    ": 82 96 505 10 2 22 35 8 40 3 8 61 6 70 82 8 93-4 602 5-7 21 5 37 41 70 5 91",
    ": 702 4 10 6 8 20 5-6 40 5 8 50 62 70 2 7 83 7 92 814 8 22 57 60 2 4 6 74 80",
    ": 2-3 5 8 90 5 900-1 4 7 9 12 5 23 46 50 4-5 9 62 6 8 75",
    ": 50001 4 8 10 4 20 30 5 40 5 8 50 3 63 73 83 5 92 104-5 11 4 22 8 34 9 55 74",
    ": 80 200 3 11 5 9 25 31 59 63 72 8 85 90 302 9 21 4 32 70 83 93 403 10 39 43 7",
    ": 60 83 93 509 20-1 7 9 32 9 43 6 8 52 7 67 82 4 6 609 12 5 28 37 40-1 51 64 6",
    ": 76 81 6 91 5 7 702 5 14 20 6 34 47 57 66 79 87 96 9 808 25 31 4 7 56 64 77 94",
    ": 7 900 4 9 23 6 30 4 41 6 52 66 73-4 7 81 4 8 92",
    ": 1001 11 6 8 22 31 43 7 67 77 85 90 102 4 6 12 21 4 30 2-3 42 50 8 63 5 9 73",
    ": 88 94 200 3 8 25 30 48 51 4 8 61 4 71 5 87 9 301 5 10 4 6 9 23 7 31 9-40 51",
    ": 60 3 8 81 6 418 41 72 5 8 84 6 9 92 4 508 15-6 20 5 8 45 9 52 7 60 2 89 610 8",
    ": 33 49 57 66 70 6 80 93 6 721-2 5 42 5 53 5 9 65 75 81 91 5 800 6 9 11 31 3 5",
    ": 9 42-3 50 4 9 65 7 86 90 901 21 8 34 47 51 5 62 5 8 72 5 7 83 5-6 90 7",
    ": 2002 4 7 9 11 7 21 30 40 5 57 70 4 7 82-3 5 7 9 91 5 101 5 13 6 24 6 33 8 46",
    ": 55 72 85 9 92 7 200 7 10 39 57 9 65-6 9 73 7 84 9 304 14 36 54 65 9 80 4 409",
    ": 11 6 20 9 37 43 72 8 82-3 9-90 6 501 3 8 12-3 5 8 22 30 5 8 41 5 8 50 9 63-4",
    ": 8 70-1 3 5 8 81 93 9 606 11 8 20-1 3 8 34 6 40 50 9 70 4 7 80 2 6 702 5 8 21",
    ": 6 8 35 45 53 64 6 72 4 7 84 92 801 9 11 3 6 20 8 31 7 41 73 5 9 82 6 91 3 7-8",
    ": 900 2-3 11 5 21 32 43 5 7 54 85 8 91 3",
    ": 3002 12 23 33 44 9 58 71 81 6 9 92 5 9 110 7 27 32 41 53 6 9 62-3 5 8 70-1 80",
    ": 9 91 3 7-8 200 3 7 10 2 5 25 8 32 45 52 9 61 4 6 9 71 4 85 8 300 12 20 31 55",
    ": 65 8 75 81 90 5 409 17 23 8 30 8 44 7 50 65 8 72-3 6 83 91 5-6 501 5 10 4 21",
    ": 7 30 48 50 3 9 63 8 85 95 600 3 10 4 7-8 20 8 39 42 5 7 51 3 7 9 62 7 9 76 8",
    ": 81 7 91 702 10 5 8 23 9 34 41 7 52 8 79 84 7-8 91 5 800 3 5 9-10 32 7 40 7 52",
    ": 4 6 8 61 3 6 77 9 86 9 94 9 902 7 14 7 9 23 33 8 40 53-4 6 61 3 70 83 9 91",
    ": 4000-1 4 8 10 4 21 3 7 30 2 5 8 40 2 7 56 8 62 8 71 6 80 96 9-100 8-9 11 3 6",
    ": 20 3 7 9-30 3 45 8 53 6 77 82 7 91 200 8 14 6 23 9 48 55 61 5 7 85 8 90 4 7",
    ": 301 3 6 10 8 23 7 31 43 9 52 4 60 2 5 70 8 85 90 415-6 20 2 43 64 72 6 80 3 5",
    ": 90 2 7 501 13 20 3 5 30 2 4 9 47 9 55 60 3-4 71 3 6 83 8 92 5 603 8 10 8 25 8",
    ": 33 5 41 3 9 52 5 8 75 7 9 85 8 90 2 6 8 702 6 9 11-2 5 8 27 31 3 5 43 6 9 61",
    ": 8 85 8 91 7 806 10-1 5 7 23 6 30 2-3 5 40 4 6-7 50 3 5 9 61 5 71 94 6 903-4 7",
    ": 9 18-9 35 45 53 9 61 9 77 80 9 93-4 8",
    ": 5008 14 6-8 21 31 9 50 3 8 67 71 80 95 9 111 20 4 35 7 48-9 51 64 76 83 9 91",
    ": 3 5 8 200 5 8 11 28 43 54 7 63 7 71 6 81 7 94 6 301 16 22 4 32 49 51 9 61 7",
    ": 75 84 8 93 400 4-5 7 11 4-5 7 9 21 4 42 50 66 75 513 7 28 36 53 6 65 78 82 7",
    ": 9 99 602 4 12 6 8 43 51 5 9 61 7 73 8-9 87 91 7 700 2 7 15-6 31 43 9 54 8 61",
    ": 5 70 8 87 96 801 3 14 6 8 21 4 8 35 40 2 5-6 50 2-3 6 9 64 8 72 5 8-9 81 3 5",
    ": 7 91 4 7 901 4 6 11 5 8 25 8 35 45 7 9 56 61 8 71 5 84 8 93 9",
    ": 6004 9 20 4 7 30 4 41 56 63 6 9 73 7 80 5-6 9 96 101 15 24 8 33 43 5 8 53 5",
    ": 63 8 72 7 9 83 5 90 3 201 4 9 12 5 21 3 9 32 6 9 44 53 7 61 4 9 76 9 82 4 8",
    ": 90 5 9 303 6 14 21-2 8 32 6 45 55 63 8 74 9 82 5 401 5 8 13 21 40 3 6 50 7 61",
    ": 70 96 501 3 7 20 3 37 46 50 2 5 7 62 73 6 84 7 91 601 7 12 20 6 42 5 9-50 2",
    ": 62 9 72 4 88 96 704 6 20 4 6 31 6 40 9 52 5 9 61 5 8 72 81 6 806 17 20 2 7 34",
    ": 40 3 51 64 9-70 4 7 81 3 9 92 9 904 6 10-1 21 3 5 33 41 54 62 8 78 83 5 9 92",
    ": 4",
    ": 7001 26 31 61 5 7 72 7 9 81-2 9 93 6 8 101 4 9 20 7 9 31 7 41-2 5 53 5 8 64 6",
    ": 70 4 81 4 6-7 90-1 200 3 8 11 3 8 20 7 35 42 4 9 52 4 8 61 7 72 80 3 96 300 3",
    ": 6 12 5 26 35 48 54 62 87 90 8 426 44 7 55 8 60 3 73 7 9 81 9 95 7 9 509 12 4",
    ": 6 27 32 5 8 54 7 60 8 71 5 9 83 5 8 95 602 4 10 3 20 5 8-9 33 6 8 41 5 8 50",
    ": 60 4 8 76 86 91 704 11 38 40 50 5 68 75 8 85 7-8 93 803 12 37 48 51 4 60 3 8",
    ": 71 4 81 3 8 91 900 5 10 21 30 43 6 52 4 8 70 81 6 8 91 4",
    ": 8013 9 37 43 52 62 81 5 8 90 2 102 12 31 45 9 65 70 8 88 96 202 5 9 24 36 8",
    ": 41 8 57 9 68 73 5 94 309 42 4 50 74 81 4 6 400 24 7 31 47 59 68 73 91 516 20",
    ": 5 33 5 42 6 52 6 9 65 9 79 84 98 618 20 3 5 30 40 5 50 61 70 4 6 84 93 6 700",
    ": 8 13 23 31 6 44-5 51 7 60 4 6 73 5 9 81 4 90 9 805 8 11 20 5 52 5 7 75 82 92",
    ": 9 909 24 33 40 6 92",
    ": 9023 30 4 56 78 87 92 117 26 31 7 51 62 9 72 206 23 9 47 51 8 64 7 90 9 309",
    ": 20 7 32 4 8 41 6 56 9 69 77 86 91 3 405 9 11 5 28 36 8 49 71 6 80 4 91 9 510",
    ": 3 9 25 7 38 40 50 5 7 65 70 88 90-2 5 7 600 7 21 4 7 37 42 4 52 7 65 85 723 9",
    ": 52 7 61 74 81 4 8 98 816 9 23 35 42 5 8 52 6 8 62 4 8 74 7 9 87 90 4 8 903 5",
    ": 9 15 24 7 9 32 7 40 2 4 50 5 8 60 4 9 72 7 80 5",
    ": 60008 17 21 3 6 9 32 61 75 88 90 5 7 104-5 8 12 5 8 23 8 31 8 43 6 50 61 71 8",
    ": 86 218 35 44 52 4 6 60 5 70 98 302 4 11 25 8 59 72 86 409 15 23 7 56 8 61 4 6",
    ": 76 9 83 6 500 5 7 10 6 24 6-7 31 4 6 8 42 9 54 7 63 9 73 7 81 4 7 94 7 603 18",
    ": 30 6 40 52 7 67 90 707 9 13 7 28 35 43 5 7 52 7 9 62 5 8 71 5 8 87 808 11 5 7",
    ": 20 39 46-7 52 4 6 60 3 6 73 9 95 903 8 12 5 8 24 32 4 9 41 3 5 9-50 3 5 68 71",
    ": 3 80 9-90 4 6",
    ": 1000 2 6 11 3 7 21 8 32 4 6 9 44 7 9 52 62 6 9 75 80 3 90 3 100 5 13 7 21 4 7",
    ": 9 32 6 51 3 6 60 3-4 6 72 6 83 7 93 7 223 9 43 50 3 60 6 70 3 6 8 82 9 92-3 6",
    ": 9 302 5 17 23 7 9 32-4 54 60 7 72 87 95 405 19 22 5 35 9-40 50 9 69 500 8 39",
    ": 73 7 80 5 92 6 607 14 6 8 20 2 4 7 31 6 46 52 4 62 5 71 82 5 8 713 29 44 7 58",
    ": 64 73 80 2 6 9 92 4 806 14 30 9 53 5 61 8 71 9 82 7 90 9 908 13 27 9-30 42-3",
    ": 5 52 7 61 7 77 9 88 93",
    ": 2000 9 24 7 31 3 46 50 61 6 71 95 102 4-6 18 21 7 30 2-3 5 7 9 47 51 4 75 82",
    ": 7 9 93 200 5 11 9 28 57 9 68 74 7 85 90 5 8 305 8 19 22 5 38 43 7 54 60 6 70",
    ": 8 83 8 94 7 9 405 10 3 7 25 31 4 7 41 3 55 65 8 71 3-4 7 82 6 9 92 4 8 504 7",
    ": 27 9 33 5 7 9 48 55 60 5 72 81 7 90 3 6 8 610 4 9 21 4 6 32 8 42 5 7 9 54 7",
    ": 60-1 3 73 80 3 92 5 701-2 5 7 10 2 9 34 44 9 64 8 74 9 801 31 7 48 57 62 5 77",
    ": 94 7 903 15 37 42 94 8",
    ": 3001 29 106 47 55 7 9 63 74 99 203 16 20 7 40 4 7 56 63 71 3 7 300 16 38 55 7",
    ": 63 8 75 84 400 9 13 20 36 63 72 506 9 40 63 5 9 71-2 6 82 95 610 2 7 20 8 50",
    ": 82 92 5 719 33 6 45 61 77 82 9 803 8 17 31 7 44 53 60 3 8 73 95 904 6 9 12 25",
    ": 8 31 4 44 7 51 5 8 65 8 73 6 8 81 4 6 90",
    ": 4004 6 12 8 23 30 5 42 4 57 60 4 6 71 94 104 7 11 38 41 7 65 9 92 200 18 36",
    ": 40-1 7 62 6 8 84 6 9 91 3 5 9 302-3 5 11 5 20 2 7 9 40 7 9 54 7-8 67 72 4 6-7",
    ": 90 7 405 20 8 44 7 52 63 72 84 8 500 8 11 7 22 5 36 40 4 9 54 9 63 9 85 8 91",
    ": 4 605-6 9 16-7 21 8 31 3 8 47 51 4 8 64 6 70 3 7 9 82 93-4 7 9 705 14 7 26 9",
    ": 32 47-8 60 3 6 9 73-4 7 80 4 7-8 92 801 4 11 3 9 22 6 30 8 44 8 52 5 7 68 81",
    ": 8 91 5 8 907 12 4 7 21 7 48 67 71 7 82 4 92 7",
    ": 5006 8 11 3-4 7 21 9 39 42 4 6 9 51 60 2 5 8 70 3 7 92 100 3 20 3 5 35-6 9 46",
    ": 53 5 8 72 4 206 18 21 4 35 46 8 53 7 60 3 8 70 5 83 95 8 301 5 8 16 23-4 31 3",
    ": 55 8-60 6 70 6 8 84 6 96 9 402 5 22 6 41 52 63 8 70 3 5 94 6 504 21 8 31 54",
    ": 64 80 3-4 98 603 11 4 8 21 33 48 50 7 61 8 83 6 90 4 7 700 11 8 21 4 6 30 40",
    ": 7 50 2-3 5 7 9 64 72 82 92 4 6 9 818 21 5 7 9 37 52 5 9 61 6 8 75 96 9 902 4",
    ": 9 12 4 8 21 4 9 32 5 9 41 54 62 72 5 8 95",
    ": 6000 3 8 10 3 7 9 21 30 3 6-7 9-40 2 6 51 3 8 67 79 82 5 9 91 4 107 11 5 9",
    ": 26-7 9 31 6 9 42-3 51 8-9 67 70-2 91 4 8 204 7 13 5-6 9 28 31 3 6 45 9 52 8",
    ": 64 72 4 87 90 2 6 8 301 3 6 9-10 7 24 6 8-9 37 40 2 7 54 9 62 74 7 84 9 94-5",
    ": 400 2 4 6 10 3 5 8 27 46 9 52 4 68 70-1 3-4 7 9 93 6 500 9 16 8 35 7 9 44 61",
    ": 9 73 8 87 90 5 7 600 5 12 4 30 5 8 46 50 8 61 3 6 9 73 6 9 89 91 702 9 12 4 7",
    ": 20 5 7 9 37 43 52 8 61-2 5 8 72 8 84 7 93 5 8 801 7 15 8 23 5 8 30 8-9 50 3 6",
    ": 66 8 81 5 9 92 4 9-900 3 14 6 20 9 32 5 8 42 4 8 50 3 9 62 4 70 6-7 81 7 90 3",
    ": 9-7000 5 8 14 7 9 23 9 32 45 8 52 7 60 3 7 73 81 4 6 91 5 7 101 4 12 4 8 41",
    ": 51 4 8 90 201 5 15 9 28 30 4 43 6 51 3 6 63 9 72 6 8 81 3 6 95 306 9 16-7 22",
    ": 5 9 31 7 55 7-8 61 5 7 9 71 3-4 7 80-1 4 91-2 6-7 9 403 5 7 12 5 8 23 7 30 9",
    ": 43 54 64 73 6 80 3 6 94 7 9 502 5 7 13 5 7 25 8 37 54 8 64 8 80 2 6 91 3 600",
    ": 3 7 10 2 4 7 20 3 5 8 30 3 5 7 42 4 7 51 61 7 71 6 80 5 90-2 706 10 3 22 5 30",
    ": 8 40 55 7 9 62 5 7 73 5 80-1 7 91 7 800 2 5 10 25 32 5 42 63 73 901 9 27 45",
    ": 54 8 80 2 6-7 95 7",
    ": 8001 6 11 3 7 20-1 8 36 9 43 7 54 8 61 70 2 4-5 87 90 5 102 5 14 7 24 8 36 53",
    ": 83 205 7 10 4 35 60 6 73 85 91 8 301 13 6 26 8 36 43 60 3 9 71 3 87 405 7 10",
    ": 8 26 38 43 8 53 5 61 3 71 89 97 500 13 5 8 24 8 38 40 3 50 3 7 60-1 4 9 73 80",
    ": 3 8 91 9 602 12 6 28 31 3 7 9 43 6 8 57 67 9 72 89 92 700 11 24 7 33 51 5 61",
    ": 72 5 9 803 30 54 8 65 94 7 914 26 9 44 57 69 71 5 7 9 81 3 6",
    ": 99-9000 3 12 23 9 43 6 9 53 8 81 92 5 115 8 23 31 40 53 61 5 70 5 7 82 96 9",
    ": 204 9 12 4 8 20 3 6 9 35 7 46 67 73 83 9 94 7 302 37 42 57 61 3 7 9 74 88 92",
    ": 7 417 20 2 6 32 4 42 52 4 6 67 75 80 3 6 9 94 7 502 5 11 3 6 9 23 5 9 32 7 46",
    ": 50 8 62 7 80 92 7 601 11 5 8 22 30-1 6 40 4 51 6 61 8 71 4 6 9 88 96 700 3 7",
    ": 9 13 8 24 7 32 4 6 45 7 9 55 9 73 83 8 90 3 6 804 11 6 8 23 6 30 2-3 44 8 50",
    ": 6 64 6 72 81 5 7-8 93 6 900 12 4 31 4-5 7 40 9 55 65 75 9 90-1 6 8",
    ": 70001 9 19 22 8-9 33 43 60 3-4 9-70 3 81 3 5 93 5-6 9 102 9 11 3 5 9 26 31 8",
    ": 42-3 6 51 4 7 9 64 8 72 6 80 3-4 6 9 93 200 3 5 12 7 20 9 42 8 54 62 8 78 84",
    ": 6 96 300 2 5 21 3 5 8 32 5 68 74 6 9 81 3 6 91 5 408 20 5 8 30 3 6 40 53 62 6",
    ": 75 80 3 5 8 96 8 508 16 20 3 43 6 55 8 60 4 7 71 3 8 82 5 9 94 7 602 6 16 9",
    ": 21 35 43 7 50 69 73 82 6 92 703 9 16 32 6 9 46 8 50 64 71 4 8-9 87 9 95 8 801",
    ": 16 22 51 4 62 70 86 8 916 27 36 63 9 80 95",
    ": 1004 28 32 40 52 8 60 2 6 70 88 95 135 41 5 81 3 203 6 27 9 45 72 6 81 8 301",
    ": 10 9 35 8 43 5 53 70 6 8 80-1 90 5 402 11 6 23 7 54 8 69 75 83 501 3 14 27 34",
    ": 8 41 4 56 8 80 93 5 9 613 9 21 8 33 7 41 5 8 50 63 9 72 9 85 8 90 700 4 10 24",
    ": 34 9 43 7 72 5 86 91 7 835 42 9 52 8 62 8 71 7 81 4 900 19 23 7 9 34 41 51 4",
    ": 63 9 72 89 95",
    ": 2000 3 5 9 13 7 36 8 40 8 51 5 7 60 2 4 80 6 90 111 5 32 6 8 50 4 6 66 73 80",
    ": 5 90 3 6 205 13 6 26 40 4 51 5 60 3 7 79 92 4 303 6 16 8 28 32 4 8 42 6 57 9",
    ": 62 5 70 2-3 6 9 86 9 98 404 6 15 8 32 8 42 50 6 68 70 2 4 7 81 8 90 4 510 7",
    ": 25 7 35 8 47 9 57 60 2 5 7 73 6 83-5 8 90 5 600 2 4 6 17 20 7 33 5 42 4 6 54",
    ": 61 9 72 8 84-5 9 91 4 9 702 5 14 22 8 31 6 45 7 51 4 8 61 5 9 74 86 9 92 9",
    ": 805 11 4 28 53 64 6 73 5 9 81 5 8 910 8 20 8 31 5 46 57 61 74 9 89 93 7",
    ": 3003 5 29 38 41 58 67 74 90 2 6 9 101 3 7 9 13 5 9 27 34-5 8 41 7 58 87 95 8",
    ": 201-2 4 13 6 8 23 31 9 51 4 60 2 6 70 5 7 9 81 7 90 3 304 8 16 24 30 2 4 41-2",
    ": 50-1 6 8 60 2-3 6 70 9 94 9-400 5 10 7 23 6 8 33 55 62 7 78 80 6 92 6 513 6",
    ": 30 3 6 41 3 6 9 51 3 6 8 72 8 90 602 4 6 9 11-2 8-9 22 9 33 6 8 45 59 62 6 9",
    ": 71 84 8 91 701 3 11 4 23 6 50 4 8 62 4 73 6 82 5-6 800 2 5-6 9 12 6 9 25-6 9",
    ": 31 6 8 42 9 55 9 61 4 76 80 90 2 908 12 6 22 4 8 32-3 8 41 3 50 62 74 9 81 5",
    ": 90 8",
    ": 4005 9 23 8 30 6 9 41 50 2 5 60 7 71 5-6 9 87 93 5 102 4 9 11 3 7 23 35 40 6",
    ": 54 8 67 77 81 94 200 8 11 4 9 23 5 32 4 9 44 6 9 61 72 9 92 8 301 4 7 9 16 24",
    ": 7 9 37 41 5 53 61 4 7 71 6 8 90 401 6 11-2 8 20 30 2 46 9 55 63 5 8 71 80 3",
    ": 90 3 6 512 6 28 31 40 3 7 52 65 8 73-4 6 81 3 90 3 8 602 10 4 27 34 8 40 55 7",
    ": 61 74 6 84 95 9 710 3 22 9 32 6 9 53 75 8 80 2 4 9 96 9 811 7 28 32 40 5 52",
    ": 4-5 7 64 9 74 6 82 99 905 8 14 6 8 23 46 58 62 72 6 82 90 5",
    ": 5000 4 17 25 8 41 5 53 60 73 81 4 94 8 101 4 7 9 12 4 7 20 6 9 32 4 7 49 51-2",
    ": 6 62 71 4 7 81 4 7 90 3 7 207 13 5 20 6 31 7 42-3 6 55 63 8 70 3 5 8 81 3 94",
    ": 303 5 9 13 6 8 28 31 5 7 46 8 57 60 6 9 74 7 83 6 90 9 402 7 11 7 20 4 9 32 8",
    ": 44 7 53 6 9 65 7 9 72 6 84 90 3 6 9 502 5 8 13 6 8 21 4 38 40-1 3 7 9 51 60 3",
    ": 72 8 83 5 9-90 7 602 7 13-4 24 7 31 7 43-4 9 52 5 65 71 4 8 94 702 5 7 14 8",
    ": 20 4 34 6 9 41-2 54 8 60 6 78 80 5 8 93 6 806 9 13 9 24 9 38 45 9 55 7 61 74",
    ": 95 900 8-9 24 6 34 6 48 52 74 6 9 82 95 8",
    ": 6000 11 3 21 4 33-4 7 50 2 5 8 60 3 5 73 5 84 99 104 14 8 28 56 66 70 7 80 3",
    ": 7 95 206 8 11 3 7 23 9 34 6 45 51 3 6 60 3 8 70 9 84 6 305 12 5 20 6 8 37 43",
    ": 9 51 4 6-7 62 72 4 80 3 90 4 400 3 10 5 21 3 6 9 31 4 43 50 4 7 60 4 6 8 71 8",
    ": 80 90 8 502 4 7 10 21 3 6 32 5 43 5 8 51 9 66-7 73 7 80 5 90 3 8 605 19 22 9",
    ": 37 54 62 727-8 34 40 2 4 6 50 70 96 807 55 61 3 96 9 906 11 5 20 4 30 4 8 42",
    ": 4 8 54 7 66 72 86 97",
    ": 7000 3 7 18 22 6 9 35 9 42 6 8 51 61 4 6-8 71 8-9 86 8 93 5 103 6 21 8-9 45",
    ": 50 4 8 61 9 71 6 203 9 11 26 53 6 9 64 7 77 90 316 29 36 9 45 52 8 72 84 90 2",
    ": 9-400 3 5 9 16 24 7 35 42 5 56 8 61 9 75 80 3 5 7 90 5 501 4 7 12 27 31 43",
    ": 61-2 7 79 81 90 3 611 20 37 47 52 6 9 62 70 3 7 80 6 90 5 712 8 38 56 64 70 2",
    ": 7 95 807 18 26 60 72 6 82 7 900 12 8 23 8 38 44 8 55 7 68-9 76 8 81 3 5 97 9",
    ": 8013 7 25 8 30 45 51 4 7 62 6 8 74 9 86 102 30 5 78 94 7 203 6 10 3 53 5 61 4",
    ": 70 5 8 83 6 8 91 7 305 9 16 24 7 31 51 61 4 82 6 92 8 402 6 10 6 9 21 5 37 53",
    ": 8 72 90 506 12 6 24 30 3 5 40 5 9-50 3 6 60 3 8 73 6 8 86 90 604 8 10-1 7 21",
    ": 5 8 31 5 44 59 71 83 6 99 701 5 11 22 5 9 32 4-5 42 65 8 80 9 95 805 13 53 69",
    ": 92 8 901 18 23 30 48 50 2 4 8 61 5-8 71 80 8 94",
    ": 9000 4 7 15 9 22 8 41 6 8 53 7 71 4 7 80 9 95 116 22 5 34 40 8 52 6 9 62 71 4",
    ": 7 97 200-1 27 44 58 63 9 88 93 9 308 11 5 9 24 9 37 42 7 53 76 9 85 98 404 7",
    ": 11 4 27 31 7 46 8 86 90 7 507 10 3 20 4 8 35-6 41 57 62 9 71 80 7 90 2 7 616",
    ": 8 21 4 6 9 31 4 7 9 42 4 8 52 5 62 5 9 71 6 83 9 92 6 702 4 14 7-8 26 30 2 4",
    ": 7 41 3 6 8 55 8 60 2 8 71 4 6 85 7 9 99 805 7 10 5 24 32 4 48 51 6 8 62 5 8",
    ": 86-7 92 8 902 5 21 30 4 6 43 5 7 56-7 62 7 71 6-7 88 93-4",
    ": 80003 10 23 36 46 53 5 7 65 8 77 9 89 104 13 5 8 20 7 9 32 4-5 41 4 7 54 6 8",
    ": 60 2 7 70 5 7 9 82 4 6 8 94 202 8 10 3 22-3 5 39 41 3 8 58 64 7 81 94 308 16",
    ": 9 22 6 8 30 6 8 42 52 4 67 70 2 6-7 9 81 6 91 9 403 7 9 14 20 7 9 31 3 9 44",
    ": 52 63 5 9 81 6 9 91 7 502 4 12 4 9 23 9 40 3 56 8 62 5 9 75 7 80 5 90 604 6",
    ": 11 3 23 7 9 38 43 53 7 61 4 6 72 5 82 5 9 98 706 10 6 21 5 33 6 40 2 4 6 54 8",
    ": 60 2-3 6 8-9 71 4 83 91 4 7 9 806 8 12 4-5 8 20-1 3 5 31 3 6 9 41 3-4 6 54 61",
    ": 72 6 82 6 8 91 4 900 2 5 7 18 25 9 32 42 7 52 5 9 61 6-7 71 3 8 80-1 5 9-90 2",
    ": 4 8",
    ": 1003 5 7 11 4 6 21 4 7 9 31 3 40-1 8 51 3 7 63 5 70-1 3-4 82 4-5 7 9 101 3 5",
    ": 8 12 5-6 8-9 24 8 33 6-7 40 4 7 51 61 3 5 9 71 3 5 84 6 8 91 3 6 9 203 5 9 14",
    ": 6 9 22 4 8 31 8 43 6 50 2 4 8 60 5 7 71 5 7 9 83 90 2 5 9 302 4 11 5 7 20 5-6",
    ": 31 3 6 42 52 5 61 76 8 81 5 7 9 91 5 401 9 15-6 9 24 9 33 5 7 40 2 8 52 75 82",
    ": 8 90 4 6 9 501 17 21 9 32 8 41 6 8 50 2 4 7 9 61 4 6 71 5 87 90 4 607 9 11 6",
    ": 26 30 7 9 43 9 51 3 5 7 68 70 3 5-6 8 83 5-6 94 702 13 6 9 37 9-40 7 56 78 86",
    ": 92 804 7 25 38 46 8 68 80 2 9 93 902 14 7 25 9 40 57 64 70 4 91",
    ": 2000 5 16 20 5 49 52 6 8 80 5 100 2 4-5 7 11-2 8 23 5 30-1 8 40 2 6 8 52 60 6",
    ": 9 91 209 13 5 26 41 61 76 87 92 4 8 300 2 20 5 8 30 7 43 6 9 53 5 8 75 88 97",
    ": 401 10 2 4-6 8 25 32 4 41 61 3 7 9 74 82 4 92 5-6 9 502 4 7-8 13 8 21 36 41-2",
    ": 6 54 65 71 9 87 9 93 5 600 4 6 22 46 61 8 83 719 37 42 6 61 81-2 5 93 6 800-1",
    ": 4 6 8 11-3 5 8 22 5 8 34 6 8 43 5-7 9 53-5 7 9 62 5 7 9 72 4 8 81-2 4 8 91-2",
    ": 5-6 901 4-5 8 10 5 7-8 21-2 5-6 8-9 34-5 7 43 6 51 3 8 61-2 5 73 5 8 80 2 7-8",
    ": 93-4 6 9",
    ": 3010 6-7 22-3 6-7 33-4 6 47 9 52 60 2 73 5 8-9 84 6 96 101 6 8 11 5 25 8 34 9",
    ": 41 5 53 5 61 5-6 8 73 6 81 3 7 91 7 201 3 6-7 10 2-3 5 7-8 20-1 6-7 30 3 5 7",
    ": 9 43-4 8 50-1 3 6 60 2 4 8 70 3 83 7-8 90 4 7 300 5 11 3 6 8 20 2 7 30 2 47-8",
    ": 54 6 69 77 80 2 4 8 93 6 9 402 5 7 15 9 23 6 8 34 9-40 5-6 9 56 8 62 7-8 70",
    ": 3-4 81-2 4 91-2 7 502 5 7 10 7 24 8-9 31-2 4-5 8 40 5 8 54-6 62 4 7 71-2 5-6",
    ": 8 80-1 3-4 8 90 3 6 601 3 5 9 11 4 6 24 8-9 33 5 44-5 51 4 6-8 61 6 72 5 80 3",
    ": 9 94 8 700 4-5 7 9 12-3 6-7 21 5 9 36 8-9 41-3 5 52 4-5 7 61-2 4-6 8 73 5-6 8",
    ": 80 4 6 8 90 3-5 7-8 801 3 7 10 4 21 3 5-7 30 4 7 9 41 6 9 51 7 9-60 2 6 9 73",
    ": 6 81 5 7 9 93-4 7 900 6 8-9 11 3 25 7 9-30 4-5 7 41 3 5 8 50 7 9-63 5-6 9",
    ": 71-2 80 3 5 90 7",
    ": 4001 7-8 11 4 8 22 5 7-8 30 2 4-5 7 9 47-8 53 5-6 8-9 62 7 9 73 7 9-80 2 5 8",
    ": 90 8 105 10 4-5 7-9 21 7 30 2 6 8-9 43 8 51 3 5 7 9 62-3 6 70 4 7-8 80-1 3-4",
    ": 6 8 91-2 4 6-7 9-200 2 5 8-9 14-5 7 20 4 8 31-3 6-7 9 41 3 6 53 9-60 2 5-6",
    ": 75-7 9 81 6 9 94 301 3 8 10 3 9-22 4 9-30 3 6 8 40 9 52 5-6 8 61 5 9 71 5 7",
    ": 9-80 2-3 7-8 94 7-8 401 3 5-6 13 6-8 20-1 4 6-7 33 6 9 41-2 4-7 52 5 8 61 5 7",
    ": 9 71 3 8 83 5 8 91 3 7 9 501-2 6-9 11 5-7 9-20 2 4-5 8 30 4 7 9 43 5 9 51 4",
    ": 60-1 5-6 8 71-2 6 80 4 8 91 5 7 9 601-2 4 6 8 16 8 20 3 5 8-9 34 8-9 42 6 8",
    ": 50-1 3 9 61 7 9 71 3 5 9 81 3 5 90-1 3 5 704 11-2 4-6 8 20 2-3 5 8-9 31 4 43",
    ": 52 5 9 62 4 6-7 9-71 3 6 83 9-90 2 4 6 8 802-3 6 10-1 3 5 7-8 20-1 3 7 30 40",
    ": 6 54 7 9-62 4 71 83 6 92 4 7-8 900 2 9 14 9 21-2 7 9 31 3 5 7 43 5 7-8 51 3-4",
    ": 6 8 62 5 7-8 70 2 8 83-4 8 91-2 6",
    ": 5001 4 8 14 8 24 8 31 3 6 9 42-3 5 9-50 2 4 7 69 71 3 6 8 80 2-3 5 90-2 6 8",
    ": 102 4 8 13 7 9 22 5 7-8 30 2 5 7 9 45 8 52 4-5 7-9 63 5-6 8-9 71 3 7-8 81 3-4",
    ": 8 90-1 3 6-7 200 5 10 2 5 7 9 25 7-8 30-1 5 7 40 3 51 7-8 68 70-1 4-5 8 81",
    ": 6-7 95 7 9 303 11-2 4 6-7 9 23-4 6 8-9 32-3 6 41 6 51-2 4-5 8 62 4-5 8 70 5-6",
    ": 8 83 5 94 8 400 4 6-7 12 4 6-7 21 9 31 7 41-2 5 7 9-50 2 5 8 60-1 6 8 70 3 6",
    ": 80 3 5 7 9-90 6 8 504 10-1 3 6-8 22 4-5 8 30 2 4-5 7 45-7 9 52 6-7 60 4-5 7",
    ": 9-71 5 7-8 81-2 5 9-90 4 7 9-600 4 9 13 7 9-20 2-3 5 7 31 4 6-7 44 7 9 52 9",
    ": 61-2 4-5 70 3 9 82 5 90-2 4-7 700 2 4-5 7 10 6 9 23-4 6 8-9 31 6 8-41 4 6 8",
    ": 52 9 61 3 5 7 73 7 80 2-3 7 91 3 803 14 7-8 20-1 3-6 8-9 31 3 5-6 40 2 5-6 8",
    ": 51 3 8 61 3-5 7 70 5 80 3 7 91 3-4 8 901-2 4-6 11 4 21-2 4-6 8-9 36 8 40 2-3",
    ": 5 50-1 3 6-7 60 7-8 70 2 4-5 82-3 5 7 95",
    ": 6000-1 3-5 7 10-1 3-5 7 22-3 6 8-9 31 8 42 4-5 8 50 3-4 6-63 8 72-4 8 81-3 8",
    ": 90 8-9 102 6 8-9 12 7 9 21 4 32 4 8 41 6 8 51 3 7 60-4 9-70 2 5-6 8-9 84 7",
    ": 9-90 3 5-6 8-201 8 10 3-4 7 27 9-30 2 7-8 41-2 4 8 50-3 5-6 61-2 5-6 8 70-2",
    ": 4-5 8 90 2 7 9 303-6 8 10-1 3 5 7 22 9 37 43 5 8 52 4 6 9 61 6 8 72 5 8 82 4",
    ": 8 92 400 2 4 7 9 14-5 26-7 30 2 4 7 9 45-6 8-9 52 4 6 8-60 2-3 5 70 2-3 5 80",
    ": 90 5 7-8 502 5 9 11 4 6-7 21 3 30 3 6 8 40 2 7 54 6-7 64 8 72 7 80-2 4-5 7-9",
    ": 92-3 8 603-4 8 12 4 8-9 23-5 7-8 30 8 40 2 6-9 52 4-60 2-3 6 70 2-3 80 5 7",
    ": 90-2 5 8 701-2 4 6-9 11 4-6 8 20-1 3-4 7 9-30 4 8-9 43-4 6 9 51-2 4-5 60 2-3",
    ": 5 7 70 2 4 6 8 82 7 9-90 2-3 5 9 801 3 5 9 11-2 4 7-8 20 4-5 8 34 7 41 4 7 9",
    ": 53 6 60-1 3 5-7 9 72 4-5 7 86 9-91 6-7 901 4-8 10 4 27 32 6 44 7-8 50 2-3 5",
    ": 60 2 4-6 9 75 7 9 81 3 5-7 9 95",
    ": 7003 11 5 20 8 30 3 6 9-40 3-4 7 9 51 3 5-6 9-60 4-5 8 70-1 3 7 80 4 9-90 2 6",
    ": 8 102-3 6 10-1 4 6 8-9 21-2 8 35-7 9-40 2-3 5-6 51 6 8-9 61 5 70 3-4 6 80-1 5",
    ": 7 90 7 200 2-3 10-1 5 7 22 5 30-1 7 9 41 3 6 8 52 5 60 3 6 8 70 83 5 8 91 3 6",
    ": 8 304 7 12 6 9 21 4 6 9 36 8 40 3 9 51 4 60 2 4 70 6 9-80 9 91 6 8 401-2 10 4",
    ": 6 25-6 8-9 38-9 41-2 5 7 50 2 6 8 60 4 70 2 6 8 80 91 3-4 504 7 10 3 6 20-1 3",
    ": 7 36 9 43-4 9-52 4 7 9 64 7 9 71 4 6 8 80 2 7 92-3 6 9 602-4 6-7 13-4 6 8 20",
    ": 2-3 6 30 3 6 8 40 2-3 8-9 51-2 4-5 7-8 62 71 3 82 4-5 7-8 90 2 4-5 705 7 12-3",
    ": 5 7 9 21-2 4-5 9 31-2 4-5 9 47 57 62 4 7 9 71 3-4 6 8-9 81 8 93 6 9 803 6 8",
    ": 10 4 21 32 6 8 42 4 6 8 51 3-4 6-8 61 5 9-70 4-5 81 3-4 7 90 2-3 5-6 900 2 5",
    ": 7-8 11 21 4 7-8 30 3 8 42 7 50-2 4 7 62 4 78 81 4 6 8-90 2-5 9",
    ": 8002-3 6 15 8-9 21 5-6 9 31 3 7 9 45 7 9 51 3-4 6 8 61 5-6 70 5 7-8 80 3 6-7",
    ": 9 91 5-6 100 5 12 4 6 9 21 3 6 8 35 7 9-40 2 4 7 52-3 5-7 61-2 4 78 80 2 5 7",
    ": 9 92-3 5-8 201-2 4-5 9 13 9 22 36 9 46 59 61-2 70-1 5 8 83 7 9-91 6-7 300 3 5",
    ": 8 10 22 4 33 7 9 41 3-4 7 50 2 5 7 66 8 70 6 80 5 8-90 6 8 401-2 4 9 13 7-9",
    ": 21 6-9 32 4 40 3 8 51 3 5-6 8 61 5 7 76 8 80 2 6 90 3-4 9 504 8 12 5 8 24-5 8",
    ": 33 5 7 9 42 5 7 50-1 3 5-6 60 3 6 8 71 3 5 83 5-6 8 92 6-7 9 601 3-4 6-7 9 13",
    ": 6 9 21 6-7 33 5 8 42 8 51 4 8 64 6 8 82 5 90 2-3 704 6 9-10 4-5 20 2-3 5-6",
    ": 9-30 2 7 46 52 6-7 60 3-4 6 8 72 7 9 82 6-7 95 800 2 7 10 5-6 8 20 5-6 9 31 9",
    ": 41 6 9 51 63 8 71 3 7-8 82 4 9-90 2-3 6 903 15 28 36 8 48-9 54 62 8 72-3 5-6",
    ": 8 81 6 9 92 4",
    ": 9000 3-4 6 8 10 4-5 9 24-5 9-30 2 4 45 8-9 52 4 6 9 61-2 5 7 9 73 8-9 81 3 8",
    ": 92-3 101 4 6 9-10 2 4 7 9 21 3 5-6 8 30 3 42-3 5 7-9 51 3 6 62 4-5 7 9-70 3",
    ": 5-6 80 2 4 90 4 6 8 200 4 6 12 4 6 8 20 3 5-6 32 4 6 8 40 4 7 9 52 4-5 9 67",
    ": 71 4 8 80 6 99 303 6 10 5 8 22 30 4 8 40 4-5 55 61-2 72 4 80 4 8 90 407 11 7",
    ": 23 6 30 3 7-8 44 8 52 4-5 8 63-4 8 77 85 7 9 92-3 7 507 9 13 6 8 20 2 7 30 4",
    ": 7-8 41 6 8-9 56 8 60-2 4 6 74-5 80 7 9 97-8 610 4 7 9 21-2 7 32 4 6 9 41 6",
    ": 50-1 4-5 7 61-2 4 7 70-1 4-5 7 83-4 6 90-1 3 5-6 8 703 5 10 2 7-8 23 7-8 30 5",
    ": 7 41 3-4 6 8 53 9 62-3 5 76 85 92-3 6 800 3 6-10 2-4 7-20 4-5 32 4 6 41 3-5 7",
    ": 9-50 4 8-9 62 4 9 78 83 90 3 5 901 3 5 10 3 7-8 20-2 6-8 30 2 6 41 3 5 9 51-2",
    ": 9 62-4 72 4 7-8 81 4 9 92-4 6 8",
    ": 90004 8 10 2 4 6 20 3 5-6 9 32-3 7 41 4 6 52 7 9 61-2 4 72 8 82 7 9 95 100 2",
    ": 6 10 2 9 23 5 34 42 7 50 5 61 3 8 71-2 5 81 3 6 99 201-2 4 10 2 4-5 26-7 35 9",
    ": 42-5 7-8 50 2-3 5-6 61 4 6-9 73 7-8 82-3 9 92 5 7 9 301 4 8-9 12 4 6 29 33 5",
    ": 9 45 7 52 5 8 68 71 6 9 81 3 6-7 92-3 403 8 20 3 6 9 33-4 6 8 47-8 51 4 6 67",
    ": 74 7 80 3-4 6-7 9-91 3 6 8 500 4 7 9-10 3 6 9 25 32 5 40 3 5 9 55 7 62 6 70 2",
    ": 7 82 5 90 2-3 5 7-8 601 8 11 4 6-7 9 24 6-7 31-2 4 40 2 57 60 2-3 71 3-5 7 80",
    ": 2-3 5 9-90 2 5-6 8 702-6 9 12 5 8 24 7-8 35 41 4 6 8-9 51 3-4 63 5 71 4 83 7",
    ": 90 4-5 7 801 4 6-7 13 5 7 20 6 8-9 31 4 42 7 9 53 9-60 2 7-8 71 3-4 8-9 82 4",
    ": 6 8 90-1 3 5-8 901 5-7 9 11-2 9 21 7-9 35 8 40 2-4 6-7 9-50 3-4 6 8 60 3-7",
    ": 9-71 6 8-80 2-3 6 91-2 5 7-9",
    ": 1001-2 5-6 8-11 3 5-6 8-9 25 7-8 35 7-8 42 5-6 8 50 2-3 6-7 60 3-4 6 9-70 3-4",
    ": 7-8 80 2 4-5 7 90-1 3 5 7-8 100 5 8 10 2 20 3-4 6 30-1 5 7-8 45-6 50 2-4 9 63",
    ": 6 8 71 3 5 8 82-3 5 91 3 9-200 6 9 12 5 20 2 5 7 31-2 6-7 41-2 4 7 50 4 6 8-9",
    ": 61 3-4 6 9-70 7-8 80 2 5 7-8 90-1 3 8 301-2 7 14 7 9-20 2 8-9 32 4 7 40-2 6",
    ": 54-5 7 60 3 5 9-70 4-5 8 81 3-4 7 90 2 5 7 9 403 5 15 20 4 9 31-2 5-6 9 48",
    ": 52-3 5 9 63-4 8-9 73 9 81 5-6 92 5-6 8 500 4-5 7 13 5 9 21-2 5 7 33-4 6-7 40",
    ": 3 5 51-2 6 64 6 75 7 81 5 9 92 4 6 602 4 8 11 3 23 5 38 40-1 5-6 8-9 51 8",
    ": 60-1 3 5 73 8 84 6 8 92 7 701-2 4 6-7 9-10 2 4 8-9 24 33 7 9 41 4-5 9-50 3",
    ": 5-6 8 63 5 7 9-70 2 4-5 7 9 82-3 90 4 8-9 801 4 6-7 11-2 8 21 6 32 5 7 41",
    ": 51-2 8 62 8 74 6 82 4-5 8 90 2 5 900-1 3 7 12-3 5 8 20 2-4 30 3 7 41-2 8-9 51",
    ": 3 8 60 2 6 9 75-7 9 81-2 5-6 8 92 4 9",
    ": 2010 2 20-2 4 8-9 36 8 43 5 8-9 52 4-5 7 64 7 71-2 4-5 9 81 3 6-7 91 3-4 6 8",
    ": 100 4 6 8 10 8 27 9 31-2 4 7 42 4-5 7-9 52 61-2 7-8 72 8 81 3-4 6 8 90-1 3 6",
    ": 9 202 4-6 22-3 8 41 4 7 61 5 7 71 7 83 5 8 90 4 301 3 5 7 10 7 29-30 4 7 41 3",
    ": 6 51 60-1 5-6 8-9 71 7 81-2 4 7-8 91 4-5 8 402 4 6-7 10 6-7 20-1 4-5 7 32 4",
    ": 6-7 40-1 3-4 7 9-50 2 8 60-1 3 8 76 9 81-2 4 91-3 6-7 503 5 9 11 5 7-8 24 7 9",
    ": 31-2 4 7 41 3-4 6-8 50-1 5 8 61 5-7 70 5 81 3 5 7-8 90-1 3 5 7 9 601-2 4 10 5",
    ": 7 9 21 3-4 7 9-30 3-5 7-8 42-3 8 53 7 62-3 5 7 74-5 8 81 7-8 90 4 6 9-700 4 7",
    ": 11 3-4 25-6 32-4 40 8 51 7-9 61 5-6 70 4 83 6 8 91 5-6 8 801 3 7 9 20 3 6 33",
    ": 9 41 6 56 9 70 5-6 80 2 8 90 7-8 900 3-4 7 14 6 25 30 2 4 6 8 42 4 7 9 56 8",
    ": 62 6 9 72 6 80 3 7 96",
    ": 3002 7 9 17 9-20 2 4 32 8-9 42 5 7 9 55 7-8 61 9-70 2-3 5 7-80 2-3 5 8 90 2 4",
    ": 6 9 101-7 9-16 8-20 2-4 6 8-30 2-3 8-40 2-6 8-9 51-2 4-6 8-9 64 6 71 3 6-81",
    ": 4-6 8 90-2 6-202 5 10-5 20-3 5 8 31-2 5 9-44 6 8 51 5 7-9 62-6 71-2 7-9 83-94",
    ": 6-8 301-5 7-9 12-20 4-5 30-3 5-6 8-43 6 8 50 6-61 3 6 8-9 71-3 5-6 8-9 81-5",
    ": 7-8 93 5-6 8 400 4-7 9-11 4 6 8 20 5 7 30 6 41 4 6-56 8 61-2 5 7-9 71-2 5",
    ": 7-83 7-9 95-502 4-6 8 10 2 6-7 24 6-7 30 2-6 9 44 6-8 53-4 8-60 2-3 5 7-9 71",
    ": 5 7 9 81-3 5 8 92 6 600 4 9 11-3 5-6 8 20-6 9-32 5 7-9 42-4 6-51 3 5 61-4 6",
    ": 71-4 6 8 81 6-7 9-91 3 5-7 9 701-3 5-10 2-5 8-20 3-4 7-8 32 6 9-40 2-5 7-8",
    ": 51-2 4 6-7 60-1 4 6 8-70 2 4-9 81-3 5 7-9 91-2 4 6 8-800 6 8-11 3-4 6-7 20-1",
    ": 4 8 33-4 6 8 40-1 3-4 6-7 9-50 3-9 63 6-9 71 3-4 6-80 2 4-6 9 91-6 8-901 3-5",
    ": 7-10 2-6 8 20 2-5 7-33 7 40-3 5-8 50-1 5-6 8-61 3 5 7-8 71-2 4-6 8-80 2-7",
    ": 90-2 4-8",
    ": 4000 2 4 6 8-10 5-6 8 21-5 7-33 5-8 42 4 6-55 8-61 5-8 70 5-7 80-3 5-91 3 5-7",
    ": 103-4 6-7 9-10 2 6-7 20-4 6 9-30 4-5 7-9 41-2 5 7 50 4-7 9-62 4-70 2 5-80 4 7",
    ": 9-90 2-8 200-1 7-9 12 5-20 2 4-6 8-9 31-5 7 9-40 3 5-7 9 53-6 8-9 61-3 5 7-8",
    ": 72-7 9-84 7-8 90 2 6 8 300-4 7 9 12 4-21 4-6 8-35 7 9 42-3 5-7 50-1 3 5-6",
    ": 8-60 3-70 3-6 8 80-5 7 9 91-3 5 7 9 401 4-5 7-10 3 5-7 9 21 4-8 32-4 9 41-8",
    ": 50-1 4 6-8 60-8 70 2-5 7 9-81 3-4 8-90 3 5-7 9-501 3-4 6 8-9 11-4 9 24 6 9",
    ": 31-2 4-5 40 2-3 6 50-2 6 8-60 2 4 6-9 72-4 6 8-9 87-8 90-2 4-7 601-2 4 6-12",
    ": 4-7 21 3 6 9-30 2-7 9 41-2 4-8 51 3-60 2-5 7 9 71 3-4 6-7 9-81 3 5 7-8 90 2",
    ": 5-7 9-702 4-5 15-27 9 32 5 7-8 40 3-5 7-8 51-2 4 7-8 60-4 6 8-77 9-83 5 9-90",
    ": 2-3 5-800 3 6-9 11 3-5 7-20 2-6 8 30-1 3 5-42 4-5 8-52 4-5 9-60 2-4 6-7 9 72",
    ": 4 6-7 80 3-5 7 9-90 3-4 6-7 9-902 5-6 8 11-6 9-22 4 7-8 31 3-4 6-8 40-7 51-3",
    ": 7-62 5 9-70 2-8 80-4 6 90-3 7",
    ": 5002-3 5-6 8 11-2 4-8 22 5 7-8 30-1 3-5 7 9 41-6 9-50 8-61 3-5 7-8 70 3-7",
    ": 81-3 6-90 3-7 9-111 3-4 6-9 21-2 5 7 9 32 4 7-9 41-3 5-6 8-51 4-6 60-1 7 9 71",
    ": 4 7 9-82 4 7 9 91-7 200-1 4 6 8 11 3-5 8-20 2 5-7 30-2 8 44 7-9 52-4 8-9 62-3",
    ": 6 9 73 5-6 9-80 2 6 8 94 6 8-9 302-3 5-6 8 11 3 5 8-9 24 6-7 30-1 9-40 4-5 7",
    ": 9 51 5 62-3 5 73 5 9-82 5-6 92 5 7-8 400 2-3 9 11-3 5-6 8 22-4 8-30 2-3 6",
    ": 41-2 4 8-9 51-2 4 6 8 61 4 6 8-9 71 3 5-6 8-9 83 6 9 91 3 8 500 3 8 11 4 8 21",
    ": 4 7-8 30-5 7 40 4 7 9 51 5 7 9 61 4 71 3 5-7 80 5 7-8 90 3 6-9 602-3 7 10-2",
    ": 4-6 8 20 2 4 7-30 2-3 5-6 9-41 3-6 9-51 5 7-8 60 4-8 71 3-4 6 8 80-1 5 7 92 6",
    ": 8 703 5 9-10 2-4 6 21 6-7 35 7 9 41 3 5 9 53-4 8 61 3 6-7 70 3 6 9-81 4 6 94",
    ": 6-7 9-800 4 13 9 24 7 33-4 6-7 9 41-2 5 7-8 50 2 4 60 2 5 70 2 8 80 3 6 9-90",
    ": 2 4 8 900-1 3-4 6 8 10-1 3 9 22-3 5 7-8 30 4 7 9 41 4-5 7 9-50 3 9 61-2 6 8-9",
    ": 74 7 80 3 6-7 9 92 4 6",
    ": 6001 8-9 12-4 6-7 9-21 4-5 8 30 9 41 5 7-8 50 3 7 62 5 7 9 71 3 6 9 81 5 9-90",
    ": 2 4 6-8 100 4 11-2 4 7 23 30-1 3 5 41 6-7 9-50 2-3 5 7 62 4 7 70 2 8 80 2 4 7",
    ": 9-90 2 5-6 9 201 3 7 16 21 5 8 30-1 3-4 6 9 41-5 8 54-7 62 4 6 8-9 72-6 9-80",
    ": 3 5 7 9 91 5-6 300 4-5 7 10 2 5 7-8 20 3 6-7 30 2-3 5-6 40-1 3-4 9-51 3 8 61",
    ": 6 8-9 76 80 2-3 5-6 8 90-1 3 8-401 3 5 7 9 12-3 5 8-9 25-8 32-3 8 40 2-4 6",
    ": 9-51 3-4 6 61-2 8 70-1 3 5 80-1 3 5-6 9 91-6 8-9 503 6-7 10-1 3-5 7-20 3-4",
    ": 6-7 9-31 41 4 7-9 53 60 3 5 8 78 81 5 90 4 6 8 603 5-6 8 10 6 9 21-2 6 8 31 3",
    ": 5-6 8 42 4 6 50 4 6 8-9 62-3 5 7 9 76 8 80-1 5 8 90 7-9 701-2 5 7-8 17 9 27",
    ": 30 8 40 2 8 50-1 3 7 61-2 4-5 7-8 71-2 5 8 80 2-3 5 7 9 91-2 5-7 9 802-4 6 11",
    ": 6-7 9-20 2-3 5 7 9 32 9 46 8 50 2-3 5 60 2 4-5 7 72-3 5 9 81 5-6 9-90 5 9",
    ": 902-3 7 9-11 3 5 7 9 22 4-5 8-9 31 5-6 40-1 3-4 51-2 8 61 6 8 70-2 4 9-80 4 8",
    ": 91-6 8",
    ": 7000 10 5-6 9-20 6 9 31 4-5 7 9-40 4 7-8 54 6 8 60 3 5-6 9 71 4 9 83 5-6 8 90",
    ": 3 7 101 3 6 8 11 3-4 8 21-2 9-30 3 5-6 8-9 41 3 5 8 51 3 60 2-3 5-6 70 4 6 9",
    ": 82 8-9 91 5-6 8-9 201-2 5 8 11 4 6-7 9 21-2 5-7 34 9-40 3-4 7 51 4-7 60 5 8",
    ": 70-1 4-5 7 80 2 4-6 8 90-3 5 8 300 2 4 9-10 3-5 7 27 31 4 6 44-5 9-50 2-3 5 7",
    ": 62 4-7 71 6 9 83-4 90 2-3 7 402-3 6 9 12-3 6-7 9-21 3 7 30-1 7 41 3 6 8 50 3",
    ": 5 9-60 8 70 2 4-6 8 80-1 8-9 91 3-4 8 501 5 7-8 10 2 4 6-7 22-3 6 8-9 31-2",
    ": 9-40 2-3 5 9 52 7-8 64 6 73-4 9-80 3 6 90 2 4-6 600 2 5 8-9 13 5 8 20 4 6 8",
    ": 30 3-4 6-7 41 6 8 52-3 7 9-60 2 6 8-9 74 6 9 82 4-5 7 92 4 7 9 701-2 5-6 10 4",
    ": 8 20 4 7 9-30 3 5 7 41 4 6-7 50 5 8-60 2 5-6 70-1 9 82 7 93-4 6-7 9-800 7 10",
    ": 5-6 8 20 2 30 3 5 7-8 45 7 50 2-3 60 2 4 70 5-6 83 5 90 3 5 7 9 901 6 9 11",
    ": 3-4 6 20 3-4 7 9-30 7 9-40 2-3 5 9 51 3 5-6 8 62-4 6 8 70-1 3 6 8 80 6-7 90 3",
    ": 5-6 8",
    ": 8000-1 5 7 10 3 27 30 6 44 8 51 3 5-6 65 71 3-4 6 8-80 4-5 8-90 2 6-8 100-2 4",
    ": 8-9 11 5-8 20 6 9 31 3 7 41 6-7 53 5-7 60-1 3-4 6 9-70 5-8 81 4 6-7 91-3 6-8",
    ": 200 8-9 11 8-9 21 3 5 7 9-30 6-7 40 2 6-7 50 4 6 8 60-2 4-70 3 6-9 81-5 7-91",
    ": 3 5-6 8 301-2 4-5 7-12 4-5 20 2-3 8 30-1 3 5 40-1 3-6 9 52 5 61 5-7 9-74 81 3",
    ": 6-7 9 91-3 6 8-9 401-2 5 9 11-2 4 23-4 6 8-30 2 4 8-40 2 5 9 52-3 5-6 9 61-2",
    ": 5 8 72 4 6-7 81-2 4-5 94 500-2 5-7 11-2 4 7 9 23 8 31-2 5-6 8 40 3 7 9 51 4-5",
    ": 7 9 63-4 6 72 6 8 80 3-7 9-90 7-8 600 5 10 3 5 7 23 7 37-40 2 6 9-50 2-3 5",
    ": 8-9 63 9 73 7 9 81-2 4 7 9 94-5 7 9 702 4-5 10 3 9 21 4-5 7 31 3 8-40 2 5 7-8",
    ": 52 4-5 60 5 9 71 7-8 80 4 6 9-90 3-4 8 804 7-8 10 5 7 21 5-6 9-30 2-5 8 40",
    ": 2-3 5 9-50 3 5 8-9 61 3 5-7 9-73 6 80 3-5 90-3 5-7 9 902-4 8 11-3 7-8 21 30-1",
    ": 5 7-9 46-8 50 3 5 9 63 5 7 70 3 6 8 88 91 3 6",
    ": 9-9000 6 11 4-5 8 20-1 4-6 9 31 6 8 42 5 50-1 4 7 9 68 71-2 4-5 82 5-6 8 90-1",
    ": 4 6 8 102 10 6 8 20 2-3 5 8 31 3 7-8 40 4 8 50-1 5-6 8 60 2 6-7 9-70 3-4 8-9",
    ": 82 6-7 9-92 5 8 200-1 5-7 10 3 6 22 4 6 31-3 6 40 3 6 9 56-7 63 5 8-9 71-3",
    ": 5-6 8 80 4 90 3-5 7-8 300 2 5 7 10-1 3-5 7 9-20 2-3 30 4 6-7 9 41 4 6-7 9-51",
    ": 5-7 61-2 5 8-9 74 6-9 84-6 90-1 3 5 8 404-5 8 10-2 6-7 24 7 31 3-4 8 40-1 4",
    ": 6-8 50-3 6 8 62 4-7 9-70 2 6-7 9-81 5 7-9 96 502-3 9 12-3 7 9 21 4-5 9 32 5-6",
    ": 8 45-6 8 50 5-6 60 2 8 73 5 7-9 81-2 4-7 90-1 3-4 6 600-1 4 6 16 20 2 4 6 9",
    ": 32-3 6 9-40 2-3 5 7-8 51 3-4 60-1 3 6-8 70-1 3-4 6-7 81-3 5-6 8 90-1 3 7-8",
    ": 704-5 7-8 11-3 8-20 2-4 30 2 5 8 45 7-8 51-2 4 7-60 2-4 6-7 70-1 6 8 80-3 5-6",
    ": 8 90 2-3 5-8 801-3 5 7-8 10-1 5-6 8-9 22 6 8 31-3 5-7 40-2 5 7 9-50 2-4 6 8-9",
    ": 61 7 9 71-2 5 7-9 81 5 90-1 3-4 6 8 900-1 3-4 7 9 13 7 9-20 4 6 9-30 2 4-5 7",
    ": 40 2 5 9-50 3 5-6 8-60 2 6 9 73 5 7 9 83-4 6-7 9-91 5",
    ": 200005 10 2 5-6 9 21-2 4-5 30 2 9-41 3 5 52 4 60-1 5-6 72-3 5 8 81-3 6 8 90-4",
    ": 7 100 2-3 5-6 9 11 5-9 22-3 6 8 35 7-9 43 8-9 51 4-5 7 60 4 8-70 8 83 8 92-3",
    ": 6 200-1 4 6-8 11 4-5 8 21-3 6 9-31 4 40 2 4-6 51-2 4 6 60-1 4 6 70 2 4 6-7",
    ": 80-1 4 7 93 5-6 300-4 6 11-2 4 7 21 4 7 30 2-3 7-8 41 3 6 8-50 2 5 7 60-2 4-5",
    ": 7 9 72 5-7 9 82 8-90 2-5 7 9-401 5 10-4 6 8 22-3 5-8 30-2 4-5 43-4 7-9 52-3",
    ": 7-8 62 4 6 9-70 2-3 7-8 81 3-4 7-90 2-4 7-8 501-3 5-7 10 2 4 6-7 20-1 4 6 8-9",
    ": 32 4 6 9 41-7 9 51 6-7 9-60 4-5 7 9-70 2 5-6 8 83-7 9 91-6 8 601 4-8 11-3 7 9",
    ": 21-2 4-6 8-9 32 5-6 8-9 41 5-6 9 51 3 6-8 60-1 3-5 7-8 70-1 7-80 2 4-6 94 6-7",
    ": 702 4-7 10-2 7 9 21 3-6 8-31 3 7-9 41-2 6 53 5 60-1 4-5 8 75-7 9 81 3-4 7",
    ": 94-9 802 4 8 10-5 9-24 6 9-30 44 6-7 9-51 4-5 7 9-60 4-5 8 74-6 8-9 81-4 8",
    ": 90-2 6-7 901 4 6 8 10 3 5 7-8 20 2 5-7 9-30 8-40 2 4 7-8 50 3 6 8 61-6 9 71-4",
    ": 6-7 9-80 2-3 6 91 4-5",
    ": 7-1000 3 6 9 11 3 5-6 8-9 22-3 6-7 9 31 4-6 40-1 3-5 8-51 3 5 8 60-1 3-5 7 71",
    ": 3 6 8-80 3-4 7-8 92 4-5 7 9 101-2 4 6 8-9 14 6-8 20 4-6 9 31 4-7 9 41 3 6 8",
    ": 51-2 4-5 9 62 5 7-8 72 8-9 82 4-5 7-8 90 3 5-6 8 201 4 7 9 11-2 6 23 5-7 31-2",
    ": 4-5 7-8 40 2 5-6 8 50 2 4-5 7 9 63 5-6 8 70 3 5 7-8 80 5-7 90-1 3-7 300-2 9",
    ": 11-3 7 9 21 3-4 7 31-2 7 41 4 52 4 7 9 61-2 8 70 2 5 82-3 5-7 90 6 8 400 3 5",
    ": 23 5-6 8-9 32-4 6 40 2 5-6 8-51 3 5 8 61 3-4 7 9-70 2-3 5 7 9 81-4 6 8-90 9",
    ": 502-4 6 9-10 2 4 6 9-21 3-4 6 8-9 32 5-7 9 41-3 9 52 4-5 7 63-5 7 70 4-6 81 5",
    ": 8-9 93 602-3 5 7 10 3-4 6-8 20 2-3 5 8-9 31-3 5-6 8-40 2-4 7-8 51-6 8-60 3 7",
    ": 9 75 8 80-2 4 6 8 91 4 7 703-5 9 11 3 5 7 9-20 2 4 35-6 8 40 2 4 6 8-9 55",
    ": 63-4 7-8 71-2 6 82 5 9 95 7 9 801 3 7 9-10 2-4 8 21 3 5 8-30 3-4 6 8-9 41-3 5",
    ": 8 51 6 8 60 2-3 5 7-8 77 9 81 3 8 91 7 9-900 2 6-7 9-10 2-4 6-7 9-20 2-4 6-7",
    ": 9 31 3 6-7 9 41 3-5 8 50-2 4-5 7 9-60 3 6 70-1 3 5-6 9-80 2 4-5 8 91 3-5",
    ": 9-2001 5 8-9 13 5-6 22 31-3 5 8 41 3 5 7 9 51 3 5 7-8 60 2 6 8 70 2-4 7-8 80",
    ": 2-4 6-7 91 3 5 7 100 2 7-8 11 5 7 24-6 32-3 5 7-9 41 4-6 8 50-1 3 5-8 60 2-3",
    ": 6-7 70-1 3-4 7 81-4 6-9 91 4-6 8 200-1 3 5 7-8 10-2 6-7 20 5 8 30-1 3 8 41 5",
    ": 9 52 6-7 9-60 6 8-9 71 4 6 84 9 91 4 9-300 2 7 14 7 23-4 6-8 37 9 47-8 51-3",
    ": 63 7 9 73-4 7 80 3-4 6 9-90 4 6 8 402 5 8 11 22 4-5 7 30-1 4 8-9 41 4 8 51-2",
    ": 4-5 7-8 61-2 4-6 8 70 3-4 6 9 81 3-4 6 8 90 6-9 501 3-4 9 12 5 8-9 22 4 8 31",
    ": 4-5 40 2 4 6-7 51 5-7 9-60 5 71 4 6 9 85-6 8-90 2-4 8 600 2-3 5-6 8 10 3 6 9",
    ": 22 4 30-1 3-7 41 3-5 7-51 7-8 61 3 6-9 71 3 6 8 80-2 4-7 91 3 700 3-5 7-9",
    ": 11-2 4-5 8-21 3-5 8 31 6-7 9-40 2-3 5-6 9-51 5 7-8 61-2 4 7-8 71-3 6-7 80 4-6",
    ": 8 90-2 4-6 800 2 5-6 8-9 12 5-6 21 3 6 30 5 8 48-9 55 9 64-5 8-9 71-3 7-80 6",
    ": 92 4 6 9-901 5 10 2 4-5 7 26 9-30 2 5 9-42 4-50 3 6-9 62 5-6 71-2 8 80-1 3 7",
    ": 91 4-5 7 9",
    ": 3001 5-6 8-9 11 4 7-9 22 5-6 8-30 2-3 5 9-40 3-4 6 9 51 6 9-62 4 7 73 80-2 4",
    ": 6 8 90-1 5 100 3 7 11 3 5 9-20 6 32 5-6 8 41-3 5 8-51 3 5-6 9 61-2 4 7 9-70 3",
    ": 5-7 80 2 6 9 91-2 4-5 8-201 4 6-7 10 3 5-6 8-9 24 6 9-30 3 5 8-9 42 4-5 50",
    ": 2-4 6 8-60 5-6 8-72 5-6 8 80 4-5 7 91 6 302-3 5 7 10 2-3 5 7 21-6 9-30 2-3 5",
    ": 8-9 42-4 7 9-50 3 5 7 9-64 6 9-70 2-4 7-8 80-1 3 5 8 92-3 6 401 5 8-9 15-6",
    ": 9-20 3-4 7 34 7 40 2 5 8 51 4-5 7 9-60 2 4 9 72 4 8 80 2 4-5 7 9 91 3 5 500-2",
    ": 5 9 12 4 7 21-2 4 6-8 30-1 3-4 6 8 42-3 5-7 9 51 6-8 60-1 3 5 9 77 82 7-8 96",
    ": 8-9 604 8 10-1 3 5-7 9 21-3 5 8-31 4 7 9 43 5 7 9-50 2 5 8 60 2 6 9-71 3 6 8",
    ": 81 5 7 90 3 6-8 700 4 6-7 9 11 4-5 8-9 23-4 9 33 6 9 45-6 52-3 8-9 61-3 6 8-9",
    ": 71 3-4 6 8 80-1 3-4 7-8 92-3 6-7 803 11 4-6 8 21 3 6 8 32 4-5 7 9 44 6 8 52 6",
    ": 9 62-3 5 7 9 72-3 7 9 85 7 90-1 5 901 3 6 9 13 5 7-25 8 30 2 4 6 8-9 41 6 8",
    ": 51 4 6 9 61-2 5-7 70-2 4-5 7 9-80 2-4 6-91 6 8-9",
    ": 4001 4-5 7 9 12 4-5 8 21 3 5-6 8 30 2 4-5 9 44 6 51-3 9-61 5-8 70 3 5 8 80",
    ": 5-6 9-90 2 4-5 8 100-1 3 7-8 10 2 4 6-8 20 3 9-30 5 7 9 42-3 5 7-8 50 2-3 5",
    ": 61 5 8 70-1 3 6-7 82-3 5-6 9 93 5 7-8 200-1 7 10 4 7 20-2 30 2-4 7 41-2 4-5",
    ": 7-8 50-1 5-6 9-60 8-71 3 5 7 9-81 91 3 5-6 8 300 2 5 10-2 4-5 7 21 3 6 8 30-1",
    ": 43 5-50 2 5 9 61-2 4-7 9-71 3 5-8 80 4 92 4 6 9 403 5 7-8 10-1 4-6 8-20 2 5-7",
    ": 30 4 45 50 3-5 9 62-3 5 7-8 72 7 9 81 3-5 8 90 3 5 7 500 2-3 5-6 8 13-4 9-20",
    ": 3-4 8-9 33-4 8 47 52-3 5-6 60-1 7 9-70 5-6 9 81 4 7 9 93-4 600-1 3 5-6 8-9 11",
    ": 6 26-7 9 35 7-8 40 2 4-6 8-9 51 7 60 6 8 70 2 9 81 4-5 9 94 7-9 701 5 11-2",
    ": 4-5 9 28 30-1 4 6 42 4 6 8-9 52 4 7 60-3 6 8-9 71-2 6 82 4 6 90-1 6-7 800 3 5",
    ": 7 12-3 5-6 23-5 9-30 2-3 8-9 41 3-5 7 9-50 2-3 6 8 60-1 5 74 9 81 4 7 9 91 5",
    ": 7 901 3 5 9-10 2 5 9-20 3 5-6 8-9 31-2 4 7 9-40 2 4 6 8-9 51 3 68 70 2 7-8 92",
    ": 5 7 9",
    ": 5003 5 9 13 22 7 36 8 40 2 7-8 50 2 4 6-7 9 63 8-9 71 7 81-2 7-8 91-2 6-7 9",
    ": 101-4 6 9-11 3-4 7 9 21-2 7-9 31 3-4 8-9 41 3 6 9 53-4 7 63 6 70 2-3 6 8 84-5",
    ": 7 9 91 3-4 6 8-9 207 9 12 4 7 9 22 4 8 31 4 6-7 9-40 2-3 5 9 51 5 7-8 63 7 9",
    ": 71-3 5 7 9-80 3-4 6-7 9 93 6 301 4 7-8 10-2 6-7 9-20 3-4 8 31 4 6 40-1 6-7 9",
    ": 51-2 4 6 8 62 6-7 70 2 9 82-6 9 98-401 3-4 6-7 9-12 4-5 7-9 21 5 32 4 6-7 9",
    ": 41 5 7 9 55-63 5 71 3 5-6 80 3-4 9 91 5 8 502-3 5 7 10-1 4-5 7-8 21-2 4 6-7",
    ": 9-30 3-5 7 41-3 5-8 50-2 4 6-7 9 61-2 4-8 71-3 5 7 81 3 5 8-9 92-3 5-6 8-602",
    ": 7-8 18 26 9-31 4 6-9 41 3-7 9 51 6 60 4 6 8 72 4-6 9 81-2 4-7 90-2 7-8 700",
    ": 2-5 7-8 10 2-3 8-9 21 4 9-30 3-4 6-8 41-3 5 7-51 4 7-8 61 3 6-8 70-1 4-6 9",
    ": 82-5 9 91 3-5 7 800-1 4 7 10 4 8 21 3 6 32 6-8 43-4 7-8 50-1 3-4 60-3 7-8 73",
    ": 5 7-8 83-4 6-8 91 5-7 900 5 7-8 10 4-5 7-22 6-8 31-3 7 9-40 2-3 5 7 9-50 2",
    ": 4-5 61-2 4-5 70 2 4-7 9 85 7 94 6 9",
    ": 6002 8 11 3 5 8-9 21-3 5-8 31 8 40 6 50 3-4 8 60 3-6 8-9 71-2 4 9-81 4-6 8 90",
    ": 2 5 7 102-3 6-7 9 11-2 4 8-20 3-4 6 8-31 4-6 40-2 4-7 51-3 5-6 62-3 6-8 70-1",
    ": 5-6 82-4 7 9 91 3-6 9 203 5-7 12-5 8 20 6 8-9 32 4 7 42 6 9-50 3 7 60 2-4 6-8",
    ": 72 5-9 81-2 5 9 92-5 9 303 5 7-8 10 2 6 8-9 21-2 4 6 8 30 3 6-9 41 4 7 50 6",
    ": 60 2-3 5-6 8 73 5 7 81 5 8 91 5-7 402 4 7-9 11 6 9-20 2-3 5-7 32 6 8 42-4 50",
    ": 2 5 60 2 6 9 72-3 6 9-80 2 4-5 7 91 3 500-1 5-7 9 11 4-8 22-3 5 31-3 5 8-9 41",
    ": 4 6-7 9 51 4-6 8-9 61 4-5 9 71 3-5 7 81-4 6-8 90-3 7-8 600-1 3-4 6-7 9-10 2-7",
    ": 20 5 7 9-30 4 7-9 42 4 6-8 50-1 3-6 9 63 5-6 73 5-8 80 2 4-6 8-91 5 701-3",
    ": 9-12 6-7 20-1 3-8 31-2 6 9-41 4 9-52 4 9-60 4-5 7 70-2 4 7-81 5-6 91-2 5 8-9",
    ": 801 3-4 6 8-9 11 3-4 6-9 21 3 5-8 30 4-5 7 9-41 4 6-7 9-51 3-4 62-3 5-6 8",
    ": 70-1 3 5 9-80 2 4-5 7-8 92 4 7 9 901 10 2 4-5 9-21 4 6-8 30-1 4 6 9 42-3 5-8",
    ": 50 2-4 6 9 61-3 5 7-8 70-2 6 80-3 6-7 9-93 5",
    ": 8-7000 2-3 5-7 11-3 6 8 21-3 8 33 6-43 6-8 50 2-3 5-6 8 60 2-4 6-7 9-71 3 5",
    ": 84 6-8 90 4 6-8 100 5 12-4 7 25-7 30 4 6 8-40 3-5 8 50 3-4 7 9-60 2-3 5 73 7",
    ": 9 82 4-5 8 94 6 9 201 4-6 8-10 2-3 5-7 20-1 3-4 6 9-30 2 4-5 7 9 42 4-5 8-50",
    ": 2 4 60 2-4 6-7 9-71 3-5 9-81 4-5 7 90 2 5-6 301 3-4 7-10 2 5-6 8 20 2-3 5-7 9",
    ": 31 3 5-8 42 5-6 8-51 4 6-7 60 3-8 71-3 5 7-9 81 3 5-6 8-90 2-3 5 7 400-1 4 6",
    ": 8-9 15 7-8 20-1 3-4 6 31 3 5 8-40 3-6 8-9 53 8 63 8 72-4 6 80 2 4 6-7 90-2 5",
    ": 9-501 5-6 10-1 3 5-7 21 3 5-6 33-4 41 3-6 8 51-4 9 62 4 8-9 72 4-5 7 9 81-3 5",
    ": 7-8 90-1 3 6 601-3 5-8 12-3 5 9 25-6 33 7 40 4 9-50 2-3 7 60 2-4 6-7 9-72 4-6",
    ": 84-5 7-92 4 8 700 8-10 2 4 6 8-9 22 4-5 7 31 3 6-7 40 6 9-50 3 5-6 8 61-4 6-7",
    ": 9-70 2-3 5-6 8-80 2-3 5 90-2 5-6 8-9 802-3 7 9 11 6 9-20 3 5 7 35-6 40 4-5 9",
    ": 52 4-7 9 61-3 5-9 71 3 5-6 8-9 81-3 8-90 2-5 9 902 4 7 11 3 5-7 23 6 8-30 2-3",
    ": 6-7 9 41 3-4 6-7 9-51 3-4 9 62 70-1 3 5-7 9 81-2 4 7-8 90-1 3 5 8",
    ": 8001 3-4 8-9 14-5 7 9 23-4 8-31 4-5 43-4 7 51 3-4 8-9 62 4-5 7 71-2 7 9 85-6",
    ": 90 2 6 8 105 7 14 7 9-22 5 7 30-1 5 40 4 6 50-1 3 5 60 2 4 7 74 6 8-80 4 6",
    ": 8-9 92-4 7 201 6 9 11 3 22 4 6 8 30 3 7 47 9 51 60-2 4 6 9-70 80-2 4 6 8-9 93",
    ": 5-6 302 4 6 9-10 3 6-7 20-1 4-5 7 30-1 6 8-9 43 6 8-52 4 6-7 9 61-3 5-6 9",
    ": 71-2 7 80 93-4 6 8-9 401 4-6 8-11 3-6 8-9 21 3-4 6-8 31-2 4 7-8 41 4-6 8 50 2",
    ": 5-7 9 61-2 6-8 70 5-9 81 4-6 9 91-2 4-5 7 9 501-4 6 8 11 3 6 8-9 22 4 6-8 30",
    ": 3-4 7 9-41 4 6 9-50 2-4 62 5 7 9 72 4-5 7-8 84-6 8 90 4-5 8 602 6 8-9 11-2 6",
    ": 8-9 22 4-5 8 30 2 4-7 9-41 3-5 7-9 51-2 4 6 8-9 62 4-7 70-1 4-6 9-80 4 6-7",
    ": 90-1 4 8 700 2-3 7-9 11-2 6 20-1 4 6-9 32-3 5 40 4-5 51 3-4 6-7 9 61-3 6 8",
    ": 70-2 4 7 9 81 3 5 7-8 91-2 5 7 9 801 4 6-8 16-7 9-20 2-31 3 8 40-1 5 7-8 50-1",
    ": 3-4 6 61 70 2-3 5-8 83 6-9 92 4 6 8 906-7 10-1 4 6-8 20 5-6 31-2 6 8-40 2 9",
    ": 51 3-5 64 71-2 4 8-9 81-2 4-5 9-90 4 7-8",
    ": 9000-5 7 10 2 4 20-1 3 5-6 31-2 8 41 5-6 9 52-4 7 60-1 3-4 6-7 71 3 6-9 85",
    ": 7-8 90 2-3 7-8 100 2 5-8 11 8-9 21-4 7-8 31 42-3 5-6 52-3 6 9-60 2-3 6-7 9 71",
    ": 4 9 81 5 9-90 2 4-6 8 204 7 11 3 5 9 21-2 5 9 31 4-5 7-8 40 5 7-9 51 3 7-8 60",
    ": 5 7 9 72-7 9 82 4 6 90 4 7 300-1 3 6 8 12-5 7 9 24 6-7 9 31 3-4 6 8 42-3 5",
    ": 7-8 50-1 4 60 3 6-7 70 2-4 6-8 80 3-6 91 3 6 400 2-3 5 10 2 4-7 22 6 31 5-40",
    ": 3 8 50 2 5-6 8 60 3-5 8-9 75 7-8 80-1 6-7 93 5-6 501 3 5-7 9-10 2-3 7 9-21",
    ": 3-5 8-30 2 5 7-9 41 3 6-8 50 2-3 6-7 60-2 5-6 70-1 3 6-9 84-5 7-9 91 3 7 9",
    ": 602 5-7 9 14 7 9 22-3 5 9 36 40 4 7 50 2-3 65-6 9-70 9-80 2 6-7 90 2-3 7-9",
    ": 703-4 10 2-4 7-9 22 5 8 30 3 5 40 2-4 6 8-9 51 4-5 8-9 61 3-4 7 73 7-80 2-4 8",
    ": 90 3-5 7 802-3 5-7 10 3-4 6-8 21 5 35-7 9-40 7-8 50 4-5 60-3 5-6 8 70 3-4 6",
    ": 9-80 3 6-7 9-90 2-3 7-8 901 4 12 5-6 9-21 3-4 7 9 31-2 4 6 8-9 41-2 4-6 8-9",
    ": 51-2 4 6 9 62 5 8 72-3 5-6 9 82 5-8 90-2 4 6 8-9",
    ": 10002-4 9 12 5 20-1 4-5 9 31 3-4 6 8 40 2-3 9-50 2 8 63 70-1 3-4 7 9 81-2 6",
    ": 90 3 6-7 100 2 4-6 8-10 3-6 8-9 21-5 7 9-30 2-3 6 9-40 2 5-6 52 6-9 61-2 5",
    ": 7-8 70-3 6 9 82-3 5 9-90 2 7-8 201 7 13-4 21-2 4-5 7 31-2 6-7 41 3-4 6 8 50-1",
    ": 4 6 9-60 3-6 8 75-6 8 82 4-5 7-8 91 4 9-300 5-6 10 2-4 6-7 9 21 5 32 4 6 8",
    ": 42-3 5-8 52 4 6 8-60 2-3 70 2 4-6 80-1 3-4 8 90 2-3 5 7-9 401 3-4 6 12-4 6",
    ": 8-9 22-4 6 8-9 31 6 9-40 7 9 51 3-4 6 60 4 6-7 9-70 4-6 82 4 6 8 90-2 6-8",
    ": 500-1 4 6 8-9 11 6 9 21-3 6-7 9-30 9 42-4 6 9 51 4 6 8-9 62-3 7 9-70 4 6 8 80",
    ": 2 5 8-9 91 5 600 3 5 8-9 11-2 5-9 21-2 4-6 9 32 5 40 3 5-50 2 5-7 9-61 3-5 71",
    ": 3 5-7 80-1 3 5-90 2 5 7-700 2 4-6 8-9 11-2 6 9 21 3 5-8 33 7 9 41-2 4-5 7-8",
    ": 50 2 4-5 7 9 63 5 7-8 70 2-3 5-8 81 5 8-9 91-3 800 2 4 6-9 12-3 5-6 8-9 21-2",
    ": 4-5 7 9 32-4 6-9 41-2 4-6 9 52 4-5 9 62 5-7 70-1 3 5 7-9 81-3 5-6 90-1 5-6",
    ": 8-900 2 5-8 10-2 4 7 20 3-5 7 30-1 3 6 8 40 2 4 7-51 4-5 9 62-3 5 7-9 75 7",
    ": 80-1 4 91 4 8",
    ": 1001 3 5-6 9 12 4 6 21 4-6 8 31 3 5-6 40 8-9 51 6-7 9 61-3 5 9 77 9 82-3 5-7",
    ": 9 95 7 100 7 9-14 6 8 20-1 6-7 30 3 5-6 9 41-2 7 9 51-3 8-9 61 3-4 6 9 71-3 7",
    ": 9-80 3 6-7 9 94-5 9 202-3 5 8 12 4 7-21 6-7 9 34 6 8-9 41 4 6 8-51 3-5 9 61",
    ": 3-4 6 8-9 74 8-9 83 6 90-1 5 9 301-2 4-6 9 13 5-6 8 22 6 8 37 9 42 9 51-4 7-9",
    ": 61-2 4-5 70-1 4-5 9-80 2-3 5-6 95 8 402-4 6-7 9 11-2 4 8 21 4-5 8 30-2 5 8-40",
    ": 2-4 6-50 2-3 6 8-9 61 3-4 6-8 70-3 6-7 9-81 3 5 92-4 7 500-2 4-7 11 6-7 9 21",
    ": 4-5 30-1 3 5 8 40 2 5 7-9 52-3 5 7-8 61-4 6-8 70-1 3 5 8-9 82-3 8 95 7 9-601",
    ": 4-5 7 9 12 5 7-8 20-1 3 5 8-9 31 5 8 40 7 51 3 5 7 9 64-5 7 70 2-3 5 8-9 84 6",
    ": 90 3 5 7-8 700 6-7 9-10 4-5 21-3 5 8 30 8-9 43-5 9-50 2 7-8 63 5-6 8 70 2-3",
    ": 5-6 8-9 81 3-4 6-7 9-90 3 7 9-800 3 5-6 8 11-2 8 21 3 8 30 4-5 8-9 42 4 7",
    ": 9-50 3 5-7 9-60 2-3 5 71 6 8 83 5 7-8 90-1 3 5-8 900 2 5 7-8 10-2 6-7 9 22 8",
    ": 30 5-7 41-3 5 8-9 51-2 4 6 9 61-3 5 7 9-70 2 7-8 82-3 6 9 93 5 7 9",
    ": 2003-4 6 9 12-4 6 20 2 4 6-7 31 3 5-6 8-40 2-4 6 8 50-2 60-1 3 6-7 9 71-2 6",
    ": 80-2 90 2-4 8 101 4 7-8 10-1 6-7 9-21 31 3-4 7 40 3 7-8 51-2 5 8 60 3-4 9",
    ": 71-3 5-80 3 5 7-8 90-3 7-8 200 4-6 8-10 2 8 21-2 4-6 9 31-4 6-7 9 41 3-6 8-51",
    ": 3 6-7 9-61 3 5-8 71-2 4 7 9-81 4-5 7 90-2 6 9 301-4 6-7 10 2-4 6 8-9 22 8",
    ": 30-2 4 6 8 42-4 6 8 50 2 4 7 9-60 2 4-5 8-9 71-2 7-8 80-1 5 7 90 3 5-6 401",
    ": 3-4 7 9 14 6-7 9 21 3 5-6 8 31 5 7-8 40 2 4-5 7-8 51 3 63-5 7-9 71 5 88-91",
    ": 3-4 6 500 2 5 7-8 11 3 5 7-8 24 6 8 30-1 3 6-7 9 43 5 8-50 3-4 7 9 61-2 4 6 9",
    ": 72-3 6 8 81-2 4 7-90 600-1 4-5 7-9 11-2 5 20 2 5 7 31 4 8 42 4 6-7 9 52 4-5 7",
    ": 60 3-4 6 8-9 71-2 4 7-9 84-5 8 90 6 9 701-2 6 9 11 3-4 6 9 22 4 7 30 5 7 9 41",
    ": 3 5-6 8 51 5 7-8 66-7 71-3 5-6 8 81 3 9 91-2 4 7-8 803 9 15 7-20 3-4 9 33-4",
    ": 6-7 41-3 7 50 2 60 2-4 6-71 4-5 7 9 82 4 9 91-2 4-7 9 904 6-7 9 12-3 6-8 24-7",
    ": 9 31-5 7-40 5-6 8-50 2 4-5 7-8 64 7 9-70 4-5 7-8 80 3 6-7 90-5 7-8",
    ": 3000 5-6 8-12 6 9-20 3-4 7-9 33 7 9 41 3-5 7-50 2-3 60-1 3 5-6 70-1 3 6-8 83",
    ": 6 8-9 93-6 8 102 4-6 9-10 2 4 7-8 20 2 5 7 9-30 4-5 7 9 42-3 6-7 9 51-3 6-7",
    ": 9-61 3 6 8-72 4-6 81 3 6 8-91 3-4 6 201 3 6 9-11 6 8-20 2-4 32-4 42 5 8 50-1",
    ": 3-4 8-60 2 7 70 3 5-6 85-7 9-90 2-4 6-7 9-301 3 6 8-9 11 3 5 21 4 7 9-30 2 5",
    ": 8-9 41 3-4 9 52-4 6 8-9 61-2 4-6 70-5 7-8 83 6-7 9-90 2 4 401-4 6 11-2 6 8",
    ": 20-1 3-4 8 32 5 7 40 2-3 8-9 55-6 8 60-2 6-8 70-3 5-6 8-81 3-5 8 90 2 5 8",
    ": 500-1 4 8-9 13-5 8-20 6-7 33-5 7 41 4-8 50-2 8 60-1 3-5 7 70 3-4 6-7 80 2-3 5",
    ": 7 91-3 5-8 600-1 5 7-8 10 2-3 5-6 8 21-2 7-8 30 4-5 7-9 41 4 6 9 51 8 60 3",
    ": 8-70 3-4 6 9 82-3 5 91-2 4-7 701 3 6-7 9-11 3-7 9-21 4 7-9 31-2 4 41-2 5-6 8",
    ": 57-8 60-1 3 5-6 9 71-5 7 81-4 6-8 91 3 5 7 801 6-10 2 4-6 8-9 21 4-5 7-30 2 5",
    ": 8 40-1 3 6 8 50 2 6-7 9-60 3-4 9 72 5 8 80 2 4-5 8-9 92 5 7 901 3 6-7 9 14 9",
    ": 21-3 5 31-2 4 7-8 44-6 9 53-5 60-1 3 5-6 8-76 80 2-3 5-7",
    ": 94-4001 4 6 8-11 3-5 8-20 3-5 8 31-4 6 8-9 41 4-6 8 51 3-4 7 62-4 6 8 70 2 4",
    ": 8 81-5 7-90 4 7 9 102 4 6 12 5-6 9 21 4-6 8-30 2 4 6 8 42 6-51 3-4 7-60 2 5 7",
    ": 9-70 6-7 80-1 3 91 5 8 200-1 4-5 7 9-10 2 5 7-9 21-2 5 9 31-3 7-9 42-4 8-9 51",
    ": 3 6 9-61 5 7 9 73 8-9 82 5-7 9 91-3 9 304 6 9 11 5 7-9 22 4-6 8 31-3 6 9-41",
    ": 3-5 8-9 51 4-5 8-61 6 8 70 2 4-6 8-80 5-7 9 95-6 9-400 2-3 6 9-10 2 4 6-7",
    ": 9-21 4-7 30-2 4-5 8 40 3 8-9 58-9 61-2 7 70-2 5-6 9 81 4 7-8 90-1 4-5 7 501-3",
    ": 5-6 10-1 3-4 7-8 20 8 30 3 7 9 45 7-8 50 2-3 5-6 9 61 4 77 80 3 5-6 91 6-8",
    ": 600 2-3 6-7 9-11 3 5 8 20-1 3 6 33 5 8 40-1 3 6 50-1 4 7-8 60-2 6-8 70 2-3 5",
    ": 8 80 2-4 6 8-9 91-4 6 8-700 3 6-7 9-10 2 5-8 21-3 5-6 8-9 31 5 7 9-40 2-5 7",
    ": 9-52 5-7 60 4 7-8 70-1 3 5 8 83-6 8-9 91-3 6 8-9 802-3 5 8 11-3 5-8 20-3 5 30",
    ": 2-3 6 40-4 9-51 3-4 7 9 62-5 8 71 4 8 80-2 4-7 9-90 2 5-6 8 906 9-10 9 21 3-7",
    ": 9 32 6 8 43 5 7-9 51 8 60 5-8 70 5-6 8 80-2 6 90-1 4-5 7",
    ": 9-5000 2-3 9-10 2 4-6 9 23 5-6 8 30-1 3-4 8-9 41 5 8-50 2 4 8 61 5-7 70-1 3",
    ": 80-2 4 6 9-90 3 5-6 8 101 3-5 8-10 2-5 7-8 20 5-6 8-30 5-9 41 4 8 50 3-5 8",
    ": 62-3 6-7 70 2 4-6 9 81 5-8 90-1 3-4 8 200-2 8 13-5 8 21-3 7 9-30 3-5 7-41 4",
    ": 7-8 50-1 5 7 9 64 6 70 2-3 5-6 8-9 81 4 6 8 90 2-5 7-8 301-2 4 6 9-10 2-5 7-8",
    ": 21 4-6 30-2 9 44-5 7-8 56 8 62-7 70-1 3 6-7 9-81 3-5 7-8 93 6 9-402 4 7-9 11",
    ": 3-5 8-9 21 5 7-9 32 7 40-1 3-4 6-7 50-1 5 9-60 3-6 8-9 71 3 6 9-81 3-5 91 3",
    ": 7-8 503 5-7 9 12-4 6-9 22 7 9-30 4 9 41 3 6-8 50 2-3 5 8-9 63 7 9 72-5 7-83 5",
    ": 7 9-90 5 8 600 3 5 7 10 2-6 8-9 23-5 31-2 4 6-7 9-40 4-8 50-1 5-9 61 3 6 8",
    ": 73-7 9 81 4-5 8 90 2-3 6-7 701 3-5 8 14 6-7 20 2-3 5 7 31-2 4 40 2-5 7 9 51 3",
    ": 6 8-60 2-3 6 8 70 2 4 7 9-80 3-5 9-90 2-3 6 8 802 4 7-8 13-4 8-20 3-4 6-8",
    ": 32-3 9 42 4-8 53 6 8-9 62 4 7-8 70 2 4 8 82-5 90-2 5 9 901 3-4 6 8-10 3 5-9",
    ": 22 4 7 9-30 2 4 7 9 41-2 4-5 7 50-1 4-5 7 60-1 4 72-4 6-7 9-82 4 7-8 91 4-5",
    ": 7-9",
    ": 6002-5 9-11 3-7 9 21 4 6-7 9-30 3-5 8-40 5 7-51 3 5-6 8 65 75 80-1 3-4 6 91 3",
    ": 7 100 3-4 6 8 10-2 5-6 9 28 30 2-5 8-40 4 6-7 51-2 4 9 61 9-71 5-7 9-80 4 6",
    ": 8-90 2 5 7 9-203 8-9 13 6 20-1 3-4 8 31 4 6-8 41 4 7 52 6 9-60 4-5 9 71-3 5-6",
    ": 80-1 6 8-9 92-5 8-301 3-7 9-11 3 5-6 22-3 5 7-8 30 3 7 9-41 3-5 7-8 54-5 7",
    ": 9-63 5 9-70 3 5-6 8 80-1 3-4 6 8-9 91-2 6-8 401 3-5 8 10 2 4 7 20-1 5 8-9",
    ": 33-4 6-7 40-1 4 9 52-3 6-7 9-60 2-3 70 3 5 7-8 83 5 9 93 5-9 502 4 7 10-1 3-4",
    ": 6 20 2 6 8-9 32-3 5 7-8 42 5-9 52-4 6-7 61-6 8-71 4 7 9 81 3-6 8 90-1 3 5-7 9",
    ": 603 6-7 9 12-5 9-20 3-5 7 9 31-3 6 9 42-5 8-9 52-6 8 60-1 6-8 70-1 3-4 8 81-5",
    ": 7-8 91-4 7-8 700 3-4 6 8 10-4 20-3 6 8-9 31-4 6 8 41 3-4 6 8-51 3 6-7 60-4",
    ": 6-7 9-70 5-8 85 9 92-6 8 800-3 5 7-8 10 2-4 6-9 22-3 6 9 31-2 4-6 9 42 4-7",
    ": 50-1 4-5 7-8 60 2-4 6 71 3-4 8 82 5-6 9-91 3-4 6-9 903 9-10 2-4 6-9 21-2 7 30",
    ": 2 5 7-8 40-1 3 6 8 53 6-7 9-61 4 7-8 72 5-7 80-1 6-7 9-90 3 6 8",
    ": 7000-3 7-8 10 2 4-8 20-1 6-7 30 4 7 9-40 8 50-1 5-6 8 60-2 70 4 8-9 82 5 8",
    ": 90-1 5-6 8 100-1 4-7 9 11 3 6 9 21 3-4 6 9 35 40-2 4-5 8-9 52-4 6-8 61 5 8",
    ": 71-2 4 7 9 85 8-9 91-3 201 7 12 5 20 4 30 3-4 7 9 41-2 4-5 7-51 4 8 60-1 3 5",
    ": 8 70 2-3 5 7-8 80 2 4 6 8 94 6 8-9 301 3-6 8-9 12-4 8 20-4 7-8 30-1 3-6 8 40",
    ": 5-6 9 53-4 9-60 2-3 6 72 7 9-80 2-3 5 7 9 91-2 4 7 404-5 8 10-1 4-5 21 8-9 34",
    ": 7-9 41 4-5 7-9 52 5-6 8-9 61-3 5 9 71 5 8-81 3 5 8-90 2-3 5 7-8 500-1 8-10 3",
    ": 8 23 6 36 8-40 2 4-5 8 51-3 5 9 62-3 6 9-70 3 5-8 80-3 7-9 91-2 4 7-8 600-1 3",
    ": 5-7 9 12-3 5 9-21 3 7-8 30 5-6 8 44 8-9 52 5 63 5 7-8 70 4 8-80 6-7 9 92 700",
    ": 4 9 11 5 8 20 2 4 6 31 4 7 9-40 2 4-5 8 51 3 6 9 61 6 9-71 3 5-6 83 5 7 90-1",
    ": 4 806 8-9 11-2 5 8 20-2 4-5 7-8 30 2 5-7 40-2 5 8 55 9-60 3-4 8 71 3-4 80 3 7",
    ": 9 92 5 7 900 7-9 12-3 7 9-22 4 8 31-2 4 6 9-41 3-4 6-7 51 4-5 8 60-2 6 70 2 4",
    ": 7 80 2-3 7 91 4 8",
    ": 8000 3-4 6 9-10 3 7 20 5 30 3 9 43 6 8-9 52 6 61-2 6 9 71 6 8 86-9 91-2 6-9",
    ": 101 7 10 2-3 8-9 24-5 8-9 31-4 41 3-4 6-8 51-4 8-9 61 3-6 8-9 75 8-9 82-3 8",
    ": 93 6-9 201 6 11 3 5 7 9-20 2 5 8 35-6 8 40 8 50-1 4-6 9-60 4 8-9 71 3 6-7 80",
    ": 3 5-6 8 92 5 7 302 4 6 9 11-2 4-5 7 9 24-5 8 30 5-6 41 3 5-6 8 54-5 7 9 62",
    ": 4-5 7 9-70 3 8 82 4 8 92 4 6-7 413-4 20-1 3 5-6 8-9 33-6 8 40 2 6 50 2 4 6-8",
    ": 60-2 4 7 73 5-7 9-80 3 5 7 9 91 3 7 501 3-4 6 8 14 8 21-2 4 8-9 33 7 42-3 7",
    ": 57 9 61 3-5 70 3 6 82-3 5 9-91 3 9 601 3-4 8-11 5-6 21-2 4 31-2 5 7-8 42-3",
    ": 5-7 9-50 2-3 7-8 60 2-6 70-2 5 7-8 80-1 3 5-6 8 90 3 6-7 9-700 6 9 11 3 6 9",
    ": 21 3 5 7-9 31 3 5 7-8 41 3 6 50 2-6 8 60 7 70-1 3-4 6-7 81-2 4 6 8-90 2 5 7-9",
    ": 802-3 5 7 10-1 3 6 8 21 6 8-9 31 4 8 41 3-4 9-50 2-3 5 7-8 60-1 5 8-9 71 4 7",
    ": 9 81 3 5-6 90 8 900-1 3-4 6-7 9-10 3-4 7-8 21 3-5 7 9 32-3 7 42 8 51-2 5-6",
    ": 9-62 4-5 7-9 71-2 4-6 8 80-1 6 9-90 2 5 7 9",
    ": 9001 3-7 11 3-5 7 20-1 3-4 31 3 7-8 41-2 5-6 8-9 51 3 5 7-60 2 4-5 7 70-2 4-6",
    ": 8-80 2-3 5-7 9 92 4-5 7-8 100 2 8-9 11 3 5-6 9 22 5 7 31 3 5-6 8 42-3 6-9 51",
    ": 4 8 60 4-5 8 71 6 9 82-3 5-8 90 2-3 7-8 202-3 5 9 13 5-7 9 22 4 9 31 3 6-9",
    ": 41-3 9 51 5 7 61 4 71 3 8 85 9 92 4-6 8-301 3-4 6 8-10 5 8-20 2-4 7 9-32 4 40",
    ": 7-8 50-2 5 7 9-61 3 6-7 70 3-4 8-9 85 95-6 402-3 6 9-10 5 7-8 20 5 9 31-2 5-6",
    ": 41-2 4 7 9 52-3 5 7-8 61 3 8-9 71 4 6-9 82 4 6 8 90 5-8 500 2 4-7 9-10 2-4",
    ": 6-22 7 32 6-7 9 41-3 5-7 9-50 4 6 9-61 3 5-7 70-1 3 6 8 80 3 5-6 8 91 6 9-600",
    ": 10-1 5 8 22-3 7 9 31-2 5 8 44 7 9 51 8 62 4-5 7 70-1 4 8 80-1 3 5 8 90 2 4 6",
    ": 9 701-3 5 7-8 14 6-7 9 21 7 9-37 42 8 52-4 60-1 5 8 73 7 9 83 5 8-90 2-3 8-9",
    ": 802 9 11-2 6-7 9 22 5-6 30 2 7-8 42 5-6 8-9 51 3 7-8 60-2 5-6 70 2 4 6 9 81-3",
    ": 6-7 9-90 2 5-6 900-4 9-10 3-4 6-7 9-20 2 4-8 30 2-3 5 8 40 2-3 6-7 50 2-3 5-9",
    ": 61 5 7-71 3 6 85 8 91-2 5 7",
    ": 9-20001 5-6 9-10 3-5 8 20-2 5-6 34 7-8 40 3 5 8 52-5 7-9 61 4-7 9-70 2 7-9 81",
    ": 3-5 9-90 2-3 5-6 102-3 5 9 12 4 20 4-5 7-8 30 2 6 8 41 3-5 7-8 50 3-4 7-8 61",
    ": 3-4 6-8 70-2 4 7 9-80 3 5-6 9 92 5 203-4 7 11 4-5 20 2-3 7-9 31-2 7 41 4 6-9",
    ": 52 6 9-60 3-4 6 8-9 71 5 7-9 81-4 6-9 91-4 8-300 2-3 5-6 8-9 11-2 6-8 23-5",
    ": 7-8 30 5 8 40-1 4 7 9 52 4-5 60-1 4 73 5 7-8 80-1 9 92 4 6-8 401 4 7 12 8 22",
    ": 4 9-30 2-3 5-8 43-4 6 53 5 7 9 61 4 7 70-1 3-5 8-80 4-6 8 92 4-6 8 500-3 9-13",
    ": 5 21 4-5 7 9 32 5 9 41 3-4 6-7 9 61-2 4-5 70-1 80 2 6 8 90 2-6 8 600-1 3-4",
    ": 6-7 11 4-5 7 9 21 4-5 7-8 30 2 4-5 8-9 43 7 50 2-3 9-60 2-3 5-7 9 71-2 4-5 7",
    ": 80 4-5 8-9 91 7 700 2 5 7-8 11-2 4 8 23 6 9 31-2 4 6 42-3 5-7 51 4 7-8 61 5 7",
    ": 9 71-2 4 6 80 3-5 8 90 2 5-6 8 800-1 3-7 13 5 8 21 4-6 8 34 6 8 41-3 5-6 9-50",
    ": 3 5-7 9 61-3 5 7 9-70 5-6 9-80 2-4 90 3 8 900-3 5 11 3-4 6-7 24-5 7-8 31 6-40",
    ": 2-3 6-7 9 51 4 9-61 4 70 6-7 9 82 4-5 9 91",
    ": 5-1000 2 5 7 11-2 4 6 8 20-2 5-6 9 31-2 4-5 8-9 41-3 5-7 50 3 5 9 61 3-4 6 70",
    ": 4 9-80 2-3 6 8-9 96 100-1 4 9-10 2 5-6 9 22 5 8 30 4 6 41 3 5 50-1 3-5 9 61-3",
    ": 5 8-70 2-3 7-8 81 3-4 6-8 94-5 7-9 203 6-7 9-11 3-5 8 20 5 7 34 6 9-41 4-5",
    ": 8-50 4-5 9-60 3 7 9 71 5-8 85 9-90 2 4-5 8 300 2 5-6 8-9 11 5 8 25-6 9-30 3-4",
    ": 7 9-44 6 8 50 3 6-7 62 4 8 70-2 5 7-8 83-4 8 91 4 6 8 400 2 6 16-7 9-21 3 6-7",
    ": 9-32 4-6 40 2 4 9 53 5 7-8 60 3 6 70 2 4 9 83-4 7 92 4 6 500 2-4 7 9 13 5 23",
    ": 9 35 7 44-5 7 9 60-1 5 9 71-2 6-8 80-2 91 5 7 601 4 6-9 11-2 4 7 24-5 33-5",
    ": 9-40 4 7 9-51 3-4 6 8 61 3 6 9-71 4 6-7 9-80 3 5-6 8 91 4 6-7 701 4 9-10 3 7",
    ": 20 4 7 31-2 5 7 41-2 8-50 2-3 7-8 60-2 4-5 8 73-4 7 9 81 3-4 7 9 91 4-6 9 801",
    ": 3-4 6-7 9 11-2 5 8 20 2-3 5 8-32 4-5 8 40-1 3 6 8 50 7-9 61-2 5 9 76 8 81 4",
    ": 7-9 92 6-7 9 901-2 5 8 11 4 6 8-21 5-7 31-2 4 8 40-1 3-5 8 50 6 8 60 2 4 6",
    ": 9-70 2-3 8 80 3-4 6 92 4-5 8-9",
    ": 2001 3-4 6 8-9 13-4 7 9-20 2 5-6 30-1 3 6 8 40-1 3-4 7-8 51 3 8-9 62 4 6 8 72",
    ": 5 81 3-4 7 9-92 5-6 8-100 2 6 12 5 7 21-2 4 6 9 32 5 41 3-4 8 51 3 5 7-9 62-3",
    ": 5-6 9 73 6 8-9 81 7 9-90 2-3 5 9 205 7 9-10 3 7 20 2 4 7 9-31 3 7-9 41 3 5 8",
    ": 50-1 3-4 6 8 64 72 5-6 81-2 4 7-8 90 2-4 300 2-3 5 7-8 12 5-6 21 4 33-4 8 40",
    ": 5 7-8 50 2 5 7 60 2 5-6 8-9 71 3 84 8 92 4 9-400 2-7 11-2 4 7 9-20 3 5 8 30-1",
    ": 4 8 41 4 6-7 50 3-6 60 3 6 8-9 74-5 8-9 81-2 4 7 9-92 4 6 503 8 10-1 3 6 8-20",
    ": 2 4-5 7 9-30 2-3 7 9 42 8 51 3 5 64 9-70 4-5 8 83-4 90-3 6 8-9 602 4 8 11 3-4",
    ": 6-7 9-20 3-6 8-9 31 3-4 6 8-9 41-3 5-7 50-1 3-6 8 61-2 4 6 9-70 2 4-6 80-1 3",
    ": 5 7 9 91-2 5-7 701-2 4 6-7 9-11 5-7 20 2-3 8-9 33-4 6 8 41-2 9-50 2-3 7-8 60",
    ": 3-7 9-70 2-3 5-7 80-3 5 93-5 7 9-803 8 10 2-4 6 9-20 2 6 32-4 7 9-40 3-4 6",
    ": 51-2 4-5 63-5 7-8 71-3 7-8 80 2-5 8-9 92-3 6-7 9 901 3-6 8 11-2 4 7-9 26-7 9",
    ": 34 6 9 41-3 6-9 51 3-4 8 60 3-4 7 9-72 4 6 80 3-4 90-1 5",
    ": 3000-2 4 6-9 14-5 8-9 22-3 7 9-31 4 6 9 41-2 4 7-8 50 3 5 7 9-60 4 7 9 74 7",
    ": 80-1 4 7 9 92-4 7 101-2 4 7 9 11 3-4 20-1 3-4 30-1 3-4 8 41 4 7-9 53 7 60-1 4",
    ": 6-70 2-3 5-7 9-80 3 7-8 90 3 5-7 200-1 6-7 14 6 9 23 5 7 30 3 5-6 40 2 4 6 50",
    ": 3 7 60 2 5-7 9-70 2 6 8 81 3 5 7-8 90-1 4 7 300 2 4 7 10 2 6 20-1 3-4 6-7",
    ": 9-30 5-6 40 2-5 7 9 51-2 4 9-60 4 6 8 71-2 5 8 80-1 4 6-7 9-90 3 6-8 401-2 5",
    ": 8 11-5 8 21 4 7 31 4 6 8 40-1 4-5 8 51-2 4 7 60-1 3-6 9 71 9-80 2-3 5-6 9",
    ": 91-2 6-7 500 8 12-4 7-8 22 5 7 9-30 4 7 9-40 4 6-7 9 52 4-5 60-1 3-5 7-9 71 4",
    ": 7 86-7 9 92-3 6 602 7-8 10 6-7 9-21 4-5 8 31 7 40-2 4-6 9-50 3-4 8 60-1 3 5 7",
    ": 9-70 2 7 87 90 4 6-7 9 706 10 3-4 9 23 6 8 32 5-6 41-2 7-8 50-1 3 5 8 60 3-5",
    ": 7 9 77-8 80-1 3-6 8 90-1 4 6 8 801 3 10 5 7 9-21 3-4 6 8-9 31 5-6 9 41-2 5 8",
    ": 50 3 6-7 9 61-2 5-6 9 71-2 4-5 7 82-3 6 9-90 2-3 5 7-9 901 4 6 9 11-4 7 9-20",
    ": 4 6 31-2 45-7 9 56 9 61-2 4 6 9 71-3 7-8 80-2 5-7 9 92 5-6 8",
    ": 4002-6 15-6 9 23-4 7 33 5 7-8 40-1 3-5 7-8 50 3-5 7 9 62-3 5-7 9 72-3 7 9 81",
    ": 3 5 7 9-93 5-6 8-9 101 3-5 9-13 5-6 8 20 3-5 7-8 31-2 4-6 9-41 3-4 8 50 3 5",
    ": 9-60 3 5-6 9 72-3 5-6 8-9 82 4 6 8-91 3 5-6 200 2-5 11 3-4 9-22 6 8 30 4-7",
    ": 9-40 4 6-8 53-4 6 9 61-2 5 9 71 4 6-8 85 7 93-4 300-1 3 6 9 13 7 20 2 6 8-9",
    ": 31 3 5-6 8-9 41 4 7-8 51 3 9 64-9 71-2 5-6 81 3-4 7-8 90-2 4 6 8 405-6 8 16 8",
    ": 22 6 9-30 4 9-40 3 5 7 52 60 3-4 70 2 7-9 82 7-9 91 3 500 2 4 6 9 17 25 7",
    ": 9-30 2-3 5 40 3 5-6 8 52-3 6 8 61 4 6 71 4 8 84 7 9-91 6 9-600 2 4-5 7 9 12 4",
    ": 6 9 22 4-5 7 9-30 3 8 41 3 6 8-9 51-2 6-7 62-3 5 9 71 4 7 82 6 8-90 4-5 701 5",
    ": 9-10 3-4 8 22 6 9-31 3 6 41-2 7 50 2 4-5 7-8 62 5 9 71 6 80 2-3 5 8-9 91 3-4",
    ": 6 8-9 801-4 6 9-10 2 6 8 20-2 4 6-7 9-30 2 5-6 8-40 2-3 5-6 9-50 2 4-5 60-2 8",
    ": 71-2 4 6-8 80-1 4 8-9 91-2 8 900 2 4 7-9 12 4 21 4 6-7 9-31 3 6 8 41 4-8 51",
    ": 5-7 62 4-5 7 9-71 3 8 82 9-90 2 6",
    ": 9-5000 3 5-6 8-9 12 4-7 9 26-7 31-3 5 9-40 3-6 8-9 52 4-5 8-60 2-6 8-70 3 5",
    ": 80-2 4 91 5-7 9-102 7-8 10 2 5-6 8 21-2 4 6 30 3 6 9 46 8 50-2 4-8 61 5-6",
    ": 70-1 3-5 7-9 81-3 5-6 8 90 2-4 7 202-3 11 3-4 7 24 7 9-30 4 7 45 9-50 3 6",
    ": 60-1 3 6-7 9-70 7 80-1 7-8 90 3 5-6 300 2-3 5-6 8-9 11 3 6 8-20 3 6-7 9 32 9",
    ": 41-3 5 9-53 5 7 9 61 5 7 71 4 7 9 86 92-4 6 9 401 3-4 13-5 9 22-3 7 32 4-5 8",
    ": 40 2 4 6-7 50-1 3 5 8-60 2 8 70 3 5 7-8 80-1 3 5-6 8 91-2 7 500 7-8 10 2 6 8",
    ": 20 2 5 7-8 30-2 4-5 9-41 3-4 6 8 51 3-4 6-7 9 61-3 7 71-2 5 81-2 4 6-8 90-1",
    ": 3-4 7 9 601 5 7 12 4 7-8 20 2-4 9 32 5 40 3-5 8 51 5 7 60 2 4 6 8 73 5-6 8 80",
    ": 2-3 7 92-3 5 702-3 5-7 13-4 8 20 3 6 8 31 3 8-9 43 53 5 8-9 62-4 8 70 81 4",
    ": 95-6 8 802 9 11 7 24-6 9 36-7 40-1 3-4 6 8-50 4 7 9 62-3 5 8 70 2 4-5 8 80-1",
    ": 3 7 90 4 6 901 3-5 11 3 5 7 9 21-2 4 6 31-2 5 8-9 41-2 6 54 60-1 3 5-7 70 4 6",
    ": 9 81 6-7 9-90 3 5 7",
    ": 6000 2-3 5-6 9-10 2-3 5-6 8-9 24 6 30 2 4 6 40 3 5 9 53 9-61 5 7 70-1 7 80-1",
    ": 3-4 6-8 91 3 5-6 8 106 8-9 12 5 8-9 22 7 9 36-7 41 4-5 8-50 3 5-6 8-9 61 4 7",
    ": 9-70 2-3 8 80-2 5-6 8-9 91-2 4-5 200 3-4 7-8 10 3-4 9-20 2-3 5-6 33-4 40 3-5",
    ": 7-8 50-1 5 7 9 61 5-6 8-9 71-2 7 80 8 90 3-4 303 5 7 12 4-5 7-8 20 6-7 9-30",
    ": 3-5 7 41 7 52 5-7 9-61 3 5 70-1 5 81-2 5-6 9 91-2 5 7 9 401 3-4 8 10-1 3 5 20",
    ": 2 7-8 31 7-8 41 3-5 7 50 2 5 7-8 62 5 9 72 4 6 8-81 5 7-8 90-1 3 6 8 503-4",
    ": 6-7 9 15-7 9 21 3-4 6 30 3-4 8 41 4-5 50 3 8 60 3 5 9 71 3-4 8 80 2 4 6-7",
    ": 9-90 2-3 5 7-9 601 3-6 8-9 11 4 6 8-9 24-5 30 3-4 7 9-40 2 5-6 8-9 53 6-7 9",
    ": 63 7 9-71 3-5 81-2 4-6 8 92-3 5 7 9 704 8-9 11-2 5 7 22-3 8-9 31 5 43-4 6-7",
    ": 53 5-7 64 6 9-70 2-4 6 80 2-3 6 8-90 2-3 6-8 801 3-4 8 10 3-4 6 20-1 3 5-6 8",
    ": 31 3-5 7 9 41 3 5-6 51 4 8-60 2 6 8-9 71 3-4 6 80 2-4 7-8 91 5 7-8 900 3 5-6",
    ": 8-9 11-2 5-9 22-3 5-6 8 30 2-3 9-40 2-3 5-6 8 54 8 60 2-3 7 72-3 5 9 81 3 90",
    ": 2-4 6 8",
    ": 7001 4-6 9 11 4 20 9 31-2 5-6 9 42 4 6 8 50 2-4 6-7 9-60 2 70-2 4 6 9 81 6-8",
    ": 90 2 5 9 101-2 5 9-10 2 9 25 9 32 5 8 40 2 4-5 9-51 5 9 63-4 6 71 4-5 8 80 2",
    ": 5-6 8 90 2-4 6 8-9 201-2 5 8-9 12 5-8 21 3-4 6-7 31-2 5 7-9 41-3 5-6 50-1 3-5",
    ": 7-60 3 8-9 71-3 5 9 82-3 6 9-90 3 6 301 4-5 10 2-3 5 8 25 8-9 31 4 6-7 41-2 4",
    ": 9 56 9 64 6 70 4-6 8-9 83-4 90 2 4-6 8-9 401-2 6 8 10-1 5-6 8 20 2 4 6-7 9-31",
    ": 9 42 4-5 7 51-2 4-5 7 9-60 4 6 8 71 3-4 85 9 94-5 9-501 3-4 7-9 12 4 9-21 8",
    ": 32 4 7-8 42-3 5-7 51-2 6 8 61-2 4-5 9 73 6 80 2-3 90 3 7-8 603 7 10-1 7-8 21",
    ": 4 8-9 39 42 4 8 54 6-7 9 61-2 5 9-70 4-5 80 5 8 90-1 3 5 7-8 700-1 3-5 8-10 3",
    ": 6 8 20 3 6 9 32 9 42 9 53 9 63 7 70 2 8 83 91 800 4 6 8 10-1 9 21-2 4 9 31 3",
    ": 7 45 51 3 9 61 5-6 70-1 8 82-3 6 8-9 92 5-6 9 903 8 10 6 9-21 3 6-7 31 8 40",
    ": 2-3 7-8 50-1 4 8 62 4 6-7 9 71-2 5 8 80-1 4 8 90 3-4 6-7",
    ": 8000 3 6 8 10 2 6-7 23-5 7 9-30 2 8-9 42 6-8 51 3 7 9-60 4 6 9 72 4 6 9 84 7",
    ": 93-4 7 101 5 8 10 2 5 8-9 21 4 6 8 33-4 43-5 51-3 5-7 9 62-7 73 6 9 81 7 9 91",
    ": 3 202 5 9-11 3 5-6 8 22-3 6 8 33 41 3 5 7 50 3 6-7 9 61 3-4 72 82-4 7-8 90-1",
    ": 3 5 8-9 301-2 4-5 7 9-10 2-3 6-9 21-3 32 4 6-8 42-4 8 51-4 7 9 62-4 70 4 9-82",
    ": 4-5 93 5-6 401 3 5-6 8 10 3-4 6 20 5 7 30 5 7 9 44 55-6 8 61 6 9 72-4 8 83-4",
    ": 6 9-90 2 5-7 9 504 6-8 11 5-7 20-1 3-4 6 8 35 7 9 41 4 7 50-2 7 9-60 3 6-7 70",
    ": 2 4 6 8 80 2-4 6 9 91 3-4 6 8 602 4 7 9 15 20 2 4-5 7-8 30 2-4 6 9 41 3-5 8-9",
    ": 51 4-6 60 3 6 8-70 2-3 5-6 8-9 83 6-7 96 8 701-2 4 6 8-9 15 7-8 20-1 3-4 7 32",
    ": 6-7 9 41 5-7 51-3 5-8 60-1 3-4 6 8 72 5 7 9-80 2-4 6-8 90 4 7-8 801 5 9 11",
    ": 3-5 7-8 20 2 5 7 31 3 5-7 9-42 4-6 8 50 2 4-5 8 60 6 9-70 2 5 7 9 81 4 8 91",
    ": 3-5 8 900 6 8 12 4 7 21 3 6 8-9 34 40 5 51-3 6 9 64-5 7 9 71 3-4 6-7 9-80 2 4",
    ": 9 92-3 5-6 8-9",
    ": 9002 5-6 9 11 5 7-9 21 4-5 8 30-1 4 41 3-4 9 52-3 9 61 5 7 72 6 8 80-3 7 9-91",
    ": 3 5-7 9 101 5 10-2 5 21-2 4-5 7 31 3 40 2 4 51-2 4 6 8-9 62 4 6-7 9 72-3 5-6",
    ": 8 80-1 4 6 90 6 200 2-3 6 8 10-1 3-4 6 21 8 32 4-5 7 41 4 50 3 5 8-60 2 4 6",
    ": 74 8 82 301 9 14 7 21 3 5-6 30 3-4 6 8 42-3 5 50 2 4-5 8-9 64 7 9 72 5 7 9-80",
    ": 2-4 6 90 2 6 8 401-2 7 10 7 20 2-3 6 30 3 5 7 41-3 7 9 51 3 5-6 60 2 4-5 7",
    ": 9-70 7-8 92 4-5 502 4 7 9-10 2 5 8 21-2 4 6 8 30 6 9 44 52-3 5 8 62 5 73 5 9",
    ": 81-2 4 6 8 600 7-9 11-3 5 7 9 21-3 5 30 4-5 7 9 41 3 51 3 7 61-2 4-6 74 7",
    ": 9-80 2 4 6-7 93 5-6 702 6 8 11-2 4 6 8 20 2 6 8 30 2 4 6 9-40 3 5 7 9 52 4 7",
    ": 9-60 2 4 6-7 70 2 6 8 82 8 90 2 7 9 801 3 5 8 12 6-7 9 21 3-4 30 2 4 6 9-40",
    ": 3-4 6 8-50 4 71 3 9 83 6 90 2 4-5 7 900 2 6 8 12 4 6 9-20 6 8 32 8 41 50 2 5",
    ": 8 60 3 5 9-71 3 7-8 86 9 91 6",
    ": 30004 6 10-2 6 31 40 2 8 50 2 4 62 5 72 4 7-9 83 8 90 3 5-6 101 6 10 2 9 24 8",
    ": 32 4 41 50 2 4 6-7 64-5 71 3 80-1 3 5-6 9 95 8 204 7-8 12-3 9 21 3 7 9-30 7-9",
    ": 43 5 7 9 51 3 60 3 7 71 4-5 7-8 80 3 8-9 91 3 6 303 5-6 14 6 20 2 4 8-9 31-2",
    ": 6 40 4 6 51-2 4 7-8 60 2-3 5-6 70 2 4 6 80 2-3 5 91 3 6 400 2-3 5-6 9-11 3 6",
    ": 9 22-3 5 32 6 8 40 3 5 7 9-50 2 4 6 9 61 70 2 4 6-7 9 83-4 6 91 6 9 501-2 4 9",
    ": 12 9 22 5 8 31 3 40 6 9 51 3-4 8-9 62-4 6 8 72 4 9 82-3 5-6 8-9 95-7 9-600 2",
    ": 7 9 15-6 9-20 3 6 37-8 41-2 4 6-7 9 51 3 5-6 8-9 63 6-8 71 3 5 8 81 4 6 8-9",
    ": 708 10 4 7 9 23 6 8 32 43-4 6 8 51 4 6 8-9 61 3 5-6 8 70 2-3 5 8-9 82 4 9 94",
    ": 7-8 804 6 8-9 11-2 5-6 9 21 6 32 5 7-8 40 3 5 7 9 53 5 7 9-60 2 9 72-3 5 80 2",
    ": 5-6 8 92-3 8 901-2 4-5 7 11 4-5 28-9 31 4 40-1 7 55 7-8 63 5-6 74-5 80 2 4",
    ": 6-7 9 91 3",
    ": 1000 2 4 6 8 10-1 3-4 6-7 24 8 30 2 4 6 8 41 9 52-3 5 60 3 5-6 8 71 4 6 8 81",
    ": 5 9 91 4 105 9-10 3 7 22 5 32-3 5-6 40 2 4 51-2 5 7 9 63-4 9 73 5 8 81 3 5-6",
    ": 8 90 3 5 7-8 205 10 2-3 6 8 20-1 3 6 8 31 3 5 42 5 7-9 51 3-4 63 5-6 74 6 8",
    ": 80-1 5 8 90-1 5-6 304 6 8 16 8 20 6 8 37 9 42 4 7 9 51 61 3 5 9 75 83 90 2 7",
    ": 401 3 7 12 4-5 7 9 21 4 32 4-5 7 9 45 9 53 6 8 60-1 3 5 7-8 70 4 6 80 4 6 8",
    ": 90 2 9-500 4 6 8 13 5 22-4 6 8 31 5-6 9 41-2 6 9 52-3 5 9 62-3 7 75-6 8 80-1",
    ": 4 9 601 3 7 12 5 7-8 20 3 6-7 9 31 3 5 7 49-50 5-6 61 6 70 5-6 8 82 4 6 8-9",
    ": 91-3 8 707 9-10 4 6 8 25 8 30 7-8 42 4 7 9 52 4 7 60 2 7 71 7-82 4 6 9 91 3 5",
    ": 7 802 5 7 10 2 4 6 9 22 4-5 7 9 36 41 4-5 9 51-2 4 8 63 7 9 72 4 7 80-1 4 6 8",
    ": 90 2 4 6 8 901 5 7 9 11 6-7 21 5 30 2 5 9 42-3 6 51 3-4 9 64 8 73 5 7 81 3 90",
    ": 2 4 6",
    ": 2003 5 22 6 30 2 7-8 46 8 52 4 6 8-9 61 6 73 8-9 84 8 90 4 6 102 6 8 11 3-4 6",
    ": 9-20 9 33 41 3 8 50 2 4-5 63 5 7 9 73 5-6 8 81-2 6 8 90-1 8 200 2-3 9-11 5 20",
    ": 2 4-5 7 30 5 7 47 50 7 63-4 7 71 5 82 7 9 94-5 9 312-3 30 2 4 8 40 50-1 8-9",
    ": 66 8-9 72 4 81 7-8 90 2 6 401 4 6-7 10 2 6-7 21-2 6 30 2 6 9 41 4-5 52 4 8",
    ": 63-4 6 8 70-1 7 92 7 9-500 3 10-1 3 20 30 4 40 2 4-5 9 55 7 9 65 70 5 7 9 81",
    ": 3 9 93 7 9 604 7 15-6 8-9 22 8 33-4 6-7 41 3 5 8 52 6 8 60 2 6 70-2 8-9 84-5",
    ": 9 92-5 714 20 2 7 32 4-5 8-9 41 4 52 6 60 4 6-7 71-2 5-6 9 84-5 7 90 3-4 6-7",
    ": 9-800 2 6 9 11 3 5-7 9 21 5-6 8-9 33 9 41 5 9 52 7 9 66 8 70 5-6 8 80-1 4 7 9",
    ": 91 3 5 8 905 7-8 10 2 4 6 20 2 4-5 7-8 30 2-3 5 40 4-5 9 51 5 7-8 60 3-4 72",
    ": 4-5 7-8 80 4 7 9 92 4",
    ": 3007-8 11 5 7 20 4 30 5 40 4-5 8 53 5 7-8 60 2 5-6 76 8 86 9 93 6 100 5 7 24",
    ": 6 8-9 31 3 5 7 41 7 50 2 7 9 61-2 7 9 73 5 7 9 81 4 6 8 91 3 5 7 9 210 2 4",
    ": 29-30 4 6 8-9 41-2 5 9 55 7 9 62-3 5 7 75 83 90 2 9 303 5 8 11 3 5 7-8 23 5",
    ": 7-8 34 6 43 5 8 53 5 7 60 2 4 7 72 8 83 5 7 91 8 413 8-9 23 9 34 6 8 40 2 5 9",
    ": 51 4 6 60 2 5-7 76 9 81 3 6 92 4 6-7 9 501 3 5-6 12-3 5 8 22 4 9 31 4-5 41 5",
    ": 7 52 5 7 9 62 6 8 70 2 4-5 7 9 83 7 9 91 4 6 602 6-7 9 11-3 5-6 8 20 5 32 7",
    ": 40 2 9-50 5 7 9 61 3-4 75 7 9 83 9 91 5 9 711 3-4 7 20 2 4 7 9 33 42 4-5 7-8",
    ": 50 2 5 8 60 2 6-7 9 78 80 3 5 7-8 98 800 2 4 6 8 10 3 5 7 9 21 5 8-9 31-2 6 8",
    ": 42 8 50 8 60-1 5-6 71 5 82 900 8 10 2-3 8 22 4 9 36 9-43 8-9 51 9 62 4 6 8 70",
    ": 3 5 8 87 94-5",
    ": 4000-1 8 15 8 26 36 41 3 5-6 52 8 61 3 71 5 7 9 81 6 92 103 5 10 2 5-6 21 3 7",
    ": 9 31 3 5 7 40 4 9-50 61 4 73 9 83 5-6 8-9 93-8 214 6 25 7 33 5 9 44 6 8-9 52",
    ": 4 6 9 62 9 73 5 9-80 5 7 90-2 8 304 6 10 3 25 8 35 7 41 4 52 61 4-5 72 9 82 4",
    ": 8 91 3-4 6-7 9 416 9 21 3 6-7 32 4 6 40 2 4 6-7 52 4-5 7 9 61 3 5 74-6 9 82 4",
    ": 6 93 7 500 6 10 2 4-5 7 26 35 42 4-5 8 53-4 63 8 72 4 81 6 91 9 602 7 9 16 24",
    ": 7 9-30 41 4 9 54 7 69 75 88 90 5 8 705 10 3 7-8 23-4 8 30 2 5 9 42 4 50 4 6 8",
    ": 62 4-5 7 71 5 7 81-2 4 6 8 92 4 7 805-6 8 10 2 7 9 26 8-9 35 7 43 50 3 5 7 9",
    ": 61 4 8-9 71 3 6 9 84 7 9 900 2 6 8 13-4 9 22 6 30 2 4 45 7 54-5 7 60-1 5 77",
    ": 81 4 9 94 6 8",
    ": 5000 3 5 13-4 6 8 20-1 4 8 30 2 5 8 40 2 5 9 51 3 5 61 8 70 2-3 5 7 83 90 4 6",
    ": 104 6 15 24 6 9 31 7-8 40-1 4 7-50 3 8 60 4 9-70 4 8 81 3 6-7 92-3 5 9 201 6",
    ": 9 14-5 7 9 21-2 7 9-30 2 4 8 40-1 4-5 8 51-2 5 7 66 9 71 5 84-5 7 90 2-3 6 8",
    ": 303 5 8 10 3 5 22 6 9 33 5 7 42 8 53-4 8 60-2 70 8 80 2-4 98 401 5-6 8 14 6 9",
    ": 24 8 30 5 7 40 3 6 8 50 2 4 6 64-5 70 6 9 83 5 8-90 6-8 500 3 7 10 3 6 8 20-1",
    ": 9 33-4 6 40 5 50 2 4 7 9 62 4 8-9 71 8 83 8 90 2 5 9 602-3 5 7-9 19 24-7 9 32",
    ": 6 8 40-1 7 9 51 3 5 66 8 71 3 5 80-1 3 5 7 9 91-2 4 7 700 5 8 10-1 3 5 9 21 4",
    ": 8 33-4 6 41 3 55 9 61 6 8 71 5 9 81 6-7 94 6 801 4 13 7 20-1 4 6 30 4 7 44 6",
    ": 8 50 2 7 9 61 8 70 2 4 6-7 9 81-2 5 9 94 8 900 5-7 15 9 23-4 6 30 2-3 7 9-41",
    ": 3 5 8 50 2-3 61-2 4 6 70-1 5 9 81 3 5 90 2 7-8",
    ": 6001 5 10 4 6 8 21 5-6 8-9 31 3-4 7-8 42-3 5 8 56-7 69 71 4 89 92-4 7 9 101 3",
    ": 5-6 11 3 20 3-4 8 30 8 40 5 9-50 2 4 6 8 60 2 4 7 72-3 5 7 80 3-4 9-90 2-3 9",
    ": 202-3 8 11 3 8 20 2 5 31 3 5-7 40 4-5 7 9 51-3 7 9 61 5 73-5 7-8 80 2 5 8-90",
    ": 2 5 8-9 301 3 10 2 23-4 8-9 32-3 5-7 40 2-4 8 51-2 5 7 9-60 3-4 6-7 71-2 4-5",
    ": 7 9 86 91 3 7-8 401-2 4-5 7 9 11-2 4 6 9-20 2 8 30-1 8 42-3 6 9 52 4 6 8-9 65",
    ": 9-70 2 7 81 91 3 7 500-1 3 5 15 24 7-8 34 6-7 9 41-2 4 6 9 52 6 8-60 2 79 84",
    ": 90 4 7-8 601 5-6 8 10 4-6 8-9 22-3 5 9 31 3 8 40 2-3 6 8 53 5 7 9 61 5-6 8 71",
    ": 5 7 9 81 3 6 8-9 95 7 9 703 5 8 10 2 4 6 20 2 7 9 31-2 4-5 7 41 3 5 7-8 50",
    ": 2-3 9 61 5 8 70 5-6 8 81 4 6 93-4 6 803 5 9 11 4 22 32 4-5 9 43 5-6 8 50 2 8",
    ": 60 2 9 73 5-6 9 81-2 6 9-90 3-4 6-7 900-1 7-8 10 2 4-5 7-8 23 6 8 37 9 41 9",
    ": 51 4 6 63 7-8 78 80 2 5 8 90 2 5 8",
    ": 7005 18 20 6-7 9 31 3 42 9 53 8 63 6 70-2 4 6 80 4 6 9-90 3 5 100 2-3 12 20-2",
    ": 4 40-1 9 51 5-6 8 61 3 6 9 71 3 5-8 80 2-3 5 7 91 7 204 9 11 5 7-8 20 2 6 9",
    ": 33-4 6 40 2 4 6 8-9 53-4 61 4 6 8 75-7 80-1 3 90 7 300 2 4 8 15 22-3 6 32 7",
    ": 41 4 7 9-50 2 7 61 3 71 3 82 5-6 90 2 4 400 2 7-8 12 4 25-6 8 31 40 4 6 8-9",
    ": 58 60 2 4 7 79 90-1 500 11 3 5 8 21-2 6 32 4 7 9-40 3 57 62 4 8-70 3-4 84 7",
    ": 91 5-6 606 11 4-5 22-3 32 4 8-40 2 4 8 52-3 5 7 9 61 8 70 2-3 6 8 88 91 3 5 8",
    ": 701 3 5-6 8 11-2 4 6 8 21-2 4 6-7 33 42-3 6-7 9-50 5 61 6-7 9 74-5 9 81 3-4",
    ": 6-7 9 92 7 9-800 2 5 8 12 4 6 9 27 34 43 8 50 3 5 7 9 61 3 8 70 4 7 82 91-2",
    ": 4-5 8 902 4-5 10 2 6-7 20-1 3-5 9-30 2-3 42 4-5 9 54 9 62-4 6 9 72 4 8 80 4 6",
    ": 9 92 4 9",
    ": 8003 11 3 6-7 32-3 5 42 5 54 7 9-60 5 7 9 71 5 7 82 6 90 2-3 7 100 6 8 10 2",
    ": 6-7 9 21 5-7 9-30 2-3 7 9 41 3-4 6 8 50 4 8 61-2 4 8 70 2-3 5 7 80 4-5 9-90",
    ": 2-3 5-6 8 208 11 3 5-6 8 20 2-3 5 7 9 32-3 5 7 9-41 4 6 50 5-6 8 61 3 6 72-3",
    ": 5-6 8 80 2-3 9 91 4-6 8 300 5 10 4 7-8 22-3 7-8 30 2 4 46 8 50-1 3 8-9 61 5-6",
    ": 70 4 6 82 4 6 90 2 4 6 9 403 5 8-9 12-3 5 7 20 7 30 4 7 9 41 3 7 9-50 7 9 63",
    ": 8-70 2 4-5 7 9-80 2 7 9-90 2 5-6 8 506 10 4 9-20 5-6 8 43-4 7 51-2 6 8 62-3 5",
    ": 8 70 4 9 83 6 8 91-2 6-7 604 6 8-10 2 4 24 7-9 36 41-2 4 6 8-9 61 3-4 7 70 2",
    ": 4 9 82 5 8 90 2 4 7 9 703 5 8 10 2-4 6 24 7 31 4 7 42-3 9 55-6 8 71 4 6 80 9",
    ": 93-5 7-8 800 2 8 10 2 4 7 20 30 2 40 6-7 50 5 66 71 3 5 80 2 4 6-7 9 92 4-5 8",
    ": 900 3 5 11 4 6 8-20 4 6 32 6 40-1 4 8-9 51 3-4 6-7 9-60 3 5 9 71 3-4 6 8 80-1",
    ": 4 6 8 91-2 4 6",
    ": 9000-1 3-4 6-7 9 12 8 20 2 4 9 32-4 48 52 4 8 60 2 6 76-7 9 81 3 8 91 3 101 3",
    ": 6 8 12 4 6 8 22-3 30 4-5 7-8 40 2 6-7 52 4 60 2 4-5 8 70 4 82 5 8 90 2 4 6-7",
    ": 200-1 4 6 9 11 3 5 9 22 5 7 9 37 9 41 8 50 2 4 8-61 5 7-8 70 6 9-81 3 9 92 4",
    ": 306-7 15-6 8-20 2 6-7 32 6 8 41 9 51-2 4 9 61-2 6 70 4 8 83 5 7 9-90 5-6 8",
    ": 410 4 22 4 7 9 33 9 41 4-5 7 55 60-2 4-5 71 3 7 81 5 7 9 96 501 4 7 9-11 3 5",
    ": 7 9 23 5 9 32 9-41 3-4 6 50-1 4 6-7 61-2 4 6 72 6 8 81 3-4 92 4 6 8 600-2 9",
    ": 11 4 22 4 30 6 43 52 4 7-8 60 4 6 8 70 5-6 8 81 3-5 9 91 4 6 703 5 11 3-4 6 8",
    ": 20 4 6 8 34 8 45 7 52 5 7-8 60 2 4-5 7 75 8 80 8 90 2-3 803 6-8 13-4 7 20 7 9",
    ": 32-3 5 7 9 45 7 51 3 6 61 3 71-2 4 8 83 7-8 90 4-5 7 9 902 4 9-10 2 4 22 5 9",
    ": 33-4 6 42 5 52 4 6 60 3-4 7 9-70 2 4 6 8-9 81 3 5 9-90 4 6 8",
    ": 40001 5 9 12 4 6 8 22 5 32 4-5 7 40 5-6 51 4 6 8 61 5 9 71 3 5 7 9 81 8 90 3",
    ": 7 101 3 5 8 10 4 6 9 25 9 31-2 4-5 7-8 42 6 53-4 7 64 6 70-1 4 6 8-9 83 5 7",
    ": 90 2 5 202 5 8-9 11 9 21 3 8 31 44-5 7 9 52 4 6-7 9 64-5 70 2 4 6 82-3 6 91 3",
    ": 7 9 305 7-8 10 3 5-6 8 21-2 7 9-30 3 40 3 5-7 51 4 6 8-9 61 4-5 71-6 8 81 5-6",
    ": 8 94-5 7 402 6 11 3 5-6 8 22 4 6 8 30-1 5 7-8 43 5 50-2 4 61 3-4 8 71 3 5-6 8",
    ": 82 5 8-9 98-9 502-3 5 7 9 11 3 21 4 30 3-6 8 40 4 6 50 5-6 8 62 4 9 73 5 7-8",
    ": 82 8 91 5 7 600-1 5 8 10 2 6 8-9 26 9 31 3 9-40 7 9-50 2 5 9 62-3 5 8 71 3 8",
    ": 80 3 5 92 8-700 2 4 6 9 11-2 6 20 5 7 9 31-3 5-6 8 40 3 6 8 50 3 6 9 61 7-8",
    ": 71 3 5 9 81-2 6-7 90 2 8-9 801 3 10 3-4 6 20 3 6 8-9 31-3 5 8 40-1 3-5 7 9",
    ": 55-6 8-9 61 3-4 6 8 72 5 80-1 7 9-90 2-4 6 8 902 6 11 3 6 22 5 7 9 31 8 40-1",
    ": 3 8 53 7 9 63 7-9 73 8-9 81 3 9 94 6 8",
    ": 1000 7-8 12-3 6 9 23 7-8 31 3 5 7 43 5 7 9-50 5-6 8 61 7-9 80 2 7 9-90 2 5 7",
    ": 101 3-4 13 6-7 9-20 8 30 8-9 49-50 4 7 9-60 2 4 6-8 70 2 4 8 84 7 9 97 9-200",
    ": 2 6 9 11-3 5 7 9-20 3 5-6 30-3 5 7 9 42 4-5 53 7 65 8 70-1 3 8 83 7 9 98-9",
    ": 303 7 15 7 21 3-4 30 5 8-40 2-3 5-6 8 51-2 4 7-8 60-1 3 7-8 70 2 4-5 85 8-9",
    ": 91 3 6 9-400 2 4 6 9 14-5 9 23 8 35 7-8 40 2 51 5 7-8 60 4 7 77 9-81 3 5 9",
    ": 91-3 7 501 3 6 9 13 5-6 8 20 2 4 6 8 31 3-4 7 9-40 4 6-7 51 3-4 6-7 68-70 3",
    ": 7-8 80 2 4 7 9 94 7 603 6 8 11-2 4 9 28-9 31 3 7 45 8 52 7 61-5 7 9 74 6 9 82",
    ": 6 9 91 7 700-1 6 9 11 3 7 9 21 3 33 5 43 7 9-50 3 61-2 5-6 9-70 2-3 5 9 82-3",
    ": 6 9 91-2 5 8 805 10 3-4 7 20 2 4-5 7 31-2 4 6 8 43-4 6-7 51 7 9-60 2 4-5 7-9",
    ": 71-2 4-6 9 87 9-90 2-4 6 904 7 9-10 2 5-6 8 20 5 7 30-1 3 6 40-1 5 7-8 58 61",
    ": 3-4 7-8 71 6-7 80 3-4 6 8 90-3 5 7",
    ": 2001-3 7 10 2-3 5 7 9 21 8 30 5 7-8 40 2 7-8 50 3 7-8 61-2 6 70 3 81 4 7 91 3",
    ": 100-2 10 2-3 6 21-2 8 30 4 7 40 2 7 50 3 5 9 65-7 9-70 2-5 82 4 90 3-4 9-200",
    ": 2 5-6 8 10 2 7 9 27-8 31 3 5 9 41 5 9 53-4 6 64-5 7-8 70 2 7 81-2 4-6 8 95 7",
    ": 308 10 4 8 22-3 5 32 49 51 3-5 7 64 9 76 86 91-2 8 402 4-5 8 11 3 5 7 24 9-30",
    ": 2-4 6 40-1 5 51 4 9 61 3 6-9 73-4 8 83-4 6 9 91 3 7-8 500 2 5 7 10 2 6 9 21-2",
    ": 4 6 8 31-2 5-6 8 43 5 9-50 2 4 7 9-60 2 5 7-8 72 4 6-7 81 4 93-5 8 602 4 6 8",
    ": 10-1 4 6 8 22 4 6 34 6-7 9 41 3-5 8 53 7 9 61-2 4 70-1 3 8 83 7 93 6 8 700",
    ": 3-4 10 2 4-7 22 4-5 7 33 6 41 3 5 9 55 8 60-1 3 8 71 80 2 5 7 9 93-4 6-7 800",
    ": 4 6 10 4 25 7 33 6 40-2 5-6 9 53-4 6 63-4 8 70 3 8 80 3 5 8-9 91 5 900 2 5 9",
    ": 13 7 23-5 7 9 31 5 44 6-7 9 59-60 9 72-3 6-7 80 2-3 5 8 90 2 6-8",
    ": 3000 2 4-5 9 15 22 4 6 8 30-1 3 8 40-1 9-50 3 5 60-1 3 5-6 71 3-4 6 8 83 5-6",
    ": 9 91 3 5-6 8 100 2-4 6-7 11 3 7 9 22 4 6-8 31 4 9 41 5 59 66 8 70-1 7 82 4",
    ": 6-7 94-5 7 9 201 3-5 7 10-1 3 6 20-1 5 7 32-4 6 41 3 5 7-8 51-2 4 6 60 3-4 6",
    ": 72 6 84 9-90 2 4-5 300-1 5 7 9-11 3 8 20 3-6 8 30-1 3-5 8 48-50 2 9 63-6 8-70",
    ": 2 4-5 8 84 6 401 8 10-1 3 5 7-8 23-4 9 31 6 8 45 7 9 53-4 6 61 5 8 70-1 3 7",
    ": 81-2 4 6 91-2 503 7 9 12 4 7 9-20 2-4 8 30 4 6 8 41-2 7-8 50 3-4 7-60 9-70",
    ": 2-3 6 8 80 2 4 8 90-1 3 7-8 600 4 6 11 7 9-20 2 5 7 35 9-40 2 4 6-7 50 8 65 7",
    ": 71 3 5-6 8-9 81-2 92 4-5 8 700 2 5 8 10 7 9 21 3-4 7 9-30 2-3 7 9 44 6 8 50-1",
    ": 3 5 7 64 7 9 72 6 80 7 9 92 4 6 8 800-1 4-7 12-3 6 8-9 23 5-6 9-30 2 4 6 41 3",
    ": 9 51 3-4 7 9 71-2 5 7 81 3 5 7 9 91 6 900 2 4 6 9 11 3-4 9 21 33 9 41 4-5 8",
    ": 52 4 6 60 2 5 7 72 8-9 83 8 93 5 7",
    ": 4003-4 6 8 10 2-4 6-7 21-4 7-8 38 46 54 6-9 61 3-5 9 73 5 9 86 9 93 7-8 101 4",
    ": 7 10 6 23 8-9 32 5-6 8 40 3 50 3 8 70-1 4-5 89 91-2 4 6 201 7 9 12-4 9 21-2 7",
    ": 33 5 7 40 2 5 8 52-3 7 61 5 9 73 6-7 81 3 6-8 92-3 5-6 8 303 5-6 8 11 3 5 7-8",
    ": 23-5 9 32 9-40 2 4-5 9-50 8 64 7 71 4 8 82 91 7 9 401 3 6 10 3-4 6 8 25 9-30",
    ": 2 4 6-7 45 8 51 5 8-9 62 8 70 80 2 6 8 90 3 7 500 4-5 9-12 4 6 9 23 7 9 31 4",
    ": 42 5-6 8 50 2-3 9-60 4 8 71 5 8 81 3 6 8-90 4 6-7 9 601-2 5 8 12 4-5 24 7 30",
    ": 2 6-7 43-4 6 51 3-5 7 60 2 4 72 4 7 81 3 92-3 8-9 702 4 10 4-5 7 9 23 6 8",
    ": 32-3 5 41 3-4 6 8-9 51-2 4 6 62 4 70 2-3 5 82 6 9 92 4 7 802 4 6 8-9 12 5-6",
    ": 20 5-6 41 3 5 9-50 3 8 61 5 7-8 70 2 7 9 83 7 90 2 4-5 7 9 901 4-6 12 4 6 20",
    ": 3 5 8 30 2 6 8 50 4 60 6 73 7-8 82-4 6 8-9 93",
    ": 5004 10 5-6 8 20 5-6 31 3 8 41 6 53 5 70 3-4 7 80 3 6 92 7 101-2 4 7 11 23",
    ": 5-7 9 31 6 8 42 4 6-7 9 56 8 61 3 5 7 74-7 81 3 5-6 97 9 201 5-6 8-9 11-2 4 8",
    ": 23 5-7 9 31-2 42-3 7 54 7-8 60-1 3 5-6 8 77-8 80 2-3 5 8 90 2 4 7 9 309 11 4",
    ": 21 3 7-8 32 45 7 50-2 4 7 71-3 5 8-82 4-5 97 401 5-7 10 3-4 6-7 20-1 30-1",
    ": 40-1 3 5 7 9-50 3 7 61 5-6 71-2 6-7 80 3 5-6 9-93 5-6 8 501 4-5 7-8 10 2 4-5",
    ": 9-20 3 5-7 9-30 4 6-8 40 5 7 54-6 9 62 8 71 4 6 9 81-2 5 7 9 91-2 4 6-7 9",
    ": 602-3 11 3 5-6 8 20 2-3 7 9-30 3 7 9 41 4 7 9-50 2 4 6 8 60 5-6 8 70-1 3 6 8",
    ": 81 3 6 700-2 5 7 10 2-3 6 9 23-4 6 30 2-4 6-7 40 2-4 57 9 63 5-6 8-9 71 5 7 9",
    ": 81 3-4 6 8 91 3-4 800 3-4 7 9-11 5 7 9 22 30 5 41 4 6-51 8 61 3 5-6 8-9 71-2",
    ": 7-80 2 4 6-7 90 4 6-7 905-6 8 10 2-3 5 9 25 30 2 42-3 5 7-8 53 7 61 3-4 6-8",
    ": 71-2 4 6-7 9 81-2 4-5 7-90 4 7-8",
    ": 6000 3 5-6 10 4-5 7-8 27 30-1 3 9 41 4-7 52 4 62 5 70-1 9 83 5 8 90 6 100 2 5",
    ": 7 9 11-2 24-5 7 30 2 5-6 8 42 4 7 51 61 3 5 7 9 73 5 81 3 8 90 2-3 5 200 7 9",
    ": 11 3-4 6 8 21 7-8 32 4 42 4 51 3 6-7 9 63-4 6 9-70 2 5 9 82-3 7 9 91 3-4 6",
    ": 8-9 302 10-2 4 6 8 28-9 34 6-7 9 46 8 50 3 5 8 60-1 3-4 7 9-70 4 6-9 83 6 8",
    ": 90 3 8-9 403 5 9 11 3-5 7-8 22 4 7-8 31 3 9 41 3-7 9 51 4-5 9 62 8 70 3 5 80",
    ": 3 5 8 91 3 509-10 2 5-6 29 33 6 8 40 8 50 2 4 7 65 7 70 3 81-2 93 5 7 9 601",
    ": 3-4 6-9 14 20 2 4-5 7 9 33 5 7-9 42 5 8 52 4-5 9 62 4 6 8 70-2 4 7-9 82 5 91",
    ": 3 6-7 9 701-2 4 6-7 18 20 2 7 9 37-8 41-2 5 9-52 6 9 62 4 6 71 4-5 80 3-4 8-9",
    ": 91 8 800 2 4 7 9 13 9 24 8 35-6 47-8 52 6 60 8 72 4 8 82-3 6 8-9 92 6-7 913 6",
    ": 24 6 35 7 43 51 3 6 8 60 9-70 2 4 6 9-80 2 4 9 92-3 5",
    ": 7002 4 6 8 10 2 4 7 22 4 6 9 31 42-3 6 8 54 6-7 9 61 3 7 9 75 7 83 6 8 92 7",
    ": 102-3 6 8 12 5 7-8 20-1 31 40 3 7 51 5-6 8-9 62-3 8 70-1 3 80-1 4-5 92 5",
    ": 9-200 2 4-5 8-9 13-6 9 22 6 9-30 2-3 5 7 40 4 6 8 51 3 5 7-9 61 6-8 71 5-6 9",
    ": 81 7-8 92 5-6 300 4-5 9 11 3 7 22 8 31-2 8 46 9 51 4 60 2 4 7 73 8-9 81 3 5",
    ": 93 6 9 401 3 5 7 9 11 5 20 4 9-30 3 5-6 8 42 4 6 53 9 63 5 8-70 2-3 9 81 3-4",
    ": 6-7 90-2 4 7 502-3 12 5 7 21 3 7 9 33-4 7 9-40 5 8 54 61 4 9 71 3 5-6 9 81 5",
    ": 8 90 4-5 7 602 5 7 12 7-8 22 9 32 7 9 42 5 9 57 9 61-2 8-9 71 5 7 84 6 8 93",
    ": 7-8 700 5 8-9 11 4 21-3 5 31 3 8 49 52 61 9 75 7 9 82 95 7 800 5 11 3-4 7 23",
    ": 7 9 31-2 40 5 9 51 5 61-2 6-8 70 9 82 9-90 2 4 7 900 5 9 11-2 4 8-9 22 32 4 6",
    ": 9 41 3-4 8 54 6 8 62 4-5 8 71 3 5 9-80 4 91-2 6-7",
    ": 8001-2 4 6-8 10 9 22-3 6 30-1 4 40 2 4 7 50 2-4 7 9 63-4 9 75 81 4-5 8-9 93 6",
    ": 8 105 7-8 11 6-7 20 3-5 8-9 31 6 8-9 41 7 50 2-3 5 60 6 8 71 3 7 9-87 92 5",
    ": 7-8 201 6-7 9-10 3 9 24 6 8 30 5 9-40 7-8 54 6 8 60 2 4 6 8 74 7 9 81 4 6 90",
    ": 2 7 300 2 4 6 8 10 2-3 6 8 22 4 6 32-3 7 9 41 4 50-1 64 8 70 2 5-6 8 80 2 5 7",
    ": 9 93 8 401-2 6 8-9 11 3 5-7 9-20 2 4 6-8 30 5 7 45 8 52 5 8-9 64 6 8 70 2 4 7",
    ": 82 4 7 91-4 6 8 500 7 11 3 5-6 23 6 8 30 2 4 6 43-5 52 4 9 62-3 5 8 70 2 80-3",
    ": 5 90 2 4-5 8 600 2 6 8-9 15 7-8 21 3-4 6 32-3 6 8 40 3 5 7 50 7 9 69 71 7-8",
    ": 84 7-8 90 3 6 9 701 4-6 8-9 11 3-4 27 9 32-3 7 9-40 3 5 7 9 57-9 63-4 6 8",
    ": 73-4 8 80 2 4 7 90 2-3 6 800 4 9-12 4-5 20 4-5 7 9-30 5 7-8 44 8-9 51 3 5",
    ": 63-5 70 4 81 3 7 9 91 3-4 6-7 9 906 15-7 22 4 6 8 31 3 6 8 40-1 3 8 51 6 8 61",
    ": 5-6 8 70 4 6 80 8 90 2-4 6 8",
    ": 9001 3-4 6 8 10-2 5 7-8 20 2 7 9-30 2 40 2 4 9 51 4 7-9 64 6 71 4 82 6 8-9 95",
    ": 7 102 4 6 9 12 4 6 8 20 4 7 9 32-3 5 40 52-4 6 60 3-6 8 71-2 4 81 4 8 90 5-6",
    ": 8 200 4 7 11 3 25 7 9-31 44 8 51 4 60-1 5 7 9-70 2 5 8 86 90-1 4 7-8 305 7 11",
    ": 3 5 20 2 9 36 44 9 53 5 7 60-1 8 70 4 6 9 81 91 6-7 9 401 3 8 13-4 8 20 5 7",
    ": 31 3 41 4 6 8 50 3 5 7 63 6-7 9 74 80-1 5 8 94 6 501-3 5 9 13 24 8 31 8 44 7",
    ": 56-7 9-60 2 4 7 70 2 5 7 9-80 3 6 8 93 5 9 604-5 7 9 12 4 6 22 33-4 8-9 47-8",
    ": 50 8-9 61 5-6 81 6-7 9 92 4-5 7 701-2 5 7 9 14-6 20 8 31 6 8 40-1 5 7 58 60 2",
    ": 4-5 8 71 5 7 9 81 6 9-90 3-4 6-8 800 2 7 9 11 6 8 20 2-4 6 8-30 40 8 56 8 62",
    ": 4 70 84-7 9-90 3 8-9 902 7 18 20 3 7 9 32 8 41-4 6 8 51 7 9 63 5 7 9-71 3 7",
    ": 81-4 8-9 91 3-4 6-7 9",
    ": 50002 5-7 9-10 2 6 8 20-2 4 6 31-2 5 9 43 5-6 50-2 9 61 4 6 70 2 5-8 80 91 6",
    ": 8 100 3 9 11-2 5 8 23-7 9 32 4 6 40 4 7-8 51-2 4 6-7 60 5-6 9-70 5-7 81 5-6",
    ": 91-2 5 200-2 7-8 10 3-4 6 8 21 4 6-8 30 5 7-8 41 3 5 7-8 54 7 9 61 3-4 9 72",
    ": 8-9 83 6 9 91 6-8 300 3 7 14-5 8 21 6 9 31-2 8 41-2 4 7 9 52 4 8 60 5 8 72-3",
    ": 5 9-80 2 6 95 403 10 2 4 6 8 21 4 6 9 33 6-8 42-3 6 8-50 2 6-7 64 7-8 71 7-8",
    ": 81-2 5 7 93 8 501 8 11 5-6 8 20 30 6 40 2 4 7 50 2 4 9 65 7 72 80 6 96 601 4",
    ": 6 9 20 4 7 31 5 40-1 6-7 50 5-6 61-2 4 7 72 4 80 3 7 9 93 7 700 7-9 16 22 5 9",
    ": 31 5 43 5-6 51 3 7 60 2 5 73-4 8 84-5 9 92 8 801 4-5 11 3 8 24 38 42 50 7",
    ": 60-1 4 6 75 9 82-3 7 90 4 6 8-9 903-4 12 4 7 20 5 7-8 30-2 6-7 41 5 51 3 5-6",
    ": 63 71-2 4 9 83 5-7 90 2 6",
    ": 1002 8 11 3-4 6 24 7 31 4 41 3-5 9 52 62 4 7 75 7 9 82 5-6 8 93 7 101-2 6 12",
    ": 4 6 22-3 6 8 30 3 6 41 50 5-6 9 64 7 70 4 6 83 5 8-9 91 3 6 8 201 4-5 9-10",
    ": 4-5 7 9 21-2 9 32 5 40 2 50 3 8 65 9 71 81 5 90 3 5 8 302 5 8 10 3 5-6 9 22 4",
    ": 8-9 31 3-4 9 42 5 8 51 8 61 8 70 4 7 81 91-2 6 8 401 3 7 13 6 20 2 7 30 4 9",
    ": 42-3 53 6 63 5 9 72 7-8 82-3 9 91-2 4 9 502 5 11-2 25 9 34-5 8 43 54 9 63 73",
    ": 83 5 9 94 600 6-7 10 4 6 8 22 5 37-8 41 3 9 53 5 61 76 80 2-3 5 8-9 702 11 6",
    ": 35 40 3-4 50 4 65 7 75 85 94 800-1 4 7 9 21 9 33 7 41-2 7-8 51 3 5 8-9 62 4 9",
    ": 72 88 90 2-3 6 902 6 8 11 6 20 4 6 30 2 40 4 8-9 51 4 6 9 61 3 5 7 73 8 83",
    ": 2002 6 8 17 27 30 3 5 7 49 52 5-6 9 62 6 8 70 6 9 81 7 9 91-2 6 104-5 13 20 2",
    ": 7-8 31 5 8 40 8 51 5 60 7 75 8 83 5 9 94 9 203 6 10 5 7 20 3 9 33 6 43 54 7",
    ": 60 7 70 2-3 8 80 3 8 90 3 6 307-8 10 3 7 20 3 30 2 8 41 4 6 55 9 61 4 9 72",
    ": 82-3 6 9-90 5 403 6 8 15 9 21 4 7 33 7 9 42 5 8 57 9 67 74 7 9 82 6 92 7 9",
    ": 503 15 7 23 6 33 5-6 9 41 3 58 70 4-5 8-9 85 8 91 3 6 9 607-8 12 9 25-6 9-30",
    ": 3 7 9 42 5 8 51 9 63 6 70 3 5 7 83 6 9 91 4 7 704 8 19 21 33 9 45 8 58 66 70",
    ": 3 6 80 6 96 809 14 23 30 4 41 6 51 68 70 4 903 18 20 2 30 2 5 50 8 62 9 71 4",
    ": 82 6 93 7",
    ": 3002 5 8 14 8 20 2 5 9-30 2 7 40 51 62 5 8-9 73 85 8 94 6 8 100 3 12 4 6 20 4",
    ": 8 33 9 42 7 55 65 76 8 80 8-90 2 5-6 9-200 2 8 10 22 4 7 31 3 7 9 48-9 52 64",
    ": 77 86 9 93 6 9 302 7 11 9 28 34 8 40 3 6 8 53 7 60 4 72 82 4 6 8 98 401 3 8-9",
    ": 13 9 22-3 6 33 7 9 50 4 7 60 4 71 5 80 500 2 10 5 7 28 35 9 48 58 60 70 3 6 9",
    ": 86 8 91 3 9 607-8 15 7 21 7 30-1 44 6 62 5 73 9 82 7 93 6 701 4 8-9 11 3 21 5",
    ": 7 35 40 3 6 8 50-1 5 7 68 70 3 6 83 6 92 9 802 6 9 18 21 5 9 32 6 8 42 6 9 51",
    ": 4 60 9 78 80 6 908-9 15 8 27 31 5 7 9 41 7-8 58 61-2 6 73 8 82 5 95-6",
    ": 4005 7 11 5 7 20 3 8 32 41 3 6 8 50 2-4 61-3 6 73 6 84 9 95 8 101 6 12 5-6 9",
    ": 23 6 30 40 3 54 7 9 62 5 9 71 4 7 81 9 98 204 14 7 27 31-2 7 42 5 8 51-2 6 9",
    ": 62 6 72 4-5 7 81 3 5 7 96 303 6 9 17 20-1 4 7 30 3 8 41 6 56 8 64 73 6 9 83 6",
    ": 94 6 402 6 8 11 8 25 7 9 35-6 9 42 5-6 52 5-6 61 4 8 70 3-4 7 80 6 93 9 504 6",
    ": 8 10 3 6 9 21 4-5 32 7-8 46 54 6 61 4 7 70 3 5 91 4 6 603 12 4 8 20 7 30 3-4",
    ": 6 9 41 3 6 53 6 9 65 72 9 85-6 9 92 5 9 707-8 14 8 28-9 32 5 40 3 53 60 4 7",
    ": 75 8 81 3 94 800 2 7-8 10 4 20 9 31 4-5 40 4-7 51 4-5 9 64 6 9-70 81 3 5 7 9",
    ": 94 8 904 6 10 2 4 7 20 2 8 34 9 41 4 6 52 4 8 63 6 9-70 2 9 85 90 2-3 6",
    ": 5002 7 12 4 20 3-4 6-7 30 3 6 9 41 4 7 51 4 60 3 6-7 71 4 81 9 92 5-6 101 4 9",
    ": 18-9 21 9 36-7 42 4 6 9 57 9 62 8-9 73 85 8 90 2 5 200 4 8 11 3 5 9 25 7 30 4",
    ": 41 5-6 9 51 4 8 63-4 6 9 72 4 6 9 82 7 90 2 4 8-9 302 7 10 6 8 21 4 6 9 32 4",
    ": 41 3 5 9 55 60-1 4 8 72 6 83 91 8 412 5-7 21 3 32 4 6 40 2 50 5 8 62 71 4 6 8",
    ": 86 90 4 8 500 4 7 18-9 26 32 5 7 9 44 52 5 9 65 8 71 4 7-9 82 6 8-9 97 602 5",
    ": 9 15-6 8 21 4 7 33 40 7 51 6 61 4 6 71 5 80 7 98 704 9 21 30 5 8 40 3 6 8 50",
    ": 2 5 62 4 8 75 7 80 2 7 92 4 801 3 12 9 28 34 41 3 51 3 8 67 88 92 8 903 13 5",
    ": 22 4-5 9 33 6 41 6 51 4 62 5 7 72 7-8 82 7-8 91 5 9",
    ": 6002 5-7 11 3-4 6 9 22-3 9 32-3 6 9 42 4 8 53 6 62 6 8 73 6 9 84 9 95 7 106 9",
    ": 12 9 22-3 5 31 3-4 41 3 50 4 7 9 62 7 72 5 7 80 8-9 91 4 6 203 16 8 20 2 9 31",
    ": 4-5 8 41 6 50 5-6 8 60 5 72 5 84 7 90 5 9 302 7 9 13 6 8-9 22 35 7 40 54 63 6",
    ": 71 9 82 4 7 9 99 401 4 6-7 10 4 7-8 21 5 7 9 32 6 9 42 6 52 5 66 72 84 7 9 91",
    ": 3 6-7 501 4 7 10 2 4 6 22 9 32 5 41-4 51 6 60 2 72 5 8-9 83 91-2 6 8 601 5 12",
    ": 9 24 32 5 7 40 2 7-8 51-2 5 68 70 7 9 81 6-7 94 702 4 16 8 21 3 6 32 5 48 50",
    ": 4 6-7 9-60 2 8 72 7-8 81 6-7 91 5 8 804 8 11 6 8-9 22 5-6 8 39 43 8-9 53-4",
    ": 66-7 71 3 7 85 91 4 8 902 7 12 20 3 6 9 36 42 8 50 3 6 70 6 9 81 4 7 91-2 6",
    ": 9-7000 3 6 9-10 6 9 21 3 5 8-9 33 40 2 5 7 52 4 65 7-8 71 5 82 4 6 91 4 8 101",
    ": 12 4 7 22 6-7 30 3 5 42 5 8 51-2 5 8 64 6 70 2 81-2 91 7 209-10 4 7 23 8 31 4",
    ": 7 40 3 6 9 53 6 62 6 9 71-2 5 9 82 5-6 92-3 5 9 301 3 6 11 3 7-8 20 2 37 43 9",
    ": 51 62 4 9 72 7-8 82 7 9 93 6 9 402 9 12 20 2 30 7 41 8 52 9 65 71-2 9 82 5-6",
    ": 8 96 501 8 13 6 9 30 5 8 51 3 6 65 8 76-7 80 3 8 91 8 614 20 2 5 7 30 6 41",
    ": 4-5 8 50 4-5 7 60-1 8 72 6 8-9 87 92 702 8 10 9 23 9 31 41-2 5-6 50 4 8 60 6",
    ": 8 70 4 6 87 9 91 4 800 2 7-8 11 3 9-20 2 5 7 42 5 51 5 7 9 61 3 9 72 8-9 81",
    ": 3-4 9 92 7 9 901 6-8 12 6 20 2 5 40 50 5 7 63 9 71 3 9 88 91",
    ": 8000 2 4 7 11 3 8 21 4 7 9-30 4 7 9-40 3 5 8 51 3-4 6 8 60 3 5 7 75 8-9 87-8",
    ": 90 3 9 102 5 9-10 3 6 9-20 3 6-7 30 4 7 41-2 5 7 9 52 5 65 9 73 9 82 5 8 90 5",
    ": 8-9 206 9 12 4 6 21 4 8 32 5 41-2 4 9 51 5 9-60 2-3 6 9 72 4 6 8 81 5 96-7",
    ": 302 5 10 3 20-1 3-4 8 33 6 44-5 50 2 64 6 71 3 86 91-2 5-6 8-9 405 8-9 26 8",
    ": 33-4 40 3-4 7 51 7 60 2-3 7-8 74 80-1 8 93 5-6 8 504 7 9 18 21 4 6-7 32-3",
    ": 45-6 54 63 6 8 76 86 94 9 603 8-9 15 24 7-8 36 42 4 7 9 51 4 6 8 63-4 6 9 72",
    ": 5 9-80 5 8 705 7 12-3 20-2 9-30 5 9 44 6 50 3 8 60 2 7 70 3 8 83 90 9-800 4 9",
    ": 13 6 9 21 3-4 9 33-4 9 41 7 9 51 6 9 63 6-7 70 80 90 5-6 900 3 5 7 10-1 6 9",
    ": 22 5-6 32-4 7 44 6 50 2-3 6-7 60 3 7 71 5 84 6 9 91",
    ": 9001 4 10 2 5 9 22 9 33 6 42 6 50 3 5 71 5 86 90 2 4 6 101 10 3 5 9-20 5 9 32",
    ": 6 8 43-4 9 52 4 7 60 3 7 70 3 5 82 4 90 2 5 7 201 6 9 12 8-9 22 4 8-30 2 4 7",
    ": 41-2 8 51 9 70 81 5 7-8 90-1 4 7 300 3 5 12 6 31 4 6 43 52 4 60 2 6 72 80 4",
    ": 9-90 402 5 7 15-6 26 30 6 40 3 6 50 7 61 4 7 71 5 8 81 5 7 90 500-1 8 10-1 3",
    ": 7-8 22 9 31 5 9 44 9 53 6 60 2 4 74 81 91 7 9 604-5 7 9 11-2 5 8 20 6-7 9 32",
    ": 41 5-6 8 51 4 8 61 5-6 8 71 8 81-2 5 91 3 7 9 702 5 7-8 11 4 21 3-4 8 34 9 41",
    ": 5 9-50 3-4 9 65 8 71 5 8 83-4 7 91 4 7-8 803 5 8-9 11 7 20 9 31 4 6 9 42 8 50",
    ": 4 8 68 70 4 6 80 5 9-90 2 902 4 8 11 6 9 25 30 2 7-8 42 4-5 52 5-6 61 3 9",
    ": 75-7 81 4 8-9 98-9",
    ": 60006 11 4-5 7 21 3 7-8 30 3 47 9 58 60 2 6 74 6 80 4 90 5 7-8 102 4 11 7",
    ": 9-20 2 7-9 32-4 8 40 5 7 9 51 5-6 8-9 62 4 8-9 78 83 9 96 9-200 2 7 10-1 4 6",
    ": 8 22 4 6 9 40-1 5-6 8 51-2 6-7 9 63 5 8 72 4 8 80 7-8 95 300 3-7 9 14 6-7 23",
    ": 5 37-8 42 7 51-2 4-5 62 7-8 76-7 9 81 3 6 9-90 5 405-6 8 12 5 23-5 7 34 40 3",
    ": 5 8-9 58 61 7 75 7 85 8 90 5 515 8 32 8 42 7 50 2-3 5 8 63-4 8 71 82 4 6 91 5",
    ": 9 604 11 4-5 8 23-4 32 5 8 40 4 7 9-50 2-3 5-6 60 5 88 90 2 705 8 13-4 9-20 8",
    ": 30-1 4 43 5 7 51 4-5 8-9 66-7 70 3-4 9 82 98 801 8 14 7 20 2 4 9 31 6-7 9 42",
    ": 4 50 5 7 60 4 8 72 80 4 92 4 6 905 13-4 9 25 8 30 4 9 44 8 51 7 64 7 9 72 5",
    ": 81 4 8 90 3-4",
    ": 1000 10 3 9 28 30 7 9 45 50 2 8 62 4 72 4 8 80 3 8-9 91 8 105 7-8 10 9 23-4 6",
    ": 8-9 32 5-6 9 46 50 3 7 60 3-4 6 70 4 7-8 81 4-5 9 93 5-6 9-200 3 6 8 12 5-6 9",
    ": 24 30 2 4 6-7 9 45 7 51 4-6 8 61-2 4 7 71 5 8 80 6-7 92 5-6 301-2 13 9 22-3 8",
    ": 31 4 7 42 9-50 3 5-6 61 5 9 72 8 81-2 9 91 3-4 403 7 10 3-4 7 21-2 6 31 3 8",
    ": 42-3 6 8 53 6 8 60 3 5 9 72-4 7 80 4 6 8 91 4 9 506 8 10 5-6 8 22 4 6 30 40",
    ": 3-4 6 50 2 61-2 5-6 70 5 9-81 5 8 91 5 7 9 603 7 10-1 4 6 20 7 30 40 6-7 9 57",
    ": 9 61 3 70 4-5 86 92 7 702 13-4 8 21 3 5 7 30 3 6 8 41 6-8 51 5 8 70-1 3 8 80",
    ": 2 6 8 90 4 6 9 802 4 6 10-1 4 6 8 22 5-6 8-9 31 41 51 7 65-6 70 3 6 8 84-5 8",
    ": 91-2 5 7 9 901 4 6-7 9 16 20 3 6-7 31-3 5 8-41 4 6-8 54 6 9 64-5 71 4 6 9-80",
    ": 4-5 90 4 8",
    ": 2000 4 7 9 11 3 5 7 20-1 3 7 9 36-7 41-2 4-5 8 50 6-7 61-2 5-6 70 3 6 9 81 3",
    ": 91 5 9 101-2 8-9 13 7 23-4 33 6 9 46 8 56 62 8 72 5 83 6 8 90 2 6-7 200 6 13",
    ": 5 22-3 6 8-9 32 4 43 50 63 5 70 4 8 87 91 3 5 302 4 7 10-1 4 6 8-9 22 4 8 33",
    ": 6 8-9 46 50-1 7 62 8 72 7-8 81 4 91 406-7 9 12 6-7 21 3 6 8 31 4 7 9 42 8 50",
    ": 3 7 61 3 6 71 3 5 82 8 502 5 7 12 5-6 22 6 9 31 6 45 7-8 50 3 61 4 71 4 84 6",
    ": 92 9 602 11 3 5 7 24 7 37 44 6 50 5 7-8 65 8 70-1 4 80 2-3 8 703 6 15 8 22 32",
    ": 9 44 53 61 77-8 85 9 95-6 9 802 4 7-8 12 8 23 7-8 31 43 6 52 9 62-3 5 75-6 8",
    ": 81 4 6 9-90 4 9 902-3 33 5 8 40 4 6 8 51 4-5 7 9 61 6-7 9 76 8 80 3 5-6 9 94",
    ": 6-7",
    ": 3002 4-5 7 14 6 23 9-30 3 7 44 63-4 72 4 6 82 6-7 9 102 6 10-1 3 5 8 21 7 32",
    ": 7 40 5 8 55 9 61 76 81 5 8-9 91 4-5 9 201-2 5 8 10 3-4 9 21 6 31-2 5 48 53-4",
    ": 6 8-9 67 72-3 5 8-9 82 6 90 6 8 301 5 9 17 9 21 3 6-7 31 4 42 5 7 56 65 7",
    ": 70-2 5 7 9 82-3 8-9 94 7 404 9 17-8 21 3 6-7 32-3 6 9 41 6-7 50 4 6-7 60 2",
    ": 9-70 2 7-8 81-2 4 7 90 3 7 500 6 8 11 4 6-8 20 2 4 6 31 8-9 42-3 51-3 6-7",
    ": 60-1 5-6 9 73 6 8-9 84 6 8 90-1 3 9 601-2 6 9 12-3 6 24 8 31 7 9 44 7 9-50 2",
    ": 5 9 64 8-9 72-3 6 8 89 92 5 8 702 4 6 9 13-4 8 22 7-8 32 42 5 8 50 4 8 60 74",
    ": 8 81 3-4 9 95 800 2 11 3 9 21-3 30 6-7 42-3 9 56 9 62 4 8 70 2 6 81 4 8-9 93",
    ": 6 8 909-10 2 4-5 9 21 4 7-8 33 7-8 40 2-3 5 7 51-2 5 7 61-2 70 3 6 80 8 92-3",
    ": 6",
    ": 4000 2 8 10 3 5 8 21 5 9-31 4 8 40 53 5 61 3 8 70 2 5 8 85 7-8 96-7 9 106 9",
    ": 19 21 3 7 33 5 9 42-3 7 51 3 6 61 5 9 74 6 8 80 2 9 91 3 8-9 208 10 2 4 7-8",
    ": 20 2-3 6 31 4-5 8-9 43 5-6 50 2-3 8 63 71 81 5 7 90 5 7-8 302 8 10-1 5 22 8",
    ": 31 4 8 46 9-50 2 8-9 61 4 9 72 8 83 5 8 90-1 4 408 13 8-9 21 3 5 7 33 6-7 9",
    ": 41 6 8 56 60 3 6-8 72 6 9 83 7 9-90 2 503 7 13 6 9-21 4-5 31-3 41-2 7 51 3 6",
    ": 65 71 6 9 81 3 6 93 6 9 601 4 9 16 9 23 6 36 43-4 51 5 9 61 5 71 3-4 8 80 5 7",
    ": 9 95-6 9 701 10-1 4 7-9 28-31 4-5 8 41 8 50 2 5 7 61 4-5 70 2-5 7 9 81 7 91 7",
    ": 801-2 10 4 6-7 9-20 3 6 9 32 6 9-40 2 4 8 53 5 61 9-70 4 9 88 90 2-3 7-8 901",
    ": 3 5 8-10 4 8 20 9 32 4 7 45 51 4 7 60-1 6 9 73 84 6 8 91 3 6",
    ": 5001 4-5 8 11-2 4 23 6 8-9 33 8 46 8 51-2 6 9 67 70 5 85 7 91-2 8 103 5 8 10",
    ": 2 8-9 22 6 9-30 3 9 42 8 51 7 60 6-7 70 3-4 84 8 90 7 202-3 5 8 11-2 7 9 23 6",
    ": 9 34-5 40 9 51 65 73 6 8 89 92 8 300 2-3 5-6 8 10 2 20 5 39 42 8 52 60 72 4-5",
    ": 7 85 8 91 8-9 401 3 5 7 9 12 7 21 4-5 8 34 6 9-40 5 9 53-4 61-3 7 70-1 9-80 9",
    ": 91-2 5 7 502 13 7-8 22 5-6 31-2 4-5 9-41 4 9 55 9 63 7 76 84-5 90 3 6-7 9 602",
    ": 6-7 10 3 6 21-2 9 32 40 3 8 53 5 7 62 4 7-8 72 5 9-80 94-5 701 3 5 7-8 12",
    ": 9-20 7 30-1 3 5 7 9 43-4 6 51 3 60-1 6 74 9 82 7 90-1 4 7 803-4 8 12 5 21",
    ": 30-2 6 8 40 3 5 7 9 55-6 66 8 73 7-8 81 3 9 92 8-9 901 4 6-7 10 4-5 20 3 6-7",
    ": 31 6 8 41 4 6-7 50-3 6 61 7 9 72 5 9 84 92 8",
    ": 6000 2-3 5 8 10 2 4-5 22 7 33-5 7 41 3-5 53 5 7-8 60 2 4 77 80 5 95 7 100-1",
    ": 3-5 8-9 11 5 7-8 24 7 30 5-6 41 5 7 9-50 3 5 64 9 71 3-4 6 80 4 9 92 6 200",
    ": 4-5 8 11-3 5 8-9 21 4-5 7-8 34 9 41 8-51 7 60-2 5 7 70 3 5-6 9 83-4 7 9 92-3",
    ": 7-8 301-2 8-10 5 8-9 22 5 7 30 2 4-5 7 41 4 9-51 7 60 2-3 71-3 5-6 80-1 5 90",
    ": 4 6 9-400 4-5 9 11-2 4-5 8-9 21 3 5 31 8-42 4-5 8 50 2-3 7 67-8 71 6 9-81 3 5",
    ": 7 91-2 4 7 501 5 9-11 4 6 20 2-3 5-6 9 31 4-5 7 9 43 6 8 51-2 5 8 64-6 8 72 4",
    ": 6-7 80 2-3 5-6 9-90 4-5 9 601 3-4 8 11 4 6-7 9 22 8 30 2 5 9 42 5-6 50-2 5-6",
    ": 8 62-3 8 71 6 84 7 90-1 4 6 9 701 3 5 7-8 11-2 4 6 8 22-3 5 30 8 42 4 7-50 2",
    ": 5 7-9 61 3 5 8-9 75 7 82 5 92 4 6 800-1 4 12 20 3 32 4 6 8 40-1 3 7 56 9-60 3",
    ": 5-6 8-9 72 9 82 5 7 9 91-2 4 6 8 900 4 7-8 10 4 6-8 21 3 5 8 31 5-6 42 4 6 9",
    ": 51-2 4-5 8-60 3 6-8 70-1 3-4 7 9 82 93 8",
    ": 7010 3-4 9 21-2 5-7 31-2 5-7 9 42 5 9 57 62 5-6 70 5 7 81-2 5-6 91 4 6-8",
    ": 100-1 7 9 12-3 6 22 5-6 9 31 6-7 40 2 4 6-8 52 4 61 7 9 71 3-4 6-8 81 3 6 8",
    ": 93 6-7 9 201-2 6-7 9 11 3 25 7 31-2 5 7-8 41 3 5 7-9 51 5 9 62 4-7 75-6 8",
    ": 80-2 5 9 91-2 4-5 7 300-1 3-4 8-9 12 5 8 23 5 8-9 33 5 7-8 42 6 8 51 3-4 7 60",
    ": 4-5 8 70 2 5-7 9 82 6 9 93 7 9-400 5 7 11 4 8 20-1 6-7 30 3-4 6-7 9-41 5 8",
    ": 51-3 7 60-2 6 9 74-5 8-9 82-3 9 92-3 7 9 502 5 10 2 4 6 9 22 5 7 9 31-2 5 7-8",
    ": 44 50-1 3 5 8 60 4-6 9 71 4-5 7 9 81 3 6 9 91-3 5 9 603-4 7 9 13-4 7 23 31-2",
    ": 5 40 3 5 7 9 51 3-4 6 8 60-1 6 8 73 8 80-3 7 92 4 7-8 708 16 8 24-6 31 5 44 8",
    ": 50-1 4-5 8 60 2 4 6 8-9 82 6 8 800 8 11-2 6-7 9 22 5-6 9 32-3 6 46 8 50-1 3 7",
    ": 60 5 8 73-4 7 9 81-2 5-6 8 92 5 7 904-5 7 9 14-5 8 21 4-5 8 30 2 4 7 40 4-5 7",
    ": 50-1 7 9 62-3 7 70 3 6 9-80 3 90 2 4-5 7-8",
    ": 8000 10 6 21 6 34-5 42 6 9-50 2 4 60 71-2 6 9 81 6 8 90 3-4 100 3 6 9-10 9-20",
    ": 4 7 30 2 4 6 40-3 6 53 5 8 60 3 5-6 9 72 5-6 9 81 5-6 8 92 5 8 201 3-5 7 10 2",
    ": 6 8 21-2 6 32 5 8-9 41 7-8 50 2 5 7-8 61 3 6-7 9 73-4 8 80 3 90 2 5-6 8 303 6",
    ": 8 11-2 4 6 23-4 8-9 32 6-7 40-2 6-7 9-50 2 4-5 61 4 6 9-70 4 7-8 80 2-4 8 90",
    ": 6-7 400-1 4 9-10 2 4 6-7 21 31 3 40 3-4 6 50 3 7-8 62 8 72 4 7-8 82-3 5-6",
    ": 90-2 4-5 8 500 3 5-6 10 2 5 9 26 8-9 31 3 8 41 4 8-9 54-5 8 61 5-6 9 72 7-8",
    ": 83-4 6-8 90 3 604 12 6 9 25 34-5 45-7 51 4 65-6 74 6-7 9 81-2 7-8 92 4 9 701",
    ": 4 7-8 10 2-4 7 9 21 7 9 31 6 9-41 4 7-9 52-3 5 7 9 62 4 7 9-70 5 9 81 4 8 90",
    ": 8 804 6 9 12-3 5 8 22-3 6-8 30-3 6 40 56 8 60 4 6 8 70 2-3 6 8-9 88-9 91 4-5",
    ": 903 6-7 10 6 20-1 5-6 9 33 5 8-9 41 3 6 8-9 51 4-5 8-60 2 4 6 71 3-4 8 81-2 4",
    ": 7-8 91 3 5-6 8",
    ": 9001 3 6 10 4 7 22 4 6-7 30 2 4-5 7 9-40 2 9-50 2 4 6 9 64 8-9 73 6-7 80 2",
    ": 5-7 90 3 7 104-5 13-4 21 7 33-4 43 6 50-1 6-7 60 3 70-2 5-6 83 5 7 90 8-9 203",
    ": 5-6 8 12 4-5 7 22 5-6 8 33 8 42 9 52 5-6 8 60 3 7 9 71 5 80-1 91-2 9 302 5 7",
    ": 9 11-2 5-6 23 9 37-8 41 5-6 8-9 52 8 61-3 6-8 73 5 7 80 2 5-6 92-3 5 9 402-5",
    ": 7 9 11 5 7-8 21 8 30 3 43 5 50 5 8 60 8 70 4 7 84 9 92 7-8 501 7 9 11 3 5 20",
    ": 2 6 8-9 35-6 8 40 6 50 5 7 9 65 8-9 72-3 6-7 83 8 93-4 6 600 9 12 6 21-2 7",
    ": 9-30 3 5 7 40-1 5-6 8-9 51 4-6 62 4 6 71 4 7 81 5-6 96-7 9-701 4 7 9 11 3 5",
    ": 20 7-8 33-4 7 9 42 4-7 50-1 6 8 60 2 4 72-3 81 6 9-91 7 800 2 4 9 14 6 8 20",
    ": 2-4 6 8-9 32-5 7 48 50 5 65 7 72 7 80 4 9 91 5 9-901 4 7 11-3 5 8-20 4-5 30",
    ": 8-9 42 7-9 52 6 8-60 5 9 74 7 9-80 91-3 5 7-8",
    ": 70001 3-4 8 16-7 20 4 8 30 2-3 5-6 9 41 3 5-6 8 51 4-6 60 2 4 6 71 3 5 8 80 3",
    ": 9 94-5 8-9 103 5-7 10-1 5 20 2 4-5 30 4 6 9-42 5-7 9 51-2 5 8 61 4 7-8 70 3 8",
    ": 80 2-3 5-7 90 3 7-8 200 3-5 7-8 10-1 5-6 9-20 2 4-5 32-3 7 43 5 7 51 4 7 60-1",
    ": 8 80 3 7 91 5 301 3-5 8-10 3 6 9-20 6 34 7 9 44 6-7 9 51 3-4 7 9 63 7 73-5 81",
    ": 4 9 92 5 7-8 404 7 15-6 8-20 5 9 36 8 45 53-5 9 62 71 80 2 4 6-9 91 5 506-8",
    ": 11 4 6-7 9 22 5-6 8 32 4-5 40 4 52 6 9-60 8-9 71 4-5 7 82 8 93-4 7 602 16 23",
    ": 5 7 9 31 5-6 8 40 3-4 7-8 51 3-4 7 60 4 70 2 5 8-9 82 7-8 90 4 7 702 5 9 12 5",
    ": 21 7 34 41 8-50 2 5-6 8 60-1 3-5 9 72 9-80 3-5 8 92-3 7-8 801-2 7 9 14 7-8 21",
    ": 3 6 8 30 2 4 7 9 46-7 52 60 3 5 8-9 74 7 9-80 2-5 7 9 91 3 7-8 900 4 9 17",
    ": 20-1 5 7-8 35 8 40-1 3 5 7 50-1 4-5 7 61 70 3 8 89-90 2 4 6",
    ": 1002 5 7 9-10 2 4 6 23 31 6 8-40 51 65 7 9-70 3 7-8 81 4-5 9 91 3 5 7-8 101-3",
    ": 5 7-8 12 6 22 5 8 31 5 7-8 44-6 50 3 7 60 2-3 7-8 70 7-82 5 7 91-2 5-6 201 4",
    ": 6 9-11 3 7-8 23 6 9 31 4 6 40 5 56 60 2-3 7 9 71 7 9 81-2 5 90 5-6 8 303 6-7",
    ": 9 14 9 30 2 4-5 7 40 2 4 51 7 60 3 70 5 7 82-3 5-6 9 91-2 5 7-8 400 3 7 10 3",
    ": 8 20 3-4 7 33 6 40 3-4 7 50-1 3 5-6 9 62 5 8 70-2 5 7-8 80 2-3 6-7 90-1 7",
    ": 503-4 9 12-3 8 21 3 31-3 43 63 8 70-1 4 9 84 8 90 4 6 609 16 20-1 4 8 31-2 42",
    ": 5 9 51-2 9 61-2 4-5 8 70 3 6 9-80 4 7 9 91 4 710 8 20 4 31-2 8 40 2-3 5 50-1",
    ": 4 8 61 3-4 8 71-2 4 6 9 81 3 7 91 3 6 8 800 2 9 13 7-8 21 3 8 31 6 9-40 9",
    ": 52-4 8 61 3-4 6 8 73-4 81 3 6 8-9 91 4 7 903 8 11 3 20 5 9 31 3-4 6 8 48 50",
    ": 3-5 9-60 3 6 8-70 2-3 84 6-7 93 5 8",
    ": 2005 10 21-3 31-2 5 40 3 8 51 3 7 61 70-2 5 7 9 81 90 2 4 102-3 8 10-1 3 5 9",
    ": 22 6 30 3 5-6 45 53 62-3 5-6 9 71-3 6 83 5 8 91 5 8 205 7 11 6 8 26 32 4-5 9",
    ": 41-2 4-7 50-1 3 66 72 86 8 90 301 5 9-11 3 5 7-8 23 5 33 6 9 42 5 50 2 6 9-60",
    ": 3 9 73 7 81 91 402 4 6 10 2-3 5 7 9 21 3 5 30 5-6 9 45 9 51 4 66 9 72 8-9 81",
    ": 5 8 92-4 7 501-3 6 8 18-9 21 4-5 32 5-6 8 42 54 63 8-9 73 6 8 82 91 3 6 603-4",
    ": 10 4-5 7 21-2 30 3 6 8-9 44 9 51-2 61-2 9 72 5-8 84 90 8 701-3 8-9 12 6-7 24",
    ": 8 30 2 6 9 43 5 8 50-2 6 65-6 9 73-4 7 80 7 95 7 800-2 12-3 20 7 9 35 7 40 3",
    ": 6 50 7 9-60 5 73 8 82 5 7 9 94 7 9-900 3 6 8-9 11 4 7 20-1 4 6 8-9 32 6 42 8",
    ": 55 9 62 6 8 70 2 4 6 8-9 82 5 7-8",
    ": 99-3000 2 5 9 13-5 23 5 7 9 39 47-8 54 6-7 61 9 72 82 6-7 9 91 4 9 104-5 8",
    ": 10-1 4 21 5 30-1 4-5 8 42 54 6 8 62 5 8 71 4 84 6 94 200 2 5 7 9-11 4 6-7",
    ": 9-20 5 9 32 7 41 3-4 9 51 6 9 62-3 5-6 70 3-4 82 4-6 90 3 6 8 300 4-5 8 14 8",
    ": 24-5 33 5 40-1 7 51 3-4 7-8 63 9-70 2-3 5 88 91 3 6 8 401 3 8 12 4-5 29 31 4",
    ": 7-8 41 5 51-2 6 60 7 70 2-3 7 9 84 6 90 2-4 6-7 500-1 6 8-11 5 23 5-6 32 5-6",
    ": 9 43 7 50-1 5 7 63-4 74-5 9 85 9 91 3 5-6 9 602-3 6 12 9-21 5 31 4-5 7 40 2 6",
    ": 50 4 7-8 61-2 5 9 76-7 80 8 91 3-4 6 8-9 704 9 15 7 9-20 3 30 4 6 8 41 5-6 8",
    ": 50 2 5 7-8 60 5 8 72-3 82 4 90-1 6 800 3 7-8 12 9-20 4 9 32-4 7 40 2 5 7 52 6",
    ": 9-60 2-3 5 9 71 5 9-80 4 95 7 901-4 7-8 11 5 8 26-7 30-1 7 42 6-7 9-50 3 9 66",
    ": 70 2 4 6 8 82-3 5 90 3 8",
    ": 4000 3-4 6 8 10 2 7 21 3 8 30 3 6 8 44 7 50 2-3 5 9 61 8 72-3 5 83 9 92-3 8",
    ": 104 6 10-1 6-7 21 3 8 31 5-7 40 2-3 5-6 53-4 7 61 3 5 9-70 5 7 82 90-2 5-6 8",
    ": 200 3 8-9 12-3 6-7 20 2 4 7 31 3 5 9 43-4 7-8 58-9 64-5 7-8 70-1 3 5-6 80 3",
    ": 6-7 90 4 6 300-3 5 9 14 6 22-3 5-6 32 4 8 40 4 50 5-6 63 5 9-70 7 80-1 4 7 90",
    ": 8-9 402 4 7 10 4-5 7 9 29 36 8 41-2 6 50-1 3 6 8 62 5 70-2 6 9 82-3 5-7 93 6",
    ": 502 4 6-7 10 2 6-7 20 3 7 31-2 5 40 3 5-7 51 9-60 2-3 6-7 70-1 80 5 8 90 4 7",
    ": 601-2 4-5 7 10 7-8 20 2 7 9 32 7-8 40-1 4-6 9 52-4 7 9-61 5 70 3-4 6 80 2-3 9",
    ": 91-2 7-9 701-2 7 9-10 8 20 2 5 30 4-5 9 41 5 7-8 54 7 63 7 70 4 84 93-4 6-8",
    ": 800 2 4 11 3 7 9 21 3-4 6 31-2 4 6 9 42 4-5 8 53-5 67 70 4-6 9 81 3-4 90 3-4",
    ": 6-7 9 902 4-5 8 15-6 8-9 22-3 6 8-30 3 5-7 40-2 7 51 3-4 7 60 4 6 8 70-1 4 6",
    ": 8-9 81 4 6 8-9 91 4-5 8",
    ": 5013 5 7 9 22 4-5 9 33 6 9 48 55 65 8 71 7 9-80 90 4 8 102 4 7 9 13 5-6 8-9",
    ": 23-4 6-8 30-1 3-4 8 42-3 6-7 50-2 5 9 61-2 5-6 9 71 8-9 81-3 7 9 91 9 203 5-6",
    ": 8-9 15 7 20-1 5 9 35 8-9 42-3 50-1 4 7 9 69 74 6 80 2 91 6 300 2-3 10 3 5 7",
    ": 20 2 6 31 5 7-8 40 4 7 52 5-6 63 8 71-2 6 8 80-1 3 5-6 8 91 4 400 3-4 6 9 12",
    ": 7-8 21-2 4-5 9 31 6-7 40-1 4 50 2 7 61 3 8 71 5 8 80-1 3 7 91 3 7-8 500 5 8-9",
    ": 12-3 6-7 9-20 2 5 9-30 2-3 5-6 40 3 5 7 55 9 66 9 71 3-4 8 80 4-6 91 6 8",
    ": 600-1 3 5 7-9 12 4 9 22 6 9-30 2 7 42 7 9 53 5-6 60-1 4-5 70 4 80 8 91 7 700",
    ": 2 7 9 14 8 20-1 3 6-7 9 35 7 9 41 3 6-7 50-1 3 6 60 4 70-1 9 82 6 8-9 91 804",
    ": 6 10 6-7 20 4 9 32-3 6-7 41-2 4 6 50 3 6 60 2-4 6 71 4 8 83 94-5 7-8 900 3",
    ": 5-6 11-2 4-5 23 6-7 31 3 7-8 40-1 4 7 52 5-6 63 5 7-8 70-1 3 6 8-9 82 4 7-8",
    ": 91-2 5-6 8",
    ": 6001 3 5 8 14 6 21 5-6 30-1 5 9 41 5-6 54 6 60 5-6 8 71-2 6 8-9 83 6 9 91 4-5",
    ": 7-8 107 9 12 5-6 20 3 5 9-31 3 8 45 9-50 5-6 8 61 5 9 73 5 7 80-1 5 8-90 3 5",
    ": 200-1 3 5 9 11-2 4-5 7 9 21 3 5 8-30 2-4 6 8 40 4-5 51 3-4 7 9-60 4-5 7 9 73",
    ": 80 3 6 8 90 2 4 302 5-6 9 12 5 7-8 23 6-7 30-1 3 5 7 48-9 52 8 60 6 70 2 5 8",
    ": 81 4-5 9 92 4 6 8 402 4-7 11-2 8-9 21 9 32 6 42 6 52 4 6-8 61 3 71 4-5 7-8 81",
    ": 3 5 7 9-91 5 8 503-6 8-9 11-2 4 8-9 21 3 7 9 35-6 8-9 44 6-8 54 63-5 8-9 71-2",
    ": 7 80 2-4 8 90-1 3 9 602 4-5 7-8 11-2 4-5 8 22-3 7 30 2 6 8 41 5-6 8 54 7 66",
    ": 71-2 81 6 92-3 700 3 5 7 11 22-3 5 9 31 5 7-8 42-3 7-8 50-1 3 5 7 63 8 70-1 3",
    ": 8 81 5-6 92-3 8 800-1 3-4 6 8-11 4 20 5-6 8-9 31 3 7-8 43 9 51 4 6 9-60 2 6",
    ": 72-3 7-8 83-4 9 91 5 7-8 901-2 6-7 9 13 21 5-6 9 34 44-5 8 51-2 4 8 61 3 6",
    ": 9-71 5 8 80 2-3 9 91-2 4-5",
    ": 7001 3-4 6 8 11-4 6-8 24 7 30-1 3 7 9 41 3-5 7 50-1 4 9-60 3 5-6 9 74 6 8 82",
    ": 5 9-90 5 100-1 3 5 10-1 6-8 22 32 6 42 5 8 50 3 7 9-60 2 6 8 71 4 6 9 83-4",
    ": 6-7 90-1 3-4 8 200 2 5 7 11 7 20 2-3 30 2 4-6 40-1 5 50 3 60 7 9-70 7 82 5-7",
    ": 9 92 6 8 302 5-6 8 12-4 6 9 21 4-5 9 32 6 40 3 6 50-1 3 7 62 8 71 5-6 81-2 4",
    ": 6 8-9 95 402 5 7 11 3 6 20 3 7 36 8 41-3 7 9 51 3 6-7 63-4 70 6-7 9 87 90 3-4",
    ": 6-7 503 5 8 13-4 6 23-4 6-7 9 31 3 6 8 41 3-4 8-9 51 5 7 60 2 4 6 70 4 9 81-2",
    ": 5 7 90 3-4 8 603-4 6-7 9 12 7-8 24 6 30 4 8-9 45 8-9 54-5 9 61 3 8-9 72-3 6",
    ": 8-9 82 92 5 8 703 5-6 8 11 7 21 30-1 8 47 9 51 6 60 4 7 9 74 80-1 4 6 9 91 4",
    ": 6 9 801 9 17 9-20 4-5 8 31-2 5 9 42 8 50 9 61 4 9 73-4 9 82 9-90 3 5-6 8 900",
    ": 2-3 5 8 12-3 6-7 21 6 9 37 41 4 6 8 51 5 61 4 72 4 80 3 5 9 91 3-4 7-8",
    ": 8001 3 7 9 12-3 5-6 9-20 3-4 6 32 6-7 40 2 6 9 51 4-6 9-60 6 9 71 6 9 83 5 8",
    ": 97-8 101 7 10 3 6 8 21 30 3 8 40 3 6 52 5 7-8 63 7 71 6 80 5 8 90 2 5 9-201",
    ": 4-6 9 11 5 8 21 4-5 7 33-4 7 9 42-3 5 51-3 6 9 63-4 7 71 3-4 6 81 8 91 4 9",
    ": 301 5 8-9 21 5 33 9 43 6-7 51 3-4 7 61 71-3 86 9-90 3 5 400 2 4-5 7 12 5-6 22",
    ": 4 6 8 30-1 8-9 41 6 9 51 3-4 7 60 2 4 71 9 84-7 97 9 501 3 6 8-9 12-3 7 22 5",
    ": 7 35 41 3 7-8 51-2 4-5 7 62 6-7 74 7 9-80 8 92 7 601 3 10-1 7 28 30 3 6 9-40",
    ": 4 7-9 54 8-9 61 4 6 9 77 83 5 9 91 5-6 703 6 8 10 4 7-8 23 31 8-9 42-3 7-8 53",
    ": 5 8-9 62 4 7 9 72-3 6 81-3 5 90-1 5 7 9-800 3 10-1 4 7 23 6-7 32 7-8 40-1 5-6",
    ": 8 55 9 63-4 7 71 3 83 7-8 94 903 5-6 10 3 5 7 21 4 8 30 4 8 40 3 7 51 5 9 61",
    ": 3 7-8 73 6 80 6-7 90-1 3-4 9",
    ": 9005-6 12-4 20 3 8 30 2 6 42 51-3 5 7-8 60 2-3 5 7-8 75 82-3 7 9 91 4 101 3 5",
    ": 15 23 7 37-8 41 4 7 9 51 5 7 9 62 70 4 6 81 6 8 92 4 7 203-4 6 9-10 3-4 8 23",
    ": 5 33 5 8 41-2 6 8-50 4 8 61 8 70 2-3 83 5-6 90 4-6 301-2 4 7 11 3 7 9 21 3 5",
    ": 8 30 2 5 8 43 51 3 7-8 60 4-5 8 78-9 83 5 7-8 91 3 9 402-3 14 6-7 9 21 4 8 33",
    ": 8 42-3 6-7 50 3 8 74 80 3-4 8-9 92 5 7 503 6 12 20 7-8 33 5 7-8 40 2 9 56-7",
    ": 62 5 9 75 8 81 6 90 2-3 6-8 601 6-7 11 4 6 8-9 21-2 5 31 5 7 9-42 4 9 54 6",
    ": 8-9 62 5 9-70 4 6 8-9 81 8 90-1 4-6 9-700 9-10 5 7 25 34 45-7 51 5 61 8 71-2",
    ": 6-7 80 7-8 94 7 801 5 7 11-2 5-6 8 20-1 3 7 31-2 9 42-3 50 4 6-7 62 4 9 73",
    ": 5-6 80 4 7 94 7-9 905 8 10 5-6 8 20 4-5 8 32 42 6-7 50 2 4 6 61 3 5 9 71 3-4",
    ": 7-8 82 7 9 93",
    ": 80003 6-7 9 13 5 20 3 9 32 5 41 5 7 52 5-7 60 8-9 72-3 5 8 80 8 90 3 9 105-6",
    ": 8 10 7 9 24 9 35 7 9 44 50 3 8-9 61 3-4 70-1 3 5 8-9 84 7-8 92-3 5 200 3 11",
    ": 4-5 7 23 6 32 4 6 8 42-3 54 66 70 2-3 8 81 6 9-90 3-5 7-8 303 5 7 10 5 21-2",
    ": 4-5 8-9 33 5 44 6 8 50 3 5 8-9 61 73 6 8 85 94 6 8-400 11-2 5 7-8 22 32 40 7",
    ": 50 2 6 9-60 3 7 72 6 80 2 4 9 91 5 7-8 504 6 14-5 20-1 4-5 8 32 40 3 5 8-9 51",
    ": 4 6 8-9 67 70-1 3 86-7 90 4 9 602 12 6-8 21 3 5 36 9 42 6 54 7 61 4-5 7 71 4",
    ": 6 8-9 82 4 6 96 8-9 702-3 6 10 4-5 8-9 22-3 7 30 3 5 7 41-2 5 8 54 7 60-1 4 9",
    ": 71 5 80 2 4 8 94 8 802 8 11 5-6 20 3 5 7-8 31 3 5 43 6 60-1 7 9 75 8 80 3 5",
    ": 90-1 3 900 3-4 6 10 3 5 8 21 3 5-6 32-3 5 9 42-3 5-6 9 60-1 4 70-1 5 83 5",
    ": 95-6 9",
    ": 1002 4 8 10 9 21-2 7 33 5 9 41 4 9-50 3-4 9 64-5 9 71 3 5 7-8 80 2 4 7 90 7",
    ": 9-101 4-6 11 6 24 8-30 3 9 44 6 8-9 57 71 4-5 7 80 6 8 201 6-7 9 12-4 7-8 20",
    ": 3-4 6 33 41 3 7-8 50-1 4-5 7 60 2 8 78 83-4 8-9 92 4 6 9-300 3 5-6 10 2-3 5-6",
    ": 8 21 4-5 7 30 2 9 41-2 4 50 5 8 60 5 8 72 6 8 82 6 94 7-8 406 8 14 20 3-4 31",
    ": 8-9 57 60 4 6 71 4 9 81-2 5 7 90-1 6-7 503 6 10 3-4 27 9 39 43 7 50 3-4 9 62",
    ": 6 73-4 7 87 91 7 9-600 9-10 3-4 6 9 21 3-4 7 9 32-3 5-6 9 42 51 6 63 5 72 5",
    ": 81 8 91 3 7 701 5 7 10-1 9-20 3 9 32-3 6 41-2 7 51 3 6 60 2 4 7 9 73 7-9 81 8",
    ": 90 2 5 8-9 802 4 6 12 4 6 9 22 5-6 9 33 6 47 50 60 4 8-9 77 9 81 3 7 9-90 4 8",
    ": 901 4 9 15-6 23 5-6 9 32 4 9 41 8 51 6-7 64 7-8 70 3-4 87 91 8",
    ": 2003-4 8 11 3 7-20 2 30 4 40 2 51 7 61 4 71-2 7-8 80 2-3 90 7 9 103-4 16-7",
    ": 26-7 30 3 6 8 41 4 7 9 52 61 6 77 80-1 3 6 91 4-5 8 205-6 10 7-8 22 7 32 5-6",
    ": 8 40 5 7 9 51 4 7 63 7 79 82 4 7 90 4 7 300 2 6-7 10-1 4-5 25 30 2 4-5 8-9",
    ": 43-5 8 50-1 62 4-5 70-2 9 81 5 94-5 7 402 11 4-5 9-20 3 5 9 32-3 5 7 40-1 6 9",
    ": 51-2 6 8 60 3 5 72-3 8 83-4 6 9 500 3 6 8 12 4-6 9 26 8 33 6 9 44 6-7 9 54",
    ": 6-7 65 8 75 80 5 7 96 9 601 3 10-1 3-4 8-9 22-3 9-30 2 5 42 4 9-50 2 4-5 66-7",
    ": 71 5 8 84 6 91 5 7 701 4 12 6 22 4 8 30 4 6 8 43 6 50 4-6 9-60 3 5 70 3 7-8",
    ": 80 2 4 6 8-9 93-4 8 800-1 7 9 12 5 8 21 3 5 9 31 6 40 2 8 56 9 64 7 9 73 5 7",
    ": 82 4 7 9 94 6-7 9 902 5-6 10 2 7 20-1 3 5 8 30 5 7-9 44 8-9 52 60 2-3 6 9 73",
    ": 5-6 8-9 85 7 90-1 3-4 6 9",
    ": 3004 8-9 11-2 5-6 23-5 32 4 41 5 9 55-7 60 2-3 5 73 8 80 2 5 8 93-4 100 9",
    ": 13-4 8 20 3-4 6 30 3 6 8 43 6 8 53-4 7-8 64 6 72 5 7-8 87-8 90 4-7 200 5 7 11",
    ": 5 8 21 31 3-4 6-7 41 5 7-8 52 5-7 9 61 6 9 73 5-6 80 3-5 9-91 6 8 302 6-7 17",
    ": 20 3 5 7 34 7 41 7 53 7 62 5 7-8 70 2-3 6 80 3-4 8 90 2 4-5 401 3 5 12-3 6 22",
    ": 34 40-1 6-7 54 60 3-4 8 71 5 80-1 8-9 95 8 501-2 6 10 3 27 31 4 6 43 7-50 8",
    ": 60 6 72 7-8 80 3 5-7 92 6 9 604 7-8 10-1 7-9 26 9 33 5-6 9 42 4 6 51-4 6-8 61",
    ": 4 7-8 70 80 3 6 8 91 3 5 7 700 3 9 14 6 24 30 4 7 40 2 5-6 52 4 7 61-2 5-6 8",
    ": 72 4 7 82 90-1 5 9 802 8-9 12 4 9 24 7 32 8 41 8-9 52-3 5 9 67 9 73 6 9 85 7",
    ": 95-6 9-900 5 9 16 20 4 6 8-9 32 4-5 7-8 42 53 5 7 60 5 7-70 2-3 85-6 8-9 91 8",
    ": 4001-4 6-9 14 7 9 22 5 9-30 3-5 40 2 4 7 9-50 2 7 9-61 7-8 71 4-5 80 2 7-8 90",
    ": 2 4-5 7 9 102-4 6 12 5-6 8 21 6 30 3 5 43 8 55 8-9 61-2 5 8 72 4-5 7-8 85 8",
    ": 91-2 4 7 200 2-3 6-7 9 11 4-6 20 6 31-2 5-6 9 42 6 9 58-9 61-2 4 6 73 7 9 82",
    ": 4 91 5 301 5 8-9 11 3 7 25 8-9 33 9-40 2 5 50 2 9-60 3 8 71-3 5 7 88 90 2-5",
    ": 400 5-6 8 10 6-8 22-3 6 33 9 42 7 9-50 2 5-7 60 2-3 6-7 71 4 8 80 6-8 90 4 9",
    ": 504 6-7 9 12 4 22-3 5 32 40 4-5 50 4 67 75-6 8 80 4 90 6-7 605 8 10-1 6-7",
    ": 20-3 6 9 39-42 9 51 5 62 4-5 7-8 71 3 7 85 9 92-3 5-6 9 703 6 9-11 4-7 20 2 6",
    ": 9-30 3-5 41 7-8 50-1 6 61-2 72-4 7-8 83 6-7 90-3 6-7 9 802 4 6-8 10-1 5-7",
    ": 9-20 2 5 31 3 5 7 9 42 4 6 9 57-8 67 72-4 7 83-4 8-9 96 9 902 5 7 9 12 4 6 9",
    ": 23 33 44 6-7 52 8 61 3 5-7 72-3 82 5-7 9 92 4 6 8",
    ": 5001 3-4 10 4-7 20 4 30 7 40 2 4 7 9 57-8 66-7 70 2-3 6-7 82 4 7 91 3-4 6-7",
    ": 9-100 2-3 7-8 11 4-5 9-21 4 6 32 8 46-7 50 8 60 3 5 7 9 71 3 5 7 9 81 3-4 7-8",
    ": 94 6 9-200 4 8-10 3 5 7 23 36 41 3-6 8 50 2-5 8 62 4 8 70 2-3 6 8-80 8 96 8-9",
    ": 304-6 9 11-2 7-8 22 30 4 6-7 9 43 5 8 50 4 7 9 61-2 4-6 9 73 5 8-9 81 3-4 91",
    ": 6-7 408 16 8 20-1 3 7 9 33 6 8 42 7 53-4 8 63-4 8 71 8 83 5 7-8 90 3 5 8 502",
    ": 6 8 12-3 7 9 22 5 9 34 6 8 41 3-4 7-8 53 5-6 9-60 3-4 70 4 6 83 6 91-2 7-9",
    ": 603 6-7 10 3 5-6 9 24 7 9 32 4 6 8 40 2 4 53 5 8 61 4-5 70 5 8 82 4 6 91 4-5",
    ": 707-8 11 8 23 5 7 9 32 8 40 5 51-2 62 8-9 73 5 7 81 4-5 7 92 7 802 5 7-8 11-3",
    ": 5 9 24 9-31 3-4 40 3-4 7-8 51 3 60 3 70 5-6 9 83 5-6 8 90-1 9 908 10 2 8 20 8",
    ": 31-2 9-40 3-4 8 50 5 7 9 65-6 9-70 4-5 80-1 3-4 6 8-9 97",
    ": 6005-6 8 10 2 7 9-21 4 8 30 2 5 9-40 2-4 6 54 6 9-60 3-4 6 70 6 81 3 7 93-5",
    ": 102 4 8 12 23 5-6 8 30 4-5 8-9 42 4-5 7-8 51 8 61 3 5-6 73-4 8 80-1 4-5 8-9",
    ": 91 3-5 7 201 3 7 9 11 3 5 7 9-20 4 8 32-3 8 42 4 6 8-9 54-6 9 64-6 9 72-4 7 9",
    ": 85 8 90 2-3 5 7 300-1 3 6-7 13-5 7 9 21 4-5 9 32 6-7 41-2 4 9 52 4 7-9 62 5",
    ": 71 3-4 7-8 84-5 9 92 401 3 11 6-7 21 5-7 32 4 6-7 42 5-6 51 6-7 60 4-5 73-4 7",
    ": 82-3 5 9 94 8-9 503 5 11-2 4 6 8 20 2 5 7 31-2 5 7 41-2 5 8-9 54 8 62 8 76 8",
    ": 82-3 5 8 92-3 9 602 5 12-3 21 6-7 31 6 8 44 7 52 4 6 60 70 4 9 89 94 703 6 9",
    ": 11 8-9 22 4-5 8 31 7 40 2-4 9 51-2 4 9 64-5 71 4 8 80-2 5 7-9 97 807 23 30",
    ": 3-5 8 45 8 51 7 60 2 5-6 70-1 4 8 96-8 900 8 10 2 5-6 9 22 7 30 43 5 9 52 8",
    ": 60 2 4 8 76-7 83 5 7-8 94",
    ": 7001-2 6 8 17 23 5 7 30-1 5 7 53 8 60 2 5 71 82 9 93 8 101 5 13 5 8-9 25 7 30",
    ": 2 4 46 8-9 51-3 8 61 8 79 89-90 3 5 202 6 9 13 5 20 6-7 33 5 7 9 41 3 52 4 6",
    ": 8 61 4 6 8 72 4 81 5 91 8 302 13 23-4 8 32 4 41 7 54 6 60 7-8 72-3 7 83 8 92",
    ": 6-7 410 2 8 23 5 9 33 5 41-2 4 9 53 5 60 2 4 6 71 6 82-3 8-9 91 6 500-1 3-4",
    ": 13 5-6 20 8 31 4 7 9 44 6 53 5 9 61 8 71 6 80 8 95 7 600-1 3 6 8 16 21 3 7 30",
    ": 2 5 41 4-5 7-8 53 5 62 4 9 77 9 83-5 8 700 3 5 11 4-5 8 21 4 33 6 40 6 50 3",
    ": 5-7 9 72 6 9 81 3 91 5 7 800-1 5 9 11-2 8 20 2 9 31 5 7 45-6 8 52 4-5 8 61 5",
    ": 9 71-2 9 83 5-6 9 91 4 6 9-900 7 12 6 8 20-2 4 32 4-5 9 42 7 51-2 8 62 7 70 4",
    ": 8 80 8-9 92 5-6",
    ": 9-8000 3 8 14 8-20 2-3 6-7 30 2 6 40 3-4 50 2 7 9 63 7 9-70 2 5 8 81 3 6 90",
    ": 6-7 105-6 8 15-6 8-9 22-3 6-7 30 2 4-5 41 5 7 52 6 62 4 6 8 79 92 202 4 14-5",
    ": 9 23 6 9-30 5 7 9 41 4-5 7 51 5 7-8 60-1 8 70 3 9 81-3 94 9 301 6 9 12 26 8",
    ": 33 6 41-3 5 50 2 9 62 7 72 6 9 85 8 94 6 9 401 4-5 10 4 23 5 7-8 33 7 40 6 51",
    ": 4 60 3 5 7 9 71 4 8-9 81 3 6 91 3 6-8 505 7 11 4-5 7 30-2 7 43-4 7-8 52-3 6",
    ": 65 70-1 3 7 80 8 91 3 5 7 601-3 7 10 22 6-7 9 31 3-4 7 41-2 5 50 4 8-9 66-7",
    ": 75 82 8 91 6-7 700-1 5 7 10 4 6 8 21 4 6-7 31 3 8 40 4 7 9-50 4 9 71 3 5 80-1",
    ": 4-5 8-9 94-6 800 2 7 13-5 9 21-2 4 9 36 42 8 51 4 7 64 8 73 80-1 3 7 9 98 900",
    ": 2 5 8 11 3 8 23 6-7 9 32 6 42 59 61 6 70 7-8 82-3 7 90 2 5-6",
    ": 9-9000 4-5 8 11 7 20 5 7 35-6 8 40 5 8 67 71 5-6 8 91 7-8 101 11-2 5 9 26 39",
    ": 41 5-6 9 52 8 60-1 4 8 70 2 6 82 5-6 8 96 201 8 13 22 4 6 32 6 8 40 3 6 54 6",
    ": 9 61 3 70 3 6 81 3 90 4 7 304 6 9-10 4 6 30 2 4-6 8 43 7 50-1 3 5-8 60 2 4 8",
    ": 72 4 9 83 6-8 98 403 5 10 4 6-7 9 21 4 30 2-5 9 49-50 61 4-5 71 4 8 81 4 7 91",
    ": 4 7 9 506 9 15 20 3 31 6-7 41 4 50 8 60 7 70 4-5 8 81 3-4 7 93 5 8 602 4 6",
    ": 8-9 12 8 26 30 4 8 41 6 8-9 52 6 62 8 70 3 81 8 92 5-6 9 701 6 8 11 3 9-20 7",
    ": 30 44 6 8 54-6 8 61 3-4 7 76 83 6 91 5-6 800 2 6 9 12 4 6 9 22 30 3 8 42 8 54",
    ": 9 69 78 81 3 6 8-9 91 3-4 900 2 6-8 11 5-6 8 25 34-5 9-40 3-4 6 8 55-6 8 60 4",
    ": 6 9 71 4 7 81 8-9 92-3",
    ": 90001 3-4 8-9 14-5 20 3 7 9 36-9 43-4 6-7 58-9 61-2 4-5 9 73 5 7 9 81-2 7",
    ": 9-90 3-4 7 101-4 9 11 4 9-21 5-6 8 33 5 45 50 3 8 62-3 70 5 8 80 2 4-5 91 4-5",
    ": 8 201 13 8 25 9 32 4 42 5 8-9 51 4 7 9 63-4 6 9 71-2 4-7 81 7 9-90 3 5 7 300",
    ": 3 6 9 11 5 7-9 22 9 31 3 40 5 8 51 5 62 72-4 8 82 6-7 91 5 404 8 10 6 20 4 8",
    ": 35 7-8 41 6 9 58 60 5 70 2 4 86-9 91 7 500 5-6 9 11 9 21 4-5 7 9 34 44 8 52 6",
    ": 8-9 65 72-3 82 5 8 95 7 600 3 8 14 7-8 25 8 30 40-2 5 7 9 51 6 60 3 7 70-1 8",
    ": 80 2 92 5 8-9 701 10-1 3-4 8-9 26 36 40-1 5 50-1 6-7 64 6-7 9-72 8 80 3-4 6",
    ": 91 3 7 803-4 8-9 11 7-8 21-2 5 31 3 6 9-40 6-7 53 5 8 65-7 71 9 81 4 92-3 6 8",
    ": 900 4 7 9-10 5 7 22 30-1 5-6 9 41 6 55 8-61 3 5 7 9 77 80 4 91 3 6",
    ": 1002 13 9 26-7 31-2 9 41 5-7 51 3 60 3 72-3 6 9-80 91-2 4-5 7 103 7 9 16 24",
    ": 30 4-5 8-9 42 5 50 5-6 64 6 75 80 6 8 95 202 7 15 9-20 2 6 31 50-1 5-6 8 67-8",
    ": 72 6 81 7 9-91 5-6 300 3 19 24-5 8 30 4 6 43-5 8-9 56 62 6 73 5 8 83 90 7 403",
    ": 7-8 25-6 30-1 4 43 7-8 50-1 3 9-60 2 4 70-1 4 6-7 81 5 90 6-7 9 501-2 5-7 11",
    ": 5 7 9 22-4 6 31 7-8 46 55 8 65-7 70-1 7 84 91 3 601 4-7 9 11 6 24 6-7 9 32",
    ": 4-5 40 2 4-5 9 52 7 9 61 6 70 2 6-7 9-80 3 6 9 92-3 6 700-1 4 10 5 7-8 23-4 6",
    ": 32 6 41 4-5 8 52 8 60 2 4 6 8 72 5-6 9-80 3 9 91-3 5 8 800 3 9 11 7 9 22-3 32",
    ": 5 7 48-52 6 60-2 7 72 6 8 83 5 9 94-5 7 902 6-7 17 9-20 3 5 9 33-5 40 2 7 58",
    ": 67 9 80 2 6 9-90 5-6 9",
    ": 2002-3 7-9 12 4 6 22 6-7 31 5 7 40 4 8 50-1 5-7 62 6-8 74-5 85 7 92 8 106 8",
    ": 11 6 24 40 4 7 50 2-3 5 60 3-4 70 5-6 83 90 2 4 8 203-4 8-9 11 6 21 7 44 6 9",
    ": 54 6 63 7 71 3 5 8 81 4-5 8 92-3 6 8 305 7 11 4 22 4 34 48 55 60-1 5-6 9 75 8",
    ": 81 5 8 90 2 4 404 6 10-1 4-5 20 2 4 8 33-4 6-8 41 8 53 61 4 8 70 6-7 85 92 5",
    ": 8-9 503-5 8 16 8 21 5 31 3 8-9 41 3 7-8 51 3 8 61 6-7 70 4 92 5-6 604 6 8 10",
    ": 2 4-5 9 24 9-30 3 6 43-4 7 54 6 9 62-3 70 5-6 81 90 4 8 700 2-3 12 30 3 8-9",
    ": 44 54 62 71 85-6 8 94 802-3 10-1 5 9 22 34 8 40 2-3 6 53 5 7-9 62-3 7 70-1 4",
    ": 80 6-7 92 6 903 17 9 22 9-30 3 7-8 41 9 53 5 7 9-60 4 71 4 8-9 81 6-7 94 7 9",
    ": 3002 7 11 4 21 4-5 9 34 8 44 7 50 6 63 6 75 84 9 91 4 8 102 4 11 6 21 7 31 43",
    ": 9 64 74 7 83 91 5 8 200 5 7-8 15 24 7 32 5-6 40 4 6 9 53 6 9-60 2 5-6 72-3 6",
    ": 81-2 5 7 92 300-1 13 8 23 30 9 41 54 8 65 7 76 9 90 3-4 402 6-7 11-2 4 6 23 7",
    ": 32 4 9 52 4 9-60 3 7 9 74 7 9 82 4 97-8 503 13 9 21 3 8 32 5 7 9 42 9 54 8 63",
    ": 6 8 70 4-5 9 85 8 91 600 2 4-5 9 12 7-8 21 4 31 45 8 50 5 60 4-5 7 72 80 3 92",
    ": 7-8 701 4-5 11-2 4 8 20 2 9 33-4 40 2 5 7-8 52 63 5 9 82 6 9 92 8 805 9 11 8",
    ": 21 3 34-5 9 42 5 50 4 8 62 7 71-2 6 9 84 90-1 4 9 904 8-9 19 23 34 7 45 50-1",
    ": 5 8 60 5 71-2 5 7 9 82 98",
    ": 4001 5-6 11 5 7 21 3 6 30 9 41-2 5-6 50-1 6 61 4 70-1 5 83 5 7 94 6 8-9 102",
    ": 6-7 11 4 9 28-30 2 4 6 41 5 8 51 5-6 61 4 6 8-9 72 5 7 81 4 9 93 8 202 7 9 11",
    ": 4 6 8 21-2 30 5 9 48 54-5 9 64 6-7 70 4 6 8 85-6 90-1 5-6 9 316 9 21 30 2 5",
    ": 40 6 8 54 8 63-4 7-8 71 3 82-3 7-8 91 402 6 8 11 9-20 6 30 44 6 51 4 9-60 2",
    ": 4-5 7 73 6 82 4-5 93 6-7 500 3 25 7 30 6 49 54 9 63 7 73-6 84 9 91 5-6 601",
    ": 3-4 7 11 3 5 9 21 6-8 32-3 7 40 3 7 9 51 3 6 8 62 7 70 2 5 88 90-1 4 702 6 10",
    ": 6 9-20 3 5-6 9 33 5 45 50 5 61 5 70 3-4 8 83 9 93 7 9 803-4 8 10 5 7 21 9 32",
    ": 4 6 41 53 9 65-6 71-2 4 7 9 81 4 9 96 9 903 7 9 12-3 7 24 9 33 42 5 7 9-50 5",
    ": 7 65 70 4 7 81 8 91-2",
    ": 5000-1 3 10 5 8 21 4-5 9 43 5 9 53-4 9 61 6 8-9 72-3 5 83 7 90 5-6 8 100 8-10",
    ": 2 5 7-8 20 5 9 33-4 40 2 4 6 50 5 8 61 4 6 8 76 80 3 8 90 8 204 9 19 24 8-9",
    ": 31 5 9 44 6-7 51 61 3 8-9 74 6 80 4 90 5-6 301 3 7 12 4 6 8 22 6 36 42 5 51 4",
    ": 67-8 74 84 6 91 4-5 400 7 12 5 8 21-2 8 33-4 8-9 45 54 7 62 4 8-9 72 9 81 6",
    ": 90 4 6 9-500 8-9 17 20 4-5 9 35 8 43 5 50 6 65 8 72 4 7-8 83 90-1 5-6 604 7-8",
    ": 11-2 4 8 24 6 8 32 40 7 52 63 5 7 71 4 9-80 2 4 8-9 92 4 6 8 705 11 5-6 23 6",
    ": 31 3 9 41 6 8-9 52-3 7 9 63 5 7 70 4 9 84 91 6 9 806 9 13 6-7 22 7 35-6 41 3",
    ": 54 6 9 61 3 70 3-4 89 93 8 904 6 10 5 8 27 9 33 40 3 9 51 6-7 66 74 83 8 93-4",
    ": 9",
    ": 6004 7-8 27 31 6 41 9 53 5 8 66 70 2 7 82 92 6 101 3 5 9 14-5 8 20 3 8 32 7 9",
    ": 43 8 53-4 9-60 2 71 6 8 83-4 6 90 2 4-5 9 205 8 12 4 7 9 26-7 33 46 50 6 64 7",
    ": 72 9 83-4 9 94-5 302 6 12 5 9 21 4 35 9 44-5 8 51 4 60 5 83 9 94 9 403-4 8 12",
    ": 7-8 27 34 7 9 41 4-5 9 55 8 60-1 9 71 3 7 93 5 7 500 2 9 14 9 27-8 31 3 6 40",
    ": 3-4 8-9 52 8 71 4-5 7 81 8 92 6 8 601 9-10 2 8 21 4 7 9 33-4 40-1 7 54 64 8",
    ": 70 2 8 80 5-7 95 9 703 5 7 14-5 8-9 23 6-7 9 32 7 41-2 6 50 7 61-2 6 74 9 81",
    ": 5 8 91 3 6 9 802 5 7 12 4 7 9 21-2 4 8 35-6 9 41 3 5 9 55 7 9-60 3-4 9 71-3 5",
    ": 7 80 3 5 8 91 5 901 4 21 4 8-9 33-4 41-2 7 51 8 68-9 73 7 80 2 5-6 9 91 3",
    ": 7000 4 9 11 3 5 21 3-4 7 32 6 8-9 44 53 5 62 6 72-3 6 8 81-2 7 96 104 6-7",
    ": 11-2 7 21 3 6 30 4 7 41 4 50-1 6 61 4-5 8 74 8 81 3 7 200 3 8 12 6 22 7 30 2",
    ": 9 41 5 9 56 8 64 8 70 6 80 8 92 9-300 2 4 7-8 12 4 9 22 7-8 30 3-4 40 5 51",
    ": 5-6 70-1 5 80 8 96 405 10 4 24-5 9 36 8 40 4-5 8 51 3 5 63-4 6 70 5-6 9 81",
    ": 3-4 6 92-3 7 502 6-7 11 7-8 21 3 7 33 7-8 47-8 51 4 67-8 71 7-8 80 3 5 8 90 7",
    ": 600 4 7 10 23-4 31 6 43 7 51 3-4 7-8 79-80 5 9 91 3 7 705 9 13 5 9 23 6 34 6",
    ": 40 4 8 50-1 5 9 62 7-8 72 4 7 81 3 9 91 4 803 10 3 6 8 23-4 9 35-6 42 9 54 60",
    ": 3 8 72 4 6 8 81 3 5 9 95 900 9 12 22 4 32 7 47 9-50 4 66-7 70-1 3 8 83 5 9",
    ": 94-5",
    ": 9-8000 3 5 9 13 5-6 9-20 4 6 8-9 33 9 43 53 7-8 61 3 5 8-9 75 81 3 5 8 94 9",
    ": 104 8 18 21-2 6-7 32 4 42 9 51 5 60-1 3 9-70 3 6 83 9 98 200 4 7-8 12 25-6 36",
    ": 9 45 7 53 6-7 60 2 7 75 81 8 92 8 302-3 6 8 10 2 20 3 6 30 3-4 8-9 43 6 50-1",
    ": 4 61 7 70 4 81 4-5 8 93-4 6 401 6 12 4 6 23 7 32-3 7 42-3 6-7 50 5 7 60 6-7 9",
    ": 74-5 84 7-8 91 6 8 503-4 11 3 6 8 20 3-4 7 9 33 9 42 7 56-7 60 3 6 9 71 5-6",
    ": 82-3 5 9 91 6 9-600 3 7-8 12-3 6 21 6 8 30 3 8 45 61 3 6 71 82 7 9 93 5 9 708",
    ": 12-3 7 20 5 7 31-2 8-9 42 4 8-9 57 60 3 5 9 72-3 6-7 80 5 9-90 4 9 801 3 5 8",
    ": 13 6 20-1 4 9 33 8 44 6 8 52 5 9-60 3 73 81 3 5 9 93 9 903 11 7 22 7 9-30 3 5",
    ": 9-40 6-7 55 9 61 3 72 4 83 5-6 94 7",
    ": 9-9000 11-2 7 21 5 9 34-5 8 42-3 7 51 9 61 6 70 2 5 8 81 6 99-100 2 4 11 7 21",
    ": 8-9 32-3 7 41 7 50 3 8-9 62 4 7 72 4 8 84 7 91 7 9-200 3 8 10 3 6 9 23 7 34 7",
    ": 9 42 5-6 9-50 5 8 60 3 71 4 9 86-7 90-1 3-4 7 302 8 11 3 7 20 3-4 6 32 4 9 43",
    ": 8 50 8 66 8-9 83 92-3 9-400 6 11 7 22 5 9 33 5 9 42 6-7 55 9 67 70-1 4-5 80 3",
    ": 7-8 501 7 9 12-3 7 9 26 9 32 5 7 9 41 4 6-7 51 5 8-9 68-9 71 7 81 9 92 5",
    ": 600-1 5 7 12-3 9 21 5-6 36-7 43 51 4 7 9 67-8 71 4 6 81-2 5-6 90-1 7-8 703",
    ": 10-1 3 5-6 9 21 5-6 9 33 6 40 3 8 50 3 7-8 62-3 5-6 71 3 7 82-4 9 91 6 801-2",
    ": 10 2 4 9 25 9 31 6 41 3 7 51-2 6-7 60 2 6 70 5-6 83 7 91 4-5 7 901 4 10 4 8",
    ": 20 3-4 8 30 2 7 41 3-4 8 54 7 9 61 3 7-8 72 9 81 6 92",
    ": 300000-1 7 15 21 4-5 7 32 42 6 9 58 71 5 9 94 9 101 8 10 6-7 9 21 3-4 8 33 7",
    ": 43-4 8-9 52 63 75 86 92 4 7 9 202 7 11 8 24 9 31 5 43 6 8 51 3 8-9 61 3 70",
    ": 5-6 80 4 8 93 6 8 301 5 8 10 4 6 8 20 2 4 9-30 4-6 40 3 9 53 7 62-3 7-8 75-6",
    ": 80 2 4 8 90 3-4 400 10 4 20 5 9 33 6 9 44 6 8 51 4 6 9 65 7 73-4 8 82 6-7 9",
    ": 95 7 9 505 7 9 11-2 6-7 20 3 8 30-1 5 7 44-5 50 3 6 62 6 70-1 3 6 8 81 5 93-4",
    ": 7 600-1 5 9 13-4 20 2 32 8 45 9 56 8 64 6 9 74 8-9 82 4 90-1 5 8 708 12 5-6 9",
    ": 21 3 8 36-7 41 7 58 62-3 5 9 72 4 8 81 5 9 93 801-2 6 11-3 6 8-9 23-4 8 31 40",
    ": 4 7 51-2 5 8 62-3 70 2 6 81-2 5 7 9 91 3 5 9 902 6 13 9 21 5 8-9 34 9 51 6",
    ": 60-1 4 9 71 6 9-80 5 8 92 6",
    ": 1000 7 11-2 4 8 27 31 6 40 2 5 52 5 9 66 71 4-5 9 84 8 91-2 5 7 100-1 4 10 4",
    ": 8 23 5 7-8 31 4 6 8 46-7 9 54 7 60 2 4 9 73-4 87 91 3-4 8 201-2 5 10 3 6 9 25",
    ": 8 30 5 9 44 7 50-1 5 61 4-5 7 9 72 4 6 9-80 4 93 7 302 6 21 9-30 3-4 8 40 2 5",
    ": 51 5-6 63 7 72 6 9 84 91-2 5 400 2 6 9 14 7 9 31-2 7 41 3 7 51 3 6-7 61-2 5",
    ": 70 7 80-1 5-6 90 2-3 5 7-8 500-1 7 12 4 9 21 4 34-5 40 3 6 50-1 5-6 60 2 70 2",
    ": 5 81-2 5 90-1 4 6 600 7 10 6 8 20 3 5 8-9 32 4 6 9 41 3 7 52-3 5-6 62 5 9-70",
    ": 7 81-2 9-90 6 700-1 3 7-8 11 5 8 22 6 9 31 5 8-9 45 9-50 7-8 62 6 74-5 80 3 6",
    ": 9 93 6 9 802-3 19 23-4 9 32 8-9 43-4 8 53 5 9-60 3 6-7 9 76-7 82 7 9 92 4 7",
    ": 900 6 10 3 24 6 34 8 42 7-8 53-4 7 9 65 7 70-1 6 8 81 7 9 92 4 7 9",
    ": 2001 9 14-5 20 4 30-1 5 9 45-6 9 53 5 9 61 3 6 8 71 5 9 82 5 7 90-1 4 7 107",
    ": 16 9 22-3 5-6 9-30 3-4 41 5 52 7 62 73 5 9-80 7-8 92 9 206 9-10 4 30 5 9 41",
    ": 50 6 61 4 75-6 8 80 2 6 8-9 94-5 9 302 6 15 8 22-3 6 9 31 8 43-4 9-50 4-5 7",
    ": 62 5 9 73 7 9 84 7 95 9-400 2 6-7 11-2 5 8 38-9 43 8 51 6 64 8 74 81 7 90-1 4",
    ": 500-1 4 7 11 3 20 2 5 30-1 4 9 43-4 9 52-3 6 63-4 79 83 94 6 600-1 12 6 9 30",
    ": 3-4 8 43-4 7 53 7 61 9 79 83 6 90 2 7 701 4 8-9 13 5 9 25 8 30 2 5 9 41 9-50",
    ": 4 65 8 74 82 6 93 6 802 5-6 9 13-4 8 21 4 8 34 9 42 55 66 8 74 7 9 81 3 7 98",
    ": 908 11 5-6 9-20 3 6-7 38-9 42-3 5 53 6 9 64 9 71 4 7 9 82 7-8 93 7 9",
    ": 3002-3 6 11-2 5 8 23 6-7 30 2 4 40 4-5 50 4 6 60 3 7-8 72 80 6 90-1 4 101 4 6",
    ": 8 13 5 7 9 25-6 9 33 6 41 3 9 53-4 7 9 67 71-2 80 7 99 208 11 5-6 9 24 6-7 37",
    ": 42 7-8 55 9 62-3 8 76 84-5 90 4 9 311 5 8 21 3 5 8 30 6 40-1 4 7-8 51 4 6 9",
    ": 61 5 8-9 74 8 80 3-4 8-9 92 8 401 3-4 9-10 5 8 23 9 39 45 8 50 3 63 7 71 4",
    ": 7-8 82 98 501 4 12 5-6 20 4 6 9 33-4 46 52 5 8 68 71 4 6 8 80 5 8 93 5 600-1",
    ": 5 14 9-20 3 7 32 49-50 4-5 62 6 70 2 81 6-7 91 3 8 701 4 10 4 7-8 21 4 8 30 2",
    ": 8 40 3 7 50 2 62 72 7 9-80 2 90 2 800 2 4 6 12 4-5 20 2-3 6 8 34 40 3 5 54 7",
    ": 64 6 9 72 6 80-1 6 90 4-5 8 902-3 5 8 19 39 41 5 7-8 61 5 7 77 85 7 90 5-6",
    ": 4000 6 13 7 22 5 32-4 6 41 59 63 71 5 83 8-9 91 9-100 4 6 8 18 21-2 32 6 41-2",
    ": 5-6 50 4 63 7-8 83-4 7 90 8-9 211 3 5 9 23 6 30 5 40 4-5 62 6-9 73 5-6 9 83 8",
    ": 91-2 6 300 4 15 20-1 5 30 7 41 8 50 4 9-60 3 8-9 72 4 7 83-4 9 94 403 7 9 18",
    ": 24 9 33 6 41 3 6 9-50 4 9 63 7 72 8 80 6 90-1 4-5 9 501 3 8 21 4 6-7 31 7-8",
    ": 43 52 5 71 82 7-8 91 5-6 601 7 12 6 24 8-9 31 6 41 5-6 58 66 70 3-4 8 84-5 92",
    ": 6 9 703 7-8 14 6 21 33 7 43 5 50 2-3 60-1 5-6 9 74 6 9 82 91 4 8 807 12 5 8-9",
    ": 29 32 8 43 6 53 7 62 8 71 7-8 80 7-8 92 902 10-1 5 9 24-5 33 9 42 7 65-6 71",
    ": 4-5 8-9 88 90-1 6",
    ": 9-5000 3 11 6 9 22 8-9 32 7-8 41 3 7 9 53 6 9 62 4 8-9 73-4 7 86 91 3 6-7",
    ": 102-3 6 11 5 21 3 5-6 31 5 40 5 7 9 53 60 3-4 9 76 80 4 6 90 3-4 202 5 7 9 18",
    ": 20 2 5 35 8 41 6 9 52 4 7-8 62 8 71 4-5 81 3 8 99 303 14 8-9 24 8 31-2 4-5",
    ": 41-2 6 8-9 52 4 6 8 60 9-70 2-3 7 81-2 6 8 95 7 9 403 6 11 6 20 2 4-5 31 3 7",
    ": 40 3-4 6 9 57 61 6 70-1 7 81 6-7 91 5-6 505 9 11 4 7 20 4-5 33 44-5 9 57-8",
    ": 63-4 7 9 71 3 6 86 90 6 601 5 11 3 20 3 5 30 2 6 41 5 7 60 5 7 71-2 5 81 6 91",
    ": 3 6 707 9 17 21 3 5 32 4 7 40-1 50 5 66-7 76 82 8 801 4 7-8 19 21 3 8 32 7 41",
    ": 9 51 6 9 61 3-4 8 71 3-4 82 6 90 6 8 910 6-8 22 5 8 33 7-8 40 2 54 63 5 78-9",
    ": 87 93 7",
    ": 6006 9 12 6-7 26 38 46 55-6 61 8 78 81 5 92-3 7 9 101 3 8-9 15 23 6 8 31 3 6",
    ": 48 50 5 64 8-9 71 4 7 80 5-6 8 90-1 4 7 201 4 7 12-3 6 20 5 9 37 9 42-3 6",
    ": 51-2 5 61 6 8 72 8 81 4 6 90 8 306 8 10 2 6 22 4 7 32 6 41 4 7 53 8 65-6 9-70",
    ": 3 5 9 82-3 91 400-1 3 7 10 2 4 7 21 5 9 33-4 6 8 46 51 3 5 7 62 6-7 72 81 3 9",
    ": 92 4 6 502 5-6 10-1 9 21 6-7 9 38 45 50-1 6 67 72 5-6 81 8 90 9 601-2 6 8 11",
    ": 4 8-9 23 8-9 39 43-4 56-7 60 5 8 72 6-7 86 90 3 5 9-700 4 9 11 5 7 21 5 8",
    ": 32-3 6 44 51 4 6 8 63 7 71 83 6 90 808 10 9 24 7 30 2 5 43 6 8 51 5 9 69-70",
    ": 2-3 6-7 84 8-9 91 4 906 13 8 20 3 7 9 33 5 9 41 4 7 9 54 61 3 5 75 9 85 9 92",
    ": 7001 4-5 12 4 9 22-3 6 8 31 3 6 8 41 7-8 55 9-60 3 8 73 8 82 7 91 5 9 104 10",
    ": 6 9 21 5 8 31 3-4 8-9 43 5 8 54 8 63-4 73 7-8 82 5 93 206-7 11 3 7 9 23 9 34",
    ": 9-40 5 7 51-2 7 64 6 9 71 4 8-9 83 7 92 5 8 306 10 6 9 26-7 31-2 9 43 5 7 51",
    ": 5 9 63-4 8-70 6 90-1 5 7 401 9 13 5 23 6 31 3-4 8 43-5 8 52 4 6 61-2 71 4 8",
    ": 81 91 501-2 6 10 5 21 4 7 30 9 43 9 54 62-3 5 74 9 83 7 90 2 5-6 601 7 10 2 6",
    ": 31-2 6 40 6 59 65 70-1 7 81 5-6 90 5 7 700 5 16 20 6 30 6-7 42 7 51 61 4 9",
    ": 71-2 6 81-2 7 9 97 800-1 6-7 14 9 25 9-30 4-5 9 48 55 60-1 8-9 72 80 5 8 93 6",
    ": 900 2 4 9-10 5 9-20 5 30 5 9 44 9 53 9-60 3 6 8 70-1 4 7 80 5 9-90 4-5",
    ": 9-8000 2 7 9 13 5 8 24 34 40-1 3 50 61 5 70 3 6 80-1 7 90 100 8 14 7 20 7-8",
    ": 34 6 9 41 6 51 7 9 61 4 6 8-9 71-2 6 8-9 82 5 8 90 2 4-5 204-5 10-1 5-6 25 30",
    ": 3-4 8 40 3-4 8 51-2 60 2 6 70 3 9 82 5 7-8 94 9 310 5 21 6 8 30 2 7 42 6-7 50",
    ": 2 7 60-2 4 6 8 71 5-6 9-80 3 6 94 8-9 403-4 9 11 5-6 9 23 5 32 5-6 47 51-2 4",
    ": 8 60 71-2 7 89 93 502 13 6 27 34 7 43 6 8 54 60-1 5 71 3 6 8 80 6 9 91 5 7",
    ": 601 3 5 20 30 2 4 8 42 9 53-4 8-9 62 4 7 72 80 700 2 6 9-10 2 5 8 20 9 32 40",
    ": 7 51-2 6 9-60 71 4 8 80 4 9 91 806 8 11 6 20 3 6-7 31 6 8 42 4 50 3 8 63 8 73",
    ": 7-8 81 5 7 91-2 6 905 10 2 9 28 30 2 5 9 43-4 9 53 5 8 61 3 6-7 70-1 5 9 83-4",
    ": 91 3 8",
    ": 9001 3 9 13 7-8 22 6-7 31 8-9 43 51 70 4 8 80 7 90 8 101-2 9 13 6 21-2 4 31-2",
    ": 9 43 6-7 50 2 5-6 9 65 7 70-1 5 9 82 5 90 2 202 9 12 4 9 24 36 40 7 57 61 3 5",
    ": 9 76 8 84 93 302 8 13-4 20 2 4 7 34-5 44 7 51 4 9 62 6 9-70 4 9 86 8 91-2 4 7",
    ": 402 7-8 13 6 21 3 9-30 3-4 7 41 5 8-9 54 8 63 8 75 7 9-80 91 8 502-3 8 11 3",
    ": 21-2 4 8-9 33-4 42 8 51-2 6 60 4-5 9 72 5 80 2 5 8 94 8 602 7 10 7 9 26 30 4",
    ": 45 52-3 61 3 7 70 4 6 9 85-6 8 94-5 8 700 10-1 7 24 8 34 7 42-3 8 52-3 7 60 6",
    ": 8-9 72 6 81-2 6-7 98 806 8 12 8 20 3 8-9 33-4 45 8 50 3 6 66 9 73 6 9 84 9 95",
    ": 9 902 6 9 13 9 21 8 32 4 41-2 5 51 4-5 8-9 62-3 6 70 2 8 82 5 8-90 3 6",
    ": 9-10000 3-4 8 11 27 9-30 3 6 8 40 5 9 53 5 64-5 71 6-7 81 5 9 94 102 4 7 10",
    ": 5-6 8 22 5-6 32 5 8 43 8 51 3 8 60 4 8 75 83 7-8 92 8-9 205 7-8 11 4 9 25-6",
    ": 9-30 4 6 40 2 6 50-1 6-7 61-2 5 72 7 84 7 9 97 9 304 8 11 3 23-4 8 36 46-7 9",
    ": 60 6 71 9-80 5 92 7 9 405 14 24 7 30 2 9 43 6-7 50 2 8 61 4 6 70-1 4 9-80 6 9",
    ": 96 500 3-4 9 14 8 21 3-4 9-30 3 6 41 3 8 52-3 8 61 7 72 5 7 9 84 94-5 8-9 603",
    ": 7 13 8-9 24 30 2 4 7 40-1 6 54 6 61 71 5 9 90 6 8 701 5 8 18 21 3-4 6 30-1",
    ": 5-6 40 5 9-50 2 5 7 60 4 7 75 7 81 5 94 800 2 9 14 6 9 23 7 34 9 41 8 51 3 5",
    ": 61 3 6 73 5 8 86 93 5 9 901 6 10 5 9 26 9 33-4 9 46-7 52 82 4 8 95",
    ": 1004 8 18 22 6 36 43-4 51 8 60 4 9 79-80 93-4 7 9-100 5 13 6 9 21 7 33 8 45-6",
    ": 50 6-7 60 3 5-6 77 80-1 5 92 4 7 200 4 7 18 22 5 7 30 2 5 40 53 9 68 71 5",
    ": 82-3 8 98 306 10 4 23 37 9 45 50-1 4 60 3 6 70 6 80-1 5 7 91-2 6 400 3 10 5",
    ": 21 32-4 6-7 41 4 52 7 61 6 8 72-3 6 8 84 7-8 92 9 502 5-6 8 14-5 9 22 7 30 5",
    ": 9 46 9-50 7 70 3 5 8 85 8 93 8 601 12 25 9 32 7 9 41 4 6 50 2 6-7 60 4-5 9 71",
    ": 9 84 8-9 93 704 12 5 8 22 39 46 53 6 8 60 5 73-4 7 80 3 8 96 800 4 6 9 20 2 4",
    ": 33-4 9 44 7 9 52 5 61 6 70-1 3-4 8 82 5 94 902 7 12 8 20 3 5 8 30 5 7 40 6 52",
    ": 7 80 3 5 90 3 7-8",
    ": 2002 5 8 11 3 6 8 22 5-6 34 7 45-6 51 4 7 9 61 9 71 4 9 88 94 8-9 103 8 13 6",
    ": 8-9 24 32 5 40 9 52-3 9 64 8 73 6 8-9 82 94 8-9 201-2 5 12 6 21 6 30-1 5 41 6",
    ": 8 51 4 6 60-1 9 75 9 81 6 90 4-5 8-9 301-2 6-7 11 5 21 41 50 5 7 64 7 70 88",
    ": 93 6-7 403 5 7 10 2 7 20 3 32 43 6 8 58 61 3 6-8 72 89 91-2 5 7 501 3 8 11 3",
    ": 8 22 4 8 32 6-7 43-4 53 6-7 62 6 8 74 6 80 2-3 91 4 604-5 14 7-8 26 8 32 8-9",
    ": 43 58 61 6 8 73 82-3 92-3 6 9 702 4 6 10 23 30 3 8 47-8 50 8 65 70 6 9 84 8-9",
    ": 98 802 4 6 10 4-5 8 23-4 9 37 42 6 51-2 6 61 6-7 70 3 5 84 9 92 4 9 901 3 6",
    ": 17 35 8 43 6 9 53 8-9 62-3 71-2 6 80 3-4 90-1",
    ": 3002 11 6 22 5-6 33 8 43 5-6 9 53 6 8 62 5 9-70 2 6 8 81 6 8 91 109 15 9 23",
    ": 8-9 33 5 8 41 4 8 55-6 65 7-8 76 9-80 4 6-7 91 4 6 9 202 7 10-1 6 20 6-8 32",
    ": 5-6 40 51 4 7 61 6 70 7-8 82 4 7-8 95 7-8 305 8 12-3 6-7 9 21 5-6 32 8 42 8",
    ": 51 4 7-8 62 5-6 8 72-3 81 6 91 8 402 4 10 4 8 29-30 2 9-40 6-7 50 4 8 69 71 5",
    ": 83 6-7 91 4 7 500 4 13-4 8 25-6 31 5 8-9 43 50 3-4 8 63 7 73-4 6 81 6-7 94",
    ": 600 3-4 9 13 9 23 8 32 40 3 6-7 51-3 8 60 7 74-5 8-9 83 7 91-2 5 8-9 703 6 9",
    ": 14 6 9 23 37 9 44 50 2 4 60-1 5 71 7 83 6 9-90 3 7 800-2 6 10 2 4 6 9 22 4 31",
    ": 44 6-7 51 6-7 60 2 7-8 71 7 9 81-2 6 90 3 6-7 901 4 9-10 4 6 20-1 6 31 7 41-2",
    ": 8 53 5 62 8 70 3 8 83 9 92 4 7 9",
    ": 4001 3-4 8 10 2 6 8 20-1 5 8 30-1 8 42 7 54-5 9 64 72 80-1 6-7 90 2-3 9 102 5",
    ": 8 10 6 20 2 7 33 7 45 8-9 56 8 62-3 70 2 4 9 94 7 9 203 7 13 7 9 22 6 31 3",
    ": 7-8 45 9 53-4 7 62 9 72 6-7 81 6 91 5 7 9 303-4 7 9 17 20 6 37 41 54 7 66",
    ": 9-70 4 7 83 90 4 400-1 5 7 14 7 26 8 32 9 42 6 8 50 9 68 71 5 9 82 5-6 8 99",
    ": 501 9 13 5 27 32 8 41 5 50-1 6 60-1 4-5 7 70 2 7-8 81 3 92-3 600 5 11 5 8",
    ": 23-4 7 38 43 52 4 60-3 70 5 9 84 6 90 4 702-3 7 10 4 6 23 9 35-6 40 4 50-1 5",
    ": 67-8 81 90 2 4-5 8 815 21 8 38 42-4 9 52 60 3 8 74-6 80 90-1 4 8 902-3 5 7 12",
    ": 4 7 9 25 30 3 9 42-3 7 52 4 66-7 75 80 90 3 6 9",
    ": 5003 5 8-9 11 8-9 22 8 31 9-40 4 6 9 52 9 62 72 4 9 84 6 90 3 5 102 7-8 10 5",
    ": 7 9 23 7 9 31 6 8 40 5 8 50 2 5 62 5 70-1 4 8 88 97 201-2 6 8 15 8-9 30-1 5-6",
    ": 41 3-4 51-2 62 8 71-2 5-6 81 3 6-7 90 304-5 9 13 20 4 8 30 6 41 6-7 53 61-2 7",
    ": 76-7 9 83 7 9 92 6-7 405 9 15-6 8-9 22 8 31 4 8 42 6 8 51 3 8 60 79 82-3 6 93",
    ": 5-6 9 501 12 6 20-1 4 8 32 6 9 44 8-9 56 8 61 6 70 4 6 82 5 91 3 5 7 600 3 5",
    ": 7 11 4-5 8 20 2-3 7 30 3 6-7 42-3 7 9 51 3 60 3 71 4 6 80 5 9 92 4 700 13 9",
    ": 24 6 8 30 6 8 45 9 51 67-8 70 84 92-3 7 800 5 7 17 23 35 8 42-3 5-6 51 5 60 4",
    ": 7 9 72 9-80 3 5 9-90 9 901 3-4 6 10 2 9 24-5 9 32 4 6 40 52 4 6 60 2 8 70 4 9",
    ": 82 95 9",
    ": 6001 4 9 14 6 9 23 7 36-7 42 5 7-8 52 60 5 7 70 3 5 7 80 3 92 5 7 9 101 3 9",
    ": 17 9-20 5 8 35 9 45 9 51 5 62 6 74 7 9 81 6 94 8 206-8 10 3 5 23 5 8-9 37",
    ": 43-4 8 54-5 9-60 5 8 70 3 8 83 90 4 7 300 2 17 24 8 31 6 40 4-5 50 3-4 62 76",
    ": 8 87 90 3 7 409 12 8-9 25 30 43 5 8 51-2 6 60 9 72 4 82 8 94 8-9 502 4 6 9 14",
    ": 8 22 8 30 2 7 9 41 4 7-8 53-4 7 62 7 71-2 6 80-1 5 9 91 4 9 602-3 8 15 8 21 3",
    ": 5 9 33 46 53 7 67 70 2 7 84 8 93 8-9 702 7 14-5 21 4-5 45 8 50 3 9 70 9 83",
    ": 92-3 5 803 5 13 8 22 7 33-4 8 48-9 55 7 61 3 5 7 74 9 84 6 94-5 9 904 6 12",
    ": 5-6 21 5-6 30 3 6-7 43 8-9 51 9 61 4 71 6 8 81 5 8",
    ": 99-7000 8 10 3 5-6 8-9 23 5 7 35 7 49 53 7 60-2 8 70 4-5 7 81-2 4-6 9 92 6",
    ": 104 7 20 2 4 8 33 40 3 5 8 52 61 8-9 75 9-80 3 90 202 5 10 3 8 23 5 7 33 6-7",
    ": 47-8 52 5 67 76 86 9 95 7 303 8 10 6 9-20 4-5 8 34 9 46 9 52 4-5 7 72 7 83 6",
    ": 9 96-7 400 5 7 10-1 3 6 20 6 8 32 6 9 47 52-3 5 8 64-5 9 73 6 8 81 4 93 9 502",
    ": 12 5 22 6 36 9-40 3 6 9 52 4 9 67 70 2-3 5-6 89-90 6 602 4 9 13 6 27 31-2 9",
    ": 41-2 6 53 6 8-9 63 6 70-1 3 9 89 96-7 705 7 13 9 25 8 34 8 41 7 50 2 6 8 77 9",
    ": 86 90-1 5 9-801 6-7 16-8 21-2 8 34 6-7 42-3 58 60 2 6-7 74 6 9 84 8 91 900 11",
    ": 8 22-3 7 32 6 41 6 8-9 52 4 6-7 64 8 73 5 7 82 7-8 93 8",
    ": 8004 7-8 12 5 8 21 3 7 33 7 9 45-6 8 50 6 60 2 7 9-70 83 5 91 3 5 9 102 6 8",
    ": 12 21 7 9 33 9 42 53-4 9 66-7 71 6-7 81 4 6 8 91 4 7 200 2 6 9 12-3 20 3 8 32",
    ": 4 6 9 42 8 50 2 4 6 8 60 4 6 71 8 80 91 309 13 6 23 9 33 5-6 9 41 53 7 66",
    ": 74-5 9 82-3 5-6 95 9 401 3 5 7 9 12 4 7 21 3 5 31 4 6 8-9 43 5-6 55-6 9 61 5",
    ": 73 5 80 2 5 7 90 503-4 7 10 2 8 20 9 32 7 41 5 7 50 2 6 9 63 72 4 7 84 92-3",
    ": 8-600 3 9 14 8-9 26 33 5 7 40 3 8 52-3 61 3 8 71 4-5 8 80 3-4 8 91 4 8 702 4",
    ": 9-10 4-5 8 22 4 30 40 7 55-6 9 61 5 70 3 5 8 81 4-5 9 92 5 8-9 802 7 15 20",
    ": 3-4 6 34 6 9 41 4 7 50 2 4 9-60 5 70 2 8-9 82 9 95 904 12 4 20 2 5 38 42-3 5",
    ": 53 7-9 68-9 72 7 80 3 5 8 90 6 8",
    ": 9003 12 5 7 27 32 6 41-2 7 9 51 61-2 6 73 7 82 6-7 95 100 8 10 5 26 36 9 41 5",
    ": 7 53 5 7 60-1 3 72 5 84 8 90 2 4 7-8 202-3 12 28-9 31-2 4 40 3 51-2 61 7 70-1",
    ": 5 8 81 5 97 302 4 9 12 6-7 9 22-3 6 31-2 41-2 5-6 50 2 8 64-5 72-3 6 81 7",
    ": 90-1 4 8 400 7 11 4 7 22 5 7 40 8 52-3 5 7 9 62 70 86 9 93 9 502 10 3 8 20 6",
    ": 30 5 41 8 53 5 9 61 4 75 81 4 6 8 90 5-6 600-1 3 6 17 9 24 7 31 3 7 49 66 78",
    ": 82-3 6 93 7-8 705 8 12 6 22-3 5 34-5 42 4 53 62-3 8 72 6 9 82 4 90 3 8 800 4",
    ": 7-9 12 4 6 20 5 9-30 3 7 9-40 3 8 51 62 70 2 6 80 3 5 91 5 900 2 6-7 12 8 22",
    ": 7 30 3-4 6-7 49 52 4 7-8 61 6 9 74 6 8 91-2",
    ": 20001 7 14 20 4-5 30 3 5 8 43 5 8-9 52 63 5 74 81-2 6 91 3 6 101 4-5 9 15 20",
    ": 4 9 32 6 40-1 8 53 7 63 8 73 82 5 90 7 200 7 9 11 6 26-7 36 41 50 6 60 4 70 3",
    ": 8 90 4 300 5 12 7 21 30 2 7 42-3 51 7 9 68 71 4 8 83 90 4-5 9 403 13 6-7 9 23",
    ": 30 8-9 42 9 52 5 65 9 72 5 7 80 4 9 500 6 9 11 6 8 20 3-4 6 30 4-5 43-4 8 54",
    ": 61 7-8 74 6 9 81 7 91 4-5 601 5-6 11 22 5 31 40 2 4 6 9 56 65 9-70 3 8 80 2 8",
    ": 93 707 9 22 7 30 2 4 9 50 2 6 62 6 70 2 7 9 82 91 4 7 806 11 4 6 8-9 23 33-4",
    ": 8 40 3 7-8 57-8 62 8 71 4 9 84 6 8 91 6 901 7 13 8 24 38 42 7 50 5 7 63 6-7",
    ": 76 8 80 5-6 8 92 4 8",
    ": 1000 3 10 29 38-9 42 6 50 60 5 7 75-6 81 4 6 8 92 9-100 2 4 7-8 10 6 9 22 4",
    ": 7-8 33 7-9 42 5 7 50 2-3 6 60 4 6 9 71 8 80 7 92 5-6 9 201 4-5 7 11 3 5 20 3",
    ": 31 3 40 7 53 5 62 6 75 81 6 90 301 6 9 12 7 9 31 7 40 54 7 74 8 90 8 401 6 11",
    ": 8 21 33 9 44 8 66 9 77 81 8 99 505 9 13-4 22 5-7 31 8 46 51 7 74 80 616 20 34",
    ": 7 51 6 8 61 4 7 74 80 9 91 4 8 701 12 5 27 37 40 50 61 5 9 72 5 8 82 9 93 5",
    ": 800 7 11 21 3 8 32 9 48 51 3 9 66 70 3 8 86 9 92 5 900 3 30 45 50 5 60 70 7",
    ": 81-2 6 9 91",
    ": 2000 3 9 15 27 30 5 59 75 84 102 11 23 31 46 52 6 60 2 9 82 92 202 11 20 6 30",
    ": 40 50 60 72 80 4 92 7 304 12 32 8 44 7 53-4 67 78 80 8 90 2 9 405 11 5 23 30",
    ": 8 42 52 6 74 9 83 6 507 15 9 27 30 5 8 41 6 9 53 60 4 80 9 91 603 12 6 9 23 7",
    ": 31 44 7 55 9 66 72 80 92 701 7 9 12 21 5 30 4 41 7 57 60 4 74 8 86 94 8 802 6",
    ": 11 6 22 6 44 7 51 6 60 2 5 8 71 4 81 92 6 900 5 7 18 23 9 33 40 51 7 61 6 70",
    ": 4 8 83 7 92",
    ": 3008 14 21 30-1 41 5 7 51 68 71 3 9 83 93 107 13 35 8 47 52 4 61 4 8 70 3 7",
    ": 80 3 94 200 8 13 30 40 51 60 2 7 9 74 96 302 9 13 7 25 32 6 47 50 4 9 67 73 6",
    ": 8 82 7 90 410 6 20 5 9 32 41 6 9 53 7 78 88 91 500 2 7 18 21 6 30 41 9 53 6",
    ": 61 5 8 73 6 9 82 97 600 4 9 11 8 21 5 35 48 64 6 74 8 84 7 714 9 21 6 8 33 8",
    ": 40 6 52 5 8 62 7 71 6 9 83 6 92 5 8 804 18 26 31 9 50 63 70 7 99 903 21-2 30",
    ": 3 8 43 7 53 66 76 82 5 8",
    ": 4003 7 10 4 9 23 30 5 9 45 61 4 74 84 7 91 6 102 6 28 31 8 60-1 6 9 76 95 200",
    ": 7 16 24 8 32 44 6-7 50 7 62 7 71 4 80 3 5 9 96 328-9 36 9 42 65 77 88 95 9",
    ": 401 5 10 4 24 6 32 5 42 6 50 9 70 5 9 83 7 9 95 500 9 16 20 33 7 41 51 5 66",
    ": 71 5 9 85 8 93 8 601 12 7 23 34 7 9 45 55 60 4 7 74 8 87 705 16 40 3 52 5 61",
    ": 7 72 85 805 12 23 39 46 51 8 66 70 90 6 905 10 8 20 7 35 41 9 52 4 69 71 3 7",
    ": 80 5 97",
    ": 5005 8 22 30 40 4 9 56-7 64 9 73 5 9 85 9 91 5 103 6 23 7 32 55 60 3 79 83 7",
    ": 94 8 213 8 20 2 8 33 5 7 48 51 62 80 4 95 8 313 25 30 40 4 54 61 5 73 403 6",
    ": 22 6 34 42 8 55 70 4 6 85 90 6 500 3 7 10 5 23 9 34 6 40 4 7 52 66 70 9 83 8",
    ": 99 602 7 20 4 9 46 8 51 4 60 4 7 71 3 8 82 4 8 95 7 711 28 31 3 8 52-3 60 6",
    ": 70 4 83 7 94 800 4 20 5 50 60 4 75 84 91 7 905 15 21 4 8 34 7 44 8 50 3 8 62",
    ": 74 84 7 94",
    ": 6003 10 4 6 9 25 31 7 50 4 60 3 81 94 107 9 15 9 23 7 35 9 45 8 55 62 7 74 8",
    ": 83 7 91 5 9 204 22 5 9 32 7 41 5 9 53 63 7 71 4 7 82 6 95 9 303 16 21 5 9 32",
    ": 4 7 9 45 54 6 63 75 8 85 90 5 400 4 15 21 5 32 6 40 4 8 55 61 5 7 80 3 9 93",
    ": 506 18 32 8 45 65 8 72 83 93 7 614 29 34 45 52 6 64 77 81 5 98 703 13 8 23 34",
    ": 44 55 62 6 800 9 13 9 30 47 53 60 7 71 4 9 912 5 23 32 5 8 41 51 5 61 7 71 8",
    ": 82 95 7",
    ": 7005 10 5 8 47 52 61 5 7 72 80 92 5 106 10 4 29 32 45 54 7 70 4 87 91 5 204 6",
    ": 16 9 29 35 40 53 8 73 83 6 92 6 9 319 26 9 31 5 9 48 50 7 62 78 82 92 401 4",
    ": 10 4 7 23 6 42 62 9 76 90 502 6 9 32 53 63 5 71 5 8 87 604 23 33 43 54 8 66",
    ": 77 9 85 9-90 701 4 7 10 4 23 9 35 59 76 81 809 13 5 38 51 3 6 60 6 9 81 4 7 9",
    ": 902 8 12 7 23 9 37 47 51 5 60 9 74 7 83 95",
    ": 8004 8 11 5 20 3 7 39 43 7 51 6 60 6 74 87 90 5 9 102 21 35 42 6 59 63 7 70",
    ": 84 218 23 7 30 4 7 9 43 6 50 6 9 64 74 88 300 5 10 4 27 30 2 9 44 9 59 62 7",
    ": 72 7 82 9 402 5 10-1 28 31 4 9 43 9 63 8 72 7 85 90-1 502 17 24 42 55 79 83",
    ": 91 7 601 5 17 22 33 6 8 42 7 52 64 8 71 7 94 700 3 6 9 12 6 25 30 44 7 51 8",
    ": 71 7 80 4 9 96 800 4 12 7 21 5 30 4 7 42 6 8 53 71 5 89 96 8 904 11 4 21 5 38",
    ": 41 9 52 6 77 85 8 99",
    ": 9008 10 3 22 5 35 9 42 6 51 4 74 86 90 105 14 8 35 42 8 52 65 71 9 84 8 93",
    ": 200 3 11-2 5 8 27 9 33 9-40 55 60 4 7 9 73 92 300 7 10 5 9 21 6 30 3 43 52 6",
    ": 8 62 73 6 82 8 92 4 400 11 4 9 23 6 30 2 42 6 58 61 70 4 80 90 6 509 12 36 53",
    ": 7 60 71 84 8 609 13 33 43 60 2 5 9 73 80 94 703 8 12 21 33 5 44 52 66 9 72 83",
    ": 6 9 803 6 16 32 41 5 9 57 62 6 80 90 908 11 8 25 8 31 5 9 46 50 7 80-1 3 90 5",
    ": 30002 19 23 9 33 7 43 5 9 64 9 75 82 7 91 9 102 10 20 8 41 4 7 55 9 63 73 80",
    ": 3 90 8 202-3 7 12 6 25 36 42 50 4 61 4 73 8 81 6 98 301 6 10 6 23 34 6 47 54",
    ": 7 61 4 71 4 9 85 8 96 400 14 8 22 8 35 9 46 71 4 83 6 8 92 501 3 8 14 8 32 6",
    ": 8 43 8 62 5 70 3 80 2 7 9 92 5 8 612 22 6-7 9 32 9 45 51 76 9 85 9 94 6 9 703",
    ": 6 10 2 5 8 29 34 7 40 6 9 52 9 63 70 2 5 80 5 94 8 807 9 13 8 22 6 38 40 8 52",
    ": 9 63 72 83 90 7 913 28 44 8 57 71 5 93 9",
    ": 1006 10 4 22 31 5 44 8 53 6 67 72 5 81 92 5 108 15 27 33 6 42 5 57 79 83 92 7",
    ": 214 8 22 30 3 40 3 9 51 4 8 68 77 96 333 48 57 63 7 74 86 92 402 7 9 14 8 24",
    ": 9 32 7 40 6 8 53 65 9 81 9 94 8 503 6 8 12 9 27 30 4 8 40 9 51 7 61 71 5 81-5",
    ": 97 600 2 5 14 7 26 9 36 42 6 8 50 3 65 74 80 8 96 9 703 6 8 14 24 31 3 7 41 6",
    ": 53 6 63 7 71 8 86 90 3 7 801 5 11 20 4 30 42 8 51 5 65 74 81 8 91 916-7 23 5",
    ": 31 43 60 6 70 81 7 92",
    ": 2003 8 15 23 30 5 8 42 8 54 8 65 75 90 4 104 7 10 6 21 5 33 46 56 65 8 72 85",
    ": 91 9 203 5 22 30 7 44 6 50 7 60 6 71 4 82 5 8 303 5 14 7 22 4 8 34 43 6 50 4",
    ": 8 62 9 76 80 5 9 91 8 402 11 6 9 52 8 63 7 80 4 91 9 502 13 6 20 6 35 41 9 57",
    ": 61 4 72 9 85 92 603 8 10 5 7 27 31 6 58 65 8 73 6 80 5 91 9 704 10 25 31 4 48",
    ": 52 8-9 70 3 8 81 96 805 15 21 5 7 33 40 3 5 9 66 75 80 90 4 910 25 9 32 40 4",
    ": 6 50 4 66 71 5 90 2 5",
    ": 3006 10 36 49 58 62 4 6 71 86 90 3 7 101 6 11 9 25 9 31 3 6 48 54 65 7 71 7",
    ": 81 4 8 97 206 9-10 7 20 5 30 5 9 44 7 50 61 4 8 72 6 86 8 95 300 12 23 5 33 6",
    ": 44 50 60 4 8 70 4 83 5 91 8 402 7 13 22 4 31 41 6 50 5 63 74 82 6 8 98 505 9",
    ": 12 5 22 30 4-5 8 46 58 61 8 71 6 86 96 613 21 8 31 41 3 5 53 6 9 65 75 9 85",
    ": 90 8-9 710 26 34 44 53 8 60 5 77 87 94 801 4 10 24 7 9 35-6 50-2 5 8 73 7 80",
    ": 4 8 91 5-6 911 7 20 2 8 42 6 60 5 9 75 9",
    ": 4001 4 19 40 4 6 53 9 73 6 9 81 9 95 7 106 15 8 23 6 8 39 43 9 53 60 7 77 9",
    ": 82 8 91 200 10 4 22 8 31 40 3 5 53 65 9 84 7 92 8 301 5 10 4 9 25 9 35 9 45",
    ": 57 63 72 8 82 97 409 14 22 8 36 53 8 67 71 5 9 83 6 9 96 500 6 22 8 38 46 63",
    ": 71 5 92 603 6 21 30 7 44 8 57 60 5 71 8 95 8 706 10 24 43 5 8 63 7 74 95 9",
    ": 802 9 13 8 28 43 57 66 9 75 86 94 8 902 20 3 31 50 4 7 67 72 7 84 90 4 7",
    ": 5003 17 28 33 57 62 9 75 100 7 19 29 47 52 8 67 72 6 83 5 8 94 200 10 4 9 24",
    ": 8 39 57 60 7 76 96 315 7 26 32 40 4 7 52 71 8 82 407 18 22 34 46 66 73 7 83 7",
    ": 91 515 22 8 36 45 55 68 82 8 606 19 36 41 55 85 709 29 33 46 59 71 81 95 800",
    ": 8 12 7 30 8 41 5 56 60 4 71 4 80 96 904 8 22 8 39 44 53 64 9 80 6 9 94",
    ": 6008 18 23 8 33 7 40 8 52 4 8 69 82 91 6 100 13 6 20 5 8 32 7 40 51 62 6 79",
    ": 83 6 93 9 204 7 14 9 46 8 57 60 77 88 93 303 17 21 9 46 50 3 60 74 85 9 400 5",
    ": 27 43 8 54 8 63 71 5 80 6 91 515 9 27 31 5 51 4 8 62 73 7 87 92 6 612 6 20 8",
    ": 41 56 60 4 9 74 87 92 700 4 9 15 9 23 6 32 42 5 63 7 93 803 7 21 32 46 54 64",
    ": 8 76 90 2 7 900 5 10 34 41 60 5 70 6 80 99",
    ": 7013 8 24 60 80 95 100 3 20 5 35 9 48 60 6 73 205 17 21 33 40 52 8 62 8 78 92",
    ": 314 27 32 57 62 79 84 9 408 14 26 33 5 40 6 71 4 81 9 99 513 6 24 8 35 9 44 7",
    ": 50 4 8 62 73 88 94 602 9 16 21 4 9 32 41 5 53 8 62 72 6 9 90 5 8 702 7 23 33",
    ": 41 52 62 70 4 8 93 7 801 7 11 5 8 40 9 53 7 62 72 83 7 93 8 900 16 28 32 6 60",
    ": 3 78 83 8 91 6",
    ": 8002 14 22 6 36 8 54 61 4 8 80 104 20 30 3 5 9 42 9 53 63 7 77 87 206 9 14 9",
    ": 24-5 30 3 48 70 86 91 9 302 6 11 7 22 9 32 5 43 55 8 66 71 4 89 98 402 6 20 7",
    ": 9 34 41 51 61 7 70 4 88 502 8 14 8 22 6 9 39 43 50 4 62-3 7 77 95 606 11 6 8",
    ": 28 32 5 8 51 5 60 73 83 91 6 702 8 13 8 28 33 41 7 51 6 66 76 89 93 803 24 31",
    ": 4 44 9 55 8 62 80 92 910 5 22 37 49 58 64 74",
    ": 9003 8 16 22 7 48 52 64 73 9 83 9 92 6 9 102 5 10 22 6 51 66 73 8 91 5 200 10",
    ": 25 56 62 5 84 309 12 27 31 41 4 50 8 64 76 88 91 6 400 6 12 6 20 3 6 30 47 50",
    ": 6 66 72 7 80 5 8 95 9 503 11 21 9 37 52 7 61 6 71 8 93 602 15 27 31 47 51 7",
    ": 68 71 5 85 95 8 705 13 9 24 32 7 41 7 56 9 64 8 70 4 8 88 93 8 805 14 24 7 32",
    ": 48 56 60 6 81 7 9 96 902 6 14 9 22 8 31 6 9 45 50 5 8 65 73 8 82 96 9",
    ": 40004 10 5 28 34 8 44 9 53 63 70 3 8 100 6 9 18 23 8 46 8 59 72 6 85 203 13",
    ": 20 4 8 35 9 44 53 7 60 3 8 71 6 80 310 6 23 32 52 7 62 5 77 89 93 408 19 27",
    ": 32 51 5 60 4 75 83 7 96 516 30 3 42 54 9 68 71 8 82 6 92 603 17 24 7 40 7 51",
    ": 63 7 70 7 83 7 91 700 2 15 22 7 40 5 53 9 72 80 93 7 802 10 4 21 5 34 53 7 62",
    ": 9 75 85 90 901 10 7 26 48 59 68 71 5 83 93 8",
    ": 1002 30 7 64 70 4 9 83 8 91 4 9 108 14 22 9 36 52 4 9 68 81 6 9 93 7 208 13 6",
    ": 21 4 35 56 65 8 71 5 80 7 99 308 21 30 40 5 57 64 7 79 89 400 5 9 18 30 8 43",
    ": 51 7 62 70 4 93 9 521 8 32 7 56 8 63 70 4 9 83 7 93 600 10 9 24 33 40 6 50 6",
    ": 61 72 7 99 710 27 32 42 55 9 67 72 82 94 800 4 11 5 23 30 7 41 52 62 6 75 84",
    ": 9 906 8 15 21 6 31 9 46 8 65 88 94 9",
    ": 2004 18 22 37 41 6 54 73 80 4 93 101 4 11 4 24 36 40 5 50 60 76 86 9 96 203 6",
    ": 11 6 20 4 40 50 5 60 7 80 91 323 35 9 44 9 54 7 61 80 91 6 403 7 10 5 20 4 42",
    ": 4 9 53 63 75 88 95 9 505 16 20 4 8 35 45 50 71 602 6 19 25 30 40 56 60 6 70",
    ": 90 8 700 4 17 25 43 8 53 60 75 9 99 814 22 8 48 52 67 73 89 94 8 909 29 40 52",
    ": 9 62 70 6 93 7",
    ": 3003 7 9 16 20 4 44 58 74 7 82 90 5 104 11 7 23 32 6 49 64 6 71 9 83 97 211 7",
    ": 21 5 30 8 44 50 9 64 6 81 90 8 309 12 21 30 6 9 50 62 7 77 81 4 90 3 7 400 6",
    ": 13 7 20 5 38 43 53 63 7 72 7 98 501 8 17 35 43 52 9 65 74 6 83 8 96 601 19 28",
    ": 35 9 50 4 61 73 8 82 96 716 20 30 64 9 73 8 81 6 91 8 802 13 25 30 3 44 61-2",
    ": 5 7 72 81 8 94 9 901 8 17 25 31 9 41 5 50 4 76 86 9 98",
    ": 4002 10 9 33 8 43 52 64 8 76 82 123 6 30 40 6 57 9 63 8 78 81 4 9 95 9 220 8",
    ": 41 9 52 5 62 79 84 9 95 301 4 23 37 53 6 61 77 82 7 92 402 10 6 23 7 38 41 7",
    ": 58 72 80 3 98 501 9 22 6 33 40 2 51 61 6 70 85 7 91 605 10 21 4 8 32 42 55 74",
    ": 81 5 8 93 700 8 11 39 45 9 53 70 87 810 6 35 47 59 62 78 83 905 13 22 53 7 61",
    ": 9 76 9 81",
    ": 5007 11 32 8 42 6 50 5 9 64 8-9 75 80 2 93 103 17 20 8 32 8 56 61 6 200 12 4",
    ": 7 22 6 33 57 68 86 306 13 22 36 40 5 58 63 71 81 6 9 400 8 24 32 8 45 54 7 62",
    ": 81 99 511 6 25 30 5 9 58 72 9 82 6 90 4 601 9 20 6 32 9 44 54 8 66 74 81 91 5",
    ": 9 715 9 36 8 57 72 6 9 91 812 5 9 32 41 4 61 73 8 88 903 12 7 21 30 3 52 7-8",
    ": 69 73 83 7 99",
    ": 6001 6 10 39 44 59 64 76 81 8 96 104 10 22 5 32 6 9 55 69 73 82 6 99 205 14",
    ": 21 6 35 51 61 5 76 85 313 23 31 40 2 54 9 64 9 75 90 7 400 6 11 7 23 33 8 41",
    ": 54 60 3 8 71 7 9 85 92 4 8 507 10 20 33 51 61 7 72 84 98 611 6 21 35 47 55 7",
    ": 60 5 9 78 82 5 96 8 702 9 19 23 7 35 44 7 57 85 96 9 826 30 7 43 50 4 9 61 7",
    ": 73 8 89 93 6 902 12 6 24 9 33 47 52 65 82 6 9 98",
    ": 7004 12 20 32 44 8 66 71 4 8 82 90 7 109 14 8 20 5 32 6 46 52 63 7 83 6 90 8",
    ": 207 14 20 5 36 40 8 66 301 5 14 21 4 36 42 6 51 7 68 94 9 406 9 12 21 6 36 45",
    ": 50 8 60 3 6 71 5 81 95 500 13 6 20 3 8 34 44 52 7 62 7 78 86 91 601 15 9 23 8",
    ": 33 7 40 4 8 57 62 4 78 80 95 704 10 5 9 27 32 8 46 57 65 71 5 80 7 800 5 13",
    ": 24 33 45 58 62 6 73 8 88 93 8 901 5 10 8 22 36 41 7 67 72 6 84 8 93",
    ": 8024 8 32 6 47 62 72 5 80 2 91 106 11 21 5 41 6 9 56 65 71 80 4 7 94 200 3 8",
    ": 11 20 34 8 43 5 58 63 7 76 83 6 90 4 8 304 10 9 24 7 32 5 40 5 9 54 9 62 71 7",
    ": 85 90 4 7 401 9 14 9 22 38 41 6 71 9 91 6 9 507 10 6 21 30 5 52 5 73 85 603",
    ": 13 20 35 44 61 75 83 90 3 8 709 18 30 41 60 4 77 98 801 8 11 5 9 24 45 52 62",
    ": 7 70 6 9 85 91 5 901 5 8 22 5 9-30 48 51 60 4 8 72 85 94 9",
    ": 9009 19 22 5 30 3 42 8 56 61 8 81 9 93 9 102 7 14 31 54 65 70 5 83 92 202 5",
    ": 10 5 8 38 52 87 90 2 317 20 5 9 35 8 55 62 7 71 86 90 5 8 418 20 2 6 8 44 55",
    ": 72 4 7 82 7 507 28 39 51 4 65 78 88 92 615 21 5 37 41 5 8 67 74 8 90 703 8 11",
    ": 4 8 26 9 39 52 6 63 8 75 84 95 803 9 20 3 42 6 55 9 72 93 6 901 6 9 11 6 22 8",
    ": 38 54 73 6 94 7",
    ": 50006 46 88 115 45 69 225 31 43 59 68 82 7 302 17 31 4 9 43 8 63 74 82 7 94 8",
    ": 408 16 20 3 6 9 32 7 44 50 62 77 95 504 17 26 30 8 42 7 50 76 84 8 93 8 601 6",
    ": 11 25 30 6 41 5 7 57 63 89 94 713 6 25 34 43 6 53 60 5 74 82 803 8 23 9 34 66",
    ": 75 910 3 9 29 33 54 66 77 88 93",
    ": 1002 17 21 8 147 59 222 56 64 348 57 68 71 80 4 400 5 17 21 6 31 4 7 41 8 51",
    ": 7 61 72 6 80 4 9 93 7 502 7 11 21 6 30 5 45 50 3 60 5 8 73 81 7 94 600 4 13",
    ": 24 36 56 74 85 92 704 12 7 9 24 7 35 55 64 71 5 82 8 91 8 815 9 33 49 60 7 77",
    ": 81 90 6 911 6 29 50 6 9 70 9 82 91 8",
    ": 2002 11 7 26 38 46 59 62 71 5 102 5 9 14 272 304 24 57 82 90 6 402 17 21 66",
    ": 71 82 6 91 6 513 23 39 63 9 86 96 601 7 20 4 31 72 80 3 700 5 8 18 34 8 46 53",
    ": 8 61 70 4 86 805 32 40 9 51 73 6 86 93 900 7 15 9 30 4 43 5 56 62 7 71 4 83 9",
    ": 98",
    ": 3002 20 8 63 84 101 50 71 232 310 64 74 446 55 67 76 500 5 28 35 52 6 69 78",
    ": 81 605 19 26 31 5 9 48 51 9 66 70 6 95 719 41 7 51 8 62 5 74 84 93 804 29 38",
    ": 42 7 50 5 9 69 78 91 4 920 32 48 53 9 67 73 89",
    ": 4008 16 21 38 41 53 7 68 84 111 6 23 32 46 51 6 68 75 9 84 7 94 253 366 90",
    ": 499 523 613 52 7 70 6 83 7 91 6 706 13 8 23 8 33 43 8 52 61 6 73 80 5 9 93",
    ": 807 10 8 32 8 53 70 8 91 5 909 15 30 41 6 53 75 81 5 91",
    ": 5026 35 9 44 58 65 79 91 104 15 21 6 42 73 7 87 93 200 28 31 4 46 62 6 81 91",
    ": 5 330 7 40 9 54 8 62 73 88 96 401 6 14 8 21 5 31 6 41-2 7 53 8 532 59 604 29",
    ": 40 76 746 812 28 37 49 55 60 76 82 5 94 919 24 34 51 64 9 74 80 4 91 8",
    ": 6011 21 48 51 6 64 72 7 82 100 11 20 6 31 5 62 6 71 93 214 8 26 31 9 56 79 86",
    ": 300 11 3 8 22 33 9 43 57 62 71 80 95 412 23 41 8 51 7 67 75 84 510 9 38 54 65",
    ": 70 7 82 8 99 745 55 91 802 27 80 936",
    ": 7086 97 110 30 44 53 7 62 72 5 91 7 202 10 21 31 42 6 57 84 7 92 7 302 7 25",
    ": 31 5 54 62 4 72 8 83 8 415 8 33 43 52 6 62 7 83 9 94 513 20 36 43 50 6 72 9",
    ": 84 9 94 602 8 39 65 71 5 99 704 10 24 47 52 8 63 5 75 84 802 24 30 5 54 9 75",
    ": 90 6 902 10 6 38 44 9 73 7 82",
    ": 8021 98 109 25 38 57 211 9 57 63 79 86 9 306 11 22 34 49 59 65 75 84 99 406",
    ": 15 22 30 42 51 61 72 7 89 92 7 506 26 31 66 90 605 13 24 8 42 9 59 74 8 89 96",
    ": 711 23 7 31 43 8 53 7 71 82 9 96 806 14 7 24 7 34 41 5 53 63 8 72 6 81 90 7",
    ": 903 6 16 25 36 41 54 81 92",
    ": 9004 7 11 6 24 32 65 72 7 115 21 33 41 50 220 54 444 74 9 92 501 15 30 7 46",
    ": 61 6 79 85 94 608 20 6 35 68 73 9 703 11 8 34 45 51 5 70 8 85 94 9 807 25 35",
    ": 8 47 52 61 6 71 6 84 90 910 9 48 56 72 8 82 7 96",
    ": 60000 6 15 20 7 37 41 60 4 9 82 8 92 101 7 12 22 7 32 9 49 54 68 70 4 87 95",
    ": 224 59 361 442 51 71 81 7 93 500 5 10 5 9 29 32 8 45 51 65 89 93 620 36 45 50",
    ": 7 69 80 7 93 700 5 18 41 50 5 66 76 87 98 809 17 22 40 50 5 62 6 71 5 86 91 4",
    ": 905 9 16 20 31 6 41 4 7 62 5 82 9 94",
    ": 1045 71 106 10 4 27 32 7 67 76 8 83 7 93 9 204 9 19 24 37 47 71 80 5 93 5 300",
    ": 4 10 2 6 22 9 62 7 87 97 407 12 4 21 6 31 7 45 50 65 8 79 86 91 6 510 4 26 33",
    ": 44 55 84 95 639 42 8 52 69 93 701 6 10 25 62 73 80 92 8 808 15 8 27 34 40 9",
    ": 52 63 76 86 90 910 4 22 34 8 43 8 63 70 84 9 94 9",
    ": 2019 65 79 88 96 108 29 41 5 69 85 94 8 203 9 18 21 43 5 50 8 66 74 7 85 92",
    ": 303 7 20 41 5 51 65 9 74 85 90 8 403 8 16 32 44 50 3 9 69 76 80 91 509 20 30",
    ": 5 47 52 65 72 89 96 607 13-4 20 39 43 50 60 73 84 97 703 22 9 32 41 53 9 64",
    ": 73 7 87 93 8 825 39 54 62 8 76 81 902 8 13 82 7 92",
    ": 3002 11 4 9 31 7 55 8 70 2 6 88 99 107 20 32 5 46 57 61 6 86 93 204 15 9 28",
    ": 41 74 300 4 11 32 7 56 62 7 74 7 82 90 5 8 403 9 33 49 54 64 9 91 513 9 27 44",
    ": 8 70 81 7 95 615 21 41 7 55 61 9 74 88 92 7 703 9 12 6 27 32 54 63 8 77 98",
    ": 821 38 55 9 67 73 84 94 911 26 31 46 56 65 74 8 99",
    ": 4004 28 33 60 6 71 84 95 102 15 28 38 48 69 80 8 241 58 65 78 99 324 59 71 94",
    ": 416 35 8 53 64 88 94 503 13 32 7 53 8 78 94 606 13 22 6 32 8 45 56 64 9 72 86",
    ": 96 735 41 6 51 7 64 70 90 8 809 12 5 24 9 37 42 51 6 71 7 99 912 7 30 42 62 8",
    ": 74 9 84",
    ": 5006 11 9 26 36 41 50 6 60 74 8 82 90 9 109 17 24 35 8 43 9 53 60 75 9 85 9",
    ": 95 9 208 13 23 8 34 55 68 73 7 315 40 7 51 62 85 94 408 12 9 24 31 8 44 50 68",
    ": 76 86 508 12 6 22 30 50 6 60 7 84 90 4 604 13 9 28 38 48 53 7 9 74 9 706 18",
    ": 21 31-2 44 78 83 98 804 22 7 37 43 51 61 75 80 6 9 99 902 13 20 42 7 51 9 65",
    ": 9 74 90 5",
    ": 6003 17 28 36 41 6 58 86 93 9 117 28 32 7 50 3 98 214 37 56 64 79 84 90 5 303",
    ": 13 22 8 33 9 57 66 72 7 92 414 27 30 6 44 61 6 80 92 502 11 8 24 9 32 9 43 8",
    ": 52 4 72 6 93 601 13 21-2 31 42 51 6 73 82 8 94 9 704 22 6 46 51 73 7 89 806",
    ": 13 20 4 43 7 63 70 88 908 12 23 7 51 7 64 88 95 9",
    ": 7007 11 5 20 39 58 63 72 84 8 96 106 13 40 52 8 62 72 81 6 231 7 42 9 62 73",
    ": 81 308 12 7 27 32 51 8 68 96 404 13 22 32 72 81 8 97 507 14 20 8 35 41 6 52 5",
    ": 9 62 77 92 607 12 20 34 47 51 63 74 8 91 4 737 40 56 62 86 90 5 800 13 23 41",
    ": 9 58 64 8 74 81 7 909 19 34 41 55 63 7 82 97",
    ": 8000 5 10 5 36 48 53 64 71 7 103 7 12 4 8 23 30 9 42 6 52 8 68 74 82 9 93 217",
    ": 28 34 46 52 61 7 82 93 300 8 16 25 35 8 54 9 64 84 6 94 406 12 25 65 83 90 5",
    ": 500 6 16 20 31 9 46 53 64 7 75 80 4 605 23 7 42 7 53 60 71 84 710 22 36 42 9",
    ": 75 91 7 800 5 12 9 24 30 42 50 4 77 85 9 901 5 15 20 35 9 48 54 64 87 93",
    ": 9005 11 20 6 38 42 54 8 72 81 7 99 104 24 33 51 71 86 98 202 5 9 21 5 38 55 9",
    ": 68 75 80 6 96 300 6 13 21 7 9 35 44 50 4 61 70 7 82 90 407 22 9 38 44 61 5 74",
    ": 8 86 9 95 7 502 9 21 8 33 8 42 56 61 75 9 84 92 604 13 7 21 4 7 31-2 44 8 53",
    ": 63 72 92 7 702 7 12 27 33 7 45 71 5 82 7 91 5 806 23 46 66 72 4 7 97 902 7 10",
    ": 4 28 42 50 8 60 6 70 5 81 7 93 9",
    ": 70014 29 46 9 55 81 92 104 14 26 31 5 41 7 56 62 86 9 94 218 22 6 32 4 9 43 9",
    ": 54 7 63 8 71 9 87 307 11 5 20 32 9 47 56 60 5 70 81 92 9 407 10-1 6 21 4 31",
    ": 46 51 8 69 74 81 8 93 9 516 23 9 36 43 5 55 60 6 78 86 92 613 8 24 8 33 8 47",
    ": 53 8 66 701 22 32 8 53 60 806 11 9 24 31 6 62 73 92 7 902 27 32 7 41-2 6 66",
    ": 70 90 4",
    ": 1001 11 8 29 35 53 9 64 77 83 8 102 4 13 37 46 60 3 8 92 9 203 6 11 41 3 9 65",
    ": 72 81 8 90 313 23 7 31 6 44 8 62 82 5 95 400 6 12 28 40 62 74 90 5 9 507 11 5",
    ": 33 6 41 6 51 60 72 85 601 8 11 21 5 7 32 9 43 7 65 83 7 94 700 9 15 21 5 32 7",
    ": 63 83 97 802 6 12 7 31 7 56 61 7 71 9 90 3 907 16 21 6 49 52 65 70 3 9 84 7",
    ": 93 8",
    ": 2008 28 36 45 66 75 9 89 94 117 22 35 43 56 61 74 88-9 94 6 8 219 30 42 7 50",
    ": 5 9 63 9 76 81 95 317 25 45 9 54 70 400 4 14 22 32 40 8 55 9 64 72 7 81 8 90",
    ": 501 6 15 39 47 55 71 7 91 607 12 67 714 25 9 33 7 45 61 9 71 85 809 32 6 42",
    ": 50 5 62 79 83 9 91 4 905 13 22 35 51 7 62 71 7 82 6 90 5",
    ": 3001 5 10 3 8 29 50 69 74 103 15 26 46 54 60 7 74 84 8 97 9 222 34 40 4 64 70",
    ": 80 304 24 7 30 2 79 84 90 6 402 8 18 24 35 44 51 70 84 90 4 504 12 21 8 49 57",
    ": 63 8 96 601 20 32 8 44 55 66 71 82 92 8 728 35 9 45 50 8 68 74 88 96 809 19",
    ": 24 39 43 51 63 8 73 8 84 94 904 14 37 44 73 7 91",
    ": 4003 17 21 7 33 56 61 5 70 83 93 8 112 40 3 8 52 8 64 72 83 6 98 202 10 26 30",
    ": 4 7 43 7 54 8 85 93 8 305 10 7 29 43 60 79 90 7 403 8 12 7 22 32 54 68 72 8",
    ": 83 94 506 26 32 7 60 6 71 90 9 605 11 8 23 6 37 41 65 78 85 91 5 706 18 55 65",
    ": 70 4 89 800-1 6 9 19 23 8 41 7 52 7 60 3 8 75 80 4 904 19 34 8 54 60 71 83",
    ": 5004 9 14 9 30 50 5 63 100 6 8 12 8 26 32 54 64 73 89 206 17 9 26 50 65 72 81",
    ": 6 9 96 9 305 36 41 7 63 78 83 402 5 11 6 25 32 6 70 89 94 9 505 21 9 34 9 51",
    ": 60 5 602 14 27-8 50 5 9 66 71 80 4 7 98 702 9 21 43 8 57 85 94 802 6 22 6 31",
    ": 54 8 62 7 74 8 900 5 10 6 27 33 44 50 64 86 99",
    ": 6005 22 7 30 6 40 8 56 65 9 78 84 91 9 104 9 20 6 33 8 43 9 53 9 75 87 92 203",
    ": 17 20 6 33 9 44 52 61 5 75 9 85 90 6 305 17 22 37 40 7 53 9 82 404 7 15 22 31",
    ": 6 42 54 67 79 84 90 7 505 12 22 7 55 60 75 84 90 9 610 22 36 42 58 64 8 86 97",
    ": 701 3 12 5 25 62 8 74 95 812 9 23 6 32 42 52 4 72 7 81 96 907 17 26 30 40 4",
    ": 53 8 62 80 8 94 9",
    ": 7010 9 40 62 72 9 95 109 15 35 43 54 74 81 4 8 95 201 5 9 15 21 33 43 8 53 7",
    ": 63 7 88 93 304 37 42 52 6 78 83 9 407 9 15 24 9 33 8 48 54 82 7 97 506 14 8",
    ": 26 36 74 604 12 22 32 8 53 60 77 86 705 11 21 4 30 40 4 9 72 80 96 801 9 12",
    ": 36 45 54 61 6 79 86 91 907 10 5 24 30 9 46 64 76 91",
    ": 8016 24 35 49 60 72 7 84 100 16 20 7 33 7 46 52 76 82 6 92 201 11 21 5 31 42",
    ": 5 61 5 71 6 83 91 301 6 8 14 8 23 6 32 42 6 56 63 79 86 91 402 5 12 7 24 6 31",
    ": 40 5 51 5 8 62 8 86 90 503 5 12 7 42 6 72 7 83 603 10 22 6 32 40 7 61 72 5 99",
    ": 725 32 9 44 50 60 5 82 99 807 10 9 23 39 44 9 52 6 61 9 74 8 93 9 904 30 49",
    ": 57 69 88",
    ": 9002 6 11 4 21 8 32 6 47 52 61 73 8 83 7 99 104 14 8 23 30 42 7 60 4 7 73 7",
    ": 83 97 200 5 12 8 29 43 8 52 8 62 70 4 9 83 7 96 302 12 8 24 9 34 9 46 50 69",
    ": 76 84 92 9 446 59 63 70 5 9 85 90 503 11 9 25 9 37 47 50 61 5 70 7 84 90 607",
    ": 12 27 32 48 76 80 6 91 8 705 17 30 46 51 7 61 6 72 8 99 803 16 9 23 35 44 6 8",
    ": 60 7 77 87 90 7 901 16 21 60 82 96",
    ": 80001 5 14 7 38 46 68 75 83 100 17 30 40 51 9 66 71 8 90-1 5 211 27 32 9 47",
    ": 52 8 67 9 74 81 6 90 8 304 20 5 8 39 48 53 66 70 82 8 96 406 11 7 34 41 6 63",
    ": 7 76 87 96 507 11 9 22 42 53 8 75 84 8 606 30 4 40 4 9 59 67 74 7 9 88 92 8",
    ": 713 20 3 9 35 66 72 4 80 8 94 8 803 8 15 9 24 9 35 55 8 62 6 8 73 80 4 7 94",
    ": 902 4 8 12 22 8 33 44 59",
    ": 1002 12 25 9-30 3 7 42 6 51 9 77 83 92 105 10 3 22 5 8 33 7 48 50 4 62 5 89",
    ": 92 5 9 203 15 7 22 7 55 9 63 6 71 9 93 7 302 5 13 8 20 37 9 55 8 63 81 4 95",
    ": 409 17 24 34 40 50 4 8 70 87 96 520 7 32 49 60 6 70 4 83 90 4 605 9 12 6 28",
    ": 32 4 8 70 2 82 8 92 708 13 21 4 9 34 7 41 6 61 6 71 8 86 9 811 6 20 39 43 50",
    ": 65 71 81 6 909 15 27 53 5 8 65 8 71 6 85 91 7",
    ": 2001 8 22 7 30 43 6 52 7 61 75 9 85 90 101 4 18 26 8 47 9 56 9 64 73 9 204 12",
    ": 7 20 3 31 9 43 8 60 6 82 95 301 6 15 24 35 43 53 62 5 70 8 85 94 7 400 3 7 18",
    ": 28 31 4 9 44 63 71 88 94 501 3 10 4 20 5 7 38 45 9 56 65 79 86 602 7 11 5 9",
    ": 29 34 42 58 64 71 5 9 95 700 6 11 8 25 8 30 8 41 3 50 7 62 8 71 8 83 92 5 8",
    ": 806 10 5 9 42 8 75 9 88 96 900 5 11 28 34 8 49 53 62 5 8 70 85 9 99",
    ": 3004 12 21 30 3 6 41 7 57 60 7 81 5 90 4 8 100 4 8 11 28 53 9 63 6 71 5 80 4",
    ": 9 93 213 6 20 5 32 5 46 63 83 92 300 2 6 10 2 7 21 5 8 36 52 7 60 7 9 74 90 3",
    ": 6 404 10 27 31 3 8 42 50 3 7 66 9 79 82 8 92 502 5 20 8 32 40 7 59 63 8 72 82",
    ": 7 90 610 4 27 39 48 51 7 61 6 81 5 91 709 16 25 8 51 8 68 70 4 7 82 8 94 8",
    ": 808 14 22 7 9 41 7 56 9 62 8 72 6 82 93 901 5 8 25 52 7 72 4 8 82 97",
    ": 4003 9 11 6 23 33 46 51 4 60 93 8 102 9 11 4 6 9 21 34 43 5 53 6 9 62 5 8 71",
    ": 6 81 6 90 3 8 208 11 7 20 5 9 39 45 7 76 81 6 91 4 7 307 22 33 9 48 58 60 71",
    ": 5 8 83 9 93 406 20 9 37 44 50 4 8 62 5 72 82 6 96 9 524 33 60 76 83 610 5 7",
    ": 26 8 38 57 65 9 78 86 703 8 11 23 31 6 42 8 55 60 4 79 84 95 801 16 8 23 47",
    ": 50 60 70 6 81 4 910 20 49 57 62 5 71 80 4 94",
    ": 5004 10 8 22 6 35 42 62 4 8 84 6 95 101 3 11 24 8 32 42 7 53 8 90 5 205 14 9",
    ": 28 31 7 44 7 52 7 70 96 305 14 8 22 6 30 9 54 9 71 6 80 6 98 405 8 16 21 32 6",
    ": 41 5 57 66 72 6 85 9 504 8 12 23 32 45 50 5 62 6 70 3 8 84 9 600 19 24 30 8",
    ": 41 7 57 64 7 76 80 2 7 701 20 3 7 30 5 43 9 59 69 72 8 90 5 803 7 11 5 26 30",
    ": 6 43 54 9 69 73 82 92 904 8 13 37 42 53 73 5 93 7",
    ": 6012 6 20 2 8 32 43 53 6 8 61 8 87 96 9 108 16 9 23 7 32 7 41 7 62 71 5 8 84",
    ": 9 93 6 201 9 12 9 23 9 43 8 54 60 4 8 73 8 83 98 312 20 9 42 50 9 66 72 7 82",
    ": 5 9 99 413 9 34 43 7 65 72 80 4 9 98 504 10 24 7 32 7 40 6 9 52 6 60 6 72 6",
    ": 88 90 608 12 6 23 35 44 57 60 5 70 5 9 90 701 10 26 31 3 7 49 57 60 9 85 9 94",
    ": 806 12 8 24 35 50 60 70 5 80 5 9 96 900 4 13 6 20 2 31 42 6 54 63 81 5 9 96 9",
    ": 7004 7 37 45 54 8 61 70 6 9 84 91 7-8 101 17 28 34 42 52 7 68 73 8 91 228 32",
    ": 5 44 8 51 69 79 83 8 92 301 10 25 37 41 50 67 72 7 81 5 98 408 10 6 8 25 38",
    ": 43 8 51 8 64 8 74 8 85 91 507 11 6 9 24 9 36 44 9 54 73 8 84 92 600 14 6 20 6",
    ": 38 44 53 61 9 74 81 6 90 6 9 703 10 3 6 22 7 9 39 46 55 63 72 6 80 8 96 8 804",
    ": 7 12 7 22 38 51 8 61 4 71 80 6 92-3 904 8 15 45 9 55 68 76 81-2 92",
    ": 8000 5 7 11 20 37 42 6 50 3 5 60 3 72 8 89 94 104 8 44 9 59 64 9 74 83 6 202",
    ": 5 8 13 7 40 6 55 67 70 84 9 94 303 8 15 22 5 30 3 7 41 9 55 9 77 81 8 406 13",
    ": 22 9 33 7 41 6 9 54 8 71 82 4 8 501 6 18 26 32 6 43 6 55 60 4 9 76 89 96 606",
    ": 10 5 35 8 54 77 84 7 701 4 12 6 40 5 7 56 62 72 8 86 811 8 22 34 8 40 5 50 8",
    ": 61 6 71 89 93 6 901 5 19 28 50 4 71 6 80 93",
    ": 9007 12 9 32 48 68 73 9 94 8 105 10 2 6 23 7 33 6 47 52 60 73 7 81 4 6 93 207",
    ": 11 6 30 9 45 54 7 68 77 80 4 7 99 311 22 6 34 49 54 6 60 71 89 96 9 412 22-3",
    ": 41 7 54 61 9 73 9 83 504 19 34 46 60 70 81 91 610 20 2 5 9 35 40 9 60 78 82 6",
    ": 90 7 711 5 9 24 30 4 8 45 65 70 9 83 9 91 6 811 6 20 5 31 4 8 47 52 7 68 74 9",
    ": 83 90 2 6 923 8 34 7 41 3 71 84 8 94 8",
    ": 90007 12 6 22 4 9 33 62 9 77 82 5 9 107 14 28 33 46 55 68 78 82 92 211 41 5 7",
    ": 63 7 77 82 98 314 29 40 7 51 3 70 8 85 413 8 31 6 40 6 50 61 5 9 71 87 91 502",
    ": 16 22 32 47 64 73 7 9 85 600 7 21 6 9 33 48 53 72 82 99 708 12 5 20 3 9 39 49",
    ": 51 5 8 61 6 8 78 89 802 11 28 33 40 6 51 66 70 3 8 81 93 900 10 6 20 30 4 9",
    ": 46 51 5 64 78 80 5 91 6",
    ": 1000 4 15 8 27 66 76 83 91 102 6 11 6 21 6 32 5 41 6 8 55 62 79 91 5 213 8 22",
    ": 8 32 41 9 54 77 300 10 5 9 35 41 55 62 71 8 84 92 9 405 9 23 41 9 54 7 68 76",
    ": 80 5 93 5 509 29 41 6 55 9 77 88 96 603 7 19 26 37 41 6 56 81 9 93 700 4 20 4",
    ": 36 40 50 7 68 95 9 804 11 3 30 5 44 50 66 70 87 901 6 15 25 9 35 8 42 55 72",
    ": 87 91 6",
    ": 2001 3 6 19 24 32 5 40 51 6 61 75 83 91 7 105 18 29 41 5 51 78 87 92 210 6 9",
    ": 26 8 47 9 67 92 8 303 11 4 7 20 5 44 53 7 62 7 73 6 82 5 96 405 26 31 42 5 60",
    ": 3 74 81 500 3 7 17 32 9 53 60 77 9 87 600 3 15 8 22 6 9 31 6 46 50 9 64 70 93",
    ": 709 21 5 9 52 9 70 82 91 6 812 5 22 4 34 9 63 71 5 9 908 13 7 31 45 72 8 83",
    ": 92",
    ": 3012 9 32 60 3 7 82 90 3 7 118 25 7 32 44 52 64 71 6 95 8 203 13 7 21 9 59 71",
    ": 83 91 6 302 7 18 24 31 5 40 7 50 63 72 82 6 97 406 26 32 8 40 61 7 86 95 508",
    ": 14 9 27 44 9 63 70 4 82 7 91 9 607 16 35 8 42 6 63 73 81 8 93 702 6 18 23 7",
    ": 42 64 77 80 4 95 8 803 19 27 32 42 52 61 6 9 76 81 96 907 29 38 62 7 82 7 96",
    ": 4002 6 21 37 41 6 50 6 68 72 6 86 9 93 100 4 26 48 53 67 78 84 95 215 33 8 42",
    ": 6 62 70 83 302 7 12 20 4 31 42 6 50 5 60 9 77 87 412 24 8 32 51 4 64 6 87 505",
    ": 16 26 31 53 7 63 73 8 91 5 600 8 23 34 8 43 63 9 75 9 86 703 6 16 33 47 69 74",
    ": 9 83 9 99 808 14 8 20 30 43 8 66 71 93 910 22 8 39 73 6 81",
    ": 5013 9 22 6 41 7 89 96 107 19 23 7 41 9 58 62 7 78 90 4 219 48 62 73 8 80 5",
    ": 91 5 301 9 21 8 36 49 57 88 92 420 6 35 9 50 4 60 4 9 81 6 96 501 14 26 36 42",
    ": 5 9 73 88 93 8 606 11 5 28 42 6 8 54 64 72 7 701 10 20 32 42 8-9 51 5 69 89",
    ": 92 803 37 46 51 72 81 5 907 12 6 23 7 9 36 40 53 8 88 92 6",
    ": 6003 13 21 4 47 51 6 72 8 91 7 101 5 13 6 20 6 31 9 43 8 57 69 74 7 84 9 95 9",
    ": 205 8 12 5 9 23 32 6 40 52 8 63 73 95 304 16 20 6 36 41 7 64 74 83 97 404 16",
    ": 26 36 42 8 55 7 62 5 78 83 90 8 508 15 9 24 7 44 50 7 62 9 74 9 84 7 90 6 611",
    ": 4 24 8 35 41 52 9 65 9 71 8 88 94 700 9 14 9 30 5 48 53 65 8 73 80 99 803 7",
    ": 12 6 27 35 41 54 8 71 9 85 93 7 902 5 18 24 30 5 42 50 69 72 8 83 9 94",
    ": 7011 38 43 53 63 7 73 7 96 113 7 34 9 48 58 62 7 75 9 86 92 6 9 210 24 34 8",
    ": 52 63 8 94 309 21 9 32 42 69 85 91 6 403 12 7 20 4 31 5 40 59 64 76 88 95 9",
    ": 503 12 6 20 30 55 64 71 4 7 80 96 600 3 9 13 31 6 41 54 65 77 84 8 92 717 20",
    ": 4 36 40 6 50 64 76 82 97 800-1 10 4 25 31 6 45 55 9 64 70 7 82 6 94 902 6 15",
    ": 20 4 7 31 3 6 43 8 52 6 9 65 74 7 82 6 92",
    ": 8002 8 14 22 9 36 49 64 78 82 9 93 9 108 13 5 8 28 32 5 44 50 8 68 74 86 91 6",
    ": 225 30 6 58 62 5 73 7 305 12 9 22 35 40 7 63 70 7 80 91 7 401 6 12 30 4 45 8",
    ": 53 9 64 73 7 81 90 5 500 12 31 5 9 52 8 64 73 8 84 8 95 603 20 3 5 50 4 73 8",
    ": 82 5 93 8 701 6 12 7 20 32 4 44 54 69 75 80 3 96 9 807 23 36 45 52 64 8 75 81",
    ": 9 94 904 12 7 35 48 56 61 5 9 71 4 80 7 96",
    ": 9001 7 9 12 7 20 4 7 30 5 9 57 61 4 91 104 8 14 27 30 8 43 53 63 72 6 83 91",
    ": 200 13 8 21 35 40 5 9 59 69 72 6 87 303 6 19 24 30 4 9 54 6 61 83 8 417 28 31",
    ": 6 56 70 5 83 8 94 511 29 45 9 60 3 6 77 90 6 602 33 7 44 63 77 90 703 13 23",
    ": 38 42 61 9 75 80 3 7 800 9 12 21 31 8 48 72 9 83 8 95 8 904 22 7 31 5 9 47 59",
    ": 65 73 83 8 92",
    ": 400000 4 8 19 23 38 54 7 66 77 84 7 92 100 3 21 6 42 6 50 63 8 71 80 5 93 9",
    ": 203 7 10 21 35 41 54 8 66 71 5 82 9 93 303 7 19 24 32 9 47 60 70 4 9 84 9 412",
    ": 21 5 9 40 9 53 8 67 76 87 93 8 503 11 26 30 45 59 64 70 4 91 600 5 8 20 7 41",
    ": 8 56 64 91 709 19 24 31 46 50 8 71 6 80 2 805 16 27 30 9 64 72 84 9 98 907 14",
    ": 9 28 32 7 46 62 8 76 87 92",
    ": 1001 4 11 22 7 37 45 51 5 60 73 6 102 12 9 22 9 40 5 58 63 71 8 84 7 201 5 10",
    ": 4 20 32 45 9 68 84 8 96 300 17 24 8 30 7 48 52 83 7 91 7 9 409 15 20 35 7 47",
    ": 69 75 85 9 98 503 6 9 36 40 2 9 67 70 82 604 12 35 45 54 77 82 5 704 12 33 7",
    ": 41 7 52 60 7 73 8 84 9 98 807 12 33 54 7 60 8 79 92 6 906 18 26 9 33 7 43 53",
    ": 7 61 8 71 88 92 6",
    ": 2002 21 4 8 33 9 56 63 7 71 93 104 8 10 22 31 40 6 52 66 71 8 99 213 8 23 30",
    ": 8 44 8 54 61 70 3 89 98 303 11 50 9 65 70 3 94 409 20 32 8 46 50 62 7 71-2 6",
    ": 85 90 6 505 9 15 34 9 48 53 64 72 7 80 4 95 611 4 6 9 25 9 36 40 6 51 74 81 3",
    ": 8 94 7 702 7 13 9 21 9 33 6 60 3 7 70 3 89 94 6 801 35 9 44 54 69 74 9 83 90",
    ": 905 11 22 30 88 97",
    ": 3000 5 10 4 20 3 6 48 55 68 73 110 23 8 31 6 48 65 81 5 97 203 9 16 27 37 43",
    ": 8 53 9 74 90 301 7 10 7 39 52 6 75 405 36 98 519 22 5 32 42 7 50 5 62 74 8-9",
    ": 92 605 8 14 25 9 34 60 6 76 98 707 10 2 25 30 8 46 50 7 61 6 79 88 92 802 19",
    ": 21 6 9 39 53 68 80 904 11 5 7 22 52 9 62 6 71 97",
    ": 4013 27 32 9 43 51 60 7 90 4 120 34 63 93 239 47 54 72 86 321 35 55 8 76 405",
    ": 22 43 59 68 76 82 6 93 514 8 44 52 67 87 91 8 606 11 7 22 51 8 62 8 77 83 95",
    ": 707 27 46 9 66 85 92 6 806 14 8 24 32 8 42 8 61 75 9 84 902 22 9 54 86 92",
    ": 5003 20 6 30 8 43 57 67 73 82 92 103 9 16 23 43 8 60 7 85 207 14 39 52 65 85",
    ": 93 300 9 29 49 85 408 19 27 39 49 69 92 501 14 21 45 53 81 90 8 610 37 66 85",
    ": 711 20 50 6 62 7 78 94 816 24 30 46 62 70 7 81 92 7 906 9 21 5 30 9 45 62 72",
    ": 4 88 93 7",
    ": 6048 53 68 93 104 13 6 21 8 41 6 52 62 9 74 9 88 207 12 26 30 8 67 71 7 91 5",
    ": 307 12 34 53 74 89 95 400 15 24 65 81 9 99 525 38 46 79 84 602 7 23 30 5 9 43",
    ": 61 84 723 84 92 800 27 59 66 76 87 99 904 9 22 48 64 7 83 8 99",
    ": 7024 39 43 9 54 7 78 101 17 31 6 42 51 63 7 77 81 99-200 10 9 24 32 48 56 60",
    ": 5 81 8 92 9 306 13 7 36 41 50 6 61 87 403 11 22 39 44 50 5 66 8 83 93 9 508",
    ": 17 23 33 7 43 75 82 8 604 16 33 9 46 52 76 82 9 94 704 16 23 7 41 56 64 8 80",
    ": 3 99 826 38 50 8 94 914 34 49 66 92",
    ": 8017 39 44 76 88 115 27 39 45 50 75 206 10 6 65 74 80 5 302 26 44 56 61 72 8",
    ": 91 8 404 10 7 37 42 7 66 73 98 512 27 37 49 51 8 67 71 89 94 616 29 48 61 7",
    ": 74 93 714 25 39 45 62 77 89 94 807 18 50 5 62 96 902 27 32 7 43 8 58 67 74 9",
    ": 98",
    ": 9003 7 18 21 9 39 46 52 78 96 112 20 6 53 89 95 201 18 33 84 96 309 20 66 70",
    ": 7 88 92 9 414 21 6 33 9 45 71 7 84 95 517 29 34 46 611 7 22 8 59 65 79 99 708",
    ": 20 47 54 60 70 5 87 96 801 8 30 48 54 81 90 5 903 8 36 63 81 8",
    ": 10003 9 15 76 85 98 112 8 29 44 52 7 66 74 80 6 93 8 215 20 6 32 9 46 85 300",
    ": 6 11 32 8 54 7 72 80 403 19 23 45 52 73 8 90 501 17 23 30 5 40 8 60 86 91 603",
    ": 12 28 39 51 8 64 8 74 81 90 702 15 24 61 7 71 7 84 811 21 7 31 5 40 50 60 7",
    ": 76 82 6 9 908 25 34 40 6 53 7 82 7",
    ": 1011 9 26 32 8 43 8 60 9 75 81 8 95 108 24 39 46 63 72 6 80 91 6 217 25 43 52",
    ": 6 73 6 89 96 306 16 27 40 51 60 7 71 92 412 40 6 9 61 75 9 97 507 12 21 6 31",
    ": 47 57 64 76 81 97 604 11 33 8 42 9 55 68 72 88 92 738 42 5 53 69 75 94 801 26",
    ": 33 9 45 65 76 83 6 907 29 35 41 7 59 68 80 8 95",
    ": 2000 13 9 25 32 7 41 50 5 61 4 80 95 105 12 8 24 48 55 64 7 82 9 99 276 300",
    ": 20 87 95 402 10 34 62 71 9 84 505 10 5 22 9 41 7 58 64 72 9 601 6 20 7 34 8",
    ": 56 60 76 95 723 9 35 49 52 64 70 88 93 9 803 8 20 6 34 9 50 5 69 79 96 905 10",
    ": 60 70 9 84 96",
    ": 3001 6 18 43 50 83 100 6 11 9 26 30 40 5 55 62 72 95 200 10 37 65 71 83 92 7",
    ": 303 8 18 32 55 61 7 73 81 95 408 45 50 6 72 83 510 34 48 62 89 602 14 28 33",
    ": 40 6 57 61 85 703 19 28 37 50 3 61 7 76 81 7 98 805 10 9 33 46 62 75 82 98",
    ": 907 15 24 30 6 50 5 87 98",
    ": 4043 56 72 8 94 109 20 59 73 207 21 9 41 8 60 9 74 98 309 21 31 50 7 63 99",
    ": 407 11 27 48 55 70 81 92 500 5 19 31 4 59 86 91 604 17 59 74 84 9 95 710 35",
    ": 52 8 67 70 87 92 814 9 30 59 66 70 84 90 948 63 8 95 8",
    ": 5005 12 7 21 44 8 54 7 63 8 73 9 84 106 10 7 26 37 43 53 7 80 5 92 202 6 11",
    ": 44 8 51 7 82 9 95 300 8 14 9 24 7 39 57 63 79 83 407 12 29 35 55 61 6 70 5 88",
    ": 93 512 9 25 36 52 6 66 72 87 91 7 623 30 7 48 52 7 81 8 707 12 6 27 39 46 51",
    ": 8 62 83 91 8 823 40 5 50 61 97 974 99",
    ": 6008 13 25 34 57 68 80 3 108 15 9 32 64 71 89 208 14 32 7 43 56 8 73 300 26",
    ": 33 40 4 50 6 63 7 76 83 409 13 27 41 7 75 99 503 10 26 32 8 42 6 65 71 637 42",
    ": 8 66 74 8 86 97 708 14 21 32 6 45 8 58 75 9 84 9 95 812 32 44 9 58 66 73 7 87",
    ": 92 7 901 9 14 44 60 9 75 88",
    ": 7013 9 25 39 44 68 83 98 103 19 36 40 55 69 88 99 213 28 40 73 82 93 9 323 8",
    ": 53 8 77 89 404 46 56 66 516 33 7 43 8 54 9 67 84 91 603 11 21 45 51 61 4 75",
    ": 95 700 7 18 26 32 48 52 7 67 74 9 91 814 9 28 53 60 79 907 35 9 44 82 7",
    ": 8006 13 31 8 43 51 4 62 72 8 89 95 106 45 61 79 88 93 9 214 38 50 5 9 63 71 8",
    ": 82 8 304 11 29 35 56 85 9 97 407 38 40 54 66 88 95 529 74 99 622 33 45 51 66",
    ": 80 99 714 20 34-5 62 7 79 86 92 8 824 8 33 7 54 78 81 4 8 94 8 905 10 9 25 32",
    ": 42 6 91 9",
    ": 9004 11 8 21 48 80 7 95 101 7 12 7 21 37 44 64 9 75 80 2 9 94 212 21 36 41 7",
    "special2 CAH+7 embl_tpa_tsa_prot",
    ": 3073556",
    ": 7494443 5 7-9 51 3 8-60 2-3 5 9 73-4 6-7 9-85 7-90 2 5 7-8 500-1 5 7 10-20 2",
    ": 5-8 30-1 3-4 8-40 2-3 5-6 8-9 51 3-5 7-8 60 2 4-7 9 71 3-84 6 8 90-3 5-7",
    ": 602-3 5-6 8-9 11-2 5-6 21-5 9 31 3-42 4 6-8 50 2-60 2-3 5-7 74-5 7 80 4-5 7-9",
    ": 91-9 702-14 6-8 21-30 3-4 6 8-42 4 6-7 50-1 4-8 60-5 8 70 2-4 6 9-80 5-92 4-5",
    ": 7 9-801 3 6 11-2 4-6 9 21 3-6 8-9 31 3-7 40-3 7 50 3-5 7-8 62 4 6-8 71-3 8",
    ": 82-4 7-96 900-1 3-10 2-6 9 22-4 6-8 31-6 8 42-4 7-8 50-1 3 6-9 61-5 8-9 71",
    ": 6-8 80-2 4-5 8-97 9",
    ": 5001-8 10-7 9-22 4-8 30-3 5-7 9-45 7-50 2-3 5 7-8 60 3-4 7-9 74 8 81-2 5-7",
    ": 9-93 6-8 104-7 10-1 3-5 7-27 31 4-9 41 3-6 52 4-8 60 3-4 6-71 4-80 3-6 9 91-3",
    ": 7 9-200 4 6 11-2 4 6-22 4-6 8-9 33-8 40 2-4 6-8 50-1 4-60 2-3 5-74 6-7 9 81-2",
    ": 4 7 90 5-6 8-9 303-6 10 4-5 7-8 21 4-6 9 31-2 4-5 41-3 6 8-9 51 5 7 62 5 7",
    ": 9-76 8-9 82-5 7 90 2-4 8 400-3 5 8 10 5-8 21-32 6-7 9 41 6-53 6 60-1 3-5 7-77",
    ": 80-1 3-4 6-95 8-9 503-4 7 10-1 3 6-25 7-8 30-2 4 9-44 8-9 51 4 8-66 8-9 71 3",
    ": 5-6 8 81-2 4-6 9-93 6 9-600 2 4 7-8 14 6-7 21 3 8-9 33 5 7 9-40 4-55 7 9-60",
    ": 4-7 9-75 7-8 83-4 6 8-9 92-3 7 9 701-2 4 6 8-9 13-4 8 20-3 6-30 4-43 5-8 50",
    ": 2-61 3 5-8 71-4 6-8 80 2-8 90 4-5 7-800 2-11 3 7-20 3-4 6-7 32 5 7 9 41-4 7-8",
    ": 52 5 7 9 61 3 5 8-71 4-6 8-9 81-4 6-90 3 5-6 8-908 11-3 5-8 20-3 6 8-33 5-7",
    ": 9-42 4-50 2-4 6 61 5 7 9-70 7-81 5-7 9-96",
    ": 9-6000 2 4 9 11 3 5-7 21-2 4 6-7 31 4 6-7 41 4 7 9 51-2 4 6-60 3 6-9 72 4-5",
    ": 7-88 90-2 4-104 6 9-11 4-6 8-20 3-30 2-8 42 4-5 7-9 51-4 6 9-64 6-9 71 3 7-85",
    ": 7 90-1 4-8 201-4 6 8-13 6-7 9-22 4 9-30 3 5 7-9 41-3 5-6 8-9 52-3 5-60 2-3",
    ": 5-7 70-4 6-7 81-3 6 9 91 3 5-6 9 302-10 2-8 20 3-9 31 3-5 7-40 2 4-5 7 50-1 6",
    ": 8-9 61 3 5-9 73-4 7-8 80-3 6-91 3-401 3-11 3 5 8 20-5 30 5 7-8 41-2 5-8 50-1",
    ": 3-9 61-3 5 8-9 72 8-9 82-3 6 8-9 93-4 6-9 501 3 5-6 8-11 3-7 20-7 9-32 4-8 41",
    ": 3 5-6 8-9 51 4-5 7-63 6-7 72 6 8 80 2 4-5 7 9-91 5-6 9-602 4-13 6-7 20 2-5",
    ": 7-8 33 6-7 9 41-3 5-51 3 5-7 60 2 4-5 7 9 72 4 7 80-1 3-5 7-8 90-1 3 7 9-701",
    ": 3-10 2-5 8 20 3-6 9-31 4 6 8 40 2-3 5-8 50 3-4 6-9 61 4-8 70 2 4 7 80 2-3",
    ": 5-91 4 6-800 3-5 8 10-1 4-5 21 5 9 33-4 6 8-42 4 8 51-6 8-63 7-71 4 9-84 7-9",
    ": 91-2 4 8-9 901-8 11-7 21-7 9 32 5 7-8 40-1 3-5 8-51 3-61 3-6 70 2-3 5 7 9-80",
    ": 2-3 5-8 90 3-6",
    ": 9-7003 5 11-2 4-5 7-8 20-9 32-6 8-43 6 8-51 3-6 8-66 8 70 2-6 80 2-3 5 7-91",
    ": 3-4 8 102-7 11 3-4 8 20 2 4 6 8 30-1 5 7-9 41-4 7 9 51 3 5-6 8-61 6-8 70 3",
    ": 5-6 9-80 4 6-7 9 91 3-4 6-9 201 8 24 7 32 9 44 59 61 3-4 6 71 7-8 81 3-4 6-8",
    ": 91-2 5-7 301 4-7 10 2 4 7-8 20-2 4 6 9-32 5-48 50 2-3 5-7 9 61 4-6 8 72 4-5",
    ": 7-90 2-6 8 403 5 9 11-2 4-6 8-9 23-4 7 9-30 4-5 40-7 50 2-3 6 60 4-8 70-1 4-5",
    ": 7-86 9-91 3 5-6 9 501 3 6-7 9-13 5-7 9 22-7 9 33-7 9-40 3-6 50-2 4 6-8 60-5",
    ": 70-1 4 6 8 80 2-3 7-8 91-3 6-7 9-607 9-10 3-5 20 2-3 5-6 8 30-7 9-41 3-4 6",
    ": 9-51 3-6 8-61 3 5-6 8-70 2-80 2-6 9 91-2 7-8 700-4 6-7 11 3 6 8 21 3-31 3 5-7",
    ": 40-4 7-8 50 6 8-9 61-7 9 71-2 4 6 80 2-4 6 90 2-6 8-802 4-7 9 12-3 5 7-9 21-4",
    ": 8-31 3-9 42-8 51 4-6 8-61 3-4 6 8-71 3-7 80-1 4 7-9 93 5-6 8-900 2-3 5-6 8-11",
    ": 3-8 21 3 5 7-9 31-3 5 7-8 40 3 5-6 8-9 51-3 5-6 8-9 61 3-4 9-70 2-7 81-2 5-7",
    ": 90 2 4-5 7",
    ": 9-8001 9-11 4 7 22-3 6-8 32-4 6-41 4-5 7 52-4 6-8 61 3-6 8-80 3-6 9-93 7-8",
    ": 101 3 5 7-8 10-3 5 7-24 7-35 7-8 40-1 5-50 2-4 6 8 61-5 8 70-3 7 9 82 5 7-90",
    ": 2 4-6 8 200-1 4-5 8-12 4-20 3 8 30-5 8-40 2-6 50-1 3 5-7 62 5 8-70 2 4 6 9",
    ": 81-4 9-91 5 7-8 300-1 3-13 6-7 9 21 3-30 3-9 42-4 7-9 52-5 7-63 5-8 70-82 4-6",
    ": 8-93 5-6 9 401 3-5 7-8 10-5 9 21-8 31-2 4 6 8-9 42 4-7 9-54 6-8 62-3 5 7 9-72",
    ": 4-5 7-80 2-3 5-7 9 91-4 7-500 5-7 9 11-4 6 9-21 3 5-8 30-5 8-47 9 51-5 7-9",
    ": 61-4 8-71 5-82 4-93 5 9-600 3-5 7-9 11 3 5-6 9-22 4-9 31-2 4-5 7-43 5-9 52-6",
    ": 8-60 2-5 7-71 3-9 81 4-91 4-5 7 9-701 4-6 9-18 24 6 8-9 31 4-7 40-1 3-4 6",
    ": 9-52 4 6-61 4-5 7-8 70 2-4 6 8-80 3 5-6 8 90 2 4 6-7 9-800 2-3 5 7-9 11-2 4 6",
    ": 8-24 6-34 8-9 41-3 5-8 50-8 60-1 3 6-7 70-2 5-84 8-9 91-2 6 8 900 2-4 8-9 12",
    ": 9-21 4 6-7 31 3-4 7-9 42-3 5-50 3-4 6 8-9 61-2 4-71 5-6 81-2 6 90-1 3 5-7",
    ": 9000-4 9-10 2-3 6 8-21 3-35 7-8 40-2 4 6-7 50-4 6-62 5 7 9 72 4 6-8 80-1 3-7",
    ": 9-93 5-8 100 4 7-8 12 4-5 7-8 22-3 6 31-2 4-5 7-43 5-9 51-4 6-7 9 62 4-5 7",
    ": 70-1 3-5 8-80 2-3 7 90 2 4-5 7-209 11-4 6-7 20 2-37 41-2 5 7-8 50-3 8 60-4",
    ": 6-7 9-72 4-5 8 80-6 8-90 2-3 5 7 9 303-4 6 8 10 3 8 21-2 4 6 8-30 2-3 5-6",
    ": 44-6 8-51 3-5 8 60-1 3 5 7 78 83 90 8 404 6-7 12-4 9-21 3 5 7-30 2-4 6-7 9-42",
    ": 4-8 50-1 3 7 9 62-3 5-6 8 74-8 81-9 91 4-8 500-1 3-4 8 10-3 5-20 2 5-6 31-3",
    ": 5-8 40 3 5 8-55 7 60-1 3-5 7-8 70 2-3 9 81-2 4-5 7 9-90 3-4 7 9-600 4-6 8-10",
    ": 2 4 7-8 20 2 4-5 7-8 30-1 3-7 9-40 2 4-9 52-61 3 5-7 9 71-2 4 6-7 9-83 8 90-1",
    ": 3 5-6 700 2 7-10 3-9 21 8-32 4-5 7 9 42-5 7-8 50-1 4 6-7 9-60 3 5-71 4 6-7",
    ": 83-4 6-90 2 4 8 800 2-13 5-6 8 21 3-6 8-30 2-4 6-7 9-40 2-7 9-51 3-7 9-61",
    ": 4-81 4-5 7 93-4 6 8-900 2-4 6-10 2-8 21 3 6 8-33 5-40 2-5 7-8 50-1 3 5 7-61",
    ": 5-8 71-5 7 9-81 4-5 7 9 92 5-6",
    ": 500001-3 5-7 12-3 7-8 21-3 5 7-8 30 2-5 8-41 3-4 8-51 3 8-64 6-7 9 71 4 6 8",
    ": 80 3-4 90 3 5 7-8 100-4 6 8-11 3-6 8-9 23-6 9 31 5-6 8-41 3 6 8 51-6 8 60-4 6",
    ": 8-72 4-6 81 3-5 7-8 92-3 5 7 9 201-3 5 7-8 10-3 8 20-2 4-5 7-31 3 7-9 41-2",
    ": 5-7 50-1 3-4 6-7 60 2-3 5-9 71 3-4 6-8 80-1 3-5 7-91 5-6 8 300 3-5 7-10 2-4",
    ": 6-9 21-2 4-5 8-9 31 3 5 7 9 43-9 51-3 7-8 60 2-3 5 7-8 70-4 6-9 82 5-6 9-96 8",
    ": 400 2-3 5-6 10-2 4-5 7-8 20 2 7 9-30 3-6 8-42 4-5 7 51-2 4-5 7 60 2 4 7-8",
    ": 70-1 4-5 7-9 81-2 6-7 9-90 2 7-503 6-9 11-2 4 6 8 21 5-6 8 31-2 4 7 9 41 7-8",
    ": 51 3 5-6 8 61-7 9-71 5 8-85 8-92 4 6 8-9 603-5 7-10 2-4 9 22-3 7-9 31 3-8",
    ": 41-8 50-4 6-8 60-1 4 7-8 71 3 6-8 81 6-92 4-5 7 9-702 4-14 6-7 21 3-5 7-9",
    ": 32-5 8 42-9 52-62 4-7 70-3 5-82 5 7-8 92-3 5-805 7 10-2 6 9-20 4-9 32 5-8",
    ": 41-3 5-