#!/bin/bash

ROMDIR=/tmp/romdir.$$
DATFILE=mrboom.dat
ROMFILE=mrboom.rom

H=../../sdl2/sdl2_data.h
mkdir $ROMDIR
cd GFX/
cat GAME1.PCX GAME2.PCX GAME3.PCX SPRITE.PCX SPRITE2.PCX MENU.PCX SPRITE3.PCX DRAW1.PCX DRAW2.PCX MED.PCX MED3.PCX VIC1.PCX VIC2.PCX VIC3.PCX VIC4.PCX NEIGE1.PCX NEIGE2.PCX NEIGE3.PCX PIC.PCX MRFOND.PCX MICRO.PCX NUAGE1.PCX NUAGE2.PCX FORET.PCX FEUILLE.PCX PAUSE.PCX MEDC.PCX MEDG.PCX NEIGE1.MRB MICRO1.MRB JUNGLE1.MRB ROSE1.MRB FETE1.MRB CRAYON.PCX CRAYON2.PCX NUAGE1.MRB LAPIN1.PCX MORT.PCX LAPIN2.PCX LAPIN3.PCX LAPIN4.PCX FOOT.PCX FOOT1.MRB FOOT2.MRB FETE2.MRB NEIGE2.MRB ROSE2.MRB JUNGLE2.MRB MICRO2.MRB NUAGE2.MRB SOUCOUPE.PCX SOCCER.PCX FOOTANIM.PCX LUNE1.MRB LUNE2.MRB > $ROMDIR/$DATFILE
cd -
cd SOUND
cp -f * $ROMDIR/
cd ..
cd $ROMDIR
if [ "$1" == "sdl" ]
then
zip -9 $ROM *.WAV 
H=../../../sdl/sdl_data.h
else
zip -9 $ROMFILE $DATFILE *.WAV *.XM *.MOD 
fi
cd -
echo -n "char dataRom[] = " > $H
hexdump -v -e '16/1 "_x%02X" "\n"' $ROMDIR/$ROMFILE | sed 's/_/\\/g; s/\\x  //g; s/.*/    "&"/' >> $H
echo ";" >> $H
rm -rf $ROMDIR

