/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.LongCollection;
import com.carrotsearch.hppc.LongLookupContainer;
import com.carrotsearch.hppc.cursors.LongCursor;
import com.carrotsearch.hppc.predicates.LongPredicate;
import java.util.Arrays;

abstract class AbstractLongCollection
implements LongCollection {
    AbstractLongCollection() {
    }

    public int removeAll(LongLookupContainer c) {
        final LongLookupContainer c2 = c;
        return this.removeAll(new LongPredicate(){

            public boolean apply(long k) {
                return c2.contains(k);
            }
        });
    }

    public int retainAll(LongLookupContainer c) {
        final LongLookupContainer c2 = c;
        return this.removeAll(new LongPredicate(){

            public boolean apply(long k) {
                return !c2.contains(k);
            }
        });
    }

    public int retainAll(final LongPredicate predicate) {
        return this.removeAll(new LongPredicate(){

            public boolean apply(long value) {
                return !predicate.apply(value);
            }
        });
    }

    public long[] toArray() {
        int size = this.size();
        long[] array = new long[size];
        int i = 0;
        for (LongCursor c : this) {
            array[i++] = c.value;
        }
        return array;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }
}

