/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2018 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


#ifndef CLEAVE_SPEC_HPP
#define CLEAVE_SPEC_HPP


/////////////////////// Qt includes
#include <QString>
#include <QList>


/////////////////////// Local includes
#include "exportimportconfig.h"
#include "CleaveMotif.hpp"
#include "CleaveRule.hpp"


namespace MsXpS
{

namespace libXpertMass
{


class DECLSPEC CleaveSpec : public PolChemDefEntity
{
  public:
  CleaveSpec(PolChemDefCstSPtr, QString, QString = QString());

  CleaveSpec(const CleaveSpec &other);
  ~CleaveSpec();

  using PolChemDefEntity::operator=;
  CleaveSpec &operator=(const CleaveSpec &other);

  void setPattern(const QString &);
  const QString &pattern();

  QList<CleaveMotif *> *motifList();
  QList<CleaveRule *> *ruleList();

  static int isNameInList(const QString &,
                          const QList<CleaveSpec *> &,
                          CleaveSpec *other = nullptr);

  bool parse();

  using PolChemDefEntity::validate;
  bool validate();

  bool renderXmlClsElement(const QDomElement &, int);

  QString *formatXmlClsElement(int, const QString & = QString("  "));

  protected:
  //! Pattern.
  QString m_pattern;

  //! List of cleavage motifs.
  QList<CleaveMotif *> m_motifList; // "Lys/" and -Lys/Pro and...

  //! List of cleavage rules.
  QList<CleaveRule *> m_ruleList; // Cleavage conditions...
};

} // namespace libXpertMass

} // namespace MsXpS


#endif // CLEAVE_SPEC_HPP
