/*
    VLDocking Framework 2.1
    Copyright VLSOLUTIONS, 2004-2006

    email : info@vlsolutions.com
------------------------------------------------------------------------
This software is distributed under the CeCILL license, a GNU GPL-compatible
license adapted to french law.
French and English license headers are provided at the begining of
the source files of this software application.
------------------------------------------------------------------------
LICENCE CeCILL (FRENCH VERSION).
------------------------------------------------------------------------
Ce logiciel est un programme informatique servant  amliorer les interfaces
homme-machine d'applications Java bases sur Swing, en leur apportant un
ensemble de fonctions relatives au dockage des composants.

Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA
sur le site "http://www.cecill.info".

En contrepartie de l'accessibilit au code source et des droits de copie,
de modification et de redistribution accords par cette licence, il n'est
offert aux utilisateurs qu'une garantie limite.  Pour les mmes raisons,
seule une responsabilit restreinte pse sur l'auteur du programme,  le
titulaire des droits patrimoniaux et les concdants successifs.

A cet gard  l'attention de l'utilisateur est attire sur les risques
associs au chargement,   l'utilisation,   la modification et/ou au
dveloppement et  la reproduction du logiciel par l'utilisateur tant
donn sa spcificit de logiciel libre, qui peut le rendre complexe 
manipuler et qui le rserve donc  des dveloppeurs et des professionnels
avertis possdant  des  connaissances  informatiques approfondies.  Les
utilisateurs sont donc invits  charger  et  tester  l'adquation  du
logiciel  leurs besoins dans des conditions permettant d'assurer la
scurit de leurs systmes et ou de leurs donnes et, plus gnralement,
 l'utiliser et l'exploiter dans les mmes conditions de scurit.

Le fait que vous puissiez accder  cet en-tte signifie que vous avez
pris connaissance de la licence CeCILL, et que vous en avez accept les
termes.

------------------------------------------------------------------------
CeCILL License (ENGLISH VERSION)
------------------------------------------------------------------------

This software is a computer program whose purpose is to enhance Human-Computer
Interfaces written in Java with the Swing framework, providing them a set of
functions related to component docking.

This software is governed by the CeCILL  license under French law and
abiding by the rules of distribution of free software.  You can  use,
modify and/ or redistribute the software under the terms of the CeCILL
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info".

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability.

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or
data to be ensured and,  more generally, to use and operate it in the
same conditions as regards security.

The fact that you are presently reading this means that you have had
knowledge of the CeCILL license and that you accept its terms.

*/


package com.vlsolutions.swing.docking.event;

import com.vlsolutions.swing.docking.ui.DockingUISettings;
import java.awt.event.*;

import com.vlsolutions.swing.docking.*;
import javax.swing.*;

/** An event send to a dockDropReceiver to complete a drop operation
 * <p>
 * This event is used by API extenders to manage drag and drop action related to
 * docking. This is not meant to be used by User Applications.
 *
 * <p>
 * The dockDropReceiver can accept or reject the drop.
 * <p>
 * If the drop is accepted, the receiver must process the docking operation,
 * (usually by invoking a docking method on the desktop).
 *
 * @author Lilian Chamontin, vlsolutions.
 * @version 1.0
 * */
public class DockDropEvent extends DockEvent {
  
  private DockingDesktop desk;
  private boolean accepted;
  
  public DockDropEvent(DockingDesktop desk, DockableDragSource source, MouseEvent event) {
    super(desk, source, event);
    this.desk = desk;
  }
  
  
  /** shortcut for acceptDrop(true).
   * <p>
   * If the drop is accepted, the receiver must process the docking operation,
   * (usually by invoking a docking method on the desktop).
   * <p>
   * As of version 2.1, a DockingActionEvent has been added to the DockEvent class, adding
   * a "semantic" description of the docking operation. The DropReceiver must call
   * setDockingAction() before acceptDrop().
   * <p>
   * It is still the responsability of the drop receiver to process the docking operation.
   * */
  public void acceptDrop(){
    acceptDrop(true);
  }
  
  /** notifies the event manager that docking is accepted.
   * <p>
   * If the drop is accepted, the receiver must process the docking operation,
   * (usually by invoking a docking method on the desktop).
   *
   * @param remove  if true, the docking desktop will remove the dragged dockable
   * from its containment hierarchy. If false, it is the responsibility of the
   * DockDropReceiver to remove (or simply move) the dragged dockable.
   * <p> for example, accepting drop without removing the component is saving
   * a lot of processing for TabbedDockableContainers when the dragged component
   * already belongs to their tabs.
   * */
  public void acceptDrop(boolean remove){
    this.accepted = true;
    if (remove){
      DockableState state = desk.getContext().getDockableState(source.getDockable());
      DockingDesktop sourceDesktop;
      if (state == null){
        // this should happen only with whole tabs drags as they don't have any state
        // associated with them (bug ?)
        if (source instanceof TabbedDockableContainer){
          Dockable d1 = ((TabbedDockableContainer)source).getDockableAt(0);
          state = desk.getContext().getDockableState(d1);
          sourceDesktop = state.getDesktop();
        } else {
          throw new RuntimeException("unmanaged dockable drag source : " + source);
        }
      } else {
        sourceDesktop = state.getDesktop();
      }
      if (sourceDesktop != null){
        sourceDesktop.dropRemove(source);
      }
    }
  }
  
  /** It is still time to reject a drop, although the standard way is by denying the
   * previous drag operation. */
  public void rejectDrop(){
    UIManager.getLookAndFeel().provideErrorFeedback(desk);
  }
  
  /** Indicates if the drop operation is accepted.
   * <p>
   * Once rejected (with <code>rejectDrop</code>, it is not possible to re-accept it
   * */
  public boolean isDropAccepted() {
    return accepted;
  }
  
}
