# @file    TestSyncAnnotation.rb
# @brief   tests for improved syncAnnotation functions
#
# @author  Akiya Jouraku (Ruby conversion)
# @author  Sarah Keating 
# 
# ====== WARNING ===== WARNING ===== WARNING ===== WARNING ===== WARNING ======
#
# DO NOT EDIT THIS FILE.
#
# This file was generated automatically by converting the file located at
# src/sbml/test/TestSyncAnnotation.cpp
# using the conversion program dev/utilities/translateTests/translateTests.pl.
# Any changes made here will be lost the next time the file is regenerated.
#
# -----------------------------------------------------------------------------
# This file is part of libSBML.  Please visit http://sbml.org for more
# information about SBML, and the latest version of libSBML.
#
# Copyright 2005-2010 California Institute of Technology.
# Copyright 2002-2005 California Institute of Technology and
#                     Japan Science and Technology Corporation.
# 
# This library is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation.  A copy of the license agreement is provided
# in the file named "LICENSE.txt" included with this software distribution
# and also available online as http://sbml.org/software/libsbml/license.html
# -----------------------------------------------------------------------------
require 'test/unit'
require 'libSBML'

class TestSyncAnnotation < Test::Unit::TestCase

  def equals(*x)
    case x.size
    when 2
      e, s = x
      return e == s
    when 1
      e, = x
      return e == @@oss.str()
    end
  end

  def setup
    filename = "../../sbml/annotation/test/test-data/annotationL3_2.xml"
    @@d = LibSBML::readSBML(filename)
    @@m = @@d.getModel()
  end

  def teardown
    @@d = nil
  end

  def test_SyncAnnotation_deleteCVTerms
    c = @@m.getCompartment(1)
    xml = LibSBML::RDFAnnotationParser.deleteRDFCVTermAnnotation(c.getAnnotation())
    expected = "<annotation>\n" + 
    "  <jd2:JDesignerLayout version=\"2.0\" MajorVersion=\"2\" MinorVersion=\"0\" BuildVersion=\"41\">\n" + 
    "    <jd2:header>\n" + 
    "      <jd2:VersionHeader JDesignerVersion=\"2.0\"/>\n" + 
    "      <jd2:ModelHeader Author=\"Mr Untitled\" ModelVersion=\"0.0\" ModelTitle=\"untitled\"/>\n" + 
    "      <jd2:TimeCourseDetails timeStart=\"0\" timeEnd=\"10\" numberOfPoints=\"1000\"/>\n" + 
    "    </jd2:header>\n" + 
    "  </jd2:JDesignerLayout>\n" + 
    "  <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n" + 
    "    <rdf:Description rdf:about=\"#_000003\">\n" + 
    "      <dc:creator>\n" + 
    "        <rdf:Bag>\n" + 
    "          <rdf:li rdf:parseType=\"Resource\">\n" + 
    "            <vCard:N rdf:parseType=\"Resource\">\n" + 
    "              <vCard:Family>Le Novere</vCard:Family>\n" + 
    "              <vCard:Given>Nicolas</vCard:Given>\n" + 
    "            </vCard:N>\n" + 
    "            <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n" + 
    "            <vCard:ORG>\n" + 
    "              <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n" + 
    "            </vCard:ORG>\n" + 
    "          </rdf:li>\n" + 
    "        </rdf:Bag>\n" + 
    "      </dc:creator>\n" + 
    "      <dcterms:created rdf:parseType=\"Resource\">\n" + 
    "        <dcterms:W3CDTF>2005-02-02T14:56:11</dcterms:W3CDTF>\n" + 
    "      </dcterms:created>\n" + 
    "      <dcterms:modified rdf:parseType=\"Resource\">\n" + 
    "        <dcterms:W3CDTF>2006-05-30T10:46:02</dcterms:W3CDTF>\n" + 
    "      </dcterms:modified>\n" + 
    "    </rdf:Description>\n" + 
    "    <rdf:Description>\n" + 
    "      <rdf:other/>\n" + 
    "    </rdf:Description>\n" + 
    "  </rdf:RDF>\n" + 
    "</annotation>"
    assert_equal true, equals(expected,xml.toXMLString())
  end

  def test_SyncAnnotation_deleteModelOnly
    c = @@m.getCompartment(1)
    xml = LibSBML::RDFAnnotationParser.deleteRDFHistoryAnnotation(c.getAnnotation())
    expected = "<annotation>\n" + 
    "  <jd2:JDesignerLayout version=\"2.0\" MajorVersion=\"2\" MinorVersion=\"0\" BuildVersion=\"41\">\n" + 
    "    <jd2:header>\n" + 
    "      <jd2:VersionHeader JDesignerVersion=\"2.0\"/>\n" + 
    "      <jd2:ModelHeader Author=\"Mr Untitled\" ModelVersion=\"0.0\" ModelTitle=\"untitled\"/>\n" + 
    "      <jd2:TimeCourseDetails timeStart=\"0\" timeEnd=\"10\" numberOfPoints=\"1000\"/>\n" + 
    "    </jd2:header>\n" + 
    "  </jd2:JDesignerLayout>\n" + 
    "  <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n" + 
    "    <rdf:Description rdf:about=\"#_000003\">\n" + 
    "      <bqbiol:is>\n" + 
    "        <rdf:Bag>\n" + 
    "          <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n" + 
    "        </rdf:Bag>\n" + 
    "      </bqbiol:is>\n" + 
    "    </rdf:Description>\n" + 
    "    <rdf:Description>\n" + 
    "      <rdf:other/>\n" + 
    "    </rdf:Description>\n" + 
    "  </rdf:RDF>\n" + 
    "</annotation>"
    assert_equal true, equals(expected,xml.toXMLString())
  end

  def test_SyncAnnotation_deleteModelOnly_1
    c = @@m.getCompartment(7)
    xml = LibSBML::RDFAnnotationParser.deleteRDFHistoryAnnotation(c.getAnnotation())
    expected = "<annotation>\n" + 
    "  <jd2:JDesignerLayout version=\"2.0\" MajorVersion=\"2\" MinorVersion=\"0\" BuildVersion=\"41\">\n" + 
    "    <jd2:header>\n" + 
    "      <jd2:VersionHeader JDesignerVersion=\"2.0\"/>\n" + 
    "      <jd2:ModelHeader Author=\"Mr Untitled\" ModelVersion=\"0.0\" ModelTitle=\"untitled\"/>\n" + 
    "      <jd2:TimeCourseDetails timeStart=\"0\" timeEnd=\"10\" numberOfPoints=\"1000\"/>\n" + 
    "    </jd2:header>\n" + 
    "  </jd2:JDesignerLayout>\n" + 
    "</annotation>"
    assert_equal true, equals(expected,xml.toXMLString())
    xml = LibSBML::RDFAnnotationParser.deleteRDFHistoryAnnotation(nil)
    assert( xml == nil )
    xml = LibSBML::RDFAnnotationParser.deleteRDFHistoryAnnotation(LibSBML::XMLNode.convertStringToXMLNode("<notannotatio/>"))
    assert( xml == nil )
  end

  def test_SyncAnnotation_modifyBoth_1
    c = @@m.getCompartment(0)
    mh = @@m.getModelHistory().clone()
    cv = @@m.getCVTerm(0).clone()
    c.setModelHistory(mh)
    c.addCVTerm(cv)
    c.unsetCVTerms()
    expected = "<compartment metaid=\"_000002\" id=\"comp1\" constant=\"true\">\n" + 
    "  <annotation>\n" + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n" + 
    "      <rdf:Description rdf:about=\"#_000002\">\n" + 
    "        <dc:creator>\n" + 
    "          <rdf:Bag>\n" + 
    "            <rdf:li rdf:parseType=\"Resource\">\n" + 
    "              <vCard:N rdf:parseType=\"Resource\">\n" + 
    "                <vCard:Family>Le Novere</vCard:Family>\n" + 
    "                <vCard:Given>Nicolas</vCard:Given>\n" + 
    "              </vCard:N>\n" + 
    "              <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n" + 
    "              <vCard:ORG rdf:parseType=\"Resource\">\n" + 
    "                <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n" + 
    "              </vCard:ORG>\n" + 
    "            </rdf:li>\n" + 
    "          </rdf:Bag>\n" + 
    "        </dc:creator>\n" + 
    "        <dcterms:created rdf:parseType=\"Resource\">\n" + 
    "          <dcterms:W3CDTF>2005-02-02T14:56:11Z</dcterms:W3CDTF>\n" + 
    "        </dcterms:created>\n" + 
    "        <dcterms:modified rdf:parseType=\"Resource\">\n" + 
    "          <dcterms:W3CDTF>2006-05-30T10:46:02Z</dcterms:W3CDTF>\n" + 
    "        </dcterms:modified>\n" + 
    "      </rdf:Description>\n" + 
    "    </rdf:RDF>\n" + 
    "  </annotation>\n" + 
    "</compartment>"
    assert_equal true, equals(expected,c.toSBML())
    c.unsetModelHistory()
    c.addCVTerm(cv)
    expected1 = "<compartment metaid=\"_000002\" id=\"comp1\" constant=\"true\">\n" + 
    "  <annotation>\n" + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n" + 
    "      <rdf:Description rdf:about=\"#_000002\">\n" + 
    "        <bqbiol:is>\n" + 
    "          <rdf:Bag>\n" + 
    "            <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n" + 
    "          </rdf:Bag>\n" + 
    "        </bqbiol:is>\n" + 
    "      </rdf:Description>\n" + 
    "    </rdf:RDF>\n" + 
    "  </annotation>\n" + 
    "</compartment>"
    assert_equal true, equals(expected1,c.toSBML())
    c.setModelHistory(mh)
    c.unsetCVTerms()
    c.addCVTerm(cv)
    expected2 = "<compartment metaid=\"_000002\" id=\"comp1\" constant=\"true\">\n" + 
    "  <annotation>\n" + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n" + 
    "      <rdf:Description rdf:about=\"#_000002\">\n" + 
    "        <dc:creator>\n" + 
    "          <rdf:Bag>\n" + 
    "            <rdf:li rdf:parseType=\"Resource\">\n" + 
    "              <vCard:N rdf:parseType=\"Resource\">\n" + 
    "                <vCard:Family>Le Novere</vCard:Family>\n" + 
    "                <vCard:Given>Nicolas</vCard:Given>\n" + 
    "              </vCard:N>\n" + 
    "              <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n" + 
    "              <vCard:ORG rdf:parseType=\"Resource\">\n" + 
    "                <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n" + 
    "              </vCard:ORG>\n" + 
    "            </rdf:li>\n" + 
    "          </rdf:Bag>\n" + 
    "        </dc:creator>\n" + 
    "        <dcterms:created rdf:parseType=\"Resource\">\n" + 
    "          <dcterms:W3CDTF>2005-02-02T14:56:11Z</dcterms:W3CDTF>\n" + 
    "        </dcterms:created>\n" + 
    "        <dcterms:modified rdf:parseType=\"Resource\">\n" + 
    "          <dcterms:W3CDTF>2006-05-30T10:46:02Z</dcterms:W3CDTF>\n" + 
    "        </dcterms:modified>\n" + 
    "        <bqbiol:is>\n" + 
    "          <rdf:Bag>\n" + 
    "            <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n" + 
    "          </rdf:Bag>\n" + 
    "        </bqbiol:is>\n" + 
    "      </rdf:Description>\n" + 
    "    </rdf:RDF>\n" + 
    "  </annotation>\n" + 
    "</compartment>"
    assert_equal true, equals(expected2,c.toSBML())
  end

  def test_SyncAnnotation_modifyBoth_2
    c = @@m.getCompartment(0)
    mh = @@m.getModelHistory().clone()
    cv = @@m.getCVTerm(0).clone()
    c.setModelHistory(mh)
    c.unsetModelHistory()
    c.addCVTerm(cv)
    expected = "<compartment metaid=\"_000002\" id=\"comp1\" constant=\"true\">\n" + 
    "  <annotation>\n" + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n" + 
    "      <rdf:Description rdf:about=\"#_000002\">\n" + 
    "        <bqbiol:is>\n" + 
    "          <rdf:Bag>\n" + 
    "            <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n" + 
    "          </rdf:Bag>\n" + 
    "        </bqbiol:is>\n" + 
    "      </rdf:Description>\n" + 
    "    </rdf:RDF>\n" + 
    "  </annotation>\n" + 
    "</compartment>"
    assert_equal true, equals(expected,c.toSBML())
  end

  def test_SyncAnnotation_modifyBoth_3
    c = @@m.getCompartment(0)
    mh = @@m.getModelHistory().clone()
    cv = @@m.getCVTerm(0).clone()
    c.setModelHistory(mh)
    c.addCVTerm(cv)
    expected = "<compartment metaid=\"_000002\" id=\"comp1\" constant=\"true\">\n" + 
    "  <annotation>\n" + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n" + 
    "      <rdf:Description rdf:about=\"#_000002\">\n" + 
    "        <dc:creator>\n" + 
    "          <rdf:Bag>\n" + 
    "            <rdf:li rdf:parseType=\"Resource\">\n" + 
    "              <vCard:N rdf:parseType=\"Resource\">\n" + 
    "                <vCard:Family>Le Novere</vCard:Family>\n" + 
    "                <vCard:Given>Nicolas</vCard:Given>\n" + 
    "              </vCard:N>\n" + 
    "              <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n" + 
    "              <vCard:ORG rdf:parseType=\"Resource\">\n" + 
    "                <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n" + 
    "              </vCard:ORG>\n" + 
    "            </rdf:li>\n" + 
    "          </rdf:Bag>\n" + 
    "        </dc:creator>\n" + 
    "        <dcterms:created rdf:parseType=\"Resource\">\n" + 
    "          <dcterms:W3CDTF>2005-02-02T14:56:11Z</dcterms:W3CDTF>\n" + 
    "        </dcterms:created>\n" + 
    "        <dcterms:modified rdf:parseType=\"Resource\">\n" + 
    "          <dcterms:W3CDTF>2006-05-30T10:46:02Z</dcterms:W3CDTF>\n" + 
    "        </dcterms:modified>\n" + 
    "        <bqbiol:is>\n" + 
    "          <rdf:Bag>\n" + 
    "            <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n" + 
    "          </rdf:Bag>\n" + 
    "        </bqbiol:is>\n" + 
    "      </rdf:Description>\n" + 
    "    </rdf:RDF>\n" + 
    "  </annotation>\n" + 
    "</compartment>"
    assert_equal true, equals(expected,c.toSBML())
  end

  def test_SyncAnnotation_modifyBoth_4
    c = @@m.getCompartment(1)
    mh = c.getModelHistory().clone()
    cv = c.getCVTerm(0).clone()
    c.unsetModelHistory()
    c.unsetCVTerms()
    expected = "<compartment metaid=\"_000003\" id=\"A\" constant=\"true\">\n" + 
    "  <annotation>\n" + 
    "    <jd2:JDesignerLayout version=\"2.0\" MajorVersion=\"2\" MinorVersion=\"0\" BuildVersion=\"41\">\n" + 
    "      <jd2:header>\n" + 
    "        <jd2:VersionHeader JDesignerVersion=\"2.0\"/>\n" + 
    "        <jd2:ModelHeader Author=\"Mr Untitled\" ModelVersion=\"0.0\" ModelTitle=\"untitled\"/>\n" + 
    "        <jd2:TimeCourseDetails timeStart=\"0\" timeEnd=\"10\" numberOfPoints=\"1000\"/>\n" + 
    "      </jd2:header>\n" + 
    "    </jd2:JDesignerLayout>\n" + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n" + 
    "      <rdf:Description>\n" + 
    "        <rdf:other/>\n" + 
    "      </rdf:Description>\n" + 
    "    </rdf:RDF>\n" + 
    "  </annotation>\n" + 
    "</compartment>"
    assert_equal true, equals(expected,c.toSBML())
    c.setModelHistory(mh)
    c.addCVTerm(cv)
    c.unsetCVTerms()
    expected1 = "<compartment metaid=\"_000003\" id=\"A\" constant=\"true\">\n" + 
    "  <annotation>\n" + 
    "    <jd2:JDesignerLayout version=\"2.0\" MajorVersion=\"2\" MinorVersion=\"0\" BuildVersion=\"41\">\n" + 
    "      <jd2:header>\n" + 
    "        <jd2:VersionHeader JDesignerVersion=\"2.0\"/>\n" + 
    "        <jd2:ModelHeader Author=\"Mr Untitled\" ModelVersion=\"0.0\" ModelTitle=\"untitled\"/>\n" + 
    "        <jd2:TimeCourseDetails timeStart=\"0\" timeEnd=\"10\" numberOfPoints=\"1000\"/>\n" + 
    "      </jd2:header>\n" + 
    "    </jd2:JDesignerLayout>\n" + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n" + 
    "      <rdf:Description rdf:about=\"#_000003\">\n" + 
    "        <dc:creator>\n" + 
    "          <rdf:Bag>\n" + 
    "            <rdf:li rdf:parseType=\"Resource\">\n" + 
    "              <vCard:N rdf:parseType=\"Resource\">\n" + 
    "                <vCard:Family>Le Novere</vCard:Family>\n" + 
    "                <vCard:Given>Nicolas</vCard:Given>\n" + 
    "              </vCard:N>\n" + 
    "              <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n" + 
    "              <vCard:ORG rdf:parseType=\"Resource\">\n" + 
    "                <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n" + 
    "              </vCard:ORG>\n" + 
    "            </rdf:li>\n" + 
    "          </rdf:Bag>\n" + 
    "        </dc:creator>\n" + 
    "        <dcterms:created rdf:parseType=\"Resource\">\n" + 
    "          <dcterms:W3CDTF>2005-02-02T14:56:11Z</dcterms:W3CDTF>\n" + 
    "        </dcterms:created>\n" + 
    "        <dcterms:modified rdf:parseType=\"Resource\">\n" + 
    "          <dcterms:W3CDTF>2006-05-30T10:46:02Z</dcterms:W3CDTF>\n" + 
    "        </dcterms:modified>\n" + 
    "      </rdf:Description>\n" + 
    "      <rdf:Description>\n" + 
    "        <rdf:other/>\n" + 
    "      </rdf:Description>\n" + 
    "    </rdf:RDF>\n" + 
    "  </annotation>\n" + 
    "</compartment>"
    assert_equal true, equals(expected1,c.toSBML())
    c.unsetModelHistory()
    c.unsetCVTerms()
    c.addCVTerm(cv)
    expected2 = "<compartment metaid=\"_000003\" id=\"A\" constant=\"true\">\n" + 
    "  <annotation>\n" + 
    "    <jd2:JDesignerLayout version=\"2.0\" MajorVersion=\"2\" MinorVersion=\"0\" BuildVersion=\"41\">\n" + 
    "      <jd2:header>\n" + 
    "        <jd2:VersionHeader JDesignerVersion=\"2.0\"/>\n" + 
    "        <jd2:ModelHeader Author=\"Mr Untitled\" ModelVersion=\"0.0\" ModelTitle=\"untitled\"/>\n" + 
    "        <jd2:TimeCourseDetails timeStart=\"0\" timeEnd=\"10\" numberOfPoints=\"1000\"/>\n" + 
    "      </jd2:header>\n" + 
    "    </jd2:JDesignerLayout>\n" + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n" + 
    "      <rdf:Description rdf:about=\"#_000003\">\n" + 
    "        <bqbiol:is>\n" + 
    "          <rdf:Bag>\n" + 
    "            <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n" + 
    "          </rdf:Bag>\n" + 
    "        </bqbiol:is>\n" + 
    "      </rdf:Description>\n" + 
    "      <rdf:Description>\n" + 
    "        <rdf:other/>\n" + 
    "      </rdf:Description>\n" + 
    "    </rdf:RDF>\n" + 
    "  </annotation>\n" + 
    "</compartment>"
    assert_equal true, equals(expected2,c.toSBML())
    c.unsetModelHistory()
    c.unsetCVTerms()
    c.addCVTerm(cv)
    c.setModelHistory(mh)
    expected3 = "<compartment metaid=\"_000003\" id=\"A\" constant=\"true\">\n" + 
    "  <annotation>\n" + 
    "    <jd2:JDesignerLayout version=\"2.0\" MajorVersion=\"2\" MinorVersion=\"0\" BuildVersion=\"41\">\n" + 
    "      <jd2:header>\n" + 
    "        <jd2:VersionHeader JDesignerVersion=\"2.0\"/>\n" + 
    "        <jd2:ModelHeader Author=\"Mr Untitled\" ModelVersion=\"0.0\" ModelTitle=\"untitled\"/>\n" + 
    "        <jd2:TimeCourseDetails timeStart=\"0\" timeEnd=\"10\" numberOfPoints=\"1000\"/>\n" + 
    "      </jd2:header>\n" + 
    "    </jd2:JDesignerLayout>\n" + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n" + 
    "      <rdf:Description rdf:about=\"#_000003\">\n" + 
    "        <dc:creator>\n" + 
    "          <rdf:Bag>\n" + 
    "            <rdf:li rdf:parseType=\"Resource\">\n" + 
    "              <vCard:N rdf:parseType=\"Resource\">\n" + 
    "                <vCard:Family>Le Novere</vCard:Family>\n" + 
    "                <vCard:Given>Nicolas</vCard:Given>\n" + 
    "              </vCard:N>\n" + 
    "              <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n" + 
    "              <vCard:ORG rdf:parseType=\"Resource\">\n" + 
    "                <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n" + 
    "              </vCard:ORG>\n" + 
    "            </rdf:li>\n" + 
    "          </rdf:Bag>\n" + 
    "        </dc:creator>\n" + 
    "        <dcterms:created rdf:parseType=\"Resource\">\n" + 
    "          <dcterms:W3CDTF>2005-02-02T14:56:11Z</dcterms:W3CDTF>\n" + 
    "        </dcterms:created>\n" + 
    "        <dcterms:modified rdf:parseType=\"Resource\">\n" + 
    "          <dcterms:W3CDTF>2006-05-30T10:46:02Z</dcterms:W3CDTF>\n" + 
    "        </dcterms:modified>\n" + 
    "        <bqbiol:is>\n" + 
    "          <rdf:Bag>\n" + 
    "            <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n" + 
    "          </rdf:Bag>\n" + 
    "        </bqbiol:is>\n" + 
    "      </rdf:Description>\n" + 
    "      <rdf:Description>\n" + 
    "        <rdf:other/>\n" + 
    "      </rdf:Description>\n" + 
    "    </rdf:RDF>\n" + 
    "  </annotation>\n" + 
    "</compartment>"
    assert_equal true, equals(expected3,c.toSBML())
  end

  def test_SyncAnnotation_modifyCVTerms_1
    c = @@m.getCompartment(4)
    cv = c.getCVTerm(0).clone()
    c.unsetCVTerms()
    c.addCVTerm(cv)
    expected = "<compartment metaid=\"_000012\" id=\"cc\" constant=\"true\">\n" + 
    "  <annotation>\n" + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n" + 
    "      <rdf:Description rdf:about=\"#_000012\">\n" + 
    "        <bqbiol:is>\n" + 
    "          <rdf:Bag>\n" + 
    "            <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n" + 
    "          </rdf:Bag>\n" + 
    "        </bqbiol:is>\n" + 
    "      </rdf:Description>\n" + 
    "    </rdf:RDF>\n" + 
    "  </annotation>\n" + 
    "</compartment>"
    assert_equal true, equals(expected,c.toSBML())
  end

  def test_SyncAnnotation_modifyCVTerms_2
    @@m.unsetCVTerms()
    expected = "<annotation>\n" + 
    "  <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n" + 
    "    <rdf:Description rdf:about=\"#_000001\">\n" + 
    "      <dc:creator>\n" + 
    "        <rdf:Bag>\n" + 
    "          <rdf:li rdf:parseType=\"Resource\">\n" + 
    "            <vCard:N rdf:parseType=\"Resource\">\n" + 
    "              <vCard:Family>Le Novere</vCard:Family>\n" + 
    "              <vCard:Given>Nicolas</vCard:Given>\n" + 
    "            </vCard:N>\n" + 
    "            <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n" + 
    "            <vCard:ORG>\n" + 
    "              <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n" + 
    "            </vCard:ORG>\n" + 
    "          </rdf:li>\n" + 
    "        </rdf:Bag>\n" + 
    "      </dc:creator>\n" + 
    "      <dcterms:created rdf:parseType=\"Resource\">\n" + 
    "        <dcterms:W3CDTF>2005-02-02T14:56:11</dcterms:W3CDTF>\n" + 
    "      </dcterms:created>\n" + 
    "      <dcterms:modified rdf:parseType=\"Resource\">\n" + 
    "        <dcterms:W3CDTF>2006-05-30T10:46:02</dcterms:W3CDTF>\n" + 
    "      </dcterms:modified>\n" + 
    "    </rdf:Description>\n" + 
    "  </rdf:RDF>\n" + 
    "</annotation>"
    assert_equal true, equals(expected,@@m.getAnnotation().toXMLString())
  end

  def test_SyncAnnotation_modifyCVTerms_3
    cv = @@m.getCVTerm(0).clone()
    @@m.unsetCVTerms()
    @@m.addCVTerm(cv)
    expected = "<annotation>\n" + 
    "  <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n" + 
    "    <rdf:Description rdf:about=\"#_000001\">\n" + 
    "      <dc:creator>\n" + 
    "        <rdf:Bag>\n" + 
    "          <rdf:li rdf:parseType=\"Resource\">\n" + 
    "            <vCard:N rdf:parseType=\"Resource\">\n" + 
    "              <vCard:Family>Le Novere</vCard:Family>\n" + 
    "              <vCard:Given>Nicolas</vCard:Given>\n" + 
    "            </vCard:N>\n" + 
    "            <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n" + 
    "            <vCard:ORG>\n" + 
    "              <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n" + 
    "            </vCard:ORG>\n" + 
    "          </rdf:li>\n" + 
    "        </rdf:Bag>\n" + 
    "      </dc:creator>\n" + 
    "      <dcterms:created rdf:parseType=\"Resource\">\n" + 
    "        <dcterms:W3CDTF>2005-02-02T14:56:11</dcterms:W3CDTF>\n" + 
    "      </dcterms:created>\n" + 
    "      <dcterms:modified rdf:parseType=\"Resource\">\n" + 
    "        <dcterms:W3CDTF>2006-05-30T10:46:02</dcterms:W3CDTF>\n" + 
    "      </dcterms:modified>\n" + 
    "      <bqbiol:is>\n" + 
    "        <rdf:Bag>\n" + 
    "          <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n" + 
    "        </rdf:Bag>\n" + 
    "      </bqbiol:is>\n" + 
    "    </rdf:Description>\n" + 
    "  </rdf:RDF>\n" + 
    "</annotation>"
    assert_equal true, equals(expected,@@m.getAnnotation().toXMLString())
  end

  def test_SyncAnnotation_modifyCVTerms_4
    cv = @@m.getCVTerm(0).clone()
    c = @@m.getCompartment(0)
    c.addCVTerm(cv)
    expected = "<compartment metaid=\"_000002\" id=\"comp1\" constant=\"true\">\n" + 
    "  <annotation>\n" + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n" + 
    "      <rdf:Description rdf:about=\"#_000002\">\n" + 
    "        <bqbiol:is>\n" + 
    "          <rdf:Bag>\n" + 
    "            <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n" + 
    "          </rdf:Bag>\n" + 
    "        </bqbiol:is>\n" + 
    "      </rdf:Description>\n" + 
    "    </rdf:RDF>\n" + 
    "  </annotation>\n" + 
    "</compartment>"
    assert_equal true, equals(expected,c.toSBML())
  end

  def test_SyncAnnotation_modifyCVTerms_5
    c = @@m.getCompartment(6)
    cv = c.getCVTerm(0).clone()
    c.unsetCVTerms()
    c.addCVTerm(cv)
    expected = "<compartment metaid=\"_000042\" id=\"cc1\" constant=\"true\">\n" + 
    "  <annotation>\n" + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n" + 
    "      <rdf:Description rdf:about=\"#_000042\">\n" + 
    "        <bqbiol:is>\n" + 
    "          <rdf:Bag>\n" + 
    "            <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n" + 
    "          </rdf:Bag>\n" + 
    "        </bqbiol:is>\n" + 
    "      </rdf:Description>\n" + 
    "      <rdf:Description/>\n" + 
    "    </rdf:RDF>\n" + 
    "  </annotation>\n" + 
    "</compartment>"
    assert_equal true, equals(expected,c.toSBML())
  end

  def test_SyncAnnotation_modifyHistory_1
    c = @@m.getCompartment(3)
    mh = c.getModelHistory().clone()
    c.unsetModelHistory()
    c.setModelHistory(mh)
    expected = "<compartment metaid=\"_000004\" id=\"C\" constant=\"true\">\n" + 
    "  <annotation>\n" + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n" + 
    "      <rdf:Description rdf:about=\"#_000004\">\n" + 
    "        <dc:creator>\n" + 
    "          <rdf:Bag>\n" + 
    "            <rdf:li rdf:parseType=\"Resource\">\n" + 
    "              <vCard:N rdf:parseType=\"Resource\">\n" + 
    "                <vCard:Family>Le Novere</vCard:Family>\n" + 
    "                <vCard:Given>Nicolas</vCard:Given>\n" + 
    "              </vCard:N>\n" + 
    "              <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n" + 
    "              <vCard:ORG rdf:parseType=\"Resource\">\n" + 
    "                <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n" + 
    "              </vCard:ORG>\n" + 
    "            </rdf:li>\n" + 
    "          </rdf:Bag>\n" + 
    "        </dc:creator>\n" + 
    "        <dcterms:created rdf:parseType=\"Resource\">\n" + 
    "          <dcterms:W3CDTF>2005-02-02T14:56:11Z</dcterms:W3CDTF>\n" + 
    "        </dcterms:created>\n" + 
    "        <dcterms:modified rdf:parseType=\"Resource\">\n" + 
    "          <dcterms:W3CDTF>2006-05-30T10:46:02Z</dcterms:W3CDTF>\n" + 
    "        </dcterms:modified>\n" + 
    "      </rdf:Description>\n" + 
    "    </rdf:RDF>\n" + 
    "  </annotation>\n" + 
    "</compartment>"
    assert_equal true, equals(expected,c.toSBML())
  end

  def test_SyncAnnotation_modifyHistory_2
    @@m.unsetModelHistory()
    expected = "<annotation>\n" + 
    "  <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n" + 
    "    <rdf:Description rdf:about=\"#_000001\">\n" + 
    "      <bqbiol:is>\n" + 
    "        <rdf:Bag>\n" + 
    "          <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n" + 
    "        </rdf:Bag>\n" + 
    "      </bqbiol:is>\n" + 
    "    </rdf:Description>\n" + 
    "  </rdf:RDF>\n" + 
    "</annotation>"
    assert_equal true, equals(expected,@@m.getAnnotation().toXMLString())
  end

  def test_SyncAnnotation_modifyHistory_3
    mh = @@m.getModelHistory().clone()
    @@m.unsetModelHistory()
    @@m.setModelHistory(mh)
    expected = "<annotation>\n" + 
    "  <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n" + 
    "    <rdf:Description rdf:about=\"#_000001\">\n" + 
    "      <dc:creator>\n" + 
    "        <rdf:Bag>\n" + 
    "          <rdf:li rdf:parseType=\"Resource\">\n" + 
    "            <vCard:N rdf:parseType=\"Resource\">\n" + 
    "              <vCard:Family>Le Novere</vCard:Family>\n" + 
    "              <vCard:Given>Nicolas</vCard:Given>\n" + 
    "            </vCard:N>\n" + 
    "            <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n" + 
    "            <vCard:ORG rdf:parseType=\"Resource\">\n" + 
    "              <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n" + 
    "            </vCard:ORG>\n" + 
    "          </rdf:li>\n" + 
    "        </rdf:Bag>\n" + 
    "      </dc:creator>\n" + 
    "      <dcterms:created rdf:parseType=\"Resource\">\n" + 
    "        <dcterms:W3CDTF>2005-02-02T14:56:11Z</dcterms:W3CDTF>\n" + 
    "      </dcterms:created>\n" + 
    "      <dcterms:modified rdf:parseType=\"Resource\">\n" + 
    "        <dcterms:W3CDTF>2006-05-30T10:46:02Z</dcterms:W3CDTF>\n" + 
    "      </dcterms:modified>\n" + 
    "      <bqbiol:is>\n" + 
    "        <rdf:Bag>\n" + 
    "          <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n" + 
    "        </rdf:Bag>\n" + 
    "      </bqbiol:is>\n" + 
    "    </rdf:Description>\n" + 
    "  </rdf:RDF>\n" + 
    "</annotation>"
    assert_equal true, equals(expected,@@m.getAnnotation().toXMLString())
  end

  def test_SyncAnnotation_modifyHistory_4
    c = @@m.getCompartment(0)
    mh = @@m.getModelHistory().clone()
    c.setModelHistory(mh)
    expected = "<compartment metaid=\"_000002\" id=\"comp1\" constant=\"true\">\n" + 
    "  <annotation>\n" + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n" + 
    "      <rdf:Description rdf:about=\"#_000002\">\n" + 
    "        <dc:creator>\n" + 
    "          <rdf:Bag>\n" + 
    "            <rdf:li rdf:parseType=\"Resource\">\n" + 
    "              <vCard:N rdf:parseType=\"Resource\">\n" + 
    "                <vCard:Family>Le Novere</vCard:Family>\n" + 
    "                <vCard:Given>Nicolas</vCard:Given>\n" + 
    "              </vCard:N>\n" + 
    "              <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n" + 
    "              <vCard:ORG rdf:parseType=\"Resource\">\n" + 
    "                <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n" + 
    "              </vCard:ORG>\n" + 
    "            </rdf:li>\n" + 
    "          </rdf:Bag>\n" + 
    "        </dc:creator>\n" + 
    "        <dcterms:created rdf:parseType=\"Resource\">\n" + 
    "          <dcterms:W3CDTF>2005-02-02T14:56:11Z</dcterms:W3CDTF>\n" + 
    "        </dcterms:created>\n" + 
    "        <dcterms:modified rdf:parseType=\"Resource\">\n" + 
    "          <dcterms:W3CDTF>2006-05-30T10:46:02Z</dcterms:W3CDTF>\n" + 
    "        </dcterms:modified>\n" + 
    "      </rdf:Description>\n" + 
    "    </rdf:RDF>\n" + 
    "  </annotation>\n" + 
    "</compartment>"
    assert_equal true, equals(expected,c.toSBML())
  end

  def test_SyncAnnotation_modifyHistory_5
    c = @@m.getCompartment(5)
    mh = c.getModelHistory().clone()
    c.unsetModelHistory()
    c.setModelHistory(mh)
    expected = "<compartment metaid=\"_000032\" id=\"C1\" constant=\"true\">\n" + 
    "  <annotation>\n" + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n" + 
    "      <rdf:Description rdf:about=\"#_000032\">\n" + 
    "        <dc:creator>\n" + 
    "          <rdf:Bag>\n" + 
    "            <rdf:li rdf:parseType=\"Resource\">\n" + 
    "              <vCard:N rdf:parseType=\"Resource\">\n" + 
    "                <vCard:Family>Le Novere</vCard:Family>\n" + 
    "                <vCard:Given>Nicolas</vCard:Given>\n" + 
    "              </vCard:N>\n" + 
    "              <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n" + 
    "              <vCard:ORG rdf:parseType=\"Resource\">\n" + 
    "                <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n" + 
    "              </vCard:ORG>\n" + 
    "            </rdf:li>\n" + 
    "          </rdf:Bag>\n" + 
    "        </dc:creator>\n" + 
    "        <dcterms:created rdf:parseType=\"Resource\">\n" + 
    "          <dcterms:W3CDTF>2005-02-02T14:56:11Z</dcterms:W3CDTF>\n" + 
    "        </dcterms:created>\n" + 
    "        <dcterms:modified rdf:parseType=\"Resource\">\n" + 
    "          <dcterms:W3CDTF>2006-05-30T10:46:02Z</dcterms:W3CDTF>\n" + 
    "        </dcterms:modified>\n" + 
    "      </rdf:Description>\n" + 
    "      <rdf:other/>\n" + 
    "    </rdf:RDF>\n" + 
    "  </annotation>\n" + 
    "</compartment>"
    assert_equal true, equals(expected,c.toSBML())
  end

  def test_SyncAnnotation_noChanges_1
    c = @@m.getCompartment(1)
    expected = "<compartment metaid=\"_000003\" id=\"A\" constant=\"true\">\n" + 
    "  <annotation>\n" + 
    "    <jd2:JDesignerLayout version=\"2.0\" MajorVersion=\"2\" MinorVersion=\"0\" BuildVersion=\"41\">\n" + 
    "      <jd2:header>\n" + 
    "        <jd2:VersionHeader JDesignerVersion=\"2.0\"/>\n" + 
    "        <jd2:ModelHeader Author=\"Mr Untitled\" ModelVersion=\"0.0\" ModelTitle=\"untitled\"/>\n" + 
    "        <jd2:TimeCourseDetails timeStart=\"0\" timeEnd=\"10\" numberOfPoints=\"1000\"/>\n" + 
    "      </jd2:header>\n" + 
    "    </jd2:JDesignerLayout>\n" + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n" + 
    "      <rdf:Description rdf:about=\"#_000003\">\n" + 
    "        <dc:creator>\n" + 
    "          <rdf:Bag>\n" + 
    "            <rdf:li rdf:parseType=\"Resource\">\n" + 
    "              <vCard:N rdf:parseType=\"Resource\">\n" + 
    "                <vCard:Family>Le Novere</vCard:Family>\n" + 
    "                <vCard:Given>Nicolas</vCard:Given>\n" + 
    "              </vCard:N>\n" + 
    "              <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n" + 
    "              <vCard:ORG>\n" + 
    "                <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n" + 
    "              </vCard:ORG>\n" + 
    "            </rdf:li>\n" + 
    "          </rdf:Bag>\n" + 
    "        </dc:creator>\n" + 
    "        <dcterms:created rdf:parseType=\"Resource\">\n" + 
    "          <dcterms:W3CDTF>2005-02-02T14:56:11</dcterms:W3CDTF>\n" + 
    "        </dcterms:created>\n" + 
    "        <dcterms:modified rdf:parseType=\"Resource\">\n" + 
    "          <dcterms:W3CDTF>2006-05-30T10:46:02</dcterms:W3CDTF>\n" + 
    "        </dcterms:modified>\n" + 
    "        <bqbiol:is>\n" + 
    "          <rdf:Bag>\n" + 
    "            <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n" + 
    "          </rdf:Bag>\n" + 
    "        </bqbiol:is>\n" + 
    "      </rdf:Description>\n" + 
    "      <rdf:Description>\n" + 
    "        <rdf:other/>\n" + 
    "      </rdf:Description>\n" + 
    "    </rdf:RDF>\n" + 
    "  </annotation>\n" + 
    "</compartment>"
    assert_equal true, equals(expected,c.toSBML())
  end

  def test_SyncAnnotation_noChanges_2
    expected = "<annotation>\n" + 
    "  <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n" + 
    "    <rdf:Description rdf:about=\"#_000001\">\n" + 
    "      <dc:creator>\n" + 
    "        <rdf:Bag>\n" + 
    "          <rdf:li rdf:parseType=\"Resource\">\n" + 
    "            <vCard:N rdf:parseType=\"Resource\">\n" + 
    "              <vCard:Family>Le Novere</vCard:Family>\n" + 
    "              <vCard:Given>Nicolas</vCard:Given>\n" + 
    "            </vCard:N>\n" + 
    "            <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n" + 
    "            <vCard:ORG>\n" + 
    "              <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n" + 
    "            </vCard:ORG>\n" + 
    "          </rdf:li>\n" + 
    "        </rdf:Bag>\n" + 
    "      </dc:creator>\n" + 
    "      <dcterms:created rdf:parseType=\"Resource\">\n" + 
    "        <dcterms:W3CDTF>2005-02-02T14:56:11</dcterms:W3CDTF>\n" + 
    "      </dcterms:created>\n" + 
    "      <dcterms:modified rdf:parseType=\"Resource\">\n" + 
    "        <dcterms:W3CDTF>2006-05-30T10:46:02</dcterms:W3CDTF>\n" + 
    "      </dcterms:modified>\n" + 
    "      <bqbiol:is>\n" + 
    "        <rdf:Bag>\n" + 
    "          <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n" + 
    "        </rdf:Bag>\n" + 
    "      </bqbiol:is>\n" + 
    "    </rdf:Description>\n" + 
    "  </rdf:RDF>\n" + 
    "</annotation>"
    assert_equal true, equals(expected,@@m.getAnnotation().toXMLString())
  end

  def test_SyncAnnotation_stringChangesMetaid
    c = LibSBML::Compartment.new(3,1)
    c.setMetaId("_000005")
    c.setId("A")
    addedAnn = "<annotation>\n" + 
    "  <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n" + 
    "    <rdf:Description rdf:about=\"#_000003\">\n" + 
    "      <dc:creator>\n" + 
    "        <rdf:Bag>\n" + 
    "          <rdf:li rdf:parseType=\"Resource\">\n" + 
    "            <vCard:N rdf:parseType=\"Resource\">\n" + 
    "              <vCard:Family>Le Novere</vCard:Family>\n" + 
    "              <vCard:Given>Nicolas</vCard:Given>\n" + 
    "            </vCard:N>\n" + 
    "            <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n" + 
    "            <vCard:ORG rdf:parseType=\"Resource\">\n" + 
    "              <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n" + 
    "            </vCard:ORG>\n" + 
    "          </rdf:li>\n" + 
    "        </rdf:Bag>\n" + 
    "      </dc:creator>\n" + 
    "      <dcterms:created rdf:parseType=\"Resource\">\n" + 
    "        <dcterms:W3CDTF>2005-02-02T14:56:11</dcterms:W3CDTF>\n" + 
    "      </dcterms:created>\n" + 
    "      <dcterms:modified rdf:parseType=\"Resource\">\n" + 
    "        <dcterms:W3CDTF>2006-05-30T10:46:02</dcterms:W3CDTF>\n" + 
    "      </dcterms:modified>\n" + 
    "      <bqbiol:is>\n" + 
    "        <rdf:Bag>\n" + 
    "          <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n" + 
    "        </rdf:Bag>\n" + 
    "      </bqbiol:is>\n" + 
    "    </rdf:Description>\n" + 
    "  </rdf:RDF>\n" + 
    "</annotation>"
    c.setAnnotation(addedAnn)
    expected = "<compartment metaid=\"_000005\" id=\"A\">\n" + 
    "  <annotation>\n" + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n" + 
    "      <rdf:Description rdf:about=\"#_000005\">\n" + 
    "        <dc:creator>\n" + 
    "          <rdf:Bag>\n" + 
    "            <rdf:li rdf:parseType=\"Resource\">\n" + 
    "              <vCard:N rdf:parseType=\"Resource\">\n" + 
    "                <vCard:Family>Le Novere</vCard:Family>\n" + 
    "                <vCard:Given>Nicolas</vCard:Given>\n" + 
    "              </vCard:N>\n" + 
    "              <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n" + 
    "              <vCard:ORG rdf:parseType=\"Resource\">\n" + 
    "                <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n" + 
    "              </vCard:ORG>\n" + 
    "            </rdf:li>\n" + 
    "          </rdf:Bag>\n" + 
    "        </dc:creator>\n" + 
    "        <dcterms:created rdf:parseType=\"Resource\">\n" + 
    "          <dcterms:W3CDTF>2005-02-02T14:56:11Z</dcterms:W3CDTF>\n" + 
    "        </dcterms:created>\n" + 
    "        <dcterms:modified rdf:parseType=\"Resource\">\n" + 
    "          <dcterms:W3CDTF>2006-05-30T10:46:02Z</dcterms:W3CDTF>\n" + 
    "        </dcterms:modified>\n" + 
    "        <bqbiol:is>\n" + 
    "          <rdf:Bag>\n" + 
    "            <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n" + 
    "          </rdf:Bag>\n" + 
    "        </bqbiol:is>\n" + 
    "      </rdf:Description>\n" + 
    "    </rdf:RDF>\n" + 
    "  </annotation>\n" + 
    "</compartment>"
    assert_equal true, equals(expected,c.toSBML())
  end

  def test_SyncAnnotation_stringChangesMetaid_1
    c = LibSBML::Model.new(2,3)
    c.setMetaId("_000005")
    c.setId("A")
    addedAnn = "<annotation>\n" + 
    "  <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n" + 
    "    <rdf:Description rdf:about=\"#_000001\">\n" + 
    "      <dc:creator>\n" + 
    "        <rdf:Bag>\n" + 
    "          <rdf:li rdf:parseType=\"Resource\">\n" + 
    "            <vCard:N rdf:parseType=\"Resource\">\n" + 
    "              <vCard:Family>Le Novere</vCard:Family>\n" + 
    "              <vCard:Given>Nicolas</vCard:Given>\n" + 
    "            </vCard:N>\n" + 
    "            <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n" + 
    "            <vCard:ORG rdf:parseType=\"Resource\">\n" + 
    "              <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n" + 
    "            </vCard:ORG>\n" + 
    "          </rdf:li>\n" + 
    "        </rdf:Bag>\n" + 
    "      </dc:creator>\n" + 
    "      <dcterms:created rdf:parseType=\"Resource\">\n" + 
    "        <dcterms:W3CDTF>2005-02-02T14:56:11</dcterms:W3CDTF>\n" + 
    "      </dcterms:created>\n" + 
    "      <dcterms:modified rdf:parseType=\"Resource\">\n" + 
    "        <dcterms:W3CDTF>2006-05-30T10:46:02</dcterms:W3CDTF>\n" + 
    "      </dcterms:modified>\n" + 
    "      <bqbiol:is>\n" + 
    "        <rdf:Bag>\n" + 
    "          <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n" + 
    "        </rdf:Bag>\n" + 
    "      </bqbiol:is>\n" + 
    "    </rdf:Description>\n" + 
    "  </rdf:RDF>\n" + 
    "</annotation>"
    c.setAnnotation(addedAnn)
    expected = "<model metaid=\"_000005\" id=\"A\">\n" + 
    "  <annotation>\n" + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n" + 
    "      <rdf:Description rdf:about=\"#_000005\">\n" + 
    "        <dc:creator rdf:parseType=\"Resource\">\n" + 
    "          <rdf:Bag>\n" + 
    "            <rdf:li rdf:parseType=\"Resource\">\n" + 
    "              <vCard:N rdf:parseType=\"Resource\">\n" + 
    "                <vCard:Family>Le Novere</vCard:Family>\n" + 
    "                <vCard:Given>Nicolas</vCard:Given>\n" + 
    "              </vCard:N>\n" + 
    "              <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n" + 
    "              <vCard:ORG>\n" + 
    "                <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n" + 
    "              </vCard:ORG>\n" + 
    "            </rdf:li>\n" + 
    "          </rdf:Bag>\n" + 
    "        </dc:creator>\n" + 
    "        <dcterms:created rdf:parseType=\"Resource\">\n" + 
    "          <dcterms:W3CDTF>2005-02-02T14:56:11Z</dcterms:W3CDTF>\n" + 
    "        </dcterms:created>\n" + 
    "        <dcterms:modified rdf:parseType=\"Resource\">\n" + 
    "          <dcterms:W3CDTF>2006-05-30T10:46:02Z</dcterms:W3CDTF>\n" + 
    "        </dcterms:modified>\n" + 
    "        <bqbiol:is>\n" + 
    "          <rdf:Bag>\n" + 
    "            <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n" + 
    "          </rdf:Bag>\n" + 
    "        </bqbiol:is>\n" + 
    "      </rdf:Description>\n" + 
    "    </rdf:RDF>\n" + 
    "  </annotation>\n" + 
    "</model>"
    assert_equal true, equals(expected,c.toSBML())
  end

  def test_SyncAnnotation_stringChangesMetaid_2
    c = LibSBML::Compartment.new(2,3)
    c.setMetaId("_000005")
    c.setId("A")
    addedAnn = "<annotation>\n" + 
    "  <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n" + 
    "    <rdf:Description rdf:about=\"#_000001\">\n" + 
    "      <bqbiol:is>\n" + 
    "        <rdf:Bag>\n" + 
    "          <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n" + 
    "        </rdf:Bag>\n" + 
    "      </bqbiol:is>\n" + 
    "    </rdf:Description>\n" + 
    "  </rdf:RDF>\n" + 
    "</annotation>"
    c.setAnnotation(addedAnn)
    expected = "<compartment metaid=\"_000005\" id=\"A\">\n" + 
    "  <annotation>\n" + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n" + 
    "      <rdf:Description rdf:about=\"#_000005\">\n" + 
    "        <bqbiol:is>\n" + 
    "          <rdf:Bag>\n" + 
    "            <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n" + 
    "          </rdf:Bag>\n" + 
    "        </bqbiol:is>\n" + 
    "      </rdf:Description>\n" + 
    "    </rdf:RDF>\n" + 
    "  </annotation>\n" + 
    "</compartment>"
    assert_equal true, equals(expected,c.toSBML())
  end

  def test_SyncAnnotation_stringChangesMetaid_3
    c = LibSBML::Model.new(3,1)
    c.setMetaId("_000005")
    c.setId("A")
    addedAnn = "<annotation>\n" + 
    "  <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n" + 
    "    <rdf:Description rdf:about=\"#_000001\">\n" + 
    "      <dc:creator>\n" + 
    "        <rdf:Bag>\n" + 
    "          <rdf:li rdf:parseType=\"Resource\">\n" + 
    "            <vCard:N rdf:parseType=\"Resource\">\n" + 
    "              <vCard:Family>Le Novere</vCard:Family>\n" + 
    "              <vCard:Given>Nicolas</vCard:Given>\n" + 
    "            </vCard:N>\n" + 
    "            <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n" + 
    "            <vCard:ORG>\n" + 
    "              <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n" + 
    "            </vCard:ORG>\n" + 
    "          </rdf:li>\n" + 
    "        </rdf:Bag>\n" + 
    "      </dc:creator>\n" + 
    "      <dcterms:created rdf:parseType=\"Resource\">\n" + 
    "        <dcterms:W3CDTF>2005-02-02T14:56:11</dcterms:W3CDTF>\n" + 
    "      </dcterms:created>\n" + 
    "      <dcterms:modified rdf:parseType=\"Resource\">\n" + 
    "        <dcterms:W3CDTF>2006-05-30T10:46:02</dcterms:W3CDTF>\n" + 
    "      </dcterms:modified>\n" + 
    "      <bqbiol:is>\n" + 
    "        <rdf:Bag>\n" + 
    "          <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n" + 
    "        </rdf:Bag>\n" + 
    "      </bqbiol:is>\n" + 
    "    </rdf:Description>\n" + 
    "  </rdf:RDF>\n" + 
    "</annotation>"
    c.setAnnotation(addedAnn)
    expected = "<model metaid=\"_000005\" id=\"A\">\n" + 
    "  <annotation>\n" + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n" + 
    "      <rdf:Description rdf:about=\"#_000005\">\n" + 
    "        <dc:creator>\n" + 
    "          <rdf:Bag>\n" + 
    "            <rdf:li rdf:parseType=\"Resource\">\n" + 
    "              <vCard:N rdf:parseType=\"Resource\">\n" + 
    "                <vCard:Family>Le Novere</vCard:Family>\n" + 
    "                <vCard:Given>Nicolas</vCard:Given>\n" + 
    "              </vCard:N>\n" + 
    "              <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n" + 
    "              <vCard:ORG rdf:parseType=\"Resource\">\n" + 
    "                <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n" + 
    "              </vCard:ORG>\n" + 
    "            </rdf:li>\n" + 
    "          </rdf:Bag>\n" + 
    "        </dc:creator>\n" + 
    "        <dcterms:created rdf:parseType=\"Resource\">\n" + 
    "          <dcterms:W3CDTF>2005-02-02T14:56:11Z</dcterms:W3CDTF>\n" + 
    "        </dcterms:created>\n" + 
    "        <dcterms:modified rdf:parseType=\"Resource\">\n" + 
    "          <dcterms:W3CDTF>2006-05-30T10:46:02Z</dcterms:W3CDTF>\n" + 
    "        </dcterms:modified>\n" + 
    "        <bqbiol:is>\n" + 
    "          <rdf:Bag>\n" + 
    "            <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n" + 
    "          </rdf:Bag>\n" + 
    "        </bqbiol:is>\n" + 
    "      </rdf:Description>\n" + 
    "    </rdf:RDF>\n" + 
    "  </annotation>\n" + 
    "</model>"
    assert_equal true, equals(expected,c.toSBML())
  end

  def test_SyncAnnotation_stringHistoryWhenNotValid
    c = LibSBML::Compartment.new(2,4)
    c.setMetaId("_000003")
    c.setId("A")
    addedAnn = "<annotation>\n" + 
    "  <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n" + 
    "    <rdf:Description rdf:about=\"#_000005\">\n" + 
    "      <dc:creator>\n" + 
    "        <rdf:Bag>\n" + 
    "          <rdf:li rdf:parseType=\"Resource\">\n" + 
    "            <vCard:N rdf:parseType=\"Resource\">\n" + 
    "              <vCard:Family>Le Novere</vCard:Family>\n" + 
    "              <vCard:Given>Nicolas</vCard:Given>\n" + 
    "            </vCard:N>\n" + 
    "            <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n" + 
    "            <vCard:ORG rdf:parseType=\"Resource\">\n" + 
    "              <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n" + 
    "            </vCard:ORG>\n" + 
    "          </rdf:li>\n" + 
    "        </rdf:Bag>\n" + 
    "      </dc:creator>\n" + 
    "      <dcterms:created rdf:parseType=\"Resource\">\n" + 
    "        <dcterms:W3CDTF>2005-02-02T14:56:11Z</dcterms:W3CDTF>\n" + 
    "      </dcterms:created>\n" + 
    "      <dcterms:modified rdf:parseType=\"Resource\">\n" + 
    "        <dcterms:W3CDTF>2006-05-30T10:46:02Z</dcterms:W3CDTF>\n" + 
    "      </dcterms:modified>\n" + 
    "      <bqbiol:is>\n" + 
    "        <rdf:Bag>\n" + 
    "          <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n" + 
    "        </rdf:Bag>\n" + 
    "      </bqbiol:is>\n" + 
    "    </rdf:Description>\n" + 
    "  </rdf:RDF>\n" + 
    "</annotation>"
    c.setAnnotation(addedAnn)
    expected = "<compartment metaid=\"_000003\" id=\"A\">\n" + 
    "  <annotation>\n" + 
    "    <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n" + 
    "      <rdf:Description rdf:about=\"#_000003\">\n" + 
    "        <bqbiol:is>\n" + 
    "          <rdf:Bag>\n" + 
    "            <rdf:li rdf:resource=\"http://www.geneontology.org/#GO:0007274\"/>\n" + 
    "          </rdf:Bag>\n" + 
    "        </bqbiol:is>\n" + 
    "      </rdf:Description>\n" + 
    "      <rdf:Description rdf:about=\"#_000005\">\n" + 
    "        <dc:creator>\n" + 
    "          <rdf:Bag>\n" + 
    "            <rdf:li rdf:parseType=\"Resource\">\n" + 
    "              <vCard:N rdf:parseType=\"Resource\">\n" + 
    "                <vCard:Family>Le Novere</vCard:Family>\n" + 
    "                <vCard:Given>Nicolas</vCard:Given>\n" + 
    "              </vCard:N>\n" + 
    "              <vCard:EMAIL>lenov@ebi.ac.uk</vCard:EMAIL>\n" + 
    "              <vCard:ORG rdf:parseType=\"Resource\">\n" + 
    "                <vCard:Orgname>EMBL-EBI</vCard:Orgname>\n" + 
    "              </vCard:ORG>\n" + 
    "            </rdf:li>\n" + 
    "          </rdf:Bag>\n" + 
    "        </dc:creator>\n" + 
    "        <dcterms:created rdf:parseType=\"Resource\">\n" + 
    "          <dcterms:W3CDTF>2005-02-02T14:56:11Z</dcterms:W3CDTF>\n" + 
    "        </dcterms:created>\n" + 
    "        <dcterms:modified rdf:parseType=\"Resource\">\n" + 
    "          <dcterms:W3CDTF>2006-05-30T10:46:02Z</dcterms:W3CDTF>\n" + 
    "        </dcterms:modified>\n" + 
    "      </rdf:Description>\n" + 
    "    </rdf:RDF>\n" + 
    "  </annotation>\n" + 
    "</compartment>"
    assert_equal true, equals(expected,c.toSBML())
  end

end
