/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 */
 
package org.apache.jdo.tck.pc.fieldtypes;

import java.io.Serializable;

public class FieldsOfPrimitivelong { 
  public int identifier;
  private long long0;
  private long long1;
  private long long2;
  private long long3;
  private long long4;
  private long long5;
  private long long6;
  private long long7;
  private static long long8;
  private transient long long9;
  private transient long long10;
  private transient long long11;
  private transient long long12;
  private transient long long13;
  private transient long long14;
  private final long long15 = 5;
  private volatile long long16;
  private volatile long long17;
  private volatile long long18;
  private volatile long long19;
  private volatile long long20;
  private volatile long long21;
  private volatile long long22;
  private volatile long long23;
  private static transient long long24;
  private static final long long25 = 5;
  private static volatile long long26;
  private transient final long long27 = 5;
  private transient volatile long long28;
  private transient volatile long long29;
  private transient volatile long long30;
  private transient volatile long long31;
  private transient volatile long long32;
  private transient volatile long long33;
  private static transient final long long34 = 5;
  private static transient volatile long long35;
  public long long36;
  public long long37;
  public long long38;
  public long long39;
  public long long40;
  public long long41;
  public long long42;
  public long long43;
  public static long long44;
  public transient long long45;
  public transient long long46;
  public transient long long47;
  public transient long long48;
  public transient long long49;
  public transient long long50;
  public final long long51 = 5;
  public volatile long long52;
  public volatile long long53;
  public volatile long long54;
  public volatile long long55;
  public volatile long long56;
  public volatile long long57;
  public volatile long long58;
  public volatile long long59;
  public static transient long long60;
  public static final long long61 = 5;
  public static volatile long long62;
  public transient final long long63 = 5;
  public transient volatile long long64;
  public transient volatile long long65;
  public transient volatile long long66;
  public transient volatile long long67;
  public transient volatile long long68;
  public transient volatile long long69;
  public static transient final long long70 = 5;
  public static transient volatile long long71;
  protected long long72;
  protected long long73;
  protected long long74;
  protected long long75;
  protected long long76;
  protected long long77;
  protected long long78;
  protected long long79;
  protected static long long80;
  protected transient long long81;
  protected transient long long82;
  protected transient long long83;
  protected transient long long84;
  protected transient long long85;
  protected transient long long86;
  protected final long long87 = 5;
  protected volatile long long88;
  protected volatile long long89;
  protected volatile long long90;
  protected volatile long long91;
  protected volatile long long92;
  protected volatile long long93;
  protected volatile long long94;
  protected volatile long long95;
  protected static transient long long96;
  protected static final long long97 = 5;
  protected static volatile long long98;
  protected transient final long long99 = 5;
  protected transient volatile long long100;
  protected transient volatile long long101;
  protected transient volatile long long102;
  protected transient volatile long long103;
  protected transient volatile long long104;
  protected transient volatile long long105;
  protected static transient final long long106 = 5;
  protected static transient volatile long long107;
  long long108;
  long long109;
  long long110;
  long long111;
  long long112;
  long long113;
  long long114;
  long long115;
  static long long116;
  transient long long117;
  transient long long118;
  transient long long119;
  transient long long120;
  transient long long121;
  transient long long122;
  final long long123 = 5;
  volatile long long124;
  volatile long long125;
  volatile long long126;
  volatile long long127;
  volatile long long128;
  volatile long long129;
  volatile long long130;
  volatile long long131;
  static transient long long132;
  static final long long133 = 5;
  static volatile long long134;
  transient final long long135 = 5;
  transient volatile long long136;
  transient volatile long long137;
  transient volatile long long138;
  transient volatile long long139;
  transient volatile long long140;
  transient volatile long long141;
  static transient final long long142 = 5;
  static transient volatile long long143;

public static final boolean [] isPersistent = { 
true,true,true,false,true,true,true,false,false,false,
false,true,true,true,false,false,true,true,true,false,
true,true,true,false,false,false,false,false,false,false,
true,true,true,false,false,false,true,true,true,false,
true,true,true,false,false,false,false,true,true,true,
false,false,true,true,true,false,true,true,true,false,
false,false,false,false,false,false,true,true,true,false,
false,false,true,true,true,false,true,true,true,false,
false,false,false,true,true,true,false,false,true,true,
true,false,true,true,true,false,false,false,false,false,
false,false,true,true,true,false,false,false,true,true,
true,false,true,true,true,false,false,false,false,true,
true,true,false,false,true,true,true,false,true,true,
true,false,false,false,false,false,false,false,true,true,
true,false,false,false
 };

public static final boolean [] isStatic = { 
false,false,false,false,false,false,false,false,true,false,
false,false,false,false,false,false,false,false,false,false,
false,false,false,false,true,true,true,false,false,false,
false,false,false,false,true,true,false,false,false,false,
false,false,false,false,true,false,false,false,false,false,
false,false,false,false,false,false,false,false,false,false,
true,true,true,false,false,false,false,false,false,false,
true,true,false,false,false,false,false,false,false,false,
true,false,false,false,false,false,false,false,false,false,
false,false,false,false,false,false,true,true,true,false,
false,false,false,false,false,false,true,true,false,false,
false,false,false,false,false,false,true,false,false,false,
false,false,false,false,false,false,false,false,false,false,
false,false,true,true,true,false,false,false,false,false,
false,false,true,true
 };

public static final boolean [] isFinal = { 
false,false,false,false,false,false,false,false,false,false,
false,false,false,false,false,true,false,false,false,false,
false,false,false,false,false,true,false,true,false,false,
false,false,false,false,true,false,false,false,false,false,
false,false,false,false,false,false,false,false,false,false,
false,true,false,false,false,false,false,false,false,false,
false,true,false,true,false,false,false,false,false,false,
true,false,false,false,false,false,false,false,false,false,
false,false,false,false,false,false,false,true,false,false,
false,false,false,false,false,false,false,true,false,true,
false,false,false,false,false,false,true,false,false,false,
false,false,false,false,false,false,false,false,false,false,
false,false,false,true,false,false,false,false,false,false,
false,false,false,true,false,true,false,false,false,false,
false,false,true,false
 };

  public static final String [] fieldSpecs = { 
  "private long long0",
  "embedded= true   private long long1",
  "embedded= false   private long long2",
  "persistence-modifier= none    private long long3",
  "persistence-modifier= persistent    private long long4",
  "persistence-modifier= persistent  embedded= true   private long long5",
  "persistence-modifier= persistent  embedded= false   private long long6",
  "persistence-modifier= transactional    private long long7",
  "private static long long8",
  "private transient long long9",
  "persistence-modifier= none    private transient long long10",
  "persistence-modifier= persistent    private transient long long11",
  "persistence-modifier= persistent  embedded= true   private transient long long12",
  "persistence-modifier= persistent  embedded= false   private transient long long13",
  "persistence-modifier= transactional    private transient long long14",
  "private final long long15",
  "private volatile long long16",
  "embedded= true   private volatile long long17",
  "embedded= false   private volatile long long18",
  "persistence-modifier= none    private volatile long long19",
  "persistence-modifier= persistent    private volatile long long20",
  "persistence-modifier= persistent  embedded= true   private volatile long long21",
  "persistence-modifier= persistent  embedded= false   private volatile long long22",
  "persistence-modifier= transactional    private volatile long long23",
  "private static transient long long24",
  "private static final long long25",
  "private static volatile long long26",
  "private transient final long long27",
  "private transient volatile long long28",
  "persistence-modifier= none    private transient volatile long long29",
  "persistence-modifier= persistent    private transient volatile long long30",
  "persistence-modifier= persistent  embedded= true   private transient volatile long long31",
  "persistence-modifier= persistent  embedded= false   private transient volatile long long32",
  "persistence-modifier= transactional    private transient volatile long long33",
  "private static transient final long long34",
  "private static transient volatile long long35",
  "public long long36",
  "embedded= true   public long long37",
  "embedded= false   public long long38",
  "persistence-modifier= none    public long long39",
  "persistence-modifier= persistent    public long long40",
  "persistence-modifier= persistent  embedded= true   public long long41",
  "persistence-modifier= persistent  embedded= false   public long long42",
  "persistence-modifier= transactional    public long long43",
  "public static long long44",
  "public transient long long45",
  "persistence-modifier= none    public transient long long46",
  "persistence-modifier= persistent    public transient long long47",
  "persistence-modifier= persistent  embedded= true   public transient long long48",
  "persistence-modifier= persistent  embedded= false   public transient long long49",
  "persistence-modifier= transactional    public transient long long50",
  "public final long long51",
  "public volatile long long52",
  "embedded= true   public volatile long long53",
  "embedded= false   public volatile long long54",
  "persistence-modifier= none    public volatile long long55",
  "persistence-modifier= persistent    public volatile long long56",
  "persistence-modifier= persistent  embedded= true   public volatile long long57",
  "persistence-modifier= persistent  embedded= false   public volatile long long58",
  "persistence-modifier= transactional    public volatile long long59",
  "public static transient long long60",
  "public static final long long61",
  "public static volatile long long62",
  "public transient final long long63",
  "public transient volatile long long64",
  "persistence-modifier= none    public transient volatile long long65",
  "persistence-modifier= persistent    public transient volatile long long66",
  "persistence-modifier= persistent  embedded= true   public transient volatile long long67",
  "persistence-modifier= persistent  embedded= false   public transient volatile long long68",
  "persistence-modifier= transactional    public transient volatile long long69",
  "public static transient final long long70",
  "public static transient volatile long long71",
  "protected long long72",
  "embedded= true   protected long long73",
  "embedded= false   protected long long74",
  "persistence-modifier= none    protected long long75",
  "persistence-modifier= persistent    protected long long76",
  "persistence-modifier= persistent  embedded= true   protected long long77",
  "persistence-modifier= persistent  embedded= false   protected long long78",
  "persistence-modifier= transactional    protected long long79",
  "protected static long long80",
  "protected transient long long81",
  "persistence-modifier= none    protected transient long long82",
  "persistence-modifier= persistent    protected transient long long83",
  "persistence-modifier= persistent  embedded= true   protected transient long long84",
  "persistence-modifier= persistent  embedded= false   protected transient long long85",
  "persistence-modifier= transactional    protected transient long long86",
  "protected final long long87",
  "protected volatile long long88",
  "embedded= true   protected volatile long long89",
  "embedded= false   protected volatile long long90",
  "persistence-modifier= none    protected volatile long long91",
  "persistence-modifier= persistent    protected volatile long long92",
  "persistence-modifier= persistent  embedded= true   protected volatile long long93",
  "persistence-modifier= persistent  embedded= false   protected volatile long long94",
  "persistence-modifier= transactional    protected volatile long long95",
  "protected static transient long long96",
  "protected static final long long97",
  "protected static volatile long long98",
  "protected transient final long long99",
  "protected transient volatile long long100",
  "persistence-modifier= none    protected transient volatile long long101",
  "persistence-modifier= persistent    protected transient volatile long long102",
  "persistence-modifier= persistent  embedded= true   protected transient volatile long long103",
  "persistence-modifier= persistent  embedded= false   protected transient volatile long long104",
  "persistence-modifier= transactional    protected transient volatile long long105",
  "protected static transient final long long106",
  "protected static transient volatile long long107",
  "long long108",
  "embedded= true   long long109",
  "embedded= false   long long110",
  "persistence-modifier= none    long long111",
  "persistence-modifier= persistent    long long112",
  "persistence-modifier= persistent  embedded= true   long long113",
  "persistence-modifier= persistent  embedded= false   long long114",
  "persistence-modifier= transactional    long long115",
  "static long long116",
  "transient long long117",
  "persistence-modifier= none    transient long long118",
  "persistence-modifier= persistent    transient long long119",
  "persistence-modifier= persistent  embedded= true   transient long long120",
  "persistence-modifier= persistent  embedded= false   transient long long121",
  "persistence-modifier= transactional    transient long long122",
  "final long long123",
  "volatile long long124",
  "embedded= true   volatile long long125",
  "embedded= false   volatile long long126",
  "persistence-modifier= none    volatile long long127",
  "persistence-modifier= persistent    volatile long long128",
  "persistence-modifier= persistent  embedded= true   volatile long long129",
  "persistence-modifier= persistent  embedded= false   volatile long long130",
  "persistence-modifier= transactional    volatile long long131",
  "static transient long long132",
  "static final long long133",
  "static volatile long long134",
  "transient final long long135",
  "transient volatile long long136",
  "persistence-modifier= none    transient volatile long long137",
  "persistence-modifier= persistent    transient volatile long long138",
  "persistence-modifier= persistent  embedded= true   transient volatile long long139",
  "persistence-modifier= persistent  embedded= false   transient volatile long long140",
  "persistence-modifier= transactional    transient volatile long long141",
  "static transient final long long142",
  "static transient volatile long long143"
  };
  public int getLength()
  {
    return fieldSpecs.length;
  }
  public long get(int index)
  {
    switch (index)
    {
      case(0):
        return long0;
      case(1):
        return long1;
      case(2):
        return long2;
      case(3):
        return long3;
      case(4):
        return long4;
      case(5):
        return long5;
      case(6):
        return long6;
      case(7):
        return long7;
      case(8):
        return long8;
      case(9):
        return long9;
      case(10):
        return long10;
      case(11):
        return long11;
      case(12):
        return long12;
      case(13):
        return long13;
      case(14):
        return long14;
      case(15):
        return long15;
      case(16):
        return long16;
      case(17):
        return long17;
      case(18):
        return long18;
      case(19):
        return long19;
      case(20):
        return long20;
      case(21):
        return long21;
      case(22):
        return long22;
      case(23):
        return long23;
      case(24):
        return long24;
      case(25):
        return long25;
      case(26):
        return long26;
      case(27):
        return long27;
      case(28):
        return long28;
      case(29):
        return long29;
      case(30):
        return long30;
      case(31):
        return long31;
      case(32):
        return long32;
      case(33):
        return long33;
      case(34):
        return long34;
      case(35):
        return long35;
      case(36):
        return long36;
      case(37):
        return long37;
      case(38):
        return long38;
      case(39):
        return long39;
      case(40):
        return long40;
      case(41):
        return long41;
      case(42):
        return long42;
      case(43):
        return long43;
      case(44):
        return long44;
      case(45):
        return long45;
      case(46):
        return long46;
      case(47):
        return long47;
      case(48):
        return long48;
      case(49):
        return long49;
      case(50):
        return long50;
      case(51):
        return long51;
      case(52):
        return long52;
      case(53):
        return long53;
      case(54):
        return long54;
      case(55):
        return long55;
      case(56):
        return long56;
      case(57):
        return long57;
      case(58):
        return long58;
      case(59):
        return long59;
      case(60):
        return long60;
      case(61):
        return long61;
      case(62):
        return long62;
      case(63):
        return long63;
      case(64):
        return long64;
      case(65):
        return long65;
      case(66):
        return long66;
      case(67):
        return long67;
      case(68):
        return long68;
      case(69):
        return long69;
      case(70):
        return long70;
      case(71):
        return long71;
      case(72):
        return long72;
      case(73):
        return long73;
      case(74):
        return long74;
      case(75):
        return long75;
      case(76):
        return long76;
      case(77):
        return long77;
      case(78):
        return long78;
      case(79):
        return long79;
      case(80):
        return long80;
      case(81):
        return long81;
      case(82):
        return long82;
      case(83):
        return long83;
      case(84):
        return long84;
      case(85):
        return long85;
      case(86):
        return long86;
      case(87):
        return long87;
      case(88):
        return long88;
      case(89):
        return long89;
      case(90):
        return long90;
      case(91):
        return long91;
      case(92):
        return long92;
      case(93):
        return long93;
      case(94):
        return long94;
      case(95):
        return long95;
      case(96):
        return long96;
      case(97):
        return long97;
      case(98):
        return long98;
      case(99):
        return long99;
      case(100):
        return long100;
      case(101):
        return long101;
      case(102):
        return long102;
      case(103):
        return long103;
      case(104):
        return long104;
      case(105):
        return long105;
      case(106):
        return long106;
      case(107):
        return long107;
      case(108):
        return long108;
      case(109):
        return long109;
      case(110):
        return long110;
      case(111):
        return long111;
      case(112):
        return long112;
      case(113):
        return long113;
      case(114):
        return long114;
      case(115):
        return long115;
      case(116):
        return long116;
      case(117):
        return long117;
      case(118):
        return long118;
      case(119):
        return long119;
      case(120):
        return long120;
      case(121):
        return long121;
      case(122):
        return long122;
      case(123):
        return long123;
      case(124):
        return long124;
      case(125):
        return long125;
      case(126):
        return long126;
      case(127):
        return long127;
      case(128):
        return long128;
      case(129):
        return long129;
      case(130):
        return long130;
      case(131):
        return long131;
      case(132):
        return long132;
      case(133):
        return long133;
      case(134):
        return long134;
      case(135):
        return long135;
      case(136):
        return long136;
      case(137):
        return long137;
      case(138):
        return long138;
      case(139):
        return long139;
      case(140):
        return long140;
      case(141):
        return long141;
      case(142):
        return long142;
      case(143):
        return long143;
      default:
        throw new IndexOutOfBoundsException();
    }
  }
  public boolean set(int index,long value)
  {
    if(fieldSpecs[index].indexOf("final") != -1)
      return false;
    switch (index)
    {
      case(0):
        long0= value;
         break;
      case(1):
        long1= value;
         break;
      case(2):
        long2= value;
         break;
      case(3):
        long3= value;
         break;
      case(4):
        long4= value;
         break;
      case(5):
        long5= value;
         break;
      case(6):
        long6= value;
         break;
      case(7):
        long7= value;
         break;
      case(8):
        long8= value;
         break;
      case(9):
        long9= value;
         break;
      case(10):
        long10= value;
         break;
      case(11):
        long11= value;
         break;
      case(12):
        long12= value;
         break;
      case(13):
        long13= value;
         break;
      case(14):
        long14= value;
         break;
      case(16):
        long16= value;
         break;
      case(17):
        long17= value;
         break;
      case(18):
        long18= value;
         break;
      case(19):
        long19= value;
         break;
      case(20):
        long20= value;
         break;
      case(21):
        long21= value;
         break;
      case(22):
        long22= value;
         break;
      case(23):
        long23= value;
         break;
      case(24):
        long24= value;
         break;
      case(26):
        long26= value;
         break;
      case(28):
        long28= value;
         break;
      case(29):
        long29= value;
         break;
      case(30):
        long30= value;
         break;
      case(31):
        long31= value;
         break;
      case(32):
        long32= value;
         break;
      case(33):
        long33= value;
         break;
      case(35):
        long35= value;
         break;
      case(36):
        long36= value;
         break;
      case(37):
        long37= value;
         break;
      case(38):
        long38= value;
         break;
      case(39):
        long39= value;
         break;
      case(40):
        long40= value;
         break;
      case(41):
        long41= value;
         break;
      case(42):
        long42= value;
         break;
      case(43):
        long43= value;
         break;
      case(44):
        long44= value;
         break;
      case(45):
        long45= value;
         break;
      case(46):
        long46= value;
         break;
      case(47):
        long47= value;
         break;
      case(48):
        long48= value;
         break;
      case(49):
        long49= value;
         break;
      case(50):
        long50= value;
         break;
      case(52):
        long52= value;
         break;
      case(53):
        long53= value;
         break;
      case(54):
        long54= value;
         break;
      case(55):
        long55= value;
         break;
      case(56):
        long56= value;
         break;
      case(57):
        long57= value;
         break;
      case(58):
        long58= value;
         break;
      case(59):
        long59= value;
         break;
      case(60):
        long60= value;
         break;
      case(62):
        long62= value;
         break;
      case(64):
        long64= value;
         break;
      case(65):
        long65= value;
         break;
      case(66):
        long66= value;
         break;
      case(67):
        long67= value;
         break;
      case(68):
        long68= value;
         break;
      case(69):
        long69= value;
         break;
      case(71):
        long71= value;
         break;
      case(72):
        long72= value;
         break;
      case(73):
        long73= value;
         break;
      case(74):
        long74= value;
         break;
      case(75):
        long75= value;
         break;
      case(76):
        long76= value;
         break;
      case(77):
        long77= value;
         break;
      case(78):
        long78= value;
         break;
      case(79):
        long79= value;
         break;
      case(80):
        long80= value;
         break;
      case(81):
        long81= value;
         break;
      case(82):
        long82= value;
         break;
      case(83):
        long83= value;
         break;
      case(84):
        long84= value;
         break;
      case(85):
        long85= value;
         break;
      case(86):
        long86= value;
         break;
      case(88):
        long88= value;
         break;
      case(89):
        long89= value;
         break;
      case(90):
        long90= value;
         break;
      case(91):
        long91= value;
         break;
      case(92):
        long92= value;
         break;
      case(93):
        long93= value;
         break;
      case(94):
        long94= value;
         break;
      case(95):
        long95= value;
         break;
      case(96):
        long96= value;
         break;
      case(98):
        long98= value;
         break;
      case(100):
        long100= value;
         break;
      case(101):
        long101= value;
         break;
      case(102):
        long102= value;
         break;
      case(103):
        long103= value;
         break;
      case(104):
        long104= value;
         break;
      case(105):
        long105= value;
         break;
      case(107):
        long107= value;
         break;
      case(108):
        long108= value;
         break;
      case(109):
        long109= value;
         break;
      case(110):
        long110= value;
         break;
      case(111):
        long111= value;
         break;
      case(112):
        long112= value;
         break;
      case(113):
        long113= value;
         break;
      case(114):
        long114= value;
         break;
      case(115):
        long115= value;
         break;
      case(116):
        long116= value;
         break;
      case(117):
        long117= value;
         break;
      case(118):
        long118= value;
         break;
      case(119):
        long119= value;
         break;
      case(120):
        long120= value;
         break;
      case(121):
        long121= value;
         break;
      case(122):
        long122= value;
         break;
      case(124):
        long124= value;
         break;
      case(125):
        long125= value;
         break;
      case(126):
        long126= value;
         break;
      case(127):
        long127= value;
         break;
      case(128):
        long128= value;
         break;
      case(129):
        long129= value;
         break;
      case(130):
        long130= value;
         break;
      case(131):
        long131= value;
         break;
      case(132):
        long132= value;
         break;
      case(134):
        long134= value;
         break;
      case(136):
        long136= value;
         break;
      case(137):
        long137= value;
         break;
      case(138):
        long138= value;
         break;
      case(139):
        long139= value;
         break;
      case(140):
        long140= value;
         break;
      case(141):
        long141= value;
         break;
      case(143):
        long143= value;
         break;
      default:
        throw new IndexOutOfBoundsException();
    }
    return true;
  }

    public static class Oid implements Serializable {
        public int identifier;

        public Oid() {
        }

        public Oid(String s) { identifier = Integer.parseInt(justTheId(s)); }

        public String toString() { return this.getClass().getName() + ": "  + identifier;}

        public int hashCode() { return (int)identifier ; }

        public boolean equals(Object other) {
            if (other != null && (other instanceof Oid)) {
                Oid k = (Oid)other;
                return k.identifier == this.identifier;
            }
            return false;
        }
        
        protected static String justTheId(String str) {
            return str.substring(str.indexOf(':') + 1);
        }
    }   
}
