package org.jboss.cache.notifications.event;

import javax.transaction.Transaction;

/**
 * An event type that includes a transaction context - if one exists - as well as a boolean as to whether the call
 * originated locally or remotely.
 *
 * @author <a href="mailto:manik@jboss.org">Manik Surtani</a>
 * @since 2.0.0
 */
public interface TransactionalEvent extends Event
{
   /**
    * @return the Transaction associated with the current call.  May be null if the current call is outside the
    *         scope of a transaction.
    */
   Transaction getTransaction();

   /**
    * @return true if the call originated on the local cache instance; false if originated from a remote one.
    */
   boolean isOriginLocal();
}
