/*
 * @(#)ChainableExceptionHelperUTest.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.util.throwable.v1;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.ByteArrayOutputStream;
import org.easymock.EasyMock;
import org.easymock.MockControl;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;


/**
 * Tests the ChainableExceptionHelper class.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2003/02/10 22:52:42 $
 * @since     March 17, 2002
 */
public class ChainableExceptionHelperUTest extends TestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS =
        ChainableExceptionHelperUTest.class;
    
    public ChainableExceptionHelperUTest( String name )
    {
        super( name );
    }

    
    //-------------------------------------------------------------------------
    // setup
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
    }


    //-------------------------------------------------------------------------
    // Tests
    
    
    public void testConstructor1a()
    {
        Throwable source = new Throwable();
        new ChainableExceptionHelper( source );
    }
    
    
    public void testConstructor1b()
    {
        try
        {
            new ChainableExceptionHelper( null );
            fail("Did not throw IllegalArgumentException");
        }
        catch (IllegalArgumentException iae)
        {
            // test exception?
        }
    }
    
    
    public void testConstructor2a()
    {
        Throwable source = new Throwable();
        Throwable cause = new Throwable();
        new ChainableExceptionHelper( source, null );
    }
    
    
    public void testConstructor2b()
    {
        Throwable source = new Throwable();
        Throwable cause = new Throwable();
        new ChainableExceptionHelper( source, cause );
    }
    
    
    public void testConstructor2c()
    {
        Throwable source = new Throwable();
        Throwable cause = new Throwable();
        try
        {
            new ChainableExceptionHelper( null, null );
            fail("Did not throw IllegalArgumentException");
        }
        catch (IllegalArgumentException iae)
        {
            // test exception?
        }
    }
    
    
    public void testConstructor2d()
    {
        Throwable source = new Throwable();
        Throwable cause = new Throwable();
        try
        {
            new ChainableExceptionHelper( null, cause );
            fail("Did not throw IllegalArgumentException");
        }
        catch (IllegalArgumentException iae)
        {
            // test exception?
        }
    }
    
    
    public void testConstructor2e()
    {
        Throwable source = new Throwable();
        Throwable cause = new Throwable();
        try
        {
            new ChainableExceptionHelper( source, source );
            fail("Did not throw IllegalArgumentException");
        }
        catch (IllegalArgumentException iae)
        {
            // test exception?
        }
    }
    
    
    public void testGetCause1()
    {
        Throwable source = new Throwable();
        Throwable cause = new Throwable();
        ChainableExceptionHelper ceh = new ChainableExceptionHelper(
            source );
        
        assertNull(
            "Does not have a null cause.",
            ceh.getCause() );
    }
    
    
    public void testGetCause2()
    {
        Throwable source = new Throwable();
        Throwable cause = new Throwable();
        ChainableExceptionHelper ceh = new ChainableExceptionHelper(
            source, null );
        
        assertNull(
            "Does not have a null cause.",
            ceh.getCause() );
    }
    
    
    public void testGetCause3()
    {
        Throwable source = new Throwable();
        Throwable cause = new Throwable();
        ChainableExceptionHelper ceh = new ChainableExceptionHelper(
            source, cause );
        
        assertEquals(
            "Does not have right cause.",
            ceh.getCause(),
            cause );
    }
    
    
    public void testInitCause1()
    {
        Throwable source = new Throwable();
        Throwable cause = new Throwable();
        ChainableExceptionHelper ceh = new ChainableExceptionHelper(
            source );
        
        assertEquals(
            "Did not return right exception.",
            ceh.initCause( cause ),
            source );
    }
    
    
    public void testInitCause2()
    {
        Throwable source = new Throwable();
        Throwable cause = new Throwable();
        ChainableExceptionHelper ceh = new ChainableExceptionHelper(
            source );
        
        assertEquals(
            "Did not return right exception.",
            ceh.initCause( null ),
            source );
    }
    
    
    public void testInitCause3()
    {
        Throwable source = new Throwable();
        Throwable cause = new Throwable();
        ChainableExceptionHelper ceh = new ChainableExceptionHelper(
            source, cause );
        
        try
        {
            ceh.initCause( cause );
            fail("Did not throw IllegalStateException");
        }
        catch (IllegalStateException ise)
        {
            // test exception?
        }
    }
    
    
    public void testInitGetCause1()
    {
        Throwable source = new Throwable();
        Throwable cause = new Throwable();
        ChainableExceptionHelper ceh = new ChainableExceptionHelper(
            source );
        
        ceh.initCause( cause );
        assertEquals(
            "Did not return right cause.",
            ceh.getCause(),
            cause );
    }
    
    
    public void testInitGetCause2()
    {
        Throwable source = new Throwable();
        Throwable cause = new Throwable();
        ChainableExceptionHelper ceh = new ChainableExceptionHelper(
            source );
        
        ceh.initCause( null );
        assertNull(
            "Did not return right cause.",
            ceh.getCause() );
    }
    
    
    public void testInitGetCause3()
    {
        Throwable source = new Throwable();
        Throwable cause = new Throwable();
        ChainableExceptionHelper ceh = new ChainableExceptionHelper(
            source, cause );
        
        assertEquals(
            "Did not return right cause.",
            ceh.getCause(),
            cause );
    }
    
    
    public void testInitGetCause4()
    {
        Throwable source = new Throwable();
        Throwable cause = new Throwable();
        ChainableExceptionHelper ceh = new ChainableExceptionHelper(
            source, null );
        
        assertNull(
            "Did not return right cause.",
            ceh.getCause() );
    }
    
    
    public void testPrintStackTrace1()
    {
        Throwable source = new Throwable();
        Throwable cause = new Throwable();
        ChainableExceptionHelper ceh = new ChainableExceptionHelper(
            source );
        
        StringWriter sw = new StringWriter();
        ceh.printStackTrace( new PrintWriter( sw, true ) );
        
        // check sw result.
        assertTrue(
            "Not a valid length",
            sw.toString().length() > 0 );
    }
    
    
    public void testPrintStackTrace2()
    {
        Throwable source = new Throwable();
        Throwable cause = new Throwable();
        ChainableExceptionHelper ceh = new ChainableExceptionHelper(
            source );
        
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ceh.printStackTrace( new PrintStream( baos, true ) );
        
        // check sw result.
        assertTrue(
            "Not a valid length",
            baos.toString().length() > 0 );
    }
    
    
    public void testPrintStackTrace3()
    {
        Throwable source = new Throwable();
        Throwable cause = new Throwable();
        ChainableExceptionHelper ceh = new ChainableExceptionHelper(
            source );
        
        ceh.initCause( cause );
        StringWriter sw = new StringWriter();
        ceh.printStackTrace( new PrintWriter( sw, true ) );
        
        // check sw result.
        assertTrue(
            "Not a valid length",
            sw.toString().length() > 0 );
    }
    
    
    public void testPrintStackTrace4()
    {
        Throwable source = new Throwable();
        Throwable cause = new Throwable();
        ChainableExceptionHelper ceh = new ChainableExceptionHelper(
            source );
        
        ceh.initCause( cause );
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ceh.printStackTrace( new PrintStream( baos, true ) );
        
        // check sw result.
        assertTrue(
            "Not a valid length",
            baos.toString().length() > 0 );
    }
    
    
    public void testInitGetCause5()
    {
        Throwable source = new Throwable();
        Throwable cause = new Throwable();
        ChainableExceptionHelper ceh = new ChainableExceptionHelper(
            source );
        
        ceh.initCause( null );
        StringWriter sw = new StringWriter();
        ceh.printStackTrace( new PrintWriter( sw, true ) );
        
        // check sw result.
        assertTrue(
            "Not a valid length",
            sw.toString().length() > 0 );
    }
    
    
    public void testInitGetCause6()
    {
        Throwable source = new Throwable();
        Throwable cause = new Throwable();
        ChainableExceptionHelper ceh = new ChainableExceptionHelper(
            source );
        
        ceh.initCause( null );
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ceh.printStackTrace( new PrintStream( baos, true ) );
        
        // check sw result.
        assertTrue(
            "Not a valid length",
            baos.toString().length() > 0 );
    }
    
    
    public void testInitGetCause7()
    {
        Throwable source = new Throwable();
        Throwable cause = new Throwable();
        ChainableExceptionHelper ceh = new ChainableExceptionHelper(
            source, cause );
        
        StringWriter sw = new StringWriter();
        ceh.printStackTrace( new PrintWriter( sw, true ) );
        
        // check sw result.
        assertTrue(
            "Not a valid length",
            sw.toString().length() > 0 );
    }
    
    
    public void testInitGetCause8()
    {
        Throwable source = new Throwable();
        Throwable cause = new Throwable();
        ChainableExceptionHelper ceh = new ChainableExceptionHelper(
            source, cause );
        
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ceh.printStackTrace( new PrintStream( baos, true ) );
        
        // check sw result.
        assertTrue(
            "Not a valid length",
            baos.toString().length() > 0 );
    }
    
    
    public void testInitGetCause9()
    {
        Throwable source = new Throwable();
        Throwable cause = new Throwable();
        ChainableExceptionHelper ceh = new ChainableExceptionHelper(
            source, null );
        
        StringWriter sw = new StringWriter();
        ceh.printStackTrace( new PrintWriter( sw, true ) );
        
        // check sw result.
        assertTrue(
            "Not a valid length",
            sw.toString().length() > 0 );
    }
    
    
    public void testInitGetCause10()
    {
        Throwable source = new Throwable();
        Throwable cause = new Throwable();
        ChainableExceptionHelper ceh = new ChainableExceptionHelper(
            source, null );
        
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ceh.printStackTrace( new PrintStream( baos, true ) );
        
        // check sw result.
        assertTrue(
            "Not a valid length",
            baos.toString().length() > 0 );
    }
    
    
    //-------------------------------------------------------------------------
    // Helpers
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static Test suite()
    {
        TestSuite suite = new TestSuite( THIS_CLASS );
        
        // Test the implementation's interface conformity.
        /*
        suite.addTest( IxUTestI.suite(
            new ImplementationCreator[] {
                new ImplementationCreator() {
                    public Object createImplementedObject() {
                        // XXXXXXXXXXXXXXXXXXXXXXXX
                    }
                },
            } ) );
        */
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        
        super.tearDown();
    }
}

